# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'FileShareConfigResponse',
    'NetworkConfigResponse',
    'NfsExportOptionsResponse',
]

@pulumi.output_type
class FileShareConfigResponse(dict):
    """
    File share configuration for the instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "capacityGb":
            suggest = "capacity_gb"
        elif key == "nfsExportOptions":
            suggest = "nfs_export_options"
        elif key == "sourceBackup":
            suggest = "source_backup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileShareConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileShareConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileShareConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity_gb: str,
                 name: str,
                 nfs_export_options: Sequence['outputs.NfsExportOptionsResponse'],
                 source_backup: str):
        """
        File share configuration for the instance.
        :param str capacity_gb: File share capacity in gigabytes (GB). Cloud Filestore defines 1 GB as 1024^3 bytes.
        :param str name: The name of the file share (must be 16 characters or less).
        :param Sequence['NfsExportOptionsResponse'] nfs_export_options: Nfs Export Options. There is a limit of 10 export options per file share.
        :param str source_backup: The resource name of the backup, in the format projects/{project_number}/locations/{location_id}/backups/{backup_id}, that this file share has been restored from.
        """
        pulumi.set(__self__, "capacity_gb", capacity_gb)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "nfs_export_options", nfs_export_options)
        pulumi.set(__self__, "source_backup", source_backup)

    @property
    @pulumi.getter(name="capacityGb")
    def capacity_gb(self) -> str:
        """
        File share capacity in gigabytes (GB). Cloud Filestore defines 1 GB as 1024^3 bytes.
        """
        return pulumi.get(self, "capacity_gb")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the file share (must be 16 characters or less).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nfsExportOptions")
    def nfs_export_options(self) -> Sequence['outputs.NfsExportOptionsResponse']:
        """
        Nfs Export Options. There is a limit of 10 export options per file share.
        """
        return pulumi.get(self, "nfs_export_options")

    @property
    @pulumi.getter(name="sourceBackup")
    def source_backup(self) -> str:
        """
        The resource name of the backup, in the format projects/{project_number}/locations/{location_id}/backups/{backup_id}, that this file share has been restored from.
        """
        return pulumi.get(self, "source_backup")


@pulumi.output_type
class NetworkConfigResponse(dict):
    """
    Network configuration for the instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddresses":
            suggest = "ip_addresses"
        elif key == "reservedIpRange":
            suggest = "reserved_ip_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NetworkConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NetworkConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NetworkConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_addresses: Sequence[str],
                 modes: Sequence[str],
                 network: str,
                 reserved_ip_range: str):
        """
        Network configuration for the instance.
        :param Sequence[str] ip_addresses: IPv4 addresses in the format {octet 1}.{octet 2}.{octet 3}.{octet 4} or IPv6 addresses in the format {block 1}:{block 2}:{block 3}:{block 4}:{block 5}:{block 6}:{block 7}:{block 8}.
        :param Sequence[str] modes: Internet protocol versions for which the instance has IP addresses assigned. For this version, only MODE_IPV4 is supported.
        :param str network: The name of the Google Compute Engine [VPC network](/compute/docs/networks-and-firewalls#networks) to which the instance is connected.
        :param str reserved_ip_range: A /29 CIDR block in one of the [internal IP address ranges](https://www.arin.net/knowledge/address_filters.html) that identifies the range of IP addresses reserved for this instance. For example, 10.0.0.0/29 or 192.168.0.0/29. The range you specify can't overlap with either existing subnets or assigned IP address ranges for other Cloud Filestore instances in the selected VPC network.
        """
        pulumi.set(__self__, "ip_addresses", ip_addresses)
        pulumi.set(__self__, "modes", modes)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "reserved_ip_range", reserved_ip_range)

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        IPv4 addresses in the format {octet 1}.{octet 2}.{octet 3}.{octet 4} or IPv6 addresses in the format {block 1}:{block 2}:{block 3}:{block 4}:{block 5}:{block 6}:{block 7}:{block 8}.
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter
    def modes(self) -> Sequence[str]:
        """
        Internet protocol versions for which the instance has IP addresses assigned. For this version, only MODE_IPV4 is supported.
        """
        return pulumi.get(self, "modes")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        The name of the Google Compute Engine [VPC network](/compute/docs/networks-and-firewalls#networks) to which the instance is connected.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="reservedIpRange")
    def reserved_ip_range(self) -> str:
        """
        A /29 CIDR block in one of the [internal IP address ranges](https://www.arin.net/knowledge/address_filters.html) that identifies the range of IP addresses reserved for this instance. For example, 10.0.0.0/29 or 192.168.0.0/29. The range you specify can't overlap with either existing subnets or assigned IP address ranges for other Cloud Filestore instances in the selected VPC network.
        """
        return pulumi.get(self, "reserved_ip_range")


@pulumi.output_type
class NfsExportOptionsResponse(dict):
    """
    NFS export options specifications.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessMode":
            suggest = "access_mode"
        elif key == "anonGid":
            suggest = "anon_gid"
        elif key == "anonUid":
            suggest = "anon_uid"
        elif key == "ipRanges":
            suggest = "ip_ranges"
        elif key == "squashMode":
            suggest = "squash_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NfsExportOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NfsExportOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NfsExportOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_mode: str,
                 anon_gid: str,
                 anon_uid: str,
                 ip_ranges: Sequence[str],
                 squash_mode: str):
        """
        NFS export options specifications.
        :param str access_mode: Either READ_ONLY, for allowing only read requests on the exported directory, or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE.
        :param str anon_gid: An integer representing the anonymous group id with a default value of 65534. Anon_gid may only be set with squash_mode of ROOT_SQUASH. An error will be returned if this field is specified for other squash_mode settings.
        :param str anon_uid: An integer representing the anonymous user id with a default value of 65534. Anon_uid may only be set with squash_mode of ROOT_SQUASH. An error will be returned if this field is specified for other squash_mode settings.
        :param Sequence[str] ip_ranges: List of either an IPv4 addresses in the format {octet 1}.{octet 2}.{octet 3}.{octet 4} or CIDR ranges in the format {octet 1}.{octet 2}.{octet 3}.{octet 4}/{mask size} which may mount the file share. Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned. The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
        :param str squash_mode: Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH, for not allowing root access. The default is NO_ROOT_SQUASH.
        """
        pulumi.set(__self__, "access_mode", access_mode)
        pulumi.set(__self__, "anon_gid", anon_gid)
        pulumi.set(__self__, "anon_uid", anon_uid)
        pulumi.set(__self__, "ip_ranges", ip_ranges)
        pulumi.set(__self__, "squash_mode", squash_mode)

    @property
    @pulumi.getter(name="accessMode")
    def access_mode(self) -> str:
        """
        Either READ_ONLY, for allowing only read requests on the exported directory, or READ_WRITE, for allowing both read and write requests. The default is READ_WRITE.
        """
        return pulumi.get(self, "access_mode")

    @property
    @pulumi.getter(name="anonGid")
    def anon_gid(self) -> str:
        """
        An integer representing the anonymous group id with a default value of 65534. Anon_gid may only be set with squash_mode of ROOT_SQUASH. An error will be returned if this field is specified for other squash_mode settings.
        """
        return pulumi.get(self, "anon_gid")

    @property
    @pulumi.getter(name="anonUid")
    def anon_uid(self) -> str:
        """
        An integer representing the anonymous user id with a default value of 65534. Anon_uid may only be set with squash_mode of ROOT_SQUASH. An error will be returned if this field is specified for other squash_mode settings.
        """
        return pulumi.get(self, "anon_uid")

    @property
    @pulumi.getter(name="ipRanges")
    def ip_ranges(self) -> Sequence[str]:
        """
        List of either an IPv4 addresses in the format {octet 1}.{octet 2}.{octet 3}.{octet 4} or CIDR ranges in the format {octet 1}.{octet 2}.{octet 3}.{octet 4}/{mask size} which may mount the file share. Overlapping IP ranges are not allowed, both within and across NfsExportOptions. An error will be returned. The limit is 64 IP ranges/addresses for each FileShareConfig among all NfsExportOptions.
        """
        return pulumi.get(self, "ip_ranges")

    @property
    @pulumi.getter(name="squashMode")
    def squash_mode(self) -> str:
        """
        Either NO_ROOT_SQUASH, for allowing root access on the exported directory, or ROOT_SQUASH, for not allowing root access. The default is NO_ROOT_SQUASH.
        """
        return pulumi.get(self, "squash_mode")


