# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GoogleCloudDatalabelingV1beta1AnnotationSpecResponse',
    'GoogleCloudDatalabelingV1beta1AttemptResponse',
    'GoogleCloudDatalabelingV1beta1BigQuerySourceResponse',
    'GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsResponse',
    'GoogleCloudDatalabelingV1beta1BoundingPolyConfigResponse',
    'GoogleCloudDatalabelingV1beta1ClassificationMetadataResponse',
    'GoogleCloudDatalabelingV1beta1CsvInstructionResponse',
    'GoogleCloudDatalabelingV1beta1EvaluationConfigResponse',
    'GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigResponse',
    'GoogleCloudDatalabelingV1beta1EvaluationJobConfigResponse',
    'GoogleCloudDatalabelingV1beta1GcsSourceResponse',
    'GoogleCloudDatalabelingV1beta1HumanAnnotationConfigResponse',
    'GoogleCloudDatalabelingV1beta1ImageClassificationConfigResponse',
    'GoogleCloudDatalabelingV1beta1InputConfigResponse',
    'GoogleCloudDatalabelingV1beta1OperatorFeedbackMetadataResponse',
    'GoogleCloudDatalabelingV1beta1PdfInstructionResponse',
    'GoogleCloudDatalabelingV1beta1RequesterFeedbackMetadataResponse',
    'GoogleCloudDatalabelingV1beta1SentimentConfigResponse',
    'GoogleCloudDatalabelingV1beta1TextClassificationConfigResponse',
    'GoogleCloudDatalabelingV1beta1TextMetadataResponse',
    'GoogleRpcStatusResponse',
]

@pulumi.output_type
class GoogleCloudDatalabelingV1beta1AnnotationSpecResponse(dict):
    """
    Container of information related to one possible annotation that can be used in a labeling task. For example, an image classification task where images are labeled as `dog` or `cat` must reference an AnnotationSpec for `dog` and an AnnotationSpec for `cat`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1AnnotationSpecResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1AnnotationSpecResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1AnnotationSpecResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 index: int):
        """
        Container of information related to one possible annotation that can be used in a labeling task. For example, an image classification task where images are labeled as `dog` or `cat` must reference an AnnotationSpec for `dog` and an AnnotationSpec for `cat`.
        :param str description: Optional. User-provided description of the annotation specification. The description can be up to 10,000 characters long.
        :param str display_name: Required. The display name of the AnnotationSpec. Maximum of 64 characters.
        :param int index: This is the integer index of the AnnotationSpec. The index for the whole AnnotationSpecSet is sequential starting from 0. For example, an AnnotationSpecSet with classes `dog` and `cat`, might contain one AnnotationSpec with `{ display_name: "dog", index: 0 }` and one AnnotationSpec with `{ display_name: "cat", index: 1 }`. This is especially useful for model training as it encodes the string labels into numeric values.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "index", index)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. User-provided description of the annotation specification. The description can be up to 10,000 characters long.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Required. The display name of the AnnotationSpec. Maximum of 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        This is the integer index of the AnnotationSpec. The index for the whole AnnotationSpecSet is sequential starting from 0. For example, an AnnotationSpecSet with classes `dog` and `cat`, might contain one AnnotationSpec with `{ display_name: "dog", index: 0 }` and one AnnotationSpec with `{ display_name: "cat", index: 1 }`. This is especially useful for model training as it encodes the string labels into numeric values.
        """
        return pulumi.get(self, "index")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1AttemptResponse(dict):
    """
    Records a failed evaluation job run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attemptTime":
            suggest = "attempt_time"
        elif key == "partialFailures":
            suggest = "partial_failures"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1AttemptResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1AttemptResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1AttemptResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attempt_time: str,
                 partial_failures: Sequence['outputs.GoogleRpcStatusResponse']):
        """
        Records a failed evaluation job run.
        :param Sequence['GoogleRpcStatusResponse'] partial_failures: Details of errors that occurred.
        """
        pulumi.set(__self__, "attempt_time", attempt_time)
        pulumi.set(__self__, "partial_failures", partial_failures)

    @property
    @pulumi.getter(name="attemptTime")
    def attempt_time(self) -> str:
        return pulumi.get(self, "attempt_time")

    @property
    @pulumi.getter(name="partialFailures")
    def partial_failures(self) -> Sequence['outputs.GoogleRpcStatusResponse']:
        """
        Details of errors that occurred.
        """
        return pulumi.get(self, "partial_failures")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1BigQuerySourceResponse(dict):
    """
    The BigQuery location for input data. If used in an EvaluationJob, this is where the service saves the prediction input and output sampled from the model version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputUri":
            suggest = "input_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1BigQuerySourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1BigQuerySourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1BigQuerySourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_uri: str):
        """
        The BigQuery location for input data. If used in an EvaluationJob, this is where the service saves the prediction input and output sampled from the model version.
        :param str input_uri: Required. BigQuery URI to a table, up to 2,000 characters long. If you specify the URI of a table that does not exist, Data Labeling Service creates a table at the URI with the correct schema when you create your EvaluationJob. If you specify the URI of a table that already exists, it must have the [correct schema](/ml-engine/docs/continuous-evaluation/create-job#table-schema). Provide the table URI in the following format: "bq://{your_project_id}/ {your_dataset_name}/{your_table_name}" [Learn more](/ml-engine/docs/continuous-evaluation/create-job#table-schema).
        """
        pulumi.set(__self__, "input_uri", input_uri)

    @property
    @pulumi.getter(name="inputUri")
    def input_uri(self) -> str:
        """
        Required. BigQuery URI to a table, up to 2,000 characters long. If you specify the URI of a table that does not exist, Data Labeling Service creates a table at the URI with the correct schema when you create your EvaluationJob. If you specify the URI of a table that already exists, it must have the [correct schema](/ml-engine/docs/continuous-evaluation/create-job#table-schema). Provide the table URI in the following format: "bq://{your_project_id}/ {your_dataset_name}/{your_table_name}" [Learn more](/ml-engine/docs/continuous-evaluation/create-job#table-schema).
        """
        return pulumi.get(self, "input_uri")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsResponse(dict):
    """
    Options regarding evaluation between bounding boxes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iouThreshold":
            suggest = "iou_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 iou_threshold: float):
        """
        Options regarding evaluation between bounding boxes.
        :param float iou_threshold: Minimum [intersection-over-union (IOU)](/vision/automl/object-detection/docs/evaluate#intersection-over-union) required for 2 bounding boxes to be considered a match. This must be a number between 0 and 1.
        """
        pulumi.set(__self__, "iou_threshold", iou_threshold)

    @property
    @pulumi.getter(name="iouThreshold")
    def iou_threshold(self) -> float:
        """
        Minimum [intersection-over-union (IOU)](/vision/automl/object-detection/docs/evaluate#intersection-over-union) required for 2 bounding boxes to be considered a match. This must be a number between 0 and 1.
        """
        return pulumi.get(self, "iou_threshold")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1BoundingPolyConfigResponse(dict):
    """
    Config for image bounding poly (and bounding box) human labeling task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "annotationSpecSet":
            suggest = "annotation_spec_set"
        elif key == "instructionMessage":
            suggest = "instruction_message"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1BoundingPolyConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1BoundingPolyConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1BoundingPolyConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotation_spec_set: str,
                 instruction_message: str):
        """
        Config for image bounding poly (and bounding box) human labeling task.
        :param str annotation_spec_set: Required. Annotation spec set resource name.
        :param str instruction_message: Optional. Instruction message showed on contributors UI.
        """
        pulumi.set(__self__, "annotation_spec_set", annotation_spec_set)
        pulumi.set(__self__, "instruction_message", instruction_message)

    @property
    @pulumi.getter(name="annotationSpecSet")
    def annotation_spec_set(self) -> str:
        """
        Required. Annotation spec set resource name.
        """
        return pulumi.get(self, "annotation_spec_set")

    @property
    @pulumi.getter(name="instructionMessage")
    def instruction_message(self) -> str:
        """
        Optional. Instruction message showed on contributors UI.
        """
        return pulumi.get(self, "instruction_message")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1ClassificationMetadataResponse(dict):
    """
    Metadata for classification annotations.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isMultiLabel":
            suggest = "is_multi_label"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1ClassificationMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1ClassificationMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1ClassificationMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_multi_label: bool):
        """
        Metadata for classification annotations.
        :param bool is_multi_label: Whether the classification task is multi-label or not.
        """
        pulumi.set(__self__, "is_multi_label", is_multi_label)

    @property
    @pulumi.getter(name="isMultiLabel")
    def is_multi_label(self) -> bool:
        """
        Whether the classification task is multi-label or not.
        """
        return pulumi.get(self, "is_multi_label")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1CsvInstructionResponse(dict):
    """
    Deprecated: this instruction format is not supported any more. Instruction from a CSV file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsFileUri":
            suggest = "gcs_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1CsvInstructionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1CsvInstructionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1CsvInstructionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_file_uri: str):
        """
        Deprecated: this instruction format is not supported any more. Instruction from a CSV file.
        :param str gcs_file_uri: CSV file for the instruction. Only gcs path is allowed.
        """
        pulumi.set(__self__, "gcs_file_uri", gcs_file_uri)

    @property
    @pulumi.getter(name="gcsFileUri")
    def gcs_file_uri(self) -> str:
        """
        CSV file for the instruction. Only gcs path is allowed.
        """
        return pulumi.get(self, "gcs_file_uri")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1EvaluationConfigResponse(dict):
    """
    Configuration details used for calculating evaluation metrics and creating an Evaluation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boundingBoxEvaluationOptions":
            suggest = "bounding_box_evaluation_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1EvaluationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1EvaluationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1EvaluationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bounding_box_evaluation_options: 'outputs.GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsResponse'):
        """
        Configuration details used for calculating evaluation metrics and creating an Evaluation.
        :param 'GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsResponse' bounding_box_evaluation_options: Only specify this field if the related model performs image object detection (`IMAGE_BOUNDING_BOX_ANNOTATION`). Describes how to evaluate bounding boxes.
        """
        pulumi.set(__self__, "bounding_box_evaluation_options", bounding_box_evaluation_options)

    @property
    @pulumi.getter(name="boundingBoxEvaluationOptions")
    def bounding_box_evaluation_options(self) -> 'outputs.GoogleCloudDatalabelingV1beta1BoundingBoxEvaluationOptionsResponse':
        """
        Only specify this field if the related model performs image object detection (`IMAGE_BOUNDING_BOX_ANNOTATION`). Describes how to evaluate bounding boxes.
        """
        return pulumi.get(self, "bounding_box_evaluation_options")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigResponse(dict):
    """
    Provides details for how an evaluation job sends email alerts based on the results of a run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "minAcceptableMeanAveragePrecision":
            suggest = "min_acceptable_mean_average_precision"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: str,
                 min_acceptable_mean_average_precision: float):
        """
        Provides details for how an evaluation job sends email alerts based on the results of a run.
        :param str email: Required. An email address to send alerts to.
        :param float min_acceptable_mean_average_precision: Required. A number between 0 and 1 that describes a minimum mean average precision threshold. When the evaluation job runs, if it calculates that your model version's predictions from the recent interval have meanAveragePrecision below this threshold, then it sends an alert to your specified email.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "min_acceptable_mean_average_precision", min_acceptable_mean_average_precision)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Required. An email address to send alerts to.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="minAcceptableMeanAveragePrecision")
    def min_acceptable_mean_average_precision(self) -> float:
        """
        Required. A number between 0 and 1 that describes a minimum mean average precision threshold. When the evaluation job runs, if it calculates that your model version's predictions from the recent interval have meanAveragePrecision below this threshold, then it sends an alert to your specified email.
        """
        return pulumi.get(self, "min_acceptable_mean_average_precision")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1EvaluationJobConfigResponse(dict):
    """
    Configures specific details of how a continuous evaluation job works. Provide this configuration when you create an EvaluationJob.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryImportKeys":
            suggest = "bigquery_import_keys"
        elif key == "boundingPolyConfig":
            suggest = "bounding_poly_config"
        elif key == "evaluationConfig":
            suggest = "evaluation_config"
        elif key == "evaluationJobAlertConfig":
            suggest = "evaluation_job_alert_config"
        elif key == "exampleCount":
            suggest = "example_count"
        elif key == "exampleSamplePercentage":
            suggest = "example_sample_percentage"
        elif key == "humanAnnotationConfig":
            suggest = "human_annotation_config"
        elif key == "imageClassificationConfig":
            suggest = "image_classification_config"
        elif key == "inputConfig":
            suggest = "input_config"
        elif key == "textClassificationConfig":
            suggest = "text_classification_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1EvaluationJobConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1EvaluationJobConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1EvaluationJobConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_import_keys: Mapping[str, str],
                 bounding_poly_config: 'outputs.GoogleCloudDatalabelingV1beta1BoundingPolyConfigResponse',
                 evaluation_config: 'outputs.GoogleCloudDatalabelingV1beta1EvaluationConfigResponse',
                 evaluation_job_alert_config: 'outputs.GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigResponse',
                 example_count: int,
                 example_sample_percentage: float,
                 human_annotation_config: 'outputs.GoogleCloudDatalabelingV1beta1HumanAnnotationConfigResponse',
                 image_classification_config: 'outputs.GoogleCloudDatalabelingV1beta1ImageClassificationConfigResponse',
                 input_config: 'outputs.GoogleCloudDatalabelingV1beta1InputConfigResponse',
                 text_classification_config: 'outputs.GoogleCloudDatalabelingV1beta1TextClassificationConfigResponse'):
        """
        Configures specific details of how a continuous evaluation job works. Provide this configuration when you create an EvaluationJob.
        :param Mapping[str, str] bigquery_import_keys: Required. Prediction keys that tell Data Labeling Service where to find the data for evaluation in your BigQuery table. When the service samples prediction input and output from your model version and saves it to BigQuery, the data gets stored as JSON strings in the BigQuery table. These keys tell Data Labeling Service how to parse the JSON. You can provide the following entries in this field: * `data_json_key`: the data key for prediction input. You must provide either this key or `reference_json_key`. * `reference_json_key`: the data reference key for prediction input. You must provide either this key or `data_json_key`. * `label_json_key`: the label key for prediction output. Required. * `label_score_json_key`: the score key for prediction output. Required. * `bounding_box_json_key`: the bounding box key for prediction output. Required if your model version perform image object detection. Learn [how to configure prediction keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
        :param 'GoogleCloudDatalabelingV1beta1BoundingPolyConfigResponse' bounding_poly_config: Specify this field if your model version performs image object detection (bounding box detection). `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet.
        :param 'GoogleCloudDatalabelingV1beta1EvaluationConfigResponse' evaluation_config: Required. Details for calculating evaluation metrics and creating Evaulations. If your model version performs image object detection, you must specify the `boundingBoxEvaluationOptions` field within this configuration. Otherwise, provide an empty object for this configuration.
        :param 'GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigResponse' evaluation_job_alert_config: Optional. Configuration details for evaluation job alerts. Specify this field if you want to receive email alerts if the evaluation job finds that your predictions have low mean average precision during a run.
        :param int example_count: Required. The maximum number of predictions to sample and save to BigQuery during each evaluation interval. This limit overrides `example_sample_percentage`: even if the service has not sampled enough predictions to fulfill `example_sample_perecentage` during an interval, it stops sampling predictions when it meets this limit.
        :param float example_sample_percentage: Required. Fraction of predictions to sample and save to BigQuery during each evaluation interval. For example, 0.1 means 10% of predictions served by your model version get saved to BigQuery.
        :param 'GoogleCloudDatalabelingV1beta1HumanAnnotationConfigResponse' human_annotation_config: Optional. Details for human annotation of your data. If you set labelMissingGroundTruth to `true` for this evaluation job, then you must specify this field. If you plan to provide your own ground truth labels, then omit this field. Note that you must create an Instruction resource before you can specify this field. Provide the name of the instruction resource in the `instruction` field within this configuration.
        :param 'GoogleCloudDatalabelingV1beta1ImageClassificationConfigResponse' image_classification_config: Specify this field if your model version performs image classification or general classification. `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet. `allowMultiLabel` in this configuration must match `classificationMetadata.isMultiLabel` in input_config.
        :param 'GoogleCloudDatalabelingV1beta1InputConfigResponse' input_config: Rquired. Details for the sampled prediction input. Within this configuration, there are requirements for several fields: * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`. * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`, `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`, or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection). * If your machine learning model performs classification, you must specify `classificationMetadata.isMultiLabel`. * You must specify `bigquerySource` (not `gcsSource`).
        :param 'GoogleCloudDatalabelingV1beta1TextClassificationConfigResponse' text_classification_config: Specify this field if your model version performs text classification. `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet. `allowMultiLabel` in this configuration must match `classificationMetadata.isMultiLabel` in input_config.
        """
        pulumi.set(__self__, "bigquery_import_keys", bigquery_import_keys)
        pulumi.set(__self__, "bounding_poly_config", bounding_poly_config)
        pulumi.set(__self__, "evaluation_config", evaluation_config)
        pulumi.set(__self__, "evaluation_job_alert_config", evaluation_job_alert_config)
        pulumi.set(__self__, "example_count", example_count)
        pulumi.set(__self__, "example_sample_percentage", example_sample_percentage)
        pulumi.set(__self__, "human_annotation_config", human_annotation_config)
        pulumi.set(__self__, "image_classification_config", image_classification_config)
        pulumi.set(__self__, "input_config", input_config)
        pulumi.set(__self__, "text_classification_config", text_classification_config)

    @property
    @pulumi.getter(name="bigqueryImportKeys")
    def bigquery_import_keys(self) -> Mapping[str, str]:
        """
        Required. Prediction keys that tell Data Labeling Service where to find the data for evaluation in your BigQuery table. When the service samples prediction input and output from your model version and saves it to BigQuery, the data gets stored as JSON strings in the BigQuery table. These keys tell Data Labeling Service how to parse the JSON. You can provide the following entries in this field: * `data_json_key`: the data key for prediction input. You must provide either this key or `reference_json_key`. * `reference_json_key`: the data reference key for prediction input. You must provide either this key or `data_json_key`. * `label_json_key`: the label key for prediction output. Required. * `label_score_json_key`: the score key for prediction output. Required. * `bounding_box_json_key`: the bounding box key for prediction output. Required if your model version perform image object detection. Learn [how to configure prediction keys](/ml-engine/docs/continuous-evaluation/create-job#prediction-keys).
        """
        return pulumi.get(self, "bigquery_import_keys")

    @property
    @pulumi.getter(name="boundingPolyConfig")
    def bounding_poly_config(self) -> 'outputs.GoogleCloudDatalabelingV1beta1BoundingPolyConfigResponse':
        """
        Specify this field if your model version performs image object detection (bounding box detection). `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet.
        """
        return pulumi.get(self, "bounding_poly_config")

    @property
    @pulumi.getter(name="evaluationConfig")
    def evaluation_config(self) -> 'outputs.GoogleCloudDatalabelingV1beta1EvaluationConfigResponse':
        """
        Required. Details for calculating evaluation metrics and creating Evaulations. If your model version performs image object detection, you must specify the `boundingBoxEvaluationOptions` field within this configuration. Otherwise, provide an empty object for this configuration.
        """
        return pulumi.get(self, "evaluation_config")

    @property
    @pulumi.getter(name="evaluationJobAlertConfig")
    def evaluation_job_alert_config(self) -> 'outputs.GoogleCloudDatalabelingV1beta1EvaluationJobAlertConfigResponse':
        """
        Optional. Configuration details for evaluation job alerts. Specify this field if you want to receive email alerts if the evaluation job finds that your predictions have low mean average precision during a run.
        """
        return pulumi.get(self, "evaluation_job_alert_config")

    @property
    @pulumi.getter(name="exampleCount")
    def example_count(self) -> int:
        """
        Required. The maximum number of predictions to sample and save to BigQuery during each evaluation interval. This limit overrides `example_sample_percentage`: even if the service has not sampled enough predictions to fulfill `example_sample_perecentage` during an interval, it stops sampling predictions when it meets this limit.
        """
        return pulumi.get(self, "example_count")

    @property
    @pulumi.getter(name="exampleSamplePercentage")
    def example_sample_percentage(self) -> float:
        """
        Required. Fraction of predictions to sample and save to BigQuery during each evaluation interval. For example, 0.1 means 10% of predictions served by your model version get saved to BigQuery.
        """
        return pulumi.get(self, "example_sample_percentage")

    @property
    @pulumi.getter(name="humanAnnotationConfig")
    def human_annotation_config(self) -> 'outputs.GoogleCloudDatalabelingV1beta1HumanAnnotationConfigResponse':
        """
        Optional. Details for human annotation of your data. If you set labelMissingGroundTruth to `true` for this evaluation job, then you must specify this field. If you plan to provide your own ground truth labels, then omit this field. Note that you must create an Instruction resource before you can specify this field. Provide the name of the instruction resource in the `instruction` field within this configuration.
        """
        return pulumi.get(self, "human_annotation_config")

    @property
    @pulumi.getter(name="imageClassificationConfig")
    def image_classification_config(self) -> 'outputs.GoogleCloudDatalabelingV1beta1ImageClassificationConfigResponse':
        """
        Specify this field if your model version performs image classification or general classification. `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet. `allowMultiLabel` in this configuration must match `classificationMetadata.isMultiLabel` in input_config.
        """
        return pulumi.get(self, "image_classification_config")

    @property
    @pulumi.getter(name="inputConfig")
    def input_config(self) -> 'outputs.GoogleCloudDatalabelingV1beta1InputConfigResponse':
        """
        Rquired. Details for the sampled prediction input. Within this configuration, there are requirements for several fields: * `dataType` must be one of `IMAGE`, `TEXT`, or `GENERAL_DATA`. * `annotationType` must be one of `IMAGE_CLASSIFICATION_ANNOTATION`, `TEXT_CLASSIFICATION_ANNOTATION`, `GENERAL_CLASSIFICATION_ANNOTATION`, or `IMAGE_BOUNDING_BOX_ANNOTATION` (image object detection). * If your machine learning model performs classification, you must specify `classificationMetadata.isMultiLabel`. * You must specify `bigquerySource` (not `gcsSource`).
        """
        return pulumi.get(self, "input_config")

    @property
    @pulumi.getter(name="textClassificationConfig")
    def text_classification_config(self) -> 'outputs.GoogleCloudDatalabelingV1beta1TextClassificationConfigResponse':
        """
        Specify this field if your model version performs text classification. `annotationSpecSet` in this configuration must match EvaluationJob.annotationSpecSet. `allowMultiLabel` in this configuration must match `classificationMetadata.isMultiLabel` in input_config.
        """
        return pulumi.get(self, "text_classification_config")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1GcsSourceResponse(dict):
    """
    Source of the Cloud Storage file to be imported.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputUri":
            suggest = "input_uri"
        elif key == "mimeType":
            suggest = "mime_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1GcsSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1GcsSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1GcsSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_uri: str,
                 mime_type: str):
        """
        Source of the Cloud Storage file to be imported.
        :param str input_uri: Required. The input URI of source file. This must be a Cloud Storage path (`gs://...`).
        :param str mime_type: Required. The format of the source file. Only "text/csv" is supported.
        """
        pulumi.set(__self__, "input_uri", input_uri)
        pulumi.set(__self__, "mime_type", mime_type)

    @property
    @pulumi.getter(name="inputUri")
    def input_uri(self) -> str:
        """
        Required. The input URI of source file. This must be a Cloud Storage path (`gs://...`).
        """
        return pulumi.get(self, "input_uri")

    @property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> str:
        """
        Required. The format of the source file. Only "text/csv" is supported.
        """
        return pulumi.get(self, "mime_type")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1HumanAnnotationConfigResponse(dict):
    """
    Configuration for how human labeling task should be done.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "annotatedDatasetDescription":
            suggest = "annotated_dataset_description"
        elif key == "annotatedDatasetDisplayName":
            suggest = "annotated_dataset_display_name"
        elif key == "contributorEmails":
            suggest = "contributor_emails"
        elif key == "labelGroup":
            suggest = "label_group"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "questionDuration":
            suggest = "question_duration"
        elif key == "replicaCount":
            suggest = "replica_count"
        elif key == "userEmailAddress":
            suggest = "user_email_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1HumanAnnotationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1HumanAnnotationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1HumanAnnotationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotated_dataset_description: str,
                 annotated_dataset_display_name: str,
                 contributor_emails: Sequence[str],
                 instruction: str,
                 label_group: str,
                 language_code: str,
                 question_duration: str,
                 replica_count: int,
                 user_email_address: str):
        """
        Configuration for how human labeling task should be done.
        :param str annotated_dataset_description: Optional. A human-readable description for AnnotatedDataset. The description can be up to 10000 characters long.
        :param str annotated_dataset_display_name: Required. A human-readable name for AnnotatedDataset defined by users. Maximum of 64 characters .
        :param Sequence[str] contributor_emails: Optional. If you want your own labeling contributors to manage and work on this labeling request, you can set these contributors here. We will give them access to the question types in crowdcompute. Note that these emails must be registered in crowdcompute worker UI: https://crowd-compute.appspot.com/
        :param str instruction: Required. Instruction resource name.
        :param str label_group: Optional. A human-readable label used to logically group labeling tasks. This string must match the regular expression `[a-zA-Z\\d_-]{0,128}`.
        :param str language_code: Optional. The Language of this question, as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US. Only need to set this when task is language related. For example, French text classification.
        :param str question_duration: Optional. Maximum duration for contributors to answer a question. Maximum is 3600 seconds. Default is 3600 seconds.
        :param int replica_count: Optional. Replication of questions. Each question will be sent to up to this number of contributors to label. Aggregated answers will be returned. Default is set to 1. For image related labeling, valid values are 1, 3, 5.
        :param str user_email_address: Email of the user who started the labeling task and should be notified by email. If empty no notification will be sent.
        """
        pulumi.set(__self__, "annotated_dataset_description", annotated_dataset_description)
        pulumi.set(__self__, "annotated_dataset_display_name", annotated_dataset_display_name)
        pulumi.set(__self__, "contributor_emails", contributor_emails)
        pulumi.set(__self__, "instruction", instruction)
        pulumi.set(__self__, "label_group", label_group)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "question_duration", question_duration)
        pulumi.set(__self__, "replica_count", replica_count)
        pulumi.set(__self__, "user_email_address", user_email_address)

    @property
    @pulumi.getter(name="annotatedDatasetDescription")
    def annotated_dataset_description(self) -> str:
        """
        Optional. A human-readable description for AnnotatedDataset. The description can be up to 10000 characters long.
        """
        return pulumi.get(self, "annotated_dataset_description")

    @property
    @pulumi.getter(name="annotatedDatasetDisplayName")
    def annotated_dataset_display_name(self) -> str:
        """
        Required. A human-readable name for AnnotatedDataset defined by users. Maximum of 64 characters .
        """
        return pulumi.get(self, "annotated_dataset_display_name")

    @property
    @pulumi.getter(name="contributorEmails")
    def contributor_emails(self) -> Sequence[str]:
        """
        Optional. If you want your own labeling contributors to manage and work on this labeling request, you can set these contributors here. We will give them access to the question types in crowdcompute. Note that these emails must be registered in crowdcompute worker UI: https://crowd-compute.appspot.com/
        """
        return pulumi.get(self, "contributor_emails")

    @property
    @pulumi.getter
    def instruction(self) -> str:
        """
        Required. Instruction resource name.
        """
        return pulumi.get(self, "instruction")

    @property
    @pulumi.getter(name="labelGroup")
    def label_group(self) -> str:
        """
        Optional. A human-readable label used to logically group labeling tasks. This string must match the regular expression `[a-zA-Z\\d_-]{0,128}`.
        """
        return pulumi.get(self, "label_group")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Optional. The Language of this question, as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US. Only need to set this when task is language related. For example, French text classification.
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="questionDuration")
    def question_duration(self) -> str:
        """
        Optional. Maximum duration for contributors to answer a question. Maximum is 3600 seconds. Default is 3600 seconds.
        """
        return pulumi.get(self, "question_duration")

    @property
    @pulumi.getter(name="replicaCount")
    def replica_count(self) -> int:
        """
        Optional. Replication of questions. Each question will be sent to up to this number of contributors to label. Aggregated answers will be returned. Default is set to 1. For image related labeling, valid values are 1, 3, 5.
        """
        return pulumi.get(self, "replica_count")

    @property
    @pulumi.getter(name="userEmailAddress")
    def user_email_address(self) -> str:
        """
        Email of the user who started the labeling task and should be notified by email. If empty no notification will be sent.
        """
        return pulumi.get(self, "user_email_address")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1ImageClassificationConfigResponse(dict):
    """
    Config for image classification human labeling task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMultiLabel":
            suggest = "allow_multi_label"
        elif key == "annotationSpecSet":
            suggest = "annotation_spec_set"
        elif key == "answerAggregationType":
            suggest = "answer_aggregation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1ImageClassificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1ImageClassificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1ImageClassificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_multi_label: bool,
                 annotation_spec_set: str,
                 answer_aggregation_type: str):
        """
        Config for image classification human labeling task.
        :param bool allow_multi_label: Optional. If allow_multi_label is true, contributors are able to choose multiple labels for one image.
        :param str annotation_spec_set: Required. Annotation spec set resource name.
        :param str answer_aggregation_type: Optional. The type of how to aggregate answers.
        """
        pulumi.set(__self__, "allow_multi_label", allow_multi_label)
        pulumi.set(__self__, "annotation_spec_set", annotation_spec_set)
        pulumi.set(__self__, "answer_aggregation_type", answer_aggregation_type)

    @property
    @pulumi.getter(name="allowMultiLabel")
    def allow_multi_label(self) -> bool:
        """
        Optional. If allow_multi_label is true, contributors are able to choose multiple labels for one image.
        """
        return pulumi.get(self, "allow_multi_label")

    @property
    @pulumi.getter(name="annotationSpecSet")
    def annotation_spec_set(self) -> str:
        """
        Required. Annotation spec set resource name.
        """
        return pulumi.get(self, "annotation_spec_set")

    @property
    @pulumi.getter(name="answerAggregationType")
    def answer_aggregation_type(self) -> str:
        """
        Optional. The type of how to aggregate answers.
        """
        return pulumi.get(self, "answer_aggregation_type")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1InputConfigResponse(dict):
    """
    The configuration of input data, including data type, location, etc.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "annotationType":
            suggest = "annotation_type"
        elif key == "bigquerySource":
            suggest = "bigquery_source"
        elif key == "classificationMetadata":
            suggest = "classification_metadata"
        elif key == "dataType":
            suggest = "data_type"
        elif key == "gcsSource":
            suggest = "gcs_source"
        elif key == "textMetadata":
            suggest = "text_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1InputConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1InputConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1InputConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotation_type: str,
                 bigquery_source: 'outputs.GoogleCloudDatalabelingV1beta1BigQuerySourceResponse',
                 classification_metadata: 'outputs.GoogleCloudDatalabelingV1beta1ClassificationMetadataResponse',
                 data_type: str,
                 gcs_source: 'outputs.GoogleCloudDatalabelingV1beta1GcsSourceResponse',
                 text_metadata: 'outputs.GoogleCloudDatalabelingV1beta1TextMetadataResponse'):
        """
        The configuration of input data, including data type, location, etc.
        :param str annotation_type: Optional. The type of annotation to be performed on this data. You must specify this field if you are using this InputConfig in an EvaluationJob.
        :param 'GoogleCloudDatalabelingV1beta1BigQuerySourceResponse' bigquery_source: Source located in BigQuery. You must specify this field if you are using this InputConfig in an EvaluationJob.
        :param 'GoogleCloudDatalabelingV1beta1ClassificationMetadataResponse' classification_metadata: Optional. Metadata about annotations for the input. You must specify this field if you are using this InputConfig in an EvaluationJob for a model version that performs classification.
        :param str data_type: Required. Data type must be specifed when user tries to import data.
        :param 'GoogleCloudDatalabelingV1beta1GcsSourceResponse' gcs_source: Source located in Cloud Storage.
        :param 'GoogleCloudDatalabelingV1beta1TextMetadataResponse' text_metadata: Required for text import, as language code must be specified.
        """
        pulumi.set(__self__, "annotation_type", annotation_type)
        pulumi.set(__self__, "bigquery_source", bigquery_source)
        pulumi.set(__self__, "classification_metadata", classification_metadata)
        pulumi.set(__self__, "data_type", data_type)
        pulumi.set(__self__, "gcs_source", gcs_source)
        pulumi.set(__self__, "text_metadata", text_metadata)

    @property
    @pulumi.getter(name="annotationType")
    def annotation_type(self) -> str:
        """
        Optional. The type of annotation to be performed on this data. You must specify this field if you are using this InputConfig in an EvaluationJob.
        """
        return pulumi.get(self, "annotation_type")

    @property
    @pulumi.getter(name="bigquerySource")
    def bigquery_source(self) -> 'outputs.GoogleCloudDatalabelingV1beta1BigQuerySourceResponse':
        """
        Source located in BigQuery. You must specify this field if you are using this InputConfig in an EvaluationJob.
        """
        return pulumi.get(self, "bigquery_source")

    @property
    @pulumi.getter(name="classificationMetadata")
    def classification_metadata(self) -> 'outputs.GoogleCloudDatalabelingV1beta1ClassificationMetadataResponse':
        """
        Optional. Metadata about annotations for the input. You must specify this field if you are using this InputConfig in an EvaluationJob for a model version that performs classification.
        """
        return pulumi.get(self, "classification_metadata")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> str:
        """
        Required. Data type must be specifed when user tries to import data.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> 'outputs.GoogleCloudDatalabelingV1beta1GcsSourceResponse':
        """
        Source located in Cloud Storage.
        """
        return pulumi.get(self, "gcs_source")

    @property
    @pulumi.getter(name="textMetadata")
    def text_metadata(self) -> 'outputs.GoogleCloudDatalabelingV1beta1TextMetadataResponse':
        """
        Required for text import, as language code must be specified.
        """
        return pulumi.get(self, "text_metadata")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1OperatorFeedbackMetadataResponse(dict):
    """
    Metadata describing the feedback from the operator.
    """
    def __init__(__self__):
        """
        Metadata describing the feedback from the operator.
        """
        pass


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1PdfInstructionResponse(dict):
    """
    Instruction from a PDF file.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsFileUri":
            suggest = "gcs_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1PdfInstructionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1PdfInstructionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1PdfInstructionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_file_uri: str):
        """
        Instruction from a PDF file.
        :param str gcs_file_uri: PDF file for the instruction. Only gcs path is allowed.
        """
        pulumi.set(__self__, "gcs_file_uri", gcs_file_uri)

    @property
    @pulumi.getter(name="gcsFileUri")
    def gcs_file_uri(self) -> str:
        """
        PDF file for the instruction. Only gcs path is allowed.
        """
        return pulumi.get(self, "gcs_file_uri")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1RequesterFeedbackMetadataResponse(dict):
    """
    Metadata describing the feedback from the labeling task requester.
    """
    def __init__(__self__):
        """
        Metadata describing the feedback from the labeling task requester.
        """
        pass


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1SentimentConfigResponse(dict):
    """
    Config for setting up sentiments.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableLabelSentimentSelection":
            suggest = "enable_label_sentiment_selection"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1SentimentConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1SentimentConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1SentimentConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_label_sentiment_selection: bool):
        """
        Config for setting up sentiments.
        :param bool enable_label_sentiment_selection: If set to true, contributors will have the option to select sentiment of the label they selected, to mark it as negative or positive label. Default is false.
        """
        pulumi.set(__self__, "enable_label_sentiment_selection", enable_label_sentiment_selection)

    @property
    @pulumi.getter(name="enableLabelSentimentSelection")
    def enable_label_sentiment_selection(self) -> bool:
        """
        If set to true, contributors will have the option to select sentiment of the label they selected, to mark it as negative or positive label. Default is false.
        """
        return pulumi.get(self, "enable_label_sentiment_selection")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1TextClassificationConfigResponse(dict):
    """
    Config for text classification human labeling task.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMultiLabel":
            suggest = "allow_multi_label"
        elif key == "annotationSpecSet":
            suggest = "annotation_spec_set"
        elif key == "sentimentConfig":
            suggest = "sentiment_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1TextClassificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1TextClassificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1TextClassificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_multi_label: bool,
                 annotation_spec_set: str,
                 sentiment_config: 'outputs.GoogleCloudDatalabelingV1beta1SentimentConfigResponse'):
        """
        Config for text classification human labeling task.
        :param bool allow_multi_label: Optional. If allow_multi_label is true, contributors are able to choose multiple labels for one text segment.
        :param str annotation_spec_set: Required. Annotation spec set resource name.
        :param 'GoogleCloudDatalabelingV1beta1SentimentConfigResponse' sentiment_config: Optional. Configs for sentiment selection. We deprecate sentiment analysis in data labeling side as it is incompatible with uCAIP.
        """
        pulumi.set(__self__, "allow_multi_label", allow_multi_label)
        pulumi.set(__self__, "annotation_spec_set", annotation_spec_set)
        pulumi.set(__self__, "sentiment_config", sentiment_config)

    @property
    @pulumi.getter(name="allowMultiLabel")
    def allow_multi_label(self) -> bool:
        """
        Optional. If allow_multi_label is true, contributors are able to choose multiple labels for one text segment.
        """
        return pulumi.get(self, "allow_multi_label")

    @property
    @pulumi.getter(name="annotationSpecSet")
    def annotation_spec_set(self) -> str:
        """
        Required. Annotation spec set resource name.
        """
        return pulumi.get(self, "annotation_spec_set")

    @property
    @pulumi.getter(name="sentimentConfig")
    def sentiment_config(self) -> 'outputs.GoogleCloudDatalabelingV1beta1SentimentConfigResponse':
        """
        Optional. Configs for sentiment selection. We deprecate sentiment analysis in data labeling side as it is incompatible with uCAIP.
        """
        return pulumi.get(self, "sentiment_config")


@pulumi.output_type
class GoogleCloudDatalabelingV1beta1TextMetadataResponse(dict):
    """
    Metadata for the text.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "languageCode":
            suggest = "language_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudDatalabelingV1beta1TextMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudDatalabelingV1beta1TextMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudDatalabelingV1beta1TextMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 language_code: str):
        """
        Metadata for the text.
        :param str language_code: The language of this text, as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US.
        """
        pulumi.set(__self__, "language_code", language_code)

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        The language of this text, as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt). Default value is en-US.
        """
        return pulumi.get(self, "language_code")


@pulumi.output_type
class GoogleRpcStatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


