# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'AutoscalingSettingsResponse',
    'BigQueryIODetailsResponse',
    'BigTableIODetailsResponse',
    'ComponentSourceResponse',
    'ComponentTransformResponse',
    'DatastoreIODetailsResponse',
    'DebugOptionsResponse',
    'DiskResponse',
    'DisplayDataResponse',
    'EnvironmentResponse',
    'ExecutionStageStateResponse',
    'ExecutionStageSummaryResponse',
    'FileIODetailsResponse',
    'JobMetadataResponse',
    'PackageResponse',
    'ParameterMetadataResponse',
    'PipelineDescriptionResponse',
    'PubSubIODetailsResponse',
    'RuntimeMetadataResponse',
    'SDKInfoResponse',
    'SdkHarnessContainerImageResponse',
    'SdkVersionResponse',
    'SpannerIODetailsResponse',
    'StageSourceResponse',
    'StatusResponse',
    'StepResponse',
    'TaskRunnerSettingsResponse',
    'TemplateMetadataResponse',
    'TransformSummaryResponse',
    'WorkerPoolResponse',
    'WorkerSettingsResponse',
]

@pulumi.output_type
class AutoscalingSettingsResponse(dict):
    """
    Settings for WorkerPool autoscaling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxNumWorkers":
            suggest = "max_num_workers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 max_num_workers: int):
        """
        Settings for WorkerPool autoscaling.
        :param str algorithm: The algorithm to use for autoscaling.
        :param int max_num_workers: The maximum number of workers to cap scaling at.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "max_num_workers", max_num_workers)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm to use for autoscaling.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="maxNumWorkers")
    def max_num_workers(self) -> int:
        """
        The maximum number of workers to cap scaling at.
        """
        return pulumi.get(self, "max_num_workers")


@pulumi.output_type
class BigQueryIODetailsResponse(dict):
    """
    Metadata for a BigQuery connector used by the job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigQueryIODetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigQueryIODetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigQueryIODetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset: str,
                 project_id: str,
                 query: str,
                 table: str):
        """
        Metadata for a BigQuery connector used by the job.
        :param str dataset: Dataset accessed in the connection.
        :param str project_id: Project accessed in the connection.
        :param str query: Query used to access data in the connection.
        :param str table: Table accessed in the connection.
        """
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "table", table)

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        Dataset accessed in the connection.
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        Project accessed in the connection.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query used to access data in the connection.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        Table accessed in the connection.
        """
        return pulumi.get(self, "table")


@pulumi.output_type
class BigTableIODetailsResponse(dict):
    """
    Metadata for a Cloud BigTable connector used by the job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "tableId":
            suggest = "table_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BigTableIODetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BigTableIODetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BigTableIODetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_id: str,
                 project_id: str,
                 table_id: str):
        """
        Metadata for a Cloud BigTable connector used by the job.
        :param str instance_id: InstanceId accessed in the connection.
        :param str project_id: ProjectId accessed in the connection.
        :param str table_id: TableId accessed in the connection.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "table_id", table_id)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        InstanceId accessed in the connection.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        ProjectId accessed in the connection.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="tableId")
    def table_id(self) -> str:
        """
        TableId accessed in the connection.
        """
        return pulumi.get(self, "table_id")


@pulumi.output_type
class ComponentSourceResponse(dict):
    """
    Description of an interstitial value between transforms in an execution stage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originalTransformOrCollection":
            suggest = "original_transform_or_collection"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 original_transform_or_collection: str,
                 user_name: str):
        """
        Description of an interstitial value between transforms in an execution stage.
        :param str name: Dataflow service generated name for this source.
        :param str original_transform_or_collection: User name for the original user transform or collection with which this source is most closely associated.
        :param str user_name: Human-readable name for this transform; may be user or system generated.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "original_transform_or_collection", original_transform_or_collection)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Dataflow service generated name for this source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="originalTransformOrCollection")
    def original_transform_or_collection(self) -> str:
        """
        User name for the original user transform or collection with which this source is most closely associated.
        """
        return pulumi.get(self, "original_transform_or_collection")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Human-readable name for this transform; may be user or system generated.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class ComponentTransformResponse(dict):
    """
    Description of a transform executed as part of an execution stage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originalTransform":
            suggest = "original_transform"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComponentTransformResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComponentTransformResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComponentTransformResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 original_transform: str,
                 user_name: str):
        """
        Description of a transform executed as part of an execution stage.
        :param str name: Dataflow service generated name for this source.
        :param str original_transform: User name for the original user transform with which this transform is most closely associated.
        :param str user_name: Human-readable name for this transform; may be user or system generated.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "original_transform", original_transform)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Dataflow service generated name for this source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="originalTransform")
    def original_transform(self) -> str:
        """
        User name for the original user transform with which this transform is most closely associated.
        """
        return pulumi.get(self, "original_transform")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Human-readable name for this transform; may be user or system generated.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class DatastoreIODetailsResponse(dict):
    """
    Metadata for a Datastore connector used by the job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatastoreIODetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatastoreIODetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatastoreIODetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: str,
                 project_id: str):
        """
        Metadata for a Datastore connector used by the job.
        :param str namespace: Namespace used in the connection.
        :param str project_id: ProjectId accessed in the connection.
        """
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace used in the connection.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        ProjectId accessed in the connection.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class DebugOptionsResponse(dict):
    """
    Describes any options that have an effect on the debugging of pipelines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableHotKeyLogging":
            suggest = "enable_hot_key_logging"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DebugOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DebugOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DebugOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_hot_key_logging: bool):
        """
        Describes any options that have an effect on the debugging of pipelines.
        :param bool enable_hot_key_logging: When true, enables the logging of the literal hot key to the user's Cloud Logging.
        """
        pulumi.set(__self__, "enable_hot_key_logging", enable_hot_key_logging)

    @property
    @pulumi.getter(name="enableHotKeyLogging")
    def enable_hot_key_logging(self) -> bool:
        """
        When true, enables the logging of the literal hot key to the user's Cloud Logging.
        """
        return pulumi.get(self, "enable_hot_key_logging")


@pulumi.output_type
class DiskResponse(dict):
    """
    Describes the data disk used by a workflow job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskType":
            suggest = "disk_type"
        elif key == "mountPoint":
            suggest = "mount_point"
        elif key == "sizeGb":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_type: str,
                 mount_point: str,
                 size_gb: int):
        """
        Describes the data disk used by a workflow job.
        :param str disk_type: Disk storage type, as defined by Google Compute Engine. This must be a disk type appropriate to the project and zone in which the workers will run. If unknown or unspecified, the service will attempt to choose a reasonable default. For example, the standard persistent disk type is a resource name typically ending in "pd-standard". If SSD persistent disks are available, the resource name typically ends with "pd-ssd". The actual valid values are defined the Google Compute Engine API, not by the Cloud Dataflow API; consult the Google Compute Engine documentation for more information about determining the set of available disk types for a particular project and zone. Google Compute Engine Disk types are local to a particular project in a particular zone, and so the resource name will typically look something like this: compute.googleapis.com/projects/project-id/zones/zone/diskTypes/pd-standard
        :param str mount_point: Directory in a VM where disk is mounted.
        :param int size_gb: Size of disk in GB. If zero or unspecified, the service will attempt to choose a reasonable default.
        """
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "mount_point", mount_point)
        pulumi.set(__self__, "size_gb", size_gb)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Disk storage type, as defined by Google Compute Engine. This must be a disk type appropriate to the project and zone in which the workers will run. If unknown or unspecified, the service will attempt to choose a reasonable default. For example, the standard persistent disk type is a resource name typically ending in "pd-standard". If SSD persistent disks are available, the resource name typically ends with "pd-ssd". The actual valid values are defined the Google Compute Engine API, not by the Cloud Dataflow API; consult the Google Compute Engine documentation for more information about determining the set of available disk types for a particular project and zone. Google Compute Engine Disk types are local to a particular project in a particular zone, and so the resource name will typically look something like this: compute.googleapis.com/projects/project-id/zones/zone/diskTypes/pd-standard
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="mountPoint")
    def mount_point(self) -> str:
        """
        Directory in a VM where disk is mounted.
        """
        return pulumi.get(self, "mount_point")

    @property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> int:
        """
        Size of disk in GB. If zero or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class DisplayDataResponse(dict):
    """
    Data provided with a pipeline or transform to provide descriptive info.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boolValue":
            suggest = "bool_value"
        elif key == "durationValue":
            suggest = "duration_value"
        elif key == "floatValue":
            suggest = "float_value"
        elif key == "int64Value":
            suggest = "int64_value"
        elif key == "javaClassValue":
            suggest = "java_class_value"
        elif key == "shortStrValue":
            suggest = "short_str_value"
        elif key == "strValue":
            suggest = "str_value"
        elif key == "timestampValue":
            suggest = "timestamp_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DisplayDataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DisplayDataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DisplayDataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bool_value: bool,
                 duration_value: str,
                 float_value: float,
                 int64_value: str,
                 java_class_value: str,
                 key: str,
                 label: str,
                 namespace: str,
                 short_str_value: str,
                 str_value: str,
                 timestamp_value: str,
                 url: str):
        """
        Data provided with a pipeline or transform to provide descriptive info.
        :param bool bool_value: Contains value if the data is of a boolean type.
        :param str duration_value: Contains value if the data is of duration type.
        :param float float_value: Contains value if the data is of float type.
        :param str int64_value: Contains value if the data is of int64 type.
        :param str java_class_value: Contains value if the data is of java class type.
        :param str key: The key identifying the display data. This is intended to be used as a label for the display data when viewed in a dax monitoring system.
        :param str label: An optional label to display in a dax UI for the element.
        :param str namespace: The namespace for the key. This is usually a class name or programming language namespace (i.e. python module) which defines the display data. This allows a dax monitoring system to specially handle the data and perform custom rendering.
        :param str short_str_value: A possible additional shorter value to display. For example a java_class_name_value of com.mypackage.MyDoFn will be stored with MyDoFn as the short_str_value and com.mypackage.MyDoFn as the java_class_name value. short_str_value can be displayed and java_class_name_value will be displayed as a tooltip.
        :param str str_value: Contains value if the data is of string type.
        :param str timestamp_value: Contains value if the data is of timestamp type.
        :param str url: An optional full URL.
        """
        pulumi.set(__self__, "bool_value", bool_value)
        pulumi.set(__self__, "duration_value", duration_value)
        pulumi.set(__self__, "float_value", float_value)
        pulumi.set(__self__, "int64_value", int64_value)
        pulumi.set(__self__, "java_class_value", java_class_value)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "short_str_value", short_str_value)
        pulumi.set(__self__, "str_value", str_value)
        pulumi.set(__self__, "timestamp_value", timestamp_value)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="boolValue")
    def bool_value(self) -> bool:
        """
        Contains value if the data is of a boolean type.
        """
        return pulumi.get(self, "bool_value")

    @property
    @pulumi.getter(name="durationValue")
    def duration_value(self) -> str:
        """
        Contains value if the data is of duration type.
        """
        return pulumi.get(self, "duration_value")

    @property
    @pulumi.getter(name="floatValue")
    def float_value(self) -> float:
        """
        Contains value if the data is of float type.
        """
        return pulumi.get(self, "float_value")

    @property
    @pulumi.getter(name="int64Value")
    def int64_value(self) -> str:
        """
        Contains value if the data is of int64 type.
        """
        return pulumi.get(self, "int64_value")

    @property
    @pulumi.getter(name="javaClassValue")
    def java_class_value(self) -> str:
        """
        Contains value if the data is of java class type.
        """
        return pulumi.get(self, "java_class_value")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key identifying the display data. This is intended to be used as a label for the display data when viewed in a dax monitoring system.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        An optional label to display in a dax UI for the element.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace for the key. This is usually a class name or programming language namespace (i.e. python module) which defines the display data. This allows a dax monitoring system to specially handle the data and perform custom rendering.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="shortStrValue")
    def short_str_value(self) -> str:
        """
        A possible additional shorter value to display. For example a java_class_name_value of com.mypackage.MyDoFn will be stored with MyDoFn as the short_str_value and com.mypackage.MyDoFn as the java_class_name value. short_str_value can be displayed and java_class_name_value will be displayed as a tooltip.
        """
        return pulumi.get(self, "short_str_value")

    @property
    @pulumi.getter(name="strValue")
    def str_value(self) -> str:
        """
        Contains value if the data is of string type.
        """
        return pulumi.get(self, "str_value")

    @property
    @pulumi.getter(name="timestampValue")
    def timestamp_value(self) -> str:
        """
        Contains value if the data is of timestamp type.
        """
        return pulumi.get(self, "timestamp_value")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        An optional full URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class EnvironmentResponse(dict):
    """
    Describes the environment in which a Dataflow Job runs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterManagerApiService":
            suggest = "cluster_manager_api_service"
        elif key == "debugOptions":
            suggest = "debug_options"
        elif key == "flexResourceSchedulingGoal":
            suggest = "flex_resource_scheduling_goal"
        elif key == "internalExperiments":
            suggest = "internal_experiments"
        elif key == "sdkPipelineOptions":
            suggest = "sdk_pipeline_options"
        elif key == "serviceAccountEmail":
            suggest = "service_account_email"
        elif key == "serviceKmsKeyName":
            suggest = "service_kms_key_name"
        elif key == "serviceOptions":
            suggest = "service_options"
        elif key == "shuffleMode":
            suggest = "shuffle_mode"
        elif key == "tempStoragePrefix":
            suggest = "temp_storage_prefix"
        elif key == "userAgent":
            suggest = "user_agent"
        elif key == "workerPools":
            suggest = "worker_pools"
        elif key == "workerRegion":
            suggest = "worker_region"
        elif key == "workerZone":
            suggest = "worker_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_manager_api_service: str,
                 dataset: str,
                 debug_options: 'outputs.DebugOptionsResponse',
                 experiments: Sequence[str],
                 flex_resource_scheduling_goal: str,
                 internal_experiments: Mapping[str, str],
                 sdk_pipeline_options: Mapping[str, str],
                 service_account_email: str,
                 service_kms_key_name: str,
                 service_options: Sequence[str],
                 shuffle_mode: str,
                 temp_storage_prefix: str,
                 user_agent: Mapping[str, str],
                 version: Mapping[str, str],
                 worker_pools: Sequence['outputs.WorkerPoolResponse'],
                 worker_region: str,
                 worker_zone: str):
        """
        Describes the environment in which a Dataflow Job runs.
        :param str cluster_manager_api_service: The type of cluster manager API to use. If unknown or unspecified, the service will attempt to choose a reasonable default. This should be in the form of the API service name, e.g. "compute.googleapis.com".
        :param str dataset: The dataset for the current project where various workflow related tables are stored. The supported resource type is: Google BigQuery: bigquery.googleapis.com/{dataset}
        :param 'DebugOptionsResponse' debug_options: Any debugging options to be supplied to the job.
        :param Sequence[str] experiments: The list of experiments to enable. This field should be used for SDK related experiments and not for service related experiments. The proper field for service related experiments is service_options. For more details see the rationale at go/user-specified-service-options.
        :param str flex_resource_scheduling_goal: Which Flexible Resource Scheduling mode to run in.
        :param Mapping[str, str] internal_experiments: Experimental settings.
        :param Mapping[str, str] sdk_pipeline_options: The Cloud Dataflow SDK pipeline options specified by the user. These options are passed through the service and are used to recreate the SDK pipeline options on the worker in a language agnostic and platform independent way.
        :param str service_account_email: Identity to run virtual machines as. Defaults to the default account.
        :param str service_kms_key_name: If set, contains the Cloud KMS key identifier used to encrypt data at rest, AKA a Customer Managed Encryption Key (CMEK). Format: projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
        :param Sequence[str] service_options: The list of service options to enable. This field should be used for service related experiments only. These experiments, when graduating to GA, should be replaced by dedicated fields or become default (i.e. always on). For more details see the rationale at go/user-specified-service-options.
        :param str shuffle_mode: The shuffle mode used for the job.
        :param str temp_storage_prefix: The prefix of the resources the system should use for temporary storage. The system will append the suffix "/temp-{JOBNAME} to this resource prefix, where {JOBNAME} is the value of the job_name field. The resulting bucket and object prefix is used as the prefix of the resources used to store temporary data needed during the job execution. NOTE: This will override the value in taskrunner_settings. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param Mapping[str, str] user_agent: A description of the process that generated the request.
        :param Mapping[str, str] version: A structure describing which components and their versions of the service are required in order to run the job.
        :param Sequence['WorkerPoolResponse'] worker_pools: The worker pools. At least one "harness" worker pool must be specified in order for the job to have workers.
        :param str worker_region: The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        :param str worker_zone: The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity.
        """
        pulumi.set(__self__, "cluster_manager_api_service", cluster_manager_api_service)
        pulumi.set(__self__, "dataset", dataset)
        pulumi.set(__self__, "debug_options", debug_options)
        pulumi.set(__self__, "experiments", experiments)
        pulumi.set(__self__, "flex_resource_scheduling_goal", flex_resource_scheduling_goal)
        pulumi.set(__self__, "internal_experiments", internal_experiments)
        pulumi.set(__self__, "sdk_pipeline_options", sdk_pipeline_options)
        pulumi.set(__self__, "service_account_email", service_account_email)
        pulumi.set(__self__, "service_kms_key_name", service_kms_key_name)
        pulumi.set(__self__, "service_options", service_options)
        pulumi.set(__self__, "shuffle_mode", shuffle_mode)
        pulumi.set(__self__, "temp_storage_prefix", temp_storage_prefix)
        pulumi.set(__self__, "user_agent", user_agent)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "worker_pools", worker_pools)
        pulumi.set(__self__, "worker_region", worker_region)
        pulumi.set(__self__, "worker_zone", worker_zone)

    @property
    @pulumi.getter(name="clusterManagerApiService")
    def cluster_manager_api_service(self) -> str:
        """
        The type of cluster manager API to use. If unknown or unspecified, the service will attempt to choose a reasonable default. This should be in the form of the API service name, e.g. "compute.googleapis.com".
        """
        return pulumi.get(self, "cluster_manager_api_service")

    @property
    @pulumi.getter
    def dataset(self) -> str:
        """
        The dataset for the current project where various workflow related tables are stored. The supported resource type is: Google BigQuery: bigquery.googleapis.com/{dataset}
        """
        return pulumi.get(self, "dataset")

    @property
    @pulumi.getter(name="debugOptions")
    def debug_options(self) -> 'outputs.DebugOptionsResponse':
        """
        Any debugging options to be supplied to the job.
        """
        return pulumi.get(self, "debug_options")

    @property
    @pulumi.getter
    def experiments(self) -> Sequence[str]:
        """
        The list of experiments to enable. This field should be used for SDK related experiments and not for service related experiments. The proper field for service related experiments is service_options. For more details see the rationale at go/user-specified-service-options.
        """
        return pulumi.get(self, "experiments")

    @property
    @pulumi.getter(name="flexResourceSchedulingGoal")
    def flex_resource_scheduling_goal(self) -> str:
        """
        Which Flexible Resource Scheduling mode to run in.
        """
        return pulumi.get(self, "flex_resource_scheduling_goal")

    @property
    @pulumi.getter(name="internalExperiments")
    def internal_experiments(self) -> Mapping[str, str]:
        """
        Experimental settings.
        """
        return pulumi.get(self, "internal_experiments")

    @property
    @pulumi.getter(name="sdkPipelineOptions")
    def sdk_pipeline_options(self) -> Mapping[str, str]:
        """
        The Cloud Dataflow SDK pipeline options specified by the user. These options are passed through the service and are used to recreate the SDK pipeline options on the worker in a language agnostic and platform independent way.
        """
        return pulumi.get(self, "sdk_pipeline_options")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> str:
        """
        Identity to run virtual machines as. Defaults to the default account.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter(name="serviceKmsKeyName")
    def service_kms_key_name(self) -> str:
        """
        If set, contains the Cloud KMS key identifier used to encrypt data at rest, AKA a Customer Managed Encryption Key (CMEK). Format: projects/PROJECT_ID/locations/LOCATION/keyRings/KEY_RING/cryptoKeys/KEY
        """
        return pulumi.get(self, "service_kms_key_name")

    @property
    @pulumi.getter(name="serviceOptions")
    def service_options(self) -> Sequence[str]:
        """
        The list of service options to enable. This field should be used for service related experiments only. These experiments, when graduating to GA, should be replaced by dedicated fields or become default (i.e. always on). For more details see the rationale at go/user-specified-service-options.
        """
        return pulumi.get(self, "service_options")

    @property
    @pulumi.getter(name="shuffleMode")
    def shuffle_mode(self) -> str:
        """
        The shuffle mode used for the job.
        """
        return pulumi.get(self, "shuffle_mode")

    @property
    @pulumi.getter(name="tempStoragePrefix")
    def temp_storage_prefix(self) -> str:
        """
        The prefix of the resources the system should use for temporary storage. The system will append the suffix "/temp-{JOBNAME} to this resource prefix, where {JOBNAME} is the value of the job_name field. The resulting bucket and object prefix is used as the prefix of the resources used to store temporary data needed during the job execution. NOTE: This will override the value in taskrunner_settings. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "temp_storage_prefix")

    @property
    @pulumi.getter(name="userAgent")
    def user_agent(self) -> Mapping[str, str]:
        """
        A description of the process that generated the request.
        """
        return pulumi.get(self, "user_agent")

    @property
    @pulumi.getter
    def version(self) -> Mapping[str, str]:
        """
        A structure describing which components and their versions of the service are required in order to run the job.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="workerPools")
    def worker_pools(self) -> Sequence['outputs.WorkerPoolResponse']:
        """
        The worker pools. At least one "harness" worker pool must be specified in order for the job to have workers.
        """
        return pulumi.get(self, "worker_pools")

    @property
    @pulumi.getter(name="workerRegion")
    def worker_region(self) -> str:
        """
        The Compute Engine region (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1". Mutually exclusive with worker_zone. If neither worker_region nor worker_zone is specified, default to the control plane's region.
        """
        return pulumi.get(self, "worker_region")

    @property
    @pulumi.getter(name="workerZone")
    def worker_zone(self) -> str:
        """
        The Compute Engine zone (https://cloud.google.com/compute/docs/regions-zones/regions-zones) in which worker processing should occur, e.g. "us-west1-a". Mutually exclusive with worker_region. If neither worker_region nor worker_zone is specified, a zone in the control plane's region is chosen based on available capacity.
        """
        return pulumi.get(self, "worker_zone")


@pulumi.output_type
class ExecutionStageStateResponse(dict):
    """
    A message describing the state of a particular execution stage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentStateTime":
            suggest = "current_state_time"
        elif key == "executionStageName":
            suggest = "execution_stage_name"
        elif key == "executionStageState":
            suggest = "execution_stage_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecutionStageStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecutionStageStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecutionStageStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_state_time: str,
                 execution_stage_name: str,
                 execution_stage_state: str):
        """
        A message describing the state of a particular execution stage.
        :param str current_state_time: The time at which the stage transitioned to this state.
        :param str execution_stage_name: The name of the execution stage.
        :param str execution_stage_state: Executions stage states allow the same set of values as JobState.
        """
        pulumi.set(__self__, "current_state_time", current_state_time)
        pulumi.set(__self__, "execution_stage_name", execution_stage_name)
        pulumi.set(__self__, "execution_stage_state", execution_stage_state)

    @property
    @pulumi.getter(name="currentStateTime")
    def current_state_time(self) -> str:
        """
        The time at which the stage transitioned to this state.
        """
        return pulumi.get(self, "current_state_time")

    @property
    @pulumi.getter(name="executionStageName")
    def execution_stage_name(self) -> str:
        """
        The name of the execution stage.
        """
        return pulumi.get(self, "execution_stage_name")

    @property
    @pulumi.getter(name="executionStageState")
    def execution_stage_state(self) -> str:
        """
        Executions stage states allow the same set of values as JobState.
        """
        return pulumi.get(self, "execution_stage_state")


@pulumi.output_type
class ExecutionStageSummaryResponse(dict):
    """
    Description of the composing transforms, names/ids, and input/outputs of a stage of execution. Some composing transforms and sources may have been generated by the Dataflow service during execution planning.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "componentSource":
            suggest = "component_source"
        elif key == "componentTransform":
            suggest = "component_transform"
        elif key == "inputSource":
            suggest = "input_source"
        elif key == "outputSource":
            suggest = "output_source"
        elif key == "prerequisiteStage":
            suggest = "prerequisite_stage"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecutionStageSummaryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecutionStageSummaryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecutionStageSummaryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component_source: Sequence['outputs.ComponentSourceResponse'],
                 component_transform: Sequence['outputs.ComponentTransformResponse'],
                 input_source: Sequence['outputs.StageSourceResponse'],
                 kind: str,
                 name: str,
                 output_source: Sequence['outputs.StageSourceResponse'],
                 prerequisite_stage: Sequence[str]):
        """
        Description of the composing transforms, names/ids, and input/outputs of a stage of execution. Some composing transforms and sources may have been generated by the Dataflow service during execution planning.
        :param Sequence['ComponentSourceResponse'] component_source: Collections produced and consumed by component transforms of this stage.
        :param Sequence['ComponentTransformResponse'] component_transform: Transforms that comprise this execution stage.
        :param Sequence['StageSourceResponse'] input_source: Input sources for this stage.
        :param str kind: Type of transform this stage is executing.
        :param str name: Dataflow service generated name for this stage.
        :param Sequence['StageSourceResponse'] output_source: Output sources for this stage.
        :param Sequence[str] prerequisite_stage: Other stages that must complete before this stage can run.
        """
        pulumi.set(__self__, "component_source", component_source)
        pulumi.set(__self__, "component_transform", component_transform)
        pulumi.set(__self__, "input_source", input_source)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "output_source", output_source)
        pulumi.set(__self__, "prerequisite_stage", prerequisite_stage)

    @property
    @pulumi.getter(name="componentSource")
    def component_source(self) -> Sequence['outputs.ComponentSourceResponse']:
        """
        Collections produced and consumed by component transforms of this stage.
        """
        return pulumi.get(self, "component_source")

    @property
    @pulumi.getter(name="componentTransform")
    def component_transform(self) -> Sequence['outputs.ComponentTransformResponse']:
        """
        Transforms that comprise this execution stage.
        """
        return pulumi.get(self, "component_transform")

    @property
    @pulumi.getter(name="inputSource")
    def input_source(self) -> Sequence['outputs.StageSourceResponse']:
        """
        Input sources for this stage.
        """
        return pulumi.get(self, "input_source")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of transform this stage is executing.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Dataflow service generated name for this stage.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputSource")
    def output_source(self) -> Sequence['outputs.StageSourceResponse']:
        """
        Output sources for this stage.
        """
        return pulumi.get(self, "output_source")

    @property
    @pulumi.getter(name="prerequisiteStage")
    def prerequisite_stage(self) -> Sequence[str]:
        """
        Other stages that must complete before this stage can run.
        """
        return pulumi.get(self, "prerequisite_stage")


@pulumi.output_type
class FileIODetailsResponse(dict):
    """
    Metadata for a File connector used by the job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePattern":
            suggest = "file_pattern"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileIODetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileIODetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileIODetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_pattern: str):
        """
        Metadata for a File connector used by the job.
        :param str file_pattern: File Pattern used to access files by the connector.
        """
        pulumi.set(__self__, "file_pattern", file_pattern)

    @property
    @pulumi.getter(name="filePattern")
    def file_pattern(self) -> str:
        """
        File Pattern used to access files by the connector.
        """
        return pulumi.get(self, "file_pattern")


@pulumi.output_type
class JobMetadataResponse(dict):
    """
    Metadata available primarily for filtering jobs. Will be included in the ListJob response and Job SUMMARY view.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigTableDetails":
            suggest = "big_table_details"
        elif key == "bigqueryDetails":
            suggest = "bigquery_details"
        elif key == "datastoreDetails":
            suggest = "datastore_details"
        elif key == "fileDetails":
            suggest = "file_details"
        elif key == "pubsubDetails":
            suggest = "pubsub_details"
        elif key == "sdkVersion":
            suggest = "sdk_version"
        elif key == "spannerDetails":
            suggest = "spanner_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 big_table_details: Sequence['outputs.BigTableIODetailsResponse'],
                 bigquery_details: Sequence['outputs.BigQueryIODetailsResponse'],
                 datastore_details: Sequence['outputs.DatastoreIODetailsResponse'],
                 file_details: Sequence['outputs.FileIODetailsResponse'],
                 pubsub_details: Sequence['outputs.PubSubIODetailsResponse'],
                 sdk_version: 'outputs.SdkVersionResponse',
                 spanner_details: Sequence['outputs.SpannerIODetailsResponse']):
        """
        Metadata available primarily for filtering jobs. Will be included in the ListJob response and Job SUMMARY view.
        :param Sequence['BigTableIODetailsResponse'] big_table_details: Identification of a Cloud BigTable source used in the Dataflow job.
        :param Sequence['BigQueryIODetailsResponse'] bigquery_details: Identification of a BigQuery source used in the Dataflow job.
        :param Sequence['DatastoreIODetailsResponse'] datastore_details: Identification of a Datastore source used in the Dataflow job.
        :param Sequence['FileIODetailsResponse'] file_details: Identification of a File source used in the Dataflow job.
        :param Sequence['PubSubIODetailsResponse'] pubsub_details: Identification of a PubSub source used in the Dataflow job.
        :param 'SdkVersionResponse' sdk_version: The SDK version used to run the job.
        :param Sequence['SpannerIODetailsResponse'] spanner_details: Identification of a Spanner source used in the Dataflow job.
        """
        pulumi.set(__self__, "big_table_details", big_table_details)
        pulumi.set(__self__, "bigquery_details", bigquery_details)
        pulumi.set(__self__, "datastore_details", datastore_details)
        pulumi.set(__self__, "file_details", file_details)
        pulumi.set(__self__, "pubsub_details", pubsub_details)
        pulumi.set(__self__, "sdk_version", sdk_version)
        pulumi.set(__self__, "spanner_details", spanner_details)

    @property
    @pulumi.getter(name="bigTableDetails")
    def big_table_details(self) -> Sequence['outputs.BigTableIODetailsResponse']:
        """
        Identification of a Cloud BigTable source used in the Dataflow job.
        """
        return pulumi.get(self, "big_table_details")

    @property
    @pulumi.getter(name="bigqueryDetails")
    def bigquery_details(self) -> Sequence['outputs.BigQueryIODetailsResponse']:
        """
        Identification of a BigQuery source used in the Dataflow job.
        """
        return pulumi.get(self, "bigquery_details")

    @property
    @pulumi.getter(name="datastoreDetails")
    def datastore_details(self) -> Sequence['outputs.DatastoreIODetailsResponse']:
        """
        Identification of a Datastore source used in the Dataflow job.
        """
        return pulumi.get(self, "datastore_details")

    @property
    @pulumi.getter(name="fileDetails")
    def file_details(self) -> Sequence['outputs.FileIODetailsResponse']:
        """
        Identification of a File source used in the Dataflow job.
        """
        return pulumi.get(self, "file_details")

    @property
    @pulumi.getter(name="pubsubDetails")
    def pubsub_details(self) -> Sequence['outputs.PubSubIODetailsResponse']:
        """
        Identification of a PubSub source used in the Dataflow job.
        """
        return pulumi.get(self, "pubsub_details")

    @property
    @pulumi.getter(name="sdkVersion")
    def sdk_version(self) -> 'outputs.SdkVersionResponse':
        """
        The SDK version used to run the job.
        """
        return pulumi.get(self, "sdk_version")

    @property
    @pulumi.getter(name="spannerDetails")
    def spanner_details(self) -> Sequence['outputs.SpannerIODetailsResponse']:
        """
        Identification of a Spanner source used in the Dataflow job.
        """
        return pulumi.get(self, "spanner_details")


@pulumi.output_type
class PackageResponse(dict):
    """
    The packages that must be installed in order for a worker to run the steps of the Cloud Dataflow job that will be assigned to its worker pool. This is the mechanism by which the Cloud Dataflow SDK causes code to be loaded onto the workers. For example, the Cloud Dataflow Java SDK might use this to install jars containing the user's code and all of the various dependencies (libraries, data files, etc.) required in order for that code to run.
    """
    def __init__(__self__, *,
                 location: str,
                 name: str):
        """
        The packages that must be installed in order for a worker to run the steps of the Cloud Dataflow job that will be assigned to its worker pool. This is the mechanism by which the Cloud Dataflow SDK causes code to be loaded onto the workers. For example, the Cloud Dataflow Java SDK might use this to install jars containing the user's code and all of the various dependencies (libraries, data files, etc.) required in order for that code to run.
        :param str location: The resource to read the package from. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket} bucket.storage.googleapis.com/
        :param str name: The name of the package.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        The resource to read the package from. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket} bucket.storage.googleapis.com/
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the package.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ParameterMetadataResponse(dict):
    """
    Metadata for a specific parameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "helpText":
            suggest = "help_text"
        elif key == "isOptional":
            suggest = "is_optional"
        elif key == "paramType":
            suggest = "param_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParameterMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParameterMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParameterMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 help_text: str,
                 is_optional: bool,
                 label: str,
                 name: str,
                 param_type: str,
                 regexes: Sequence[str]):
        """
        Metadata for a specific parameter.
        :param str help_text: Required. The help text to display for the parameter.
        :param bool is_optional: Optional. Whether the parameter is optional. Defaults to false.
        :param str label: Required. The label to display for the parameter.
        :param str name: Required. The name of the parameter.
        :param str param_type: Optional. The type of the parameter. Used for selecting input picker.
        :param Sequence[str] regexes: Optional. Regexes that the parameter must match.
        """
        pulumi.set(__self__, "help_text", help_text)
        pulumi.set(__self__, "is_optional", is_optional)
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "param_type", param_type)
        pulumi.set(__self__, "regexes", regexes)

    @property
    @pulumi.getter(name="helpText")
    def help_text(self) -> str:
        """
        Required. The help text to display for the parameter.
        """
        return pulumi.get(self, "help_text")

    @property
    @pulumi.getter(name="isOptional")
    def is_optional(self) -> bool:
        """
        Optional. Whether the parameter is optional. Defaults to false.
        """
        return pulumi.get(self, "is_optional")

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Required. The label to display for the parameter.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the parameter.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="paramType")
    def param_type(self) -> str:
        """
        Optional. The type of the parameter. Used for selecting input picker.
        """
        return pulumi.get(self, "param_type")

    @property
    @pulumi.getter
    def regexes(self) -> Sequence[str]:
        """
        Optional. Regexes that the parameter must match.
        """
        return pulumi.get(self, "regexes")


@pulumi.output_type
class PipelineDescriptionResponse(dict):
    """
    A descriptive representation of submitted pipeline as well as the executed form. This data is provided by the Dataflow service for ease of visualizing the pipeline and interpreting Dataflow provided metrics.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayData":
            suggest = "display_data"
        elif key == "executionPipelineStage":
            suggest = "execution_pipeline_stage"
        elif key == "originalPipelineTransform":
            suggest = "original_pipeline_transform"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PipelineDescriptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PipelineDescriptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PipelineDescriptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_data: Sequence['outputs.DisplayDataResponse'],
                 execution_pipeline_stage: Sequence['outputs.ExecutionStageSummaryResponse'],
                 original_pipeline_transform: Sequence['outputs.TransformSummaryResponse']):
        """
        A descriptive representation of submitted pipeline as well as the executed form. This data is provided by the Dataflow service for ease of visualizing the pipeline and interpreting Dataflow provided metrics.
        :param Sequence['DisplayDataResponse'] display_data: Pipeline level display data.
        :param Sequence['ExecutionStageSummaryResponse'] execution_pipeline_stage: Description of each stage of execution of the pipeline.
        :param Sequence['TransformSummaryResponse'] original_pipeline_transform: Description of each transform in the pipeline and collections between them.
        """
        pulumi.set(__self__, "display_data", display_data)
        pulumi.set(__self__, "execution_pipeline_stage", execution_pipeline_stage)
        pulumi.set(__self__, "original_pipeline_transform", original_pipeline_transform)

    @property
    @pulumi.getter(name="displayData")
    def display_data(self) -> Sequence['outputs.DisplayDataResponse']:
        """
        Pipeline level display data.
        """
        return pulumi.get(self, "display_data")

    @property
    @pulumi.getter(name="executionPipelineStage")
    def execution_pipeline_stage(self) -> Sequence['outputs.ExecutionStageSummaryResponse']:
        """
        Description of each stage of execution of the pipeline.
        """
        return pulumi.get(self, "execution_pipeline_stage")

    @property
    @pulumi.getter(name="originalPipelineTransform")
    def original_pipeline_transform(self) -> Sequence['outputs.TransformSummaryResponse']:
        """
        Description of each transform in the pipeline and collections between them.
        """
        return pulumi.get(self, "original_pipeline_transform")


@pulumi.output_type
class PubSubIODetailsResponse(dict):
    """
    Metadata for a Pub/Sub connector used by the job.
    """
    def __init__(__self__, *,
                 subscription: str,
                 topic: str):
        """
        Metadata for a Pub/Sub connector used by the job.
        :param str subscription: Subscription used in the connection.
        :param str topic: Topic accessed in the connection.
        """
        pulumi.set(__self__, "subscription", subscription)
        pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def subscription(self) -> str:
        """
        Subscription used in the connection.
        """
        return pulumi.get(self, "subscription")

    @property
    @pulumi.getter
    def topic(self) -> str:
        """
        Topic accessed in the connection.
        """
        return pulumi.get(self, "topic")


@pulumi.output_type
class RuntimeMetadataResponse(dict):
    """
    RuntimeMetadata describing a runtime environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sdkInfo":
            suggest = "sdk_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameters: Sequence['outputs.ParameterMetadataResponse'],
                 sdk_info: 'outputs.SDKInfoResponse'):
        """
        RuntimeMetadata describing a runtime environment.
        :param Sequence['ParameterMetadataResponse'] parameters: The parameters for the template.
        :param 'SDKInfoResponse' sdk_info: SDK Info for the template.
        """
        pulumi.set(__self__, "parameters", parameters)
        pulumi.set(__self__, "sdk_info", sdk_info)

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.ParameterMetadataResponse']:
        """
        The parameters for the template.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="sdkInfo")
    def sdk_info(self) -> 'outputs.SDKInfoResponse':
        """
        SDK Info for the template.
        """
        return pulumi.get(self, "sdk_info")


@pulumi.output_type
class SDKInfoResponse(dict):
    """
    SDK Information.
    """
    def __init__(__self__, *,
                 language: str,
                 version: str):
        """
        SDK Information.
        :param str language: Required. The SDK Language.
        :param str version: Optional. The SDK version.
        """
        pulumi.set(__self__, "language", language)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def language(self) -> str:
        """
        Required. The SDK Language.
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Optional. The SDK version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class SdkHarnessContainerImageResponse(dict):
    """
    Defines a SDK harness container for executing Dataflow pipelines.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImage":
            suggest = "container_image"
        elif key == "environmentId":
            suggest = "environment_id"
        elif key == "useSingleCorePerContainer":
            suggest = "use_single_core_per_container"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SdkHarnessContainerImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SdkHarnessContainerImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SdkHarnessContainerImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_image: str,
                 environment_id: str,
                 use_single_core_per_container: bool):
        """
        Defines a SDK harness container for executing Dataflow pipelines.
        :param str container_image: A docker container image that resides in Google Container Registry.
        :param str environment_id: Environment ID for the Beam runner API proto Environment that corresponds to the current SDK Harness.
        :param bool use_single_core_per_container: If true, recommends the Dataflow service to use only one core per SDK container instance with this image. If false (or unset) recommends using more than one core per SDK container instance with this image for efficiency. Note that Dataflow service may choose to override this property if needed.
        """
        pulumi.set(__self__, "container_image", container_image)
        pulumi.set(__self__, "environment_id", environment_id)
        pulumi.set(__self__, "use_single_core_per_container", use_single_core_per_container)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> str:
        """
        A docker container image that resides in Google Container Registry.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter(name="environmentId")
    def environment_id(self) -> str:
        """
        Environment ID for the Beam runner API proto Environment that corresponds to the current SDK Harness.
        """
        return pulumi.get(self, "environment_id")

    @property
    @pulumi.getter(name="useSingleCorePerContainer")
    def use_single_core_per_container(self) -> bool:
        """
        If true, recommends the Dataflow service to use only one core per SDK container instance with this image. If false (or unset) recommends using more than one core per SDK container instance with this image for efficiency. Note that Dataflow service may choose to override this property if needed.
        """
        return pulumi.get(self, "use_single_core_per_container")


@pulumi.output_type
class SdkVersionResponse(dict):
    """
    The version of the SDK used to run the job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sdkSupportStatus":
            suggest = "sdk_support_status"
        elif key == "versionDisplayName":
            suggest = "version_display_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SdkVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SdkVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SdkVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 sdk_support_status: str,
                 version: str,
                 version_display_name: str):
        """
        The version of the SDK used to run the job.
        :param str sdk_support_status: The support status for this SDK version.
        :param str version: The version of the SDK used to run the job.
        :param str version_display_name: A readable string describing the version of the SDK.
        """
        pulumi.set(__self__, "sdk_support_status", sdk_support_status)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "version_display_name", version_display_name)

    @property
    @pulumi.getter(name="sdkSupportStatus")
    def sdk_support_status(self) -> str:
        """
        The support status for this SDK version.
        """
        return pulumi.get(self, "sdk_support_status")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the SDK used to run the job.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="versionDisplayName")
    def version_display_name(self) -> str:
        """
        A readable string describing the version of the SDK.
        """
        return pulumi.get(self, "version_display_name")


@pulumi.output_type
class SpannerIODetailsResponse(dict):
    """
    Metadata for a Spanner connector used by the job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "databaseId":
            suggest = "database_id"
        elif key == "instanceId":
            suggest = "instance_id"
        elif key == "projectId":
            suggest = "project_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpannerIODetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpannerIODetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpannerIODetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 database_id: str,
                 instance_id: str,
                 project_id: str):
        """
        Metadata for a Spanner connector used by the job.
        :param str database_id: DatabaseId accessed in the connection.
        :param str instance_id: InstanceId accessed in the connection.
        :param str project_id: ProjectId accessed in the connection.
        """
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project_id", project_id)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> str:
        """
        DatabaseId accessed in the connection.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        InstanceId accessed in the connection.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        ProjectId accessed in the connection.
        """
        return pulumi.get(self, "project_id")


@pulumi.output_type
class StageSourceResponse(dict):
    """
    Description of an input or output of an execution stage.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "originalTransformOrCollection":
            suggest = "original_transform_or_collection"
        elif key == "sizeBytes":
            suggest = "size_bytes"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StageSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StageSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StageSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 original_transform_or_collection: str,
                 size_bytes: str,
                 user_name: str):
        """
        Description of an input or output of an execution stage.
        :param str name: Dataflow service generated name for this source.
        :param str original_transform_or_collection: User name for the original user transform or collection with which this source is most closely associated.
        :param str size_bytes: Size of the source, if measurable.
        :param str user_name: Human-readable name for this source; may be user or system generated.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "original_transform_or_collection", original_transform_or_collection)
        pulumi.set(__self__, "size_bytes", size_bytes)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Dataflow service generated name for this source.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="originalTransformOrCollection")
    def original_transform_or_collection(self) -> str:
        """
        User name for the original user transform or collection with which this source is most closely associated.
        """
        return pulumi.get(self, "original_transform_or_collection")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> str:
        """
        Size of the source, if measurable.
        """
        return pulumi.get(self, "size_bytes")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        Human-readable name for this source; may be user or system generated.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class StepResponse(dict):
    """
    Defines a particular step within a Cloud Dataflow job. A job consists of multiple steps, each of which performs some specific operation as part of the overall job. Data is typically passed from one step to another as part of the job. Here's an example of a sequence of steps which together implement a Map-Reduce job: * Read a collection of data from some source, parsing the collection's elements. * Validate the elements. * Apply a user-defined function to map each element to some value and extract an element-specific key value. * Group elements with the same key into a single element with that key, transforming a multiply-keyed collection into a uniquely-keyed collection. * Write the elements out to some data sink. Note that the Cloud Dataflow service may be used to run many different types of jobs, not just Map-Reduce.
    """
    def __init__(__self__, *,
                 kind: str,
                 name: str,
                 properties: Mapping[str, str]):
        """
        Defines a particular step within a Cloud Dataflow job. A job consists of multiple steps, each of which performs some specific operation as part of the overall job. Data is typically passed from one step to another as part of the job. Here's an example of a sequence of steps which together implement a Map-Reduce job: * Read a collection of data from some source, parsing the collection's elements. * Validate the elements. * Apply a user-defined function to map each element to some value and extract an element-specific key value. * Group elements with the same key into a single element with that key, transforming a multiply-keyed collection into a uniquely-keyed collection. * Write the elements out to some data sink. Note that the Cloud Dataflow service may be used to run many different types of jobs, not just Map-Reduce.
        :param str kind: The kind of step in the Cloud Dataflow job.
        :param str name: The name that identifies the step. This must be unique for each step with respect to all other steps in the Cloud Dataflow job.
        :param Mapping[str, str] properties: Named properties associated with the step. Each kind of predefined step has its own required set of properties. Must be provided on Create. Only retrieved with JOB_VIEW_ALL.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of step in the Cloud Dataflow job.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name that identifies the step. This must be unique for each step with respect to all other steps in the Cloud Dataflow job.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Named properties associated with the step. Each kind of predefined step has its own required set of properties. Must be provided on Create. Only retrieved with JOB_VIEW_ALL.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class TaskRunnerSettingsResponse(dict):
    """
    Taskrunner configuration settings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseTaskDir":
            suggest = "base_task_dir"
        elif key == "baseUrl":
            suggest = "base_url"
        elif key == "commandlinesFileName":
            suggest = "commandlines_file_name"
        elif key == "continueOnException":
            suggest = "continue_on_exception"
        elif key == "dataflowApiVersion":
            suggest = "dataflow_api_version"
        elif key == "harnessCommand":
            suggest = "harness_command"
        elif key == "languageHint":
            suggest = "language_hint"
        elif key == "logDir":
            suggest = "log_dir"
        elif key == "logToSerialconsole":
            suggest = "log_to_serialconsole"
        elif key == "logUploadLocation":
            suggest = "log_upload_location"
        elif key == "oauthScopes":
            suggest = "oauth_scopes"
        elif key == "parallelWorkerSettings":
            suggest = "parallel_worker_settings"
        elif key == "streamingWorkerMainClass":
            suggest = "streaming_worker_main_class"
        elif key == "taskGroup":
            suggest = "task_group"
        elif key == "taskUser":
            suggest = "task_user"
        elif key == "tempStoragePrefix":
            suggest = "temp_storage_prefix"
        elif key == "vmId":
            suggest = "vm_id"
        elif key == "workflowFileName":
            suggest = "workflow_file_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TaskRunnerSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TaskRunnerSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TaskRunnerSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alsologtostderr: bool,
                 base_task_dir: str,
                 base_url: str,
                 commandlines_file_name: str,
                 continue_on_exception: bool,
                 dataflow_api_version: str,
                 harness_command: str,
                 language_hint: str,
                 log_dir: str,
                 log_to_serialconsole: bool,
                 log_upload_location: str,
                 oauth_scopes: Sequence[str],
                 parallel_worker_settings: 'outputs.WorkerSettingsResponse',
                 streaming_worker_main_class: str,
                 task_group: str,
                 task_user: str,
                 temp_storage_prefix: str,
                 vm_id: str,
                 workflow_file_name: str):
        """
        Taskrunner configuration settings.
        :param bool alsologtostderr: Whether to also send taskrunner log info to stderr.
        :param str base_task_dir: The location on the worker for task-specific subdirectories.
        :param str base_url: The base URL for the taskrunner to use when accessing Google Cloud APIs. When workers access Google Cloud APIs, they logically do so via relative URLs. If this field is specified, it supplies the base URL to use for resolving these relative URLs. The normative algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators". If not specified, the default value is "http://www.googleapis.com/"
        :param str commandlines_file_name: The file to store preprocessing commands in.
        :param bool continue_on_exception: Whether to continue taskrunner if an exception is hit.
        :param str dataflow_api_version: The API version of endpoint, e.g. "v1b3"
        :param str harness_command: The command to launch the worker harness.
        :param str language_hint: The suggested backend language.
        :param str log_dir: The directory on the VM to store logs.
        :param bool log_to_serialconsole: Whether to send taskrunner log info to Google Compute Engine VM serial console.
        :param str log_upload_location: Indicates where to put logs. If this is not specified, the logs will not be uploaded. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param Sequence[str] oauth_scopes: The OAuth2 scopes to be requested by the taskrunner in order to access the Cloud Dataflow API.
        :param 'WorkerSettingsResponse' parallel_worker_settings: The settings to pass to the parallel worker harness.
        :param str streaming_worker_main_class: The streaming worker main class name.
        :param str task_group: The UNIX group ID on the worker VM to use for tasks launched by taskrunner; e.g. "wheel".
        :param str task_user: The UNIX user ID on the worker VM to use for tasks launched by taskrunner; e.g. "root".
        :param str temp_storage_prefix: The prefix of the resources the taskrunner should use for temporary storage. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param str vm_id: The ID string of the VM.
        :param str workflow_file_name: The file to store the workflow in.
        """
        pulumi.set(__self__, "alsologtostderr", alsologtostderr)
        pulumi.set(__self__, "base_task_dir", base_task_dir)
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "commandlines_file_name", commandlines_file_name)
        pulumi.set(__self__, "continue_on_exception", continue_on_exception)
        pulumi.set(__self__, "dataflow_api_version", dataflow_api_version)
        pulumi.set(__self__, "harness_command", harness_command)
        pulumi.set(__self__, "language_hint", language_hint)
        pulumi.set(__self__, "log_dir", log_dir)
        pulumi.set(__self__, "log_to_serialconsole", log_to_serialconsole)
        pulumi.set(__self__, "log_upload_location", log_upload_location)
        pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        pulumi.set(__self__, "parallel_worker_settings", parallel_worker_settings)
        pulumi.set(__self__, "streaming_worker_main_class", streaming_worker_main_class)
        pulumi.set(__self__, "task_group", task_group)
        pulumi.set(__self__, "task_user", task_user)
        pulumi.set(__self__, "temp_storage_prefix", temp_storage_prefix)
        pulumi.set(__self__, "vm_id", vm_id)
        pulumi.set(__self__, "workflow_file_name", workflow_file_name)

    @property
    @pulumi.getter
    def alsologtostderr(self) -> bool:
        """
        Whether to also send taskrunner log info to stderr.
        """
        return pulumi.get(self, "alsologtostderr")

    @property
    @pulumi.getter(name="baseTaskDir")
    def base_task_dir(self) -> str:
        """
        The location on the worker for task-specific subdirectories.
        """
        return pulumi.get(self, "base_task_dir")

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The base URL for the taskrunner to use when accessing Google Cloud APIs. When workers access Google Cloud APIs, they logically do so via relative URLs. If this field is specified, it supplies the base URL to use for resolving these relative URLs. The normative algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators". If not specified, the default value is "http://www.googleapis.com/"
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="commandlinesFileName")
    def commandlines_file_name(self) -> str:
        """
        The file to store preprocessing commands in.
        """
        return pulumi.get(self, "commandlines_file_name")

    @property
    @pulumi.getter(name="continueOnException")
    def continue_on_exception(self) -> bool:
        """
        Whether to continue taskrunner if an exception is hit.
        """
        return pulumi.get(self, "continue_on_exception")

    @property
    @pulumi.getter(name="dataflowApiVersion")
    def dataflow_api_version(self) -> str:
        """
        The API version of endpoint, e.g. "v1b3"
        """
        return pulumi.get(self, "dataflow_api_version")

    @property
    @pulumi.getter(name="harnessCommand")
    def harness_command(self) -> str:
        """
        The command to launch the worker harness.
        """
        return pulumi.get(self, "harness_command")

    @property
    @pulumi.getter(name="languageHint")
    def language_hint(self) -> str:
        """
        The suggested backend language.
        """
        return pulumi.get(self, "language_hint")

    @property
    @pulumi.getter(name="logDir")
    def log_dir(self) -> str:
        """
        The directory on the VM to store logs.
        """
        return pulumi.get(self, "log_dir")

    @property
    @pulumi.getter(name="logToSerialconsole")
    def log_to_serialconsole(self) -> bool:
        """
        Whether to send taskrunner log info to Google Compute Engine VM serial console.
        """
        return pulumi.get(self, "log_to_serialconsole")

    @property
    @pulumi.getter(name="logUploadLocation")
    def log_upload_location(self) -> str:
        """
        Indicates where to put logs. If this is not specified, the logs will not be uploaded. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "log_upload_location")

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Sequence[str]:
        """
        The OAuth2 scopes to be requested by the taskrunner in order to access the Cloud Dataflow API.
        """
        return pulumi.get(self, "oauth_scopes")

    @property
    @pulumi.getter(name="parallelWorkerSettings")
    def parallel_worker_settings(self) -> 'outputs.WorkerSettingsResponse':
        """
        The settings to pass to the parallel worker harness.
        """
        return pulumi.get(self, "parallel_worker_settings")

    @property
    @pulumi.getter(name="streamingWorkerMainClass")
    def streaming_worker_main_class(self) -> str:
        """
        The streaming worker main class name.
        """
        return pulumi.get(self, "streaming_worker_main_class")

    @property
    @pulumi.getter(name="taskGroup")
    def task_group(self) -> str:
        """
        The UNIX group ID on the worker VM to use for tasks launched by taskrunner; e.g. "wheel".
        """
        return pulumi.get(self, "task_group")

    @property
    @pulumi.getter(name="taskUser")
    def task_user(self) -> str:
        """
        The UNIX user ID on the worker VM to use for tasks launched by taskrunner; e.g. "root".
        """
        return pulumi.get(self, "task_user")

    @property
    @pulumi.getter(name="tempStoragePrefix")
    def temp_storage_prefix(self) -> str:
        """
        The prefix of the resources the taskrunner should use for temporary storage. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "temp_storage_prefix")

    @property
    @pulumi.getter(name="vmId")
    def vm_id(self) -> str:
        """
        The ID string of the VM.
        """
        return pulumi.get(self, "vm_id")

    @property
    @pulumi.getter(name="workflowFileName")
    def workflow_file_name(self) -> str:
        """
        The file to store the workflow in.
        """
        return pulumi.get(self, "workflow_file_name")


@pulumi.output_type
class TemplateMetadataResponse(dict):
    """
    Metadata describing a template.
    """
    def __init__(__self__, *,
                 description: str,
                 name: str,
                 parameters: Sequence['outputs.ParameterMetadataResponse']):
        """
        Metadata describing a template.
        :param str description: Optional. A description of the template.
        :param str name: Required. The name of the template.
        :param Sequence['ParameterMetadataResponse'] parameters: The parameters for the template.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "parameters", parameters)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. A description of the template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the template.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def parameters(self) -> Sequence['outputs.ParameterMetadataResponse']:
        """
        The parameters for the template.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class TransformSummaryResponse(dict):
    """
    Description of the type, names/ids, and input/outputs for a transform.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayData":
            suggest = "display_data"
        elif key == "inputCollectionName":
            suggest = "input_collection_name"
        elif key == "outputCollectionName":
            suggest = "output_collection_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransformSummaryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransformSummaryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransformSummaryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_data: Sequence['outputs.DisplayDataResponse'],
                 input_collection_name: Sequence[str],
                 kind: str,
                 name: str,
                 output_collection_name: Sequence[str]):
        """
        Description of the type, names/ids, and input/outputs for a transform.
        :param Sequence['DisplayDataResponse'] display_data: Transform-specific display data.
        :param Sequence[str] input_collection_name: User names for all collection inputs to this transform.
        :param str kind: Type of transform.
        :param str name: User provided name for this transform instance.
        :param Sequence[str] output_collection_name: User names for all collection outputs to this transform.
        """
        pulumi.set(__self__, "display_data", display_data)
        pulumi.set(__self__, "input_collection_name", input_collection_name)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "output_collection_name", output_collection_name)

    @property
    @pulumi.getter(name="displayData")
    def display_data(self) -> Sequence['outputs.DisplayDataResponse']:
        """
        Transform-specific display data.
        """
        return pulumi.get(self, "display_data")

    @property
    @pulumi.getter(name="inputCollectionName")
    def input_collection_name(self) -> Sequence[str]:
        """
        User names for all collection inputs to this transform.
        """
        return pulumi.get(self, "input_collection_name")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Type of transform.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        User provided name for this transform instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="outputCollectionName")
    def output_collection_name(self) -> Sequence[str]:
        """
        User names for all collection outputs to this transform.
        """
        return pulumi.get(self, "output_collection_name")


@pulumi.output_type
class WorkerPoolResponse(dict):
    """
    Describes one particular pool of Cloud Dataflow workers to be instantiated by the Cloud Dataflow service in order to perform the computations required by a job. Note that a workflow job may use multiple pools, in order to match the various computational requirements of the various stages of the job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingSettings":
            suggest = "autoscaling_settings"
        elif key == "dataDisks":
            suggest = "data_disks"
        elif key == "defaultPackageSet":
            suggest = "default_package_set"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "diskSourceImage":
            suggest = "disk_source_image"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "numThreadsPerWorker":
            suggest = "num_threads_per_worker"
        elif key == "numWorkers":
            suggest = "num_workers"
        elif key == "onHostMaintenance":
            suggest = "on_host_maintenance"
        elif key == "poolArgs":
            suggest = "pool_args"
        elif key == "sdkHarnessContainerImages":
            suggest = "sdk_harness_container_images"
        elif key == "taskrunnerSettings":
            suggest = "taskrunner_settings"
        elif key == "teardownPolicy":
            suggest = "teardown_policy"
        elif key == "workerHarnessContainerImage":
            suggest = "worker_harness_container_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerPoolResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerPoolResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerPoolResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_settings: 'outputs.AutoscalingSettingsResponse',
                 data_disks: Sequence['outputs.DiskResponse'],
                 default_package_set: str,
                 disk_size_gb: int,
                 disk_source_image: str,
                 disk_type: str,
                 ip_configuration: str,
                 kind: str,
                 machine_type: str,
                 metadata: Mapping[str, str],
                 network: str,
                 num_threads_per_worker: int,
                 num_workers: int,
                 on_host_maintenance: str,
                 packages: Sequence['outputs.PackageResponse'],
                 pool_args: Mapping[str, str],
                 sdk_harness_container_images: Sequence['outputs.SdkHarnessContainerImageResponse'],
                 subnetwork: str,
                 taskrunner_settings: 'outputs.TaskRunnerSettingsResponse',
                 teardown_policy: str,
                 worker_harness_container_image: str,
                 zone: str):
        """
        Describes one particular pool of Cloud Dataflow workers to be instantiated by the Cloud Dataflow service in order to perform the computations required by a job. Note that a workflow job may use multiple pools, in order to match the various computational requirements of the various stages of the job.
        :param 'AutoscalingSettingsResponse' autoscaling_settings: Settings for autoscaling of this WorkerPool.
        :param Sequence['DiskResponse'] data_disks: Data disks that are used by a VM in this workflow.
        :param str default_package_set: The default package set to install. This allows the service to select a default set of packages which are useful to worker harnesses written in a particular language.
        :param int disk_size_gb: Size of root disk for VMs, in GB. If zero or unspecified, the service will attempt to choose a reasonable default.
        :param str disk_source_image: Fully qualified source image for disks.
        :param str disk_type: Type of root disk for VMs. If empty or unspecified, the service will attempt to choose a reasonable default.
        :param str ip_configuration: Configuration for VM IPs.
        :param str kind: The kind of the worker pool; currently only `harness` and `shuffle` are supported.
        :param str machine_type: Machine type (e.g. "n1-standard-1"). If empty or unspecified, the service will attempt to choose a reasonable default.
        :param Mapping[str, str] metadata: Metadata to set on the Google Compute Engine VMs.
        :param str network: Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        :param int num_threads_per_worker: The number of threads per worker harness. If empty or unspecified, the service will choose a number of threads (according to the number of cores on the selected machine type for batch, or 1 by convention for streaming).
        :param int num_workers: Number of Google Compute Engine workers in this pool needed to execute the job. If zero or unspecified, the service will attempt to choose a reasonable default.
        :param str on_host_maintenance: The action to take on host maintenance, as defined by the Google Compute Engine API.
        :param Sequence['PackageResponse'] packages: Packages to be installed on workers.
        :param Mapping[str, str] pool_args: Extra arguments for this worker pool.
        :param Sequence['SdkHarnessContainerImageResponse'] sdk_harness_container_images: Set of SDK harness containers needed to execute this pipeline. This will only be set in the Fn API path. For non-cross-language pipelines this should have only one entry. Cross-language pipelines will have two or more entries.
        :param str subnetwork: Subnetwork to which VMs will be assigned, if desired. Expected to be of the form "regions/REGION/subnetworks/SUBNETWORK".
        :param 'TaskRunnerSettingsResponse' taskrunner_settings: Settings passed through to Google Compute Engine workers when using the standard Dataflow task runner. Users should ignore this field.
        :param str teardown_policy: Sets the policy for determining when to turndown worker pool. Allowed values are: `TEARDOWN_ALWAYS`, `TEARDOWN_ON_SUCCESS`, and `TEARDOWN_NEVER`. `TEARDOWN_ALWAYS` means workers are always torn down regardless of whether the job succeeds. `TEARDOWN_ON_SUCCESS` means workers are torn down if the job succeeds. `TEARDOWN_NEVER` means the workers are never torn down. If the workers are not torn down by the service, they will continue to run and use Google Compute Engine VM resources in the user's project until they are explicitly terminated by the user. Because of this, Google recommends using the `TEARDOWN_ALWAYS` policy except for small, manually supervised test jobs. If unknown or unspecified, the service will attempt to choose a reasonable default.
        :param str worker_harness_container_image: Required. Docker container image that executes the Cloud Dataflow worker harness, residing in Google Container Registry. Deprecated for the Fn API path. Use sdk_harness_container_images instead.
        :param str zone: Zone to run the worker pools in. If empty or unspecified, the service will attempt to choose a reasonable default.
        """
        pulumi.set(__self__, "autoscaling_settings", autoscaling_settings)
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "default_package_set", default_package_set)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "disk_source_image", disk_source_image)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "ip_configuration", ip_configuration)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "num_threads_per_worker", num_threads_per_worker)
        pulumi.set(__self__, "num_workers", num_workers)
        pulumi.set(__self__, "on_host_maintenance", on_host_maintenance)
        pulumi.set(__self__, "packages", packages)
        pulumi.set(__self__, "pool_args", pool_args)
        pulumi.set(__self__, "sdk_harness_container_images", sdk_harness_container_images)
        pulumi.set(__self__, "subnetwork", subnetwork)
        pulumi.set(__self__, "taskrunner_settings", taskrunner_settings)
        pulumi.set(__self__, "teardown_policy", teardown_policy)
        pulumi.set(__self__, "worker_harness_container_image", worker_harness_container_image)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="autoscalingSettings")
    def autoscaling_settings(self) -> 'outputs.AutoscalingSettingsResponse':
        """
        Settings for autoscaling of this WorkerPool.
        """
        return pulumi.get(self, "autoscaling_settings")

    @property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.DiskResponse']:
        """
        Data disks that are used by a VM in this workflow.
        """
        return pulumi.get(self, "data_disks")

    @property
    @pulumi.getter(name="defaultPackageSet")
    def default_package_set(self) -> str:
        """
        The default package set to install. This allows the service to select a default set of packages which are useful to worker harnesses written in a particular language.
        """
        return pulumi.get(self, "default_package_set")

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> int:
        """
        Size of root disk for VMs, in GB. If zero or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="diskSourceImage")
    def disk_source_image(self) -> str:
        """
        Fully qualified source image for disks.
        """
        return pulumi.get(self, "disk_source_image")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        """
        Type of root disk for VMs. If empty or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> str:
        """
        Configuration for VM IPs.
        """
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of the worker pool; currently only `harness` and `shuffle` are supported.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        Machine type (e.g. "n1-standard-1"). If empty or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Metadata to set on the Google Compute Engine VMs.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def network(self) -> str:
        """
        Network to which VMs will be assigned. If empty or unspecified, the service will use the network "default".
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="numThreadsPerWorker")
    def num_threads_per_worker(self) -> int:
        """
        The number of threads per worker harness. If empty or unspecified, the service will choose a number of threads (according to the number of cores on the selected machine type for batch, or 1 by convention for streaming).
        """
        return pulumi.get(self, "num_threads_per_worker")

    @property
    @pulumi.getter(name="numWorkers")
    def num_workers(self) -> int:
        """
        Number of Google Compute Engine workers in this pool needed to execute the job. If zero or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "num_workers")

    @property
    @pulumi.getter(name="onHostMaintenance")
    def on_host_maintenance(self) -> str:
        """
        The action to take on host maintenance, as defined by the Google Compute Engine API.
        """
        return pulumi.get(self, "on_host_maintenance")

    @property
    @pulumi.getter
    def packages(self) -> Sequence['outputs.PackageResponse']:
        """
        Packages to be installed on workers.
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter(name="poolArgs")
    def pool_args(self) -> Mapping[str, str]:
        """
        Extra arguments for this worker pool.
        """
        return pulumi.get(self, "pool_args")

    @property
    @pulumi.getter(name="sdkHarnessContainerImages")
    def sdk_harness_container_images(self) -> Sequence['outputs.SdkHarnessContainerImageResponse']:
        """
        Set of SDK harness containers needed to execute this pipeline. This will only be set in the Fn API path. For non-cross-language pipelines this should have only one entry. Cross-language pipelines will have two or more entries.
        """
        return pulumi.get(self, "sdk_harness_container_images")

    @property
    @pulumi.getter
    def subnetwork(self) -> str:
        """
        Subnetwork to which VMs will be assigned, if desired. Expected to be of the form "regions/REGION/subnetworks/SUBNETWORK".
        """
        return pulumi.get(self, "subnetwork")

    @property
    @pulumi.getter(name="taskrunnerSettings")
    def taskrunner_settings(self) -> 'outputs.TaskRunnerSettingsResponse':
        """
        Settings passed through to Google Compute Engine workers when using the standard Dataflow task runner. Users should ignore this field.
        """
        return pulumi.get(self, "taskrunner_settings")

    @property
    @pulumi.getter(name="teardownPolicy")
    def teardown_policy(self) -> str:
        """
        Sets the policy for determining when to turndown worker pool. Allowed values are: `TEARDOWN_ALWAYS`, `TEARDOWN_ON_SUCCESS`, and `TEARDOWN_NEVER`. `TEARDOWN_ALWAYS` means workers are always torn down regardless of whether the job succeeds. `TEARDOWN_ON_SUCCESS` means workers are torn down if the job succeeds. `TEARDOWN_NEVER` means the workers are never torn down. If the workers are not torn down by the service, they will continue to run and use Google Compute Engine VM resources in the user's project until they are explicitly terminated by the user. Because of this, Google recommends using the `TEARDOWN_ALWAYS` policy except for small, manually supervised test jobs. If unknown or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "teardown_policy")

    @property
    @pulumi.getter(name="workerHarnessContainerImage")
    def worker_harness_container_image(self) -> str:
        """
        Required. Docker container image that executes the Cloud Dataflow worker harness, residing in Google Container Registry. Deprecated for the Fn API path. Use sdk_harness_container_images instead.
        """
        return pulumi.get(self, "worker_harness_container_image")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        Zone to run the worker pools in. If empty or unspecified, the service will attempt to choose a reasonable default.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class WorkerSettingsResponse(dict):
    """
    Provides data to pass through to the worker harness.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseUrl":
            suggest = "base_url"
        elif key == "reportingEnabled":
            suggest = "reporting_enabled"
        elif key == "servicePath":
            suggest = "service_path"
        elif key == "shuffleServicePath":
            suggest = "shuffle_service_path"
        elif key == "tempStoragePrefix":
            suggest = "temp_storage_prefix"
        elif key == "workerId":
            suggest = "worker_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkerSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkerSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkerSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_url: str,
                 reporting_enabled: bool,
                 service_path: str,
                 shuffle_service_path: str,
                 temp_storage_prefix: str,
                 worker_id: str):
        """
        Provides data to pass through to the worker harness.
        :param str base_url: The base URL for accessing Google Cloud APIs. When workers access Google Cloud APIs, they logically do so via relative URLs. If this field is specified, it supplies the base URL to use for resolving these relative URLs. The normative algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators". If not specified, the default value is "http://www.googleapis.com/"
        :param bool reporting_enabled: Whether to send work progress updates to the service.
        :param str service_path: The Cloud Dataflow service path relative to the root URL, for example, "dataflow/v1b3/projects".
        :param str shuffle_service_path: The Shuffle service path relative to the root URL, for example, "shuffle/v1beta1".
        :param str temp_storage_prefix: The prefix of the resources the system should use for temporary storage. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        :param str worker_id: The ID of the worker running this pipeline.
        """
        pulumi.set(__self__, "base_url", base_url)
        pulumi.set(__self__, "reporting_enabled", reporting_enabled)
        pulumi.set(__self__, "service_path", service_path)
        pulumi.set(__self__, "shuffle_service_path", shuffle_service_path)
        pulumi.set(__self__, "temp_storage_prefix", temp_storage_prefix)
        pulumi.set(__self__, "worker_id", worker_id)

    @property
    @pulumi.getter(name="baseUrl")
    def base_url(self) -> str:
        """
        The base URL for accessing Google Cloud APIs. When workers access Google Cloud APIs, they logically do so via relative URLs. If this field is specified, it supplies the base URL to use for resolving these relative URLs. The normative algorithm used is defined by RFC 1808, "Relative Uniform Resource Locators". If not specified, the default value is "http://www.googleapis.com/"
        """
        return pulumi.get(self, "base_url")

    @property
    @pulumi.getter(name="reportingEnabled")
    def reporting_enabled(self) -> bool:
        """
        Whether to send work progress updates to the service.
        """
        return pulumi.get(self, "reporting_enabled")

    @property
    @pulumi.getter(name="servicePath")
    def service_path(self) -> str:
        """
        The Cloud Dataflow service path relative to the root URL, for example, "dataflow/v1b3/projects".
        """
        return pulumi.get(self, "service_path")

    @property
    @pulumi.getter(name="shuffleServicePath")
    def shuffle_service_path(self) -> str:
        """
        The Shuffle service path relative to the root URL, for example, "shuffle/v1beta1".
        """
        return pulumi.get(self, "shuffle_service_path")

    @property
    @pulumi.getter(name="tempStoragePrefix")
    def temp_storage_prefix(self) -> str:
        """
        The prefix of the resources the system should use for temporary storage. The supported resource type is: Google Cloud Storage: storage.googleapis.com/{bucket}/{object} bucket.storage.googleapis.com/{object}
        """
        return pulumi.get(self, "temp_storage_prefix")

    @property
    @pulumi.getter(name="workerId")
    def worker_id(self) -> str:
        """
        The ID of the worker running this pipeline.
        """
        return pulumi.get(self, "worker_id")


