# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegionBackendServiceArgs', 'RegionBackendService']

@pulumi.input_type
class RegionBackendServiceArgs:
    def __init__(__self__, *,
                 backend_service: pulumi.Input[str],
                 project: pulumi.Input[str],
                 region: pulumi.Input[str],
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]] = None,
                 cdn_policy: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']] = None,
                 circuit_breakers: Optional[pulumi.Input['CircuitBreakersArgs']] = None,
                 connection_draining: Optional[pulumi.Input['ConnectionDrainingArgs']] = None,
                 consistent_hash: Optional[pulumi.Input['ConsistentHashLoadBalancerSettingsArgs']] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 failover_policy: Optional[pulumi.Input['BackendServiceFailoverPolicyArgs']] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 iap: Optional[pulumi.Input['BackendServiceIAPArgs']] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input['BackendServiceLogConfigArgs']] = None,
                 max_stream_duration: Optional[pulumi.Input['DurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input['OutlierDetectionArgs']] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input['SecuritySettingsArgs']] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a RegionBackendService resource.
        :param pulumi.Input[str] region: [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
               
               If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[Sequence[pulumi.Input['BackendArgs']]] backends: The list of backends that serve this BackendService.
        :param pulumi.Input['BackendServiceCdnPolicyArgs'] cdn_policy: Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
        :param pulumi.Input['CircuitBreakersArgs'] circuit_breakers: Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.
               
               This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input['ConsistentHashLoadBalancerSettingsArgs'] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.
               
               This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied responses.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[bool] enable_cdn: If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
        :param pulumi.Input['BackendServiceFailoverPolicyArgs'] failover_policy: Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.
               
               To see the latest fingerprint, make a get() request to retrieve a BackendService.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] health_checks: The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
        :param pulumi.Input['BackendServiceIAPArgs'] iap: The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
        :param pulumi.Input[str] id: [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[str] kind: [Output Only] Type of resource. Always compute#backendService for backend services.
        :param pulumi.Input[str] load_balancing_scheme: Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality. The possible values are:  
               - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. 
               - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. 
               - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. 
               - RANDOM: The load balancer selects a random healthy host. 
               - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. 
               - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 
               
               This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  
               
               If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.
               
               Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input['BackendServiceLogConfigArgs'] log_config: This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
        :param pulumi.Input['DurationArgs'] max_stream_duration: Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
               If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
               This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] network: The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input['OutlierDetectionArgs'] outlier_detection: Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.
               
               This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[int] port: Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.
               
               Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
        :param pulumi.Input[str] port_name: A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.
               
               
               
               Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
        :param pulumi.Input[str] protocol: The protocol this BackendService uses to communicate with backends.
               
               Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.
               
               Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
        :param pulumi.Input[str] security_policy: [Output Only] The resource URL for the security policy associated with this backend service.
        :param pulumi.Input['SecuritySettingsArgs'] security_settings: This field specifies the security policy that applies to this backend service. This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        :param pulumi.Input[str] self_link: [Output Only] Server-defined URL for the resource.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE.
               
               When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
               
               When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
               
               When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
        """
        pulumi.set(__self__, "backend_service", backend_service)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "region", region)
        if affinity_cookie_ttl_sec is not None:
            pulumi.set(__self__, "affinity_cookie_ttl_sec", affinity_cookie_ttl_sec)
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if cdn_policy is not None:
            pulumi.set(__self__, "cdn_policy", cdn_policy)
        if circuit_breakers is not None:
            pulumi.set(__self__, "circuit_breakers", circuit_breakers)
        if connection_draining is not None:
            pulumi.set(__self__, "connection_draining", connection_draining)
        if consistent_hash is not None:
            pulumi.set(__self__, "consistent_hash", consistent_hash)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if custom_request_headers is not None:
            pulumi.set(__self__, "custom_request_headers", custom_request_headers)
        if custom_response_headers is not None:
            pulumi.set(__self__, "custom_response_headers", custom_response_headers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_cdn is not None:
            pulumi.set(__self__, "enable_cdn", enable_cdn)
        if failover_policy is not None:
            pulumi.set(__self__, "failover_policy", failover_policy)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if health_checks is not None:
            pulumi.set(__self__, "health_checks", health_checks)
        if iap is not None:
            pulumi.set(__self__, "iap", iap)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if load_balancing_scheme is not None:
            pulumi.set(__self__, "load_balancing_scheme", load_balancing_scheme)
        if locality_lb_policy is not None:
            pulumi.set(__self__, "locality_lb_policy", locality_lb_policy)
        if log_config is not None:
            pulumi.set(__self__, "log_config", log_config)
        if max_stream_duration is not None:
            pulumi.set(__self__, "max_stream_duration", max_stream_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if outlier_detection is not None:
            pulumi.set(__self__, "outlier_detection", outlier_detection)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_name is not None:
            pulumi.set(__self__, "port_name", port_name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if security_policy is not None:
            pulumi.set(__self__, "security_policy", security_policy)
        if security_settings is not None:
            pulumi.set(__self__, "security_settings", security_settings)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if timeout_sec is not None:
            pulumi.set(__self__, "timeout_sec", timeout_sec)

    @property
    @pulumi.getter(name="backendService")
    def backend_service(self) -> pulumi.Input[str]:
        return pulumi.get(self, "backend_service")

    @backend_service.setter
    def backend_service(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend_service", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> Optional[pulumi.Input[int]]:
        """
        Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.

        If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @affinity_cookie_ttl_sec.setter
    def affinity_cookie_ttl_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "affinity_cookie_ttl_sec", value)

    @property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]]:
        """
        The list of backends that serve this BackendService.
        """
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]:
        """
        Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
        """
        return pulumi.get(self, "cdn_policy")

    @cdn_policy.setter
    def cdn_policy(self, value: Optional[pulumi.Input['BackendServiceCdnPolicyArgs']]):
        pulumi.set(self, "cdn_policy", value)

    @property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> Optional[pulumi.Input['CircuitBreakersArgs']]:
        """
        Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.

        This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "circuit_breakers")

    @circuit_breakers.setter
    def circuit_breakers(self, value: Optional[pulumi.Input['CircuitBreakersArgs']]):
        pulumi.set(self, "circuit_breakers", value)

    @property
    @pulumi.getter(name="connectionDraining")
    def connection_draining(self) -> Optional[pulumi.Input['ConnectionDrainingArgs']]:
        return pulumi.get(self, "connection_draining")

    @connection_draining.setter
    def connection_draining(self, value: Optional[pulumi.Input['ConnectionDrainingArgs']]):
        pulumi.set(self, "connection_draining", value)

    @property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> Optional[pulumi.Input['ConsistentHashLoadBalancerSettingsArgs']]:
        """
        Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.

        This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "consistent_hash")

    @consistent_hash.setter
    def consistent_hash(self, value: Optional[pulumi.Input['ConsistentHashLoadBalancerSettingsArgs']]):
        pulumi.set(self, "consistent_hash", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="customRequestHeaders")
    def custom_request_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied requests.
        """
        return pulumi.get(self, "custom_request_headers")

    @custom_request_headers.setter
    def custom_request_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_request_headers", value)

    @property
    @pulumi.getter(name="customResponseHeaders")
    def custom_response_headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Headers that the HTTP/S load balancer should add to proxied responses.
        """
        return pulumi.get(self, "custom_response_headers")

    @custom_response_headers.setter
    def custom_response_headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "custom_response_headers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="enableCDN")
    def enable_cdn(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
        """
        return pulumi.get(self, "enable_cdn")

    @enable_cdn.setter
    def enable_cdn(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_cdn", value)

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> Optional[pulumi.Input['BackendServiceFailoverPolicyArgs']]:
        """
        Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
        """
        return pulumi.get(self, "failover_policy")

    @failover_policy.setter
    def failover_policy(self, value: Optional[pulumi.Input['BackendServiceFailoverPolicyArgs']]):
        pulumi.set(self, "failover_policy", value)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.

        To see the latest fingerprint, make a get() request to retrieve a BackendService.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
        """
        return pulumi.get(self, "health_checks")

    @health_checks.setter
    def health_checks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "health_checks", value)

    @property
    @pulumi.getter
    def iap(self) -> Optional[pulumi.Input['BackendServiceIAPArgs']]:
        """
        The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
        """
        return pulumi.get(self, "iap")

    @iap.setter
    def iap(self, value: Optional[pulumi.Input['BackendServiceIAPArgs']]):
        pulumi.set(self, "iap", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] Type of resource. Always compute#backendService for backend services.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @load_balancing_scheme.setter
    def load_balancing_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancing_scheme", value)

    @property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The load balancing algorithm used within the scope of the locality. The possible values are:  
        - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. 
        - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. 
        - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. 
        - RANDOM: The load balancer selects a random healthy host. 
        - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. 
        - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 

        This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  

        If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.

        Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "locality_lb_policy")

    @locality_lb_policy.setter
    def locality_lb_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locality_lb_policy", value)

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> Optional[pulumi.Input['BackendServiceLogConfigArgs']]:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
        """
        return pulumi.get(self, "log_config")

    @log_config.setter
    def log_config(self, value: Optional[pulumi.Input['BackendServiceLogConfigArgs']]):
        pulumi.set(self, "log_config", value)

    @property
    @pulumi.getter(name="maxStreamDuration")
    def max_stream_duration(self) -> Optional[pulumi.Input['DurationArgs']]:
        """
        Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
        If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
        This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "max_stream_duration")

    @max_stream_duration.setter
    def max_stream_duration(self, value: Optional[pulumi.Input['DurationArgs']]):
        pulumi.set(self, "max_stream_duration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> Optional[pulumi.Input['OutlierDetectionArgs']]:
        """
        Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.

        This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "outlier_detection")

    @outlier_detection.setter
    def outlier_detection(self, value: Optional[pulumi.Input['OutlierDetectionArgs']]):
        pulumi.set(self, "outlier_detection", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.

        Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> Optional[pulumi.Input[str]]:
        """
        A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.



        Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
        """
        return pulumi.get(self, "port_name")

    @port_name.setter
    def port_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_name", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol this BackendService uses to communicate with backends.

        Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.

        Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] The resource URL for the security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @security_policy.setter
    def security_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_policy", value)

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> Optional[pulumi.Input['SecuritySettingsArgs']]:
        """
        This field specifies the security policy that applies to this backend service. This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "security_settings")

    @security_settings.setter
    def security_settings(self, value: Optional[pulumi.Input['SecuritySettingsArgs']]):
        pulumi.set(self, "security_settings", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[pulumi.Input[str]]:
        """
        Type of session affinity to use. The default is NONE.

        When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.

        When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.

        When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "session_affinity")

    @session_affinity.setter
    def session_affinity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "session_affinity", value)

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> Optional[pulumi.Input[int]]:
        """
        The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
        """
        return pulumi.get(self, "timeout_sec")

    @timeout_sec.setter
    def timeout_sec(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout_sec", value)


class RegionBackendService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backend_service: Optional[pulumi.Input[str]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendArgs']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[pulumi.InputType['BackendServiceCdnPolicyArgs']]] = None,
                 circuit_breakers: Optional[pulumi.Input[pulumi.InputType['CircuitBreakersArgs']]] = None,
                 connection_draining: Optional[pulumi.Input[pulumi.InputType['ConnectionDrainingArgs']]] = None,
                 consistent_hash: Optional[pulumi.Input[pulumi.InputType['ConsistentHashLoadBalancerSettingsArgs']]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 failover_policy: Optional[pulumi.Input[pulumi.InputType['BackendServiceFailoverPolicyArgs']]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 iap: Optional[pulumi.Input[pulumi.InputType['BackendServiceIAPArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['BackendServiceLogConfigArgs']]] = None,
                 max_stream_duration: Optional[pulumi.Input[pulumi.InputType['DurationArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input[pulumi.InputType['OutlierDetectionArgs']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input[pulumi.InputType['SecuritySettingsArgs']]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Creates a regional BackendService resource in the specified project using the data included in the request. For more information, see  Backend services overview.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] affinity_cookie_ttl_sec: Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.
               
               If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendArgs']]]] backends: The list of backends that serve this BackendService.
        :param pulumi.Input[pulumi.InputType['BackendServiceCdnPolicyArgs']] cdn_policy: Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
        :param pulumi.Input[pulumi.InputType['CircuitBreakersArgs']] circuit_breakers: Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.
               
               This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[pulumi.InputType['ConsistentHashLoadBalancerSettingsArgs']] consistent_hash: Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.
               
               This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in RFC3339 text format.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_request_headers: Headers that the HTTP/S load balancer should add to proxied requests.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] custom_response_headers: Headers that the HTTP/S load balancer should add to proxied responses.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[bool] enable_cdn: If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
        :param pulumi.Input[pulumi.InputType['BackendServiceFailoverPolicyArgs']] failover_policy: Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
        :param pulumi.Input[str] fingerprint: Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.
               
               To see the latest fingerprint, make a get() request to retrieve a BackendService.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] health_checks: The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
        :param pulumi.Input[pulumi.InputType['BackendServiceIAPArgs']] iap: The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
        :param pulumi.Input[str] id: [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[str] kind: [Output Only] Type of resource. Always compute#backendService for backend services.
        :param pulumi.Input[str] load_balancing_scheme: Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
        :param pulumi.Input[str] locality_lb_policy: The load balancing algorithm used within the scope of the locality. The possible values are:  
               - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. 
               - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. 
               - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. 
               - RANDOM: The load balancer selects a random healthy host. 
               - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. 
               - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 
               
               This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  
               
               If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.
               
               Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[pulumi.InputType['BackendServiceLogConfigArgs']] log_config: This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
        :param pulumi.Input[pulumi.InputType['DurationArgs']] max_stream_duration: Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
               If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
               This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] network: The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
        :param pulumi.Input[pulumi.InputType['OutlierDetectionArgs']] outlier_detection: Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.
               
               This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[int] port: Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.
               
               Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
        :param pulumi.Input[str] port_name: A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.
               
               
               
               Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
        :param pulumi.Input[str] protocol: The protocol this BackendService uses to communicate with backends.
               
               Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.
               
               Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
        :param pulumi.Input[str] region: [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[str] security_policy: [Output Only] The resource URL for the security policy associated with this backend service.
        :param pulumi.Input[pulumi.InputType['SecuritySettingsArgs']] security_settings: This field specifies the security policy that applies to this backend service. This field is applicable to either:  
               - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
               - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        :param pulumi.Input[str] self_link: [Output Only] Server-defined URL for the resource.
        :param pulumi.Input[str] session_affinity: Type of session affinity to use. The default is NONE.
               
               When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.
               
               When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.
               
               When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.
               
               Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        :param pulumi.Input[int] timeout_sec: The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegionBackendServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a regional BackendService resource in the specified project using the data included in the request. For more information, see  Backend services overview.

        :param str resource_name: The name of the resource.
        :param RegionBackendServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegionBackendServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 affinity_cookie_ttl_sec: Optional[pulumi.Input[int]] = None,
                 backend_service: Optional[pulumi.Input[str]] = None,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendArgs']]]]] = None,
                 cdn_policy: Optional[pulumi.Input[pulumi.InputType['BackendServiceCdnPolicyArgs']]] = None,
                 circuit_breakers: Optional[pulumi.Input[pulumi.InputType['CircuitBreakersArgs']]] = None,
                 connection_draining: Optional[pulumi.Input[pulumi.InputType['ConnectionDrainingArgs']]] = None,
                 consistent_hash: Optional[pulumi.Input[pulumi.InputType['ConsistentHashLoadBalancerSettingsArgs']]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 custom_request_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 custom_response_headers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 enable_cdn: Optional[pulumi.Input[bool]] = None,
                 failover_policy: Optional[pulumi.Input[pulumi.InputType['BackendServiceFailoverPolicyArgs']]] = None,
                 fingerprint: Optional[pulumi.Input[str]] = None,
                 health_checks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 iap: Optional[pulumi.Input[pulumi.InputType['BackendServiceIAPArgs']]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 load_balancing_scheme: Optional[pulumi.Input[str]] = None,
                 locality_lb_policy: Optional[pulumi.Input[str]] = None,
                 log_config: Optional[pulumi.Input[pulumi.InputType['BackendServiceLogConfigArgs']]] = None,
                 max_stream_duration: Optional[pulumi.Input[pulumi.InputType['DurationArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 outlier_detection: Optional[pulumi.Input[pulumi.InputType['OutlierDetectionArgs']]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 port_name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_policy: Optional[pulumi.Input[str]] = None,
                 security_settings: Optional[pulumi.Input[pulumi.InputType['SecuritySettingsArgs']]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 session_affinity: Optional[pulumi.Input[str]] = None,
                 timeout_sec: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegionBackendServiceArgs.__new__(RegionBackendServiceArgs)

            __props__.__dict__["affinity_cookie_ttl_sec"] = affinity_cookie_ttl_sec
            if backend_service is None and not opts.urn:
                raise TypeError("Missing required property 'backend_service'")
            __props__.__dict__["backend_service"] = backend_service
            __props__.__dict__["backends"] = backends
            __props__.__dict__["cdn_policy"] = cdn_policy
            __props__.__dict__["circuit_breakers"] = circuit_breakers
            __props__.__dict__["connection_draining"] = connection_draining
            __props__.__dict__["consistent_hash"] = consistent_hash
            __props__.__dict__["creation_timestamp"] = creation_timestamp
            __props__.__dict__["custom_request_headers"] = custom_request_headers
            __props__.__dict__["custom_response_headers"] = custom_response_headers
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_cdn"] = enable_cdn
            __props__.__dict__["failover_policy"] = failover_policy
            __props__.__dict__["fingerprint"] = fingerprint
            __props__.__dict__["health_checks"] = health_checks
            __props__.__dict__["iap"] = iap
            __props__.__dict__["id"] = id
            __props__.__dict__["kind"] = kind
            __props__.__dict__["load_balancing_scheme"] = load_balancing_scheme
            __props__.__dict__["locality_lb_policy"] = locality_lb_policy
            __props__.__dict__["log_config"] = log_config
            __props__.__dict__["max_stream_duration"] = max_stream_duration
            __props__.__dict__["name"] = name
            __props__.__dict__["network"] = network
            __props__.__dict__["outlier_detection"] = outlier_detection
            __props__.__dict__["port"] = port
            __props__.__dict__["port_name"] = port_name
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["protocol"] = protocol
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["security_policy"] = security_policy
            __props__.__dict__["security_settings"] = security_settings
            __props__.__dict__["self_link"] = self_link
            __props__.__dict__["session_affinity"] = session_affinity
            __props__.__dict__["timeout_sec"] = timeout_sec
        super(RegionBackendService, __self__).__init__(
            'google-native:compute/v1:RegionBackendService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RegionBackendService':
        """
        Get an existing RegionBackendService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RegionBackendServiceArgs.__new__(RegionBackendServiceArgs)

        __props__.__dict__["affinity_cookie_ttl_sec"] = None
        __props__.__dict__["backends"] = None
        __props__.__dict__["cdn_policy"] = None
        __props__.__dict__["circuit_breakers"] = None
        __props__.__dict__["connection_draining"] = None
        __props__.__dict__["consistent_hash"] = None
        __props__.__dict__["creation_timestamp"] = None
        __props__.__dict__["custom_request_headers"] = None
        __props__.__dict__["custom_response_headers"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["enable_cdn"] = None
        __props__.__dict__["failover_policy"] = None
        __props__.__dict__["fingerprint"] = None
        __props__.__dict__["health_checks"] = None
        __props__.__dict__["iap"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["load_balancing_scheme"] = None
        __props__.__dict__["locality_lb_policy"] = None
        __props__.__dict__["log_config"] = None
        __props__.__dict__["max_stream_duration"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["network"] = None
        __props__.__dict__["outlier_detection"] = None
        __props__.__dict__["port"] = None
        __props__.__dict__["port_name"] = None
        __props__.__dict__["protocol"] = None
        __props__.__dict__["region"] = None
        __props__.__dict__["security_policy"] = None
        __props__.__dict__["security_settings"] = None
        __props__.__dict__["self_link"] = None
        __props__.__dict__["session_affinity"] = None
        __props__.__dict__["timeout_sec"] = None
        return RegionBackendService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="affinityCookieTtlSec")
    def affinity_cookie_ttl_sec(self) -> pulumi.Output[int]:
        """
        Lifetime of cookies in seconds. Only applicable if the loadBalancingScheme is EXTERNAL, INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, the protocol is HTTP or HTTPS, and the sessionAffinity is GENERATED_COOKIE, or HTTP_COOKIE.

        If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is one day (86,400).

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "affinity_cookie_ttl_sec")

    @property
    @pulumi.getter
    def backends(self) -> pulumi.Output[Sequence['outputs.BackendResponse']]:
        """
        The list of backends that serve this BackendService.
        """
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="cdnPolicy")
    def cdn_policy(self) -> pulumi.Output['outputs.BackendServiceCdnPolicyResponse']:
        """
        Cloud CDN configuration for this BackendService. Only available for  external HTTP(S) Load Balancing.
        """
        return pulumi.get(self, "cdn_policy")

    @property
    @pulumi.getter(name="circuitBreakers")
    def circuit_breakers(self) -> pulumi.Output['outputs.CircuitBreakersResponse']:
        """
        Settings controlling the volume of connections to a backend service. If not set, this feature is considered disabled.

        This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "circuit_breakers")

    @property
    @pulumi.getter(name="connectionDraining")
    def connection_draining(self) -> pulumi.Output['outputs.ConnectionDrainingResponse']:
        return pulumi.get(self, "connection_draining")

    @property
    @pulumi.getter(name="consistentHash")
    def consistent_hash(self) -> pulumi.Output['outputs.ConsistentHashLoadBalancerSettingsResponse']:
        """
        Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH.

        This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "consistent_hash")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="customRequestHeaders")
    def custom_request_headers(self) -> pulumi.Output[Sequence[str]]:
        """
        Headers that the HTTP/S load balancer should add to proxied requests.
        """
        return pulumi.get(self, "custom_request_headers")

    @property
    @pulumi.getter(name="customResponseHeaders")
    def custom_response_headers(self) -> pulumi.Output[Sequence[str]]:
        """
        Headers that the HTTP/S load balancer should add to proxied responses.
        """
        return pulumi.get(self, "custom_response_headers")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableCDN")
    def enable_cdn(self) -> pulumi.Output[bool]:
        """
        If true, enables Cloud CDN for the backend service. Only applicable if the loadBalancingScheme is EXTERNAL and the protocol is HTTP or HTTPS.
        """
        return pulumi.get(self, "enable_cdn")

    @property
    @pulumi.getter(name="failoverPolicy")
    def failover_policy(self) -> pulumi.Output['outputs.BackendServiceFailoverPolicyResponse']:
        """
        Applicable only to Failover for Internal TCP/UDP Load Balancing and Network Load Balancing. Requires at least one backend instance group to be defined as a backup (failover) backend.
        """
        return pulumi.get(self, "failover_policy")

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[str]:
        """
        Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet.

        To see the latest fingerprint, make a get() request to retrieve a BackendService.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See  Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check. Backend services with internet or serverless NEG backends must not have a health check.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter
    def iap(self) -> pulumi.Output['outputs.BackendServiceIAPResponse']:
        """
        The configurations for Identity-Aware Proxy on this resource. Not available for Internal TCP/UDP Load Balancing and Network Load Balancing.
        """
        return pulumi.get(self, "iap")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        [Output Only] Type of resource. Always compute#backendService for backend services.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="loadBalancingScheme")
    def load_balancing_scheme(self) -> pulumi.Output[str]:
        """
        Specifies the load balancer type. Choose EXTERNAL for external HTTP(S), SSL Proxy, TCP Proxy and Network Load Balancing. Choose  INTERNAL for Internal TCP/UDP Load Balancing. Choose  INTERNAL_MANAGED for Internal HTTP(S) Load Balancing.  INTERNAL_SELF_MANAGED for Traffic Director. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
        """
        return pulumi.get(self, "load_balancing_scheme")

    @property
    @pulumi.getter(name="localityLbPolicy")
    def locality_lb_policy(self) -> pulumi.Output[str]:
        """
        The load balancing algorithm used within the scope of the locality. The possible values are:  
        - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. 
        - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. 
        - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. 
        - RANDOM: The load balancer selects a random healthy host. 
        - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. 
        - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see https://ai.google/research/pubs/pub44824 

        This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  

        If sessionAffinity is not NONE, and this field is not set to MAGLEV or RING_HASH, session affinity settings will not take effect.

        Only the default ROUND_ROBIN policy is supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "locality_lb_policy")

    @property
    @pulumi.getter(name="logConfig")
    def log_config(self) -> pulumi.Output['outputs.BackendServiceLogConfigResponse']:
        """
        This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
        """
        return pulumi.get(self, "log_config")

    @property
    @pulumi.getter(name="maxStreamDuration")
    def max_stream_duration(self) -> pulumi.Output['outputs.DurationResponse']:
        """
        Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed.
        If not specified, there will be no timeout limit, i.e. the maximum duration is infinite.
        This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "max_stream_duration")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> pulumi.Output[str]:
        """
        The URL of the network to which this backend service belongs. This field can only be specified when the load balancing scheme is set to INTERNAL.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="outlierDetection")
    def outlier_detection(self) -> pulumi.Output['outputs.OutlierDetectionResponse']:
        """
        Settings controlling the eviction of unhealthy hosts from the load balancing pool for the backend service. If not set, this feature is considered disabled.

        This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.  

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "outlier_detection")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80.

        Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portName")
    def port_name(self) -> pulumi.Output[str]:
        """
        A named port on a backend instance group representing the port for communication to the backend VMs in that group. Required when the loadBalancingScheme is EXTERNAL (except Network Load Balancing), INTERNAL_MANAGED, or  INTERNAL_SELF_MANAGED and the backends are instance groups. The named port must be defined on each backend instance group. This parameter has no meaning if the backends are NEGs.



        Backend services for Internal TCP/UDP Load Balancing and Network Load Balancing require you omit port_name.
        """
        return pulumi.get(self, "port_name")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[str]:
        """
        The protocol this BackendService uses to communicate with backends.

        Possible values are HTTP, HTTPS, HTTP2, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancer or for Traffic Director for more information.

        Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityPolicy")
    def security_policy(self) -> pulumi.Output[str]:
        """
        [Output Only] The resource URL for the security policy associated with this backend service.
        """
        return pulumi.get(self, "security_policy")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> pulumi.Output['outputs.SecuritySettingsResponse']:
        """
        This field specifies the security policy that applies to this backend service. This field is applicable to either:  
        - A regional backend service with the service_protocol set to HTTP, HTTPS, or HTTP2, and load_balancing_scheme set to INTERNAL_MANAGED. 
        - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        [Output Only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> pulumi.Output[str]:
        """
        Type of session affinity to use. The default is NONE.

        When the loadBalancingScheme is EXTERNAL: * For Network Load Balancing, the possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or  CLIENT_IP_PORT_PROTO. * For all other load balancers that use loadBalancingScheme=EXTERNAL, the possible values are NONE, CLIENT_IP, or GENERATED_COOKIE. * You can use GENERATED_COOKIE if the protocol is HTTP, HTTP2, or HTTPS.

        When the loadBalancingScheme is INTERNAL, possible values are NONE, CLIENT_IP, CLIENT_IP_PROTO, or CLIENT_IP_PORT_PROTO.

        When the loadBalancingScheme is INTERNAL_SELF_MANAGED, or INTERNAL_MANAGED, possible values are NONE, CLIENT_IP, GENERATED_COOKIE, HEADER_FIELD, or HTTP_COOKIE.

        Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
        """
        return pulumi.get(self, "session_affinity")

    @property
    @pulumi.getter(name="timeoutSec")
    def timeout_sec(self) -> pulumi.Output[int]:
        """
        The backend service timeout has a different meaning depending on the type of load balancer. For more information see,  Backend service settings The default is 30 seconds. The full range of timeout values allowed is 1 - 2,147,483,647 seconds.
        """
        return pulumi.get(self, "timeout_sec")

