# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InterconnectAttachmentArgs', 'InterconnectAttachment']

@pulumi.input_type
class InterconnectAttachmentArgs:
    def __init__(__self__, *,
                 interconnect_attachment: pulumi.Input[str],
                 project: pulumi.Input[str],
                 region: pulumi.Input[str],
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_router_ip_address: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 customer_router_ip_address: Optional[pulumi.Input[str]] = None,
                 dataplane_version: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[str]] = None,
                 encryption: Optional[pulumi.Input[str]] = None,
                 google_reference_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 interconnect: Optional[pulumi.Input[str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mtu: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operational_status: Optional[pulumi.Input[str]] = None,
                 pairing_key: Optional[pulumi.Input[str]] = None,
                 partner_asn: Optional[pulumi.Input[str]] = None,
                 partner_metadata: Optional[pulumi.Input['InterconnectAttachmentPartnerMetadataArgs']] = None,
                 private_interconnect_info: Optional[pulumi.Input['InterconnectAttachmentPrivateInfoArgs']] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 self_link_with_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a InterconnectAttachment resource.
        :param pulumi.Input[str] region: [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[bool] admin_enabled: Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
        :param pulumi.Input[str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: 
               - BPS_50M: 50 Mbit/s 
               - BPS_100M: 100 Mbit/s 
               - BPS_200M: 200 Mbit/s 
               - BPS_300M: 300 Mbit/s 
               - BPS_400M: 400 Mbit/s 
               - BPS_500M: 500 Mbit/s 
               - BPS_1G: 1 Gbit/s 
               - BPS_2G: 2 Gbit/s 
               - BPS_5G: 5 Gbit/s 
               - BPS_10G: 10 Gbit/s 
               - BPS_20G: 20 Gbit/s 
               - BPS_50G: 50 Gbit/s
        :param pulumi.Input[Sequence[pulumi.Input[str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[str] cloud_router_ip_address: [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] customer_router_ip_address: [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        :param pulumi.Input[int] dataplane_version: [Output Only] Dataplane version for this InterconnectAttachment.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] edge_availability_domain: Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: 
               - AVAILABILITY_DOMAIN_ANY 
               - AVAILABILITY_DOMAIN_1 
               - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[str] encryption: Indicates the user-supplied encryption option of this interconnect attachment: 
               - NONE is the default value, which means that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of attachment. 
               - IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud Interconnect, create the attachment using this option. 
               Not currently available in all Interconnect locations.
        :param pulumi.Input[str] google_reference_id: [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
        :param pulumi.Input[str] id: [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[str] interconnect: URL of the underlying Interconnect object that this attachment's traffic will traverse through.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway?s IP address will be allocated from the IP address range specified here. For example, if the HA VPN gateway?s interface 0 is paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this interconnect attachment. If this field is not specified for interconnect attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment, the HA VPN gateway's IP address will be allocated from regional external IP address pool.
               Not currently available in all Interconnect locations.
        :param pulumi.Input[str] kind: [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
        :param pulumi.Input[str] label_fingerprint: A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
               
               To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        :param pulumi.Input[int] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] operational_status: [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: 
               - OS_ACTIVE: The attachment has been turned up and is ready to use. 
               - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
        :param pulumi.Input[str] pairing_key: [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        :param pulumi.Input[str] partner_asn: Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
        :param pulumi.Input['InterconnectAttachmentPartnerMetadataArgs'] partner_metadata: Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
        :param pulumi.Input['InterconnectAttachmentPrivateInfoArgs'] private_interconnect_info: [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
        :param pulumi.Input[str] router: URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
        :param pulumi.Input[str] self_link: [Output Only] Server-defined URL for the resource.
        :param pulumi.Input[str] self_link_with_id: [Output Only] Server-defined URL for this resource with the resource id.
        :param pulumi.Input[str] state: [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: 
               - ACTIVE: The attachment has been turned up and is ready to use. 
               - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. 
               - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. 
               - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. 
               - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. 
               - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
        :param pulumi.Input[str] type: The type of interconnect attachment this is, which can take one of the following values: 
               - DEDICATED: an attachment to a Dedicated Interconnect. 
               - PARTNER: an attachment to a Partner Interconnect, created by the customer. 
               - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
        :param pulumi.Input[int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
        """
        pulumi.set(__self__, "interconnect_attachment", interconnect_attachment)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "region", region)
        if admin_enabled is not None:
            pulumi.set(__self__, "admin_enabled", admin_enabled)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if candidate_subnets is not None:
            pulumi.set(__self__, "candidate_subnets", candidate_subnets)
        if cloud_router_ip_address is not None:
            pulumi.set(__self__, "cloud_router_ip_address", cloud_router_ip_address)
        if creation_timestamp is not None:
            pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        if customer_router_ip_address is not None:
            pulumi.set(__self__, "customer_router_ip_address", customer_router_ip_address)
        if dataplane_version is not None:
            pulumi.set(__self__, "dataplane_version", dataplane_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edge_availability_domain is not None:
            pulumi.set(__self__, "edge_availability_domain", edge_availability_domain)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if google_reference_id is not None:
            pulumi.set(__self__, "google_reference_id", google_reference_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if interconnect is not None:
            pulumi.set(__self__, "interconnect", interconnect)
        if ipsec_internal_addresses is not None:
            pulumi.set(__self__, "ipsec_internal_addresses", ipsec_internal_addresses)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if label_fingerprint is not None:
            pulumi.set(__self__, "label_fingerprint", label_fingerprint)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if mtu is not None:
            pulumi.set(__self__, "mtu", mtu)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operational_status is not None:
            pulumi.set(__self__, "operational_status", operational_status)
        if pairing_key is not None:
            pulumi.set(__self__, "pairing_key", pairing_key)
        if partner_asn is not None:
            pulumi.set(__self__, "partner_asn", partner_asn)
        if partner_metadata is not None:
            pulumi.set(__self__, "partner_metadata", partner_metadata)
        if private_interconnect_info is not None:
            pulumi.set(__self__, "private_interconnect_info", private_interconnect_info)
        if router is not None:
            pulumi.set(__self__, "router", router)
        if self_link is not None:
            pulumi.set(__self__, "self_link", self_link)
        if self_link_with_id is not None:
            pulumi.set(__self__, "self_link_with_id", self_link_with_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vlan_tag8021q is not None:
            pulumi.set(__self__, "vlan_tag8021q", vlan_tag8021q)

    @property
    @pulumi.getter(name="interconnectAttachment")
    def interconnect_attachment(self) -> pulumi.Input[str]:
        return pulumi.get(self, "interconnect_attachment")

    @interconnect_attachment.setter
    def interconnect_attachment(self, value: pulumi.Input[str]):
        pulumi.set(self, "interconnect_attachment", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
        """
        return pulumi.get(self, "admin_enabled")

    @admin_enabled.setter
    def admin_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_enabled", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[str]]:
        """
        Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: 
        - BPS_50M: 50 Mbit/s 
        - BPS_100M: 100 Mbit/s 
        - BPS_200M: 200 Mbit/s 
        - BPS_300M: 300 Mbit/s 
        - BPS_400M: 400 Mbit/s 
        - BPS_500M: 500 Mbit/s 
        - BPS_1G: 1 Gbit/s 
        - BPS_2G: 2 Gbit/s 
        - BPS_5G: 5 Gbit/s 
        - BPS_10G: 10 Gbit/s 
        - BPS_20G: 20 Gbit/s 
        - BPS_50G: 50 Gbit/s
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="candidateSubnets")
    def candidate_subnets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
        """
        return pulumi.get(self, "candidate_subnets")

    @candidate_subnets.setter
    def candidate_subnets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "candidate_subnets", value)

    @property
    @pulumi.getter(name="cloudRouterIpAddress")
    def cloud_router_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        """
        return pulumi.get(self, "cloud_router_ip_address")

    @cloud_router_ip_address.setter
    def cloud_router_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_router_ip_address", value)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @creation_timestamp.setter
    def creation_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_timestamp", value)

    @property
    @pulumi.getter(name="customerRouterIpAddress")
    def customer_router_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        """
        return pulumi.get(self, "customer_router_ip_address")

    @customer_router_ip_address.setter
    def customer_router_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "customer_router_ip_address", value)

    @property
    @pulumi.getter(name="dataplaneVersion")
    def dataplane_version(self) -> Optional[pulumi.Input[int]]:
        """
        [Output Only] Dataplane version for this InterconnectAttachment.
        """
        return pulumi.get(self, "dataplane_version")

    @dataplane_version.setter
    def dataplane_version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "dataplane_version", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="edgeAvailabilityDomain")
    def edge_availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: 
        - AVAILABILITY_DOMAIN_ANY 
        - AVAILABILITY_DOMAIN_1 
        - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        """
        return pulumi.get(self, "edge_availability_domain")

    @edge_availability_domain.setter
    def edge_availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "edge_availability_domain", value)

    @property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the user-supplied encryption option of this interconnect attachment: 
        - NONE is the default value, which means that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of attachment. 
        - IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud Interconnect, create the attachment using this option. 
        Not currently available in all Interconnect locations.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "encryption", value)

    @property
    @pulumi.getter(name="googleReferenceId")
    def google_reference_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
        """
        return pulumi.get(self, "google_reference_id")

    @google_reference_id.setter
    def google_reference_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "google_reference_id", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def interconnect(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the underlying Interconnect object that this attachment's traffic will traverse through.
        """
        return pulumi.get(self, "interconnect")

    @interconnect.setter
    def interconnect(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "interconnect", value)

    @property
    @pulumi.getter(name="ipsecInternalAddresses")
    def ipsec_internal_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway?s IP address will be allocated from the IP address range specified here. For example, if the HA VPN gateway?s interface 0 is paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this interconnect attachment. If this field is not specified for interconnect attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment, the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        Not currently available in all Interconnect locations.
        """
        return pulumi.get(self, "ipsec_internal_addresses")

    @ipsec_internal_addresses.setter
    def ipsec_internal_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ipsec_internal_addresses", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> Optional[pulumi.Input[str]]:
        """
        A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.

        To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
        """
        return pulumi.get(self, "label_fingerprint")

    @label_fingerprint.setter
    def label_fingerprint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label_fingerprint", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def mtu(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        """
        return pulumi.get(self, "mtu")

    @mtu.setter
    def mtu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mtu", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: 
        - OS_ACTIVE: The attachment has been turned up and is ready to use. 
        - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
        """
        return pulumi.get(self, "operational_status")

    @operational_status.setter
    def operational_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operational_status", value)

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> Optional[pulumi.Input[str]]:
        """
        [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        """
        return pulumi.get(self, "pairing_key")

    @pairing_key.setter
    def pairing_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pairing_key", value)

    @property
    @pulumi.getter(name="partnerAsn")
    def partner_asn(self) -> Optional[pulumi.Input[str]]:
        """
        Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
        """
        return pulumi.get(self, "partner_asn")

    @partner_asn.setter
    def partner_asn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partner_asn", value)

    @property
    @pulumi.getter(name="partnerMetadata")
    def partner_metadata(self) -> Optional[pulumi.Input['InterconnectAttachmentPartnerMetadataArgs']]:
        """
        Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
        """
        return pulumi.get(self, "partner_metadata")

    @partner_metadata.setter
    def partner_metadata(self, value: Optional[pulumi.Input['InterconnectAttachmentPartnerMetadataArgs']]):
        pulumi.set(self, "partner_metadata", value)

    @property
    @pulumi.getter(name="privateInterconnectInfo")
    def private_interconnect_info(self) -> Optional[pulumi.Input['InterconnectAttachmentPrivateInfoArgs']]:
        """
        [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
        """
        return pulumi.get(self, "private_interconnect_info")

    @private_interconnect_info.setter
    def private_interconnect_info(self, value: Optional[pulumi.Input['InterconnectAttachmentPrivateInfoArgs']]):
        pulumi.set(self, "private_interconnect_info", value)

    @property
    @pulumi.getter
    def router(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
        """
        return pulumi.get(self, "router")

    @router.setter
    def router(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "router", value)

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @self_link.setter
    def self_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link", value)

    @property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @self_link_with_id.setter
    def self_link_with_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "self_link_with_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: 
        - ACTIVE: The attachment has been turned up and is ready to use. 
        - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. 
        - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. 
        - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. 
        - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. 
        - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of interconnect attachment this is, which can take one of the following values: 
        - DEDICATED: an attachment to a Dedicated Interconnect. 
        - PARTNER: an attachment to a Partner Interconnect, created by the customer. 
        - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vlanTag8021q")
    def vlan_tag8021q(self) -> Optional[pulumi.Input[int]]:
        """
        The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
        """
        return pulumi.get(self, "vlan_tag8021q")

    @vlan_tag8021q.setter
    def vlan_tag8021q(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_tag8021q", value)


class InterconnectAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_router_ip_address: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 customer_router_ip_address: Optional[pulumi.Input[str]] = None,
                 dataplane_version: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[str]] = None,
                 encryption: Optional[pulumi.Input[str]] = None,
                 google_reference_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 interconnect: Optional[pulumi.Input[str]] = None,
                 interconnect_attachment: Optional[pulumi.Input[str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mtu: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operational_status: Optional[pulumi.Input[str]] = None,
                 pairing_key: Optional[pulumi.Input[str]] = None,
                 partner_asn: Optional[pulumi.Input[str]] = None,
                 partner_metadata: Optional[pulumi.Input[pulumi.InputType['InterconnectAttachmentPartnerMetadataArgs']]] = None,
                 private_interconnect_info: Optional[pulumi.Input[pulumi.InputType['InterconnectAttachmentPrivateInfoArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 self_link_with_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Creates an InterconnectAttachment in the specified project using the data included in the request.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_enabled: Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
        :param pulumi.Input[str] bandwidth: Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: 
               - BPS_50M: 50 Mbit/s 
               - BPS_100M: 100 Mbit/s 
               - BPS_200M: 200 Mbit/s 
               - BPS_300M: 300 Mbit/s 
               - BPS_400M: 400 Mbit/s 
               - BPS_500M: 500 Mbit/s 
               - BPS_1G: 1 Gbit/s 
               - BPS_2G: 2 Gbit/s 
               - BPS_5G: 5 Gbit/s 
               - BPS_10G: 10 Gbit/s 
               - BPS_20G: 20 Gbit/s 
               - BPS_50G: 50 Gbit/s
        :param pulumi.Input[Sequence[pulumi.Input[str]]] candidate_subnets: Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
        :param pulumi.Input[str] cloud_router_ip_address: [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] customer_router_ip_address: [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        :param pulumi.Input[int] dataplane_version: [Output Only] Dataplane version for this InterconnectAttachment.
        :param pulumi.Input[str] description: An optional description of this resource.
        :param pulumi.Input[str] edge_availability_domain: Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: 
               - AVAILABILITY_DOMAIN_ANY 
               - AVAILABILITY_DOMAIN_1 
               - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        :param pulumi.Input[str] encryption: Indicates the user-supplied encryption option of this interconnect attachment: 
               - NONE is the default value, which means that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of attachment. 
               - IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud Interconnect, create the attachment using this option. 
               Not currently available in all Interconnect locations.
        :param pulumi.Input[str] google_reference_id: [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
        :param pulumi.Input[str] id: [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[str] interconnect: URL of the underlying Interconnect object that this attachment's traffic will traverse through.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ipsec_internal_addresses: URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway?s IP address will be allocated from the IP address range specified here. For example, if the HA VPN gateway?s interface 0 is paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this interconnect attachment. If this field is not specified for interconnect attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment, the HA VPN gateway's IP address will be allocated from regional external IP address pool.
               Not currently available in all Interconnect locations.
        :param pulumi.Input[str] kind: [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
        :param pulumi.Input[str] label_fingerprint: A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
               
               To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        :param pulumi.Input[int] mtu: Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] operational_status: [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: 
               - OS_ACTIVE: The attachment has been turned up and is ready to use. 
               - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
        :param pulumi.Input[str] pairing_key: [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        :param pulumi.Input[str] partner_asn: Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
        :param pulumi.Input[pulumi.InputType['InterconnectAttachmentPartnerMetadataArgs']] partner_metadata: Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
        :param pulumi.Input[pulumi.InputType['InterconnectAttachmentPrivateInfoArgs']] private_interconnect_info: [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
        :param pulumi.Input[str] region: [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[str] router: URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
        :param pulumi.Input[str] self_link: [Output Only] Server-defined URL for the resource.
        :param pulumi.Input[str] self_link_with_id: [Output Only] Server-defined URL for this resource with the resource id.
        :param pulumi.Input[str] state: [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: 
               - ACTIVE: The attachment has been turned up and is ready to use. 
               - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. 
               - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. 
               - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. 
               - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. 
               - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
        :param pulumi.Input[str] type: The type of interconnect attachment this is, which can take one of the following values: 
               - DEDICATED: an attachment to a Dedicated Interconnect. 
               - PARTNER: an attachment to a Partner Interconnect, created by the customer. 
               - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
        :param pulumi.Input[int] vlan_tag8021q: The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InterconnectAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates an InterconnectAttachment in the specified project using the data included in the request.

        :param str resource_name: The name of the resource.
        :param InterconnectAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InterconnectAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_enabled: Optional[pulumi.Input[bool]] = None,
                 bandwidth: Optional[pulumi.Input[str]] = None,
                 candidate_subnets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cloud_router_ip_address: Optional[pulumi.Input[str]] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 customer_router_ip_address: Optional[pulumi.Input[str]] = None,
                 dataplane_version: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 edge_availability_domain: Optional[pulumi.Input[str]] = None,
                 encryption: Optional[pulumi.Input[str]] = None,
                 google_reference_id: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 interconnect: Optional[pulumi.Input[str]] = None,
                 interconnect_attachment: Optional[pulumi.Input[str]] = None,
                 ipsec_internal_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 label_fingerprint: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 mtu: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operational_status: Optional[pulumi.Input[str]] = None,
                 pairing_key: Optional[pulumi.Input[str]] = None,
                 partner_asn: Optional[pulumi.Input[str]] = None,
                 partner_metadata: Optional[pulumi.Input[pulumi.InputType['InterconnectAttachmentPartnerMetadataArgs']]] = None,
                 private_interconnect_info: Optional[pulumi.Input[pulumi.InputType['InterconnectAttachmentPrivateInfoArgs']]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 self_link_with_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vlan_tag8021q: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InterconnectAttachmentArgs.__new__(InterconnectAttachmentArgs)

            __props__.__dict__["admin_enabled"] = admin_enabled
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["candidate_subnets"] = candidate_subnets
            __props__.__dict__["cloud_router_ip_address"] = cloud_router_ip_address
            __props__.__dict__["creation_timestamp"] = creation_timestamp
            __props__.__dict__["customer_router_ip_address"] = customer_router_ip_address
            __props__.__dict__["dataplane_version"] = dataplane_version
            __props__.__dict__["description"] = description
            __props__.__dict__["edge_availability_domain"] = edge_availability_domain
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["google_reference_id"] = google_reference_id
            __props__.__dict__["id"] = id
            __props__.__dict__["interconnect"] = interconnect
            if interconnect_attachment is None and not opts.urn:
                raise TypeError("Missing required property 'interconnect_attachment'")
            __props__.__dict__["interconnect_attachment"] = interconnect_attachment
            __props__.__dict__["ipsec_internal_addresses"] = ipsec_internal_addresses
            __props__.__dict__["kind"] = kind
            __props__.__dict__["label_fingerprint"] = label_fingerprint
            __props__.__dict__["labels"] = labels
            __props__.__dict__["mtu"] = mtu
            __props__.__dict__["name"] = name
            __props__.__dict__["operational_status"] = operational_status
            __props__.__dict__["pairing_key"] = pairing_key
            __props__.__dict__["partner_asn"] = partner_asn
            __props__.__dict__["partner_metadata"] = partner_metadata
            __props__.__dict__["private_interconnect_info"] = private_interconnect_info
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["router"] = router
            __props__.__dict__["self_link"] = self_link
            __props__.__dict__["self_link_with_id"] = self_link_with_id
            __props__.__dict__["state"] = state
            __props__.__dict__["type"] = type
            __props__.__dict__["vlan_tag8021q"] = vlan_tag8021q
        super(InterconnectAttachment, __self__).__init__(
            'google-native:compute/alpha:InterconnectAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'InterconnectAttachment':
        """
        Get an existing InterconnectAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InterconnectAttachmentArgs.__new__(InterconnectAttachmentArgs)

        __props__.__dict__["admin_enabled"] = None
        __props__.__dict__["bandwidth"] = None
        __props__.__dict__["candidate_subnets"] = None
        __props__.__dict__["cloud_router_ip_address"] = None
        __props__.__dict__["creation_timestamp"] = None
        __props__.__dict__["customer_router_ip_address"] = None
        __props__.__dict__["dataplane_version"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["edge_availability_domain"] = None
        __props__.__dict__["encryption"] = None
        __props__.__dict__["google_reference_id"] = None
        __props__.__dict__["interconnect"] = None
        __props__.__dict__["ipsec_internal_addresses"] = None
        __props__.__dict__["kind"] = None
        __props__.__dict__["label_fingerprint"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["mtu"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["operational_status"] = None
        __props__.__dict__["pairing_key"] = None
        __props__.__dict__["partner_asn"] = None
        __props__.__dict__["partner_metadata"] = None
        __props__.__dict__["private_interconnect_info"] = None
        __props__.__dict__["region"] = None
        __props__.__dict__["router"] = None
        __props__.__dict__["self_link"] = None
        __props__.__dict__["self_link_with_id"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["type"] = None
        __props__.__dict__["vlan_tag8021q"] = None
        return InterconnectAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminEnabled")
    def admin_enabled(self) -> pulumi.Output[bool]:
        """
        Determines whether this Attachment will carry packets. Not present for PARTNER_PROVIDER.
        """
        return pulumi.get(self, "admin_enabled")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[str]:
        """
        Provisioned bandwidth capacity for the interconnect attachment. For attachments of type DEDICATED, the user can set the bandwidth. For attachments of type PARTNER, the Google Partner that is operating the interconnect must set the bandwidth. Output only for PARTNER type, mutable for PARTNER_PROVIDER and DEDICATED, and can take one of the following values: 
        - BPS_50M: 50 Mbit/s 
        - BPS_100M: 100 Mbit/s 
        - BPS_200M: 200 Mbit/s 
        - BPS_300M: 300 Mbit/s 
        - BPS_400M: 400 Mbit/s 
        - BPS_500M: 500 Mbit/s 
        - BPS_1G: 1 Gbit/s 
        - BPS_2G: 2 Gbit/s 
        - BPS_5G: 5 Gbit/s 
        - BPS_10G: 10 Gbit/s 
        - BPS_20G: 20 Gbit/s 
        - BPS_50G: 50 Gbit/s
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="candidateSubnets")
    def candidate_subnets(self) -> pulumi.Output[Sequence[str]]:
        """
        Up to 16 candidate prefixes that can be used to restrict the allocation of cloudRouterIpAddress and customerRouterIpAddress for this attachment. All prefixes must be within link-local address space (169.254.0.0/16) and must be /29 or shorter (/28, /27, etc). Google will attempt to select an unused /29 from the supplied candidate prefix(es). The request will fail if all possible /29s are in use on Google's edge. If not supplied, Google will randomly select an unused /29 from all of link-local space.
        """
        return pulumi.get(self, "candidate_subnets")

    @property
    @pulumi.getter(name="cloudRouterIpAddress")
    def cloud_router_ip_address(self) -> pulumi.Output[str]:
        """
        [Output Only] IPv4 address + prefix length to be configured on Cloud Router Interface for this interconnect attachment.
        """
        return pulumi.get(self, "cloud_router_ip_address")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="customerRouterIpAddress")
    def customer_router_ip_address(self) -> pulumi.Output[str]:
        """
        [Output Only] IPv4 address + prefix length to be configured on the customer router subinterface for this interconnect attachment.
        """
        return pulumi.get(self, "customer_router_ip_address")

    @property
    @pulumi.getter(name="dataplaneVersion")
    def dataplane_version(self) -> pulumi.Output[int]:
        """
        [Output Only] Dataplane version for this InterconnectAttachment.
        """
        return pulumi.get(self, "dataplane_version")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional description of this resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="edgeAvailabilityDomain")
    def edge_availability_domain(self) -> pulumi.Output[str]:
        """
        Desired availability domain for the attachment. Only available for type PARTNER, at creation time, and can take one of the following values: 
        - AVAILABILITY_DOMAIN_ANY 
        - AVAILABILITY_DOMAIN_1 
        - AVAILABILITY_DOMAIN_2 For improved reliability, customers should configure a pair of attachments, one per availability domain. The selected availability domain will be provided to the Partner via the pairing key, so that the provisioned circuit will lie in the specified domain. If not specified, the value will default to AVAILABILITY_DOMAIN_ANY.
        """
        return pulumi.get(self, "edge_availability_domain")

    @property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[str]:
        """
        Indicates the user-supplied encryption option of this interconnect attachment: 
        - NONE is the default value, which means that the attachment carries unencrypted traffic. VMs can send traffic to, or receive traffic from, this type of attachment. 
        - IPSEC indicates that the attachment carries only traffic encrypted by an IPsec device such as an HA VPN gateway. VMs cannot directly send traffic to, or receive traffic from, such an attachment. To use IPsec-encrypted Cloud Interconnect, create the attachment using this option. 
        Not currently available in all Interconnect locations.
        """
        return pulumi.get(self, "encryption")

    @property
    @pulumi.getter(name="googleReferenceId")
    def google_reference_id(self) -> pulumi.Output[str]:
        """
        [Output Only] Google reference ID, to be used when raising support tickets with Google or otherwise to debug backend connectivity issues. [Deprecated] This field is not used.
        """
        return pulumi.get(self, "google_reference_id")

    @property
    @pulumi.getter
    def interconnect(self) -> pulumi.Output[str]:
        """
        URL of the underlying Interconnect object that this attachment's traffic will traverse through.
        """
        return pulumi.get(self, "interconnect")

    @property
    @pulumi.getter(name="ipsecInternalAddresses")
    def ipsec_internal_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        URL of addresses that have been reserved for the interconnect attachment, Used only for interconnect attachment that has the encryption option as IPSEC. The addresses must be RFC 1918 IP address ranges. When creating HA VPN gateway over the interconnect attachment, if the attachment is configured to use an RFC 1918 IP address, then the VPN gateway?s IP address will be allocated from the IP address range specified here. For example, if the HA VPN gateway?s interface 0 is paired to this interconnect attachment, then an RFC 1918 IP address for the VPN gateway interface 0 will be allocated from the IP address specified for this interconnect attachment. If this field is not specified for interconnect attachment that has encryption option as IPSEC, later on when creating HA VPN gateway on this interconnect attachment, the HA VPN gateway's IP address will be allocated from regional external IP address pool.
        Not currently available in all Interconnect locations.
        """
        return pulumi.get(self, "ipsec_internal_addresses")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        [Output Only] Type of the resource. Always compute#interconnectAttachment for interconnect attachments.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="labelFingerprint")
    def label_fingerprint(self) -> pulumi.Output[str]:
        """
        A fingerprint for the labels being applied to this InterconnectAttachment, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.

        To see the latest fingerprint, make a get() request to retrieve an InterconnectAttachment.
        """
        return pulumi.get(self, "label_fingerprint")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels for this resource. These can only be added or modified by the setLabels method. Each label key/value pair must comply with RFC1035. Label values may be empty.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def mtu(self) -> pulumi.Output[int]:
        """
        Maximum Transmission Unit (MTU), in bytes, of packets passing through this interconnect attachment. Only 1440 and 1500 are allowed. If not specified, the value will default to 1440.
        """
        return pulumi.get(self, "mtu")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationalStatus")
    def operational_status(self) -> pulumi.Output[str]:
        """
        [Output Only] The current status of whether or not this interconnect attachment is functional, which can take one of the following values: 
        - OS_ACTIVE: The attachment has been turned up and is ready to use. 
        - OS_UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete.
        """
        return pulumi.get(self, "operational_status")

    @property
    @pulumi.getter(name="pairingKey")
    def pairing_key(self) -> pulumi.Output[str]:
        """
        [Output only for type PARTNER. Input only for PARTNER_PROVIDER. Not present for DEDICATED]. The opaque identifier of an PARTNER attachment used to initiate provisioning with a selected partner. Of the form "XXXXX/region/domain"
        """
        return pulumi.get(self, "pairing_key")

    @property
    @pulumi.getter(name="partnerAsn")
    def partner_asn(self) -> pulumi.Output[str]:
        """
        Optional BGP ASN for the router supplied by a Layer 3 Partner if they configured BGP on behalf of the customer. Output only for PARTNER type, input only for PARTNER_PROVIDER, not available for DEDICATED.
        """
        return pulumi.get(self, "partner_asn")

    @property
    @pulumi.getter(name="partnerMetadata")
    def partner_metadata(self) -> pulumi.Output['outputs.InterconnectAttachmentPartnerMetadataResponse']:
        """
        Informational metadata about Partner attachments from Partners to display to customers. Output only for for PARTNER type, mutable for PARTNER_PROVIDER, not available for DEDICATED.
        """
        return pulumi.get(self, "partner_metadata")

    @property
    @pulumi.getter(name="privateInterconnectInfo")
    def private_interconnect_info(self) -> pulumi.Output['outputs.InterconnectAttachmentPrivateInfoResponse']:
        """
        [Output Only] Information specific to an InterconnectAttachment. This property is populated if the interconnect that this is attached to is of type DEDICATED.
        """
        return pulumi.get(self, "private_interconnect_info")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        [Output Only] URL of the region where the regional interconnect attachment resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[str]:
        """
        URL of the Cloud Router to be used for dynamic routing. This router must be in the same region as this InterconnectAttachment. The InterconnectAttachment will automatically connect the Interconnect to the network & region within which the Cloud Router is configured.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        [Output Only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="selfLinkWithId")
    def self_link_with_id(self) -> pulumi.Output[str]:
        """
        [Output Only] Server-defined URL for this resource with the resource id.
        """
        return pulumi.get(self, "self_link_with_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        [Output Only] The current state of this attachment's functionality. Enum values ACTIVE and UNPROVISIONED are shared by DEDICATED/PRIVATE, PARTNER, and PARTNER_PROVIDER interconnect attachments, while enum values PENDING_PARTNER, PARTNER_REQUEST_RECEIVED, and PENDING_CUSTOMER are used for only PARTNER and PARTNER_PROVIDER interconnect attachments. This state can take one of the following values: 
        - ACTIVE: The attachment has been turned up and is ready to use. 
        - UNPROVISIONED: The attachment is not ready to use yet, because turnup is not complete. 
        - PENDING_PARTNER: A newly-created PARTNER attachment that has not yet been configured on the Partner side. 
        - PARTNER_REQUEST_RECEIVED: A PARTNER attachment is in the process of provisioning after a PARTNER_PROVIDER attachment was created that references it. 
        - PENDING_CUSTOMER: A PARTNER or PARTNER_PROVIDER attachment that is waiting for a customer to activate it. 
        - DEFUNCT: The attachment was deleted externally and is no longer functional. This could be because the associated Interconnect was removed, or because the other side of a Partner attachment was deleted.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of interconnect attachment this is, which can take one of the following values: 
        - DEDICATED: an attachment to a Dedicated Interconnect. 
        - PARTNER: an attachment to a Partner Interconnect, created by the customer. 
        - PARTNER_PROVIDER: an attachment to a Partner Interconnect, created by the partner.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vlanTag8021q")
    def vlan_tag8021q(self) -> pulumi.Output[int]:
        """
        The IEEE 802.1Q VLAN tag for this attachment, in the range 2-4094. Only specified at creation time.
        """
        return pulumi.get(self, "vlan_tag8021q")

