# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'ArtifactObjectsResponse',
    'ArtifactsResponse',
    'BuildOptionsResponse',
    'BuildResponse',
    'BuildStepResponse',
    'BuiltImageResponse',
    'GitHubEventsConfigResponse',
    'InlineSecretResponse',
    'PullRequestFilterResponse',
    'PushFilterResponse',
    'RepoSourceResponse',
    'ResultsResponse',
    'SecretManagerSecretResponse',
    'SecretResponse',
    'SecretsResponse',
    'SourceProvenanceResponse',
    'SourceResponse',
    'StorageSourceManifestResponse',
    'StorageSourceResponse',
    'TimeSpanResponse',
    'VolumeResponse',
]

@pulumi.output_type
class ArtifactObjectsResponse(dict):
    """
    Files in the workspace to upload to Cloud Storage upon successful completion of all build steps.
    """
    def __init__(__self__, *,
                 location: str,
                 paths: Sequence[str],
                 timing: 'outputs.TimeSpanResponse'):
        """
        Files in the workspace to upload to Cloud Storage upon successful completion of all build steps.
        :param str location: Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/". (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Files in the workspace matching any path pattern will be uploaded to Cloud Storage with this location as a prefix.
        :param Sequence[str] paths: Path globs used to match files in the build's workspace.
        :param 'TimeSpanResponse' timing: Stores timing information for pushing all artifact objects.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "timing", timing)

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Cloud Storage bucket and optional object path, in the form "gs://bucket/path/to/somewhere/". (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Files in the workspace matching any path pattern will be uploaded to Cloud Storage with this location as a prefix.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Path globs used to match files in the build's workspace.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter
    def timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for pushing all artifact objects.
        """
        return pulumi.get(self, "timing")


@pulumi.output_type
class ArtifactsResponse(dict):
    """
    Artifacts produced by a build that should be uploaded upon successful completion of all build steps.
    """
    def __init__(__self__, *,
                 images: Sequence[str],
                 objects: 'outputs.ArtifactObjectsResponse'):
        """
        Artifacts produced by a build that should be uploaded upon successful completion of all build steps.
        :param Sequence[str] images: A list of images to be pushed upon the successful completion of all build steps. The images will be pushed using the builder service account's credentials. The digests of the pushed images will be stored in the Build resource's results field. If any of the images fail to be pushed, the build is marked FAILURE.
        :param 'ArtifactObjectsResponse' objects: A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps. Files in the workspace matching specified paths globs will be uploaded to the specified Cloud Storage location using the builder service account's credentials. The location and generation of the uploaded objects will be stored in the Build resource's results field. If any objects fail to be pushed, the build is marked FAILURE.
        """
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "objects", objects)

    @property
    @pulumi.getter
    def images(self) -> Sequence[str]:
        """
        A list of images to be pushed upon the successful completion of all build steps. The images will be pushed using the builder service account's credentials. The digests of the pushed images will be stored in the Build resource's results field. If any of the images fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter
    def objects(self) -> 'outputs.ArtifactObjectsResponse':
        """
        A list of objects to be uploaded to Cloud Storage upon successful completion of all build steps. Files in the workspace matching specified paths globs will be uploaded to the specified Cloud Storage location using the builder service account's credentials. The location and generation of the uploaded objects will be stored in the Build resource's results field. If any objects fail to be pushed, the build is marked FAILURE.
        """
        return pulumi.get(self, "objects")


@pulumi.output_type
class BuildOptionsResponse(dict):
    """
    Optional arguments to enable specific features of builds.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "dynamicSubstitutions":
            suggest = "dynamic_substitutions"
        elif key == "logStreamingOption":
            suggest = "log_streaming_option"
        elif key == "machineType":
            suggest = "machine_type"
        elif key == "requestedVerifyOption":
            suggest = "requested_verify_option"
        elif key == "secretEnv":
            suggest = "secret_env"
        elif key == "sourceProvenanceHash":
            suggest = "source_provenance_hash"
        elif key == "substitutionOption":
            suggest = "substitution_option"
        elif key == "workerPool":
            suggest = "worker_pool"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildOptionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildOptionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildOptionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_size_gb: str,
                 dynamic_substitutions: bool,
                 env: Sequence[str],
                 log_streaming_option: str,
                 logging: str,
                 machine_type: str,
                 requested_verify_option: str,
                 secret_env: Sequence[str],
                 source_provenance_hash: Sequence[str],
                 substitution_option: str,
                 volumes: Sequence['outputs.VolumeResponse'],
                 worker_pool: str):
        """
        Optional arguments to enable specific features of builds.
        :param str disk_size_gb: Requested disk size for the VM that runs the build. Note that this is *NOT* "disk free"; some of the space will be used by the operating system and build utilities. Also note that this is the minimum disk size that will be allocated for the build -- the build may run with a larger disk than requested. At present, the maximum disk size is 1000GB; builds that request more than the maximum are rejected with an error.
        :param bool dynamic_substitutions: Option to specify whether or not to apply bash style string operations to the substitutions. NOTE: this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        :param Sequence[str] env: A list of global environment variable definitions that will exist for all build steps in this build. If a variable is defined in both globally and in a build step, the variable will use the build step value. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param str log_streaming_option: Option to define build log streaming behavior to Google Cloud Storage.
        :param str logging: Option to specify the logging mode, which determines if and where build logs are stored.
        :param str machine_type: Compute Engine machine type on which to run the build.
        :param str requested_verify_option: Requested verifiability options.
        :param Sequence[str] secret_env: A list of global environment variables, which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`. These variables will be available to all build steps in this build.
        :param Sequence[str] source_provenance_hash: Requested hash for SourceProvenance.
        :param str substitution_option: Option to specify behavior when there is an error in the substitution checks. NOTE: this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden in the build configuration file.
        :param Sequence['VolumeResponse'] volumes: Global list of volumes to mount for ALL build steps Each volume is created as an empty volume prior to starting the build process. Upon completion of the build, volumes and their contents are discarded. Global volume names and paths cannot conflict with the volumes defined a build step. Using a global volume in a build with only one step is not valid as it is indicative of a build request with an incorrect configuration.
        :param str worker_pool: Option to specify a `WorkerPool` for the build. Format: projects/{project}/locations/{location}/workerPools/{workerPool} This field is in beta and is available only to restricted users.
        """
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "dynamic_substitutions", dynamic_substitutions)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "log_streaming_option", log_streaming_option)
        pulumi.set(__self__, "logging", logging)
        pulumi.set(__self__, "machine_type", machine_type)
        pulumi.set(__self__, "requested_verify_option", requested_verify_option)
        pulumi.set(__self__, "secret_env", secret_env)
        pulumi.set(__self__, "source_provenance_hash", source_provenance_hash)
        pulumi.set(__self__, "substitution_option", substitution_option)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "worker_pool", worker_pool)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> str:
        """
        Requested disk size for the VM that runs the build. Note that this is *NOT* "disk free"; some of the space will be used by the operating system and build utilities. Also note that this is the minimum disk size that will be allocated for the build -- the build may run with a larger disk than requested. At present, the maximum disk size is 1000GB; builds that request more than the maximum are rejected with an error.
        """
        return pulumi.get(self, "disk_size_gb")

    @property
    @pulumi.getter(name="dynamicSubstitutions")
    def dynamic_substitutions(self) -> bool:
        """
        Option to specify whether or not to apply bash style string operations to the substitutions. NOTE: this is always enabled for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "dynamic_substitutions")

    @property
    @pulumi.getter
    def env(self) -> Sequence[str]:
        """
        A list of global environment variable definitions that will exist for all build steps in this build. If a variable is defined in both globally and in a build step, the variable will use the build step value. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="logStreamingOption")
    def log_streaming_option(self) -> str:
        """
        Option to define build log streaming behavior to Google Cloud Storage.
        """
        return pulumi.get(self, "log_streaming_option")

    @property
    @pulumi.getter
    def logging(self) -> str:
        """
        Option to specify the logging mode, which determines if and where build logs are stored.
        """
        return pulumi.get(self, "logging")

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> str:
        """
        Compute Engine machine type on which to run the build.
        """
        return pulumi.get(self, "machine_type")

    @property
    @pulumi.getter(name="requestedVerifyOption")
    def requested_verify_option(self) -> str:
        """
        Requested verifiability options.
        """
        return pulumi.get(self, "requested_verify_option")

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Sequence[str]:
        """
        A list of global environment variables, which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`. These variables will be available to all build steps in this build.
        """
        return pulumi.get(self, "secret_env")

    @property
    @pulumi.getter(name="sourceProvenanceHash")
    def source_provenance_hash(self) -> Sequence[str]:
        """
        Requested hash for SourceProvenance.
        """
        return pulumi.get(self, "source_provenance_hash")

    @property
    @pulumi.getter(name="substitutionOption")
    def substitution_option(self) -> str:
        """
        Option to specify behavior when there is an error in the substitution checks. NOTE: this is always set to ALLOW_LOOSE for triggered builds and cannot be overridden in the build configuration file.
        """
        return pulumi.get(self, "substitution_option")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        Global list of volumes to mount for ALL build steps Each volume is created as an empty volume prior to starting the build process. Upon completion of the build, volumes and their contents are discarded. Global volume names and paths cannot conflict with the volumes defined a build step. Using a global volume in a build with only one step is not valid as it is indicative of a build request with an incorrect configuration.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="workerPool")
    def worker_pool(self) -> str:
        """
        Option to specify a `WorkerPool` for the build. Format: projects/{project}/locations/{location}/workerPools/{workerPool} This field is in beta and is available only to restricted users.
        """
        return pulumi.get(self, "worker_pool")


@pulumi.output_type
class BuildResponse(dict):
    """
    A build resource in the Cloud Build API. At a high level, a `Build` describes where to find source code, how to build it (for example, the builder image to run on the source), and where to store the built artifacts. Fields can include the following variables, which will be expanded when the build is created: - $PROJECT_ID: the project ID of the build. - $PROJECT_NUMBER: the project number of the build. - $BUILD_ID: the autogenerated ID of the build. - $REPO_NAME: the source repository name specified by RepoSource. - $BRANCH_NAME: the branch name specified by RepoSource. - $TAG_NAME: the tag name specified by RepoSource. - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or resolved from the specified branch or tag. - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availableSecrets":
            suggest = "available_secrets"
        elif key == "buildTriggerId":
            suggest = "build_trigger_id"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "finishTime":
            suggest = "finish_time"
        elif key == "logUrl":
            suggest = "log_url"
        elif key == "logsBucket":
            suggest = "logs_bucket"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "queueTtl":
            suggest = "queue_ttl"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "sourceProvenance":
            suggest = "source_provenance"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "statusDetail":
            suggest = "status_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifacts: 'outputs.ArtifactsResponse',
                 available_secrets: 'outputs.SecretsResponse',
                 build_trigger_id: str,
                 create_time: str,
                 finish_time: str,
                 images: Sequence[str],
                 log_url: str,
                 logs_bucket: str,
                 name: str,
                 options: 'outputs.BuildOptionsResponse',
                 project_id: str,
                 queue_ttl: str,
                 results: 'outputs.ResultsResponse',
                 secrets: Sequence['outputs.SecretResponse'],
                 service_account: str,
                 source: 'outputs.SourceResponse',
                 source_provenance: 'outputs.SourceProvenanceResponse',
                 start_time: str,
                 status: str,
                 status_detail: str,
                 steps: Sequence['outputs.BuildStepResponse'],
                 substitutions: Mapping[str, str],
                 tags: Sequence[str],
                 timeout: str,
                 timing: Mapping[str, str]):
        """
        A build resource in the Cloud Build API. At a high level, a `Build` describes where to find source code, how to build it (for example, the builder image to run on the source), and where to store the built artifacts. Fields can include the following variables, which will be expanded when the build is created: - $PROJECT_ID: the project ID of the build. - $PROJECT_NUMBER: the project number of the build. - $BUILD_ID: the autogenerated ID of the build. - $REPO_NAME: the source repository name specified by RepoSource. - $BRANCH_NAME: the branch name specified by RepoSource. - $TAG_NAME: the tag name specified by RepoSource. - $REVISION_ID or $COMMIT_SHA: the commit SHA specified by RepoSource or resolved from the specified branch or tag. - $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
        :param 'ArtifactsResponse' artifacts: Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        :param 'SecretsResponse' available_secrets: Secrets and secret environment variables.
        :param str build_trigger_id: The ID of the `BuildTrigger` that triggered this build, if it was triggered automatically.
        :param str create_time: Time at which the request to create the build was received.
        :param str finish_time: Time at which execution of the build was finished. The difference between finish_time and start_time is the duration of the build's execution.
        :param Sequence[str] images: A list of images to be pushed upon the successful completion of all build steps. The images are pushed using the builder service account's credentials. The digests of the pushed images will be stored in the `Build` resource's results field. If any of the images fail to be pushed, the build status is marked `FAILURE`.
        :param str log_url: URL to logs for this build in Google Cloud Console.
        :param str logs_bucket: Google Cloud Storage bucket where logs should be written (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
        :param str name: The 'Build' name with format: `projects/{project}/locations/{location}/builds/{build}`, where {build} is a unique identifier generated by the service.
        :param 'BuildOptionsResponse' options: Special options for this build.
        :param str project_id: ID of the project.
        :param str queue_ttl: TTL in queue for this build. If provided and the build is enqueued longer than this value, the build will expire and the build status will be `EXPIRED`. The TTL starts ticking from create_time.
        :param 'ResultsResponse' results: Results of the build.
        :param Sequence['SecretResponse'] secrets: Secrets to decrypt using Cloud Key Management Service. Note: Secret Manager is the recommended technique for managing sensitive data with Cloud Build. Use `available_secrets` to configure builds to access secrets from Secret Manager. For instructions, see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
        :param str service_account: IAM service account whose credentials will be used at build runtime. Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email address or uniqueId of the service account. 
        :param 'SourceResponse' source: The location of the source files to build.
        :param 'SourceProvenanceResponse' source_provenance: A permanent fixed identifier for source.
        :param str start_time: Time at which execution of the build was started.
        :param str status: Status of the build.
        :param str status_detail: Customer-readable message about the current status.
        :param Sequence['BuildStepResponse'] steps: Required. The operations to be performed on the workspace.
        :param Mapping[str, str] substitutions: Substitutions data for `Build` resource.
        :param Sequence[str] tags: Tags for annotation of a `Build`. These are not docker tags.
        :param str timeout: Amount of time that this build should be allowed to run, to second granularity. If this amount of time elapses, work on the build will cease and the build status will be `TIMEOUT`. `timeout` starts ticking from `startTime`. Default time is ten minutes.
        :param Mapping[str, str] timing: Stores timing information for phases of the build. Valid keys are: * BUILD: time to execute all build steps * PUSH: time to push all specified images. * FETCHSOURCE: time to fetch source. If the build does not specify source or images, these keys will not be included.
        """
        pulumi.set(__self__, "artifacts", artifacts)
        pulumi.set(__self__, "available_secrets", available_secrets)
        pulumi.set(__self__, "build_trigger_id", build_trigger_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "finish_time", finish_time)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "log_url", log_url)
        pulumi.set(__self__, "logs_bucket", logs_bucket)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "options", options)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "queue_ttl", queue_ttl)
        pulumi.set(__self__, "results", results)
        pulumi.set(__self__, "secrets", secrets)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_provenance", source_provenance)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_detail", status_detail)
        pulumi.set(__self__, "steps", steps)
        pulumi.set(__self__, "substitutions", substitutions)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "timing", timing)

    @property
    @pulumi.getter
    def artifacts(self) -> 'outputs.ArtifactsResponse':
        """
        Artifacts produced by the build that should be uploaded upon successful completion of all build steps.
        """
        return pulumi.get(self, "artifacts")

    @property
    @pulumi.getter(name="availableSecrets")
    def available_secrets(self) -> 'outputs.SecretsResponse':
        """
        Secrets and secret environment variables.
        """
        return pulumi.get(self, "available_secrets")

    @property
    @pulumi.getter(name="buildTriggerId")
    def build_trigger_id(self) -> str:
        """
        The ID of the `BuildTrigger` that triggered this build, if it was triggered automatically.
        """
        return pulumi.get(self, "build_trigger_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the request to create the build was received.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="finishTime")
    def finish_time(self) -> str:
        """
        Time at which execution of the build was finished. The difference between finish_time and start_time is the duration of the build's execution.
        """
        return pulumi.get(self, "finish_time")

    @property
    @pulumi.getter
    def images(self) -> Sequence[str]:
        """
        A list of images to be pushed upon the successful completion of all build steps. The images are pushed using the builder service account's credentials. The digests of the pushed images will be stored in the `Build` resource's results field. If any of the images fail to be pushed, the build status is marked `FAILURE`.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="logUrl")
    def log_url(self) -> str:
        """
        URL to logs for this build in Google Cloud Console.
        """
        return pulumi.get(self, "log_url")

    @property
    @pulumi.getter(name="logsBucket")
    def logs_bucket(self) -> str:
        """
        Google Cloud Storage bucket where logs should be written (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
        """
        return pulumi.get(self, "logs_bucket")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The 'Build' name with format: `projects/{project}/locations/{location}/builds/{build}`, where {build} is a unique identifier generated by the service.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> 'outputs.BuildOptionsResponse':
        """
        Special options for this build.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        ID of the project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="queueTtl")
    def queue_ttl(self) -> str:
        """
        TTL in queue for this build. If provided and the build is enqueued longer than this value, the build will expire and the build status will be `EXPIRED`. The TTL starts ticking from create_time.
        """
        return pulumi.get(self, "queue_ttl")

    @property
    @pulumi.getter
    def results(self) -> 'outputs.ResultsResponse':
        """
        Results of the build.
        """
        return pulumi.get(self, "results")

    @property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.SecretResponse']:
        """
        Secrets to decrypt using Cloud Key Management Service. Note: Secret Manager is the recommended technique for managing sensitive data with Cloud Build. Use `available_secrets` to configure builds to access secrets from Secret Manager. For instructions, see: https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        IAM service account whose credentials will be used at build runtime. Must be of the format `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email address or uniqueId of the service account. 
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter
    def source(self) -> 'outputs.SourceResponse':
        """
        The location of the source files to build.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceProvenance")
    def source_provenance(self) -> 'outputs.SourceProvenanceResponse':
        """
        A permanent fixed identifier for source.
        """
        return pulumi.get(self, "source_provenance")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time at which execution of the build was started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the build.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetail")
    def status_detail(self) -> str:
        """
        Customer-readable message about the current status.
        """
        return pulumi.get(self, "status_detail")

    @property
    @pulumi.getter
    def steps(self) -> Sequence['outputs.BuildStepResponse']:
        """
        Required. The operations to be performed on the workspace.
        """
        return pulumi.get(self, "steps")

    @property
    @pulumi.getter
    def substitutions(self) -> Mapping[str, str]:
        """
        Substitutions data for `Build` resource.
        """
        return pulumi.get(self, "substitutions")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Tags for annotation of a `Build`. These are not docker tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Amount of time that this build should be allowed to run, to second granularity. If this amount of time elapses, work on the build will cease and the build status will be `TIMEOUT`. `timeout` starts ticking from `startTime`. Default time is ten minutes.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def timing(self) -> Mapping[str, str]:
        """
        Stores timing information for phases of the build. Valid keys are: * BUILD: time to execute all build steps * PUSH: time to push all specified images. * FETCHSOURCE: time to fetch source. If the build does not specify source or images, these keys will not be included.
        """
        return pulumi.get(self, "timing")


@pulumi.output_type
class BuildStepResponse(dict):
    """
    A step in the build pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pullTiming":
            suggest = "pull_timing"
        elif key == "secretEnv":
            suggest = "secret_env"
        elif key == "waitFor":
            suggest = "wait_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 dir: str,
                 entrypoint: str,
                 env: Sequence[str],
                 name: str,
                 pull_timing: 'outputs.TimeSpanResponse',
                 secret_env: Sequence[str],
                 status: str,
                 timeout: str,
                 timing: 'outputs.TimeSpanResponse',
                 volumes: Sequence['outputs.VolumeResponse'],
                 wait_for: Sequence[str]):
        """
        A step in the build pipeline.
        :param Sequence[str] args: A list of arguments that will be presented to the step when it is started. If the image used to run the step's container has an entrypoint, the `args` are used as arguments to that entrypoint. If the image does not define an entrypoint, the first element in args is used as the entrypoint, and the remainder will be used as arguments.
        :param str dir: Working directory to use when running this step's container. If this value is a relative path, it is relative to the build's working directory. If this value is absolute, it may be outside the build's working directory, in which case the contents of the path may not be persisted across build step executions, unless a `volume` for that path is specified. If the build specifies a `RepoSource` with `dir` and a step with a `dir`, which specifies an absolute path, the `RepoSource` `dir` is ignored for the step's execution.
        :param str entrypoint: Entrypoint to be used instead of the build step image's default entrypoint. If unset, the image's default entrypoint is used.
        :param Sequence[str] env: A list of environment variable definitions to be used when running a step. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        :param str name: Required. The name of the container image that will run this particular build step. If the image is available in the host's Docker daemon's cache, it will be run directly. If not, the host will attempt to pull the image first, using the builder service account's credentials if necessary. The Docker daemon's cache will already have the latest versions of all of the officially supported build steps ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The Docker daemon will also have cached many of the layers for some popular images, like "ubuntu", "debian", but they will be refreshed at the time you attempt to use them. If you built an image in a previous build step, it will be stored in the host's Docker daemon's cache and is available to use as the name for a later build step.
        :param 'TimeSpanResponse' pull_timing: Stores timing information for pulling this build step's builder image only.
        :param Sequence[str] secret_env: A list of environment variables which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`.
        :param str status: Status of the build step. At this time, build step status is only updated on build completion; step status is not updated in real-time as the build progresses.
        :param str timeout: Time limit for executing this build step. If not defined, the step has no time limit and will be allowed to continue to run until either it completes or the build itself times out.
        :param 'TimeSpanResponse' timing: Stores timing information for executing this build step.
        :param Sequence['VolumeResponse'] volumes: List of volumes to mount into the build step. Each volume is created as an empty volume prior to execution of the build step. Upon completion of the build, volumes and their contents are discarded. Using a named volume in only one step is not valid as it is indicative of a build request with an incorrect configuration.
        :param Sequence[str] wait_for: The ID(s) of the step(s) that this build step depends on. This build step will not start until all the build steps in `wait_for` have completed successfully. If `wait_for` is empty, this build step will start when all previous build steps in the `Build.Steps` list have completed successfully.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "entrypoint", entrypoint)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pull_timing", pull_timing)
        pulumi.set(__self__, "secret_env", secret_env)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "timeout", timeout)
        pulumi.set(__self__, "timing", timing)
        pulumi.set(__self__, "volumes", volumes)
        pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        A list of arguments that will be presented to the step when it is started. If the image used to run the step's container has an entrypoint, the `args` are used as arguments to that entrypoint. If the image does not define an entrypoint, the first element in args is used as the entrypoint, and the remainder will be used as arguments.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def dir(self) -> str:
        """
        Working directory to use when running this step's container. If this value is a relative path, it is relative to the build's working directory. If this value is absolute, it may be outside the build's working directory, in which case the contents of the path may not be persisted across build step executions, unless a `volume` for that path is specified. If the build specifies a `RepoSource` with `dir` and a step with a `dir`, which specifies an absolute path, the `RepoSource` `dir` is ignored for the step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter
    def entrypoint(self) -> str:
        """
        Entrypoint to be used instead of the build step image's default entrypoint. If unset, the image's default entrypoint is used.
        """
        return pulumi.get(self, "entrypoint")

    @property
    @pulumi.getter
    def env(self) -> Sequence[str]:
        """
        A list of environment variable definitions to be used when running a step. The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. The name of the container image that will run this particular build step. If the image is available in the host's Docker daemon's cache, it will be run directly. If not, the host will attempt to pull the image first, using the builder service account's credentials if necessary. The Docker daemon's cache will already have the latest versions of all of the officially supported build steps ([https://github.com/GoogleCloudPlatform/cloud-builders](https://github.com/GoogleCloudPlatform/cloud-builders)). The Docker daemon will also have cached many of the layers for some popular images, like "ubuntu", "debian", but they will be refreshed at the time you attempt to use them. If you built an image in a previous build step, it will be stored in the host's Docker daemon's cache and is available to use as the name for a later build step.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pullTiming")
    def pull_timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for pulling this build step's builder image only.
        """
        return pulumi.get(self, "pull_timing")

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Sequence[str]:
        """
        A list of environment variables which are encrypted using a Cloud Key Management Service crypto key. These values must be specified in the build's `Secret`.
        """
        return pulumi.get(self, "secret_env")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the build step. At this time, build step status is only updated on build completion; step status is not updated in real-time as the build progresses.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Time limit for executing this build step. If not defined, the step has no time limit and will be allowed to continue to run until either it completes or the build itself times out.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter
    def timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for executing this build step.
        """
        return pulumi.get(self, "timing")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        List of volumes to mount into the build step. Each volume is created as an empty volume prior to execution of the build step. Upon completion of the build, volumes and their contents are discarded. Using a named volume in only one step is not valid as it is indicative of a build request with an incorrect configuration.
        """
        return pulumi.get(self, "volumes")

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Sequence[str]:
        """
        The ID(s) of the step(s) that this build step depends on. This build step will not start until all the build steps in `wait_for` have completed successfully. If `wait_for` is empty, this build step will start when all previous build steps in the `Build.Steps` list have completed successfully.
        """
        return pulumi.get(self, "wait_for")


@pulumi.output_type
class BuiltImageResponse(dict):
    """
    An image built by the pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pushTiming":
            suggest = "push_timing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuiltImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuiltImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuiltImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 digest: str,
                 name: str,
                 push_timing: 'outputs.TimeSpanResponse'):
        """
        An image built by the pipeline.
        :param str digest: Docker Registry 2.0 digest.
        :param str name: Name used to push the container image to Google Container Registry, as presented to `docker push`.
        :param 'TimeSpanResponse' push_timing: Stores timing information for pushing the specified image.
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "push_timing", push_timing)

    @property
    @pulumi.getter
    def digest(self) -> str:
        """
        Docker Registry 2.0 digest.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name used to push the container image to Google Container Registry, as presented to `docker push`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="pushTiming")
    def push_timing(self) -> 'outputs.TimeSpanResponse':
        """
        Stores timing information for pushing the specified image.
        """
        return pulumi.get(self, "push_timing")


@pulumi.output_type
class GitHubEventsConfigResponse(dict):
    """
    GitHubEventsConfig describes the configuration of a trigger that creates a build whenever a GitHub event is received. This message is experimental.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "installationId":
            suggest = "installation_id"
        elif key == "pullRequest":
            suggest = "pull_request"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitHubEventsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitHubEventsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitHubEventsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 installation_id: str,
                 name: str,
                 owner: str,
                 pull_request: 'outputs.PullRequestFilterResponse',
                 push: 'outputs.PushFilterResponse'):
        """
        GitHubEventsConfig describes the configuration of a trigger that creates a build whenever a GitHub event is received. This message is experimental.
        :param str installation_id: The installationID that emits the GitHub event.
        :param str name: Name of the repository. For example: The name for https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        :param str owner: Owner of the repository. For example: The owner for https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        :param 'PullRequestFilterResponse' pull_request: filter to match changes in pull requests.
        :param 'PushFilterResponse' push: filter to match changes in refs like branches, tags.
        """
        pulumi.set(__self__, "installation_id", installation_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner", owner)
        pulumi.set(__self__, "pull_request", pull_request)
        pulumi.set(__self__, "push", push)

    @property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> str:
        """
        The installationID that emits the GitHub event.
        """
        return pulumi.get(self, "installation_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the repository. For example: The name for https://github.com/googlecloudplatform/cloud-builders is "cloud-builders".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def owner(self) -> str:
        """
        Owner of the repository. For example: The owner for https://github.com/googlecloudplatform/cloud-builders is "googlecloudplatform".
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter(name="pullRequest")
    def pull_request(self) -> 'outputs.PullRequestFilterResponse':
        """
        filter to match changes in pull requests.
        """
        return pulumi.get(self, "pull_request")

    @property
    @pulumi.getter
    def push(self) -> 'outputs.PushFilterResponse':
        """
        filter to match changes in refs like branches, tags.
        """
        return pulumi.get(self, "push")


@pulumi.output_type
class InlineSecretResponse(dict):
    """
    Pairs a set of secret environment variables mapped to encrypted values with the Cloud KMS key to use to decrypt the value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "envMap":
            suggest = "env_map"
        elif key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InlineSecretResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InlineSecretResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InlineSecretResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 env_map: Mapping[str, str],
                 kms_key_name: str):
        """
        Pairs a set of secret environment variables mapped to encrypted values with the Cloud KMS key to use to decrypt the value.
        :param Mapping[str, str] env_map: Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        :param str kms_key_name: Resource name of Cloud KMS crypto key to decrypt the encrypted value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        pulumi.set(__self__, "env_map", env_map)
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="envMap")
    def env_map(self) -> Mapping[str, str]:
        """
        Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        return pulumi.get(self, "env_map")

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Resource name of Cloud KMS crypto key to decrypt the encrypted value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class PullRequestFilterResponse(dict):
    """
    PullRequestFilter contains filter properties for matching GitHub Pull Requests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commentControl":
            suggest = "comment_control"
        elif key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PullRequestFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PullRequestFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PullRequestFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: str,
                 comment_control: str,
                 invert_regex: bool):
        """
        PullRequestFilter contains filter properties for matching GitHub Pull Requests.
        :param str branch: Regex of branches to match. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param str comment_control: Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        :param bool invert_regex: If true, branches that do NOT match the git_ref will trigger a build.
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "comment_control", comment_control)
        pulumi.set(__self__, "invert_regex", invert_regex)

    @property
    @pulumi.getter
    def branch(self) -> str:
        """
        Regex of branches to match. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="commentControl")
    def comment_control(self) -> str:
        """
        Configure builds to run whether a repository owner or collaborator need to comment `/gcbrun`.
        """
        return pulumi.get(self, "comment_control")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> bool:
        """
        If true, branches that do NOT match the git_ref will trigger a build.
        """
        return pulumi.get(self, "invert_regex")


@pulumi.output_type
class PushFilterResponse(dict):
    """
    Push contains filter properties for matching GitHub git pushes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "invertRegex":
            suggest = "invert_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PushFilterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PushFilterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PushFilterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: str,
                 invert_regex: bool,
                 tag: str):
        """
        Push contains filter properties for matching GitHub git pushes.
        :param str branch: Regexes matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param bool invert_regex: When true, only trigger a build if the revision regex does NOT match the git_ref regex.
        :param str tag: Regexes matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "branch", branch)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter
    def branch(self) -> str:
        """
        Regexes matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> bool:
        """
        When true, only trigger a build if the revision regex does NOT match the git_ref regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Regexes matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class RepoSourceResponse(dict):
    """
    Location of the source in a Google Cloud Source Repository.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "branchName":
            suggest = "branch_name"
        elif key == "commitSha":
            suggest = "commit_sha"
        elif key == "invertRegex":
            suggest = "invert_regex"
        elif key == "projectId":
            suggest = "project_id"
        elif key == "repoName":
            suggest = "repo_name"
        elif key == "tagName":
            suggest = "tag_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepoSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepoSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepoSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch_name: str,
                 commit_sha: str,
                 dir: str,
                 invert_regex: bool,
                 project_id: str,
                 repo_name: str,
                 substitutions: Mapping[str, str],
                 tag_name: str):
        """
        Location of the source in a Google Cloud Source Repository.
        :param str branch_name: Regex matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        :param str commit_sha: Explicit commit SHA to build.
        :param str dir: Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's `dir` is specified and is an absolute path, this value is ignored for that step's execution.
        :param bool invert_regex: Only trigger a build if the revision regex does NOT match the revision regex.
        :param str project_id: ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        :param str repo_name: Name of the Cloud Source Repository.
        :param Mapping[str, str] substitutions: Substitutions to use in a triggered build. Should only be used with RunBuildTrigger
        :param str tag_name: Regex matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        pulumi.set(__self__, "branch_name", branch_name)
        pulumi.set(__self__, "commit_sha", commit_sha)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "invert_regex", invert_regex)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "repo_name", repo_name)
        pulumi.set(__self__, "substitutions", substitutions)
        pulumi.set(__self__, "tag_name", tag_name)

    @property
    @pulumi.getter(name="branchName")
    def branch_name(self) -> str:
        """
        Regex matching branches to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "branch_name")

    @property
    @pulumi.getter(name="commitSha")
    def commit_sha(self) -> str:
        """
        Explicit commit SHA to build.
        """
        return pulumi.get(self, "commit_sha")

    @property
    @pulumi.getter
    def dir(self) -> str:
        """
        Directory, relative to the source root, in which to run the build. This must be a relative path. If a step's `dir` is specified and is an absolute path, this value is ignored for that step's execution.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter(name="invertRegex")
    def invert_regex(self) -> bool:
        """
        Only trigger a build if the revision regex does NOT match the revision regex.
        """
        return pulumi.get(self, "invert_regex")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        ID of the project that owns the Cloud Source Repository. If omitted, the project ID requesting the build is assumed.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        Name of the Cloud Source Repository.
        """
        return pulumi.get(self, "repo_name")

    @property
    @pulumi.getter
    def substitutions(self) -> Mapping[str, str]:
        """
        Substitutions to use in a triggered build. Should only be used with RunBuildTrigger
        """
        return pulumi.get(self, "substitutions")

    @property
    @pulumi.getter(name="tagName")
    def tag_name(self) -> str:
        """
        Regex matching tags to build. The syntax of the regular expressions accepted is the syntax accepted by RE2 and described at https://github.com/google/re2/wiki/Syntax
        """
        return pulumi.get(self, "tag_name")


@pulumi.output_type
class ResultsResponse(dict):
    """
    Artifacts created by the build pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "artifactManifest":
            suggest = "artifact_manifest"
        elif key == "artifactTiming":
            suggest = "artifact_timing"
        elif key == "buildStepImages":
            suggest = "build_step_images"
        elif key == "buildStepOutputs":
            suggest = "build_step_outputs"
        elif key == "numArtifacts":
            suggest = "num_artifacts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResultsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResultsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResultsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 artifact_manifest: str,
                 artifact_timing: 'outputs.TimeSpanResponse',
                 build_step_images: Sequence[str],
                 build_step_outputs: Sequence[str],
                 images: Sequence['outputs.BuiltImageResponse'],
                 num_artifacts: str):
        """
        Artifacts created by the build pipeline.
        :param str artifact_manifest: Path to the artifact manifest. Only populated when artifacts are uploaded.
        :param 'TimeSpanResponse' artifact_timing: Time to push all non-container artifacts.
        :param Sequence[str] build_step_images: List of build step digests, in the order corresponding to build step indices.
        :param Sequence[str] build_step_outputs: List of build step outputs, produced by builder images, in the order corresponding to build step indices. [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders) can produce this output by writing to `$BUILDER_OUTPUT/output`. Only the first 4KB of data is stored.
        :param Sequence['BuiltImageResponse'] images: Container images that were built as a part of the build.
        :param str num_artifacts: Number of artifacts uploaded. Only populated when artifacts are uploaded.
        """
        pulumi.set(__self__, "artifact_manifest", artifact_manifest)
        pulumi.set(__self__, "artifact_timing", artifact_timing)
        pulumi.set(__self__, "build_step_images", build_step_images)
        pulumi.set(__self__, "build_step_outputs", build_step_outputs)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "num_artifacts", num_artifacts)

    @property
    @pulumi.getter(name="artifactManifest")
    def artifact_manifest(self) -> str:
        """
        Path to the artifact manifest. Only populated when artifacts are uploaded.
        """
        return pulumi.get(self, "artifact_manifest")

    @property
    @pulumi.getter(name="artifactTiming")
    def artifact_timing(self) -> 'outputs.TimeSpanResponse':
        """
        Time to push all non-container artifacts.
        """
        return pulumi.get(self, "artifact_timing")

    @property
    @pulumi.getter(name="buildStepImages")
    def build_step_images(self) -> Sequence[str]:
        """
        List of build step digests, in the order corresponding to build step indices.
        """
        return pulumi.get(self, "build_step_images")

    @property
    @pulumi.getter(name="buildStepOutputs")
    def build_step_outputs(self) -> Sequence[str]:
        """
        List of build step outputs, produced by builder images, in the order corresponding to build step indices. [Cloud Builders](https://cloud.google.com/cloud-build/docs/cloud-builders) can produce this output by writing to `$BUILDER_OUTPUT/output`. Only the first 4KB of data is stored.
        """
        return pulumi.get(self, "build_step_outputs")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.BuiltImageResponse']:
        """
        Container images that were built as a part of the build.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="numArtifacts")
    def num_artifacts(self) -> str:
        """
        Number of artifacts uploaded. Only populated when artifacts are uploaded.
        """
        return pulumi.get(self, "num_artifacts")


@pulumi.output_type
class SecretManagerSecretResponse(dict):
    """
    Pairs a secret environment variable with a SecretVersion in Secret Manager.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionName":
            suggest = "version_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretManagerSecretResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretManagerSecretResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretManagerSecretResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 env: str,
                 version_name: str):
        """
        Pairs a secret environment variable with a SecretVersion in Secret Manager.
        :param str env: Environment variable name to associate with the secret. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step.
        :param str version_name: Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "version_name", version_name)

    @property
    @pulumi.getter
    def env(self) -> str:
        """
        Environment variable name to associate with the secret. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="versionName")
    def version_name(self) -> str:
        """
        Resource name of the SecretVersion. In format: projects/*/secrets/*/versions/*
        """
        return pulumi.get(self, "version_name")


@pulumi.output_type
class SecretResponse(dict):
    """
    Pairs a set of secret environment variables containing encrypted values with the Cloud KMS key to use to decrypt the value. Note: Use `kmsKeyName` with `available_secrets` instead of using `kmsKeyName` with `secret`. For instructions see: https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-credentials.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"
        elif key == "secretEnv":
            suggest = "secret_env"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str,
                 secret_env: Mapping[str, str]):
        """
        Pairs a set of secret environment variables containing encrypted values with the Cloud KMS key to use to decrypt the value. Note: Use `kmsKeyName` with `available_secrets` instead of using `kmsKeyName` with `secret`. For instructions see: https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-credentials.
        :param str kms_key_name: Cloud KMS key name to use to decrypt these envs.
        :param Mapping[str, str] secret_env: Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)
        pulumi.set(__self__, "secret_env", secret_env)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Cloud KMS key name to use to decrypt these envs.
        """
        return pulumi.get(self, "kms_key_name")

    @property
    @pulumi.getter(name="secretEnv")
    def secret_env(self) -> Mapping[str, str]:
        """
        Map of environment variable name to its encrypted value. Secret environment variables must be unique across all of a build's secrets, and must be used by at least one build step. Values can be at most 64 KB in size. There can be at most 100 secret values across all of a build's secrets.
        """
        return pulumi.get(self, "secret_env")


@pulumi.output_type
class SecretsResponse(dict):
    """
    Secrets and secret environment variables.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretManager":
            suggest = "secret_manager"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecretsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecretsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecretsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 inline: Sequence['outputs.InlineSecretResponse'],
                 secret_manager: Sequence['outputs.SecretManagerSecretResponse']):
        """
        Secrets and secret environment variables.
        :param Sequence['InlineSecretResponse'] inline: Secrets encrypted with KMS key and the associated secret environment variable.
        :param Sequence['SecretManagerSecretResponse'] secret_manager: Secrets in Secret Manager and associated secret environment variable.
        """
        pulumi.set(__self__, "inline", inline)
        pulumi.set(__self__, "secret_manager", secret_manager)

    @property
    @pulumi.getter
    def inline(self) -> Sequence['outputs.InlineSecretResponse']:
        """
        Secrets encrypted with KMS key and the associated secret environment variable.
        """
        return pulumi.get(self, "inline")

    @property
    @pulumi.getter(name="secretManager")
    def secret_manager(self) -> Sequence['outputs.SecretManagerSecretResponse']:
        """
        Secrets in Secret Manager and associated secret environment variable.
        """
        return pulumi.get(self, "secret_manager")


@pulumi.output_type
class SourceProvenanceResponse(dict):
    """
    Provenance of the source. Ways to find the original source, or verify that some source was used for this build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileHashes":
            suggest = "file_hashes"
        elif key == "resolvedRepoSource":
            suggest = "resolved_repo_source"
        elif key == "resolvedStorageSource":
            suggest = "resolved_storage_source"
        elif key == "resolvedStorageSourceManifest":
            suggest = "resolved_storage_source_manifest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceProvenanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceProvenanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceProvenanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_hashes: Mapping[str, str],
                 resolved_repo_source: 'outputs.RepoSourceResponse',
                 resolved_storage_source: 'outputs.StorageSourceResponse',
                 resolved_storage_source_manifest: 'outputs.StorageSourceManifestResponse'):
        """
        Provenance of the source. Ways to find the original source, or verify that some source was used for this build.
        :param Mapping[str, str] file_hashes: Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. Note that `FileHashes` will only be populated if `BuildOptions` has requested a `SourceProvenanceHash`. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path to that file.
        :param 'RepoSourceResponse' resolved_repo_source: A copy of the build's `source.repo_source`, if exists, with any revisions resolved.
        :param 'StorageSourceResponse' resolved_storage_source: A copy of the build's `source.storage_source`, if exists, with any generations resolved.
        :param 'StorageSourceManifestResponse' resolved_storage_source_manifest: A copy of the build's `source.storage_source_manifest`, if exists, with any revisions resolved. This feature is in Preview.
        """
        pulumi.set(__self__, "file_hashes", file_hashes)
        pulumi.set(__self__, "resolved_repo_source", resolved_repo_source)
        pulumi.set(__self__, "resolved_storage_source", resolved_storage_source)
        pulumi.set(__self__, "resolved_storage_source_manifest", resolved_storage_source_manifest)

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> Mapping[str, str]:
        """
        Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. Note that `FileHashes` will only be populated if `BuildOptions` has requested a `SourceProvenanceHash`. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (`.tar.gz`), the `FileHash` will be for the single path to that file.
        """
        return pulumi.get(self, "file_hashes")

    @property
    @pulumi.getter(name="resolvedRepoSource")
    def resolved_repo_source(self) -> 'outputs.RepoSourceResponse':
        """
        A copy of the build's `source.repo_source`, if exists, with any revisions resolved.
        """
        return pulumi.get(self, "resolved_repo_source")

    @property
    @pulumi.getter(name="resolvedStorageSource")
    def resolved_storage_source(self) -> 'outputs.StorageSourceResponse':
        """
        A copy of the build's `source.storage_source`, if exists, with any generations resolved.
        """
        return pulumi.get(self, "resolved_storage_source")

    @property
    @pulumi.getter(name="resolvedStorageSourceManifest")
    def resolved_storage_source_manifest(self) -> 'outputs.StorageSourceManifestResponse':
        """
        A copy of the build's `source.storage_source_manifest`, if exists, with any revisions resolved. This feature is in Preview.
        """
        return pulumi.get(self, "resolved_storage_source_manifest")


@pulumi.output_type
class SourceResponse(dict):
    """
    Location of the source in a supported storage service.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoSource":
            suggest = "repo_source"
        elif key == "storageSource":
            suggest = "storage_source"
        elif key == "storageSourceManifest":
            suggest = "storage_source_manifest"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repo_source: 'outputs.RepoSourceResponse',
                 storage_source: 'outputs.StorageSourceResponse',
                 storage_source_manifest: 'outputs.StorageSourceManifestResponse'):
        """
        Location of the source in a supported storage service.
        :param 'RepoSourceResponse' repo_source: If provided, get the source from this location in a Cloud Source Repository.
        :param 'StorageSourceResponse' storage_source: If provided, get the source from this location in Google Cloud Storage.
        :param 'StorageSourceManifestResponse' storage_source_manifest: If provided, get the source from this manifest in Google Cloud Storage. This feature is in Preview.
        """
        pulumi.set(__self__, "repo_source", repo_source)
        pulumi.set(__self__, "storage_source", storage_source)
        pulumi.set(__self__, "storage_source_manifest", storage_source_manifest)

    @property
    @pulumi.getter(name="repoSource")
    def repo_source(self) -> 'outputs.RepoSourceResponse':
        """
        If provided, get the source from this location in a Cloud Source Repository.
        """
        return pulumi.get(self, "repo_source")

    @property
    @pulumi.getter(name="storageSource")
    def storage_source(self) -> 'outputs.StorageSourceResponse':
        """
        If provided, get the source from this location in Google Cloud Storage.
        """
        return pulumi.get(self, "storage_source")

    @property
    @pulumi.getter(name="storageSourceManifest")
    def storage_source_manifest(self) -> 'outputs.StorageSourceManifestResponse':
        """
        If provided, get the source from this manifest in Google Cloud Storage. This feature is in Preview.
        """
        return pulumi.get(self, "storage_source_manifest")


@pulumi.output_type
class StorageSourceManifestResponse(dict):
    """
    Location of the source manifest in Google Cloud Storage. This feature is in Preview.
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation: str,
                 object: str):
        """
        Location of the source manifest in Google Cloud Storage. This feature is in Preview.
        :param str bucket: Google Cloud Storage bucket containing the source manifest (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param str generation: Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        :param str object: Google Cloud Storage object containing the source manifest. This object must be a JSON file.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Google Cloud Storage bucket containing the source manifest (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Google Cloud Storage object containing the source manifest. This object must be a JSON file.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class StorageSourceResponse(dict):
    """
    Location of the source in an archive file in Google Cloud Storage.
    """
    def __init__(__self__, *,
                 bucket: str,
                 generation: str,
                 object: str):
        """
        Location of the source in an archive file in Google Cloud Storage.
        :param str bucket: Google Cloud Storage bucket containing the source (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        :param str generation: Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        :param str object: Google Cloud Storage object containing the source. This object must be a gzipped archive file (`.tar.gz`) containing source to build.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Google Cloud Storage bucket containing the source (see [Bucket Name Requirements](https://cloud.google.com/storage/docs/bucket-naming#requirements)).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def generation(self) -> str:
        """
        Google Cloud Storage generation for the object. If the generation is omitted, the latest generation will be used.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Google Cloud Storage object containing the source. This object must be a gzipped archive file (`.tar.gz`) containing source to build.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class TimeSpanResponse(dict):
    """
    Start and end times for a build execution phase.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TimeSpanResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TimeSpanResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TimeSpanResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 start_time: str):
        """
        Start and end times for a build execution phase.
        :param str end_time: End of time span.
        :param str start_time: Start of time span.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        End of time span.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Start of time span.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class VolumeResponse(dict):
    """
    Volume describes a Docker container volume which is mounted into build steps in order to persist files across build step execution.
    """
    def __init__(__self__, *,
                 name: str,
                 path: str):
        """
        Volume describes a Docker container volume which is mounted into build steps in order to persist files across build step execution.
        :param str name: Name of the volume to mount. Volume names must be unique per build step and must be valid names for Docker volumes. Each named volume must be used by at least two build steps.
        :param str path: Path at which to mount the volume. Paths must be absolute and cannot conflict with other volume paths on the same build step or with certain reserved volume paths.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the volume to mount. Volume names must be unique per build step and must be valid names for Docker volumes. Each named volume must be used by at least two build steps.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path at which to mount the volume. Paths must be absolute and cannot conflict with other volume paths on the same build step or with certain reserved volume paths.
        """
        return pulumi.get(self, "path")


