# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = ['RepositoryPackageTagArgs', 'RepositoryPackageTag']

@pulumi.input_type
class RepositoryPackageTagArgs:
    def __init__(__self__, *,
                 locations_id: pulumi.Input[str],
                 packages_id: pulumi.Input[str],
                 projects_id: pulumi.Input[str],
                 repositories_id: pulumi.Input[str],
                 tags_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RepositoryPackageTag resource.
        :param pulumi.Input[str] name: The name of the tag, for example: "projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/tags/tag1".
        :param pulumi.Input[str] version: The name of the version the tag refers to, for example: "projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/versions/sha256:5243811"
        """
        pulumi.set(__self__, "locations_id", locations_id)
        pulumi.set(__self__, "packages_id", packages_id)
        pulumi.set(__self__, "projects_id", projects_id)
        pulumi.set(__self__, "repositories_id", repositories_id)
        pulumi.set(__self__, "tags_id", tags_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="locationsId")
    def locations_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "locations_id")

    @locations_id.setter
    def locations_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "locations_id", value)

    @property
    @pulumi.getter(name="packagesId")
    def packages_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "packages_id")

    @packages_id.setter
    def packages_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "packages_id", value)

    @property
    @pulumi.getter(name="projectsId")
    def projects_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "projects_id")

    @projects_id.setter
    def projects_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "projects_id", value)

    @property
    @pulumi.getter(name="repositoriesId")
    def repositories_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "repositories_id")

    @repositories_id.setter
    def repositories_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "repositories_id", value)

    @property
    @pulumi.getter(name="tagsId")
    def tags_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "tags_id")

    @tags_id.setter
    def tags_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "tags_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the tag, for example: "projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/tags/tag1".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the version the tag refers to, for example: "projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/versions/sha256:5243811"
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class RepositoryPackageTag(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 packages_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 repositories_id: Optional[pulumi.Input[str]] = None,
                 tags_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a tag.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the tag, for example: "projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/tags/tag1".
        :param pulumi.Input[str] version: The name of the version the tag refers to, for example: "projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/versions/sha256:5243811"
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RepositoryPackageTagArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a tag.

        :param str resource_name: The name of the resource.
        :param RepositoryPackageTagArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RepositoryPackageTagArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 locations_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 packages_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 repositories_id: Optional[pulumi.Input[str]] = None,
                 tags_id: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RepositoryPackageTagArgs.__new__(RepositoryPackageTagArgs)

            if locations_id is None and not opts.urn:
                raise TypeError("Missing required property 'locations_id'")
            __props__.__dict__["locations_id"] = locations_id
            __props__.__dict__["name"] = name
            if packages_id is None and not opts.urn:
                raise TypeError("Missing required property 'packages_id'")
            __props__.__dict__["packages_id"] = packages_id
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__.__dict__["projects_id"] = projects_id
            if repositories_id is None and not opts.urn:
                raise TypeError("Missing required property 'repositories_id'")
            __props__.__dict__["repositories_id"] = repositories_id
            if tags_id is None and not opts.urn:
                raise TypeError("Missing required property 'tags_id'")
            __props__.__dict__["tags_id"] = tags_id
            __props__.__dict__["version"] = version
        super(RepositoryPackageTag, __self__).__init__(
            'google-native:artifactregistry/v1beta2:RepositoryPackageTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'RepositoryPackageTag':
        """
        Get an existing RepositoryPackageTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RepositoryPackageTagArgs.__new__(RepositoryPackageTagArgs)

        __props__.__dict__["name"] = None
        __props__.__dict__["version"] = None
        return RepositoryPackageTag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the tag, for example: "projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/tags/tag1".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The name of the version the tag refers to, for example: "projects/p1/locations/us-central1/repositories/repo1/packages/pkg1/versions/sha256:5243811"
        """
        return pulumi.get(self, "version")

