# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OrganizationDeveloperAppKeyArgs', 'OrganizationDeveloperAppKey']

@pulumi.input_type
class OrganizationDeveloperAppKeyArgs:
    def __init__(__self__, *,
                 apps_id: pulumi.Input[str],
                 developers_id: pulumi.Input[str],
                 keys_id: pulumi.Input[str],
                 organizations_id: pulumi.Input[str],
                 api_products: Optional[pulumi.Input[Sequence[Any]]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]] = None,
                 consumer_key: Optional[pulumi.Input[str]] = None,
                 consumer_secret: Optional[pulumi.Input[str]] = None,
                 expires_at: Optional[pulumi.Input[str]] = None,
                 expires_in_seconds: Optional[pulumi.Input[str]] = None,
                 issued_at: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OrganizationDeveloperAppKey resource.
        :param pulumi.Input[Sequence[Any]] api_products: List of API products for which the credential can be used. **Note**: Do not specify the list of API products when creating a consumer key and secret for a developer app. Instead, use the UpdateDeveloperAppKey API to make the association after the consumer key and secret are created.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]] attributes: List of attributes associated with the credential.
        :param pulumi.Input[str] consumer_key: Consumer key.
        :param pulumi.Input[str] consumer_secret: Secret key.
        :param pulumi.Input[str] expires_at: Time the developer app expires in milliseconds since epoch.
        :param pulumi.Input[str] expires_in_seconds: Input only. Expiration time, in seconds, for the consumer key. If not set or left to the default value of `-1`, the API key never expires. The expiration time can't be updated after it is set.
        :param pulumi.Input[str] issued_at: Time the developer app was created in milliseconds since epoch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Scopes to apply to the app. The specified scope names must already be defined for the API product that you associate with the app.
        :param pulumi.Input[str] status: Status of the credential. Valid values include `approved` or `revoked`.
        """
        pulumi.set(__self__, "apps_id", apps_id)
        pulumi.set(__self__, "developers_id", developers_id)
        pulumi.set(__self__, "keys_id", keys_id)
        pulumi.set(__self__, "organizations_id", organizations_id)
        if api_products is not None:
            pulumi.set(__self__, "api_products", api_products)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if consumer_key is not None:
            pulumi.set(__self__, "consumer_key", consumer_key)
        if consumer_secret is not None:
            pulumi.set(__self__, "consumer_secret", consumer_secret)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if expires_in_seconds is not None:
            pulumi.set(__self__, "expires_in_seconds", expires_in_seconds)
        if issued_at is not None:
            pulumi.set(__self__, "issued_at", issued_at)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="appsId")
    def apps_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "apps_id")

    @apps_id.setter
    def apps_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "apps_id", value)

    @property
    @pulumi.getter(name="developersId")
    def developers_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "developers_id")

    @developers_id.setter
    def developers_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "developers_id", value)

    @property
    @pulumi.getter(name="keysId")
    def keys_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "keys_id")

    @keys_id.setter
    def keys_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "keys_id", value)

    @property
    @pulumi.getter(name="organizationsId")
    def organizations_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "organizations_id")

    @organizations_id.setter
    def organizations_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "organizations_id", value)

    @property
    @pulumi.getter(name="apiProducts")
    def api_products(self) -> Optional[pulumi.Input[Sequence[Any]]]:
        """
        List of API products for which the credential can be used. **Note**: Do not specify the list of API products when creating a consumer key and secret for a developer app. Instead, use the UpdateDeveloperAppKey API to make the association after the consumer key and secret are created.
        """
        return pulumi.get(self, "api_products")

    @api_products.setter
    def api_products(self, value: Optional[pulumi.Input[Sequence[Any]]]):
        pulumi.set(self, "api_products", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]:
        """
        List of attributes associated with the credential.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> Optional[pulumi.Input[str]]:
        """
        Consumer key.
        """
        return pulumi.get(self, "consumer_key")

    @consumer_key.setter
    def consumer_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_key", value)

    @property
    @pulumi.getter(name="consumerSecret")
    def consumer_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Secret key.
        """
        return pulumi.get(self, "consumer_secret")

    @consumer_secret.setter
    def consumer_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consumer_secret", value)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time the developer app expires in milliseconds since epoch.
        """
        return pulumi.get(self, "expires_at")

    @expires_at.setter
    def expires_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires_at", value)

    @property
    @pulumi.getter(name="expiresInSeconds")
    def expires_in_seconds(self) -> Optional[pulumi.Input[str]]:
        """
        Input only. Expiration time, in seconds, for the consumer key. If not set or left to the default value of `-1`, the API key never expires. The expiration time can't be updated after it is set.
        """
        return pulumi.get(self, "expires_in_seconds")

    @expires_in_seconds.setter
    def expires_in_seconds(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expires_in_seconds", value)

    @property
    @pulumi.getter(name="issuedAt")
    def issued_at(self) -> Optional[pulumi.Input[str]]:
        """
        Time the developer app was created in milliseconds since epoch.
        """
        return pulumi.get(self, "issued_at")

    @issued_at.setter
    def issued_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issued_at", value)

    @property
    @pulumi.getter
    def scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Scopes to apply to the app. The specified scope names must already be defined for the API product that you associate with the app.
        """
        return pulumi.get(self, "scopes")

    @scopes.setter
    def scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scopes", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the credential. Valid values include `approved` or `revoked`.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class OrganizationDeveloperAppKey(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_products: Optional[pulumi.Input[Sequence[Any]]] = None,
                 apps_id: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AttributeArgs']]]]] = None,
                 consumer_key: Optional[pulumi.Input[str]] = None,
                 consumer_secret: Optional[pulumi.Input[str]] = None,
                 developers_id: Optional[pulumi.Input[str]] = None,
                 expires_at: Optional[pulumi.Input[str]] = None,
                 expires_in_seconds: Optional[pulumi.Input[str]] = None,
                 issued_at: Optional[pulumi.Input[str]] = None,
                 keys_id: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a custom consumer key and secret for a developer app. This is particularly useful if you want to migrate existing consumer keys and secrets to Apigee hybrid from another system. Consumer keys and secrets can contain letters, numbers, underscores, and hyphens. No other special characters are allowed. To avoid service disruptions, a consumer key and secret should not exceed 2 KBs each. **Note**: When creating the consumer key and secret, an association to API products will not be made. Therefore, you should not specify the associated API products in your request. Instead, use the UpdateDeveloperAppKey API to make the association after the consumer key and secret are created. If a consumer key and secret already exist, you can keep them or delete them using the DeleteDeveloperAppKey API.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[Any]] api_products: List of API products for which the credential can be used. **Note**: Do not specify the list of API products when creating a consumer key and secret for a developer app. Instead, use the UpdateDeveloperAppKey API to make the association after the consumer key and secret are created.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AttributeArgs']]]] attributes: List of attributes associated with the credential.
        :param pulumi.Input[str] consumer_key: Consumer key.
        :param pulumi.Input[str] consumer_secret: Secret key.
        :param pulumi.Input[str] expires_at: Time the developer app expires in milliseconds since epoch.
        :param pulumi.Input[str] expires_in_seconds: Input only. Expiration time, in seconds, for the consumer key. If not set or left to the default value of `-1`, the API key never expires. The expiration time can't be updated after it is set.
        :param pulumi.Input[str] issued_at: Time the developer app was created in milliseconds since epoch.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scopes: Scopes to apply to the app. The specified scope names must already be defined for the API product that you associate with the app.
        :param pulumi.Input[str] status: Status of the credential. Valid values include `approved` or `revoked`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationDeveloperAppKeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a custom consumer key and secret for a developer app. This is particularly useful if you want to migrate existing consumer keys and secrets to Apigee hybrid from another system. Consumer keys and secrets can contain letters, numbers, underscores, and hyphens. No other special characters are allowed. To avoid service disruptions, a consumer key and secret should not exceed 2 KBs each. **Note**: When creating the consumer key and secret, an association to API products will not be made. Therefore, you should not specify the associated API products in your request. Instead, use the UpdateDeveloperAppKey API to make the association after the consumer key and secret are created. If a consumer key and secret already exist, you can keep them or delete them using the DeleteDeveloperAppKey API.

        :param str resource_name: The name of the resource.
        :param OrganizationDeveloperAppKeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationDeveloperAppKeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_products: Optional[pulumi.Input[Sequence[Any]]] = None,
                 apps_id: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1AttributeArgs']]]]] = None,
                 consumer_key: Optional[pulumi.Input[str]] = None,
                 consumer_secret: Optional[pulumi.Input[str]] = None,
                 developers_id: Optional[pulumi.Input[str]] = None,
                 expires_at: Optional[pulumi.Input[str]] = None,
                 expires_in_seconds: Optional[pulumi.Input[str]] = None,
                 issued_at: Optional[pulumi.Input[str]] = None,
                 keys_id: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationDeveloperAppKeyArgs.__new__(OrganizationDeveloperAppKeyArgs)

            __props__.__dict__["api_products"] = api_products
            if apps_id is None and not opts.urn:
                raise TypeError("Missing required property 'apps_id'")
            __props__.__dict__["apps_id"] = apps_id
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["consumer_key"] = consumer_key
            __props__.__dict__["consumer_secret"] = consumer_secret
            if developers_id is None and not opts.urn:
                raise TypeError("Missing required property 'developers_id'")
            __props__.__dict__["developers_id"] = developers_id
            __props__.__dict__["expires_at"] = expires_at
            __props__.__dict__["expires_in_seconds"] = expires_in_seconds
            __props__.__dict__["issued_at"] = issued_at
            if keys_id is None and not opts.urn:
                raise TypeError("Missing required property 'keys_id'")
            __props__.__dict__["keys_id"] = keys_id
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__.__dict__["organizations_id"] = organizations_id
            __props__.__dict__["scopes"] = scopes
            __props__.__dict__["status"] = status
        super(OrganizationDeveloperAppKey, __self__).__init__(
            'google-native:apigee/v1:OrganizationDeveloperAppKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'OrganizationDeveloperAppKey':
        """
        Get an existing OrganizationDeveloperAppKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = OrganizationDeveloperAppKeyArgs.__new__(OrganizationDeveloperAppKeyArgs)

        __props__.__dict__["api_products"] = None
        __props__.__dict__["attributes"] = None
        __props__.__dict__["consumer_key"] = None
        __props__.__dict__["consumer_secret"] = None
        __props__.__dict__["expires_at"] = None
        __props__.__dict__["expires_in_seconds"] = None
        __props__.__dict__["issued_at"] = None
        __props__.__dict__["scopes"] = None
        __props__.__dict__["status"] = None
        return OrganizationDeveloperAppKey(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apiProducts")
    def api_products(self) -> pulumi.Output[Sequence[Any]]:
        """
        List of API products for which the credential can be used. **Note**: Do not specify the list of API products when creating a consumer key and secret for a developer app. Instead, use the UpdateDeveloperAppKey API to make the association after the consumer key and secret are created.
        """
        return pulumi.get(self, "api_products")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Sequence['outputs.GoogleCloudApigeeV1AttributeResponse']]:
        """
        List of attributes associated with the credential.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="consumerKey")
    def consumer_key(self) -> pulumi.Output[str]:
        """
        Consumer key.
        """
        return pulumi.get(self, "consumer_key")

    @property
    @pulumi.getter(name="consumerSecret")
    def consumer_secret(self) -> pulumi.Output[str]:
        """
        Secret key.
        """
        return pulumi.get(self, "consumer_secret")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[str]:
        """
        Time the developer app expires in milliseconds since epoch.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter(name="expiresInSeconds")
    def expires_in_seconds(self) -> pulumi.Output[str]:
        """
        Input only. Expiration time, in seconds, for the consumer key. If not set or left to the default value of `-1`, the API key never expires. The expiration time can't be updated after it is set.
        """
        return pulumi.get(self, "expires_in_seconds")

    @property
    @pulumi.getter(name="issuedAt")
    def issued_at(self) -> pulumi.Output[str]:
        """
        Time the developer app was created in milliseconds since epoch.
        """
        return pulumi.get(self, "issued_at")

    @property
    @pulumi.getter
    def scopes(self) -> pulumi.Output[Sequence[str]]:
        """
        Scopes to apply to the app. The specified scope names must already be defined for the API product that you associate with the app.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the credential. Valid values include `approved` or `revoked`.
        """
        return pulumi.get(self, "status")

