# autogenerated
# mypy: ignore-errors
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from rime_sdk.protos.test_run_results import test_run_results_pb2 as protos_dot_test__run__results_dot_test__run__results__pb2


class ResultsReaderStub(object):
    """All fields of entity messages are assumed to be immutable unless otherwise specified.
    For example, we mark the "resolved" field of TestCase as mutable with a comment, and
    thus it is present in the TestCaseWriteMask.

    One set of CRUD RPCs that operate the entire test run tree is too complicated to use,
    so we chose to have CRUD endpoints at each level of the test run endpoints.
    Clients can fetch individual nodes of the test run tree more easily and we can
    worry less about running into the 4mb Protobuf message size limit.

    Create methods allow immutable methods to be set and thus should only be used
    by clients with appropriate privileges.
    Internal services such as the RIME engine can use these RPCs.

    ResultsReader is a service for querying test run results.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.GetTestRun = channel.unary_unary(
                '/rime.ResultsReader/GetTestRun',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestRunRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestRunResponse.FromString,
                )
        self.ListTestRuns = channel.unary_stream(
                '/rime.ResultsReader/ListTestRuns',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestRunsRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestRunsResponse.FromString,
                )
        self.GetTestBatch = channel.unary_unary(
                '/rime.ResultsReader/GetTestBatch',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestBatchRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestBatchResponse.FromString,
                )
        self.ListTestBatches = channel.unary_stream(
                '/rime.ResultsReader/ListTestBatches',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestBatchesRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestBatchesResponse.FromString,
                )
        self.GetTestCase = channel.unary_unary(
                '/rime.ResultsReader/GetTestCase',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestCaseRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestCaseResponse.FromString,
                )
        self.ListTestCases = channel.unary_unary(
                '/rime.ResultsReader/ListTestCases',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestCasesRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestCasesResponse.FromString,
                )
        self.GetFeatureResult = channel.unary_unary(
                '/rime.ResultsReader/GetFeatureResult',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetFeatureResultRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetFeatureResultResponse.FromString,
                )
        self.ListFeatureResults = channel.unary_stream(
                '/rime.ResultsReader/ListFeatureResults',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListFeatureResultsRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListFeatureResultsResponse.FromString,
                )


class ResultsReaderServicer(object):
    """All fields of entity messages are assumed to be immutable unless otherwise specified.
    For example, we mark the "resolved" field of TestCase as mutable with a comment, and
    thus it is present in the TestCaseWriteMask.

    One set of CRUD RPCs that operate the entire test run tree is too complicated to use,
    so we chose to have CRUD endpoints at each level of the test run endpoints.
    Clients can fetch individual nodes of the test run tree more easily and we can
    worry less about running into the 4mb Protobuf message size limit.

    Create methods allow immutable methods to be set and thus should only be used
    by clients with appropriate privileges.
    Internal services such as the RIME engine can use these RPCs.

    ResultsReader is a service for querying test run results.
    """

    def GetTestRun(self, request, context):
        """
        ----- Read operations for test runs -----
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListTestRuns(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTestBatch(self, request, context):
        """
        ----- Read operations for test batches -----

        Size-unbounded data like failing rows and sensitivity will be returned
        in separate endpoints.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListTestBatches(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTestCase(self, request, context):
        """
        ----- Read operations for test cases -----
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListTestCases(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetFeatureResult(self, request, context):
        """
        ----- Read operations for feature results -----
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListFeatureResults(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ResultsReaderServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'GetTestRun': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTestRun,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestRunRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestRunResponse.SerializeToString,
            ),
            'ListTestRuns': grpc.unary_stream_rpc_method_handler(
                    servicer.ListTestRuns,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestRunsRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestRunsResponse.SerializeToString,
            ),
            'GetTestBatch': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTestBatch,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestBatchRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestBatchResponse.SerializeToString,
            ),
            'ListTestBatches': grpc.unary_stream_rpc_method_handler(
                    servicer.ListTestBatches,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestBatchesRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestBatchesResponse.SerializeToString,
            ),
            'GetTestCase': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTestCase,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestCaseRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetTestCaseResponse.SerializeToString,
            ),
            'ListTestCases': grpc.unary_unary_rpc_method_handler(
                    servicer.ListTestCases,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestCasesRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListTestCasesResponse.SerializeToString,
            ),
            'GetFeatureResult': grpc.unary_unary_rpc_method_handler(
                    servicer.GetFeatureResult,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetFeatureResultRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.GetFeatureResultResponse.SerializeToString,
            ),
            'ListFeatureResults': grpc.unary_stream_rpc_method_handler(
                    servicer.ListFeatureResults,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListFeatureResultsRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.ListFeatureResultsResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'rime.ResultsReader', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ResultsReader(object):
    """All fields of entity messages are assumed to be immutable unless otherwise specified.
    For example, we mark the "resolved" field of TestCase as mutable with a comment, and
    thus it is present in the TestCaseWriteMask.

    One set of CRUD RPCs that operate the entire test run tree is too complicated to use,
    so we chose to have CRUD endpoints at each level of the test run endpoints.
    Clients can fetch individual nodes of the test run tree more easily and we can
    worry less about running into the 4mb Protobuf message size limit.

    Create methods allow immutable methods to be set and thus should only be used
    by clients with appropriate privileges.
    Internal services such as the RIME engine can use these RPCs.

    ResultsReader is a service for querying test run results.
    """

    @staticmethod
    def GetTestRun(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsReader/GetTestRun',
            protos_dot_test__run__results_dot_test__run__results__pb2.GetTestRunRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.GetTestRunResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListTestRuns(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/rime.ResultsReader/ListTestRuns',
            protos_dot_test__run__results_dot_test__run__results__pb2.ListTestRunsRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.ListTestRunsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetTestBatch(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsReader/GetTestBatch',
            protos_dot_test__run__results_dot_test__run__results__pb2.GetTestBatchRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.GetTestBatchResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListTestBatches(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/rime.ResultsReader/ListTestBatches',
            protos_dot_test__run__results_dot_test__run__results__pb2.ListTestBatchesRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.ListTestBatchesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetTestCase(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsReader/GetTestCase',
            protos_dot_test__run__results_dot_test__run__results__pb2.GetTestCaseRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.GetTestCaseResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListTestCases(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsReader/ListTestCases',
            protos_dot_test__run__results_dot_test__run__results__pb2.ListTestCasesRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.ListTestCasesResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def GetFeatureResult(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsReader/GetFeatureResult',
            protos_dot_test__run__results_dot_test__run__results__pb2.GetFeatureResultRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.GetFeatureResultResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def ListFeatureResults(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(request, target, '/rime.ResultsReader/ListFeatureResults',
            protos_dot_test__run__results_dot_test__run__results__pb2.ListFeatureResultsRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.ListFeatureResultsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)


class ResultsWriterStub(object):
    """ResultsWriter is a service for creating and modifying test run results.
    Create RPCs are omitted because we are still using the ResultsStore
    to upload test run results and the TestRunTracker to create tracking information.
    Our way of creating test run results going forward will use some sort of
    pubsub abstraction for the RIME engine.
    Additionally, we do not want users to create their own test run results; that would
    be unfortunate for RI's business if anyone could create their own RIME.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.UpdateTestRun = channel.unary_unary(
                '/rime.ResultsWriter/UpdateTestRun',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestRunRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestRunResponse.FromString,
                )
        self.DeleteTestRun = channel.unary_unary(
                '/rime.ResultsWriter/DeleteTestRun',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.DeleteTestRunRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.DeleteTestRunResponse.FromString,
                )
        self.MoveTestRuns = channel.unary_unary(
                '/rime.ResultsWriter/MoveTestRuns',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.MoveTestRunsRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.MoveTestRunsResponse.FromString,
                )
        self.UpdateTestBatch = channel.unary_unary(
                '/rime.ResultsWriter/UpdateTestBatch',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestBatchRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestBatchResponse.FromString,
                )
        self.UpdateTestCase = channel.unary_unary(
                '/rime.ResultsWriter/UpdateTestCase',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestCaseRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestCaseResponse.FromString,
                )
        self.UpdateFeatureResult = channel.unary_unary(
                '/rime.ResultsWriter/UpdateFeatureResult',
                request_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateFeatureResultRequest.SerializeToString,
                response_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateFeatureResultResponse.FromString,
                )


class ResultsWriterServicer(object):
    """ResultsWriter is a service for creating and modifying test run results.
    Create RPCs are omitted because we are still using the ResultsStore
    to upload test run results and the TestRunTracker to create tracking information.
    Our way of creating test run results going forward will use some sort of
    pubsub abstraction for the RIME engine.
    Additionally, we do not want users to create their own test run results; that would
    be unfortunate for RI's business if anyone could create their own RIME.
    """

    def UpdateTestRun(self, request, context):
        """
        ----- Write operations for test runs -----
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteTestRun(self, request, context):
        """DeleteTestRun propagates the delete to all children (test batches, test cases,
        and feature results).
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def MoveTestRuns(self, request, context):
        """This should be its own RPC because there may be complicated backend
        logic required to move test runs around.
        N calls to UpdateTestRun with the projectID being changed does not seem good.
        This is an all-or-nothing call - either all test runs exist in the source project
        and are moved successfully to the destination project or nothing happens.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateTestBatch(self, request, context):
        """
        ----- Write operations for test batches -----
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateTestCase(self, request, context):
        """
        ----- Write operations for test cases -----
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def UpdateFeatureResult(self, request, context):
        """
        ----- Write operations for feature results -----
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ResultsWriterServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'UpdateTestRun': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateTestRun,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestRunRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestRunResponse.SerializeToString,
            ),
            'DeleteTestRun': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteTestRun,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.DeleteTestRunRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.DeleteTestRunResponse.SerializeToString,
            ),
            'MoveTestRuns': grpc.unary_unary_rpc_method_handler(
                    servicer.MoveTestRuns,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.MoveTestRunsRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.MoveTestRunsResponse.SerializeToString,
            ),
            'UpdateTestBatch': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateTestBatch,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestBatchRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestBatchResponse.SerializeToString,
            ),
            'UpdateTestCase': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateTestCase,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestCaseRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestCaseResponse.SerializeToString,
            ),
            'UpdateFeatureResult': grpc.unary_unary_rpc_method_handler(
                    servicer.UpdateFeatureResult,
                    request_deserializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateFeatureResultRequest.FromString,
                    response_serializer=protos_dot_test__run__results_dot_test__run__results__pb2.UpdateFeatureResultResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'rime.ResultsWriter', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ResultsWriter(object):
    """ResultsWriter is a service for creating and modifying test run results.
    Create RPCs are omitted because we are still using the ResultsStore
    to upload test run results and the TestRunTracker to create tracking information.
    Our way of creating test run results going forward will use some sort of
    pubsub abstraction for the RIME engine.
    Additionally, we do not want users to create their own test run results; that would
    be unfortunate for RI's business if anyone could create their own RIME.
    """

    @staticmethod
    def UpdateTestRun(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsWriter/UpdateTestRun',
            protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestRunRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestRunResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def DeleteTestRun(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsWriter/DeleteTestRun',
            protos_dot_test__run__results_dot_test__run__results__pb2.DeleteTestRunRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.DeleteTestRunResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def MoveTestRuns(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsWriter/MoveTestRuns',
            protos_dot_test__run__results_dot_test__run__results__pb2.MoveTestRunsRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.MoveTestRunsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UpdateTestBatch(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsWriter/UpdateTestBatch',
            protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestBatchRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestBatchResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UpdateTestCase(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsWriter/UpdateTestCase',
            protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestCaseRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.UpdateTestCaseResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def UpdateFeatureResult(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/rime.ResultsWriter/UpdateFeatureResult',
            protos_dot_test__run__results_dot_test__run__results__pb2.UpdateFeatureResultRequest.SerializeToString,
            protos_dot_test__run__results_dot_test__run__results__pb2.UpdateFeatureResultResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
