/*
 * Decompiled with CFR 0.152.
 */
package org.cellprofiler.runnablequeue;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;

public class RunnableQueue
implements Runnable {
    private static SynchronousQueue<Runnable> queue = new SynchronousQueue();

    @Override
    public void run() {
        try {
            while (true) {
                Runnable runnable = queue.take();
                runnable.run();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static void enqueue(Runnable runnable) throws InterruptedException {
        queue.put(new FutureTask<Object>(runnable, null));
    }

    public static void execute(Runnable runnable) throws InterruptedException, ExecutionException {
        FutureTask<Object> futureTask = new FutureTask<Object>(runnable, null);
        RunnableQueue.enqueue(futureTask);
        futureTask.get();
    }

    public static <V> V execute(Callable<V> callable) throws InterruptedException, ExecutionException {
        FutureTask<V> futureTask = new FutureTask<V>(callable);
        RunnableQueue.enqueue(futureTask);
        return futureTask.get();
    }

    public static void stop() throws InterruptedException, ExecutionException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().interrupt();
            }
        };
        RunnableQueue.execute(runnable);
    }
}

