"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * An Origin that represents a group.
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 */
class OriginGroup {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_origins_OriginGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, OriginGroup);
            }
            throw error;
        }
    }
    bind(scope, options) {
        const primaryOriginConfig = this.props.primaryOrigin.bind(scope, options);
        if (primaryOriginConfig.failoverConfig) {
            throw new Error('An OriginGroup cannot use an Origin with its own failover configuration as its primary origin!');
        }
        return {
            originProperty: primaryOriginConfig.originProperty,
            failoverConfig: {
                failoverOrigin: this.props.fallbackOrigin,
                statusCodes: this.props.fallbackStatusCodes,
            },
        };
    }
}
exports.OriginGroup = OriginGroup;
_a = JSII_RTTI_SYMBOL_1;
OriginGroup[_a] = { fqn: "@aws-cdk/aws-cloudfront-origins.OriginGroup", version: "1.175.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3JpZ2luLWdyb3VwLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsib3JpZ2luLWdyb3VwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQXlCQTs7OztHQUlHO0FBQ0gsTUFBYSxXQUFXO0lBQ3RCLFlBQW9DLEtBQXVCO1FBQXZCLFVBQUssR0FBTCxLQUFLLENBQWtCOzs7Ozs7K0NBRGhELFdBQVc7Ozs7S0FFckI7SUFFTSxJQUFJLENBQUMsS0FBZ0IsRUFBRSxPQUFxQztRQUNqRSxNQUFNLG1CQUFtQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxLQUFLLEVBQUUsT0FBTyxDQUFDLENBQUM7UUFDMUUsSUFBSSxtQkFBbUIsQ0FBQyxjQUFjLEVBQUU7WUFDdEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxnR0FBZ0csQ0FBQyxDQUFDO1NBQ25IO1FBRUQsT0FBTztZQUNMLGNBQWMsRUFBRSxtQkFBbUIsQ0FBQyxjQUFjO1lBQ2xELGNBQWMsRUFBRTtnQkFDZCxjQUFjLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxjQUFjO2dCQUN6QyxXQUFXLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxtQkFBbUI7YUFDNUM7U0FDRixDQUFDO0tBQ0g7O0FBakJILGtDQWtCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNsb3VkZnJvbnQgZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBmb3Ige0BsaW5rIE9yaWdpbkdyb3VwfS4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgT3JpZ2luR3JvdXBQcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgcHJpbWFyeSBvcmlnaW4gdGhhdCBzaG91bGQgc2VydmUgcmVxdWVzdHMgZm9yIHRoaXMgZ3JvdXAuXG4gICAqL1xuICByZWFkb25seSBwcmltYXJ5T3JpZ2luOiBjbG91ZGZyb250LklPcmlnaW47XG5cbiAgLyoqXG4gICAqIFRoZSBmYWxsYmFjayBvcmlnaW4gdGhhdCBzaG91bGQgc2VydmUgcmVxdWVzdHMgd2hlbiB0aGUgcHJpbWFyeSBmYWlscy5cbiAgICovXG4gIHJlYWRvbmx5IGZhbGxiYWNrT3JpZ2luOiBjbG91ZGZyb250LklPcmlnaW47XG5cbiAgLyoqXG4gICAqIFRoZSBsaXN0IG9mIEhUVFAgc3RhdHVzIGNvZGVzIHRoYXQsXG4gICAqIHdoZW4gcmV0dXJuZWQgZnJvbSB0aGUgcHJpbWFyeSBvcmlnaW4sXG4gICAqIHdvdWxkIGNhdXNlIHF1ZXJ5aW5nIHRoZSBmYWxsYmFjayBvcmlnaW4uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gNTAwLCA1MDIsIDUwMyBhbmQgNTA0XG4gICAqL1xuICByZWFkb25seSBmYWxsYmFja1N0YXR1c0NvZGVzPzogbnVtYmVyW107XG59XG5cbi8qKlxuICogQW4gT3JpZ2luIHRoYXQgcmVwcmVzZW50cyBhIGdyb3VwLlxuICogQ29uc2lzdHMgb2YgYSBwcmltYXJ5IE9yaWdpbixcbiAqIGFuZCBhIGZhbGxiYWNrIE9yaWdpbiBjYWxsZWQgd2hlbiB0aGUgcHJpbWFyeSByZXR1cm5zIG9uZSBvZiB0aGUgcHJvdmlkZWQgSFRUUCBzdGF0dXMgY29kZXMuXG4gKi9cbmV4cG9ydCBjbGFzcyBPcmlnaW5Hcm91cCBpbXBsZW1lbnRzIGNsb3VkZnJvbnQuSU9yaWdpbiB7XG4gIHB1YmxpYyBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBPcmlnaW5Hcm91cFByb3BzKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChzY29wZTogQ29uc3RydWN0LCBvcHRpb25zOiBjbG91ZGZyb250Lk9yaWdpbkJpbmRPcHRpb25zKTogY2xvdWRmcm9udC5PcmlnaW5CaW5kQ29uZmlnIHtcbiAgICBjb25zdCBwcmltYXJ5T3JpZ2luQ29uZmlnID0gdGhpcy5wcm9wcy5wcmltYXJ5T3JpZ2luLmJpbmQoc2NvcGUsIG9wdGlvbnMpO1xuICAgIGlmIChwcmltYXJ5T3JpZ2luQ29uZmlnLmZhaWxvdmVyQ29uZmlnKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ0FuIE9yaWdpbkdyb3VwIGNhbm5vdCB1c2UgYW4gT3JpZ2luIHdpdGggaXRzIG93biBmYWlsb3ZlciBjb25maWd1cmF0aW9uIGFzIGl0cyBwcmltYXJ5IG9yaWdpbiEnKTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgb3JpZ2luUHJvcGVydHk6IHByaW1hcnlPcmlnaW5Db25maWcub3JpZ2luUHJvcGVydHksXG4gICAgICBmYWlsb3ZlckNvbmZpZzoge1xuICAgICAgICBmYWlsb3Zlck9yaWdpbjogdGhpcy5wcm9wcy5mYWxsYmFja09yaWdpbixcbiAgICAgICAgc3RhdHVzQ29kZXM6IHRoaXMucHJvcHMuZmFsbGJhY2tTdGF0dXNDb2RlcyxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19