# coding: utf-8

"""
    Internal API

    SmartDiagnostics REST API for internal users only  # noqa: E501

    OpenAPI spec version: v3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from smart_diagnostics_client.api_client import ApiClient


class RepeatersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def export_repeaters(self, **kwargs):  # noqa: E501
        """Requests a Repeater export.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_repeaters(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `RadioMacAddress` | String | `eq, neq, in, like, isnull, isnotnull` | | `SerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `CorporationName` | String | | `Id` | Int64 | | `LastStatusUpdate` | DateTime? | | `LocationName` | String | | `Name` | String | | `RadioMacAddress` | String | | `SerialNumber` | String | | `SoftwareVersion` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Name`, `SerialNumber`, `SoftwareVersion`.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.export_repeaters_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.export_repeaters_with_http_info(**kwargs)  # noqa: E501
            return data

    def export_repeaters_with_http_info(self, **kwargs):  # noqa: E501
        """Requests a Repeater export.  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.export_repeaters_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `RadioMacAddress` | String | `eq, neq, in, like, isnull, isnotnull` | | `SerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `CorporationName` | String | | `Id` | Int64 | | `LastStatusUpdate` | DateTime? | | `LocationName` | String | | `Name` | String | | `RadioMacAddress` | String | | `SerialNumber` | String | | `SoftwareVersion` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Name`, `SerialNumber`, `SoftwareVersion`.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['filter', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method export_repeaters" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Repeaters/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_repeater_overview(self, repeater_id, **kwargs):  # noqa: E501
        """Gets a single repeater overview  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repeater_overview(repeater_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int repeater_id: Id of the repeater to retrieve information (required)
        :param bool include_state:
        :return: RepeaterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_repeater_overview_with_http_info(repeater_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_repeater_overview_with_http_info(repeater_id, **kwargs)  # noqa: E501
            return data

    def get_repeater_overview_with_http_info(self, repeater_id, **kwargs):  # noqa: E501
        """Gets a single repeater overview  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repeater_overview_with_http_info(repeater_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int repeater_id: Id of the repeater to retrieve information (required)
        :param bool include_state:
        :return: RepeaterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repeater_id', 'include_state']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repeater_overview" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repeater_id' is set
        if ('repeater_id' not in params or
                params['repeater_id'] is None):
            raise ValueError("Missing the required parameter `repeater_id` when calling `get_repeater_overview`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repeater_id' in params:
            path_params['repeaterId'] = params['repeater_id']  # noqa: E501

        query_params = []
        if 'include_state' in params:
            query_params.append(('includeState', params['include_state']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Repeaters/{repeaterId}/overview', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RepeaterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_repeaters_overview(self, **kwargs):  # noqa: E501
        """Gets repeaters  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repeaters_overview(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_state:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `RadioMacAddress` | String | `eq, neq, in, like, isnull, isnotnull` | | `SerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `CorporationName` | String | | `Id` | Int64 | | `LastStatusUpdate` | DateTime? | | `LocationName` | String | | `Name` | String | | `RadioMacAddress` | String | | `SerialNumber` | String | | `SoftwareVersion` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Name`, `SerialNumber`, `SoftwareVersion`.
        :return: PagedResultsModelRepeaterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_repeaters_overview_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_repeaters_overview_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_repeaters_overview_with_http_info(self, **kwargs):  # noqa: E501
        """Gets repeaters  # noqa: E501

        Required Permissions: Location User  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repeaters_overview_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param bool include_state:
        :param str filter: Filter statements to narrow results by properties. Filterable properties:  | Field name | Type | Operators | | ---------- | ---- | --------- | | `Active` | Boolean | `eq, neq` | | `Corporation` | CorporationChild | `isnull, isnotnull` | | `CorporationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `CorporationId` | Guid | `eq, neq, in` | | `CorporationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `Id` | Int64 | `eq, neq, in, lt, gt, leq, geq` | | `Location` | LocationChild | `isnull, isnotnull` | | `LocationAbbreviation` | String | `eq, neq, in, like, isnull, isnotnull` | | `LocationId` | Guid | `eq, neq, in` | | `LocationName` | String | `eq, neq, in, like, isnull, isnotnull` | | `RadioMacAddress` | String | `eq, neq, in, like, isnull, isnotnull` | | `SerialNumber` | String | `eq, neq, in, like, isnull, isnotnull` |
        :param int page: Results page. 1-based (1 returns the first page, 0 is invalid).
        :param int page_limit: Number of items to return per page.
        :param str order_by: Allows sorting response items by multiple fields. Sortable properties: | Field name | Type | | ---------- | ---- | | `Active` | Boolean | | `CorporationName` | String | | `Id` | Int64 | | `LastStatusUpdate` | DateTime? | | `LocationName` | String | | `Name` | String | | `RadioMacAddress` | String | | `SerialNumber` | String | | `SoftwareVersion` | String |
        :param str name_search: Provide search terms to narrow result.  Searchable properties: `CorporationName`, `LocationName`, `Name`, `SerialNumber`, `SoftwareVersion`.
        :return: PagedResultsModelRepeaterResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_state', 'filter', 'page', 'page_limit', 'order_by', 'name_search']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repeaters_overview" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'include_state' in params:
            query_params.append(('includeState', params['include_state']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501
        if 'page' in params:
            query_params.append(('Page', params['page']))  # noqa: E501
        if 'page_limit' in params:
            query_params.append(('PageLimit', params['page_limit']))  # noqa: E501
        if 'order_by' in params:
            query_params.append(('OrderBy', params['order_by']))  # noqa: E501
        if 'name_search' in params:
            query_params.append(('NameSearch', params['name_search']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/v3.0/Repeaters/overview', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PagedResultsModelRepeaterResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
