# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rasa',
 'rasa.cli',
 'rasa.cli.arguments',
 'rasa.cli.initial_project.actions',
 'rasa.core',
 'rasa.core.actions',
 'rasa.core.brokers',
 'rasa.core.channels',
 'rasa.core.evaluation',
 'rasa.core.featurizers',
 'rasa.core.nlg',
 'rasa.core.policies',
 'rasa.core.training',
 'rasa.core.training.converters',
 'rasa.engine',
 'rasa.engine.recipes',
 'rasa.engine.runner',
 'rasa.engine.storage',
 'rasa.engine.training',
 'rasa.graph_components',
 'rasa.graph_components.converters',
 'rasa.graph_components.providers',
 'rasa.graph_components.validators',
 'rasa.nlu',
 'rasa.nlu.classifiers',
 'rasa.nlu.emulators',
 'rasa.nlu.extractors',
 'rasa.nlu.featurizers',
 'rasa.nlu.featurizers.dense_featurizer',
 'rasa.nlu.featurizers.sparse_featurizer',
 'rasa.nlu.selectors',
 'rasa.nlu.tokenizers',
 'rasa.nlu.utils',
 'rasa.nlu.utils.hugging_face',
 'rasa.shared',
 'rasa.shared.core',
 'rasa.shared.core.training_data',
 'rasa.shared.core.training_data.story_reader',
 'rasa.shared.core.training_data.story_writer',
 'rasa.shared.importers',
 'rasa.shared.nlu',
 'rasa.shared.nlu.training_data',
 'rasa.shared.nlu.training_data.formats',
 'rasa.shared.nlu.training_data.schemas',
 'rasa.shared.utils',
 'rasa.shared.utils.schemas',
 'rasa.utils',
 'rasa.utils.tensorflow']

package_data = \
{'': ['*'],
 'rasa.cli': ['initial_project/*',
              'initial_project/data/*',
              'initial_project/tests/*'],
 'rasa.engine.recipes': ['config_files/*']}

install_requires = \
['CacheControl>=0.12.9,<0.13.0',
 'PyJWT[crypto]>=2.0.0,<3.0.0',
 'SQLAlchemy>=1.4.0,<1.5.0',
 'absl-py>=0.9,<1.4',
 'aio-pika>=6.7.1,<9.0.0',
 'aiogram<2.24',
 'aiohttp>=3.6,!=3.7.4.post0,<3.9',
 'apscheduler>=3.6,<3.10',
 'attrs>=19.3,<22.2',
 'boto3>=1.12,<2.0',
 'cloudpickle>=1.2,<2.3',
 'colorclass>=2.2,<2.3',
 'coloredlogs>=10,<16',
 'colorhash>=1.0.2,<1.3.0',
 'confluent-kafka>=1.9.2,<2.0.0',
 'fbmessenger>=6.0.0,<6.1.0',
 'google-auth<3',
 'joblib>=0.15.1,<1.3.0',
 'jsonpickle>=1.3,<3.1',
 'jsonschema>=3.2,<4.18',
 'matplotlib>=3.1,<3.6',
 'mattermostwrapper>=2.2,<2.3',
 'networkx>=2.4,<2.7',
 'packaging>=20.0,<21.0',
 'pluggy>=1.0.0,<2.0.0',
 'prompt-toolkit>=3.0,<3.0.29',
 'protobuf>=3.9.2,<3.20',
 'psycopg2-binary>=2.8.2,<2.10.0',
 'pydot>=1.4,<1.5',
 'pykwalify>=1.7,<1.9',
 'pymongo[srv,tls]>=3.8,<3.11',
 'python-dateutil>=2.8,<2.9',
 'python-engineio>=4,<6,!=5.0.0',
 'python-socketio>=4.4,<6',
 'pytz>=2019.1,<2023.0',
 'questionary>=1.5.1,<1.11.0',
 'randomname>=0.1.5,<0.2.0',
 'rasa-sdk>=3.5.0a2.dev1,<3.6.0',
 'redis>=3.4,<5.0',
 'regex>=2020.6,<2022.11',
 'requests>=2.23,<3.0',
 'rocketchat_API>=0.6.31,<1.29.0',
 'ruamel.yaml>=0.16.5,<0.18.0',
 'sanic-cors>=2.0.0,<2.1.0',
 'sanic-jwt>=1.6.0,<2.0.0',
 'sanic-routing>=0.7.2,<0.8.0',
 'sanic>=21.12,<21.13',
 'sentry-sdk>=0.17.0,<1.15.0',
 'setuptools>=41.0.0',
 'sklearn-crfsuite>=0.3,<0.4',
 'slack-sdk>=3.19.2,<4.0.0',
 'tarsafe>=0.0.3,<0.0.4',
 'tensorflow-addons>=0.18,<0.20',
 'tensorflow_hub>=0.12.0,<0.13.0',
 'terminaltables>=3.1.0,<3.2.0',
 'tqdm>=4.31,<5.0',
 'twilio>=6.26,<7.15',
 'typing-extensions>=4.1.1,<5.0.0',
 'typing-utils>=0.1.0,<0.2.0',
 'ujson>=1.35,<6.0',
 'webexteamssdk>=1.1.1,<1.7.0']

extras_require = \
{':python_full_version >= "3.7.0" and python_full_version < "3.8.0"': ['dask==2022.2.0',
                                                                       'numpy>=1.19.2,<1.22.0',
                                                                       'scipy>=1.4.1,<1.8.0',
                                                                       'scikit-learn>=0.22,<1.1'],
 ':python_version >= "3.8" and python_version < "3.11"': ['dask==2022.10.2',
                                                          'numpy>=1.19.2,<1.24.0',
                                                          'scipy>=1.4.1,<1.9.0',
                                                          'scikit-learn>=0.22,<1.2'],
 ':sys_platform != "darwin" or platform_machine != "arm64"': ['tensorflow>=2.11.0,<2.12.0'],
 ':sys_platform != "win32" and platform_machine != "arm64"': ['tensorflow-text>=2.11.0,<2.12.0'],
 ':sys_platform == "darwin" and platform_machine == "arm64"': ['tensorflow-macos==2.11.0'],
 ':sys_platform == "linux" and (platform_machine == "arm64" or platform_machine == "aarch64")': ['tensorflow-cpu-aws>=2.11.0,<2.12.0'],
 ':sys_platform == "win32"': ['tensorflow-intel>=2.11.0,<2.12.0',
                              'colorama>=0.4.4,<0.5.0'],
 'full': ['transformers>=4.13.0,<=4.26.0',
          'sentencepiece[sentencepiece]>=0.1.96,<0.2.0',
          'jieba>=0.39,<0.43'],
 'full:sys_platform != "darwin" or platform_machine != "arm64"': ['spacy>=3.1,<3.5',
                                                                  'spacy>=3.1,<3.5'],
 'full:sys_platform == "darwin" and platform_machine == "arm64"': ['spacy>=3.4,<4.0',
                                                                   'spacy>=3.4,<4.0'],
 'gh-release-notes': ['github3.py>=3.2.0,<3.3.0'],
 'jieba': ['jieba>=0.39,<0.43'],
 'metal:sys_platform == "darwin" and platform_machine == "arm64"': ['tensorflow-metal==0.5.1'],
 'spacy:sys_platform != "darwin" or platform_machine != "arm64"': ['spacy>=3.1,<3.5',
                                                                   'spacy>=3.1,<3.5'],
 'spacy:sys_platform == "darwin" and platform_machine == "arm64"': ['spacy>=3.4,<4.0',
                                                                    'spacy>=3.4,<4.0'],
 'transformers': ['transformers>=4.13.0,<=4.26.0',
                  'sentencepiece[sentencepiece]>=0.1.96,<0.2.0']}

entry_points = \
{'console_scripts': ['rasa = rasa.__main__:main']}

setup_kwargs = {
    'name': 'rasa',
    'version': '3.5.0a2.dev1',
    'description': 'Open source machine learning framework to automate text- and voice-based conversations: NLU, dialogue management, connect to Slack, Facebook, and more - Create chatbots and voice assistants',
    'long_description': '<h1 align="center">Rasa Open Source</h1>\n\n<div align="center">\n\n[![Join the chat on Rasa Community Forum](https://img.shields.io/badge/forum-join%20discussions-brightgreen.svg)](https://forum.rasa.com/?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)\n[![PyPI version](https://badge.fury.io/py/rasa.svg)](https://badge.fury.io/py/rasa)\n[![Supported Python Versions](https://img.shields.io/pypi/pyversions/rasa.svg)](https://pypi.python.org/pypi/rasa)\n[![Build Status](https://github.com/RasaHQ/rasa/workflows/Continuous%20Integration/badge.svg)](https://github.com/RasaHQ/rasa/actions)\n[![Coverage Status](https://api.codeclimate.com/v1/badges/756dc6fea1d5d3e127f7/test_coverage)](https://codeclimate.com/github/RasaHQ/rasa/)\n[![Documentation Status](https://img.shields.io/badge/docs-stable-brightgreen.svg)](https://rasa.com/docs)\n![Documentation Build](https://img.shields.io/netlify/d2e447e4-5a5e-4dc7-be5d-7c04ae7ff706?label=Documentation%20Build)\n[![FOSSA Status](https://app.fossa.com/api/projects/custom%2B8141%2Fgit%40github.com%3ARasaHQ%2Frasa.git.svg?type=shield)](https://app.fossa.com/projects/custom%2B8141%2Fgit%40github.com%3ARasaHQ%2Frasa.git?ref=badge_shield)\n[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://github.com/orgs/RasaHQ/projects/23)\n\n</div>\n\n<hr />\n\n💡 **We\'re migrating issues to Jira** 💡\n\nStarting January 2023, issues for Rasa Open Source are located in\n[this Jira board](https://rasa-open-source.atlassian.net/browse/OSS). You can browse issues without being logged in;\nif you want to create issues, you\'ll need to create a Jira account.\n\n<hr />\n\n<img align="right" height="255" src="https://www.rasa.com/assets/img/sara/sara-open-source-2.0.png" alt="An image of Sara, the Rasa mascot bird, holding a flag that reads Open Source with one wing, and a wrench in the other" title="Rasa Open Source">\n\nRasa is an open source machine learning framework to automate text and voice-based conversations. With Rasa, you can build contextual assistants on:\n- Facebook Messenger\n- Slack\n- Google Hangouts\n- Webex Teams\n- Microsoft Bot Framework\n- Rocket.Chat\n- Mattermost\n- Telegram\n- Twilio\n- Your own custom conversational channels\n\nor voice assistants as:\n- Alexa Skills\n- Google Home Actions\n\nRasa helps you build contextual assistants capable of having layered conversations with\nlots of back-and-forth. In order for a human to have a meaningful exchange with a contextual\nassistant, the assistant needs to be able to use context to build on things that were previously\ndiscussed – Rasa enables you to build assistants that can do this in a scalable way.\n\nThere\'s a lot more background information in this\n[blog post](https://medium.com/rasa-blog/a-new-approach-to-conversational-software-2e64a5d05f2a).\n\n---\n- 🤔 [Learn more about Rasa](https://rasa.community/)\n\n- 🤓 [Read The Docs](https://rasa.com/docs/rasa/)\n\n- 😁 [Install Rasa](https://rasa.com/docs/rasa/installation/environment-set-up)\n\n- 🚀 [Dive deeper in the learning center](https://learning.rasa.com/)\n\n- 🤗 [Contribute](#how-to-contribute)\n\n- ❓ [Get enterprise-grade support](https://rasa.com/support/)\n\n- 🏢 [Explore the features of our commercial platform](https://rasa.com/product/rasa-platform/)\n\n- 📚 [Learn more about research papers that leverage Rasa](https://scholar.google.com/scholar?oi=bibs&hl=en&authuser=1&cites=16243802403383697687,353275993797024115,14567308604105196228,9067977709825839723,9855847065463746011&as_sdt=5)\n\n\n\n---\n## Where to get help\n\nThere is extensive documentation in the [Rasa Docs](https://rasa.com/docs/rasa).\nMake sure to select the correct version so you are looking at\nthe docs for the version you installed.\n\nPlease use [Rasa Community Forum](https://forum.rasa.com) for quick answers to\nquestions.\n\n### README Contents:\n- [How to contribute](#how-to-contribute)\n- [Development Internals](#development-internals)\n- [Releases](#releases)\n- [License](#license)\n\n### How to contribute\nWe are very happy to receive and merge your contributions into this repository!\n\nTo contribute via pull request, follow these steps:\n\n1. Create an issue describing the feature you want to work on (or\n   have a look at the [contributor board](https://github.com/orgs/RasaHQ/projects/23))\n2. Write your code, tests and documentation, and format them with ``black``\n3. Create a pull request describing your changes\n\nFor more detailed instructions on how to contribute code, check out these [code contributor guidelines](CONTRIBUTING.md).\n\nYou can find more information about how to contribute to Rasa (in lots of\ndifferent ways!) [on our website.](http://rasa.community).\n\nYour pull request will be reviewed by a maintainer, who will get\nback to you about any necessary changes or questions. You will\nalso be asked to sign a\n[Contributor License Agreement](https://cla-assistant.io/RasaHQ/rasa).\n\n\n## Development Internals\n\n### Installing Poetry\n\nRasa uses Poetry for packaging and dependency management. If you want to build it from source,\nyou have to install Poetry first. Please follow\n[the official guide](https://python-poetry.org/docs/#installation) to see all possible options.\n\n### Managing environments\n\nThe official [Poetry guide](https://python-poetry.org/docs/managing-environments/) suggests to use\n[pyenv](https://github.com/pyenv/pyenv) or any other similar tool to easily switch between Python versions.\nThis is how it can be done:\n\n```bash\npyenv install 3.7.9\npyenv local 3.7.9  # Activate Python 3.7.9 for the current project\n```\n*Note*: If you have trouble installing a specific version of python on your system\nit might be worth trying other supported versions.\n\nBy default, Poetry will try to use the currently activated Python version to create the virtual environment\nfor the current project automatically. You can also create and activate a virtual environment manually — in this\ncase, Poetry should pick it up and use it to install the dependencies. For example:\n\n```bash\npython -m venv .venv\nsource .venv/bin/activate\n```\n\nYou can make sure that the environment is picked up by executing\n\n```bash\npoetry env info\n```\n\n### Building from source\n\nTo install dependencies and `rasa` itself in editable mode execute\n\n```bash\nmake install\n```\n\n*Note for macOS users*: under macOS Big Sur we\'ve seen some compiler issues for\ndependencies. Using `export SYSTEM_VERSION_COMPAT=1` before the installation helped.\n\n\n#### Installing optional dependencies\n\nIn order to install rasa\'s optional dependencies, you need to run:\n\n```bash\nmake install-full\n```\n\n*Note for macOS users*: The command `make install-full` could result in a failure while installing `tokenizers`\n(issue described in depth [here](https://github.com/huggingface/tokenizers/issues/1050)).\n\nIn order to resolve it, you must follow these steps to install a Rust compiler:\n```bash\nbrew install rustup\nrustup-init\n```\n\nAfter initialising the Rust compiler, you should restart the console and check its installation:\n```bash\nrustc --version\n```\n\nIn case the PATH variable had not been automatically setup, run:\n```bash\nexport PATH="$HOME/.cargo/bin:$PATH"\n```\n\n\n### Running and changing the documentation\n\nFirst of all, install all the required dependencies:\n\n```bash\nmake install install-docs\n```\n\nAfter the installation has finished, you can run and view the documentation\nlocally using:\n\n```bash\nmake livedocs\n```\n\nIt should open a new tab with the local version of the docs in your browser;\nif not, visit http://localhost:3000 in your browser.\nYou can now change the docs locally and the web page will automatically reload\nand apply your changes.\n\n### Running the Tests\n\nIn order to run the tests, make sure that you have the development requirements installed:\n\n```bash\nmake prepare-tests-ubuntu # Only on Ubuntu and Debian based systems\nmake prepare-tests-macos  # Only on macOS\n```\n\nThen, run the tests:\n\n```bash\nmake test\n```\n\nThey can also be run at multiple jobs to save some time:\n\n```bash\nJOBS=[n] make test\n```\n\nWhere `[n]` is the number of jobs desired. If omitted, `[n]` will be automatically chosen by pytest.\n\n\n### Running the Integration Tests\n\nIn order to run the integration tests, make sure that you have the development requirements installed:\n\n```bash\nmake prepare-tests-ubuntu # Only on Ubuntu and Debian based systems\nmake prepare-tests-macos  # Only on macOS\n```\n\nThen, you\'ll need to start services with the following command which uses\n[Docker Compose](https://docs.docker.com/compose/install/):\n\n```bash\nmake run-integration-containers\n```\n\nFinally, you can run the integration tests like this:\n\n```bash\nmake test-integration\n```\n\n\n### Resolving merge conflicts\n\nPoetry doesn\'t include any solution that can help to resolve merge conflicts in\nthe lock file `poetry.lock` by default.\nHowever, there is a great tool called [poetry-merge-lock](https://poetry-merge-lock.readthedocs.io/en/latest/).\nHere is how you can install it:\n\n```bash\npip install poetry-merge-lock\n```\n\nJust execute this command to resolve merge conflicts in `poetry.lock` automatically:\n\n```bash\npoetry-merge-lock\n```\n\n### Build a Docker image locally\n\nIn order to build a Docker image on your local machine execute the following command:\n\n```bash\nmake build-docker\n```\n\nThe Docker image is available on your local machine as `rasa:localdev`.\n\n### Code Style\n\nTo ensure a standardized code style we use the formatter [black](https://github.com/ambv/black).\nTo ensure our type annotations are correct we use the type checker [pytype](https://github.com/google/pytype).\nIf your code is not formatted properly or doesn\'t type check, GitHub will fail to build.\n\n#### Formatting\n\nIf you want to automatically format your code on every commit, you can use [pre-commit](https://pre-commit.com/).\nJust install it via `pip install pre-commit` and execute `pre-commit install` in the root folder.\nThis will add a hook to the repository, which reformats files on every commit.\n\nIf you want to set it up manually, install black via `poetry install`.\nTo reformat files execute\n```\nmake formatter\n```\n\n#### Type Checking\n\nIf you want to check types on the codebase, install `mypy` using `poetry install`.\nTo check the types execute\n```\nmake types\n```\n\n### Deploying documentation updates\n\nWe use `Docusaurus v2` to build docs for tagged versions and for the `main` branch.\nThe static site that gets built is pushed to the `documentation` branch of this repo.\n\nWe host the site on netlify. On `main` branch builds (see `.github/workflows/documentation.yml`), we push the built docs to\nthe `documentation` branch. Netlify automatically re-deploys the docs pages whenever there is a change to that branch.\n\n## Releases\nRasa has implemented robust policies governing version naming, as well as release pace for major, minor, and patch releases.\n\nThe values for a given version number (MAJOR.MINOR.PATCH) are incremented as follows:\n- MAJOR version for incompatible API changes or other breaking changes.\n- MINOR version for functionality added in a backward compatible manner.\n- PATCH version for backward compatible bug fixes.\n\nThe following table describes the version types and their expected *release cadence*:\n\n| Version Type |                                                                  Description                                                                  |  Target Cadence |\n|--------------|-----------------------------------------------------------------------------------------------------------------------------------------------|-----------------|\n| Major        | For significant changes, or when any backward-incompatible changes are introduced to the API or data model.                                   | Every 1 - 2 yrs |\n| Minor        | For when new backward-compatible functionality is introduced, a minor feature is introduced, or when a set of smaller features is rolled out. | +/- Quarterly   |\n| Patch        | For backward-compatible bug fixes that fix incorrect behavior.                                                                                | As needed       |\n\nWhile this table represents our target release frequency, we reserve the right to modify it based on changing market conditions and technical requirements.\n\n### Maintenance Policy\nOur End of Life policy defines how long a given release is considered supported, as well as how long a release is\nconsidered to be still in active development or maintenance.\n\nThe maintentance duration and end of life for every release are shown on our website as part of the [Product Release and Maintenance Policy](https://rasa.com/rasa-product-release-and-maintenance-policy/).\n\n### Cutting a Major / Minor release\n#### A week before release day\n\n1. **Make sure the [milestone](https://github.com/RasaHQ/rasa/milestones) already exists and is scheduled for the\ncorrect date.**\n2. **Take a look at the issues & PRs that are in the milestone**: does it look about right for the release highlights\nwe are planning to ship? Does it look like anything is missing? Don\'t worry about being aware of every PR that should\nbe in, but it\'s useful to take a moment to evaluate what\'s assigned to the milestone.\n3. **Post a message on the engineering Slack channel**, letting the team know you\'ll be the one cutting the upcoming\nrelease, as well as:\n    1. Providing the link to the appropriate milestone\n    2. Reminding everyone to go over their issues and PRs and please assign them to the milestone\n    3. Reminding everyone of the scheduled date for the release\n\n#### A day before release day\n\n1. **Go over the milestone and evaluate the status of any PR merging that\'s happening. Follow up with people on their\nbugs and fixes.** If the release introduces new bugs or regressions that can\'t be fixed in time, we should discuss on\nSlack about this and take a decision on how to move forward. If the issue is not ready to be merged in time, we remove the issue / PR from the milestone and notify the PR owner and the product manager on Slack about it. The PR / issue owners are responsible for\ncommunicating any issues which might be release relevant. Postponing the release should be considered as an edge case scenario.\n\n#### Release day! 🚀\n\n1. **At the start of the day, post a small message on slack announcing release day!** Communicate you\'ll be handling\nthe release, and the time you\'re aiming to start releasing (again, no later than 4pm, as issues may arise and\ncause delays). This message should be posted early in the morning and before moving forward with any of the steps of the release,\n   in order to give enough time to people to check their PRs and issues. That way they can plan any remaining work. A template of the slack message can be found [here](https://rasa-hq.slack.com/archives/C36SS4N8M/p1613032208137500?thread_ts=1612876410.068400&cid=C36SS4N8M).\n   The release time should be communicated transparently so that others can plan potentially necessary steps accordingly. If there are bigger changes this should be communicated.\n2. Make sure the milestone is empty (everything has been either merged or moved to the next milestone)\n3. Once everything in the milestone is taken care of, post a small message on Slack communicating you are about to\nstart the release process (in case anything is missing).\n4. **You may now do the release by following the instructions outlined in the\n[Rasa Open Source README](#steps-to-release-a-new-version) !**\n\n#### After a Major release\n\nAfter a Major release has been completed, please follow [these instructions to complete the documentation update](./docs/README.md#manual-steps-after-a-new-version).\n\n### Steps to release a new version\nReleasing a new version is quite simple, as the packages are build and distributed by GitHub Actions.\n\n*Release steps*:\n1. Make sure all dependencies are up to date (**especially Rasa SDK**)\n    - For Rasa SDK, except in the case of a patch release, that means first creating a [new Rasa SDK release](https://github.com/RasaHQ/rasa-sdk#steps-to-release-a-new-version) (make sure the version numbers between the new Rasa and Rasa SDK releases match)\n    - Once the tag with the new Rasa SDK release is pushed and the package appears on [pypi](https://pypi.org/project/rasa-sdk/), the dependency in the rasa repository can be resolved (see below).\n2. If this is a minor / major release: Make sure all fixes from currently supported minor versions have been merged from their respective release branches (e.g. 3.3.x) back into main.\n3. In case of a minor release, create a new branch that corresponds to the new release, e.g.\n   ```bash\n    git checkout -b 1.2.x\n    git push origin 1.2.x\n    ```\n4. Switch to the branch you want to cut the release from (`main` in case of a major, the `<major>.<minor>.x` branch for minors and patches)\n    - Update the `rasa-sdk` entry in `pyproject.toml` with the new release version and run `poetry update`. This creates a new `poetry.lock` file with all dependencies resolved.\n    - Commit the changes with `git commit -am "bump rasa-sdk dependency"` but do not push them. They will be automatically picked up by the following step.\n5. If this is a major release, update the list of actively maintained versions [in the README](#actively-maintained-versions) and in [the docs](./docs/docs/actively-maintained-versions.mdx).\n6. Run `make release`\n7. Create a PR against the release branch (e.g. `1.2.x`)\n8. Once your PR is merged, tag a new release (this SHOULD always happen on the release branch), e.g. using\n    ```bash\n    git checkout 1.2.x\n    git pull origin 1.2.x\n    git tag 1.2.0 -m "next release"\n    git push origin 1.2.0 --tags\n    ```\n    GitHub will build this tag and publish the build artifacts.\n9. After all the steps are completed and if everything goes well then we should see a message automatically posted in the company\'s Slack (`product` channel) like this [one](https://rasa-hq.slack.com/archives/C7B08Q5FX/p1614354499046600)\n10. If no message appears in the channel then you can do the following checks:\n    - Check the workflows in [Github Actions](https://github.com/RasaHQ/rasa/actions) and make sure that the merged PR of the current release is completed successfully. To easily find your PR you can use the filters `event: push` and `branch: <version number>` (example on release 2.4 you can see [here](https://github.com/RasaHQ/rasa/actions/runs/643344876))\n    - If the workflow is not completed, then try to re run the workflow in case that solves the problem\n    - If the problem persists, check also the log files and try to find the root cause of the issue\n    - If you still cannot resolve the error, contact the infrastructure team by providing any helpful information from your investigation\n11.  After the message is posted correctly in the `product` channel, check also in the `product-engineering-alerts` channel if there are any alerts related to the Rasa Open Source release like this [one](https://rasa-hq.slack.com/archives/C01585AN2NP/p1615486087001000)\n\n### Cutting a Patch release\n\nPatch releases are simpler to cut, since they are meant to contain only bugfixes.\n\n**The only things you need to do to cut a patch release are:**\n\n1. Notify the engineering team on Slack that you are planning to cut a patch, in case someone has an important fix\nto add.\n2. Make sure the bugfix(es) are in the release branch you will use (p.e if you are cutting a `2.0.4` patch, you will\nneed your fixes to be on the `2.0.x` release branch). All patch releases must come from a `.x` branch!\n3. Once you\'re ready to release the Rasa Open Source patch, checkout the branch, run `make release` and follow the\nsteps + get the PR merged.\n4. Once the PR is in, pull the `.x` branch again and push the tag!\n\n### Actively maintained versions\n\nWe\'re actively maintaining _any minor on our latest major release_ and _the latest minor of the previous major release_.\nCurrently, this means the following minor versions will receive bugfixes updates:\n- 2.8\n- Every minor version on 3.x\n\n## License\nLicensed under the Apache License, Version 2.0.\nCopyright 2022 Rasa Technologies GmbH. [Copy of the license](LICENSE.txt).\n\nA list of the Licenses of the dependencies of the project can be found at\nthe bottom of the\n[Libraries Summary](https://libraries.io/github/RasaHQ/rasa).\n',
    'author': 'Rasa Technologies GmbH',
    'author_email': 'hi@rasa.com',
    'maintainer': 'Tom Bocklisch',
    'maintainer_email': 'tom@rasa.com',
    'url': 'https://rasa.com',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
