# Generated by Django 3.1.7 on 2021-09-09 12:52

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import los_docusign.models
import los_docusign.utils.validators
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="DocusignChoiceConfig",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "docusign_model",
                    models.CharField(
                        choices=[
                            ("docusign_templates", "docusign_templates"),
                            (
                                "docusign_template_org_exclulsions",
                                "docusign_template_org_exclulsions",
                            ),
                        ],
                        max_length=128,
                    ),
                ),
                (
                    "config_key",
                    models.CharField(max_length=128, verbose_name="Config Key"),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                "verbose_name": "Docusign Choice Config",
                "verbose_name_plural": "Docusign Choice Configs",
                "db_table": "docusign_choice_configs",
            },
        ),
        migrations.CreateModel(
            name="DocusignTemplate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("docusign_payload", models.TextField(verbose_name="Docusign Payload")),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="Is Active"),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                (
                    "is_default",
                    models.BooleanField(default=False, verbose_name="Default Template"),
                ),
                (
                    "template_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="los_docusign.docusignchoiceconfig",
                    ),
                ),
            ],
            options={
                "verbose_name": "Docusign Template",
                "verbose_name_plural": "Docusign Templates",
                "db_table": "docusign_templates",
            },
        ),
        migrations.CreateModel(
            name="DocuSignUserAuth",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("access_token", models.TextField(verbose_name="Access Token")),
                ("expires_at", models.DateTimeField(verbose_name="Token Expires At")),
                (
                    "organization_pk",
                    models.CharField(max_length=255, verbose_name="organization pk"),
                ),
                (
                    "two_factor_enabled_flag",
                    models.BooleanField(
                        default=False, verbose_name="Two Factor Enabled?"
                    ),
                ),
                (
                    "docusign_api_username",
                    models.CharField(
                        max_length=255, verbose_name="Docusign API Username"
                    ),
                ),
                (
                    "default_user",
                    models.BooleanField(
                        default=False, max_length=255, verbose_name="Default User?"
                    ),
                ),
                (
                    "organization_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="contenttypes.contenttype",
                        verbose_name="Organization Model",
                    ),
                ),
            ],
            options={
                "verbose_name": "Docusign user authentication",
                "verbose_name_plural": "Docusign user authentications",
                "db_table": "docusign_client_auths",
            },
        ),
        migrations.CreateModel(
            name="DocusignOrgTemplate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "organization_pk",
                    models.CharField(max_length=255, verbose_name="organization pk"),
                ),
                (
                    "docusign_template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="los_docusign.docusigntemplate",
                    ),
                ),
                (
                    "organization_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="contenttypes.contenttype",
                        verbose_name="Organization Model",
                    ),
                ),
            ],
            options={
                "verbose_name": "Docusign Organization Template",
                "verbose_name_plural": "Docusign Organization Templates",
                "db_table": "docusign_org_templates",
            },
        ),
        migrations.CreateModel(
            name="DocusignEnvelopeStageData",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "slug",
                    models.UUIDField(
                        blank=True, db_index=True, default=uuid.uuid4, editable=False
                    ),
                ),
                (
                    "envelope_id",
                    models.CharField(
                        db_index=True, max_length=255, verbose_name="Envelope ID"
                    ),
                ),
                (
                    "record_status",
                    models.CharField(max_length=255, verbose_name="Record Status"),
                ),
                (
                    "envelope_status",
                    models.CharField(max_length=255, verbose_name="Envelope Status"),
                ),
                (
                    "recipient_status",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=255,
                        null=True,
                        verbose_name="Recipient Status",
                    ),
                ),
                (
                    "signed_document",
                    models.FileField(
                        blank=True,
                        max_length=255,
                        null=True,
                        upload_to=los_docusign.models.return_slug_for_url,
                        validators=[
                            los_docusign.utils.validators.validate_file_extension
                        ],
                        verbose_name="Document",
                    ),
                ),
                (
                    "envelope_response",
                    models.CharField(max_length=255, verbose_name="Envelope Response"),
                ),
                (
                    "error_message",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="Error Message",
                    ),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "client_user_id",
                    models.CharField(
                        blank=True,
                        max_length=255,
                        null=True,
                        verbose_name="Client User Id",
                    ),
                ),
                (
                    "recipient_auth_info",
                    models.JSONField(
                        blank=True,
                        null=True,
                        verbose_name="Recipient Authentication Info",
                    ),
                ),
                (
                    "object_pk",
                    models.CharField(max_length=255, verbose_name="object pk"),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="contenttypes.contenttype",
                        verbose_name="content type",
                    ),
                ),
                (
                    "docusign_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="los_docusign.docusignuserauth",
                    ),
                ),
            ],
            options={
                "verbose_name": "Docusign Envelope Stage Data",
                "verbose_name_plural": "Docusign Envelope Stage Datas",
                "db_table": "docusign_envelope_stage_datas",
            },
        ),
        migrations.CreateModel(
            name="DocusignEnvelopeAuditLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "object_pk",
                    models.CharField(
                        db_index=True, max_length=255, verbose_name="object pk"
                    ),
                ),
                ("event_received_at", models.DateTimeField(blank=True, null=True)),
                (
                    "envelope_id",
                    models.CharField(max_length=255, verbose_name="Envelope ID"),
                ),
                (
                    "event_type",
                    models.CharField(
                        blank=True, db_index=True, max_length=125, null=True
                    ),
                ),
                (
                    "event_value",
                    models.CharField(
                        blank=True, db_index=True, max_length=125, null=True
                    ),
                ),
                (
                    "tin",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        max_length=9,
                        null=True,
                        validators=[
                            django.core.validators.MinLengthValidator(
                                9, message="Business TIN must be 9 digits"
                            ),
                            django.core.validators.RegexValidator(
                                "^\\d*$", "Numeric Values Required"
                            ),
                        ],
                        verbose_name="TIN",
                    ),
                ),
                (
                    "remote_addr",
                    models.GenericIPAddressField(
                        blank=True, null=True, verbose_name="remote address"
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="contenttypes.contenttype",
                        verbose_name="content type",
                    ),
                ),
            ],
            options={
                "verbose_name": "Docusign Envelope Audit Log",
                "verbose_name_plural": "Docusign Envelopes Audits Logs",
                "db_table": "docusign_envelope_audit_log",
            },
        ),
        migrations.CreateModel(
            name="DocusignTemplateOrgExclusion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "organization_pk",
                    models.CharField(max_length=255, verbose_name="organization pk"),
                ),
                (
                    "document_name",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="los_docusign.docusignchoiceconfig",
                    ),
                ),
                (
                    "organization_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="contenttypes.contenttype",
                        verbose_name="Organization Model",
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="los_docusign.docusigntemplate",
                    ),
                ),
            ],
            options={
                "verbose_name": "Docusign Organization Template Exclusion",
                "verbose_name_plural": "Docusign Organization Template Exclusions",
                "db_table": "docusign_template_org_exclulsions",
                "unique_together": {("organization_pk", "document_name", "template")},
            },
        ),
        migrations.CreateModel(
            name="DocusignOrgTemplateConfig",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "organization_pk",
                    models.CharField(
                        db_index=True, max_length=255, verbose_name="object pk"
                    ),
                ),
                (
                    "template_config",
                    models.JSONField(verbose_name="Template Configuration"),
                ),
                (
                    "is_active",
                    models.BooleanField(default=True, verbose_name="Is Active"),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True, null=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                (
                    "is_default",
                    models.BooleanField(default=False, verbose_name="Default Config"),
                ),
                (
                    "organization_model",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="contenttypes.contenttype",
                        verbose_name="content type",
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="los_docusign.docusigntemplate",
                    ),
                ),
            ],
            options={
                "verbose_name": "Docusign Organization Template Config",
                "verbose_name_plural": "Docusign Organizations Templates Configs",
                "db_table": "docusign_org_template_configs",
                "unique_together": {("organization_pk", "template")},
            },
        ),
    ]
