import datetime
import shutil

from pathlib import Path

from geoformat.driver.geojson_driver import (
    geojson_to_geolayer,
    geolayer_to_geojson,
    load_json_data,
    feature_attributes_to_properties,
    from_geojson_get_features_list,
    json_object_to_feature_generator,
    geoformat_feature_to_geojson_feature
)

from tests.data.geolayers import (
    geolayer_geometry_only_all_geometries_type,
    geolayer_attributes_only_without_none_value,
    geolayer_fr_dept_population,
    geolayer_fr_dept_geometry_only,
    geolayer_fr_dept_data_only,
    geolayer_fr_dept_data_and_geometry,
)

from tests.data.features import (
    feature_attributes_only,
    feature_dpt_data_only_a,
    feature_dpt_geometry_only_a,
    feature_dpt_data_and_geometry_a

)
from tests.utils.tests_utils import test_function

# declare path
file_path_base = Path(__file__).parent.parent.parent.parent.joinpath
all_geometries_path = file_path_base(
    "tests/geoformat/driver/test/all_geometry_type_only.geojson"
)
geometry_only_path = file_path_base(
    "tests/geoformat/driver/test/FRANCE_DPT_GENERALIZE_LAMB93_ROUND_GEOMETRY_ONLY.geojson"
)
geolayer_attributes_only_path = file_path_base(
    "tests/geoformat/driver/test/attributes_only.geojson"
)

geolayer_fr_dept_data_only_geojson_path = file_path_base(
    "tests/geoformat/driver/test/FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_ONLY.geojson"
)

geolayer_fr_dept_data_and_geometry_path = file_path_base(
    "tests/geoformat/driver/test/FRANCE_DPT_GENERALIZE_LAMB93_ROUND.geojson"
)
data_only_path = file_path_base(
    "tests/geoformat/driver/test/dept_population.geojson"
)

geolayer_to_geojson_parameters = {
    0: {
        "geolayer": geolayer_geometry_only_all_geometries_type,
        "path": all_geometries_path,
        "overwrite": True,
        "add_extension": True,
        "return_value": all_geometries_path,
    },
    1: {
        "geolayer": geolayer_fr_dept_geometry_only,
        "path": geometry_only_path,
        "overwrite": True,
        "add_extension": True,
        "return_value": geometry_only_path,
    },
    2: {
        "geolayer": geolayer_attributes_only_without_none_value,
        "path": geolayer_attributes_only_path,
        "overwrite": True,
        "add_extension": True,
        "return_value": geolayer_attributes_only_path,
    },
    3: {
        "geolayer": geolayer_fr_dept_data_only,
        "path": geolayer_fr_dept_data_only_geojson_path,
        "overwrite": True,
        "add_extension": True,
        "return_value": geolayer_fr_dept_data_only_geojson_path,
    },
    4: {
        "geolayer": geolayer_fr_dept_data_and_geometry,
        "path": geolayer_fr_dept_data_and_geometry_path,
        "overwrite": True,
        "add_extension": True,
        "return_value": geolayer_fr_dept_data_and_geometry_path,
    },
    5: {
        "geolayer": geolayer_fr_dept_population,
        "path": data_only_path,
        "overwrite": True,
        "add_extension": True,
        "return_value": data_only_path,
    },
}

load_json_data_parameters = {
    0: {
        "path": all_geometries_path,
        "return_value": (
            {
                "type": "FeatureCollection",
                "name": "all_geometry_type_only",
                "features": [
                    {
                        "type": "Feature",
                        "geometry": {"type": "Point", "coordinates": [-115.81, 37.24]},
                        "properties": {},
                        "id": 0,
                    },
                    {
                        "type": "Feature",
                        "geometry": {"type": "Point", "coordinates": []},
                        "properties": {},
                        "id": 1,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "LineString",
                            "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                        },
                        "properties": {},
                        "id": 2,
                    },
                    {
                        "type": "Feature",
                        "geometry": {"type": "LineString", "coordinates": []},
                        "properties": {},
                        "id": 3,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                        },
                        "properties": {},
                        "id": 4,
                    },
                    {
                        "type": "Feature",
                        "geometry": {"type": "Polygon", "coordinates": []},
                        "properties": {},
                        "id": 5,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "MultiPoint",
                            "coordinates": [
                                [-155.52, 19.61],
                                [-156.22, 20.74],
                                [-157.97, 21.46],
                            ],
                        },
                        "properties": {},
                        "id": 6,
                    },
                    {
                        "type": "Feature",
                        "geometry": {"type": "MultiPoint", "coordinates": []},
                        "properties": {},
                        "id": 7,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "MultiLineString",
                            "coordinates": [
                                [[3.75, 9.25], [-130.95, 1.52]],
                                [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                            ],
                        },
                        "properties": {},
                        "id": 8,
                    },
                    {
                        "type": "Feature",
                        "geometry": {"type": "MultiLineString", "coordinates": []},
                        "properties": {},
                        "id": 9,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "MultiPolygon",
                            "coordinates": [
                                [
                                    [
                                        [3.78, 9.28],
                                        [-130.91, 1.52],
                                        [35.12, 72.234],
                                        [3.78, 9.28],
                                    ]
                                ],
                                [
                                    [
                                        [23.18, -34.29],
                                        [-1.31, -4.61],
                                        [3.41, 77.91],
                                        [23.18, -34.29],
                                    ]
                                ],
                            ],
                        },
                        "properties": {},
                        "id": 10,
                    },
                    {
                        "type": "Feature",
                        "geometry": {"type": "MultiPolygon", "coordinates": []},
                        "properties": {},
                        "id": 11,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "GeometryCollection",
                            "geometries": [
                                {"type": "Point", "coordinates": [-115.81, 37.24]},
                                {
                                    "type": "LineString",
                                    "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                                },
                                {
                                    "type": "Polygon",
                                    "coordinates": [
                                        [
                                            [2.38, 57.322],
                                            [23.194, -20.28],
                                            [-120.43, 19.15],
                                            [2.38, 57.322],
                                        ],
                                        [
                                            [-5.21, 23.51],
                                            [15.21, -10.81],
                                            [-20.51, 1.51],
                                            [-5.21, 23.51],
                                        ],
                                    ],
                                },
                                {
                                    "type": "MultiPoint",
                                    "coordinates": [
                                        [-155.52, 19.61],
                                        [-156.22, 20.74],
                                        [-157.97, 21.46],
                                    ],
                                },
                                {
                                    "type": "MultiLineString",
                                    "coordinates": [
                                        [[3.75, 9.25], [-130.95, 1.52]],
                                        [
                                            [23.15, -34.25],
                                            [-1.35, -4.65],
                                            [3.45, 77.95],
                                        ],
                                    ],
                                },
                                {
                                    "type": "MultiPolygon",
                                    "coordinates": [
                                        [
                                            [
                                                [3.78, 9.28],
                                                [-130.91, 1.52],
                                                [35.12, 72.234],
                                                [3.78, 9.28],
                                            ]
                                        ],
                                        [
                                            [
                                                [23.18, -34.29],
                                                [-1.31, -4.61],
                                                [3.41, 77.91],
                                                [23.18, -34.29],
                                            ]
                                        ],
                                    ],
                                },
                            ],
                        },
                        "properties": {},
                        "id": 12,
                    },
                    {
                        "type": "Feature",
                        "geometry": {"type": "GeometryCollection", "geometries": []},
                        "properties": {},
                        "id": 13,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "GeometryCollection",
                            "geometries": [
                                {"type": "Point", "coordinates": []},
                                {
                                    "type": "LineString",
                                    "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                                },
                                {
                                    "type": "Polygon",
                                    "coordinates": [
                                        [
                                            [2.38, 57.322],
                                            [23.194, -20.28],
                                            [-120.43, 19.15],
                                            [2.38, 57.322],
                                        ],
                                        [
                                            [-5.21, 23.51],
                                            [15.21, -10.81],
                                            [-20.51, 1.51],
                                            [-5.21, 23.51],
                                        ],
                                    ],
                                },
                                {"type": "MultiPoint", "coordinates": []},
                                {
                                    "type": "MultiLineString",
                                    "coordinates": [
                                        [[3.75, 9.25], [-130.95, 1.52]],
                                        [
                                            [23.15, -34.25],
                                            [-1.35, -4.65],
                                            [3.45, 77.95],
                                        ],
                                    ],
                                },
                                {"type": "MultiPolygon", "coordinates": []},
                            ],
                        },
                        "properties": {},
                        "id": 14,
                    },
                ],
                "crs": {
                    "type": "name",
                    "properties": {"name": "urn:ogc:def:crs:EPSG::4326"},
                },
            },
            "all_geometry_type_only",
        ),
    },
    1: {
        "path": geometry_only_path,
        "return_value": (
            {
                "type": "FeatureCollection",
                "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_GEOMETRY_ONLY",
                "features": [
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [505760.0, 6248691.0],
                                    [509767.0, 6249274.0],
                                    [514960.0, 6255730.0],
                                    [523428.0, 6259977.0],
                                    [531230.0, 6258583.0],
                                    [536034.0, 6253601.0],
                                    [539594.0, 6265818.0],
                                    [554723.0, 6278961.0],
                                    [550482.0, 6283435.0],
                                    [545681.0, 6284750.0],
                                    [535303.0, 6300840.0],
                                    [531445.0, 6300603.0],
                                    [531142.0, 6309545.0],
                                    [528381.0, 6316132.0],
                                    [520187.0, 6318466.0],
                                    [528536.0, 6329188.0],
                                    [521740.0, 6328834.0],
                                    [519117.0, 6332164.0],
                                    [512956.0, 6327891.0],
                                    [507637.0, 6333951.0],
                                    [502833.0, 6331375.0],
                                    [496470.0, 6331745.0],
                                    [495008.0, 6328849.0],
                                    [483787.0, 6325253.0],
                                    [474692.0, 6327970.0],
                                    [465465.0, 6324803.0],
                                    [465239.0, 6317398.0],
                                    [461632.0, 6315722.0],
                                    [453303.0, 6321029.0],
                                    [444807.0, 6320573.0],
                                    [440195.0, 6315550.0],
                                    [443572.0, 6313646.0],
                                    [442698.0, 6298315.0],
                                    [439499.0, 6295895.0],
                                    [438084.0, 6281592.0],
                                    [443497.0, 6282643.0],
                                    [449863.0, 6280833.0],
                                    [456497.0, 6283051.0],
                                    [457450.0, 6278664.0],
                                    [461941.0, 6273297.0],
                                    [466465.0, 6272970.0],
                                    [468215.0, 6263513.0],
                                    [471536.0, 6256527.0],
                                    [479309.0, 6257879.0],
                                    [496988.0, 6250664.0],
                                    [505760.0, 6248691.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 0,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [547193.0, 6388334.0],
                                    [539761.0, 6395885.0],
                                    [530971.0, 6390971.0],
                                    [526858.0, 6394383.0],
                                    [527849.0, 6401566.0],
                                    [514373.0, 6400391.0],
                                    [512334.0, 6403639.0],
                                    [495031.0, 6397493.0],
                                    [491196.0, 6399384.0],
                                    [489091.0, 6407815.0],
                                    [486169.0, 6410676.0],
                                    [474628.0, 6407547.0],
                                    [472909.0, 6402270.0],
                                    [476701.0, 6399758.0],
                                    [474218.0, 6394851.0],
                                    [464993.0, 6388179.0],
                                    [460343.0, 6383021.0],
                                    [460366.0, 6373402.0],
                                    [462536.0, 6370133.0],
                                    [454032.0, 6364649.0],
                                    [457916.0, 6359953.0],
                                    [455164.0, 6354504.0],
                                    [449164.0, 6352477.0],
                                    [449759.0, 6344226.0],
                                    [459734.0, 6343570.0],
                                    [462757.0, 6341305.0],
                                    [470769.0, 6340294.0],
                                    [467874.0, 6336236.0],
                                    [464468.0, 6326808.0],
                                    [465465.0, 6324803.0],
                                    [474692.0, 6327970.0],
                                    [483787.0, 6325253.0],
                                    [495008.0, 6328849.0],
                                    [496470.0, 6331745.0],
                                    [502833.0, 6331375.0],
                                    [507637.0, 6333951.0],
                                    [512956.0, 6327891.0],
                                    [519117.0, 6332164.0],
                                    [520115.0, 6336256.0],
                                    [529462.0, 6338671.0],
                                    [533815.0, 6350996.0],
                                    [536387.0, 6355171.0],
                                    [530427.0, 6360537.0],
                                    [531660.0, 6365290.0],
                                    [544593.0, 6364542.0],
                                    [545774.0, 6366277.0],
                                    [541673.0, 6377661.0],
                                    [542159.0, 6383881.0],
                                    [547193.0, 6388334.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 1,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [841110.0, 6468164.0],
                                    [847361.0, 6468209.0],
                                    [855768.0, 6473591.0],
                                    [860939.0, 6470947.0],
                                    [866406.0, 6463235.0],
                                    [870728.0, 6463360.0],
                                    [871909.0, 6454823.0],
                                    [871457.0, 6445038.0],
                                    [888053.0, 6440277.0],
                                    [892767.0, 6444271.0],
                                    [895595.0, 6439026.0],
                                    [895949.0, 6427870.0],
                                    [894862.0, 6413405.0],
                                    [907889.0, 6409384.0],
                                    [918546.0, 6403480.0],
                                    [921863.0, 6404787.0],
                                    [925560.0, 6409806.0],
                                    [930672.0, 6410433.0],
                                    [933177.0, 6416064.0],
                                    [939410.0, 6420031.0],
                                    [941569.0, 6417648.0],
                                    [947667.0, 6423241.0],
                                    [956742.0, 6422339.0],
                                    [960775.0, 6424797.0],
                                    [965006.0, 6422921.0],
                                    [964872.0, 6432532.0],
                                    [961377.0, 6439340.0],
                                    [952342.0, 6439924.0],
                                    [953909.0, 6450690.0],
                                    [956276.0, 6452799.0],
                                    [950505.0, 6456663.0],
                                    [945165.0, 6465401.0],
                                    [945461.0, 6470305.0],
                                    [949441.0, 6473761.0],
                                    [948557.0, 6482085.0],
                                    [943964.0, 6486985.0],
                                    [938381.0, 6486658.0],
                                    [931624.0, 6492445.0],
                                    [925224.0, 6482705.0],
                                    [917457.0, 6486189.0],
                                    [913763.0, 6489603.0],
                                    [904449.0, 6504924.0],
                                    [897998.0, 6515860.0],
                                    [888123.0, 6525941.0],
                                    [888996.0, 6528631.0],
                                    [882529.0, 6534232.0],
                                    [879159.0, 6530984.0],
                                    [876089.0, 6523611.0],
                                    [870291.0, 6521483.0],
                                    [863140.0, 6525920.0],
                                    [862850.0, 6517700.0],
                                    [865784.0, 6514252.0],
                                    [858527.0, 6506228.0],
                                    [848198.0, 6502534.0],
                                    [841056.0, 6498593.0],
                                    [845846.0, 6493277.0],
                                    [837308.0, 6485557.0],
                                    [837457.0, 6475559.0],
                                    [841110.0, 6468164.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 2,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [634422.0, 7101577.0],
                                    [623701.0, 7099214.0],
                                    [610465.0, 7094261.0],
                                    [605814.0, 7089013.0],
                                    [599885.0, 7086576.0],
                                    [601399.0, 7078135.0],
                                    [598139.0, 7067917.0],
                                    [599563.0, 7049801.0],
                                    [597332.0, 7035063.0],
                                    [603193.0, 7029103.0],
                                    [605232.0, 7026713.0],
                                    [612989.0, 7030025.0],
                                    [622831.0, 7024302.0],
                                    [624801.0, 7021563.0],
                                    [634147.0, 7017146.0],
                                    [635372.0, 7012312.0],
                                    [648121.0, 7014552.0],
                                    [654991.0, 7012592.0],
                                    [660837.0, 7014835.0],
                                    [663948.0, 7010834.0],
                                    [656343.0, 7006536.0],
                                    [658067.0, 7000416.0],
                                    [662547.0, 7004433.0],
                                    [667892.0, 7004913.0],
                                    [669642.0, 7001764.0],
                                    [689814.0, 6997681.0],
                                    [691147.0, 6993758.0],
                                    [706470.0, 6995042.0],
                                    [706855.0, 7002888.0],
                                    [711164.0, 7009522.0],
                                    [712383.0, 7015916.0],
                                    [699507.0, 7031355.0],
                                    [702680.0, 7038239.0],
                                    [701478.0, 7042709.0],
                                    [697493.0, 7046164.0],
                                    [692820.0, 7044918.0],
                                    [687641.0, 7047582.0],
                                    [686184.0, 7056263.0],
                                    [688698.0, 7062196.0],
                                    [683642.0, 7063001.0],
                                    [679720.0, 7059405.0],
                                    [673807.0, 7057943.0],
                                    [664277.0, 7059477.0],
                                    [658064.0, 7064147.0],
                                    [653390.0, 7071778.0],
                                    [644454.0, 7079622.0],
                                    [642453.0, 7087769.0],
                                    [636514.0, 7100652.0],
                                    [634422.0, 7101577.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 3,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [776081.0, 6923412.0],
                                    [782994.0, 6923346.0],
                                    [790665.0, 6921022.0],
                                    [795010.0, 6915033.0],
                                    [803525.0, 6909934.0],
                                    [814643.0, 6911926.0],
                                    [818364.0, 6905215.0],
                                    [822754.0, 6907655.0],
                                    [833062.0, 6905548.0],
                                    [837898.0, 6908256.0],
                                    [842092.0, 6905887.0],
                                    [849280.0, 6910207.0],
                                    [847303.0, 6917040.0],
                                    [853548.0, 6926776.0],
                                    [849442.0, 6935263.0],
                                    [853210.0, 6945817.0],
                                    [856532.0, 6942619.0],
                                    [867310.0, 6942452.0],
                                    [873032.0, 6949057.0],
                                    [869864.0, 6950495.0],
                                    [863792.0, 6957578.0],
                                    [856370.0, 6957018.0],
                                    [850915.0, 6964755.0],
                                    [848735.0, 6964497.0],
                                    [834935.0, 6970707.0],
                                    [833403.0, 6975569.0],
                                    [835414.0, 6979112.0],
                                    [832902.0, 6984653.0],
                                    [828614.0, 6985882.0],
                                    [833821.0, 7001508.0],
                                    [834466.0, 7007583.0],
                                    [830491.0, 7008459.0],
                                    [826108.0, 7005649.0],
                                    [820627.0, 6997569.0],
                                    [821199.0, 6989850.0],
                                    [814347.0, 6988595.0],
                                    [808498.0, 6984157.0],
                                    [803958.0, 6983050.0],
                                    [795770.0, 6985807.0],
                                    [788558.0, 6985051.0],
                                    [789845.0, 6973793.0],
                                    [787172.0, 6965431.0],
                                    [790134.0, 6962730.0],
                                    [781387.0, 6953785.0],
                                    [779463.0, 6948255.0],
                                    [774574.0, 6946610.0],
                                    [777906.0, 6941851.0],
                                    [775403.0, 6934852.0],
                                    [776081.0, 6923412.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 4,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [730707.0, 6810078.0],
                                    [736893.0, 6807760.0],
                                    [745765.0, 6796957.0],
                                    [746161.0, 6791892.0],
                                    [749678.0, 6782304.0],
                                    [755033.0, 6785741.0],
                                    [759917.0, 6778325.0],
                                    [763413.0, 6765164.0],
                                    [767353.0, 6760249.0],
                                    [783028.0, 6759096.0],
                                    [789480.0, 6763963.0],
                                    [796594.0, 6759156.0],
                                    [797692.0, 6763119.0],
                                    [808147.0, 6762855.0],
                                    [816397.0, 6764598.0],
                                    [817962.0, 6771080.0],
                                    [827043.0, 6770243.0],
                                    [825768.0, 6776095.0],
                                    [828770.0, 6781171.0],
                                    [835407.0, 6779651.0],
                                    [837598.0, 6783989.0],
                                    [837935.0, 6797546.0],
                                    [834073.0, 6806764.0],
                                    [827022.0, 6811887.0],
                                    [822210.0, 6820200.0],
                                    [823302.0, 6827043.0],
                                    [819107.0, 6829393.0],
                                    [814106.0, 6826118.0],
                                    [803526.0, 6829924.0],
                                    [796995.0, 6835851.0],
                                    [797551.0, 6845278.0],
                                    [785824.0, 6845891.0],
                                    [779497.0, 6845091.0],
                                    [773768.0, 6840880.0],
                                    [769985.0, 6834113.0],
                                    [760761.0, 6824301.0],
                                    [753955.0, 6826609.0],
                                    [746802.0, 6826973.0],
                                    [740952.0, 6835710.0],
                                    [737148.0, 6833964.0],
                                    [731262.0, 6826009.0],
                                    [728998.0, 6813854.0],
                                    [730707.0, 6810078.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 5,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [1009696.0, 6370071.0],
                                    [1002665.0, 6364730.0],
                                    [997268.0, 6357103.0],
                                    [994698.0, 6348019.0],
                                    [1000668.0, 6338218.0],
                                    [1000089.0, 6334256.0],
                                    [1007601.0, 6328762.0],
                                    [1009068.0, 6324850.0],
                                    [1014122.0, 6322114.0],
                                    [1012050.0, 6317690.0],
                                    [1007566.0, 6320724.0],
                                    [1000978.0, 6315262.0],
                                    [997097.0, 6315251.0],
                                    [992638.0, 6305621.0],
                                    [1002326.0, 6300425.0],
                                    [1003290.0, 6292496.0],
                                    [1006552.0, 6288390.0],
                                    [1015523.0, 6285590.0],
                                    [1014132.0, 6274778.0],
                                    [1018256.0, 6272482.0],
                                    [1020971.0, 6279894.0],
                                    [1026533.0, 6279746.0],
                                    [1033109.0, 6287175.0],
                                    [1036126.0, 6293135.0],
                                    [1041921.0, 6296903.0],
                                    [1048217.0, 6297561.0],
                                    [1064350.0, 6309506.0],
                                    [1061225.0, 6317546.0],
                                    [1066133.0, 6321494.0],
                                    [1066468.0, 6326676.0],
                                    [1072800.0, 6330433.0],
                                    [1073742.0, 6336784.0],
                                    [1077560.0, 6342698.0],
                                    [1073403.0, 6350462.0],
                                    [1060282.0, 6348576.0],
                                    [1054180.0, 6344806.0],
                                    [1042408.0, 6347558.0],
                                    [1034654.0, 6353189.0],
                                    [1025044.0, 6356596.0],
                                    [1020000.0, 6356725.0],
                                    [1018585.0, 6361599.0],
                                    [1009696.0, 6370071.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 6,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [753779.0, 6537018.0],
                                    [758503.0, 6532097.0],
                                    [754369.0, 6520637.0],
                                    [760734.0, 6514163.0],
                                    [764154.0, 6503988.0],
                                    [770440.0, 6500348.0],
                                    [774454.0, 6495613.0],
                                    [776221.0, 6483674.0],
                                    [770335.0, 6479388.0],
                                    [770263.0, 6473476.0],
                                    [776677.0, 6475557.0],
                                    [780259.0, 6472021.0],
                                    [792166.0, 6477709.0],
                                    [802398.0, 6475469.0],
                                    [807029.0, 6471772.0],
                                    [806856.0, 6463705.0],
                                    [811227.0, 6465007.0],
                                    [816370.0, 6460772.0],
                                    [825694.0, 6462649.0],
                                    [826509.0, 6469123.0],
                                    [831517.0, 6473257.0],
                                    [837457.0, 6475559.0],
                                    [837308.0, 6485557.0],
                                    [834511.0, 6489782.0],
                                    [829797.0, 6488843.0],
                                    [825934.0, 6498617.0],
                                    [818524.0, 6498224.0],
                                    [809870.0, 6504594.0],
                                    [806255.0, 6511913.0],
                                    [808147.0, 6518212.0],
                                    [807296.0, 6530310.0],
                                    [802643.0, 6534285.0],
                                    [800220.0, 6540120.0],
                                    [801039.0, 6547667.0],
                                    [798995.0, 6551156.0],
                                    [802035.0, 6559678.0],
                                    [810991.0, 6564128.0],
                                    [806993.0, 6569822.0],
                                    [798969.0, 6562707.0],
                                    [797273.0, 6565101.0],
                                    [787355.0, 6564848.0],
                                    [785138.0, 6567101.0],
                                    [776287.0, 6563809.0],
                                    [774989.0, 6567447.0],
                                    [768620.0, 6568680.0],
                                    [769267.0, 6575508.0],
                                    [762003.0, 6573092.0],
                                    [760949.0, 6561975.0],
                                    [763504.0, 6554575.0],
                                    [762385.0, 6549859.0],
                                    [763887.0, 6544360.0],
                                    [761084.0, 6541876.0],
                                    [754888.0, 6541809.0],
                                    [753779.0, 6537018.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 7,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [505760.0, 6248691.0],
                                    [506455.0, 6246240.0],
                                    [501020.0, 6240519.0],
                                    [500952.0, 6237523.0],
                                    [491741.0, 6229153.0],
                                    [498958.0, 6224762.0],
                                    [501199.0, 6216194.0],
                                    [506394.0, 6214104.0],
                                    [501753.0, 6199863.0],
                                    [493715.0, 6200925.0],
                                    [492032.0, 6195420.0],
                                    [491362.0, 6184305.0],
                                    [493119.0, 6181125.0],
                                    [509918.0, 6181609.0],
                                    [507071.0, 6189939.0],
                                    [508439.0, 6196068.0],
                                    [512551.0, 6198492.0],
                                    [524704.0, 6194181.0],
                                    [522873.0, 6204718.0],
                                    [526458.0, 6208824.0],
                                    [535012.0, 6210452.0],
                                    [537386.0, 6214080.0],
                                    [535770.0, 6220735.0],
                                    [540236.0, 6224348.0],
                                    [541984.0, 6228895.0],
                                    [547328.0, 6230443.0],
                                    [554118.0, 6225953.0],
                                    [555809.0, 6233248.0],
                                    [562910.0, 6233771.0],
                                    [567825.0, 6236309.0],
                                    [561407.0, 6244405.0],
                                    [565565.0, 6247682.0],
                                    [572065.0, 6240985.0],
                                    [575081.0, 6235814.0],
                                    [582028.0, 6242918.0],
                                    [589272.0, 6240503.0],
                                    [593467.0, 6242482.0],
                                    [598408.0, 6250205.0],
                                    [603733.0, 6249863.0],
                                    [603060.0, 6255463.0],
                                    [607574.0, 6261192.0],
                                    [611672.0, 6256714.0],
                                    [621363.0, 6260238.0],
                                    [620519.0, 6263967.0],
                                    [609628.0, 6269734.0],
                                    [605052.0, 6276459.0],
                                    [594074.0, 6282175.0],
                                    [597601.0, 6285124.0],
                                    [595737.0, 6291653.0],
                                    [592076.0, 6294561.0],
                                    [590928.0, 6301074.0],
                                    [586632.0, 6302842.0],
                                    [583878.0, 6308763.0],
                                    [583992.0, 6314318.0],
                                    [575242.0, 6309509.0],
                                    [567948.0, 6310839.0],
                                    [568130.0, 6303820.0],
                                    [556606.0, 6298479.0],
                                    [550735.0, 6304341.0],
                                    [535303.0, 6300840.0],
                                    [545681.0, 6284750.0],
                                    [550482.0, 6283435.0],
                                    [554723.0, 6278961.0],
                                    [539594.0, 6265818.0],
                                    [536034.0, 6253601.0],
                                    [531230.0, 6258583.0],
                                    [523428.0, 6259977.0],
                                    [514960.0, 6255730.0],
                                    [509767.0, 6249274.0],
                                    [505760.0, 6248691.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 8,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [806993.0, 6569822.0],
                                    [808209.0, 6578315.0],
                                    [815826.0, 6575242.0],
                                    [824653.0, 6575157.0],
                                    [830305.0, 6579430.0],
                                    [833486.0, 6565745.0],
                                    [837322.0, 6565642.0],
                                    [839484.0, 6574938.0],
                                    [845050.0, 6590960.0],
                                    [845229.0, 6595067.0],
                                    [848718.0, 6603737.0],
                                    [857422.0, 6600366.0],
                                    [868758.0, 6603264.0],
                                    [869949.0, 6598870.0],
                                    [877344.0, 6596683.0],
                                    [885325.0, 6599852.0],
                                    [880824.0, 6605207.0],
                                    [886706.0, 6618161.0],
                                    [882575.0, 6628163.0],
                                    [880659.0, 6638936.0],
                                    [887343.0, 6642371.0],
                                    [876345.0, 6647462.0],
                                    [872158.0, 6650880.0],
                                    [871408.0, 6655745.0],
                                    [860161.0, 6652754.0],
                                    [855755.0, 6655507.0],
                                    [831500.0, 6648015.0],
                                    [823470.0, 6650227.0],
                                    [813434.0, 6659755.0],
                                    [806754.0, 6662035.0],
                                    [806631.0, 6665548.0],
                                    [795506.0, 6668991.0],
                                    [791663.0, 6673495.0],
                                    [789554.0, 6672918.0],
                                    [784602.0, 6669828.0],
                                    [780471.0, 6669516.0],
                                    [778810.0, 6664936.0],
                                    [781374.0, 6662136.0],
                                    [779000.0, 6654397.0],
                                    [778932.0, 6646959.0],
                                    [783308.0, 6642195.0],
                                    [780490.0, 6638662.0],
                                    [781064.0, 6632682.0],
                                    [775685.0, 6631211.0],
                                    [770503.0, 6626941.0],
                                    [760920.0, 6622686.0],
                                    [756196.0, 6628301.0],
                                    [748049.0, 6627896.0],
                                    [748734.0, 6623209.0],
                                    [753291.0, 6618069.0],
                                    [756931.0, 6607772.0],
                                    [761463.0, 6602522.0],
                                    [763922.0, 6603795.0],
                                    [768312.0, 6598303.0],
                                    [773476.0, 6599308.0],
                                    [776586.0, 6596649.0],
                                    [775079.0, 6589273.0],
                                    [775913.0, 6580395.0],
                                    [769267.0, 6575508.0],
                                    [768620.0, 6568680.0],
                                    [774989.0, 6567447.0],
                                    [776287.0, 6563809.0],
                                    [785138.0, 6567101.0],
                                    [787355.0, 6564848.0],
                                    [797273.0, 6565101.0],
                                    [798969.0, 6562707.0],
                                    [806993.0, 6569822.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 9,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [399495.0, 6830885.0],
                                    [398130.0, 6822559.0],
                                    [400321.0, 6810723.0],
                                    [395852.0, 6803336.0],
                                    [398626.0, 6784333.0],
                                    [400465.0, 6781914.0],
                                    [400197.0, 6773697.0],
                                    [394099.0, 6773357.0],
                                    [390140.0, 6770978.0],
                                    [386941.0, 6760260.0],
                                    [382932.0, 6754022.0],
                                    [389872.0, 6749698.0],
                                    [393110.0, 6750366.0],
                                    [402067.0, 6747685.0],
                                    [404251.0, 6751414.0],
                                    [412442.0, 6746090.0],
                                    [419671.0, 6744167.0],
                                    [429458.0, 6743442.0],
                                    [440863.0, 6746201.0],
                                    [446732.0, 6745443.0],
                                    [446459.0, 6750432.0],
                                    [442128.0, 6753611.0],
                                    [448124.0, 6758669.0],
                                    [447308.0, 6764356.0],
                                    [455060.0, 6767070.0],
                                    [451057.0, 6776681.0],
                                    [459373.0, 6778102.0],
                                    [460615.0, 6783387.0],
                                    [458409.0, 6789055.0],
                                    [466280.0, 6794064.0],
                                    [465298.0, 6799724.0],
                                    [467628.0, 6811401.0],
                                    [473893.0, 6813452.0],
                                    [474394.0, 6821359.0],
                                    [467262.0, 6822174.0],
                                    [466087.0, 6830999.0],
                                    [463434.0, 6833996.0],
                                    [457920.0, 6827997.0],
                                    [451256.0, 6826715.0],
                                    [446687.0, 6829012.0],
                                    [441174.0, 6828584.0],
                                    [437568.0, 6825109.0],
                                    [429868.0, 6822252.0],
                                    [422197.0, 6821752.0],
                                    [414934.0, 6829326.0],
                                    [407934.0, 6831360.0],
                                    [404267.0, 6828490.0],
                                    [399495.0, 6830885.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 10,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [459784.0, 6545825.0],
                                    [457303.0, 6539406.0],
                                    [458386.0, 6534878.0],
                                    [455132.0, 6526680.0],
                                    [449713.0, 6524677.0],
                                    [445866.0, 6528260.0],
                                    [434480.0, 6521530.0],
                                    [434607.0, 6512022.0],
                                    [436951.0, 6506668.0],
                                    [442913.0, 6501478.0],
                                    [446521.0, 6493231.0],
                                    [444696.0, 6489309.0],
                                    [445861.0, 6484044.0],
                                    [443202.0, 6478722.0],
                                    [447267.0, 6474282.0],
                                    [456356.0, 6470307.0],
                                    [455660.0, 6465791.0],
                                    [461242.0, 6465553.0],
                                    [464807.0, 6459164.0],
                                    [468806.0, 6462928.0],
                                    [474561.0, 6460744.0],
                                    [485798.0, 6470195.0],
                                    [484697.0, 6477489.0],
                                    [489646.0, 6488189.0],
                                    [493466.0, 6488572.0],
                                    [504657.0, 6496986.0],
                                    [505177.0, 6505055.0],
                                    [513233.0, 6510903.0],
                                    [515635.0, 6515544.0],
                                    [522412.0, 6520738.0],
                                    [522669.0, 6525452.0],
                                    [527825.0, 6527023.0],
                                    [534383.0, 6537804.0],
                                    [540666.0, 6541823.0],
                                    [539507.0, 6547743.0],
                                    [531290.0, 6552122.0],
                                    [531964.0, 6561069.0],
                                    [526089.0, 6562344.0],
                                    [521367.0, 6557890.0],
                                    [509938.0, 6556936.0],
                                    [507509.0, 6562167.0],
                                    [499249.0, 6554736.0],
                                    [489751.0, 6554866.0],
                                    [483517.0, 6558927.0],
                                    [473907.0, 6559092.0],
                                    [469589.0, 6554692.0],
                                    [465641.0, 6555184.0],
                                    [464645.0, 6548283.0],
                                    [459784.0, 6545825.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 11,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [417723.0, 6857101.0],
                                    [408651.0, 6861319.0],
                                    [399642.0, 6861271.0],
                                    [396867.0, 6868913.0],
                                    [401493.0, 6871059.0],
                                    [411444.0, 6881401.0],
                                    [417375.0, 6892264.0],
                                    [416434.0, 6899162.0],
                                    [413253.0, 6901117.0],
                                    [415797.0, 6907383.0],
                                    [406933.0, 6907874.0],
                                    [400663.0, 6914651.0],
                                    [399047.0, 6920143.0],
                                    [400759.0, 6925144.0],
                                    [397607.0, 6926545.0],
                                    [396597.0, 6932989.0],
                                    [388320.0, 6946238.0],
                                    [388687.0, 6950091.0],
                                    [394381.0, 6955463.0],
                                    [390587.0, 6963240.0],
                                    [381046.0, 6965005.0],
                                    [372051.0, 6959988.0],
                                    [362230.0, 6961356.0],
                                    [343652.0, 6969661.0],
                                    [343012.0, 6963991.0],
                                    [349037.0, 6960923.0],
                                    [349892.0, 6952123.0],
                                    [346450.0, 6948841.0],
                                    [350114.0, 6938864.0],
                                    [350193.0, 6931900.0],
                                    [357636.0, 6924163.0],
                                    [364780.0, 6906370.0],
                                    [363427.0, 6896430.0],
                                    [366480.0, 6887586.0],
                                    [365701.0, 6878731.0],
                                    [362959.0, 6869214.0],
                                    [363872.0, 6859932.0],
                                    [368562.0, 6852485.0],
                                    [376547.0, 6847928.0],
                                    [372261.0, 6845150.0],
                                    [363309.0, 6845999.0],
                                    [366767.0, 6839135.0],
                                    [368413.0, 6830443.0],
                                    [376536.0, 6826525.0],
                                    [384742.0, 6834496.0],
                                    [389634.0, 6835155.0],
                                    [399495.0, 6830885.0],
                                    [404267.0, 6828490.0],
                                    [407934.0, 6831360.0],
                                    [414934.0, 6829326.0],
                                    [421619.0, 6835816.0],
                                    [423498.0, 6841841.0],
                                    [420581.0, 6852284.0],
                                    [417723.0, 6857101.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 12,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [590236.0, 6872273.0],
                                    [594217.0, 6866696.0],
                                    [596554.0, 6858123.0],
                                    [595472.0, 6845570.0],
                                    [597086.0, 6841311.0],
                                    [604791.0, 6831646.0],
                                    [608912.0, 6830618.0],
                                    [611402.0, 6819097.0],
                                    [620311.0, 6818025.0],
                                    [623768.0, 6826369.0],
                                    [627504.0, 6829048.0],
                                    [627800.0, 6838438.0],
                                    [632440.0, 6843248.0],
                                    [634691.0, 6849194.0],
                                    [643163.0, 6853168.0],
                                    [637702.0, 6857774.0],
                                    [637864.0, 6864035.0],
                                    [641404.0, 6867928.0],
                                    [641836.0, 6872490.0],
                                    [633062.0, 6879807.0],
                                    [628641.0, 6878089.0],
                                    [622312.0, 6880731.0],
                                    [614076.0, 6886919.0],
                                    [606678.0, 6883543.0],
                                    [603102.0, 6887292.0],
                                    [598361.0, 6887345.0],
                                    [591984.0, 6886421.0],
                                    [587216.0, 6881812.0],
                                    [590236.0, 6872273.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 13,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [986155.0, 6724947.0],
                                    [984341.0, 6721925.0],
                                    [977033.0, 6724531.0],
                                    [974258.0, 6721322.0],
                                    [969354.0, 6721610.0],
                                    [967469.0, 6716290.0],
                                    [955890.0, 6718838.0],
                                    [950918.0, 6717032.0],
                                    [945847.0, 6708437.0],
                                    [932449.0, 6699390.0],
                                    [925719.0, 6696195.0],
                                    [922029.0, 6697905.0],
                                    [904021.0, 6688452.0],
                                    [905832.0, 6683506.0],
                                    [912920.0, 6678099.0],
                                    [913407.0, 6674258.0],
                                    [909981.0, 6669146.0],
                                    [913780.0, 6661601.0],
                                    [925599.0, 6657600.0],
                                    [925393.0, 6653995.0],
                                    [928880.0, 6645788.0],
                                    [940225.0, 6640408.0],
                                    [944367.0, 6635241.0],
                                    [942748.0, 6631718.0],
                                    [934547.0, 6625608.0],
                                    [937312.0, 6621303.0],
                                    [933274.0, 6616467.0],
                                    [940343.0, 6611180.0],
                                    [938167.0, 6613167.0],
                                    [950995.0, 6626461.0],
                                    [962319.0, 6634781.0],
                                    [961533.0, 6640379.0],
                                    [963711.0, 6649123.0],
                                    [961099.0, 6653277.0],
                                    [967437.0, 6658254.0],
                                    [976505.0, 6662212.0],
                                    [981857.0, 6667617.0],
                                    [983508.0, 6674248.0],
                                    [992174.0, 6680929.0],
                                    [993793.0, 6685149.0],
                                    [999048.0, 6690006.0],
                                    [1001635.0, 6695987.0],
                                    [1006570.0, 6701646.0],
                                    [1002944.0, 6704539.0],
                                    [995578.0, 6702427.0],
                                    [996902.0, 6711079.0],
                                    [994087.0, 6717743.0],
                                    [993651.0, 6723596.0],
                                    [986155.0, 6724947.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 14,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [904250.0, 6825381.0],
                                    [904895.0, 6830283.0],
                                    [900379.0, 6832469.0],
                                    [903561.0, 6837915.0],
                                    [902927.0, 6847494.0],
                                    [899528.0, 6852809.0],
                                    [904125.0, 6862116.0],
                                    [901302.0, 6871865.0],
                                    [905066.0, 6875501.0],
                                    [906433.0, 6884047.0],
                                    [905859.0, 6891045.0],
                                    [901739.0, 6893315.0],
                                    [900172.0, 6898682.0],
                                    [901547.0, 6903348.0],
                                    [898091.0, 6905220.0],
                                    [898652.0, 6915853.0],
                                    [895087.0, 6927281.0],
                                    [891117.0, 6929633.0],
                                    [883576.0, 6926040.0],
                                    [878534.0, 6930925.0],
                                    [879041.0, 6935896.0],
                                    [875512.0, 6946935.0],
                                    [873032.0, 6949057.0],
                                    [867310.0, 6942452.0],
                                    [856532.0, 6942619.0],
                                    [853210.0, 6945817.0],
                                    [849442.0, 6935263.0],
                                    [853548.0, 6926776.0],
                                    [847303.0, 6917040.0],
                                    [849280.0, 6910207.0],
                                    [842092.0, 6905887.0],
                                    [841416.0, 6900107.0],
                                    [845429.0, 6892400.0],
                                    [846791.0, 6883540.0],
                                    [848915.0, 6882413.0],
                                    [848655.0, 6874905.0],
                                    [841874.0, 6870868.0],
                                    [838677.0, 6859119.0],
                                    [846329.0, 6850924.0],
                                    [846365.0, 6844539.0],
                                    [847795.0, 6838972.0],
                                    [852692.0, 6834838.0],
                                    [856191.0, 6834907.0],
                                    [863008.0, 6828766.0],
                                    [873603.0, 6822775.0],
                                    [882722.0, 6816263.0],
                                    [893443.0, 6818701.0],
                                    [904250.0, 6825381.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 15,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [486169.0, 6410676.0],
                                    [482141.0, 6421330.0],
                                    [476390.0, 6418176.0],
                                    [469504.0, 6418931.0],
                                    [461839.0, 6422164.0],
                                    [466012.0, 6428425.0],
                                    [464018.0, 6432038.0],
                                    [469719.0, 6445475.0],
                                    [467756.0, 6450339.0],
                                    [460931.0, 6449393.0],
                                    [457280.0, 6451647.0],
                                    [452009.0, 6448234.0],
                                    [444096.0, 6451365.0],
                                    [437492.0, 6457585.0],
                                    [433418.0, 6457450.0],
                                    [431214.0, 6470295.0],
                                    [421098.0, 6472770.0],
                                    [418478.0, 6475494.0],
                                    [406100.0, 6476140.0],
                                    [404682.0, 6481482.0],
                                    [399796.0, 6489042.0],
                                    [386164.0, 6505245.0],
                                    [380995.0, 6504145.0],
                                    [375328.0, 6494206.0],
                                    [373905.0, 6475097.0],
                                    [366594.0, 6427323.0],
                                    [365668.0, 6410104.0],
                                    [370987.0, 6417061.0],
                                    [380337.0, 6407555.0],
                                    [382533.0, 6402380.0],
                                    [376517.0, 6401861.0],
                                    [367865.0, 6404553.0],
                                    [364521.0, 6395279.0],
                                    [361697.0, 6391399.0],
                                    [361774.0, 6383396.0],
                                    [373686.0, 6386677.0],
                                    [375548.0, 6389853.0],
                                    [383562.0, 6383958.0],
                                    [381182.0, 6379048.0],
                                    [388231.0, 6379327.0],
                                    [393973.0, 6376334.0],
                                    [403228.0, 6378937.0],
                                    [411314.0, 6378206.0],
                                    [411174.0, 6373203.0],
                                    [418928.0, 6369127.0],
                                    [419635.0, 6366255.0],
                                    [426389.0, 6364119.0],
                                    [430077.0, 6359927.0],
                                    [429214.0, 6351421.0],
                                    [438523.0, 6349285.0],
                                    [442465.0, 6350467.0],
                                    [445091.0, 6357381.0],
                                    [449164.0, 6352477.0],
                                    [455164.0, 6354504.0],
                                    [457916.0, 6359953.0],
                                    [454032.0, 6364649.0],
                                    [462536.0, 6370133.0],
                                    [460366.0, 6373402.0],
                                    [460343.0, 6383021.0],
                                    [464993.0, 6388179.0],
                                    [474218.0, 6394851.0],
                                    [476701.0, 6399758.0],
                                    [472909.0, 6402270.0],
                                    [474628.0, 6407547.0],
                                    [486169.0, 6410676.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 16,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [503908.0, 6928958.0],
                                    [498291.0, 6928808.0],
                                    [490213.0, 6925480.0],
                                    [480923.0, 6917694.0],
                                    [474554.0, 6915313.0],
                                    [465316.0, 6913926.0],
                                    [451821.0, 6920480.0],
                                    [444571.0, 6921849.0],
                                    [429556.0, 6922759.0],
                                    [420281.0, 6924935.0],
                                    [414059.0, 6928862.0],
                                    [403953.0, 6928646.0],
                                    [400759.0, 6925144.0],
                                    [399047.0, 6920143.0],
                                    [400663.0, 6914651.0],
                                    [406933.0, 6907874.0],
                                    [415797.0, 6907383.0],
                                    [413253.0, 6901117.0],
                                    [416434.0, 6899162.0],
                                    [417375.0, 6892264.0],
                                    [411444.0, 6881401.0],
                                    [401493.0, 6871059.0],
                                    [396867.0, 6868913.0],
                                    [399642.0, 6861271.0],
                                    [408651.0, 6861319.0],
                                    [417723.0, 6857101.0],
                                    [427244.0, 6861949.0],
                                    [446005.0, 6869054.0],
                                    [449827.0, 6868751.0],
                                    [454384.0, 6863198.0],
                                    [457511.0, 6867107.0],
                                    [469104.0, 6863978.0],
                                    [475607.0, 6865852.0],
                                    [484257.0, 6870962.0],
                                    [489675.0, 6876299.0],
                                    [491678.0, 6873174.0],
                                    [500558.0, 6877307.0],
                                    [504730.0, 6874732.0],
                                    [510545.0, 6875400.0],
                                    [512505.0, 6881741.0],
                                    [508338.0, 6886469.0],
                                    [512079.0, 6895331.0],
                                    [509950.0, 6897618.0],
                                    [509502.0, 6910309.0],
                                    [505278.0, 6914121.0],
                                    [503908.0, 6928958.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 17,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [915394.0, 6762341.0],
                                    [919858.0, 6768473.0],
                                    [924039.0, 6766004.0],
                                    [929025.0, 6772821.0],
                                    [935284.0, 6772098.0],
                                    [936416.0, 6766072.0],
                                    [941726.0, 6764118.0],
                                    [951150.0, 6767749.0],
                                    [956126.0, 6765947.0],
                                    [959909.0, 6759629.0],
                                    [964569.0, 6761737.0],
                                    [968808.0, 6766577.0],
                                    [972278.0, 6762245.0],
                                    [982963.0, 6756697.0],
                                    [986052.0, 6752778.0],
                                    [987691.0, 6753958.0],
                                    [993060.0, 6757264.0],
                                    [991355.0, 6761730.0],
                                    [993983.0, 6773739.0],
                                    [998205.0, 6776671.0],
                                    [1001795.0, 6789636.0],
                                    [1006708.0, 6801985.0],
                                    [1011125.0, 6809400.0],
                                    [1005338.0, 6811635.0],
                                    [1003109.0, 6819572.0],
                                    [1004385.0, 6831654.0],
                                    [994239.0, 6827289.0],
                                    [987769.0, 6820181.0],
                                    [982282.0, 6817771.0],
                                    [973656.0, 6818945.0],
                                    [964951.0, 6823820.0],
                                    [963830.0, 6819154.0],
                                    [935203.0, 6815546.0],
                                    [930831.0, 6810526.0],
                                    [919362.0, 6809623.0],
                                    [910921.0, 6826770.0],
                                    [904250.0, 6825381.0],
                                    [893443.0, 6818701.0],
                                    [882722.0, 6816263.0],
                                    [878315.0, 6811920.0],
                                    [883843.0, 6809100.0],
                                    [896020.0, 6796835.0],
                                    [901295.0, 6794520.0],
                                    [899609.0, 6786135.0],
                                    [895837.0, 6779219.0],
                                    [900794.0, 6778635.0],
                                    [906998.0, 6773750.0],
                                    [908017.0, 6765028.0],
                                    [912655.0, 6766332.0],
                                    [915394.0, 6762341.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 18,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [642856.0, 6724786.0],
                                    [634456.0, 6720842.0],
                                    [639501.0, 6716775.0],
                                    [642622.0, 6708275.0],
                                    [632231.0, 6698879.0],
                                    [634922.0, 6687596.0],
                                    [624165.0, 6685496.0],
                                    [619951.0, 6688294.0],
                                    [617060.0, 6680060.0],
                                    [612147.0, 6680536.0],
                                    [612309.0, 6675948.0],
                                    [607114.0, 6670785.0],
                                    [615265.0, 6667454.0],
                                    [621646.0, 6669974.0],
                                    [627833.0, 6667741.0],
                                    [627981.0, 6660408.0],
                                    [631131.0, 6657674.0],
                                    [629301.0, 6648616.0],
                                    [633457.0, 6642556.0],
                                    [627496.0, 6637025.0],
                                    [632500.0, 6630848.0],
                                    [628673.0, 6627353.0],
                                    [634340.0, 6622075.0],
                                    [637665.0, 6611745.0],
                                    [635550.0, 6606712.0],
                                    [638969.0, 6598575.0],
                                    [634893.0, 6595681.0],
                                    [636090.0, 6591904.0],
                                    [644784.0, 6591412.0],
                                    [645179.0, 6595086.0],
                                    [650317.0, 6601560.0],
                                    [660370.0, 6603761.0],
                                    [664479.0, 6602292.0],
                                    [670500.0, 6605989.0],
                                    [669145.0, 6615318.0],
                                    [677474.0, 6626628.0],
                                    [682775.0, 6624336.0],
                                    [686837.0, 6626145.0],
                                    [696943.0, 6633749.0],
                                    [702446.0, 6632753.0],
                                    [705186.0, 6641947.0],
                                    [703828.0, 6645606.0],
                                    [706033.0, 6650549.0],
                                    [705753.0, 6657660.0],
                                    [701762.0, 6662486.0],
                                    [702129.0, 6669867.0],
                                    [698614.0, 6680189.0],
                                    [698745.0, 6684384.0],
                                    [690449.0, 6694237.0],
                                    [694642.0, 6704915.0],
                                    [690565.0, 6713347.0],
                                    [685430.0, 6710473.0],
                                    [682544.0, 6713710.0],
                                    [678869.0, 6710238.0],
                                    [674282.0, 6709782.0],
                                    [669909.0, 6717111.0],
                                    [661757.0, 6718781.0],
                                    [657729.0, 6723417.0],
                                    [652875.0, 6720759.0],
                                    [646396.0, 6725640.0],
                                    [642856.0, 6724786.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 19,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [779411.0, 6373918.0],
                                    [785084.0, 6367917.0],
                                    [783861.0, 6358147.0],
                                    [791158.0, 6357807.0],
                                    [800494.0, 6352553.0],
                                    [802764.0, 6358131.0],
                                    [806518.0, 6360956.0],
                                    [819866.0, 6361270.0],
                                    [824346.0, 6357163.0],
                                    [831641.0, 6353746.0],
                                    [831614.0, 6360351.0],
                                    [832713.0, 6371581.0],
                                    [835151.0, 6374038.0],
                                    [834538.0, 6384016.0],
                                    [835764.0, 6388411.0],
                                    [841041.0, 6396655.0],
                                    [839715.0, 6410394.0],
                                    [844069.0, 6414766.0],
                                    [848816.0, 6428161.0],
                                    [844782.0, 6435636.0],
                                    [842390.0, 6453321.0],
                                    [841110.0, 6468164.0],
                                    [837457.0, 6475559.0],
                                    [831517.0, 6473257.0],
                                    [826509.0, 6469123.0],
                                    [825694.0, 6462649.0],
                                    [816370.0, 6460772.0],
                                    [813436.0, 6450097.0],
                                    [808187.0, 6450395.0],
                                    [808165.0, 6446004.0],
                                    [801638.0, 6433950.0],
                                    [796332.0, 6429870.0],
                                    [791307.0, 6420019.0],
                                    [782106.0, 6419872.0],
                                    [781273.0, 6415520.0],
                                    [774103.0, 6411136.0],
                                    [768276.0, 6405343.0],
                                    [771844.0, 6388592.0],
                                    [775042.0, 6386528.0],
                                    [779411.0, 6373918.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 20,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [776081.0, 6923412.0],
                                    [775403.0, 6934852.0],
                                    [777906.0, 6941851.0],
                                    [774574.0, 6946610.0],
                                    [779463.0, 6948255.0],
                                    [781387.0, 6953785.0],
                                    [790134.0, 6962730.0],
                                    [787172.0, 6965431.0],
                                    [789845.0, 6973793.0],
                                    [788558.0, 6985051.0],
                                    [781905.0, 6987282.0],
                                    [778060.0, 6986162.0],
                                    [770359.0, 6988977.0],
                                    [766237.0, 6992385.0],
                                    [753505.0, 6995276.0],
                                    [751253.0, 6997000.0],
                                    [744014.0, 6992056.0],
                                    [739058.0, 6995179.0],
                                    [735248.0, 6991264.0],
                                    [725313.0, 6993104.0],
                                    [720100.0, 6990781.0],
                                    [716534.0, 6992565.0],
                                    [712391.0, 6990404.0],
                                    [713833.0, 6986563.0],
                                    [708480.0, 6979518.0],
                                    [705667.0, 6969289.0],
                                    [708546.0, 6956332.0],
                                    [707064.0, 6950845.0],
                                    [709520.0, 6938240.0],
                                    [706939.0, 6934901.0],
                                    [711648.0, 6928031.0],
                                    [706805.0, 6926038.0],
                                    [706929.0, 6919738.0],
                                    [698137.0, 6911415.0],
                                    [701957.0, 6908433.0],
                                    [704672.0, 6899225.0],
                                    [710189.0, 6894765.0],
                                    [705248.0, 6890863.0],
                                    [712067.0, 6888882.0],
                                    [712559.0, 6879371.0],
                                    [722321.0, 6872132.0],
                                    [724211.0, 6867685.0],
                                    [729581.0, 6862815.0],
                                    [735603.0, 6861428.0],
                                    [738742.0, 6868146.0],
                                    [744067.0, 6871735.0],
                                    [747254.0, 6882494.0],
                                    [743801.0, 6891376.0],
                                    [745398.0, 6894771.0],
                                    [751361.0, 6898188.0],
                                    [747051.0, 6913033.0],
                                    [761575.0, 6918670.0],
                                    [767112.0, 6923360.0],
                                    [775242.0, 6918312.0],
                                    [776081.0, 6923412.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 21,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [334283.0, 6280551.0],
                                    [327832.0, 6270658.0],
                                    [324268.0, 6267623.0],
                                    [314107.0, 6264613.0],
                                    [316186.0, 6255555.0],
                                    [321493.0, 6257288.0],
                                    [325696.0, 6250142.0],
                                    [329513.0, 6253905.0],
                                    [334359.0, 6254169.0],
                                    [344050.0, 6249226.0],
                                    [343580.0, 6242296.0],
                                    [340751.0, 6235590.0],
                                    [335750.0, 6230517.0],
                                    [338499.0, 6226346.0],
                                    [344947.0, 6224142.0],
                                    [346289.0, 6231519.0],
                                    [352412.0, 6225527.0],
                                    [355170.0, 6226484.0],
                                    [373097.0, 6218255.0],
                                    [377794.0, 6214129.0],
                                    [388910.0, 6213290.0],
                                    [393755.0, 6214784.0],
                                    [395170.0, 6206882.0],
                                    [409841.0, 6194695.0],
                                    [412796.0, 6198151.0],
                                    [418372.0, 6194685.0],
                                    [422245.0, 6194862.0],
                                    [428954.0, 6200122.0],
                                    [428150.0, 6207547.0],
                                    [431947.0, 6209367.0],
                                    [431385.0, 6215423.0],
                                    [437107.0, 6220297.0],
                                    [440142.0, 6228799.0],
                                    [443868.0, 6230545.0],
                                    [446410.0, 6236240.0],
                                    [454979.0, 6245934.0],
                                    [452746.0, 6249402.0],
                                    [457777.0, 6262698.0],
                                    [451477.0, 6264635.0],
                                    [454138.0, 6272903.0],
                                    [449863.0, 6280833.0],
                                    [443497.0, 6282643.0],
                                    [438084.0, 6281592.0],
                                    [433057.0, 6279053.0],
                                    [424830.0, 6280287.0],
                                    [421554.0, 6283529.0],
                                    [412501.0, 6278002.0],
                                    [403447.0, 6281078.0],
                                    [399714.0, 6278404.0],
                                    [394475.0, 6281218.0],
                                    [385124.0, 6280151.0],
                                    [377063.0, 6275535.0],
                                    [367753.0, 6276986.0],
                                    [362964.0, 6280741.0],
                                    [352961.0, 6276001.0],
                                    [342731.0, 6276517.0],
                                    [338238.0, 6281381.0],
                                    [334283.0, 6280551.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 22,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [642856.0, 6724786.0],
                                    [640167.0, 6731164.0],
                                    [620646.0, 6731114.0],
                                    [613256.0, 6732409.0],
                                    [609792.0, 6727136.0],
                                    [605429.0, 6729771.0],
                                    [602374.0, 6738361.0],
                                    [591237.0, 6742041.0],
                                    [590280.0, 6747700.0],
                                    [594464.0, 6753836.0],
                                    [589886.0, 6759775.0],
                                    [589601.0, 6765689.0],
                                    [573758.0, 6762848.0],
                                    [566408.0, 6764638.0],
                                    [559999.0, 6772636.0],
                                    [559439.0, 6777275.0],
                                    [551727.0, 6777731.0],
                                    [551017.0, 6782681.0],
                                    [539332.0, 6780273.0],
                                    [535875.0, 6773086.0],
                                    [539183.0, 6762306.0],
                                    [532634.0, 6757689.0],
                                    [533549.0, 6751156.0],
                                    [528757.0, 6745774.0],
                                    [518605.0, 6737439.0],
                                    [521086.0, 6735350.0],
                                    [530153.0, 6735215.0],
                                    [539386.0, 6732046.0],
                                    [543743.0, 6727862.0],
                                    [552256.0, 6724799.0],
                                    [555366.0, 6719856.0],
                                    [552945.0, 6716389.0],
                                    [559271.0, 6706788.0],
                                    [557303.0, 6702930.0],
                                    [558309.0, 6696538.0],
                                    [557051.0, 6690388.0],
                                    [561058.0, 6687382.0],
                                    [565759.0, 6689706.0],
                                    [569696.0, 6685244.0],
                                    [573297.0, 6677558.0],
                                    [582631.0, 6683116.0],
                                    [593597.0, 6687211.0],
                                    [602149.0, 6685865.0],
                                    [612147.0, 6680536.0],
                                    [617060.0, 6680060.0],
                                    [619951.0, 6688294.0],
                                    [624165.0, 6685496.0],
                                    [634922.0, 6687596.0],
                                    [632231.0, 6698879.0],
                                    [642622.0, 6708275.0],
                                    [639501.0, 6716775.0],
                                    [634456.0, 6720842.0],
                                    [642856.0, 6724786.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 23,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [1001023.0, 6834020.0],
                                    [1007603.0, 6833382.0],
                                    [1013753.0, 6840510.0],
                                    [1015426.0, 6846104.0],
                                    [1012123.0, 6851875.0],
                                    [1016765.0, 6860562.0],
                                    [1004387.0, 6868517.0],
                                    [1002983.0, 6863593.0],
                                    [997609.0, 6864713.0],
                                    [996607.0, 6871102.0],
                                    [990508.0, 6874464.0],
                                    [991999.0, 6880708.0],
                                    [996400.0, 6888804.0],
                                    [1000174.0, 6890502.0],
                                    [1005257.0, 6886565.0],
                                    [1014136.0, 6883372.0],
                                    [1016790.0, 6880171.0],
                                    [1025429.0, 6883147.0],
                                    [1032318.0, 6879884.0],
                                    [1035096.0, 6882767.0],
                                    [1038624.0, 6893752.0],
                                    [1031356.0, 6897552.0],
                                    [1023578.0, 6906994.0],
                                    [1018182.0, 6905695.0],
                                    [1013674.0, 6899390.0],
                                    [1009903.0, 6900358.0],
                                    [996736.0, 6898172.0],
                                    [992282.0, 6906134.0],
                                    [986611.0, 6909639.0],
                                    [979390.0, 6908077.0],
                                    [979652.0, 6901424.0],
                                    [972590.0, 6902443.0],
                                    [968604.0, 6909024.0],
                                    [966935.0, 6915200.0],
                                    [959086.0, 6922273.0],
                                    [960438.0, 6926520.0],
                                    [957718.0, 6930675.0],
                                    [948608.0, 6936180.0],
                                    [945901.0, 6934734.0],
                                    [938917.0, 6936180.0],
                                    [935871.0, 6939385.0],
                                    [928691.0, 6938466.0],
                                    [926408.0, 6934964.0],
                                    [916749.0, 6932316.0],
                                    [915342.0, 6936492.0],
                                    [909643.0, 6936903.0],
                                    [913390.0, 6932141.0],
                                    [912688.0, 6923499.0],
                                    [920628.0, 6907653.0],
                                    [917676.0, 6905219.0],
                                    [920671.0, 6900380.0],
                                    [914011.0, 6893894.0],
                                    [914442.0, 6889764.0],
                                    [922708.0, 6883240.0],
                                    [922735.0, 6879575.0],
                                    [928151.0, 6878713.0],
                                    [929417.0, 6875078.0],
                                    [939656.0, 6875317.0],
                                    [945024.0, 6864515.0],
                                    [946451.0, 6858744.0],
                                    [961206.0, 6856322.0],
                                    [964692.0, 6852206.0],
                                    [969100.0, 6851558.0],
                                    [971773.0, 6847764.0],
                                    [976380.0, 6847597.0],
                                    [983189.0, 6843093.0],
                                    [993487.0, 6842033.0],
                                    [1001023.0, 6834020.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 24,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [483517.0, 6558927.0],
                                    [489751.0, 6554866.0],
                                    [499249.0, 6554736.0],
                                    [507509.0, 6562167.0],
                                    [509938.0, 6556936.0],
                                    [521367.0, 6557890.0],
                                    [526089.0, 6562344.0],
                                    [531964.0, 6561069.0],
                                    [530127.0, 6570272.0],
                                    [538896.0, 6578287.0],
                                    [546474.0, 6577615.0],
                                    [548271.0, 6584464.0],
                                    [556218.0, 6586207.0],
                                    [559931.0, 6588729.0],
                                    [562773.0, 6594026.0],
                                    [558128.0, 6596023.0],
                                    [557842.0, 6602380.0],
                                    [547958.0, 6609437.0],
                                    [542426.0, 6611026.0],
                                    [538906.0, 6616112.0],
                                    [541431.0, 6623495.0],
                                    [537221.0, 6629765.0],
                                    [533123.0, 6635020.0],
                                    [531658.0, 6641492.0],
                                    [525272.0, 6647330.0],
                                    [524608.0, 6655240.0],
                                    [515158.0, 6658631.0],
                                    [517389.0, 6653506.0],
                                    [510389.0, 6653999.0],
                                    [505157.0, 6650870.0],
                                    [494833.0, 6656131.0],
                                    [494947.0, 6665028.0],
                                    [485608.0, 6667284.0],
                                    [482922.0, 6672972.0],
                                    [478404.0, 6673399.0],
                                    [476861.0, 6677880.0],
                                    [471947.0, 6677374.0],
                                    [469141.0, 6670338.0],
                                    [464624.0, 6667352.0],
                                    [465537.0, 6662685.0],
                                    [471018.0, 6649618.0],
                                    [469757.0, 6639127.0],
                                    [470952.0, 6628365.0],
                                    [467588.0, 6622657.0],
                                    [472374.0, 6614809.0],
                                    [467690.0, 6607234.0],
                                    [468300.0, 6594579.0],
                                    [472081.0, 6590232.0],
                                    [472141.0, 6584899.0],
                                    [475179.0, 6582497.0],
                                    [479925.0, 6587264.0],
                                    [482897.0, 6584792.0],
                                    [478920.0, 6578170.0],
                                    [477460.0, 6571967.0],
                                    [480502.0, 6565882.0],
                                    [485043.0, 6563684.0],
                                    [483517.0, 6558927.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 25,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [515635.0, 6515544.0],
                                    [513233.0, 6510903.0],
                                    [505177.0, 6505055.0],
                                    [504657.0, 6496986.0],
                                    [493466.0, 6488572.0],
                                    [489646.0, 6488189.0],
                                    [484697.0, 6477489.0],
                                    [485798.0, 6470195.0],
                                    [474561.0, 6460744.0],
                                    [468806.0, 6462928.0],
                                    [464807.0, 6459164.0],
                                    [460931.0, 6449393.0],
                                    [467756.0, 6450339.0],
                                    [469719.0, 6445475.0],
                                    [464018.0, 6432038.0],
                                    [466012.0, 6428425.0],
                                    [461839.0, 6422164.0],
                                    [469504.0, 6418931.0],
                                    [476390.0, 6418176.0],
                                    [482141.0, 6421330.0],
                                    [486169.0, 6410676.0],
                                    [489091.0, 6407815.0],
                                    [491196.0, 6399384.0],
                                    [495031.0, 6397493.0],
                                    [512334.0, 6403639.0],
                                    [514373.0, 6400391.0],
                                    [527849.0, 6401566.0],
                                    [526858.0, 6394383.0],
                                    [530971.0, 6390971.0],
                                    [539761.0, 6395885.0],
                                    [547193.0, 6388334.0],
                                    [553597.0, 6395079.0],
                                    [553113.0, 6398528.0],
                                    [559319.0, 6399932.0],
                                    [564402.0, 6403210.0],
                                    [570668.0, 6413830.0],
                                    [570522.0, 6417080.0],
                                    [576964.0, 6421036.0],
                                    [574976.0, 6434607.0],
                                    [577774.0, 6436765.0],
                                    [573095.0, 6446142.0],
                                    [566113.0, 6450433.0],
                                    [564865.0, 6461779.0],
                                    [560988.0, 6465186.0],
                                    [568750.0, 6477311.0],
                                    [563844.0, 6479160.0],
                                    [563452.0, 6484264.0],
                                    [553144.0, 6489340.0],
                                    [546900.0, 6501981.0],
                                    [539039.0, 6503445.0],
                                    [529342.0, 6499739.0],
                                    [524801.0, 6504583.0],
                                    [526849.0, 6509996.0],
                                    [515635.0, 6515544.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 26,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [877344.0, 6596683.0],
                                    [877221.0, 6593352.0],
                                    [882664.0, 6589574.0],
                                    [882486.0, 6586333.0],
                                    [887558.0, 6582363.0],
                                    [890444.0, 6576892.0],
                                    [895736.0, 6577631.0],
                                    [903737.0, 6585593.0],
                                    [908880.0, 6582354.0],
                                    [909869.0, 6577050.0],
                                    [919460.0, 6577537.0],
                                    [923919.0, 6580132.0],
                                    [929573.0, 6589336.0],
                                    [935280.0, 6595262.0],
                                    [935835.0, 6600587.0],
                                    [941800.0, 6609883.0],
                                    [940343.0, 6611180.0],
                                    [933274.0, 6616467.0],
                                    [937312.0, 6621303.0],
                                    [934547.0, 6625608.0],
                                    [942748.0, 6631718.0],
                                    [944367.0, 6635241.0],
                                    [940225.0, 6640408.0],
                                    [928880.0, 6645788.0],
                                    [925393.0, 6653995.0],
                                    [925599.0, 6657600.0],
                                    [913780.0, 6661601.0],
                                    [909981.0, 6669146.0],
                                    [913407.0, 6674258.0],
                                    [912920.0, 6678099.0],
                                    [905832.0, 6683506.0],
                                    [904021.0, 6688452.0],
                                    [896736.0, 6687711.0],
                                    [890265.0, 6692353.0],
                                    [888032.0, 6690633.0],
                                    [887407.0, 6682465.0],
                                    [884880.0, 6674426.0],
                                    [881002.0, 6667371.0],
                                    [876191.0, 6666228.0],
                                    [875449.0, 6660099.0],
                                    [871408.0, 6655745.0],
                                    [872158.0, 6650880.0],
                                    [876345.0, 6647462.0],
                                    [887343.0, 6642371.0],
                                    [880659.0, 6638936.0],
                                    [882575.0, 6628163.0],
                                    [886706.0, 6618161.0],
                                    [880824.0, 6605207.0],
                                    [885325.0, 6599852.0],
                                    [877344.0, 6596683.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 27,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [610874.0, 6360746.0],
                                    [596271.0, 6358053.0],
                                    [592401.0, 6355117.0],
                                    [585843.0, 6356520.0],
                                    [581893.0, 6352690.0],
                                    [570617.0, 6348643.0],
                                    [562737.0, 6350024.0],
                                    [549131.0, 6360516.0],
                                    [545774.0, 6366277.0],
                                    [544593.0, 6364542.0],
                                    [531660.0, 6365290.0],
                                    [530427.0, 6360537.0],
                                    [536387.0, 6355171.0],
                                    [533815.0, 6350996.0],
                                    [529462.0, 6338671.0],
                                    [520115.0, 6336256.0],
                                    [519117.0, 6332164.0],
                                    [521740.0, 6328834.0],
                                    [528536.0, 6329188.0],
                                    [520187.0, 6318466.0],
                                    [528381.0, 6316132.0],
                                    [531142.0, 6309545.0],
                                    [531445.0, 6300603.0],
                                    [535303.0, 6300840.0],
                                    [550735.0, 6304341.0],
                                    [556606.0, 6298479.0],
                                    [568130.0, 6303820.0],
                                    [567948.0, 6310839.0],
                                    [575242.0, 6309509.0],
                                    [583992.0, 6314318.0],
                                    [583816.0, 6319290.0],
                                    [589156.0, 6320414.0],
                                    [595091.0, 6325907.0],
                                    [592665.0, 6336179.0],
                                    [599594.0, 6336049.0],
                                    [602120.0, 6333848.0],
                                    [607335.0, 6338978.0],
                                    [613603.0, 6341028.0],
                                    [619220.0, 6339455.0],
                                    [618185.0, 6342854.0],
                                    [612268.0, 6345645.0],
                                    [617826.0, 6353582.0],
                                    [612319.0, 6353954.0],
                                    [610874.0, 6360746.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 28,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [404251.0, 6660135.0],
                                    [413368.0, 6662854.0],
                                    [417889.0, 6660618.0],
                                    [424993.0, 6661094.0],
                                    [429262.0, 6663802.0],
                                    [429925.0, 6668493.0],
                                    [434893.0, 6670550.0],
                                    [442005.0, 6668948.0],
                                    [454238.0, 6672319.0],
                                    [458546.0, 6672434.0],
                                    [464624.0, 6667352.0],
                                    [469141.0, 6670338.0],
                                    [471947.0, 6677374.0],
                                    [476861.0, 6677880.0],
                                    [479254.0, 6691029.0],
                                    [487846.0, 6706491.0],
                                    [490772.0, 6714971.0],
                                    [489539.0, 6719725.0],
                                    [491931.0, 6726763.0],
                                    [485937.0, 6723990.0],
                                    [478533.0, 6727039.0],
                                    [474490.0, 6731769.0],
                                    [469484.0, 6733109.0],
                                    [464631.0, 6730466.0],
                                    [460339.0, 6732350.0],
                                    [457617.0, 6739093.0],
                                    [450112.0, 6740918.0],
                                    [446732.0, 6745443.0],
                                    [440863.0, 6746201.0],
                                    [429458.0, 6743442.0],
                                    [419671.0, 6744167.0],
                                    [412442.0, 6746090.0],
                                    [404251.0, 6751414.0],
                                    [402067.0, 6747685.0],
                                    [393110.0, 6750366.0],
                                    [389872.0, 6749698.0],
                                    [382932.0, 6754022.0],
                                    [382163.0, 6750361.0],
                                    [381255.0, 6745617.0],
                                    [386987.0, 6740963.0],
                                    [389301.0, 6732485.0],
                                    [398982.0, 6728603.0],
                                    [395905.0, 6725901.0],
                                    [386462.0, 6727467.0],
                                    [387234.0, 6720426.0],
                                    [401401.0, 6717774.0],
                                    [402393.0, 6705897.0],
                                    [396890.0, 6703794.0],
                                    [385609.0, 6704471.0],
                                    [375470.0, 6701871.0],
                                    [374867.0, 6698071.0],
                                    [378391.0, 6691949.0],
                                    [382659.0, 6691801.0],
                                    [384839.0, 6683588.0],
                                    [379159.0, 6679552.0],
                                    [379298.0, 6676338.0],
                                    [387784.0, 6670618.0],
                                    [385082.0, 6667087.0],
                                    [392012.0, 6664073.0],
                                    [401283.0, 6663962.0],
                                    [404251.0, 6660135.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 29,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [863140.0, 6525920.0],
                                    [849404.0, 6524528.0],
                                    [844536.0, 6535588.0],
                                    [833933.0, 6540287.0],
                                    [835850.0, 6543054.0],
                                    [834501.0, 6551198.0],
                                    [835220.0, 6556428.0],
                                    [838741.0, 6561678.0],
                                    [837322.0, 6565642.0],
                                    [833486.0, 6565745.0],
                                    [830305.0, 6579430.0],
                                    [824653.0, 6575157.0],
                                    [815826.0, 6575242.0],
                                    [808209.0, 6578315.0],
                                    [806993.0, 6569822.0],
                                    [810991.0, 6564128.0],
                                    [802035.0, 6559678.0],
                                    [798995.0, 6551156.0],
                                    [801039.0, 6547667.0],
                                    [800220.0, 6540120.0],
                                    [802643.0, 6534285.0],
                                    [807296.0, 6530310.0],
                                    [808147.0, 6518212.0],
                                    [806255.0, 6511913.0],
                                    [809870.0, 6504594.0],
                                    [818524.0, 6498224.0],
                                    [825934.0, 6498617.0],
                                    [829797.0, 6488843.0],
                                    [834511.0, 6489782.0],
                                    [837308.0, 6485557.0],
                                    [845846.0, 6493277.0],
                                    [841056.0, 6498593.0],
                                    [848198.0, 6502534.0],
                                    [858527.0, 6506228.0],
                                    [865784.0, 6514252.0],
                                    [862850.0, 6517700.0],
                                    [863140.0, 6525920.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 30,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [606642.0, 6924066.0],
                                    [602657.0, 6922993.0],
                                    [596650.0, 6927678.0],
                                    [584841.0, 6929723.0],
                                    [579971.0, 6928884.0],
                                    [574422.0, 6917678.0],
                                    [566281.0, 6917384.0],
                                    [564288.0, 6913853.0],
                                    [558013.0, 6912674.0],
                                    [555352.0, 6907664.0],
                                    [548914.0, 6917432.0],
                                    [548813.0, 6922655.0],
                                    [537794.0, 6926754.0],
                                    [530512.0, 6925008.0],
                                    [524567.0, 6928708.0],
                                    [520591.0, 6933755.0],
                                    [506978.0, 6930086.0],
                                    [503908.0, 6928958.0],
                                    [505278.0, 6914121.0],
                                    [509502.0, 6910309.0],
                                    [509950.0, 6897618.0],
                                    [512079.0, 6895331.0],
                                    [508338.0, 6886469.0],
                                    [512505.0, 6881741.0],
                                    [510545.0, 6875400.0],
                                    [508448.0, 6870995.0],
                                    [513552.0, 6867418.0],
                                    [520512.0, 6866728.0],
                                    [524600.0, 6861683.0],
                                    [533488.0, 6856087.0],
                                    [536389.0, 6850906.0],
                                    [533024.0, 6847407.0],
                                    [539112.0, 6843338.0],
                                    [543803.0, 6848251.0],
                                    [555241.0, 6849633.0],
                                    [566604.0, 6854037.0],
                                    [576482.0, 6852521.0],
                                    [580772.0, 6855857.0],
                                    [579784.0, 6860594.0],
                                    [587701.0, 6866890.0],
                                    [590236.0, 6872273.0],
                                    [587216.0, 6881812.0],
                                    [591984.0, 6886421.0],
                                    [598361.0, 6887345.0],
                                    [601892.0, 6893098.0],
                                    [603501.0, 6902160.0],
                                    [605624.0, 6904387.0],
                                    [606128.0, 6907968.0],
                                    [610931.0, 6911811.0],
                                    [609871.0, 6919444.0],
                                    [606642.0, 6924066.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 31,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [619220.0, 6339455.0],
                                    [628552.0, 6344336.0],
                                    [632260.0, 6344664.0],
                                    [651092.0, 6332910.0],
                                    [652742.0, 6328715.0],
                                    [656723.0, 6328192.0],
                                    [661724.0, 6320369.0],
                                    [659810.0, 6316970.0],
                                    [664259.0, 6313698.0],
                                    [664946.0, 6304799.0],
                                    [674324.0, 6293934.0],
                                    [679276.0, 6292258.0],
                                    [684993.0, 6295873.0],
                                    [693643.0, 6293013.0],
                                    [694796.0, 6288406.0],
                                    [698819.0, 6289943.0],
                                    [704898.0, 6288229.0],
                                    [704815.0, 6303628.0],
                                    [716344.0, 6301672.0],
                                    [722102.0, 6311077.0],
                                    [728786.0, 6312824.0],
                                    [736140.0, 6324746.0],
                                    [726344.0, 6331169.0],
                                    [726879.0, 6340020.0],
                                    [729879.0, 6341376.0],
                                    [728598.0, 6344387.0],
                                    [718362.0, 6347498.0],
                                    [709994.0, 6353946.0],
                                    [712305.0, 6356606.0],
                                    [709537.0, 6364934.0],
                                    [710800.0, 6372878.0],
                                    [705449.0, 6378272.0],
                                    [706639.0, 6384441.0],
                                    [698547.0, 6393953.0],
                                    [693924.0, 6403282.0],
                                    [694820.0, 6408897.0],
                                    [690477.0, 6411547.0],
                                    [688126.0, 6419157.0],
                                    [684359.0, 6419403.0],
                                    [679353.0, 6426925.0],
                                    [676829.0, 6423158.0],
                                    [668604.0, 6416079.0],
                                    [668313.0, 6410487.0],
                                    [665404.0, 6408608.0],
                                    [664849.0, 6402561.0],
                                    [655192.0, 6393469.0],
                                    [646639.0, 6396959.0],
                                    [637228.0, 6394175.0],
                                    [637122.0, 6391031.0],
                                    [632813.0, 6386229.0],
                                    [625170.0, 6387538.0],
                                    [615061.0, 6379167.0],
                                    [607709.0, 6375883.0],
                                    [610874.0, 6360746.0],
                                    [612319.0, 6353954.0],
                                    [617826.0, 6353582.0],
                                    [612268.0, 6345645.0],
                                    [618185.0, 6342854.0],
                                    [619220.0, 6339455.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 32,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [636090.0, 6591904.0],
                                    [630016.0, 6590287.0],
                                    [622684.0, 6592821.0],
                                    [609355.0, 6592908.0],
                                    [602234.0, 6588456.0],
                                    [595863.0, 6588324.0],
                                    [586530.0, 6592902.0],
                                    [578129.0, 6584256.0],
                                    [580236.0, 6579624.0],
                                    [574730.0, 6569689.0],
                                    [580656.0, 6565605.0],
                                    [587795.0, 6549437.0],
                                    [586335.0, 6540289.0],
                                    [592200.0, 6538029.0],
                                    [591561.0, 6529605.0],
                                    [597279.0, 6527024.0],
                                    [604752.0, 6527760.0],
                                    [613074.0, 6522626.0],
                                    [612524.0, 6515422.0],
                                    [614305.0, 6511565.0],
                                    [623634.0, 6517796.0],
                                    [631053.0, 6514297.0],
                                    [635791.0, 6515072.0],
                                    [637278.0, 6511373.0],
                                    [648450.0, 6509221.0],
                                    [649366.0, 6512420.0],
                                    [656101.0, 6511235.0],
                                    [660507.0, 6515469.0],
                                    [656022.0, 6519074.0],
                                    [652489.0, 6525488.0],
                                    [656753.0, 6529414.0],
                                    [660605.0, 6529501.0],
                                    [668605.0, 6543382.0],
                                    [665172.0, 6557241.0],
                                    [666451.0, 6560450.0],
                                    [662729.0, 6571178.0],
                                    [659880.0, 6575828.0],
                                    [653217.0, 6581299.0],
                                    [647921.0, 6581264.0],
                                    [644784.0, 6591412.0],
                                    [636090.0, 6591904.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 33,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [695265.0, 6784783.0],
                                    [685053.0, 6785343.0],
                                    [678166.0, 6780535.0],
                                    [665644.0, 6782354.0],
                                    [663338.0, 6793247.0],
                                    [657236.0, 6795707.0],
                                    [655721.0, 6802434.0],
                                    [653275.0, 6801114.0],
                                    [639308.0, 6801806.0],
                                    [625387.0, 6798948.0],
                                    [623220.0, 6795517.0],
                                    [615539.0, 6776549.0],
                                    [606511.0, 6774717.0],
                                    [597558.0, 6774986.0],
                                    [595216.0, 6770968.0],
                                    [589165.0, 6770859.0],
                                    [589601.0, 6765689.0],
                                    [589886.0, 6759775.0],
                                    [594464.0, 6753836.0],
                                    [590280.0, 6747700.0],
                                    [591237.0, 6742041.0],
                                    [602374.0, 6738361.0],
                                    [605429.0, 6729771.0],
                                    [609792.0, 6727136.0],
                                    [613256.0, 6732409.0],
                                    [620646.0, 6731114.0],
                                    [640167.0, 6731164.0],
                                    [642856.0, 6724786.0],
                                    [646396.0, 6725640.0],
                                    [652875.0, 6720759.0],
                                    [657729.0, 6723417.0],
                                    [661757.0, 6718781.0],
                                    [669909.0, 6717111.0],
                                    [674282.0, 6709782.0],
                                    [678869.0, 6710238.0],
                                    [682544.0, 6713710.0],
                                    [685430.0, 6710473.0],
                                    [690565.0, 6713347.0],
                                    [693556.0, 6718403.0],
                                    [698236.0, 6718784.0],
                                    [695341.0, 6722058.0],
                                    [694231.0, 6731133.0],
                                    [689391.0, 6734632.0],
                                    [689262.0, 6740069.0],
                                    [695135.0, 6740319.0],
                                    [701782.0, 6742907.0],
                                    [700769.0, 6756036.0],
                                    [703743.0, 6756785.0],
                                    [709585.0, 6763406.0],
                                    [706580.0, 6772621.0],
                                    [703759.0, 6774663.0],
                                    [702192.0, 6781427.0],
                                    [695265.0, 6784783.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 34,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [986052.0, 6752778.0],
                                    [982963.0, 6756697.0],
                                    [972278.0, 6762245.0],
                                    [968808.0, 6766577.0],
                                    [964569.0, 6761737.0],
                                    [959909.0, 6759629.0],
                                    [956126.0, 6765947.0],
                                    [951150.0, 6767749.0],
                                    [941726.0, 6764118.0],
                                    [936416.0, 6766072.0],
                                    [935284.0, 6772098.0],
                                    [929025.0, 6772821.0],
                                    [924039.0, 6766004.0],
                                    [919858.0, 6768473.0],
                                    [915394.0, 6762341.0],
                                    [910900.0, 6755744.0],
                                    [906433.0, 6754603.0],
                                    [901288.0, 6749897.0],
                                    [900414.0, 6745482.0],
                                    [902985.0, 6741752.0],
                                    [901778.0, 6735043.0],
                                    [894824.0, 6733348.0],
                                    [886220.0, 6734507.0],
                                    [880542.0, 6733086.0],
                                    [878352.0, 6725366.0],
                                    [882147.0, 6728546.0],
                                    [886108.0, 6726069.0],
                                    [887785.0, 6718944.0],
                                    [884206.0, 6713509.0],
                                    [880595.0, 6713705.0],
                                    [884919.0, 6701062.0],
                                    [890265.0, 6692353.0],
                                    [896736.0, 6687711.0],
                                    [904021.0, 6688452.0],
                                    [922029.0, 6697905.0],
                                    [925719.0, 6696195.0],
                                    [932449.0, 6699390.0],
                                    [945847.0, 6708437.0],
                                    [950918.0, 6717032.0],
                                    [955890.0, 6718838.0],
                                    [967469.0, 6716290.0],
                                    [969354.0, 6721610.0],
                                    [974258.0, 6721322.0],
                                    [977033.0, 6724531.0],
                                    [984341.0, 6721925.0],
                                    [986155.0, 6724947.0],
                                    [983826.0, 6731782.0],
                                    [981470.0, 6745308.0],
                                    [986052.0, 6752778.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 35,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [753779.0, 6537018.0],
                                    [745523.0, 6547324.0],
                                    [735860.0, 6546571.0],
                                    [732386.0, 6552810.0],
                                    [728730.0, 6550656.0],
                                    [712873.0, 6551781.0],
                                    [697819.0, 6557998.0],
                                    [693029.0, 6567076.0],
                                    [695157.0, 6571452.0],
                                    [688886.0, 6572856.0],
                                    [685369.0, 6566281.0],
                                    [679424.0, 6569309.0],
                                    [672252.0, 6557694.0],
                                    [666451.0, 6560450.0],
                                    [665172.0, 6557241.0],
                                    [668605.0, 6543382.0],
                                    [660605.0, 6529501.0],
                                    [656753.0, 6529414.0],
                                    [652489.0, 6525488.0],
                                    [656022.0, 6519074.0],
                                    [660507.0, 6515469.0],
                                    [663288.0, 6509261.0],
                                    [662164.0, 6504560.0],
                                    [658322.0, 6500286.0],
                                    [662264.0, 6494997.0],
                                    [661594.0, 6486680.0],
                                    [672750.0, 6482640.0],
                                    [677684.0, 6475835.0],
                                    [688449.0, 6477003.0],
                                    [693859.0, 6474045.0],
                                    [695974.0, 6467752.0],
                                    [701310.0, 6465307.0],
                                    [708104.0, 6472781.0],
                                    [713160.0, 6472555.0],
                                    [722742.0, 6478087.0],
                                    [735734.0, 6477978.0],
                                    [739202.0, 6481030.0],
                                    [749018.0, 6471190.0],
                                    [752222.0, 6475420.0],
                                    [760473.0, 6472496.0],
                                    [763248.0, 6477235.0],
                                    [770263.0, 6473476.0],
                                    [770335.0, 6479388.0],
                                    [776221.0, 6483674.0],
                                    [774454.0, 6495613.0],
                                    [770440.0, 6500348.0],
                                    [764154.0, 6503988.0],
                                    [760734.0, 6514163.0],
                                    [754369.0, 6520637.0],
                                    [758503.0, 6532097.0],
                                    [753779.0, 6537018.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 36,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [583992.0, 6314318.0],
                                    [583878.0, 6308763.0],
                                    [586632.0, 6302842.0],
                                    [590928.0, 6301074.0],
                                    [592076.0, 6294561.0],
                                    [595737.0, 6291653.0],
                                    [597601.0, 6285124.0],
                                    [594074.0, 6282175.0],
                                    [605052.0, 6276459.0],
                                    [609628.0, 6269734.0],
                                    [620519.0, 6263967.0],
                                    [621363.0, 6260238.0],
                                    [624846.0, 6255615.0],
                                    [637154.0, 6259493.0],
                                    [640013.0, 6262596.0],
                                    [651680.0, 6257911.0],
                                    [654081.0, 6259728.0],
                                    [664821.0, 6258302.0],
                                    [668090.0, 6259189.0],
                                    [672444.0, 6264623.0],
                                    [672394.0, 6269695.0],
                                    [668935.0, 6274250.0],
                                    [671212.0, 6283521.0],
                                    [676690.0, 6282993.0],
                                    [680178.0, 6279485.0],
                                    [693221.0, 6284557.0],
                                    [694796.0, 6288406.0],
                                    [693643.0, 6293013.0],
                                    [684993.0, 6295873.0],
                                    [679276.0, 6292258.0],
                                    [674324.0, 6293934.0],
                                    [664946.0, 6304799.0],
                                    [664259.0, 6313698.0],
                                    [659810.0, 6316970.0],
                                    [661724.0, 6320369.0],
                                    [656723.0, 6328192.0],
                                    [652742.0, 6328715.0],
                                    [651092.0, 6332910.0],
                                    [632260.0, 6344664.0],
                                    [628552.0, 6344336.0],
                                    [619220.0, 6339455.0],
                                    [613603.0, 6341028.0],
                                    [607335.0, 6338978.0],
                                    [602120.0, 6333848.0],
                                    [599594.0, 6336049.0],
                                    [592665.0, 6336179.0],
                                    [595091.0, 6325907.0],
                                    [589156.0, 6320414.0],
                                    [583816.0, 6319290.0],
                                    [583992.0, 6314318.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 37,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [612314.0, 6962826.0],
                                    [608347.0, 6970745.0],
                                    [605014.0, 6980736.0],
                                    [589321.0, 6994349.0],
                                    [583880.0, 6997485.0],
                                    [570354.0, 6986979.0],
                                    [561015.0, 6982476.0],
                                    [553619.0, 6982021.0],
                                    [539569.0, 6977082.0],
                                    [525341.0, 6975010.0],
                                    [506777.0, 6963564.0],
                                    [498821.0, 6960824.0],
                                    [494437.0, 6953650.0],
                                    [487453.0, 6938754.0],
                                    [491281.0, 6933115.0],
                                    [506978.0, 6930086.0],
                                    [520591.0, 6933755.0],
                                    [524567.0, 6928708.0],
                                    [530512.0, 6925008.0],
                                    [537794.0, 6926754.0],
                                    [548813.0, 6922655.0],
                                    [548914.0, 6917432.0],
                                    [555352.0, 6907664.0],
                                    [558013.0, 6912674.0],
                                    [564288.0, 6913853.0],
                                    [566281.0, 6917384.0],
                                    [574422.0, 6917678.0],
                                    [579971.0, 6928884.0],
                                    [584841.0, 6929723.0],
                                    [596650.0, 6927678.0],
                                    [602657.0, 6922993.0],
                                    [606642.0, 6924066.0],
                                    [610545.0, 6930338.0],
                                    [607205.0, 6935073.0],
                                    [609123.0, 6937659.0],
                                    [606321.0, 6945902.0],
                                    [607933.0, 6953359.0],
                                    [605401.0, 6955866.0],
                                    [612314.0, 6962826.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 38,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [823302.0, 6827043.0],
                                    [822210.0, 6820200.0],
                                    [827022.0, 6811887.0],
                                    [834073.0, 6806764.0],
                                    [837935.0, 6797546.0],
                                    [837598.0, 6783989.0],
                                    [835407.0, 6779651.0],
                                    [828770.0, 6781171.0],
                                    [825768.0, 6776095.0],
                                    [827043.0, 6770243.0],
                                    [833398.0, 6769005.0],
                                    [833316.0, 6764154.0],
                                    [838226.0, 6763382.0],
                                    [846087.0, 6753627.0],
                                    [848388.0, 6746302.0],
                                    [846031.0, 6742315.0],
                                    [848455.0, 6733791.0],
                                    [858300.0, 6729814.0],
                                    [863148.0, 6730266.0],
                                    [868188.0, 6726357.0],
                                    [878352.0, 6725366.0],
                                    [880542.0, 6733086.0],
                                    [886220.0, 6734507.0],
                                    [894824.0, 6733348.0],
                                    [901778.0, 6735043.0],
                                    [902985.0, 6741752.0],
                                    [900414.0, 6745482.0],
                                    [901288.0, 6749897.0],
                                    [906433.0, 6754603.0],
                                    [910900.0, 6755744.0],
                                    [915394.0, 6762341.0],
                                    [912655.0, 6766332.0],
                                    [908017.0, 6765028.0],
                                    [906998.0, 6773750.0],
                                    [900794.0, 6778635.0],
                                    [895837.0, 6779219.0],
                                    [899609.0, 6786135.0],
                                    [901295.0, 6794520.0],
                                    [896020.0, 6796835.0],
                                    [883843.0, 6809100.0],
                                    [878315.0, 6811920.0],
                                    [882722.0, 6816263.0],
                                    [873603.0, 6822775.0],
                                    [863008.0, 6828766.0],
                                    [856191.0, 6834907.0],
                                    [852692.0, 6834838.0],
                                    [847795.0, 6838972.0],
                                    [846365.0, 6844539.0],
                                    [840675.0, 6844876.0],
                                    [835676.0, 6840415.0],
                                    [836281.0, 6837534.0],
                                    [830469.0, 6833515.0],
                                    [832829.0, 6827018.0],
                                    [823302.0, 6827043.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 39,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [831641.0, 6353746.0],
                                    [824346.0, 6357163.0],
                                    [819866.0, 6361270.0],
                                    [806518.0, 6360956.0],
                                    [802764.0, 6358131.0],
                                    [800494.0, 6352553.0],
                                    [791158.0, 6357807.0],
                                    [783861.0, 6358147.0],
                                    [785084.0, 6367917.0],
                                    [779411.0, 6373918.0],
                                    [775211.0, 6367175.0],
                                    [770571.0, 6365836.0],
                                    [775941.0, 6359276.0],
                                    [773621.0, 6356674.0],
                                    [775968.0, 6350322.0],
                                    [776174.0, 6341769.0],
                                    [768987.0, 6337162.0],
                                    [763780.0, 6336809.0],
                                    [754256.0, 6342872.0],
                                    [750995.0, 6342037.0],
                                    [750700.0, 6336169.0],
                                    [735189.0, 6336775.0],
                                    [729879.0, 6341376.0],
                                    [726879.0, 6340020.0],
                                    [726344.0, 6331169.0],
                                    [736140.0, 6324746.0],
                                    [728786.0, 6312824.0],
                                    [734096.0, 6312602.0],
                                    [742673.0, 6306434.0],
                                    [746263.0, 6307559.0],
                                    [750088.0, 6313306.0],
                                    [758340.0, 6319159.0],
                                    [763184.0, 6318967.0],
                                    [766255.0, 6313712.0],
                                    [766790.0, 6307842.0],
                                    [773726.0, 6310049.0],
                                    [780634.0, 6301895.0],
                                    [792244.0, 6293431.0],
                                    [796379.0, 6284647.0],
                                    [792922.0, 6276955.0],
                                    [788998.0, 6273432.0],
                                    [792112.0, 6270978.0],
                                    [792074.0, 6265425.0],
                                    [799607.0, 6263119.0],
                                    [800175.0, 6267290.0],
                                    [813903.0, 6274579.0],
                                    [815212.0, 6281222.0],
                                    [819908.0, 6290041.0],
                                    [828463.0, 6288899.0],
                                    [833168.0, 6302217.0],
                                    [831988.0, 6308980.0],
                                    [839658.0, 6315433.0],
                                    [847769.0, 6322554.0],
                                    [843231.0, 6331183.0],
                                    [836689.0, 6335330.0],
                                    [837656.0, 6344658.0],
                                    [831641.0, 6353746.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 40,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [1011125.0, 6809400.0],
                                    [1016850.0, 6809125.0],
                                    [1022638.0, 6802981.0],
                                    [1032428.0, 6798669.0],
                                    [1032222.0, 6793924.0],
                                    [1036067.0, 6790258.0],
                                    [1040408.0, 6789869.0],
                                    [1046450.0, 6801750.0],
                                    [1048508.0, 6811325.0],
                                    [1051141.0, 6812923.0],
                                    [1050303.0, 6822049.0],
                                    [1052109.0, 6831679.0],
                                    [1054677.0, 6834498.0],
                                    [1054069.0, 6843233.0],
                                    [1056359.0, 6848835.0],
                                    [1064869.0, 6858273.0],
                                    [1065247.0, 6862338.0],
                                    [1074008.0, 6868775.0],
                                    [1077114.0, 6879387.0],
                                    [1081448.0, 6887616.0],
                                    [1072364.0, 6888601.0],
                                    [1060439.0, 6895482.0],
                                    [1055798.0, 6892558.0],
                                    [1050607.0, 6895578.0],
                                    [1045763.0, 6893084.0],
                                    [1038624.0, 6893752.0],
                                    [1035096.0, 6882767.0],
                                    [1032318.0, 6879884.0],
                                    [1025429.0, 6883147.0],
                                    [1016790.0, 6880171.0],
                                    [1014136.0, 6883372.0],
                                    [1005257.0, 6886565.0],
                                    [1000174.0, 6890502.0],
                                    [996400.0, 6888804.0],
                                    [991999.0, 6880708.0],
                                    [990508.0, 6874464.0],
                                    [996607.0, 6871102.0],
                                    [997609.0, 6864713.0],
                                    [1002983.0, 6863593.0],
                                    [1004387.0, 6868517.0],
                                    [1016765.0, 6860562.0],
                                    [1012123.0, 6851875.0],
                                    [1015426.0, 6846104.0],
                                    [1013753.0, 6840510.0],
                                    [1007603.0, 6833382.0],
                                    [1001023.0, 6834020.0],
                                    [1004385.0, 6831654.0],
                                    [1003109.0, 6819572.0],
                                    [1005338.0, 6811635.0],
                                    [1011125.0, 6809400.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 41,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [719561.0, 6234874.0],
                                    [716336.0, 6238907.0],
                                    [711963.0, 6238657.0],
                                    [700385.0, 6243263.0],
                                    [700353.0, 6246775.0],
                                    [686427.0, 6247043.0],
                                    [681495.0, 6239871.0],
                                    [667653.0, 6244475.0],
                                    [662679.0, 6249784.0],
                                    [664821.0, 6258302.0],
                                    [654081.0, 6259728.0],
                                    [651680.0, 6257911.0],
                                    [640013.0, 6262596.0],
                                    [637154.0, 6259493.0],
                                    [624846.0, 6255615.0],
                                    [621363.0, 6260238.0],
                                    [611672.0, 6256714.0],
                                    [607574.0, 6261192.0],
                                    [603060.0, 6255463.0],
                                    [603733.0, 6249863.0],
                                    [598408.0, 6250205.0],
                                    [593467.0, 6242482.0],
                                    [596256.0, 6236985.0],
                                    [595072.0, 6233132.0],
                                    [604330.0, 6228108.0],
                                    [614442.0, 6225039.0],
                                    [613663.0, 6217624.0],
                                    [617210.0, 6214637.0],
                                    [617137.0, 6197372.0],
                                    [608402.0, 6195450.0],
                                    [610538.0, 6185966.0],
                                    [614361.0, 6182470.0],
                                    [622733.0, 6184536.0],
                                    [632373.0, 6176261.0],
                                    [631545.0, 6174170.0],
                                    [644388.0, 6178927.0],
                                    [647326.0, 6181831.0],
                                    [644930.0, 6193342.0],
                                    [655189.0, 6193206.0],
                                    [659825.0, 6194610.0],
                                    [675246.0, 6192375.0],
                                    [678721.0, 6193157.0],
                                    [682753.0, 6199641.0],
                                    [688989.0, 6202113.0],
                                    [693222.0, 6198384.0],
                                    [703560.0, 6193187.0],
                                    [704952.0, 6201963.0],
                                    [703499.0, 6206754.0],
                                    [709550.0, 6222514.0],
                                    [719561.0, 6234874.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 42,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [695265.0, 6784783.0],
                                    [700383.0, 6789702.0],
                                    [703237.0, 6796855.0],
                                    [703668.0, 6806647.0],
                                    [712422.0, 6807964.0],
                                    [727042.0, 6808060.0],
                                    [730707.0, 6810078.0],
                                    [728998.0, 6813854.0],
                                    [731262.0, 6826009.0],
                                    [737148.0, 6833964.0],
                                    [740952.0, 6835710.0],
                                    [733915.0, 6839303.0],
                                    [735102.0, 6844463.0],
                                    [732040.0, 6850473.0],
                                    [735603.0, 6861428.0],
                                    [729581.0, 6862815.0],
                                    [724211.0, 6867685.0],
                                    [722321.0, 6872132.0],
                                    [712559.0, 6879371.0],
                                    [712067.0, 6888882.0],
                                    [705248.0, 6890863.0],
                                    [700622.0, 6887964.0],
                                    [680633.0, 6884542.0],
                                    [673222.0, 6889902.0],
                                    [670084.0, 6886723.0],
                                    [667303.0, 6878971.0],
                                    [670882.0, 6870004.0],
                                    [667928.0, 6865519.0],
                                    [670056.0, 6856451.0],
                                    [671600.0, 6851283.0],
                                    [668472.0, 6843626.0],
                                    [665649.0, 6839786.0],
                                    [666363.0, 6833836.0],
                                    [663045.0, 6825117.0],
                                    [663371.0, 6815578.0],
                                    [665496.0, 6812431.0],
                                    [657768.0, 6807009.0],
                                    [655721.0, 6802434.0],
                                    [657236.0, 6795707.0],
                                    [663338.0, 6793247.0],
                                    [665644.0, 6782354.0],
                                    [678166.0, 6780535.0],
                                    [685053.0, 6785343.0],
                                    [695265.0, 6784783.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 43,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [706470.0, 6995042.0],
                                    [691147.0, 6993758.0],
                                    [689814.0, 6997681.0],
                                    [669642.0, 7001764.0],
                                    [667892.0, 7004913.0],
                                    [662547.0, 7004433.0],
                                    [658067.0, 7000416.0],
                                    [656343.0, 7006536.0],
                                    [663948.0, 7010834.0],
                                    [660837.0, 7014835.0],
                                    [654991.0, 7012592.0],
                                    [648121.0, 7014552.0],
                                    [635372.0, 7012312.0],
                                    [634147.0, 7017146.0],
                                    [624801.0, 7021563.0],
                                    [622831.0, 7024302.0],
                                    [612989.0, 7030025.0],
                                    [605232.0, 7026713.0],
                                    [603193.0, 7029103.0],
                                    [596733.0, 7029014.0],
                                    [595668.0, 7021497.0],
                                    [599348.0, 7018454.0],
                                    [591189.0, 7008466.0],
                                    [589294.0, 7002423.0],
                                    [583880.0, 6997485.0],
                                    [589321.0, 6994349.0],
                                    [605014.0, 6980736.0],
                                    [608347.0, 6970745.0],
                                    [612314.0, 6962826.0],
                                    [620154.0, 6956108.0],
                                    [623025.0, 6958366.0],
                                    [636565.0, 6954687.0],
                                    [645659.0, 6956103.0],
                                    [654712.0, 6950974.0],
                                    [664208.0, 6949037.0],
                                    [669006.0, 6944292.0],
                                    [676176.0, 6942514.0],
                                    [677528.0, 6947426.0],
                                    [685504.0, 6946842.0],
                                    [685089.0, 6950779.0],
                                    [693916.0, 6955962.0],
                                    [708546.0, 6956332.0],
                                    [705667.0, 6969289.0],
                                    [708480.0, 6979518.0],
                                    [713833.0, 6986563.0],
                                    [712391.0, 6990404.0],
                                    [706470.0, 6995042.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 44,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [708104.0, 6472781.0],
                                    [709251.0, 6464988.0],
                                    [717445.0, 6463649.0],
                                    [722648.0, 6446835.0],
                                    [725628.0, 6444038.0],
                                    [723408.0, 6437470.0],
                                    [727352.0, 6435060.0],
                                    [728488.0, 6430309.0],
                                    [732563.0, 6427378.0],
                                    [732994.0, 6422485.0],
                                    [737614.0, 6413026.0],
                                    [746579.0, 6414955.0],
                                    [746937.0, 6419760.0],
                                    [752090.0, 6419191.0],
                                    [752669.0, 6414624.0],
                                    [758530.0, 6415778.0],
                                    [768276.0, 6405343.0],
                                    [774103.0, 6411136.0],
                                    [781273.0, 6415520.0],
                                    [782106.0, 6419872.0],
                                    [791307.0, 6420019.0],
                                    [796332.0, 6429870.0],
                                    [801638.0, 6433950.0],
                                    [808165.0, 6446004.0],
                                    [808187.0, 6450395.0],
                                    [813436.0, 6450097.0],
                                    [816370.0, 6460772.0],
                                    [811227.0, 6465007.0],
                                    [806856.0, 6463705.0],
                                    [807029.0, 6471772.0],
                                    [802398.0, 6475469.0],
                                    [792166.0, 6477709.0],
                                    [780259.0, 6472021.0],
                                    [776677.0, 6475557.0],
                                    [770263.0, 6473476.0],
                                    [763248.0, 6477235.0],
                                    [760473.0, 6472496.0],
                                    [752222.0, 6475420.0],
                                    [749018.0, 6471190.0],
                                    [739202.0, 6481030.0],
                                    [735734.0, 6477978.0],
                                    [722742.0, 6478087.0],
                                    [713160.0, 6472555.0],
                                    [708104.0, 6472781.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 45,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [776081.0, 6923412.0],
                                    [775242.0, 6918312.0],
                                    [767112.0, 6923360.0],
                                    [761575.0, 6918670.0],
                                    [747051.0, 6913033.0],
                                    [751361.0, 6898188.0],
                                    [745398.0, 6894771.0],
                                    [743801.0, 6891376.0],
                                    [747254.0, 6882494.0],
                                    [744067.0, 6871735.0],
                                    [738742.0, 6868146.0],
                                    [735603.0, 6861428.0],
                                    [732040.0, 6850473.0],
                                    [735102.0, 6844463.0],
                                    [733915.0, 6839303.0],
                                    [740952.0, 6835710.0],
                                    [746802.0, 6826973.0],
                                    [753955.0, 6826609.0],
                                    [760761.0, 6824301.0],
                                    [769985.0, 6834113.0],
                                    [773768.0, 6840880.0],
                                    [779497.0, 6845091.0],
                                    [785824.0, 6845891.0],
                                    [797551.0, 6845278.0],
                                    [796995.0, 6835851.0],
                                    [803526.0, 6829924.0],
                                    [814106.0, 6826118.0],
                                    [819107.0, 6829393.0],
                                    [823302.0, 6827043.0],
                                    [832829.0, 6827018.0],
                                    [830469.0, 6833515.0],
                                    [836281.0, 6837534.0],
                                    [835676.0, 6840415.0],
                                    [840675.0, 6844876.0],
                                    [846365.0, 6844539.0],
                                    [846329.0, 6850924.0],
                                    [838677.0, 6859119.0],
                                    [841874.0, 6870868.0],
                                    [848655.0, 6874905.0],
                                    [848915.0, 6882413.0],
                                    [846791.0, 6883540.0],
                                    [845429.0, 6892400.0],
                                    [841416.0, 6900107.0],
                                    [842092.0, 6905887.0],
                                    [837898.0, 6908256.0],
                                    [833062.0, 6905548.0],
                                    [822754.0, 6907655.0],
                                    [818364.0, 6905215.0],
                                    [814643.0, 6911926.0],
                                    [803525.0, 6909934.0],
                                    [795010.0, 6915033.0],
                                    [790665.0, 6921022.0],
                                    [782994.0, 6923346.0],
                                    [776081.0, 6923412.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 46,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [428954.0, 6200122.0],
                                    [442286.0, 6190571.0],
                                    [445343.0, 6185147.0],
                                    [453012.0, 6180794.0],
                                    [468501.0, 6186020.0],
                                    [475317.0, 6183479.0],
                                    [477861.0, 6178841.0],
                                    [483521.0, 6184043.0],
                                    [489111.0, 6180226.0],
                                    [493119.0, 6181125.0],
                                    [491362.0, 6184305.0],
                                    [492032.0, 6195420.0],
                                    [493715.0, 6200925.0],
                                    [501753.0, 6199863.0],
                                    [506394.0, 6214104.0],
                                    [501199.0, 6216194.0],
                                    [498958.0, 6224762.0],
                                    [491741.0, 6229153.0],
                                    [500952.0, 6237523.0],
                                    [501020.0, 6240519.0],
                                    [506455.0, 6246240.0],
                                    [505760.0, 6248691.0],
                                    [496988.0, 6250664.0],
                                    [479309.0, 6257879.0],
                                    [471536.0, 6256527.0],
                                    [468215.0, 6263513.0],
                                    [466465.0, 6272970.0],
                                    [461941.0, 6273297.0],
                                    [457450.0, 6278664.0],
                                    [456497.0, 6283051.0],
                                    [449863.0, 6280833.0],
                                    [454138.0, 6272903.0],
                                    [451477.0, 6264635.0],
                                    [457777.0, 6262698.0],
                                    [452746.0, 6249402.0],
                                    [454979.0, 6245934.0],
                                    [446410.0, 6236240.0],
                                    [443868.0, 6230545.0],
                                    [440142.0, 6228799.0],
                                    [437107.0, 6220297.0],
                                    [431385.0, 6215423.0],
                                    [431947.0, 6209367.0],
                                    [428150.0, 6207547.0],
                                    [428954.0, 6200122.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 47,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [547193.0, 6388334.0],
                                    [542159.0, 6383881.0],
                                    [541673.0, 6377661.0],
                                    [545774.0, 6366277.0],
                                    [549131.0, 6360516.0],
                                    [562737.0, 6350024.0],
                                    [570617.0, 6348643.0],
                                    [581893.0, 6352690.0],
                                    [585843.0, 6356520.0],
                                    [592401.0, 6355117.0],
                                    [596271.0, 6358053.0],
                                    [610874.0, 6360746.0],
                                    [607709.0, 6375883.0],
                                    [615061.0, 6379167.0],
                                    [625170.0, 6387538.0],
                                    [632813.0, 6386229.0],
                                    [637122.0, 6391031.0],
                                    [634129.0, 6393565.0],
                                    [633003.0, 6406356.0],
                                    [634482.0, 6410441.0],
                                    [628463.0, 6419614.0],
                                    [626129.0, 6431248.0],
                                    [613933.0, 6431618.0],
                                    [607209.0, 6426078.0],
                                    [601475.0, 6429196.0],
                                    [593751.0, 6437105.0],
                                    [584718.0, 6439628.0],
                                    [577774.0, 6436765.0],
                                    [574976.0, 6434607.0],
                                    [576964.0, 6421036.0],
                                    [570522.0, 6417080.0],
                                    [570668.0, 6413830.0],
                                    [564402.0, 6403210.0],
                                    [559319.0, 6399932.0],
                                    [553113.0, 6398528.0],
                                    [553597.0, 6395079.0],
                                    [547193.0, 6388334.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 48,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [992638.0, 6305621.0],
                                    [997097.0, 6315251.0],
                                    [1000978.0, 6315262.0],
                                    [1007566.0, 6320724.0],
                                    [1012050.0, 6317690.0],
                                    [1014122.0, 6322114.0],
                                    [1009068.0, 6324850.0],
                                    [1007601.0, 6328762.0],
                                    [1000089.0, 6334256.0],
                                    [1000668.0, 6338218.0],
                                    [994698.0, 6348019.0],
                                    [997268.0, 6357103.0],
                                    [1002665.0, 6364730.0],
                                    [1009696.0, 6370071.0],
                                    [1008626.0, 6382943.0],
                                    [1006125.0, 6388590.0],
                                    [1012175.0, 6394096.0],
                                    [1012913.0, 6402904.0],
                                    [1010207.0, 6403290.0],
                                    [1004568.0, 6397351.0],
                                    [999315.0, 6394909.0],
                                    [992592.0, 6389297.0],
                                    [988952.0, 6378656.0],
                                    [983401.0, 6378221.0],
                                    [971476.0, 6380340.0],
                                    [967103.0, 6386021.0],
                                    [957182.0, 6379131.0],
                                    [959705.0, 6373500.0],
                                    [957118.0, 6369997.0],
                                    [950982.0, 6378672.0],
                                    [944316.0, 6377139.0],
                                    [935206.0, 6370624.0],
                                    [932421.0, 6356788.0],
                                    [925339.0, 6357350.0],
                                    [930231.0, 6349978.0],
                                    [920148.0, 6349530.0],
                                    [913873.0, 6347227.0],
                                    [911050.0, 6344481.0],
                                    [905908.0, 6346585.0],
                                    [903520.0, 6340766.0],
                                    [899978.0, 6338355.0],
                                    [900470.0, 6332559.0],
                                    [903879.0, 6328807.0],
                                    [901642.0, 6319541.0],
                                    [909386.0, 6316209.0],
                                    [907367.0, 6306820.0],
                                    [913516.0, 6306489.0],
                                    [922160.0, 6296144.0],
                                    [923991.0, 6299127.0],
                                    [933734.0, 6296912.0],
                                    [944763.0, 6293054.0],
                                    [956283.0, 6301072.0],
                                    [958836.0, 6305328.0],
                                    [970413.0, 6298787.0],
                                    [974848.0, 6301646.0],
                                    [974774.0, 6305117.0],
                                    [983574.0, 6307147.0],
                                    [992638.0, 6305621.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 49,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [521086.0, 6735350.0],
                                    [518605.0, 6737439.0],
                                    [528757.0, 6745774.0],
                                    [533549.0, 6751156.0],
                                    [532634.0, 6757689.0],
                                    [539183.0, 6762306.0],
                                    [535875.0, 6773086.0],
                                    [539332.0, 6780273.0],
                                    [542578.0, 6786711.0],
                                    [536374.0, 6790515.0],
                                    [531913.0, 6790043.0],
                                    [528051.0, 6796772.0],
                                    [517130.0, 6797243.0],
                                    [513744.0, 6803794.0],
                                    [506061.0, 6806938.0],
                                    [505117.0, 6820071.0],
                                    [500193.0, 6823412.0],
                                    [486746.0, 6818925.0],
                                    [482552.0, 6813147.0],
                                    [477803.0, 6815005.0],
                                    [473893.0, 6813452.0],
                                    [467628.0, 6811401.0],
                                    [465298.0, 6799724.0],
                                    [466280.0, 6794064.0],
                                    [458409.0, 6789055.0],
                                    [460615.0, 6783387.0],
                                    [459373.0, 6778102.0],
                                    [451057.0, 6776681.0],
                                    [455060.0, 6767070.0],
                                    [447308.0, 6764356.0],
                                    [448124.0, 6758669.0],
                                    [442128.0, 6753611.0],
                                    [446459.0, 6750432.0],
                                    [446732.0, 6745443.0],
                                    [450112.0, 6740918.0],
                                    [457617.0, 6739093.0],
                                    [460339.0, 6732350.0],
                                    [464631.0, 6730466.0],
                                    [469484.0, 6733109.0],
                                    [474490.0, 6731769.0],
                                    [478533.0, 6727039.0],
                                    [485937.0, 6723990.0],
                                    [491931.0, 6726763.0],
                                    [502971.0, 6722018.0],
                                    [509057.0, 6729569.0],
                                    [515591.0, 6731294.0],
                                    [521086.0, 6735350.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 50,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "MultiPolygon",
                            "coordinates": [
                                [
                                    [
                                        [229520.0, 6710085.0],
                                        [240383.0, 6704696.0],
                                        [240163.0, 6708285.0],
                                        [235835.0, 6713741.0],
                                        [229006.0, 6716339.0],
                                        [229520.0, 6710085.0],
                                    ]
                                ],
                                [
                                    [
                                        [212687.0, 6770001.0],
                                        [211559.0, 6762660.0],
                                        [216528.0, 6752538.0],
                                        [224759.0, 6753321.0],
                                        [234540.0, 6747533.0],
                                        [234220.0, 6745025.0],
                                        [240082.0, 6736634.0],
                                        [251238.0, 6736509.0],
                                        [260889.0, 6740570.0],
                                        [266327.0, 6740184.0],
                                        [271833.0, 6736526.0],
                                        [269308.0, 6731426.0],
                                        [263161.0, 6733044.0],
                                        [258643.0, 6731063.0],
                                        [263631.0, 6725691.0],
                                        [274085.0, 6728424.0],
                                        [283689.0, 6728526.0],
                                        [290663.0, 6724762.0],
                                        [288997.0, 6719519.0],
                                        [300067.0, 6720583.0],
                                        [315995.0, 6726944.0],
                                        [317487.0, 6738014.0],
                                        [315562.0, 6748257.0],
                                        [318803.0, 6749864.0],
                                        [322365.0, 6758359.0],
                                        [317839.0, 6765781.0],
                                        [320890.0, 6769878.0],
                                        [317014.0, 6776765.0],
                                        [309516.0, 6779524.0],
                                        [306739.0, 6782705.0],
                                        [310549.0, 6787938.0],
                                        [306966.0, 6794650.0],
                                        [300637.0, 6793781.0],
                                        [298204.0, 6799128.0],
                                        [291749.0, 6798375.0],
                                        [285132.0, 6789099.0],
                                        [280665.0, 6785525.0],
                                        [277875.0, 6787107.0],
                                        [279762.0, 6794931.0],
                                        [270150.0, 6795768.0],
                                        [252150.0, 6805897.0],
                                        [246074.0, 6807146.0],
                                        [242780.0, 6802066.0],
                                        [233945.0, 6800703.0],
                                        [229439.0, 6804532.0],
                                        [212675.0, 6807535.0],
                                        [202658.0, 6804638.0],
                                        [202166.0, 6798131.0],
                                        [205220.0, 6785800.0],
                                        [211608.0, 6786141.0],
                                        [216607.0, 6782805.0],
                                        [223352.0, 6780867.0],
                                        [221788.0, 6771592.0],
                                        [212687.0, 6770001.0],
                                    ]
                                ],
                            ],
                        },
                        "properties": {},
                        "id": 51,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [539112.0, 6843338.0],
                                    [541484.0, 6833537.0],
                                    [549859.0, 6826656.0],
                                    [547706.0, 6812952.0],
                                    [543224.0, 6808364.0],
                                    [535921.0, 6806758.0],
                                    [534094.0, 6803079.0],
                                    [538862.0, 6792254.0],
                                    [536374.0, 6790515.0],
                                    [542578.0, 6786711.0],
                                    [539332.0, 6780273.0],
                                    [551017.0, 6782681.0],
                                    [551727.0, 6777731.0],
                                    [559439.0, 6777275.0],
                                    [559999.0, 6772636.0],
                                    [566408.0, 6764638.0],
                                    [573758.0, 6762848.0],
                                    [589601.0, 6765689.0],
                                    [589165.0, 6770859.0],
                                    [595216.0, 6770968.0],
                                    [597558.0, 6774986.0],
                                    [606511.0, 6774717.0],
                                    [615539.0, 6776549.0],
                                    [623220.0, 6795517.0],
                                    [625387.0, 6798948.0],
                                    [624251.0, 6811501.0],
                                    [620852.0, 6812073.0],
                                    [620311.0, 6818025.0],
                                    [611402.0, 6819097.0],
                                    [608912.0, 6830618.0],
                                    [604791.0, 6831646.0],
                                    [597086.0, 6841311.0],
                                    [595472.0, 6845570.0],
                                    [596554.0, 6858123.0],
                                    [594217.0, 6866696.0],
                                    [590236.0, 6872273.0],
                                    [587701.0, 6866890.0],
                                    [579784.0, 6860594.0],
                                    [580772.0, 6855857.0],
                                    [576482.0, 6852521.0],
                                    [566604.0, 6854037.0],
                                    [555241.0, 6849633.0],
                                    [543803.0, 6848251.0],
                                    [539112.0, 6843338.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 52,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [1232225.0, 6105798.0],
                                    [1226359.0, 6102880.0],
                                    [1217754.0, 6104291.0],
                                    [1215715.0, 6123336.0],
                                    [1210743.0, 6122769.0],
                                    [1206639.0, 6131576.0],
                                    [1202519.0, 6133762.0],
                                    [1199675.0, 6142105.0],
                                    [1187662.0, 6146432.0],
                                    [1180116.0, 6152978.0],
                                    [1164950.0, 6158109.0],
                                    [1159342.0, 6158599.0],
                                    [1169805.0, 6146197.0],
                                    [1163901.0, 6144874.0],
                                    [1160274.0, 6141810.0],
                                    [1162433.0, 6134554.0],
                                    [1168722.0, 6128275.0],
                                    [1172897.0, 6127710.0],
                                    [1175910.0, 6121801.0],
                                    [1169135.0, 6117789.0],
                                    [1170381.0, 6114875.0],
                                    [1164715.0, 6111213.0],
                                    [1168686.0, 6106658.0],
                                    [1175324.0, 6107066.0],
                                    [1177911.0, 6109856.0],
                                    [1182246.0, 6105577.0],
                                    [1180256.0, 6096485.0],
                                    [1173562.0, 6088828.0],
                                    [1176478.0, 6086334.0],
                                    [1193164.0, 6083876.0],
                                    [1190373.0, 6079505.0],
                                    [1183548.0, 6076443.0],
                                    [1183755.0, 6068439.0],
                                    [1188281.0, 6067524.0],
                                    [1196826.0, 6061810.0],
                                    [1209242.0, 6057430.0],
                                    [1210610.0, 6054235.0],
                                    [1221376.0, 6050136.0],
                                    [1221646.0, 6056536.0],
                                    [1224377.0, 6061299.0],
                                    [1225618.0, 6068574.0],
                                    [1229809.0, 6072152.0],
                                    [1228158.0, 6078400.0],
                                    [1232811.0, 6083356.0],
                                    [1233466.0, 6095728.0],
                                    [1232225.0, 6105798.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 53,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [879041.0, 6935896.0],
                                    [878534.0, 6930925.0],
                                    [883576.0, 6926040.0],
                                    [891117.0, 6929633.0],
                                    [895087.0, 6927281.0],
                                    [898652.0, 6915853.0],
                                    [898091.0, 6905220.0],
                                    [901547.0, 6903348.0],
                                    [900172.0, 6898682.0],
                                    [901739.0, 6893315.0],
                                    [905859.0, 6891045.0],
                                    [906433.0, 6884047.0],
                                    [905066.0, 6875501.0],
                                    [901302.0, 6871865.0],
                                    [904125.0, 6862116.0],
                                    [899528.0, 6852809.0],
                                    [902927.0, 6847494.0],
                                    [903561.0, 6837915.0],
                                    [900379.0, 6832469.0],
                                    [904895.0, 6830283.0],
                                    [904250.0, 6825381.0],
                                    [910921.0, 6826770.0],
                                    [919362.0, 6809623.0],
                                    [930831.0, 6810526.0],
                                    [935203.0, 6815546.0],
                                    [963830.0, 6819154.0],
                                    [964951.0, 6823820.0],
                                    [973656.0, 6818945.0],
                                    [982282.0, 6817771.0],
                                    [987769.0, 6820181.0],
                                    [994239.0, 6827289.0],
                                    [1004385.0, 6831654.0],
                                    [1001023.0, 6834020.0],
                                    [993487.0, 6842033.0],
                                    [983189.0, 6843093.0],
                                    [976380.0, 6847597.0],
                                    [971773.0, 6847764.0],
                                    [969100.0, 6851558.0],
                                    [964692.0, 6852206.0],
                                    [961206.0, 6856322.0],
                                    [946451.0, 6858744.0],
                                    [945024.0, 6864515.0],
                                    [939656.0, 6875317.0],
                                    [929417.0, 6875078.0],
                                    [928151.0, 6878713.0],
                                    [922735.0, 6879575.0],
                                    [922708.0, 6883240.0],
                                    [914442.0, 6889764.0],
                                    [914011.0, 6893894.0],
                                    [920671.0, 6900380.0],
                                    [917676.0, 6905219.0],
                                    [920628.0, 6907653.0],
                                    [912688.0, 6923499.0],
                                    [913390.0, 6932141.0],
                                    [909643.0, 6936903.0],
                                    [902225.0, 6942685.0],
                                    [896580.0, 6941163.0],
                                    [892512.0, 6942531.0],
                                    [879041.0, 6935896.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 54,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [510545.0, 6875400.0],
                                    [504730.0, 6874732.0],
                                    [500558.0, 6877307.0],
                                    [491678.0, 6873174.0],
                                    [489675.0, 6876299.0],
                                    [484257.0, 6870962.0],
                                    [475607.0, 6865852.0],
                                    [469104.0, 6863978.0],
                                    [457511.0, 6867107.0],
                                    [454384.0, 6863198.0],
                                    [449827.0, 6868751.0],
                                    [446005.0, 6869054.0],
                                    [427244.0, 6861949.0],
                                    [417723.0, 6857101.0],
                                    [420581.0, 6852284.0],
                                    [423498.0, 6841841.0],
                                    [421619.0, 6835816.0],
                                    [414934.0, 6829326.0],
                                    [422197.0, 6821752.0],
                                    [429868.0, 6822252.0],
                                    [437568.0, 6825109.0],
                                    [441174.0, 6828584.0],
                                    [446687.0, 6829012.0],
                                    [451256.0, 6826715.0],
                                    [457920.0, 6827997.0],
                                    [463434.0, 6833996.0],
                                    [466087.0, 6830999.0],
                                    [467262.0, 6822174.0],
                                    [474394.0, 6821359.0],
                                    [473893.0, 6813452.0],
                                    [477803.0, 6815005.0],
                                    [482552.0, 6813147.0],
                                    [486746.0, 6818925.0],
                                    [500193.0, 6823412.0],
                                    [505117.0, 6820071.0],
                                    [506061.0, 6806938.0],
                                    [513744.0, 6803794.0],
                                    [517130.0, 6797243.0],
                                    [528051.0, 6796772.0],
                                    [531913.0, 6790043.0],
                                    [536374.0, 6790515.0],
                                    [538862.0, 6792254.0],
                                    [534094.0, 6803079.0],
                                    [535921.0, 6806758.0],
                                    [543224.0, 6808364.0],
                                    [547706.0, 6812952.0],
                                    [549859.0, 6826656.0],
                                    [541484.0, 6833537.0],
                                    [539112.0, 6843338.0],
                                    [533024.0, 6847407.0],
                                    [536389.0, 6850906.0],
                                    [533488.0, 6856087.0],
                                    [524600.0, 6861683.0],
                                    [520512.0, 6866728.0],
                                    [513552.0, 6867418.0],
                                    [508448.0, 6870995.0],
                                    [510545.0, 6875400.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 55,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [877344.0, 6596683.0],
                                    [869949.0, 6598870.0],
                                    [868758.0, 6603264.0],
                                    [857422.0, 6600366.0],
                                    [848718.0, 6603737.0],
                                    [845229.0, 6595067.0],
                                    [845050.0, 6590960.0],
                                    [839484.0, 6574938.0],
                                    [837322.0, 6565642.0],
                                    [838741.0, 6561678.0],
                                    [835220.0, 6556428.0],
                                    [834501.0, 6551198.0],
                                    [835850.0, 6543054.0],
                                    [833933.0, 6540287.0],
                                    [844536.0, 6535588.0],
                                    [849404.0, 6524528.0],
                                    [863140.0, 6525920.0],
                                    [870291.0, 6521483.0],
                                    [876089.0, 6523611.0],
                                    [879159.0, 6530984.0],
                                    [882529.0, 6534232.0],
                                    [888996.0, 6528631.0],
                                    [888123.0, 6525941.0],
                                    [897998.0, 6515860.0],
                                    [904449.0, 6504924.0],
                                    [909413.0, 6509006.0],
                                    [910338.0, 6515974.0],
                                    [915868.0, 6518199.0],
                                    [916332.0, 6528631.0],
                                    [919315.0, 6541572.0],
                                    [917441.0, 6547210.0],
                                    [916992.0, 6555432.0],
                                    [918731.0, 6560168.0],
                                    [928176.0, 6563414.0],
                                    [933670.0, 6575392.0],
                                    [940629.0, 6577110.0],
                                    [938817.0, 6580823.0],
                                    [943610.0, 6590224.0],
                                    [935280.0, 6595262.0],
                                    [929573.0, 6589336.0],
                                    [923919.0, 6580132.0],
                                    [919460.0, 6577537.0],
                                    [909869.0, 6577050.0],
                                    [908880.0, 6582354.0],
                                    [903737.0, 6585593.0],
                                    [895736.0, 6577631.0],
                                    [890444.0, 6576892.0],
                                    [887558.0, 6582363.0],
                                    [882486.0, 6586333.0],
                                    [882664.0, 6589574.0],
                                    [877221.0, 6593352.0],
                                    [877344.0, 6596683.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 56,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [524704.0, 6194181.0],
                                    [530246.0, 6189977.0],
                                    [542336.0, 6189236.0],
                                    [549247.0, 6180805.0],
                                    [554894.0, 6182516.0],
                                    [562658.0, 6181937.0],
                                    [567864.0, 6177510.0],
                                    [571419.0, 6168649.0],
                                    [580902.0, 6173997.0],
                                    [585134.0, 6170835.0],
                                    [592180.0, 6170254.0],
                                    [600206.0, 6164532.0],
                                    [607482.0, 6165290.0],
                                    [615529.0, 6169131.0],
                                    [617954.0, 6174066.0],
                                    [631545.0, 6174170.0],
                                    [632373.0, 6176261.0],
                                    [622733.0, 6184536.0],
                                    [614361.0, 6182470.0],
                                    [610538.0, 6185966.0],
                                    [608402.0, 6195450.0],
                                    [617137.0, 6197372.0],
                                    [617210.0, 6214637.0],
                                    [613663.0, 6217624.0],
                                    [614442.0, 6225039.0],
                                    [604330.0, 6228108.0],
                                    [595072.0, 6233132.0],
                                    [596256.0, 6236985.0],
                                    [593467.0, 6242482.0],
                                    [589272.0, 6240503.0],
                                    [582028.0, 6242918.0],
                                    [575081.0, 6235814.0],
                                    [572065.0, 6240985.0],
                                    [565565.0, 6247682.0],
                                    [561407.0, 6244405.0],
                                    [567825.0, 6236309.0],
                                    [562910.0, 6233771.0],
                                    [555809.0, 6233248.0],
                                    [554118.0, 6225953.0],
                                    [547328.0, 6230443.0],
                                    [541984.0, 6228895.0],
                                    [540236.0, 6224348.0],
                                    [535770.0, 6220735.0],
                                    [537386.0, 6214080.0],
                                    [535012.0, 6210452.0],
                                    [526458.0, 6208824.0],
                                    [522873.0, 6204718.0],
                                    [524704.0, 6194181.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 57,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [563452.0, 6484264.0],
                                    [563844.0, 6479160.0],
                                    [568750.0, 6477311.0],
                                    [560988.0, 6465186.0],
                                    [564865.0, 6461779.0],
                                    [566113.0, 6450433.0],
                                    [573095.0, 6446142.0],
                                    [577774.0, 6436765.0],
                                    [584718.0, 6439628.0],
                                    [593751.0, 6437105.0],
                                    [601475.0, 6429196.0],
                                    [607209.0, 6426078.0],
                                    [613933.0, 6431618.0],
                                    [626129.0, 6431248.0],
                                    [631663.0, 6432186.0],
                                    [628772.0, 6440050.0],
                                    [634831.0, 6442812.0],
                                    [638218.0, 6451518.0],
                                    [636846.0, 6458269.0],
                                    [642886.0, 6465907.0],
                                    [649118.0, 6470007.0],
                                    [651369.0, 6479623.0],
                                    [656321.0, 6476249.0],
                                    [659915.0, 6480065.0],
                                    [661594.0, 6486680.0],
                                    [662264.0, 6494997.0],
                                    [658322.0, 6500286.0],
                                    [662164.0, 6504560.0],
                                    [663288.0, 6509261.0],
                                    [660507.0, 6515469.0],
                                    [656101.0, 6511235.0],
                                    [649366.0, 6512420.0],
                                    [648450.0, 6509221.0],
                                    [637278.0, 6511373.0],
                                    [635791.0, 6515072.0],
                                    [631053.0, 6514297.0],
                                    [623634.0, 6517796.0],
                                    [614305.0, 6511565.0],
                                    [612121.0, 6507862.0],
                                    [605337.0, 6509707.0],
                                    [593766.0, 6498788.0],
                                    [587429.0, 6495459.0],
                                    [581471.0, 6497412.0],
                                    [576059.0, 6493313.0],
                                    [571080.0, 6486618.0],
                                    [566212.0, 6489282.0],
                                    [563452.0, 6484264.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 58,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [987691.0, 6753958.0],
                                    [989189.0, 6749828.0],
                                    [1000830.0, 6745745.0],
                                    [1003510.0, 6737902.0],
                                    [1000706.0, 6731961.0],
                                    [1006958.0, 6729298.0],
                                    [1010786.0, 6719537.0],
                                    [1014326.0, 6713511.0],
                                    [1019985.0, 6711034.0],
                                    [1024064.0, 6712992.0],
                                    [1031730.0, 6713160.0],
                                    [1039126.0, 6720266.0],
                                    [1038581.0, 6725392.0],
                                    [1044459.0, 6729657.0],
                                    [1044908.0, 6732411.0],
                                    [1039238.0, 6738821.0],
                                    [1038337.0, 6743276.0],
                                    [1040672.0, 6747502.0],
                                    [1039113.0, 6752662.0],
                                    [1040418.0, 6763108.0],
                                    [1044697.0, 6773634.0],
                                    [1040564.0, 6779861.0],
                                    [1040408.0, 6789869.0],
                                    [1036067.0, 6790258.0],
                                    [1032222.0, 6793924.0],
                                    [1032428.0, 6798669.0],
                                    [1022638.0, 6802981.0],
                                    [1016850.0, 6809125.0],
                                    [1011125.0, 6809400.0],
                                    [1006708.0, 6801985.0],
                                    [1001795.0, 6789636.0],
                                    [998205.0, 6776671.0],
                                    [993983.0, 6773739.0],
                                    [991355.0, 6761730.0],
                                    [993060.0, 6757264.0],
                                    [987691.0, 6753958.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 59,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [573297.0, 6677558.0],
                                    [569696.0, 6685244.0],
                                    [565759.0, 6689706.0],
                                    [561058.0, 6687382.0],
                                    [557051.0, 6690388.0],
                                    [558309.0, 6696538.0],
                                    [557303.0, 6702930.0],
                                    [559271.0, 6706788.0],
                                    [552945.0, 6716389.0],
                                    [555366.0, 6719856.0],
                                    [552256.0, 6724799.0],
                                    [543743.0, 6727862.0],
                                    [539386.0, 6732046.0],
                                    [530153.0, 6735215.0],
                                    [521086.0, 6735350.0],
                                    [515591.0, 6731294.0],
                                    [509057.0, 6729569.0],
                                    [502971.0, 6722018.0],
                                    [491931.0, 6726763.0],
                                    [489539.0, 6719725.0],
                                    [490772.0, 6714971.0],
                                    [487846.0, 6706491.0],
                                    [479254.0, 6691029.0],
                                    [476861.0, 6677880.0],
                                    [478404.0, 6673399.0],
                                    [482922.0, 6672972.0],
                                    [485608.0, 6667284.0],
                                    [494947.0, 6665028.0],
                                    [494833.0, 6656131.0],
                                    [505157.0, 6650870.0],
                                    [510389.0, 6653999.0],
                                    [517389.0, 6653506.0],
                                    [515158.0, 6658631.0],
                                    [524608.0, 6655240.0],
                                    [525272.0, 6647330.0],
                                    [531658.0, 6641492.0],
                                    [533123.0, 6635020.0],
                                    [537221.0, 6629765.0],
                                    [546519.0, 6631001.0],
                                    [551779.0, 6655211.0],
                                    [553982.0, 6659068.0],
                                    [560408.0, 6661557.0],
                                    [568878.0, 6661167.0],
                                    [571950.0, 6667671.0],
                                    [576079.0, 6670370.0],
                                    [573297.0, 6677558.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 60,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [634422.0, 7101577.0],
                                    [636514.0, 7100652.0],
                                    [642453.0, 7087769.0],
                                    [644454.0, 7079622.0],
                                    [653390.0, 7071778.0],
                                    [658064.0, 7064147.0],
                                    [664277.0, 7059477.0],
                                    [673807.0, 7057943.0],
                                    [679720.0, 7059405.0],
                                    [683642.0, 7063001.0],
                                    [688698.0, 7062196.0],
                                    [686184.0, 7056263.0],
                                    [687641.0, 7047582.0],
                                    [692820.0, 7044918.0],
                                    [697493.0, 7046164.0],
                                    [701478.0, 7042709.0],
                                    [702680.0, 7038239.0],
                                    [699507.0, 7031355.0],
                                    [712383.0, 7015916.0],
                                    [711164.0, 7009522.0],
                                    [706855.0, 7002888.0],
                                    [706470.0, 6995042.0],
                                    [712391.0, 6990404.0],
                                    [716534.0, 6992565.0],
                                    [720100.0, 6990781.0],
                                    [725313.0, 6993104.0],
                                    [735248.0, 6991264.0],
                                    [739058.0, 6995179.0],
                                    [744014.0, 6992056.0],
                                    [751253.0, 6997000.0],
                                    [753505.0, 6995276.0],
                                    [766237.0, 6992385.0],
                                    [770359.0, 6988977.0],
                                    [778060.0, 6986162.0],
                                    [781905.0, 6987282.0],
                                    [783321.0, 6995122.0],
                                    [788006.0, 6997129.0],
                                    [785882.0, 7004302.0],
                                    [780654.0, 7004663.0],
                                    [782919.0, 7012216.0],
                                    [787237.0, 7018342.0],
                                    [781127.0, 7020183.0],
                                    [773958.0, 7027731.0],
                                    [768979.0, 7028494.0],
                                    [763439.0, 7026158.0],
                                    [760772.0, 7028536.0],
                                    [753265.0, 7028386.0],
                                    [749524.0, 7024442.0],
                                    [746894.0, 7030603.0],
                                    [747241.0, 7039722.0],
                                    [743565.0, 7044070.0],
                                    [733656.0, 7048580.0],
                                    [726572.0, 7043892.0],
                                    [720348.0, 7047849.0],
                                    [717610.0, 7060148.0],
                                    [718286.0, 7067127.0],
                                    [713527.0, 7069761.0],
                                    [710740.0, 7076212.0],
                                    [704337.0, 7075998.0],
                                    [695621.0, 7071968.0],
                                    [692807.0, 7066387.0],
                                    [686789.0, 7068929.0],
                                    [680050.0, 7079722.0],
                                    [674224.0, 7079651.0],
                                    [671748.0, 7084186.0],
                                    [674131.0, 7094505.0],
                                    [670178.0, 7102078.0],
                                    [667909.0, 7110430.0],
                                    [659576.0, 7106814.0],
                                    [654175.0, 7107325.0],
                                    [637372.0, 7101244.0],
                                    [634422.0, 7101577.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 61,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [1010786.0, 6719537.0],
                                    [1006958.0, 6729298.0],
                                    [1000706.0, 6731961.0],
                                    [1003510.0, 6737902.0],
                                    [1000830.0, 6745745.0],
                                    [989189.0, 6749828.0],
                                    [987691.0, 6753958.0],
                                    [986052.0, 6752778.0],
                                    [981470.0, 6745308.0],
                                    [983826.0, 6731782.0],
                                    [986155.0, 6724947.0],
                                    [993651.0, 6723596.0],
                                    [994087.0, 6717743.0],
                                    [996902.0, 6711079.0],
                                    [1001194.0, 6713400.0],
                                    [999772.0, 6717889.0],
                                    [1007028.0, 6717766.0],
                                    [1010786.0, 6719537.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 62,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [382163.0, 6750361.0],
                                    [374291.0, 6753124.0],
                                    [371672.0, 6756673.0],
                                    [356172.0, 6751743.0],
                                    [351165.0, 6744974.0],
                                    [342268.0, 6743932.0],
                                    [335469.0, 6745297.0],
                                    [327477.0, 6743723.0],
                                    [317487.0, 6738014.0],
                                    [315995.0, 6726944.0],
                                    [300067.0, 6720583.0],
                                    [288997.0, 6719519.0],
                                    [282806.0, 6712695.0],
                                    [283678.0, 6703214.0],
                                    [288393.0, 6698809.0],
                                    [292251.0, 6700736.0],
                                    [299211.0, 6695249.0],
                                    [308160.0, 6699576.0],
                                    [309828.0, 6691500.0],
                                    [308860.0, 6686791.0],
                                    [304084.0, 6683183.0],
                                    [316935.0, 6678247.0],
                                    [322009.0, 6670666.0],
                                    [324590.0, 6666698.0],
                                    [332678.0, 6659222.0],
                                    [338731.0, 6658583.0],
                                    [343129.0, 6653969.0],
                                    [353671.0, 6649968.0],
                                    [357453.0, 6652400.0],
                                    [354064.0, 6663454.0],
                                    [354394.0, 6667534.0],
                                    [359840.0, 6669393.0],
                                    [361112.0, 6656907.0],
                                    [367588.0, 6659427.0],
                                    [367645.0, 6668175.0],
                                    [374065.0, 6668782.0],
                                    [376108.0, 6673611.0],
                                    [385082.0, 6667087.0],
                                    [387784.0, 6670618.0],
                                    [379298.0, 6676338.0],
                                    [379159.0, 6679552.0],
                                    [384839.0, 6683588.0],
                                    [382659.0, 6691801.0],
                                    [378391.0, 6691949.0],
                                    [374867.0, 6698071.0],
                                    [375470.0, 6701871.0],
                                    [385609.0, 6704471.0],
                                    [396890.0, 6703794.0],
                                    [402393.0, 6705897.0],
                                    [401401.0, 6717774.0],
                                    [387234.0, 6720426.0],
                                    [386462.0, 6727467.0],
                                    [395905.0, 6725901.0],
                                    [398982.0, 6728603.0],
                                    [389301.0, 6732485.0],
                                    [386987.0, 6740963.0],
                                    [381255.0, 6745617.0],
                                    [382163.0, 6750361.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 63,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [698236.0, 6718784.0],
                                    [701928.0, 6717598.0],
                                    [707666.0, 6720847.0],
                                    [709181.0, 6715638.0],
                                    [715400.0, 6713642.0],
                                    [717731.0, 6709895.0],
                                    [723118.0, 6710529.0],
                                    [726085.0, 6708066.0],
                                    [729904.0, 6712131.0],
                                    [736733.0, 6710509.0],
                                    [738638.0, 6714270.0],
                                    [743712.0, 6710994.0],
                                    [743701.0, 6707332.0],
                                    [751168.0, 6705240.0],
                                    [753904.0, 6700965.0],
                                    [759265.0, 6699206.0],
                                    [773240.0, 6698003.0],
                                    [773484.0, 6692940.0],
                                    [783517.0, 6693799.0],
                                    [780393.0, 6701310.0],
                                    [784360.0, 6705398.0],
                                    [783952.0, 6713331.0],
                                    [788376.0, 6717645.0],
                                    [791050.0, 6725986.0],
                                    [795163.0, 6731989.0],
                                    [794312.0, 6737086.0],
                                    [799827.0, 6740411.0],
                                    [799053.0, 6750471.0],
                                    [794318.0, 6750026.0],
                                    [796594.0, 6759156.0],
                                    [789480.0, 6763963.0],
                                    [783028.0, 6759096.0],
                                    [767353.0, 6760249.0],
                                    [763413.0, 6765164.0],
                                    [759917.0, 6778325.0],
                                    [755033.0, 6785741.0],
                                    [749678.0, 6782304.0],
                                    [746161.0, 6791892.0],
                                    [745765.0, 6796957.0],
                                    [736893.0, 6807760.0],
                                    [730707.0, 6810078.0],
                                    [727042.0, 6808060.0],
                                    [712422.0, 6807964.0],
                                    [703668.0, 6806647.0],
                                    [703237.0, 6796855.0],
                                    [700383.0, 6789702.0],
                                    [695265.0, 6784783.0],
                                    [702192.0, 6781427.0],
                                    [703759.0, 6774663.0],
                                    [706580.0, 6772621.0],
                                    [709585.0, 6763406.0],
                                    [703743.0, 6756785.0],
                                    [700769.0, 6756036.0],
                                    [701782.0, 6742907.0],
                                    [695135.0, 6740319.0],
                                    [689262.0, 6740069.0],
                                    [689391.0, 6734632.0],
                                    [694231.0, 6731133.0],
                                    [695341.0, 6722058.0],
                                    [698236.0, 6718784.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 64,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "MultiPolygon",
                            "coordinates": [
                                [
                                    [
                                        [330825.0, 6841252.0],
                                        [328251.0, 6849310.0],
                                        [322500.0, 6846053.0],
                                        [325749.0, 6841751.0],
                                        [330825.0, 6841252.0],
                                    ]
                                ],
                                [
                                    [
                                        [399495.0, 6830885.0],
                                        [389634.0, 6835155.0],
                                        [384742.0, 6834496.0],
                                        [376536.0, 6826525.0],
                                        [368413.0, 6830443.0],
                                        [366767.0, 6839135.0],
                                        [363309.0, 6845999.0],
                                        [348952.0, 6844300.0],
                                        [343084.0, 6846084.0],
                                        [341341.0, 6849649.0],
                                        [342875.0, 6855953.0],
                                        [334395.0, 6854417.0],
                                        [329772.0, 6850320.0],
                                        [334969.0, 6837949.0],
                                        [337450.0, 6835570.0],
                                        [332923.0, 6813386.0],
                                        [328273.0, 6809495.0],
                                        [325505.0, 6811765.0],
                                        [320973.0, 6806998.0],
                                        [315234.0, 6806646.0],
                                        [311879.0, 6798427.0],
                                        [306966.0, 6794650.0],
                                        [310549.0, 6787938.0],
                                        [306739.0, 6782705.0],
                                        [309516.0, 6779524.0],
                                        [317014.0, 6776765.0],
                                        [320890.0, 6769878.0],
                                        [317839.0, 6765781.0],
                                        [322365.0, 6758359.0],
                                        [318803.0, 6749864.0],
                                        [315562.0, 6748257.0],
                                        [317487.0, 6738014.0],
                                        [327477.0, 6743723.0],
                                        [335469.0, 6745297.0],
                                        [342268.0, 6743932.0],
                                        [351165.0, 6744974.0],
                                        [356172.0, 6751743.0],
                                        [371672.0, 6756673.0],
                                        [374291.0, 6753124.0],
                                        [382163.0, 6750361.0],
                                        [382932.0, 6754022.0],
                                        [386941.0, 6760260.0],
                                        [390140.0, 6770978.0],
                                        [394099.0, 6773357.0],
                                        [400197.0, 6773697.0],
                                        [400465.0, 6781914.0],
                                        [398626.0, 6784333.0],
                                        [395852.0, 6803336.0],
                                        [400321.0, 6810723.0],
                                        [398130.0, 6822559.0],
                                        [399495.0, 6830885.0],
                                    ]
                                ],
                            ],
                        },
                        "properties": {},
                        "id": 65,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [334283.0, 6280551.0],
                                    [338238.0, 6281381.0],
                                    [342731.0, 6276517.0],
                                    [352961.0, 6276001.0],
                                    [362964.0, 6280741.0],
                                    [367753.0, 6276986.0],
                                    [377063.0, 6275535.0],
                                    [385124.0, 6280151.0],
                                    [394475.0, 6281218.0],
                                    [399714.0, 6278404.0],
                                    [403447.0, 6281078.0],
                                    [412501.0, 6278002.0],
                                    [421554.0, 6283529.0],
                                    [424830.0, 6280287.0],
                                    [433057.0, 6279053.0],
                                    [438084.0, 6281592.0],
                                    [439499.0, 6295895.0],
                                    [442698.0, 6298315.0],
                                    [443572.0, 6313646.0],
                                    [440195.0, 6315550.0],
                                    [444807.0, 6320573.0],
                                    [453303.0, 6321029.0],
                                    [461632.0, 6315722.0],
                                    [465239.0, 6317398.0],
                                    [465465.0, 6324803.0],
                                    [464468.0, 6326808.0],
                                    [467874.0, 6336236.0],
                                    [470769.0, 6340294.0],
                                    [462757.0, 6341305.0],
                                    [459734.0, 6343570.0],
                                    [449759.0, 6344226.0],
                                    [449164.0, 6352477.0],
                                    [445091.0, 6357381.0],
                                    [442465.0, 6350467.0],
                                    [438523.0, 6349285.0],
                                    [429214.0, 6351421.0],
                                    [430077.0, 6359927.0],
                                    [426389.0, 6364119.0],
                                    [419635.0, 6366255.0],
                                    [418928.0, 6369127.0],
                                    [411174.0, 6373203.0],
                                    [411314.0, 6378206.0],
                                    [403228.0, 6378937.0],
                                    [393973.0, 6376334.0],
                                    [388231.0, 6379327.0],
                                    [381182.0, 6379048.0],
                                    [383562.0, 6383958.0],
                                    [375548.0, 6389853.0],
                                    [373686.0, 6386677.0],
                                    [361774.0, 6383396.0],
                                    [355175.0, 6347840.0],
                                    [348748.0, 6322487.0],
                                    [342546.0, 6300215.0],
                                    [341177.0, 6292691.0],
                                    [334283.0, 6280551.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 66,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [210124.0, 6860562.0],
                                    [210319.0, 6864435.0],
                                    [197918.0, 6867491.0],
                                    [195168.0, 6863087.0],
                                    [188759.0, 6861699.0],
                                    [187283.0, 6866983.0],
                                    [171676.0, 6866983.0],
                                    [165007.0, 6863478.0],
                                    [159513.0, 6866951.0],
                                    [150836.0, 6862294.0],
                                    [143559.0, 6862620.0],
                                    [137993.0, 6858007.0],
                                    [130421.0, 6856362.0],
                                    [126410.0, 6849458.0],
                                    [124277.0, 6841317.0],
                                    [126191.0, 6836271.0],
                                    [137035.0, 6831319.0],
                                    [151215.0, 6836632.0],
                                    [149516.0, 6831882.0],
                                    [159712.0, 6829829.0],
                                    [158800.0, 6824711.0],
                                    [152925.0, 6822802.0],
                                    [150196.0, 6824902.0],
                                    [139593.0, 6825317.0],
                                    [139209.0, 6819312.0],
                                    [147794.0, 6818873.0],
                                    [158225.0, 6812964.0],
                                    [159803.0, 6806301.0],
                                    [156741.0, 6801688.0],
                                    [151961.0, 6804475.0],
                                    [143250.0, 6802653.0],
                                    [129762.0, 6802135.0],
                                    [125302.0, 6798484.0],
                                    [144750.0, 6790824.0],
                                    [150552.0, 6779953.0],
                                    [149596.0, 6769606.0],
                                    [162294.0, 6768615.0],
                                    [164959.0, 6774152.0],
                                    [171525.0, 6775493.0],
                                    [174013.0, 6772980.0],
                                    [183941.0, 6774809.0],
                                    [184280.0, 6770949.0],
                                    [191411.0, 6764941.0],
                                    [196633.0, 6766198.0],
                                    [200244.0, 6762976.0],
                                    [211251.0, 6761104.0],
                                    [212687.0, 6770001.0],
                                    [221788.0, 6771592.0],
                                    [223352.0, 6780867.0],
                                    [216607.0, 6782805.0],
                                    [211608.0, 6786141.0],
                                    [205220.0, 6785800.0],
                                    [202166.0, 6798131.0],
                                    [202658.0, 6804638.0],
                                    [212675.0, 6807535.0],
                                    [216996.0, 6817941.0],
                                    [214652.0, 6824074.0],
                                    [215204.0, 6828740.0],
                                    [213034.0, 6834627.0],
                                    [212655.0, 6842190.0],
                                    [216761.0, 6846809.0],
                                    [210382.0, 6855067.0],
                                    [210124.0, 6860562.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 67,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [995359.0, 6526975.0],
                                    [996263.0, 6533312.0],
                                    [1005620.0, 6535079.0],
                                    [1009539.0, 6537663.0],
                                    [1013275.0, 6543845.0],
                                    [1010939.0, 6550631.0],
                                    [1005414.0, 6557665.0],
                                    [1000587.0, 6561265.0],
                                    [1000913.0, 6565514.0],
                                    [994423.0, 6565990.0],
                                    [993170.0, 6574229.0],
                                    [997429.0, 6583180.0],
                                    [990846.0, 6588853.0],
                                    [991547.0, 6595136.0],
                                    [985884.0, 6596474.0],
                                    [972312.0, 6594423.0],
                                    [960663.0, 6587846.0],
                                    [955674.0, 6591075.0],
                                    [952150.0, 6588701.0],
                                    [949250.0, 6580383.0],
                                    [953939.0, 6574878.0],
                                    [949136.0, 6572391.0],
                                    [944956.0, 6566962.0],
                                    [928176.0, 6563414.0],
                                    [918731.0, 6560168.0],
                                    [916992.0, 6555432.0],
                                    [917441.0, 6547210.0],
                                    [919315.0, 6541572.0],
                                    [921730.0, 6540986.0],
                                    [922988.0, 6530552.0],
                                    [926213.0, 6526897.0],
                                    [936560.0, 6520059.0],
                                    [946066.0, 6522280.0],
                                    [948121.0, 6516633.0],
                                    [952091.0, 6514710.0],
                                    [959117.0, 6516128.0],
                                    [962862.0, 6525460.0],
                                    [965836.0, 6528299.0],
                                    [969073.0, 6537583.0],
                                    [971940.0, 6540371.0],
                                    [975690.0, 6531451.0],
                                    [979688.0, 6528135.0],
                                    [984284.0, 6528734.0],
                                    [988618.0, 6520489.0],
                                    [995359.0, 6526975.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 68,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [605624.0, 6904387.0],
                                    [608283.0, 6898554.0],
                                    [612180.0, 6899061.0],
                                    [618689.0, 6896449.0],
                                    [626847.0, 6897876.0],
                                    [633020.0, 6901508.0],
                                    [645465.0, 6895048.0],
                                    [649761.0, 6898738.0],
                                    [652314.0, 6895981.0],
                                    [659205.0, 6894147.0],
                                    [670084.0, 6886723.0],
                                    [673222.0, 6889902.0],
                                    [680633.0, 6884542.0],
                                    [700622.0, 6887964.0],
                                    [705248.0, 6890863.0],
                                    [710189.0, 6894765.0],
                                    [704672.0, 6899225.0],
                                    [701957.0, 6908433.0],
                                    [698137.0, 6911415.0],
                                    [706929.0, 6919738.0],
                                    [706805.0, 6926038.0],
                                    [711648.0, 6928031.0],
                                    [706939.0, 6934901.0],
                                    [709520.0, 6938240.0],
                                    [707064.0, 6950845.0],
                                    [708546.0, 6956332.0],
                                    [693916.0, 6955962.0],
                                    [685089.0, 6950779.0],
                                    [685504.0, 6946842.0],
                                    [677528.0, 6947426.0],
                                    [676176.0, 6942514.0],
                                    [669006.0, 6944292.0],
                                    [664208.0, 6949037.0],
                                    [654712.0, 6950974.0],
                                    [645659.0, 6956103.0],
                                    [636565.0, 6954687.0],
                                    [623025.0, 6958366.0],
                                    [620154.0, 6956108.0],
                                    [612314.0, 6962826.0],
                                    [605401.0, 6955866.0],
                                    [607933.0, 6953359.0],
                                    [606321.0, 6945902.0],
                                    [609123.0, 6937659.0],
                                    [607205.0, 6935073.0],
                                    [610545.0, 6930338.0],
                                    [606642.0, 6924066.0],
                                    [609871.0, 6919444.0],
                                    [610931.0, 6911811.0],
                                    [606128.0, 6907968.0],
                                    [605624.0, 6904387.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 69,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [598361.0, 6887345.0],
                                    [603102.0, 6887292.0],
                                    [606678.0, 6883543.0],
                                    [614076.0, 6886919.0],
                                    [622312.0, 6880731.0],
                                    [628641.0, 6878089.0],
                                    [633062.0, 6879807.0],
                                    [641836.0, 6872490.0],
                                    [641404.0, 6867928.0],
                                    [648071.0, 6872567.0],
                                    [653619.0, 6875101.0],
                                    [660416.0, 6872923.0],
                                    [667303.0, 6878971.0],
                                    [670084.0, 6886723.0],
                                    [659205.0, 6894147.0],
                                    [652314.0, 6895981.0],
                                    [649761.0, 6898738.0],
                                    [645465.0, 6895048.0],
                                    [633020.0, 6901508.0],
                                    [626847.0, 6897876.0],
                                    [618689.0, 6896449.0],
                                    [612180.0, 6899061.0],
                                    [608283.0, 6898554.0],
                                    [605624.0, 6904387.0],
                                    [603501.0, 6902160.0],
                                    [601892.0, 6893098.0],
                                    [598361.0, 6887345.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 70,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [783517.0, 6693799.0],
                                    [773484.0, 6692940.0],
                                    [773240.0, 6698003.0],
                                    [759265.0, 6699206.0],
                                    [753904.0, 6700965.0],
                                    [751168.0, 6705240.0],
                                    [743701.0, 6707332.0],
                                    [743712.0, 6710994.0],
                                    [738638.0, 6714270.0],
                                    [736733.0, 6710509.0],
                                    [729904.0, 6712131.0],
                                    [726085.0, 6708066.0],
                                    [723118.0, 6710529.0],
                                    [717731.0, 6709895.0],
                                    [715400.0, 6713642.0],
                                    [709181.0, 6715638.0],
                                    [707666.0, 6720847.0],
                                    [701928.0, 6717598.0],
                                    [698236.0, 6718784.0],
                                    [693556.0, 6718403.0],
                                    [690565.0, 6713347.0],
                                    [694642.0, 6704915.0],
                                    [690449.0, 6694237.0],
                                    [698745.0, 6684384.0],
                                    [698614.0, 6680189.0],
                                    [702129.0, 6669867.0],
                                    [701762.0, 6662486.0],
                                    [705753.0, 6657660.0],
                                    [706033.0, 6650549.0],
                                    [703828.0, 6645606.0],
                                    [705186.0, 6641947.0],
                                    [702446.0, 6632753.0],
                                    [703745.0, 6628663.0],
                                    [716475.0, 6620334.0],
                                    [720608.0, 6624106.0],
                                    [726499.0, 6620539.0],
                                    [733164.0, 6623625.0],
                                    [737251.0, 6617690.0],
                                    [742042.0, 6624120.0],
                                    [748049.0, 6627896.0],
                                    [756196.0, 6628301.0],
                                    [760920.0, 6622686.0],
                                    [770503.0, 6626941.0],
                                    [775685.0, 6631211.0],
                                    [781064.0, 6632682.0],
                                    [780490.0, 6638662.0],
                                    [783308.0, 6642195.0],
                                    [778932.0, 6646959.0],
                                    [779000.0, 6654397.0],
                                    [781374.0, 6662136.0],
                                    [778810.0, 6664936.0],
                                    [780471.0, 6669516.0],
                                    [784602.0, 6669828.0],
                                    [789554.0, 6672918.0],
                                    [791663.0, 6673495.0],
                                    [793165.0, 6678355.0],
                                    [789098.0, 6683996.0],
                                    [785899.0, 6682517.0],
                                    [783517.0, 6693799.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 71,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [871408.0, 6655745.0],
                                    [875449.0, 6660099.0],
                                    [876191.0, 6666228.0],
                                    [881002.0, 6667371.0],
                                    [884880.0, 6674426.0],
                                    [887407.0, 6682465.0],
                                    [888032.0, 6690633.0],
                                    [890265.0, 6692353.0],
                                    [884919.0, 6701062.0],
                                    [880595.0, 6713705.0],
                                    [884206.0, 6713509.0],
                                    [887785.0, 6718944.0],
                                    [886108.0, 6726069.0],
                                    [882147.0, 6728546.0],
                                    [878352.0, 6725366.0],
                                    [868188.0, 6726357.0],
                                    [863148.0, 6730266.0],
                                    [858300.0, 6729814.0],
                                    [848455.0, 6733791.0],
                                    [846031.0, 6742315.0],
                                    [848388.0, 6746302.0],
                                    [846087.0, 6753627.0],
                                    [838226.0, 6763382.0],
                                    [833316.0, 6764154.0],
                                    [833398.0, 6769005.0],
                                    [827043.0, 6770243.0],
                                    [817962.0, 6771080.0],
                                    [816397.0, 6764598.0],
                                    [808147.0, 6762855.0],
                                    [797692.0, 6763119.0],
                                    [796594.0, 6759156.0],
                                    [794318.0, 6750026.0],
                                    [799053.0, 6750471.0],
                                    [799827.0, 6740411.0],
                                    [794312.0, 6737086.0],
                                    [795163.0, 6731989.0],
                                    [791050.0, 6725986.0],
                                    [788376.0, 6717645.0],
                                    [783952.0, 6713331.0],
                                    [784360.0, 6705398.0],
                                    [780393.0, 6701310.0],
                                    [783517.0, 6693799.0],
                                    [785899.0, 6682517.0],
                                    [789098.0, 6683996.0],
                                    [793165.0, 6678355.0],
                                    [791663.0, 6673495.0],
                                    [795506.0, 6668991.0],
                                    [806631.0, 6665548.0],
                                    [806754.0, 6662035.0],
                                    [813434.0, 6659755.0],
                                    [823470.0, 6650227.0],
                                    [831500.0, 6648015.0],
                                    [855755.0, 6655507.0],
                                    [860161.0, 6652754.0],
                                    [871408.0, 6655745.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 72,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [643163.0, 6853168.0],
                                    [634691.0, 6849194.0],
                                    [632440.0, 6843248.0],
                                    [627800.0, 6838438.0],
                                    [627504.0, 6829048.0],
                                    [623768.0, 6826369.0],
                                    [620311.0, 6818025.0],
                                    [620852.0, 6812073.0],
                                    [624251.0, 6811501.0],
                                    [625387.0, 6798948.0],
                                    [639308.0, 6801806.0],
                                    [653275.0, 6801114.0],
                                    [655721.0, 6802434.0],
                                    [657768.0, 6807009.0],
                                    [665496.0, 6812431.0],
                                    [663371.0, 6815578.0],
                                    [663045.0, 6825117.0],
                                    [666363.0, 6833836.0],
                                    [665649.0, 6839786.0],
                                    [668472.0, 6843626.0],
                                    [663488.0, 6848458.0],
                                    [653706.0, 6846856.0],
                                    [650056.0, 6850064.0],
                                    [643163.0, 6853168.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 73,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [483517.0, 6558927.0],
                                    [485043.0, 6563684.0],
                                    [480502.0, 6565882.0],
                                    [477460.0, 6571967.0],
                                    [478920.0, 6578170.0],
                                    [482897.0, 6584792.0],
                                    [479925.0, 6587264.0],
                                    [475179.0, 6582497.0],
                                    [472141.0, 6584899.0],
                                    [472081.0, 6590232.0],
                                    [468300.0, 6594579.0],
                                    [467690.0, 6607234.0],
                                    [472374.0, 6614809.0],
                                    [467588.0, 6622657.0],
                                    [470952.0, 6628365.0],
                                    [469757.0, 6639127.0],
                                    [471018.0, 6649618.0],
                                    [465537.0, 6662685.0],
                                    [464624.0, 6667352.0],
                                    [458546.0, 6672434.0],
                                    [454238.0, 6672319.0],
                                    [442005.0, 6668948.0],
                                    [434893.0, 6670550.0],
                                    [429925.0, 6668493.0],
                                    [429262.0, 6663802.0],
                                    [424993.0, 6661094.0],
                                    [417889.0, 6660618.0],
                                    [413368.0, 6662854.0],
                                    [404251.0, 6660135.0],
                                    [408792.0, 6655192.0],
                                    [411920.0, 6644974.0],
                                    [417892.0, 6640888.0],
                                    [415662.0, 6636435.0],
                                    [420740.0, 6628764.0],
                                    [421344.0, 6621760.0],
                                    [423543.0, 6619698.0],
                                    [424018.0, 6609992.0],
                                    [422851.0, 6601758.0],
                                    [420470.0, 6597142.0],
                                    [428213.0, 6593481.0],
                                    [426574.0, 6590996.0],
                                    [411453.0, 6585116.0],
                                    [411065.0, 6578554.0],
                                    [415606.0, 6575464.0],
                                    [420640.0, 6566176.0],
                                    [426299.0, 6566639.0],
                                    [429269.0, 6562335.0],
                                    [437311.0, 6559539.0],
                                    [446458.0, 6558600.0],
                                    [459784.0, 6545825.0],
                                    [464645.0, 6548283.0],
                                    [465641.0, 6555184.0],
                                    [469589.0, 6554692.0],
                                    [473907.0, 6559092.0],
                                    [483517.0, 6558927.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 74,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [306966.0, 6794650.0],
                                    [311879.0, 6798427.0],
                                    [315234.0, 6806646.0],
                                    [320973.0, 6806998.0],
                                    [325505.0, 6811765.0],
                                    [328273.0, 6809495.0],
                                    [332923.0, 6813386.0],
                                    [337450.0, 6835570.0],
                                    [334969.0, 6837949.0],
                                    [330825.0, 6841252.0],
                                    [325749.0, 6841751.0],
                                    [322500.0, 6846053.0],
                                    [319331.0, 6843417.0],
                                    [315059.0, 6845536.0],
                                    [309156.0, 6855461.0],
                                    [296913.0, 6849790.0],
                                    [284640.0, 6841250.0],
                                    [280881.0, 6840740.0],
                                    [271227.0, 6848399.0],
                                    [271155.0, 6854763.0],
                                    [262910.0, 6863924.0],
                                    [263482.0, 6867351.0],
                                    [257346.0, 6869777.0],
                                    [251930.0, 6880323.0],
                                    [243322.0, 6881073.0],
                                    [228138.0, 6874463.0],
                                    [222446.0, 6879145.0],
                                    [216642.0, 6872989.0],
                                    [215941.0, 6861279.0],
                                    [210124.0, 6860562.0],
                                    [210382.0, 6855067.0],
                                    [216761.0, 6846809.0],
                                    [212655.0, 6842190.0],
                                    [213034.0, 6834627.0],
                                    [215204.0, 6828740.0],
                                    [214652.0, 6824074.0],
                                    [216996.0, 6817941.0],
                                    [212675.0, 6807535.0],
                                    [229439.0, 6804532.0],
                                    [233945.0, 6800703.0],
                                    [242780.0, 6802066.0],
                                    [246074.0, 6807146.0],
                                    [252150.0, 6805897.0],
                                    [270150.0, 6795768.0],
                                    [279762.0, 6794931.0],
                                    [277875.0, 6787107.0],
                                    [280665.0, 6785525.0],
                                    [285132.0, 6789099.0],
                                    [291749.0, 6798375.0],
                                    [298204.0, 6799128.0],
                                    [300637.0, 6793781.0],
                                    [306966.0, 6794650.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 75,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [702446.0, 6632753.0],
                                    [696943.0, 6633749.0],
                                    [686837.0, 6626145.0],
                                    [682775.0, 6624336.0],
                                    [677474.0, 6626628.0],
                                    [669145.0, 6615318.0],
                                    [670500.0, 6605989.0],
                                    [664479.0, 6602292.0],
                                    [660370.0, 6603761.0],
                                    [650317.0, 6601560.0],
                                    [645179.0, 6595086.0],
                                    [644784.0, 6591412.0],
                                    [647921.0, 6581264.0],
                                    [653217.0, 6581299.0],
                                    [659880.0, 6575828.0],
                                    [662729.0, 6571178.0],
                                    [666451.0, 6560450.0],
                                    [672252.0, 6557694.0],
                                    [679424.0, 6569309.0],
                                    [685369.0, 6566281.0],
                                    [688886.0, 6572856.0],
                                    [695157.0, 6571452.0],
                                    [693029.0, 6567076.0],
                                    [697819.0, 6557998.0],
                                    [712873.0, 6551781.0],
                                    [728730.0, 6550656.0],
                                    [732386.0, 6552810.0],
                                    [735860.0, 6546571.0],
                                    [745523.0, 6547324.0],
                                    [753779.0, 6537018.0],
                                    [754888.0, 6541809.0],
                                    [761084.0, 6541876.0],
                                    [763887.0, 6544360.0],
                                    [762385.0, 6549859.0],
                                    [763504.0, 6554575.0],
                                    [760949.0, 6561975.0],
                                    [762003.0, 6573092.0],
                                    [769267.0, 6575508.0],
                                    [775913.0, 6580395.0],
                                    [775079.0, 6589273.0],
                                    [776586.0, 6596649.0],
                                    [773476.0, 6599308.0],
                                    [768312.0, 6598303.0],
                                    [763922.0, 6603795.0],
                                    [761463.0, 6602522.0],
                                    [756931.0, 6607772.0],
                                    [753291.0, 6618069.0],
                                    [748734.0, 6623209.0],
                                    [748049.0, 6627896.0],
                                    [742042.0, 6624120.0],
                                    [737251.0, 6617690.0],
                                    [733164.0, 6623625.0],
                                    [726499.0, 6620539.0],
                                    [720608.0, 6624106.0],
                                    [716475.0, 6620334.0],
                                    [703745.0, 6628663.0],
                                    [702446.0, 6632753.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 76,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "MultiPolygon",
                            "coordinates": [
                                [
                                    [
                                        [365341.0, 6575902.0],
                                        [359213.0, 6576771.0],
                                        [352445.0, 6583031.0],
                                        [350494.0, 6577212.0],
                                        [356155.0, 6576636.0],
                                        [364082.0, 6571051.0],
                                        [365341.0, 6575902.0],
                                    ]
                                ],
                                [
                                    [
                                        [373352.0, 6542832.0],
                                        [371342.0, 6552252.0],
                                        [366346.0, 6552808.0],
                                        [362447.0, 6556836.0],
                                        [360591.0, 6548506.0],
                                        [369260.0, 6539881.0],
                                        [371124.0, 6531592.0],
                                        [374437.0, 6534213.0],
                                        [375330.0, 6540510.0],
                                        [373352.0, 6542832.0],
                                    ]
                                ],
                                [
                                    [
                                        [464807.0, 6459164.0],
                                        [461242.0, 6465553.0],
                                        [455660.0, 6465791.0],
                                        [456356.0, 6470307.0],
                                        [447267.0, 6474282.0],
                                        [443202.0, 6478722.0],
                                        [445861.0, 6484044.0],
                                        [444696.0, 6489309.0],
                                        [446521.0, 6493231.0],
                                        [442913.0, 6501478.0],
                                        [436951.0, 6506668.0],
                                        [434607.0, 6512022.0],
                                        [434480.0, 6521530.0],
                                        [445866.0, 6528260.0],
                                        [449713.0, 6524677.0],
                                        [455132.0, 6526680.0],
                                        [458386.0, 6534878.0],
                                        [457303.0, 6539406.0],
                                        [459784.0, 6545825.0],
                                        [446458.0, 6558600.0],
                                        [437311.0, 6559539.0],
                                        [429269.0, 6562335.0],
                                        [426299.0, 6566639.0],
                                        [420640.0, 6566176.0],
                                        [415606.0, 6575464.0],
                                        [411065.0, 6578554.0],
                                        [411453.0, 6585116.0],
                                        [404775.0, 6589452.0],
                                        [397324.0, 6586760.0],
                                        [391500.0, 6591809.0],
                                        [382360.0, 6587238.0],
                                        [383479.0, 6581738.0],
                                        [376439.0, 6576760.0],
                                        [374243.0, 6571617.0],
                                        [381511.0, 6566597.0],
                                        [386552.0, 6553761.0],
                                        [382858.0, 6551653.0],
                                        [385303.0, 6547012.0],
                                        [378912.0, 6532887.0],
                                        [370510.0, 6529071.0],
                                        [370474.0, 6520657.0],
                                        [379564.0, 6513624.0],
                                        [387626.0, 6509256.0],
                                        [386164.0, 6505245.0],
                                        [399796.0, 6489042.0],
                                        [404682.0, 6481482.0],
                                        [406100.0, 6476140.0],
                                        [418478.0, 6475494.0],
                                        [421098.0, 6472770.0],
                                        [431214.0, 6470295.0],
                                        [433418.0, 6457450.0],
                                        [437492.0, 6457585.0],
                                        [444096.0, 6451365.0],
                                        [452009.0, 6448234.0],
                                        [457280.0, 6451647.0],
                                        [460931.0, 6449393.0],
                                        [464807.0, 6459164.0],
                                    ]
                                ],
                            ],
                        },
                        "properties": {},
                        "id": 77,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [728488.0, 6430309.0],
                                    [727352.0, 6435060.0],
                                    [723408.0, 6437470.0],
                                    [725628.0, 6444038.0],
                                    [722648.0, 6446835.0],
                                    [717445.0, 6463649.0],
                                    [709251.0, 6464988.0],
                                    [708104.0, 6472781.0],
                                    [701310.0, 6465307.0],
                                    [695974.0, 6467752.0],
                                    [693859.0, 6474045.0],
                                    [688449.0, 6477003.0],
                                    [677684.0, 6475835.0],
                                    [672750.0, 6482640.0],
                                    [661594.0, 6486680.0],
                                    [659915.0, 6480065.0],
                                    [656321.0, 6476249.0],
                                    [651369.0, 6479623.0],
                                    [649118.0, 6470007.0],
                                    [642886.0, 6465907.0],
                                    [636846.0, 6458269.0],
                                    [638218.0, 6451518.0],
                                    [634831.0, 6442812.0],
                                    [628772.0, 6440050.0],
                                    [631663.0, 6432186.0],
                                    [626129.0, 6431248.0],
                                    [628463.0, 6419614.0],
                                    [634482.0, 6410441.0],
                                    [633003.0, 6406356.0],
                                    [634129.0, 6393565.0],
                                    [637122.0, 6391031.0],
                                    [637228.0, 6394175.0],
                                    [646639.0, 6396959.0],
                                    [655192.0, 6393469.0],
                                    [664849.0, 6402561.0],
                                    [665404.0, 6408608.0],
                                    [668313.0, 6410487.0],
                                    [668604.0, 6416079.0],
                                    [676829.0, 6423158.0],
                                    [679353.0, 6426925.0],
                                    [684359.0, 6419403.0],
                                    [688126.0, 6419157.0],
                                    [690477.0, 6411547.0],
                                    [694820.0, 6408897.0],
                                    [693924.0, 6403282.0],
                                    [698547.0, 6393953.0],
                                    [704864.0, 6413115.0],
                                    [707862.0, 6414941.0],
                                    [708330.0, 6420849.0],
                                    [714401.0, 6418301.0],
                                    [719705.0, 6424147.0],
                                    [728488.0, 6430309.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 78,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [664821.0, 6258302.0],
                                    [662679.0, 6249784.0],
                                    [667653.0, 6244475.0],
                                    [681495.0, 6239871.0],
                                    [686427.0, 6247043.0],
                                    [700353.0, 6246775.0],
                                    [700385.0, 6243263.0],
                                    [711963.0, 6238657.0],
                                    [716336.0, 6238907.0],
                                    [719561.0, 6234874.0],
                                    [727933.0, 6241307.0],
                                    [734945.0, 6243544.0],
                                    [741504.0, 6241707.0],
                                    [748880.0, 6250885.0],
                                    [753675.0, 6255020.0],
                                    [764523.0, 6260540.0],
                                    [773373.0, 6269062.0],
                                    [781738.0, 6273121.0],
                                    [788998.0, 6273432.0],
                                    [792922.0, 6276955.0],
                                    [796379.0, 6284647.0],
                                    [792244.0, 6293431.0],
                                    [780634.0, 6301895.0],
                                    [773726.0, 6310049.0],
                                    [766790.0, 6307842.0],
                                    [766255.0, 6313712.0],
                                    [763184.0, 6318967.0],
                                    [758340.0, 6319159.0],
                                    [750088.0, 6313306.0],
                                    [746263.0, 6307559.0],
                                    [742673.0, 6306434.0],
                                    [734096.0, 6312602.0],
                                    [728786.0, 6312824.0],
                                    [722102.0, 6311077.0],
                                    [716344.0, 6301672.0],
                                    [704815.0, 6303628.0],
                                    [704898.0, 6288229.0],
                                    [698819.0, 6289943.0],
                                    [694796.0, 6288406.0],
                                    [693221.0, 6284557.0],
                                    [680178.0, 6279485.0],
                                    [676690.0, 6282993.0],
                                    [671212.0, 6283521.0],
                                    [668935.0, 6274250.0],
                                    [672394.0, 6269695.0],
                                    [672444.0, 6264623.0],
                                    [668090.0, 6259189.0],
                                    [664821.0, 6258302.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 79,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [921863.0, 6404787.0],
                                    [918546.0, 6403480.0],
                                    [907889.0, 6409384.0],
                                    [894862.0, 6413405.0],
                                    [895949.0, 6427870.0],
                                    [895595.0, 6439026.0],
                                    [892767.0, 6444271.0],
                                    [888053.0, 6440277.0],
                                    [871457.0, 6445038.0],
                                    [871909.0, 6454823.0],
                                    [870728.0, 6463360.0],
                                    [866406.0, 6463235.0],
                                    [860939.0, 6470947.0],
                                    [855768.0, 6473591.0],
                                    [847361.0, 6468209.0],
                                    [841110.0, 6468164.0],
                                    [842390.0, 6453321.0],
                                    [844782.0, 6435636.0],
                                    [848816.0, 6428161.0],
                                    [844069.0, 6414766.0],
                                    [839715.0, 6410394.0],
                                    [841041.0, 6396655.0],
                                    [835764.0, 6388411.0],
                                    [834538.0, 6384016.0],
                                    [835151.0, 6374038.0],
                                    [832713.0, 6371581.0],
                                    [831614.0, 6360351.0],
                                    [840525.0, 6360052.0],
                                    [843837.0, 6356928.0],
                                    [844895.0, 6349809.0],
                                    [864358.0, 6358713.0],
                                    [871547.0, 6356009.0],
                                    [872115.0, 6350341.0],
                                    [890550.0, 6347548.0],
                                    [890601.0, 6342463.0],
                                    [894810.0, 6342254.0],
                                    [899978.0, 6338355.0],
                                    [903520.0, 6340766.0],
                                    [905908.0, 6346585.0],
                                    [911050.0, 6344481.0],
                                    [913873.0, 6347227.0],
                                    [914428.0, 6355637.0],
                                    [911254.0, 6355549.0],
                                    [909816.0, 6362305.0],
                                    [898744.0, 6362932.0],
                                    [892505.0, 6372493.0],
                                    [899815.0, 6380077.0],
                                    [907085.0, 6377469.0],
                                    [909000.0, 6384874.0],
                                    [906293.0, 6386082.0],
                                    [910174.0, 6394503.0],
                                    [921214.0, 6398819.0],
                                    [921863.0, 6404787.0],
                                ],
                                [
                                    [850837.0, 6364673.0],
                                    [852761.0, 6369494.0],
                                    [856829.0, 6372215.0],
                                    [860545.0, 6368019.0],
                                    [860544.0, 6360615.0],
                                    [857850.0, 6357360.0],
                                    [850729.0, 6357929.0],
                                    [850837.0, 6364673.0],
                                ],
                            ],
                        },
                        "properties": {},
                        "id": 80,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [600206.0, 6164532.0],
                                    [597209.0, 6163462.0],
                                    [595443.0, 6155896.0],
                                    [604042.0, 6154257.0],
                                    [614139.0, 6147692.0],
                                    [616327.0, 6140765.0],
                                    [624388.0, 6140739.0],
                                    [630462.0, 6147428.0],
                                    [638840.0, 6149005.0],
                                    [653442.0, 6143379.0],
                                    [657322.0, 6137875.0],
                                    [662029.0, 6137190.0],
                                    [665163.0, 6139863.0],
                                    [672907.0, 6137962.0],
                                    [673207.0, 6145058.0],
                                    [679658.0, 6147303.0],
                                    [683451.0, 6146537.0],
                                    [686936.0, 6150974.0],
                                    [703357.0, 6152588.0],
                                    [707042.0, 6147292.0],
                                    [714275.0, 6148346.0],
                                    [710994.0, 6157024.0],
                                    [704080.0, 6161154.0],
                                    [702907.0, 6175403.0],
                                    [703560.0, 6193187.0],
                                    [693222.0, 6198384.0],
                                    [688989.0, 6202113.0],
                                    [682753.0, 6199641.0],
                                    [678721.0, 6193157.0],
                                    [675246.0, 6192375.0],
                                    [659825.0, 6194610.0],
                                    [655189.0, 6193206.0],
                                    [644930.0, 6193342.0],
                                    [647326.0, 6181831.0],
                                    [644388.0, 6178927.0],
                                    [631545.0, 6174170.0],
                                    [617954.0, 6174066.0],
                                    [615529.0, 6169131.0],
                                    [607482.0, 6165290.0],
                                    [600206.0, 6164532.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 81,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [956276.0, 6452799.0],
                                    [964422.0, 6450656.0],
                                    [967061.0, 6446025.0],
                                    [974349.0, 6445704.0],
                                    [973771.0, 6449910.0],
                                    [985382.0, 6452122.0],
                                    [989157.0, 6455721.0],
                                    [995952.0, 6458223.0],
                                    [1002558.0, 6454919.0],
                                    [1011443.0, 6464355.0],
                                    [1024403.0, 6470318.0],
                                    [1021887.0, 6478062.0],
                                    [1027167.0, 6487344.0],
                                    [1021485.0, 6490016.0],
                                    [1020210.0, 6493869.0],
                                    [1012252.0, 6497350.0],
                                    [1011518.0, 6512378.0],
                                    [1006337.0, 6512917.0],
                                    [997830.0, 6518696.0],
                                    [995359.0, 6526975.0],
                                    [988618.0, 6520489.0],
                                    [984284.0, 6528734.0],
                                    [979688.0, 6528135.0],
                                    [975690.0, 6531451.0],
                                    [971940.0, 6540371.0],
                                    [969073.0, 6537583.0],
                                    [965836.0, 6528299.0],
                                    [962862.0, 6525460.0],
                                    [959117.0, 6516128.0],
                                    [952091.0, 6514710.0],
                                    [948121.0, 6516633.0],
                                    [946066.0, 6522280.0],
                                    [936560.0, 6520059.0],
                                    [926213.0, 6526897.0],
                                    [922988.0, 6530552.0],
                                    [921730.0, 6540986.0],
                                    [919315.0, 6541572.0],
                                    [916332.0, 6528631.0],
                                    [915868.0, 6518199.0],
                                    [910338.0, 6515974.0],
                                    [909413.0, 6509006.0],
                                    [904449.0, 6504924.0],
                                    [913763.0, 6489603.0],
                                    [917457.0, 6486189.0],
                                    [925224.0, 6482705.0],
                                    [931624.0, 6492445.0],
                                    [938381.0, 6486658.0],
                                    [943964.0, 6486985.0],
                                    [948557.0, 6482085.0],
                                    [949441.0, 6473761.0],
                                    [945461.0, 6470305.0],
                                    [945165.0, 6465401.0],
                                    [950505.0, 6456663.0],
                                    [956276.0, 6452799.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 82,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [921863.0, 6404787.0],
                                    [921214.0, 6398819.0],
                                    [910174.0, 6394503.0],
                                    [906293.0, 6386082.0],
                                    [909000.0, 6384874.0],
                                    [907085.0, 6377469.0],
                                    [899815.0, 6380077.0],
                                    [892505.0, 6372493.0],
                                    [898744.0, 6362932.0],
                                    [909816.0, 6362305.0],
                                    [911254.0, 6355549.0],
                                    [914428.0, 6355637.0],
                                    [913873.0, 6347227.0],
                                    [920148.0, 6349530.0],
                                    [930231.0, 6349978.0],
                                    [925339.0, 6357350.0],
                                    [932421.0, 6356788.0],
                                    [935206.0, 6370624.0],
                                    [944316.0, 6377139.0],
                                    [950982.0, 6378672.0],
                                    [957118.0, 6369997.0],
                                    [959705.0, 6373500.0],
                                    [957182.0, 6379131.0],
                                    [967103.0, 6386021.0],
                                    [971476.0, 6380340.0],
                                    [983401.0, 6378221.0],
                                    [988952.0, 6378656.0],
                                    [992592.0, 6389297.0],
                                    [999315.0, 6394909.0],
                                    [1004568.0, 6397351.0],
                                    [1010207.0, 6403290.0],
                                    [1012913.0, 6402904.0],
                                    [1015781.0, 6406977.0],
                                    [1022960.0, 6406318.0],
                                    [1016213.0, 6418043.0],
                                    [1016501.0, 6423604.0],
                                    [1010607.0, 6425833.0],
                                    [1004832.0, 6424533.0],
                                    [995855.0, 6430156.0],
                                    [996598.0, 6437292.0],
                                    [994575.0, 6442256.0],
                                    [989294.0, 6442329.0],
                                    [985382.0, 6452122.0],
                                    [973771.0, 6449910.0],
                                    [974349.0, 6445704.0],
                                    [967061.0, 6446025.0],
                                    [964422.0, 6450656.0],
                                    [956276.0, 6452799.0],
                                    [953909.0, 6450690.0],
                                    [952342.0, 6439924.0],
                                    [961377.0, 6439340.0],
                                    [964872.0, 6432532.0],
                                    [965006.0, 6422921.0],
                                    [960775.0, 6424797.0],
                                    [956742.0, 6422339.0],
                                    [947667.0, 6423241.0],
                                    [941569.0, 6417648.0],
                                    [939410.0, 6420031.0],
                                    [933177.0, 6416064.0],
                                    [930672.0, 6410433.0],
                                    [925560.0, 6409806.0],
                                    [921863.0, 6404787.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 83,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "MultiPolygon",
                            "coordinates": [
                                [
                                    [
                                        [850837.0, 6364673.0],
                                        [850729.0, 6357929.0],
                                        [857850.0, 6357360.0],
                                        [860544.0, 6360615.0],
                                        [860545.0, 6368019.0],
                                        [856829.0, 6372215.0],
                                        [852761.0, 6369494.0],
                                        [850837.0, 6364673.0],
                                    ]
                                ],
                                [
                                    [
                                        [839658.0, 6315433.0],
                                        [848847.0, 6314233.0],
                                        [858049.0, 6310039.0],
                                        [863255.0, 6305296.0],
                                        [865136.0, 6300908.0],
                                        [876282.0, 6295340.0],
                                        [879627.0, 6296831.0],
                                        [886796.0, 6295631.0],
                                        [896706.0, 6289935.0],
                                        [904218.0, 6287715.0],
                                        [910307.0, 6287877.0],
                                        [921881.0, 6295602.0],
                                        [922160.0, 6296144.0],
                                        [913516.0, 6306489.0],
                                        [907367.0, 6306820.0],
                                        [909386.0, 6316209.0],
                                        [901642.0, 6319541.0],
                                        [903879.0, 6328807.0],
                                        [900470.0, 6332559.0],
                                        [899978.0, 6338355.0],
                                        [894810.0, 6342254.0],
                                        [890601.0, 6342463.0],
                                        [890550.0, 6347548.0],
                                        [872115.0, 6350341.0],
                                        [871547.0, 6356009.0],
                                        [864358.0, 6358713.0],
                                        [844895.0, 6349809.0],
                                        [843837.0, 6356928.0],
                                        [840525.0, 6360052.0],
                                        [831614.0, 6360351.0],
                                        [831641.0, 6353746.0],
                                        [837656.0, 6344658.0],
                                        [836689.0, 6335330.0],
                                        [843231.0, 6331183.0],
                                        [847769.0, 6322554.0],
                                        [839658.0, 6315433.0],
                                    ]
                                ],
                            ],
                        },
                        "properties": {},
                        "id": 84,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [636090.0, 6591904.0],
                                    [634893.0, 6595681.0],
                                    [638969.0, 6598575.0],
                                    [635550.0, 6606712.0],
                                    [637665.0, 6611745.0],
                                    [634340.0, 6622075.0],
                                    [628673.0, 6627353.0],
                                    [632500.0, 6630848.0],
                                    [627496.0, 6637025.0],
                                    [633457.0, 6642556.0],
                                    [629301.0, 6648616.0],
                                    [631131.0, 6657674.0],
                                    [627981.0, 6660408.0],
                                    [627833.0, 6667741.0],
                                    [621646.0, 6669974.0],
                                    [615265.0, 6667454.0],
                                    [607114.0, 6670785.0],
                                    [612309.0, 6675948.0],
                                    [612147.0, 6680536.0],
                                    [602149.0, 6685865.0],
                                    [593597.0, 6687211.0],
                                    [582631.0, 6683116.0],
                                    [573297.0, 6677558.0],
                                    [576079.0, 6670370.0],
                                    [571950.0, 6667671.0],
                                    [568878.0, 6661167.0],
                                    [560408.0, 6661557.0],
                                    [553982.0, 6659068.0],
                                    [551779.0, 6655211.0],
                                    [546519.0, 6631001.0],
                                    [537221.0, 6629765.0],
                                    [541431.0, 6623495.0],
                                    [538906.0, 6616112.0],
                                    [542426.0, 6611026.0],
                                    [547958.0, 6609437.0],
                                    [557842.0, 6602380.0],
                                    [558128.0, 6596023.0],
                                    [562773.0, 6594026.0],
                                    [559931.0, 6588729.0],
                                    [569564.0, 6587075.0],
                                    [573702.0, 6590223.0],
                                    [578129.0, 6584256.0],
                                    [586530.0, 6592902.0],
                                    [595863.0, 6588324.0],
                                    [602234.0, 6588456.0],
                                    [609355.0, 6592908.0],
                                    [622684.0, 6592821.0],
                                    [630016.0, 6590287.0],
                                    [636090.0, 6591904.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 85,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [1232225.0, 6105798.0],
                                    [1232233.0, 6116272.0],
                                    [1242213.0, 6134033.0],
                                    [1241272.0, 6154177.0],
                                    [1238247.0, 6164499.0],
                                    [1238682.0, 6169952.0],
                                    [1236764.0, 6182904.0],
                                    [1228823.0, 6195229.0],
                                    [1228376.0, 6197858.0],
                                    [1231051.0, 6211355.0],
                                    [1228846.0, 6218876.0],
                                    [1227050.0, 6231255.0],
                                    [1223421.0, 6233783.0],
                                    [1216996.0, 6231337.0],
                                    [1218749.0, 6222752.0],
                                    [1215986.0, 6213431.0],
                                    [1218915.0, 6209217.0],
                                    [1219580.0, 6202912.0],
                                    [1215962.0, 6195537.0],
                                    [1212393.0, 6200184.0],
                                    [1205077.0, 6201621.0],
                                    [1198634.0, 6198671.0],
                                    [1193909.0, 6190462.0],
                                    [1183050.0, 6187935.0],
                                    [1176939.0, 6184145.0],
                                    [1176781.0, 6180877.0],
                                    [1165934.0, 6173994.0],
                                    [1165800.0, 6162888.0],
                                    [1161943.0, 6162734.0],
                                    [1159342.0, 6158599.0],
                                    [1164950.0, 6158109.0],
                                    [1180116.0, 6152978.0],
                                    [1187662.0, 6146432.0],
                                    [1199675.0, 6142105.0],
                                    [1202519.0, 6133762.0],
                                    [1206639.0, 6131576.0],
                                    [1210743.0, 6122769.0],
                                    [1215715.0, 6123336.0],
                                    [1217754.0, 6104291.0],
                                    [1226359.0, 6102880.0],
                                    [1232225.0, 6105798.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 86,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [563452.0, 6484264.0],
                                    [566212.0, 6489282.0],
                                    [571080.0, 6486618.0],
                                    [576059.0, 6493313.0],
                                    [581471.0, 6497412.0],
                                    [587429.0, 6495459.0],
                                    [593766.0, 6498788.0],
                                    [605337.0, 6509707.0],
                                    [612121.0, 6507862.0],
                                    [614305.0, 6511565.0],
                                    [612524.0, 6515422.0],
                                    [613074.0, 6522626.0],
                                    [604752.0, 6527760.0],
                                    [597279.0, 6527024.0],
                                    [591561.0, 6529605.0],
                                    [592200.0, 6538029.0],
                                    [586335.0, 6540289.0],
                                    [587795.0, 6549437.0],
                                    [580656.0, 6565605.0],
                                    [574730.0, 6569689.0],
                                    [580236.0, 6579624.0],
                                    [578129.0, 6584256.0],
                                    [573702.0, 6590223.0],
                                    [569564.0, 6587075.0],
                                    [559931.0, 6588729.0],
                                    [556218.0, 6586207.0],
                                    [548271.0, 6584464.0],
                                    [546474.0, 6577615.0],
                                    [538896.0, 6578287.0],
                                    [530127.0, 6570272.0],
                                    [531964.0, 6561069.0],
                                    [531290.0, 6552122.0],
                                    [539507.0, 6547743.0],
                                    [540666.0, 6541823.0],
                                    [534383.0, 6537804.0],
                                    [527825.0, 6527023.0],
                                    [522669.0, 6525452.0],
                                    [522412.0, 6520738.0],
                                    [515635.0, 6515544.0],
                                    [526849.0, 6509996.0],
                                    [524801.0, 6504583.0],
                                    [529342.0, 6499739.0],
                                    [539039.0, 6503445.0],
                                    [546900.0, 6501981.0],
                                    [553144.0, 6489340.0],
                                    [563452.0, 6484264.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 87,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "MultiPolygon",
                            "coordinates": [
                                [
                                    [
                                        [297360.0, 6667914.0],
                                        [299985.0, 6664525.0],
                                        [303823.0, 6669495.0],
                                        [298725.0, 6671705.0],
                                        [297360.0, 6667914.0],
                                    ]
                                ],
                                [
                                    [
                                        [322009.0, 6670666.0],
                                        [318317.0, 6668787.0],
                                        [315194.0, 6662103.0],
                                        [307861.0, 6656132.0],
                                        [308108.0, 6649020.0],
                                        [322518.0, 6633220.0],
                                        [328569.0, 6623483.0],
                                        [331126.0, 6610513.0],
                                        [333817.0, 6610276.0],
                                        [344797.0, 6600884.0],
                                        [354269.0, 6598459.0],
                                        [356701.0, 6592204.0],
                                        [364357.0, 6592471.0],
                                        [376108.0, 6582708.0],
                                        [376887.0, 6588202.0],
                                        [382360.0, 6587238.0],
                                        [391500.0, 6591809.0],
                                        [397324.0, 6586760.0],
                                        [404775.0, 6589452.0],
                                        [411453.0, 6585116.0],
                                        [426574.0, 6590996.0],
                                        [428213.0, 6593481.0],
                                        [420470.0, 6597142.0],
                                        [422851.0, 6601758.0],
                                        [424018.0, 6609992.0],
                                        [423543.0, 6619698.0],
                                        [421344.0, 6621760.0],
                                        [420740.0, 6628764.0],
                                        [415662.0, 6636435.0],
                                        [417892.0, 6640888.0],
                                        [411920.0, 6644974.0],
                                        [408792.0, 6655192.0],
                                        [404251.0, 6660135.0],
                                        [401283.0, 6663962.0],
                                        [392012.0, 6664073.0],
                                        [385082.0, 6667087.0],
                                        [376108.0, 6673611.0],
                                        [374065.0, 6668782.0],
                                        [367645.0, 6668175.0],
                                        [367588.0, 6659427.0],
                                        [361112.0, 6656907.0],
                                        [359840.0, 6669393.0],
                                        [354394.0, 6667534.0],
                                        [354064.0, 6663454.0],
                                        [357453.0, 6652400.0],
                                        [353671.0, 6649968.0],
                                        [343129.0, 6653969.0],
                                        [338731.0, 6658583.0],
                                        [332678.0, 6659222.0],
                                        [324590.0, 6666698.0],
                                        [322009.0, 6670666.0],
                                    ]
                                ],
                            ],
                        },
                        "properties": {},
                        "id": 88,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [917346.0, 6234793.0],
                                    [919352.0, 6230892.0],
                                    [929076.0, 6227424.0],
                                    [928534.0, 6223947.0],
                                    [932969.0, 6220583.0],
                                    [939545.0, 6227616.0],
                                    [947016.0, 6224540.0],
                                    [954550.0, 6225038.0],
                                    [959301.0, 6228480.0],
                                    [965861.0, 6230140.0],
                                    [974387.0, 6227034.0],
                                    [975697.0, 6233209.0],
                                    [984286.0, 6234176.0],
                                    [989472.0, 6238682.0],
                                    [995722.0, 6237173.0],
                                    [997536.0, 6239863.0],
                                    [998568.0, 6249133.0],
                                    [997443.0, 6253468.0],
                                    [1002933.0, 6264260.0],
                                    [1012590.0, 6265313.0],
                                    [1018256.0, 6272482.0],
                                    [1014132.0, 6274778.0],
                                    [1015523.0, 6285590.0],
                                    [1006552.0, 6288390.0],
                                    [1003290.0, 6292496.0],
                                    [1002326.0, 6300425.0],
                                    [992638.0, 6305621.0],
                                    [983574.0, 6307147.0],
                                    [974774.0, 6305117.0],
                                    [974848.0, 6301646.0],
                                    [970413.0, 6298787.0],
                                    [958836.0, 6305328.0],
                                    [956283.0, 6301072.0],
                                    [944763.0, 6293054.0],
                                    [933734.0, 6296912.0],
                                    [923991.0, 6299127.0],
                                    [922160.0, 6296144.0],
                                    [921881.0, 6295602.0],
                                    [926823.0, 6291811.0],
                                    [925792.0, 6288611.0],
                                    [917893.0, 6286245.0],
                                    [916541.0, 6283087.0],
                                    [920209.0, 6276225.0],
                                    [918385.0, 6268519.0],
                                    [922861.0, 6263349.0],
                                    [917403.0, 6259253.0],
                                    [924245.0, 6244827.0],
                                    [918110.0, 6241136.0],
                                    [917346.0, 6234793.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 89,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [670056.0, 6856451.0],
                                    [662997.0, 6862431.0],
                                    [657169.0, 6861180.0],
                                    [650942.0, 6857646.0],
                                    [650056.0, 6850064.0],
                                    [653706.0, 6846856.0],
                                    [663488.0, 6848458.0],
                                    [668472.0, 6843626.0],
                                    [671600.0, 6851283.0],
                                    [670056.0, 6856451.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 90,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [650942.0, 6857646.0],
                                    [645325.0, 6859675.0],
                                    [643644.0, 6863501.0],
                                    [650140.0, 6866932.0],
                                    [648071.0, 6872567.0],
                                    [641404.0, 6867928.0],
                                    [637864.0, 6864035.0],
                                    [637702.0, 6857774.0],
                                    [643163.0, 6853168.0],
                                    [650056.0, 6850064.0],
                                    [650942.0, 6857646.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 91,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [698547.0, 6393953.0],
                                    [706639.0, 6384441.0],
                                    [705449.0, 6378272.0],
                                    [710800.0, 6372878.0],
                                    [709537.0, 6364934.0],
                                    [712305.0, 6356606.0],
                                    [709994.0, 6353946.0],
                                    [718362.0, 6347498.0],
                                    [728598.0, 6344387.0],
                                    [729879.0, 6341376.0],
                                    [735189.0, 6336775.0],
                                    [750700.0, 6336169.0],
                                    [750995.0, 6342037.0],
                                    [754256.0, 6342872.0],
                                    [763780.0, 6336809.0],
                                    [768987.0, 6337162.0],
                                    [776174.0, 6341769.0],
                                    [775968.0, 6350322.0],
                                    [773621.0, 6356674.0],
                                    [775941.0, 6359276.0],
                                    [770571.0, 6365836.0],
                                    [775211.0, 6367175.0],
                                    [779411.0, 6373918.0],
                                    [775042.0, 6386528.0],
                                    [771844.0, 6388592.0],
                                    [768276.0, 6405343.0],
                                    [758530.0, 6415778.0],
                                    [752669.0, 6414624.0],
                                    [752090.0, 6419191.0],
                                    [746937.0, 6419760.0],
                                    [746579.0, 6414955.0],
                                    [737614.0, 6413026.0],
                                    [732994.0, 6422485.0],
                                    [732563.0, 6427378.0],
                                    [728488.0, 6430309.0],
                                    [719705.0, 6424147.0],
                                    [714401.0, 6418301.0],
                                    [708330.0, 6420849.0],
                                    [707862.0, 6414941.0],
                                    [704864.0, 6413115.0],
                                    [698547.0, 6393953.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 92,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [799607.0, 6263119.0],
                                    [825918.0, 6262030.0],
                                    [828657.0, 6259471.0],
                                    [826719.0, 6253810.0],
                                    [834804.0, 6251115.0],
                                    [842728.0, 6251679.0],
                                    [850515.0, 6249931.0],
                                    [851283.0, 6257962.0],
                                    [859395.0, 6260541.0],
                                    [865618.0, 6249711.0],
                                    [881792.0, 6250642.0],
                                    [887411.0, 6254047.0],
                                    [891677.0, 6249845.0],
                                    [890480.0, 6245406.0],
                                    [892188.0, 6237089.0],
                                    [906247.0, 6238345.0],
                                    [911635.0, 6232742.0],
                                    [917346.0, 6234793.0],
                                    [918110.0, 6241136.0],
                                    [924245.0, 6244827.0],
                                    [917403.0, 6259253.0],
                                    [922861.0, 6263349.0],
                                    [918385.0, 6268519.0],
                                    [920209.0, 6276225.0],
                                    [916541.0, 6283087.0],
                                    [917893.0, 6286245.0],
                                    [925792.0, 6288611.0],
                                    [926823.0, 6291811.0],
                                    [921881.0, 6295602.0],
                                    [910307.0, 6287877.0],
                                    [904218.0, 6287715.0],
                                    [896706.0, 6289935.0],
                                    [886796.0, 6295631.0],
                                    [879627.0, 6296831.0],
                                    [876282.0, 6295340.0],
                                    [865136.0, 6300908.0],
                                    [863255.0, 6305296.0],
                                    [858049.0, 6310039.0],
                                    [848847.0, 6314233.0],
                                    [839658.0, 6315433.0],
                                    [831988.0, 6308980.0],
                                    [833168.0, 6302217.0],
                                    [828463.0, 6288899.0],
                                    [819908.0, 6290041.0],
                                    [815212.0, 6281222.0],
                                    [813903.0, 6274579.0],
                                    [800175.0, 6267290.0],
                                    [799607.0, 6263119.0],
                                ],
                                [
                                    [869889.0, 6258065.0],
                                    [866899.0, 6258272.0],
                                    [866104.0, 6264876.0],
                                    [862374.0, 6265459.0],
                                    [862969.0, 6272152.0],
                                    [870516.0, 6271879.0],
                                    [874819.0, 6259107.0],
                                    [869889.0, 6258065.0],
                                ],
                            ],
                        },
                        "properties": {},
                        "id": 93,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [650942.0, 6857646.0],
                                    [657169.0, 6861180.0],
                                    [654926.0, 6867065.0],
                                    [650140.0, 6866932.0],
                                    [643644.0, 6863501.0],
                                    [645325.0, 6859675.0],
                                    [650942.0, 6857646.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 94,
                    },
                    {
                        "type": "Feature",
                        "geometry": {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [670056.0, 6856451.0],
                                    [667928.0, 6865519.0],
                                    [670882.0, 6870004.0],
                                    [667303.0, 6878971.0],
                                    [660416.0, 6872923.0],
                                    [653619.0, 6875101.0],
                                    [648071.0, 6872567.0],
                                    [650140.0, 6866932.0],
                                    [654926.0, 6867065.0],
                                    [657169.0, 6861180.0],
                                    [662997.0, 6862431.0],
                                    [670056.0, 6856451.0],
                                ]
                            ],
                        },
                        "properties": {},
                        "id": 95,
                    },
                ],
                "crs": {
                    "type": "name",
                    "properties": {"name": "urn:ogc:def:crs:EPSG::2154"},
                },
            },
            "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_GEOMETRY_ONLY",
        ),
    },
    2: {
        "path": data_only_path,
        "return_value": (
            {
                "type": "FeatureCollection",
                "name": "dept_population",
                "features": [
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "32",
                            "INSEE_REG": "76",
                            "POPULATION": 191091,
                            "AREA": 6304.33,
                            "DENSITY": 30.31,
                        },
                        "id": 0,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "47",
                            "INSEE_REG": "75",
                            "POPULATION": 332842,
                            "AREA": 5382.87,
                            "DENSITY": 61.83,
                        },
                        "id": 1,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "38",
                            "INSEE_REG": "84",
                            "POPULATION": 1258722,
                            "AREA": 7868.79,
                            "DENSITY": 159.96,
                        },
                        "id": 2,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "62",
                            "INSEE_REG": "32",
                            "POPULATION": 1468018,
                            "AREA": 6714.14,
                            "DENSITY": 218.65,
                        },
                        "id": 3,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "08",
                            "INSEE_REG": "44",
                            "POPULATION": 273579,
                            "AREA": 5253.13,
                            "DENSITY": 52.08,
                        },
                        "id": 4,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "10",
                            "INSEE_REG": "44",
                            "POPULATION": 310020,
                            "AREA": 6021.83,
                            "DENSITY": 51.48,
                        },
                        "id": 5,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "42",
                            "INSEE_REG": "84",
                            "POPULATION": 762941,
                            "AREA": 4795.85,
                            "DENSITY": 159.08,
                        },
                        "id": 6,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "06",
                            "INSEE_REG": "93",
                            "POPULATION": 1083310,
                            "AREA": 4291.62,
                            "DENSITY": 252.42,
                        },
                        "id": 7,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "31",
                            "INSEE_REG": "76",
                            "POPULATION": 1362672,
                            "AREA": 6364.82,
                            "DENSITY": 214.09,
                        },
                        "id": 8,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "71",
                            "INSEE_REG": "27",
                            "POPULATION": 553595,
                            "AREA": 8598.33,
                            "DENSITY": 64.38,
                        },
                        "id": 9,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "53",
                            "INSEE_REG": "52",
                            "POPULATION": 307445,
                            "AREA": 5208.37,
                            "DENSITY": 59.03,
                        },
                        "id": 10,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "78",
                            "INSEE_REG": "11",
                            "POPULATION": 1438266,
                            "AREA": 2305.64,
                            "DENSITY": 623.8,
                        },
                        "id": 11,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "50",
                            "INSEE_REG": "28",
                            "POPULATION": 496883,
                            "AREA": 6015.07,
                            "DENSITY": 82.61,
                        },
                        "id": 12,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "16",
                            "INSEE_REG": "75",
                            "POPULATION": 352335,
                            "AREA": 5963.54,
                            "DENSITY": 59.08,
                        },
                        "id": 13,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "25",
                            "INSEE_REG": "27",
                            "POPULATION": 539067,
                            "AREA": 5248.31,
                            "DENSITY": 102.71,
                        },
                        "id": 14,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "55",
                            "INSEE_REG": "44",
                            "POPULATION": 187187,
                            "AREA": 6233.18,
                            "DENSITY": 30.03,
                        },
                        "id": 15,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "33",
                            "INSEE_REG": "75",
                            "POPULATION": 1583384,
                            "AREA": 10068.74,
                            "DENSITY": 157.26,
                        },
                        "id": 16,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "14",
                            "INSEE_REG": "28",
                            "POPULATION": 694002,
                            "AREA": 5588.48,
                            "DENSITY": 124.18,
                        },
                        "id": 17,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "88",
                            "INSEE_REG": "44",
                            "POPULATION": 367673,
                            "AREA": 5891.56,
                            "DENSITY": 62.41,
                        },
                        "id": 18,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "18",
                            "INSEE_REG": "24",
                            "POPULATION": 304256,
                            "AREA": 7292.67,
                            "DENSITY": 41.72,
                        },
                        "id": 19,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "07",
                            "INSEE_REG": "84",
                            "POPULATION": 325712,
                            "AREA": 5562.05,
                            "DENSITY": 58.56,
                        },
                        "id": 20,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "02",
                            "INSEE_REG": "32",
                            "POPULATION": 534490,
                            "AREA": 7418.97,
                            "DENSITY": 72.04,
                        },
                        "id": 21,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "64",
                            "INSEE_REG": "75",
                            "POPULATION": 677309,
                            "AREA": 7691.6,
                            "DENSITY": 88.06,
                        },
                        "id": 22,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "41",
                            "INSEE_REG": "24",
                            "POPULATION": 331915,
                            "AREA": 6412.3,
                            "DENSITY": 51.76,
                        },
                        "id": 23,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "57",
                            "INSEE_REG": "44",
                            "POPULATION": 1043522,
                            "AREA": 6252.63,
                            "DENSITY": 166.89,
                        },
                        "id": 24,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "86",
                            "INSEE_REG": "75",
                            "POPULATION": 436876,
                            "AREA": 7025.24,
                            "DENSITY": 62.19,
                        },
                        "id": 25,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "24",
                            "INSEE_REG": "75",
                            "POPULATION": 413606,
                            "AREA": 9209.9,
                            "DENSITY": 44.91,
                        },
                        "id": 26,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "39",
                            "INSEE_REG": "27",
                            "POPULATION": 260188,
                            "AREA": 5040.63,
                            "DENSITY": 51.62,
                        },
                        "id": 27,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "82",
                            "INSEE_REG": "76",
                            "POPULATION": 258349,
                            "AREA": 3731.0,
                            "DENSITY": 69.24,
                        },
                        "id": 28,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "49",
                            "INSEE_REG": "52",
                            "POPULATION": 813493,
                            "AREA": 7161.34,
                            "DENSITY": 113.6,
                        },
                        "id": 29,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "69",
                            "INSEE_REG": "84",
                            "POPULATION": 1843319,
                            "AREA": 3253.11,
                            "DENSITY": 566.63,
                        },
                        "id": 30,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "12",
                            "INSEE_REG": "76",
                            "POPULATION": 279206,
                            "AREA": 8770.69,
                            "DENSITY": 31.83,
                        },
                        "id": 31,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "23",
                            "INSEE_REG": "75",
                            "POPULATION": 118638,
                            "AREA": 5589.16,
                            "DENSITY": 21.23,
                        },
                        "id": 32,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "45",
                            "INSEE_REG": "24",
                            "POPULATION": 678008,
                            "AREA": 6804.01,
                            "DENSITY": 99.65,
                        },
                        "id": 33,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "70",
                            "INSEE_REG": "27",
                            "POPULATION": 236659,
                            "AREA": 5382.37,
                            "DENSITY": 43.97,
                        },
                        "id": 34,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "63",
                            "INSEE_REG": "84",
                            "POPULATION": 653742,
                            "AREA": 8003.1,
                            "DENSITY": 81.69,
                        },
                        "id": 35,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "81",
                            "INSEE_REG": "76",
                            "POPULATION": 387890,
                            "AREA": 5785.79,
                            "DENSITY": 67.04,
                        },
                        "id": 36,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "27",
                            "INSEE_REG": "28",
                            "POPULATION": 601843,
                            "AREA": 6035.85,
                            "DENSITY": 99.71,
                        },
                        "id": 37,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "76",
                            "INSEE_REG": "28",
                            "POPULATION": 1254378,
                            "AREA": 6318.26,
                            "DENSITY": 198.53,
                        },
                        "id": 38,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "52",
                            "INSEE_REG": "44",
                            "POPULATION": 175640,
                            "AREA": 6249.91,
                            "DENSITY": 28.1,
                        },
                        "id": 39,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "30",
                            "INSEE_REG": "76",
                            "POPULATION": 744178,
                            "AREA": 5874.71,
                            "DENSITY": 126.67,
                        },
                        "id": 40,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "67",
                            "INSEE_REG": "44",
                            "POPULATION": 1125559,
                            "AREA": 4796.37,
                            "DENSITY": 234.67,
                        },
                        "id": 41,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "11",
                            "INSEE_REG": "76",
                            "POPULATION": 370260,
                            "AREA": 6351.35,
                            "DENSITY": 58.3,
                        },
                        "id": 42,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "77",
                            "INSEE_REG": "11",
                            "POPULATION": 1403997,
                            "AREA": 5924.64,
                            "DENSITY": 236.98,
                        },
                        "id": 43,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "43",
                            "INSEE_REG": "84",
                            "POPULATION": 227283,
                            "AREA": 4996.58,
                            "DENSITY": 45.49,
                        },
                        "id": 44,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "51",
                            "INSEE_REG": "44",
                            "POPULATION": 568895,
                            "AREA": 8195.78,
                            "DENSITY": 69.41,
                        },
                        "id": 45,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "80",
                            "INSEE_REG": "32",
                            "POPULATION": 572443,
                            "AREA": 6206.58,
                            "DENSITY": 92.23,
                        },
                        "id": 46,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "46",
                            "INSEE_REG": "76",
                            "POPULATION": 173828,
                            "AREA": 5221.64,
                            "DENSITY": 33.29,
                        },
                        "id": 47,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "65",
                            "INSEE_REG": "76",
                            "POPULATION": 228530,
                            "AREA": 4527.89,
                            "DENSITY": 50.47,
                        },
                        "id": 48,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "04",
                            "INSEE_REG": "93",
                            "POPULATION": 163915,
                            "AREA": 6993.79,
                            "DENSITY": 23.44,
                        },
                        "id": 49,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "72",
                            "INSEE_REG": "52",
                            "POPULATION": 566506,
                            "AREA": 6236.75,
                            "DENSITY": 90.83,
                        },
                        "id": 50,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "56",
                            "INSEE_REG": "53",
                            "POPULATION": 750863,
                            "AREA": 6864.07,
                            "DENSITY": 109.39,
                        },
                        "id": 51,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "2A",
                            "INSEE_REG": "94",
                            "POPULATION": 157249,
                            "AREA": 4028.53,
                            "DENSITY": 39.03,
                        },
                        "id": 52,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "28",
                            "INSEE_REG": "24",
                            "POPULATION": 433233,
                            "AREA": 5927.23,
                            "DENSITY": 73.09,
                        },
                        "id": 53,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "54",
                            "INSEE_REG": "44",
                            "POPULATION": 733481,
                            "AREA": 5283.29,
                            "DENSITY": 138.83,
                        },
                        "id": 54,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "01",
                            "INSEE_REG": "84",
                            "POPULATION": 643350,
                            "AREA": 5773.77,
                            "DENSITY": 111.43,
                        },
                        "id": 55,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "19",
                            "INSEE_REG": "75",
                            "POPULATION": 241464,
                            "AREA": 5888.93,
                            "DENSITY": 41.0,
                        },
                        "id": 56,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "09",
                            "INSEE_REG": "76",
                            "POPULATION": 153153,
                            "AREA": 4921.75,
                            "DENSITY": 31.12,
                        },
                        "id": 57,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "68",
                            "INSEE_REG": "44",
                            "POPULATION": 764030,
                            "AREA": 3526.37,
                            "DENSITY": 216.66,
                        },
                        "id": 58,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "59",
                            "INSEE_REG": "32",
                            "POPULATION": 2604361,
                            "AREA": 5774.99,
                            "DENSITY": 450.97,
                        },
                        "id": 59,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "90",
                            "INSEE_REG": "27",
                            "POPULATION": 142622,
                            "AREA": 609.64,
                            "DENSITY": 233.94,
                        },
                        "id": 60,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "44",
                            "INSEE_REG": "52",
                            "POPULATION": 1394909,
                            "AREA": 6992.78,
                            "DENSITY": 199.48,
                        },
                        "id": 61,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "89",
                            "INSEE_REG": "27",
                            "POPULATION": 338291,
                            "AREA": 7450.97,
                            "DENSITY": 45.4,
                        },
                        "id": 62,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "35",
                            "INSEE_REG": "53",
                            "POPULATION": 1060199,
                            "AREA": 6830.2,
                            "DENSITY": 155.22,
                        },
                        "id": 63,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "40",
                            "INSEE_REG": "75",
                            "POPULATION": 407444,
                            "AREA": 9353.03,
                            "DENSITY": 43.56,
                        },
                        "id": 64,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "29",
                            "INSEE_REG": "53",
                            "POPULATION": 909028,
                            "AREA": 6756.76,
                            "DENSITY": 134.54,
                        },
                        "id": 65,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "74",
                            "INSEE_REG": "84",
                            "POPULATION": 807360,
                            "AREA": 4596.53,
                            "DENSITY": 175.65,
                        },
                        "id": 66,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "60",
                            "INSEE_REG": "32",
                            "POPULATION": 824503,
                            "AREA": 5893.6,
                            "DENSITY": 139.9,
                        },
                        "id": 67,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "95",
                            "INSEE_REG": "11",
                            "POPULATION": 1228618,
                            "AREA": 1254.18,
                            "DENSITY": 979.62,
                        },
                        "id": 68,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "58",
                            "INSEE_REG": "27",
                            "POPULATION": 207182,
                            "AREA": 6862.87,
                            "DENSITY": 30.19,
                        },
                        "id": 69,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "61",
                            "INSEE_REG": "28",
                            "POPULATION": 283372,
                            "AREA": 6142.73,
                            "DENSITY": 46.13,
                        },
                        "id": 70,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "91",
                            "INSEE_REG": "11",
                            "POPULATION": 1296130,
                            "AREA": 1818.35,
                            "DENSITY": 712.81,
                        },
                        "id": 71,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "21",
                            "INSEE_REG": "27",
                            "POPULATION": 532871,
                            "AREA": 8787.51,
                            "DENSITY": 60.64,
                        },
                        "id": 72,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "22",
                            "INSEE_REG": "53",
                            "POPULATION": 598814,
                            "AREA": 6963.26,
                            "DENSITY": 86.0,
                        },
                        "id": 73,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "03",
                            "INSEE_REG": "84",
                            "POPULATION": 337988,
                            "AREA": 7365.26,
                            "DENSITY": 45.89,
                        },
                        "id": 74,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "17",
                            "INSEE_REG": "75",
                            "POPULATION": 644303,
                            "AREA": 6913.03,
                            "DENSITY": 93.2,
                        },
                        "id": 75,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "15",
                            "INSEE_REG": "84",
                            "POPULATION": 145143,
                            "AREA": 5767.47,
                            "DENSITY": 25.17,
                        },
                        "id": 76,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "34",
                            "INSEE_REG": "76",
                            "POPULATION": 1144892,
                            "AREA": 6231.05,
                            "DENSITY": 183.74,
                        },
                        "id": 77,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "26",
                            "INSEE_REG": "84",
                            "POPULATION": 511553,
                            "AREA": 6553.53,
                            "DENSITY": 78.06,
                        },
                        "id": 78,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "66",
                            "INSEE_REG": "76",
                            "POPULATION": 474452,
                            "AREA": 4147.76,
                            "DENSITY": 114.39,
                        },
                        "id": 79,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "73",
                            "INSEE_REG": "84",
                            "POPULATION": 431174,
                            "AREA": 6260.4,
                            "DENSITY": 68.87,
                        },
                        "id": 80,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "37",
                            "INSEE_REG": "24",
                            "POPULATION": 606511,
                            "AREA": 6147.6,
                            "DENSITY": 98.66,
                        },
                        "id": 81,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "05",
                            "INSEE_REG": "93",
                            "POPULATION": 141284,
                            "AREA": 5685.31,
                            "DENSITY": 24.85,
                        },
                        "id": 82,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "79",
                            "INSEE_REG": "75",
                            "POPULATION": 374351,
                            "AREA": 6029.06,
                            "DENSITY": 62.09,
                        },
                        "id": 83,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "84",
                            "INSEE_REG": "93",
                            "POPULATION": 559479,
                            "AREA": 3577.19,
                            "DENSITY": 156.4,
                        },
                        "id": 84,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "36",
                            "INSEE_REG": "24",
                            "POPULATION": 222232,
                            "AREA": 6887.38,
                            "DENSITY": 32.27,
                        },
                        "id": 85,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "2B",
                            "INSEE_REG": "94",
                            "POPULATION": 177689,
                            "AREA": 4719.71,
                            "DENSITY": 37.65,
                        },
                        "id": 86,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "87",
                            "INSEE_REG": "75",
                            "POPULATION": 374426,
                            "AREA": 5549.31,
                            "DENSITY": 67.47,
                        },
                        "id": 87,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "85",
                            "INSEE_REG": "52",
                            "POPULATION": 675247,
                            "AREA": 6758.23,
                            "DENSITY": 99.91,
                        },
                        "id": 88,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "83",
                            "INSEE_REG": "93",
                            "POPULATION": 1058740,
                            "AREA": 6002.84,
                            "DENSITY": 176.37,
                        },
                        "id": 89,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "94",
                            "INSEE_REG": "11",
                            "POPULATION": 1387926,
                            "AREA": 244.7,
                            "DENSITY": 5671.95,
                        },
                        "id": 90,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "92",
                            "INSEE_REG": "11",
                            "POPULATION": 1609306,
                            "AREA": 175.63,
                            "DENSITY": 9163.05,
                        },
                        "id": 91,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "48",
                            "INSEE_REG": "76",
                            "POPULATION": 76601,
                            "AREA": 5172.02,
                            "DENSITY": 14.81,
                        },
                        "id": 92,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "13",
                            "INSEE_REG": "93",
                            "POPULATION": 2024162,
                            "AREA": 5082.57,
                            "DENSITY": 398.26,
                        },
                        "id": 93,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "93",
                            "INSEE_REG": "11",
                            "POPULATION": 1623111,
                            "AREA": 236.96,
                            "DENSITY": 6849.73,
                        },
                        "id": 94,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "75",
                            "INSEE_REG": "11",
                            "POPULATION": 2187526,
                            "AREA": 105.44,
                            "DENSITY": 20746.64,
                        },
                        "id": 95,
                    },
                ],
            },
            "dept_population",
        ),
    },
    3: {
        "path": data_only_path,
        "return_value": (
            {
                "type": "FeatureCollection",
                "name": "dept_population",
                "features": [
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "32",
                            "INSEE_REG": "76",
                            "POPULATION": 191091,
                            "AREA": 6304.33,
                            "DENSITY": 30.31,
                        },
                        "id": 0,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "47",
                            "INSEE_REG": "75",
                            "POPULATION": 332842,
                            "AREA": 5382.87,
                            "DENSITY": 61.83,
                        },
                        "id": 1,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "38",
                            "INSEE_REG": "84",
                            "POPULATION": 1258722,
                            "AREA": 7868.79,
                            "DENSITY": 159.96,
                        },
                        "id": 2,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "62",
                            "INSEE_REG": "32",
                            "POPULATION": 1468018,
                            "AREA": 6714.14,
                            "DENSITY": 218.65,
                        },
                        "id": 3,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "08",
                            "INSEE_REG": "44",
                            "POPULATION": 273579,
                            "AREA": 5253.13,
                            "DENSITY": 52.08,
                        },
                        "id": 4,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "10",
                            "INSEE_REG": "44",
                            "POPULATION": 310020,
                            "AREA": 6021.83,
                            "DENSITY": 51.48,
                        },
                        "id": 5,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "42",
                            "INSEE_REG": "84",
                            "POPULATION": 762941,
                            "AREA": 4795.85,
                            "DENSITY": 159.08,
                        },
                        "id": 6,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "06",
                            "INSEE_REG": "93",
                            "POPULATION": 1083310,
                            "AREA": 4291.62,
                            "DENSITY": 252.42,
                        },
                        "id": 7,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "31",
                            "INSEE_REG": "76",
                            "POPULATION": 1362672,
                            "AREA": 6364.82,
                            "DENSITY": 214.09,
                        },
                        "id": 8,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "71",
                            "INSEE_REG": "27",
                            "POPULATION": 553595,
                            "AREA": 8598.33,
                            "DENSITY": 64.38,
                        },
                        "id": 9,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "53",
                            "INSEE_REG": "52",
                            "POPULATION": 307445,
                            "AREA": 5208.37,
                            "DENSITY": 59.03,
                        },
                        "id": 10,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "78",
                            "INSEE_REG": "11",
                            "POPULATION": 1438266,
                            "AREA": 2305.64,
                            "DENSITY": 623.8,
                        },
                        "id": 11,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "50",
                            "INSEE_REG": "28",
                            "POPULATION": 496883,
                            "AREA": 6015.07,
                            "DENSITY": 82.61,
                        },
                        "id": 12,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "16",
                            "INSEE_REG": "75",
                            "POPULATION": 352335,
                            "AREA": 5963.54,
                            "DENSITY": 59.08,
                        },
                        "id": 13,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "25",
                            "INSEE_REG": "27",
                            "POPULATION": 539067,
                            "AREA": 5248.31,
                            "DENSITY": 102.71,
                        },
                        "id": 14,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "55",
                            "INSEE_REG": "44",
                            "POPULATION": 187187,
                            "AREA": 6233.18,
                            "DENSITY": 30.03,
                        },
                        "id": 15,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "33",
                            "INSEE_REG": "75",
                            "POPULATION": 1583384,
                            "AREA": 10068.74,
                            "DENSITY": 157.26,
                        },
                        "id": 16,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "14",
                            "INSEE_REG": "28",
                            "POPULATION": 694002,
                            "AREA": 5588.48,
                            "DENSITY": 124.18,
                        },
                        "id": 17,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "88",
                            "INSEE_REG": "44",
                            "POPULATION": 367673,
                            "AREA": 5891.56,
                            "DENSITY": 62.41,
                        },
                        "id": 18,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "18",
                            "INSEE_REG": "24",
                            "POPULATION": 304256,
                            "AREA": 7292.67,
                            "DENSITY": 41.72,
                        },
                        "id": 19,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "07",
                            "INSEE_REG": "84",
                            "POPULATION": 325712,
                            "AREA": 5562.05,
                            "DENSITY": 58.56,
                        },
                        "id": 20,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "02",
                            "INSEE_REG": "32",
                            "POPULATION": 534490,
                            "AREA": 7418.97,
                            "DENSITY": 72.04,
                        },
                        "id": 21,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "64",
                            "INSEE_REG": "75",
                            "POPULATION": 677309,
                            "AREA": 7691.6,
                            "DENSITY": 88.06,
                        },
                        "id": 22,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "41",
                            "INSEE_REG": "24",
                            "POPULATION": 331915,
                            "AREA": 6412.3,
                            "DENSITY": 51.76,
                        },
                        "id": 23,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "57",
                            "INSEE_REG": "44",
                            "POPULATION": 1043522,
                            "AREA": 6252.63,
                            "DENSITY": 166.89,
                        },
                        "id": 24,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "86",
                            "INSEE_REG": "75",
                            "POPULATION": 436876,
                            "AREA": 7025.24,
                            "DENSITY": 62.19,
                        },
                        "id": 25,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "24",
                            "INSEE_REG": "75",
                            "POPULATION": 413606,
                            "AREA": 9209.9,
                            "DENSITY": 44.91,
                        },
                        "id": 26,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "39",
                            "INSEE_REG": "27",
                            "POPULATION": 260188,
                            "AREA": 5040.63,
                            "DENSITY": 51.62,
                        },
                        "id": 27,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "82",
                            "INSEE_REG": "76",
                            "POPULATION": 258349,
                            "AREA": 3731.0,
                            "DENSITY": 69.24,
                        },
                        "id": 28,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "49",
                            "INSEE_REG": "52",
                            "POPULATION": 813493,
                            "AREA": 7161.34,
                            "DENSITY": 113.6,
                        },
                        "id": 29,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "69",
                            "INSEE_REG": "84",
                            "POPULATION": 1843319,
                            "AREA": 3253.11,
                            "DENSITY": 566.63,
                        },
                        "id": 30,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "12",
                            "INSEE_REG": "76",
                            "POPULATION": 279206,
                            "AREA": 8770.69,
                            "DENSITY": 31.83,
                        },
                        "id": 31,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "23",
                            "INSEE_REG": "75",
                            "POPULATION": 118638,
                            "AREA": 5589.16,
                            "DENSITY": 21.23,
                        },
                        "id": 32,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "45",
                            "INSEE_REG": "24",
                            "POPULATION": 678008,
                            "AREA": 6804.01,
                            "DENSITY": 99.65,
                        },
                        "id": 33,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "70",
                            "INSEE_REG": "27",
                            "POPULATION": 236659,
                            "AREA": 5382.37,
                            "DENSITY": 43.97,
                        },
                        "id": 34,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "63",
                            "INSEE_REG": "84",
                            "POPULATION": 653742,
                            "AREA": 8003.1,
                            "DENSITY": 81.69,
                        },
                        "id": 35,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "81",
                            "INSEE_REG": "76",
                            "POPULATION": 387890,
                            "AREA": 5785.79,
                            "DENSITY": 67.04,
                        },
                        "id": 36,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "27",
                            "INSEE_REG": "28",
                            "POPULATION": 601843,
                            "AREA": 6035.85,
                            "DENSITY": 99.71,
                        },
                        "id": 37,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "76",
                            "INSEE_REG": "28",
                            "POPULATION": 1254378,
                            "AREA": 6318.26,
                            "DENSITY": 198.53,
                        },
                        "id": 38,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "52",
                            "INSEE_REG": "44",
                            "POPULATION": 175640,
                            "AREA": 6249.91,
                            "DENSITY": 28.1,
                        },
                        "id": 39,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "30",
                            "INSEE_REG": "76",
                            "POPULATION": 744178,
                            "AREA": 5874.71,
                            "DENSITY": 126.67,
                        },
                        "id": 40,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "67",
                            "INSEE_REG": "44",
                            "POPULATION": 1125559,
                            "AREA": 4796.37,
                            "DENSITY": 234.67,
                        },
                        "id": 41,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "11",
                            "INSEE_REG": "76",
                            "POPULATION": 370260,
                            "AREA": 6351.35,
                            "DENSITY": 58.3,
                        },
                        "id": 42,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "77",
                            "INSEE_REG": "11",
                            "POPULATION": 1403997,
                            "AREA": 5924.64,
                            "DENSITY": 236.98,
                        },
                        "id": 43,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "43",
                            "INSEE_REG": "84",
                            "POPULATION": 227283,
                            "AREA": 4996.58,
                            "DENSITY": 45.49,
                        },
                        "id": 44,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "51",
                            "INSEE_REG": "44",
                            "POPULATION": 568895,
                            "AREA": 8195.78,
                            "DENSITY": 69.41,
                        },
                        "id": 45,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "80",
                            "INSEE_REG": "32",
                            "POPULATION": 572443,
                            "AREA": 6206.58,
                            "DENSITY": 92.23,
                        },
                        "id": 46,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "46",
                            "INSEE_REG": "76",
                            "POPULATION": 173828,
                            "AREA": 5221.64,
                            "DENSITY": 33.29,
                        },
                        "id": 47,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "65",
                            "INSEE_REG": "76",
                            "POPULATION": 228530,
                            "AREA": 4527.89,
                            "DENSITY": 50.47,
                        },
                        "id": 48,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "04",
                            "INSEE_REG": "93",
                            "POPULATION": 163915,
                            "AREA": 6993.79,
                            "DENSITY": 23.44,
                        },
                        "id": 49,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "72",
                            "INSEE_REG": "52",
                            "POPULATION": 566506,
                            "AREA": 6236.75,
                            "DENSITY": 90.83,
                        },
                        "id": 50,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "56",
                            "INSEE_REG": "53",
                            "POPULATION": 750863,
                            "AREA": 6864.07,
                            "DENSITY": 109.39,
                        },
                        "id": 51,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "2A",
                            "INSEE_REG": "94",
                            "POPULATION": 157249,
                            "AREA": 4028.53,
                            "DENSITY": 39.03,
                        },
                        "id": 52,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "28",
                            "INSEE_REG": "24",
                            "POPULATION": 433233,
                            "AREA": 5927.23,
                            "DENSITY": 73.09,
                        },
                        "id": 53,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "54",
                            "INSEE_REG": "44",
                            "POPULATION": 733481,
                            "AREA": 5283.29,
                            "DENSITY": 138.83,
                        },
                        "id": 54,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "01",
                            "INSEE_REG": "84",
                            "POPULATION": 643350,
                            "AREA": 5773.77,
                            "DENSITY": 111.43,
                        },
                        "id": 55,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "19",
                            "INSEE_REG": "75",
                            "POPULATION": 241464,
                            "AREA": 5888.93,
                            "DENSITY": 41.0,
                        },
                        "id": 56,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "09",
                            "INSEE_REG": "76",
                            "POPULATION": 153153,
                            "AREA": 4921.75,
                            "DENSITY": 31.12,
                        },
                        "id": 57,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "68",
                            "INSEE_REG": "44",
                            "POPULATION": 764030,
                            "AREA": 3526.37,
                            "DENSITY": 216.66,
                        },
                        "id": 58,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "59",
                            "INSEE_REG": "32",
                            "POPULATION": 2604361,
                            "AREA": 5774.99,
                            "DENSITY": 450.97,
                        },
                        "id": 59,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "90",
                            "INSEE_REG": "27",
                            "POPULATION": 142622,
                            "AREA": 609.64,
                            "DENSITY": 233.94,
                        },
                        "id": 60,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "44",
                            "INSEE_REG": "52",
                            "POPULATION": 1394909,
                            "AREA": 6992.78,
                            "DENSITY": 199.48,
                        },
                        "id": 61,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "89",
                            "INSEE_REG": "27",
                            "POPULATION": 338291,
                            "AREA": 7450.97,
                            "DENSITY": 45.4,
                        },
                        "id": 62,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "35",
                            "INSEE_REG": "53",
                            "POPULATION": 1060199,
                            "AREA": 6830.2,
                            "DENSITY": 155.22,
                        },
                        "id": 63,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "40",
                            "INSEE_REG": "75",
                            "POPULATION": 407444,
                            "AREA": 9353.03,
                            "DENSITY": 43.56,
                        },
                        "id": 64,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "29",
                            "INSEE_REG": "53",
                            "POPULATION": 909028,
                            "AREA": 6756.76,
                            "DENSITY": 134.54,
                        },
                        "id": 65,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "74",
                            "INSEE_REG": "84",
                            "POPULATION": 807360,
                            "AREA": 4596.53,
                            "DENSITY": 175.65,
                        },
                        "id": 66,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "60",
                            "INSEE_REG": "32",
                            "POPULATION": 824503,
                            "AREA": 5893.6,
                            "DENSITY": 139.9,
                        },
                        "id": 67,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "95",
                            "INSEE_REG": "11",
                            "POPULATION": 1228618,
                            "AREA": 1254.18,
                            "DENSITY": 979.62,
                        },
                        "id": 68,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "58",
                            "INSEE_REG": "27",
                            "POPULATION": 207182,
                            "AREA": 6862.87,
                            "DENSITY": 30.19,
                        },
                        "id": 69,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "61",
                            "INSEE_REG": "28",
                            "POPULATION": 283372,
                            "AREA": 6142.73,
                            "DENSITY": 46.13,
                        },
                        "id": 70,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "91",
                            "INSEE_REG": "11",
                            "POPULATION": 1296130,
                            "AREA": 1818.35,
                            "DENSITY": 712.81,
                        },
                        "id": 71,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "21",
                            "INSEE_REG": "27",
                            "POPULATION": 532871,
                            "AREA": 8787.51,
                            "DENSITY": 60.64,
                        },
                        "id": 72,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "22",
                            "INSEE_REG": "53",
                            "POPULATION": 598814,
                            "AREA": 6963.26,
                            "DENSITY": 86.0,
                        },
                        "id": 73,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "03",
                            "INSEE_REG": "84",
                            "POPULATION": 337988,
                            "AREA": 7365.26,
                            "DENSITY": 45.89,
                        },
                        "id": 74,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "17",
                            "INSEE_REG": "75",
                            "POPULATION": 644303,
                            "AREA": 6913.03,
                            "DENSITY": 93.2,
                        },
                        "id": 75,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "15",
                            "INSEE_REG": "84",
                            "POPULATION": 145143,
                            "AREA": 5767.47,
                            "DENSITY": 25.17,
                        },
                        "id": 76,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "34",
                            "INSEE_REG": "76",
                            "POPULATION": 1144892,
                            "AREA": 6231.05,
                            "DENSITY": 183.74,
                        },
                        "id": 77,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "26",
                            "INSEE_REG": "84",
                            "POPULATION": 511553,
                            "AREA": 6553.53,
                            "DENSITY": 78.06,
                        },
                        "id": 78,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "66",
                            "INSEE_REG": "76",
                            "POPULATION": 474452,
                            "AREA": 4147.76,
                            "DENSITY": 114.39,
                        },
                        "id": 79,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "73",
                            "INSEE_REG": "84",
                            "POPULATION": 431174,
                            "AREA": 6260.4,
                            "DENSITY": 68.87,
                        },
                        "id": 80,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "37",
                            "INSEE_REG": "24",
                            "POPULATION": 606511,
                            "AREA": 6147.6,
                            "DENSITY": 98.66,
                        },
                        "id": 81,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "05",
                            "INSEE_REG": "93",
                            "POPULATION": 141284,
                            "AREA": 5685.31,
                            "DENSITY": 24.85,
                        },
                        "id": 82,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "79",
                            "INSEE_REG": "75",
                            "POPULATION": 374351,
                            "AREA": 6029.06,
                            "DENSITY": 62.09,
                        },
                        "id": 83,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "84",
                            "INSEE_REG": "93",
                            "POPULATION": 559479,
                            "AREA": 3577.19,
                            "DENSITY": 156.4,
                        },
                        "id": 84,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "36",
                            "INSEE_REG": "24",
                            "POPULATION": 222232,
                            "AREA": 6887.38,
                            "DENSITY": 32.27,
                        },
                        "id": 85,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "2B",
                            "INSEE_REG": "94",
                            "POPULATION": 177689,
                            "AREA": 4719.71,
                            "DENSITY": 37.65,
                        },
                        "id": 86,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "87",
                            "INSEE_REG": "75",
                            "POPULATION": 374426,
                            "AREA": 5549.31,
                            "DENSITY": 67.47,
                        },
                        "id": 87,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "85",
                            "INSEE_REG": "52",
                            "POPULATION": 675247,
                            "AREA": 6758.23,
                            "DENSITY": 99.91,
                        },
                        "id": 88,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "83",
                            "INSEE_REG": "93",
                            "POPULATION": 1058740,
                            "AREA": 6002.84,
                            "DENSITY": 176.37,
                        },
                        "id": 89,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "94",
                            "INSEE_REG": "11",
                            "POPULATION": 1387926,
                            "AREA": 244.7,
                            "DENSITY": 5671.95,
                        },
                        "id": 90,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "92",
                            "INSEE_REG": "11",
                            "POPULATION": 1609306,
                            "AREA": 175.63,
                            "DENSITY": 9163.05,
                        },
                        "id": 91,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "48",
                            "INSEE_REG": "76",
                            "POPULATION": 76601,
                            "AREA": 5172.02,
                            "DENSITY": 14.81,
                        },
                        "id": 92,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "13",
                            "INSEE_REG": "93",
                            "POPULATION": 2024162,
                            "AREA": 5082.57,
                            "DENSITY": 398.26,
                        },
                        "id": 93,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "93",
                            "INSEE_REG": "11",
                            "POPULATION": 1623111,
                            "AREA": 236.96,
                            "DENSITY": 6849.73,
                        },
                        "id": 94,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "75",
                            "INSEE_REG": "11",
                            "POPULATION": 2187526,
                            "AREA": 105.44,
                            "DENSITY": 20746.64,
                        },
                        "id": 95,
                    },
                ],
            },
            "dept_population",
        ),
    },
    4: {
        "path": data_only_path,
        "return_value": (
            {
                "type": "FeatureCollection",
                "name": "dept_population",
                "features": [
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "32",
                            "INSEE_REG": "76",
                            "POPULATION": 191091,
                            "AREA": 6304.33,
                            "DENSITY": 30.31,
                        },
                        "id": 0,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "47",
                            "INSEE_REG": "75",
                            "POPULATION": 332842,
                            "AREA": 5382.87,
                            "DENSITY": 61.83,
                        },
                        "id": 1,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "38",
                            "INSEE_REG": "84",
                            "POPULATION": 1258722,
                            "AREA": 7868.79,
                            "DENSITY": 159.96,
                        },
                        "id": 2,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "62",
                            "INSEE_REG": "32",
                            "POPULATION": 1468018,
                            "AREA": 6714.14,
                            "DENSITY": 218.65,
                        },
                        "id": 3,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "08",
                            "INSEE_REG": "44",
                            "POPULATION": 273579,
                            "AREA": 5253.13,
                            "DENSITY": 52.08,
                        },
                        "id": 4,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "10",
                            "INSEE_REG": "44",
                            "POPULATION": 310020,
                            "AREA": 6021.83,
                            "DENSITY": 51.48,
                        },
                        "id": 5,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "42",
                            "INSEE_REG": "84",
                            "POPULATION": 762941,
                            "AREA": 4795.85,
                            "DENSITY": 159.08,
                        },
                        "id": 6,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "06",
                            "INSEE_REG": "93",
                            "POPULATION": 1083310,
                            "AREA": 4291.62,
                            "DENSITY": 252.42,
                        },
                        "id": 7,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "31",
                            "INSEE_REG": "76",
                            "POPULATION": 1362672,
                            "AREA": 6364.82,
                            "DENSITY": 214.09,
                        },
                        "id": 8,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "71",
                            "INSEE_REG": "27",
                            "POPULATION": 553595,
                            "AREA": 8598.33,
                            "DENSITY": 64.38,
                        },
                        "id": 9,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "53",
                            "INSEE_REG": "52",
                            "POPULATION": 307445,
                            "AREA": 5208.37,
                            "DENSITY": 59.03,
                        },
                        "id": 10,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "78",
                            "INSEE_REG": "11",
                            "POPULATION": 1438266,
                            "AREA": 2305.64,
                            "DENSITY": 623.8,
                        },
                        "id": 11,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "50",
                            "INSEE_REG": "28",
                            "POPULATION": 496883,
                            "AREA": 6015.07,
                            "DENSITY": 82.61,
                        },
                        "id": 12,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "16",
                            "INSEE_REG": "75",
                            "POPULATION": 352335,
                            "AREA": 5963.54,
                            "DENSITY": 59.08,
                        },
                        "id": 13,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "25",
                            "INSEE_REG": "27",
                            "POPULATION": 539067,
                            "AREA": 5248.31,
                            "DENSITY": 102.71,
                        },
                        "id": 14,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "55",
                            "INSEE_REG": "44",
                            "POPULATION": 187187,
                            "AREA": 6233.18,
                            "DENSITY": 30.03,
                        },
                        "id": 15,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "33",
                            "INSEE_REG": "75",
                            "POPULATION": 1583384,
                            "AREA": 10068.74,
                            "DENSITY": 157.26,
                        },
                        "id": 16,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "14",
                            "INSEE_REG": "28",
                            "POPULATION": 694002,
                            "AREA": 5588.48,
                            "DENSITY": 124.18,
                        },
                        "id": 17,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "88",
                            "INSEE_REG": "44",
                            "POPULATION": 367673,
                            "AREA": 5891.56,
                            "DENSITY": 62.41,
                        },
                        "id": 18,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "18",
                            "INSEE_REG": "24",
                            "POPULATION": 304256,
                            "AREA": 7292.67,
                            "DENSITY": 41.72,
                        },
                        "id": 19,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "07",
                            "INSEE_REG": "84",
                            "POPULATION": 325712,
                            "AREA": 5562.05,
                            "DENSITY": 58.56,
                        },
                        "id": 20,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "02",
                            "INSEE_REG": "32",
                            "POPULATION": 534490,
                            "AREA": 7418.97,
                            "DENSITY": 72.04,
                        },
                        "id": 21,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "64",
                            "INSEE_REG": "75",
                            "POPULATION": 677309,
                            "AREA": 7691.6,
                            "DENSITY": 88.06,
                        },
                        "id": 22,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "41",
                            "INSEE_REG": "24",
                            "POPULATION": 331915,
                            "AREA": 6412.3,
                            "DENSITY": 51.76,
                        },
                        "id": 23,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "57",
                            "INSEE_REG": "44",
                            "POPULATION": 1043522,
                            "AREA": 6252.63,
                            "DENSITY": 166.89,
                        },
                        "id": 24,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "86",
                            "INSEE_REG": "75",
                            "POPULATION": 436876,
                            "AREA": 7025.24,
                            "DENSITY": 62.19,
                        },
                        "id": 25,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "24",
                            "INSEE_REG": "75",
                            "POPULATION": 413606,
                            "AREA": 9209.9,
                            "DENSITY": 44.91,
                        },
                        "id": 26,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "39",
                            "INSEE_REG": "27",
                            "POPULATION": 260188,
                            "AREA": 5040.63,
                            "DENSITY": 51.62,
                        },
                        "id": 27,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "82",
                            "INSEE_REG": "76",
                            "POPULATION": 258349,
                            "AREA": 3731.0,
                            "DENSITY": 69.24,
                        },
                        "id": 28,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "49",
                            "INSEE_REG": "52",
                            "POPULATION": 813493,
                            "AREA": 7161.34,
                            "DENSITY": 113.6,
                        },
                        "id": 29,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "69",
                            "INSEE_REG": "84",
                            "POPULATION": 1843319,
                            "AREA": 3253.11,
                            "DENSITY": 566.63,
                        },
                        "id": 30,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "12",
                            "INSEE_REG": "76",
                            "POPULATION": 279206,
                            "AREA": 8770.69,
                            "DENSITY": 31.83,
                        },
                        "id": 31,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "23",
                            "INSEE_REG": "75",
                            "POPULATION": 118638,
                            "AREA": 5589.16,
                            "DENSITY": 21.23,
                        },
                        "id": 32,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "45",
                            "INSEE_REG": "24",
                            "POPULATION": 678008,
                            "AREA": 6804.01,
                            "DENSITY": 99.65,
                        },
                        "id": 33,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "70",
                            "INSEE_REG": "27",
                            "POPULATION": 236659,
                            "AREA": 5382.37,
                            "DENSITY": 43.97,
                        },
                        "id": 34,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "63",
                            "INSEE_REG": "84",
                            "POPULATION": 653742,
                            "AREA": 8003.1,
                            "DENSITY": 81.69,
                        },
                        "id": 35,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "81",
                            "INSEE_REG": "76",
                            "POPULATION": 387890,
                            "AREA": 5785.79,
                            "DENSITY": 67.04,
                        },
                        "id": 36,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "27",
                            "INSEE_REG": "28",
                            "POPULATION": 601843,
                            "AREA": 6035.85,
                            "DENSITY": 99.71,
                        },
                        "id": 37,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "76",
                            "INSEE_REG": "28",
                            "POPULATION": 1254378,
                            "AREA": 6318.26,
                            "DENSITY": 198.53,
                        },
                        "id": 38,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "52",
                            "INSEE_REG": "44",
                            "POPULATION": 175640,
                            "AREA": 6249.91,
                            "DENSITY": 28.1,
                        },
                        "id": 39,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "30",
                            "INSEE_REG": "76",
                            "POPULATION": 744178,
                            "AREA": 5874.71,
                            "DENSITY": 126.67,
                        },
                        "id": 40,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "67",
                            "INSEE_REG": "44",
                            "POPULATION": 1125559,
                            "AREA": 4796.37,
                            "DENSITY": 234.67,
                        },
                        "id": 41,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "11",
                            "INSEE_REG": "76",
                            "POPULATION": 370260,
                            "AREA": 6351.35,
                            "DENSITY": 58.3,
                        },
                        "id": 42,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "77",
                            "INSEE_REG": "11",
                            "POPULATION": 1403997,
                            "AREA": 5924.64,
                            "DENSITY": 236.98,
                        },
                        "id": 43,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "43",
                            "INSEE_REG": "84",
                            "POPULATION": 227283,
                            "AREA": 4996.58,
                            "DENSITY": 45.49,
                        },
                        "id": 44,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "51",
                            "INSEE_REG": "44",
                            "POPULATION": 568895,
                            "AREA": 8195.78,
                            "DENSITY": 69.41,
                        },
                        "id": 45,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "80",
                            "INSEE_REG": "32",
                            "POPULATION": 572443,
                            "AREA": 6206.58,
                            "DENSITY": 92.23,
                        },
                        "id": 46,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "46",
                            "INSEE_REG": "76",
                            "POPULATION": 173828,
                            "AREA": 5221.64,
                            "DENSITY": 33.29,
                        },
                        "id": 47,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "65",
                            "INSEE_REG": "76",
                            "POPULATION": 228530,
                            "AREA": 4527.89,
                            "DENSITY": 50.47,
                        },
                        "id": 48,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "04",
                            "INSEE_REG": "93",
                            "POPULATION": 163915,
                            "AREA": 6993.79,
                            "DENSITY": 23.44,
                        },
                        "id": 49,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "72",
                            "INSEE_REG": "52",
                            "POPULATION": 566506,
                            "AREA": 6236.75,
                            "DENSITY": 90.83,
                        },
                        "id": 50,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "56",
                            "INSEE_REG": "53",
                            "POPULATION": 750863,
                            "AREA": 6864.07,
                            "DENSITY": 109.39,
                        },
                        "id": 51,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "2A",
                            "INSEE_REG": "94",
                            "POPULATION": 157249,
                            "AREA": 4028.53,
                            "DENSITY": 39.03,
                        },
                        "id": 52,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "28",
                            "INSEE_REG": "24",
                            "POPULATION": 433233,
                            "AREA": 5927.23,
                            "DENSITY": 73.09,
                        },
                        "id": 53,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "54",
                            "INSEE_REG": "44",
                            "POPULATION": 733481,
                            "AREA": 5283.29,
                            "DENSITY": 138.83,
                        },
                        "id": 54,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "01",
                            "INSEE_REG": "84",
                            "POPULATION": 643350,
                            "AREA": 5773.77,
                            "DENSITY": 111.43,
                        },
                        "id": 55,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "19",
                            "INSEE_REG": "75",
                            "POPULATION": 241464,
                            "AREA": 5888.93,
                            "DENSITY": 41.0,
                        },
                        "id": 56,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "09",
                            "INSEE_REG": "76",
                            "POPULATION": 153153,
                            "AREA": 4921.75,
                            "DENSITY": 31.12,
                        },
                        "id": 57,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "68",
                            "INSEE_REG": "44",
                            "POPULATION": 764030,
                            "AREA": 3526.37,
                            "DENSITY": 216.66,
                        },
                        "id": 58,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "59",
                            "INSEE_REG": "32",
                            "POPULATION": 2604361,
                            "AREA": 5774.99,
                            "DENSITY": 450.97,
                        },
                        "id": 59,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "90",
                            "INSEE_REG": "27",
                            "POPULATION": 142622,
                            "AREA": 609.64,
                            "DENSITY": 233.94,
                        },
                        "id": 60,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "44",
                            "INSEE_REG": "52",
                            "POPULATION": 1394909,
                            "AREA": 6992.78,
                            "DENSITY": 199.48,
                        },
                        "id": 61,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "89",
                            "INSEE_REG": "27",
                            "POPULATION": 338291,
                            "AREA": 7450.97,
                            "DENSITY": 45.4,
                        },
                        "id": 62,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "35",
                            "INSEE_REG": "53",
                            "POPULATION": 1060199,
                            "AREA": 6830.2,
                            "DENSITY": 155.22,
                        },
                        "id": 63,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "40",
                            "INSEE_REG": "75",
                            "POPULATION": 407444,
                            "AREA": 9353.03,
                            "DENSITY": 43.56,
                        },
                        "id": 64,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "29",
                            "INSEE_REG": "53",
                            "POPULATION": 909028,
                            "AREA": 6756.76,
                            "DENSITY": 134.54,
                        },
                        "id": 65,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "74",
                            "INSEE_REG": "84",
                            "POPULATION": 807360,
                            "AREA": 4596.53,
                            "DENSITY": 175.65,
                        },
                        "id": 66,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "60",
                            "INSEE_REG": "32",
                            "POPULATION": 824503,
                            "AREA": 5893.6,
                            "DENSITY": 139.9,
                        },
                        "id": 67,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "95",
                            "INSEE_REG": "11",
                            "POPULATION": 1228618,
                            "AREA": 1254.18,
                            "DENSITY": 979.62,
                        },
                        "id": 68,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "58",
                            "INSEE_REG": "27",
                            "POPULATION": 207182,
                            "AREA": 6862.87,
                            "DENSITY": 30.19,
                        },
                        "id": 69,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "61",
                            "INSEE_REG": "28",
                            "POPULATION": 283372,
                            "AREA": 6142.73,
                            "DENSITY": 46.13,
                        },
                        "id": 70,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "91",
                            "INSEE_REG": "11",
                            "POPULATION": 1296130,
                            "AREA": 1818.35,
                            "DENSITY": 712.81,
                        },
                        "id": 71,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "21",
                            "INSEE_REG": "27",
                            "POPULATION": 532871,
                            "AREA": 8787.51,
                            "DENSITY": 60.64,
                        },
                        "id": 72,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "22",
                            "INSEE_REG": "53",
                            "POPULATION": 598814,
                            "AREA": 6963.26,
                            "DENSITY": 86.0,
                        },
                        "id": 73,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "03",
                            "INSEE_REG": "84",
                            "POPULATION": 337988,
                            "AREA": 7365.26,
                            "DENSITY": 45.89,
                        },
                        "id": 74,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "17",
                            "INSEE_REG": "75",
                            "POPULATION": 644303,
                            "AREA": 6913.03,
                            "DENSITY": 93.2,
                        },
                        "id": 75,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "15",
                            "INSEE_REG": "84",
                            "POPULATION": 145143,
                            "AREA": 5767.47,
                            "DENSITY": 25.17,
                        },
                        "id": 76,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "34",
                            "INSEE_REG": "76",
                            "POPULATION": 1144892,
                            "AREA": 6231.05,
                            "DENSITY": 183.74,
                        },
                        "id": 77,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "26",
                            "INSEE_REG": "84",
                            "POPULATION": 511553,
                            "AREA": 6553.53,
                            "DENSITY": 78.06,
                        },
                        "id": 78,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "66",
                            "INSEE_REG": "76",
                            "POPULATION": 474452,
                            "AREA": 4147.76,
                            "DENSITY": 114.39,
                        },
                        "id": 79,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "73",
                            "INSEE_REG": "84",
                            "POPULATION": 431174,
                            "AREA": 6260.4,
                            "DENSITY": 68.87,
                        },
                        "id": 80,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "37",
                            "INSEE_REG": "24",
                            "POPULATION": 606511,
                            "AREA": 6147.6,
                            "DENSITY": 98.66,
                        },
                        "id": 81,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "05",
                            "INSEE_REG": "93",
                            "POPULATION": 141284,
                            "AREA": 5685.31,
                            "DENSITY": 24.85,
                        },
                        "id": 82,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "79",
                            "INSEE_REG": "75",
                            "POPULATION": 374351,
                            "AREA": 6029.06,
                            "DENSITY": 62.09,
                        },
                        "id": 83,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "84",
                            "INSEE_REG": "93",
                            "POPULATION": 559479,
                            "AREA": 3577.19,
                            "DENSITY": 156.4,
                        },
                        "id": 84,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "36",
                            "INSEE_REG": "24",
                            "POPULATION": 222232,
                            "AREA": 6887.38,
                            "DENSITY": 32.27,
                        },
                        "id": 85,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "2B",
                            "INSEE_REG": "94",
                            "POPULATION": 177689,
                            "AREA": 4719.71,
                            "DENSITY": 37.65,
                        },
                        "id": 86,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "87",
                            "INSEE_REG": "75",
                            "POPULATION": 374426,
                            "AREA": 5549.31,
                            "DENSITY": 67.47,
                        },
                        "id": 87,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "85",
                            "INSEE_REG": "52",
                            "POPULATION": 675247,
                            "AREA": 6758.23,
                            "DENSITY": 99.91,
                        },
                        "id": 88,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "83",
                            "INSEE_REG": "93",
                            "POPULATION": 1058740,
                            "AREA": 6002.84,
                            "DENSITY": 176.37,
                        },
                        "id": 89,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "94",
                            "INSEE_REG": "11",
                            "POPULATION": 1387926,
                            "AREA": 244.7,
                            "DENSITY": 5671.95,
                        },
                        "id": 90,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "92",
                            "INSEE_REG": "11",
                            "POPULATION": 1609306,
                            "AREA": 175.63,
                            "DENSITY": 9163.05,
                        },
                        "id": 91,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "48",
                            "INSEE_REG": "76",
                            "POPULATION": 76601,
                            "AREA": 5172.02,
                            "DENSITY": 14.81,
                        },
                        "id": 92,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "13",
                            "INSEE_REG": "93",
                            "POPULATION": 2024162,
                            "AREA": 5082.57,
                            "DENSITY": 398.26,
                        },
                        "id": 93,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "93",
                            "INSEE_REG": "11",
                            "POPULATION": 1623111,
                            "AREA": 236.96,
                            "DENSITY": 6849.73,
                        },
                        "id": 94,
                    },
                    {
                        "type": "Feature",
                        "geometry": {},
                        "properties": {
                            "CODE_DEPT": "75",
                            "INSEE_REG": "11",
                            "POPULATION": 2187526,
                            "AREA": 105.44,
                            "DENSITY": 20746.64,
                        },
                        "id": 95,
                    },
                ],
            },
            "dept_population",
        ),
    },
}

from_geojson_get_features_list_parameters = {
    0: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "all_geometry_type_only",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": [-115.81, 37.24]},
                    "properties": {},
                    "id": 0,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": []},
                    "properties": {},
                    "id": 1,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "LineString",
                        "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    },
                    "properties": {},
                    "id": 2,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "LineString", "coordinates": []},
                    "properties": {},
                    "id": 3,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [2.38, 57.322],
                                [23.194, -20.28],
                                [-120.43, 19.15],
                                [2.38, 57.322],
                            ],
                            [
                                [-5.21, 23.51],
                                [15.21, -10.81],
                                [-20.51, 1.51],
                                [-5.21, 23.51],
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 4,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Polygon", "coordinates": []},
                    "properties": {},
                    "id": 5,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPoint",
                        "coordinates": [
                            [-155.52, 19.61],
                            [-156.22, 20.74],
                            [-157.97, 21.46],
                        ],
                    },
                    "properties": {},
                    "id": 6,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPoint", "coordinates": []},
                    "properties": {},
                    "id": 7,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiLineString",
                        "coordinates": [
                            [[3.75, 9.25], [-130.95, 1.52]],
                            [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                        ],
                    },
                    "properties": {},
                    "id": 8,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiLineString", "coordinates": []},
                    "properties": {},
                    "id": 9,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [3.78, 9.28],
                                    [-130.91, 1.52],
                                    [35.12, 72.234],
                                    [3.78, 9.28],
                                ]
                            ],
                            [
                                [
                                    [23.18, -34.29],
                                    [-1.31, -4.61],
                                    [3.41, 77.91],
                                    [23.18, -34.29],
                                ]
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 10,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPolygon", "coordinates": []},
                    "properties": {},
                    "id": 11,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": [-115.81, 37.24]},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {
                                "type": "MultiPoint",
                                "coordinates": [
                                    [-155.52, 19.61],
                                    [-156.22, 20.74],
                                    [-157.97, 21.46],
                                ],
                            },
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {
                                "type": "MultiPolygon",
                                "coordinates": [
                                    [
                                        [
                                            [3.78, 9.28],
                                            [-130.91, 1.52],
                                            [35.12, 72.234],
                                            [3.78, 9.28],
                                        ]
                                    ],
                                    [
                                        [
                                            [23.18, -34.29],
                                            [-1.31, -4.61],
                                            [3.41, 77.91],
                                            [23.18, -34.29],
                                        ]
                                    ],
                                ],
                            },
                        ],
                    },
                    "properties": {},
                    "id": 12,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "GeometryCollection", "geometries": []},
                    "properties": {},
                    "id": 13,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": []},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {"type": "MultiPoint", "coordinates": []},
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {"type": "MultiPolygon", "coordinates": []},
                        ],
                    },
                    "properties": {},
                    "id": 14,
                },
            ],
            "crs": {
                "type": "name",
                "properties": {"name": "urn:ogc:def:crs:EPSG::4326"},
            },
        },
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_filter": None,
        "serialize": False,
        "bbox_extent": False,
        "feature_limit": False,
        "feature_offset": False,
        "return_value": [
            {"geometry": {"type": "Point", "coordinates": [-115.81, 37.24]}},
            {"geometry": {"type": "Point", "coordinates": []}},
            {
                "geometry": {
                    "type": "LineString",
                    "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                }
            },
            {"geometry": {"type": "LineString", "coordinates": []}},
            {
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [2.38, 57.322],
                            [23.194, -20.28],
                            [-120.43, 19.15],
                            [2.38, 57.322],
                        ],
                        [
                            [-5.21, 23.51],
                            [15.21, -10.81],
                            [-20.51, 1.51],
                            [-5.21, 23.51],
                        ],
                    ],
                }
            },
            {"geometry": {"type": "Polygon", "coordinates": []}},
            {
                "geometry": {
                    "type": "MultiPoint",
                    "coordinates": [
                        [-155.52, 19.61],
                        [-156.22, 20.74],
                        [-157.97, 21.46],
                    ],
                }
            },
            {"geometry": {"type": "MultiPoint", "coordinates": []}},
            {
                "geometry": {
                    "type": "MultiLineString",
                    "coordinates": [
                        [[3.75, 9.25], [-130.95, 1.52]],
                        [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                    ],
                }
            },
            {"geometry": {"type": "MultiLineString", "coordinates": []}},
            {
                "geometry": {
                    "type": "MultiPolygon",
                    "coordinates": [
                        [
                            [
                                [3.78, 9.28],
                                [-130.91, 1.52],
                                [35.12, 72.234],
                                [3.78, 9.28],
                            ]
                        ],
                        [
                            [
                                [23.18, -34.29],
                                [-1.31, -4.61],
                                [3.41, 77.91],
                                [23.18, -34.29],
                            ]
                        ],
                    ],
                }
            },
            {"geometry": {"type": "MultiPolygon", "coordinates": []}},
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {"type": "Point", "coordinates": [-115.81, 37.24]},
                        {
                            "type": "LineString",
                            "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                        },
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                        },
                        {
                            "type": "MultiPoint",
                            "coordinates": [
                                [-155.52, 19.61],
                                [-156.22, 20.74],
                                [-157.97, 21.46],
                            ],
                        },
                        {
                            "type": "MultiLineString",
                            "coordinates": [
                                [[3.75, 9.25], [-130.95, 1.52]],
                                [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                            ],
                        },
                        {
                            "type": "MultiPolygon",
                            "coordinates": [
                                [
                                    [
                                        [3.78, 9.28],
                                        [-130.91, 1.52],
                                        [35.12, 72.234],
                                        [3.78, 9.28],
                                    ]
                                ],
                                [
                                    [
                                        [23.18, -34.29],
                                        [-1.31, -4.61],
                                        [3.41, 77.91],
                                        [23.18, -34.29],
                                    ]
                                ],
                            ],
                        },
                    ],
                }
            },
            {"geometry": {"type": "GeometryCollection", "geometries": []}},
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {"type": "Point", "coordinates": []},
                        {
                            "type": "LineString",
                            "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                        },
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                        },
                        {"type": "MultiPoint", "coordinates": []},
                        {
                            "type": "MultiLineString",
                            "coordinates": [
                                [[3.75, 9.25], [-130.95, 1.52]],
                                [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                            ],
                        },
                        {"type": "MultiPolygon", "coordinates": []},
                    ],
                }
            },
        ],
    },
    1: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "all_geometry_type_only",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": [-115.81, 37.24]},
                    "properties": {},
                    "id": 0,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": []},
                    "properties": {},
                    "id": 1,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "LineString",
                        "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    },
                    "properties": {},
                    "id": 2,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "LineString", "coordinates": []},
                    "properties": {},
                    "id": 3,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [2.38, 57.322],
                                [23.194, -20.28],
                                [-120.43, 19.15],
                                [2.38, 57.322],
                            ],
                            [
                                [-5.21, 23.51],
                                [15.21, -10.81],
                                [-20.51, 1.51],
                                [-5.21, 23.51],
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 4,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Polygon", "coordinates": []},
                    "properties": {},
                    "id": 5,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPoint",
                        "coordinates": [
                            [-155.52, 19.61],
                            [-156.22, 20.74],
                            [-157.97, 21.46],
                        ],
                    },
                    "properties": {},
                    "id": 6,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPoint", "coordinates": []},
                    "properties": {},
                    "id": 7,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiLineString",
                        "coordinates": [
                            [[3.75, 9.25], [-130.95, 1.52]],
                            [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                        ],
                    },
                    "properties": {},
                    "id": 8,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiLineString", "coordinates": []},
                    "properties": {},
                    "id": 9,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [3.78, 9.28],
                                    [-130.91, 1.52],
                                    [35.12, 72.234],
                                    [3.78, 9.28],
                                ]
                            ],
                            [
                                [
                                    [23.18, -34.29],
                                    [-1.31, -4.61],
                                    [3.41, 77.91],
                                    [23.18, -34.29],
                                ]
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 10,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPolygon", "coordinates": []},
                    "properties": {},
                    "id": 11,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": [-115.81, 37.24]},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {
                                "type": "MultiPoint",
                                "coordinates": [
                                    [-155.52, 19.61],
                                    [-156.22, 20.74],
                                    [-157.97, 21.46],
                                ],
                            },
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {
                                "type": "MultiPolygon",
                                "coordinates": [
                                    [
                                        [
                                            [3.78, 9.28],
                                            [-130.91, 1.52],
                                            [35.12, 72.234],
                                            [3.78, 9.28],
                                        ]
                                    ],
                                    [
                                        [
                                            [23.18, -34.29],
                                            [-1.31, -4.61],
                                            [3.41, 77.91],
                                            [23.18, -34.29],
                                        ]
                                    ],
                                ],
                            },
                        ],
                    },
                    "properties": {},
                    "id": 12,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "GeometryCollection", "geometries": []},
                    "properties": {},
                    "id": 13,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": []},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {"type": "MultiPoint", "coordinates": []},
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {"type": "MultiPolygon", "coordinates": []},
                        ],
                    },
                    "properties": {},
                    "id": 14,
                },
            ],
            "crs": {
                "type": "name",
                "properties": {"name": "urn:ogc:def:crs:EPSG::4326"},
            },
        },
        "field_name_filter": None,
        "geometry_type_filter": "Point",
        "bbox_filter": None,
        "serialize": False,
        "bbox_extent": False,
        "feature_limit": False,
        "feature_offset": False,
        "return_value": [
            {"geometry": {"type": "Point", "coordinates": [-115.81, 37.24]}},
            {"geometry": {"type": "Point", "coordinates": []}},
            {"geometry": {"type": "Point", "coordinates": [-115.81, 37.24]}},
            {"geometry": {"type": "Point", "coordinates": []}},
        ],
    },
    2: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "all_geometry_type_only",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": [-115.81, 37.24]},
                    "properties": {},
                    "id": 0,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": []},
                    "properties": {},
                    "id": 1,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "LineString",
                        "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    },
                    "properties": {},
                    "id": 2,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "LineString", "coordinates": []},
                    "properties": {},
                    "id": 3,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [2.38, 57.322],
                                [23.194, -20.28],
                                [-120.43, 19.15],
                                [2.38, 57.322],
                            ],
                            [
                                [-5.21, 23.51],
                                [15.21, -10.81],
                                [-20.51, 1.51],
                                [-5.21, 23.51],
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 4,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Polygon", "coordinates": []},
                    "properties": {},
                    "id": 5,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPoint",
                        "coordinates": [
                            [-155.52, 19.61],
                            [-156.22, 20.74],
                            [-157.97, 21.46],
                        ],
                    },
                    "properties": {},
                    "id": 6,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPoint", "coordinates": []},
                    "properties": {},
                    "id": 7,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiLineString",
                        "coordinates": [
                            [[3.75, 9.25], [-130.95, 1.52]],
                            [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                        ],
                    },
                    "properties": {},
                    "id": 8,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiLineString", "coordinates": []},
                    "properties": {},
                    "id": 9,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [3.78, 9.28],
                                    [-130.91, 1.52],
                                    [35.12, 72.234],
                                    [3.78, 9.28],
                                ]
                            ],
                            [
                                [
                                    [23.18, -34.29],
                                    [-1.31, -4.61],
                                    [3.41, 77.91],
                                    [23.18, -34.29],
                                ]
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 10,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPolygon", "coordinates": []},
                    "properties": {},
                    "id": 11,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": [-115.81, 37.24]},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {
                                "type": "MultiPoint",
                                "coordinates": [
                                    [-155.52, 19.61],
                                    [-156.22, 20.74],
                                    [-157.97, 21.46],
                                ],
                            },
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {
                                "type": "MultiPolygon",
                                "coordinates": [
                                    [
                                        [
                                            [3.78, 9.28],
                                            [-130.91, 1.52],
                                            [35.12, 72.234],
                                            [3.78, 9.28],
                                        ]
                                    ],
                                    [
                                        [
                                            [23.18, -34.29],
                                            [-1.31, -4.61],
                                            [3.41, 77.91],
                                            [23.18, -34.29],
                                        ]
                                    ],
                                ],
                            },
                        ],
                    },
                    "properties": {},
                    "id": 12,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "GeometryCollection", "geometries": []},
                    "properties": {},
                    "id": 13,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": []},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {"type": "MultiPoint", "coordinates": []},
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {"type": "MultiPolygon", "coordinates": []},
                        ],
                    },
                    "properties": {},
                    "id": 14,
                },
            ],
            "crs": {
                "type": "name",
                "properties": {"name": "urn:ogc:def:crs:EPSG::4326"},
            },
        },
        "field_name_filter": None,
        "geometry_type_filter": "Point",
        "bbox_filter": (-115.81, 37.24, -115.81, 37.24),
        "serialize": False,
        "bbox_extent": False,
        "feature_limit": False,
        "feature_offset": False,
        "return_value": [
            {"geometry": {"type": "Point", "coordinates": [-115.81, 37.24]}},
            {"geometry": {"type": "Point", "coordinates": [-115.81, 37.24]}},
        ],
    },
    3: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "all_geometry_type_only",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": [-115.81, 37.24]},
                    "properties": {},
                    "id": 0,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": []},
                    "properties": {},
                    "id": 1,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "LineString",
                        "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    },
                    "properties": {},
                    "id": 2,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "LineString", "coordinates": []},
                    "properties": {},
                    "id": 3,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [2.38, 57.322],
                                [23.194, -20.28],
                                [-120.43, 19.15],
                                [2.38, 57.322],
                            ],
                            [
                                [-5.21, 23.51],
                                [15.21, -10.81],
                                [-20.51, 1.51],
                                [-5.21, 23.51],
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 4,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Polygon", "coordinates": []},
                    "properties": {},
                    "id": 5,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPoint",
                        "coordinates": [
                            [-155.52, 19.61],
                            [-156.22, 20.74],
                            [-157.97, 21.46],
                        ],
                    },
                    "properties": {},
                    "id": 6,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPoint", "coordinates": []},
                    "properties": {},
                    "id": 7,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiLineString",
                        "coordinates": [
                            [[3.75, 9.25], [-130.95, 1.52]],
                            [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                        ],
                    },
                    "properties": {},
                    "id": 8,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiLineString", "coordinates": []},
                    "properties": {},
                    "id": 9,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [3.78, 9.28],
                                    [-130.91, 1.52],
                                    [35.12, 72.234],
                                    [3.78, 9.28],
                                ]
                            ],
                            [
                                [
                                    [23.18, -34.29],
                                    [-1.31, -4.61],
                                    [3.41, 77.91],
                                    [23.18, -34.29],
                                ]
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 10,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPolygon", "coordinates": []},
                    "properties": {},
                    "id": 11,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": [-115.81, 37.24]},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {
                                "type": "MultiPoint",
                                "coordinates": [
                                    [-155.52, 19.61],
                                    [-156.22, 20.74],
                                    [-157.97, 21.46],
                                ],
                            },
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {
                                "type": "MultiPolygon",
                                "coordinates": [
                                    [
                                        [
                                            [3.78, 9.28],
                                            [-130.91, 1.52],
                                            [35.12, 72.234],
                                            [3.78, 9.28],
                                        ]
                                    ],
                                    [
                                        [
                                            [23.18, -34.29],
                                            [-1.31, -4.61],
                                            [3.41, 77.91],
                                            [23.18, -34.29],
                                        ]
                                    ],
                                ],
                            },
                        ],
                    },
                    "properties": {},
                    "id": 12,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "GeometryCollection", "geometries": []},
                    "properties": {},
                    "id": 13,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": []},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {"type": "MultiPoint", "coordinates": []},
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {"type": "MultiPolygon", "coordinates": []},
                        ],
                    },
                    "properties": {},
                    "id": 14,
                },
            ],
            "crs": {
                "type": "name",
                "properties": {"name": "urn:ogc:def:crs:EPSG::4326"},
            },
        },
        "field_name_filter": None,
        "geometry_type_filter": ("Point", "Polygon"),
        "bbox_filter": (
            (-115.81, 37.24, -115.81, 37.24),
            (23.194, -20.28, 23.194, -20.28),
        ),
        "serialize": False,
        "bbox_extent": False,
        "feature_limit": False,
        "feature_offset": False,
        "return_value": [
            {"geometry": {"type": "Point", "coordinates": [-115.81, 37.24]}},
            {
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [2.38, 57.322],
                            [23.194, -20.28],
                            [-120.43, 19.15],
                            [2.38, 57.322],
                        ],
                        [
                            [-5.21, 23.51],
                            [15.21, -10.81],
                            [-20.51, 1.51],
                            [-5.21, 23.51],
                        ],
                    ],
                }
            },
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {"type": "Point", "coordinates": [-115.81, 37.24]},
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                        },
                    ],
                }
            },
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {"type": "Point", "coordinates": []},
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                        },
                    ],
                }
            },
        ],
    },
    4: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "all_geometry_type_only",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": [-115.81, 37.24]},
                    "properties": {},
                    "id": 0,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": []},
                    "properties": {},
                    "id": 1,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "LineString",
                        "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    },
                    "properties": {},
                    "id": 2,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "LineString", "coordinates": []},
                    "properties": {},
                    "id": 3,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [2.38, 57.322],
                                [23.194, -20.28],
                                [-120.43, 19.15],
                                [2.38, 57.322],
                            ],
                            [
                                [-5.21, 23.51],
                                [15.21, -10.81],
                                [-20.51, 1.51],
                                [-5.21, 23.51],
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 4,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Polygon", "coordinates": []},
                    "properties": {},
                    "id": 5,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPoint",
                        "coordinates": [
                            [-155.52, 19.61],
                            [-156.22, 20.74],
                            [-157.97, 21.46],
                        ],
                    },
                    "properties": {},
                    "id": 6,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPoint", "coordinates": []},
                    "properties": {},
                    "id": 7,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiLineString",
                        "coordinates": [
                            [[3.75, 9.25], [-130.95, 1.52]],
                            [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                        ],
                    },
                    "properties": {},
                    "id": 8,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiLineString", "coordinates": []},
                    "properties": {},
                    "id": 9,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [3.78, 9.28],
                                    [-130.91, 1.52],
                                    [35.12, 72.234],
                                    [3.78, 9.28],
                                ]
                            ],
                            [
                                [
                                    [23.18, -34.29],
                                    [-1.31, -4.61],
                                    [3.41, 77.91],
                                    [23.18, -34.29],
                                ]
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 10,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPolygon", "coordinates": []},
                    "properties": {},
                    "id": 11,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": [-115.81, 37.24]},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {
                                "type": "MultiPoint",
                                "coordinates": [
                                    [-155.52, 19.61],
                                    [-156.22, 20.74],
                                    [-157.97, 21.46],
                                ],
                            },
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {
                                "type": "MultiPolygon",
                                "coordinates": [
                                    [
                                        [
                                            [3.78, 9.28],
                                            [-130.91, 1.52],
                                            [35.12, 72.234],
                                            [3.78, 9.28],
                                        ]
                                    ],
                                    [
                                        [
                                            [23.18, -34.29],
                                            [-1.31, -4.61],
                                            [3.41, 77.91],
                                            [23.18, -34.29],
                                        ]
                                    ],
                                ],
                            },
                        ],
                    },
                    "properties": {},
                    "id": 12,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "GeometryCollection", "geometries": []},
                    "properties": {},
                    "id": 13,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": []},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {"type": "MultiPoint", "coordinates": []},
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {"type": "MultiPolygon", "coordinates": []},
                        ],
                    },
                    "properties": {},
                    "id": 14,
                },
            ],
            "crs": {
                "type": "name",
                "properties": {"name": "urn:ogc:def:crs:EPSG::4326"},
            },
        },
        "field_name_filter": None,
        "geometry_type_filter": ("Point", "Polygon"),
        "bbox_filter": (
            (-115.81, 37.24, -115.81, 37.24),
            (23.194, -20.28, 23.194, -20.28),
        ),
        "serialize": True,
        "bbox_extent": False,
        "feature_limit": False,
        "feature_offset": False,
        "return_value": [
            {
                "geometry": b"\x00\x00\x00\x00\x01\xc0\\\xf3\xd7\n=p\xa4@B\x9e\xb8Q\xeb\x85\x1f"
            },
            {
                "geometry": b"\x00\x00\x00\x00\x03\x00\x00\x00\x02\x00\x00\x00\x04@\x03\n=p\xa3\xd7\n@L\xa97K\xc6\xa7\xf0@71\xa9\xfb\xe7l\x8b\xc04G\xae\x14z\xe1H\xc0^\x1b\x85\x1e\xb8Q\xec@3&fffff@\x03\n=p\xa3\xd7\n@L\xa97K\xc6\xa7\xf0\x00\x00\x00\x04\xc0\x14\xd7\n=p\xa3\xd7@7\x82\x8f\\(\xf5\xc3@.k\x85\x1e\xb8Q\xec\xc0%\x9e\xb8Q\xeb\x85\x1f\xc04\x82\x8f\\(\xf5\xc3?\xf8(\xf5\xc2\x8f\\)\xc0\x14\xd7\n=p\xa3\xd7@7\x82\x8f\\(\xf5\xc3"
            },
            {
                "geometry": b"\x00\x00\x00\x00\x07\x00\x00\x00\x02\x00\x00\x00\x00\x01\xc0\\\xf3\xd7\n=p\xa4@B\x9e\xb8Q\xeb\x85\x1f\x00\x00\x00\x00\x03\x00\x00\x00\x02\x00\x00\x00\x04@\x03\n=p\xa3\xd7\n@L\xa97K\xc6\xa7\xf0@71\xa9\xfb\xe7l\x8b\xc04G\xae\x14z\xe1H\xc0^\x1b\x85\x1e\xb8Q\xec@3&fffff@\x03\n=p\xa3\xd7\n@L\xa97K\xc6\xa7\xf0\x00\x00\x00\x04\xc0\x14\xd7\n=p\xa3\xd7@7\x82\x8f\\(\xf5\xc3@.k\x85\x1e\xb8Q\xec\xc0%\x9e\xb8Q\xeb\x85\x1f\xc04\x82\x8f\\(\xf5\xc3?\xf8(\xf5\xc2\x8f\\)\xc0\x14\xd7\n=p\xa3\xd7@7\x82\x8f\\(\xf5\xc3"
            },
            {
                "geometry": b"\x00\x00\x00\x00\x07\x00\x00\x00\x02\x00\x00\x00\x00\x01\x7f\xf8\x00\x00\x00\x00\x00\x00\x7f\xf8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x02\x00\x00\x00\x04@\x03\n=p\xa3\xd7\n@L\xa97K\xc6\xa7\xf0@71\xa9\xfb\xe7l\x8b\xc04G\xae\x14z\xe1H\xc0^\x1b\x85\x1e\xb8Q\xec@3&fffff@\x03\n=p\xa3\xd7\n@L\xa97K\xc6\xa7\xf0\x00\x00\x00\x04\xc0\x14\xd7\n=p\xa3\xd7@7\x82\x8f\\(\xf5\xc3@.k\x85\x1e\xb8Q\xec\xc0%\x9e\xb8Q\xeb\x85\x1f\xc04\x82\x8f\\(\xf5\xc3?\xf8(\xf5\xc2\x8f\\)\xc0\x14\xd7\n=p\xa3\xd7@7\x82\x8f\\(\xf5\xc3"
            },
        ],
    },
    5: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "all_geometry_type_only",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": [-115.81, 37.24]},
                    "properties": {},
                    "id": 0,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": []},
                    "properties": {},
                    "id": 1,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "LineString",
                        "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    },
                    "properties": {},
                    "id": 2,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "LineString", "coordinates": []},
                    "properties": {},
                    "id": 3,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [2.38, 57.322],
                                [23.194, -20.28],
                                [-120.43, 19.15],
                                [2.38, 57.322],
                            ],
                            [
                                [-5.21, 23.51],
                                [15.21, -10.81],
                                [-20.51, 1.51],
                                [-5.21, 23.51],
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 4,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Polygon", "coordinates": []},
                    "properties": {},
                    "id": 5,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPoint",
                        "coordinates": [
                            [-155.52, 19.61],
                            [-156.22, 20.74],
                            [-157.97, 21.46],
                        ],
                    },
                    "properties": {},
                    "id": 6,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPoint", "coordinates": []},
                    "properties": {},
                    "id": 7,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiLineString",
                        "coordinates": [
                            [[3.75, 9.25], [-130.95, 1.52]],
                            [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                        ],
                    },
                    "properties": {},
                    "id": 8,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiLineString", "coordinates": []},
                    "properties": {},
                    "id": 9,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [3.78, 9.28],
                                    [-130.91, 1.52],
                                    [35.12, 72.234],
                                    [3.78, 9.28],
                                ]
                            ],
                            [
                                [
                                    [23.18, -34.29],
                                    [-1.31, -4.61],
                                    [3.41, 77.91],
                                    [23.18, -34.29],
                                ]
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 10,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPolygon", "coordinates": []},
                    "properties": {},
                    "id": 11,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": [-115.81, 37.24]},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {
                                "type": "MultiPoint",
                                "coordinates": [
                                    [-155.52, 19.61],
                                    [-156.22, 20.74],
                                    [-157.97, 21.46],
                                ],
                            },
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {
                                "type": "MultiPolygon",
                                "coordinates": [
                                    [
                                        [
                                            [3.78, 9.28],
                                            [-130.91, 1.52],
                                            [35.12, 72.234],
                                            [3.78, 9.28],
                                        ]
                                    ],
                                    [
                                        [
                                            [23.18, -34.29],
                                            [-1.31, -4.61],
                                            [3.41, 77.91],
                                            [23.18, -34.29],
                                        ]
                                    ],
                                ],
                            },
                        ],
                    },
                    "properties": {},
                    "id": 12,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "GeometryCollection", "geometries": []},
                    "properties": {},
                    "id": 13,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": []},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {"type": "MultiPoint", "coordinates": []},
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {"type": "MultiPolygon", "coordinates": []},
                        ],
                    },
                    "properties": {},
                    "id": 14,
                },
            ],
            "crs": {
                "type": "name",
                "properties": {"name": "urn:ogc:def:crs:EPSG::4326"},
            },
        },
        "field_name_filter": None,
        "geometry_type_filter": ("Point", "Polygon"),
        "bbox_filter": (
            (-115.81, 37.24, -115.81, 37.24),
            (23.194, -20.28, 23.194, -20.28),
        ),
        "serialize": False,
        "bbox_extent": True,
        "feature_limit": False,
        "feature_offset": False,
        "return_value": [
            {
                "geometry": {
                    "type": "Point",
                    "coordinates": [-115.81, 37.24],
                    "bbox": (-115.81, 37.24, -115.81, 37.24),
                }
            },
            {
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [2.38, 57.322],
                            [23.194, -20.28],
                            [-120.43, 19.15],
                            [2.38, 57.322],
                        ],
                        [
                            [-5.21, 23.51],
                            [15.21, -10.81],
                            [-20.51, 1.51],
                            [-5.21, 23.51],
                        ],
                    ],
                    "bbox": (-120.43, -20.28, 23.194, 57.322),
                }
            },
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {
                            "type": "Point",
                            "coordinates": [-115.81, 37.24],
                            "bbox": (-115.81, 37.24, -115.81, 37.24),
                        },
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                            "bbox": (-120.43, -20.28, 23.194, 57.322),
                        },
                    ],
                    "bbox": (-120.43, -20.28, 23.194, 57.322),
                }
            },
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {"type": "Point", "coordinates": []},
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                            "bbox": (-120.43, -20.28, 23.194, 57.322),
                        },
                    ],
                    "bbox": (-120.43, -20.28, 23.194, 57.322),
                }
            },
        ],
    },
    6: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "all_geometry_type_only",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": [-115.81, 37.24]},
                    "properties": {},
                    "id": 0,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": []},
                    "properties": {},
                    "id": 1,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "LineString",
                        "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    },
                    "properties": {},
                    "id": 2,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "LineString", "coordinates": []},
                    "properties": {},
                    "id": 3,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [2.38, 57.322],
                                [23.194, -20.28],
                                [-120.43, 19.15],
                                [2.38, 57.322],
                            ],
                            [
                                [-5.21, 23.51],
                                [15.21, -10.81],
                                [-20.51, 1.51],
                                [-5.21, 23.51],
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 4,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Polygon", "coordinates": []},
                    "properties": {},
                    "id": 5,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPoint",
                        "coordinates": [
                            [-155.52, 19.61],
                            [-156.22, 20.74],
                            [-157.97, 21.46],
                        ],
                    },
                    "properties": {},
                    "id": 6,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPoint", "coordinates": []},
                    "properties": {},
                    "id": 7,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiLineString",
                        "coordinates": [
                            [[3.75, 9.25], [-130.95, 1.52]],
                            [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                        ],
                    },
                    "properties": {},
                    "id": 8,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiLineString", "coordinates": []},
                    "properties": {},
                    "id": 9,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [3.78, 9.28],
                                    [-130.91, 1.52],
                                    [35.12, 72.234],
                                    [3.78, 9.28],
                                ]
                            ],
                            [
                                [
                                    [23.18, -34.29],
                                    [-1.31, -4.61],
                                    [3.41, 77.91],
                                    [23.18, -34.29],
                                ]
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 10,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPolygon", "coordinates": []},
                    "properties": {},
                    "id": 11,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": [-115.81, 37.24]},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {
                                "type": "MultiPoint",
                                "coordinates": [
                                    [-155.52, 19.61],
                                    [-156.22, 20.74],
                                    [-157.97, 21.46],
                                ],
                            },
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {
                                "type": "MultiPolygon",
                                "coordinates": [
                                    [
                                        [
                                            [3.78, 9.28],
                                            [-130.91, 1.52],
                                            [35.12, 72.234],
                                            [3.78, 9.28],
                                        ]
                                    ],
                                    [
                                        [
                                            [23.18, -34.29],
                                            [-1.31, -4.61],
                                            [3.41, 77.91],
                                            [23.18, -34.29],
                                        ]
                                    ],
                                ],
                            },
                        ],
                    },
                    "properties": {},
                    "id": 12,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "GeometryCollection", "geometries": []},
                    "properties": {},
                    "id": 13,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": []},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {"type": "MultiPoint", "coordinates": []},
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {"type": "MultiPolygon", "coordinates": []},
                        ],
                    },
                    "properties": {},
                    "id": 14,
                },
            ],
            "crs": {
                "type": "name",
                "properties": {"name": "urn:ogc:def:crs:EPSG::4326"},
            },
        },
        "field_name_filter": None,
        "geometry_type_filter": ("Point", "Polygon"),
        "bbox_filter": (
            (-115.81, 37.24, -115.81, 37.24),
            (23.194, -20.28, 23.194, -20.28),
        ),
        "serialize": False,
        "bbox_extent": False,
        "feature_limit": 3,
        "feature_offset": False,
        "return_value": [
            {"geometry": {"type": "Point", "coordinates": [-115.81, 37.24]}},
            {
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [2.38, 57.322],
                            [23.194, -20.28],
                            [-120.43, 19.15],
                            [2.38, 57.322],
                        ],
                        [
                            [-5.21, 23.51],
                            [15.21, -10.81],
                            [-20.51, 1.51],
                            [-5.21, 23.51],
                        ],
                    ],
                }
            },
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {"type": "Point", "coordinates": [-115.81, 37.24]},
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                        },
                    ],
                }
            },
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {"type": "Point", "coordinates": []},
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                        },
                    ],
                }
            },
        ][:3],
    },
    7: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "all_geometry_type_only",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": [-115.81, 37.24]},
                    "properties": {},
                    "id": 0,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Point", "coordinates": []},
                    "properties": {},
                    "id": 1,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "LineString",
                        "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                    },
                    "properties": {},
                    "id": 2,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "LineString", "coordinates": []},
                    "properties": {},
                    "id": 3,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [2.38, 57.322],
                                [23.194, -20.28],
                                [-120.43, 19.15],
                                [2.38, 57.322],
                            ],
                            [
                                [-5.21, 23.51],
                                [15.21, -10.81],
                                [-20.51, 1.51],
                                [-5.21, 23.51],
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 4,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "Polygon", "coordinates": []},
                    "properties": {},
                    "id": 5,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPoint",
                        "coordinates": [
                            [-155.52, 19.61],
                            [-156.22, 20.74],
                            [-157.97, 21.46],
                        ],
                    },
                    "properties": {},
                    "id": 6,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPoint", "coordinates": []},
                    "properties": {},
                    "id": 7,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiLineString",
                        "coordinates": [
                            [[3.75, 9.25], [-130.95, 1.52]],
                            [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                        ],
                    },
                    "properties": {},
                    "id": 8,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiLineString", "coordinates": []},
                    "properties": {},
                    "id": 9,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [3.78, 9.28],
                                    [-130.91, 1.52],
                                    [35.12, 72.234],
                                    [3.78, 9.28],
                                ]
                            ],
                            [
                                [
                                    [23.18, -34.29],
                                    [-1.31, -4.61],
                                    [3.41, 77.91],
                                    [23.18, -34.29],
                                ]
                            ],
                        ],
                    },
                    "properties": {},
                    "id": 10,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "MultiPolygon", "coordinates": []},
                    "properties": {},
                    "id": 11,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": [-115.81, 37.24]},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {
                                "type": "MultiPoint",
                                "coordinates": [
                                    [-155.52, 19.61],
                                    [-156.22, 20.74],
                                    [-157.97, 21.46],
                                ],
                            },
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {
                                "type": "MultiPolygon",
                                "coordinates": [
                                    [
                                        [
                                            [3.78, 9.28],
                                            [-130.91, 1.52],
                                            [35.12, 72.234],
                                            [3.78, 9.28],
                                        ]
                                    ],
                                    [
                                        [
                                            [23.18, -34.29],
                                            [-1.31, -4.61],
                                            [3.41, 77.91],
                                            [23.18, -34.29],
                                        ]
                                    ],
                                ],
                            },
                        ],
                    },
                    "properties": {},
                    "id": 12,
                },
                {
                    "type": "Feature",
                    "geometry": {"type": "GeometryCollection", "geometries": []},
                    "properties": {},
                    "id": 13,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "GeometryCollection",
                        "geometries": [
                            {"type": "Point", "coordinates": []},
                            {
                                "type": "LineString",
                                "coordinates": [[8.919, 44.4074], [8.923, 44.4075]],
                            },
                            {
                                "type": "Polygon",
                                "coordinates": [
                                    [
                                        [2.38, 57.322],
                                        [23.194, -20.28],
                                        [-120.43, 19.15],
                                        [2.38, 57.322],
                                    ],
                                    [
                                        [-5.21, 23.51],
                                        [15.21, -10.81],
                                        [-20.51, 1.51],
                                        [-5.21, 23.51],
                                    ],
                                ],
                            },
                            {"type": "MultiPoint", "coordinates": []},
                            {
                                "type": "MultiLineString",
                                "coordinates": [
                                    [[3.75, 9.25], [-130.95, 1.52]],
                                    [[23.15, -34.25], [-1.35, -4.65], [3.45, 77.95]],
                                ],
                            },
                            {"type": "MultiPolygon", "coordinates": []},
                        ],
                    },
                    "properties": {},
                    "id": 14,
                },
            ],
            "crs": {
                "type": "name",
                "properties": {"name": "urn:ogc:def:crs:EPSG::4326"},
            },
        },
        "field_name_filter": None,
        "geometry_type_filter": ("Point", "Polygon"),
        "bbox_filter": (
            (-115.81, 37.24, -115.81, 37.24),
            (23.194, -20.28, 23.194, -20.28),
        ),
        "serialize": False,
        "bbox_extent": False,
        "feature_limit": 3,
        "feature_offset": 2,
        "return_value": [
            {"geometry": {"type": "Point", "coordinates": [-115.81, 37.24]}},
            {
                "geometry": {
                    "type": "Polygon",
                    "coordinates": [
                        [
                            [2.38, 57.322],
                            [23.194, -20.28],
                            [-120.43, 19.15],
                            [2.38, 57.322],
                        ],
                        [
                            [-5.21, 23.51],
                            [15.21, -10.81],
                            [-20.51, 1.51],
                            [-5.21, 23.51],
                        ],
                    ],
                }
            },
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {"type": "Point", "coordinates": [-115.81, 37.24]},
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                        },
                    ],
                }
            },
            {
                "geometry": {
                    "type": "GeometryCollection",
                    "geometries": [
                        {"type": "Point", "coordinates": []},
                        {
                            "type": "Polygon",
                            "coordinates": [
                                [
                                    [2.38, 57.322],
                                    [23.194, -20.28],
                                    [-120.43, 19.15],
                                    [2.38, 57.322],
                                ],
                                [
                                    [-5.21, 23.51],
                                    [15.21, -10.81],
                                    [-20.51, 1.51],
                                    [-5.21, 23.51],
                                ],
                            ],
                        },
                    ],
                }
            },
        ][1:4],
    },
    8: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "attributes_only",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {},
                    "properties": {
                        "field_integer": 586,
                        "field_integer_list": [5879, 8557],
                        "field_real": 8789.97568,
                        "field_real_list": [89798.3654, 8757.97568],
                        "field_string": "salut",
                        "field_string_list": ["bonjour", "monsieur"],
                        "field_date": "2020-03-31",
                        "field_time": "11:22:10.000999",
                        "field_datetime": "2020-03-31 11:22:10.000999",
                        "field_binary": "00000000040000000200000000010000000000000000000000000000000000000000013ff00000000000003ff0000000000000",
                        "field_boolean": True,
                    },
                    "id": 0,
                }
            ],
        },
        "field_name_filter": ["field_real", "field_binary"],
        "geometry_type_filter": None,
        "bbox_filter": None,
        "serialize": False,
        "bbox_extent": False,
        "feature_limit": None,
        "feature_offset": None,
        "return_value": [
            {
                "attributes": {
                    "field_real": 8789.97568,
                    "field_binary": "00000000040000000200000000010000000000000000000000000000000000000000013ff00000000000003ff0000000000000",
                }
            }
        ],
    },
    9: {
        "geojson_in_dict": {
            "type": "FeatureCollection",
            "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_AND_GEOMETRY",
            "features": [
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [505760.0, 6248691.0],
                                [509767.0, 6249274.0],
                                [514960.0, 6255730.0],
                                [523428.0, 6259977.0],
                                [531230.0, 6258583.0],
                                [536034.0, 6253601.0],
                                [539594.0, 6265818.0],
                                [554723.0, 6278961.0],
                                [550482.0, 6283435.0],
                                [545681.0, 6284750.0],
                                [535303.0, 6300840.0],
                                [531445.0, 6300603.0],
                                [531142.0, 6309545.0],
                                [528381.0, 6316132.0],
                                [520187.0, 6318466.0],
                                [528536.0, 6329188.0],
                                [521740.0, 6328834.0],
                                [519117.0, 6332164.0],
                                [512956.0, 6327891.0],
                                [507637.0, 6333951.0],
                                [502833.0, 6331375.0],
                                [496470.0, 6331745.0],
                                [495008.0, 6328849.0],
                                [483787.0, 6325253.0],
                                [474692.0, 6327970.0],
                                [465465.0, 6324803.0],
                                [465239.0, 6317398.0],
                                [461632.0, 6315722.0],
                                [453303.0, 6321029.0],
                                [444807.0, 6320573.0],
                                [440195.0, 6315550.0],
                                [443572.0, 6313646.0],
                                [442698.0, 6298315.0],
                                [439499.0, 6295895.0],
                                [438084.0, 6281592.0],
                                [443497.0, 6282643.0],
                                [449863.0, 6280833.0],
                                [456497.0, 6283051.0],
                                [457450.0, 6278664.0],
                                [461941.0, 6273297.0],
                                [466465.0, 6272970.0],
                                [468215.0, 6263513.0],
                                [471536.0, 6256527.0],
                                [479309.0, 6257879.0],
                                [496988.0, 6250664.0],
                                [505760.0, 6248691.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"},
                    "id": 0,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [547193.0, 6388334.0],
                                [539761.0, 6395885.0],
                                [530971.0, 6390971.0],
                                [526858.0, 6394383.0],
                                [527849.0, 6401566.0],
                                [514373.0, 6400391.0],
                                [512334.0, 6403639.0],
                                [495031.0, 6397493.0],
                                [491196.0, 6399384.0],
                                [489091.0, 6407815.0],
                                [486169.0, 6410676.0],
                                [474628.0, 6407547.0],
                                [472909.0, 6402270.0],
                                [476701.0, 6399758.0],
                                [474218.0, 6394851.0],
                                [464993.0, 6388179.0],
                                [460343.0, 6383021.0],
                                [460366.0, 6373402.0],
                                [462536.0, 6370133.0],
                                [454032.0, 6364649.0],
                                [457916.0, 6359953.0],
                                [455164.0, 6354504.0],
                                [449164.0, 6352477.0],
                                [449759.0, 6344226.0],
                                [459734.0, 6343570.0],
                                [462757.0, 6341305.0],
                                [470769.0, 6340294.0],
                                [467874.0, 6336236.0],
                                [464468.0, 6326808.0],
                                [465465.0, 6324803.0],
                                [474692.0, 6327970.0],
                                [483787.0, 6325253.0],
                                [495008.0, 6328849.0],
                                [496470.0, 6331745.0],
                                [502833.0, 6331375.0],
                                [507637.0, 6333951.0],
                                [512956.0, 6327891.0],
                                [519117.0, 6332164.0],
                                [520115.0, 6336256.0],
                                [529462.0, 6338671.0],
                                [533815.0, 6350996.0],
                                [536387.0, 6355171.0],
                                [530427.0, 6360537.0],
                                [531660.0, 6365290.0],
                                [544593.0, 6364542.0],
                                [545774.0, 6366277.0],
                                [541673.0, 6377661.0],
                                [542159.0, 6383881.0],
                                [547193.0, 6388334.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "47", "NOM_DEPT": "LOT-ET-GARONNE"},
                    "id": 1,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [841110.0, 6468164.0],
                                [847361.0, 6468209.0],
                                [855768.0, 6473591.0],
                                [860939.0, 6470947.0],
                                [866406.0, 6463235.0],
                                [870728.0, 6463360.0],
                                [871909.0, 6454823.0],
                                [871457.0, 6445038.0],
                                [888053.0, 6440277.0],
                                [892767.0, 6444271.0],
                                [895595.0, 6439026.0],
                                [895949.0, 6427870.0],
                                [894862.0, 6413405.0],
                                [907889.0, 6409384.0],
                                [918546.0, 6403480.0],
                                [921863.0, 6404787.0],
                                [925560.0, 6409806.0],
                                [930672.0, 6410433.0],
                                [933177.0, 6416064.0],
                                [939410.0, 6420031.0],
                                [941569.0, 6417648.0],
                                [947667.0, 6423241.0],
                                [956742.0, 6422339.0],
                                [960775.0, 6424797.0],
                                [965006.0, 6422921.0],
                                [964872.0, 6432532.0],
                                [961377.0, 6439340.0],
                                [952342.0, 6439924.0],
                                [953909.0, 6450690.0],
                                [956276.0, 6452799.0],
                                [950505.0, 6456663.0],
                                [945165.0, 6465401.0],
                                [945461.0, 6470305.0],
                                [949441.0, 6473761.0],
                                [948557.0, 6482085.0],
                                [943964.0, 6486985.0],
                                [938381.0, 6486658.0],
                                [931624.0, 6492445.0],
                                [925224.0, 6482705.0],
                                [917457.0, 6486189.0],
                                [913763.0, 6489603.0],
                                [904449.0, 6504924.0],
                                [897998.0, 6515860.0],
                                [888123.0, 6525941.0],
                                [888996.0, 6528631.0],
                                [882529.0, 6534232.0],
                                [879159.0, 6530984.0],
                                [876089.0, 6523611.0],
                                [870291.0, 6521483.0],
                                [863140.0, 6525920.0],
                                [862850.0, 6517700.0],
                                [865784.0, 6514252.0],
                                [858527.0, 6506228.0],
                                [848198.0, 6502534.0],
                                [841056.0, 6498593.0],
                                [845846.0, 6493277.0],
                                [837308.0, 6485557.0],
                                [837457.0, 6475559.0],
                                [841110.0, 6468164.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "38", "NOM_DEPT": "ISERE"},
                    "id": 2,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [634422.0, 7101577.0],
                                [623701.0, 7099214.0],
                                [610465.0, 7094261.0],
                                [605814.0, 7089013.0],
                                [599885.0, 7086576.0],
                                [601399.0, 7078135.0],
                                [598139.0, 7067917.0],
                                [599563.0, 7049801.0],
                                [597332.0, 7035063.0],
                                [603193.0, 7029103.0],
                                [605232.0, 7026713.0],
                                [612989.0, 7030025.0],
                                [622831.0, 7024302.0],
                                [624801.0, 7021563.0],
                                [634147.0, 7017146.0],
                                [635372.0, 7012312.0],
                                [648121.0, 7014552.0],
                                [654991.0, 7012592.0],
                                [660837.0, 7014835.0],
                                [663948.0, 7010834.0],
                                [656343.0, 7006536.0],
                                [658067.0, 7000416.0],
                                [662547.0, 7004433.0],
                                [667892.0, 7004913.0],
                                [669642.0, 7001764.0],
                                [689814.0, 6997681.0],
                                [691147.0, 6993758.0],
                                [706470.0, 6995042.0],
                                [706855.0, 7002888.0],
                                [711164.0, 7009522.0],
                                [712383.0, 7015916.0],
                                [699507.0, 7031355.0],
                                [702680.0, 7038239.0],
                                [701478.0, 7042709.0],
                                [697493.0, 7046164.0],
                                [692820.0, 7044918.0],
                                [687641.0, 7047582.0],
                                [686184.0, 7056263.0],
                                [688698.0, 7062196.0],
                                [683642.0, 7063001.0],
                                [679720.0, 7059405.0],
                                [673807.0, 7057943.0],
                                [664277.0, 7059477.0],
                                [658064.0, 7064147.0],
                                [653390.0, 7071778.0],
                                [644454.0, 7079622.0],
                                [642453.0, 7087769.0],
                                [636514.0, 7100652.0],
                                [634422.0, 7101577.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "62", "NOM_DEPT": "PAS-DE-CALAIS"},
                    "id": 3,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [776081.0, 6923412.0],
                                [782994.0, 6923346.0],
                                [790665.0, 6921022.0],
                                [795010.0, 6915033.0],
                                [803525.0, 6909934.0],
                                [814643.0, 6911926.0],
                                [818364.0, 6905215.0],
                                [822754.0, 6907655.0],
                                [833062.0, 6905548.0],
                                [837898.0, 6908256.0],
                                [842092.0, 6905887.0],
                                [849280.0, 6910207.0],
                                [847303.0, 6917040.0],
                                [853548.0, 6926776.0],
                                [849442.0, 6935263.0],
                                [853210.0, 6945817.0],
                                [856532.0, 6942619.0],
                                [867310.0, 6942452.0],
                                [873032.0, 6949057.0],
                                [869864.0, 6950495.0],
                                [863792.0, 6957578.0],
                                [856370.0, 6957018.0],
                                [850915.0, 6964755.0],
                                [848735.0, 6964497.0],
                                [834935.0, 6970707.0],
                                [833403.0, 6975569.0],
                                [835414.0, 6979112.0],
                                [832902.0, 6984653.0],
                                [828614.0, 6985882.0],
                                [833821.0, 7001508.0],
                                [834466.0, 7007583.0],
                                [830491.0, 7008459.0],
                                [826108.0, 7005649.0],
                                [820627.0, 6997569.0],
                                [821199.0, 6989850.0],
                                [814347.0, 6988595.0],
                                [808498.0, 6984157.0],
                                [803958.0, 6983050.0],
                                [795770.0, 6985807.0],
                                [788558.0, 6985051.0],
                                [789845.0, 6973793.0],
                                [787172.0, 6965431.0],
                                [790134.0, 6962730.0],
                                [781387.0, 6953785.0],
                                [779463.0, 6948255.0],
                                [774574.0, 6946610.0],
                                [777906.0, 6941851.0],
                                [775403.0, 6934852.0],
                                [776081.0, 6923412.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "08", "NOM_DEPT": "ARDENNES"},
                    "id": 4,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [730707.0, 6810078.0],
                                [736893.0, 6807760.0],
                                [745765.0, 6796957.0],
                                [746161.0, 6791892.0],
                                [749678.0, 6782304.0],
                                [755033.0, 6785741.0],
                                [759917.0, 6778325.0],
                                [763413.0, 6765164.0],
                                [767353.0, 6760249.0],
                                [783028.0, 6759096.0],
                                [789480.0, 6763963.0],
                                [796594.0, 6759156.0],
                                [797692.0, 6763119.0],
                                [808147.0, 6762855.0],
                                [816397.0, 6764598.0],
                                [817962.0, 6771080.0],
                                [827043.0, 6770243.0],
                                [825768.0, 6776095.0],
                                [828770.0, 6781171.0],
                                [835407.0, 6779651.0],
                                [837598.0, 6783989.0],
                                [837935.0, 6797546.0],
                                [834073.0, 6806764.0],
                                [827022.0, 6811887.0],
                                [822210.0, 6820200.0],
                                [823302.0, 6827043.0],
                                [819107.0, 6829393.0],
                                [814106.0, 6826118.0],
                                [803526.0, 6829924.0],
                                [796995.0, 6835851.0],
                                [797551.0, 6845278.0],
                                [785824.0, 6845891.0],
                                [779497.0, 6845091.0],
                                [773768.0, 6840880.0],
                                [769985.0, 6834113.0],
                                [760761.0, 6824301.0],
                                [753955.0, 6826609.0],
                                [746802.0, 6826973.0],
                                [740952.0, 6835710.0],
                                [737148.0, 6833964.0],
                                [731262.0, 6826009.0],
                                [728998.0, 6813854.0],
                                [730707.0, 6810078.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "10", "NOM_DEPT": "AUBE"},
                    "id": 5,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [1009696.0, 6370071.0],
                                [1002665.0, 6364730.0],
                                [997268.0, 6357103.0],
                                [994698.0, 6348019.0],
                                [1000668.0, 6338218.0],
                                [1000089.0, 6334256.0],
                                [1007601.0, 6328762.0],
                                [1009068.0, 6324850.0],
                                [1014122.0, 6322114.0],
                                [1012050.0, 6317690.0],
                                [1007566.0, 6320724.0],
                                [1000978.0, 6315262.0],
                                [997097.0, 6315251.0],
                                [992638.0, 6305621.0],
                                [1002326.0, 6300425.0],
                                [1003290.0, 6292496.0],
                                [1006552.0, 6288390.0],
                                [1015523.0, 6285590.0],
                                [1014132.0, 6274778.0],
                                [1018256.0, 6272482.0],
                                [1020971.0, 6279894.0],
                                [1026533.0, 6279746.0],
                                [1033109.0, 6287175.0],
                                [1036126.0, 6293135.0],
                                [1041921.0, 6296903.0],
                                [1048217.0, 6297561.0],
                                [1064350.0, 6309506.0],
                                [1061225.0, 6317546.0],
                                [1066133.0, 6321494.0],
                                [1066468.0, 6326676.0],
                                [1072800.0, 6330433.0],
                                [1073742.0, 6336784.0],
                                [1077560.0, 6342698.0],
                                [1073403.0, 6350462.0],
                                [1060282.0, 6348576.0],
                                [1054180.0, 6344806.0],
                                [1042408.0, 6347558.0],
                                [1034654.0, 6353189.0],
                                [1025044.0, 6356596.0],
                                [1020000.0, 6356725.0],
                                [1018585.0, 6361599.0],
                                [1009696.0, 6370071.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "06", "NOM_DEPT": "ALPES-MARITIMES"},
                    "id": 6,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [753779.0, 6537018.0],
                                [758503.0, 6532097.0],
                                [754369.0, 6520637.0],
                                [760734.0, 6514163.0],
                                [764154.0, 6503988.0],
                                [770440.0, 6500348.0],
                                [774454.0, 6495613.0],
                                [776221.0, 6483674.0],
                                [770335.0, 6479388.0],
                                [770263.0, 6473476.0],
                                [776677.0, 6475557.0],
                                [780259.0, 6472021.0],
                                [792166.0, 6477709.0],
                                [802398.0, 6475469.0],
                                [807029.0, 6471772.0],
                                [806856.0, 6463705.0],
                                [811227.0, 6465007.0],
                                [816370.0, 6460772.0],
                                [825694.0, 6462649.0],
                                [826509.0, 6469123.0],
                                [831517.0, 6473257.0],
                                [837457.0, 6475559.0],
                                [837308.0, 6485557.0],
                                [834511.0, 6489782.0],
                                [829797.0, 6488843.0],
                                [825934.0, 6498617.0],
                                [818524.0, 6498224.0],
                                [809870.0, 6504594.0],
                                [806255.0, 6511913.0],
                                [808147.0, 6518212.0],
                                [807296.0, 6530310.0],
                                [802643.0, 6534285.0],
                                [800220.0, 6540120.0],
                                [801039.0, 6547667.0],
                                [798995.0, 6551156.0],
                                [802035.0, 6559678.0],
                                [810991.0, 6564128.0],
                                [806993.0, 6569822.0],
                                [798969.0, 6562707.0],
                                [797273.0, 6565101.0],
                                [787355.0, 6564848.0],
                                [785138.0, 6567101.0],
                                [776287.0, 6563809.0],
                                [774989.0, 6567447.0],
                                [768620.0, 6568680.0],
                                [769267.0, 6575508.0],
                                [762003.0, 6573092.0],
                                [760949.0, 6561975.0],
                                [763504.0, 6554575.0],
                                [762385.0, 6549859.0],
                                [763887.0, 6544360.0],
                                [761084.0, 6541876.0],
                                [754888.0, 6541809.0],
                                [753779.0, 6537018.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "42", "NOM_DEPT": "LOIRE"},
                    "id": 7,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [505760.0, 6248691.0],
                                [506455.0, 6246240.0],
                                [501020.0, 6240519.0],
                                [500952.0, 6237523.0],
                                [491741.0, 6229153.0],
                                [498958.0, 6224762.0],
                                [501199.0, 6216194.0],
                                [506394.0, 6214104.0],
                                [501753.0, 6199863.0],
                                [493715.0, 6200925.0],
                                [492032.0, 6195420.0],
                                [491362.0, 6184305.0],
                                [493119.0, 6181125.0],
                                [509918.0, 6181609.0],
                                [507071.0, 6189939.0],
                                [508439.0, 6196068.0],
                                [512551.0, 6198492.0],
                                [524704.0, 6194181.0],
                                [522873.0, 6204718.0],
                                [526458.0, 6208824.0],
                                [535012.0, 6210452.0],
                                [537386.0, 6214080.0],
                                [535770.0, 6220735.0],
                                [540236.0, 6224348.0],
                                [541984.0, 6228895.0],
                                [547328.0, 6230443.0],
                                [554118.0, 6225953.0],
                                [555809.0, 6233248.0],
                                [562910.0, 6233771.0],
                                [567825.0, 6236309.0],
                                [561407.0, 6244405.0],
                                [565565.0, 6247682.0],
                                [572065.0, 6240985.0],
                                [575081.0, 6235814.0],
                                [582028.0, 6242918.0],
                                [589272.0, 6240503.0],
                                [593467.0, 6242482.0],
                                [598408.0, 6250205.0],
                                [603733.0, 6249863.0],
                                [603060.0, 6255463.0],
                                [607574.0, 6261192.0],
                                [611672.0, 6256714.0],
                                [621363.0, 6260238.0],
                                [620519.0, 6263967.0],
                                [609628.0, 6269734.0],
                                [605052.0, 6276459.0],
                                [594074.0, 6282175.0],
                                [597601.0, 6285124.0],
                                [595737.0, 6291653.0],
                                [592076.0, 6294561.0],
                                [590928.0, 6301074.0],
                                [586632.0, 6302842.0],
                                [583878.0, 6308763.0],
                                [583992.0, 6314318.0],
                                [575242.0, 6309509.0],
                                [567948.0, 6310839.0],
                                [568130.0, 6303820.0],
                                [556606.0, 6298479.0],
                                [550735.0, 6304341.0],
                                [535303.0, 6300840.0],
                                [545681.0, 6284750.0],
                                [550482.0, 6283435.0],
                                [554723.0, 6278961.0],
                                [539594.0, 6265818.0],
                                [536034.0, 6253601.0],
                                [531230.0, 6258583.0],
                                [523428.0, 6259977.0],
                                [514960.0, 6255730.0],
                                [509767.0, 6249274.0],
                                [505760.0, 6248691.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "31", "NOM_DEPT": "HAUTE-GARONNE"},
                    "id": 8,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [806993.0, 6569822.0],
                                [808209.0, 6578315.0],
                                [815826.0, 6575242.0],
                                [824653.0, 6575157.0],
                                [830305.0, 6579430.0],
                                [833486.0, 6565745.0],
                                [837322.0, 6565642.0],
                                [839484.0, 6574938.0],
                                [845050.0, 6590960.0],
                                [845229.0, 6595067.0],
                                [848718.0, 6603737.0],
                                [857422.0, 6600366.0],
                                [868758.0, 6603264.0],
                                [869949.0, 6598870.0],
                                [877344.0, 6596683.0],
                                [885325.0, 6599852.0],
                                [880824.0, 6605207.0],
                                [886706.0, 6618161.0],
                                [882575.0, 6628163.0],
                                [880659.0, 6638936.0],
                                [887343.0, 6642371.0],
                                [876345.0, 6647462.0],
                                [872158.0, 6650880.0],
                                [871408.0, 6655745.0],
                                [860161.0, 6652754.0],
                                [855755.0, 6655507.0],
                                [831500.0, 6648015.0],
                                [823470.0, 6650227.0],
                                [813434.0, 6659755.0],
                                [806754.0, 6662035.0],
                                [806631.0, 6665548.0],
                                [795506.0, 6668991.0],
                                [791663.0, 6673495.0],
                                [789554.0, 6672918.0],
                                [784602.0, 6669828.0],
                                [780471.0, 6669516.0],
                                [778810.0, 6664936.0],
                                [781374.0, 6662136.0],
                                [779000.0, 6654397.0],
                                [778932.0, 6646959.0],
                                [783308.0, 6642195.0],
                                [780490.0, 6638662.0],
                                [781064.0, 6632682.0],
                                [775685.0, 6631211.0],
                                [770503.0, 6626941.0],
                                [760920.0, 6622686.0],
                                [756196.0, 6628301.0],
                                [748049.0, 6627896.0],
                                [748734.0, 6623209.0],
                                [753291.0, 6618069.0],
                                [756931.0, 6607772.0],
                                [761463.0, 6602522.0],
                                [763922.0, 6603795.0],
                                [768312.0, 6598303.0],
                                [773476.0, 6599308.0],
                                [776586.0, 6596649.0],
                                [775079.0, 6589273.0],
                                [775913.0, 6580395.0],
                                [769267.0, 6575508.0],
                                [768620.0, 6568680.0],
                                [774989.0, 6567447.0],
                                [776287.0, 6563809.0],
                                [785138.0, 6567101.0],
                                [787355.0, 6564848.0],
                                [797273.0, 6565101.0],
                                [798969.0, 6562707.0],
                                [806993.0, 6569822.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "71", "NOM_DEPT": "SAONE-ET-LOIRE"},
                    "id": 9,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [399495.0, 6830885.0],
                                [398130.0, 6822559.0],
                                [400321.0, 6810723.0],
                                [395852.0, 6803336.0],
                                [398626.0, 6784333.0],
                                [400465.0, 6781914.0],
                                [400197.0, 6773697.0],
                                [394099.0, 6773357.0],
                                [390140.0, 6770978.0],
                                [386941.0, 6760260.0],
                                [382932.0, 6754022.0],
                                [389872.0, 6749698.0],
                                [393110.0, 6750366.0],
                                [402067.0, 6747685.0],
                                [404251.0, 6751414.0],
                                [412442.0, 6746090.0],
                                [419671.0, 6744167.0],
                                [429458.0, 6743442.0],
                                [440863.0, 6746201.0],
                                [446732.0, 6745443.0],
                                [446459.0, 6750432.0],
                                [442128.0, 6753611.0],
                                [448124.0, 6758669.0],
                                [447308.0, 6764356.0],
                                [455060.0, 6767070.0],
                                [451057.0, 6776681.0],
                                [459373.0, 6778102.0],
                                [460615.0, 6783387.0],
                                [458409.0, 6789055.0],
                                [466280.0, 6794064.0],
                                [465298.0, 6799724.0],
                                [467628.0, 6811401.0],
                                [473893.0, 6813452.0],
                                [474394.0, 6821359.0],
                                [467262.0, 6822174.0],
                                [466087.0, 6830999.0],
                                [463434.0, 6833996.0],
                                [457920.0, 6827997.0],
                                [451256.0, 6826715.0],
                                [446687.0, 6829012.0],
                                [441174.0, 6828584.0],
                                [437568.0, 6825109.0],
                                [429868.0, 6822252.0],
                                [422197.0, 6821752.0],
                                [414934.0, 6829326.0],
                                [407934.0, 6831360.0],
                                [404267.0, 6828490.0],
                                [399495.0, 6830885.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "53", "NOM_DEPT": "MAYENNE"},
                    "id": 10,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [459784.0, 6545825.0],
                                [457303.0, 6539406.0],
                                [458386.0, 6534878.0],
                                [455132.0, 6526680.0],
                                [449713.0, 6524677.0],
                                [445866.0, 6528260.0],
                                [434480.0, 6521530.0],
                                [434607.0, 6512022.0],
                                [436951.0, 6506668.0],
                                [442913.0, 6501478.0],
                                [446521.0, 6493231.0],
                                [444696.0, 6489309.0],
                                [445861.0, 6484044.0],
                                [443202.0, 6478722.0],
                                [447267.0, 6474282.0],
                                [456356.0, 6470307.0],
                                [455660.0, 6465791.0],
                                [461242.0, 6465553.0],
                                [464807.0, 6459164.0],
                                [468806.0, 6462928.0],
                                [474561.0, 6460744.0],
                                [485798.0, 6470195.0],
                                [484697.0, 6477489.0],
                                [489646.0, 6488189.0],
                                [493466.0, 6488572.0],
                                [504657.0, 6496986.0],
                                [505177.0, 6505055.0],
                                [513233.0, 6510903.0],
                                [515635.0, 6515544.0],
                                [522412.0, 6520738.0],
                                [522669.0, 6525452.0],
                                [527825.0, 6527023.0],
                                [534383.0, 6537804.0],
                                [540666.0, 6541823.0],
                                [539507.0, 6547743.0],
                                [531290.0, 6552122.0],
                                [531964.0, 6561069.0],
                                [526089.0, 6562344.0],
                                [521367.0, 6557890.0],
                                [509938.0, 6556936.0],
                                [507509.0, 6562167.0],
                                [499249.0, 6554736.0],
                                [489751.0, 6554866.0],
                                [483517.0, 6558927.0],
                                [473907.0, 6559092.0],
                                [469589.0, 6554692.0],
                                [465641.0, 6555184.0],
                                [464645.0, 6548283.0],
                                [459784.0, 6545825.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "16", "NOM_DEPT": "CHARENTE"},
                    "id": 11,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [417723.0, 6857101.0],
                                [408651.0, 6861319.0],
                                [399642.0, 6861271.0],
                                [396867.0, 6868913.0],
                                [401493.0, 6871059.0],
                                [411444.0, 6881401.0],
                                [417375.0, 6892264.0],
                                [416434.0, 6899162.0],
                                [413253.0, 6901117.0],
                                [415797.0, 6907383.0],
                                [406933.0, 6907874.0],
                                [400663.0, 6914651.0],
                                [399047.0, 6920143.0],
                                [400759.0, 6925144.0],
                                [397607.0, 6926545.0],
                                [396597.0, 6932989.0],
                                [388320.0, 6946238.0],
                                [388687.0, 6950091.0],
                                [394381.0, 6955463.0],
                                [390587.0, 6963240.0],
                                [381046.0, 6965005.0],
                                [372051.0, 6959988.0],
                                [362230.0, 6961356.0],
                                [343652.0, 6969661.0],
                                [343012.0, 6963991.0],
                                [349037.0, 6960923.0],
                                [349892.0, 6952123.0],
                                [346450.0, 6948841.0],
                                [350114.0, 6938864.0],
                                [350193.0, 6931900.0],
                                [357636.0, 6924163.0],
                                [364780.0, 6906370.0],
                                [363427.0, 6896430.0],
                                [366480.0, 6887586.0],
                                [365701.0, 6878731.0],
                                [362959.0, 6869214.0],
                                [363872.0, 6859932.0],
                                [368562.0, 6852485.0],
                                [376547.0, 6847928.0],
                                [372261.0, 6845150.0],
                                [363309.0, 6845999.0],
                                [366767.0, 6839135.0],
                                [368413.0, 6830443.0],
                                [376536.0, 6826525.0],
                                [384742.0, 6834496.0],
                                [389634.0, 6835155.0],
                                [399495.0, 6830885.0],
                                [404267.0, 6828490.0],
                                [407934.0, 6831360.0],
                                [414934.0, 6829326.0],
                                [421619.0, 6835816.0],
                                [423498.0, 6841841.0],
                                [420581.0, 6852284.0],
                                [417723.0, 6857101.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "50", "NOM_DEPT": "MANCHE"},
                    "id": 12,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [590236.0, 6872273.0],
                                [594217.0, 6866696.0],
                                [596554.0, 6858123.0],
                                [595472.0, 6845570.0],
                                [597086.0, 6841311.0],
                                [604791.0, 6831646.0],
                                [608912.0, 6830618.0],
                                [611402.0, 6819097.0],
                                [620311.0, 6818025.0],
                                [623768.0, 6826369.0],
                                [627504.0, 6829048.0],
                                [627800.0, 6838438.0],
                                [632440.0, 6843248.0],
                                [634691.0, 6849194.0],
                                [643163.0, 6853168.0],
                                [637702.0, 6857774.0],
                                [637864.0, 6864035.0],
                                [641404.0, 6867928.0],
                                [641836.0, 6872490.0],
                                [633062.0, 6879807.0],
                                [628641.0, 6878089.0],
                                [622312.0, 6880731.0],
                                [614076.0, 6886919.0],
                                [606678.0, 6883543.0],
                                [603102.0, 6887292.0],
                                [598361.0, 6887345.0],
                                [591984.0, 6886421.0],
                                [587216.0, 6881812.0],
                                [590236.0, 6872273.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "78", "NOM_DEPT": "YVELINES"},
                    "id": 13,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [986155.0, 6724947.0],
                                [984341.0, 6721925.0],
                                [977033.0, 6724531.0],
                                [974258.0, 6721322.0],
                                [969354.0, 6721610.0],
                                [967469.0, 6716290.0],
                                [955890.0, 6718838.0],
                                [950918.0, 6717032.0],
                                [945847.0, 6708437.0],
                                [932449.0, 6699390.0],
                                [925719.0, 6696195.0],
                                [922029.0, 6697905.0],
                                [904021.0, 6688452.0],
                                [905832.0, 6683506.0],
                                [912920.0, 6678099.0],
                                [913407.0, 6674258.0],
                                [909981.0, 6669146.0],
                                [913780.0, 6661601.0],
                                [925599.0, 6657600.0],
                                [925393.0, 6653995.0],
                                [928880.0, 6645788.0],
                                [940225.0, 6640408.0],
                                [944367.0, 6635241.0],
                                [942748.0, 6631718.0],
                                [934547.0, 6625608.0],
                                [937312.0, 6621303.0],
                                [933274.0, 6616467.0],
                                [940343.0, 6611180.0],
                                [938167.0, 6613167.0],
                                [950995.0, 6626461.0],
                                [962319.0, 6634781.0],
                                [961533.0, 6640379.0],
                                [963711.0, 6649123.0],
                                [961099.0, 6653277.0],
                                [967437.0, 6658254.0],
                                [976505.0, 6662212.0],
                                [981857.0, 6667617.0],
                                [983508.0, 6674248.0],
                                [992174.0, 6680929.0],
                                [993793.0, 6685149.0],
                                [999048.0, 6690006.0],
                                [1001635.0, 6695987.0],
                                [1006570.0, 6701646.0],
                                [1002944.0, 6704539.0],
                                [995578.0, 6702427.0],
                                [996902.0, 6711079.0],
                                [994087.0, 6717743.0],
                                [993651.0, 6723596.0],
                                [986155.0, 6724947.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "25", "NOM_DEPT": "DOUBS"},
                    "id": 14,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [904250.0, 6825381.0],
                                [904895.0, 6830283.0],
                                [900379.0, 6832469.0],
                                [903561.0, 6837915.0],
                                [902927.0, 6847494.0],
                                [899528.0, 6852809.0],
                                [904125.0, 6862116.0],
                                [901302.0, 6871865.0],
                                [905066.0, 6875501.0],
                                [906433.0, 6884047.0],
                                [905859.0, 6891045.0],
                                [901739.0, 6893315.0],
                                [900172.0, 6898682.0],
                                [901547.0, 6903348.0],
                                [898091.0, 6905220.0],
                                [898652.0, 6915853.0],
                                [895087.0, 6927281.0],
                                [891117.0, 6929633.0],
                                [883576.0, 6926040.0],
                                [878534.0, 6930925.0],
                                [879041.0, 6935896.0],
                                [875512.0, 6946935.0],
                                [873032.0, 6949057.0],
                                [867310.0, 6942452.0],
                                [856532.0, 6942619.0],
                                [853210.0, 6945817.0],
                                [849442.0, 6935263.0],
                                [853548.0, 6926776.0],
                                [847303.0, 6917040.0],
                                [849280.0, 6910207.0],
                                [842092.0, 6905887.0],
                                [841416.0, 6900107.0],
                                [845429.0, 6892400.0],
                                [846791.0, 6883540.0],
                                [848915.0, 6882413.0],
                                [848655.0, 6874905.0],
                                [841874.0, 6870868.0],
                                [838677.0, 6859119.0],
                                [846329.0, 6850924.0],
                                [846365.0, 6844539.0],
                                [847795.0, 6838972.0],
                                [852692.0, 6834838.0],
                                [856191.0, 6834907.0],
                                [863008.0, 6828766.0],
                                [873603.0, 6822775.0],
                                [882722.0, 6816263.0],
                                [893443.0, 6818701.0],
                                [904250.0, 6825381.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "55", "NOM_DEPT": "MEUSE"},
                    "id": 15,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [486169.0, 6410676.0],
                                [482141.0, 6421330.0],
                                [476390.0, 6418176.0],
                                [469504.0, 6418931.0],
                                [461839.0, 6422164.0],
                                [466012.0, 6428425.0],
                                [464018.0, 6432038.0],
                                [469719.0, 6445475.0],
                                [467756.0, 6450339.0],
                                [460931.0, 6449393.0],
                                [457280.0, 6451647.0],
                                [452009.0, 6448234.0],
                                [444096.0, 6451365.0],
                                [437492.0, 6457585.0],
                                [433418.0, 6457450.0],
                                [431214.0, 6470295.0],
                                [421098.0, 6472770.0],
                                [418478.0, 6475494.0],
                                [406100.0, 6476140.0],
                                [404682.0, 6481482.0],
                                [399796.0, 6489042.0],
                                [386164.0, 6505245.0],
                                [380995.0, 6504145.0],
                                [375328.0, 6494206.0],
                                [373905.0, 6475097.0],
                                [366594.0, 6427323.0],
                                [365668.0, 6410104.0],
                                [370987.0, 6417061.0],
                                [380337.0, 6407555.0],
                                [382533.0, 6402380.0],
                                [376517.0, 6401861.0],
                                [367865.0, 6404553.0],
                                [364521.0, 6395279.0],
                                [361697.0, 6391399.0],
                                [361774.0, 6383396.0],
                                [373686.0, 6386677.0],
                                [375548.0, 6389853.0],
                                [383562.0, 6383958.0],
                                [381182.0, 6379048.0],
                                [388231.0, 6379327.0],
                                [393973.0, 6376334.0],
                                [403228.0, 6378937.0],
                                [411314.0, 6378206.0],
                                [411174.0, 6373203.0],
                                [418928.0, 6369127.0],
                                [419635.0, 6366255.0],
                                [426389.0, 6364119.0],
                                [430077.0, 6359927.0],
                                [429214.0, 6351421.0],
                                [438523.0, 6349285.0],
                                [442465.0, 6350467.0],
                                [445091.0, 6357381.0],
                                [449164.0, 6352477.0],
                                [455164.0, 6354504.0],
                                [457916.0, 6359953.0],
                                [454032.0, 6364649.0],
                                [462536.0, 6370133.0],
                                [460366.0, 6373402.0],
                                [460343.0, 6383021.0],
                                [464993.0, 6388179.0],
                                [474218.0, 6394851.0],
                                [476701.0, 6399758.0],
                                [472909.0, 6402270.0],
                                [474628.0, 6407547.0],
                                [486169.0, 6410676.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "33", "NOM_DEPT": "GIRONDE"},
                    "id": 16,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [503908.0, 6928958.0],
                                [498291.0, 6928808.0],
                                [490213.0, 6925480.0],
                                [480923.0, 6917694.0],
                                [474554.0, 6915313.0],
                                [465316.0, 6913926.0],
                                [451821.0, 6920480.0],
                                [444571.0, 6921849.0],
                                [429556.0, 6922759.0],
                                [420281.0, 6924935.0],
                                [414059.0, 6928862.0],
                                [403953.0, 6928646.0],
                                [400759.0, 6925144.0],
                                [399047.0, 6920143.0],
                                [400663.0, 6914651.0],
                                [406933.0, 6907874.0],
                                [415797.0, 6907383.0],
                                [413253.0, 6901117.0],
                                [416434.0, 6899162.0],
                                [417375.0, 6892264.0],
                                [411444.0, 6881401.0],
                                [401493.0, 6871059.0],
                                [396867.0, 6868913.0],
                                [399642.0, 6861271.0],
                                [408651.0, 6861319.0],
                                [417723.0, 6857101.0],
                                [427244.0, 6861949.0],
                                [446005.0, 6869054.0],
                                [449827.0, 6868751.0],
                                [454384.0, 6863198.0],
                                [457511.0, 6867107.0],
                                [469104.0, 6863978.0],
                                [475607.0, 6865852.0],
                                [484257.0, 6870962.0],
                                [489675.0, 6876299.0],
                                [491678.0, 6873174.0],
                                [500558.0, 6877307.0],
                                [504730.0, 6874732.0],
                                [510545.0, 6875400.0],
                                [512505.0, 6881741.0],
                                [508338.0, 6886469.0],
                                [512079.0, 6895331.0],
                                [509950.0, 6897618.0],
                                [509502.0, 6910309.0],
                                [505278.0, 6914121.0],
                                [503908.0, 6928958.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "14", "NOM_DEPT": "CALVADOS"},
                    "id": 17,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [915394.0, 6762341.0],
                                [919858.0, 6768473.0],
                                [924039.0, 6766004.0],
                                [929025.0, 6772821.0],
                                [935284.0, 6772098.0],
                                [936416.0, 6766072.0],
                                [941726.0, 6764118.0],
                                [951150.0, 6767749.0],
                                [956126.0, 6765947.0],
                                [959909.0, 6759629.0],
                                [964569.0, 6761737.0],
                                [968808.0, 6766577.0],
                                [972278.0, 6762245.0],
                                [982963.0, 6756697.0],
                                [986052.0, 6752778.0],
                                [987691.0, 6753958.0],
                                [993060.0, 6757264.0],
                                [991355.0, 6761730.0],
                                [993983.0, 6773739.0],
                                [998205.0, 6776671.0],
                                [1001795.0, 6789636.0],
                                [1006708.0, 6801985.0],
                                [1011125.0, 6809400.0],
                                [1005338.0, 6811635.0],
                                [1003109.0, 6819572.0],
                                [1004385.0, 6831654.0],
                                [994239.0, 6827289.0],
                                [987769.0, 6820181.0],
                                [982282.0, 6817771.0],
                                [973656.0, 6818945.0],
                                [964951.0, 6823820.0],
                                [963830.0, 6819154.0],
                                [935203.0, 6815546.0],
                                [930831.0, 6810526.0],
                                [919362.0, 6809623.0],
                                [910921.0, 6826770.0],
                                [904250.0, 6825381.0],
                                [893443.0, 6818701.0],
                                [882722.0, 6816263.0],
                                [878315.0, 6811920.0],
                                [883843.0, 6809100.0],
                                [896020.0, 6796835.0],
                                [901295.0, 6794520.0],
                                [899609.0, 6786135.0],
                                [895837.0, 6779219.0],
                                [900794.0, 6778635.0],
                                [906998.0, 6773750.0],
                                [908017.0, 6765028.0],
                                [912655.0, 6766332.0],
                                [915394.0, 6762341.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "88", "NOM_DEPT": "VOSGES"},
                    "id": 18,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [642856.0, 6724786.0],
                                [634456.0, 6720842.0],
                                [639501.0, 6716775.0],
                                [642622.0, 6708275.0],
                                [632231.0, 6698879.0],
                                [634922.0, 6687596.0],
                                [624165.0, 6685496.0],
                                [619951.0, 6688294.0],
                                [617060.0, 6680060.0],
                                [612147.0, 6680536.0],
                                [612309.0, 6675948.0],
                                [607114.0, 6670785.0],
                                [615265.0, 6667454.0],
                                [621646.0, 6669974.0],
                                [627833.0, 6667741.0],
                                [627981.0, 6660408.0],
                                [631131.0, 6657674.0],
                                [629301.0, 6648616.0],
                                [633457.0, 6642556.0],
                                [627496.0, 6637025.0],
                                [632500.0, 6630848.0],
                                [628673.0, 6627353.0],
                                [634340.0, 6622075.0],
                                [637665.0, 6611745.0],
                                [635550.0, 6606712.0],
                                [638969.0, 6598575.0],
                                [634893.0, 6595681.0],
                                [636090.0, 6591904.0],
                                [644784.0, 6591412.0],
                                [645179.0, 6595086.0],
                                [650317.0, 6601560.0],
                                [660370.0, 6603761.0],
                                [664479.0, 6602292.0],
                                [670500.0, 6605989.0],
                                [669145.0, 6615318.0],
                                [677474.0, 6626628.0],
                                [682775.0, 6624336.0],
                                [686837.0, 6626145.0],
                                [696943.0, 6633749.0],
                                [702446.0, 6632753.0],
                                [705186.0, 6641947.0],
                                [703828.0, 6645606.0],
                                [706033.0, 6650549.0],
                                [705753.0, 6657660.0],
                                [701762.0, 6662486.0],
                                [702129.0, 6669867.0],
                                [698614.0, 6680189.0],
                                [698745.0, 6684384.0],
                                [690449.0, 6694237.0],
                                [694642.0, 6704915.0],
                                [690565.0, 6713347.0],
                                [685430.0, 6710473.0],
                                [682544.0, 6713710.0],
                                [678869.0, 6710238.0],
                                [674282.0, 6709782.0],
                                [669909.0, 6717111.0],
                                [661757.0, 6718781.0],
                                [657729.0, 6723417.0],
                                [652875.0, 6720759.0],
                                [646396.0, 6725640.0],
                                [642856.0, 6724786.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "18", "NOM_DEPT": "CHER"},
                    "id": 19,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [779411.0, 6373918.0],
                                [785084.0, 6367917.0],
                                [783861.0, 6358147.0],
                                [791158.0, 6357807.0],
                                [800494.0, 6352553.0],
                                [802764.0, 6358131.0],
                                [806518.0, 6360956.0],
                                [819866.0, 6361270.0],
                                [824346.0, 6357163.0],
                                [831641.0, 6353746.0],
                                [831614.0, 6360351.0],
                                [832713.0, 6371581.0],
                                [835151.0, 6374038.0],
                                [834538.0, 6384016.0],
                                [835764.0, 6388411.0],
                                [841041.0, 6396655.0],
                                [839715.0, 6410394.0],
                                [844069.0, 6414766.0],
                                [848816.0, 6428161.0],
                                [844782.0, 6435636.0],
                                [842390.0, 6453321.0],
                                [841110.0, 6468164.0],
                                [837457.0, 6475559.0],
                                [831517.0, 6473257.0],
                                [826509.0, 6469123.0],
                                [825694.0, 6462649.0],
                                [816370.0, 6460772.0],
                                [813436.0, 6450097.0],
                                [808187.0, 6450395.0],
                                [808165.0, 6446004.0],
                                [801638.0, 6433950.0],
                                [796332.0, 6429870.0],
                                [791307.0, 6420019.0],
                                [782106.0, 6419872.0],
                                [781273.0, 6415520.0],
                                [774103.0, 6411136.0],
                                [768276.0, 6405343.0],
                                [771844.0, 6388592.0],
                                [775042.0, 6386528.0],
                                [779411.0, 6373918.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "07", "NOM_DEPT": "ARDECHE"},
                    "id": 20,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [776081.0, 6923412.0],
                                [775403.0, 6934852.0],
                                [777906.0, 6941851.0],
                                [774574.0, 6946610.0],
                                [779463.0, 6948255.0],
                                [781387.0, 6953785.0],
                                [790134.0, 6962730.0],
                                [787172.0, 6965431.0],
                                [789845.0, 6973793.0],
                                [788558.0, 6985051.0],
                                [781905.0, 6987282.0],
                                [778060.0, 6986162.0],
                                [770359.0, 6988977.0],
                                [766237.0, 6992385.0],
                                [753505.0, 6995276.0],
                                [751253.0, 6997000.0],
                                [744014.0, 6992056.0],
                                [739058.0, 6995179.0],
                                [735248.0, 6991264.0],
                                [725313.0, 6993104.0],
                                [720100.0, 6990781.0],
                                [716534.0, 6992565.0],
                                [712391.0, 6990404.0],
                                [713833.0, 6986563.0],
                                [708480.0, 6979518.0],
                                [705667.0, 6969289.0],
                                [708546.0, 6956332.0],
                                [707064.0, 6950845.0],
                                [709520.0, 6938240.0],
                                [706939.0, 6934901.0],
                                [711648.0, 6928031.0],
                                [706805.0, 6926038.0],
                                [706929.0, 6919738.0],
                                [698137.0, 6911415.0],
                                [701957.0, 6908433.0],
                                [704672.0, 6899225.0],
                                [710189.0, 6894765.0],
                                [705248.0, 6890863.0],
                                [712067.0, 6888882.0],
                                [712559.0, 6879371.0],
                                [722321.0, 6872132.0],
                                [724211.0, 6867685.0],
                                [729581.0, 6862815.0],
                                [735603.0, 6861428.0],
                                [738742.0, 6868146.0],
                                [744067.0, 6871735.0],
                                [747254.0, 6882494.0],
                                [743801.0, 6891376.0],
                                [745398.0, 6894771.0],
                                [751361.0, 6898188.0],
                                [747051.0, 6913033.0],
                                [761575.0, 6918670.0],
                                [767112.0, 6923360.0],
                                [775242.0, 6918312.0],
                                [776081.0, 6923412.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "02", "NOM_DEPT": "AISNE"},
                    "id": 21,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [334283.0, 6280551.0],
                                [327832.0, 6270658.0],
                                [324268.0, 6267623.0],
                                [314107.0, 6264613.0],
                                [316186.0, 6255555.0],
                                [321493.0, 6257288.0],
                                [325696.0, 6250142.0],
                                [329513.0, 6253905.0],
                                [334359.0, 6254169.0],
                                [344050.0, 6249226.0],
                                [343580.0, 6242296.0],
                                [340751.0, 6235590.0],
                                [335750.0, 6230517.0],
                                [338499.0, 6226346.0],
                                [344947.0, 6224142.0],
                                [346289.0, 6231519.0],
                                [352412.0, 6225527.0],
                                [355170.0, 6226484.0],
                                [373097.0, 6218255.0],
                                [377794.0, 6214129.0],
                                [388910.0, 6213290.0],
                                [393755.0, 6214784.0],
                                [395170.0, 6206882.0],
                                [409841.0, 6194695.0],
                                [412796.0, 6198151.0],
                                [418372.0, 6194685.0],
                                [422245.0, 6194862.0],
                                [428954.0, 6200122.0],
                                [428150.0, 6207547.0],
                                [431947.0, 6209367.0],
                                [431385.0, 6215423.0],
                                [437107.0, 6220297.0],
                                [440142.0, 6228799.0],
                                [443868.0, 6230545.0],
                                [446410.0, 6236240.0],
                                [454979.0, 6245934.0],
                                [452746.0, 6249402.0],
                                [457777.0, 6262698.0],
                                [451477.0, 6264635.0],
                                [454138.0, 6272903.0],
                                [449863.0, 6280833.0],
                                [443497.0, 6282643.0],
                                [438084.0, 6281592.0],
                                [433057.0, 6279053.0],
                                [424830.0, 6280287.0],
                                [421554.0, 6283529.0],
                                [412501.0, 6278002.0],
                                [403447.0, 6281078.0],
                                [399714.0, 6278404.0],
                                [394475.0, 6281218.0],
                                [385124.0, 6280151.0],
                                [377063.0, 6275535.0],
                                [367753.0, 6276986.0],
                                [362964.0, 6280741.0],
                                [352961.0, 6276001.0],
                                [342731.0, 6276517.0],
                                [338238.0, 6281381.0],
                                [334283.0, 6280551.0],
                            ]
                        ],
                    },
                    "properties": {
                        "CODE_DEPT": "64",
                        "NOM_DEPT": "PYRENEES-ATLANTIQUES",
                    },
                    "id": 22,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [642856.0, 6724786.0],
                                [640167.0, 6731164.0],
                                [620646.0, 6731114.0],
                                [613256.0, 6732409.0],
                                [609792.0, 6727136.0],
                                [605429.0, 6729771.0],
                                [602374.0, 6738361.0],
                                [591237.0, 6742041.0],
                                [590280.0, 6747700.0],
                                [594464.0, 6753836.0],
                                [589886.0, 6759775.0],
                                [589601.0, 6765689.0],
                                [573758.0, 6762848.0],
                                [566408.0, 6764638.0],
                                [559999.0, 6772636.0],
                                [559439.0, 6777275.0],
                                [551727.0, 6777731.0],
                                [551017.0, 6782681.0],
                                [539332.0, 6780273.0],
                                [535875.0, 6773086.0],
                                [539183.0, 6762306.0],
                                [532634.0, 6757689.0],
                                [533549.0, 6751156.0],
                                [528757.0, 6745774.0],
                                [518605.0, 6737439.0],
                                [521086.0, 6735350.0],
                                [530153.0, 6735215.0],
                                [539386.0, 6732046.0],
                                [543743.0, 6727862.0],
                                [552256.0, 6724799.0],
                                [555366.0, 6719856.0],
                                [552945.0, 6716389.0],
                                [559271.0, 6706788.0],
                                [557303.0, 6702930.0],
                                [558309.0, 6696538.0],
                                [557051.0, 6690388.0],
                                [561058.0, 6687382.0],
                                [565759.0, 6689706.0],
                                [569696.0, 6685244.0],
                                [573297.0, 6677558.0],
                                [582631.0, 6683116.0],
                                [593597.0, 6687211.0],
                                [602149.0, 6685865.0],
                                [612147.0, 6680536.0],
                                [617060.0, 6680060.0],
                                [619951.0, 6688294.0],
                                [624165.0, 6685496.0],
                                [634922.0, 6687596.0],
                                [632231.0, 6698879.0],
                                [642622.0, 6708275.0],
                                [639501.0, 6716775.0],
                                [634456.0, 6720842.0],
                                [642856.0, 6724786.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "41", "NOM_DEPT": "LOIR-ET-CHER"},
                    "id": 23,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [1001023.0, 6834020.0],
                                [1007603.0, 6833382.0],
                                [1013753.0, 6840510.0],
                                [1015426.0, 6846104.0],
                                [1012123.0, 6851875.0],
                                [1016765.0, 6860562.0],
                                [1004387.0, 6868517.0],
                                [1002983.0, 6863593.0],
                                [997609.0, 6864713.0],
                                [996607.0, 6871102.0],
                                [990508.0, 6874464.0],
                                [991999.0, 6880708.0],
                                [996400.0, 6888804.0],
                                [1000174.0, 6890502.0],
                                [1005257.0, 6886565.0],
                                [1014136.0, 6883372.0],
                                [1016790.0, 6880171.0],
                                [1025429.0, 6883147.0],
                                [1032318.0, 6879884.0],
                                [1035096.0, 6882767.0],
                                [1038624.0, 6893752.0],
                                [1031356.0, 6897552.0],
                                [1023578.0, 6906994.0],
                                [1018182.0, 6905695.0],
                                [1013674.0, 6899390.0],
                                [1009903.0, 6900358.0],
                                [996736.0, 6898172.0],
                                [992282.0, 6906134.0],
                                [986611.0, 6909639.0],
                                [979390.0, 6908077.0],
                                [979652.0, 6901424.0],
                                [972590.0, 6902443.0],
                                [968604.0, 6909024.0],
                                [966935.0, 6915200.0],
                                [959086.0, 6922273.0],
                                [960438.0, 6926520.0],
                                [957718.0, 6930675.0],
                                [948608.0, 6936180.0],
                                [945901.0, 6934734.0],
                                [938917.0, 6936180.0],
                                [935871.0, 6939385.0],
                                [928691.0, 6938466.0],
                                [926408.0, 6934964.0],
                                [916749.0, 6932316.0],
                                [915342.0, 6936492.0],
                                [909643.0, 6936903.0],
                                [913390.0, 6932141.0],
                                [912688.0, 6923499.0],
                                [920628.0, 6907653.0],
                                [917676.0, 6905219.0],
                                [920671.0, 6900380.0],
                                [914011.0, 6893894.0],
                                [914442.0, 6889764.0],
                                [922708.0, 6883240.0],
                                [922735.0, 6879575.0],
                                [928151.0, 6878713.0],
                                [929417.0, 6875078.0],
                                [939656.0, 6875317.0],
                                [945024.0, 6864515.0],
                                [946451.0, 6858744.0],
                                [961206.0, 6856322.0],
                                [964692.0, 6852206.0],
                                [969100.0, 6851558.0],
                                [971773.0, 6847764.0],
                                [976380.0, 6847597.0],
                                [983189.0, 6843093.0],
                                [993487.0, 6842033.0],
                                [1001023.0, 6834020.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "57", "NOM_DEPT": "MOSELLE"},
                    "id": 24,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [483517.0, 6558927.0],
                                [489751.0, 6554866.0],
                                [499249.0, 6554736.0],
                                [507509.0, 6562167.0],
                                [509938.0, 6556936.0],
                                [521367.0, 6557890.0],
                                [526089.0, 6562344.0],
                                [531964.0, 6561069.0],
                                [530127.0, 6570272.0],
                                [538896.0, 6578287.0],
                                [546474.0, 6577615.0],
                                [548271.0, 6584464.0],
                                [556218.0, 6586207.0],
                                [559931.0, 6588729.0],
                                [562773.0, 6594026.0],
                                [558128.0, 6596023.0],
                                [557842.0, 6602380.0],
                                [547958.0, 6609437.0],
                                [542426.0, 6611026.0],
                                [538906.0, 6616112.0],
                                [541431.0, 6623495.0],
                                [537221.0, 6629765.0],
                                [533123.0, 6635020.0],
                                [531658.0, 6641492.0],
                                [525272.0, 6647330.0],
                                [524608.0, 6655240.0],
                                [515158.0, 6658631.0],
                                [517389.0, 6653506.0],
                                [510389.0, 6653999.0],
                                [505157.0, 6650870.0],
                                [494833.0, 6656131.0],
                                [494947.0, 6665028.0],
                                [485608.0, 6667284.0],
                                [482922.0, 6672972.0],
                                [478404.0, 6673399.0],
                                [476861.0, 6677880.0],
                                [471947.0, 6677374.0],
                                [469141.0, 6670338.0],
                                [464624.0, 6667352.0],
                                [465537.0, 6662685.0],
                                [471018.0, 6649618.0],
                                [469757.0, 6639127.0],
                                [470952.0, 6628365.0],
                                [467588.0, 6622657.0],
                                [472374.0, 6614809.0],
                                [467690.0, 6607234.0],
                                [468300.0, 6594579.0],
                                [472081.0, 6590232.0],
                                [472141.0, 6584899.0],
                                [475179.0, 6582497.0],
                                [479925.0, 6587264.0],
                                [482897.0, 6584792.0],
                                [478920.0, 6578170.0],
                                [477460.0, 6571967.0],
                                [480502.0, 6565882.0],
                                [485043.0, 6563684.0],
                                [483517.0, 6558927.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "86", "NOM_DEPT": "VIENNE"},
                    "id": 25,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [515635.0, 6515544.0],
                                [513233.0, 6510903.0],
                                [505177.0, 6505055.0],
                                [504657.0, 6496986.0],
                                [493466.0, 6488572.0],
                                [489646.0, 6488189.0],
                                [484697.0, 6477489.0],
                                [485798.0, 6470195.0],
                                [474561.0, 6460744.0],
                                [468806.0, 6462928.0],
                                [464807.0, 6459164.0],
                                [460931.0, 6449393.0],
                                [467756.0, 6450339.0],
                                [469719.0, 6445475.0],
                                [464018.0, 6432038.0],
                                [466012.0, 6428425.0],
                                [461839.0, 6422164.0],
                                [469504.0, 6418931.0],
                                [476390.0, 6418176.0],
                                [482141.0, 6421330.0],
                                [486169.0, 6410676.0],
                                [489091.0, 6407815.0],
                                [491196.0, 6399384.0],
                                [495031.0, 6397493.0],
                                [512334.0, 6403639.0],
                                [514373.0, 6400391.0],
                                [527849.0, 6401566.0],
                                [526858.0, 6394383.0],
                                [530971.0, 6390971.0],
                                [539761.0, 6395885.0],
                                [547193.0, 6388334.0],
                                [553597.0, 6395079.0],
                                [553113.0, 6398528.0],
                                [559319.0, 6399932.0],
                                [564402.0, 6403210.0],
                                [570668.0, 6413830.0],
                                [570522.0, 6417080.0],
                                [576964.0, 6421036.0],
                                [574976.0, 6434607.0],
                                [577774.0, 6436765.0],
                                [573095.0, 6446142.0],
                                [566113.0, 6450433.0],
                                [564865.0, 6461779.0],
                                [560988.0, 6465186.0],
                                [568750.0, 6477311.0],
                                [563844.0, 6479160.0],
                                [563452.0, 6484264.0],
                                [553144.0, 6489340.0],
                                [546900.0, 6501981.0],
                                [539039.0, 6503445.0],
                                [529342.0, 6499739.0],
                                [524801.0, 6504583.0],
                                [526849.0, 6509996.0],
                                [515635.0, 6515544.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "24", "NOM_DEPT": "DORDOGNE"},
                    "id": 26,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [877344.0, 6596683.0],
                                [877221.0, 6593352.0],
                                [882664.0, 6589574.0],
                                [882486.0, 6586333.0],
                                [887558.0, 6582363.0],
                                [890444.0, 6576892.0],
                                [895736.0, 6577631.0],
                                [903737.0, 6585593.0],
                                [908880.0, 6582354.0],
                                [909869.0, 6577050.0],
                                [919460.0, 6577537.0],
                                [923919.0, 6580132.0],
                                [929573.0, 6589336.0],
                                [935280.0, 6595262.0],
                                [935835.0, 6600587.0],
                                [941800.0, 6609883.0],
                                [940343.0, 6611180.0],
                                [933274.0, 6616467.0],
                                [937312.0, 6621303.0],
                                [934547.0, 6625608.0],
                                [942748.0, 6631718.0],
                                [944367.0, 6635241.0],
                                [940225.0, 6640408.0],
                                [928880.0, 6645788.0],
                                [925393.0, 6653995.0],
                                [925599.0, 6657600.0],
                                [913780.0, 6661601.0],
                                [909981.0, 6669146.0],
                                [913407.0, 6674258.0],
                                [912920.0, 6678099.0],
                                [905832.0, 6683506.0],
                                [904021.0, 6688452.0],
                                [896736.0, 6687711.0],
                                [890265.0, 6692353.0],
                                [888032.0, 6690633.0],
                                [887407.0, 6682465.0],
                                [884880.0, 6674426.0],
                                [881002.0, 6667371.0],
                                [876191.0, 6666228.0],
                                [875449.0, 6660099.0],
                                [871408.0, 6655745.0],
                                [872158.0, 6650880.0],
                                [876345.0, 6647462.0],
                                [887343.0, 6642371.0],
                                [880659.0, 6638936.0],
                                [882575.0, 6628163.0],
                                [886706.0, 6618161.0],
                                [880824.0, 6605207.0],
                                [885325.0, 6599852.0],
                                [877344.0, 6596683.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "39", "NOM_DEPT": "JURA"},
                    "id": 27,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [610874.0, 6360746.0],
                                [596271.0, 6358053.0],
                                [592401.0, 6355117.0],
                                [585843.0, 6356520.0],
                                [581893.0, 6352690.0],
                                [570617.0, 6348643.0],
                                [562737.0, 6350024.0],
                                [549131.0, 6360516.0],
                                [545774.0, 6366277.0],
                                [544593.0, 6364542.0],
                                [531660.0, 6365290.0],
                                [530427.0, 6360537.0],
                                [536387.0, 6355171.0],
                                [533815.0, 6350996.0],
                                [529462.0, 6338671.0],
                                [520115.0, 6336256.0],
                                [519117.0, 6332164.0],
                                [521740.0, 6328834.0],
                                [528536.0, 6329188.0],
                                [520187.0, 6318466.0],
                                [528381.0, 6316132.0],
                                [531142.0, 6309545.0],
                                [531445.0, 6300603.0],
                                [535303.0, 6300840.0],
                                [550735.0, 6304341.0],
                                [556606.0, 6298479.0],
                                [568130.0, 6303820.0],
                                [567948.0, 6310839.0],
                                [575242.0, 6309509.0],
                                [583992.0, 6314318.0],
                                [583816.0, 6319290.0],
                                [589156.0, 6320414.0],
                                [595091.0, 6325907.0],
                                [592665.0, 6336179.0],
                                [599594.0, 6336049.0],
                                [602120.0, 6333848.0],
                                [607335.0, 6338978.0],
                                [613603.0, 6341028.0],
                                [619220.0, 6339455.0],
                                [618185.0, 6342854.0],
                                [612268.0, 6345645.0],
                                [617826.0, 6353582.0],
                                [612319.0, 6353954.0],
                                [610874.0, 6360746.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "82", "NOM_DEPT": "TARN-ET-GARONNE"},
                    "id": 28,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [404251.0, 6660135.0],
                                [413368.0, 6662854.0],
                                [417889.0, 6660618.0],
                                [424993.0, 6661094.0],
                                [429262.0, 6663802.0],
                                [429925.0, 6668493.0],
                                [434893.0, 6670550.0],
                                [442005.0, 6668948.0],
                                [454238.0, 6672319.0],
                                [458546.0, 6672434.0],
                                [464624.0, 6667352.0],
                                [469141.0, 6670338.0],
                                [471947.0, 6677374.0],
                                [476861.0, 6677880.0],
                                [479254.0, 6691029.0],
                                [487846.0, 6706491.0],
                                [490772.0, 6714971.0],
                                [489539.0, 6719725.0],
                                [491931.0, 6726763.0],
                                [485937.0, 6723990.0],
                                [478533.0, 6727039.0],
                                [474490.0, 6731769.0],
                                [469484.0, 6733109.0],
                                [464631.0, 6730466.0],
                                [460339.0, 6732350.0],
                                [457617.0, 6739093.0],
                                [450112.0, 6740918.0],
                                [446732.0, 6745443.0],
                                [440863.0, 6746201.0],
                                [429458.0, 6743442.0],
                                [419671.0, 6744167.0],
                                [412442.0, 6746090.0],
                                [404251.0, 6751414.0],
                                [402067.0, 6747685.0],
                                [393110.0, 6750366.0],
                                [389872.0, 6749698.0],
                                [382932.0, 6754022.0],
                                [382163.0, 6750361.0],
                                [381255.0, 6745617.0],
                                [386987.0, 6740963.0],
                                [389301.0, 6732485.0],
                                [398982.0, 6728603.0],
                                [395905.0, 6725901.0],
                                [386462.0, 6727467.0],
                                [387234.0, 6720426.0],
                                [401401.0, 6717774.0],
                                [402393.0, 6705897.0],
                                [396890.0, 6703794.0],
                                [385609.0, 6704471.0],
                                [375470.0, 6701871.0],
                                [374867.0, 6698071.0],
                                [378391.0, 6691949.0],
                                [382659.0, 6691801.0],
                                [384839.0, 6683588.0],
                                [379159.0, 6679552.0],
                                [379298.0, 6676338.0],
                                [387784.0, 6670618.0],
                                [385082.0, 6667087.0],
                                [392012.0, 6664073.0],
                                [401283.0, 6663962.0],
                                [404251.0, 6660135.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "49", "NOM_DEPT": "MAINE-ET-LOIRE"},
                    "id": 29,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [863140.0, 6525920.0],
                                [849404.0, 6524528.0],
                                [844536.0, 6535588.0],
                                [833933.0, 6540287.0],
                                [835850.0, 6543054.0],
                                [834501.0, 6551198.0],
                                [835220.0, 6556428.0],
                                [838741.0, 6561678.0],
                                [837322.0, 6565642.0],
                                [833486.0, 6565745.0],
                                [830305.0, 6579430.0],
                                [824653.0, 6575157.0],
                                [815826.0, 6575242.0],
                                [808209.0, 6578315.0],
                                [806993.0, 6569822.0],
                                [810991.0, 6564128.0],
                                [802035.0, 6559678.0],
                                [798995.0, 6551156.0],
                                [801039.0, 6547667.0],
                                [800220.0, 6540120.0],
                                [802643.0, 6534285.0],
                                [807296.0, 6530310.0],
                                [808147.0, 6518212.0],
                                [806255.0, 6511913.0],
                                [809870.0, 6504594.0],
                                [818524.0, 6498224.0],
                                [825934.0, 6498617.0],
                                [829797.0, 6488843.0],
                                [834511.0, 6489782.0],
                                [837308.0, 6485557.0],
                                [845846.0, 6493277.0],
                                [841056.0, 6498593.0],
                                [848198.0, 6502534.0],
                                [858527.0, 6506228.0],
                                [865784.0, 6514252.0],
                                [862850.0, 6517700.0],
                                [863140.0, 6525920.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "69", "NOM_DEPT": "RHONE"},
                    "id": 30,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [606642.0, 6924066.0],
                                [602657.0, 6922993.0],
                                [596650.0, 6927678.0],
                                [584841.0, 6929723.0],
                                [579971.0, 6928884.0],
                                [574422.0, 6917678.0],
                                [566281.0, 6917384.0],
                                [564288.0, 6913853.0],
                                [558013.0, 6912674.0],
                                [555352.0, 6907664.0],
                                [548914.0, 6917432.0],
                                [548813.0, 6922655.0],
                                [537794.0, 6926754.0],
                                [530512.0, 6925008.0],
                                [524567.0, 6928708.0],
                                [520591.0, 6933755.0],
                                [506978.0, 6930086.0],
                                [503908.0, 6928958.0],
                                [505278.0, 6914121.0],
                                [509502.0, 6910309.0],
                                [509950.0, 6897618.0],
                                [512079.0, 6895331.0],
                                [508338.0, 6886469.0],
                                [512505.0, 6881741.0],
                                [510545.0, 6875400.0],
                                [508448.0, 6870995.0],
                                [513552.0, 6867418.0],
                                [520512.0, 6866728.0],
                                [524600.0, 6861683.0],
                                [533488.0, 6856087.0],
                                [536389.0, 6850906.0],
                                [533024.0, 6847407.0],
                                [539112.0, 6843338.0],
                                [543803.0, 6848251.0],
                                [555241.0, 6849633.0],
                                [566604.0, 6854037.0],
                                [576482.0, 6852521.0],
                                [580772.0, 6855857.0],
                                [579784.0, 6860594.0],
                                [587701.0, 6866890.0],
                                [590236.0, 6872273.0],
                                [587216.0, 6881812.0],
                                [591984.0, 6886421.0],
                                [598361.0, 6887345.0],
                                [601892.0, 6893098.0],
                                [603501.0, 6902160.0],
                                [605624.0, 6904387.0],
                                [606128.0, 6907968.0],
                                [610931.0, 6911811.0],
                                [609871.0, 6919444.0],
                                [606642.0, 6924066.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "27", "NOM_DEPT": "EURE"},
                    "id": 31,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [619220.0, 6339455.0],
                                [628552.0, 6344336.0],
                                [632260.0, 6344664.0],
                                [651092.0, 6332910.0],
                                [652742.0, 6328715.0],
                                [656723.0, 6328192.0],
                                [661724.0, 6320369.0],
                                [659810.0, 6316970.0],
                                [664259.0, 6313698.0],
                                [664946.0, 6304799.0],
                                [674324.0, 6293934.0],
                                [679276.0, 6292258.0],
                                [684993.0, 6295873.0],
                                [693643.0, 6293013.0],
                                [694796.0, 6288406.0],
                                [698819.0, 6289943.0],
                                [704898.0, 6288229.0],
                                [704815.0, 6303628.0],
                                [716344.0, 6301672.0],
                                [722102.0, 6311077.0],
                                [728786.0, 6312824.0],
                                [736140.0, 6324746.0],
                                [726344.0, 6331169.0],
                                [726879.0, 6340020.0],
                                [729879.0, 6341376.0],
                                [728598.0, 6344387.0],
                                [718362.0, 6347498.0],
                                [709994.0, 6353946.0],
                                [712305.0, 6356606.0],
                                [709537.0, 6364934.0],
                                [710800.0, 6372878.0],
                                [705449.0, 6378272.0],
                                [706639.0, 6384441.0],
                                [698547.0, 6393953.0],
                                [693924.0, 6403282.0],
                                [694820.0, 6408897.0],
                                [690477.0, 6411547.0],
                                [688126.0, 6419157.0],
                                [684359.0, 6419403.0],
                                [679353.0, 6426925.0],
                                [676829.0, 6423158.0],
                                [668604.0, 6416079.0],
                                [668313.0, 6410487.0],
                                [665404.0, 6408608.0],
                                [664849.0, 6402561.0],
                                [655192.0, 6393469.0],
                                [646639.0, 6396959.0],
                                [637228.0, 6394175.0],
                                [637122.0, 6391031.0],
                                [632813.0, 6386229.0],
                                [625170.0, 6387538.0],
                                [615061.0, 6379167.0],
                                [607709.0, 6375883.0],
                                [610874.0, 6360746.0],
                                [612319.0, 6353954.0],
                                [617826.0, 6353582.0],
                                [612268.0, 6345645.0],
                                [618185.0, 6342854.0],
                                [619220.0, 6339455.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "12", "NOM_DEPT": "AVEYRON"},
                    "id": 32,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [636090.0, 6591904.0],
                                [630016.0, 6590287.0],
                                [622684.0, 6592821.0],
                                [609355.0, 6592908.0],
                                [602234.0, 6588456.0],
                                [595863.0, 6588324.0],
                                [586530.0, 6592902.0],
                                [578129.0, 6584256.0],
                                [580236.0, 6579624.0],
                                [574730.0, 6569689.0],
                                [580656.0, 6565605.0],
                                [587795.0, 6549437.0],
                                [586335.0, 6540289.0],
                                [592200.0, 6538029.0],
                                [591561.0, 6529605.0],
                                [597279.0, 6527024.0],
                                [604752.0, 6527760.0],
                                [613074.0, 6522626.0],
                                [612524.0, 6515422.0],
                                [614305.0, 6511565.0],
                                [623634.0, 6517796.0],
                                [631053.0, 6514297.0],
                                [635791.0, 6515072.0],
                                [637278.0, 6511373.0],
                                [648450.0, 6509221.0],
                                [649366.0, 6512420.0],
                                [656101.0, 6511235.0],
                                [660507.0, 6515469.0],
                                [656022.0, 6519074.0],
                                [652489.0, 6525488.0],
                                [656753.0, 6529414.0],
                                [660605.0, 6529501.0],
                                [668605.0, 6543382.0],
                                [665172.0, 6557241.0],
                                [666451.0, 6560450.0],
                                [662729.0, 6571178.0],
                                [659880.0, 6575828.0],
                                [653217.0, 6581299.0],
                                [647921.0, 6581264.0],
                                [644784.0, 6591412.0],
                                [636090.0, 6591904.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "23", "NOM_DEPT": "CREUSE"},
                    "id": 33,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [695265.0, 6784783.0],
                                [685053.0, 6785343.0],
                                [678166.0, 6780535.0],
                                [665644.0, 6782354.0],
                                [663338.0, 6793247.0],
                                [657236.0, 6795707.0],
                                [655721.0, 6802434.0],
                                [653275.0, 6801114.0],
                                [639308.0, 6801806.0],
                                [625387.0, 6798948.0],
                                [623220.0, 6795517.0],
                                [615539.0, 6776549.0],
                                [606511.0, 6774717.0],
                                [597558.0, 6774986.0],
                                [595216.0, 6770968.0],
                                [589165.0, 6770859.0],
                                [589601.0, 6765689.0],
                                [589886.0, 6759775.0],
                                [594464.0, 6753836.0],
                                [590280.0, 6747700.0],
                                [591237.0, 6742041.0],
                                [602374.0, 6738361.0],
                                [605429.0, 6729771.0],
                                [609792.0, 6727136.0],
                                [613256.0, 6732409.0],
                                [620646.0, 6731114.0],
                                [640167.0, 6731164.0],
                                [642856.0, 6724786.0],
                                [646396.0, 6725640.0],
                                [652875.0, 6720759.0],
                                [657729.0, 6723417.0],
                                [661757.0, 6718781.0],
                                [669909.0, 6717111.0],
                                [674282.0, 6709782.0],
                                [678869.0, 6710238.0],
                                [682544.0, 6713710.0],
                                [685430.0, 6710473.0],
                                [690565.0, 6713347.0],
                                [693556.0, 6718403.0],
                                [698236.0, 6718784.0],
                                [695341.0, 6722058.0],
                                [694231.0, 6731133.0],
                                [689391.0, 6734632.0],
                                [689262.0, 6740069.0],
                                [695135.0, 6740319.0],
                                [701782.0, 6742907.0],
                                [700769.0, 6756036.0],
                                [703743.0, 6756785.0],
                                [709585.0, 6763406.0],
                                [706580.0, 6772621.0],
                                [703759.0, 6774663.0],
                                [702192.0, 6781427.0],
                                [695265.0, 6784783.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "45", "NOM_DEPT": "LOIRET"},
                    "id": 34,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [986052.0, 6752778.0],
                                [982963.0, 6756697.0],
                                [972278.0, 6762245.0],
                                [968808.0, 6766577.0],
                                [964569.0, 6761737.0],
                                [959909.0, 6759629.0],
                                [956126.0, 6765947.0],
                                [951150.0, 6767749.0],
                                [941726.0, 6764118.0],
                                [936416.0, 6766072.0],
                                [935284.0, 6772098.0],
                                [929025.0, 6772821.0],
                                [924039.0, 6766004.0],
                                [919858.0, 6768473.0],
                                [915394.0, 6762341.0],
                                [910900.0, 6755744.0],
                                [906433.0, 6754603.0],
                                [901288.0, 6749897.0],
                                [900414.0, 6745482.0],
                                [902985.0, 6741752.0],
                                [901778.0, 6735043.0],
                                [894824.0, 6733348.0],
                                [886220.0, 6734507.0],
                                [880542.0, 6733086.0],
                                [878352.0, 6725366.0],
                                [882147.0, 6728546.0],
                                [886108.0, 6726069.0],
                                [887785.0, 6718944.0],
                                [884206.0, 6713509.0],
                                [880595.0, 6713705.0],
                                [884919.0, 6701062.0],
                                [890265.0, 6692353.0],
                                [896736.0, 6687711.0],
                                [904021.0, 6688452.0],
                                [922029.0, 6697905.0],
                                [925719.0, 6696195.0],
                                [932449.0, 6699390.0],
                                [945847.0, 6708437.0],
                                [950918.0, 6717032.0],
                                [955890.0, 6718838.0],
                                [967469.0, 6716290.0],
                                [969354.0, 6721610.0],
                                [974258.0, 6721322.0],
                                [977033.0, 6724531.0],
                                [984341.0, 6721925.0],
                                [986155.0, 6724947.0],
                                [983826.0, 6731782.0],
                                [981470.0, 6745308.0],
                                [986052.0, 6752778.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "70", "NOM_DEPT": "HAUTE-SAONE"},
                    "id": 35,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [753779.0, 6537018.0],
                                [745523.0, 6547324.0],
                                [735860.0, 6546571.0],
                                [732386.0, 6552810.0],
                                [728730.0, 6550656.0],
                                [712873.0, 6551781.0],
                                [697819.0, 6557998.0],
                                [693029.0, 6567076.0],
                                [695157.0, 6571452.0],
                                [688886.0, 6572856.0],
                                [685369.0, 6566281.0],
                                [679424.0, 6569309.0],
                                [672252.0, 6557694.0],
                                [666451.0, 6560450.0],
                                [665172.0, 6557241.0],
                                [668605.0, 6543382.0],
                                [660605.0, 6529501.0],
                                [656753.0, 6529414.0],
                                [652489.0, 6525488.0],
                                [656022.0, 6519074.0],
                                [660507.0, 6515469.0],
                                [663288.0, 6509261.0],
                                [662164.0, 6504560.0],
                                [658322.0, 6500286.0],
                                [662264.0, 6494997.0],
                                [661594.0, 6486680.0],
                                [672750.0, 6482640.0],
                                [677684.0, 6475835.0],
                                [688449.0, 6477003.0],
                                [693859.0, 6474045.0],
                                [695974.0, 6467752.0],
                                [701310.0, 6465307.0],
                                [708104.0, 6472781.0],
                                [713160.0, 6472555.0],
                                [722742.0, 6478087.0],
                                [735734.0, 6477978.0],
                                [739202.0, 6481030.0],
                                [749018.0, 6471190.0],
                                [752222.0, 6475420.0],
                                [760473.0, 6472496.0],
                                [763248.0, 6477235.0],
                                [770263.0, 6473476.0],
                                [770335.0, 6479388.0],
                                [776221.0, 6483674.0],
                                [774454.0, 6495613.0],
                                [770440.0, 6500348.0],
                                [764154.0, 6503988.0],
                                [760734.0, 6514163.0],
                                [754369.0, 6520637.0],
                                [758503.0, 6532097.0],
                                [753779.0, 6537018.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "63", "NOM_DEPT": "PUY-DE-DOME"},
                    "id": 36,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [583992.0, 6314318.0],
                                [583878.0, 6308763.0],
                                [586632.0, 6302842.0],
                                [590928.0, 6301074.0],
                                [592076.0, 6294561.0],
                                [595737.0, 6291653.0],
                                [597601.0, 6285124.0],
                                [594074.0, 6282175.0],
                                [605052.0, 6276459.0],
                                [609628.0, 6269734.0],
                                [620519.0, 6263967.0],
                                [621363.0, 6260238.0],
                                [624846.0, 6255615.0],
                                [637154.0, 6259493.0],
                                [640013.0, 6262596.0],
                                [651680.0, 6257911.0],
                                [654081.0, 6259728.0],
                                [664821.0, 6258302.0],
                                [668090.0, 6259189.0],
                                [672444.0, 6264623.0],
                                [672394.0, 6269695.0],
                                [668935.0, 6274250.0],
                                [671212.0, 6283521.0],
                                [676690.0, 6282993.0],
                                [680178.0, 6279485.0],
                                [693221.0, 6284557.0],
                                [694796.0, 6288406.0],
                                [693643.0, 6293013.0],
                                [684993.0, 6295873.0],
                                [679276.0, 6292258.0],
                                [674324.0, 6293934.0],
                                [664946.0, 6304799.0],
                                [664259.0, 6313698.0],
                                [659810.0, 6316970.0],
                                [661724.0, 6320369.0],
                                [656723.0, 6328192.0],
                                [652742.0, 6328715.0],
                                [651092.0, 6332910.0],
                                [632260.0, 6344664.0],
                                [628552.0, 6344336.0],
                                [619220.0, 6339455.0],
                                [613603.0, 6341028.0],
                                [607335.0, 6338978.0],
                                [602120.0, 6333848.0],
                                [599594.0, 6336049.0],
                                [592665.0, 6336179.0],
                                [595091.0, 6325907.0],
                                [589156.0, 6320414.0],
                                [583816.0, 6319290.0],
                                [583992.0, 6314318.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "81", "NOM_DEPT": "TARN"},
                    "id": 37,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [612314.0, 6962826.0],
                                [608347.0, 6970745.0],
                                [605014.0, 6980736.0],
                                [589321.0, 6994349.0],
                                [583880.0, 6997485.0],
                                [570354.0, 6986979.0],
                                [561015.0, 6982476.0],
                                [553619.0, 6982021.0],
                                [539569.0, 6977082.0],
                                [525341.0, 6975010.0],
                                [506777.0, 6963564.0],
                                [498821.0, 6960824.0],
                                [494437.0, 6953650.0],
                                [487453.0, 6938754.0],
                                [491281.0, 6933115.0],
                                [506978.0, 6930086.0],
                                [520591.0, 6933755.0],
                                [524567.0, 6928708.0],
                                [530512.0, 6925008.0],
                                [537794.0, 6926754.0],
                                [548813.0, 6922655.0],
                                [548914.0, 6917432.0],
                                [555352.0, 6907664.0],
                                [558013.0, 6912674.0],
                                [564288.0, 6913853.0],
                                [566281.0, 6917384.0],
                                [574422.0, 6917678.0],
                                [579971.0, 6928884.0],
                                [584841.0, 6929723.0],
                                [596650.0, 6927678.0],
                                [602657.0, 6922993.0],
                                [606642.0, 6924066.0],
                                [610545.0, 6930338.0],
                                [607205.0, 6935073.0],
                                [609123.0, 6937659.0],
                                [606321.0, 6945902.0],
                                [607933.0, 6953359.0],
                                [605401.0, 6955866.0],
                                [612314.0, 6962826.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "76", "NOM_DEPT": "SEINE-MARITIME"},
                    "id": 38,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [823302.0, 6827043.0],
                                [822210.0, 6820200.0],
                                [827022.0, 6811887.0],
                                [834073.0, 6806764.0],
                                [837935.0, 6797546.0],
                                [837598.0, 6783989.0],
                                [835407.0, 6779651.0],
                                [828770.0, 6781171.0],
                                [825768.0, 6776095.0],
                                [827043.0, 6770243.0],
                                [833398.0, 6769005.0],
                                [833316.0, 6764154.0],
                                [838226.0, 6763382.0],
                                [846087.0, 6753627.0],
                                [848388.0, 6746302.0],
                                [846031.0, 6742315.0],
                                [848455.0, 6733791.0],
                                [858300.0, 6729814.0],
                                [863148.0, 6730266.0],
                                [868188.0, 6726357.0],
                                [878352.0, 6725366.0],
                                [880542.0, 6733086.0],
                                [886220.0, 6734507.0],
                                [894824.0, 6733348.0],
                                [901778.0, 6735043.0],
                                [902985.0, 6741752.0],
                                [900414.0, 6745482.0],
                                [901288.0, 6749897.0],
                                [906433.0, 6754603.0],
                                [910900.0, 6755744.0],
                                [915394.0, 6762341.0],
                                [912655.0, 6766332.0],
                                [908017.0, 6765028.0],
                                [906998.0, 6773750.0],
                                [900794.0, 6778635.0],
                                [895837.0, 6779219.0],
                                [899609.0, 6786135.0],
                                [901295.0, 6794520.0],
                                [896020.0, 6796835.0],
                                [883843.0, 6809100.0],
                                [878315.0, 6811920.0],
                                [882722.0, 6816263.0],
                                [873603.0, 6822775.0],
                                [863008.0, 6828766.0],
                                [856191.0, 6834907.0],
                                [852692.0, 6834838.0],
                                [847795.0, 6838972.0],
                                [846365.0, 6844539.0],
                                [840675.0, 6844876.0],
                                [835676.0, 6840415.0],
                                [836281.0, 6837534.0],
                                [830469.0, 6833515.0],
                                [832829.0, 6827018.0],
                                [823302.0, 6827043.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "52", "NOM_DEPT": "HAUTE-MARNE"},
                    "id": 39,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [831641.0, 6353746.0],
                                [824346.0, 6357163.0],
                                [819866.0, 6361270.0],
                                [806518.0, 6360956.0],
                                [802764.0, 6358131.0],
                                [800494.0, 6352553.0],
                                [791158.0, 6357807.0],
                                [783861.0, 6358147.0],
                                [785084.0, 6367917.0],
                                [779411.0, 6373918.0],
                                [775211.0, 6367175.0],
                                [770571.0, 6365836.0],
                                [775941.0, 6359276.0],
                                [773621.0, 6356674.0],
                                [775968.0, 6350322.0],
                                [776174.0, 6341769.0],
                                [768987.0, 6337162.0],
                                [763780.0, 6336809.0],
                                [754256.0, 6342872.0],
                                [750995.0, 6342037.0],
                                [750700.0, 6336169.0],
                                [735189.0, 6336775.0],
                                [729879.0, 6341376.0],
                                [726879.0, 6340020.0],
                                [726344.0, 6331169.0],
                                [736140.0, 6324746.0],
                                [728786.0, 6312824.0],
                                [734096.0, 6312602.0],
                                [742673.0, 6306434.0],
                                [746263.0, 6307559.0],
                                [750088.0, 6313306.0],
                                [758340.0, 6319159.0],
                                [763184.0, 6318967.0],
                                [766255.0, 6313712.0],
                                [766790.0, 6307842.0],
                                [773726.0, 6310049.0],
                                [780634.0, 6301895.0],
                                [792244.0, 6293431.0],
                                [796379.0, 6284647.0],
                                [792922.0, 6276955.0],
                                [788998.0, 6273432.0],
                                [792112.0, 6270978.0],
                                [792074.0, 6265425.0],
                                [799607.0, 6263119.0],
                                [800175.0, 6267290.0],
                                [813903.0, 6274579.0],
                                [815212.0, 6281222.0],
                                [819908.0, 6290041.0],
                                [828463.0, 6288899.0],
                                [833168.0, 6302217.0],
                                [831988.0, 6308980.0],
                                [839658.0, 6315433.0],
                                [847769.0, 6322554.0],
                                [843231.0, 6331183.0],
                                [836689.0, 6335330.0],
                                [837656.0, 6344658.0],
                                [831641.0, 6353746.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "30", "NOM_DEPT": "GARD"},
                    "id": 40,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [1011125.0, 6809400.0],
                                [1016850.0, 6809125.0],
                                [1022638.0, 6802981.0],
                                [1032428.0, 6798669.0],
                                [1032222.0, 6793924.0],
                                [1036067.0, 6790258.0],
                                [1040408.0, 6789869.0],
                                [1046450.0, 6801750.0],
                                [1048508.0, 6811325.0],
                                [1051141.0, 6812923.0],
                                [1050303.0, 6822049.0],
                                [1052109.0, 6831679.0],
                                [1054677.0, 6834498.0],
                                [1054069.0, 6843233.0],
                                [1056359.0, 6848835.0],
                                [1064869.0, 6858273.0],
                                [1065247.0, 6862338.0],
                                [1074008.0, 6868775.0],
                                [1077114.0, 6879387.0],
                                [1081448.0, 6887616.0],
                                [1072364.0, 6888601.0],
                                [1060439.0, 6895482.0],
                                [1055798.0, 6892558.0],
                                [1050607.0, 6895578.0],
                                [1045763.0, 6893084.0],
                                [1038624.0, 6893752.0],
                                [1035096.0, 6882767.0],
                                [1032318.0, 6879884.0],
                                [1025429.0, 6883147.0],
                                [1016790.0, 6880171.0],
                                [1014136.0, 6883372.0],
                                [1005257.0, 6886565.0],
                                [1000174.0, 6890502.0],
                                [996400.0, 6888804.0],
                                [991999.0, 6880708.0],
                                [990508.0, 6874464.0],
                                [996607.0, 6871102.0],
                                [997609.0, 6864713.0],
                                [1002983.0, 6863593.0],
                                [1004387.0, 6868517.0],
                                [1016765.0, 6860562.0],
                                [1012123.0, 6851875.0],
                                [1015426.0, 6846104.0],
                                [1013753.0, 6840510.0],
                                [1007603.0, 6833382.0],
                                [1001023.0, 6834020.0],
                                [1004385.0, 6831654.0],
                                [1003109.0, 6819572.0],
                                [1005338.0, 6811635.0],
                                [1011125.0, 6809400.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "67", "NOM_DEPT": "BAS-RHIN"},
                    "id": 41,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [719561.0, 6234874.0],
                                [716336.0, 6238907.0],
                                [711963.0, 6238657.0],
                                [700385.0, 6243263.0],
                                [700353.0, 6246775.0],
                                [686427.0, 6247043.0],
                                [681495.0, 6239871.0],
                                [667653.0, 6244475.0],
                                [662679.0, 6249784.0],
                                [664821.0, 6258302.0],
                                [654081.0, 6259728.0],
                                [651680.0, 6257911.0],
                                [640013.0, 6262596.0],
                                [637154.0, 6259493.0],
                                [624846.0, 6255615.0],
                                [621363.0, 6260238.0],
                                [611672.0, 6256714.0],
                                [607574.0, 6261192.0],
                                [603060.0, 6255463.0],
                                [603733.0, 6249863.0],
                                [598408.0, 6250205.0],
                                [593467.0, 6242482.0],
                                [596256.0, 6236985.0],
                                [595072.0, 6233132.0],
                                [604330.0, 6228108.0],
                                [614442.0, 6225039.0],
                                [613663.0, 6217624.0],
                                [617210.0, 6214637.0],
                                [617137.0, 6197372.0],
                                [608402.0, 6195450.0],
                                [610538.0, 6185966.0],
                                [614361.0, 6182470.0],
                                [622733.0, 6184536.0],
                                [632373.0, 6176261.0],
                                [631545.0, 6174170.0],
                                [644388.0, 6178927.0],
                                [647326.0, 6181831.0],
                                [644930.0, 6193342.0],
                                [655189.0, 6193206.0],
                                [659825.0, 6194610.0],
                                [675246.0, 6192375.0],
                                [678721.0, 6193157.0],
                                [682753.0, 6199641.0],
                                [688989.0, 6202113.0],
                                [693222.0, 6198384.0],
                                [703560.0, 6193187.0],
                                [704952.0, 6201963.0],
                                [703499.0, 6206754.0],
                                [709550.0, 6222514.0],
                                [719561.0, 6234874.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "11", "NOM_DEPT": "AUDE"},
                    "id": 42,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [695265.0, 6784783.0],
                                [700383.0, 6789702.0],
                                [703237.0, 6796855.0],
                                [703668.0, 6806647.0],
                                [712422.0, 6807964.0],
                                [727042.0, 6808060.0],
                                [730707.0, 6810078.0],
                                [728998.0, 6813854.0],
                                [731262.0, 6826009.0],
                                [737148.0, 6833964.0],
                                [740952.0, 6835710.0],
                                [733915.0, 6839303.0],
                                [735102.0, 6844463.0],
                                [732040.0, 6850473.0],
                                [735603.0, 6861428.0],
                                [729581.0, 6862815.0],
                                [724211.0, 6867685.0],
                                [722321.0, 6872132.0],
                                [712559.0, 6879371.0],
                                [712067.0, 6888882.0],
                                [705248.0, 6890863.0],
                                [700622.0, 6887964.0],
                                [680633.0, 6884542.0],
                                [673222.0, 6889902.0],
                                [670084.0, 6886723.0],
                                [667303.0, 6878971.0],
                                [670882.0, 6870004.0],
                                [667928.0, 6865519.0],
                                [670056.0, 6856451.0],
                                [671600.0, 6851283.0],
                                [668472.0, 6843626.0],
                                [665649.0, 6839786.0],
                                [666363.0, 6833836.0],
                                [663045.0, 6825117.0],
                                [663371.0, 6815578.0],
                                [665496.0, 6812431.0],
                                [657768.0, 6807009.0],
                                [655721.0, 6802434.0],
                                [657236.0, 6795707.0],
                                [663338.0, 6793247.0],
                                [665644.0, 6782354.0],
                                [678166.0, 6780535.0],
                                [685053.0, 6785343.0],
                                [695265.0, 6784783.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "77", "NOM_DEPT": "SEINE-ET-MARNE"},
                    "id": 43,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [706470.0, 6995042.0],
                                [691147.0, 6993758.0],
                                [689814.0, 6997681.0],
                                [669642.0, 7001764.0],
                                [667892.0, 7004913.0],
                                [662547.0, 7004433.0],
                                [658067.0, 7000416.0],
                                [656343.0, 7006536.0],
                                [663948.0, 7010834.0],
                                [660837.0, 7014835.0],
                                [654991.0, 7012592.0],
                                [648121.0, 7014552.0],
                                [635372.0, 7012312.0],
                                [634147.0, 7017146.0],
                                [624801.0, 7021563.0],
                                [622831.0, 7024302.0],
                                [612989.0, 7030025.0],
                                [605232.0, 7026713.0],
                                [603193.0, 7029103.0],
                                [596733.0, 7029014.0],
                                [595668.0, 7021497.0],
                                [599348.0, 7018454.0],
                                [591189.0, 7008466.0],
                                [589294.0, 7002423.0],
                                [583880.0, 6997485.0],
                                [589321.0, 6994349.0],
                                [605014.0, 6980736.0],
                                [608347.0, 6970745.0],
                                [612314.0, 6962826.0],
                                [620154.0, 6956108.0],
                                [623025.0, 6958366.0],
                                [636565.0, 6954687.0],
                                [645659.0, 6956103.0],
                                [654712.0, 6950974.0],
                                [664208.0, 6949037.0],
                                [669006.0, 6944292.0],
                                [676176.0, 6942514.0],
                                [677528.0, 6947426.0],
                                [685504.0, 6946842.0],
                                [685089.0, 6950779.0],
                                [693916.0, 6955962.0],
                                [708546.0, 6956332.0],
                                [705667.0, 6969289.0],
                                [708480.0, 6979518.0],
                                [713833.0, 6986563.0],
                                [712391.0, 6990404.0],
                                [706470.0, 6995042.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "80", "NOM_DEPT": "SOMME"},
                    "id": 44,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [708104.0, 6472781.0],
                                [709251.0, 6464988.0],
                                [717445.0, 6463649.0],
                                [722648.0, 6446835.0],
                                [725628.0, 6444038.0],
                                [723408.0, 6437470.0],
                                [727352.0, 6435060.0],
                                [728488.0, 6430309.0],
                                [732563.0, 6427378.0],
                                [732994.0, 6422485.0],
                                [737614.0, 6413026.0],
                                [746579.0, 6414955.0],
                                [746937.0, 6419760.0],
                                [752090.0, 6419191.0],
                                [752669.0, 6414624.0],
                                [758530.0, 6415778.0],
                                [768276.0, 6405343.0],
                                [774103.0, 6411136.0],
                                [781273.0, 6415520.0],
                                [782106.0, 6419872.0],
                                [791307.0, 6420019.0],
                                [796332.0, 6429870.0],
                                [801638.0, 6433950.0],
                                [808165.0, 6446004.0],
                                [808187.0, 6450395.0],
                                [813436.0, 6450097.0],
                                [816370.0, 6460772.0],
                                [811227.0, 6465007.0],
                                [806856.0, 6463705.0],
                                [807029.0, 6471772.0],
                                [802398.0, 6475469.0],
                                [792166.0, 6477709.0],
                                [780259.0, 6472021.0],
                                [776677.0, 6475557.0],
                                [770263.0, 6473476.0],
                                [763248.0, 6477235.0],
                                [760473.0, 6472496.0],
                                [752222.0, 6475420.0],
                                [749018.0, 6471190.0],
                                [739202.0, 6481030.0],
                                [735734.0, 6477978.0],
                                [722742.0, 6478087.0],
                                [713160.0, 6472555.0],
                                [708104.0, 6472781.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "43", "NOM_DEPT": "HAUTE-LOIRE"},
                    "id": 45,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [776081.0, 6923412.0],
                                [775242.0, 6918312.0],
                                [767112.0, 6923360.0],
                                [761575.0, 6918670.0],
                                [747051.0, 6913033.0],
                                [751361.0, 6898188.0],
                                [745398.0, 6894771.0],
                                [743801.0, 6891376.0],
                                [747254.0, 6882494.0],
                                [744067.0, 6871735.0],
                                [738742.0, 6868146.0],
                                [735603.0, 6861428.0],
                                [732040.0, 6850473.0],
                                [735102.0, 6844463.0],
                                [733915.0, 6839303.0],
                                [740952.0, 6835710.0],
                                [746802.0, 6826973.0],
                                [753955.0, 6826609.0],
                                [760761.0, 6824301.0],
                                [769985.0, 6834113.0],
                                [773768.0, 6840880.0],
                                [779497.0, 6845091.0],
                                [785824.0, 6845891.0],
                                [797551.0, 6845278.0],
                                [796995.0, 6835851.0],
                                [803526.0, 6829924.0],
                                [814106.0, 6826118.0],
                                [819107.0, 6829393.0],
                                [823302.0, 6827043.0],
                                [832829.0, 6827018.0],
                                [830469.0, 6833515.0],
                                [836281.0, 6837534.0],
                                [835676.0, 6840415.0],
                                [840675.0, 6844876.0],
                                [846365.0, 6844539.0],
                                [846329.0, 6850924.0],
                                [838677.0, 6859119.0],
                                [841874.0, 6870868.0],
                                [848655.0, 6874905.0],
                                [848915.0, 6882413.0],
                                [846791.0, 6883540.0],
                                [845429.0, 6892400.0],
                                [841416.0, 6900107.0],
                                [842092.0, 6905887.0],
                                [837898.0, 6908256.0],
                                [833062.0, 6905548.0],
                                [822754.0, 6907655.0],
                                [818364.0, 6905215.0],
                                [814643.0, 6911926.0],
                                [803525.0, 6909934.0],
                                [795010.0, 6915033.0],
                                [790665.0, 6921022.0],
                                [782994.0, 6923346.0],
                                [776081.0, 6923412.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "51", "NOM_DEPT": "MARNE"},
                    "id": 46,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [428954.0, 6200122.0],
                                [442286.0, 6190571.0],
                                [445343.0, 6185147.0],
                                [453012.0, 6180794.0],
                                [468501.0, 6186020.0],
                                [475317.0, 6183479.0],
                                [477861.0, 6178841.0],
                                [483521.0, 6184043.0],
                                [489111.0, 6180226.0],
                                [493119.0, 6181125.0],
                                [491362.0, 6184305.0],
                                [492032.0, 6195420.0],
                                [493715.0, 6200925.0],
                                [501753.0, 6199863.0],
                                [506394.0, 6214104.0],
                                [501199.0, 6216194.0],
                                [498958.0, 6224762.0],
                                [491741.0, 6229153.0],
                                [500952.0, 6237523.0],
                                [501020.0, 6240519.0],
                                [506455.0, 6246240.0],
                                [505760.0, 6248691.0],
                                [496988.0, 6250664.0],
                                [479309.0, 6257879.0],
                                [471536.0, 6256527.0],
                                [468215.0, 6263513.0],
                                [466465.0, 6272970.0],
                                [461941.0, 6273297.0],
                                [457450.0, 6278664.0],
                                [456497.0, 6283051.0],
                                [449863.0, 6280833.0],
                                [454138.0, 6272903.0],
                                [451477.0, 6264635.0],
                                [457777.0, 6262698.0],
                                [452746.0, 6249402.0],
                                [454979.0, 6245934.0],
                                [446410.0, 6236240.0],
                                [443868.0, 6230545.0],
                                [440142.0, 6228799.0],
                                [437107.0, 6220297.0],
                                [431385.0, 6215423.0],
                                [431947.0, 6209367.0],
                                [428150.0, 6207547.0],
                                [428954.0, 6200122.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "65", "NOM_DEPT": "HAUTES-PYRENEES"},
                    "id": 47,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [547193.0, 6388334.0],
                                [542159.0, 6383881.0],
                                [541673.0, 6377661.0],
                                [545774.0, 6366277.0],
                                [549131.0, 6360516.0],
                                [562737.0, 6350024.0],
                                [570617.0, 6348643.0],
                                [581893.0, 6352690.0],
                                [585843.0, 6356520.0],
                                [592401.0, 6355117.0],
                                [596271.0, 6358053.0],
                                [610874.0, 6360746.0],
                                [607709.0, 6375883.0],
                                [615061.0, 6379167.0],
                                [625170.0, 6387538.0],
                                [632813.0, 6386229.0],
                                [637122.0, 6391031.0],
                                [634129.0, 6393565.0],
                                [633003.0, 6406356.0],
                                [634482.0, 6410441.0],
                                [628463.0, 6419614.0],
                                [626129.0, 6431248.0],
                                [613933.0, 6431618.0],
                                [607209.0, 6426078.0],
                                [601475.0, 6429196.0],
                                [593751.0, 6437105.0],
                                [584718.0, 6439628.0],
                                [577774.0, 6436765.0],
                                [574976.0, 6434607.0],
                                [576964.0, 6421036.0],
                                [570522.0, 6417080.0],
                                [570668.0, 6413830.0],
                                [564402.0, 6403210.0],
                                [559319.0, 6399932.0],
                                [553113.0, 6398528.0],
                                [553597.0, 6395079.0],
                                [547193.0, 6388334.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "46", "NOM_DEPT": "LOT"},
                    "id": 48,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [992638.0, 6305621.0],
                                [997097.0, 6315251.0],
                                [1000978.0, 6315262.0],
                                [1007566.0, 6320724.0],
                                [1012050.0, 6317690.0],
                                [1014122.0, 6322114.0],
                                [1009068.0, 6324850.0],
                                [1007601.0, 6328762.0],
                                [1000089.0, 6334256.0],
                                [1000668.0, 6338218.0],
                                [994698.0, 6348019.0],
                                [997268.0, 6357103.0],
                                [1002665.0, 6364730.0],
                                [1009696.0, 6370071.0],
                                [1008626.0, 6382943.0],
                                [1006125.0, 6388590.0],
                                [1012175.0, 6394096.0],
                                [1012913.0, 6402904.0],
                                [1010207.0, 6403290.0],
                                [1004568.0, 6397351.0],
                                [999315.0, 6394909.0],
                                [992592.0, 6389297.0],
                                [988952.0, 6378656.0],
                                [983401.0, 6378221.0],
                                [971476.0, 6380340.0],
                                [967103.0, 6386021.0],
                                [957182.0, 6379131.0],
                                [959705.0, 6373500.0],
                                [957118.0, 6369997.0],
                                [950982.0, 6378672.0],
                                [944316.0, 6377139.0],
                                [935206.0, 6370624.0],
                                [932421.0, 6356788.0],
                                [925339.0, 6357350.0],
                                [930231.0, 6349978.0],
                                [920148.0, 6349530.0],
                                [913873.0, 6347227.0],
                                [911050.0, 6344481.0],
                                [905908.0, 6346585.0],
                                [903520.0, 6340766.0],
                                [899978.0, 6338355.0],
                                [900470.0, 6332559.0],
                                [903879.0, 6328807.0],
                                [901642.0, 6319541.0],
                                [909386.0, 6316209.0],
                                [907367.0, 6306820.0],
                                [913516.0, 6306489.0],
                                [922160.0, 6296144.0],
                                [923991.0, 6299127.0],
                                [933734.0, 6296912.0],
                                [944763.0, 6293054.0],
                                [956283.0, 6301072.0],
                                [958836.0, 6305328.0],
                                [970413.0, 6298787.0],
                                [974848.0, 6301646.0],
                                [974774.0, 6305117.0],
                                [983574.0, 6307147.0],
                                [992638.0, 6305621.0],
                            ]
                        ],
                    },
                    "properties": {
                        "CODE_DEPT": "04",
                        "NOM_DEPT": "ALPES-DE-HAUTE-PROVENCE",
                    },
                    "id": 49,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [521086.0, 6735350.0],
                                [518605.0, 6737439.0],
                                [528757.0, 6745774.0],
                                [533549.0, 6751156.0],
                                [532634.0, 6757689.0],
                                [539183.0, 6762306.0],
                                [535875.0, 6773086.0],
                                [539332.0, 6780273.0],
                                [542578.0, 6786711.0],
                                [536374.0, 6790515.0],
                                [531913.0, 6790043.0],
                                [528051.0, 6796772.0],
                                [517130.0, 6797243.0],
                                [513744.0, 6803794.0],
                                [506061.0, 6806938.0],
                                [505117.0, 6820071.0],
                                [500193.0, 6823412.0],
                                [486746.0, 6818925.0],
                                [482552.0, 6813147.0],
                                [477803.0, 6815005.0],
                                [473893.0, 6813452.0],
                                [467628.0, 6811401.0],
                                [465298.0, 6799724.0],
                                [466280.0, 6794064.0],
                                [458409.0, 6789055.0],
                                [460615.0, 6783387.0],
                                [459373.0, 6778102.0],
                                [451057.0, 6776681.0],
                                [455060.0, 6767070.0],
                                [447308.0, 6764356.0],
                                [448124.0, 6758669.0],
                                [442128.0, 6753611.0],
                                [446459.0, 6750432.0],
                                [446732.0, 6745443.0],
                                [450112.0, 6740918.0],
                                [457617.0, 6739093.0],
                                [460339.0, 6732350.0],
                                [464631.0, 6730466.0],
                                [469484.0, 6733109.0],
                                [474490.0, 6731769.0],
                                [478533.0, 6727039.0],
                                [485937.0, 6723990.0],
                                [491931.0, 6726763.0],
                                [502971.0, 6722018.0],
                                [509057.0, 6729569.0],
                                [515591.0, 6731294.0],
                                [521086.0, 6735350.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "72", "NOM_DEPT": "SARTHE"},
                    "id": 50,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [229520.0, 6710085.0],
                                    [240383.0, 6704696.0],
                                    [240163.0, 6708285.0],
                                    [235835.0, 6713741.0],
                                    [229006.0, 6716339.0],
                                    [229520.0, 6710085.0],
                                ]
                            ],
                            [
                                [
                                    [212687.0, 6770001.0],
                                    [211559.0, 6762660.0],
                                    [216528.0, 6752538.0],
                                    [224759.0, 6753321.0],
                                    [234540.0, 6747533.0],
                                    [234220.0, 6745025.0],
                                    [240082.0, 6736634.0],
                                    [251238.0, 6736509.0],
                                    [260889.0, 6740570.0],
                                    [266327.0, 6740184.0],
                                    [271833.0, 6736526.0],
                                    [269308.0, 6731426.0],
                                    [263161.0, 6733044.0],
                                    [258643.0, 6731063.0],
                                    [263631.0, 6725691.0],
                                    [274085.0, 6728424.0],
                                    [283689.0, 6728526.0],
                                    [290663.0, 6724762.0],
                                    [288997.0, 6719519.0],
                                    [300067.0, 6720583.0],
                                    [315995.0, 6726944.0],
                                    [317487.0, 6738014.0],
                                    [315562.0, 6748257.0],
                                    [318803.0, 6749864.0],
                                    [322365.0, 6758359.0],
                                    [317839.0, 6765781.0],
                                    [320890.0, 6769878.0],
                                    [317014.0, 6776765.0],
                                    [309516.0, 6779524.0],
                                    [306739.0, 6782705.0],
                                    [310549.0, 6787938.0],
                                    [306966.0, 6794650.0],
                                    [300637.0, 6793781.0],
                                    [298204.0, 6799128.0],
                                    [291749.0, 6798375.0],
                                    [285132.0, 6789099.0],
                                    [280665.0, 6785525.0],
                                    [277875.0, 6787107.0],
                                    [279762.0, 6794931.0],
                                    [270150.0, 6795768.0],
                                    [252150.0, 6805897.0],
                                    [246074.0, 6807146.0],
                                    [242780.0, 6802066.0],
                                    [233945.0, 6800703.0],
                                    [229439.0, 6804532.0],
                                    [212675.0, 6807535.0],
                                    [202658.0, 6804638.0],
                                    [202166.0, 6798131.0],
                                    [205220.0, 6785800.0],
                                    [211608.0, 6786141.0],
                                    [216607.0, 6782805.0],
                                    [223352.0, 6780867.0],
                                    [221788.0, 6771592.0],
                                    [212687.0, 6770001.0],
                                ]
                            ],
                        ],
                    },
                    "properties": {"CODE_DEPT": "56", "NOM_DEPT": "MORBIHAN"},
                    "id": 51,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [539112.0, 6843338.0],
                                [541484.0, 6833537.0],
                                [549859.0, 6826656.0],
                                [547706.0, 6812952.0],
                                [543224.0, 6808364.0],
                                [535921.0, 6806758.0],
                                [534094.0, 6803079.0],
                                [538862.0, 6792254.0],
                                [536374.0, 6790515.0],
                                [542578.0, 6786711.0],
                                [539332.0, 6780273.0],
                                [551017.0, 6782681.0],
                                [551727.0, 6777731.0],
                                [559439.0, 6777275.0],
                                [559999.0, 6772636.0],
                                [566408.0, 6764638.0],
                                [573758.0, 6762848.0],
                                [589601.0, 6765689.0],
                                [589165.0, 6770859.0],
                                [595216.0, 6770968.0],
                                [597558.0, 6774986.0],
                                [606511.0, 6774717.0],
                                [615539.0, 6776549.0],
                                [623220.0, 6795517.0],
                                [625387.0, 6798948.0],
                                [624251.0, 6811501.0],
                                [620852.0, 6812073.0],
                                [620311.0, 6818025.0],
                                [611402.0, 6819097.0],
                                [608912.0, 6830618.0],
                                [604791.0, 6831646.0],
                                [597086.0, 6841311.0],
                                [595472.0, 6845570.0],
                                [596554.0, 6858123.0],
                                [594217.0, 6866696.0],
                                [590236.0, 6872273.0],
                                [587701.0, 6866890.0],
                                [579784.0, 6860594.0],
                                [580772.0, 6855857.0],
                                [576482.0, 6852521.0],
                                [566604.0, 6854037.0],
                                [555241.0, 6849633.0],
                                [543803.0, 6848251.0],
                                [539112.0, 6843338.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "28", "NOM_DEPT": "EURE-ET-LOIR"},
                    "id": 52,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [1232225.0, 6105798.0],
                                [1226359.0, 6102880.0],
                                [1217754.0, 6104291.0],
                                [1215715.0, 6123336.0],
                                [1210743.0, 6122769.0],
                                [1206639.0, 6131576.0],
                                [1202519.0, 6133762.0],
                                [1199675.0, 6142105.0],
                                [1187662.0, 6146432.0],
                                [1180116.0, 6152978.0],
                                [1164950.0, 6158109.0],
                                [1159342.0, 6158599.0],
                                [1169805.0, 6146197.0],
                                [1163901.0, 6144874.0],
                                [1160274.0, 6141810.0],
                                [1162433.0, 6134554.0],
                                [1168722.0, 6128275.0],
                                [1172897.0, 6127710.0],
                                [1175910.0, 6121801.0],
                                [1169135.0, 6117789.0],
                                [1170381.0, 6114875.0],
                                [1164715.0, 6111213.0],
                                [1168686.0, 6106658.0],
                                [1175324.0, 6107066.0],
                                [1177911.0, 6109856.0],
                                [1182246.0, 6105577.0],
                                [1180256.0, 6096485.0],
                                [1173562.0, 6088828.0],
                                [1176478.0, 6086334.0],
                                [1193164.0, 6083876.0],
                                [1190373.0, 6079505.0],
                                [1183548.0, 6076443.0],
                                [1183755.0, 6068439.0],
                                [1188281.0, 6067524.0],
                                [1196826.0, 6061810.0],
                                [1209242.0, 6057430.0],
                                [1210610.0, 6054235.0],
                                [1221376.0, 6050136.0],
                                [1221646.0, 6056536.0],
                                [1224377.0, 6061299.0],
                                [1225618.0, 6068574.0],
                                [1229809.0, 6072152.0],
                                [1228158.0, 6078400.0],
                                [1232811.0, 6083356.0],
                                [1233466.0, 6095728.0],
                                [1232225.0, 6105798.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "2A", "NOM_DEPT": "CORSE-DU-SUD"},
                    "id": 53,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [879041.0, 6935896.0],
                                [878534.0, 6930925.0],
                                [883576.0, 6926040.0],
                                [891117.0, 6929633.0],
                                [895087.0, 6927281.0],
                                [898652.0, 6915853.0],
                                [898091.0, 6905220.0],
                                [901547.0, 6903348.0],
                                [900172.0, 6898682.0],
                                [901739.0, 6893315.0],
                                [905859.0, 6891045.0],
                                [906433.0, 6884047.0],
                                [905066.0, 6875501.0],
                                [901302.0, 6871865.0],
                                [904125.0, 6862116.0],
                                [899528.0, 6852809.0],
                                [902927.0, 6847494.0],
                                [903561.0, 6837915.0],
                                [900379.0, 6832469.0],
                                [904895.0, 6830283.0],
                                [904250.0, 6825381.0],
                                [910921.0, 6826770.0],
                                [919362.0, 6809623.0],
                                [930831.0, 6810526.0],
                                [935203.0, 6815546.0],
                                [963830.0, 6819154.0],
                                [964951.0, 6823820.0],
                                [973656.0, 6818945.0],
                                [982282.0, 6817771.0],
                                [987769.0, 6820181.0],
                                [994239.0, 6827289.0],
                                [1004385.0, 6831654.0],
                                [1001023.0, 6834020.0],
                                [993487.0, 6842033.0],
                                [983189.0, 6843093.0],
                                [976380.0, 6847597.0],
                                [971773.0, 6847764.0],
                                [969100.0, 6851558.0],
                                [964692.0, 6852206.0],
                                [961206.0, 6856322.0],
                                [946451.0, 6858744.0],
                                [945024.0, 6864515.0],
                                [939656.0, 6875317.0],
                                [929417.0, 6875078.0],
                                [928151.0, 6878713.0],
                                [922735.0, 6879575.0],
                                [922708.0, 6883240.0],
                                [914442.0, 6889764.0],
                                [914011.0, 6893894.0],
                                [920671.0, 6900380.0],
                                [917676.0, 6905219.0],
                                [920628.0, 6907653.0],
                                [912688.0, 6923499.0],
                                [913390.0, 6932141.0],
                                [909643.0, 6936903.0],
                                [902225.0, 6942685.0],
                                [896580.0, 6941163.0],
                                [892512.0, 6942531.0],
                                [879041.0, 6935896.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "54", "NOM_DEPT": "MEURTHE-ET-MOSELLE"},
                    "id": 54,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [510545.0, 6875400.0],
                                [504730.0, 6874732.0],
                                [500558.0, 6877307.0],
                                [491678.0, 6873174.0],
                                [489675.0, 6876299.0],
                                [484257.0, 6870962.0],
                                [475607.0, 6865852.0],
                                [469104.0, 6863978.0],
                                [457511.0, 6867107.0],
                                [454384.0, 6863198.0],
                                [449827.0, 6868751.0],
                                [446005.0, 6869054.0],
                                [427244.0, 6861949.0],
                                [417723.0, 6857101.0],
                                [420581.0, 6852284.0],
                                [423498.0, 6841841.0],
                                [421619.0, 6835816.0],
                                [414934.0, 6829326.0],
                                [422197.0, 6821752.0],
                                [429868.0, 6822252.0],
                                [437568.0, 6825109.0],
                                [441174.0, 6828584.0],
                                [446687.0, 6829012.0],
                                [451256.0, 6826715.0],
                                [457920.0, 6827997.0],
                                [463434.0, 6833996.0],
                                [466087.0, 6830999.0],
                                [467262.0, 6822174.0],
                                [474394.0, 6821359.0],
                                [473893.0, 6813452.0],
                                [477803.0, 6815005.0],
                                [482552.0, 6813147.0],
                                [486746.0, 6818925.0],
                                [500193.0, 6823412.0],
                                [505117.0, 6820071.0],
                                [506061.0, 6806938.0],
                                [513744.0, 6803794.0],
                                [517130.0, 6797243.0],
                                [528051.0, 6796772.0],
                                [531913.0, 6790043.0],
                                [536374.0, 6790515.0],
                                [538862.0, 6792254.0],
                                [534094.0, 6803079.0],
                                [535921.0, 6806758.0],
                                [543224.0, 6808364.0],
                                [547706.0, 6812952.0],
                                [549859.0, 6826656.0],
                                [541484.0, 6833537.0],
                                [539112.0, 6843338.0],
                                [533024.0, 6847407.0],
                                [536389.0, 6850906.0],
                                [533488.0, 6856087.0],
                                [524600.0, 6861683.0],
                                [520512.0, 6866728.0],
                                [513552.0, 6867418.0],
                                [508448.0, 6870995.0],
                                [510545.0, 6875400.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "61", "NOM_DEPT": "ORNE"},
                    "id": 55,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [877344.0, 6596683.0],
                                [869949.0, 6598870.0],
                                [868758.0, 6603264.0],
                                [857422.0, 6600366.0],
                                [848718.0, 6603737.0],
                                [845229.0, 6595067.0],
                                [845050.0, 6590960.0],
                                [839484.0, 6574938.0],
                                [837322.0, 6565642.0],
                                [838741.0, 6561678.0],
                                [835220.0, 6556428.0],
                                [834501.0, 6551198.0],
                                [835850.0, 6543054.0],
                                [833933.0, 6540287.0],
                                [844536.0, 6535588.0],
                                [849404.0, 6524528.0],
                                [863140.0, 6525920.0],
                                [870291.0, 6521483.0],
                                [876089.0, 6523611.0],
                                [879159.0, 6530984.0],
                                [882529.0, 6534232.0],
                                [888996.0, 6528631.0],
                                [888123.0, 6525941.0],
                                [897998.0, 6515860.0],
                                [904449.0, 6504924.0],
                                [909413.0, 6509006.0],
                                [910338.0, 6515974.0],
                                [915868.0, 6518199.0],
                                [916332.0, 6528631.0],
                                [919315.0, 6541572.0],
                                [917441.0, 6547210.0],
                                [916992.0, 6555432.0],
                                [918731.0, 6560168.0],
                                [928176.0, 6563414.0],
                                [933670.0, 6575392.0],
                                [940629.0, 6577110.0],
                                [938817.0, 6580823.0],
                                [943610.0, 6590224.0],
                                [935280.0, 6595262.0],
                                [929573.0, 6589336.0],
                                [923919.0, 6580132.0],
                                [919460.0, 6577537.0],
                                [909869.0, 6577050.0],
                                [908880.0, 6582354.0],
                                [903737.0, 6585593.0],
                                [895736.0, 6577631.0],
                                [890444.0, 6576892.0],
                                [887558.0, 6582363.0],
                                [882486.0, 6586333.0],
                                [882664.0, 6589574.0],
                                [877221.0, 6593352.0],
                                [877344.0, 6596683.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "01", "NOM_DEPT": "AIN"},
                    "id": 56,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [524704.0, 6194181.0],
                                [530246.0, 6189977.0],
                                [542336.0, 6189236.0],
                                [549247.0, 6180805.0],
                                [554894.0, 6182516.0],
                                [562658.0, 6181937.0],
                                [567864.0, 6177510.0],
                                [571419.0, 6168649.0],
                                [580902.0, 6173997.0],
                                [585134.0, 6170835.0],
                                [592180.0, 6170254.0],
                                [600206.0, 6164532.0],
                                [607482.0, 6165290.0],
                                [615529.0, 6169131.0],
                                [617954.0, 6174066.0],
                                [631545.0, 6174170.0],
                                [632373.0, 6176261.0],
                                [622733.0, 6184536.0],
                                [614361.0, 6182470.0],
                                [610538.0, 6185966.0],
                                [608402.0, 6195450.0],
                                [617137.0, 6197372.0],
                                [617210.0, 6214637.0],
                                [613663.0, 6217624.0],
                                [614442.0, 6225039.0],
                                [604330.0, 6228108.0],
                                [595072.0, 6233132.0],
                                [596256.0, 6236985.0],
                                [593467.0, 6242482.0],
                                [589272.0, 6240503.0],
                                [582028.0, 6242918.0],
                                [575081.0, 6235814.0],
                                [572065.0, 6240985.0],
                                [565565.0, 6247682.0],
                                [561407.0, 6244405.0],
                                [567825.0, 6236309.0],
                                [562910.0, 6233771.0],
                                [555809.0, 6233248.0],
                                [554118.0, 6225953.0],
                                [547328.0, 6230443.0],
                                [541984.0, 6228895.0],
                                [540236.0, 6224348.0],
                                [535770.0, 6220735.0],
                                [537386.0, 6214080.0],
                                [535012.0, 6210452.0],
                                [526458.0, 6208824.0],
                                [522873.0, 6204718.0],
                                [524704.0, 6194181.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "09", "NOM_DEPT": "ARIEGE"},
                    "id": 57,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [563452.0, 6484264.0],
                                [563844.0, 6479160.0],
                                [568750.0, 6477311.0],
                                [560988.0, 6465186.0],
                                [564865.0, 6461779.0],
                                [566113.0, 6450433.0],
                                [573095.0, 6446142.0],
                                [577774.0, 6436765.0],
                                [584718.0, 6439628.0],
                                [593751.0, 6437105.0],
                                [601475.0, 6429196.0],
                                [607209.0, 6426078.0],
                                [613933.0, 6431618.0],
                                [626129.0, 6431248.0],
                                [631663.0, 6432186.0],
                                [628772.0, 6440050.0],
                                [634831.0, 6442812.0],
                                [638218.0, 6451518.0],
                                [636846.0, 6458269.0],
                                [642886.0, 6465907.0],
                                [649118.0, 6470007.0],
                                [651369.0, 6479623.0],
                                [656321.0, 6476249.0],
                                [659915.0, 6480065.0],
                                [661594.0, 6486680.0],
                                [662264.0, 6494997.0],
                                [658322.0, 6500286.0],
                                [662164.0, 6504560.0],
                                [663288.0, 6509261.0],
                                [660507.0, 6515469.0],
                                [656101.0, 6511235.0],
                                [649366.0, 6512420.0],
                                [648450.0, 6509221.0],
                                [637278.0, 6511373.0],
                                [635791.0, 6515072.0],
                                [631053.0, 6514297.0],
                                [623634.0, 6517796.0],
                                [614305.0, 6511565.0],
                                [612121.0, 6507862.0],
                                [605337.0, 6509707.0],
                                [593766.0, 6498788.0],
                                [587429.0, 6495459.0],
                                [581471.0, 6497412.0],
                                [576059.0, 6493313.0],
                                [571080.0, 6486618.0],
                                [566212.0, 6489282.0],
                                [563452.0, 6484264.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "19", "NOM_DEPT": "CORREZE"},
                    "id": 58,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [987691.0, 6753958.0],
                                [989189.0, 6749828.0],
                                [1000830.0, 6745745.0],
                                [1003510.0, 6737902.0],
                                [1000706.0, 6731961.0],
                                [1006958.0, 6729298.0],
                                [1010786.0, 6719537.0],
                                [1014326.0, 6713511.0],
                                [1019985.0, 6711034.0],
                                [1024064.0, 6712992.0],
                                [1031730.0, 6713160.0],
                                [1039126.0, 6720266.0],
                                [1038581.0, 6725392.0],
                                [1044459.0, 6729657.0],
                                [1044908.0, 6732411.0],
                                [1039238.0, 6738821.0],
                                [1038337.0, 6743276.0],
                                [1040672.0, 6747502.0],
                                [1039113.0, 6752662.0],
                                [1040418.0, 6763108.0],
                                [1044697.0, 6773634.0],
                                [1040564.0, 6779861.0],
                                [1040408.0, 6789869.0],
                                [1036067.0, 6790258.0],
                                [1032222.0, 6793924.0],
                                [1032428.0, 6798669.0],
                                [1022638.0, 6802981.0],
                                [1016850.0, 6809125.0],
                                [1011125.0, 6809400.0],
                                [1006708.0, 6801985.0],
                                [1001795.0, 6789636.0],
                                [998205.0, 6776671.0],
                                [993983.0, 6773739.0],
                                [991355.0, 6761730.0],
                                [993060.0, 6757264.0],
                                [987691.0, 6753958.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "68", "NOM_DEPT": "HAUT-RHIN"},
                    "id": 59,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [573297.0, 6677558.0],
                                [569696.0, 6685244.0],
                                [565759.0, 6689706.0],
                                [561058.0, 6687382.0],
                                [557051.0, 6690388.0],
                                [558309.0, 6696538.0],
                                [557303.0, 6702930.0],
                                [559271.0, 6706788.0],
                                [552945.0, 6716389.0],
                                [555366.0, 6719856.0],
                                [552256.0, 6724799.0],
                                [543743.0, 6727862.0],
                                [539386.0, 6732046.0],
                                [530153.0, 6735215.0],
                                [521086.0, 6735350.0],
                                [515591.0, 6731294.0],
                                [509057.0, 6729569.0],
                                [502971.0, 6722018.0],
                                [491931.0, 6726763.0],
                                [489539.0, 6719725.0],
                                [490772.0, 6714971.0],
                                [487846.0, 6706491.0],
                                [479254.0, 6691029.0],
                                [476861.0, 6677880.0],
                                [478404.0, 6673399.0],
                                [482922.0, 6672972.0],
                                [485608.0, 6667284.0],
                                [494947.0, 6665028.0],
                                [494833.0, 6656131.0],
                                [505157.0, 6650870.0],
                                [510389.0, 6653999.0],
                                [517389.0, 6653506.0],
                                [515158.0, 6658631.0],
                                [524608.0, 6655240.0],
                                [525272.0, 6647330.0],
                                [531658.0, 6641492.0],
                                [533123.0, 6635020.0],
                                [537221.0, 6629765.0],
                                [546519.0, 6631001.0],
                                [551779.0, 6655211.0],
                                [553982.0, 6659068.0],
                                [560408.0, 6661557.0],
                                [568878.0, 6661167.0],
                                [571950.0, 6667671.0],
                                [576079.0, 6670370.0],
                                [573297.0, 6677558.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "37", "NOM_DEPT": "INDRE-ET-LOIRE"},
                    "id": 60,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [634422.0, 7101577.0],
                                [636514.0, 7100652.0],
                                [642453.0, 7087769.0],
                                [644454.0, 7079622.0],
                                [653390.0, 7071778.0],
                                [658064.0, 7064147.0],
                                [664277.0, 7059477.0],
                                [673807.0, 7057943.0],
                                [679720.0, 7059405.0],
                                [683642.0, 7063001.0],
                                [688698.0, 7062196.0],
                                [686184.0, 7056263.0],
                                [687641.0, 7047582.0],
                                [692820.0, 7044918.0],
                                [697493.0, 7046164.0],
                                [701478.0, 7042709.0],
                                [702680.0, 7038239.0],
                                [699507.0, 7031355.0],
                                [712383.0, 7015916.0],
                                [711164.0, 7009522.0],
                                [706855.0, 7002888.0],
                                [706470.0, 6995042.0],
                                [712391.0, 6990404.0],
                                [716534.0, 6992565.0],
                                [720100.0, 6990781.0],
                                [725313.0, 6993104.0],
                                [735248.0, 6991264.0],
                                [739058.0, 6995179.0],
                                [744014.0, 6992056.0],
                                [751253.0, 6997000.0],
                                [753505.0, 6995276.0],
                                [766237.0, 6992385.0],
                                [770359.0, 6988977.0],
                                [778060.0, 6986162.0],
                                [781905.0, 6987282.0],
                                [783321.0, 6995122.0],
                                [788006.0, 6997129.0],
                                [785882.0, 7004302.0],
                                [780654.0, 7004663.0],
                                [782919.0, 7012216.0],
                                [787237.0, 7018342.0],
                                [781127.0, 7020183.0],
                                [773958.0, 7027731.0],
                                [768979.0, 7028494.0],
                                [763439.0, 7026158.0],
                                [760772.0, 7028536.0],
                                [753265.0, 7028386.0],
                                [749524.0, 7024442.0],
                                [746894.0, 7030603.0],
                                [747241.0, 7039722.0],
                                [743565.0, 7044070.0],
                                [733656.0, 7048580.0],
                                [726572.0, 7043892.0],
                                [720348.0, 7047849.0],
                                [717610.0, 7060148.0],
                                [718286.0, 7067127.0],
                                [713527.0, 7069761.0],
                                [710740.0, 7076212.0],
                                [704337.0, 7075998.0],
                                [695621.0, 7071968.0],
                                [692807.0, 7066387.0],
                                [686789.0, 7068929.0],
                                [680050.0, 7079722.0],
                                [674224.0, 7079651.0],
                                [671748.0, 7084186.0],
                                [674131.0, 7094505.0],
                                [670178.0, 7102078.0],
                                [667909.0, 7110430.0],
                                [659576.0, 7106814.0],
                                [654175.0, 7107325.0],
                                [637372.0, 7101244.0],
                                [634422.0, 7101577.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "59", "NOM_DEPT": "NORD"},
                    "id": 61,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [1010786.0, 6719537.0],
                                [1006958.0, 6729298.0],
                                [1000706.0, 6731961.0],
                                [1003510.0, 6737902.0],
                                [1000830.0, 6745745.0],
                                [989189.0, 6749828.0],
                                [987691.0, 6753958.0],
                                [986052.0, 6752778.0],
                                [981470.0, 6745308.0],
                                [983826.0, 6731782.0],
                                [986155.0, 6724947.0],
                                [993651.0, 6723596.0],
                                [994087.0, 6717743.0],
                                [996902.0, 6711079.0],
                                [1001194.0, 6713400.0],
                                [999772.0, 6717889.0],
                                [1007028.0, 6717766.0],
                                [1010786.0, 6719537.0],
                            ]
                        ],
                    },
                    "properties": {
                        "CODE_DEPT": "90",
                        "NOM_DEPT": "TERRITOIRE DE BELFORT",
                    },
                    "id": 62,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [382163.0, 6750361.0],
                                [374291.0, 6753124.0],
                                [371672.0, 6756673.0],
                                [356172.0, 6751743.0],
                                [351165.0, 6744974.0],
                                [342268.0, 6743932.0],
                                [335469.0, 6745297.0],
                                [327477.0, 6743723.0],
                                [317487.0, 6738014.0],
                                [315995.0, 6726944.0],
                                [300067.0, 6720583.0],
                                [288997.0, 6719519.0],
                                [282806.0, 6712695.0],
                                [283678.0, 6703214.0],
                                [288393.0, 6698809.0],
                                [292251.0, 6700736.0],
                                [299211.0, 6695249.0],
                                [308160.0, 6699576.0],
                                [309828.0, 6691500.0],
                                [308860.0, 6686791.0],
                                [304084.0, 6683183.0],
                                [316935.0, 6678247.0],
                                [322009.0, 6670666.0],
                                [324590.0, 6666698.0],
                                [332678.0, 6659222.0],
                                [338731.0, 6658583.0],
                                [343129.0, 6653969.0],
                                [353671.0, 6649968.0],
                                [357453.0, 6652400.0],
                                [354064.0, 6663454.0],
                                [354394.0, 6667534.0],
                                [359840.0, 6669393.0],
                                [361112.0, 6656907.0],
                                [367588.0, 6659427.0],
                                [367645.0, 6668175.0],
                                [374065.0, 6668782.0],
                                [376108.0, 6673611.0],
                                [385082.0, 6667087.0],
                                [387784.0, 6670618.0],
                                [379298.0, 6676338.0],
                                [379159.0, 6679552.0],
                                [384839.0, 6683588.0],
                                [382659.0, 6691801.0],
                                [378391.0, 6691949.0],
                                [374867.0, 6698071.0],
                                [375470.0, 6701871.0],
                                [385609.0, 6704471.0],
                                [396890.0, 6703794.0],
                                [402393.0, 6705897.0],
                                [401401.0, 6717774.0],
                                [387234.0, 6720426.0],
                                [386462.0, 6727467.0],
                                [395905.0, 6725901.0],
                                [398982.0, 6728603.0],
                                [389301.0, 6732485.0],
                                [386987.0, 6740963.0],
                                [381255.0, 6745617.0],
                                [382163.0, 6750361.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "44", "NOM_DEPT": "LOIRE-ATLANTIQUE"},
                    "id": 63,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [698236.0, 6718784.0],
                                [701928.0, 6717598.0],
                                [707666.0, 6720847.0],
                                [709181.0, 6715638.0],
                                [715400.0, 6713642.0],
                                [717731.0, 6709895.0],
                                [723118.0, 6710529.0],
                                [726085.0, 6708066.0],
                                [729904.0, 6712131.0],
                                [736733.0, 6710509.0],
                                [738638.0, 6714270.0],
                                [743712.0, 6710994.0],
                                [743701.0, 6707332.0],
                                [751168.0, 6705240.0],
                                [753904.0, 6700965.0],
                                [759265.0, 6699206.0],
                                [773240.0, 6698003.0],
                                [773484.0, 6692940.0],
                                [783517.0, 6693799.0],
                                [780393.0, 6701310.0],
                                [784360.0, 6705398.0],
                                [783952.0, 6713331.0],
                                [788376.0, 6717645.0],
                                [791050.0, 6725986.0],
                                [795163.0, 6731989.0],
                                [794312.0, 6737086.0],
                                [799827.0, 6740411.0],
                                [799053.0, 6750471.0],
                                [794318.0, 6750026.0],
                                [796594.0, 6759156.0],
                                [789480.0, 6763963.0],
                                [783028.0, 6759096.0],
                                [767353.0, 6760249.0],
                                [763413.0, 6765164.0],
                                [759917.0, 6778325.0],
                                [755033.0, 6785741.0],
                                [749678.0, 6782304.0],
                                [746161.0, 6791892.0],
                                [745765.0, 6796957.0],
                                [736893.0, 6807760.0],
                                [730707.0, 6810078.0],
                                [727042.0, 6808060.0],
                                [712422.0, 6807964.0],
                                [703668.0, 6806647.0],
                                [703237.0, 6796855.0],
                                [700383.0, 6789702.0],
                                [695265.0, 6784783.0],
                                [702192.0, 6781427.0],
                                [703759.0, 6774663.0],
                                [706580.0, 6772621.0],
                                [709585.0, 6763406.0],
                                [703743.0, 6756785.0],
                                [700769.0, 6756036.0],
                                [701782.0, 6742907.0],
                                [695135.0, 6740319.0],
                                [689262.0, 6740069.0],
                                [689391.0, 6734632.0],
                                [694231.0, 6731133.0],
                                [695341.0, 6722058.0],
                                [698236.0, 6718784.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "89", "NOM_DEPT": "YONNE"},
                    "id": 64,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [330825.0, 6841252.0],
                                    [328251.0, 6849310.0],
                                    [322500.0, 6846053.0],
                                    [325749.0, 6841751.0],
                                    [330825.0, 6841252.0],
                                ]
                            ],
                            [
                                [
                                    [399495.0, 6830885.0],
                                    [389634.0, 6835155.0],
                                    [384742.0, 6834496.0],
                                    [376536.0, 6826525.0],
                                    [368413.0, 6830443.0],
                                    [366767.0, 6839135.0],
                                    [363309.0, 6845999.0],
                                    [348952.0, 6844300.0],
                                    [343084.0, 6846084.0],
                                    [341341.0, 6849649.0],
                                    [342875.0, 6855953.0],
                                    [334395.0, 6854417.0],
                                    [329772.0, 6850320.0],
                                    [334969.0, 6837949.0],
                                    [337450.0, 6835570.0],
                                    [332923.0, 6813386.0],
                                    [328273.0, 6809495.0],
                                    [325505.0, 6811765.0],
                                    [320973.0, 6806998.0],
                                    [315234.0, 6806646.0],
                                    [311879.0, 6798427.0],
                                    [306966.0, 6794650.0],
                                    [310549.0, 6787938.0],
                                    [306739.0, 6782705.0],
                                    [309516.0, 6779524.0],
                                    [317014.0, 6776765.0],
                                    [320890.0, 6769878.0],
                                    [317839.0, 6765781.0],
                                    [322365.0, 6758359.0],
                                    [318803.0, 6749864.0],
                                    [315562.0, 6748257.0],
                                    [317487.0, 6738014.0],
                                    [327477.0, 6743723.0],
                                    [335469.0, 6745297.0],
                                    [342268.0, 6743932.0],
                                    [351165.0, 6744974.0],
                                    [356172.0, 6751743.0],
                                    [371672.0, 6756673.0],
                                    [374291.0, 6753124.0],
                                    [382163.0, 6750361.0],
                                    [382932.0, 6754022.0],
                                    [386941.0, 6760260.0],
                                    [390140.0, 6770978.0],
                                    [394099.0, 6773357.0],
                                    [400197.0, 6773697.0],
                                    [400465.0, 6781914.0],
                                    [398626.0, 6784333.0],
                                    [395852.0, 6803336.0],
                                    [400321.0, 6810723.0],
                                    [398130.0, 6822559.0],
                                    [399495.0, 6830885.0],
                                ]
                            ],
                        ],
                    },
                    "properties": {"CODE_DEPT": "35", "NOM_DEPT": "ILLE-ET-VILAINE"},
                    "id": 65,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [334283.0, 6280551.0],
                                [338238.0, 6281381.0],
                                [342731.0, 6276517.0],
                                [352961.0, 6276001.0],
                                [362964.0, 6280741.0],
                                [367753.0, 6276986.0],
                                [377063.0, 6275535.0],
                                [385124.0, 6280151.0],
                                [394475.0, 6281218.0],
                                [399714.0, 6278404.0],
                                [403447.0, 6281078.0],
                                [412501.0, 6278002.0],
                                [421554.0, 6283529.0],
                                [424830.0, 6280287.0],
                                [433057.0, 6279053.0],
                                [438084.0, 6281592.0],
                                [439499.0, 6295895.0],
                                [442698.0, 6298315.0],
                                [443572.0, 6313646.0],
                                [440195.0, 6315550.0],
                                [444807.0, 6320573.0],
                                [453303.0, 6321029.0],
                                [461632.0, 6315722.0],
                                [465239.0, 6317398.0],
                                [465465.0, 6324803.0],
                                [464468.0, 6326808.0],
                                [467874.0, 6336236.0],
                                [470769.0, 6340294.0],
                                [462757.0, 6341305.0],
                                [459734.0, 6343570.0],
                                [449759.0, 6344226.0],
                                [449164.0, 6352477.0],
                                [445091.0, 6357381.0],
                                [442465.0, 6350467.0],
                                [438523.0, 6349285.0],
                                [429214.0, 6351421.0],
                                [430077.0, 6359927.0],
                                [426389.0, 6364119.0],
                                [419635.0, 6366255.0],
                                [418928.0, 6369127.0],
                                [411174.0, 6373203.0],
                                [411314.0, 6378206.0],
                                [403228.0, 6378937.0],
                                [393973.0, 6376334.0],
                                [388231.0, 6379327.0],
                                [381182.0, 6379048.0],
                                [383562.0, 6383958.0],
                                [375548.0, 6389853.0],
                                [373686.0, 6386677.0],
                                [361774.0, 6383396.0],
                                [355175.0, 6347840.0],
                                [348748.0, 6322487.0],
                                [342546.0, 6300215.0],
                                [341177.0, 6292691.0],
                                [334283.0, 6280551.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "40", "NOM_DEPT": "LANDES"},
                    "id": 66,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [210124.0, 6860562.0],
                                [210319.0, 6864435.0],
                                [197918.0, 6867491.0],
                                [195168.0, 6863087.0],
                                [188759.0, 6861699.0],
                                [187283.0, 6866983.0],
                                [171676.0, 6866983.0],
                                [165007.0, 6863478.0],
                                [159513.0, 6866951.0],
                                [150836.0, 6862294.0],
                                [143559.0, 6862620.0],
                                [137993.0, 6858007.0],
                                [130421.0, 6856362.0],
                                [126410.0, 6849458.0],
                                [124277.0, 6841317.0],
                                [126191.0, 6836271.0],
                                [137035.0, 6831319.0],
                                [151215.0, 6836632.0],
                                [149516.0, 6831882.0],
                                [159712.0, 6829829.0],
                                [158800.0, 6824711.0],
                                [152925.0, 6822802.0],
                                [150196.0, 6824902.0],
                                [139593.0, 6825317.0],
                                [139209.0, 6819312.0],
                                [147794.0, 6818873.0],
                                [158225.0, 6812964.0],
                                [159803.0, 6806301.0],
                                [156741.0, 6801688.0],
                                [151961.0, 6804475.0],
                                [143250.0, 6802653.0],
                                [129762.0, 6802135.0],
                                [125302.0, 6798484.0],
                                [144750.0, 6790824.0],
                                [150552.0, 6779953.0],
                                [149596.0, 6769606.0],
                                [162294.0, 6768615.0],
                                [164959.0, 6774152.0],
                                [171525.0, 6775493.0],
                                [174013.0, 6772980.0],
                                [183941.0, 6774809.0],
                                [184280.0, 6770949.0],
                                [191411.0, 6764941.0],
                                [196633.0, 6766198.0],
                                [200244.0, 6762976.0],
                                [211251.0, 6761104.0],
                                [212687.0, 6770001.0],
                                [221788.0, 6771592.0],
                                [223352.0, 6780867.0],
                                [216607.0, 6782805.0],
                                [211608.0, 6786141.0],
                                [205220.0, 6785800.0],
                                [202166.0, 6798131.0],
                                [202658.0, 6804638.0],
                                [212675.0, 6807535.0],
                                [216996.0, 6817941.0],
                                [214652.0, 6824074.0],
                                [215204.0, 6828740.0],
                                [213034.0, 6834627.0],
                                [212655.0, 6842190.0],
                                [216761.0, 6846809.0],
                                [210382.0, 6855067.0],
                                [210124.0, 6860562.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "29", "NOM_DEPT": "FINISTERE"},
                    "id": 67,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [995359.0, 6526975.0],
                                [996263.0, 6533312.0],
                                [1005620.0, 6535079.0],
                                [1009539.0, 6537663.0],
                                [1013275.0, 6543845.0],
                                [1010939.0, 6550631.0],
                                [1005414.0, 6557665.0],
                                [1000587.0, 6561265.0],
                                [1000913.0, 6565514.0],
                                [994423.0, 6565990.0],
                                [993170.0, 6574229.0],
                                [997429.0, 6583180.0],
                                [990846.0, 6588853.0],
                                [991547.0, 6595136.0],
                                [985884.0, 6596474.0],
                                [972312.0, 6594423.0],
                                [960663.0, 6587846.0],
                                [955674.0, 6591075.0],
                                [952150.0, 6588701.0],
                                [949250.0, 6580383.0],
                                [953939.0, 6574878.0],
                                [949136.0, 6572391.0],
                                [944956.0, 6566962.0],
                                [928176.0, 6563414.0],
                                [918731.0, 6560168.0],
                                [916992.0, 6555432.0],
                                [917441.0, 6547210.0],
                                [919315.0, 6541572.0],
                                [921730.0, 6540986.0],
                                [922988.0, 6530552.0],
                                [926213.0, 6526897.0],
                                [936560.0, 6520059.0],
                                [946066.0, 6522280.0],
                                [948121.0, 6516633.0],
                                [952091.0, 6514710.0],
                                [959117.0, 6516128.0],
                                [962862.0, 6525460.0],
                                [965836.0, 6528299.0],
                                [969073.0, 6537583.0],
                                [971940.0, 6540371.0],
                                [975690.0, 6531451.0],
                                [979688.0, 6528135.0],
                                [984284.0, 6528734.0],
                                [988618.0, 6520489.0],
                                [995359.0, 6526975.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "74", "NOM_DEPT": "HAUTE-SAVOIE"},
                    "id": 68,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [605624.0, 6904387.0],
                                [608283.0, 6898554.0],
                                [612180.0, 6899061.0],
                                [618689.0, 6896449.0],
                                [626847.0, 6897876.0],
                                [633020.0, 6901508.0],
                                [645465.0, 6895048.0],
                                [649761.0, 6898738.0],
                                [652314.0, 6895981.0],
                                [659205.0, 6894147.0],
                                [670084.0, 6886723.0],
                                [673222.0, 6889902.0],
                                [680633.0, 6884542.0],
                                [700622.0, 6887964.0],
                                [705248.0, 6890863.0],
                                [710189.0, 6894765.0],
                                [704672.0, 6899225.0],
                                [701957.0, 6908433.0],
                                [698137.0, 6911415.0],
                                [706929.0, 6919738.0],
                                [706805.0, 6926038.0],
                                [711648.0, 6928031.0],
                                [706939.0, 6934901.0],
                                [709520.0, 6938240.0],
                                [707064.0, 6950845.0],
                                [708546.0, 6956332.0],
                                [693916.0, 6955962.0],
                                [685089.0, 6950779.0],
                                [685504.0, 6946842.0],
                                [677528.0, 6947426.0],
                                [676176.0, 6942514.0],
                                [669006.0, 6944292.0],
                                [664208.0, 6949037.0],
                                [654712.0, 6950974.0],
                                [645659.0, 6956103.0],
                                [636565.0, 6954687.0],
                                [623025.0, 6958366.0],
                                [620154.0, 6956108.0],
                                [612314.0, 6962826.0],
                                [605401.0, 6955866.0],
                                [607933.0, 6953359.0],
                                [606321.0, 6945902.0],
                                [609123.0, 6937659.0],
                                [607205.0, 6935073.0],
                                [610545.0, 6930338.0],
                                [606642.0, 6924066.0],
                                [609871.0, 6919444.0],
                                [610931.0, 6911811.0],
                                [606128.0, 6907968.0],
                                [605624.0, 6904387.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "60", "NOM_DEPT": "OISE"},
                    "id": 69,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [598361.0, 6887345.0],
                                [603102.0, 6887292.0],
                                [606678.0, 6883543.0],
                                [614076.0, 6886919.0],
                                [622312.0, 6880731.0],
                                [628641.0, 6878089.0],
                                [633062.0, 6879807.0],
                                [641836.0, 6872490.0],
                                [641404.0, 6867928.0],
                                [648071.0, 6872567.0],
                                [653619.0, 6875101.0],
                                [660416.0, 6872923.0],
                                [667303.0, 6878971.0],
                                [670084.0, 6886723.0],
                                [659205.0, 6894147.0],
                                [652314.0, 6895981.0],
                                [649761.0, 6898738.0],
                                [645465.0, 6895048.0],
                                [633020.0, 6901508.0],
                                [626847.0, 6897876.0],
                                [618689.0, 6896449.0],
                                [612180.0, 6899061.0],
                                [608283.0, 6898554.0],
                                [605624.0, 6904387.0],
                                [603501.0, 6902160.0],
                                [601892.0, 6893098.0],
                                [598361.0, 6887345.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "95", "NOM_DEPT": "VAL-D'OISE"},
                    "id": 70,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [783517.0, 6693799.0],
                                [773484.0, 6692940.0],
                                [773240.0, 6698003.0],
                                [759265.0, 6699206.0],
                                [753904.0, 6700965.0],
                                [751168.0, 6705240.0],
                                [743701.0, 6707332.0],
                                [743712.0, 6710994.0],
                                [738638.0, 6714270.0],
                                [736733.0, 6710509.0],
                                [729904.0, 6712131.0],
                                [726085.0, 6708066.0],
                                [723118.0, 6710529.0],
                                [717731.0, 6709895.0],
                                [715400.0, 6713642.0],
                                [709181.0, 6715638.0],
                                [707666.0, 6720847.0],
                                [701928.0, 6717598.0],
                                [698236.0, 6718784.0],
                                [693556.0, 6718403.0],
                                [690565.0, 6713347.0],
                                [694642.0, 6704915.0],
                                [690449.0, 6694237.0],
                                [698745.0, 6684384.0],
                                [698614.0, 6680189.0],
                                [702129.0, 6669867.0],
                                [701762.0, 6662486.0],
                                [705753.0, 6657660.0],
                                [706033.0, 6650549.0],
                                [703828.0, 6645606.0],
                                [705186.0, 6641947.0],
                                [702446.0, 6632753.0],
                                [703745.0, 6628663.0],
                                [716475.0, 6620334.0],
                                [720608.0, 6624106.0],
                                [726499.0, 6620539.0],
                                [733164.0, 6623625.0],
                                [737251.0, 6617690.0],
                                [742042.0, 6624120.0],
                                [748049.0, 6627896.0],
                                [756196.0, 6628301.0],
                                [760920.0, 6622686.0],
                                [770503.0, 6626941.0],
                                [775685.0, 6631211.0],
                                [781064.0, 6632682.0],
                                [780490.0, 6638662.0],
                                [783308.0, 6642195.0],
                                [778932.0, 6646959.0],
                                [779000.0, 6654397.0],
                                [781374.0, 6662136.0],
                                [778810.0, 6664936.0],
                                [780471.0, 6669516.0],
                                [784602.0, 6669828.0],
                                [789554.0, 6672918.0],
                                [791663.0, 6673495.0],
                                [793165.0, 6678355.0],
                                [789098.0, 6683996.0],
                                [785899.0, 6682517.0],
                                [783517.0, 6693799.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "58", "NOM_DEPT": "NIEVRE"},
                    "id": 71,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [871408.0, 6655745.0],
                                [875449.0, 6660099.0],
                                [876191.0, 6666228.0],
                                [881002.0, 6667371.0],
                                [884880.0, 6674426.0],
                                [887407.0, 6682465.0],
                                [888032.0, 6690633.0],
                                [890265.0, 6692353.0],
                                [884919.0, 6701062.0],
                                [880595.0, 6713705.0],
                                [884206.0, 6713509.0],
                                [887785.0, 6718944.0],
                                [886108.0, 6726069.0],
                                [882147.0, 6728546.0],
                                [878352.0, 6725366.0],
                                [868188.0, 6726357.0],
                                [863148.0, 6730266.0],
                                [858300.0, 6729814.0],
                                [848455.0, 6733791.0],
                                [846031.0, 6742315.0],
                                [848388.0, 6746302.0],
                                [846087.0, 6753627.0],
                                [838226.0, 6763382.0],
                                [833316.0, 6764154.0],
                                [833398.0, 6769005.0],
                                [827043.0, 6770243.0],
                                [817962.0, 6771080.0],
                                [816397.0, 6764598.0],
                                [808147.0, 6762855.0],
                                [797692.0, 6763119.0],
                                [796594.0, 6759156.0],
                                [794318.0, 6750026.0],
                                [799053.0, 6750471.0],
                                [799827.0, 6740411.0],
                                [794312.0, 6737086.0],
                                [795163.0, 6731989.0],
                                [791050.0, 6725986.0],
                                [788376.0, 6717645.0],
                                [783952.0, 6713331.0],
                                [784360.0, 6705398.0],
                                [780393.0, 6701310.0],
                                [783517.0, 6693799.0],
                                [785899.0, 6682517.0],
                                [789098.0, 6683996.0],
                                [793165.0, 6678355.0],
                                [791663.0, 6673495.0],
                                [795506.0, 6668991.0],
                                [806631.0, 6665548.0],
                                [806754.0, 6662035.0],
                                [813434.0, 6659755.0],
                                [823470.0, 6650227.0],
                                [831500.0, 6648015.0],
                                [855755.0, 6655507.0],
                                [860161.0, 6652754.0],
                                [871408.0, 6655745.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "21", "NOM_DEPT": "COTE-D'OR"},
                    "id": 72,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [643163.0, 6853168.0],
                                [634691.0, 6849194.0],
                                [632440.0, 6843248.0],
                                [627800.0, 6838438.0],
                                [627504.0, 6829048.0],
                                [623768.0, 6826369.0],
                                [620311.0, 6818025.0],
                                [620852.0, 6812073.0],
                                [624251.0, 6811501.0],
                                [625387.0, 6798948.0],
                                [639308.0, 6801806.0],
                                [653275.0, 6801114.0],
                                [655721.0, 6802434.0],
                                [657768.0, 6807009.0],
                                [665496.0, 6812431.0],
                                [663371.0, 6815578.0],
                                [663045.0, 6825117.0],
                                [666363.0, 6833836.0],
                                [665649.0, 6839786.0],
                                [668472.0, 6843626.0],
                                [663488.0, 6848458.0],
                                [653706.0, 6846856.0],
                                [650056.0, 6850064.0],
                                [643163.0, 6853168.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "91", "NOM_DEPT": "ESSONNE"},
                    "id": 73,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [483517.0, 6558927.0],
                                [485043.0, 6563684.0],
                                [480502.0, 6565882.0],
                                [477460.0, 6571967.0],
                                [478920.0, 6578170.0],
                                [482897.0, 6584792.0],
                                [479925.0, 6587264.0],
                                [475179.0, 6582497.0],
                                [472141.0, 6584899.0],
                                [472081.0, 6590232.0],
                                [468300.0, 6594579.0],
                                [467690.0, 6607234.0],
                                [472374.0, 6614809.0],
                                [467588.0, 6622657.0],
                                [470952.0, 6628365.0],
                                [469757.0, 6639127.0],
                                [471018.0, 6649618.0],
                                [465537.0, 6662685.0],
                                [464624.0, 6667352.0],
                                [458546.0, 6672434.0],
                                [454238.0, 6672319.0],
                                [442005.0, 6668948.0],
                                [434893.0, 6670550.0],
                                [429925.0, 6668493.0],
                                [429262.0, 6663802.0],
                                [424993.0, 6661094.0],
                                [417889.0, 6660618.0],
                                [413368.0, 6662854.0],
                                [404251.0, 6660135.0],
                                [408792.0, 6655192.0],
                                [411920.0, 6644974.0],
                                [417892.0, 6640888.0],
                                [415662.0, 6636435.0],
                                [420740.0, 6628764.0],
                                [421344.0, 6621760.0],
                                [423543.0, 6619698.0],
                                [424018.0, 6609992.0],
                                [422851.0, 6601758.0],
                                [420470.0, 6597142.0],
                                [428213.0, 6593481.0],
                                [426574.0, 6590996.0],
                                [411453.0, 6585116.0],
                                [411065.0, 6578554.0],
                                [415606.0, 6575464.0],
                                [420640.0, 6566176.0],
                                [426299.0, 6566639.0],
                                [429269.0, 6562335.0],
                                [437311.0, 6559539.0],
                                [446458.0, 6558600.0],
                                [459784.0, 6545825.0],
                                [464645.0, 6548283.0],
                                [465641.0, 6555184.0],
                                [469589.0, 6554692.0],
                                [473907.0, 6559092.0],
                                [483517.0, 6558927.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "79", "NOM_DEPT": "DEUX-SEVRES"},
                    "id": 74,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [306966.0, 6794650.0],
                                [311879.0, 6798427.0],
                                [315234.0, 6806646.0],
                                [320973.0, 6806998.0],
                                [325505.0, 6811765.0],
                                [328273.0, 6809495.0],
                                [332923.0, 6813386.0],
                                [337450.0, 6835570.0],
                                [334969.0, 6837949.0],
                                [330825.0, 6841252.0],
                                [325749.0, 6841751.0],
                                [322500.0, 6846053.0],
                                [319331.0, 6843417.0],
                                [315059.0, 6845536.0],
                                [309156.0, 6855461.0],
                                [296913.0, 6849790.0],
                                [284640.0, 6841250.0],
                                [280881.0, 6840740.0],
                                [271227.0, 6848399.0],
                                [271155.0, 6854763.0],
                                [262910.0, 6863924.0],
                                [263482.0, 6867351.0],
                                [257346.0, 6869777.0],
                                [251930.0, 6880323.0],
                                [243322.0, 6881073.0],
                                [228138.0, 6874463.0],
                                [222446.0, 6879145.0],
                                [216642.0, 6872989.0],
                                [215941.0, 6861279.0],
                                [210124.0, 6860562.0],
                                [210382.0, 6855067.0],
                                [216761.0, 6846809.0],
                                [212655.0, 6842190.0],
                                [213034.0, 6834627.0],
                                [215204.0, 6828740.0],
                                [214652.0, 6824074.0],
                                [216996.0, 6817941.0],
                                [212675.0, 6807535.0],
                                [229439.0, 6804532.0],
                                [233945.0, 6800703.0],
                                [242780.0, 6802066.0],
                                [246074.0, 6807146.0],
                                [252150.0, 6805897.0],
                                [270150.0, 6795768.0],
                                [279762.0, 6794931.0],
                                [277875.0, 6787107.0],
                                [280665.0, 6785525.0],
                                [285132.0, 6789099.0],
                                [291749.0, 6798375.0],
                                [298204.0, 6799128.0],
                                [300637.0, 6793781.0],
                                [306966.0, 6794650.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "22", "NOM_DEPT": "COTES-D'ARMOR"},
                    "id": 75,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [702446.0, 6632753.0],
                                [696943.0, 6633749.0],
                                [686837.0, 6626145.0],
                                [682775.0, 6624336.0],
                                [677474.0, 6626628.0],
                                [669145.0, 6615318.0],
                                [670500.0, 6605989.0],
                                [664479.0, 6602292.0],
                                [660370.0, 6603761.0],
                                [650317.0, 6601560.0],
                                [645179.0, 6595086.0],
                                [644784.0, 6591412.0],
                                [647921.0, 6581264.0],
                                [653217.0, 6581299.0],
                                [659880.0, 6575828.0],
                                [662729.0, 6571178.0],
                                [666451.0, 6560450.0],
                                [672252.0, 6557694.0],
                                [679424.0, 6569309.0],
                                [685369.0, 6566281.0],
                                [688886.0, 6572856.0],
                                [695157.0, 6571452.0],
                                [693029.0, 6567076.0],
                                [697819.0, 6557998.0],
                                [712873.0, 6551781.0],
                                [728730.0, 6550656.0],
                                [732386.0, 6552810.0],
                                [735860.0, 6546571.0],
                                [745523.0, 6547324.0],
                                [753779.0, 6537018.0],
                                [754888.0, 6541809.0],
                                [761084.0, 6541876.0],
                                [763887.0, 6544360.0],
                                [762385.0, 6549859.0],
                                [763504.0, 6554575.0],
                                [760949.0, 6561975.0],
                                [762003.0, 6573092.0],
                                [769267.0, 6575508.0],
                                [775913.0, 6580395.0],
                                [775079.0, 6589273.0],
                                [776586.0, 6596649.0],
                                [773476.0, 6599308.0],
                                [768312.0, 6598303.0],
                                [763922.0, 6603795.0],
                                [761463.0, 6602522.0],
                                [756931.0, 6607772.0],
                                [753291.0, 6618069.0],
                                [748734.0, 6623209.0],
                                [748049.0, 6627896.0],
                                [742042.0, 6624120.0],
                                [737251.0, 6617690.0],
                                [733164.0, 6623625.0],
                                [726499.0, 6620539.0],
                                [720608.0, 6624106.0],
                                [716475.0, 6620334.0],
                                [703745.0, 6628663.0],
                                [702446.0, 6632753.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "03", "NOM_DEPT": "ALLIER"},
                    "id": 76,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [365341.0, 6575902.0],
                                    [359213.0, 6576771.0],
                                    [352445.0, 6583031.0],
                                    [350494.0, 6577212.0],
                                    [356155.0, 6576636.0],
                                    [364082.0, 6571051.0],
                                    [365341.0, 6575902.0],
                                ]
                            ],
                            [
                                [
                                    [373352.0, 6542832.0],
                                    [371342.0, 6552252.0],
                                    [366346.0, 6552808.0],
                                    [362447.0, 6556836.0],
                                    [360591.0, 6548506.0],
                                    [369260.0, 6539881.0],
                                    [371124.0, 6531592.0],
                                    [374437.0, 6534213.0],
                                    [375330.0, 6540510.0],
                                    [373352.0, 6542832.0],
                                ]
                            ],
                            [
                                [
                                    [464807.0, 6459164.0],
                                    [461242.0, 6465553.0],
                                    [455660.0, 6465791.0],
                                    [456356.0, 6470307.0],
                                    [447267.0, 6474282.0],
                                    [443202.0, 6478722.0],
                                    [445861.0, 6484044.0],
                                    [444696.0, 6489309.0],
                                    [446521.0, 6493231.0],
                                    [442913.0, 6501478.0],
                                    [436951.0, 6506668.0],
                                    [434607.0, 6512022.0],
                                    [434480.0, 6521530.0],
                                    [445866.0, 6528260.0],
                                    [449713.0, 6524677.0],
                                    [455132.0, 6526680.0],
                                    [458386.0, 6534878.0],
                                    [457303.0, 6539406.0],
                                    [459784.0, 6545825.0],
                                    [446458.0, 6558600.0],
                                    [437311.0, 6559539.0],
                                    [429269.0, 6562335.0],
                                    [426299.0, 6566639.0],
                                    [420640.0, 6566176.0],
                                    [415606.0, 6575464.0],
                                    [411065.0, 6578554.0],
                                    [411453.0, 6585116.0],
                                    [404775.0, 6589452.0],
                                    [397324.0, 6586760.0],
                                    [391500.0, 6591809.0],
                                    [382360.0, 6587238.0],
                                    [383479.0, 6581738.0],
                                    [376439.0, 6576760.0],
                                    [374243.0, 6571617.0],
                                    [381511.0, 6566597.0],
                                    [386552.0, 6553761.0],
                                    [382858.0, 6551653.0],
                                    [385303.0, 6547012.0],
                                    [378912.0, 6532887.0],
                                    [370510.0, 6529071.0],
                                    [370474.0, 6520657.0],
                                    [379564.0, 6513624.0],
                                    [387626.0, 6509256.0],
                                    [386164.0, 6505245.0],
                                    [399796.0, 6489042.0],
                                    [404682.0, 6481482.0],
                                    [406100.0, 6476140.0],
                                    [418478.0, 6475494.0],
                                    [421098.0, 6472770.0],
                                    [431214.0, 6470295.0],
                                    [433418.0, 6457450.0],
                                    [437492.0, 6457585.0],
                                    [444096.0, 6451365.0],
                                    [452009.0, 6448234.0],
                                    [457280.0, 6451647.0],
                                    [460931.0, 6449393.0],
                                    [464807.0, 6459164.0],
                                ]
                            ],
                        ],
                    },
                    "properties": {"CODE_DEPT": "17", "NOM_DEPT": "CHARENTE-MARITIME"},
                    "id": 77,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [728488.0, 6430309.0],
                                [727352.0, 6435060.0],
                                [723408.0, 6437470.0],
                                [725628.0, 6444038.0],
                                [722648.0, 6446835.0],
                                [717445.0, 6463649.0],
                                [709251.0, 6464988.0],
                                [708104.0, 6472781.0],
                                [701310.0, 6465307.0],
                                [695974.0, 6467752.0],
                                [693859.0, 6474045.0],
                                [688449.0, 6477003.0],
                                [677684.0, 6475835.0],
                                [672750.0, 6482640.0],
                                [661594.0, 6486680.0],
                                [659915.0, 6480065.0],
                                [656321.0, 6476249.0],
                                [651369.0, 6479623.0],
                                [649118.0, 6470007.0],
                                [642886.0, 6465907.0],
                                [636846.0, 6458269.0],
                                [638218.0, 6451518.0],
                                [634831.0, 6442812.0],
                                [628772.0, 6440050.0],
                                [631663.0, 6432186.0],
                                [626129.0, 6431248.0],
                                [628463.0, 6419614.0],
                                [634482.0, 6410441.0],
                                [633003.0, 6406356.0],
                                [634129.0, 6393565.0],
                                [637122.0, 6391031.0],
                                [637228.0, 6394175.0],
                                [646639.0, 6396959.0],
                                [655192.0, 6393469.0],
                                [664849.0, 6402561.0],
                                [665404.0, 6408608.0],
                                [668313.0, 6410487.0],
                                [668604.0, 6416079.0],
                                [676829.0, 6423158.0],
                                [679353.0, 6426925.0],
                                [684359.0, 6419403.0],
                                [688126.0, 6419157.0],
                                [690477.0, 6411547.0],
                                [694820.0, 6408897.0],
                                [693924.0, 6403282.0],
                                [698547.0, 6393953.0],
                                [704864.0, 6413115.0],
                                [707862.0, 6414941.0],
                                [708330.0, 6420849.0],
                                [714401.0, 6418301.0],
                                [719705.0, 6424147.0],
                                [728488.0, 6430309.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "15", "NOM_DEPT": "CANTAL"},
                    "id": 78,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [664821.0, 6258302.0],
                                [662679.0, 6249784.0],
                                [667653.0, 6244475.0],
                                [681495.0, 6239871.0],
                                [686427.0, 6247043.0],
                                [700353.0, 6246775.0],
                                [700385.0, 6243263.0],
                                [711963.0, 6238657.0],
                                [716336.0, 6238907.0],
                                [719561.0, 6234874.0],
                                [727933.0, 6241307.0],
                                [734945.0, 6243544.0],
                                [741504.0, 6241707.0],
                                [748880.0, 6250885.0],
                                [753675.0, 6255020.0],
                                [764523.0, 6260540.0],
                                [773373.0, 6269062.0],
                                [781738.0, 6273121.0],
                                [788998.0, 6273432.0],
                                [792922.0, 6276955.0],
                                [796379.0, 6284647.0],
                                [792244.0, 6293431.0],
                                [780634.0, 6301895.0],
                                [773726.0, 6310049.0],
                                [766790.0, 6307842.0],
                                [766255.0, 6313712.0],
                                [763184.0, 6318967.0],
                                [758340.0, 6319159.0],
                                [750088.0, 6313306.0],
                                [746263.0, 6307559.0],
                                [742673.0, 6306434.0],
                                [734096.0, 6312602.0],
                                [728786.0, 6312824.0],
                                [722102.0, 6311077.0],
                                [716344.0, 6301672.0],
                                [704815.0, 6303628.0],
                                [704898.0, 6288229.0],
                                [698819.0, 6289943.0],
                                [694796.0, 6288406.0],
                                [693221.0, 6284557.0],
                                [680178.0, 6279485.0],
                                [676690.0, 6282993.0],
                                [671212.0, 6283521.0],
                                [668935.0, 6274250.0],
                                [672394.0, 6269695.0],
                                [672444.0, 6264623.0],
                                [668090.0, 6259189.0],
                                [664821.0, 6258302.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "34", "NOM_DEPT": "HERAULT"},
                    "id": 79,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [921863.0, 6404787.0],
                                [918546.0, 6403480.0],
                                [907889.0, 6409384.0],
                                [894862.0, 6413405.0],
                                [895949.0, 6427870.0],
                                [895595.0, 6439026.0],
                                [892767.0, 6444271.0],
                                [888053.0, 6440277.0],
                                [871457.0, 6445038.0],
                                [871909.0, 6454823.0],
                                [870728.0, 6463360.0],
                                [866406.0, 6463235.0],
                                [860939.0, 6470947.0],
                                [855768.0, 6473591.0],
                                [847361.0, 6468209.0],
                                [841110.0, 6468164.0],
                                [842390.0, 6453321.0],
                                [844782.0, 6435636.0],
                                [848816.0, 6428161.0],
                                [844069.0, 6414766.0],
                                [839715.0, 6410394.0],
                                [841041.0, 6396655.0],
                                [835764.0, 6388411.0],
                                [834538.0, 6384016.0],
                                [835151.0, 6374038.0],
                                [832713.0, 6371581.0],
                                [831614.0, 6360351.0],
                                [840525.0, 6360052.0],
                                [843837.0, 6356928.0],
                                [844895.0, 6349809.0],
                                [864358.0, 6358713.0],
                                [871547.0, 6356009.0],
                                [872115.0, 6350341.0],
                                [890550.0, 6347548.0],
                                [890601.0, 6342463.0],
                                [894810.0, 6342254.0],
                                [899978.0, 6338355.0],
                                [903520.0, 6340766.0],
                                [905908.0, 6346585.0],
                                [911050.0, 6344481.0],
                                [913873.0, 6347227.0],
                                [914428.0, 6355637.0],
                                [911254.0, 6355549.0],
                                [909816.0, 6362305.0],
                                [898744.0, 6362932.0],
                                [892505.0, 6372493.0],
                                [899815.0, 6380077.0],
                                [907085.0, 6377469.0],
                                [909000.0, 6384874.0],
                                [906293.0, 6386082.0],
                                [910174.0, 6394503.0],
                                [921214.0, 6398819.0],
                                [921863.0, 6404787.0],
                            ],
                            [
                                [850837.0, 6364673.0],
                                [852761.0, 6369494.0],
                                [856829.0, 6372215.0],
                                [860545.0, 6368019.0],
                                [860544.0, 6360615.0],
                                [857850.0, 6357360.0],
                                [850729.0, 6357929.0],
                                [850837.0, 6364673.0],
                            ],
                        ],
                    },
                    "properties": {"CODE_DEPT": "26", "NOM_DEPT": "DROME"},
                    "id": 80,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [600206.0, 6164532.0],
                                [597209.0, 6163462.0],
                                [595443.0, 6155896.0],
                                [604042.0, 6154257.0],
                                [614139.0, 6147692.0],
                                [616327.0, 6140765.0],
                                [624388.0, 6140739.0],
                                [630462.0, 6147428.0],
                                [638840.0, 6149005.0],
                                [653442.0, 6143379.0],
                                [657322.0, 6137875.0],
                                [662029.0, 6137190.0],
                                [665163.0, 6139863.0],
                                [672907.0, 6137962.0],
                                [673207.0, 6145058.0],
                                [679658.0, 6147303.0],
                                [683451.0, 6146537.0],
                                [686936.0, 6150974.0],
                                [703357.0, 6152588.0],
                                [707042.0, 6147292.0],
                                [714275.0, 6148346.0],
                                [710994.0, 6157024.0],
                                [704080.0, 6161154.0],
                                [702907.0, 6175403.0],
                                [703560.0, 6193187.0],
                                [693222.0, 6198384.0],
                                [688989.0, 6202113.0],
                                [682753.0, 6199641.0],
                                [678721.0, 6193157.0],
                                [675246.0, 6192375.0],
                                [659825.0, 6194610.0],
                                [655189.0, 6193206.0],
                                [644930.0, 6193342.0],
                                [647326.0, 6181831.0],
                                [644388.0, 6178927.0],
                                [631545.0, 6174170.0],
                                [617954.0, 6174066.0],
                                [615529.0, 6169131.0],
                                [607482.0, 6165290.0],
                                [600206.0, 6164532.0],
                            ]
                        ],
                    },
                    "properties": {
                        "CODE_DEPT": "66",
                        "NOM_DEPT": "PYRENEES-ORIENTALES",
                    },
                    "id": 81,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [956276.0, 6452799.0],
                                [964422.0, 6450656.0],
                                [967061.0, 6446025.0],
                                [974349.0, 6445704.0],
                                [973771.0, 6449910.0],
                                [985382.0, 6452122.0],
                                [989157.0, 6455721.0],
                                [995952.0, 6458223.0],
                                [1002558.0, 6454919.0],
                                [1011443.0, 6464355.0],
                                [1024403.0, 6470318.0],
                                [1021887.0, 6478062.0],
                                [1027167.0, 6487344.0],
                                [1021485.0, 6490016.0],
                                [1020210.0, 6493869.0],
                                [1012252.0, 6497350.0],
                                [1011518.0, 6512378.0],
                                [1006337.0, 6512917.0],
                                [997830.0, 6518696.0],
                                [995359.0, 6526975.0],
                                [988618.0, 6520489.0],
                                [984284.0, 6528734.0],
                                [979688.0, 6528135.0],
                                [975690.0, 6531451.0],
                                [971940.0, 6540371.0],
                                [969073.0, 6537583.0],
                                [965836.0, 6528299.0],
                                [962862.0, 6525460.0],
                                [959117.0, 6516128.0],
                                [952091.0, 6514710.0],
                                [948121.0, 6516633.0],
                                [946066.0, 6522280.0],
                                [936560.0, 6520059.0],
                                [926213.0, 6526897.0],
                                [922988.0, 6530552.0],
                                [921730.0, 6540986.0],
                                [919315.0, 6541572.0],
                                [916332.0, 6528631.0],
                                [915868.0, 6518199.0],
                                [910338.0, 6515974.0],
                                [909413.0, 6509006.0],
                                [904449.0, 6504924.0],
                                [913763.0, 6489603.0],
                                [917457.0, 6486189.0],
                                [925224.0, 6482705.0],
                                [931624.0, 6492445.0],
                                [938381.0, 6486658.0],
                                [943964.0, 6486985.0],
                                [948557.0, 6482085.0],
                                [949441.0, 6473761.0],
                                [945461.0, 6470305.0],
                                [945165.0, 6465401.0],
                                [950505.0, 6456663.0],
                                [956276.0, 6452799.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "73", "NOM_DEPT": "SAVOIE"},
                    "id": 82,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [921863.0, 6404787.0],
                                [921214.0, 6398819.0],
                                [910174.0, 6394503.0],
                                [906293.0, 6386082.0],
                                [909000.0, 6384874.0],
                                [907085.0, 6377469.0],
                                [899815.0, 6380077.0],
                                [892505.0, 6372493.0],
                                [898744.0, 6362932.0],
                                [909816.0, 6362305.0],
                                [911254.0, 6355549.0],
                                [914428.0, 6355637.0],
                                [913873.0, 6347227.0],
                                [920148.0, 6349530.0],
                                [930231.0, 6349978.0],
                                [925339.0, 6357350.0],
                                [932421.0, 6356788.0],
                                [935206.0, 6370624.0],
                                [944316.0, 6377139.0],
                                [950982.0, 6378672.0],
                                [957118.0, 6369997.0],
                                [959705.0, 6373500.0],
                                [957182.0, 6379131.0],
                                [967103.0, 6386021.0],
                                [971476.0, 6380340.0],
                                [983401.0, 6378221.0],
                                [988952.0, 6378656.0],
                                [992592.0, 6389297.0],
                                [999315.0, 6394909.0],
                                [1004568.0, 6397351.0],
                                [1010207.0, 6403290.0],
                                [1012913.0, 6402904.0],
                                [1015781.0, 6406977.0],
                                [1022960.0, 6406318.0],
                                [1016213.0, 6418043.0],
                                [1016501.0, 6423604.0],
                                [1010607.0, 6425833.0],
                                [1004832.0, 6424533.0],
                                [995855.0, 6430156.0],
                                [996598.0, 6437292.0],
                                [994575.0, 6442256.0],
                                [989294.0, 6442329.0],
                                [985382.0, 6452122.0],
                                [973771.0, 6449910.0],
                                [974349.0, 6445704.0],
                                [967061.0, 6446025.0],
                                [964422.0, 6450656.0],
                                [956276.0, 6452799.0],
                                [953909.0, 6450690.0],
                                [952342.0, 6439924.0],
                                [961377.0, 6439340.0],
                                [964872.0, 6432532.0],
                                [965006.0, 6422921.0],
                                [960775.0, 6424797.0],
                                [956742.0, 6422339.0],
                                [947667.0, 6423241.0],
                                [941569.0, 6417648.0],
                                [939410.0, 6420031.0],
                                [933177.0, 6416064.0],
                                [930672.0, 6410433.0],
                                [925560.0, 6409806.0],
                                [921863.0, 6404787.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "05", "NOM_DEPT": "HAUTES-ALPES"},
                    "id": 83,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [850837.0, 6364673.0],
                                    [850729.0, 6357929.0],
                                    [857850.0, 6357360.0],
                                    [860544.0, 6360615.0],
                                    [860545.0, 6368019.0],
                                    [856829.0, 6372215.0],
                                    [852761.0, 6369494.0],
                                    [850837.0, 6364673.0],
                                ]
                            ],
                            [
                                [
                                    [839658.0, 6315433.0],
                                    [848847.0, 6314233.0],
                                    [858049.0, 6310039.0],
                                    [863255.0, 6305296.0],
                                    [865136.0, 6300908.0],
                                    [876282.0, 6295340.0],
                                    [879627.0, 6296831.0],
                                    [886796.0, 6295631.0],
                                    [896706.0, 6289935.0],
                                    [904218.0, 6287715.0],
                                    [910307.0, 6287877.0],
                                    [921881.0, 6295602.0],
                                    [922160.0, 6296144.0],
                                    [913516.0, 6306489.0],
                                    [907367.0, 6306820.0],
                                    [909386.0, 6316209.0],
                                    [901642.0, 6319541.0],
                                    [903879.0, 6328807.0],
                                    [900470.0, 6332559.0],
                                    [899978.0, 6338355.0],
                                    [894810.0, 6342254.0],
                                    [890601.0, 6342463.0],
                                    [890550.0, 6347548.0],
                                    [872115.0, 6350341.0],
                                    [871547.0, 6356009.0],
                                    [864358.0, 6358713.0],
                                    [844895.0, 6349809.0],
                                    [843837.0, 6356928.0],
                                    [840525.0, 6360052.0],
                                    [831614.0, 6360351.0],
                                    [831641.0, 6353746.0],
                                    [837656.0, 6344658.0],
                                    [836689.0, 6335330.0],
                                    [843231.0, 6331183.0],
                                    [847769.0, 6322554.0],
                                    [839658.0, 6315433.0],
                                ]
                            ],
                        ],
                    },
                    "properties": {"CODE_DEPT": "84", "NOM_DEPT": "VAUCLUSE"},
                    "id": 84,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [636090.0, 6591904.0],
                                [634893.0, 6595681.0],
                                [638969.0, 6598575.0],
                                [635550.0, 6606712.0],
                                [637665.0, 6611745.0],
                                [634340.0, 6622075.0],
                                [628673.0, 6627353.0],
                                [632500.0, 6630848.0],
                                [627496.0, 6637025.0],
                                [633457.0, 6642556.0],
                                [629301.0, 6648616.0],
                                [631131.0, 6657674.0],
                                [627981.0, 6660408.0],
                                [627833.0, 6667741.0],
                                [621646.0, 6669974.0],
                                [615265.0, 6667454.0],
                                [607114.0, 6670785.0],
                                [612309.0, 6675948.0],
                                [612147.0, 6680536.0],
                                [602149.0, 6685865.0],
                                [593597.0, 6687211.0],
                                [582631.0, 6683116.0],
                                [573297.0, 6677558.0],
                                [576079.0, 6670370.0],
                                [571950.0, 6667671.0],
                                [568878.0, 6661167.0],
                                [560408.0, 6661557.0],
                                [553982.0, 6659068.0],
                                [551779.0, 6655211.0],
                                [546519.0, 6631001.0],
                                [537221.0, 6629765.0],
                                [541431.0, 6623495.0],
                                [538906.0, 6616112.0],
                                [542426.0, 6611026.0],
                                [547958.0, 6609437.0],
                                [557842.0, 6602380.0],
                                [558128.0, 6596023.0],
                                [562773.0, 6594026.0],
                                [559931.0, 6588729.0],
                                [569564.0, 6587075.0],
                                [573702.0, 6590223.0],
                                [578129.0, 6584256.0],
                                [586530.0, 6592902.0],
                                [595863.0, 6588324.0],
                                [602234.0, 6588456.0],
                                [609355.0, 6592908.0],
                                [622684.0, 6592821.0],
                                [630016.0, 6590287.0],
                                [636090.0, 6591904.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "36", "NOM_DEPT": "INDRE"},
                    "id": 85,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [1232225.0, 6105798.0],
                                [1232233.0, 6116272.0],
                                [1242213.0, 6134033.0],
                                [1241272.0, 6154177.0],
                                [1238247.0, 6164499.0],
                                [1238682.0, 6169952.0],
                                [1236764.0, 6182904.0],
                                [1228823.0, 6195229.0],
                                [1228376.0, 6197858.0],
                                [1231051.0, 6211355.0],
                                [1228846.0, 6218876.0],
                                [1227050.0, 6231255.0],
                                [1223421.0, 6233783.0],
                                [1216996.0, 6231337.0],
                                [1218749.0, 6222752.0],
                                [1215986.0, 6213431.0],
                                [1218915.0, 6209217.0],
                                [1219580.0, 6202912.0],
                                [1215962.0, 6195537.0],
                                [1212393.0, 6200184.0],
                                [1205077.0, 6201621.0],
                                [1198634.0, 6198671.0],
                                [1193909.0, 6190462.0],
                                [1183050.0, 6187935.0],
                                [1176939.0, 6184145.0],
                                [1176781.0, 6180877.0],
                                [1165934.0, 6173994.0],
                                [1165800.0, 6162888.0],
                                [1161943.0, 6162734.0],
                                [1159342.0, 6158599.0],
                                [1164950.0, 6158109.0],
                                [1180116.0, 6152978.0],
                                [1187662.0, 6146432.0],
                                [1199675.0, 6142105.0],
                                [1202519.0, 6133762.0],
                                [1206639.0, 6131576.0],
                                [1210743.0, 6122769.0],
                                [1215715.0, 6123336.0],
                                [1217754.0, 6104291.0],
                                [1226359.0, 6102880.0],
                                [1232225.0, 6105798.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "2B", "NOM_DEPT": "HAUTE-CORSE"},
                    "id": 86,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [563452.0, 6484264.0],
                                [566212.0, 6489282.0],
                                [571080.0, 6486618.0],
                                [576059.0, 6493313.0],
                                [581471.0, 6497412.0],
                                [587429.0, 6495459.0],
                                [593766.0, 6498788.0],
                                [605337.0, 6509707.0],
                                [612121.0, 6507862.0],
                                [614305.0, 6511565.0],
                                [612524.0, 6515422.0],
                                [613074.0, 6522626.0],
                                [604752.0, 6527760.0],
                                [597279.0, 6527024.0],
                                [591561.0, 6529605.0],
                                [592200.0, 6538029.0],
                                [586335.0, 6540289.0],
                                [587795.0, 6549437.0],
                                [580656.0, 6565605.0],
                                [574730.0, 6569689.0],
                                [580236.0, 6579624.0],
                                [578129.0, 6584256.0],
                                [573702.0, 6590223.0],
                                [569564.0, 6587075.0],
                                [559931.0, 6588729.0],
                                [556218.0, 6586207.0],
                                [548271.0, 6584464.0],
                                [546474.0, 6577615.0],
                                [538896.0, 6578287.0],
                                [530127.0, 6570272.0],
                                [531964.0, 6561069.0],
                                [531290.0, 6552122.0],
                                [539507.0, 6547743.0],
                                [540666.0, 6541823.0],
                                [534383.0, 6537804.0],
                                [527825.0, 6527023.0],
                                [522669.0, 6525452.0],
                                [522412.0, 6520738.0],
                                [515635.0, 6515544.0],
                                [526849.0, 6509996.0],
                                [524801.0, 6504583.0],
                                [529342.0, 6499739.0],
                                [539039.0, 6503445.0],
                                [546900.0, 6501981.0],
                                [553144.0, 6489340.0],
                                [563452.0, 6484264.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "87", "NOM_DEPT": "HAUTE-VIENNE"},
                    "id": 87,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "MultiPolygon",
                        "coordinates": [
                            [
                                [
                                    [297360.0, 6667914.0],
                                    [299985.0, 6664525.0],
                                    [303823.0, 6669495.0],
                                    [298725.0, 6671705.0],
                                    [297360.0, 6667914.0],
                                ]
                            ],
                            [
                                [
                                    [322009.0, 6670666.0],
                                    [318317.0, 6668787.0],
                                    [315194.0, 6662103.0],
                                    [307861.0, 6656132.0],
                                    [308108.0, 6649020.0],
                                    [322518.0, 6633220.0],
                                    [328569.0, 6623483.0],
                                    [331126.0, 6610513.0],
                                    [333817.0, 6610276.0],
                                    [344797.0, 6600884.0],
                                    [354269.0, 6598459.0],
                                    [356701.0, 6592204.0],
                                    [364357.0, 6592471.0],
                                    [376108.0, 6582708.0],
                                    [376887.0, 6588202.0],
                                    [382360.0, 6587238.0],
                                    [391500.0, 6591809.0],
                                    [397324.0, 6586760.0],
                                    [404775.0, 6589452.0],
                                    [411453.0, 6585116.0],
                                    [426574.0, 6590996.0],
                                    [428213.0, 6593481.0],
                                    [420470.0, 6597142.0],
                                    [422851.0, 6601758.0],
                                    [424018.0, 6609992.0],
                                    [423543.0, 6619698.0],
                                    [421344.0, 6621760.0],
                                    [420740.0, 6628764.0],
                                    [415662.0, 6636435.0],
                                    [417892.0, 6640888.0],
                                    [411920.0, 6644974.0],
                                    [408792.0, 6655192.0],
                                    [404251.0, 6660135.0],
                                    [401283.0, 6663962.0],
                                    [392012.0, 6664073.0],
                                    [385082.0, 6667087.0],
                                    [376108.0, 6673611.0],
                                    [374065.0, 6668782.0],
                                    [367645.0, 6668175.0],
                                    [367588.0, 6659427.0],
                                    [361112.0, 6656907.0],
                                    [359840.0, 6669393.0],
                                    [354394.0, 6667534.0],
                                    [354064.0, 6663454.0],
                                    [357453.0, 6652400.0],
                                    [353671.0, 6649968.0],
                                    [343129.0, 6653969.0],
                                    [338731.0, 6658583.0],
                                    [332678.0, 6659222.0],
                                    [324590.0, 6666698.0],
                                    [322009.0, 6670666.0],
                                ]
                            ],
                        ],
                    },
                    "properties": {"CODE_DEPT": "85", "NOM_DEPT": "VENDEE"},
                    "id": 88,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [917346.0, 6234793.0],
                                [919352.0, 6230892.0],
                                [929076.0, 6227424.0],
                                [928534.0, 6223947.0],
                                [932969.0, 6220583.0],
                                [939545.0, 6227616.0],
                                [947016.0, 6224540.0],
                                [954550.0, 6225038.0],
                                [959301.0, 6228480.0],
                                [965861.0, 6230140.0],
                                [974387.0, 6227034.0],
                                [975697.0, 6233209.0],
                                [984286.0, 6234176.0],
                                [989472.0, 6238682.0],
                                [995722.0, 6237173.0],
                                [997536.0, 6239863.0],
                                [998568.0, 6249133.0],
                                [997443.0, 6253468.0],
                                [1002933.0, 6264260.0],
                                [1012590.0, 6265313.0],
                                [1018256.0, 6272482.0],
                                [1014132.0, 6274778.0],
                                [1015523.0, 6285590.0],
                                [1006552.0, 6288390.0],
                                [1003290.0, 6292496.0],
                                [1002326.0, 6300425.0],
                                [992638.0, 6305621.0],
                                [983574.0, 6307147.0],
                                [974774.0, 6305117.0],
                                [974848.0, 6301646.0],
                                [970413.0, 6298787.0],
                                [958836.0, 6305328.0],
                                [956283.0, 6301072.0],
                                [944763.0, 6293054.0],
                                [933734.0, 6296912.0],
                                [923991.0, 6299127.0],
                                [922160.0, 6296144.0],
                                [921881.0, 6295602.0],
                                [926823.0, 6291811.0],
                                [925792.0, 6288611.0],
                                [917893.0, 6286245.0],
                                [916541.0, 6283087.0],
                                [920209.0, 6276225.0],
                                [918385.0, 6268519.0],
                                [922861.0, 6263349.0],
                                [917403.0, 6259253.0],
                                [924245.0, 6244827.0],
                                [918110.0, 6241136.0],
                                [917346.0, 6234793.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "83", "NOM_DEPT": "VAR"},
                    "id": 89,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [670056.0, 6856451.0],
                                [662997.0, 6862431.0],
                                [657169.0, 6861180.0],
                                [650942.0, 6857646.0],
                                [650056.0, 6850064.0],
                                [653706.0, 6846856.0],
                                [663488.0, 6848458.0],
                                [668472.0, 6843626.0],
                                [671600.0, 6851283.0],
                                [670056.0, 6856451.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "94", "NOM_DEPT": "VAL-DE-MARNE"},
                    "id": 90,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [650942.0, 6857646.0],
                                [645325.0, 6859675.0],
                                [643644.0, 6863501.0],
                                [650140.0, 6866932.0],
                                [648071.0, 6872567.0],
                                [641404.0, 6867928.0],
                                [637864.0, 6864035.0],
                                [637702.0, 6857774.0],
                                [643163.0, 6853168.0],
                                [650056.0, 6850064.0],
                                [650942.0, 6857646.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "92", "NOM_DEPT": "HAUTS-DE-SEINE"},
                    "id": 91,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [698547.0, 6393953.0],
                                [706639.0, 6384441.0],
                                [705449.0, 6378272.0],
                                [710800.0, 6372878.0],
                                [709537.0, 6364934.0],
                                [712305.0, 6356606.0],
                                [709994.0, 6353946.0],
                                [718362.0, 6347498.0],
                                [728598.0, 6344387.0],
                                [729879.0, 6341376.0],
                                [735189.0, 6336775.0],
                                [750700.0, 6336169.0],
                                [750995.0, 6342037.0],
                                [754256.0, 6342872.0],
                                [763780.0, 6336809.0],
                                [768987.0, 6337162.0],
                                [776174.0, 6341769.0],
                                [775968.0, 6350322.0],
                                [773621.0, 6356674.0],
                                [775941.0, 6359276.0],
                                [770571.0, 6365836.0],
                                [775211.0, 6367175.0],
                                [779411.0, 6373918.0],
                                [775042.0, 6386528.0],
                                [771844.0, 6388592.0],
                                [768276.0, 6405343.0],
                                [758530.0, 6415778.0],
                                [752669.0, 6414624.0],
                                [752090.0, 6419191.0],
                                [746937.0, 6419760.0],
                                [746579.0, 6414955.0],
                                [737614.0, 6413026.0],
                                [732994.0, 6422485.0],
                                [732563.0, 6427378.0],
                                [728488.0, 6430309.0],
                                [719705.0, 6424147.0],
                                [714401.0, 6418301.0],
                                [708330.0, 6420849.0],
                                [707862.0, 6414941.0],
                                [704864.0, 6413115.0],
                                [698547.0, 6393953.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "48", "NOM_DEPT": "LOZERE"},
                    "id": 92,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [799607.0, 6263119.0],
                                [825918.0, 6262030.0],
                                [828657.0, 6259471.0],
                                [826719.0, 6253810.0],
                                [834804.0, 6251115.0],
                                [842728.0, 6251679.0],
                                [850515.0, 6249931.0],
                                [851283.0, 6257962.0],
                                [859395.0, 6260541.0],
                                [865618.0, 6249711.0],
                                [881792.0, 6250642.0],
                                [887411.0, 6254047.0],
                                [891677.0, 6249845.0],
                                [890480.0, 6245406.0],
                                [892188.0, 6237089.0],
                                [906247.0, 6238345.0],
                                [911635.0, 6232742.0],
                                [917346.0, 6234793.0],
                                [918110.0, 6241136.0],
                                [924245.0, 6244827.0],
                                [917403.0, 6259253.0],
                                [922861.0, 6263349.0],
                                [918385.0, 6268519.0],
                                [920209.0, 6276225.0],
                                [916541.0, 6283087.0],
                                [917893.0, 6286245.0],
                                [925792.0, 6288611.0],
                                [926823.0, 6291811.0],
                                [921881.0, 6295602.0],
                                [910307.0, 6287877.0],
                                [904218.0, 6287715.0],
                                [896706.0, 6289935.0],
                                [886796.0, 6295631.0],
                                [879627.0, 6296831.0],
                                [876282.0, 6295340.0],
                                [865136.0, 6300908.0],
                                [863255.0, 6305296.0],
                                [858049.0, 6310039.0],
                                [848847.0, 6314233.0],
                                [839658.0, 6315433.0],
                                [831988.0, 6308980.0],
                                [833168.0, 6302217.0],
                                [828463.0, 6288899.0],
                                [819908.0, 6290041.0],
                                [815212.0, 6281222.0],
                                [813903.0, 6274579.0],
                                [800175.0, 6267290.0],
                                [799607.0, 6263119.0],
                            ],
                            [
                                [869889.0, 6258065.0],
                                [866899.0, 6258272.0],
                                [866104.0, 6264876.0],
                                [862374.0, 6265459.0],
                                [862969.0, 6272152.0],
                                [870516.0, 6271879.0],
                                [874819.0, 6259107.0],
                                [869889.0, 6258065.0],
                            ],
                        ],
                    },
                    "properties": {"CODE_DEPT": "13", "NOM_DEPT": "BOUCHES-DU-RHONE"},
                    "id": 93,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [650942.0, 6857646.0],
                                [657169.0, 6861180.0],
                                [654926.0, 6867065.0],
                                [650140.0, 6866932.0],
                                [643644.0, 6863501.0],
                                [645325.0, 6859675.0],
                                [650942.0, 6857646.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "75", "NOM_DEPT": "PARIS"},
                    "id": 94,
                },
                {
                    "type": "Feature",
                    "geometry": {
                        "type": "Polygon",
                        "coordinates": [
                            [
                                [670056.0, 6856451.0],
                                [667928.0, 6865519.0],
                                [670882.0, 6870004.0],
                                [667303.0, 6878971.0],
                                [660416.0, 6872923.0],
                                [653619.0, 6875101.0],
                                [648071.0, 6872567.0],
                                [650140.0, 6866932.0],
                                [654926.0, 6867065.0],
                                [657169.0, 6861180.0],
                                [662997.0, 6862431.0],
                                [670056.0, 6856451.0],
                            ]
                        ],
                    },
                    "properties": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"},
                    "id": 95,
                },
            ],
            "crs": {
                "type": "name",
                "properties": {"name": "urn:ogc:def:crs:EPSG::2154"},
            },
        },
        "field_name_filter": ["CODE_DEPT"],
        "geometry_type_filter": "MultiPolygon",
        "bbox_filter": None,
        "serialize": False,
        "bbox_extent": False,
        "feature_limit": None,
        "feature_offset": None,
        "return_value": [
            {
                "attributes": {"CODE_DEPT": "56"},
                "geometry": {
                    "type": "MultiPolygon",
                    "coordinates": [
                        [
                            [
                                [229520.0, 6710085.0],
                                [240383.0, 6704696.0],
                                [240163.0, 6708285.0],
                                [235835.0, 6713741.0],
                                [229006.0, 6716339.0],
                                [229520.0, 6710085.0],
                            ]
                        ],
                        [
                            [
                                [212687.0, 6770001.0],
                                [211559.0, 6762660.0],
                                [216528.0, 6752538.0],
                                [224759.0, 6753321.0],
                                [234540.0, 6747533.0],
                                [234220.0, 6745025.0],
                                [240082.0, 6736634.0],
                                [251238.0, 6736509.0],
                                [260889.0, 6740570.0],
                                [266327.0, 6740184.0],
                                [271833.0, 6736526.0],
                                [269308.0, 6731426.0],
                                [263161.0, 6733044.0],
                                [258643.0, 6731063.0],
                                [263631.0, 6725691.0],
                                [274085.0, 6728424.0],
                                [283689.0, 6728526.0],
                                [290663.0, 6724762.0],
                                [288997.0, 6719519.0],
                                [300067.0, 6720583.0],
                                [315995.0, 6726944.0],
                                [317487.0, 6738014.0],
                                [315562.0, 6748257.0],
                                [318803.0, 6749864.0],
                                [322365.0, 6758359.0],
                                [317839.0, 6765781.0],
                                [320890.0, 6769878.0],
                                [317014.0, 6776765.0],
                                [309516.0, 6779524.0],
                                [306739.0, 6782705.0],
                                [310549.0, 6787938.0],
                                [306966.0, 6794650.0],
                                [300637.0, 6793781.0],
                                [298204.0, 6799128.0],
                                [291749.0, 6798375.0],
                                [285132.0, 6789099.0],
                                [280665.0, 6785525.0],
                                [277875.0, 6787107.0],
                                [279762.0, 6794931.0],
                                [270150.0, 6795768.0],
                                [252150.0, 6805897.0],
                                [246074.0, 6807146.0],
                                [242780.0, 6802066.0],
                                [233945.0, 6800703.0],
                                [229439.0, 6804532.0],
                                [212675.0, 6807535.0],
                                [202658.0, 6804638.0],
                                [202166.0, 6798131.0],
                                [205220.0, 6785800.0],
                                [211608.0, 6786141.0],
                                [216607.0, 6782805.0],
                                [223352.0, 6780867.0],
                                [221788.0, 6771592.0],
                                [212687.0, 6770001.0],
                            ]
                        ],
                    ],
                },
            },
            {
                "attributes": {"CODE_DEPT": "35"},
                "geometry": {
                    "type": "MultiPolygon",
                    "coordinates": [
                        [
                            [
                                [330825.0, 6841252.0],
                                [328251.0, 6849310.0],
                                [322500.0, 6846053.0],
                                [325749.0, 6841751.0],
                                [330825.0, 6841252.0],
                            ]
                        ],
                        [
                            [
                                [399495.0, 6830885.0],
                                [389634.0, 6835155.0],
                                [384742.0, 6834496.0],
                                [376536.0, 6826525.0],
                                [368413.0, 6830443.0],
                                [366767.0, 6839135.0],
                                [363309.0, 6845999.0],
                                [348952.0, 6844300.0],
                                [343084.0, 6846084.0],
                                [341341.0, 6849649.0],
                                [342875.0, 6855953.0],
                                [334395.0, 6854417.0],
                                [329772.0, 6850320.0],
                                [334969.0, 6837949.0],
                                [337450.0, 6835570.0],
                                [332923.0, 6813386.0],
                                [328273.0, 6809495.0],
                                [325505.0, 6811765.0],
                                [320973.0, 6806998.0],
                                [315234.0, 6806646.0],
                                [311879.0, 6798427.0],
                                [306966.0, 6794650.0],
                                [310549.0, 6787938.0],
                                [306739.0, 6782705.0],
                                [309516.0, 6779524.0],
                                [317014.0, 6776765.0],
                                [320890.0, 6769878.0],
                                [317839.0, 6765781.0],
                                [322365.0, 6758359.0],
                                [318803.0, 6749864.0],
                                [315562.0, 6748257.0],
                                [317487.0, 6738014.0],
                                [327477.0, 6743723.0],
                                [335469.0, 6745297.0],
                                [342268.0, 6743932.0],
                                [351165.0, 6744974.0],
                                [356172.0, 6751743.0],
                                [371672.0, 6756673.0],
                                [374291.0, 6753124.0],
                                [382163.0, 6750361.0],
                                [382932.0, 6754022.0],
                                [386941.0, 6760260.0],
                                [390140.0, 6770978.0],
                                [394099.0, 6773357.0],
                                [400197.0, 6773697.0],
                                [400465.0, 6781914.0],
                                [398626.0, 6784333.0],
                                [395852.0, 6803336.0],
                                [400321.0, 6810723.0],
                                [398130.0, 6822559.0],
                                [399495.0, 6830885.0],
                            ]
                        ],
                    ],
                },
            },
            {
                "attributes": {"CODE_DEPT": "17"},
                "geometry": {
                    "type": "MultiPolygon",
                    "coordinates": [
                        [
                            [
                                [365341.0, 6575902.0],
                                [359213.0, 6576771.0],
                                [352445.0, 6583031.0],
                                [350494.0, 6577212.0],
                                [356155.0, 6576636.0],
                                [364082.0, 6571051.0],
                                [365341.0, 6575902.0],
                            ]
                        ],
                        [
                            [
                                [373352.0, 6542832.0],
                                [371342.0, 6552252.0],
                                [366346.0, 6552808.0],
                                [362447.0, 6556836.0],
                                [360591.0, 6548506.0],
                                [369260.0, 6539881.0],
                                [371124.0, 6531592.0],
                                [374437.0, 6534213.0],
                                [375330.0, 6540510.0],
                                [373352.0, 6542832.0],
                            ]
                        ],
                        [
                            [
                                [464807.0, 6459164.0],
                                [461242.0, 6465553.0],
                                [455660.0, 6465791.0],
                                [456356.0, 6470307.0],
                                [447267.0, 6474282.0],
                                [443202.0, 6478722.0],
                                [445861.0, 6484044.0],
                                [444696.0, 6489309.0],
                                [446521.0, 6493231.0],
                                [442913.0, 6501478.0],
                                [436951.0, 6506668.0],
                                [434607.0, 6512022.0],
                                [434480.0, 6521530.0],
                                [445866.0, 6528260.0],
                                [449713.0, 6524677.0],
                                [455132.0, 6526680.0],
                                [458386.0, 6534878.0],
                                [457303.0, 6539406.0],
                                [459784.0, 6545825.0],
                                [446458.0, 6558600.0],
                                [437311.0, 6559539.0],
                                [429269.0, 6562335.0],
                                [426299.0, 6566639.0],
                                [420640.0, 6566176.0],
                                [415606.0, 6575464.0],
                                [411065.0, 6578554.0],
                                [411453.0, 6585116.0],
                                [404775.0, 6589452.0],
                                [397324.0, 6586760.0],
                                [391500.0, 6591809.0],
                                [382360.0, 6587238.0],
                                [383479.0, 6581738.0],
                                [376439.0, 6576760.0],
                                [374243.0, 6571617.0],
                                [381511.0, 6566597.0],
                                [386552.0, 6553761.0],
                                [382858.0, 6551653.0],
                                [385303.0, 6547012.0],
                                [378912.0, 6532887.0],
                                [370510.0, 6529071.0],
                                [370474.0, 6520657.0],
                                [379564.0, 6513624.0],
                                [387626.0, 6509256.0],
                                [386164.0, 6505245.0],
                                [399796.0, 6489042.0],
                                [404682.0, 6481482.0],
                                [406100.0, 6476140.0],
                                [418478.0, 6475494.0],
                                [421098.0, 6472770.0],
                                [431214.0, 6470295.0],
                                [433418.0, 6457450.0],
                                [437492.0, 6457585.0],
                                [444096.0, 6451365.0],
                                [452009.0, 6448234.0],
                                [457280.0, 6451647.0],
                                [460931.0, 6449393.0],
                                [464807.0, 6459164.0],
                            ]
                        ],
                    ],
                },
            },
            {
                "attributes": {"CODE_DEPT": "84"},
                "geometry": {
                    "type": "MultiPolygon",
                    "coordinates": [
                        [
                            [
                                [850837.0, 6364673.0],
                                [850729.0, 6357929.0],
                                [857850.0, 6357360.0],
                                [860544.0, 6360615.0],
                                [860545.0, 6368019.0],
                                [856829.0, 6372215.0],
                                [852761.0, 6369494.0],
                                [850837.0, 6364673.0],
                            ]
                        ],
                        [
                            [
                                [839658.0, 6315433.0],
                                [848847.0, 6314233.0],
                                [858049.0, 6310039.0],
                                [863255.0, 6305296.0],
                                [865136.0, 6300908.0],
                                [876282.0, 6295340.0],
                                [879627.0, 6296831.0],
                                [886796.0, 6295631.0],
                                [896706.0, 6289935.0],
                                [904218.0, 6287715.0],
                                [910307.0, 6287877.0],
                                [921881.0, 6295602.0],
                                [922160.0, 6296144.0],
                                [913516.0, 6306489.0],
                                [907367.0, 6306820.0],
                                [909386.0, 6316209.0],
                                [901642.0, 6319541.0],
                                [903879.0, 6328807.0],
                                [900470.0, 6332559.0],
                                [899978.0, 6338355.0],
                                [894810.0, 6342254.0],
                                [890601.0, 6342463.0],
                                [890550.0, 6347548.0],
                                [872115.0, 6350341.0],
                                [871547.0, 6356009.0],
                                [864358.0, 6358713.0],
                                [844895.0, 6349809.0],
                                [843837.0, 6356928.0],
                                [840525.0, 6360052.0],
                                [831614.0, 6360351.0],
                                [831641.0, 6353746.0],
                                [837656.0, 6344658.0],
                                [836689.0, 6335330.0],
                                [843231.0, 6331183.0],
                                [847769.0, 6322554.0],
                                [839658.0, 6315433.0],
                            ]
                        ],
                    ],
                },
            },
            {
                "attributes": {"CODE_DEPT": "85"},
                "geometry": {
                    "type": "MultiPolygon",
                    "coordinates": [
                        [
                            [
                                [297360.0, 6667914.0],
                                [299985.0, 6664525.0],
                                [303823.0, 6669495.0],
                                [298725.0, 6671705.0],
                                [297360.0, 6667914.0],
                            ]
                        ],
                        [
                            [
                                [322009.0, 6670666.0],
                                [318317.0, 6668787.0],
                                [315194.0, 6662103.0],
                                [307861.0, 6656132.0],
                                [308108.0, 6649020.0],
                                [322518.0, 6633220.0],
                                [328569.0, 6623483.0],
                                [331126.0, 6610513.0],
                                [333817.0, 6610276.0],
                                [344797.0, 6600884.0],
                                [354269.0, 6598459.0],
                                [356701.0, 6592204.0],
                                [364357.0, 6592471.0],
                                [376108.0, 6582708.0],
                                [376887.0, 6588202.0],
                                [382360.0, 6587238.0],
                                [391500.0, 6591809.0],
                                [397324.0, 6586760.0],
                                [404775.0, 6589452.0],
                                [411453.0, 6585116.0],
                                [426574.0, 6590996.0],
                                [428213.0, 6593481.0],
                                [420470.0, 6597142.0],
                                [422851.0, 6601758.0],
                                [424018.0, 6609992.0],
                                [423543.0, 6619698.0],
                                [421344.0, 6621760.0],
                                [420740.0, 6628764.0],
                                [415662.0, 6636435.0],
                                [417892.0, 6640888.0],
                                [411920.0, 6644974.0],
                                [408792.0, 6655192.0],
                                [404251.0, 6660135.0],
                                [401283.0, 6663962.0],
                                [392012.0, 6664073.0],
                                [385082.0, 6667087.0],
                                [376108.0, 6673611.0],
                                [374065.0, 6668782.0],
                                [367645.0, 6668175.0],
                                [367588.0, 6659427.0],
                                [361112.0, 6656907.0],
                                [359840.0, 6669393.0],
                                [354394.0, 6667534.0],
                                [354064.0, 6663454.0],
                                [357453.0, 6652400.0],
                                [353671.0, 6649968.0],
                                [343129.0, 6653969.0],
                                [338731.0, 6658583.0],
                                [332678.0, 6659222.0],
                                [324590.0, 6666698.0],
                                [322009.0, 6670666.0],
                            ]
                        ],
                    ],
                },
            },
        ],
    },
}

geojson_to_geolayer_parameters = {
    0: {
        "path": all_geometries_path,
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_extent": False,
        "bbox_filter": None,
        "serialize": False,
        "feature_limit": None,
        "feature_offset": None,
        "force_field_conversion": False,
        "crs": 4326,
        "return_value": geolayer_geometry_only_all_geometries_type,
    },
    1: {
        "path": geometry_only_path,
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_extent": True,
        "bbox_filter": None,
        "serialize": False,
        "feature_limit": None,
        "feature_offset": None,
        "force_field_conversion": False,
        "crs": 2154,
        "return_value": geolayer_fr_dept_geometry_only,
    },
    2: {
        "path": geolayer_attributes_only_path,
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_extent": False,
        "bbox_filter": None,
        "serialize": False,
        "feature_limit": None,
        "feature_offset": None,
        "force_field_conversion": True,
        "crs": None,
        "return_value": geolayer_attributes_only_without_none_value,
    },
    3: {
        "path": geolayer_fr_dept_data_only_geojson_path,
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_extent": True,
        "bbox_filter": None,
        "serialize": False,
        "feature_limit": None,
        "feature_offset": None,
        "force_field_conversion": False,
        "crs": None,
        "return_value": geolayer_fr_dept_data_only,
    },
    4: {
        "path": data_only_path,
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_extent": False,
        "bbox_filter": None,
        "serialize": False,
        "feature_limit": None,
        "feature_offset": None,
        "force_field_conversion": False,
        "crs": None,
        "return_value": geolayer_fr_dept_population,
    },
    5: {
        "path": "https://france-geojson.gregoiredavid.fr/repo/regions.geojson",
        "field_name_filter": None,
        "geometry_type_filter": None,
        "bbox_extent": False,
        "bbox_filter": None,
        "serialize": False,
        "feature_limit": None,
        "feature_offset": None,
        "force_field_conversion": False,
        "crs": 4326,
        "return_value": {'metadata': {'name': 'regions', 'fields': {'code': {'type': 'String', 'width': 2, 'index': 0}, 'nom': {'type': 'String', 'width': 26, 'index': 1}}, 'geometry_ref': {'type': {'MultiPolygon', 'Polygon'}, 'crs': 4326}}, 'features': {0: {'attributes': {'code': '11', 'nom': 'Île-de-France'}, 'geometry': {'type': 'Polygon', 'coordinates': [[[1.9221462784913, 48.457599361977], [1.9207376717625, 48.447750046159], [1.9065549813045, 48.445672344539], [1.9064076592587, 48.440146719021], [1.8774887068591, 48.440613561663], [1.8448630603718, 48.449360706547], [1.8363839553347, 48.466477806902], [1.8014512893542, 48.466086215218], [1.7963309289573, 48.484187938277], [1.7857092863217, 48.489936911612], [1.7906352036641, 48.497377315443], [1.7786170432038, 48.508131705459], [1.7757543018107, 48.527702827198], [1.7872423006556, 48.553746336139], [1.7674104287362, 48.559405546059], [1.765322855183, 48.569374568412], [1.7458629248393, 48.576137031624], [1.7368302606076, 48.572280930629], [1.7092486767776, 48.578026100992], [1.701983609829, 48.584999462088], [1.7178604312421, 48.606851120102], [1.7148984609516, 48.614392276576], [1.689422105099, 48.611536250362], [1.6793591385148, 48.618488989615], [1.6662229993646, 48.613704063337], [1.656339110342, 48.622053121145], [1.6582325680054, 48.627645882726], [1.6495606586096, 48.63227092599], [1.6515719070139, 48.638125076138], [1.64099001993, 48.643389970225], [1.6431906740267, 48.651291198129], [1.6298476379809, 48.648875085504], [1.6156160327829, 48.652789464959], [1.6024917313048, 48.663765432374], [1.6058633277913, 48.678762670696], [1.611774872468, 48.689473861848], [1.5823151457709, 48.696368116243], [1.5795403954022, 48.701811808781], [1.5948810579854, 48.709310708948], [1.5895382120501, 48.712468154974], [1.617804540369, 48.735942039093], [1.6264035004424, 48.748091646614], [1.6026875153092, 48.760486506237], [1.5849045861802, 48.763296867942], [1.5875973267999, 48.77360593191], [1.5803992974877, 48.777559499888], [1.5756742997058, 48.790504096814], [1.5834240899801, 48.807168828475], [1.5912058811372, 48.814866973865], [1.5837280523171, 48.832130726577], [1.5941817842602, 48.834218536506], [1.5951919881928, 48.839707334891], [1.5772727483959, 48.844358116549], [1.5815974879282, 48.854999853184], [1.5780393102494, 48.860864409827], [1.5666395741734, 48.866183647932], [1.5552126063723, 48.865075717505], [1.5462328761118, 48.872431616391], [1.5595079054893, 48.882055273516], [1.5572530066459, 48.891575743208], [1.5385235335514, 48.906685854091], [1.5417973746939, 48.91547990669], [1.5386177797921, 48.921794692396], [1.5241021875366, 48.924752145617], [1.5128954188837, 48.922585369837], [1.5090139983632, 48.936627464834], [1.5015266013113, 48.941051842112], [1.5010590902862, 48.952678048634], [1.4966058957223, 48.969344788938], [1.5155485568584, 48.976406187821], [1.5079088220123, 48.98376724437], [1.497416022081, 48.979551284823], [1.4770931932159, 48.978791319268], [1.4706099672547, 48.975306435494], [1.4609202371105, 48.986433838647], [1.4787512905862, 48.998884682872], [1.4721822976397, 49.018490972378], [1.4577570076778, 49.026294572016], [1.4579533584639, 49.03483279821], [1.4474286969633, 49.04518889808], [1.4472851104304, 49.053509472828], [1.4608012364168, 49.062739598254], [1.4848766880401, 49.0515451317], [1.5032944474047, 49.059098256736], [1.5116006058281, 49.074136193201], [1.5217716034178, 49.068546693163], [1.5494725491086, 49.072557881924], [1.5570743762242, 49.069620586462], [1.5747375500157, 49.078437534581], [1.6044866350314, 49.08303659502], [1.608798807603, 49.077894185227], [1.6233233619235, 49.086078404348], [1.6175344667245, 49.093996514155], [1.6470910019222, 49.124713530921], [1.655781502711, 49.130164014177], [1.6539225302112, 49.145440634177], [1.6643792614171, 49.153368483471], [1.6670168601861, 49.178613559023], [1.6769552220057, 49.202542812736], [1.6757423007191, 49.21186711807], [1.7040643483737, 49.229320472612], [1.7043588288241, 49.232197221792], [1.729662120604, 49.22919730317], [1.7341091784733, 49.221277890399], [1.7336823766846, 49.210958623685], [1.7230394537953, 49.20967924589], [1.7155761288215, 49.203118037941], [1.7258249045161, 49.195712707137], [1.7374357068856, 49.194603115202], [1.7421415990654, 49.180151725276], [1.7551705903258, 49.174545969477], [1.7775554860529, 49.184104883007], [1.7909791787819, 49.179854330047], [1.7954740881562, 49.18526277584], [1.8143979645085, 49.176162362964], [1.8265758315348, 49.179516758866], [1.8370818782543, 49.171698986367], [1.8455433838221, 49.169896687357], [1.877042152092, 49.171448857663], [1.8852348791181, 49.162636028533], [1.894536229716, 49.166040538631], [1.931476176782, 49.17416772145], [1.9480171420872, 49.170749195544], [1.9607171629873, 49.173517298241], [1.9734431640564, 49.18389441504], [1.996823915181, 49.176453415327], [2.0045021739488, 49.177609556506], [2.0217858750717, 49.188671770161], [2.0380917348167, 49.192136044555], [2.066842351201, 49.202860855132], [2.0808850919985, 49.209773929407], [2.0915398506152, 49.204360444701], [2.0968798927064, 49.189757147704], [2.1133369040576, 49.186543761789], [2.1327402600127, 49.191379169415], [2.1645707336419, 49.179671393215], [2.157743439339, 49.172599185593], [2.1642743368285, 49.166004802028], [2.1819527991076, 49.173675958457], [2.204958905762, 49.174316445929], [2.2186458815721, 49.180685270888], [2.2354095182703, 49.167035850124], [2.2163546658105, 49.154378017348], [2.2230049777895, 49.151869445673], [2.2524813607229, 49.152881479913], [2.2622091200851, 49.158297463054], [2.2695453788487, 49.156306628677], [2.2862682227562, 49.160277559835], [2.2888064839605, 49.170710377425], [2.2994229533516, 49.17583535835], [2.3011998615285, 49.183887047533], [2.3109304401404, 49.186404768181], [2.3222626753655, 49.180859736345], [2.3462625342946, 49.161815854345], [2.3592998527471, 49.147343950086], [2.370937678429, 49.159173609651], [2.383003341928, 49.155913004846], [2.3912847262891, 49.1493504084], [2.4153544805398, 49.151762413963], [2.4409039786288, 49.14580411257], [2.4354018020913, 49.133939040206], [2.4615068862157, 49.135936921998], [2.4817070713716, 49.126919463544], [2.4992321189629, 49.122269747269], [2.5020961933805, 49.118887475459], [2.4899295573932, 49.106359373937], [2.5310585957685, 49.099597191318], [2.5329944482474, 49.119245162084], [2.5408087122315, 49.122242313794], [2.5561550654469, 49.118627938332], [2.5520149054273, 49.113947081753], [2.5581755098966, 49.098381756011], [2.5786858654184, 49.091952842127], [2.5833038141204, 49.080706309944], [2.5905283926735, 49.079653961607], [2.6072121818235, 49.089061593648], [2.6103345312027, 49.09494039704], [2.6205306041593, 49.095141144665], [2.6332770991263, 49.108372635105], [2.6676934960697, 49.092495236068], [2.6848013380994, 49.081070149491], [2.6921954156417, 49.072098782916], [2.6909952426863, 49.066575827238], [2.7061794650059, 49.06530744517], [2.7204862280103, 49.074886920193], [2.7324165014354, 49.069856383944], [2.7350099332564, 49.060452516659], [2.7604244593128, 49.06296236294], [2.787073783912, 49.07527418833], [2.7918697099795, 49.090226188638], [2.8090528505052, 49.097537605404], [2.8198502647929, 49.087367188293], [2.8360889289489, 49.082987383853], [2.8451483788669, 49.084656494049], [2.8557424844029, 49.070260111043], [2.8662678657136, 49.070693981918], [2.8830747436616, 49.076071279686], [2.8949485303642, 49.077063202013], [2.9015078822282, 49.085373143453], [2.9174506912143, 49.079815930085], [2.9445842533756, 49.081604590578], [2.9704735929189, 49.088974001698], [2.9747449093505, 49.074788481937], [2.9879964190903, 49.072371853401], [2.9912365557999, 49.084010529465], [3.0085155423352, 49.091506561321], [3.0295246754031, 49.085932257529], [3.0327819280137, 49.089067566229], [3.0483557770377, 49.08631637936], [3.0573553400185, 49.093990044235], [3.0563165652026, 49.101913557338], [3.0718801833502, 49.11755332218], [3.0824299640326, 49.112379413059], [3.1019450875262, 49.108665530931], [3.1288977237115, 49.106712873662], [3.1495286898189, 49.100548046274], [3.1652303376546, 49.099653555336], [3.1568687392365, 49.086717381412], [3.1586170058803, 49.080495794822], [3.1686703252618, 49.076194127358], [3.1818447950388, 49.062073630984], [3.1821650688322, 49.052356876125], [3.1902026447151, 49.046494471584], [3.181201109614, 49.042312878135], [3.1765330296567, 49.030276306398], [3.1610292917102, 49.024224133711], [3.17167852308, 49.014125889695], [3.1836516708558, 49.011250532749], [3.2071647717724, 49.000687121653], [3.209314063913, 48.993783774365], [3.2291741613167, 48.988415153607], [3.2312127851282, 48.976752849115], [3.2441973984858, 48.976835025435], [3.2518324140274, 48.972363565032], [3.2571425774493, 48.95706258101], [3.2678473977393, 48.938330226813], [3.2845265117579, 48.940530948472], [3.3047535824542, 48.948766966256], [3.3128748032908, 48.933619620679], [3.3130772332366, 48.921215462331], [3.3302940034825, 48.908707002968], [3.3441215555428, 48.915424399696], [3.3535717935992, 48.915243105496], [3.3663458595763, 48.922834212302], [3.3722055688435, 48.921684863018], [3.3755045418202, 48.907223979388], [3.3690076856012, 48.893887842681], [3.3828118491401, 48.888743663179], [3.3804785922907, 48.874760520568], [3.3897420595655, 48.871208088242], [3.4058488876005, 48.875883179755], [3.4032208419263, 48.864690111949], [3.4209735309142, 48.863949992871], [3.4522351731222, 48.856295042236], [3.4453621334286, 48.843227318178], [3.4619058634763, 48.837795469902], [3.4704665824993, 48.850999590899], [3.4851833721947, 48.851910309574], [3.4895742506519, 48.839868156733], [3.4849684486637, 48.825009748881], [3.4872017702391, 48.815190371551], [3.4809287140503, 48.81218578416], [3.4703815627087, 48.8208976637], [3.4544121814945, 48.813840024336], [3.4321664968613, 48.812257770946], [3.4166176467147, 48.817828781451], [3.4041649646308, 48.80927626878], [3.4104778884203, 48.803943061752], [3.4412895824977, 48.800919300185], [3.442160723333, 48.784353883555], [3.4282111529646, 48.77948500421], [3.4094228096892, 48.783835572028], [3.4008409030783, 48.767256400859], [3.398657955437, 48.755599281994], [3.4129613380945, 48.753902050854], [3.4256695187547, 48.755689536249], [3.4358103469779, 48.753571711386], [3.440606129229, 48.738701946832], [3.4674670222781, 48.735224220894], [3.4643082791983, 48.707378088042], [3.4769690535178, 48.699355347111], [3.4658318000834, 48.68619250912], [3.4545564374114, 48.682119139778], [3.442691260176, 48.672503410154], [3.4408489379625, 48.66307286353], [3.4604317354595, 48.653009078358], [3.4531162175594, 48.633955984329], [3.4765733783329, 48.637329365265], [3.4881941587649, 48.644795887875], [3.5031842529874, 48.645682506087], [3.517498400146, 48.643365240313], [3.5190643678345, 48.633470112339], [3.54590310832, 48.62806547987], [3.555613758785, 48.620285576065], [3.5346181421224, 48.61035282902], [3.5038548704771, 48.604807329745], [3.5158639136582, 48.589782150903], [3.4975057114927, 48.589954752513], [3.4852747034173, 48.580426868353], [3.4733827141903, 48.576873863934], [3.4655215727904, 48.570484758136], [3.4722961348839, 48.564913176785], [3.4797700428722, 48.550623337178], [3.4796007670225, 48.544709319952], [3.4591848626137, 48.530740265696], [3.4382278519026, 48.52833381057], [3.4234477695307, 48.533559074894], [3.4142391071512, 48.533468273095], [3.4053967325678, 48.528014902933], [3.4239142947726, 48.514360214193], [3.4346387383078, 48.490251682592], [3.4203545971629, 48.491547248944], [3.3883584814447, 48.480409204068], [3.3964392758484, 48.463728690957], [3.4064837519344, 48.45245201333], [3.40356672054, 48.438738834692], [3.3969885214937, 48.434567766893], [3.3919585015834, 48.424317659764], [3.4118359218741, 48.421315638566], [3.4136232739227, 48.414339744235], [3.4220792964886, 48.413341016525], [3.4147888224632, 48.390268550005], [3.4020328168494, 48.389706108674], [3.3833174045242, 48.39970411104], [3.3672130286667, 48.394317453742], [3.3627847824483, 48.382576787133], [3.3651606301927, 48.372282482296], [3.3301099431753, 48.372120787109], [3.3093216217612, 48.376980286994], [3.3051586355523, 48.372876819681], [3.2823921646024, 48.377519839785], [3.2647767822592, 48.374621237382], [3.254386262298, 48.36502005161], [3.2328491246009, 48.370332895515], [3.2018505500023, 48.364015470529], [3.184946555144, 48.368130335436], [3.1796714598679, 48.375720974057], [3.1677335139977, 48.371858146235], [3.1398647131279, 48.372599662445], [3.1182555596676, 48.366787852825], [3.1034153439925, 48.349510589018], [3.0878411046476, 48.358744110403], [3.0605482162395, 48.357442256262], [3.0495229427782, 48.360116755131], [3.0374902381586, 48.343151149375], [3.0365741164856, 48.326028248436], [3.0158983096866, 48.307897241414], [3.0272557445779, 48.300368070976], [3.0204148507047, 48.293439730003], [3.0297705668286, 48.285841287403], [3.0249639004196, 48.27600913901], [3.0436326434308, 48.272020556142], [3.047565503762, 48.249696163103], [3.0314619630164, 48.248879164003], [3.0185660113854, 48.235192866522], [3.0189243879447, 48.231774581507], [3.0051596957479, 48.207665501246], [2.9889655342085, 48.209014778073], [2.9744704228122, 48.205550154363], [2.9695465243882, 48.193835497978], [2.9507427471906, 48.190202971569], [2.9347445709406, 48.178820824383], [2.9363157566366, 48.163391744884], [2.8680328112418, 48.156437148324], [2.8590064128033, 48.147350198136], [2.8411949308256, 48.137851473794], [2.8252530440464, 48.133557427837], [2.8208840113898, 48.129664483454], [2.800901925208, 48.133251589253], [2.7986329461926, 48.150165448323], [2.8099458960087, 48.161299706681], [2.7989459318842, 48.168273053171], [2.7801683123181, 48.167546718776], [2.7686108994112, 48.163611325806], [2.7462653547317, 48.163802955575], [2.7414632024764, 48.159773038474], [2.7535738017345, 48.15321134405], [2.7551942761197, 48.145652570311], [2.7291489796899, 48.139089867843], [2.706543037587, 48.124819235783], [2.6722231385896, 48.124202437622], [2.6634137701321, 48.122204261229], [2.6463713950461, 48.136008390021], [2.6397379446435, 48.138858805822], [2.6026896280919, 48.131484417095], [2.5775724874953, 48.132078323329], [2.570559954027, 48.140815681604], [2.5381145999136, 48.140650823762], [2.5215119811805, 48.127298388836], [2.4903125823631, 48.126606179474], [2.4648664700171, 48.129109351924], [2.4510870610062, 48.123458807719], [2.4442532323658, 48.131467936811], [2.4560832798883, 48.13581808329], [2.4783726996912, 48.156743847], [2.4832322969696, 48.164516406945], [2.5063243383023, 48.156437563961], [2.5168430223759, 48.166807571121], [2.5097551291606, 48.177877699501], [2.5129645377339, 48.192979126229], [2.5229439829919, 48.200517077101], [2.5141133764865, 48.214377652405], [2.5061863934974, 48.238532108957], [2.4866525872998, 48.240104494021], [2.4690928288345, 48.255276432625], [2.4501643446939, 48.250036886561], [2.4319323869166, 48.255142430662], [2.4237621901031, 48.260296420297], [2.4178314142956, 48.278395078542], [2.4231698173532, 48.289315551296], [2.4207604700518, 48.299253278858], [2.4048123966273, 48.314593139765], [2.4026629385658, 48.320717653248], [2.3968534009104, 48.314755298076], [2.3698159145392, 48.308674310979], [2.3401550939779, 48.320230117587], [2.3276948002521, 48.333053330653], [2.312593571187, 48.330803657009], [2.2954192911964, 48.30822244035], [2.2668923386489, 48.314682212687], [2.2535700132149, 48.300243238173], [2.2451518848313, 48.298393903395], [2.2494360700816, 48.314580917036], [2.2380428382036, 48.316370632568], [2.2463103911083, 48.329962148865], [2.2295923211201, 48.329229232055], [2.2239137900476, 48.336416239958], [2.2022520441218, 48.344598562828], [2.1982097691131, 48.337062877906], [2.185025102223, 48.32642865382], [2.1813553737363, 48.313746373001], [2.1690253806915, 48.312695907539], [2.1543896262247, 48.315910610694], [2.1557084788588, 48.304493813388], [2.1637483268763, 48.298436908006], [2.1361199958338, 48.299247999325], [2.1105944678389, 48.29694441258], [2.1137168991141, 48.307245161467], [2.1061680366894, 48.307635584746], [2.0815050149817, 48.293603520661], [2.0527138226636, 48.295470353999], [2.0493770399482, 48.289753273514], [2.0228447716486, 48.288080340461], [2.007237571012, 48.284688606385], [1.9940901445311, 48.286584124472], [1.9752915866555, 48.287202034779], [1.9666102219583, 48.295582043441], [1.959225976988, 48.308685064463], [1.9694413393402, 48.314231718094], [1.9744919508382, 48.323163720082], [1.9823432207772, 48.328312555088], [1.9749473035511, 48.335258065972], [1.9733953665973, 48.352974683353], [1.9868237281778, 48.362141015776], [1.9763108383484, 48.380270715947], [1.966381938603, 48.38158815854], [1.9765710225943, 48.399385315775], [1.9619541453882, 48.404321075988], [1.9427703207411, 48.405651458209], [1.9305611178719, 48.404126689728], [1.925889401548, 48.412741750651], [1.9378068315128, 48.426390003183], [1.9428970138616, 48.441083787001], [1.9331248410711, 48.442264032481], [1.9304234130097, 48.453403326926], [1.9221462784913, 48.457599361977]]]}}, 1: {'attributes': {'code': '24', 'nom': 'Centre-Val de Loire'}, 'geometry': {'type': 'Polygon', 'coordinates': [[[0.8148247207739, 48.670163564137], [0.82767132893029, 48.680720042791], [0.85036287028898, 48.682948048025], [0.86149783759132, 48.691007914902], [0.87671116761022, 48.715496114803], [0.88836808739528, 48.718920532577], [0.90239998073196, 48.710649225086], [0.92119872414556, 48.709175212814], [0.95524192597313, 48.716786068922], [0.96144420763056, 48.725722137279], [0.9772943914531, 48.730138669646], [0.98441493173502, 48.725995395669], [1.0140639866541, 48.72810030179], [1.0206075605327, 48.734789446779], [1.0316499412576, 48.730581545643], [1.0398026909049, 48.742155339], [1.0590712054157, 48.756765184439], [1.0686653703661, 48.756913559557], [1.0757811283562, 48.749437927852], [1.086000043818, 48.756926389494], [1.0957264674684, 48.748713222693], [1.1126577960236, 48.751863710692], [1.1209842348348, 48.767249558527], [1.1189842149957, 48.782375233568], [1.1213959532999, 48.789195509733], [1.1521150110915, 48.78555968408], [1.1533037151721, 48.774016041266], [1.161542788993, 48.769293220083], [1.1847360438338, 48.772630245963], [1.1981446610666, 48.769568542277], [1.223526519249, 48.758056658402], [1.2226160798083, 48.767292140423], [1.246023632927, 48.769675823998], [1.2562637586379, 48.765103705723], [1.2545465453882, 48.758629272206], [1.2702130511038, 48.757482633762], [1.2799854142834, 48.762674216595], [1.3002968590985, 48.767536812046], [1.3195444496148, 48.76096144137], [1.3329054445301, 48.762612355286], [1.3422322124976, 48.772542324536], [1.3626643019013, 48.781664300017], [1.3744255946955, 48.782613836125], [1.3769627320869, 48.791766336256], [1.3592476591605, 48.813608561344], [1.3621823366519, 48.834179921179], [1.3905601143901, 48.8466061658], [1.3968565494996, 48.855383585466], [1.4093657222488, 48.861152641723], [1.4238934051882, 48.861268418973], [1.4343110180818, 48.866140106761], [1.4549936915991, 48.870326164498], [1.4653628424762, 48.877601417126], [1.4683545148033, 48.892215598584], [1.4606700524523, 48.900494617753], [1.4593261044838, 48.914649076535], [1.4479593034805, 48.924639965044], [1.4594110528379, 48.928926959252], [1.4613112437714, 48.937555310548], [1.4806477281429, 48.940490376837], [1.5015266013113, 48.941051842112], [1.5090139983632, 48.936627464834], [1.5128954188837, 48.922585369837], [1.5241021875366, 48.924752145617], [1.5386177797921, 48.921794692396], [1.5417973746939, 48.91547990669], [1.5385235335514, 48.906685854091], [1.5572530066459, 48.891575743208], [1.5595079054893, 48.882055273516], [1.5462328761118, 48.872431616391], [1.5552126063723, 48.865075717505], [1.5666395741734, 48.866183647932], [1.5780393102494, 48.860864409827], [1.5815974879282, 48.854999853184], [1.5772727483959, 48.844358116549], [1.5951919881928, 48.839707334891], [1.5941817842602, 48.834218536506], [1.5837280523171, 48.832130726577], [1.5912058811372, 48.814866973865], [1.5834240899801, 48.807168828475], [1.5756742997058, 48.790504096814], [1.5803992974877, 48.777559499888], [1.5875973267999, 48.77360593191], [1.5849045861802, 48.763296867942], [1.6026875153092, 48.760486506237], [1.6264035004424, 48.748091646614], [1.617804540369, 48.735942039093], [1.5895382120501, 48.712468154974], [1.5948810579854, 48.709310708948], [1.5795403954022, 48.701811808781], [1.5823151457709, 48.696368116243], [1.611774872468, 48.689473861848], [1.6058633277913, 48.678762670696], [1.6024917313048, 48.663765432374], [1.6156160327829, 48.652789464959], [1.6298476379809, 48.648875085504], [1.6431906740267, 48.651291198129], [1.64099001993, 48.643389970225], [1.6515719070139, 48.638125076138], [1.6495606586096, 48.63227092599], [1.6582325680054, 48.627645882726], [1.656339110342, 48.622053121145], [1.6662229993646, 48.613704063337], [1.6793591385148, 48.618488989615], [1.689422105099, 48.611536250362], [1.7148984609516, 48.614392276576], [1.7178604312421, 48.606851120102], [1.701983609829, 48.584999462088], [1.7092486767776, 48.578026100992], [1.7368302606076, 48.572280930629], [1.7458629248393, 48.576137031624], [1.765322855183, 48.569374568412], [1.7674104287362, 48.559405546059], [1.7872423006556, 48.553746336139], [1.7757543018107, 48.527702827198], [1.7786170432038, 48.508131705459], [1.7906352036641, 48.497377315443], [1.7857092863217, 48.489936911612], [1.7963309289573, 48.484187938277], [1.8014512893542, 48.466086215218], [1.8363839553347, 48.466477806902], [1.8448630603718, 48.449360706547], [1.8774887068591, 48.440613561663], [1.9064076592587, 48.440146719021], [1.9065549813045, 48.445672344539], [1.9207376717625, 48.447750046159], [1.9221462784913, 48.457599361977], [1.9304234130097, 48.453403326926], [1.9331248410711, 48.442264032481], [1.9428970138616, 48.441083787001], [1.9378068315128, 48.426390003183], [1.925889401548, 48.412741750651], [1.9305611178719, 48.404126689728], [1.9427703207411, 48.405651458209], [1.9619541453882, 48.404321075988], [1.9765710225943, 48.399385315775], [1.966381938603, 48.38158815854], [1.9763108383484, 48.380270715947], [1.9868237281778, 48.362141015776], [1.9733953665973, 48.352974683353], [1.9749473035511, 48.335258065972], [1.9823432207772, 48.328312555088], [1.9744919508382, 48.323163720082], [1.9694413393402, 48.314231718094], [1.959225976988, 48.308685064463], [1.9666102219583, 48.295582043441], [1.9752915866555, 48.287202034779], [1.9940901445311, 48.286584124472], [2.007237571012, 48.284688606385], [2.0228447716486, 48.288080340461], [2.0493770399482, 48.289753273514], [2.0527138226636, 48.295470353999], [2.0815050149817, 48.293603520661], [2.1061680366894, 48.307635584746], [2.1137168991141, 48.307245161467], [2.1105944678389, 48.29694441258], [2.1361199958338, 48.299247999325], [2.1637483268763, 48.298436908006], [2.1557084788588, 48.304493813388], [2.1543896262247, 48.315910610694], [2.1690253806915, 48.312695907539], [2.1813553737363, 48.313746373001], [2.185025102223, 48.32642865382], [2.1982097691131, 48.337062877906], [2.2022520441218, 48.344598562828], [2.2239137900476, 48.336416239958], [2.2295923211201, 48.329229232055], [2.2463103911083, 48.329962148865], [2.2380428382036, 48.316370632568], [2.2494360700816, 48.314580917036], [2.2451518848313, 48.298393903395], [2.2535700132149, 48.300243238173], [2.2668923386489, 48.314682212687], [2.2954192911964, 48.30822244035], [2.312593571187, 48.330803657009], [2.3276948002521, 48.333053330653], [2.3401550939779, 48.320230117587], [2.3698159145392, 48.308674310979], [2.3968534009104, 48.314755298076], [2.4026629385658, 48.320717653248], [2.4048123966273, 48.314593139765], [2.4207604700518, 48.299253278858], [2.4231698173532, 48.289315551296], [2.4178314142956, 48.278395078542], [2.4237621901031, 48.260296420297], [2.4319323869166, 48.255142430662], [2.4501643446939, 48.250036886561], [2.4690928288345, 48.255276432625], [2.4866525872998, 48.240104494021], [2.5061863934974, 48.238532108957], [2.5141133764865, 48.214377652405], [2.5229439829919, 48.200517077101], [2.5129645377339, 48.192979126229], [2.5097551291606, 48.177877699501], [2.5168430223759, 48.166807571121], [2.5063243383023, 48.156437563961], [2.4832322969696, 48.164516406945], [2.4783726996912, 48.156743847], [2.4560832798883, 48.13581808329], [2.4442532323658, 48.131467936811], [2.4510870610062, 48.123458807719], [2.4648664700171, 48.129109351924], [2.4903125823631, 48.126606179474], [2.5215119811805, 48.127298388836], [2.5381145999136, 48.140650823762], [2.570559954027, 48.140815681604], [2.5775724874953, 48.132078323329], [2.6026896280919, 48.131484417095], [2.6397379446435, 48.138858805822], [2.6463713950461, 48.136008390021], [2.6634137701321, 48.122204261229], [2.6722231385896, 48.124202437622], [2.706543037587, 48.124819235783], [2.7291489796899, 48.139089867843], [2.7551942761197, 48.145652570311], [2.7535738017345, 48.15321134405], [2.7414632024764, 48.159773038474], [2.7462653547317, 48.163802955575], [2.7686108994112, 48.163611325806], [2.7801683123181, 48.167546718776], [2.7989459318842, 48.168273053171], [2.8099458960087, 48.161299706681], [2.7986329461926, 48.150165448323], [2.800901925208, 48.133251589253], [2.8208840113898, 48.129664483454], [2.8252530440464, 48.133557427837], [2.8411949308256, 48.137851473794], [2.8590064128033, 48.147350198136], [2.8680328112418, 48.156437148324], [2.9363157566366, 48.163391744884], [2.9532706975673, 48.165012141792], [2.9636115856187, 48.152952836191], [2.9908854951697, 48.152489288025], [2.9939835469666, 48.142265686487], [3.0067845221623, 48.145250368304], [3.0294681734995, 48.133204471839], [3.0158768007648, 48.115703437492], [3.035285259367, 48.115994375619], [3.0383144426538, 48.101542780839], [3.0498894899541, 48.088838788782], [3.0504714242752, 48.072334131135], [3.0668426687001, 48.062700948945], [3.0883164489307, 48.053931896432], [3.0973362166793, 48.039371853532], [3.1242571374888, 48.031123310866], [3.120444753158, 48.027237026667], [3.1031098748357, 48.024050754331], [3.1040912941224, 48.013541749122], [3.1154271480689, 48.012966036779], [3.1245523220345, 48.006031052733], [3.1215086124269, 47.99508051279], [3.1284487900515, 47.970976841524], [3.1177801945629, 47.964978280792], [3.1052652915151, 47.946939230434], [3.0959562152001, 47.94648282966], [3.0813886854655, 47.938303435109], [3.0784762596905, 47.93141901745], [3.0646126208988, 47.930516710244], [3.049851715745, 47.917612271733], [3.0501029428736, 47.911450149596], [3.0369085970173, 47.910046599044], [3.0251429746145, 47.905395103831], [3.0102886119028, 47.904716972369], [3.0072263096695, 47.895290955742], [3.0113128689564, 47.874942218413], [3.0020156817175, 47.86910456894], [3.0053590366439, 47.864049253797], [3.0241574870815, 47.860432544378], [3.0338278605646, 47.843872107669], [3.0310783842835, 47.837952684286], [3.0125313015817, 47.834373232486], [3.0154699273932, 47.813535934414], [3.0229373322912, 47.812772400995], [3.0281204473987, 47.800645366032], [3.0237994278176, 47.786550178612], [2.988226602321, 47.78603448946], [2.9350564314568, 47.763249875579], [2.9093762293739, 47.769314365231], [2.893986958474, 47.764757164259], [2.8701769520741, 47.764868196886], [2.8566700654285, 47.760929175798], [2.8581457165416, 47.745650029901], [2.8487899744432, 47.725884864654], [2.8489690050712, 47.716844895991], [2.8585167014012, 47.711991090287], [2.8765799552305, 47.719081526808], [2.8841930930896, 47.714211876689], [2.8829409210413, 47.702615088236], [2.9037123946566, 47.695095946597], [2.9231151407358, 47.680558801908], [2.9181562549963, 47.669794968987], [2.926238261078, 47.660085723292], [2.9369444627222, 47.659131595543], [2.9542289513333, 47.64577418642], [2.9362905168585, 47.636648702788], [2.9357687458876, 47.619831796752], [2.9452166853722, 47.608449329011], [2.9379937136807, 47.598885605034], [2.9480691732296, 47.590534725553], [2.954982923175, 47.590408879602], [2.9644517577136, 47.581632358212], [2.9622680864494, 47.576787199846], [2.9765353538906, 47.569424295927], [2.9643142632036, 47.564408371297], [2.9586515837228, 47.55737826151], [2.9142961197082, 47.565971982014], [2.9093721909559, 47.559160555497], [2.8907714985755, 47.553102008094], [2.8738950692802, 47.55280954087], [2.8661248696402, 47.546368484983], [2.8574859883322, 47.552839253284], [2.8451871650071, 47.544932948997], [2.8489012329621, 47.53754134151], [2.8746305174837, 47.520424918568], [2.8884586332585, 47.50943098545], [2.8980184987491, 47.485252401408], [2.9140606551793, 47.470896834824], [2.9209883066832, 47.455435821811], [2.9288970093188, 47.444564932191], [2.930733371753, 47.431324302158], [2.9198859465078, 47.42134952529], [2.9184549974743, 47.405524882196], [2.9008159931543, 47.385192680229], [2.8952492319567, 47.372177057081], [2.8734919391537, 47.348396860493], [2.8699481463917, 47.338248316569], [2.8765423657559, 47.321934350315], [2.8848764388062, 47.316364164149], [2.907768482234, 47.310991294935], [2.9264805753113, 47.298618271978], [2.9378619912637, 47.287719383722], [2.9739389096142, 47.269804660206], [2.9834001334309, 47.259765880582], [2.9779552353597, 47.235552508643], [2.9816886133559, 47.221993356801], [2.9972827962038, 47.20166393803], [3.0092852008476, 47.179914660937], [3.0159484799111, 47.159093918463], [3.0211980869457, 47.136438093682], [3.0280905152523, 47.129064982977], [3.0313737475376, 47.092475725697], [3.0211804845643, 47.078232382085], [3.0187160021753, 47.070780884737], [3.0232191913817, 47.062612371142], [3.034525000237, 47.056291089581], [3.0627453140392, 47.04527634615], [3.0748375004401, 47.029815006019], [3.0757442612943, 47.019148176465], [3.0655821306108, 46.997351832387], [3.0629299477088, 46.981085018578], [3.0717062160523, 46.964340639457], [3.0793324170792, 46.955115150499], [3.0648978058646, 46.937079267447], [3.062210755789, 46.927739529848], [3.0502954877584, 46.910631265703], [3.0514016137092, 46.904955777225], [3.0609590858964, 46.898148846497], [3.0680961068914, 46.877680332057], [3.0671018851119, 46.847818120893], [3.0545889127264, 46.838765097797], [3.0593510744061, 46.827263935532], [3.0374707304721, 46.807786953663], [3.0320629441459, 46.794909389217], [3.0175184994153, 46.799900698717], [3.0033551657685, 46.798122809815], [2.9895396276531, 46.799298294916], [2.977801671991, 46.80377337386], [2.959918627937, 46.803872076205], [2.9529591220769, 46.790999230159], [2.9378161550649, 46.795713700537], [2.9243754548552, 46.794523429403], [2.9081271826571, 46.787903599841], [2.9098049149944, 46.779347563944], [2.8761691440531, 46.768445733319], [2.8770157582915, 46.761468535881], [2.8612332862758, 46.754030340445], [2.845419928846, 46.742855932849], [2.8448121194469, 46.726844055458], [2.8276177034814, 46.735286079973], [2.8010724027789, 46.733722377214], [2.787290827625, 46.728613960925], [2.7744893811293, 46.718902897367], [2.7585207590938, 46.717748505775], [2.7567441474108, 46.724772483564], [2.7435704821949, 46.73008326729], [2.7372898083354, 46.743150242056], [2.7287214908144, 46.748308579779], [2.7049698717297, 46.739389993021], [2.7009209254283, 46.720959754269], [2.6881649904859, 46.720909610987], [2.6777927654584, 46.704612208045], [2.6547293011216, 46.696536792562], [2.6478858990075, 46.688908315282], [2.6313578708624, 46.690886867154], [2.6234039357923, 46.688702717854], [2.6215530530757, 46.678653259953], [2.6308613163993, 46.672294145791], [2.6246414896646, 46.657300692831], [2.6095979741835, 46.662840354764], [2.6050484721825, 46.668158037606], [2.5849748988646, 46.664165776546], [2.5721892884417, 46.659444642004], [2.5673899068872, 46.652347408754], [2.5895802639199, 46.648026747075], [2.5966478585977, 46.637215067759], [2.5852765586441, 46.622738638042], [2.5859628971047, 46.6142967727], [2.5691010154446, 46.609518978116], [2.5779519369239, 46.603788174773], [2.5815597567024, 46.593164438775], [2.6023203253116, 46.595164451357], [2.6045186165205, 46.579001838563], [2.6093779370947, 46.571328686404], [2.60621930247, 46.565758488844], [2.6149607060411, 46.553276455558], [2.5835051726425, 46.542741752192], [2.5724916070298, 46.533849645617], [2.5540275760751, 46.529387627047], [2.5366546066244, 46.519702557793], [2.5275313125159, 46.529030044988], [2.5201385391568, 46.530864132368], [2.512426202843, 46.523880853474], [2.4991226886431, 46.521292172555], [2.4969434776113, 46.533665788244], [2.4829275256976, 46.532694737487], [2.4685711377311, 46.526009632976], [2.4502811792897, 46.521935935452], [2.4266867789218, 46.526121661214], [2.4131644849466, 46.520301786364], [2.3884650716406, 46.518246292054], [2.3683002910262, 46.51843386298], [2.3520036091655, 46.512206845202], [2.3241785781947, 46.49036759012], [2.3298217389117, 46.479616607338], [2.3242884285484, 46.470978980874], [2.3166710404192, 46.468549195709], [2.3054693178764, 46.475428936804], [2.2857604795168, 46.453514664499], [2.2810437278384, 46.420403547753], [2.2498765158587, 46.426366967242], [2.2334148941606, 46.423384135542], [2.2206403396014, 46.423664161021], [2.1975676755012, 46.428294141001], [2.1851558899005, 46.423284068779], [2.1677843748983, 46.424069192575], [2.1296807376318, 46.419867872386], [2.1126347187417, 46.420825387231], [2.1083721397147, 46.413528592759], [2.0889457684929, 46.40889961632], [2.0803472806508, 46.411894246794], [2.0741962684953, 46.419842978652], [2.0294174309506, 46.424588797264], [2.0203464671203, 46.429421918521], [1.9930771581051, 46.430917343442], [1.9781042758382, 46.439772572322], [1.9542508363527, 46.438125703166], [1.943869602507, 46.433996659264], [1.9243017577068, 46.431903065788], [1.9195527692358, 46.440208070783], [1.909180451657, 46.443498226347], [1.902458213237, 46.43780452052], [1.89071589528, 46.441493184019], [1.8834368991965, 46.432557252889], [1.8580375856722, 46.433476804112], [1.8383647496008, 46.42728517531], [1.8195044214246, 46.430033877555], [1.816812388337, 46.439524938483], [1.8031391002694, 46.44691836733], [1.7983753858278, 46.45481310551], [1.7548573832317, 46.452214535934], [1.7475915839665, 46.450017868926], [1.7566658918784, 46.441292317573], [1.757375741134, 46.423616429483], [1.7493159438657, 46.41093389201], [1.7505449826939, 46.405586225701], [1.7392119982362, 46.401254100808], [1.7277096608449, 46.388955998124], [1.7091312929501, 46.393353821969], [1.6974668292376, 46.406604886198], [1.683606447426, 46.418176923275], [1.6611836253306, 46.403538218482], [1.6448463938248, 46.386816749434], [1.628836514357, 46.388247455127], [1.6143064140463, 46.405295947029], [1.6226552998913, 46.418260263211], [1.6092554805936, 46.423123163216], [1.5920388571659, 46.407311867592], [1.5696914589532, 46.405498471105], [1.5524923075161, 46.394133824944], [1.5461946362171, 46.39346025752], [1.5439680356057, 46.41688301363], [1.5350519004493, 46.424455702933], [1.5223067601736, 46.426527695424], [1.5112050540502, 46.419594596972], [1.5059901336348, 46.409908716453], [1.4929348173659, 46.398340551367], [1.4775958033831, 46.393726557044], [1.472558559102, 46.383431643989], [1.4629367778167, 46.375349793186], [1.454349713379, 46.376048839285], [1.4353743494744, 46.363842198651], [1.438395055125, 46.35797267046], [1.4151854142983, 46.347214822447], [1.4048447784072, 46.364056923495], [1.3965775759913, 46.371445233126], [1.3835201223913, 46.374755471612], [1.3775283931369, 46.382803331341], [1.3560243049838, 46.4001195921], [1.3442929839887, 46.401546863371], [1.3309220641861, 46.396705560378], [1.3223398241302, 46.389656273383], [1.3204740000508, 46.38163178083], [1.3093599883058, 46.378135125428], [1.3030594710726, 46.370991990563], [1.2795549241983, 46.376488887271], [1.2603993142262, 46.378783327264], [1.245105268008, 46.37323860456], [1.2408646690892, 46.367573686174], [1.2164239770673, 46.367784938774], [1.2047664407221, 46.387689428519], [1.191538104043, 46.376759451936], [1.1841495355328, 46.37729147918], [1.1772787760985, 46.383948000481], [1.1950871576883, 46.40275403272], [1.1944727430082, 46.410351612296], [1.2126877519811, 46.432217971701], [1.2011339896178, 46.432466167404], [1.1834055129956, 46.429224899772], [1.1860178766023, 46.441083576014], [1.1689192762458, 46.446308575491], [1.1516072310249, 46.449233517349], [1.1355078072574, 46.470884241481], [1.1529790996043, 46.472957682593], [1.1405271083029, 46.485634879486], [1.1349675834984, 46.495262876365], [1.1491485689753, 46.502205353076], [1.1459288779804, 46.506400874677], [1.1082856489547, 46.531510215741], [1.0875973131695, 46.538168324634], [1.0722975106803, 46.53723511351], [1.0206003685537, 46.537099020664], [1.0219575008089, 46.55371655484], [1.0147685045818, 46.567759565973], [0.98723321911375, 46.565560099789], [0.98209440694689, 46.572640353042], [0.96266777384523, 46.574297702094], [0.94202235129636, 46.580794785364], [0.9371898310662, 46.586044724789], [0.93775566335965, 46.594420109118], [0.91586544594852, 46.596627887059], [0.90986438287983, 46.603447081391], [0.90693650860659, 46.615213230068], [0.89430329614895, 46.625732175305], [0.89638293110539, 46.633451946341], [0.90652086468369, 46.647752216163], [0.91742860399951, 46.65036307159], [0.9067032428601, 46.665571264221], [0.91071057116932, 46.677183661606], [0.90215945171528, 46.67919114553], [0.92474929055741, 46.692789633606], [0.9249533025609, 46.699991021542], [0.91455153531157, 46.710120272246], [0.90104236961312, 46.736090564754], [0.88777529605684, 46.737902736858], [0.86746898682573, 46.748216404838], [0.85444929067001, 46.759970797231], [0.84293807311317, 46.764275112746], [0.83064773545714, 46.775361466403], [0.82943649435874, 46.783579432834], [0.81628357550664, 46.787769101729], [0.81190192936381, 46.794504364542], [0.8153195131751, 46.805707876783], [0.81032866524034, 46.813064718291], [0.80932023680023, 46.827853568236], [0.79509333742744, 46.832522249054], [0.78680224354972, 46.840463346525], [0.79645898941075, 46.848962468561], [0.79032856900623, 46.852389283147], [0.76879944678165, 46.85074613749], [0.77198838768839, 46.860643073187], [0.75088169303492, 46.863524734354], [0.74733084634723, 46.869392079962], [0.73368489987152, 46.876040130575], [0.72673737636298, 46.886740909711], [0.7043177119069, 46.903295922263], [0.70357222720342, 46.930055655547], [0.70624788531743, 46.937157219193], [0.6961893847553, 46.956809748541], [0.69256676799124, 46.974304310533], [0.68216214670066, 46.977079806439], [0.66162129594461, 46.978086547342], [0.65646206458496, 46.985434564914], [0.64769454368947, 46.98827539877], [0.63621078823085, 46.985451013839], [0.62124367303806, 46.997106205666], [0.6188740376389, 47.007464569411], [0.59055093530507, 47.006722651596], [0.56695306996355, 47.002266858023], [0.57368515665648, 46.995531274591], [0.57382203251682, 46.983340464589], [0.59353374575945, 46.977612888014], [0.60117289544287, 46.973094369377], [0.60155821661783, 46.959107207652], [0.59834824957594, 46.956764146875], [0.57084220800147, 46.95593925543], [0.53928916139484, 46.960219024665], [0.52812896085369, 46.955971768907], [0.5061349705044, 46.959245419792], [0.47662392866394, 46.949861808585], [0.44480103455716, 46.941152434129], [0.43870457627727, 46.929578354733], [0.41852515647745, 46.937386922114], [0.40666063754734, 46.936647597652], [0.38814626546636, 46.943624533306], [0.36651145250788, 46.949554418002], [0.35524351132264, 46.94418585304], [0.34773843894922, 46.936585764264], [0.33952563735758, 46.936623468454], [0.32483667041576, 46.930652041087], [0.31123243685649, 46.937837015115], [0.3052147303369, 46.952805098497], [0.30507546032998, 46.965176268239], [0.30073879657193, 46.973829519846], [0.3083994154951, 46.978149875297], [0.30178521378569, 46.984422127588], [0.30884587377182, 46.999441441774], [0.30543065376719, 47.012362068122], [0.29867667498614, 47.019599341054], [0.30969866315285, 47.025643877461], [0.30698465850517, 47.048723481399], [0.29822992579073, 47.053922293608], [0.26770726634947, 47.04388297477], [0.26201563438582, 47.057459330927], [0.26761937550861, 47.067504197075], [0.26165981464917, 47.070051249456], [0.24245135321948, 47.0711879788], [0.23175079195616, 47.064054806793], [0.20799449312514, 47.053230964732], [0.19167202519639, 47.064672009871], [0.17997285846393, 47.059187917933], [0.17421802926902, 47.071274231914], [0.20095307158529, 47.091257976623], [0.18811779784912, 47.100828164294], [0.18145709966147, 47.1143899519], [0.16598416316105, 47.107162285602], [0.16126718554822, 47.100796179607], [0.13471650901781, 47.107872599064], [0.13613099833731, 47.121578754741], [0.12716663727095, 47.119967203103], [0.12372359489648, 47.128315822721], [0.11111857810383, 47.129423259303], [0.10471937462849, 47.120793812241], [0.084648249403316, 47.118377760157], [0.076371249669326, 47.123931049218], [0.08087053131906, 47.137653029292], [0.078395363975684, 47.146334786534], [0.066259497472021, 47.143215902043], [0.053830055961677, 47.16373374848], [0.063052886223431, 47.175281799504], [0.066596690426524, 47.189796025762], [0.053277684947378, 47.197182170708], [0.072492820219795, 47.220509854465], [0.074829460019472, 47.248048474897], [0.082848635358157, 47.274168568836], [0.078978960154079, 47.282822156056], [0.099012801986365, 47.308139754432], [0.10924461524906, 47.313421774727], [0.11786940351405, 47.325601141531], [0.11745694898776, 47.332342613969], [0.13125388952305, 47.33409233868], [0.13898837615883, 47.33824318552], [0.14796868770319, 47.348447803202], [0.14165395029201, 47.361961427199], [0.15845843664067, 47.366157059648], [0.18296214025622, 47.38033044936], [0.16798792612309, 47.386934066036], [0.16948959021545, 47.395646092388], [0.15385793095636, 47.398727021572], [0.18138204745888, 47.417824739063], [0.18527899163678, 47.424736116162], [0.18093772230519, 47.453404824236], [0.18979781155354, 47.460723327297], [0.2007181726014, 47.484545277708], [0.22010664406864, 47.50195233416], [0.22008941253351, 47.511490494119], [0.22491484141757, 47.52709951065], [0.20807030184987, 47.526432351568], [0.2034912870347, 47.533330991541], [0.19334553772128, 47.539118278038], [0.20150198535452, 47.544324126228], [0.21510267043528, 47.569975576615], [0.23453049018557, 47.57797744555], [0.23000044283917, 47.608397360802], [0.23768269638563, 47.610966183961], [0.25925309972834, 47.612253732911], [0.26784211805055, 47.608672360211], [0.27799234011686, 47.597381208395], [0.29001704748145, 47.597728628188], [0.32325488038268, 47.592888415747], [0.33844630799321, 47.585030259946], [0.33958580258874, 47.579472315073], [0.36673611607068, 47.573457923574], [0.3789542711163, 47.569104805534], [0.40216586206278, 47.579002216555], [0.39442325665444, 47.594393009892], [0.37905609046241, 47.610779501442], [0.36480446047317, 47.620165400372], [0.36465430735157, 47.626011449659], [0.38107503178189, 47.639064909321], [0.39702255940301, 47.638927008339], [0.42390524684004, 47.617824451176], [0.44993291932188, 47.619329777154], [0.45518198840301, 47.627017225989], [0.45662804145159, 47.638826353606], [0.47607646347987, 47.648011563852], [0.4797670863672, 47.64329220016], [0.4996666538331, 47.645272415067], [0.51325174134335, 47.652863992861], [0.54289746214182, 47.656203651505], [0.55947922009731, 47.665994923777], [0.58772733155021, 47.669617061038], [0.60463738045699, 47.679968482062], [0.61480416648326, 47.68275087954], [0.61443245110168, 47.694215472574], [0.60418662363095, 47.685607124967], [0.59557114412559, 47.688312714504], [0.59297009308968, 47.703590911989], [0.58052041667909, 47.712330763793], [0.59409530653203, 47.723105855723], [0.61159726872368, 47.728134311986], [0.61066958830157, 47.732034198596], [0.62683335231018, 47.751793159891], [0.63937932915856, 47.751572315523], [0.67564997055176, 47.768962404729], [0.69688004266227, 47.764225211], [0.70344170542358, 47.769940283327], [0.68931761050545, 47.779996503151], [0.69798475487217, 47.788889445319], [0.71263236035006, 47.790038970809], [0.72484407861962, 47.798889067315], [0.7397212944059, 47.814678933449], [0.74540046495951, 47.825663057103], [0.7588569724751, 47.833536394698], [0.76841445732376, 47.831101351932], [0.77457358541314, 47.839684494777], [0.77401870735853, 47.851208382865], [0.75916076452252, 47.859222188506], [0.76468938104337, 47.866582667793], [0.75733759497489, 47.884473514914], [0.75986941585155, 47.898224938894], [0.77032460906914, 47.902009083915], [0.78051199587287, 47.910375216053], [0.79002362904946, 47.912210300533], [0.79799062776542, 47.898193546758], [0.81018749426364, 47.890393591962], [0.81721753097407, 47.892418803105], [0.80913428200565, 47.91066247592], [0.81211830142135, 47.928939306036], [0.8171459594605, 47.934467914387], [0.83727689039754, 47.937246716219], [0.84579379193831, 47.941403140329], [0.84529238839341, 47.954438931698], [0.82428057343045, 47.982142037161], [0.82622288599262, 47.991475839362], [0.83237463233502, 47.996592094392], [0.83170184588828, 48.006116934727], [0.84052666414894, 48.021048593652], [0.84155459904793, 48.029673676539], [0.83672342747852, 48.034558745892], [0.82520263947346, 48.03005952554], [0.80877017226921, 48.031993621434], [0.79747785616118, 48.037556987677], [0.79653309159021, 48.05267766261], [0.80118315423495, 48.071513555954], [0.83460349982458, 48.070147734707], [0.84302009925743, 48.072638200667], [0.84483764311698, 48.086647072566], [0.83920278539184, 48.09125189303], [0.81516825904503, 48.093730753222], [0.81435131408069, 48.098801731111], [0.83268783335498, 48.098453526315], [0.84121734187884, 48.103059710788], [0.8553701454218, 48.122620579792], [0.852575219489, 48.133602174445], [0.87293551592102, 48.133408559058], [0.89396954177329, 48.135535055964], [0.91379809767445, 48.135125048448], [0.91161206421963, 48.148858532659], [0.88249645680993, 48.161766033434], [0.86198925121346, 48.166816904566], [0.83683452952269, 48.167352245345], [0.82688955262783, 48.175387000045], [0.80835901939965, 48.18611890903], [0.79562670501545, 48.188043105362], [0.79765841643139, 48.19445496608], [0.80626900151784, 48.203016266265], [0.83048365574563, 48.210708729507], [0.82588953248827, 48.220721830264], [0.80608653469826, 48.239891017509], [0.80241465108887, 48.248072322927], [0.78758977714986, 48.261313612339], [0.78587084890053, 48.271138465423], [0.79426147145466, 48.284950588985], [0.79341825616719, 48.293008635712], [0.77758221552843, 48.302840856139], [0.76023175104941, 48.298171659555], [0.76219430247254, 48.306876639515], [0.77313762601396, 48.325511221527], [0.78418514184216, 48.334478837721], [0.78542500970172, 48.340430711536], [0.81840111266411, 48.349420439199], [0.82785590745519, 48.342447024282], [0.84159508492141, 48.350229728169], [0.86181253481946, 48.350897961325], [0.87015714346989, 48.35834027017], [0.88337252111541, 48.356669121421], [0.90184278255778, 48.373449772268], [0.9149193773197, 48.374324097325], [0.93117784919562, 48.391265934635], [0.94224603424783, 48.399004844657], [0.9482686361643, 48.417831978233], [0.9762713097259, 48.439081867809], [0.95840880937073, 48.44259696324], [0.94226766472979, 48.457733974776], [0.93571270291242, 48.475553807957], [0.95629262450835, 48.482279378048], [0.95436935096035, 48.490573966149], [0.94155894503993, 48.498694713572], [0.9540037271624, 48.503840229688], [0.96655146260943, 48.522741687979], [0.95341814083771, 48.526244433476], [0.922603461355, 48.537716017396], [0.93876307137649, 48.550558547099], [0.92638981194521, 48.559394233279], [0.89126612131175, 48.572177428167], [0.86767573670944, 48.573488250275], [0.85063536439017, 48.582625709205], [0.8465873876382, 48.604782622076], [0.83304661425976, 48.61077016626], [0.81963618816719, 48.609871113214], [0.81775390390063, 48.616320066598], [0.83140562696703, 48.633774446005], [0.8226824397504, 48.640053608418], [0.82392074530028, 48.650041826767], [0.81294886563427, 48.660510127486], [0.8148247207739, 48.670163564137]]]}}, 2: {'attributes': {'code': '27', 'nom': 'Bourgogne-Franche-Comté'}, 'geometry': {'type': 'Polygon', 'coordinates': [[[6.9405416785725, 47.433371743667], [6.9416788459902, 47.415801742321], [6.9383781843469, 47.40602166291], [6.9175655645227, 47.405540786123], [6.9112807218549, 47.38565149684], [6.8853957543304, 47.374599512338], [6.879373150364, 47.358392623936], [6.8841847374511, 47.3526166115], [6.9041310992201, 47.359488916109], [6.9173061224044, 47.356174450746], [6.9518221878337, 47.359328514583], [6.965171933991, 47.359200577804], [6.9832539854825, 47.36354366283], [6.9942194881531, 47.36305702277], [7.0161749063041, 47.371834506375], [7.0497154850674, 47.360716488473], [7.0522936553288, 47.351141950572], [7.0622006908671, 47.344160388368], [7.0567509457312, 47.334567036162], [7.046205749818, 47.326977520793], [7.0305707210719, 47.327027697793], [7.0097278540447, 47.324358772262], [7.0161408458867, 47.313601433148], [7.0096883964596, 47.303186330915], [6.9931211498575, 47.295543502651], [6.9812664414026, 47.295770810067], [6.9665305332962, 47.292330424797], [6.9535590397913, 47.292421856494], [6.9428919076225, 47.287757217086], [6.9514761981406, 47.262184061527], [6.9494136431571, 47.256679318602], [6.9549768276348, 47.242939913873], [6.92627289824, 47.224555534793], [6.882438308572, 47.201615407729], [6.8639146913869, 47.180098699893], [6.842629723754, 47.172148165798], [6.8448535375183, 47.166384939791], [6.8583444229594, 47.164385451371], [6.8397865674492, 47.150904795437], [6.8285734250859, 47.146341618703], [6.8065486361803, 47.130890441394], [6.7637802260904, 47.11979466278], [6.7399139141665, 47.108051829732], [6.7456764991255, 47.100307622017], [6.741092234341, 47.091067967613], [6.7178304547913, 47.088938283348], [6.7072576746821, 47.083033793266], [6.7060095703295, 47.074995419181], [6.6916197499771, 47.06668927851], [6.7110513317725, 47.054327711875], [6.7140545270618, 47.049123354928], [6.6996564781858, 47.039039389615], [6.6784719863524, 47.035382104925], [6.6616206647392, 47.028224476267], [6.6535911062238, 47.021768824963], [6.6403417206763, 47.002761124116], [6.6186789138725, 46.992038806738], [6.5931797938133, 46.991770812154], [6.5665618384639, 46.980637338846], [6.5402076242225, 46.974399049863], [6.5188066665015, 46.970856252967], [6.5052194745754, 46.965849252067], [6.4966857222781, 46.974183469608], [6.4751246015727, 46.959379453348], [6.4553435306172, 46.940428600583], [6.4326749210724, 46.928605526908], [6.4579026529923, 46.900855622932], [6.4645775075825, 46.890210535442], [6.4598785157573, 46.851147058563], [6.4423415130938, 46.83123675481], [6.4401683842133, 46.819062942975], [6.4310019605487, 46.812409973106], [6.4382925253712, 46.799581903269], [6.4586515580207, 46.788759687976], [6.4381050836181, 46.76175121989], [6.425911183574, 46.754801119874], [6.3950745702138, 46.748243117811], [6.389642803755, 46.735238377227], [6.3716294362082, 46.7247505128], [6.360238313501, 46.72308030451], [6.3448015815423, 46.711867719342], [6.3154917743371, 46.702442903244], [6.2993568333135, 46.694896443468], [6.2853255009979, 46.691242033962], [6.2704880921381, 46.683194022336], [6.2691722926715, 46.678150632899], [6.241610701122, 46.660314779707], [6.2087769308549, 46.636617811577], [6.1849170570186, 46.622901021419], [6.1755349630813, 46.614142709958], [6.1644651641931, 46.610011824492], [6.1273332783823, 46.590310133888], [6.1107441527986, 46.576314209592], [6.138105886557, 46.557659570871], [6.1564422357855, 46.545471592105], [6.1528479944668, 46.536134657174], [6.1446024516564, 46.528393629454], [6.1378590985632, 46.530871419262], [6.1126938080715, 46.509641497594], [6.0968277794178, 46.481208813072], [6.0739298928675, 46.463949535302], [6.0744598322778, 46.453664090185], [6.0843910990454, 46.447437001059], [6.0858348949625, 46.440994445768], [6.0747681070246, 46.431630995903], [6.064005627331, 46.416222559892], [6.0551820813125, 46.414801045991], [6.0480752195777, 46.405125490757], [6.0295137846375, 46.38681604791], [6.0106565375389, 46.374508650286], [5.9868463201736, 46.364869353266], [5.9729173069373, 46.346856233903], [5.9535602724875, 46.326531457174], [5.9414094008927, 46.309446510031], [5.9259040835744, 46.313765646046], [5.9185184907402, 46.307199659115], [5.9089357776791, 46.283950786541], [5.8946251190123, 46.286607913138], [5.8791206347196, 46.269936490689], [5.8702488945181, 46.265305590806], [5.8643332109856, 46.271208875005], [5.8498475590074, 46.262067170418], [5.8212837267024, 46.262094109034], [5.7656471814788, 46.268294754652], [5.7459179055539, 46.266368533117], [5.7251818400017, 46.260731935709], [5.720112401844, 46.265870062788], [5.7160491956243, 46.279915646538], [5.7192939761881, 46.293462363342], [5.714721806193, 46.308772354673], [5.6845768021754, 46.310927537001], [5.6833466019044, 46.316276892818], [5.6684418272398, 46.324369189279], [5.6529045876259, 46.323214774673], [5.6493445080392, 46.339494512081], [5.6419584041921, 46.342028332374], [5.6305151249665, 46.330204693001], [5.6176441912887, 46.329091983869], [5.610460815624, 46.324211378495], [5.59838931795, 46.298445925032], [5.5855011829326, 46.292557783319], [5.5663641424008, 46.294050213862], [5.5581274576637, 46.282173642648], [5.5420340189851, 46.270203795698], [5.5129432911698, 46.264539612518], [5.4995891133957, 46.268200455579], [5.4730515403718, 46.265066548043], [5.4568426743662, 46.274473574235], [5.4595129521644, 46.290471994825], [5.4674037740958, 46.295566233017], [5.4753005499335, 46.315382606424], [5.4669175767252, 46.323267248222], [5.4377949533958, 46.315109371064], [5.4278984240109, 46.342210714821], [5.4170861726833, 46.339534237431], [5.4102335548466, 46.30910668308], [5.4046508439018, 46.310338173994], [5.4042931339536, 46.332813029221], [5.3992759574473, 46.339521371463], [5.3819165667023, 46.345255630996], [5.3734648101425, 46.352234450451], [5.3770544086974, 46.364113395825], [5.362996992744, 46.370926983475], [5.3770431289975, 46.381355482485], [5.3552221284773, 46.39375452396], [5.3525084400185, 46.397586033829], [5.331272401231, 46.399499315198], [5.3147703161373, 46.40947618293], [5.3076872001929, 46.416819197974], [5.308978572395, 46.424532251303], [5.3194882695109, 46.430803499916], [5.3105633704742, 46.446769968334], [5.2759250637615, 46.4481213263], [5.2545935888787, 46.454117831184], [5.2468319237306, 46.459403653865], [5.2350290009581, 46.457948870166], [5.2255477233319, 46.468273543404], [5.2150628404089, 46.468359298393], [5.2130427939332, 46.481261974235], [5.2066353369633, 46.48639795185], [5.2011399666188, 46.508211405762], [5.1815968667213, 46.509758803783], [5.1667923612572, 46.514674866375], [5.1664495124354, 46.505590616989], [5.141950046447, 46.508357328146], [5.1152051358154, 46.494069043579], [5.10737201939, 46.491919458253], [5.0989387475854, 46.497166675779], [5.0700061667722, 46.485667291269], [5.0523715346281, 46.484873791529], [5.0141793460298, 46.500587565063], [5.011007749262, 46.510294840159], [4.9835496952255, 46.515392507897], [4.9645994700407, 46.513175985923], [4.9491021767105, 46.501380502462], [4.9400218107181, 46.517199374492], [4.9314208893674, 46.509211481378], [4.9257189717408, 46.497441604339], [4.9155507621799, 46.488939443669], [4.9157805036687, 46.465413333501], [4.9111172894635, 46.457732635494], [4.8992958191725, 46.450123277325], [4.8918151434404, 46.439918009678], [4.8882101486247, 46.402977057782], [4.873839273104, 46.384668143424], [4.8585287407096, 46.368018459572], [4.8514544831808, 46.356271094403], [4.8534210199043, 46.32990123356], [4.8332136171616, 46.300145048773], [4.8259515552341, 46.274785814873], [4.8109975376095, 46.259923276174], [4.8115552603184, 46.249932664612], [4.8077505003904, 46.236972415214], [4.7945859355866, 46.218311767171], [4.7933904888672, 46.204700104778], [4.7802430578135, 46.189052363162], [4.7802082627383, 46.176676203678], [4.7608053446831, 46.175968780182], [4.7597597705914, 46.172840600415], [4.7305257874621, 46.178368585861], [4.7243706747794, 46.184304976244], [4.72266470068, 46.202320489849], [4.7356928657613, 46.211923783014], [4.7206237625559, 46.222390986056], [4.7326605831699, 46.227019799221], [4.7357666167041, 46.234244688808], [4.7028290155173, 46.251330439429], [4.6883618181605, 46.25011389523], [4.6795502516132, 46.258666565339], [4.6878811178807, 46.265311972919], [4.7076872577415, 46.269647917424], [4.7075411259083, 46.284660070276], [4.694515991108, 46.292672565821], [4.6931098569714, 46.302197476983], [4.6794340760587, 46.303994122044], [4.6693820675804, 46.297910092985], [4.6546591822967, 46.303484822155], [4.6352614072065, 46.299289507242], [4.6314517777677, 46.289015276562], [4.6183224944202, 46.282440402941], [4.6220235259619, 46.270079226484], [4.6185580580588, 46.264793895574], [4.5865068000033, 46.268694622582], [4.5726687726239, 46.277139335718], [4.5698487572768, 46.293352201901], [4.5577956308141, 46.294551640092], [4.5480762222411, 46.282864938182], [4.5464477974735, 46.27391839397], [4.5372643385622, 46.269911483268], [4.5039940949336, 46.267132463094], [4.488465816487, 46.287994462282], [4.4765696377244, 46.284237867232], [4.4583704273073, 46.296976724079], [4.4397213287914, 46.293184568466], [4.4272337977412, 46.302730717527], [4.4218715520166, 46.294954263085], [4.4058135314858, 46.296057806589], [4.3920466116785, 46.263026545141], [4.388291015925, 46.247956431405], [4.3880744564659, 46.219790380732], [4.3893979878582, 46.213601360996], [4.3774743279046, 46.21020246009], [4.3631781812533, 46.200537276046], [4.3706868166882, 46.191620039558], [4.3648481141165, 46.183579311067], [4.3450682105084, 46.187441862916], [4.3357117653558, 46.181398292861], [4.3270887031684, 46.184790131282], [4.3157416420975, 46.172029804364], [4.3035807058325, 46.17426655994], [4.2952828837852, 46.172250410112], [4.2824944900944, 46.156946471815], [4.2520302327293, 46.157916681311], [4.2518988744775, 46.167097935374], [4.2610250986037, 46.178754364444], [4.2525000565082, 46.187922148658], [4.2423584224526, 46.188830459357], [4.2335294499164, 46.180026926884], [4.2246872961743, 46.177995338767], [4.207903434232, 46.194833150686], [4.1854551738783, 46.190162130834], [4.1884438149961, 46.175128955988], [4.1660889760454, 46.172928033288], [4.1324158349304, 46.177826358374], [4.1040867377072, 46.198391359055], [4.0908839436933, 46.192837097346], [4.0716672927165, 46.18807123789], [4.0614051962048, 46.188789802443], [4.051960198465, 46.181690186415], [4.0308840440337, 46.171882539683], [3.9887880883959, 46.169805261207], [3.9817823975359, 46.17634098728], [3.9728332574833, 46.193862543845], [3.9725466394127, 46.202707514639], [3.933514918779, 46.206414377073], [3.9179891232598, 46.202853033545], [3.9135693350409, 46.206918558033], [3.890130972164, 46.214487049905], [3.8981917464837, 46.226659321125], [3.8966112073781, 46.2371189424], [3.9076581109201, 46.242456213516], [3.908821904601, 46.260346940334], [3.9055127902449, 46.271596707683], [3.899538631706, 46.275908099459], [3.8912386850317, 46.28524616424], [3.8974208259956, 46.291460834216], [3.9135709840696, 46.296680727045], [3.9300977722843, 46.295820251472], [3.942781911555, 46.298925500612], [3.9477193967384, 46.303444864233], [3.9481286581435, 46.31979164002], [3.9866271252361, 46.319195576966], [3.9974052217542, 46.323291087799], [3.9847410554074, 46.32973022678], [3.9886640376734, 46.360561403255], [3.9916043062641, 46.369630419679], [3.9842615206377, 46.378286038678], [3.9772206054151, 46.399220047306], [3.9886970251491, 46.408772224942], [3.9844480228975, 46.416663389961], [3.9956151474212, 46.4286940195], [3.9881422985694, 46.435461575775], [4.0055701432229, 46.443531306791], [3.997444424826, 46.450264670788], [4.0015415164833, 46.458618151559], [3.9980402829299, 46.465463980924], [3.9730562040646, 46.477457398934], [3.9565931687991, 46.47688226209], [3.9520867242123, 46.481423383561], [3.9579376111726, 46.489753821104], [3.9496133283036, 46.492478893726], [3.9375764836594, 46.49076190287], [3.9189702450008, 46.496061208045], [3.9013529089878, 46.490636303507], [3.896985633842, 46.481471942919], [3.8904665810402, 46.481246458453], [3.8649127119961, 46.489736338385], [3.860387224324, 46.495601253328], [3.8646271424558, 46.509717077517], [3.8600251576626, 46.515222323315], [3.8494709455035, 46.513023833485], [3.8397556873666, 46.517562051932], [3.8464630176371, 46.524356398489], [3.8340033360184, 46.531134997034], [3.8176755382384, 46.525229454055], [3.8113440515561, 46.520138117834], [3.8017563839321, 46.519902255804], [3.7878963661806, 46.528042650186], [3.7656008328403, 46.537908481562], [3.7546629110025, 46.536019887064], [3.7418443310505, 46.539508443385], [3.73154117491, 46.549578224034], [3.7406549316466, 46.559049395025], [3.7432893129951, 46.567565263244], [3.7323776901235, 46.604907119963], [3.7176467323502, 46.605806262315], [3.7138737202882, 46.613995279712], [3.7230250098493, 46.622072726143], [3.7227091007956, 46.627609885471], [3.7121523238188, 46.633631635674], [3.699679505, 46.651867135799], [3.6969575528098, 46.660583034448], [3.6801004977635, 46.66852089269], [3.6554716665381, 46.687748401639], [3.6513931816228, 46.70282167235], [3.637895263919, 46.707205199291], [3.6381391050479, 46.722723829214], [3.6353341554133, 46.728514790806], [3.6225898833129, 46.740130866568], [3.6294223422648, 46.749456328005], [3.6201072037828, 46.754059565827], [3.6020398798222, 46.751247280578], [3.5977490685569, 46.76202889412], [3.5910525816638, 46.762426406979], [3.5806709648764, 46.752741235279], [3.5845515939144, 46.739382605418], [3.5971876767747, 46.728401657187], [3.598000652576, 46.723983498355], [3.5773137335153, 46.714852724197], [3.5503869458917, 46.715861095646], [3.548207507912, 46.706166654281], [3.5555591963708, 46.695741177165], [3.5543959772727, 46.684731744078], [3.5464728563281, 46.678292894912], [3.5300363962253, 46.688813284083], [3.5174930194471, 46.683185185586], [3.4871533162964, 46.658256156349], [3.4865354798384, 46.65380880583], [3.4572892729042, 46.651760006926], [3.4473385862025, 46.663554460402], [3.4535963621348, 46.681987883569], [3.4513122938683, 46.689900877873], [3.4329783660003, 46.693340026098], [3.4295672938027, 46.702504791218], [3.4341396009475, 46.711907843672], [3.4074108289121, 46.711510582242], [3.3877581200663, 46.714818365449], [3.3787310431309, 46.71134766179], [3.3754269760827, 46.699410803841], [3.3664449691016, 46.691259477216], [3.3467035850706, 46.684418162056], [3.3139651835149, 46.688751611332], [3.2988329664362, 46.713590484885], [3.2697959512206, 46.71674181988], [3.2551640362648, 46.706289026218], [3.2330363473519, 46.697017662903], [3.2155446436111, 46.682892755029], [3.1972601846791, 46.679928148065], [3.1631524413883, 46.693541123032], [3.1297797354937, 46.727201530755], [3.0839336875931, 46.737632194007], [3.0610780913415, 46.749849808096], [3.0490666680714, 46.758080742151], [3.0361449719957, 46.776351034743], [3.0368385012729, 46.784399457513], [3.0320629441459, 46.794909389217], [3.0374707304721, 46.807786953663], [3.0593510744061, 46.827263935532], [3.0545889127264, 46.838765097797], [3.0671018851119, 46.847818120893], [3.0680961068914, 46.877680332057], [3.0609590858964, 46.898148846497], [3.0514016137092, 46.904955777225], [3.0502954877584, 46.910631265703], [3.062210755789, 46.927739529848], [3.0648978058646, 46.937079267447], [3.0793324170792, 46.955115150499], [3.0717062160523, 46.964340639457], [3.0629299477088, 46.981085018578], [3.0655821306108, 46.997351832387], [3.0757442612943, 47.019148176465], [3.0748375004401, 47.029815006019], [3.0627453140392, 47.04527634615], [3.034525000237, 47.056291089581], [3.0232191913817, 47.062612371142], [3.0187160021753, 47.070780884737], [3.0211804845643, 47.078232382085], [3.0313737475376, 47.092475725697], [3.0280905152523, 47.129064982977], [3.0211980869457, 47.136438093682], [3.0159484799111, 47.159093918463], [3.0092852008476, 47.179914660937], [2.9972827962038, 47.20166393803], [2.9816886133559, 47.221993356801], [2.9779552353597, 47.235552508643], [2.9834001334309, 47.259765880582], [2.9739389096142, 47.269804660206], [2.9378619912637, 47.287719383722], [2.9264805753113, 47.298618271978], [2.907768482234, 47.310991294935], [2.8848764388062, 47.316364164149], [2.8765423657559, 47.321934350315], [2.8699481463917, 47.338248316569], [2.8734919391537, 47.348396860493], [2.8952492319567, 47.372177057081], [2.9008159931543, 47.385192680229], [2.9184549974743, 47.405524882196], [2.9198859465078, 47.42134952529], [2.930733371753, 47.431324302158], [2.9288970093188, 47.444564932191], [2.9209883066832, 47.455435821811], [2.9140606551793, 47.470896834824], [2.8980184987491, 47.485252401408], [2.8884586332585, 47.50943098545], [2.8746305174837, 47.520424918568], [2.8489012329621, 47.53754134151], [2.8451871650071, 47.544932948997], [2.8574859883322, 47.552839253284], [2.8661248696402, 47.546368484983], [2.8738950692802, 47.55280954087], [2.8907714985755, 47.553102008094], [2.9093721909559, 47.559160555497], [2.9142961197082, 47.565971982014], [2.9586515837228, 47.55737826151], [2.9643142632036, 47.564408371297], [2.9765353538906, 47.569424295927], [2.9622680864494, 47.576787199846], [2.9644517577136, 47.581632358212], [2.954982923175, 47.590408879602], [2.9480691732296, 47.590534725553], [2.9379937136807, 47.598885605034], [2.9452166853722, 47.608449329011], [2.9357687458876, 47.619831796752], [2.9362905168585, 47.636648702788], [2.9542289513333, 47.64577418642], [2.9369444627222, 47.659131595543], [2.926238261078, 47.660085723292], [2.9181562549963, 47.669794968987], [2.9231151407358, 47.680558801908], [2.9037123946566, 47.695095946597], [2.8829409210413, 47.702615088236], [2.8841930930896, 47.714211876689], [2.8765799552305, 47.719081526808], [2.8585167014012, 47.711991090287], [2.8489690050712, 47.716844895991], [2.8487899744432, 47.725884864654], [2.8581457165416, 47.745650029901], [2.8566700654285, 47.760929175798], [2.8701769520741, 47.764868196886], [2.893986958474, 47.764757164259], [2.9093762293739, 47.769314365231], [2.9350564314568, 47.763249875579], [2.988226602321, 47.78603448946], [3.0237994278176, 47.786550178612], [3.0281204473987, 47.800645366032], [3.0229373322912, 47.812772400995], [3.0154699273932, 47.813535934414], [3.0125313015817, 47.834373232486], [3.0310783842835, 47.837952684286], [3.0338278605646, 47.843872107669], [3.0241574870815, 47.860432544378], [3.0053590366439, 47.864049253797], [3.0020156817175, 47.86910456894], [3.0113128689564, 47.874942218413], [3.0072263096695, 47.895290955742], [3.0102886119028, 47.904716972369], [3.0251429746145, 47.905395103831], [3.0369085970173, 47.910046599044], [3.0501029428736, 47.911450149596], [3.049851715745, 47.917612271733], [3.0646126208988, 47.930516710244], [3.0784762596905, 47.93141901745], [3.0813886854655, 47.938303435109], [3.0959562152001, 47.94648282966], [3.1052652915151, 47.946939230434], [3.1177801945629, 47.964978280792], [3.1284487900515, 47.970976841524], [3.1215086124269, 47.99508051279], [3.1245523220345, 48.006031052733], [3.1154271480689, 48.012966036779], [3.1040912941224, 48.013541749122], [3.1031098748357, 48.024050754331], [3.120444753158, 48.027237026667], [3.1242571374888, 48.031123310866], [3.0973362166793, 48.039371853532], [3.0883164489307, 48.053931896432], [3.0668426687001, 48.062700948945], [3.0504714242752, 48.072334131135], [3.0498894899541, 48.088838788782], [3.0383144426538, 48.101542780839], [3.035285259367, 48.115994375619], [3.0158768007648, 48.115703437492], [3.0294681734995, 48.133204471839], [3.0067845221623, 48.145250368304], [2.9939835469666, 48.142265686487], [2.9908854951697, 48.152489288025], [2.9636115856187, 48.152952836191], [2.9532706975673, 48.165012141792], [2.9363157566366, 48.163391744884], [2.9347445709406, 48.178820824383], [2.9507427471906, 48.190202971569], [2.9695465243882, 48.193835497978], [2.9744704228122, 48.205550154363], [2.9889655342085, 48.209014778073], [3.0051596957479, 48.207665501246], [3.0189243879447, 48.231774581507], [3.0185660113854, 48.235192866522], [3.0314619630164, 48.248879164003], [3.047565503762, 48.249696163103], [3.0436326434308, 48.272020556142], [3.0249639004196, 48.27600913901], [3.0297705668286, 48.285841287403], [3.0204148507047, 48.293439730003], [3.0272557445779, 48.300368070976], [3.0158983096866, 48.307897241414], [3.0365741164856, 48.326028248436], [3.0374902381586, 48.343151149375], [3.0495229427782, 48.360116755131], [3.0605482162395, 48.357442256262], [3.0878411046476, 48.358744110403], [3.1034153439925, 48.349510589018], [3.1182555596676, 48.366787852825], [3.1398647131279, 48.372599662445], [3.1677335139977, 48.371858146235], [3.1796714598679, 48.375720974057], [3.184946555144, 48.368130335436], [3.2018505500023, 48.364015470529], [3.2328491246009, 48.370332895515], [3.254386262298, 48.36502005161], [3.2647767822592, 48.374621237382], [3.2823921646024, 48.377519839785], [3.3051586355523, 48.372876819681], [3.3093216217612, 48.376980286994], [3.3301099431753, 48.372120787109], [3.3651606301927, 48.372282482296], [3.3627847824483, 48.382576787133], [3.3672130286667, 48.394317453742], [3.3833174045242, 48.39970411104], [3.4020328168494, 48.389706108674], [3.4147888224632, 48.390268550005], [3.4132728603068, 48.376300840268], [3.4216806196631, 48.371727783356], [3.4275090718968, 48.35997574793], [3.4432494908564, 48.367382718502], [3.4525885512991, 48.374388436099], [3.4704759274371, 48.374667861079], [3.4748808608132, 48.369266510477], [3.4981541228456, 48.369098088724], [3.512139360519, 48.360812483948], [3.530465379844, 48.342613415975], [3.5451019683919, 48.334543016882], [3.5440725252239, 48.319671593536], [3.5634067310877, 48.321440919656], [3.566569257901, 48.307425850859], [3.5879641370453, 48.300806415009], [3.5857412014087, 48.29008425533], [3.5777963307254, 48.284593393925], [3.5881978504359, 48.280068510017], [3.6117709302505, 48.274410870011], [3.6168016799253, 48.271343511852], [3.6243226631674, 48.254526756748], [3.6138531799397, 48.24927733618], [3.6000799784034, 48.237038015917], [3.6046865808402, 48.229884548214], [3.6136268888051, 48.232260725333], [3.6216106602921, 48.225744034142], [3.6140713717985, 48.220115584573], [3.6111516430878, 48.21192986819], [3.6009970264951, 48.20380086628], [3.5751823496995, 48.188742267274], [3.5941772424762, 48.178873395497], [3.6195451473546, 48.190784507919], [3.6318850111199, 48.189390079748], [3.6414996909345, 48.183932963824], [3.6506538178638, 48.168228410946], [3.6595795108361, 48.15965193897], [3.6678669028091, 48.139211019047], [3.6887554871535, 48.144278615274], [3.6936218940592, 48.14799982015], [3.7050157631116, 48.144314849936], [3.7223449458636, 48.156837755739], [3.7141712164177, 48.170603029762], [3.7184640557735, 48.175364157847], [3.74029665141, 48.169709598744], [3.7519004546533, 48.161296410098], [3.7548293235379, 48.150244530897], [3.7398043096241, 48.138688236138], [3.7397131881194, 48.13275416124], [3.7569100878728, 48.125307470037], [3.7680208404533, 48.1337610774], [3.7768827441699, 48.124996720039], [3.8049696872895, 48.102546851574], [3.7999733080105, 48.096695524271], [3.7985814686078, 48.086366869837], [3.8067979988969, 48.083861354137], [3.8201608894357, 48.067459938552], [3.82635868236, 48.063603655356], [3.827059329799, 48.047441428512], [3.8219783557759, 48.043916868834], [3.8321550263001, 48.036232814814], [3.8425469054526, 48.036189501683], [3.850085900943, 48.02786301681], [3.8706144760895, 48.015633804416], [3.8700007142194, 48.002599720655], [3.8619707432349, 48.004325555172], [3.8398152772889, 48.003890008543], [3.8500279607807, 47.983791517043], [3.8643090405558, 47.98423551782], [3.8618055931881, 47.976443001861], [3.8783021550775, 47.979419574124], [3.885413743137, 48.00032841816], [3.9001846571879, 47.997906103474], [3.9146958839434, 47.975696995879], [3.9056151344907, 47.956390517208], [3.9020918728463, 47.939168233154], [3.8940363766278, 47.929291041133], [3.9124676793978, 47.930259049768], [3.9264502525997, 47.934566873068], [3.9403268061141, 47.933140821871], [3.9565980726161, 47.934513395738], [3.9859571275878, 47.930640025592], [4.0055897042792, 47.942010075901], [4.0122015583229, 47.933099817884], [4.0256492301283, 47.928321965076], [4.0315462267821, 47.933180877458], [4.0435079889664, 47.928107993449], [4.0540462390611, 47.92948006618], [4.0563117031209, 47.941500284277], [4.0612633895691, 47.945564277098], [4.0779088672194, 47.942844108199], [4.0929746686253, 47.942978558738], [4.091392975551, 47.929644880288], [4.111781787339, 47.926998395128], [4.129354902453, 47.936039992343], [4.1418393873722, 47.937107385043], [4.1459926719811, 47.947950206748], [4.1663202417186, 47.959799899508], [4.1814937489139, 47.957133674703], [4.185174863551, 47.953252557601], [4.185389386493, 47.940250187972], [4.201887052952, 47.94115816132], [4.2078363901654, 47.946594650302], [4.1991540335482, 47.96994144352], [4.2127809206222, 47.971725942982], [4.2284618067273, 47.969156456849], [4.2221403072235, 47.949693241055], [4.2362857449326, 47.940458371541], [4.2481126500816, 47.929257212053], [4.265592811732, 47.924112631788], [4.293421363566, 47.925673564836], [4.3019415557721, 47.939722254759], [4.2989694743195, 47.948924996538], [4.3090008707807, 47.961170613198], [4.3512833685724, 47.956581571066], [4.3984909856202, 47.963428889937], [4.414350314367, 47.968207562341], [4.4275882888072, 47.965925181567], [4.4394035883612, 47.958224025114], [4.4490036624777, 47.957151982179], [4.482135195437, 47.963341049725], [4.4908013666212, 47.967274674022], [4.515002575681, 47.966197509296], [4.5315674205603, 47.969936101313], [4.5533088051577, 47.967682340931], [4.5599635426905, 47.971424167131], [4.5552078832713, 47.985773515235], [4.5455985119462, 47.98829443758], [4.5358174351871, 48.001208262], [4.5494258066747, 48.004460028844], [4.554850985404, 48.012319062721], [4.5673230090597, 48.018739473733], [4.5718848731394, 48.025129476681], [4.5826732520974, 48.029462774305], [4.612404633886, 48.030241950581], [4.624062923698, 48.025381425202], [4.6396252873332, 48.025481582141], [4.6633228351061, 48.020020302718], [4.6732270680042, 48.015055346449], [4.6985527278028, 48.023678273472], [4.7042329730873, 48.020235152969], [4.7199460898645, 48.008895516311], [4.7492966391968, 48.004246587867], [4.7890783024494, 48.007828564444], [4.7932639090855, 47.996944239514], [4.8091903248533, 47.990087845923], [4.7946342537178, 47.983195170106], [4.7865152517638, 47.964201285162], [4.8194243190699, 47.960358692838], [4.8410086317455, 47.96075264808], [4.8520473231564, 47.956242158653], [4.8660942377505, 47.940508774674], [4.8501722212977, 47.929537855578], [4.8467200449818, 47.924483556015], [4.8289423070305, 47.915124211024], [4.8340343917843, 47.906781834116], [4.8569990661674, 47.89585146766], [4.8693396784934, 47.917449806377], [4.8944964422884, 47.922840464291], [4.9018509649222, 47.921284863427], [4.9190920876169, 47.894720464516], [4.9281731599986, 47.88687190538], [4.9282357147154, 47.871123778488], [4.9540995648128, 47.866767159307], [4.9603856383733, 47.857358065698], [4.9622497289156, 47.839702282837], [4.968346106104, 47.831938726344], [4.9846956660801, 47.828868610045], [4.9941266376295, 47.819746154602], [4.9906198706093, 47.80709265473], [4.9824009031204, 47.800350982387], [4.9635761932156, 47.795106816319], [4.9564491304036, 47.790048428128], [4.9183050956308, 47.777311690703], [4.9177846968097, 47.766614764213], [4.9307398007716, 47.761333148797], [4.9496050950308, 47.765006218324], [4.9589919593761, 47.761870409828], [4.9598932138082, 47.7544709258], [4.9707033208711, 47.727636116595], [4.9570644317617, 47.709406346338], [4.9541385723681, 47.701462932734], [4.9791098413952, 47.687763691185], [4.9922739605095, 47.688315326064], [5.0043602413418, 47.700727315079], [5.0262670139789, 47.709492979045], [5.0327622841789, 47.704076235268], [5.0327945086565, 47.692333079799], [5.0606448449781, 47.694789812394], [5.0435832118687, 47.676513563124], [5.0578872394562, 47.668305887057], [5.0703648554737, 47.666753831482], [5.0849169001544, 47.657252517205], [5.1017263997014, 47.659487818247], [5.1088743414175, 47.649687715835], [5.133419901405, 47.650731358395], [5.1562768819218, 47.668257175471], [5.1613411137784, 47.679935696643], [5.1793190058471, 47.679306571337], [5.173772704787, 47.661555338996], [5.1735955223689, 47.652564238401], [5.1885815533539, 47.6495597478], [5.2153019734879, 47.638776585158], [5.2275663747918, 47.630461719186], [5.2392323119847, 47.616130998734], [5.2505435136739, 47.622148375054], [5.2586017166912, 47.622216096373], [5.243335051832, 47.603257395562], [5.2395818018336, 47.595735741686], [5.248821805001, 47.588304655805], [5.2529216592041, 47.576950536437], [5.2779061705699, 47.581361382365], [5.2787977512377, 47.590248985309], [5.2948617680378, 47.599202098387], [5.2998385942923, 47.604925842894], [5.3223487268523, 47.612359526718], [5.3399999375357, 47.609069594411], [5.3421656596273, 47.597942682873], [5.3547654342374, 47.591360294209], [5.3706351264232, 47.604807955246], [5.3740797661661, 47.604538026913], [5.3727580571009, 47.618659790315], [5.3868465136168, 47.635662494107], [5.4055917713039, 47.647770719631], [5.3984746606309, 47.649083223607], [5.406340329799, 47.673403498326], [5.4265210893308, 47.675523872509], [5.4357130635739, 47.670913872806], [5.4460337073379, 47.670773959543], [5.4725699801331, 47.67672271053], [5.482566377733, 47.684598405046], [5.5167714113012, 47.673665697151], [5.529779465589, 47.672825610683], [5.5429630425056, 47.685875666578], [5.5672035170122, 47.705232598617], [5.580075717534, 47.703119392386], [5.5966797529575, 47.671689689304], [5.6060928986115, 47.675206717975], [5.616916763571, 47.673506825098], [5.6350433227815, 47.676729768703], [5.6534107674437, 47.677377804161], [5.6602009774384, 47.684701035958], [5.6900715815111, 47.684834261118], [5.6946315676577, 47.691589089204], [5.6934923219824, 47.703700407172], [5.6841172724944, 47.711966308717], [5.6848345035363, 47.722252488703], [5.6933389025912, 47.737536114776], [5.7092157661502, 47.744819092275], [5.7061546847262, 47.752289930468], [5.7092177964874, 47.763723848917], [5.7050877892064, 47.769109267163], [5.6799723393154, 47.76996692113], [5.6766127410923, 47.77915552638], [5.6816907857215, 47.801918539863], [5.6902845680034, 47.818602061169], [5.7038164823427, 47.822615914257], [5.7326324521832, 47.817595239681], [5.7460508220444, 47.823594453292], [5.7441242763236, 47.848675592832], [5.7534185985443, 47.851779809209], [5.7611967718111, 47.859337964072], [5.7981943193063, 47.852395843864], [5.8053544944686, 47.8473671425], [5.8279856830918, 47.851868490955], [5.8214368328201, 47.868177826395], [5.8366827972636, 47.885275579155], [5.8483941586096, 47.904328585027], [5.8699685694528, 47.900702448936], [5.8864978594033, 47.902632285568], [5.8908642780035, 47.910826243984], [5.884723650121, 47.92604631497], [5.8967125895793, 47.93202806731], [5.892904334004, 47.937140708276], [5.9001165275304, 47.9447526196], [5.9180463526732, 47.94735518647], [5.9217138598918, 47.970783700094], [5.9367445426717, 47.978874239655], [5.9475278158692, 47.979712022025], [5.9595125543651, 47.965838580885], [5.9377200582568, 47.950937203984], [5.9296518654303, 47.938718128621], [5.953718196208, 47.937030199568], [5.9689005966348, 47.947407535025], [5.9707820414319, 47.957206856313], [5.9965110271696, 47.957642319673], [6.0022660129604, 47.956088697125], [6.0099778425991, 47.968676110152], [6.0235129876577, 47.978198192556], [6.01816748796, 47.984218151119], [6.0269197055122, 47.990054024535], [6.0411765157853, 48.00442320835], [6.0725586040075, 48.015669051022], [6.0809347681235, 48.012700464881], [6.0977392042699, 48.01504283565], [6.1092294655483, 48.012467456506], [6.1165344664207, 48.019389790184], [6.1317082771503, 48.023714993889], [6.1560578216767, 48.006943160047], [6.1523407152561, 47.994505212317], [6.164889049648, 47.976133645938], [6.1509430707726, 47.970556896575], [6.160691544552, 47.964476018183], [6.1679889957893, 47.952352981729], [6.1784443979518, 47.954215961253], [6.1973668542118, 47.951792167635], [6.2079614134083, 47.94275319831], [6.2052242815746, 47.932044890248], [6.2191727089294, 47.93576331706], [6.2379829343014, 47.932840414292], [6.2773320945343, 47.953805619678], [6.2964155087065, 47.955366770009], [6.3097604456805, 47.949874526566], [6.3245064287941, 47.949279774694], [6.338561201971, 47.954979185933], [6.3661530482729, 47.961943699906], [6.394005582089, 47.956962872907], [6.4053578977345, 47.95311233294], [6.4088868226821, 47.943264452338], [6.4317140631681, 47.943817555323], [6.4363061456524, 47.936497632925], [6.4604356473863, 47.91345059658], [6.4560181967467, 47.906627288043], [6.4786058641603, 47.885521654796], [6.5032137734313, 47.89621857502], [6.5421569547535, 47.902612242352], [6.5682839276999, 47.93449546901], [6.6017847198921, 47.944400335071], [6.6302463718081, 47.925593409791], [6.6455373160956, 47.904022779887], [6.6696633226227, 47.89320009565], [6.703676313184, 47.881417920779], [6.7102378561952, 47.87576777925], [6.7304382302284, 47.867533474661], [6.7377719050045, 47.861560606022], [6.7638501387584, 47.857307907712], [6.7644647560578, 47.853457064113], [6.784819046343, 47.849620144546], [6.792547182043, 47.840496971878], [6.7884284780797, 47.834484214023], [6.8235333222471, 47.813051201983], [6.8393097752574, 47.824784354742], [6.8461756187967, 47.822942631655], [6.8428287756472, 47.812907241333], [6.8634725871955, 47.785157366739], [6.9020863665368, 47.776444142208], [6.9093369154314, 47.77760076122], [6.9239978247236, 47.770469646258], [6.9425641239541, 47.768619181766], [6.9695414653395, 47.753879554684], [6.9881803418573, 47.747811458115], [7.01596189708, 47.743229997088], [7.0194654399739, 47.736016178013], [7.0374215531951, 47.721642148751], [7.0264858913282, 47.701000683113], [7.037634862268, 47.694693941352], [7.0388002853848, 47.687529274973], [7.0480463579808, 47.682334383614], [7.0389466543978, 47.67798172185], [7.0463174145898, 47.671501618284], [7.034430907222, 47.661170659864], [7.0391920612816, 47.650571191522], [7.0188657902769, 47.650671462441], [7.0180362046747, 47.642567039669], [7.0049789727138, 47.619379272859], [7.0105070572794, 47.605019604987], [7.005954748644, 47.602446062879], [7.0254214022991, 47.592680119451], [7.0405190481699, 47.600960102238], [7.0565070741684, 47.598940564806], [7.0647156944354, 47.601059487848], [7.0772390032257, 47.598070781665], [7.0862717367469, 47.592564849851], [7.0863359637946, 47.585555682513], [7.0941662771964, 47.57363395328], [7.1002437787202, 47.572348664104], [7.1084182862429, 47.563026634543], [7.1062174347916, 47.551377585032], [7.1192027781559, 47.547271468], [7.132779554549, 47.539650016902], [7.1398015507652, 47.526066534747], [7.1378734301853, 47.510602312684], [7.1303408019013, 47.503028568514], [7.1110611805129, 47.494903561041], [7.0917092821703, 47.494843569895], [7.0792767593811, 47.488864894845], [7.0615862317267, 47.49474656879], [7.0365664433325, 47.497498840015], [7.0243941161552, 47.504209745968], [7.0002031778313, 47.499396645969], [6.9831161167318, 47.49330200911], [6.9886863518423, 47.486681305933], [6.9880828045822, 47.474451283009], [6.9917666987937, 47.466419458718], [7.0002998100994, 47.462967214339], [6.9989680532301, 47.452297949929], [6.9890632753006, 47.447650094342], [6.9700019113149, 47.44688361894], [6.9663672609906, 47.437927724299], [6.9573594450338, 47.433602748363], [6.9405416785725, 47.433371743667]]]}}, 3: {'attributes': {'code': '28', 'nom': 'Normandie'}, 'geometry': {'type': 'Polygon', 'coordinates': [[[-1.1196198636379, 49.355568981262], [-1.1150349421423, 49.362395930026], [-1.0921583687035, 49.379887497495], [-1.0782159992234, 49.388493551822], [-1.0581039796328, 49.390752810392], [-1.030230861026, 49.389584817643], [-1.0217757695616, 49.392985914906], [-0.98940345902679, 49.39743637948], [-0.93938187284516, 49.39504140049], [-0.91939336367386, 49.39002775011], [-0.90740489073828, 49.381675557637], [-0.88137714562161, 49.371558349237], [-0.85116019900865, 49.362545824867], [-0.8268800178819, 49.357899826541], [-0.75879493262363, 49.349989308157], [-0.72224467845688, 49.347004293019], [-0.69550391989566, 49.347281971172], [-0.64201902855212, 49.345054424205], [-0.62418682110984, 49.340513964595], [-0.59417938730252, 49.34074582701], [-0.55324813273511, 49.346097088235], [-0.51530983971648, 49.345015391903], [-0.45195840154088, 49.335498540224], [-0.41484997241071, 49.335581004388], [-0.39661087301599, 49.333003019991], [-0.36103882127829, 49.322880511612], [-0.30257140893328, 49.298438445237], [-0.28214642940768, 49.293321218346], [-0.24699588025273, 49.28822175334], [-0.22569484520744, 49.281819588113], [-0.21207245145114, 49.28603196545], [-0.16966058718734, 49.286245922952], [-0.14189309791495, 49.289141316114], [-0.099599544001567, 49.2976014263], [-0.087163331120361, 49.297906717769], [-0.077762308941497, 49.304037533131], [-0.013370009201545, 49.321204345512], [0.0040210484147169, 49.327780217617], [0.049806426845953, 49.350858557413], [0.075462774884584, 49.366163898954], [0.087042570312236, 49.376676027467], [0.11038536206668, 49.394265661988], [0.12974714895673, 49.402984487336], [0.15940920759597, 49.410111989975], [0.17578564453162, 49.412357210559], [0.21994143692835, 49.426760938177], [0.29722451460974, 49.429859840723], [0.34059327041276, 49.434318983746], [0.33897883098918, 49.440928520352], [0.3393150124405, 49.449872303637], [0.27313585922231, 49.453416220586], [0.27142113093512, 49.447328719148], [0.25679707643476, 49.446323719841], [0.23825592404046, 49.451159696807], [0.21769119265823, 49.452963282619], [0.19246153744669, 49.451459914922], [0.1738896350055, 49.456501326126], [0.12123966998691, 49.463194369813], [0.11663179558052, 49.468668951933], [0.090696994632536, 49.482114939562], [0.093998128223838, 49.493022491933], [0.086909848300058, 49.501426737567], [0.069553018028324, 49.506394515928], [0.065609431053556, 49.512574780191], [0.074935648312722, 49.536327644008], [0.096662241910689, 49.566865543968], [0.10673209691871, 49.583498812584], [0.13691446853437, 49.620054067093], [0.1545404481146, 49.648638840156], [0.15041940420529, 49.654089298171], [0.15745336474727, 49.662409366742], [0.16435786084442, 49.683595262249], [0.16902493112731, 49.690718055481], [0.18958482856705, 49.704795514512], [0.21166902744322, 49.714464279709], [0.23734601222366, 49.719026316153], [0.28325599543364, 49.73657572055], [0.3054297000562, 49.741647940405], [0.32055583850936, 49.741550113943], [0.35492089191875, 49.755006661783], [0.36447312419198, 49.764320270499], [0.3742717461751, 49.768687702238], [0.40291800519761, 49.776954241768], [0.42846422682965, 49.786277467203], [0.48354180865604, 49.808256679169], [0.50625084522888, 49.819729645976], [0.52275149356329, 49.824531278036], [0.53443430957787, 49.833749077935], [0.57293876242844, 49.849717051188], [0.63455572059055, 49.86165150765], [0.64204209247477, 49.864190596157], [0.67449107487386, 49.867359871226], [0.70196726010642, 49.871881124641], [0.73355874170037, 49.870614655047], [0.76972675735512, 49.872091970828], [0.79097157704249, 49.875749307356], [0.83667159834277, 49.889522498512], [0.88434934728582, 49.896715247569], [0.92979339254159, 49.906736769842], [0.95467186229888, 49.91831807638], [0.96318320357221, 49.919860176009], [1.0200494254731, 49.916107227482], [1.065897535547, 49.925609301563], [1.0809062558413, 49.932292873025], [1.1109703384695, 49.939082116247], [1.1629209730147, 49.957022281774], [1.1845869056976, 49.966360150471], [1.1943755832405, 49.968033261783], [1.2080962672336, 49.979831426538], [1.2332915838912, 49.988728375641], [1.2997853981801, 50.029578582167], [1.3170167914747, 50.03625056502], [1.3324268900416, 50.047124707032], [1.3672027614548, 50.062608452248], [1.3796981484469, 50.065011890414], [1.3924400221587, 50.060056426893], [1.4088347782602, 50.057247377816], [1.4235940727692, 50.070851596042], [1.4464534693489, 50.069324171563], [1.4591516246417, 50.062494643478], [1.455286116297, 50.056298876577], [1.4564566095824, 50.037832374442], [1.4734926140971, 50.033599846345], [1.4933105925107, 50.017740486409], [1.50103897683, 50.018915984928], [1.5180154200133, 50.00910228757], [1.5270192186573, 49.996530516122], [1.5465597760538, 49.987581734127], [1.5582578959792, 49.979389381286], [1.5738903148936, 49.973921649667], [1.5940092903756, 49.949050560009], [1.6182113660007, 49.937822139755], [1.6784507673607, 49.918130568802], [1.6932946158985, 49.895601909585], [1.7124562091314, 49.886444322648], [1.7117443909555, 49.87371820092], [1.7187325614081, 49.865708141834], [1.7195139243408, 49.85406661499], [1.724683271591, 49.845733284166], [1.7270527964865, 49.828882279702], [1.7373867941575, 49.808209452072], [1.7544750364007, 49.790629917937], [1.7579284899296, 49.780795399895], [1.7728042654107, 49.77686925316], [1.7844715649337, 49.763592975395], [1.7838342426767, 49.758309270134], [1.7471451565537, 49.757054329335], [1.7416291636029, 49.751631106006], [1.7409502199257, 49.738588067086], [1.7232343899458, 49.730085190671], [1.7121688003106, 49.731959147918], [1.7151877298233, 49.712819627841], [1.7119859825186, 49.707713850498], [1.6895744511517, 49.694787428191], [1.7045184506731, 49.68092815534], [1.7177073271231, 49.684373173475], [1.7214282927506, 49.691450681445], [1.7375343076769, 49.700350145116], [1.7506387449271, 49.693804769865], [1.7521845944048, 49.680960782507], [1.7251990095943, 49.672636996929], [1.72256553641, 49.661514170983], [1.7034537142049, 49.645178379124], [1.7046286111408, 49.639706031745], [1.7172522158626, 49.633071609694], [1.7216033847573, 49.621992077342], [1.7045833964597, 49.60539714358], [1.6951880268931, 49.599725188693], [1.7079026298891, 49.59512101877], [1.7094013142782, 49.586713688098], [1.7216170199559, 49.588805803542], [1.7147772726003, 49.576403299976], [1.7296224523484, 49.561514722426], [1.727181881084, 49.541625548343], [1.7446099134771, 49.539601433398], [1.7451293471854, 49.531735853612], [1.7309415306325, 49.516127433413], [1.7192339956449, 49.508224831919], [1.7254532581616, 49.499781817922], [1.7387428193977, 49.499646659524], [1.7437037722862, 49.495260515275], [1.7579593630441, 49.508955782237], [1.7718616459246, 49.512848245546], [1.79022549105, 49.503468309638], [1.7874800747665, 49.493410636962], [1.7741026603547, 49.484110404638], [1.7758155194349, 49.475733185704], [1.7663409121222, 49.466149422943], [1.7477144178281, 49.459538435118], [1.7512558538526, 49.452315507953], [1.7375744776703, 49.448744348943], [1.7325062090143, 49.440346816415], [1.7227989638177, 49.433057939568], [1.7207550257388, 49.421790744656], [1.7139306567281, 49.409224915677], [1.7401057248725, 49.405314790651], [1.7203128039946, 49.39483019677], [1.74121389808, 49.381720558637], [1.747580532548, 49.37311965741], [1.7594132403395, 49.36814533573], [1.7576982127616, 49.356710604078], [1.7727704938425, 49.333136370328], [1.7676000740408, 49.315889978292], [1.7756247174004, 49.29969367954], [1.796488015906, 49.284111717893], [1.7932298788283, 49.274330698204], [1.8026740663848, 49.271947858898], [1.7918059477748, 49.256427629819], [1.7895339086741, 49.247870747839], [1.7668935671793, 49.252034345086], [1.7643549601555, 49.263082374151], [1.7547213954529, 49.270007807429], [1.7104820360249, 49.264465989242], [1.7014183926808, 49.252460272045], [1.699042864415, 49.234864303276], [1.7043588288241, 49.232197221792], [1.7040643483737, 49.229320472612], [1.6757423007191, 49.21186711807], [1.6769552220057, 49.202542812736], [1.6670168601861, 49.178613559023], [1.6643792614171, 49.153368483471], [1.6539225302112, 49.145440634177], [1.655781502711, 49.130164014177], [1.6470910019222, 49.124713530921], [1.6175344667245, 49.093996514155], [1.6233233619235, 49.086078404348], [1.608798807603, 49.077894185227], [1.6044866350314, 49.08303659502], [1.5747375500157, 49.078437534581], [1.5570743762242, 49.069620586462], [1.5494725491086, 49.072557881924], [1.5217716034178, 49.068546693163], [1.5116006058281, 49.074136193201], [1.5032944474047, 49.059098256736], [1.4848766880401, 49.0515451317], [1.4608012364168, 49.062739598254], [1.4472851104304, 49.053509472828], [1.4474286969633, 49.04518889808], [1.4579533584639, 49.03483279821], [1.4577570076778, 49.026294572016], [1.4721822976397, 49.018490972378], [1.4787512905862, 48.998884682872], [1.4609202371105, 48.986433838647], [1.4706099672547, 48.975306435494], [1.4770931932159, 48.978791319268], [1.497416022081, 48.979551284823], [1.5079088220123, 48.98376724437], [1.5155485568584, 48.976406187821], [1.4966058957223, 48.969344788938], [1.5010590902862, 48.952678048634], [1.5015266013113, 48.941051842112], [1.4806477281429, 48.940490376837], [1.4613112437714, 48.937555310548], [1.4594110528379, 48.928926959252], [1.4479593034805, 48.924639965044], [1.4593261044838, 48.914649076535], [1.4606700524523, 48.900494617753], [1.4683545148033, 48.892215598584], [1.4653628424762, 48.877601417126], [1.4549936915991, 48.870326164498], [1.4343110180818, 48.866140106761], [1.4238934051882, 48.861268418973], [1.4093657222488, 48.861152641723], [1.3968565494996, 48.855383585466], [1.3905601143901, 48.8466061658], [1.3621823366519, 48.834179921179], [1.3592476591605, 48.813608561344], [1.3769627320869, 48.791766336256], [1.3744255946955, 48.782613836125], [1.3626643019013, 48.781664300017], [1.3422322124976, 48.772542324536], [1.3329054445301, 48.762612355286], [1.3195444496148, 48.76096144137], [1.3002968590985, 48.767536812046], [1.2799854142834, 48.762674216595], [1.2702130511038, 48.757482633762], [1.2545465453882, 48.758629272206], [1.2562637586379, 48.765103705723], [1.246023632927, 48.769675823998], [1.2226160798083, 48.767292140423], [1.223526519249, 48.758056658402], [1.1981446610666, 48.769568542277], [1.1847360438338, 48.772630245963], [1.161542788993, 48.769293220083], [1.1533037151721, 48.774016041266], [1.1521150110915, 48.78555968408], [1.1213959532999, 48.789195509733], [1.1189842149957, 48.782375233568], [1.1209842348348, 48.767249558527], [1.1126577960236, 48.751863710692], [1.0957264674684, 48.748713222693], [1.086000043818, 48.756926389494], [1.0757811283562, 48.749437927852], [1.0686653703661, 48.756913559557], [1.0590712054157, 48.756765184439], [1.0398026909049, 48.742155339], [1.0316499412576, 48.730581545643], [1.0206075605327, 48.734789446779], [1.0140639866541, 48.72810030179], [0.98441493173502, 48.725995395669], [0.9772943914531, 48.730138669646], [0.96144420763056, 48.725722137279], [0.95524192597313, 48.716786068922], [0.92119872414556, 48.709175212814], [0.90239998073196, 48.710649225086], [0.88836808739528, 48.718920532577], [0.87671116761022, 48.715496114803], [0.86149783759132, 48.691007914902], [0.85036287028898, 48.682948048025], [0.82767132893029, 48.680720042791], [0.8148247207739, 48.670163564137], [0.81294886563427, 48.660510127486], [0.82392074530028, 48.650041826767], [0.8226824397504, 48.640053608418], [0.83140562696703, 48.633774446005], [0.81775390390063, 48.616320066598], [0.81963618816719, 48.609871113214], [0.83304661425976, 48.61077016626], [0.8465873876382, 48.604782622076], [0.85063536439017, 48.582625709205], [0.86767573670944, 48.573488250275], [0.89126612131175, 48.572177428167], [0.92638981194521, 48.559394233279], [0.93876307137649, 48.550558547099], [0.922603461355, 48.537716017396], [0.95341814083771, 48.526244433476], [0.96655146260943, 48.522741687979], [0.9540037271624, 48.503840229688], [0.94155894503993, 48.498694713572], [0.95436935096035, 48.490573966149], [0.95629262450835, 48.482279378048], [0.93571270291242, 48.475553807957], [0.94226766472979, 48.457733974776], [0.95840880937073, 48.44259696324], [0.9762713097259, 48.439081867809], [0.9482686361643, 48.417831978233], [0.94224603424783, 48.399004844657], [0.93117784919562, 48.391265934635], [0.9149193773197, 48.374324097325], [0.90184278255778, 48.373449772268], [0.88337252111541, 48.356669121421], [0.87015714346989, 48.35834027017], [0.86181253481946, 48.350897961325], [0.84159508492141, 48.350229728169], [0.82785590745519, 48.342447024282], [0.81840111266411, 48.349420439199], [0.78542500970172, 48.340430711536], [0.78418514184216, 48.334478837721], [0.77313762601396, 48.325511221527], [0.76219430247254, 48.306876639515], [0.76023175104941, 48.298171659555], [0.77758221552843, 48.302840856139], [0.79341825616719, 48.293008635712], [0.79426147145466, 48.284950588985], [0.78587084890053, 48.271138465423], [0.78758977714986, 48.261313612339], [0.80241465108887, 48.248072322927], [0.80608653469826, 48.239891017509], [0.82588953248827, 48.220721830264], [0.83048365574563, 48.210708729507], [0.80626900151784, 48.203016266265], [0.79765841643139, 48.19445496608], [0.76407918474979, 48.181599665308], [0.75566254080812, 48.181981836049], [0.73782963836386, 48.189069627691], [0.73014979083029, 48.200521766169], [0.72363045806996, 48.19813955141], [0.7165758658899, 48.212094515686], [0.68321966914477, 48.2485882228], [0.67547108490982, 48.254740726504], [0.65315095543918, 48.263702677988], [0.64070530481206, 48.261221689671], [0.63190429889268, 48.254754506701], [0.63315984470535, 48.245553870078], [0.57919146406902, 48.24436440048], [0.56099429972633, 48.245949063769], [0.55013843367508, 48.249395520335], [0.53597049486367, 48.249844560134], [0.53848634108307, 48.256987820339], [0.5303000454288, 48.265496730429], [0.51293004449183, 48.266874483366], [0.49455647283795, 48.28681567575], [0.50702990447062, 48.295832610533], [0.48757654033176, 48.307795859172], [0.48050090924161, 48.298592258919], [0.46361198113469, 48.305016107657], [0.44279870606142, 48.304629310064], [0.43133408375288, 48.306638667446], [0.42688901989368, 48.315425242308], [0.41599578567133, 48.321625198799], [0.4062203560807, 48.314621149851], [0.3954029644226, 48.320549965535], [0.38260989677575, 48.333828412247], [0.38047838823167, 48.341797530871], [0.38828549911199, 48.349122009475], [0.38255236381737, 48.359498801305], [0.37865893857906, 48.383227765197], [0.37386118731698, 48.386969757082], [0.37537215739256, 48.395740224588], [0.37172370405574, 48.410451667862], [0.38150787714381, 48.417547978808], [0.38066015166482, 48.425411796164], [0.36771793204951, 48.438272682172], [0.36395632992898, 48.451631721658], [0.35578465090337, 48.458217063582], [0.33874148490671, 48.461599536909], [0.32727632603609, 48.471072305832], [0.31789727296834, 48.471938210212], [0.29585588821524, 48.480174860693], [0.27593434536664, 48.479055127239], [0.26286221529839, 48.482954540393], [0.25857807031538, 48.476710383834], [0.22939338887665, 48.472578001816], [0.21823241324651, 48.473790546424], [0.18981304225187, 48.461891344828], [0.18125494041244, 48.464965078387], [0.16972375424173, 48.461776714307], [0.16965670000587, 48.449364042801], [0.15610127663516, 48.454794932825], [0.15811789380158, 48.4440164218], [0.15131906064063, 48.437226845695], [0.11624768586472, 48.435555660302], [0.09917046478078, 48.41034986941], [0.083580132468228, 48.411137710408], [0.067826622948661, 48.406115400716], [0.056684859958794, 48.393974400454], [0.062489872264419, 48.382213868151], [0.020992722816365, 48.380200925309], [0.0065863250934992, 48.388521385965], [-0.0025641291874286, 48.397311951396], [-0.020363541559243, 48.393656323667], [-0.022054721991416, 48.388059994444], [-0.035753099663116, 48.384874683334], [-0.050692623162423, 48.375201195715], [-0.054527208218665, 48.382004461206], [-0.052691042298523, 48.392979240085], [-0.05669039654505, 48.398915618731], [-0.053012801512314, 48.412716132961], [-0.057355677768335, 48.42850299559], [-0.049909790963035, 48.447628170085], [-0.051890589271637, 48.453255414135], [-0.072707535476378, 48.456927943118], [-0.073006901765828, 48.450527118516], [-0.10641182796282, 48.447519773766], [-0.12454179598033, 48.449239552758], [-0.14871763477939, 48.458069224847], [-0.15336586853021, 48.476724917968], [-0.14958860992305, 48.479781866844], [-0.15856042497356, 48.496817021301], [-0.1720909995602, 48.502134649047], [-0.16634047065468, 48.51558387484], [-0.15568415360731, 48.520496772763], [-0.14501210976342, 48.521000343601], [-0.14460271813847, 48.527754338423], [-0.16937878261294, 48.536973156988], [-0.1899589987284, 48.548884398226], [-0.19398633186269, 48.554824404734], [-0.20694246592994, 48.562946447212], [-0.22107424204732, 48.560317301834], [-0.23435242732491, 48.562336320193], [-0.24264015511442, 48.567994064435], [-0.26180425334438, 48.54789519181], [-0.24635660161985, 48.542620878313], [-0.24176789393774, 48.536388956089], [-0.25395512234333, 48.525985631213], [-0.26580141522268, 48.522782191648], [-0.27155353070113, 48.507447568195], [-0.27823048075492, 48.506986142113], [-0.30280889062491, 48.517340998248], [-0.32023332020671, 48.522923755915], [-0.34337759223335, 48.500849863584], [-0.35582138041634, 48.495673571366], [-0.35349558279054, 48.483897081468], [-0.36723974711241, 48.487748985001], [-0.3676233888649, 48.492944315138], [-0.39345664138171, 48.501835194106], [-0.3991855056689, 48.510158714286], [-0.41273449116925, 48.506498004612], [-0.42497181740742, 48.507282953736], [-0.43075652123879, 48.51181625112], [-0.46226332328429, 48.512709151203], [-0.47060334996255, 48.509716651644], [-0.47820460128897, 48.501565713987], [-0.48849507