import datetime

from tests.utils.tests_utils import test_function

from geoformat.conversion.metadata_conversion import (
    geometries_scan_to_geometries_metadata,
    fields_scan_to_fields_metadata,
    get_field_name_list_ordered_by_i_field,
)
from geoformat import reorder_metadata_field_index_after_field_drop

from tests.data.fields_metadata import (
    geolayer_attributes_only_fields_metadata,
    geolayer_attributes_only_fields_metadata_without_index,
)

geometries_scan_to_geometries_metadata_parameters = {
    0: {
        "geometry_scan": {"type": {"Polygon", "MultiPolygon"}, "extent": None},
        "extent": False,
        "crs": None,
        "return_value": {"type": {"Polygon", "MultiPolygon"}},
    },
    1: {
        "geometry_scan": {"type": {"Polygon", "MultiPolygon"}, "extent": None},
        "extent": True,
        "crs": None,
        "return_value": {"type": {"Polygon", "MultiPolygon"}},
    },
    2: {
        "geometry_scan": {"type": None, "extent": None},
        "extent": False,
        "crs": None,
        "return_value": None,
    },
    3: {
        "geometry_scan": {"type": None, "extent": None},
        "extent": True,
        "crs": None,
        "return_value": None,
    },
    4: {
        "geometry_scan": {"type": {"Polygon"}, "extent": None},
        "crs": None,
        "extent": True,
        "return_value": {"type": {"Polygon"}},
    },
    5: {
        "geometry_scan": {
            "type": {
                "Point",
                "LineString",
                "Polygon",
                "MultiPoint",
                "MultiLineString",
                "MultiPolygon",
                "GeometryCollection",
            },
            "extent": None,
        },
        "crs": None,
        "extent": True,
        "return_value": {
            "type": {
                "Point",
                "LineString",
                "Polygon",
                "MultiPoint",
                "MultiLineString",
                "MultiPolygon",
                "GeometryCollection",
            }
        },
    },
    6: {
        "geometry_scan": {"type": {"Polygon", "MultiPolygon"}, "extent": None},
        "crs": None,
        "extent": True,
        "return_value": {"type": {"Polygon", "MultiPolygon"}},
    },
    7: {
        "geometry_scan": {
            "type": {"Polygon", "MultiPolygon"},
            "extent": (124277.0, 6050136.0, 1242213.0, 7110430.0),
        },
        "crs": None,
        "extent": True,
        "return_value": {
            "type": {"Polygon", "MultiPolygon"},
            "extent": (124277.0, 6050136.0, 1242213.0, 7110430.0),
        },
    },
    8: {
        "geometry_scan": {"type": None, "extent": None},
        "crs": None,
        "extent": True,
        "return_value": None,
    },
    9: {
        "geometry_scan": {
            "type": {"Polygon"},
            "extent": (382932.0, 6743442.0, 790134.0, 6997000.0),
        },
        "crs": None,
        "extent": True,
        "return_value": {
            "type": {"Polygon"},
            "extent": (382932.0, 6743442.0, 790134.0, 6997000.0),
        },
    },
    10: {
        "geometry_scan": {
            "type": {
                "Point",
                "LineString",
                "Polygon",
                "MultiPoint",
                "MultiLineString",
                "MultiPolygon",
                "GeometryCollection",
            },
            "extent": (-157.97, -34.29, 35.12, 77.95),
        },
        "crs": None,
        "extent": True,
        "return_value": {
            "type": {
                "Point",
                "LineString",
                "Polygon",
                "MultiPoint",
                "MultiLineString",
                "MultiPolygon",
                "GeometryCollection",
            },
            "extent": (-157.97, -34.29, 35.12, 77.95),
        },
    },
    11: {
        "geometry_scan": {
            "type": {"Polygon", "MultiPolygon"},
            "extent": (124277.0, 6050136.0, 1242213.0, 7110430.0),
        },
        "extent": True,
        "crs": 2154,
        "return_value": {
            "type": {"Polygon", "MultiPolygon"},
            "extent": (124277.0, 6050136.0, 1242213.0, 7110430.0),
            "crs": 2154,
        },
    },
    12: {
        "geometry_scan": {
            "type": {
                "Point",
                "LineString",
                "Polygon",
                "MultiPoint",
                "MultiLineString",
                "MultiPolygon",
                "GeometryCollection",
            },
            "extent": (-157.97, -34.29, 35.12, 77.95),
        },
        "extent": True,
        "crs": 4326,
        "return_value": {
            "type": {
                "Point",
                "LineString",
                "Polygon",
                "MultiPoint",
                "MultiLineString",
                "MultiPolygon",
                "GeometryCollection",
            },
            "extent": (-157.97, -34.29, 35.12, 77.95),
            "crs": 4326,
        },
    },
}

fields_scan_to_fields_metadata_parameters = {
    0: {
        "fields_scan": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {float},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 12,
                "field_width_list": 13,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": True,
                "native_type": {str, int, float},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 7,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 19,
                "field_width_list": 6,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": True,
                "native_type": {str, datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": False,
                "native_type": {datetime.date},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 6,
                "field_recast": True,
                "native_type": {str, datetime.time},
                "str_is_always_hexadecimal": False,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 7,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": True,
                "native_type": {bool, int},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": False,
                "native_type": {str},
                "str_is_always_hexadecimal": False,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 16,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 10,
                "field_recast": False,
                "native_type": {str},
                "str_is_always_hexadecimal": False,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_index": 11,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
        "return_value": {
            "field_integer": {"type": "Real", "width": 4, "precision": 0, "index": 0},
            "field_integer_list": {"type": "String", "width": 13, "index": 1},
            "field_real": {"type": "String", "width": 7, "index": 2},
            "field_real_list": {"type": "String", "width": 19, "index": 3},
            "field_string": {"type": "String", "width": 26, "index": 4},
            "field_date": {"type": "Date", "index": 5},
            "field_time": {"type": "String", "width": 15, "index": 6},
            "field_binary": {"type": "String", "width": 201, "index": 7},
            "field_boolean": {"type": "String", "width": 5, "index": 8},
            "field_none": {"type": "String", "width": 4, "index": 9},
            "field_string_list": {"type": "String", "width": 16, "index": 10},
            "field_datetime": {"type": "DateTime", "index": 11},
        },
    },
    1: {
        "fields_scan": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {float},
                "str_is_always_hexadecimal": None,
                "force_type": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 12,
                "field_width_list": 13,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int, float},
                "str_is_always_hexadecimal": False,
                "force_type": False,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 7,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 19,
                "field_width_list": 6,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, int},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, datetime.time},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_recast": True,
                "native_type": {bool, int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 16,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": True,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
        "return_value": {
            "field_integer": {"type": "Real", "width": 4, "precision": 0},
            "field_integer_list": {"type": "String", "width": 13},
            "field_real": {"type": "String", "width": 7},
            "field_real_list": {"type": "String", "width": 19},
            "field_string": {"type": "String", "width": 26},
            "field_date": {"type": "Date"},
            "field_time": {"type": "String", "width": 15},
            "field_binary": {"type": "String", "width": 201},
            "field_boolean": {"type": "String", "width": 5},
            "field_none": {"type": "String", "width": 4},
            "field_string_list": {"type": "String", "width": 16},
            "field_datetime": {"type": "DateTime"},
        },
    },
    2: {
        "fields_scan": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 3,
                "width_before_comma": 3,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": True,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": False,
                "native_type": {float},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 6,
                "field_recast": False,
                "native_type": set(),
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 7,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 10,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 11,
                "field_recast": False,
                "native_type": {bool},
                "force_type": True,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
        "return_value": {
            "field_integer": {"type": "Integer", "index": 0},
            "field_integer_list": {"type": "IntegerList", "index": 1},
            "field_real": {"type": "Integer", "index": 2},
            "field_real_list": {
                "type": "RealList",
                "width": 10,
                "precision": 5,
                "index": 3,
            },
            "field_string": {"type": "String", "width": 5, "index": 4},
            "field_string_list": {"type": "StringList", "width": 8, "index": 5},
            "field_date": {"type": "Date", "index": 6},
            "field_time": {"type": "Time", "index": 7},
            "field_datetime": {"type": "DateTime", "index": 8},
            "field_binary": {"type": "Binary", "index": 9},
            "field_boolean": {"type": "Boolean", "index": 10},
        },
    },
    3: {
        "fields_scan": {
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": False,
                "native_type": {int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": False,
                "native_type": {int},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": float,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": False,
                "native_type": {float},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": False,
                "native_type": {str},
                "force_type": False,
                "str_is_always_hexadecimal": False,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 6,
                "field_recast": False,
                "native_type": set(),
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 7,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 10,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 11,
                "field_recast": False,
                "native_type": {bool},
                "force_type": False,
                "str_is_always_hexadecimal": None,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
        },
        "return_value": {
            "field_integer": {"type": "Integer", "index": 0},
            "field_integer_list": {"type": "IntegerList", "index": 1},
            "field_real": {"type": "Real", "width": 4, "precision": 0, "index": 2},
            "field_real_list": {
                "type": "RealList",
                "width": 10,
                "precision": 5,
                "index": 3,
            },
            "field_string": {"type": "String", "width": 5, "index": 4},
            "field_string_list": {"type": "StringList", "width": 8, "index": 5},
            "field_date": {"type": "Date", "index": 6},
            "field_time": {"type": "Time", "index": 7},
            "field_datetime": {"type": "DateTime", "index": 8},
            "field_binary": {"type": "Binary", "index": 9},
            "field_boolean": {"type": "Boolean", "index": 10},
        },
    },
    4: {
        "fields_scan": {
            "field_none": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 0,
                "field_recast": False,
                "native_type": set(),
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_integer": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 3,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 1,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_integer_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": int,
                "field_width_str": 4,
                "field_width_list": 12,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 2,
                "field_recast": False,
                "native_type": {int},
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": int,
                "field_width_str": 6,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 3,
                "field_recast": True,
                "native_type": {float},
                "force_type": True,
                "field_width_float": 4,
                "width_before_comma": 4,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_real_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": float,
                "field_width_str": 10,
                "field_width_list": 24,
                "field_precision": 5,
                "none_value": False,
                "not_none_value": True,
                "field_index": 4,
                "field_recast": False,
                "native_type": {float},
                "force_type": True,
                "field_width_float": 10,
                "width_before_comma": 5,
                "width_after_comma": 5,
                "field_delete": False,
            },
            "field_string": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": str,
                "field_width_str": 5,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 5,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_string_list": {
                "values_in_list": True,
                "values_out_list": False,
                "field_list": True,
                "field_type": str,
                "field_width_str": 8,
                "field_width_list": 23,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 6,
                "field_recast": False,
                "native_type": {str},
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none_1": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 7,
                "field_recast": False,
                "native_type": set(),
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_date": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.date,
                "field_width_str": 10,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 8,
                "field_recast": False,
                "native_type": {datetime.date},
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_time": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.time,
                "field_width_str": 15,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 9,
                "field_recast": False,
                "native_type": {datetime.time},
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none_2": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 10,
                "field_recast": False,
                "native_type": set(),
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_none_3": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 11,
                "field_recast": False,
                "native_type": set(),
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
            "field_datetime": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": datetime.datetime,
                "field_width_str": 26,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 12,
                "field_recast": False,
                "native_type": {datetime.datetime},
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 13,
                "field_recast": False,
                "native_type": {bytes},
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_boolean": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bool,
                "field_width_str": 4,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 14,
                "field_recast": False,
                "native_type": {bool},
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            },
            "field_none_4": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": None,
                "field_width_str": 0,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": True,
                "not_none_value": False,
                "field_index": 15,
                "field_recast": False,
                "native_type": set(),
                "force_type": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": True,
            },
        },
        "return_value": {
            "field_integer": {"type": "Integer", "index": 0},
            "field_integer_list": {"type": "IntegerList", "index": 1},
            "field_real": {"type": "Integer", "index": 2},
            "field_real_list": {
                "type": "RealList",
                "width": 10,
                "precision": 5,
                "index": 3,
            },
            "field_string": {"type": "String", "width": 5, "index": 4},
            "field_string_list": {"type": "StringList", "width": 8, "index": 5},
            "field_date": {"type": "Date", "index": 6},
            "field_time": {"type": "Time", "index": 7},
            "field_datetime": {"type": "DateTime", "index": 8},
            "field_binary": {"type": "Binary", "index": 9},
            "field_boolean": {"type": "Boolean", "index": 10},
        },
    },
    5: {
        "fields_scan": {
            "field_binary": {
                "values_in_list": False,
                "values_out_list": True,
                "field_list": False,
                "field_type": bytes,
                "field_width_str": 201,
                "field_width_list": None,
                "field_precision": 0,
                "none_value": False,
                "not_none_value": True,
                "field_index": 0,
                "field_recast": True,
                "native_type": {str, bytes},
                "force_type": True,
                "str_is_always_hexadecimal": True,
                "field_width_float": 0,
                "width_before_comma": 0,
                "width_after_comma": 0,
                "field_delete": False,
            }
        },
        "return_value": {"field_binary": {"type": "Binary", "index": 0}},
    },
}

get_field_name_list_ordered_by_i_field_parameters = {
    0: {
        "fields_metadata": geolayer_attributes_only_fields_metadata,
        "return_value": [
            "field_integer",
            "field_integer_list",
            "field_real",
            "field_real_list",
            "field_string",
            "field_string_list",
            "field_date",
            "field_time",
            "field_datetime",
            "field_binary",
            "field_boolean",
        ],
    },
    1: {
        "fields_metadata": geolayer_attributes_only_fields_metadata_without_index,
        "return_value": [
            "field_integer",
            "field_integer_list",
            "field_real",
            "field_real_list",
            "field_string",
            "field_string_list",
            "field_date",
            "field_time",
            "field_datetime",
            "field_binary",
            "field_boolean",
        ],
    },
    2: {
        "fields_metadata": {'commune': {'type': 'String', 'width': 254, 'index': 2}, 'id_uic': {'type': 'Real', 'width': 19, 'precision': 11, 'index': 0}, 'id_ligne': {'type': 'String', 'width': 254, 'index': 1}, 'dpt': {'type': 'String', 'width': 254, 'index': 3}},
        "return_value": ['id_uic', 'id_ligne', 'commune', 'dpt']
    }
}


def test_all():
    # geometries_scan_to_metadata
    print(
        test_function(
            geometries_scan_to_geometries_metadata,
            geometries_scan_to_geometries_metadata_parameters,
        )
    )

    # fields_scan_to_fields_metadata
    print(
        test_function(
            fields_scan_to_fields_metadata, fields_scan_to_fields_metadata_parameters
        )
    )

    # get_field_name_list_ordered_by_i_field
    print(
        test_function(
            get_field_name_list_ordered_by_i_field,
            get_field_name_list_ordered_by_i_field_parameters,
        )
    )

if __name__ == "__main__":
    test_all()
