import copy
import datetime

from tests.data.metadata import (
    metadata_fr_dept_data_and_geometry,
    metadata_fr_dept_data_only,
    metadata_fr_dept_geometry_only,
    metadata_paris_velib,
    metadata_attributes_to_force_in_str,
    metadata_attributes_only,
    metadata_fr_dept_population,
    metadata_fr_dept_population_geometry,
    metadata_fr_dept_population_geometry_right,
    metadata_geometry_only_all_geometries_type,
    metadata_geometry_2d,
    metadata_geometry_3d
)

from tests.data.fields_metadata import (
    geolayer_attributes_only_fields_metadata,
    geolayer_attributes_only_fields_metadata_rename,
    geolayer_data_fields_metadata_complete,
    geolayer_data_fields_metadata_extract,
)

from tests.data.features import (
    feature_attributes_only,
    feature_attributes_only_rename,
    feature_attributes_only_without_none_field,
    feature_attributes_only_boolean_false,
    feature_structure_alpha_1,
    feature_structure_alpha_2,
    feature_structure_alpha_3,
    feature_dpt_data_only_a,
    feature_dpt_data_only_b,
    feature_dpt_data_only_c,
    feature_dpt_data_only_d,
    feature_dpt_geometry_only_a,
    feature_dpt_geometry_only_b,
    feature_dpt_geometry_only_c,
    feature_dpt_geometry_only_d,
    feature_dpt_data_and_geometry_a,
    feature_dpt_data_and_geometry_b,
    feature_dpt_data_and_geometry_c,
    feature_dpt_data_and_geometry_d,
    feature_dpt_population_a,
    feature_dpt_population_b,
    feature_dpt_population_c,
    feature_dpt_population_d,
    feature_dpt_population_geometry_a,
    feature_dpt_population_geometry_b,
    feature_dpt_population_geometry_c,
    feature_dpt_population_geometry_d,
    feature_dpt_data_and_geometry_a_serialized,
    feature_dpt_data_and_geometry_b_serialized,
    feature_dpt_data_and_geometry_c_serialized,
    feature_dpt_data_and_geometry_d_serialized,
    feature_attributes_bytes_only_a,
    feature_attributes_bytes_only_b,
    feature_attributes_bytes_only_c,
    feature_geometry_only_point,
    feature_geometry_only_point_empty,
    feature_geometry_only_linestring,
    feature_geometry_only_linestring_empty,
    feature_geometry_only_polygon,
    feature_geometry_only_polygon_empty,
    feature_geometry_only_multipoint,
    feature_geometry_only_multipoint_empty,
    feature_geometry_only_multilinestring,
    feature_geometry_only_multilinestring_empty,
    feature_geometry_only_multipolygon,
    feature_geometry_only_multipolygon_empty,
    feature_geometry_only_collection,
    feature_geometry_only_collection_empty,
    feature_geometry_only_collection_with_empty_geometries,
    feature_geometry_2d,
    feature_geometry_3d,
)

from tests.data.geometries import (
    POINT_WKB_BIG_ENDIAN,
    GEOMETRYCOLLECTION_WKB_BIG_ENDIAN,
    POINT_WKB_HEX_BIG_ENDIAN,
    GEOMETRYCOLLECTION_WKB_HEX_BIG_ENDIAN,
)

from geoformat.conversion.metadata_conversion import (
    get_field_name_list_ordered_by_i_field,
)
from geoformat.manipulation.geolayer_manipulation import rename_field
from geoformat.processing.data.clauses import clause_where
from geoformat.conversion.geolayer_conversion import create_geolayer_from_i_feat_list

date_time_value = datetime.datetime(
    year=2020, month=3, day=31, hour=11, minute=22, second=10, microsecond=999
)
date_value = date_time_value.date()

time_value = date_time_value.time()

geolayer_attributes_only = {
    "metadata": metadata_attributes_only,
    "features": {0: feature_attributes_only},
}

geolayer_attributes_only_rename = {
    "metadata": {
        "name": "attributes_only",
        "fields": geolayer_attributes_only_fields_metadata_rename,
    },
    "features": {0: feature_attributes_only_rename},
}

geolayer_attributes_only_without_none_value = {
    "metadata": {
        "name": "attributes_only",
        "fields": geolayer_attributes_only_fields_metadata,
    },
    "features": {0: feature_attributes_only_without_none_field},
}

geolayer_attributes_only_boolean_false = {
    "metadata": {
        "name": "attributes_only_boolean_false",
        "fields": geolayer_attributes_only_fields_metadata,
    },
    "features": {0: feature_attributes_only_boolean_false},
}

geolayer_attributes_to_force_only = {
    "metadata": {"name": "geolayer_attributes_to_force_only"},
    "features": {
        0: feature_structure_alpha_1,
        1: feature_structure_alpha_2,
        2: feature_structure_alpha_3,
    },
}

geolayer_attributes_to_force_in_str = {
    "metadata": metadata_attributes_to_force_in_str,
    "features": {
        0: {
            "attributes": {
                "field_integer": "586",
                "field_integer_list": "[5879, 8557]",
                "field_real": "8789.98",
                "field_real_list": "[89798.3654, 8757.0]",
                "field_string": "",
                "field_date": "2020-03-31",
                "field_time": "18:41:04",
                "field_binary": "00000000040000000200000000010000000000000000000000000000000000000000013ff00000000000003ff0000000000000",
                "field_boolean": "True",
                "field_string_list": "",
                "field_datetime": "",
            }
        },
        1: {
            "attributes": {
                "field_integer": "1466",
                "field_integer_list": "[987, 2345]",
                "field_real": "8789.0",
                "field_real_list": "[2.0, 5.0]",
                "field_string": "salut",
                "field_date": "",
                "field_time": "11:22:10.000999",
                "field_binary": "000000000140eff36b0a3d70a440bde68b020c49ba",
                "field_boolean": "False",
                "field_string_list": "['hi', 'mister']",
                "field_datetime": "2020-03-31 11:22:10.000999",
            }
        },
        2: {
            "attributes": {
                "field_integer": "149",
                "field_integer_list": "[987, 2345]",
                "field_real": "8789.0",
                "field_real_list": "[2.0, 5.0]",
                "field_string": "2020-03-31 11:22:10.000999",
                "field_date": "",
                "field_time": "11:22:10.000999",
                "field_binary": "000000000140eff36b0a3d70a440bde68b020c49ba",
                "field_boolean": "True",
                "field_string_list": "['hi', 'mister']",
                "field_datetime": "2020-03-31 11:22:10.000999",
            }
        },
    },
}

geolayer_attributes_to_force_only_forced = {
    "metadata": {
        "name": "geolayer_attributes_to_force_only",
        "fields": {
            "field_integer": {"type": "Integer", "index": 0},
            "field_integer_list": {"type": "IntegerList", "index": 1},
            "field_real": {"type": "Real", "width": 6, "precision": 2, "index": 2},
            "field_real_list": {
                "type": "RealList",
                "width": 9,
                "precision": 4,
                "index": 3,
            },
            "field_string": {"type": "String", "width": 26, "index": 4},
            "field_date": {"type": "Date", "index": 5},
            "field_time": {"type": "Time", "index": 6},
            "field_binary": {"type": "Binary", "index": 7},
            "field_boolean": {"type": "Boolean", "index": 8},
            "field_string_list": {"type": "StringList", "width": 6, "index": 9},
            "field_datetime": {"type": "DateTime", "index": 10},
        },
    },
    "features": {
        0: {
            "attributes": {
                "field_integer": 586,
                "field_integer_list": [5879, 8557],
                "field_real": 8789.98,
                "field_real_list": [89798.3654, 8757.0],
                "field_string": None,
                "field_date": datetime.date(2020, 3, 31),
                "field_time": datetime.time(18, 41, 4),
                "field_binary": b"\x00\x00\x00\x00\x04\x00\x00\x00\x02\x00\x00\x00\x00\x01\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x01?\xf0\x00\x00\x00\x00\x00\x00?\xf0\x00\x00\x00\x00\x00\x00",
                "field_boolean": True,
                "field_string_list": None,
                "field_datetime": None,
            }
        },
        1: {
            "attributes": {
                "field_integer": 1466,
                "field_integer_list": [987, 2345],
                "field_real": 8789.0,
                "field_real_list": [2.0, 5.0],
                "field_string": "salut",
                "field_date": None,
                "field_time": datetime.time(11, 22, 10, 999),
                "field_binary": b"\x00\x00\x00\x00\x01@\xef\xf3k\n=p\xa4@\xbd\xe6\x8b\x02\x0cI\xba",
                "field_boolean": False,
                "field_string_list": ["hi", "mister"],
                "field_datetime": datetime.datetime(2020, 3, 31, 11, 22, 10, 999),
            }
        },
        2: {
            "attributes": {
                "field_integer": 149,
                "field_integer_list": [987, 2345],
                "field_real": 8789.0,
                "field_real_list": [2.0, 5.0],
                "field_string": "2020-03-31 11:22:10.000999",
                "field_date": None,
                "field_time": datetime.time(11, 22, 10, 999),
                "field_binary": b"\x00\x00\x00\x00\x01@\xef\xf3k\n=p\xa4@\xbd\xe6\x8b\x02\x0cI\xba",
                "field_boolean": True,
                "field_string_list": ["hi", "mister"],
                "field_datetime": datetime.datetime(2020, 3, 31, 11, 22, 10, 999),
            }
        },
    },
}

geolayer_geometry_only_all_geometries_type = {
    "metadata": metadata_geometry_only_all_geometries_type,
    "features": {
        0: feature_geometry_only_point,
        1: feature_geometry_only_point_empty,
        2: feature_geometry_only_linestring,
        3: feature_geometry_only_linestring_empty,
        4: feature_geometry_only_polygon,
        5: feature_geometry_only_polygon_empty,
        6: feature_geometry_only_multipoint,
        7: feature_geometry_only_multipoint_empty,
        8: feature_geometry_only_multilinestring,
        9: feature_geometry_only_multilinestring_empty,
        10: feature_geometry_only_multipolygon,
        11: feature_geometry_only_multipolygon_empty,
        12: feature_geometry_only_collection,
        13: feature_geometry_only_collection_empty,
        14: feature_geometry_only_collection_with_empty_geometries,
    },
}

geolayer_geometry_2d = {
    "metadata": metadata_geometry_2d,
    "features": {0: feature_geometry_2d}
}

geolayer_geometry_3d = {
    "metadata": metadata_geometry_3d,
    "features": {0: feature_geometry_3d}
}

geolayer_attributes_to_force_only_2 = {
    "metadata": {"name": "geolayer_attributes_to_force_only"},
    "features": {
        0: {"attributes": {"test": "['stop', 'covid']"}},
        1: {"attributes": {"test": ["stop", "aids"]}},
        2: {"attributes": {"test": [42]}},
    },
}

geolayer_fr_dept_data_and_geometry = {
    "metadata": metadata_fr_dept_data_and_geometry,
    "features": {
        0: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [505760.0, 6248691.0],
                        [509767.0, 6249274.0],
                        [514960.0, 6255730.0],
                        [523428.0, 6259977.0],
                        [531230.0, 6258583.0],
                        [536034.0, 6253601.0],
                        [539594.0, 6265818.0],
                        [554723.0, 6278961.0],
                        [550482.0, 6283435.0],
                        [545681.0, 6284750.0],
                        [535303.0, 6300840.0],
                        [531445.0, 6300603.0],
                        [531142.0, 6309545.0],
                        [528381.0, 6316132.0],
                        [520187.0, 6318466.0],
                        [528536.0, 6329188.0],
                        [521740.0, 6328834.0],
                        [519117.0, 6332164.0],
                        [512956.0, 6327891.0],
                        [507637.0, 6333951.0],
                        [502833.0, 6331375.0],
                        [496470.0, 6331745.0],
                        [495008.0, 6328849.0],
                        [483787.0, 6325253.0],
                        [474692.0, 6327970.0],
                        [465465.0, 6324803.0],
                        [465239.0, 6317398.0],
                        [461632.0, 6315722.0],
                        [453303.0, 6321029.0],
                        [444807.0, 6320573.0],
                        [440195.0, 6315550.0],
                        [443572.0, 6313646.0],
                        [442698.0, 6298315.0],
                        [439499.0, 6295895.0],
                        [438084.0, 6281592.0],
                        [443497.0, 6282643.0],
                        [449863.0, 6280833.0],
                        [456497.0, 6283051.0],
                        [457450.0, 6278664.0],
                        [461941.0, 6273297.0],
                        [466465.0, 6272970.0],
                        [468215.0, 6263513.0],
                        [471536.0, 6256527.0],
                        [479309.0, 6257879.0],
                        [496988.0, 6250664.0],
                        [505760.0, 6248691.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"},
        },
        1: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [547193.0, 6388334.0],
                        [539761.0, 6395885.0],
                        [530971.0, 6390971.0],
                        [526858.0, 6394383.0],
                        [527849.0, 6401566.0],
                        [514373.0, 6400391.0],
                        [512334.0, 6403639.0],
                        [495031.0, 6397493.0],
                        [491196.0, 6399384.0],
                        [489091.0, 6407815.0],
                        [486169.0, 6410676.0],
                        [474628.0, 6407547.0],
                        [472909.0, 6402270.0],
                        [476701.0, 6399758.0],
                        [474218.0, 6394851.0],
                        [464993.0, 6388179.0],
                        [460343.0, 6383021.0],
                        [460366.0, 6373402.0],
                        [462536.0, 6370133.0],
                        [454032.0, 6364649.0],
                        [457916.0, 6359953.0],
                        [455164.0, 6354504.0],
                        [449164.0, 6352477.0],
                        [449759.0, 6344226.0],
                        [459734.0, 6343570.0],
                        [462757.0, 6341305.0],
                        [470769.0, 6340294.0],
                        [467874.0, 6336236.0],
                        [464468.0, 6326808.0],
                        [465465.0, 6324803.0],
                        [474692.0, 6327970.0],
                        [483787.0, 6325253.0],
                        [495008.0, 6328849.0],
                        [496470.0, 6331745.0],
                        [502833.0, 6331375.0],
                        [507637.0, 6333951.0],
                        [512956.0, 6327891.0],
                        [519117.0, 6332164.0],
                        [520115.0, 6336256.0],
                        [529462.0, 6338671.0],
                        [533815.0, 6350996.0],
                        [536387.0, 6355171.0],
                        [530427.0, 6360537.0],
                        [531660.0, 6365290.0],
                        [544593.0, 6364542.0],
                        [545774.0, 6366277.0],
                        [541673.0, 6377661.0],
                        [542159.0, 6383881.0],
                        [547193.0, 6388334.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "47", "NOM_DEPT": "LOT-ET-GARONNE"},
        },
        2: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [841110.0, 6468164.0],
                        [847361.0, 6468209.0],
                        [855768.0, 6473591.0],
                        [860939.0, 6470947.0],
                        [866406.0, 6463235.0],
                        [870728.0, 6463360.0],
                        [871909.0, 6454823.0],
                        [871457.0, 6445038.0],
                        [888053.0, 6440277.0],
                        [892767.0, 6444271.0],
                        [895595.0, 6439026.0],
                        [895949.0, 6427870.0],
                        [894862.0, 6413405.0],
                        [907889.0, 6409384.0],
                        [918546.0, 6403480.0],
                        [921863.0, 6404787.0],
                        [925560.0, 6409806.0],
                        [930672.0, 6410433.0],
                        [933177.0, 6416064.0],
                        [939410.0, 6420031.0],
                        [941569.0, 6417648.0],
                        [947667.0, 6423241.0],
                        [956742.0, 6422339.0],
                        [960775.0, 6424797.0],
                        [965006.0, 6422921.0],
                        [964872.0, 6432532.0],
                        [961377.0, 6439340.0],
                        [952342.0, 6439924.0],
                        [953909.0, 6450690.0],
                        [956276.0, 6452799.0],
                        [950505.0, 6456663.0],
                        [945165.0, 6465401.0],
                        [945461.0, 6470305.0],
                        [949441.0, 6473761.0],
                        [948557.0, 6482085.0],
                        [943964.0, 6486985.0],
                        [938381.0, 6486658.0],
                        [931624.0, 6492445.0],
                        [925224.0, 6482705.0],
                        [917457.0, 6486189.0],
                        [913763.0, 6489603.0],
                        [904449.0, 6504924.0],
                        [897998.0, 6515860.0],
                        [888123.0, 6525941.0],
                        [888996.0, 6528631.0],
                        [882529.0, 6534232.0],
                        [879159.0, 6530984.0],
                        [876089.0, 6523611.0],
                        [870291.0, 6521483.0],
                        [863140.0, 6525920.0],
                        [862850.0, 6517700.0],
                        [865784.0, 6514252.0],
                        [858527.0, 6506228.0],
                        [848198.0, 6502534.0],
                        [841056.0, 6498593.0],
                        [845846.0, 6493277.0],
                        [837308.0, 6485557.0],
                        [837457.0, 6475559.0],
                        [841110.0, 6468164.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "38", "NOM_DEPT": "ISERE"},
        },
        3: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [634422.0, 7101577.0],
                        [623701.0, 7099214.0],
                        [610465.0, 7094261.0],
                        [605814.0, 7089013.0],
                        [599885.0, 7086576.0],
                        [601399.0, 7078135.0],
                        [598139.0, 7067917.0],
                        [599563.0, 7049801.0],
                        [597332.0, 7035063.0],
                        [603193.0, 7029103.0],
                        [605232.0, 7026713.0],
                        [612989.0, 7030025.0],
                        [622831.0, 7024302.0],
                        [624801.0, 7021563.0],
                        [634147.0, 7017146.0],
                        [635372.0, 7012312.0],
                        [648121.0, 7014552.0],
                        [654991.0, 7012592.0],
                        [660837.0, 7014835.0],
                        [663948.0, 7010834.0],
                        [656343.0, 7006536.0],
                        [658067.0, 7000416.0],
                        [662547.0, 7004433.0],
                        [667892.0, 7004913.0],
                        [669642.0, 7001764.0],
                        [689814.0, 6997681.0],
                        [691147.0, 6993758.0],
                        [706470.0, 6995042.0],
                        [706855.0, 7002888.0],
                        [711164.0, 7009522.0],
                        [712383.0, 7015916.0],
                        [699507.0, 7031355.0],
                        [702680.0, 7038239.0],
                        [701478.0, 7042709.0],
                        [697493.0, 7046164.0],
                        [692820.0, 7044918.0],
                        [687641.0, 7047582.0],
                        [686184.0, 7056263.0],
                        [688698.0, 7062196.0],
                        [683642.0, 7063001.0],
                        [679720.0, 7059405.0],
                        [673807.0, 7057943.0],
                        [664277.0, 7059477.0],
                        [658064.0, 7064147.0],
                        [653390.0, 7071778.0],
                        [644454.0, 7079622.0],
                        [642453.0, 7087769.0],
                        [636514.0, 7100652.0],
                        [634422.0, 7101577.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "62", "NOM_DEPT": "PAS-DE-CALAIS"},
        },
        4: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [776081.0, 6923412.0],
                        [782994.0, 6923346.0],
                        [790665.0, 6921022.0],
                        [795010.0, 6915033.0],
                        [803525.0, 6909934.0],
                        [814643.0, 6911926.0],
                        [818364.0, 6905215.0],
                        [822754.0, 6907655.0],
                        [833062.0, 6905548.0],
                        [837898.0, 6908256.0],
                        [842092.0, 6905887.0],
                        [849280.0, 6910207.0],
                        [847303.0, 6917040.0],
                        [853548.0, 6926776.0],
                        [849442.0, 6935263.0],
                        [853210.0, 6945817.0],
                        [856532.0, 6942619.0],
                        [867310.0, 6942452.0],
                        [873032.0, 6949057.0],
                        [869864.0, 6950495.0],
                        [863792.0, 6957578.0],
                        [856370.0, 6957018.0],
                        [850915.0, 6964755.0],
                        [848735.0, 6964497.0],
                        [834935.0, 6970707.0],
                        [833403.0, 6975569.0],
                        [835414.0, 6979112.0],
                        [832902.0, 6984653.0],
                        [828614.0, 6985882.0],
                        [833821.0, 7001508.0],
                        [834466.0, 7007583.0],
                        [830491.0, 7008459.0],
                        [826108.0, 7005649.0],
                        [820627.0, 6997569.0],
                        [821199.0, 6989850.0],
                        [814347.0, 6988595.0],
                        [808498.0, 6984157.0],
                        [803958.0, 6983050.0],
                        [795770.0, 6985807.0],
                        [788558.0, 6985051.0],
                        [789845.0, 6973793.0],
                        [787172.0, 6965431.0],
                        [790134.0, 6962730.0],
                        [781387.0, 6953785.0],
                        [779463.0, 6948255.0],
                        [774574.0, 6946610.0],
                        [777906.0, 6941851.0],
                        [775403.0, 6934852.0],
                        [776081.0, 6923412.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "08", "NOM_DEPT": "ARDENNES"},
        },
        5: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [730707.0, 6810078.0],
                        [736893.0, 6807760.0],
                        [745765.0, 6796957.0],
                        [746161.0, 6791892.0],
                        [749678.0, 6782304.0],
                        [755033.0, 6785741.0],
                        [759917.0, 6778325.0],
                        [763413.0, 6765164.0],
                        [767353.0, 6760249.0],
                        [783028.0, 6759096.0],
                        [789480.0, 6763963.0],
                        [796594.0, 6759156.0],
                        [797692.0, 6763119.0],
                        [808147.0, 6762855.0],
                        [816397.0, 6764598.0],
                        [817962.0, 6771080.0],
                        [827043.0, 6770243.0],
                        [825768.0, 6776095.0],
                        [828770.0, 6781171.0],
                        [835407.0, 6779651.0],
                        [837598.0, 6783989.0],
                        [837935.0, 6797546.0],
                        [834073.0, 6806764.0],
                        [827022.0, 6811887.0],
                        [822210.0, 6820200.0],
                        [823302.0, 6827043.0],
                        [819107.0, 6829393.0],
                        [814106.0, 6826118.0],
                        [803526.0, 6829924.0],
                        [796995.0, 6835851.0],
                        [797551.0, 6845278.0],
                        [785824.0, 6845891.0],
                        [779497.0, 6845091.0],
                        [773768.0, 6840880.0],
                        [769985.0, 6834113.0],
                        [760761.0, 6824301.0],
                        [753955.0, 6826609.0],
                        [746802.0, 6826973.0],
                        [740952.0, 6835710.0],
                        [737148.0, 6833964.0],
                        [731262.0, 6826009.0],
                        [728998.0, 6813854.0],
                        [730707.0, 6810078.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "10", "NOM_DEPT": "AUBE"},
        },
        6: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1009696.0, 6370071.0],
                        [1002665.0, 6364730.0],
                        [997268.0, 6357103.0],
                        [994698.0, 6348019.0],
                        [1000668.0, 6338218.0],
                        [1000089.0, 6334256.0],
                        [1007601.0, 6328762.0],
                        [1009068.0, 6324850.0],
                        [1014122.0, 6322114.0],
                        [1012050.0, 6317690.0],
                        [1007566.0, 6320724.0],
                        [1000978.0, 6315262.0],
                        [997097.0, 6315251.0],
                        [992638.0, 6305621.0],
                        [1002326.0, 6300425.0],
                        [1003290.0, 6292496.0],
                        [1006552.0, 6288390.0],
                        [1015523.0, 6285590.0],
                        [1014132.0, 6274778.0],
                        [1018256.0, 6272482.0],
                        [1020971.0, 6279894.0],
                        [1026533.0, 6279746.0],
                        [1033109.0, 6287175.0],
                        [1036126.0, 6293135.0],
                        [1041921.0, 6296903.0],
                        [1048217.0, 6297561.0],
                        [1064350.0, 6309506.0],
                        [1061225.0, 6317546.0],
                        [1066133.0, 6321494.0],
                        [1066468.0, 6326676.0],
                        [1072800.0, 6330433.0],
                        [1073742.0, 6336784.0],
                        [1077560.0, 6342698.0],
                        [1073403.0, 6350462.0],
                        [1060282.0, 6348576.0],
                        [1054180.0, 6344806.0],
                        [1042408.0, 6347558.0],
                        [1034654.0, 6353189.0],
                        [1025044.0, 6356596.0],
                        [1020000.0, 6356725.0],
                        [1018585.0, 6361599.0],
                        [1009696.0, 6370071.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "06", "NOM_DEPT": "ALPES-MARITIMES"},
        },
        7: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [753779.0, 6537018.0],
                        [758503.0, 6532097.0],
                        [754369.0, 6520637.0],
                        [760734.0, 6514163.0],
                        [764154.0, 6503988.0],
                        [770440.0, 6500348.0],
                        [774454.0, 6495613.0],
                        [776221.0, 6483674.0],
                        [770335.0, 6479388.0],
                        [770263.0, 6473476.0],
                        [776677.0, 6475557.0],
                        [780259.0, 6472021.0],
                        [792166.0, 6477709.0],
                        [802398.0, 6475469.0],
                        [807029.0, 6471772.0],
                        [806856.0, 6463705.0],
                        [811227.0, 6465007.0],
                        [816370.0, 6460772.0],
                        [825694.0, 6462649.0],
                        [826509.0, 6469123.0],
                        [831517.0, 6473257.0],
                        [837457.0, 6475559.0],
                        [837308.0, 6485557.0],
                        [834511.0, 6489782.0],
                        [829797.0, 6488843.0],
                        [825934.0, 6498617.0],
                        [818524.0, 6498224.0],
                        [809870.0, 6504594.0],
                        [806255.0, 6511913.0],
                        [808147.0, 6518212.0],
                        [807296.0, 6530310.0],
                        [802643.0, 6534285.0],
                        [800220.0, 6540120.0],
                        [801039.0, 6547667.0],
                        [798995.0, 6551156.0],
                        [802035.0, 6559678.0],
                        [810991.0, 6564128.0],
                        [806993.0, 6569822.0],
                        [798969.0, 6562707.0],
                        [797273.0, 6565101.0],
                        [787355.0, 6564848.0],
                        [785138.0, 6567101.0],
                        [776287.0, 6563809.0],
                        [774989.0, 6567447.0],
                        [768620.0, 6568680.0],
                        [769267.0, 6575508.0],
                        [762003.0, 6573092.0],
                        [760949.0, 6561975.0],
                        [763504.0, 6554575.0],
                        [762385.0, 6549859.0],
                        [763887.0, 6544360.0],
                        [761084.0, 6541876.0],
                        [754888.0, 6541809.0],
                        [753779.0, 6537018.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "42", "NOM_DEPT": "LOIRE"},
        },
        8: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [505760.0, 6248691.0],
                        [506455.0, 6246240.0],
                        [501020.0, 6240519.0],
                        [500952.0, 6237523.0],
                        [491741.0, 6229153.0],
                        [498958.0, 6224762.0],
                        [501199.0, 6216194.0],
                        [506394.0, 6214104.0],
                        [501753.0, 6199863.0],
                        [493715.0, 6200925.0],
                        [492032.0, 6195420.0],
                        [491362.0, 6184305.0],
                        [493119.0, 6181125.0],
                        [509918.0, 6181609.0],
                        [507071.0, 6189939.0],
                        [508439.0, 6196068.0],
                        [512551.0, 6198492.0],
                        [524704.0, 6194181.0],
                        [522873.0, 6204718.0],
                        [526458.0, 6208824.0],
                        [535012.0, 6210452.0],
                        [537386.0, 6214080.0],
                        [535770.0, 6220735.0],
                        [540236.0, 6224348.0],
                        [541984.0, 6228895.0],
                        [547328.0, 6230443.0],
                        [554118.0, 6225953.0],
                        [555809.0, 6233248.0],
                        [562910.0, 6233771.0],
                        [567825.0, 6236309.0],
                        [561407.0, 6244405.0],
                        [565565.0, 6247682.0],
                        [572065.0, 6240985.0],
                        [575081.0, 6235814.0],
                        [582028.0, 6242918.0],
                        [589272.0, 6240503.0],
                        [593467.0, 6242482.0],
                        [598408.0, 6250205.0],
                        [603733.0, 6249863.0],
                        [603060.0, 6255463.0],
                        [607574.0, 6261192.0],
                        [611672.0, 6256714.0],
                        [621363.0, 6260238.0],
                        [620519.0, 6263967.0],
                        [609628.0, 6269734.0],
                        [605052.0, 6276459.0],
                        [594074.0, 6282175.0],
                        [597601.0, 6285124.0],
                        [595737.0, 6291653.0],
                        [592076.0, 6294561.0],
                        [590928.0, 6301074.0],
                        [586632.0, 6302842.0],
                        [583878.0, 6308763.0],
                        [583992.0, 6314318.0],
                        [575242.0, 6309509.0],
                        [567948.0, 6310839.0],
                        [568130.0, 6303820.0],
                        [556606.0, 6298479.0],
                        [550735.0, 6304341.0],
                        [535303.0, 6300840.0],
                        [545681.0, 6284750.0],
                        [550482.0, 6283435.0],
                        [554723.0, 6278961.0],
                        [539594.0, 6265818.0],
                        [536034.0, 6253601.0],
                        [531230.0, 6258583.0],
                        [523428.0, 6259977.0],
                        [514960.0, 6255730.0],
                        [509767.0, 6249274.0],
                        [505760.0, 6248691.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "31", "NOM_DEPT": "HAUTE-GARONNE"},
        },
        9: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [806993.0, 6569822.0],
                        [808209.0, 6578315.0],
                        [815826.0, 6575242.0],
                        [824653.0, 6575157.0],
                        [830305.0, 6579430.0],
                        [833486.0, 6565745.0],
                        [837322.0, 6565642.0],
                        [839484.0, 6574938.0],
                        [845050.0, 6590960.0],
                        [845229.0, 6595067.0],
                        [848718.0, 6603737.0],
                        [857422.0, 6600366.0],
                        [868758.0, 6603264.0],
                        [869949.0, 6598870.0],
                        [877344.0, 6596683.0],
                        [885325.0, 6599852.0],
                        [880824.0, 6605207.0],
                        [886706.0, 6618161.0],
                        [882575.0, 6628163.0],
                        [880659.0, 6638936.0],
                        [887343.0, 6642371.0],
                        [876345.0, 6647462.0],
                        [872158.0, 6650880.0],
                        [871408.0, 6655745.0],
                        [860161.0, 6652754.0],
                        [855755.0, 6655507.0],
                        [831500.0, 6648015.0],
                        [823470.0, 6650227.0],
                        [813434.0, 6659755.0],
                        [806754.0, 6662035.0],
                        [806631.0, 6665548.0],
                        [795506.0, 6668991.0],
                        [791663.0, 6673495.0],
                        [789554.0, 6672918.0],
                        [784602.0, 6669828.0],
                        [780471.0, 6669516.0],
                        [778810.0, 6664936.0],
                        [781374.0, 6662136.0],
                        [779000.0, 6654397.0],
                        [778932.0, 6646959.0],
                        [783308.0, 6642195.0],
                        [780490.0, 6638662.0],
                        [781064.0, 6632682.0],
                        [775685.0, 6631211.0],
                        [770503.0, 6626941.0],
                        [760920.0, 6622686.0],
                        [756196.0, 6628301.0],
                        [748049.0, 6627896.0],
                        [748734.0, 6623209.0],
                        [753291.0, 6618069.0],
                        [756931.0, 6607772.0],
                        [761463.0, 6602522.0],
                        [763922.0, 6603795.0],
                        [768312.0, 6598303.0],
                        [773476.0, 6599308.0],
                        [776586.0, 6596649.0],
                        [775079.0, 6589273.0],
                        [775913.0, 6580395.0],
                        [769267.0, 6575508.0],
                        [768620.0, 6568680.0],
                        [774989.0, 6567447.0],
                        [776287.0, 6563809.0],
                        [785138.0, 6567101.0],
                        [787355.0, 6564848.0],
                        [797273.0, 6565101.0],
                        [798969.0, 6562707.0],
                        [806993.0, 6569822.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "71", "NOM_DEPT": "SAONE-ET-LOIRE"},
        },
        10: {
            "attributes": {"CODE_DEPT": "53", "NOM_DEPT": "MAYENNE"},
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [399495.0, 6830885.0],
                        [398130.0, 6822559.0],
                        [400321.0, 6810723.0],
                        [395852.0, 6803336.0],
                        [398626.0, 6784333.0],
                        [400465.0, 6781914.0],
                        [400197.0, 6773697.0],
                        [394099.0, 6773357.0],
                        [390140.0, 6770978.0],
                        [386941.0, 6760260.0],
                        [382932.0, 6754022.0],
                        [389872.0, 6749698.0],
                        [393110.0, 6750366.0],
                        [402067.0, 6747685.0],
                        [404251.0, 6751414.0],
                        [412442.0, 6746090.0],
                        [419671.0, 6744167.0],
                        [429458.0, 6743442.0],
                        [440863.0, 6746201.0],
                        [446732.0, 6745443.0],
                        [446459.0, 6750432.0],
                        [442128.0, 6753611.0],
                        [448124.0, 6758669.0],
                        [447308.0, 6764356.0],
                        [455060.0, 6767070.0],
                        [451057.0, 6776681.0],
                        [459373.0, 6778102.0],
                        [460615.0, 6783387.0],
                        [458409.0, 6789055.0],
                        [466280.0, 6794064.0],
                        [465298.0, 6799724.0],
                        [467628.0, 6811401.0],
                        [473893.0, 6813452.0],
                        [474394.0, 6821359.0],
                        [467262.0, 6822174.0],
                        [466087.0, 6830999.0],
                        [463434.0, 6833996.0],
                        [457920.0, 6827997.0],
                        [451256.0, 6826715.0],
                        [446687.0, 6829012.0],
                        [441174.0, 6828584.0],
                        [437568.0, 6825109.0],
                        [429868.0, 6822252.0],
                        [422197.0, 6821752.0],
                        [414934.0, 6829326.0],
                        [407934.0, 6831360.0],
                        [404267.0, 6828490.0],
                        [399495.0, 6830885.0],
                    ]
                ],
            },
        },
        11: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [459784.0, 6545825.0],
                        [457303.0, 6539406.0],
                        [458386.0, 6534878.0],
                        [455132.0, 6526680.0],
                        [449713.0, 6524677.0],
                        [445866.0, 6528260.0],
                        [434480.0, 6521530.0],
                        [434607.0, 6512022.0],
                        [436951.0, 6506668.0],
                        [442913.0, 6501478.0],
                        [446521.0, 6493231.0],
                        [444696.0, 6489309.0],
                        [445861.0, 6484044.0],
                        [443202.0, 6478722.0],
                        [447267.0, 6474282.0],
                        [456356.0, 6470307.0],
                        [455660.0, 6465791.0],
                        [461242.0, 6465553.0],
                        [464807.0, 6459164.0],
                        [468806.0, 6462928.0],
                        [474561.0, 6460744.0],
                        [485798.0, 6470195.0],
                        [484697.0, 6477489.0],
                        [489646.0, 6488189.0],
                        [493466.0, 6488572.0],
                        [504657.0, 6496986.0],
                        [505177.0, 6505055.0],
                        [513233.0, 6510903.0],
                        [515635.0, 6515544.0],
                        [522412.0, 6520738.0],
                        [522669.0, 6525452.0],
                        [527825.0, 6527023.0],
                        [534383.0, 6537804.0],
                        [540666.0, 6541823.0],
                        [539507.0, 6547743.0],
                        [531290.0, 6552122.0],
                        [531964.0, 6561069.0],
                        [526089.0, 6562344.0],
                        [521367.0, 6557890.0],
                        [509938.0, 6556936.0],
                        [507509.0, 6562167.0],
                        [499249.0, 6554736.0],
                        [489751.0, 6554866.0],
                        [483517.0, 6558927.0],
                        [473907.0, 6559092.0],
                        [469589.0, 6554692.0],
                        [465641.0, 6555184.0],
                        [464645.0, 6548283.0],
                        [459784.0, 6545825.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "16", "NOM_DEPT": "CHARENTE"},
        },
        12: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [417723.0, 6857101.0],
                        [408651.0, 6861319.0],
                        [399642.0, 6861271.0],
                        [396867.0, 6868913.0],
                        [401493.0, 6871059.0],
                        [411444.0, 6881401.0],
                        [417375.0, 6892264.0],
                        [416434.0, 6899162.0],
                        [413253.0, 6901117.0],
                        [415797.0, 6907383.0],
                        [406933.0, 6907874.0],
                        [400663.0, 6914651.0],
                        [399047.0, 6920143.0],
                        [400759.0, 6925144.0],
                        [397607.0, 6926545.0],
                        [396597.0, 6932989.0],
                        [388320.0, 6946238.0],
                        [388687.0, 6950091.0],
                        [394381.0, 6955463.0],
                        [390587.0, 6963240.0],
                        [381046.0, 6965005.0],
                        [372051.0, 6959988.0],
                        [362230.0, 6961356.0],
                        [343652.0, 6969661.0],
                        [343012.0, 6963991.0],
                        [349037.0, 6960923.0],
                        [349892.0, 6952123.0],
                        [346450.0, 6948841.0],
                        [350114.0, 6938864.0],
                        [350193.0, 6931900.0],
                        [357636.0, 6924163.0],
                        [364780.0, 6906370.0],
                        [363427.0, 6896430.0],
                        [366480.0, 6887586.0],
                        [365701.0, 6878731.0],
                        [362959.0, 6869214.0],
                        [363872.0, 6859932.0],
                        [368562.0, 6852485.0],
                        [376547.0, 6847928.0],
                        [372261.0, 6845150.0],
                        [363309.0, 6845999.0],
                        [366767.0, 6839135.0],
                        [368413.0, 6830443.0],
                        [376536.0, 6826525.0],
                        [384742.0, 6834496.0],
                        [389634.0, 6835155.0],
                        [399495.0, 6830885.0],
                        [404267.0, 6828490.0],
                        [407934.0, 6831360.0],
                        [414934.0, 6829326.0],
                        [421619.0, 6835816.0],
                        [423498.0, 6841841.0],
                        [420581.0, 6852284.0],
                        [417723.0, 6857101.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "50", "NOM_DEPT": "MANCHE"},
        },
        13: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [590236.0, 6872273.0],
                        [594217.0, 6866696.0],
                        [596554.0, 6858123.0],
                        [595472.0, 6845570.0],
                        [597086.0, 6841311.0],
                        [604791.0, 6831646.0],
                        [608912.0, 6830618.0],
                        [611402.0, 6819097.0],
                        [620311.0, 6818025.0],
                        [623768.0, 6826369.0],
                        [627504.0, 6829048.0],
                        [627800.0, 6838438.0],
                        [632440.0, 6843248.0],
                        [634691.0, 6849194.0],
                        [643163.0, 6853168.0],
                        [637702.0, 6857774.0],
                        [637864.0, 6864035.0],
                        [641404.0, 6867928.0],
                        [641836.0, 6872490.0],
                        [633062.0, 6879807.0],
                        [628641.0, 6878089.0],
                        [622312.0, 6880731.0],
                        [614076.0, 6886919.0],
                        [606678.0, 6883543.0],
                        [603102.0, 6887292.0],
                        [598361.0, 6887345.0],
                        [591984.0, 6886421.0],
                        [587216.0, 6881812.0],
                        [590236.0, 6872273.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "78", "NOM_DEPT": "YVELINES"},
        },
        14: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [986155.0, 6724947.0],
                        [984341.0, 6721925.0],
                        [977033.0, 6724531.0],
                        [974258.0, 6721322.0],
                        [969354.0, 6721610.0],
                        [967469.0, 6716290.0],
                        [955890.0, 6718838.0],
                        [950918.0, 6717032.0],
                        [945847.0, 6708437.0],
                        [932449.0, 6699390.0],
                        [925719.0, 6696195.0],
                        [922029.0, 6697905.0],
                        [904021.0, 6688452.0],
                        [905832.0, 6683506.0],
                        [912920.0, 6678099.0],
                        [913407.0, 6674258.0],
                        [909981.0, 6669146.0],
                        [913780.0, 6661601.0],
                        [925599.0, 6657600.0],
                        [925393.0, 6653995.0],
                        [928880.0, 6645788.0],
                        [940225.0, 6640408.0],
                        [944367.0, 6635241.0],
                        [942748.0, 6631718.0],
                        [934547.0, 6625608.0],
                        [937312.0, 6621303.0],
                        [933274.0, 6616467.0],
                        [940343.0, 6611180.0],
                        [938167.0, 6613167.0],
                        [950995.0, 6626461.0],
                        [962319.0, 6634781.0],
                        [961533.0, 6640379.0],
                        [963711.0, 6649123.0],
                        [961099.0, 6653277.0],
                        [967437.0, 6658254.0],
                        [976505.0, 6662212.0],
                        [981857.0, 6667617.0],
                        [983508.0, 6674248.0],
                        [992174.0, 6680929.0],
                        [993793.0, 6685149.0],
                        [999048.0, 6690006.0],
                        [1001635.0, 6695987.0],
                        [1006570.0, 6701646.0],
                        [1002944.0, 6704539.0],
                        [995578.0, 6702427.0],
                        [996902.0, 6711079.0],
                        [994087.0, 6717743.0],
                        [993651.0, 6723596.0],
                        [986155.0, 6724947.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "25", "NOM_DEPT": "DOUBS"},
        },
        15: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [904250.0, 6825381.0],
                        [904895.0, 6830283.0],
                        [900379.0, 6832469.0],
                        [903561.0, 6837915.0],
                        [902927.0, 6847494.0],
                        [899528.0, 6852809.0],
                        [904125.0, 6862116.0],
                        [901302.0, 6871865.0],
                        [905066.0, 6875501.0],
                        [906433.0, 6884047.0],
                        [905859.0, 6891045.0],
                        [901739.0, 6893315.0],
                        [900172.0, 6898682.0],
                        [901547.0, 6903348.0],
                        [898091.0, 6905220.0],
                        [898652.0, 6915853.0],
                        [895087.0, 6927281.0],
                        [891117.0, 6929633.0],
                        [883576.0, 6926040.0],
                        [878534.0, 6930925.0],
                        [879041.0, 6935896.0],
                        [875512.0, 6946935.0],
                        [873032.0, 6949057.0],
                        [867310.0, 6942452.0],
                        [856532.0, 6942619.0],
                        [853210.0, 6945817.0],
                        [849442.0, 6935263.0],
                        [853548.0, 6926776.0],
                        [847303.0, 6917040.0],
                        [849280.0, 6910207.0],
                        [842092.0, 6905887.0],
                        [841416.0, 6900107.0],
                        [845429.0, 6892400.0],
                        [846791.0, 6883540.0],
                        [848915.0, 6882413.0],
                        [848655.0, 6874905.0],
                        [841874.0, 6870868.0],
                        [838677.0, 6859119.0],
                        [846329.0, 6850924.0],
                        [846365.0, 6844539.0],
                        [847795.0, 6838972.0],
                        [852692.0, 6834838.0],
                        [856191.0, 6834907.0],
                        [863008.0, 6828766.0],
                        [873603.0, 6822775.0],
                        [882722.0, 6816263.0],
                        [893443.0, 6818701.0],
                        [904250.0, 6825381.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "55", "NOM_DEPT": "MEUSE"},
        },
        16: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [486169.0, 6410676.0],
                        [482141.0, 6421330.0],
                        [476390.0, 6418176.0],
                        [469504.0, 6418931.0],
                        [461839.0, 6422164.0],
                        [466012.0, 6428425.0],
                        [464018.0, 6432038.0],
                        [469719.0, 6445475.0],
                        [467756.0, 6450339.0],
                        [460931.0, 6449393.0],
                        [457280.0, 6451647.0],
                        [452009.0, 6448234.0],
                        [444096.0, 6451365.0],
                        [437492.0, 6457585.0],
                        [433418.0, 6457450.0],
                        [431214.0, 6470295.0],
                        [421098.0, 6472770.0],
                        [418478.0, 6475494.0],
                        [406100.0, 6476140.0],
                        [404682.0, 6481482.0],
                        [399796.0, 6489042.0],
                        [386164.0, 6505245.0],
                        [380995.0, 6504145.0],
                        [375328.0, 6494206.0],
                        [373905.0, 6475097.0],
                        [366594.0, 6427323.0],
                        [365668.0, 6410104.0],
                        [370987.0, 6417061.0],
                        [380337.0, 6407555.0],
                        [382533.0, 6402380.0],
                        [376517.0, 6401861.0],
                        [367865.0, 6404553.0],
                        [364521.0, 6395279.0],
                        [361697.0, 6391399.0],
                        [361774.0, 6383396.0],
                        [373686.0, 6386677.0],
                        [375548.0, 6389853.0],
                        [383562.0, 6383958.0],
                        [381182.0, 6379048.0],
                        [388231.0, 6379327.0],
                        [393973.0, 6376334.0],
                        [403228.0, 6378937.0],
                        [411314.0, 6378206.0],
                        [411174.0, 6373203.0],
                        [418928.0, 6369127.0],
                        [419635.0, 6366255.0],
                        [426389.0, 6364119.0],
                        [430077.0, 6359927.0],
                        [429214.0, 6351421.0],
                        [438523.0, 6349285.0],
                        [442465.0, 6350467.0],
                        [445091.0, 6357381.0],
                        [449164.0, 6352477.0],
                        [455164.0, 6354504.0],
                        [457916.0, 6359953.0],
                        [454032.0, 6364649.0],
                        [462536.0, 6370133.0],
                        [460366.0, 6373402.0],
                        [460343.0, 6383021.0],
                        [464993.0, 6388179.0],
                        [474218.0, 6394851.0],
                        [476701.0, 6399758.0],
                        [472909.0, 6402270.0],
                        [474628.0, 6407547.0],
                        [486169.0, 6410676.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "33", "NOM_DEPT": "GIRONDE"},
        },
        17: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [503908.0, 6928958.0],
                        [498291.0, 6928808.0],
                        [490213.0, 6925480.0],
                        [480923.0, 6917694.0],
                        [474554.0, 6915313.0],
                        [465316.0, 6913926.0],
                        [451821.0, 6920480.0],
                        [444571.0, 6921849.0],
                        [429556.0, 6922759.0],
                        [420281.0, 6924935.0],
                        [414059.0, 6928862.0],
                        [403953.0, 6928646.0],
                        [400759.0, 6925144.0],
                        [399047.0, 6920143.0],
                        [400663.0, 6914651.0],
                        [406933.0, 6907874.0],
                        [415797.0, 6907383.0],
                        [413253.0, 6901117.0],
                        [416434.0, 6899162.0],
                        [417375.0, 6892264.0],
                        [411444.0, 6881401.0],
                        [401493.0, 6871059.0],
                        [396867.0, 6868913.0],
                        [399642.0, 6861271.0],
                        [408651.0, 6861319.0],
                        [417723.0, 6857101.0],
                        [427244.0, 6861949.0],
                        [446005.0, 6869054.0],
                        [449827.0, 6868751.0],
                        [454384.0, 6863198.0],
                        [457511.0, 6867107.0],
                        [469104.0, 6863978.0],
                        [475607.0, 6865852.0],
                        [484257.0, 6870962.0],
                        [489675.0, 6876299.0],
                        [491678.0, 6873174.0],
                        [500558.0, 6877307.0],
                        [504730.0, 6874732.0],
                        [510545.0, 6875400.0],
                        [512505.0, 6881741.0],
                        [508338.0, 6886469.0],
                        [512079.0, 6895331.0],
                        [509950.0, 6897618.0],
                        [509502.0, 6910309.0],
                        [505278.0, 6914121.0],
                        [503908.0, 6928958.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "14", "NOM_DEPT": "CALVADOS"},
        },
        18: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [915394.0, 6762341.0],
                        [919858.0, 6768473.0],
                        [924039.0, 6766004.0],
                        [929025.0, 6772821.0],
                        [935284.0, 6772098.0],
                        [936416.0, 6766072.0],
                        [941726.0, 6764118.0],
                        [951150.0, 6767749.0],
                        [956126.0, 6765947.0],
                        [959909.0, 6759629.0],
                        [964569.0, 6761737.0],
                        [968808.0, 6766577.0],
                        [972278.0, 6762245.0],
                        [982963.0, 6756697.0],
                        [986052.0, 6752778.0],
                        [987691.0, 6753958.0],
                        [993060.0, 6757264.0],
                        [991355.0, 6761730.0],
                        [993983.0, 6773739.0],
                        [998205.0, 6776671.0],
                        [1001795.0, 6789636.0],
                        [1006708.0, 6801985.0],
                        [1011125.0, 6809400.0],
                        [1005338.0, 6811635.0],
                        [1003109.0, 6819572.0],
                        [1004385.0, 6831654.0],
                        [994239.0, 6827289.0],
                        [987769.0, 6820181.0],
                        [982282.0, 6817771.0],
                        [973656.0, 6818945.0],
                        [964951.0, 6823820.0],
                        [963830.0, 6819154.0],
                        [935203.0, 6815546.0],
                        [930831.0, 6810526.0],
                        [919362.0, 6809623.0],
                        [910921.0, 6826770.0],
                        [904250.0, 6825381.0],
                        [893443.0, 6818701.0],
                        [882722.0, 6816263.0],
                        [878315.0, 6811920.0],
                        [883843.0, 6809100.0],
                        [896020.0, 6796835.0],
                        [901295.0, 6794520.0],
                        [899609.0, 6786135.0],
                        [895837.0, 6779219.0],
                        [900794.0, 6778635.0],
                        [906998.0, 6773750.0],
                        [908017.0, 6765028.0],
                        [912655.0, 6766332.0],
                        [915394.0, 6762341.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "88", "NOM_DEPT": "VOSGES"},
        },
        19: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [642856.0, 6724786.0],
                        [634456.0, 6720842.0],
                        [639501.0, 6716775.0],
                        [642622.0, 6708275.0],
                        [632231.0, 6698879.0],
                        [634922.0, 6687596.0],
                        [624165.0, 6685496.0],
                        [619951.0, 6688294.0],
                        [617060.0, 6680060.0],
                        [612147.0, 6680536.0],
                        [612309.0, 6675948.0],
                        [607114.0, 6670785.0],
                        [615265.0, 6667454.0],
                        [621646.0, 6669974.0],
                        [627833.0, 6667741.0],
                        [627981.0, 6660408.0],
                        [631131.0, 6657674.0],
                        [629301.0, 6648616.0],
                        [633457.0, 6642556.0],
                        [627496.0, 6637025.0],
                        [632500.0, 6630848.0],
                        [628673.0, 6627353.0],
                        [634340.0, 6622075.0],
                        [637665.0, 6611745.0],
                        [635550.0, 6606712.0],
                        [638969.0, 6598575.0],
                        [634893.0, 6595681.0],
                        [636090.0, 6591904.0],
                        [644784.0, 6591412.0],
                        [645179.0, 6595086.0],
                        [650317.0, 6601560.0],
                        [660370.0, 6603761.0],
                        [664479.0, 6602292.0],
                        [670500.0, 6605989.0],
                        [669145.0, 6615318.0],
                        [677474.0, 6626628.0],
                        [682775.0, 6624336.0],
                        [686837.0, 6626145.0],
                        [696943.0, 6633749.0],
                        [702446.0, 6632753.0],
                        [705186.0, 6641947.0],
                        [703828.0, 6645606.0],
                        [706033.0, 6650549.0],
                        [705753.0, 6657660.0],
                        [701762.0, 6662486.0],
                        [702129.0, 6669867.0],
                        [698614.0, 6680189.0],
                        [698745.0, 6684384.0],
                        [690449.0, 6694237.0],
                        [694642.0, 6704915.0],
                        [690565.0, 6713347.0],
                        [685430.0, 6710473.0],
                        [682544.0, 6713710.0],
                        [678869.0, 6710238.0],
                        [674282.0, 6709782.0],
                        [669909.0, 6717111.0],
                        [661757.0, 6718781.0],
                        [657729.0, 6723417.0],
                        [652875.0, 6720759.0],
                        [646396.0, 6725640.0],
                        [642856.0, 6724786.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "18", "NOM_DEPT": "CHER"},
        },
        20: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [779411.0, 6373918.0],
                        [785084.0, 6367917.0],
                        [783861.0, 6358147.0],
                        [791158.0, 6357807.0],
                        [800494.0, 6352553.0],
                        [802764.0, 6358131.0],
                        [806518.0, 6360956.0],
                        [819866.0, 6361270.0],
                        [824346.0, 6357163.0],
                        [831641.0, 6353746.0],
                        [831614.0, 6360351.0],
                        [832713.0, 6371581.0],
                        [835151.0, 6374038.0],
                        [834538.0, 6384016.0],
                        [835764.0, 6388411.0],
                        [841041.0, 6396655.0],
                        [839715.0, 6410394.0],
                        [844069.0, 6414766.0],
                        [848816.0, 6428161.0],
                        [844782.0, 6435636.0],
                        [842390.0, 6453321.0],
                        [841110.0, 6468164.0],
                        [837457.0, 6475559.0],
                        [831517.0, 6473257.0],
                        [826509.0, 6469123.0],
                        [825694.0, 6462649.0],
                        [816370.0, 6460772.0],
                        [813436.0, 6450097.0],
                        [808187.0, 6450395.0],
                        [808165.0, 6446004.0],
                        [801638.0, 6433950.0],
                        [796332.0, 6429870.0],
                        [791307.0, 6420019.0],
                        [782106.0, 6419872.0],
                        [781273.0, 6415520.0],
                        [774103.0, 6411136.0],
                        [768276.0, 6405343.0],
                        [771844.0, 6388592.0],
                        [775042.0, 6386528.0],
                        [779411.0, 6373918.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "07", "NOM_DEPT": "ARDECHE"},
        },
        21: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [776081.0, 6923412.0],
                        [775403.0, 6934852.0],
                        [777906.0, 6941851.0],
                        [774574.0, 6946610.0],
                        [779463.0, 6948255.0],
                        [781387.0, 6953785.0],
                        [790134.0, 6962730.0],
                        [787172.0, 6965431.0],
                        [789845.0, 6973793.0],
                        [788558.0, 6985051.0],
                        [781905.0, 6987282.0],
                        [778060.0, 6986162.0],
                        [770359.0, 6988977.0],
                        [766237.0, 6992385.0],
                        [753505.0, 6995276.0],
                        [751253.0, 6997000.0],
                        [744014.0, 6992056.0],
                        [739058.0, 6995179.0],
                        [735248.0, 6991264.0],
                        [725313.0, 6993104.0],
                        [720100.0, 6990781.0],
                        [716534.0, 6992565.0],
                        [712391.0, 6990404.0],
                        [713833.0, 6986563.0],
                        [708480.0, 6979518.0],
                        [705667.0, 6969289.0],
                        [708546.0, 6956332.0],
                        [707064.0, 6950845.0],
                        [709520.0, 6938240.0],
                        [706939.0, 6934901.0],
                        [711648.0, 6928031.0],
                        [706805.0, 6926038.0],
                        [706929.0, 6919738.0],
                        [698137.0, 6911415.0],
                        [701957.0, 6908433.0],
                        [704672.0, 6899225.0],
                        [710189.0, 6894765.0],
                        [705248.0, 6890863.0],
                        [712067.0, 6888882.0],
                        [712559.0, 6879371.0],
                        [722321.0, 6872132.0],
                        [724211.0, 6867685.0],
                        [729581.0, 6862815.0],
                        [735603.0, 6861428.0],
                        [738742.0, 6868146.0],
                        [744067.0, 6871735.0],
                        [747254.0, 6882494.0],
                        [743801.0, 6891376.0],
                        [745398.0, 6894771.0],
                        [751361.0, 6898188.0],
                        [747051.0, 6913033.0],
                        [761575.0, 6918670.0],
                        [767112.0, 6923360.0],
                        [775242.0, 6918312.0],
                        [776081.0, 6923412.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "02", "NOM_DEPT": "AISNE"},
        },
        22: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [334283.0, 6280551.0],
                        [327832.0, 6270658.0],
                        [324268.0, 6267623.0],
                        [314107.0, 6264613.0],
                        [316186.0, 6255555.0],
                        [321493.0, 6257288.0],
                        [325696.0, 6250142.0],
                        [329513.0, 6253905.0],
                        [334359.0, 6254169.0],
                        [344050.0, 6249226.0],
                        [343580.0, 6242296.0],
                        [340751.0, 6235590.0],
                        [335750.0, 6230517.0],
                        [338499.0, 6226346.0],
                        [344947.0, 6224142.0],
                        [346289.0, 6231519.0],
                        [352412.0, 6225527.0],
                        [355170.0, 6226484.0],
                        [373097.0, 6218255.0],
                        [377794.0, 6214129.0],
                        [388910.0, 6213290.0],
                        [393755.0, 6214784.0],
                        [395170.0, 6206882.0],
                        [409841.0, 6194695.0],
                        [412796.0, 6198151.0],
                        [418372.0, 6194685.0],
                        [422245.0, 6194862.0],
                        [428954.0, 6200122.0],
                        [428150.0, 6207547.0],
                        [431947.0, 6209367.0],
                        [431385.0, 6215423.0],
                        [437107.0, 6220297.0],
                        [440142.0, 6228799.0],
                        [443868.0, 6230545.0],
                        [446410.0, 6236240.0],
                        [454979.0, 6245934.0],
                        [452746.0, 6249402.0],
                        [457777.0, 6262698.0],
                        [451477.0, 6264635.0],
                        [454138.0, 6272903.0],
                        [449863.0, 6280833.0],
                        [443497.0, 6282643.0],
                        [438084.0, 6281592.0],
                        [433057.0, 6279053.0],
                        [424830.0, 6280287.0],
                        [421554.0, 6283529.0],
                        [412501.0, 6278002.0],
                        [403447.0, 6281078.0],
                        [399714.0, 6278404.0],
                        [394475.0, 6281218.0],
                        [385124.0, 6280151.0],
                        [377063.0, 6275535.0],
                        [367753.0, 6276986.0],
                        [362964.0, 6280741.0],
                        [352961.0, 6276001.0],
                        [342731.0, 6276517.0],
                        [338238.0, 6281381.0],
                        [334283.0, 6280551.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "64", "NOM_DEPT": "PYRENEES-ATLANTIQUES"},
        },
        23: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [642856.0, 6724786.0],
                        [640167.0, 6731164.0],
                        [620646.0, 6731114.0],
                        [613256.0, 6732409.0],
                        [609792.0, 6727136.0],
                        [605429.0, 6729771.0],
                        [602374.0, 6738361.0],
                        [591237.0, 6742041.0],
                        [590280.0, 6747700.0],
                        [594464.0, 6753836.0],
                        [589886.0, 6759775.0],
                        [589601.0, 6765689.0],
                        [573758.0, 6762848.0],
                        [566408.0, 6764638.0],
                        [559999.0, 6772636.0],
                        [559439.0, 6777275.0],
                        [551727.0, 6777731.0],
                        [551017.0, 6782681.0],
                        [539332.0, 6780273.0],
                        [535875.0, 6773086.0],
                        [539183.0, 6762306.0],
                        [532634.0, 6757689.0],
                        [533549.0, 6751156.0],
                        [528757.0, 6745774.0],
                        [518605.0, 6737439.0],
                        [521086.0, 6735350.0],
                        [530153.0, 6735215.0],
                        [539386.0, 6732046.0],
                        [543743.0, 6727862.0],
                        [552256.0, 6724799.0],
                        [555366.0, 6719856.0],
                        [552945.0, 6716389.0],
                        [559271.0, 6706788.0],
                        [557303.0, 6702930.0],
                        [558309.0, 6696538.0],
                        [557051.0, 6690388.0],
                        [561058.0, 6687382.0],
                        [565759.0, 6689706.0],
                        [569696.0, 6685244.0],
                        [573297.0, 6677558.0],
                        [582631.0, 6683116.0],
                        [593597.0, 6687211.0],
                        [602149.0, 6685865.0],
                        [612147.0, 6680536.0],
                        [617060.0, 6680060.0],
                        [619951.0, 6688294.0],
                        [624165.0, 6685496.0],
                        [634922.0, 6687596.0],
                        [632231.0, 6698879.0],
                        [642622.0, 6708275.0],
                        [639501.0, 6716775.0],
                        [634456.0, 6720842.0],
                        [642856.0, 6724786.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "41", "NOM_DEPT": "LOIR-ET-CHER"},
        },
        24: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1001023.0, 6834020.0],
                        [1007603.0, 6833382.0],
                        [1013753.0, 6840510.0],
                        [1015426.0, 6846104.0],
                        [1012123.0, 6851875.0],
                        [1016765.0, 6860562.0],
                        [1004387.0, 6868517.0],
                        [1002983.0, 6863593.0],
                        [997609.0, 6864713.0],
                        [996607.0, 6871102.0],
                        [990508.0, 6874464.0],
                        [991999.0, 6880708.0],
                        [996400.0, 6888804.0],
                        [1000174.0, 6890502.0],
                        [1005257.0, 6886565.0],
                        [1014136.0, 6883372.0],
                        [1016790.0, 6880171.0],
                        [1025429.0, 6883147.0],
                        [1032318.0, 6879884.0],
                        [1035096.0, 6882767.0],
                        [1038624.0, 6893752.0],
                        [1031356.0, 6897552.0],
                        [1023578.0, 6906994.0],
                        [1018182.0, 6905695.0],
                        [1013674.0, 6899390.0],
                        [1009903.0, 6900358.0],
                        [996736.0, 6898172.0],
                        [992282.0, 6906134.0],
                        [986611.0, 6909639.0],
                        [979390.0, 6908077.0],
                        [979652.0, 6901424.0],
                        [972590.0, 6902443.0],
                        [968604.0, 6909024.0],
                        [966935.0, 6915200.0],
                        [959086.0, 6922273.0],
                        [960438.0, 6926520.0],
                        [957718.0, 6930675.0],
                        [948608.0, 6936180.0],
                        [945901.0, 6934734.0],
                        [938917.0, 6936180.0],
                        [935871.0, 6939385.0],
                        [928691.0, 6938466.0],
                        [926408.0, 6934964.0],
                        [916749.0, 6932316.0],
                        [915342.0, 6936492.0],
                        [909643.0, 6936903.0],
                        [913390.0, 6932141.0],
                        [912688.0, 6923499.0],
                        [920628.0, 6907653.0],
                        [917676.0, 6905219.0],
                        [920671.0, 6900380.0],
                        [914011.0, 6893894.0],
                        [914442.0, 6889764.0],
                        [922708.0, 6883240.0],
                        [922735.0, 6879575.0],
                        [928151.0, 6878713.0],
                        [929417.0, 6875078.0],
                        [939656.0, 6875317.0],
                        [945024.0, 6864515.0],
                        [946451.0, 6858744.0],
                        [961206.0, 6856322.0],
                        [964692.0, 6852206.0],
                        [969100.0, 6851558.0],
                        [971773.0, 6847764.0],
                        [976380.0, 6847597.0],
                        [983189.0, 6843093.0],
                        [993487.0, 6842033.0],
                        [1001023.0, 6834020.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "57", "NOM_DEPT": "MOSELLE"},
        },
        25: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [483517.0, 6558927.0],
                        [489751.0, 6554866.0],
                        [499249.0, 6554736.0],
                        [507509.0, 6562167.0],
                        [509938.0, 6556936.0],
                        [521367.0, 6557890.0],
                        [526089.0, 6562344.0],
                        [531964.0, 6561069.0],
                        [530127.0, 6570272.0],
                        [538896.0, 6578287.0],
                        [546474.0, 6577615.0],
                        [548271.0, 6584464.0],
                        [556218.0, 6586207.0],
                        [559931.0, 6588729.0],
                        [562773.0, 6594026.0],
                        [558128.0, 6596023.0],
                        [557842.0, 6602380.0],
                        [547958.0, 6609437.0],
                        [542426.0, 6611026.0],
                        [538906.0, 6616112.0],
                        [541431.0, 6623495.0],
                        [537221.0, 6629765.0],
                        [533123.0, 6635020.0],
                        [531658.0, 6641492.0],
                        [525272.0, 6647330.0],
                        [524608.0, 6655240.0],
                        [515158.0, 6658631.0],
                        [517389.0, 6653506.0],
                        [510389.0, 6653999.0],
                        [505157.0, 6650870.0],
                        [494833.0, 6656131.0],
                        [494947.0, 6665028.0],
                        [485608.0, 6667284.0],
                        [482922.0, 6672972.0],
                        [478404.0, 6673399.0],
                        [476861.0, 6677880.0],
                        [471947.0, 6677374.0],
                        [469141.0, 6670338.0],
                        [464624.0, 6667352.0],
                        [465537.0, 6662685.0],
                        [471018.0, 6649618.0],
                        [469757.0, 6639127.0],
                        [470952.0, 6628365.0],
                        [467588.0, 6622657.0],
                        [472374.0, 6614809.0],
                        [467690.0, 6607234.0],
                        [468300.0, 6594579.0],
                        [472081.0, 6590232.0],
                        [472141.0, 6584899.0],
                        [475179.0, 6582497.0],
                        [479925.0, 6587264.0],
                        [482897.0, 6584792.0],
                        [478920.0, 6578170.0],
                        [477460.0, 6571967.0],
                        [480502.0, 6565882.0],
                        [485043.0, 6563684.0],
                        [483517.0, 6558927.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "86", "NOM_DEPT": "VIENNE"},
        },
        26: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [515635.0, 6515544.0],
                        [513233.0, 6510903.0],
                        [505177.0, 6505055.0],
                        [504657.0, 6496986.0],
                        [493466.0, 6488572.0],
                        [489646.0, 6488189.0],
                        [484697.0, 6477489.0],
                        [485798.0, 6470195.0],
                        [474561.0, 6460744.0],
                        [468806.0, 6462928.0],
                        [464807.0, 6459164.0],
                        [460931.0, 6449393.0],
                        [467756.0, 6450339.0],
                        [469719.0, 6445475.0],
                        [464018.0, 6432038.0],
                        [466012.0, 6428425.0],
                        [461839.0, 6422164.0],
                        [469504.0, 6418931.0],
                        [476390.0, 6418176.0],
                        [482141.0, 6421330.0],
                        [486169.0, 6410676.0],
                        [489091.0, 6407815.0],
                        [491196.0, 6399384.0],
                        [495031.0, 6397493.0],
                        [512334.0, 6403639.0],
                        [514373.0, 6400391.0],
                        [527849.0, 6401566.0],
                        [526858.0, 6394383.0],
                        [530971.0, 6390971.0],
                        [539761.0, 6395885.0],
                        [547193.0, 6388334.0],
                        [553597.0, 6395079.0],
                        [553113.0, 6398528.0],
                        [559319.0, 6399932.0],
                        [564402.0, 6403210.0],
                        [570668.0, 6413830.0],
                        [570522.0, 6417080.0],
                        [576964.0, 6421036.0],
                        [574976.0, 6434607.0],
                        [577774.0, 6436765.0],
                        [573095.0, 6446142.0],
                        [566113.0, 6450433.0],
                        [564865.0, 6461779.0],
                        [560988.0, 6465186.0],
                        [568750.0, 6477311.0],
                        [563844.0, 6479160.0],
                        [563452.0, 6484264.0],
                        [553144.0, 6489340.0],
                        [546900.0, 6501981.0],
                        [539039.0, 6503445.0],
                        [529342.0, 6499739.0],
                        [524801.0, 6504583.0],
                        [526849.0, 6509996.0],
                        [515635.0, 6515544.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "24", "NOM_DEPT": "DORDOGNE"},
        },
        27: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [877344.0, 6596683.0],
                        [877221.0, 6593352.0],
                        [882664.0, 6589574.0],
                        [882486.0, 6586333.0],
                        [887558.0, 6582363.0],
                        [890444.0, 6576892.0],
                        [895736.0, 6577631.0],
                        [903737.0, 6585593.0],
                        [908880.0, 6582354.0],
                        [909869.0, 6577050.0],
                        [919460.0, 6577537.0],
                        [923919.0, 6580132.0],
                        [929573.0, 6589336.0],
                        [935280.0, 6595262.0],
                        [935835.0, 6600587.0],
                        [941800.0, 6609883.0],
                        [940343.0, 6611180.0],
                        [933274.0, 6616467.0],
                        [937312.0, 6621303.0],
                        [934547.0, 6625608.0],
                        [942748.0, 6631718.0],
                        [944367.0, 6635241.0],
                        [940225.0, 6640408.0],
                        [928880.0, 6645788.0],
                        [925393.0, 6653995.0],
                        [925599.0, 6657600.0],
                        [913780.0, 6661601.0],
                        [909981.0, 6669146.0],
                        [913407.0, 6674258.0],
                        [912920.0, 6678099.0],
                        [905832.0, 6683506.0],
                        [904021.0, 6688452.0],
                        [896736.0, 6687711.0],
                        [890265.0, 6692353.0],
                        [888032.0, 6690633.0],
                        [887407.0, 6682465.0],
                        [884880.0, 6674426.0],
                        [881002.0, 6667371.0],
                        [876191.0, 6666228.0],
                        [875449.0, 6660099.0],
                        [871408.0, 6655745.0],
                        [872158.0, 6650880.0],
                        [876345.0, 6647462.0],
                        [887343.0, 6642371.0],
                        [880659.0, 6638936.0],
                        [882575.0, 6628163.0],
                        [886706.0, 6618161.0],
                        [880824.0, 6605207.0],
                        [885325.0, 6599852.0],
                        [877344.0, 6596683.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "39", "NOM_DEPT": "JURA"},
        },
        28: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [610874.0, 6360746.0],
                        [596271.0, 6358053.0],
                        [592401.0, 6355117.0],
                        [585843.0, 6356520.0],
                        [581893.0, 6352690.0],
                        [570617.0, 6348643.0],
                        [562737.0, 6350024.0],
                        [549131.0, 6360516.0],
                        [545774.0, 6366277.0],
                        [544593.0, 6364542.0],
                        [531660.0, 6365290.0],
                        [530427.0, 6360537.0],
                        [536387.0, 6355171.0],
                        [533815.0, 6350996.0],
                        [529462.0, 6338671.0],
                        [520115.0, 6336256.0],
                        [519117.0, 6332164.0],
                        [521740.0, 6328834.0],
                        [528536.0, 6329188.0],
                        [520187.0, 6318466.0],
                        [528381.0, 6316132.0],
                        [531142.0, 6309545.0],
                        [531445.0, 6300603.0],
                        [535303.0, 6300840.0],
                        [550735.0, 6304341.0],
                        [556606.0, 6298479.0],
                        [568130.0, 6303820.0],
                        [567948.0, 6310839.0],
                        [575242.0, 6309509.0],
                        [583992.0, 6314318.0],
                        [583816.0, 6319290.0],
                        [589156.0, 6320414.0],
                        [595091.0, 6325907.0],
                        [592665.0, 6336179.0],
                        [599594.0, 6336049.0],
                        [602120.0, 6333848.0],
                        [607335.0, 6338978.0],
                        [613603.0, 6341028.0],
                        [619220.0, 6339455.0],
                        [618185.0, 6342854.0],
                        [612268.0, 6345645.0],
                        [617826.0, 6353582.0],
                        [612319.0, 6353954.0],
                        [610874.0, 6360746.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "82", "NOM_DEPT": "TARN-ET-GARONNE"},
        },
        29: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [404251.0, 6660135.0],
                        [413368.0, 6662854.0],
                        [417889.0, 6660618.0],
                        [424993.0, 6661094.0],
                        [429262.0, 6663802.0],
                        [429925.0, 6668493.0],
                        [434893.0, 6670550.0],
                        [442005.0, 6668948.0],
                        [454238.0, 6672319.0],
                        [458546.0, 6672434.0],
                        [464624.0, 6667352.0],
                        [469141.0, 6670338.0],
                        [471947.0, 6677374.0],
                        [476861.0, 6677880.0],
                        [479254.0, 6691029.0],
                        [487846.0, 6706491.0],
                        [490772.0, 6714971.0],
                        [489539.0, 6719725.0],
                        [491931.0, 6726763.0],
                        [485937.0, 6723990.0],
                        [478533.0, 6727039.0],
                        [474490.0, 6731769.0],
                        [469484.0, 6733109.0],
                        [464631.0, 6730466.0],
                        [460339.0, 6732350.0],
                        [457617.0, 6739093.0],
                        [450112.0, 6740918.0],
                        [446732.0, 6745443.0],
                        [440863.0, 6746201.0],
                        [429458.0, 6743442.0],
                        [419671.0, 6744167.0],
                        [412442.0, 6746090.0],
                        [404251.0, 6751414.0],
                        [402067.0, 6747685.0],
                        [393110.0, 6750366.0],
                        [389872.0, 6749698.0],
                        [382932.0, 6754022.0],
                        [382163.0, 6750361.0],
                        [381255.0, 6745617.0],
                        [386987.0, 6740963.0],
                        [389301.0, 6732485.0],
                        [398982.0, 6728603.0],
                        [395905.0, 6725901.0],
                        [386462.0, 6727467.0],
                        [387234.0, 6720426.0],
                        [401401.0, 6717774.0],
                        [402393.0, 6705897.0],
                        [396890.0, 6703794.0],
                        [385609.0, 6704471.0],
                        [375470.0, 6701871.0],
                        [374867.0, 6698071.0],
                        [378391.0, 6691949.0],
                        [382659.0, 6691801.0],
                        [384839.0, 6683588.0],
                        [379159.0, 6679552.0],
                        [379298.0, 6676338.0],
                        [387784.0, 6670618.0],
                        [385082.0, 6667087.0],
                        [392012.0, 6664073.0],
                        [401283.0, 6663962.0],
                        [404251.0, 6660135.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "49", "NOM_DEPT": "MAINE-ET-LOIRE"},
        },
        30: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [863140.0, 6525920.0],
                        [849404.0, 6524528.0],
                        [844536.0, 6535588.0],
                        [833933.0, 6540287.0],
                        [835850.0, 6543054.0],
                        [834501.0, 6551198.0],
                        [835220.0, 6556428.0],
                        [838741.0, 6561678.0],
                        [837322.0, 6565642.0],
                        [833486.0, 6565745.0],
                        [830305.0, 6579430.0],
                        [824653.0, 6575157.0],
                        [815826.0, 6575242.0],
                        [808209.0, 6578315.0],
                        [806993.0, 6569822.0],
                        [810991.0, 6564128.0],
                        [802035.0, 6559678.0],
                        [798995.0, 6551156.0],
                        [801039.0, 6547667.0],
                        [800220.0, 6540120.0],
                        [802643.0, 6534285.0],
                        [807296.0, 6530310.0],
                        [808147.0, 6518212.0],
                        [806255.0, 6511913.0],
                        [809870.0, 6504594.0],
                        [818524.0, 6498224.0],
                        [825934.0, 6498617.0],
                        [829797.0, 6488843.0],
                        [834511.0, 6489782.0],
                        [837308.0, 6485557.0],
                        [845846.0, 6493277.0],
                        [841056.0, 6498593.0],
                        [848198.0, 6502534.0],
                        [858527.0, 6506228.0],
                        [865784.0, 6514252.0],
                        [862850.0, 6517700.0],
                        [863140.0, 6525920.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "69", "NOM_DEPT": "RHONE"},
        },
        31: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [606642.0, 6924066.0],
                        [602657.0, 6922993.0],
                        [596650.0, 6927678.0],
                        [584841.0, 6929723.0],
                        [579971.0, 6928884.0],
                        [574422.0, 6917678.0],
                        [566281.0, 6917384.0],
                        [564288.0, 6913853.0],
                        [558013.0, 6912674.0],
                        [555352.0, 6907664.0],
                        [548914.0, 6917432.0],
                        [548813.0, 6922655.0],
                        [537794.0, 6926754.0],
                        [530512.0, 6925008.0],
                        [524567.0, 6928708.0],
                        [520591.0, 6933755.0],
                        [506978.0, 6930086.0],
                        [503908.0, 6928958.0],
                        [505278.0, 6914121.0],
                        [509502.0, 6910309.0],
                        [509950.0, 6897618.0],
                        [512079.0, 6895331.0],
                        [508338.0, 6886469.0],
                        [512505.0, 6881741.0],
                        [510545.0, 6875400.0],
                        [508448.0, 6870995.0],
                        [513552.0, 6867418.0],
                        [520512.0, 6866728.0],
                        [524600.0, 6861683.0],
                        [533488.0, 6856087.0],
                        [536389.0, 6850906.0],
                        [533024.0, 6847407.0],
                        [539112.0, 6843338.0],
                        [543803.0, 6848251.0],
                        [555241.0, 6849633.0],
                        [566604.0, 6854037.0],
                        [576482.0, 6852521.0],
                        [580772.0, 6855857.0],
                        [579784.0, 6860594.0],
                        [587701.0, 6866890.0],
                        [590236.0, 6872273.0],
                        [587216.0, 6881812.0],
                        [591984.0, 6886421.0],
                        [598361.0, 6887345.0],
                        [601892.0, 6893098.0],
                        [603501.0, 6902160.0],
                        [605624.0, 6904387.0],
                        [606128.0, 6907968.0],
                        [610931.0, 6911811.0],
                        [609871.0, 6919444.0],
                        [606642.0, 6924066.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "27", "NOM_DEPT": "EURE"},
        },
        32: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [619220.0, 6339455.0],
                        [628552.0, 6344336.0],
                        [632260.0, 6344664.0],
                        [651092.0, 6332910.0],
                        [652742.0, 6328715.0],
                        [656723.0, 6328192.0],
                        [661724.0, 6320369.0],
                        [659810.0, 6316970.0],
                        [664259.0, 6313698.0],
                        [664946.0, 6304799.0],
                        [674324.0, 6293934.0],
                        [679276.0, 6292258.0],
                        [684993.0, 6295873.0],
                        [693643.0, 6293013.0],
                        [694796.0, 6288406.0],
                        [698819.0, 6289943.0],
                        [704898.0, 6288229.0],
                        [704815.0, 6303628.0],
                        [716344.0, 6301672.0],
                        [722102.0, 6311077.0],
                        [728786.0, 6312824.0],
                        [736140.0, 6324746.0],
                        [726344.0, 6331169.0],
                        [726879.0, 6340020.0],
                        [729879.0, 6341376.0],
                        [728598.0, 6344387.0],
                        [718362.0, 6347498.0],
                        [709994.0, 6353946.0],
                        [712305.0, 6356606.0],
                        [709537.0, 6364934.0],
                        [710800.0, 6372878.0],
                        [705449.0, 6378272.0],
                        [706639.0, 6384441.0],
                        [698547.0, 6393953.0],
                        [693924.0, 6403282.0],
                        [694820.0, 6408897.0],
                        [690477.0, 6411547.0],
                        [688126.0, 6419157.0],
                        [684359.0, 6419403.0],
                        [679353.0, 6426925.0],
                        [676829.0, 6423158.0],
                        [668604.0, 6416079.0],
                        [668313.0, 6410487.0],
                        [665404.0, 6408608.0],
                        [664849.0, 6402561.0],
                        [655192.0, 6393469.0],
                        [646639.0, 6396959.0],
                        [637228.0, 6394175.0],
                        [637122.0, 6391031.0],
                        [632813.0, 6386229.0],
                        [625170.0, 6387538.0],
                        [615061.0, 6379167.0],
                        [607709.0, 6375883.0],
                        [610874.0, 6360746.0],
                        [612319.0, 6353954.0],
                        [617826.0, 6353582.0],
                        [612268.0, 6345645.0],
                        [618185.0, 6342854.0],
                        [619220.0, 6339455.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "12", "NOM_DEPT": "AVEYRON"},
        },
        33: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [636090.0, 6591904.0],
                        [630016.0, 6590287.0],
                        [622684.0, 6592821.0],
                        [609355.0, 6592908.0],
                        [602234.0, 6588456.0],
                        [595863.0, 6588324.0],
                        [586530.0, 6592902.0],
                        [578129.0, 6584256.0],
                        [580236.0, 6579624.0],
                        [574730.0, 6569689.0],
                        [580656.0, 6565605.0],
                        [587795.0, 6549437.0],
                        [586335.0, 6540289.0],
                        [592200.0, 6538029.0],
                        [591561.0, 6529605.0],
                        [597279.0, 6527024.0],
                        [604752.0, 6527760.0],
                        [613074.0, 6522626.0],
                        [612524.0, 6515422.0],
                        [614305.0, 6511565.0],
                        [623634.0, 6517796.0],
                        [631053.0, 6514297.0],
                        [635791.0, 6515072.0],
                        [637278.0, 6511373.0],
                        [648450.0, 6509221.0],
                        [649366.0, 6512420.0],
                        [656101.0, 6511235.0],
                        [660507.0, 6515469.0],
                        [656022.0, 6519074.0],
                        [652489.0, 6525488.0],
                        [656753.0, 6529414.0],
                        [660605.0, 6529501.0],
                        [668605.0, 6543382.0],
                        [665172.0, 6557241.0],
                        [666451.0, 6560450.0],
                        [662729.0, 6571178.0],
                        [659880.0, 6575828.0],
                        [653217.0, 6581299.0],
                        [647921.0, 6581264.0],
                        [644784.0, 6591412.0],
                        [636090.0, 6591904.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "23", "NOM_DEPT": "CREUSE"},
        },
        34: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [695265.0, 6784783.0],
                        [685053.0, 6785343.0],
                        [678166.0, 6780535.0],
                        [665644.0, 6782354.0],
                        [663338.0, 6793247.0],
                        [657236.0, 6795707.0],
                        [655721.0, 6802434.0],
                        [653275.0, 6801114.0],
                        [639308.0, 6801806.0],
                        [625387.0, 6798948.0],
                        [623220.0, 6795517.0],
                        [615539.0, 6776549.0],
                        [606511.0, 6774717.0],
                        [597558.0, 6774986.0],
                        [595216.0, 6770968.0],
                        [589165.0, 6770859.0],
                        [589601.0, 6765689.0],
                        [589886.0, 6759775.0],
                        [594464.0, 6753836.0],
                        [590280.0, 6747700.0],
                        [591237.0, 6742041.0],
                        [602374.0, 6738361.0],
                        [605429.0, 6729771.0],
                        [609792.0, 6727136.0],
                        [613256.0, 6732409.0],
                        [620646.0, 6731114.0],
                        [640167.0, 6731164.0],
                        [642856.0, 6724786.0],
                        [646396.0, 6725640.0],
                        [652875.0, 6720759.0],
                        [657729.0, 6723417.0],
                        [661757.0, 6718781.0],
                        [669909.0, 6717111.0],
                        [674282.0, 6709782.0],
                        [678869.0, 6710238.0],
                        [682544.0, 6713710.0],
                        [685430.0, 6710473.0],
                        [690565.0, 6713347.0],
                        [693556.0, 6718403.0],
                        [698236.0, 6718784.0],
                        [695341.0, 6722058.0],
                        [694231.0, 6731133.0],
                        [689391.0, 6734632.0],
                        [689262.0, 6740069.0],
                        [695135.0, 6740319.0],
                        [701782.0, 6742907.0],
                        [700769.0, 6756036.0],
                        [703743.0, 6756785.0],
                        [709585.0, 6763406.0],
                        [706580.0, 6772621.0],
                        [703759.0, 6774663.0],
                        [702192.0, 6781427.0],
                        [695265.0, 6784783.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "45", "NOM_DEPT": "LOIRET"},
        },
        35: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [986052.0, 6752778.0],
                        [982963.0, 6756697.0],
                        [972278.0, 6762245.0],
                        [968808.0, 6766577.0],
                        [964569.0, 6761737.0],
                        [959909.0, 6759629.0],
                        [956126.0, 6765947.0],
                        [951150.0, 6767749.0],
                        [941726.0, 6764118.0],
                        [936416.0, 6766072.0],
                        [935284.0, 6772098.0],
                        [929025.0, 6772821.0],
                        [924039.0, 6766004.0],
                        [919858.0, 6768473.0],
                        [915394.0, 6762341.0],
                        [910900.0, 6755744.0],
                        [906433.0, 6754603.0],
                        [901288.0, 6749897.0],
                        [900414.0, 6745482.0],
                        [902985.0, 6741752.0],
                        [901778.0, 6735043.0],
                        [894824.0, 6733348.0],
                        [886220.0, 6734507.0],
                        [880542.0, 6733086.0],
                        [878352.0, 6725366.0],
                        [882147.0, 6728546.0],
                        [886108.0, 6726069.0],
                        [887785.0, 6718944.0],
                        [884206.0, 6713509.0],
                        [880595.0, 6713705.0],
                        [884919.0, 6701062.0],
                        [890265.0, 6692353.0],
                        [896736.0, 6687711.0],
                        [904021.0, 6688452.0],
                        [922029.0, 6697905.0],
                        [925719.0, 6696195.0],
                        [932449.0, 6699390.0],
                        [945847.0, 6708437.0],
                        [950918.0, 6717032.0],
                        [955890.0, 6718838.0],
                        [967469.0, 6716290.0],
                        [969354.0, 6721610.0],
                        [974258.0, 6721322.0],
                        [977033.0, 6724531.0],
                        [984341.0, 6721925.0],
                        [986155.0, 6724947.0],
                        [983826.0, 6731782.0],
                        [981470.0, 6745308.0],
                        [986052.0, 6752778.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "70", "NOM_DEPT": "HAUTE-SAONE"},
        },
        36: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [753779.0, 6537018.0],
                        [745523.0, 6547324.0],
                        [735860.0, 6546571.0],
                        [732386.0, 6552810.0],
                        [728730.0, 6550656.0],
                        [712873.0, 6551781.0],
                        [697819.0, 6557998.0],
                        [693029.0, 6567076.0],
                        [695157.0, 6571452.0],
                        [688886.0, 6572856.0],
                        [685369.0, 6566281.0],
                        [679424.0, 6569309.0],
                        [672252.0, 6557694.0],
                        [666451.0, 6560450.0],
                        [665172.0, 6557241.0],
                        [668605.0, 6543382.0],
                        [660605.0, 6529501.0],
                        [656753.0, 6529414.0],
                        [652489.0, 6525488.0],
                        [656022.0, 6519074.0],
                        [660507.0, 6515469.0],
                        [663288.0, 6509261.0],
                        [662164.0, 6504560.0],
                        [658322.0, 6500286.0],
                        [662264.0, 6494997.0],
                        [661594.0, 6486680.0],
                        [672750.0, 6482640.0],
                        [677684.0, 6475835.0],
                        [688449.0, 6477003.0],
                        [693859.0, 6474045.0],
                        [695974.0, 6467752.0],
                        [701310.0, 6465307.0],
                        [708104.0, 6472781.0],
                        [713160.0, 6472555.0],
                        [722742.0, 6478087.0],
                        [735734.0, 6477978.0],
                        [739202.0, 6481030.0],
                        [749018.0, 6471190.0],
                        [752222.0, 6475420.0],
                        [760473.0, 6472496.0],
                        [763248.0, 6477235.0],
                        [770263.0, 6473476.0],
                        [770335.0, 6479388.0],
                        [776221.0, 6483674.0],
                        [774454.0, 6495613.0],
                        [770440.0, 6500348.0],
                        [764154.0, 6503988.0],
                        [760734.0, 6514163.0],
                        [754369.0, 6520637.0],
                        [758503.0, 6532097.0],
                        [753779.0, 6537018.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "63", "NOM_DEPT": "PUY-DE-DOME"},
        },
        37: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [583992.0, 6314318.0],
                        [583878.0, 6308763.0],
                        [586632.0, 6302842.0],
                        [590928.0, 6301074.0],
                        [592076.0, 6294561.0],
                        [595737.0, 6291653.0],
                        [597601.0, 6285124.0],
                        [594074.0, 6282175.0],
                        [605052.0, 6276459.0],
                        [609628.0, 6269734.0],
                        [620519.0, 6263967.0],
                        [621363.0, 6260238.0],
                        [624846.0, 6255615.0],
                        [637154.0, 6259493.0],
                        [640013.0, 6262596.0],
                        [651680.0, 6257911.0],
                        [654081.0, 6259728.0],
                        [664821.0, 6258302.0],
                        [668090.0, 6259189.0],
                        [672444.0, 6264623.0],
                        [672394.0, 6269695.0],
                        [668935.0, 6274250.0],
                        [671212.0, 6283521.0],
                        [676690.0, 6282993.0],
                        [680178.0, 6279485.0],
                        [693221.0, 6284557.0],
                        [694796.0, 6288406.0],
                        [693643.0, 6293013.0],
                        [684993.0, 6295873.0],
                        [679276.0, 6292258.0],
                        [674324.0, 6293934.0],
                        [664946.0, 6304799.0],
                        [664259.0, 6313698.0],
                        [659810.0, 6316970.0],
                        [661724.0, 6320369.0],
                        [656723.0, 6328192.0],
                        [652742.0, 6328715.0],
                        [651092.0, 6332910.0],
                        [632260.0, 6344664.0],
                        [628552.0, 6344336.0],
                        [619220.0, 6339455.0],
                        [613603.0, 6341028.0],
                        [607335.0, 6338978.0],
                        [602120.0, 6333848.0],
                        [599594.0, 6336049.0],
                        [592665.0, 6336179.0],
                        [595091.0, 6325907.0],
                        [589156.0, 6320414.0],
                        [583816.0, 6319290.0],
                        [583992.0, 6314318.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "81", "NOM_DEPT": "TARN"},
        },
        38: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [612314.0, 6962826.0],
                        [608347.0, 6970745.0],
                        [605014.0, 6980736.0],
                        [589321.0, 6994349.0],
                        [583880.0, 6997485.0],
                        [570354.0, 6986979.0],
                        [561015.0, 6982476.0],
                        [553619.0, 6982021.0],
                        [539569.0, 6977082.0],
                        [525341.0, 6975010.0],
                        [506777.0, 6963564.0],
                        [498821.0, 6960824.0],
                        [494437.0, 6953650.0],
                        [487453.0, 6938754.0],
                        [491281.0, 6933115.0],
                        [506978.0, 6930086.0],
                        [520591.0, 6933755.0],
                        [524567.0, 6928708.0],
                        [530512.0, 6925008.0],
                        [537794.0, 6926754.0],
                        [548813.0, 6922655.0],
                        [548914.0, 6917432.0],
                        [555352.0, 6907664.0],
                        [558013.0, 6912674.0],
                        [564288.0, 6913853.0],
                        [566281.0, 6917384.0],
                        [574422.0, 6917678.0],
                        [579971.0, 6928884.0],
                        [584841.0, 6929723.0],
                        [596650.0, 6927678.0],
                        [602657.0, 6922993.0],
                        [606642.0, 6924066.0],
                        [610545.0, 6930338.0],
                        [607205.0, 6935073.0],
                        [609123.0, 6937659.0],
                        [606321.0, 6945902.0],
                        [607933.0, 6953359.0],
                        [605401.0, 6955866.0],
                        [612314.0, 6962826.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "76", "NOM_DEPT": "SEINE-MARITIME"},
        },
        39: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [823302.0, 6827043.0],
                        [822210.0, 6820200.0],
                        [827022.0, 6811887.0],
                        [834073.0, 6806764.0],
                        [837935.0, 6797546.0],
                        [837598.0, 6783989.0],
                        [835407.0, 6779651.0],
                        [828770.0, 6781171.0],
                        [825768.0, 6776095.0],
                        [827043.0, 6770243.0],
                        [833398.0, 6769005.0],
                        [833316.0, 6764154.0],
                        [838226.0, 6763382.0],
                        [846087.0, 6753627.0],
                        [848388.0, 6746302.0],
                        [846031.0, 6742315.0],
                        [848455.0, 6733791.0],
                        [858300.0, 6729814.0],
                        [863148.0, 6730266.0],
                        [868188.0, 6726357.0],
                        [878352.0, 6725366.0],
                        [880542.0, 6733086.0],
                        [886220.0, 6734507.0],
                        [894824.0, 6733348.0],
                        [901778.0, 6735043.0],
                        [902985.0, 6741752.0],
                        [900414.0, 6745482.0],
                        [901288.0, 6749897.0],
                        [906433.0, 6754603.0],
                        [910900.0, 6755744.0],
                        [915394.0, 6762341.0],
                        [912655.0, 6766332.0],
                        [908017.0, 6765028.0],
                        [906998.0, 6773750.0],
                        [900794.0, 6778635.0],
                        [895837.0, 6779219.0],
                        [899609.0, 6786135.0],
                        [901295.0, 6794520.0],
                        [896020.0, 6796835.0],
                        [883843.0, 6809100.0],
                        [878315.0, 6811920.0],
                        [882722.0, 6816263.0],
                        [873603.0, 6822775.0],
                        [863008.0, 6828766.0],
                        [856191.0, 6834907.0],
                        [852692.0, 6834838.0],
                        [847795.0, 6838972.0],
                        [846365.0, 6844539.0],
                        [840675.0, 6844876.0],
                        [835676.0, 6840415.0],
                        [836281.0, 6837534.0],
                        [830469.0, 6833515.0],
                        [832829.0, 6827018.0],
                        [823302.0, 6827043.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "52", "NOM_DEPT": "HAUTE-MARNE"},
        },
        40: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [831641.0, 6353746.0],
                        [824346.0, 6357163.0],
                        [819866.0, 6361270.0],
                        [806518.0, 6360956.0],
                        [802764.0, 6358131.0],
                        [800494.0, 6352553.0],
                        [791158.0, 6357807.0],
                        [783861.0, 6358147.0],
                        [785084.0, 6367917.0],
                        [779411.0, 6373918.0],
                        [775211.0, 6367175.0],
                        [770571.0, 6365836.0],
                        [775941.0, 6359276.0],
                        [773621.0, 6356674.0],
                        [775968.0, 6350322.0],
                        [776174.0, 6341769.0],
                        [768987.0, 6337162.0],
                        [763780.0, 6336809.0],
                        [754256.0, 6342872.0],
                        [750995.0, 6342037.0],
                        [750700.0, 6336169.0],
                        [735189.0, 6336775.0],
                        [729879.0, 6341376.0],
                        [726879.0, 6340020.0],
                        [726344.0, 6331169.0],
                        [736140.0, 6324746.0],
                        [728786.0, 6312824.0],
                        [734096.0, 6312602.0],
                        [742673.0, 6306434.0],
                        [746263.0, 6307559.0],
                        [750088.0, 6313306.0],
                        [758340.0, 6319159.0],
                        [763184.0, 6318967.0],
                        [766255.0, 6313712.0],
                        [766790.0, 6307842.0],
                        [773726.0, 6310049.0],
                        [780634.0, 6301895.0],
                        [792244.0, 6293431.0],
                        [796379.0, 6284647.0],
                        [792922.0, 6276955.0],
                        [788998.0, 6273432.0],
                        [792112.0, 6270978.0],
                        [792074.0, 6265425.0],
                        [799607.0, 6263119.0],
                        [800175.0, 6267290.0],
                        [813903.0, 6274579.0],
                        [815212.0, 6281222.0],
                        [819908.0, 6290041.0],
                        [828463.0, 6288899.0],
                        [833168.0, 6302217.0],
                        [831988.0, 6308980.0],
                        [839658.0, 6315433.0],
                        [847769.0, 6322554.0],
                        [843231.0, 6331183.0],
                        [836689.0, 6335330.0],
                        [837656.0, 6344658.0],
                        [831641.0, 6353746.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "30", "NOM_DEPT": "GARD"},
        },
        41: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1011125.0, 6809400.0],
                        [1016850.0, 6809125.0],
                        [1022638.0, 6802981.0],
                        [1032428.0, 6798669.0],
                        [1032222.0, 6793924.0],
                        [1036067.0, 6790258.0],
                        [1040408.0, 6789869.0],
                        [1046450.0, 6801750.0],
                        [1048508.0, 6811325.0],
                        [1051141.0, 6812923.0],
                        [1050303.0, 6822049.0],
                        [1052109.0, 6831679.0],
                        [1054677.0, 6834498.0],
                        [1054069.0, 6843233.0],
                        [1056359.0, 6848835.0],
                        [1064869.0, 6858273.0],
                        [1065247.0, 6862338.0],
                        [1074008.0, 6868775.0],
                        [1077114.0, 6879387.0],
                        [1081448.0, 6887616.0],
                        [1072364.0, 6888601.0],
                        [1060439.0, 6895482.0],
                        [1055798.0, 6892558.0],
                        [1050607.0, 6895578.0],
                        [1045763.0, 6893084.0],
                        [1038624.0, 6893752.0],
                        [1035096.0, 6882767.0],
                        [1032318.0, 6879884.0],
                        [1025429.0, 6883147.0],
                        [1016790.0, 6880171.0],
                        [1014136.0, 6883372.0],
                        [1005257.0, 6886565.0],
                        [1000174.0, 6890502.0],
                        [996400.0, 6888804.0],
                        [991999.0, 6880708.0],
                        [990508.0, 6874464.0],
                        [996607.0, 6871102.0],
                        [997609.0, 6864713.0],
                        [1002983.0, 6863593.0],
                        [1004387.0, 6868517.0],
                        [1016765.0, 6860562.0],
                        [1012123.0, 6851875.0],
                        [1015426.0, 6846104.0],
                        [1013753.0, 6840510.0],
                        [1007603.0, 6833382.0],
                        [1001023.0, 6834020.0],
                        [1004385.0, 6831654.0],
                        [1003109.0, 6819572.0],
                        [1005338.0, 6811635.0],
                        [1011125.0, 6809400.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "67", "NOM_DEPT": "BAS-RHIN"},
        },
        42: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [719561.0, 6234874.0],
                        [716336.0, 6238907.0],
                        [711963.0, 6238657.0],
                        [700385.0, 6243263.0],
                        [700353.0, 6246775.0],
                        [686427.0, 6247043.0],
                        [681495.0, 6239871.0],
                        [667653.0, 6244475.0],
                        [662679.0, 6249784.0],
                        [664821.0, 6258302.0],
                        [654081.0, 6259728.0],
                        [651680.0, 6257911.0],
                        [640013.0, 6262596.0],
                        [637154.0, 6259493.0],
                        [624846.0, 6255615.0],
                        [621363.0, 6260238.0],
                        [611672.0, 6256714.0],
                        [607574.0, 6261192.0],
                        [603060.0, 6255463.0],
                        [603733.0, 6249863.0],
                        [598408.0, 6250205.0],
                        [593467.0, 6242482.0],
                        [596256.0, 6236985.0],
                        [595072.0, 6233132.0],
                        [604330.0, 6228108.0],
                        [614442.0, 6225039.0],
                        [613663.0, 6217624.0],
                        [617210.0, 6214637.0],
                        [617137.0, 6197372.0],
                        [608402.0, 6195450.0],
                        [610538.0, 6185966.0],
                        [614361.0, 6182470.0],
                        [622733.0, 6184536.0],
                        [632373.0, 6176261.0],
                        [631545.0, 6174170.0],
                        [644388.0, 6178927.0],
                        [647326.0, 6181831.0],
                        [644930.0, 6193342.0],
                        [655189.0, 6193206.0],
                        [659825.0, 6194610.0],
                        [675246.0, 6192375.0],
                        [678721.0, 6193157.0],
                        [682753.0, 6199641.0],
                        [688989.0, 6202113.0],
                        [693222.0, 6198384.0],
                        [703560.0, 6193187.0],
                        [704952.0, 6201963.0],
                        [703499.0, 6206754.0],
                        [709550.0, 6222514.0],
                        [719561.0, 6234874.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "11", "NOM_DEPT": "AUDE"},
        },
        43: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [695265.0, 6784783.0],
                        [700383.0, 6789702.0],
                        [703237.0, 6796855.0],
                        [703668.0, 6806647.0],
                        [712422.0, 6807964.0],
                        [727042.0, 6808060.0],
                        [730707.0, 6810078.0],
                        [728998.0, 6813854.0],
                        [731262.0, 6826009.0],
                        [737148.0, 6833964.0],
                        [740952.0, 6835710.0],
                        [733915.0, 6839303.0],
                        [735102.0, 6844463.0],
                        [732040.0, 6850473.0],
                        [735603.0, 6861428.0],
                        [729581.0, 6862815.0],
                        [724211.0, 6867685.0],
                        [722321.0, 6872132.0],
                        [712559.0, 6879371.0],
                        [712067.0, 6888882.0],
                        [705248.0, 6890863.0],
                        [700622.0, 6887964.0],
                        [680633.0, 6884542.0],
                        [673222.0, 6889902.0],
                        [670084.0, 6886723.0],
                        [667303.0, 6878971.0],
                        [670882.0, 6870004.0],
                        [667928.0, 6865519.0],
                        [670056.0, 6856451.0],
                        [671600.0, 6851283.0],
                        [668472.0, 6843626.0],
                        [665649.0, 6839786.0],
                        [666363.0, 6833836.0],
                        [663045.0, 6825117.0],
                        [663371.0, 6815578.0],
                        [665496.0, 6812431.0],
                        [657768.0, 6807009.0],
                        [655721.0, 6802434.0],
                        [657236.0, 6795707.0],
                        [663338.0, 6793247.0],
                        [665644.0, 6782354.0],
                        [678166.0, 6780535.0],
                        [685053.0, 6785343.0],
                        [695265.0, 6784783.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "77", "NOM_DEPT": "SEINE-ET-MARNE"},
        },
        44: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [706470.0, 6995042.0],
                        [691147.0, 6993758.0],
                        [689814.0, 6997681.0],
                        [669642.0, 7001764.0],
                        [667892.0, 7004913.0],
                        [662547.0, 7004433.0],
                        [658067.0, 7000416.0],
                        [656343.0, 7006536.0],
                        [663948.0, 7010834.0],
                        [660837.0, 7014835.0],
                        [654991.0, 7012592.0],
                        [648121.0, 7014552.0],
                        [635372.0, 7012312.0],
                        [634147.0, 7017146.0],
                        [624801.0, 7021563.0],
                        [622831.0, 7024302.0],
                        [612989.0, 7030025.0],
                        [605232.0, 7026713.0],
                        [603193.0, 7029103.0],
                        [596733.0, 7029014.0],
                        [595668.0, 7021497.0],
                        [599348.0, 7018454.0],
                        [591189.0, 7008466.0],
                        [589294.0, 7002423.0],
                        [583880.0, 6997485.0],
                        [589321.0, 6994349.0],
                        [605014.0, 6980736.0],
                        [608347.0, 6970745.0],
                        [612314.0, 6962826.0],
                        [620154.0, 6956108.0],
                        [623025.0, 6958366.0],
                        [636565.0, 6954687.0],
                        [645659.0, 6956103.0],
                        [654712.0, 6950974.0],
                        [664208.0, 6949037.0],
                        [669006.0, 6944292.0],
                        [676176.0, 6942514.0],
                        [677528.0, 6947426.0],
                        [685504.0, 6946842.0],
                        [685089.0, 6950779.0],
                        [693916.0, 6955962.0],
                        [708546.0, 6956332.0],
                        [705667.0, 6969289.0],
                        [708480.0, 6979518.0],
                        [713833.0, 6986563.0],
                        [712391.0, 6990404.0],
                        [706470.0, 6995042.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "80", "NOM_DEPT": "SOMME"},
        },
        45: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [708104.0, 6472781.0],
                        [709251.0, 6464988.0],
                        [717445.0, 6463649.0],
                        [722648.0, 6446835.0],
                        [725628.0, 6444038.0],
                        [723408.0, 6437470.0],
                        [727352.0, 6435060.0],
                        [728488.0, 6430309.0],
                        [732563.0, 6427378.0],
                        [732994.0, 6422485.0],
                        [737614.0, 6413026.0],
                        [746579.0, 6414955.0],
                        [746937.0, 6419760.0],
                        [752090.0, 6419191.0],
                        [752669.0, 6414624.0],
                        [758530.0, 6415778.0],
                        [768276.0, 6405343.0],
                        [774103.0, 6411136.0],
                        [781273.0, 6415520.0],
                        [782106.0, 6419872.0],
                        [791307.0, 6420019.0],
                        [796332.0, 6429870.0],
                        [801638.0, 6433950.0],
                        [808165.0, 6446004.0],
                        [808187.0, 6450395.0],
                        [813436.0, 6450097.0],
                        [816370.0, 6460772.0],
                        [811227.0, 6465007.0],
                        [806856.0, 6463705.0],
                        [807029.0, 6471772.0],
                        [802398.0, 6475469.0],
                        [792166.0, 6477709.0],
                        [780259.0, 6472021.0],
                        [776677.0, 6475557.0],
                        [770263.0, 6473476.0],
                        [763248.0, 6477235.0],
                        [760473.0, 6472496.0],
                        [752222.0, 6475420.0],
                        [749018.0, 6471190.0],
                        [739202.0, 6481030.0],
                        [735734.0, 6477978.0],
                        [722742.0, 6478087.0],
                        [713160.0, 6472555.0],
                        [708104.0, 6472781.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "43", "NOM_DEPT": "HAUTE-LOIRE"},
        },
        46: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [776081.0, 6923412.0],
                        [775242.0, 6918312.0],
                        [767112.0, 6923360.0],
                        [761575.0, 6918670.0],
                        [747051.0, 6913033.0],
                        [751361.0, 6898188.0],
                        [745398.0, 6894771.0],
                        [743801.0, 6891376.0],
                        [747254.0, 6882494.0],
                        [744067.0, 6871735.0],
                        [738742.0, 6868146.0],
                        [735603.0, 6861428.0],
                        [732040.0, 6850473.0],
                        [735102.0, 6844463.0],
                        [733915.0, 6839303.0],
                        [740952.0, 6835710.0],
                        [746802.0, 6826973.0],
                        [753955.0, 6826609.0],
                        [760761.0, 6824301.0],
                        [769985.0, 6834113.0],
                        [773768.0, 6840880.0],
                        [779497.0, 6845091.0],
                        [785824.0, 6845891.0],
                        [797551.0, 6845278.0],
                        [796995.0, 6835851.0],
                        [803526.0, 6829924.0],
                        [814106.0, 6826118.0],
                        [819107.0, 6829393.0],
                        [823302.0, 6827043.0],
                        [832829.0, 6827018.0],
                        [830469.0, 6833515.0],
                        [836281.0, 6837534.0],
                        [835676.0, 6840415.0],
                        [840675.0, 6844876.0],
                        [846365.0, 6844539.0],
                        [846329.0, 6850924.0],
                        [838677.0, 6859119.0],
                        [841874.0, 6870868.0],
                        [848655.0, 6874905.0],
                        [848915.0, 6882413.0],
                        [846791.0, 6883540.0],
                        [845429.0, 6892400.0],
                        [841416.0, 6900107.0],
                        [842092.0, 6905887.0],
                        [837898.0, 6908256.0],
                        [833062.0, 6905548.0],
                        [822754.0, 6907655.0],
                        [818364.0, 6905215.0],
                        [814643.0, 6911926.0],
                        [803525.0, 6909934.0],
                        [795010.0, 6915033.0],
                        [790665.0, 6921022.0],
                        [782994.0, 6923346.0],
                        [776081.0, 6923412.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "51", "NOM_DEPT": "MARNE"},
        },
        47: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [428954.0, 6200122.0],
                        [442286.0, 6190571.0],
                        [445343.0, 6185147.0],
                        [453012.0, 6180794.0],
                        [468501.0, 6186020.0],
                        [475317.0, 6183479.0],
                        [477861.0, 6178841.0],
                        [483521.0, 6184043.0],
                        [489111.0, 6180226.0],
                        [493119.0, 6181125.0],
                        [491362.0, 6184305.0],
                        [492032.0, 6195420.0],
                        [493715.0, 6200925.0],
                        [501753.0, 6199863.0],
                        [506394.0, 6214104.0],
                        [501199.0, 6216194.0],
                        [498958.0, 6224762.0],
                        [491741.0, 6229153.0],
                        [500952.0, 6237523.0],
                        [501020.0, 6240519.0],
                        [506455.0, 6246240.0],
                        [505760.0, 6248691.0],
                        [496988.0, 6250664.0],
                        [479309.0, 6257879.0],
                        [471536.0, 6256527.0],
                        [468215.0, 6263513.0],
                        [466465.0, 6272970.0],
                        [461941.0, 6273297.0],
                        [457450.0, 6278664.0],
                        [456497.0, 6283051.0],
                        [449863.0, 6280833.0],
                        [454138.0, 6272903.0],
                        [451477.0, 6264635.0],
                        [457777.0, 6262698.0],
                        [452746.0, 6249402.0],
                        [454979.0, 6245934.0],
                        [446410.0, 6236240.0],
                        [443868.0, 6230545.0],
                        [440142.0, 6228799.0],
                        [437107.0, 6220297.0],
                        [431385.0, 6215423.0],
                        [431947.0, 6209367.0],
                        [428150.0, 6207547.0],
                        [428954.0, 6200122.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "65", "NOM_DEPT": "HAUTES-PYRENEES"},
        },
        48: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [547193.0, 6388334.0],
                        [542159.0, 6383881.0],
                        [541673.0, 6377661.0],
                        [545774.0, 6366277.0],
                        [549131.0, 6360516.0],
                        [562737.0, 6350024.0],
                        [570617.0, 6348643.0],
                        [581893.0, 6352690.0],
                        [585843.0, 6356520.0],
                        [592401.0, 6355117.0],
                        [596271.0, 6358053.0],
                        [610874.0, 6360746.0],
                        [607709.0, 6375883.0],
                        [615061.0, 6379167.0],
                        [625170.0, 6387538.0],
                        [632813.0, 6386229.0],
                        [637122.0, 6391031.0],
                        [634129.0, 6393565.0],
                        [633003.0, 6406356.0],
                        [634482.0, 6410441.0],
                        [628463.0, 6419614.0],
                        [626129.0, 6431248.0],
                        [613933.0, 6431618.0],
                        [607209.0, 6426078.0],
                        [601475.0, 6429196.0],
                        [593751.0, 6437105.0],
                        [584718.0, 6439628.0],
                        [577774.0, 6436765.0],
                        [574976.0, 6434607.0],
                        [576964.0, 6421036.0],
                        [570522.0, 6417080.0],
                        [570668.0, 6413830.0],
                        [564402.0, 6403210.0],
                        [559319.0, 6399932.0],
                        [553113.0, 6398528.0],
                        [553597.0, 6395079.0],
                        [547193.0, 6388334.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "46", "NOM_DEPT": "LOT"},
        },
        49: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [992638.0, 6305621.0],
                        [997097.0, 6315251.0],
                        [1000978.0, 6315262.0],
                        [1007566.0, 6320724.0],
                        [1012050.0, 6317690.0],
                        [1014122.0, 6322114.0],
                        [1009068.0, 6324850.0],
                        [1007601.0, 6328762.0],
                        [1000089.0, 6334256.0],
                        [1000668.0, 6338218.0],
                        [994698.0, 6348019.0],
                        [997268.0, 6357103.0],
                        [1002665.0, 6364730.0],
                        [1009696.0, 6370071.0],
                        [1008626.0, 6382943.0],
                        [1006125.0, 6388590.0],
                        [1012175.0, 6394096.0],
                        [1012913.0, 6402904.0],
                        [1010207.0, 6403290.0],
                        [1004568.0, 6397351.0],
                        [999315.0, 6394909.0],
                        [992592.0, 6389297.0],
                        [988952.0, 6378656.0],
                        [983401.0, 6378221.0],
                        [971476.0, 6380340.0],
                        [967103.0, 6386021.0],
                        [957182.0, 6379131.0],
                        [959705.0, 6373500.0],
                        [957118.0, 6369997.0],
                        [950982.0, 6378672.0],
                        [944316.0, 6377139.0],
                        [935206.0, 6370624.0],
                        [932421.0, 6356788.0],
                        [925339.0, 6357350.0],
                        [930231.0, 6349978.0],
                        [920148.0, 6349530.0],
                        [913873.0, 6347227.0],
                        [911050.0, 6344481.0],
                        [905908.0, 6346585.0],
                        [903520.0, 6340766.0],
                        [899978.0, 6338355.0],
                        [900470.0, 6332559.0],
                        [903879.0, 6328807.0],
                        [901642.0, 6319541.0],
                        [909386.0, 6316209.0],
                        [907367.0, 6306820.0],
                        [913516.0, 6306489.0],
                        [922160.0, 6296144.0],
                        [923991.0, 6299127.0],
                        [933734.0, 6296912.0],
                        [944763.0, 6293054.0],
                        [956283.0, 6301072.0],
                        [958836.0, 6305328.0],
                        [970413.0, 6298787.0],
                        [974848.0, 6301646.0],
                        [974774.0, 6305117.0],
                        [983574.0, 6307147.0],
                        [992638.0, 6305621.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "04", "NOM_DEPT": "ALPES-DE-HAUTE-PROVENCE"},
        },
        50: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [521086.0, 6735350.0],
                        [518605.0, 6737439.0],
                        [528757.0, 6745774.0],
                        [533549.0, 6751156.0],
                        [532634.0, 6757689.0],
                        [539183.0, 6762306.0],
                        [535875.0, 6773086.0],
                        [539332.0, 6780273.0],
                        [542578.0, 6786711.0],
                        [536374.0, 6790515.0],
                        [531913.0, 6790043.0],
                        [528051.0, 6796772.0],
                        [517130.0, 6797243.0],
                        [513744.0, 6803794.0],
                        [506061.0, 6806938.0],
                        [505117.0, 6820071.0],
                        [500193.0, 6823412.0],
                        [486746.0, 6818925.0],
                        [482552.0, 6813147.0],
                        [477803.0, 6815005.0],
                        [473893.0, 6813452.0],
                        [467628.0, 6811401.0],
                        [465298.0, 6799724.0],
                        [466280.0, 6794064.0],
                        [458409.0, 6789055.0],
                        [460615.0, 6783387.0],
                        [459373.0, 6778102.0],
                        [451057.0, 6776681.0],
                        [455060.0, 6767070.0],
                        [447308.0, 6764356.0],
                        [448124.0, 6758669.0],
                        [442128.0, 6753611.0],
                        [446459.0, 6750432.0],
                        [446732.0, 6745443.0],
                        [450112.0, 6740918.0],
                        [457617.0, 6739093.0],
                        [460339.0, 6732350.0],
                        [464631.0, 6730466.0],
                        [469484.0, 6733109.0],
                        [474490.0, 6731769.0],
                        [478533.0, 6727039.0],
                        [485937.0, 6723990.0],
                        [491931.0, 6726763.0],
                        [502971.0, 6722018.0],
                        [509057.0, 6729569.0],
                        [515591.0, 6731294.0],
                        [521086.0, 6735350.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "72", "NOM_DEPT": "SARTHE"},
        },
        51: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [229520.0, 6710085.0],
                            [240383.0, 6704696.0],
                            [240163.0, 6708285.0],
                            [235835.0, 6713741.0],
                            [229006.0, 6716339.0],
                            [229520.0, 6710085.0],
                        ]
                    ],
                    [
                        [
                            [212687.0, 6770001.0],
                            [211559.0, 6762660.0],
                            [216528.0, 6752538.0],
                            [224759.0, 6753321.0],
                            [234540.0, 6747533.0],
                            [234220.0, 6745025.0],
                            [240082.0, 6736634.0],
                            [251238.0, 6736509.0],
                            [260889.0, 6740570.0],
                            [266327.0, 6740184.0],
                            [271833.0, 6736526.0],
                            [269308.0, 6731426.0],
                            [263161.0, 6733044.0],
                            [258643.0, 6731063.0],
                            [263631.0, 6725691.0],
                            [274085.0, 6728424.0],
                            [283689.0, 6728526.0],
                            [290663.0, 6724762.0],
                            [288997.0, 6719519.0],
                            [300067.0, 6720583.0],
                            [315995.0, 6726944.0],
                            [317487.0, 6738014.0],
                            [315562.0, 6748257.0],
                            [318803.0, 6749864.0],
                            [322365.0, 6758359.0],
                            [317839.0, 6765781.0],
                            [320890.0, 6769878.0],
                            [317014.0, 6776765.0],
                            [309516.0, 6779524.0],
                            [306739.0, 6782705.0],
                            [310549.0, 6787938.0],
                            [306966.0, 6794650.0],
                            [300637.0, 6793781.0],
                            [298204.0, 6799128.0],
                            [291749.0, 6798375.0],
                            [285132.0, 6789099.0],
                            [280665.0, 6785525.0],
                            [277875.0, 6787107.0],
                            [279762.0, 6794931.0],
                            [270150.0, 6795768.0],
                            [252150.0, 6805897.0],
                            [246074.0, 6807146.0],
                            [242780.0, 6802066.0],
                            [233945.0, 6800703.0],
                            [229439.0, 6804532.0],
                            [212675.0, 6807535.0],
                            [202658.0, 6804638.0],
                            [202166.0, 6798131.0],
                            [205220.0, 6785800.0],
                            [211608.0, 6786141.0],
                            [216607.0, 6782805.0],
                            [223352.0, 6780867.0],
                            [221788.0, 6771592.0],
                            [212687.0, 6770001.0],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "56", "NOM_DEPT": "MORBIHAN"},
        },
        52: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [539112.0, 6843338.0],
                        [541484.0, 6833537.0],
                        [549859.0, 6826656.0],
                        [547706.0, 6812952.0],
                        [543224.0, 6808364.0],
                        [535921.0, 6806758.0],
                        [534094.0, 6803079.0],
                        [538862.0, 6792254.0],
                        [536374.0, 6790515.0],
                        [542578.0, 6786711.0],
                        [539332.0, 6780273.0],
                        [551017.0, 6782681.0],
                        [551727.0, 6777731.0],
                        [559439.0, 6777275.0],
                        [559999.0, 6772636.0],
                        [566408.0, 6764638.0],
                        [573758.0, 6762848.0],
                        [589601.0, 6765689.0],
                        [589165.0, 6770859.0],
                        [595216.0, 6770968.0],
                        [597558.0, 6774986.0],
                        [606511.0, 6774717.0],
                        [615539.0, 6776549.0],
                        [623220.0, 6795517.0],
                        [625387.0, 6798948.0],
                        [624251.0, 6811501.0],
                        [620852.0, 6812073.0],
                        [620311.0, 6818025.0],
                        [611402.0, 6819097.0],
                        [608912.0, 6830618.0],
                        [604791.0, 6831646.0],
                        [597086.0, 6841311.0],
                        [595472.0, 6845570.0],
                        [596554.0, 6858123.0],
                        [594217.0, 6866696.0],
                        [590236.0, 6872273.0],
                        [587701.0, 6866890.0],
                        [579784.0, 6860594.0],
                        [580772.0, 6855857.0],
                        [576482.0, 6852521.0],
                        [566604.0, 6854037.0],
                        [555241.0, 6849633.0],
                        [543803.0, 6848251.0],
                        [539112.0, 6843338.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "28", "NOM_DEPT": "EURE-ET-LOIR"},
        },
        53: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1232225.0, 6105798.0],
                        [1226359.0, 6102880.0],
                        [1217754.0, 6104291.0],
                        [1215715.0, 6123336.0],
                        [1210743.0, 6122769.0],
                        [1206639.0, 6131576.0],
                        [1202519.0, 6133762.0],
                        [1199675.0, 6142105.0],
                        [1187662.0, 6146432.0],
                        [1180116.0, 6152978.0],
                        [1164950.0, 6158109.0],
                        [1159342.0, 6158599.0],
                        [1169805.0, 6146197.0],
                        [1163901.0, 6144874.0],
                        [1160274.0, 6141810.0],
                        [1162433.0, 6134554.0],
                        [1168722.0, 6128275.0],
                        [1172897.0, 6127710.0],
                        [1175910.0, 6121801.0],
                        [1169135.0, 6117789.0],
                        [1170381.0, 6114875.0],
                        [1164715.0, 6111213.0],
                        [1168686.0, 6106658.0],
                        [1175324.0, 6107066.0],
                        [1177911.0, 6109856.0],
                        [1182246.0, 6105577.0],
                        [1180256.0, 6096485.0],
                        [1173562.0, 6088828.0],
                        [1176478.0, 6086334.0],
                        [1193164.0, 6083876.0],
                        [1190373.0, 6079505.0],
                        [1183548.0, 6076443.0],
                        [1183755.0, 6068439.0],
                        [1188281.0, 6067524.0],
                        [1196826.0, 6061810.0],
                        [1209242.0, 6057430.0],
                        [1210610.0, 6054235.0],
                        [1221376.0, 6050136.0],
                        [1221646.0, 6056536.0],
                        [1224377.0, 6061299.0],
                        [1225618.0, 6068574.0],
                        [1229809.0, 6072152.0],
                        [1228158.0, 6078400.0],
                        [1232811.0, 6083356.0],
                        [1233466.0, 6095728.0],
                        [1232225.0, 6105798.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "2A", "NOM_DEPT": "CORSE-DU-SUD"},
        },
        54: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [879041.0, 6935896.0],
                        [878534.0, 6930925.0],
                        [883576.0, 6926040.0],
                        [891117.0, 6929633.0],
                        [895087.0, 6927281.0],
                        [898652.0, 6915853.0],
                        [898091.0, 6905220.0],
                        [901547.0, 6903348.0],
                        [900172.0, 6898682.0],
                        [901739.0, 6893315.0],
                        [905859.0, 6891045.0],
                        [906433.0, 6884047.0],
                        [905066.0, 6875501.0],
                        [901302.0, 6871865.0],
                        [904125.0, 6862116.0],
                        [899528.0, 6852809.0],
                        [902927.0, 6847494.0],
                        [903561.0, 6837915.0],
                        [900379.0, 6832469.0],
                        [904895.0, 6830283.0],
                        [904250.0, 6825381.0],
                        [910921.0, 6826770.0],
                        [919362.0, 6809623.0],
                        [930831.0, 6810526.0],
                        [935203.0, 6815546.0],
                        [963830.0, 6819154.0],
                        [964951.0, 6823820.0],
                        [973656.0, 6818945.0],
                        [982282.0, 6817771.0],
                        [987769.0, 6820181.0],
                        [994239.0, 6827289.0],
                        [1004385.0, 6831654.0],
                        [1001023.0, 6834020.0],
                        [993487.0, 6842033.0],
                        [983189.0, 6843093.0],
                        [976380.0, 6847597.0],
                        [971773.0, 6847764.0],
                        [969100.0, 6851558.0],
                        [964692.0, 6852206.0],
                        [961206.0, 6856322.0],
                        [946451.0, 6858744.0],
                        [945024.0, 6864515.0],
                        [939656.0, 6875317.0],
                        [929417.0, 6875078.0],
                        [928151.0, 6878713.0],
                        [922735.0, 6879575.0],
                        [922708.0, 6883240.0],
                        [914442.0, 6889764.0],
                        [914011.0, 6893894.0],
                        [920671.0, 6900380.0],
                        [917676.0, 6905219.0],
                        [920628.0, 6907653.0],
                        [912688.0, 6923499.0],
                        [913390.0, 6932141.0],
                        [909643.0, 6936903.0],
                        [902225.0, 6942685.0],
                        [896580.0, 6941163.0],
                        [892512.0, 6942531.0],
                        [879041.0, 6935896.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "54", "NOM_DEPT": "MEURTHE-ET-MOSELLE"},
        },
        55: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [510545.0, 6875400.0],
                        [504730.0, 6874732.0],
                        [500558.0, 6877307.0],
                        [491678.0, 6873174.0],
                        [489675.0, 6876299.0],
                        [484257.0, 6870962.0],
                        [475607.0, 6865852.0],
                        [469104.0, 6863978.0],
                        [457511.0, 6867107.0],
                        [454384.0, 6863198.0],
                        [449827.0, 6868751.0],
                        [446005.0, 6869054.0],
                        [427244.0, 6861949.0],
                        [417723.0, 6857101.0],
                        [420581.0, 6852284.0],
                        [423498.0, 6841841.0],
                        [421619.0, 6835816.0],
                        [414934.0, 6829326.0],
                        [422197.0, 6821752.0],
                        [429868.0, 6822252.0],
                        [437568.0, 6825109.0],
                        [441174.0, 6828584.0],
                        [446687.0, 6829012.0],
                        [451256.0, 6826715.0],
                        [457920.0, 6827997.0],
                        [463434.0, 6833996.0],
                        [466087.0, 6830999.0],
                        [467262.0, 6822174.0],
                        [474394.0, 6821359.0],
                        [473893.0, 6813452.0],
                        [477803.0, 6815005.0],
                        [482552.0, 6813147.0],
                        [486746.0, 6818925.0],
                        [500193.0, 6823412.0],
                        [505117.0, 6820071.0],
                        [506061.0, 6806938.0],
                        [513744.0, 6803794.0],
                        [517130.0, 6797243.0],
                        [528051.0, 6796772.0],
                        [531913.0, 6790043.0],
                        [536374.0, 6790515.0],
                        [538862.0, 6792254.0],
                        [534094.0, 6803079.0],
                        [535921.0, 6806758.0],
                        [543224.0, 6808364.0],
                        [547706.0, 6812952.0],
                        [549859.0, 6826656.0],
                        [541484.0, 6833537.0],
                        [539112.0, 6843338.0],
                        [533024.0, 6847407.0],
                        [536389.0, 6850906.0],
                        [533488.0, 6856087.0],
                        [524600.0, 6861683.0],
                        [520512.0, 6866728.0],
                        [513552.0, 6867418.0],
                        [508448.0, 6870995.0],
                        [510545.0, 6875400.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "61", "NOM_DEPT": "ORNE"},
        },
        56: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [877344.0, 6596683.0],
                        [869949.0, 6598870.0],
                        [868758.0, 6603264.0],
                        [857422.0, 6600366.0],
                        [848718.0, 6603737.0],
                        [845229.0, 6595067.0],
                        [845050.0, 6590960.0],
                        [839484.0, 6574938.0],
                        [837322.0, 6565642.0],
                        [838741.0, 6561678.0],
                        [835220.0, 6556428.0],
                        [834501.0, 6551198.0],
                        [835850.0, 6543054.0],
                        [833933.0, 6540287.0],
                        [844536.0, 6535588.0],
                        [849404.0, 6524528.0],
                        [863140.0, 6525920.0],
                        [870291.0, 6521483.0],
                        [876089.0, 6523611.0],
                        [879159.0, 6530984.0],
                        [882529.0, 6534232.0],
                        [888996.0, 6528631.0],
                        [888123.0, 6525941.0],
                        [897998.0, 6515860.0],
                        [904449.0, 6504924.0],
                        [909413.0, 6509006.0],
                        [910338.0, 6515974.0],
                        [915868.0, 6518199.0],
                        [916332.0, 6528631.0],
                        [919315.0, 6541572.0],
                        [917441.0, 6547210.0],
                        [916992.0, 6555432.0],
                        [918731.0, 6560168.0],
                        [928176.0, 6563414.0],
                        [933670.0, 6575392.0],
                        [940629.0, 6577110.0],
                        [938817.0, 6580823.0],
                        [943610.0, 6590224.0],
                        [935280.0, 6595262.0],
                        [929573.0, 6589336.0],
                        [923919.0, 6580132.0],
                        [919460.0, 6577537.0],
                        [909869.0, 6577050.0],
                        [908880.0, 6582354.0],
                        [903737.0, 6585593.0],
                        [895736.0, 6577631.0],
                        [890444.0, 6576892.0],
                        [887558.0, 6582363.0],
                        [882486.0, 6586333.0],
                        [882664.0, 6589574.0],
                        [877221.0, 6593352.0],
                        [877344.0, 6596683.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "01", "NOM_DEPT": "AIN"},
        },
        57: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [524704.0, 6194181.0],
                        [530246.0, 6189977.0],
                        [542336.0, 6189236.0],
                        [549247.0, 6180805.0],
                        [554894.0, 6182516.0],
                        [562658.0, 6181937.0],
                        [567864.0, 6177510.0],
                        [571419.0, 6168649.0],
                        [580902.0, 6173997.0],
                        [585134.0, 6170835.0],
                        [592180.0, 6170254.0],
                        [600206.0, 6164532.0],
                        [607482.0, 6165290.0],
                        [615529.0, 6169131.0],
                        [617954.0, 6174066.0],
                        [631545.0, 6174170.0],
                        [632373.0, 6176261.0],
                        [622733.0, 6184536.0],
                        [614361.0, 6182470.0],
                        [610538.0, 6185966.0],
                        [608402.0, 6195450.0],
                        [617137.0, 6197372.0],
                        [617210.0, 6214637.0],
                        [613663.0, 6217624.0],
                        [614442.0, 6225039.0],
                        [604330.0, 6228108.0],
                        [595072.0, 6233132.0],
                        [596256.0, 6236985.0],
                        [593467.0, 6242482.0],
                        [589272.0, 6240503.0],
                        [582028.0, 6242918.0],
                        [575081.0, 6235814.0],
                        [572065.0, 6240985.0],
                        [565565.0, 6247682.0],
                        [561407.0, 6244405.0],
                        [567825.0, 6236309.0],
                        [562910.0, 6233771.0],
                        [555809.0, 6233248.0],
                        [554118.0, 6225953.0],
                        [547328.0, 6230443.0],
                        [541984.0, 6228895.0],
                        [540236.0, 6224348.0],
                        [535770.0, 6220735.0],
                        [537386.0, 6214080.0],
                        [535012.0, 6210452.0],
                        [526458.0, 6208824.0],
                        [522873.0, 6204718.0],
                        [524704.0, 6194181.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "09", "NOM_DEPT": "ARIEGE"},
        },
        58: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [563452.0, 6484264.0],
                        [563844.0, 6479160.0],
                        [568750.0, 6477311.0],
                        [560988.0, 6465186.0],
                        [564865.0, 6461779.0],
                        [566113.0, 6450433.0],
                        [573095.0, 6446142.0],
                        [577774.0, 6436765.0],
                        [584718.0, 6439628.0],
                        [593751.0, 6437105.0],
                        [601475.0, 6429196.0],
                        [607209.0, 6426078.0],
                        [613933.0, 6431618.0],
                        [626129.0, 6431248.0],
                        [631663.0, 6432186.0],
                        [628772.0, 6440050.0],
                        [634831.0, 6442812.0],
                        [638218.0, 6451518.0],
                        [636846.0, 6458269.0],
                        [642886.0, 6465907.0],
                        [649118.0, 6470007.0],
                        [651369.0, 6479623.0],
                        [656321.0, 6476249.0],
                        [659915.0, 6480065.0],
                        [661594.0, 6486680.0],
                        [662264.0, 6494997.0],
                        [658322.0, 6500286.0],
                        [662164.0, 6504560.0],
                        [663288.0, 6509261.0],
                        [660507.0, 6515469.0],
                        [656101.0, 6511235.0],
                        [649366.0, 6512420.0],
                        [648450.0, 6509221.0],
                        [637278.0, 6511373.0],
                        [635791.0, 6515072.0],
                        [631053.0, 6514297.0],
                        [623634.0, 6517796.0],
                        [614305.0, 6511565.0],
                        [612121.0, 6507862.0],
                        [605337.0, 6509707.0],
                        [593766.0, 6498788.0],
                        [587429.0, 6495459.0],
                        [581471.0, 6497412.0],
                        [576059.0, 6493313.0],
                        [571080.0, 6486618.0],
                        [566212.0, 6489282.0],
                        [563452.0, 6484264.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "19", "NOM_DEPT": "CORREZE"},
        },
        59: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [987691.0, 6753958.0],
                        [989189.0, 6749828.0],
                        [1000830.0, 6745745.0],
                        [1003510.0, 6737902.0],
                        [1000706.0, 6731961.0],
                        [1006958.0, 6729298.0],
                        [1010786.0, 6719537.0],
                        [1014326.0, 6713511.0],
                        [1019985.0, 6711034.0],
                        [1024064.0, 6712992.0],
                        [1031730.0, 6713160.0],
                        [1039126.0, 6720266.0],
                        [1038581.0, 6725392.0],
                        [1044459.0, 6729657.0],
                        [1044908.0, 6732411.0],
                        [1039238.0, 6738821.0],
                        [1038337.0, 6743276.0],
                        [1040672.0, 6747502.0],
                        [1039113.0, 6752662.0],
                        [1040418.0, 6763108.0],
                        [1044697.0, 6773634.0],
                        [1040564.0, 6779861.0],
                        [1040408.0, 6789869.0],
                        [1036067.0, 6790258.0],
                        [1032222.0, 6793924.0],
                        [1032428.0, 6798669.0],
                        [1022638.0, 6802981.0],
                        [1016850.0, 6809125.0],
                        [1011125.0, 6809400.0],
                        [1006708.0, 6801985.0],
                        [1001795.0, 6789636.0],
                        [998205.0, 6776671.0],
                        [993983.0, 6773739.0],
                        [991355.0, 6761730.0],
                        [993060.0, 6757264.0],
                        [987691.0, 6753958.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "68", "NOM_DEPT": "HAUT-RHIN"},
        },
        60: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [573297.0, 6677558.0],
                        [569696.0, 6685244.0],
                        [565759.0, 6689706.0],
                        [561058.0, 6687382.0],
                        [557051.0, 6690388.0],
                        [558309.0, 6696538.0],
                        [557303.0, 6702930.0],
                        [559271.0, 6706788.0],
                        [552945.0, 6716389.0],
                        [555366.0, 6719856.0],
                        [552256.0, 6724799.0],
                        [543743.0, 6727862.0],
                        [539386.0, 6732046.0],
                        [530153.0, 6735215.0],
                        [521086.0, 6735350.0],
                        [515591.0, 6731294.0],
                        [509057.0, 6729569.0],
                        [502971.0, 6722018.0],
                        [491931.0, 6726763.0],
                        [489539.0, 6719725.0],
                        [490772.0, 6714971.0],
                        [487846.0, 6706491.0],
                        [479254.0, 6691029.0],
                        [476861.0, 6677880.0],
                        [478404.0, 6673399.0],
                        [482922.0, 6672972.0],
                        [485608.0, 6667284.0],
                        [494947.0, 6665028.0],
                        [494833.0, 6656131.0],
                        [505157.0, 6650870.0],
                        [510389.0, 6653999.0],
                        [517389.0, 6653506.0],
                        [515158.0, 6658631.0],
                        [524608.0, 6655240.0],
                        [525272.0, 6647330.0],
                        [531658.0, 6641492.0],
                        [533123.0, 6635020.0],
                        [537221.0, 6629765.0],
                        [546519.0, 6631001.0],
                        [551779.0, 6655211.0],
                        [553982.0, 6659068.0],
                        [560408.0, 6661557.0],
                        [568878.0, 6661167.0],
                        [571950.0, 6667671.0],
                        [576079.0, 6670370.0],
                        [573297.0, 6677558.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "37", "NOM_DEPT": "INDRE-ET-LOIRE"},
        },
        61: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [634422.0, 7101577.0],
                        [636514.0, 7100652.0],
                        [642453.0, 7087769.0],
                        [644454.0, 7079622.0],
                        [653390.0, 7071778.0],
                        [658064.0, 7064147.0],
                        [664277.0, 7059477.0],
                        [673807.0, 7057943.0],
                        [679720.0, 7059405.0],
                        [683642.0, 7063001.0],
                        [688698.0, 7062196.0],
                        [686184.0, 7056263.0],
                        [687641.0, 7047582.0],
                        [692820.0, 7044918.0],
                        [697493.0, 7046164.0],
                        [701478.0, 7042709.0],
                        [702680.0, 7038239.0],
                        [699507.0, 7031355.0],
                        [712383.0, 7015916.0],
                        [711164.0, 7009522.0],
                        [706855.0, 7002888.0],
                        [706470.0, 6995042.0],
                        [712391.0, 6990404.0],
                        [716534.0, 6992565.0],
                        [720100.0, 6990781.0],
                        [725313.0, 6993104.0],
                        [735248.0, 6991264.0],
                        [739058.0, 6995179.0],
                        [744014.0, 6992056.0],
                        [751253.0, 6997000.0],
                        [753505.0, 6995276.0],
                        [766237.0, 6992385.0],
                        [770359.0, 6988977.0],
                        [778060.0, 6986162.0],
                        [781905.0, 6987282.0],
                        [783321.0, 6995122.0],
                        [788006.0, 6997129.0],
                        [785882.0, 7004302.0],
                        [780654.0, 7004663.0],
                        [782919.0, 7012216.0],
                        [787237.0, 7018342.0],
                        [781127.0, 7020183.0],
                        [773958.0, 7027731.0],
                        [768979.0, 7028494.0],
                        [763439.0, 7026158.0],
                        [760772.0, 7028536.0],
                        [753265.0, 7028386.0],
                        [749524.0, 7024442.0],
                        [746894.0, 7030603.0],
                        [747241.0, 7039722.0],
                        [743565.0, 7044070.0],
                        [733656.0, 7048580.0],
                        [726572.0, 7043892.0],
                        [720348.0, 7047849.0],
                        [717610.0, 7060148.0],
                        [718286.0, 7067127.0],
                        [713527.0, 7069761.0],
                        [710740.0, 7076212.0],
                        [704337.0, 7075998.0],
                        [695621.0, 7071968.0],
                        [692807.0, 7066387.0],
                        [686789.0, 7068929.0],
                        [680050.0, 7079722.0],
                        [674224.0, 7079651.0],
                        [671748.0, 7084186.0],
                        [674131.0, 7094505.0],
                        [670178.0, 7102078.0],
                        [667909.0, 7110430.0],
                        [659576.0, 7106814.0],
                        [654175.0, 7107325.0],
                        [637372.0, 7101244.0],
                        [634422.0, 7101577.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "59", "NOM_DEPT": "NORD"},
        },
        62: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1010786.0, 6719537.0],
                        [1006958.0, 6729298.0],
                        [1000706.0, 6731961.0],
                        [1003510.0, 6737902.0],
                        [1000830.0, 6745745.0],
                        [989189.0, 6749828.0],
                        [987691.0, 6753958.0],
                        [986052.0, 6752778.0],
                        [981470.0, 6745308.0],
                        [983826.0, 6731782.0],
                        [986155.0, 6724947.0],
                        [993651.0, 6723596.0],
                        [994087.0, 6717743.0],
                        [996902.0, 6711079.0],
                        [1001194.0, 6713400.0],
                        [999772.0, 6717889.0],
                        [1007028.0, 6717766.0],
                        [1010786.0, 6719537.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "90", "NOM_DEPT": "TERRITOIRE DE BELFORT"},
        },
        63: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [382163.0, 6750361.0],
                        [374291.0, 6753124.0],
                        [371672.0, 6756673.0],
                        [356172.0, 6751743.0],
                        [351165.0, 6744974.0],
                        [342268.0, 6743932.0],
                        [335469.0, 6745297.0],
                        [327477.0, 6743723.0],
                        [317487.0, 6738014.0],
                        [315995.0, 6726944.0],
                        [300067.0, 6720583.0],
                        [288997.0, 6719519.0],
                        [282806.0, 6712695.0],
                        [283678.0, 6703214.0],
                        [288393.0, 6698809.0],
                        [292251.0, 6700736.0],
                        [299211.0, 6695249.0],
                        [308160.0, 6699576.0],
                        [309828.0, 6691500.0],
                        [308860.0, 6686791.0],
                        [304084.0, 6683183.0],
                        [316935.0, 6678247.0],
                        [322009.0, 6670666.0],
                        [324590.0, 6666698.0],
                        [332678.0, 6659222.0],
                        [338731.0, 6658583.0],
                        [343129.0, 6653969.0],
                        [353671.0, 6649968.0],
                        [357453.0, 6652400.0],
                        [354064.0, 6663454.0],
                        [354394.0, 6667534.0],
                        [359840.0, 6669393.0],
                        [361112.0, 6656907.0],
                        [367588.0, 6659427.0],
                        [367645.0, 6668175.0],
                        [374065.0, 6668782.0],
                        [376108.0, 6673611.0],
                        [385082.0, 6667087.0],
                        [387784.0, 6670618.0],
                        [379298.0, 6676338.0],
                        [379159.0, 6679552.0],
                        [384839.0, 6683588.0],
                        [382659.0, 6691801.0],
                        [378391.0, 6691949.0],
                        [374867.0, 6698071.0],
                        [375470.0, 6701871.0],
                        [385609.0, 6704471.0],
                        [396890.0, 6703794.0],
                        [402393.0, 6705897.0],
                        [401401.0, 6717774.0],
                        [387234.0, 6720426.0],
                        [386462.0, 6727467.0],
                        [395905.0, 6725901.0],
                        [398982.0, 6728603.0],
                        [389301.0, 6732485.0],
                        [386987.0, 6740963.0],
                        [381255.0, 6745617.0],
                        [382163.0, 6750361.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "44", "NOM_DEPT": "LOIRE-ATLANTIQUE"},
        },
        64: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [698236.0, 6718784.0],
                        [701928.0, 6717598.0],
                        [707666.0, 6720847.0],
                        [709181.0, 6715638.0],
                        [715400.0, 6713642.0],
                        [717731.0, 6709895.0],
                        [723118.0, 6710529.0],
                        [726085.0, 6708066.0],
                        [729904.0, 6712131.0],
                        [736733.0, 6710509.0],
                        [738638.0, 6714270.0],
                        [743712.0, 6710994.0],
                        [743701.0, 6707332.0],
                        [751168.0, 6705240.0],
                        [753904.0, 6700965.0],
                        [759265.0, 6699206.0],
                        [773240.0, 6698003.0],
                        [773484.0, 6692940.0],
                        [783517.0, 6693799.0],
                        [780393.0, 6701310.0],
                        [784360.0, 6705398.0],
                        [783952.0, 6713331.0],
                        [788376.0, 6717645.0],
                        [791050.0, 6725986.0],
                        [795163.0, 6731989.0],
                        [794312.0, 6737086.0],
                        [799827.0, 6740411.0],
                        [799053.0, 6750471.0],
                        [794318.0, 6750026.0],
                        [796594.0, 6759156.0],
                        [789480.0, 6763963.0],
                        [783028.0, 6759096.0],
                        [767353.0, 6760249.0],
                        [763413.0, 6765164.0],
                        [759917.0, 6778325.0],
                        [755033.0, 6785741.0],
                        [749678.0, 6782304.0],
                        [746161.0, 6791892.0],
                        [745765.0, 6796957.0],
                        [736893.0, 6807760.0],
                        [730707.0, 6810078.0],
                        [727042.0, 6808060.0],
                        [712422.0, 6807964.0],
                        [703668.0, 6806647.0],
                        [703237.0, 6796855.0],
                        [700383.0, 6789702.0],
                        [695265.0, 6784783.0],
                        [702192.0, 6781427.0],
                        [703759.0, 6774663.0],
                        [706580.0, 6772621.0],
                        [709585.0, 6763406.0],
                        [703743.0, 6756785.0],
                        [700769.0, 6756036.0],
                        [701782.0, 6742907.0],
                        [695135.0, 6740319.0],
                        [689262.0, 6740069.0],
                        [689391.0, 6734632.0],
                        [694231.0, 6731133.0],
                        [695341.0, 6722058.0],
                        [698236.0, 6718784.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "89", "NOM_DEPT": "YONNE"},
        },
        65: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [330825.0, 6841252.0],
                            [328251.0, 6849310.0],
                            [322500.0, 6846053.0],
                            [325749.0, 6841751.0],
                            [330825.0, 6841252.0],
                        ]
                    ],
                    [
                        [
                            [399495.0, 6830885.0],
                            [389634.0, 6835155.0],
                            [384742.0, 6834496.0],
                            [376536.0, 6826525.0],
                            [368413.0, 6830443.0],
                            [366767.0, 6839135.0],
                            [363309.0, 6845999.0],
                            [348952.0, 6844300.0],
                            [343084.0, 6846084.0],
                            [341341.0, 6849649.0],
                            [342875.0, 6855953.0],
                            [334395.0, 6854417.0],
                            [329772.0, 6850320.0],
                            [334969.0, 6837949.0],
                            [337450.0, 6835570.0],
                            [332923.0, 6813386.0],
                            [328273.0, 6809495.0],
                            [325505.0, 6811765.0],
                            [320973.0, 6806998.0],
                            [315234.0, 6806646.0],
                            [311879.0, 6798427.0],
                            [306966.0, 6794650.0],
                            [310549.0, 6787938.0],
                            [306739.0, 6782705.0],
                            [309516.0, 6779524.0],
                            [317014.0, 6776765.0],
                            [320890.0, 6769878.0],
                            [317839.0, 6765781.0],
                            [322365.0, 6758359.0],
                            [318803.0, 6749864.0],
                            [315562.0, 6748257.0],
                            [317487.0, 6738014.0],
                            [327477.0, 6743723.0],
                            [335469.0, 6745297.0],
                            [342268.0, 6743932.0],
                            [351165.0, 6744974.0],
                            [356172.0, 6751743.0],
                            [371672.0, 6756673.0],
                            [374291.0, 6753124.0],
                            [382163.0, 6750361.0],
                            [382932.0, 6754022.0],
                            [386941.0, 6760260.0],
                            [390140.0, 6770978.0],
                            [394099.0, 6773357.0],
                            [400197.0, 6773697.0],
                            [400465.0, 6781914.0],
                            [398626.0, 6784333.0],
                            [395852.0, 6803336.0],
                            [400321.0, 6810723.0],
                            [398130.0, 6822559.0],
                            [399495.0, 6830885.0],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "35", "NOM_DEPT": "ILLE-ET-VILAINE"},
        },
        66: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [334283.0, 6280551.0],
                        [338238.0, 6281381.0],
                        [342731.0, 6276517.0],
                        [352961.0, 6276001.0],
                        [362964.0, 6280741.0],
                        [367753.0, 6276986.0],
                        [377063.0, 6275535.0],
                        [385124.0, 6280151.0],
                        [394475.0, 6281218.0],
                        [399714.0, 6278404.0],
                        [403447.0, 6281078.0],
                        [412501.0, 6278002.0],
                        [421554.0, 6283529.0],
                        [424830.0, 6280287.0],
                        [433057.0, 6279053.0],
                        [438084.0, 6281592.0],
                        [439499.0, 6295895.0],
                        [442698.0, 6298315.0],
                        [443572.0, 6313646.0],
                        [440195.0, 6315550.0],
                        [444807.0, 6320573.0],
                        [453303.0, 6321029.0],
                        [461632.0, 6315722.0],
                        [465239.0, 6317398.0],
                        [465465.0, 6324803.0],
                        [464468.0, 6326808.0],
                        [467874.0, 6336236.0],
                        [470769.0, 6340294.0],
                        [462757.0, 6341305.0],
                        [459734.0, 6343570.0],
                        [449759.0, 6344226.0],
                        [449164.0, 6352477.0],
                        [445091.0, 6357381.0],
                        [442465.0, 6350467.0],
                        [438523.0, 6349285.0],
                        [429214.0, 6351421.0],
                        [430077.0, 6359927.0],
                        [426389.0, 6364119.0],
                        [419635.0, 6366255.0],
                        [418928.0, 6369127.0],
                        [411174.0, 6373203.0],
                        [411314.0, 6378206.0],
                        [403228.0, 6378937.0],
                        [393973.0, 6376334.0],
                        [388231.0, 6379327.0],
                        [381182.0, 6379048.0],
                        [383562.0, 6383958.0],
                        [375548.0, 6389853.0],
                        [373686.0, 6386677.0],
                        [361774.0, 6383396.0],
                        [355175.0, 6347840.0],
                        [348748.0, 6322487.0],
                        [342546.0, 6300215.0],
                        [341177.0, 6292691.0],
                        [334283.0, 6280551.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "40", "NOM_DEPT": "LANDES"},
        },
        67: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [210124.0, 6860562.0],
                        [210319.0, 6864435.0],
                        [197918.0, 6867491.0],
                        [195168.0, 6863087.0],
                        [188759.0, 6861699.0],
                        [187283.0, 6866983.0],
                        [171676.0, 6866983.0],
                        [165007.0, 6863478.0],
                        [159513.0, 6866951.0],
                        [150836.0, 6862294.0],
                        [143559.0, 6862620.0],
                        [137993.0, 6858007.0],
                        [130421.0, 6856362.0],
                        [126410.0, 6849458.0],
                        [124277.0, 6841317.0],
                        [126191.0, 6836271.0],
                        [137035.0, 6831319.0],
                        [151215.0, 6836632.0],
                        [149516.0, 6831882.0],
                        [159712.0, 6829829.0],
                        [158800.0, 6824711.0],
                        [152925.0, 6822802.0],
                        [150196.0, 6824902.0],
                        [139593.0, 6825317.0],
                        [139209.0, 6819312.0],
                        [147794.0, 6818873.0],
                        [158225.0, 6812964.0],
                        [159803.0, 6806301.0],
                        [156741.0, 6801688.0],
                        [151961.0, 6804475.0],
                        [143250.0, 6802653.0],
                        [129762.0, 6802135.0],
                        [125302.0, 6798484.0],
                        [144750.0, 6790824.0],
                        [150552.0, 6779953.0],
                        [149596.0, 6769606.0],
                        [162294.0, 6768615.0],
                        [164959.0, 6774152.0],
                        [171525.0, 6775493.0],
                        [174013.0, 6772980.0],
                        [183941.0, 6774809.0],
                        [184280.0, 6770949.0],
                        [191411.0, 6764941.0],
                        [196633.0, 6766198.0],
                        [200244.0, 6762976.0],
                        [211251.0, 6761104.0],
                        [212687.0, 6770001.0],
                        [221788.0, 6771592.0],
                        [223352.0, 6780867.0],
                        [216607.0, 6782805.0],
                        [211608.0, 6786141.0],
                        [205220.0, 6785800.0],
                        [202166.0, 6798131.0],
                        [202658.0, 6804638.0],
                        [212675.0, 6807535.0],
                        [216996.0, 6817941.0],
                        [214652.0, 6824074.0],
                        [215204.0, 6828740.0],
                        [213034.0, 6834627.0],
                        [212655.0, 6842190.0],
                        [216761.0, 6846809.0],
                        [210382.0, 6855067.0],
                        [210124.0, 6860562.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "29", "NOM_DEPT": "FINISTERE"},
        },
        68: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [995359.0, 6526975.0],
                        [996263.0, 6533312.0],
                        [1005620.0, 6535079.0],
                        [1009539.0, 6537663.0],
                        [1013275.0, 6543845.0],
                        [1010939.0, 6550631.0],
                        [1005414.0, 6557665.0],
                        [1000587.0, 6561265.0],
                        [1000913.0, 6565514.0],
                        [994423.0, 6565990.0],
                        [993170.0, 6574229.0],
                        [997429.0, 6583180.0],
                        [990846.0, 6588853.0],
                        [991547.0, 6595136.0],
                        [985884.0, 6596474.0],
                        [972312.0, 6594423.0],
                        [960663.0, 6587846.0],
                        [955674.0, 6591075.0],
                        [952150.0, 6588701.0],
                        [949250.0, 6580383.0],
                        [953939.0, 6574878.0],
                        [949136.0, 6572391.0],
                        [944956.0, 6566962.0],
                        [928176.0, 6563414.0],
                        [918731.0, 6560168.0],
                        [916992.0, 6555432.0],
                        [917441.0, 6547210.0],
                        [919315.0, 6541572.0],
                        [921730.0, 6540986.0],
                        [922988.0, 6530552.0],
                        [926213.0, 6526897.0],
                        [936560.0, 6520059.0],
                        [946066.0, 6522280.0],
                        [948121.0, 6516633.0],
                        [952091.0, 6514710.0],
                        [959117.0, 6516128.0],
                        [962862.0, 6525460.0],
                        [965836.0, 6528299.0],
                        [969073.0, 6537583.0],
                        [971940.0, 6540371.0],
                        [975690.0, 6531451.0],
                        [979688.0, 6528135.0],
                        [984284.0, 6528734.0],
                        [988618.0, 6520489.0],
                        [995359.0, 6526975.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "74", "NOM_DEPT": "HAUTE-SAVOIE"},
        },
        69: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [605624.0, 6904387.0],
                        [608283.0, 6898554.0],
                        [612180.0, 6899061.0],
                        [618689.0, 6896449.0],
                        [626847.0, 6897876.0],
                        [633020.0, 6901508.0],
                        [645465.0, 6895048.0],
                        [649761.0, 6898738.0],
                        [652314.0, 6895981.0],
                        [659205.0, 6894147.0],
                        [670084.0, 6886723.0],
                        [673222.0, 6889902.0],
                        [680633.0, 6884542.0],
                        [700622.0, 6887964.0],
                        [705248.0, 6890863.0],
                        [710189.0, 6894765.0],
                        [704672.0, 6899225.0],
                        [701957.0, 6908433.0],
                        [698137.0, 6911415.0],
                        [706929.0, 6919738.0],
                        [706805.0, 6926038.0],
                        [711648.0, 6928031.0],
                        [706939.0, 6934901.0],
                        [709520.0, 6938240.0],
                        [707064.0, 6950845.0],
                        [708546.0, 6956332.0],
                        [693916.0, 6955962.0],
                        [685089.0, 6950779.0],
                        [685504.0, 6946842.0],
                        [677528.0, 6947426.0],
                        [676176.0, 6942514.0],
                        [669006.0, 6944292.0],
                        [664208.0, 6949037.0],
                        [654712.0, 6950974.0],
                        [645659.0, 6956103.0],
                        [636565.0, 6954687.0],
                        [623025.0, 6958366.0],
                        [620154.0, 6956108.0],
                        [612314.0, 6962826.0],
                        [605401.0, 6955866.0],
                        [607933.0, 6953359.0],
                        [606321.0, 6945902.0],
                        [609123.0, 6937659.0],
                        [607205.0, 6935073.0],
                        [610545.0, 6930338.0],
                        [606642.0, 6924066.0],
                        [609871.0, 6919444.0],
                        [610931.0, 6911811.0],
                        [606128.0, 6907968.0],
                        [605624.0, 6904387.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "60", "NOM_DEPT": "OISE"},
        },
        70: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [598361.0, 6887345.0],
                        [603102.0, 6887292.0],
                        [606678.0, 6883543.0],
                        [614076.0, 6886919.0],
                        [622312.0, 6880731.0],
                        [628641.0, 6878089.0],
                        [633062.0, 6879807.0],
                        [641836.0, 6872490.0],
                        [641404.0, 6867928.0],
                        [648071.0, 6872567.0],
                        [653619.0, 6875101.0],
                        [660416.0, 6872923.0],
                        [667303.0, 6878971.0],
                        [670084.0, 6886723.0],
                        [659205.0, 6894147.0],
                        [652314.0, 6895981.0],
                        [649761.0, 6898738.0],
                        [645465.0, 6895048.0],
                        [633020.0, 6901508.0],
                        [626847.0, 6897876.0],
                        [618689.0, 6896449.0],
                        [612180.0, 6899061.0],
                        [608283.0, 6898554.0],
                        [605624.0, 6904387.0],
                        [603501.0, 6902160.0],
                        [601892.0, 6893098.0],
                        [598361.0, 6887345.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "95", "NOM_DEPT": "VAL-D'OISE"},
        },
        71: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [783517.0, 6693799.0],
                        [773484.0, 6692940.0],
                        [773240.0, 6698003.0],
                        [759265.0, 6699206.0],
                        [753904.0, 6700965.0],
                        [751168.0, 6705240.0],
                        [743701.0, 6707332.0],
                        [743712.0, 6710994.0],
                        [738638.0, 6714270.0],
                        [736733.0, 6710509.0],
                        [729904.0, 6712131.0],
                        [726085.0, 6708066.0],
                        [723118.0, 6710529.0],
                        [717731.0, 6709895.0],
                        [715400.0, 6713642.0],
                        [709181.0, 6715638.0],
                        [707666.0, 6720847.0],
                        [701928.0, 6717598.0],
                        [698236.0, 6718784.0],
                        [693556.0, 6718403.0],
                        [690565.0, 6713347.0],
                        [694642.0, 6704915.0],
                        [690449.0, 6694237.0],
                        [698745.0, 6684384.0],
                        [698614.0, 6680189.0],
                        [702129.0, 6669867.0],
                        [701762.0, 6662486.0],
                        [705753.0, 6657660.0],
                        [706033.0, 6650549.0],
                        [703828.0, 6645606.0],
                        [705186.0, 6641947.0],
                        [702446.0, 6632753.0],
                        [703745.0, 6628663.0],
                        [716475.0, 6620334.0],
                        [720608.0, 6624106.0],
                        [726499.0, 6620539.0],
                        [733164.0, 6623625.0],
                        [737251.0, 6617690.0],
                        [742042.0, 6624120.0],
                        [748049.0, 6627896.0],
                        [756196.0, 6628301.0],
                        [760920.0, 6622686.0],
                        [770503.0, 6626941.0],
                        [775685.0, 6631211.0],
                        [781064.0, 6632682.0],
                        [780490.0, 6638662.0],
                        [783308.0, 6642195.0],
                        [778932.0, 6646959.0],
                        [779000.0, 6654397.0],
                        [781374.0, 6662136.0],
                        [778810.0, 6664936.0],
                        [780471.0, 6669516.0],
                        [784602.0, 6669828.0],
                        [789554.0, 6672918.0],
                        [791663.0, 6673495.0],
                        [793165.0, 6678355.0],
                        [789098.0, 6683996.0],
                        [785899.0, 6682517.0],
                        [783517.0, 6693799.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "58", "NOM_DEPT": "NIEVRE"},
        },
        72: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [871408.0, 6655745.0],
                        [875449.0, 6660099.0],
                        [876191.0, 6666228.0],
                        [881002.0, 6667371.0],
                        [884880.0, 6674426.0],
                        [887407.0, 6682465.0],
                        [888032.0, 6690633.0],
                        [890265.0, 6692353.0],
                        [884919.0, 6701062.0],
                        [880595.0, 6713705.0],
                        [884206.0, 6713509.0],
                        [887785.0, 6718944.0],
                        [886108.0, 6726069.0],
                        [882147.0, 6728546.0],
                        [878352.0, 6725366.0],
                        [868188.0, 6726357.0],
                        [863148.0, 6730266.0],
                        [858300.0, 6729814.0],
                        [848455.0, 6733791.0],
                        [846031.0, 6742315.0],
                        [848388.0, 6746302.0],
                        [846087.0, 6753627.0],
                        [838226.0, 6763382.0],
                        [833316.0, 6764154.0],
                        [833398.0, 6769005.0],
                        [827043.0, 6770243.0],
                        [817962.0, 6771080.0],
                        [816397.0, 6764598.0],
                        [808147.0, 6762855.0],
                        [797692.0, 6763119.0],
                        [796594.0, 6759156.0],
                        [794318.0, 6750026.0],
                        [799053.0, 6750471.0],
                        [799827.0, 6740411.0],
                        [794312.0, 6737086.0],
                        [795163.0, 6731989.0],
                        [791050.0, 6725986.0],
                        [788376.0, 6717645.0],
                        [783952.0, 6713331.0],
                        [784360.0, 6705398.0],
                        [780393.0, 6701310.0],
                        [783517.0, 6693799.0],
                        [785899.0, 6682517.0],
                        [789098.0, 6683996.0],
                        [793165.0, 6678355.0],
                        [791663.0, 6673495.0],
                        [795506.0, 6668991.0],
                        [806631.0, 6665548.0],
                        [806754.0, 6662035.0],
                        [813434.0, 6659755.0],
                        [823470.0, 6650227.0],
                        [831500.0, 6648015.0],
                        [855755.0, 6655507.0],
                        [860161.0, 6652754.0],
                        [871408.0, 6655745.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "21", "NOM_DEPT": "COTE-D'OR"},
        },
        73: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [643163.0, 6853168.0],
                        [634691.0, 6849194.0],
                        [632440.0, 6843248.0],
                        [627800.0, 6838438.0],
                        [627504.0, 6829048.0],
                        [623768.0, 6826369.0],
                        [620311.0, 6818025.0],
                        [620852.0, 6812073.0],
                        [624251.0, 6811501.0],
                        [625387.0, 6798948.0],
                        [639308.0, 6801806.0],
                        [653275.0, 6801114.0],
                        [655721.0, 6802434.0],
                        [657768.0, 6807009.0],
                        [665496.0, 6812431.0],
                        [663371.0, 6815578.0],
                        [663045.0, 6825117.0],
                        [666363.0, 6833836.0],
                        [665649.0, 6839786.0],
                        [668472.0, 6843626.0],
                        [663488.0, 6848458.0],
                        [653706.0, 6846856.0],
                        [650056.0, 6850064.0],
                        [643163.0, 6853168.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "91", "NOM_DEPT": "ESSONNE"},
        },
        74: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [483517.0, 6558927.0],
                        [485043.0, 6563684.0],
                        [480502.0, 6565882.0],
                        [477460.0, 6571967.0],
                        [478920.0, 6578170.0],
                        [482897.0, 6584792.0],
                        [479925.0, 6587264.0],
                        [475179.0, 6582497.0],
                        [472141.0, 6584899.0],
                        [472081.0, 6590232.0],
                        [468300.0, 6594579.0],
                        [467690.0, 6607234.0],
                        [472374.0, 6614809.0],
                        [467588.0, 6622657.0],
                        [470952.0, 6628365.0],
                        [469757.0, 6639127.0],
                        [471018.0, 6649618.0],
                        [465537.0, 6662685.0],
                        [464624.0, 6667352.0],
                        [458546.0, 6672434.0],
                        [454238.0, 6672319.0],
                        [442005.0, 6668948.0],
                        [434893.0, 6670550.0],
                        [429925.0, 6668493.0],
                        [429262.0, 6663802.0],
                        [424993.0, 6661094.0],
                        [417889.0, 6660618.0],
                        [413368.0, 6662854.0],
                        [404251.0, 6660135.0],
                        [408792.0, 6655192.0],
                        [411920.0, 6644974.0],
                        [417892.0, 6640888.0],
                        [415662.0, 6636435.0],
                        [420740.0, 6628764.0],
                        [421344.0, 6621760.0],
                        [423543.0, 6619698.0],
                        [424018.0, 6609992.0],
                        [422851.0, 6601758.0],
                        [420470.0, 6597142.0],
                        [428213.0, 6593481.0],
                        [426574.0, 6590996.0],
                        [411453.0, 6585116.0],
                        [411065.0, 6578554.0],
                        [415606.0, 6575464.0],
                        [420640.0, 6566176.0],
                        [426299.0, 6566639.0],
                        [429269.0, 6562335.0],
                        [437311.0, 6559539.0],
                        [446458.0, 6558600.0],
                        [459784.0, 6545825.0],
                        [464645.0, 6548283.0],
                        [465641.0, 6555184.0],
                        [469589.0, 6554692.0],
                        [473907.0, 6559092.0],
                        [483517.0, 6558927.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "79", "NOM_DEPT": "DEUX-SEVRES"},
        },
        75: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [306966.0, 6794650.0],
                        [311879.0, 6798427.0],
                        [315234.0, 6806646.0],
                        [320973.0, 6806998.0],
                        [325505.0, 6811765.0],
                        [328273.0, 6809495.0],
                        [332923.0, 6813386.0],
                        [337450.0, 6835570.0],
                        [334969.0, 6837949.0],
                        [330825.0, 6841252.0],
                        [325749.0, 6841751.0],
                        [322500.0, 6846053.0],
                        [319331.0, 6843417.0],
                        [315059.0, 6845536.0],
                        [309156.0, 6855461.0],
                        [296913.0, 6849790.0],
                        [284640.0, 6841250.0],
                        [280881.0, 6840740.0],
                        [271227.0, 6848399.0],
                        [271155.0, 6854763.0],
                        [262910.0, 6863924.0],
                        [263482.0, 6867351.0],
                        [257346.0, 6869777.0],
                        [251930.0, 6880323.0],
                        [243322.0, 6881073.0],
                        [228138.0, 6874463.0],
                        [222446.0, 6879145.0],
                        [216642.0, 6872989.0],
                        [215941.0, 6861279.0],
                        [210124.0, 6860562.0],
                        [210382.0, 6855067.0],
                        [216761.0, 6846809.0],
                        [212655.0, 6842190.0],
                        [213034.0, 6834627.0],
                        [215204.0, 6828740.0],
                        [214652.0, 6824074.0],
                        [216996.0, 6817941.0],
                        [212675.0, 6807535.0],
                        [229439.0, 6804532.0],
                        [233945.0, 6800703.0],
                        [242780.0, 6802066.0],
                        [246074.0, 6807146.0],
                        [252150.0, 6805897.0],
                        [270150.0, 6795768.0],
                        [279762.0, 6794931.0],
                        [277875.0, 6787107.0],
                        [280665.0, 6785525.0],
                        [285132.0, 6789099.0],
                        [291749.0, 6798375.0],
                        [298204.0, 6799128.0],
                        [300637.0, 6793781.0],
                        [306966.0, 6794650.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "22", "NOM_DEPT": "COTES-D'ARMOR"},
        },
        76: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [702446.0, 6632753.0],
                        [696943.0, 6633749.0],
                        [686837.0, 6626145.0],
                        [682775.0, 6624336.0],
                        [677474.0, 6626628.0],
                        [669145.0, 6615318.0],
                        [670500.0, 6605989.0],
                        [664479.0, 6602292.0],
                        [660370.0, 6603761.0],
                        [650317.0, 6601560.0],
                        [645179.0, 6595086.0],
                        [644784.0, 6591412.0],
                        [647921.0, 6581264.0],
                        [653217.0, 6581299.0],
                        [659880.0, 6575828.0],
                        [662729.0, 6571178.0],
                        [666451.0, 6560450.0],
                        [672252.0, 6557694.0],
                        [679424.0, 6569309.0],
                        [685369.0, 6566281.0],
                        [688886.0, 6572856.0],
                        [695157.0, 6571452.0],
                        [693029.0, 6567076.0],
                        [697819.0, 6557998.0],
                        [712873.0, 6551781.0],
                        [728730.0, 6550656.0],
                        [732386.0, 6552810.0],
                        [735860.0, 6546571.0],
                        [745523.0, 6547324.0],
                        [753779.0, 6537018.0],
                        [754888.0, 6541809.0],
                        [761084.0, 6541876.0],
                        [763887.0, 6544360.0],
                        [762385.0, 6549859.0],
                        [763504.0, 6554575.0],
                        [760949.0, 6561975.0],
                        [762003.0, 6573092.0],
                        [769267.0, 6575508.0],
                        [775913.0, 6580395.0],
                        [775079.0, 6589273.0],
                        [776586.0, 6596649.0],
                        [773476.0, 6599308.0],
                        [768312.0, 6598303.0],
                        [763922.0, 6603795.0],
                        [761463.0, 6602522.0],
                        [756931.0, 6607772.0],
                        [753291.0, 6618069.0],
                        [748734.0, 6623209.0],
                        [748049.0, 6627896.0],
                        [742042.0, 6624120.0],
                        [737251.0, 6617690.0],
                        [733164.0, 6623625.0],
                        [726499.0, 6620539.0],
                        [720608.0, 6624106.0],
                        [716475.0, 6620334.0],
                        [703745.0, 6628663.0],
                        [702446.0, 6632753.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "03", "NOM_DEPT": "ALLIER"},
        },
        77: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [365341.0, 6575902.0],
                            [359213.0, 6576771.0],
                            [352445.0, 6583031.0],
                            [350494.0, 6577212.0],
                            [356155.0, 6576636.0],
                            [364082.0, 6571051.0],
                            [365341.0, 6575902.0],
                        ]
                    ],
                    [
                        [
                            [373352.0, 6542832.0],
                            [371342.0, 6552252.0],
                            [366346.0, 6552808.0],
                            [362447.0, 6556836.0],
                            [360591.0, 6548506.0],
                            [369260.0, 6539881.0],
                            [371124.0, 6531592.0],
                            [374437.0, 6534213.0],
                            [375330.0, 6540510.0],
                            [373352.0, 6542832.0],
                        ]
                    ],
                    [
                        [
                            [464807.0, 6459164.0],
                            [461242.0, 6465553.0],
                            [455660.0, 6465791.0],
                            [456356.0, 6470307.0],
                            [447267.0, 6474282.0],
                            [443202.0, 6478722.0],
                            [445861.0, 6484044.0],
                            [444696.0, 6489309.0],
                            [446521.0, 6493231.0],
                            [442913.0, 6501478.0],
                            [436951.0, 6506668.0],
                            [434607.0, 6512022.0],
                            [434480.0, 6521530.0],
                            [445866.0, 6528260.0],
                            [449713.0, 6524677.0],
                            [455132.0, 6526680.0],
                            [458386.0, 6534878.0],
                            [457303.0, 6539406.0],
                            [459784.0, 6545825.0],
                            [446458.0, 6558600.0],
                            [437311.0, 6559539.0],
                            [429269.0, 6562335.0],
                            [426299.0, 6566639.0],
                            [420640.0, 6566176.0],
                            [415606.0, 6575464.0],
                            [411065.0, 6578554.0],
                            [411453.0, 6585116.0],
                            [404775.0, 6589452.0],
                            [397324.0, 6586760.0],
                            [391500.0, 6591809.0],
                            [382360.0, 6587238.0],
                            [383479.0, 6581738.0],
                            [376439.0, 6576760.0],
                            [374243.0, 6571617.0],
                            [381511.0, 6566597.0],
                            [386552.0, 6553761.0],
                            [382858.0, 6551653.0],
                            [385303.0, 6547012.0],
                            [378912.0, 6532887.0],
                            [370510.0, 6529071.0],
                            [370474.0, 6520657.0],
                            [379564.0, 6513624.0],
                            [387626.0, 6509256.0],
                            [386164.0, 6505245.0],
                            [399796.0, 6489042.0],
                            [404682.0, 6481482.0],
                            [406100.0, 6476140.0],
                            [418478.0, 6475494.0],
                            [421098.0, 6472770.0],
                            [431214.0, 6470295.0],
                            [433418.0, 6457450.0],
                            [437492.0, 6457585.0],
                            [444096.0, 6451365.0],
                            [452009.0, 6448234.0],
                            [457280.0, 6451647.0],
                            [460931.0, 6449393.0],
                            [464807.0, 6459164.0],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "17", "NOM_DEPT": "CHARENTE-MARITIME"},
        },
        78: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [728488.0, 6430309.0],
                        [727352.0, 6435060.0],
                        [723408.0, 6437470.0],
                        [725628.0, 6444038.0],
                        [722648.0, 6446835.0],
                        [717445.0, 6463649.0],
                        [709251.0, 6464988.0],
                        [708104.0, 6472781.0],
                        [701310.0, 6465307.0],
                        [695974.0, 6467752.0],
                        [693859.0, 6474045.0],
                        [688449.0, 6477003.0],
                        [677684.0, 6475835.0],
                        [672750.0, 6482640.0],
                        [661594.0, 6486680.0],
                        [659915.0, 6480065.0],
                        [656321.0, 6476249.0],
                        [651369.0, 6479623.0],
                        [649118.0, 6470007.0],
                        [642886.0, 6465907.0],
                        [636846.0, 6458269.0],
                        [638218.0, 6451518.0],
                        [634831.0, 6442812.0],
                        [628772.0, 6440050.0],
                        [631663.0, 6432186.0],
                        [626129.0, 6431248.0],
                        [628463.0, 6419614.0],
                        [634482.0, 6410441.0],
                        [633003.0, 6406356.0],
                        [634129.0, 6393565.0],
                        [637122.0, 6391031.0],
                        [637228.0, 6394175.0],
                        [646639.0, 6396959.0],
                        [655192.0, 6393469.0],
                        [664849.0, 6402561.0],
                        [665404.0, 6408608.0],
                        [668313.0, 6410487.0],
                        [668604.0, 6416079.0],
                        [676829.0, 6423158.0],
                        [679353.0, 6426925.0],
                        [684359.0, 6419403.0],
                        [688126.0, 6419157.0],
                        [690477.0, 6411547.0],
                        [694820.0, 6408897.0],
                        [693924.0, 6403282.0],
                        [698547.0, 6393953.0],
                        [704864.0, 6413115.0],
                        [707862.0, 6414941.0],
                        [708330.0, 6420849.0],
                        [714401.0, 6418301.0],
                        [719705.0, 6424147.0],
                        [728488.0, 6430309.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "15", "NOM_DEPT": "CANTAL"},
        },
        79: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [664821.0, 6258302.0],
                        [662679.0, 6249784.0],
                        [667653.0, 6244475.0],
                        [681495.0, 6239871.0],
                        [686427.0, 6247043.0],
                        [700353.0, 6246775.0],
                        [700385.0, 6243263.0],
                        [711963.0, 6238657.0],
                        [716336.0, 6238907.0],
                        [719561.0, 6234874.0],
                        [727933.0, 6241307.0],
                        [734945.0, 6243544.0],
                        [741504.0, 6241707.0],
                        [748880.0, 6250885.0],
                        [753675.0, 6255020.0],
                        [764523.0, 6260540.0],
                        [773373.0, 6269062.0],
                        [781738.0, 6273121.0],
                        [788998.0, 6273432.0],
                        [792922.0, 6276955.0],
                        [796379.0, 6284647.0],
                        [792244.0, 6293431.0],
                        [780634.0, 6301895.0],
                        [773726.0, 6310049.0],
                        [766790.0, 6307842.0],
                        [766255.0, 6313712.0],
                        [763184.0, 6318967.0],
                        [758340.0, 6319159.0],
                        [750088.0, 6313306.0],
                        [746263.0, 6307559.0],
                        [742673.0, 6306434.0],
                        [734096.0, 6312602.0],
                        [728786.0, 6312824.0],
                        [722102.0, 6311077.0],
                        [716344.0, 6301672.0],
                        [704815.0, 6303628.0],
                        [704898.0, 6288229.0],
                        [698819.0, 6289943.0],
                        [694796.0, 6288406.0],
                        [693221.0, 6284557.0],
                        [680178.0, 6279485.0],
                        [676690.0, 6282993.0],
                        [671212.0, 6283521.0],
                        [668935.0, 6274250.0],
                        [672394.0, 6269695.0],
                        [672444.0, 6264623.0],
                        [668090.0, 6259189.0],
                        [664821.0, 6258302.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "34", "NOM_DEPT": "HERAULT"},
        },
        80: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [921863.0, 6404787.0],
                        [918546.0, 6403480.0],
                        [907889.0, 6409384.0],
                        [894862.0, 6413405.0],
                        [895949.0, 6427870.0],
                        [895595.0, 6439026.0],
                        [892767.0, 6444271.0],
                        [888053.0, 6440277.0],
                        [871457.0, 6445038.0],
                        [871909.0, 6454823.0],
                        [870728.0, 6463360.0],
                        [866406.0, 6463235.0],
                        [860939.0, 6470947.0],
                        [855768.0, 6473591.0],
                        [847361.0, 6468209.0],
                        [841110.0, 6468164.0],
                        [842390.0, 6453321.0],
                        [844782.0, 6435636.0],
                        [848816.0, 6428161.0],
                        [844069.0, 6414766.0],
                        [839715.0, 6410394.0],
                        [841041.0, 6396655.0],
                        [835764.0, 6388411.0],
                        [834538.0, 6384016.0],
                        [835151.0, 6374038.0],
                        [832713.0, 6371581.0],
                        [831614.0, 6360351.0],
                        [840525.0, 6360052.0],
                        [843837.0, 6356928.0],
                        [844895.0, 6349809.0],
                        [864358.0, 6358713.0],
                        [871547.0, 6356009.0],
                        [872115.0, 6350341.0],
                        [890550.0, 6347548.0],
                        [890601.0, 6342463.0],
                        [894810.0, 6342254.0],
                        [899978.0, 6338355.0],
                        [903520.0, 6340766.0],
                        [905908.0, 6346585.0],
                        [911050.0, 6344481.0],
                        [913873.0, 6347227.0],
                        [914428.0, 6355637.0],
                        [911254.0, 6355549.0],
                        [909816.0, 6362305.0],
                        [898744.0, 6362932.0],
                        [892505.0, 6372493.0],
                        [899815.0, 6380077.0],
                        [907085.0, 6377469.0],
                        [909000.0, 6384874.0],
                        [906293.0, 6386082.0],
                        [910174.0, 6394503.0],
                        [921214.0, 6398819.0],
                        [921863.0, 6404787.0],
                    ],
                    [
                        [850837.0, 6364673.0],
                        [852761.0, 6369494.0],
                        [856829.0, 6372215.0],
                        [860545.0, 6368019.0],
                        [860544.0, 6360615.0],
                        [857850.0, 6357360.0],
                        [850729.0, 6357929.0],
                        [850837.0, 6364673.0],
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "26", "NOM_DEPT": "DROME"},
        },
        81: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [600206.0, 6164532.0],
                        [597209.0, 6163462.0],
                        [595443.0, 6155896.0],
                        [604042.0, 6154257.0],
                        [614139.0, 6147692.0],
                        [616327.0, 6140765.0],
                        [624388.0, 6140739.0],
                        [630462.0, 6147428.0],
                        [638840.0, 6149005.0],
                        [653442.0, 6143379.0],
                        [657322.0, 6137875.0],
                        [662029.0, 6137190.0],
                        [665163.0, 6139863.0],
                        [672907.0, 6137962.0],
                        [673207.0, 6145058.0],
                        [679658.0, 6147303.0],
                        [683451.0, 6146537.0],
                        [686936.0, 6150974.0],
                        [703357.0, 6152588.0],
                        [707042.0, 6147292.0],
                        [714275.0, 6148346.0],
                        [710994.0, 6157024.0],
                        [704080.0, 6161154.0],
                        [702907.0, 6175403.0],
                        [703560.0, 6193187.0],
                        [693222.0, 6198384.0],
                        [688989.0, 6202113.0],
                        [682753.0, 6199641.0],
                        [678721.0, 6193157.0],
                        [675246.0, 6192375.0],
                        [659825.0, 6194610.0],
                        [655189.0, 6193206.0],
                        [644930.0, 6193342.0],
                        [647326.0, 6181831.0],
                        [644388.0, 6178927.0],
                        [631545.0, 6174170.0],
                        [617954.0, 6174066.0],
                        [615529.0, 6169131.0],
                        [607482.0, 6165290.0],
                        [600206.0, 6164532.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "66", "NOM_DEPT": "PYRENEES-ORIENTALES"},
        },
        82: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [956276.0, 6452799.0],
                        [964422.0, 6450656.0],
                        [967061.0, 6446025.0],
                        [974349.0, 6445704.0],
                        [973771.0, 6449910.0],
                        [985382.0, 6452122.0],
                        [989157.0, 6455721.0],
                        [995952.0, 6458223.0],
                        [1002558.0, 6454919.0],
                        [1011443.0, 6464355.0],
                        [1024403.0, 6470318.0],
                        [1021887.0, 6478062.0],
                        [1027167.0, 6487344.0],
                        [1021485.0, 6490016.0],
                        [1020210.0, 6493869.0],
                        [1012252.0, 6497350.0],
                        [1011518.0, 6512378.0],
                        [1006337.0, 6512917.0],
                        [997830.0, 6518696.0],
                        [995359.0, 6526975.0],
                        [988618.0, 6520489.0],
                        [984284.0, 6528734.0],
                        [979688.0, 6528135.0],
                        [975690.0, 6531451.0],
                        [971940.0, 6540371.0],
                        [969073.0, 6537583.0],
                        [965836.0, 6528299.0],
                        [962862.0, 6525460.0],
                        [959117.0, 6516128.0],
                        [952091.0, 6514710.0],
                        [948121.0, 6516633.0],
                        [946066.0, 6522280.0],
                        [936560.0, 6520059.0],
                        [926213.0, 6526897.0],
                        [922988.0, 6530552.0],
                        [921730.0, 6540986.0],
                        [919315.0, 6541572.0],
                        [916332.0, 6528631.0],
                        [915868.0, 6518199.0],
                        [910338.0, 6515974.0],
                        [909413.0, 6509006.0],
                        [904449.0, 6504924.0],
                        [913763.0, 6489603.0],
                        [917457.0, 6486189.0],
                        [925224.0, 6482705.0],
                        [931624.0, 6492445.0],
                        [938381.0, 6486658.0],
                        [943964.0, 6486985.0],
                        [948557.0, 6482085.0],
                        [949441.0, 6473761.0],
                        [945461.0, 6470305.0],
                        [945165.0, 6465401.0],
                        [950505.0, 6456663.0],
                        [956276.0, 6452799.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "73", "NOM_DEPT": "SAVOIE"},
        },
        83: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [921863.0, 6404787.0],
                        [921214.0, 6398819.0],
                        [910174.0, 6394503.0],
                        [906293.0, 6386082.0],
                        [909000.0, 6384874.0],
                        [907085.0, 6377469.0],
                        [899815.0, 6380077.0],
                        [892505.0, 6372493.0],
                        [898744.0, 6362932.0],
                        [909816.0, 6362305.0],
                        [911254.0, 6355549.0],
                        [914428.0, 6355637.0],
                        [913873.0, 6347227.0],
                        [920148.0, 6349530.0],
                        [930231.0, 6349978.0],
                        [925339.0, 6357350.0],
                        [932421.0, 6356788.0],
                        [935206.0, 6370624.0],
                        [944316.0, 6377139.0],
                        [950982.0, 6378672.0],
                        [957118.0, 6369997.0],
                        [959705.0, 6373500.0],
                        [957182.0, 6379131.0],
                        [967103.0, 6386021.0],
                        [971476.0, 6380340.0],
                        [983401.0, 6378221.0],
                        [988952.0, 6378656.0],
                        [992592.0, 6389297.0],
                        [999315.0, 6394909.0],
                        [1004568.0, 6397351.0],
                        [1010207.0, 6403290.0],
                        [1012913.0, 6402904.0],
                        [1015781.0, 6406977.0],
                        [1022960.0, 6406318.0],
                        [1016213.0, 6418043.0],
                        [1016501.0, 6423604.0],
                        [1010607.0, 6425833.0],
                        [1004832.0, 6424533.0],
                        [995855.0, 6430156.0],
                        [996598.0, 6437292.0],
                        [994575.0, 6442256.0],
                        [989294.0, 6442329.0],
                        [985382.0, 6452122.0],
                        [973771.0, 6449910.0],
                        [974349.0, 6445704.0],
                        [967061.0, 6446025.0],
                        [964422.0, 6450656.0],
                        [956276.0, 6452799.0],
                        [953909.0, 6450690.0],
                        [952342.0, 6439924.0],
                        [961377.0, 6439340.0],
                        [964872.0, 6432532.0],
                        [965006.0, 6422921.0],
                        [960775.0, 6424797.0],
                        [956742.0, 6422339.0],
                        [947667.0, 6423241.0],
                        [941569.0, 6417648.0],
                        [939410.0, 6420031.0],
                        [933177.0, 6416064.0],
                        [930672.0, 6410433.0],
                        [925560.0, 6409806.0],
                        [921863.0, 6404787.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "05", "NOM_DEPT": "HAUTES-ALPES"},
        },
        84: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [850837.0, 6364673.0],
                            [850729.0, 6357929.0],
                            [857850.0, 6357360.0],
                            [860544.0, 6360615.0],
                            [860545.0, 6368019.0],
                            [856829.0, 6372215.0],
                            [852761.0, 6369494.0],
                            [850837.0, 6364673.0],
                        ]
                    ],
                    [
                        [
                            [839658.0, 6315433.0],
                            [848847.0, 6314233.0],
                            [858049.0, 6310039.0],
                            [863255.0, 6305296.0],
                            [865136.0, 6300908.0],
                            [876282.0, 6295340.0],
                            [879627.0, 6296831.0],
                            [886796.0, 6295631.0],
                            [896706.0, 6289935.0],
                            [904218.0, 6287715.0],
                            [910307.0, 6287877.0],
                            [921881.0, 6295602.0],
                            [922160.0, 6296144.0],
                            [913516.0, 6306489.0],
                            [907367.0, 6306820.0],
                            [909386.0, 6316209.0],
                            [901642.0, 6319541.0],
                            [903879.0, 6328807.0],
                            [900470.0, 6332559.0],
                            [899978.0, 6338355.0],
                            [894810.0, 6342254.0],
                            [890601.0, 6342463.0],
                            [890550.0, 6347548.0],
                            [872115.0, 6350341.0],
                            [871547.0, 6356009.0],
                            [864358.0, 6358713.0],
                            [844895.0, 6349809.0],
                            [843837.0, 6356928.0],
                            [840525.0, 6360052.0],
                            [831614.0, 6360351.0],
                            [831641.0, 6353746.0],
                            [837656.0, 6344658.0],
                            [836689.0, 6335330.0],
                            [843231.0, 6331183.0],
                            [847769.0, 6322554.0],
                            [839658.0, 6315433.0],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "84", "NOM_DEPT": "VAUCLUSE"},
        },
        85: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [636090.0, 6591904.0],
                        [634893.0, 6595681.0],
                        [638969.0, 6598575.0],
                        [635550.0, 6606712.0],
                        [637665.0, 6611745.0],
                        [634340.0, 6622075.0],
                        [628673.0, 6627353.0],
                        [632500.0, 6630848.0],
                        [627496.0, 6637025.0],
                        [633457.0, 6642556.0],
                        [629301.0, 6648616.0],
                        [631131.0, 6657674.0],
                        [627981.0, 6660408.0],
                        [627833.0, 6667741.0],
                        [621646.0, 6669974.0],
                        [615265.0, 6667454.0],
                        [607114.0, 6670785.0],
                        [612309.0, 6675948.0],
                        [612147.0, 6680536.0],
                        [602149.0, 6685865.0],
                        [593597.0, 6687211.0],
                        [582631.0, 6683116.0],
                        [573297.0, 6677558.0],
                        [576079.0, 6670370.0],
                        [571950.0, 6667671.0],
                        [568878.0, 6661167.0],
                        [560408.0, 6661557.0],
                        [553982.0, 6659068.0],
                        [551779.0, 6655211.0],
                        [546519.0, 6631001.0],
                        [537221.0, 6629765.0],
                        [541431.0, 6623495.0],
                        [538906.0, 6616112.0],
                        [542426.0, 6611026.0],
                        [547958.0, 6609437.0],
                        [557842.0, 6602380.0],
                        [558128.0, 6596023.0],
                        [562773.0, 6594026.0],
                        [559931.0, 6588729.0],
                        [569564.0, 6587075.0],
                        [573702.0, 6590223.0],
                        [578129.0, 6584256.0],
                        [586530.0, 6592902.0],
                        [595863.0, 6588324.0],
                        [602234.0, 6588456.0],
                        [609355.0, 6592908.0],
                        [622684.0, 6592821.0],
                        [630016.0, 6590287.0],
                        [636090.0, 6591904.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "36", "NOM_DEPT": "INDRE"},
        },
        86: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1232225.0, 6105798.0],
                        [1232233.0, 6116272.0],
                        [1242213.0, 6134033.0],
                        [1241272.0, 6154177.0],
                        [1238247.0, 6164499.0],
                        [1238682.0, 6169952.0],
                        [1236764.0, 6182904.0],
                        [1228823.0, 6195229.0],
                        [1228376.0, 6197858.0],
                        [1231051.0, 6211355.0],
                        [1228846.0, 6218876.0],
                        [1227050.0, 6231255.0],
                        [1223421.0, 6233783.0],
                        [1216996.0, 6231337.0],
                        [1218749.0, 6222752.0],
                        [1215986.0, 6213431.0],
                        [1218915.0, 6209217.0],
                        [1219580.0, 6202912.0],
                        [1215962.0, 6195537.0],
                        [1212393.0, 6200184.0],
                        [1205077.0, 6201621.0],
                        [1198634.0, 6198671.0],
                        [1193909.0, 6190462.0],
                        [1183050.0, 6187935.0],
                        [1176939.0, 6184145.0],
                        [1176781.0, 6180877.0],
                        [1165934.0, 6173994.0],
                        [1165800.0, 6162888.0],
                        [1161943.0, 6162734.0],
                        [1159342.0, 6158599.0],
                        [1164950.0, 6158109.0],
                        [1180116.0, 6152978.0],
                        [1187662.0, 6146432.0],
                        [1199675.0, 6142105.0],
                        [1202519.0, 6133762.0],
                        [1206639.0, 6131576.0],
                        [1210743.0, 6122769.0],
                        [1215715.0, 6123336.0],
                        [1217754.0, 6104291.0],
                        [1226359.0, 6102880.0],
                        [1232225.0, 6105798.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "2B", "NOM_DEPT": "HAUTE-CORSE"},
        },
        87: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [563452.0, 6484264.0],
                        [566212.0, 6489282.0],
                        [571080.0, 6486618.0],
                        [576059.0, 6493313.0],
                        [581471.0, 6497412.0],
                        [587429.0, 6495459.0],
                        [593766.0, 6498788.0],
                        [605337.0, 6509707.0],
                        [612121.0, 6507862.0],
                        [614305.0, 6511565.0],
                        [612524.0, 6515422.0],
                        [613074.0, 6522626.0],
                        [604752.0, 6527760.0],
                        [597279.0, 6527024.0],
                        [591561.0, 6529605.0],
                        [592200.0, 6538029.0],
                        [586335.0, 6540289.0],
                        [587795.0, 6549437.0],
                        [580656.0, 6565605.0],
                        [574730.0, 6569689.0],
                        [580236.0, 6579624.0],
                        [578129.0, 6584256.0],
                        [573702.0, 6590223.0],
                        [569564.0, 6587075.0],
                        [559931.0, 6588729.0],
                        [556218.0, 6586207.0],
                        [548271.0, 6584464.0],
                        [546474.0, 6577615.0],
                        [538896.0, 6578287.0],
                        [530127.0, 6570272.0],
                        [531964.0, 6561069.0],
                        [531290.0, 6552122.0],
                        [539507.0, 6547743.0],
                        [540666.0, 6541823.0],
                        [534383.0, 6537804.0],
                        [527825.0, 6527023.0],
                        [522669.0, 6525452.0],
                        [522412.0, 6520738.0],
                        [515635.0, 6515544.0],
                        [526849.0, 6509996.0],
                        [524801.0, 6504583.0],
                        [529342.0, 6499739.0],
                        [539039.0, 6503445.0],
                        [546900.0, 6501981.0],
                        [553144.0, 6489340.0],
                        [563452.0, 6484264.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "87", "NOM_DEPT": "HAUTE-VIENNE"},
        },
        88: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [297360.0, 6667914.0],
                            [299985.0, 6664525.0],
                            [303823.0, 6669495.0],
                            [298725.0, 6671705.0],
                            [297360.0, 6667914.0],
                        ]
                    ],
                    [
                        [
                            [322009.0, 6670666.0],
                            [318317.0, 6668787.0],
                            [315194.0, 6662103.0],
                            [307861.0, 6656132.0],
                            [308108.0, 6649020.0],
                            [322518.0, 6633220.0],
                            [328569.0, 6623483.0],
                            [331126.0, 6610513.0],
                            [333817.0, 6610276.0],
                            [344797.0, 6600884.0],
                            [354269.0, 6598459.0],
                            [356701.0, 6592204.0],
                            [364357.0, 6592471.0],
                            [376108.0, 6582708.0],
                            [376887.0, 6588202.0],
                            [382360.0, 6587238.0],
                            [391500.0, 6591809.0],
                            [397324.0, 6586760.0],
                            [404775.0, 6589452.0],
                            [411453.0, 6585116.0],
                            [426574.0, 6590996.0],
                            [428213.0, 6593481.0],
                            [420470.0, 6597142.0],
                            [422851.0, 6601758.0],
                            [424018.0, 6609992.0],
                            [423543.0, 6619698.0],
                            [421344.0, 6621760.0],
                            [420740.0, 6628764.0],
                            [415662.0, 6636435.0],
                            [417892.0, 6640888.0],
                            [411920.0, 6644974.0],
                            [408792.0, 6655192.0],
                            [404251.0, 6660135.0],
                            [401283.0, 6663962.0],
                            [392012.0, 6664073.0],
                            [385082.0, 6667087.0],
                            [376108.0, 6673611.0],
                            [374065.0, 6668782.0],
                            [367645.0, 6668175.0],
                            [367588.0, 6659427.0],
                            [361112.0, 6656907.0],
                            [359840.0, 6669393.0],
                            [354394.0, 6667534.0],
                            [354064.0, 6663454.0],
                            [357453.0, 6652400.0],
                            [353671.0, 6649968.0],
                            [343129.0, 6653969.0],
                            [338731.0, 6658583.0],
                            [332678.0, 6659222.0],
                            [324590.0, 6666698.0],
                            [322009.0, 6670666.0],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "85", "NOM_DEPT": "VENDEE"},
        },
        89: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [917346.0, 6234793.0],
                        [919352.0, 6230892.0],
                        [929076.0, 6227424.0],
                        [928534.0, 6223947.0],
                        [932969.0, 6220583.0],
                        [939545.0, 6227616.0],
                        [947016.0, 6224540.0],
                        [954550.0, 6225038.0],
                        [959301.0, 6228480.0],
                        [965861.0, 6230140.0],
                        [974387.0, 6227034.0],
                        [975697.0, 6233209.0],
                        [984286.0, 6234176.0],
                        [989472.0, 6238682.0],
                        [995722.0, 6237173.0],
                        [997536.0, 6239863.0],
                        [998568.0, 6249133.0],
                        [997443.0, 6253468.0],
                        [1002933.0, 6264260.0],
                        [1012590.0, 6265313.0],
                        [1018256.0, 6272482.0],
                        [1014132.0, 6274778.0],
                        [1015523.0, 6285590.0],
                        [1006552.0, 6288390.0],
                        [1003290.0, 6292496.0],
                        [1002326.0, 6300425.0],
                        [992638.0, 6305621.0],
                        [983574.0, 6307147.0],
                        [974774.0, 6305117.0],
                        [974848.0, 6301646.0],
                        [970413.0, 6298787.0],
                        [958836.0, 6305328.0],
                        [956283.0, 6301072.0],
                        [944763.0, 6293054.0],
                        [933734.0, 6296912.0],
                        [923991.0, 6299127.0],
                        [922160.0, 6296144.0],
                        [921881.0, 6295602.0],
                        [926823.0, 6291811.0],
                        [925792.0, 6288611.0],
                        [917893.0, 6286245.0],
                        [916541.0, 6283087.0],
                        [920209.0, 6276225.0],
                        [918385.0, 6268519.0],
                        [922861.0, 6263349.0],
                        [917403.0, 6259253.0],
                        [924245.0, 6244827.0],
                        [918110.0, 6241136.0],
                        [917346.0, 6234793.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "83", "NOM_DEPT": "VAR"},
        },
        90: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [670056.0, 6856451.0],
                        [662997.0, 6862431.0],
                        [657169.0, 6861180.0],
                        [650942.0, 6857646.0],
                        [650056.0, 6850064.0],
                        [653706.0, 6846856.0],
                        [663488.0, 6848458.0],
                        [668472.0, 6843626.0],
                        [671600.0, 6851283.0],
                        [670056.0, 6856451.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "94", "NOM_DEPT": "VAL-DE-MARNE"},
        },
        91: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [650942.0, 6857646.0],
                        [645325.0, 6859675.0],
                        [643644.0, 6863501.0],
                        [650140.0, 6866932.0],
                        [648071.0, 6872567.0],
                        [641404.0, 6867928.0],
                        [637864.0, 6864035.0],
                        [637702.0, 6857774.0],
                        [643163.0, 6853168.0],
                        [650056.0, 6850064.0],
                        [650942.0, 6857646.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "92", "NOM_DEPT": "HAUTS-DE-SEINE"},
        },
        92: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [698547.0, 6393953.0],
                        [706639.0, 6384441.0],
                        [705449.0, 6378272.0],
                        [710800.0, 6372878.0],
                        [709537.0, 6364934.0],
                        [712305.0, 6356606.0],
                        [709994.0, 6353946.0],
                        [718362.0, 6347498.0],
                        [728598.0, 6344387.0],
                        [729879.0, 6341376.0],
                        [735189.0, 6336775.0],
                        [750700.0, 6336169.0],
                        [750995.0, 6342037.0],
                        [754256.0, 6342872.0],
                        [763780.0, 6336809.0],
                        [768987.0, 6337162.0],
                        [776174.0, 6341769.0],
                        [775968.0, 6350322.0],
                        [773621.0, 6356674.0],
                        [775941.0, 6359276.0],
                        [770571.0, 6365836.0],
                        [775211.0, 6367175.0],
                        [779411.0, 6373918.0],
                        [775042.0, 6386528.0],
                        [771844.0, 6388592.0],
                        [768276.0, 6405343.0],
                        [758530.0, 6415778.0],
                        [752669.0, 6414624.0],
                        [752090.0, 6419191.0],
                        [746937.0, 6419760.0],
                        [746579.0, 6414955.0],
                        [737614.0, 6413026.0],
                        [732994.0, 6422485.0],
                        [732563.0, 6427378.0],
                        [728488.0, 6430309.0],
                        [719705.0, 6424147.0],
                        [714401.0, 6418301.0],
                        [708330.0, 6420849.0],
                        [707862.0, 6414941.0],
                        [704864.0, 6413115.0],
                        [698547.0, 6393953.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "48", "NOM_DEPT": "LOZERE"},
        },
        93: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [799607.0, 6263119.0],
                        [825918.0, 6262030.0],
                        [828657.0, 6259471.0],
                        [826719.0, 6253810.0],
                        [834804.0, 6251115.0],
                        [842728.0, 6251679.0],
                        [850515.0, 6249931.0],
                        [851283.0, 6257962.0],
                        [859395.0, 6260541.0],
                        [865618.0, 6249711.0],
                        [881792.0, 6250642.0],
                        [887411.0, 6254047.0],
                        [891677.0, 6249845.0],
                        [890480.0, 6245406.0],
                        [892188.0, 6237089.0],
                        [906247.0, 6238345.0],
                        [911635.0, 6232742.0],
                        [917346.0, 6234793.0],
                        [918110.0, 6241136.0],
                        [924245.0, 6244827.0],
                        [917403.0, 6259253.0],
                        [922861.0, 6263349.0],
                        [918385.0, 6268519.0],
                        [920209.0, 6276225.0],
                        [916541.0, 6283087.0],
                        [917893.0, 6286245.0],
                        [925792.0, 6288611.0],
                        [926823.0, 6291811.0],
                        [921881.0, 6295602.0],
                        [910307.0, 6287877.0],
                        [904218.0, 6287715.0],
                        [896706.0, 6289935.0],
                        [886796.0, 6295631.0],
                        [879627.0, 6296831.0],
                        [876282.0, 6295340.0],
                        [865136.0, 6300908.0],
                        [863255.0, 6305296.0],
                        [858049.0, 6310039.0],
                        [848847.0, 6314233.0],
                        [839658.0, 6315433.0],
                        [831988.0, 6308980.0],
                        [833168.0, 6302217.0],
                        [828463.0, 6288899.0],
                        [819908.0, 6290041.0],
                        [815212.0, 6281222.0],
                        [813903.0, 6274579.0],
                        [800175.0, 6267290.0],
                        [799607.0, 6263119.0],
                    ],
                    [
                        [869889.0, 6258065.0],
                        [866899.0, 6258272.0],
                        [866104.0, 6264876.0],
                        [862374.0, 6265459.0],
                        [862969.0, 6272152.0],
                        [870516.0, 6271879.0],
                        [874819.0, 6259107.0],
                        [869889.0, 6258065.0],
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "13", "NOM_DEPT": "BOUCHES-DU-RHONE"},
        },
        94: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [650942.0, 6857646.0],
                        [657169.0, 6861180.0],
                        [654926.0, 6867065.0],
                        [650140.0, 6866932.0],
                        [643644.0, 6863501.0],
                        [645325.0, 6859675.0],
                        [650942.0, 6857646.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "75", "NOM_DEPT": "PARIS"},
        },
        95: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [670056.0, 6856451.0],
                        [667928.0, 6865519.0],
                        [670882.0, 6870004.0],
                        [667303.0, 6878971.0],
                        [660416.0, 6872923.0],
                        [653619.0, 6875101.0],
                        [648071.0, 6872567.0],
                        [650140.0, 6866932.0],
                        [654926.0, 6867065.0],
                        [657169.0, 6861180.0],
                        [662997.0, 6862431.0],
                        [670056.0, 6856451.0],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"},
        },
    },
}

geolayer_fr_dept_data_and_geometry_4326_precision_6 = {
    "metadata": {
        "name": "FRANCE_DPT_GENERALIZE_LAMB93_ROUND_DATA_AND_GEOMETRY",
        "fields": {
            "CODE_DEPT": {"type": "String", "width": 2, "index": 0},
            "NOM_DEPT": {"type": "String", "width": 23, "index": 1},
        },
        "geometry_ref": {"type": {"MultiPolygon", "Polygon"}, "crs": 4326},
    },
    "features": {
        0: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.606811, 43.310886],
                        [0.655938, 43.317209],
                        [0.717591, 43.376631],
                        [0.820542, 43.416975],
                        [0.917251, 43.406333],
                        [0.978084, 43.362652],
                        [1.018184, 43.473338],
                        [1.201337, 43.594813],
                        [1.147549, 43.634176],
                        [1.087696, 43.644975],
                        [0.953983, 43.787372],
                        [0.906156, 43.784331],
                        [0.899439, 43.864698],
                        [0.862892, 43.923289],
                        [0.760085, 43.942242],
                        [0.860417, 44.040785],
                        [0.775783, 44.035911],
                        [0.741885, 44.065199],
                        [0.666592, 44.025146],
                        [0.597978, 44.078227],
                        [0.539031, 44.053722],
                        [0.459516, 44.055237],
                        [0.44245, 44.028762],
                        [0.30409, 43.993057],
                        [0.189575, 44.014642],
                        [0.076046, 43.983143],
                        [0.076647, 43.916471],
                        [0.032557, 43.900188],
                        [-0.073598, 43.945047],
                        [-0.179109, 43.93792],
                        [-0.233939, 43.891068],
                        [-0.190992, 43.875183],
                        [-0.194143, 43.737017],
                        [-0.232582, 43.714087],
                        [-0.242837, 43.584976],
                        [-0.176413, 43.596404],
                        [-0.096783, 43.582406],
                        [-0.015781, 43.604657],
                        [-0.001925, 43.56554],
                        [0.056081, 43.518807],
                        [0.112124, 43.51737],
                        [0.137982, 43.432916],
                        [0.182031, 43.371183],
                        [0.277255, 43.385791],
                        [0.498034, 43.326181],
                        [0.606811, 43.310886],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"},
        },
        1: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.075141, 44.577325],
                        [0.979128, 44.64361],
                        [0.869996, 44.597307],
                        [0.817004, 44.627001],
                        [0.827001, 44.69189],
                        [0.657434, 44.677847],
                        [0.630488, 44.706528],
                        [0.414707, 44.646337],
                        [0.365575, 44.662211],
                        [0.335449, 44.737436],
                        [0.297326, 44.762285],
                        [0.153004, 44.730481],
                        [0.133726, 44.682444],
                        [0.182678, 44.661072],
                        [0.153608, 44.616123],
                        [0.040568, 44.553047],
                        [-0.015454, 44.505063],
                        [-0.010552, 44.418543],
                        [0.018234, 44.389879],
                        [-0.085752, 44.33761],
                        [-0.034811, 44.296726],
                        [-0.066625, 44.246758],
                        [-0.140688, 44.226405],
                        [-0.129155, 44.15241],
                        [-0.004232, 44.149996],
                        [0.034594, 44.130652],
                        [0.135108, 44.124221],
                        [0.100821, 44.08677],
                        [0.062698, 44.000842],
                        [0.076046, 43.983143],
                        [0.189575, 44.014642],
                        [0.30409, 43.993057],
                        [0.44245, 44.028762],
                        [0.459516, 44.055237],
                        [0.539031, 44.053722],
                        [0.597978, 44.078227],
                        [0.666592, 44.025146],
                        [0.741885, 44.065199],
                        [0.752884, 44.10227],
                        [0.868774, 44.12633],
                        [0.91909, 44.23827],
                        [0.949924, 44.276442],
                        [0.87347, 44.323308],
                        [0.887331, 44.366375],
                        [1.049803, 44.362639],
                        [1.064084, 44.378513],
                        [1.009025, 44.480041],
                        [1.013167, 44.536127],
                        [1.075141, 44.577325],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "47", "NOM_DEPT": "LOT-ET-GARONNE"},
        },
        2: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [4.800494, 45.298361],
                        [4.880238, 45.297454],
                        [4.989191, 45.344047],
                        [5.054319, 45.319055],
                        [5.121426, 45.248336],
                        [5.176541, 45.248402],
                        [5.188574, 45.171269],
                        [5.179385, 45.08331],
                        [5.388383, 45.036139],
                        [5.449789, 45.070784],
                        [5.483609, 45.022786],
                        [5.483647, 44.922291],
                        [5.464159, 44.792427],
                        [5.627085, 44.752464],
                        [5.759044, 44.69607],
                        [5.80147, 44.706779],
                        [5.850399, 44.750745],
                        [5.915233, 44.754706],
                        [5.949519, 44.80453],
                        [6.030211, 44.838096],
                        [6.056343, 44.815908],
                        [6.136224, 44.864073],
                        [6.250544, 44.852655],
                        [6.302847, 44.87326],
                        [6.355361, 44.854779],
                        [6.35884, 44.941284],
                        [6.318198, 45.003857],
                        [6.203927, 45.012469],
                        [6.229388, 45.10875],
                        [6.260566, 45.126848],
                        [6.189208, 45.163732],
                        [6.125696, 45.24427],
                        [6.131945, 45.288287],
                        [6.18445, 45.317949],
                        [6.177451, 45.393161],
                        [6.121272, 45.438898],
                        [6.049754, 45.43792],
                        [5.96617, 45.492309],
                        [5.879738, 45.406797],
                        [5.782081, 45.440655],
                        [5.736372, 45.47254],
                        [5.623748, 45.613268],
                        [5.545542, 45.713593],
                        [5.422641, 45.807124],
                        [5.434945, 45.831094],
                        [5.353827, 45.883273],
                        [5.309169, 45.854933],
                        [5.266895, 45.789369],
                        [5.191533, 45.771688],
                        [5.101067, 45.813378],
                        [5.094527, 45.739453],
                        [5.131048, 45.707709],
                        [5.035149, 45.637203],
                        [4.901458, 45.606268],
                        [4.808697, 45.572301],
                        [4.868482, 45.52344],
                        [4.756936, 45.455707],
                        [4.755997, 45.365672],
                        [4.800494, 45.298361],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "38", "NOM_DEPT": "ISERE"},
        },
        3: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.067712, 51.006505],
                        [1.915776, 50.984085],
                        [1.728853, 50.937892],
                        [1.664095, 50.890132],
                        [1.580638, 50.867346],
                        [1.604213, 50.79187],
                        [1.560712, 50.699676],
                        [1.585413, 50.537352],
                        [1.557789, 50.404718],
                        [1.641544, 50.352153],
                        [1.670716, 50.33101],
                        [1.778784, 50.361866],
                        [1.918001, 50.311779],
                        [1.946132, 50.287428],
                        [2.07782, 50.248821],
                        [2.095748, 50.205545],
                        [2.273828, 50.22684],
                        [2.370205, 50.20977],
                        [2.451785, 50.230302],
                        [2.49569, 50.194562],
                        [2.389777, 50.155485],
                        [2.414508, 50.100642],
                        [2.476687, 50.136999],
                        [2.55133, 50.141605],
                        [2.57602, 50.113413],
                        [2.857844, 50.077393],
                        [2.876533, 50.042179],
                        [3.090254, 50.053741],
                        [3.095757, 50.124202],
                        [3.156132, 50.183715],
                        [3.173376, 50.241108],
                        [2.993078, 50.379847],
                        [3.037672, 50.44164],
                        [3.020793, 50.481769],
                        [2.96471, 50.512778],
                        [2.898952, 50.501558],
                        [2.825982, 50.525388],
                        [2.805166, 50.603271],
                        [2.840449, 50.656566],
                        [2.769041, 50.663678],
                        [2.713851, 50.631292],
                        [2.630516, 50.617952],
                        [2.495949, 50.631245],
                        [2.407792, 50.672766],
                        [2.340891, 50.740906],
                        [2.21343, 50.810549],
                        [2.183905, 50.883452],
                        [2.097601, 50.998427],
                        [2.067712, 51.006505],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "62", "NOM_DEPT": "PAS-DE-CALAIS"},
        },
        4: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [4.047973, 49.405642],
                        [4.14317, 49.404187],
                        [4.248308, 49.382256],
                        [4.306757, 49.327797],
                        [4.422583, 49.280645],
                        [4.575868, 49.296651],
                        [4.625104, 49.235656],
                        [4.686075, 49.256759],
                        [4.826941, 49.235761],
                        [4.894206, 49.259074],
                        [4.950989, 49.236866],
                        [5.051181, 49.274052],
                        [5.026437, 49.335914],
                        [5.115897, 49.421924],
                        [5.062396, 49.499153],
                        [5.118279, 49.593072],
                        [5.162975, 49.563534],
                        [5.311757, 49.55929],
                        [5.393537, 49.617088],
                        [5.350332, 49.630859],
                        [5.269179, 49.696074],
                        [5.166195, 49.692916],
                        [5.093503, 49.76373],
                        [5.063183, 49.761929],
                        [4.873875, 49.820795],
                        [4.854193, 49.864787],
                        [4.883308, 49.896179],
                        [4.85019, 49.946473],
                        [4.790903, 49.958398],
                        [4.86853, 50.097625],
                        [4.879552, 50.15203],
                        [4.824292, 50.160731],
                        [4.762161, 50.136397],
                        [4.68319, 50.064922],
                        [4.688866, 49.995498],
                        [4.59306, 49.985507],
                        [4.51041, 49.946683],
                        [4.446941, 49.937505],
                        [4.333647, 49.963561],
                        [4.233068, 49.957824],
                        [4.248507, 49.856523],
                        [4.209589, 49.781781],
                        [4.250089, 49.757102],
                        [4.127022, 49.677921],
                        [4.099316, 49.628478],
                        [4.031391, 49.61429],
                        [4.076571, 49.571127],
                        [4.040712, 49.508535],
                        [4.047973, 49.405642],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "08", "NOM_DEPT": "ARDENNES"},
        },
        5: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [3.414792, 48.390273],
                        [3.498153, 48.369097],
                        [3.616804, 48.27134],
                        [3.621604, 48.22574],
                        [3.66787, 48.139212],
                        [3.740291, 48.169708],
                        [3.804968, 48.10255],
                        [3.850029, 47.983792],
                        [3.902087, 47.93917],
                        [4.111786, 47.926996],
                        [4.199158, 47.969941],
                        [4.293424, 47.925676],
                        [4.309004, 47.961173],
                        [4.448998, 47.957155],
                        [4.559969, 47.971423],
                        [4.582679, 48.029464],
                        [4.704238, 48.020232],
                        [4.688819, 48.073128],
                        [4.73061, 48.118209],
                        [4.819307, 48.103192],
                        [4.8501, 48.141759],
                        [4.85892, 48.263638],
                        [4.809738, 48.34736],
                        [4.716096, 48.394855],
                        [4.653455, 48.470549],
                        [4.670183, 48.531887],
                        [4.614027, 48.553807],
                        [4.545407, 48.525252],
                        [4.403063, 48.56126],
                        [4.315905, 48.615579],
                        [4.325594, 48.700277],
                        [4.166387, 48.707454],
                        [4.080262, 48.701069],
                        [4.001695, 48.663875],
                        [3.949227, 48.603432],
                        [3.822742, 48.516104],
                        [3.730879, 48.537468],
                        [3.634028, 48.541298],
                        [3.555614, 48.620285],
                        [3.503854, 48.604809],
                        [3.423442, 48.533563],
                        [3.39196, 48.424322],
                        [3.414792, 48.390273],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "10", "NOM_DEPT": "AUBE"},
        },
        6: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [6.88743, 44.361048],
                        [6.796091, 44.316106],
                        [6.723994, 44.249843],
                        [6.686536, 44.169254],
                        [6.75528, 44.078607],
                        [6.745714, 44.043235],
                        [6.836004, 43.990602],
                        [6.851892, 43.954794],
                        [6.913089, 43.927965],
                        [6.88461, 43.889121],
                        [6.830709, 43.918363],
                        [6.745556, 43.872108],
                        [6.697323, 43.873655],
                        [6.636396, 43.788951],
                        [6.753536, 43.738167],
                        [6.760801, 43.666488],
                        [6.798741, 43.62818],
                        [6.908013, 43.599079],
                        [6.88423, 43.502536],
                        [6.933726, 43.480068],
                        [6.971832, 43.545449],
                        [7.040446, 43.541581],
                        [7.126469, 43.605275],
                        [7.167667, 43.657403],
                        [7.241891, 43.688485],
                        [7.320291, 43.691327],
                        [7.528513, 43.790515],
                        [7.49544, 43.864355],
                        [7.559219, 43.897295],
                        [7.567109, 43.943678],
                        [7.648594, 43.974109],
                        [7.664987, 44.030668],
                        [7.716934, 44.081761],
                        [7.670852, 44.153741],
                        [7.505741, 44.143652],
                        [7.426949, 44.112879],
                        [7.281966, 44.143451],
                        [7.188915, 44.197803],
                        [7.071038, 44.23295],
                        [7.008055, 44.236431],
                        [6.993447, 44.280891],
                        [6.88743, 44.361048],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "06", "NOM_DEPT": "ALPES-MARITIMES"},
        },
        7: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [3.694018, 45.930732],
                        [3.754371, 45.886031],
                        [3.699758, 45.783182],
                        [3.78085, 45.724349],
                        [3.823453, 45.632417],
                        [3.903596, 45.599022],
                        [3.954348, 45.555963],
                        [3.975106, 45.44827],
                        [3.899188, 45.410308],
                        [3.897408, 45.357084],
                        [3.979651, 45.375134],
                        [4.024824, 45.342888],
                        [4.177926, 45.392605],
                        [4.308199, 45.370987],
                        [4.366534, 45.336996],
                        [4.362549, 45.264395],
                        [4.418571, 45.275424],
                        [4.483135, 45.236446],
                        [4.602423, 45.251704],
                        [4.614497, 45.309837],
                        [4.679512, 45.346112],
                        [4.755997, 45.365672],
                        [4.756936, 45.455707],
                        [4.722337, 45.494298],
                        [4.661742, 45.486754],
                        [4.614858, 45.575468],
                        [4.519766, 45.573255],
                        [4.410284, 45.632051],
                        [4.365516, 45.698519],
                        [4.391252, 45.754935],
                        [4.383032, 45.863994],
                        [4.323926, 45.900501],
                        [4.293912, 45.9534],
                        [4.306096, 46.021229],
                        [4.28041, 46.052944],
                        [4.321567, 46.129223],
                        [4.438591, 46.167879],
                        [4.38808, 46.219789],
                        [4.2825, 46.15695],
                        [4.261021, 46.178751],
                        [4.132418, 46.177826],
                        [4.104091, 46.198395],
                        [3.988787, 46.16981],
                        [3.972545, 46.202712],
                        [3.890132, 46.214491],
                        [3.899533, 46.275905],
                        [3.804887, 46.254857],
                        [3.789762, 46.154851],
                        [3.821869, 46.087984],
                        [3.806764, 46.045623],
                        [3.825443, 45.995968],
                        [3.788909, 45.973859],
                        [3.708884, 45.973785],
                        [3.694018, 45.930732],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "42", "NOM_DEPT": "LOIRE"},
        },
        8: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.606811, 43.310886],
                        [0.61628, 43.289037],
                        [0.551568, 43.236103],
                        [0.551875, 43.209147],
                        [0.441999, 43.131273],
                        [0.53227, 43.093864],
                        [0.563004, 43.017468],
                        [0.627418, 43.000103],
                        [0.575935, 42.870826],
                        [0.477301, 42.878107],
                        [0.4589, 42.828145],
                        [0.455094, 42.728061],
                        [0.47775, 42.69999],
                        [0.682264, 42.708968],
                        [0.644541, 42.783076],
                        [0.659015, 42.838529],
                        [0.708378, 42.861402],
                        [0.858306, 42.825719],
                        [0.832413, 42.919988],
                        [0.874911, 42.957776],
                        [0.979101, 42.974431],
                        [1.007046, 43.007591],
                        [0.985169, 43.067056],
                        [1.038836, 43.100553],
                        [1.058913, 43.141826],
                        [1.124082, 43.156907],
                        [1.208734, 43.117951],
                        [1.227481, 43.183893],
                        [1.314608, 43.189995],
                        [1.374373, 43.213746],
                        [1.29331, 43.285337],
                        [1.343652, 43.315606],
                        [1.425361, 43.256572],
                        [1.463711, 43.210601],
                        [1.54752, 43.275674],
                        [1.637204, 43.255115],
                        [1.68842, 43.273554],
                        [1.747733, 43.34374],
                        [1.813424, 43.341404],
                        [1.804085, 43.391685],
                        [1.858743, 43.443821],
                        [1.910101, 43.404059],
                        [2.029133, 43.436898],
                        [2.018141, 43.47035],
                        [1.882609, 43.520929],
                        [1.824801, 43.580832],
                        [1.687771, 43.6307],
                        [1.730869, 43.65775],
                        [1.706446, 43.71622],
                        [1.660421, 43.741834],
                        [1.644788, 43.800257],
                        [1.591029, 43.815488],
                        [1.555463, 43.868315],
                        [1.555617, 43.918317],
                        [1.447877, 43.873553],
                        [1.356813, 43.884192],
                        [1.36089, 43.821074],
                        [1.219193, 43.770778],
                        [1.144598, 43.822298],
                        [0.953983, 43.787372],
                        [1.087696, 43.644975],
                        [1.147549, 43.634176],
                        [1.201337, 43.594813],
                        [1.018184, 43.473338],
                        [0.978084, 43.362652],
                        [0.917251, 43.406333],
                        [0.820542, 43.416975],
                        [0.717591, 43.376631],
                        [0.655938, 43.317209],
                        [0.606811, 43.310886],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "31", "NOM_DEPT": "HAUTE-GARONNE"},
        },
        9: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [4.38808, 46.219789],
                        [4.405814, 46.296061],
                        [4.503988, 46.26713],
                        [4.618552, 46.264793],
                        [4.693107, 46.302195],
                        [4.73053, 46.178372],
                        [4.780213, 46.176677],
                        [4.810995, 46.259922],
                        [4.888208, 46.402982],
                        [4.891818, 46.439914],
                        [4.940023, 46.517198],
                        [5.052374, 46.484873],
                        [5.201145, 46.50821],
                        [5.215064, 46.468359],
                        [5.310561, 46.446766],
                        [5.415742, 46.473139],
                        [5.359191, 46.522561],
                        [5.441108, 46.63754],
                        [5.391089, 46.728696],
                        [5.370245, 46.826171],
                        [5.459286, 46.855245],
                        [5.316959, 46.904056],
                        [5.263265, 46.935911],
                        [5.255236, 46.979888],
                        [5.106281, 46.955765],
                        [5.049304, 46.981587],
                        [4.72813, 46.919375],
                        [4.62323, 46.94082],
                        [4.493691, 47.028372],
                        [4.406283, 47.05],
                        [4.405487, 47.081643],
                        [4.2596, 47.114326],
                        [4.209834, 47.155412],
                        [4.181888, 47.150505],
                        [4.115967, 47.123338],
                        [4.061427, 47.121042],
                        [4.038726, 47.08001],
                        [4.072015, 47.054495],
                        [4.039402, 46.98511],
                        [4.037222, 46.918156],
                        [4.093851, 46.874734],
                        [4.056234, 46.843272],
                        [4.06271, 46.789365],
                        [3.991959, 46.776751],
                        [3.923394, 46.738873],
                        [3.79733, 46.701503],
                        [3.73619, 46.752471],
                        [3.629424, 46.749459],
                        [3.637901, 46.707209],
                        [3.696952, 46.660582],
                        [3.743287, 46.56757],
                        [3.801756, 46.5199],
                        [3.834006, 46.531132],
                        [3.890471, 46.481251],
                        [3.957938, 46.489756],
                        [3.998042, 46.465468],
                        [3.977215, 46.399225],
                        [3.986626, 46.319194],
                        [3.899533, 46.275905],
                        [3.890132, 46.214491],
                        [3.972545, 46.202712],
                        [3.988787, 46.16981],
                        [4.104091, 46.198395],
                        [4.132418, 46.177826],
                        [4.261021, 46.178751],
                        [4.2825, 46.15695],
                        [4.38808, 46.219789],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "71", "NOM_DEPT": "SAONE-ET-LOIRE"},
        },
        10: {
            "attributes": {"CODE_DEPT": "53", "NOM_DEPT": "MAYENNE"},
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-1.070165, 48.508494],
                        [-1.082794, 48.433058],
                        [-1.04502, 48.327728],
                        [-1.100061, 48.25928],
                        [-1.049606, 48.089805],
                        [-1.023283, 48.068911],
                        [-1.021261, 47.99494],
                        [-1.102671, 47.989063],
                        [-1.153994, 47.965821],
                        [-1.189184, 47.867978],
                        [-1.238252, 47.809991],
                        [-1.142627, 47.774442],
                        [-1.099916, 47.781967],
                        [-0.978657, 47.761991],
                        [-0.95203, 47.796497],
                        [-0.839294, 47.752273],
                        [-0.741708, 47.738107],
                        [-0.610818, 47.735689],
                        [-0.460412, 47.765091],
                        [-0.381703, 47.760563],
                        [-0.388201, 47.805319],
                        [-0.447859, 47.832216],
                        [-0.370673, 47.880025],
                        [-0.38484, 47.930845],
                        [-0.282633, 47.958192],
                        [-0.341665, 48.043096],
                        [-0.230942, 48.058985],
                        [-0.217174, 48.10696],
                        [-0.249921, 48.157107],
                        [-0.146837, 48.205009],
                        [-0.163096, 48.255542],
                        [-0.137978, 48.361356],
                        [-0.054531, 48.382003],
                        [-0.051896, 48.45326],
                        [-0.148713, 48.458068],
                        [-0.169383, 48.53697],
                        [-0.206938, 48.562945],
                        [-0.278228, 48.506989],
                        [-0.367623, 48.492944],
                        [-0.430754, 48.51182],
                        [-0.505065, 48.505796],
                        [-0.551718, 48.473117],
                        [-0.653994, 48.444282],
                        [-0.757281, 48.436551],
                        [-0.860363, 48.501458],
                        [-0.956379, 48.516618],
                        [-1.003999, 48.489171],
                        [-1.070165, 48.508494],
                    ]
                ],
            },
        },
        11: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-0.102937, 45.96966],
                        [-0.131664, 45.911021],
                        [-0.1154, 45.870664],
                        [-0.153095, 45.795737],
                        [-0.221745, 45.775746],
                        [-0.273119, 45.806559],
                        [-0.415839, 45.741669],
                        [-0.408929, 45.65618],
                        [-0.37592, 45.608919],
                        [-0.296715, 45.564494],
                        [-0.246156, 45.491641],
                        [-0.267424, 45.455678],
                        [-0.249759, 45.408742],
                        [-0.280896, 45.359871],
                        [-0.226702, 45.321433],
                        [-0.108786, 45.288952],
                        [-0.115385, 45.248073],
                        [-0.044168, 45.247891],
                        [0.004331, 45.191633],
                        [0.05343, 45.226855],
                        [0.127724, 45.209112],
                        [0.266609, 45.297749],
                        [0.24933, 45.363043],
                        [0.307849, 45.46087],
                        [0.356537, 45.465479],
                        [0.49626, 45.544488],
                        [0.499647, 45.617259],
                        [0.600693, 45.672144],
                        [0.629742, 45.71457],
                        [0.714888, 45.76312],
                        [0.71644, 45.805618],
                        [0.782232, 45.821082],
                        [0.862906, 45.919755],
                        [0.942592, 45.957436],
                        [0.925625, 46.010454],
                        [0.81791, 46.047878],
                        [0.823434, 46.128582],
                        [0.746905, 46.138575],
                        [0.687453, 46.097255],
                        [0.539973, 46.085558],
                        [0.506417, 46.131954],
                        [0.402656, 46.062676],
                        [0.279806, 46.060966],
                        [0.197354, 46.09555],
                        [0.072972, 46.093896],
                        [0.019273, 46.052848],
                        [-0.031995, 46.055922],
                        [-0.041431, 45.99348],
                        [-0.102937, 45.96966],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "16", "NOM_DEPT": "CHARENTE"},
        },
        12: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-0.840935, 48.75222],
                        [-0.967055, 48.786078],
                        [-1.089473, 48.781515],
                        [-1.132627, 48.848852],
                        [-1.071181, 48.870285],
                        [-0.94273, 48.967707],
                        [-0.869089, 49.067903],
                        [-0.886594, 49.129434],
                        [-0.931455, 49.145574],
                        [-0.900873, 49.202973],
                        [-1.022673, 49.203385],
                        [-1.113423, 49.261327],
                        [-1.139542, 49.309871],
                        [-1.119623, 49.355568],
                        [-1.163952, 49.366658],
                        [-1.18253, 49.424019],
                        [-1.306359, 49.538927],
                        [-1.304198, 49.573682],
                        [-1.229599, 49.62465],
                        [-1.287842, 49.692593],
                        [-1.421158, 49.703703],
                        [-1.541575, 49.65411],
                        [-1.678388, 49.661233],
                        [-1.942245, 49.725555],
                        [-1.946179, 49.674348],
                        [-1.8603, 49.650193],
                        [-1.841027, 49.571734],
                        [-1.885696, 49.540391],
                        [-1.826772, 49.452917],
                        [-1.819829, 49.390484],
                        [-1.711168, 49.325099],
                        [-1.598843, 49.169205],
                        [-1.609412, 49.079278],
                        [-1.560706, 49.001483],
                        [-1.564343, 48.921584],
                        [-1.594145, 48.834712],
                        [-1.574407, 48.751849],
                        [-1.504944, 48.687403],
                        [-1.393195, 48.650524],
                        [-1.449162, 48.623418],
                        [-1.571087, 48.626446],
                        [-1.518915, 48.566594],
                        [-1.489947, 48.489375],
                        [-1.377246, 48.458285],
                        [-1.272248, 48.533925],
                        [-1.206556, 48.542206],
                        [-1.070165, 48.508494],
                        [-1.003999, 48.489171],
                        [-0.956379, 48.516618],
                        [-0.860363, 48.501458],
                        [-0.774172, 48.562678],
                        [-0.752614, 48.617619],
                        [-0.798956, 48.710189],
                        [-0.840935, 48.75222],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "50", "NOM_DEPT": "MANCHE"},
        },
        13: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.501524, 48.941054],
                        [1.55725, 48.891577],
                        [1.591203, 48.81487],
                        [1.579546, 48.701812],
                        [1.602498, 48.663769],
                        [1.709253, 48.578024],
                        [1.76533, 48.569371],
                        [1.801446, 48.466088],
                        [1.922149, 48.4576],
                        [1.967426, 48.533071],
                        [2.017574, 48.557597],
                        [2.020006, 48.642089],
                        [2.082221, 48.685852],
                        [2.111889, 48.73956],
                        [2.226559, 48.776102],
                        [2.151578, 48.81702],
                        [2.152869, 48.87334],
                        [2.200591, 48.908679],
                        [2.205858, 48.949741],
                        [2.084915, 49.014679],
                        [2.024773, 48.998756],
                        [1.937802, 49.021776],
                        [1.82395, 49.076361],
                        [1.723457, 49.044977],
                        [1.673689, 49.078151],
                        [1.608796, 49.077894],
                        [1.521766, 49.068546],
                        [1.457763, 49.026291],
                        [1.501524, 48.941054],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "78", "NOM_DEPT": "YVELINES"},
        },
        14: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [6.806992, 47.562802],
                        [6.780972, 47.536415],
                        [6.685554, 47.562956],
                        [6.646719, 47.535261],
                        [6.581776, 47.53987],
                        [6.553563, 47.492797],
                        [6.401377, 47.5203],
                        [6.334354, 47.505966],
                        [6.262329, 47.43057],
                        [6.080046, 47.354036],
                        [5.989355, 47.327623],
                        [5.941375, 47.344254],
                        [5.698726, 47.264997],
                        [5.720409, 47.219937],
                        [5.811467, 47.169054],
                        [5.816084, 47.134339],
                        [5.768549, 47.089435],
                        [5.815051, 47.020339],
                        [5.96856, 46.980444],
                        [5.964072, 46.948079],
                        [6.005778, 46.873053],
                        [6.151794, 46.820667],
                        [6.20333, 46.772681],
                        [6.180271, 46.741575],
                        [6.069828, 46.689525],
                        [6.103767, 46.649818],
                        [6.048567, 46.607723],
                        [6.138109, 46.55766],
                        [6.110748, 46.576313],
                        [6.285329, 46.691241],
                        [6.438107, 46.761748],
                        [6.431005, 46.812412],
                        [6.464571, 46.89021],
                        [6.432669, 46.928602],
                        [6.5188, 46.970858],
                        [6.640345, 47.002757],
                        [6.714049, 47.049124],
                        [6.739908, 47.108057],
                        [6.85835, 47.164383],
                        [6.882433, 47.201616],
                        [6.954974, 47.242941],
                        [6.993127, 47.295545],
                        [7.062194, 47.344158],
                        [7.016179, 47.371836],
                        [6.917301, 47.356177],
                        [6.940537, 47.433374],
                        [6.90761, 47.494546],
                        [6.90567, 47.547362],
                        [6.806992, 47.562802],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "25", "NOM_DEPT": "DOUBS"},
        },
        15: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.765155, 48.496493],
                        [5.776212, 48.540359],
                        [5.71609, 48.561424],
                        [5.761767, 48.60939],
                        [5.757709, 48.695698],
                        [5.714036, 48.744533],
                        [5.780972, 48.826749],
                        [5.747162, 48.915258],
                        [5.800245, 48.946746],
                        [5.823067, 49.023107],
                        [5.818638, 49.086174],
                        [5.763361, 49.10788],
                        [5.744468, 49.156596],
                        [5.765544, 49.198089],
                        [5.719044, 49.215987],
                        [5.731786, 49.311343],
                        [5.688148, 49.415106],
                        [5.634566, 49.437436],
                        [5.529099, 49.407375],
                        [5.46178, 49.452691],
                        [5.47091, 49.497205],
                        [5.426919, 49.597347],
                        [5.393537, 49.617088],
                        [5.311757, 49.55929],
                        [5.162975, 49.563534],
                        [5.118279, 49.593072],
                        [5.062396, 49.499153],
                        [5.115897, 49.421924],
                        [5.026437, 49.335914],
                        [5.051181, 49.274052],
                        [4.950989, 49.236866],
                        [4.939762, 49.185068],
                        [4.992118, 49.1149],
                        [5.007681, 49.034952],
                        [5.036321, 49.024333],
                        [5.030129, 48.956902],
                        [4.936209, 48.922142],
                        [4.888761, 48.81721],
                        [4.990125, 48.741837],
                        [4.988428, 48.684419],
                        [5.005926, 48.634036],
                        [5.070888, 48.595725],
                        [5.118346, 48.595511],
                        [5.208426, 48.538611],
                        [5.34947, 48.481989],
                        [5.470048, 48.420929],
                        [5.615964, 48.439745],
                        [5.765155, 48.496493],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "55", "NOM_DEPT": "MEUSE"},
        },
        16: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.297326, 44.762285],
                        [0.241753, 44.856894],
                        [0.170434, 44.826684],
                        [0.083023, 44.831221],
                        [-0.015448, 44.857717],
                        [0.034362, 44.915469],
                        [0.007379, 44.947299],
                        [0.073297, 45.070121],
                        [0.04606, 45.113228],
                        [-0.0402, 45.102384],
                        [-0.087703, 45.121389],
                        [-0.152953, 45.088807],
                        [-0.255087, 45.114085],
                        [-0.342338, 45.167558],
                        [-0.394072, 45.16478],
                        [-0.429195, 45.279474],
                        [-0.559507, 45.297708],
                        [-0.594481, 45.321143],
                        [-0.752682, 45.32177],
                        [-0.774018, 45.369209],
                        [-0.841057, 45.435083],
                        [-1.025742, 45.574693],
                        [-1.091199, 45.56241],
                        [-1.15704, 45.47037],
                        [-1.162341, 45.297867],
                        [-1.222902, 44.864826],
                        [-1.222956, 44.709577],
                        [-1.160523, 44.774664],
                        [-1.036357, 44.693564],
                        [-1.005365, 44.648041],
                        [-1.080794, 44.640603],
                        [-1.19154, 44.660727],
                        [-1.227401, 44.575751],
                        [-1.260282, 44.539507],
                        [-1.25389, 44.467604],
                        [-1.106491, 44.502773],
                        [-1.085166, 44.532195],
                        [-0.980697, 44.482879],
                        [-1.007453, 44.437652],
                        [-0.91917, 44.443344],
                        [-0.845274, 44.418975],
                        [-0.730703, 44.446375],
                        [-0.628777, 44.443192],
                        [-0.627648, 44.398146],
                        [-0.528103, 44.364654],
                        [-0.517635, 44.339111],
                        [-0.43184, 44.322577],
                        [-0.383387, 44.286311],
                        [-0.389617, 44.209485],
                        [-0.272119, 44.193809],
                        [-0.223447, 44.205898],
                        [-0.194113, 44.26904],
                        [-0.140688, 44.226405],
                        [-0.066625, 44.246758],
                        [-0.034811, 44.296726],
                        [-0.085752, 44.33761],
                        [0.018234, 44.389879],
                        [-0.010552, 44.418543],
                        [-0.015454, 44.505063],
                        [0.040568, 44.553047],
                        [0.153608, 44.616123],
                        [0.182678, 44.661072],
                        [0.133726, 44.682444],
                        [0.153004, 44.730481],
                        [0.297326, 44.762285],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "33", "NOM_DEPT": "GIRONDE"},
        },
        17: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.297224, 49.429862],
                        [0.21994, 49.426762],
                        [0.11038, 49.394262],
                        [-0.013369, 49.321203],
                        [-0.099599, 49.297601],
                        [-0.225693, 49.281817],
                        [-0.414849, 49.335581],
                        [-0.515314, 49.345016],
                        [-0.722249, 49.347004],
                        [-0.851166, 49.362545],
                        [-0.939385, 49.395042],
                        [-1.078217, 49.388494],
                        [-1.119623, 49.355568],
                        [-1.139542, 49.309871],
                        [-1.113423, 49.261327],
                        [-1.022673, 49.203385],
                        [-0.900873, 49.202973],
                        [-0.931455, 49.145574],
                        [-0.886594, 49.129434],
                        [-0.869089, 49.067903],
                        [-0.94273, 48.967707],
                        [-1.071181, 48.870285],
                        [-1.132627, 48.848852],
                        [-1.089473, 48.781515],
                        [-0.967055, 48.786078],
                        [-0.840935, 48.75222],
                        [-0.714679, 48.799868],
                        [-0.463753, 48.871366],
                        [-0.411519, 48.87014],
                        [-0.346245, 48.821999],
                        [-0.305921, 48.858307],
                        [-0.146343, 48.834449],
                        [-0.058807, 48.853587],
                        [0.056398, 48.902464],
                        [0.127608, 48.952219],
                        [0.156475, 48.924788],
                        [0.27564, 48.964745],
                        [0.333773, 48.942884],
                        [0.412815, 48.950626],
                        [0.436751, 49.00819],
                        [0.37768, 49.04945],
                        [0.424875, 49.130194],
                        [0.394688, 49.150117],
                        [0.382787, 49.264016],
                        [0.323023, 49.296993],
                        [0.297224, 49.429862],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "14", "NOM_DEPT": "CALVADOS"},
        },
        18: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.884726, 47.926047],
                        [5.947521, 47.97971],
                        [6.002262, 47.95609],
                        [6.072564, 48.015666],
                        [6.156058, 48.006944],
                        [6.167985, 47.95235],
                        [6.237987, 47.932842],
                        [6.366146, 47.961945],
                        [6.431707, 47.943816],
                        [6.478602, 47.885522],
                        [6.542153, 47.902611],
                        [6.601782, 47.944399],
                        [6.645533, 47.904021],
                        [6.784822, 47.849623],
                        [6.823539, 47.813054],
                        [6.84618, 47.822945],
                        [6.920034, 47.850288],
                        [6.900213, 47.891191],
                        [6.943356, 47.997958],
                        [7.001884, 48.022399],
                        [7.058913, 48.137266],
                        [7.133556, 48.245941],
                        [7.198282, 48.310468],
                        [7.121908, 48.33329],
                        [7.097427, 48.405645],
                        [7.123165, 48.513592],
                        [6.982986, 48.47906],
                        [6.890811, 48.418094],
                        [6.815167, 48.398846],
                        [6.699498, 48.413088],
                        [6.584971, 48.460509],
                        [6.566974, 48.419032],
                        [6.178419, 48.397599],
                        [6.116724, 48.354038],
                        [5.961559, 48.349891],
                        [5.85607, 48.506844],
                        [5.765155, 48.496493],
                        [5.615964, 48.439745],
                        [5.470048, 48.420929],
                        [5.408721, 48.3831],
                        [5.482149, 48.356201],
                        [5.640901, 48.242354],
                        [5.710844, 48.219928],
                        [5.684319, 48.145042],
                        [5.630534, 48.083986],
                        [5.696799, 48.07723],
                        [5.777748, 48.031362],
                        [5.787281, 47.952597],
                        [5.850004, 47.962835],
                        [5.884726, 47.926047],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "88", "NOM_DEPT": "VOSGES"},
        },
        19: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.239214, 47.620978],
                        [2.127969, 47.584698],
                        [2.195636, 47.548574],
                        [2.238219, 47.472343],
                        [2.101693, 47.386783],
                        [2.138991, 47.285486],
                        [1.997038, 47.265439],
                        [1.940816, 47.290131],
                        [1.90408, 47.215655],
                        [1.839079, 47.219308],
                        [1.842109, 47.178029],
                        [1.774581, 47.130847],
                        [1.882722, 47.10195],
                        [1.966414, 47.125418],
                        [2.048375, 47.106016],
                        [2.051488, 47.040016],
                        [2.093384, 47.015736],
                        [2.070699, 46.933996],
                        [2.126204, 46.879865],
                        [2.04881, 46.829448],
                        [2.115361, 46.774359],
                        [2.065751, 46.742495],
                        [2.140724, 46.695554],
                        [2.185629, 46.602862],
                        [2.1587, 46.557346],
                        [2.204397, 46.4844],
                        [2.151672, 46.45796],
                        [2.167786, 46.424067],
                        [2.281048, 46.420405],
                        [2.285758, 46.453519],
                        [2.352004, 46.512211],
                        [2.482929, 46.532697],
                        [2.536652, 46.5197],
                        [2.614955, 46.55328],
                        [2.596648, 46.63722],
                        [2.704975, 46.739387],
                        [2.774488, 46.718907],
                        [2.827616, 46.735288],
                        [2.959915, 46.803877],
                        [3.032068, 46.794911],
                        [3.068095, 46.877677],
                        [3.050294, 46.91063],
                        [3.07933, 46.955119],
                        [3.075738, 47.019145],
                        [3.023215, 47.062617],
                        [3.028085, 47.129068],
                        [2.981685, 47.221997],
                        [2.983404, 47.259763],
                        [2.873491, 47.348396],
                        [2.928902, 47.444567],
                        [2.874625, 47.520423],
                        [2.806484, 47.494459],
                        [2.768026, 47.523527],
                        [2.719353, 47.492167],
                        [2.658459, 47.487899],
                        [2.599892, 47.553686],
                        [2.491358, 47.568295],
                        [2.437347, 47.609778],
                        [2.373021, 47.585525],
                        [2.286238, 47.628962],
                        [2.239214, 47.620978],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "18", "NOM_DEPT": "CHER"},
        },
        20: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [3.998163, 44.459798],
                        [4.068441, 44.405114],
                        [4.051452, 44.317324],
                        [4.142868, 44.313351],
                        [4.258846, 44.264786],
                        [4.288417, 44.314659],
                        [4.336073, 44.339523],
                        [4.503536, 44.340188],
                        [4.5587, 44.302445],
                        [4.649224, 44.27036],
                        [4.650615, 44.329806],
                        [4.667367, 44.430664],
                        [4.698652, 44.452309],
                        [4.69364, 44.542231],
                        [4.710266, 44.581549],
                        [4.77906, 44.654699],
                        [4.766216, 44.778627],
                        [4.822513, 44.817088],
                        [4.886589, 44.936652],
                        [4.837673, 45.004792],
                        [4.812474, 45.164482],
                        [4.800494, 45.298361],
                        [4.755997, 45.365672],
                        [4.679512, 45.346112],
                        [4.614497, 45.309837],
                        [4.602423, 45.251704],
                        [4.483135, 45.236446],
                        [4.443263, 45.140833],
                        [4.376559, 45.14436],
                        [4.375306, 45.104832],
                        [4.289828, 44.997307],
                        [4.221703, 44.961336],
                        [4.156155, 44.873334],
                        [4.039639, 44.873162],
                        [4.028375, 44.834081],
                        [3.937001, 44.795417],
                        [3.862527, 44.743863],
                        [3.905172, 44.592708],
                        [3.945149, 44.573791],
                        [3.998163, 44.459798],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "07", "NOM_DEPT": "ARDECHE"},
        },
        21: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [4.047973, 49.405642],
                        [4.040712, 49.508535],
                        [4.076571, 49.571127],
                        [4.031391, 49.61429],
                        [4.099316, 49.628478],
                        [4.127022, 49.677921],
                        [4.250089, 49.757102],
                        [4.209589, 49.781781],
                        [4.248507, 49.856523],
                        [4.233068, 49.957824],
                        [4.140895, 49.97876],
                        [4.087129, 49.969188],
                        [3.980376, 49.995376],
                        [3.923501, 50.026431],
                        [3.74638, 50.053604],
                        [3.715185, 50.069275],
                        [3.61364, 50.025419],
                        [3.544846, 50.053794],
                        [3.49136, 50.018856],
                        [3.352982, 50.035859],
                        [3.280174, 50.015183],
                        [3.230541, 50.03131],
                        [3.172707, 50.011995],
                        [3.192675, 49.977465],
                        [3.117969, 49.914276],
                        [3.078694, 49.822415],
                        [3.118403, 49.705969],
                        [3.097776, 49.656683],
                        [3.13148, 49.543378],
                        [3.095778, 49.513403],
                        [3.160583, 49.45159],
                        [3.093783, 49.433747],
                        [3.095387, 49.377119],
                        [2.97439, 49.302339],
                        [3.026888, 49.275532],
                        [3.064088, 49.192739],
                        [3.139658, 49.152577],
                        [3.071884, 49.117554],
                        [3.16523, 49.099651],
                        [3.171684, 49.014123],
                        [3.304749, 48.948764],
                        [3.330299, 48.908706],
                        [3.403219, 48.864687],
                        [3.485187, 48.851908],
                        [3.528576, 48.912141],
                        [3.601598, 48.944072],
                        [3.646307, 49.040588],
                        [3.600005, 49.120692],
                        [3.622247, 49.151104],
                        [3.704392, 49.181373],
                        [3.646953, 49.315154],
                        [3.847477, 49.364587],
                        [3.924434, 49.406182],
                        [4.035496, 49.359904],
                        [4.047973, 49.405642],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "02", "NOM_DEPT": "AISNE"},
        },
        22: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-1.524867, 43.529701],
                        [-1.597385, 43.437493],
                        [-1.63911, 43.408361],
                        [-1.762028, 43.375892],
                        [-1.729746, 43.295677],
                        [-1.665762, 43.314078],
                        [-1.608935, 43.252125],
                        [-1.564716, 43.287912],
                        [-1.505325, 43.292785],
                        [-1.382786, 43.253294],
                        [-1.383829, 43.19082],
                        [-1.413947, 43.129178],
                        [-1.471735, 43.081093],
                        [-1.435185, 43.045033],
                        [-1.354748, 43.028467],
                        [-1.343293, 43.095379],
                        [-1.264286, 43.044567],
                        [-1.231143, 43.054496],
                        [-1.006444, 42.988994],
                        [-0.94645, 42.954061],
                        [-0.810019, 42.951433],
                        [-0.751639, 42.966939],
                        [-0.729762, 42.896559],
                        [-0.543814, 42.793161],
                        [-0.509646, 42.825393],
                        [-0.43975, 42.796462],
                        [-0.392597, 42.799559],
                        [-0.313443, 42.849375],
                        [-0.327082, 42.915782],
                        [-0.281591, 42.933563],
                        [-0.291552, 42.987768],
                        [-0.223952, 43.033688],
                        [-0.190984, 43.1112],
                        [-0.146132, 43.128236],
                        [-0.117701, 43.180327],
                        [-0.017008, 43.270453],
                        [-0.046122, 43.300856],
                        [0.009598, 43.42211],
                        [-0.069031, 43.437349],
                        [-0.040132, 43.512605],
                        [-0.096783, 43.582406],
                        [-0.176413, 43.596404],
                        [-0.242837, 43.584976],
                        [-0.30369, 43.560277],
                        [-0.406042, 43.568226],
                        [-0.448292, 43.596089],
                        [-0.557174, 43.542797],
                        [-0.670807, 43.566717],
                        [-0.715391, 43.541114],
                        [-0.781781, 43.564167],
                        [-0.896691, 43.550489],
                        [-0.993394, 43.505388],
                        [-1.109248, 43.51413],
                        [-1.17082, 43.54561],
                        [-1.291182, 43.498205],
                        [-1.417774, 43.497767],
                        [-1.47662, 43.539184],
                        [-1.524867, 43.529701],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "64", "NOM_DEPT": "PYRENEES-ATLANTIQUES"},
        },
        23: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.239214, 47.620978],
                        [2.202559, 47.678145],
                        [1.942423, 47.675631],
                        [1.843695, 47.686353],
                        [1.798596, 47.638431],
                        [1.739938, 47.661534],
                        [1.697353, 47.738393],
                        [1.547878, 47.769762],
                        [1.533701, 47.820526],
                        [1.588138, 47.876427],
                        [1.525424, 47.929114],
                        [1.520124, 47.982278],
                        [1.308628, 47.953854],
                        [1.209643, 47.968501],
                        [1.121234, 48.039116],
                        [1.112233, 48.080729],
                        [1.008548, 48.083127],
                        [0.99733, 48.127494],
                        [0.841217, 48.103062],
                        [0.797485, 48.037554],
                        [0.845801, 47.941401],
                        [0.759875, 47.898227],
                        [0.774579, 47.839687],
                        [0.71263, 47.790036],
                        [0.580518, 47.712328],
                        [0.614431, 47.694214],
                        [0.735311, 47.695402],
                        [0.859504, 47.669207],
                        [0.919011, 47.632609],
                        [1.033353, 47.607012],
                        [1.076336, 47.563222],
                        [1.045291, 47.531488],
                        [1.132364, 47.446467],
                        [1.107483, 47.411325],
                        [1.122835, 47.354017],
                        [1.108127, 47.298398],
                        [1.162065, 47.272196],
                        [1.223537, 47.294081],
                        [1.276908, 47.254707],
                        [1.326666, 47.186225],
                        [1.448462, 47.237968],
                        [1.592428, 47.276677],
                        [1.705831, 47.265878],
                        [1.839079, 47.219308],
                        [1.90408, 47.215655],
                        [1.940816, 47.290131],
                        [1.997038, 47.265439],
                        [2.138991, 47.285486],
                        [2.101693, 47.386783],
                        [2.238219, 47.472343],
                        [2.195636, 47.548574],
                        [2.127969, 47.584698],
                        [2.239214, 47.620978],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "41", "NOM_DEPT": "LOIR-ET-CHER"},
        },
        24: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [7.07936, 48.536418],
                        [7.16791, 48.527596],
                        [7.256282, 48.588676],
                        [7.283045, 48.638107],
                        [7.242488, 48.691543],
                        [7.311901, 48.767301],
                        [7.149408, 48.844704],
                        [7.126799, 48.801142],
                        [7.054515, 48.813704],
                        [7.045343, 48.871549],
                        [6.964602, 48.904525],
                        [6.989216, 48.959929],
                        [7.054912, 49.030619],
                        [7.107657, 49.044114],
                        [7.17424, 49.006366],
                        [7.293049, 48.973416],
                        [7.326852, 48.943373],
                        [7.446888, 48.965779],
                        [7.538259, 48.932962],
                        [7.578392, 48.957402],
                        [7.635285, 49.054161],
                        [7.539005, 49.092065],
                        [7.439951, 49.180793],
                        [7.365078, 49.171836],
                        [7.298653, 49.117457],
                        [7.247787, 49.127982],
                        [7.066094, 49.114584],
                        [7.010704, 49.188121],
                        [6.935412, 49.222156],
                        [6.835378, 49.211324],
                        [6.834538, 49.151467],
                        [6.738512, 49.163661],
                        [6.688138, 49.224446],
                        [6.669192, 49.280605],
                        [6.565839, 49.34735],
                        [6.587074, 49.384936],
                        [6.552235, 49.423349],
                        [6.430122, 49.476398],
                        [6.391963, 49.464465],
                        [6.296571, 49.480107],
                        [6.256413, 49.510023],
                        [6.156887, 49.50439],
                        [6.123494, 49.473756],
                        [5.988988, 49.453334],
                        [5.97177, 49.491317],
                        [5.893401, 49.49691],
                        [5.94262, 49.452896],
                        [5.928531, 49.375507],
                        [6.029385, 49.230472],
                        [5.987627, 49.209617],
                        [6.02615, 49.165119],
                        [5.931603, 49.109104],
                        [5.9354, 49.071852],
                        [6.044997, 49.010419],
                        [6.043435, 48.977478],
                        [6.116899, 48.967833],
                        [6.132207, 48.934721],
                        [6.271978, 48.933136],
                        [6.338947, 48.834058],
                        [6.35503, 48.781659],
                        [6.554149, 48.754093],
                        [6.598966, 48.715691],
                        [6.658407, 48.708047],
                        [6.692284, 48.67284],
                        [6.754673, 48.669387],
                        [6.844054, 48.625975],
                        [6.982882, 48.611863],
                        [7.07936, 48.536418],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "57", "NOM_DEPT": "MOSELLE"},
        },
        25: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.197354, 46.09555],
                        [0.279806, 46.060966],
                        [0.402656, 46.062676],
                        [0.506417, 46.131954],
                        [0.539973, 46.085558],
                        [0.687453, 46.097255],
                        [0.746905, 46.138575],
                        [0.823434, 46.128582],
                        [0.796326, 46.210963],
                        [0.907272, 46.285257],
                        [1.005887, 46.280974],
                        [1.026995, 46.343034],
                        [1.129758, 46.360466],
                        [1.17728, 46.383952],
                        [1.21269, 46.432222],
                        [1.151605, 46.449236],
                        [1.145935, 46.506402],
                        [1.014764, 46.567764],
                        [0.942024, 46.580792],
                        [0.894302, 46.625737],
                        [0.924756, 46.692793],
                        [0.867469, 46.748219],
                        [0.811902, 46.794508],
                        [0.790328, 46.852391],
                        [0.704324, 46.903293],
                        [0.692569, 46.974307],
                        [0.566949, 47.00227],
                        [0.598348, 46.956764],
                        [0.506141, 46.959247],
                        [0.43871, 46.929582],
                        [0.300736, 46.973828],
                        [0.298231, 47.053919],
                        [0.174221, 47.071275],
                        [0.136131, 47.121581],
                        [0.076371, 47.123932],
                        [0.053828, 47.16373],
                        [-0.010737, 47.15751],
                        [-0.044165, 47.093243],
                        [-0.102121, 47.064797],
                        [-0.087696, 47.023133],
                        [-0.009032, 46.907477],
                        [-0.020316, 46.812654],
                        [0.000704, 46.716233],
                        [-0.040426, 46.663717],
                        [0.02599, 46.594744],
                        [-0.031351, 46.524981],
                        [-0.017093, 46.411322],
                        [0.03422, 46.373497],
                        [0.037602, 46.325529],
                        [0.078218, 46.304934],
                        [0.137598, 46.349395],
                        [0.177369, 46.328113],
                        [0.128837, 46.267232],
                        [0.112837, 46.210933],
                        [0.155111, 46.157168],
                        [0.214922, 46.138846],
                        [0.197354, 46.09555],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "86", "NOM_DEPT": "VIENNE"},
        },
        26: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.629742, 45.71457],
                        [0.600693, 45.672144],
                        [0.499647, 45.617259],
                        [0.49626, 45.544488],
                        [0.356537, 45.465479],
                        [0.307849, 45.46087],
                        [0.24933, 45.363043],
                        [0.266609, 45.297749],
                        [0.127724, 45.209112],
                        [0.05343, 45.226855],
                        [0.004331, 45.191633],
                        [-0.0402, 45.102384],
                        [0.04606, 45.113228],
                        [0.073297, 45.070121],
                        [0.007379, 44.947299],
                        [0.034362, 44.915469],
                        [-0.015448, 44.857717],
                        [0.083023, 44.831221],
                        [0.170434, 44.826684],
                        [0.241753, 44.856894],
                        [0.297326, 44.762285],
                        [0.335449, 44.737436],
                        [0.365575, 44.662211],
                        [0.414707, 44.646337],
                        [0.630488, 44.706528],
                        [0.657434, 44.677847],
                        [0.827001, 44.69189],
                        [0.817004, 44.627001],
                        [0.869996, 44.597307],
                        [0.979128, 44.64361],
                        [1.075141, 44.577325],
                        [1.153794, 44.639406],
                        [1.146672, 44.670346],
                        [1.22455, 44.684266],
                        [1.287782, 44.714781],
                        [1.364103, 44.811568],
                        [1.361404, 44.840795],
                        [1.44192, 44.877579],
                        [1.413299, 44.999386],
                        [1.448262, 45.019313],
                        [1.386442, 45.102881],
                        [1.296518, 45.140189],
                        [1.277496, 45.242082],
                        [1.227119, 45.27198],
                        [1.322797, 45.382659],
                        [1.259604, 45.398349],
                        [1.253152, 45.444219],
                        [1.119784, 45.487783],
                        [1.035849, 45.600209],
                        [0.934552, 45.611582],
                        [0.8115, 45.575871],
                        [0.75153, 45.618324],
                        [0.775843, 45.66757],
                        [0.629742, 45.71457],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "24", "NOM_DEPT": "DORDOGNE"},
        },
        27: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.310561, 46.446766],
                        [5.307691, 46.416817],
                        [5.377045, 46.381359],
                        [5.373462, 46.352236],
                        [5.437795, 46.315113],
                        [5.473055, 46.265064],
                        [5.542038, 46.270202],
                        [5.649339, 46.339491],
                        [5.714718, 46.308769],
                        [5.725183, 46.260729],
                        [5.849846, 46.262064],
                        [5.908938, 46.283952],
                        [5.986841, 46.364873],
                        [6.064008, 46.416227],
                        [6.073927, 46.463946],
                        [6.156436, 46.545468],
                        [6.138109, 46.55766],
                        [6.048567, 46.607723],
                        [6.103767, 46.649818],
                        [6.069828, 46.689525],
                        [6.180271, 46.741575],
                        [6.20333, 46.772681],
                        [6.151794, 46.820667],
                        [6.005778, 46.873053],
                        [5.964072, 46.948079],
                        [5.96856, 46.980444],
                        [5.815051, 47.020339],
                        [5.768549, 47.089435],
                        [5.816084, 47.134339],
                        [5.811467, 47.169054],
                        [5.720409, 47.219937],
                        [5.698726, 47.264997],
                        [5.60211, 47.260531],
                        [5.518539, 47.304187],
                        [5.488283, 47.289347],
                        [5.476629, 47.216028],
                        [5.439973, 47.144397],
                        [5.386012, 47.081977],
                        [5.322186, 47.072982],
                        [5.31005, 47.018021],
                        [5.255236, 46.979888],
                        [5.263265, 46.935911],
                        [5.316959, 46.904056],
                        [5.459286, 46.855245],
                        [5.370245, 46.826171],
                        [5.391089, 46.728696],
                        [5.441108, 46.63754],
                        [5.359191, 46.522561],
                        [5.415742, 46.473139],
                        [5.310561, 46.446766],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "39", "NOM_DEPT": "JURA"},
        },
        28: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.882083, 44.340065],
                        [1.699503, 44.313814],
                        [1.651621, 44.286806],
                        [1.569138, 44.298394],
                        [1.520539, 44.26327],
                        [1.380368, 44.224858],
                        [1.281379, 44.235786],
                        [1.107939, 44.327403],
                        [1.064084, 44.378513],
                        [1.049803, 44.362639],
                        [0.887331, 44.366375],
                        [0.87347, 44.323308],
                        [0.949924, 44.276442],
                        [0.91909, 44.23827],
                        [0.868774, 44.12633],
                        [0.752884, 44.10227],
                        [0.741885, 44.065199],
                        [0.775783, 44.035911],
                        [0.860417, 44.040785],
                        [0.760085, 43.942242],
                        [0.862892, 43.923289],
                        [0.899439, 43.864698],
                        [0.906156, 43.784331],
                        [0.953983, 43.787372],
                        [1.144598, 43.822298],
                        [1.219193, 43.770778],
                        [1.36089, 43.821074],
                        [1.356813, 43.884192],
                        [1.447877, 43.873553],
                        [1.555617, 43.918317],
                        [1.552291, 43.963027],
                        [1.618572, 43.974002],
                        [1.69139, 44.024341],
                        [1.658959, 44.116412],
                        [1.74554, 44.116267],
                        [1.77752, 44.096816],
                        [1.841704, 44.143691],
                        [1.919692, 44.16294],
                        [1.990171, 44.149453],
                        [1.976683, 44.179924],
                        [1.902199, 44.204327],
                        [1.970444, 44.276436],
                        [1.901391, 44.279116],
                        [1.882083, 44.340065],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "82", "NOM_DEPT": "TARN-ET-GARONNE"},
        },
        29: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-0.89196, 46.975818],
                        [-0.773877, 47.004252],
                        [-0.713058, 46.986072],
                        [-0.619977, 46.993322],
                        [-0.565468, 47.019426],
                        [-0.559532, 47.061887],
                        [-0.49534, 47.082385],
                        [-0.40078, 47.070771],
                        [-0.241538, 47.105725],
                        [-0.18484, 47.108337],
                        [-0.102121, 47.064797],
                        [-0.044165, 47.093243],
                        [-0.010737, 47.15751],
                        [0.053828, 47.16373],
                        [0.078975, 47.282825],
                        [0.18528, 47.424733],
                        [0.220109, 47.501953],
                        [0.201503, 47.544328],
                        [0.230002, 47.608398],
                        [0.151604, 47.581535],
                        [0.051659, 47.606515],
                        [-0.004508, 47.647688],
                        [-0.071831, 47.658007],
                        [-0.135037, 47.63252],
                        [-0.193157, 47.647917],
                        [-0.23306, 47.707562],
                        [-0.334077, 47.721166],
                        [-0.381703, 47.760563],
                        [-0.460412, 47.765091],
                        [-0.610818, 47.735689],
                        [-0.741708, 47.738107],
                        [-0.839294, 47.752273],
                        [-0.95203, 47.796497],
                        [-0.978657, 47.761991],
                        [-1.099916, 47.781967],
                        [-1.142627, 47.774442],
                        [-1.238252, 47.809991],
                        [-1.245882, 47.776718],
                        [-1.254577, 47.733642],
                        [-1.17493, 47.694565],
                        [-1.138202, 47.619457],
                        [-1.006864, 47.589053],
                        [-1.04591, 47.563352],
                        [-1.172416, 47.573008],
                        [-1.157233, 47.510083],
                        [-0.967483, 47.4928],
                        [-0.946443, 47.386467],
                        [-1.017874, 47.365062],
                        [-1.16761, 47.365887],
                        [-1.299877, 47.337624],
                        [-1.305109, 47.30317],
                        [-1.254175, 47.249856],
                        [-1.197722, 47.250581],
                        [-1.163216, 47.177784],
                        [-1.235248, 47.138782],
                        [-1.231146, 47.109955],
                        [-1.115463, 47.062565],
                        [-1.14857, 47.029545],
                        [-1.055403, 47.005685],
                        [-0.93346, 47.008908],
                        [-0.89196, 46.975818],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "49", "NOM_DEPT": "MAINE-ET-LOIRE"},
        },
        30: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.101067, 45.813378],
                        [4.923799, 45.803999],
                        [4.864502, 45.904617],
                        [4.729097, 45.949092],
                        [4.754631, 45.973622],
                        [4.73953, 46.047209],
                        [4.750325, 46.09415],
                        [4.797433, 46.140701],
                        [4.780213, 46.176677],
                        [4.73053, 46.178372],
                        [4.693107, 46.302195],
                        [4.618552, 46.264793],
                        [4.503988, 46.26713],
                        [4.405814, 46.296061],
                        [4.38808, 46.219789],
                        [4.438591, 46.167879],
                        [4.321567, 46.129223],
                        [4.28041, 46.052944],
                        [4.306096, 46.021229],
                        [4.293912, 45.9534],
                        [4.323926, 45.900501],
                        [4.383032, 45.863994],
                        [4.391252, 45.754935],
                        [4.365516, 45.698519],
                        [4.410284, 45.632051],
                        [4.519766, 45.573255],
                        [4.614858, 45.575468],
                        [4.661742, 45.486754],
                        [4.722337, 45.494298],
                        [4.756936, 45.455707],
                        [4.868482, 45.52344],
                        [4.808697, 45.572301],
                        [4.901458, 45.606268],
                        [5.035149, 45.637203],
                        [5.131048, 45.707709],
                        [5.094527, 45.739453],
                        [5.101067, 45.813378],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "69", "NOM_DEPT": "RHONE"},
        },
        31: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.713938, 49.409225],
                        [1.659303, 49.398986],
                        [1.575423, 49.440144],
                        [1.412122, 49.456496],
                        [1.345233, 49.448059],
                        [1.272137, 49.346289],
                        [1.160256, 49.341994],
                        [1.133994, 49.309842],
                        [1.048149, 49.297883],
                        [1.013317, 49.252263],
                        [0.921402, 49.338553],
                        [0.918119, 49.385461],
                        [0.764866, 49.419583],
                        [0.665291, 49.402002],
                        [0.581889, 49.433636],
                        [0.52494, 49.477869],
                        [0.338983, 49.440931],
                        [0.297224, 49.429862],
                        [0.323023, 49.296993],
                        [0.382787, 49.264016],
                        [0.394688, 49.150117],
                        [0.424875, 49.130194],
                        [0.37768, 49.04945],
                        [0.436751, 49.00819],
                        [0.412815, 48.950626],
                        [0.386189, 48.910415],
                        [0.457358, 48.879762],
                        [0.552503, 48.875538],
                        [0.610294, 48.831314],
                        [0.733506, 48.783364],
                        [0.774959, 48.737527],
                        [0.730589, 48.705208],
                        [0.814819, 48.670168],
                        [0.876707, 48.715492],
                        [1.031657, 48.730583],
                        [1.184731, 48.77263],
                        [1.319548, 48.760965],
                        [1.376964, 48.791769],
                        [1.362181, 48.834179],
                        [1.46835, 48.892217],
                        [1.501524, 48.941054],
                        [1.457763, 49.026291],
                        [1.521766, 49.068546],
                        [1.608796, 49.077894],
                        [1.655777, 49.130162],
                        [1.675737, 49.211867],
                        [1.704364, 49.232202],
                        [1.710479, 49.264464],
                        [1.775629, 49.299694],
                        [1.759412, 49.36815],
                        [1.713938, 49.409225],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "27", "NOM_DEPT": "EURE"},
        },
        32: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.990171, 44.149453],
                        [2.106129, 44.194395],
                        [2.152471, 44.197715],
                        [2.389214, 44.093491],
                        [2.41021, 44.055849],
                        [2.459937, 44.051398],
                        [2.522934, 43.981282],
                        [2.499347, 43.950586],
                        [2.554997, 43.92138],
                        [2.564163, 43.841331],
                        [2.681306, 43.743964],
                        [2.742838, 43.729045],
                        [2.813674, 43.761719],
                        [2.921107, 43.736114],
                        [2.935463, 43.694668],
                        [2.98535, 43.708516],
                        [3.060741, 43.693077],
                        [3.059856, 43.831647],
                        [3.203112, 43.813873],
                        [3.275075, 43.898352],
                        [3.358359, 43.913833],
                        [3.450755, 44.020787],
                        [3.32891, 44.07903],
                        [3.33606, 44.158672],
                        [3.373648, 44.170756],
                        [3.3578, 44.19791],
                        [3.229848, 44.226255],
                        [3.125229, 44.284464],
                        [3.154252, 44.30837],
                        [3.119711, 44.383378],
                        [3.135736, 44.45487],
                        [3.068543, 44.50349],
                        [3.083594, 44.559014],
                        [2.981677, 44.644677],
                        [2.923264, 44.728639],
                        [2.934522, 44.779198],
                        [2.879572, 44.803011],
                        [2.849658, 44.871489],
                        [2.801955, 44.873629],
                        [2.738254, 44.941222],
                        [2.706435, 44.907226],
                        [2.602681, 44.843168],
                        [2.599358, 44.792809],
                        [2.562709, 44.775753],
                        [2.556124, 44.721285],
                        [2.435003, 44.638878],
                        [2.326786, 44.669692],
                        [2.208414, 44.643844],
                        [2.207475, 44.615532],
                        [2.153817, 44.571901],
                        [2.057369, 44.582906],
                        [1.931468, 44.506394],
                        [1.8396, 44.4759],
                        [1.882083, 44.340065],
                        [1.901391, 44.279116],
                        [1.970444, 44.276436],
                        [1.902199, 44.204327],
                        [1.976683, 44.179924],
                        [1.990171, 44.149453],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "12", "NOM_DEPT": "AVEYRON"},
        },
        33: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.167786, 46.424067],
                        [2.088942, 46.408903],
                        [1.993082, 46.430917],
                        [1.8195, 46.430038],
                        [1.727711, 46.388959],
                        [1.644846, 46.386816],
                        [1.522307, 46.426525],
                        [1.415191, 46.347218],
                        [1.44377, 46.305894],
                        [1.3749, 46.215451],
                        [1.452795, 46.179755],
                        [1.549176, 46.03541],
                        [1.5325, 45.952804],
                        [1.60872, 45.933412],
                        [1.602398, 45.857465],
                        [1.676637, 45.835114],
                        [1.772749, 45.842828],
                        [1.880899, 45.797715],
                        [1.87514, 45.73278],
                        [1.898731, 45.698278],
                        [2.017609, 45.75549],
                        [2.113545, 45.724775],
                        [2.174353, 45.732216],
                        [2.193958, 45.699047],
                        [2.337755, 45.680605],
                        [2.349183, 45.709479],
                        [2.435856, 45.699275],
                        [2.492126, 45.73767],
                        [2.434119, 45.769857],
                        [2.38802, 45.827376],
                        [2.442585, 45.863013],
                        [2.492225, 45.86403],
                        [2.594419, 45.989442],
                        [2.549048, 46.114071],
                        [2.565379, 46.143032],
                        [2.516311, 46.23944],
                        [2.478941, 46.281148],
                        [2.391861, 46.329982],
                        [2.323024, 46.329279],
                        [2.281048, 46.420405],
                        [2.167786, 46.424067],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "23", "NOM_DEPT": "CREUSE"},
        },
        34: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.936314, 48.163392],
                        [2.798945, 48.168277],
                        [2.706547, 48.124819],
                        [2.538109, 48.140648],
                        [2.506192, 48.238536],
                        [2.423764, 48.260297],
                        [2.402664, 48.320719],
                        [2.369811, 48.308672],
                        [2.18135, 48.313745],
                        [1.994085, 48.286586],
                        [1.965479, 48.255466],
                        [1.865671, 48.083857],
                        [1.744834, 48.066144],
                        [1.624593, 48.067223],
                        [1.594116, 48.0307],
                        [1.512976, 48.028722],
                        [1.520124, 47.982278],
                        [1.525424, 47.929114],
                        [1.588138, 47.876427],
                        [1.533701, 47.820526],
                        [1.547878, 47.769762],
                        [1.697353, 47.738393],
                        [1.739938, 47.661534],
                        [1.798596, 47.638431],
                        [1.843695, 47.686353],
                        [1.942423, 47.675631],
                        [2.202559, 47.678145],
                        [2.239214, 47.620978],
                        [2.286238, 47.628962],
                        [2.373021, 47.585525],
                        [2.437347, 47.609778],
                        [2.491358, 47.568295],
                        [2.599892, 47.553686],
                        [2.658459, 47.487899],
                        [2.719353, 47.492167],
                        [2.768026, 47.523527],
                        [2.806484, 47.494459],
                        [2.874625, 47.520423],
                        [2.914297, 47.56597],
                        [2.976538, 47.569429],
                        [2.937999, 47.598885],
                        [2.92311, 47.68056],
                        [2.858518, 47.711993],
                        [2.856666, 47.760926],
                        [2.935058, 47.763246],
                        [3.023798, 47.786555],
                        [3.010293, 47.904717],
                        [3.050104, 47.911447],
                        [3.12845, 47.970973],
                        [3.088318, 48.053936],
                        [3.050471, 48.072334],
                        [3.029465, 48.133207],
                        [2.936314, 48.163392],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "45", "NOM_DEPT": "LOIRET"},
        },
        35: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [6.823539, 47.813054],
                        [6.784822, 47.849623],
                        [6.645533, 47.904021],
                        [6.601782, 47.944399],
                        [6.542153, 47.902611],
                        [6.478602, 47.885522],
                        [6.431707, 47.943816],
                        [6.366146, 47.961945],
                        [6.237987, 47.932842],
                        [6.167985, 47.95235],
                        [6.156058, 48.006944],
                        [6.072564, 48.015666],
                        [6.002262, 47.95609],
                        [5.947521, 47.97971],
                        [5.884726, 47.926047],
                        [5.821435, 47.868176],
                        [5.761191, 47.859334],
                        [5.690283, 47.818604],
                        [5.676612, 47.779158],
                        [5.709213, 47.744817],
                        [5.690066, 47.684839],
                        [5.596682, 47.671686],
                        [5.482568, 47.684603],
                        [5.406343, 47.673401],
                        [5.374079, 47.604542],
                        [5.425863, 47.632114],
                        [5.477547, 47.608722],
                        [5.496859, 47.544145],
                        [5.447064, 47.496254],
                        [5.399202, 47.499014],
                        [5.451398, 47.384063],
                        [5.518539, 47.304187],
                        [5.60211, 47.260531],
                        [5.698726, 47.264997],
                        [5.941375, 47.344254],
                        [5.989355, 47.327623],
                        [6.080046, 47.354036],
                        [6.262329, 47.43057],
                        [6.334354, 47.505966],
                        [6.401377, 47.5203],
                        [6.553563, 47.492797],
                        [6.581776, 47.53987],
                        [6.646719, 47.535261],
                        [6.685554, 47.562956],
                        [6.780972, 47.536415],
                        [6.806992, 47.562802],
                        [6.780405, 47.625261],
                        [6.757638, 47.747878],
                        [6.823539, 47.813054],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "70", "NOM_DEPT": "HAUTE-SAONE"},
        },
        36: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [3.694018, 45.930732],
                        [3.58847, 46.024138],
                        [3.463503, 46.017937],
                        [3.41903, 46.074292],
                        [3.371596, 46.055061],
                        [3.166532, 46.065678],
                        [2.971757, 46.12178],
                        [2.909593, 46.203494],
                        [2.937146, 46.242917],
                        [2.855725, 46.255486],
                        [2.810275, 46.196213],
                        [2.733052, 46.223324],
                        [2.640691, 46.118478],
                        [2.565379, 46.143032],
                        [2.549048, 46.114071],
                        [2.594419, 45.989442],
                        [2.492225, 45.86403],
                        [2.442585, 45.863013],
                        [2.38802, 45.827376],
                        [2.434119, 45.769857],
                        [2.492126, 45.73767],
                        [2.528365, 45.681924],
                        [2.514297, 45.639532],
                        [2.46535, 45.600823],
                        [2.516332, 45.553427],
                        [2.508409, 45.478499],
                        [2.65143, 45.442655],
                        [2.714857, 45.381558],
                        [2.852379, 45.392341],
                        [2.921556, 45.365775],
                        [2.948625, 45.309126],
                        [3.01671, 45.287121],
                        [3.103498, 45.354373],
                        [3.168063, 45.35226],
                        [3.290692, 45.401822],
                        [3.456747, 45.400287],
                        [3.501321, 45.427579],
                        [3.625847, 45.338346],
                        [3.667209, 45.376197],
                        [3.772255, 45.349192],
                        [3.80831, 45.391612],
                        [3.897408, 45.357084],
                        [3.899188, 45.410308],
                        [3.975106, 45.44827],
                        [3.954348, 45.555963],
                        [3.903596, 45.599022],
                        [3.823453, 45.632417],
                        [3.78085, 45.724349],
                        [3.699758, 45.783182],
                        [3.754371, 45.886031],
                        [3.694018, 45.930732],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "63", "NOM_DEPT": "PUY-DE-DOME"},
        },
        37: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.555617, 43.918317],
                        [1.555463, 43.868315],
                        [1.591029, 43.815488],
                        [1.644788, 43.800257],
                        [1.660421, 43.741834],
                        [1.706446, 43.71622],
                        [1.730869, 43.65775],
                        [1.687771, 43.6307],
                        [1.824801, 43.580832],
                        [1.882609, 43.520929],
                        [2.018141, 43.47035],
                        [2.029133, 43.436898],
                        [2.072801, 43.395687],
                        [2.224168, 43.431767],
                        [2.2591, 43.45993],
                        [2.40363, 43.418671],
                        [2.433102, 43.435176],
                        [2.565787, 43.42296],
                        [2.606081, 43.431094],
                        [2.65954, 43.480164],
                        [2.658651, 43.525794],
                        [2.615607, 43.566633],
                        [2.643264, 43.650146],
                        [2.711169, 43.645597],
                        [2.754524, 43.614139],
                        [2.915982, 43.660021],
                        [2.935463, 43.694668],
                        [2.921107, 43.736114],
                        [2.813674, 43.761719],
                        [2.742838, 43.729045],
                        [2.681306, 43.743964],
                        [2.564163, 43.841331],
                        [2.554997, 43.92138],
                        [2.499347, 43.950586],
                        [2.522934, 43.981282],
                        [2.459937, 44.051398],
                        [2.41021, 44.055849],
                        [2.389214, 44.093491],
                        [2.152471, 44.197715],
                        [2.106129, 44.194395],
                        [1.990171, 44.149453],
                        [1.919692, 44.16294],
                        [1.841704, 44.143691],
                        [1.77752, 44.096816],
                        [1.74554, 44.116267],
                        [1.658959, 44.116412],
                        [1.69139, 44.024341],
                        [1.618572, 43.974002],
                        [1.552291, 43.963027],
                        [1.555617, 43.918317],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "81", "NOM_DEPT": "TARN"},
        },
        38: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.783837, 49.758308],
                        [1.727056, 49.828884],
                        [1.678451, 49.918134],
                        [1.456462, 50.037833],
                        [1.379705, 50.065015],
                        [1.194382, 49.968038],
                        [1.065902, 49.925614],
                        [0.963187, 49.919858],
                        [0.769729, 49.872096],
                        [0.57294, 49.849721],
                        [0.320559, 49.741547],
                        [0.211663, 49.714469],
                        [0.154535, 49.648642],
                        [0.065607, 49.512571],
                        [0.121245, 49.463191],
                        [0.338983, 49.440931],
                        [0.52494, 49.477869],
                        [0.581889, 49.433636],
                        [0.665291, 49.402002],
                        [0.764866, 49.419583],
                        [0.918119, 49.385461],
                        [0.921402, 49.338553],
                        [1.013317, 49.252263],
                        [1.048149, 49.297883],
                        [1.133994, 49.309842],
                        [1.160256, 49.341994],
                        [1.272137, 49.346289],
                        [1.345233, 49.448059],
                        [1.412122, 49.456496],
                        [1.575423, 49.440144],
                        [1.659303, 49.398986],
                        [1.713938, 49.409225],
                        [1.766345, 49.46615],
                        [1.719233, 49.508223],
                        [1.745133, 49.531738],
                        [1.704582, 49.605399],
                        [1.725205, 49.672634],
                        [1.689576, 49.694786],
                        [1.783837, 49.758308],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "76", "NOM_DEPT": "SEINE-MARITIME"},
        },
        39: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [4.670183, 48.531887],
                        [4.653455, 48.470549],
                        [4.716096, 48.394855],
                        [4.809738, 48.34736],
                        [4.85892, 48.263638],
                        [4.8501, 48.141759],
                        [4.819307, 48.103192],
                        [4.73061, 48.118209],
                        [4.688819, 48.073128],
                        [4.704238, 48.020232],
                        [4.789084, 48.007829],
                        [4.786513, 47.964202],
                        [4.852043, 47.956239],
                        [4.954094, 47.866768],
                        [4.982401, 47.800347],
                        [4.94961, 47.765003],
                        [4.979107, 47.687763],
                        [5.108878, 47.649685],
                        [5.173597, 47.652569],
                        [5.239232, 47.61613],
                        [5.374079, 47.604542],
                        [5.406343, 47.673401],
                        [5.482568, 47.684603],
                        [5.596682, 47.671686],
                        [5.690066, 47.684839],
                        [5.709213, 47.744817],
                        [5.676612, 47.779158],
                        [5.690283, 47.818604],
                        [5.761191, 47.859334],
                        [5.821435, 47.868176],
                        [5.884726, 47.926047],
                        [5.850004, 47.962835],
                        [5.787281, 47.952597],
                        [5.777748, 48.031362],
                        [5.696799, 48.07723],
                        [5.630534, 48.083986],
                        [5.684319, 48.145042],
                        [5.710844, 48.219928],
                        [5.640901, 48.242354],
                        [5.482149, 48.356201],
                        [5.408721, 48.3831],
                        [5.470048, 48.420929],
                        [5.34947, 48.481989],
                        [5.208426, 48.538611],
                        [5.118346, 48.595511],
                        [5.070888, 48.595725],
                        [5.005926, 48.634036],
                        [4.988428, 48.684419],
                        [4.911268, 48.688712],
                        [4.841961, 48.649667],
                        [4.849256, 48.623633],
                        [4.769196, 48.588688],
                        [4.79918, 48.52978],
                        [4.670183, 48.531887],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "52", "NOM_DEPT": "HAUTE-MARNE"},
        },
        40: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [4.649224, 44.27036],
                        [4.5587, 44.302445],
                        [4.503536, 44.340188],
                        [4.336073, 44.339523],
                        [4.288417, 44.314659],
                        [4.258846, 44.264786],
                        [4.142868, 44.313351],
                        [4.051452, 44.317324],
                        [4.068441, 44.405114],
                        [3.998163, 44.459798],
                        [3.944362, 44.399568],
                        [3.885918, 44.387999],
                        [3.952331, 44.32839],
                        [3.922859, 44.305218],
                        [3.951317, 44.247795],
                        [3.952604, 44.170794],
                        [3.862105, 44.130074],
                        [3.796995, 44.127389],
                        [3.678641, 44.182759],
                        [3.637769, 44.175488],
                        [3.633491, 44.122695],
                        [3.43973, 44.129098],
                        [3.373648, 44.170756],
                        [3.33606, 44.158672],
                        [3.32891, 44.07903],
                        [3.450755, 44.020787],
                        [3.358359, 43.913833],
                        [3.424448, 43.911598],
                        [3.530701, 43.855625],
                        [3.575448, 43.865522],
                        [3.623589, 43.916979],
                        [3.72699, 43.969016],
                        [3.787325, 43.96687],
                        [3.824905, 43.919298],
                        [3.830797, 43.866424],
                        [3.917385, 43.885593],
                        [4.002046, 43.811464],
                        [4.144781, 43.733887],
                        [4.194441, 43.654304],
                        [4.150216, 43.585562],
                        [4.101042, 43.554371],
                        [4.139123, 43.531896],
                        [4.137664, 43.481946],
                        [4.230283, 43.460185],
                        [4.238106, 43.497627],
                        [4.40935, 43.561128],
                        [4.427028, 43.620678],
                        [4.487237, 43.699238],
                        [4.593032, 43.687462],
                        [4.654821, 43.806409],
                        [4.64191, 43.867478],
                        [4.739061, 43.924059],
                        [4.842094, 43.986475],
                        [4.787978, 44.065054],
                        [4.707458, 44.103672],
                        [4.722075, 44.187422],
                        [4.649224, 44.27036],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "30", "NOM_DEPT": "GARD"},
        },
        41: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [7.198282, 48.310468],
                        [7.275184, 48.305235],
                        [7.348563, 48.247195],
                        [7.476943, 48.203537],
                        [7.470561, 48.161015],
                        [7.519369, 48.126112],
                        [7.577313, 48.120369],
                        [7.667803, 48.223911],
                        [7.70314, 48.308812],
                        [7.739881, 48.321748],
                        [7.735976, 48.404158],
                        [7.768185, 48.489658],
                        [7.805196, 48.513571],
                        [7.80417, 48.592335],
                        [7.839817, 48.641374],
                        [7.96314, 48.721353],
                        [7.971745, 48.757628],
                        [8.096321, 48.810384],
                        [8.147938, 48.903808],
                        [8.214338, 48.975093],
                        [8.091376, 48.989258],
                        [7.934627, 49.057809],
                        [7.868786, 49.034157],
                        [7.800437, 49.064117],
                        [7.73223, 49.04436],
                        [7.635285, 49.054161],
                        [7.578392, 48.957402],
                        [7.538259, 48.932962],
                        [7.446888, 48.965779],
                        [7.326852, 48.943373],
                        [7.293049, 48.973416],
                        [7.17424, 49.006366],
                        [7.107657, 49.044114],
                        [7.054912, 49.030619],
                        [6.989216, 48.959929],
                        [6.964602, 48.904525],
                        [7.045343, 48.871549],
                        [7.054515, 48.813704],
                        [7.126799, 48.801142],
                        [7.149408, 48.844704],
                        [7.311901, 48.767301],
                        [7.242488, 48.691543],
                        [7.283045, 48.638107],
                        [7.256282, 48.588676],
                        [7.16791, 48.527596],
                        [7.07936, 48.536418],
                        [7.123165, 48.513592],
                        [7.097427, 48.405645],
                        [7.121908, 48.33329],
                        [7.198282, 48.310468],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "67", "NOM_DEPT": "BAS-RHIN"},
        },
        42: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [3.240561, 43.212809],
                        [3.201027, 43.249167],
                        [3.147208, 43.247005],
                        [3.004741, 43.288538],
                        [3.004349, 43.320131],
                        [2.832762, 43.322413],
                        [2.772248, 43.257786],
                        [2.601603, 43.298707],
                        [2.539962, 43.346222],
                        [2.565787, 43.42296],
                        [2.433102, 43.435176],
                        [2.40363, 43.418671],
                        [2.2591, 43.45993],
                        [2.224168, 43.431767],
                        [2.072801, 43.395687],
                        [2.029133, 43.436898],
                        [1.910101, 43.404059],
                        [1.858743, 43.443821],
                        [1.804085, 43.391685],
                        [1.813424, 43.341404],
                        [1.747733, 43.34374],
                        [1.68842, 43.273554],
                        [1.723844, 43.224524],
                        [1.710056, 43.189698],
                        [1.824772, 43.145814],
                        [1.949476, 43.119494],
                        [1.941133, 43.052715],
                        [1.9851, 43.026272],
                        [1.986921, 42.871012],
                        [1.880474, 42.852669],
                        [1.90818, 42.767667],
                        [1.955396, 42.736701],
                        [2.057204, 42.756223],
                        [2.175874, 42.682795],
                        [2.166054, 42.663918],
                        [2.322006, 42.707792],
                        [2.357535, 42.734122],
                        [2.327116, 42.837443],
                        [2.452475, 42.836933],
                        [2.509012, 42.849832],
                        [2.697578, 42.830431],
                        [2.74, 42.837574],
                        [2.789054, 42.895989],
                        [2.865274, 42.918341],
                        [2.917115, 42.88486],
                        [3.043499, 42.83815],
                        [3.060589, 42.91706],
                        [3.042843, 42.960154],
                        [3.117221, 43.101839],
                        [3.240561, 43.212809],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "11", "NOM_DEPT": "AUDE"},
        },
        43: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.936314, 48.163392],
                        [3.005156, 48.20767],
                        [3.043627, 48.272022],
                        [3.049519, 48.36012],
                        [3.167738, 48.371861],
                        [3.365159, 48.372281],
                        [3.414792, 48.390273],
                        [3.39196, 48.424322],
                        [3.423442, 48.533563],
                        [3.503854, 48.604809],
                        [3.555614, 48.620285],
                        [3.460426, 48.65301],
                        [3.476964, 48.699358],
                        [3.435809, 48.753572],
                        [3.485187, 48.851908],
                        [3.403219, 48.864687],
                        [3.330299, 48.908706],
                        [3.304749, 48.948764],
                        [3.171684, 49.014123],
                        [3.16523, 49.099651],
                        [3.071884, 49.117554],
                        [3.008516, 49.09151],
                        [2.735013, 49.06045],
                        [2.633273, 49.108376],
                        [2.590524, 49.079655],
                        [2.553061, 49.009817],
                        [2.602598, 48.929357],
                        [2.562622, 48.888884],
                        [2.59228, 48.807437],
                        [2.613648, 48.761027],
                        [2.57166, 48.692014],
                        [2.533616, 48.657331],
                        [2.543777, 48.60385],
                        [2.499525, 48.525239],
                        [2.50475, 48.439446],
                        [2.533732, 48.411251],
                        [2.429832, 48.362016],
                        [2.402664, 48.320719],
                        [2.423764, 48.260297],
                        [2.506192, 48.238536],
                        [2.538109, 48.140648],
                        [2.706547, 48.124819],
                        [2.798945, 48.168277],
                        [2.936314, 48.163392],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "77", "NOM_DEPT": "SEINE-ET-MARNE"},
        },
        44: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [3.090254, 50.053741],
                        [2.876533, 50.042179],
                        [2.857844, 50.077393],
                        [2.57602, 50.113413],
                        [2.55133, 50.141605],
                        [2.476687, 50.136999],
                        [2.414508, 50.100642],
                        [2.389777, 50.155485],
                        [2.49569, 50.194562],
                        [2.451785, 50.230302],
                        [2.370205, 50.20977],
                        [2.273828, 50.22684],
                        [2.095748, 50.205545],
                        [2.07782, 50.248821],
                        [1.946132, 50.287428],
                        [1.918001, 50.311779],
                        [1.778784, 50.361866],
                        [1.670716, 50.33101],
                        [1.641544, 50.352153],
                        [1.550936, 50.350323],
                        [1.537948, 50.282668],
                        [1.590267, 50.255951],
                        [1.478714, 50.164918],
                        [1.453881, 50.110329],
                        [1.379705, 50.065015],
                        [1.456462, 50.037833],
                        [1.678451, 49.918134],
                        [1.727056, 49.828884],
                        [1.783837, 49.758308],
                        [1.893864, 49.698988],
                        [1.93321, 49.71963],
                        [2.12141, 49.688074],
                        [2.247169, 49.701641],
                        [2.373146, 49.656266],
                        [2.504749, 49.639467],
                        [2.571493, 49.597081],
                        [2.670723, 49.581412],
                        [2.689142, 49.625602],
                        [2.799495, 49.620586],
                        [2.793612, 49.655954],
                        [2.915713, 49.702672],
                        [3.118403, 49.705969],
                        [3.078694, 49.822415],
                        [3.117969, 49.914276],
                        [3.192675, 49.977465],
                        [3.172707, 50.011995],
                        [3.090254, 50.053741],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "80", "NOM_DEPT": "SOMME"},
        },
        45: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [3.103498, 45.354373],
                        [3.117998, 45.284187],
                        [3.222465, 45.271971],
                        [3.288033, 45.120424],
                        [3.325785, 45.095136],
                        [3.29725, 45.036078],
                        [3.347199, 45.014234],
                        [3.361343, 44.971412],
                        [3.412835, 44.944843],
                        [3.417971, 44.900768],
                        [3.475774, 44.815372],
                        [3.589349, 44.832194],
                        [3.594336, 44.87543],
                        [3.659522, 44.869939],
                        [3.666365, 44.828778],
                        [3.740651, 44.838697],
                        [3.862527, 44.743863],
                        [3.937001, 44.795417],
                        [4.028375, 44.834081],
                        [4.039639, 44.873162],
                        [4.156155, 44.873334],
                        [4.221703, 44.961336],
                        [4.289828, 44.997307],
                        [4.375306, 45.104832],
                        [4.376559, 45.14436],
                        [4.443263, 45.140833],
                        [4.483135, 45.236446],
                        [4.418571, 45.275424],
                        [4.362549, 45.264395],
                        [4.366534, 45.336996],
                        [4.308199, 45.370987],
                        [4.177926, 45.392605],
                        [4.024824, 45.342888],
                        [3.979651, 45.375134],
                        [3.897408, 45.357084],
                        [3.80831, 45.391612],
                        [3.772255, 45.349192],
                        [3.667209, 45.376197],
                        [3.625847, 45.338346],
                        [3.501321, 45.427579],
                        [3.456747, 45.400287],
                        [3.290692, 45.401822],
                        [3.168063, 45.35226],
                        [3.103498, 45.354373],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "43", "NOM_DEPT": "HAUTE-LOIRE"},
        },
        46: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [4.047973, 49.405642],
                        [4.035496, 49.359904],
                        [3.924434, 49.406182],
                        [3.847477, 49.364587],
                        [3.646953, 49.315154],
                        [3.704392, 49.181373],
                        [3.622247, 49.151104],
                        [3.600005, 49.120692],
                        [3.646307, 49.040588],
                        [3.601598, 48.944072],
                        [3.528576, 48.912141],
                        [3.485187, 48.851908],
                        [3.435809, 48.753572],
                        [3.476964, 48.699358],
                        [3.460426, 48.65301],
                        [3.555614, 48.620285],
                        [3.634028, 48.541298],
                        [3.730879, 48.537468],
                        [3.822742, 48.516104],
                        [3.949227, 48.603432],
                        [4.001695, 48.663875],
                        [4.080262, 48.701069],
                        [4.166387, 48.707454],
                        [4.325594, 48.700277],
                        [4.315905, 48.615579],
                        [4.403063, 48.56126],
                        [4.545407, 48.525252],
                        [4.614027, 48.553807],
                        [4.670183, 48.531887],
                        [4.79918, 48.52978],
                        [4.769196, 48.588688],
                        [4.849256, 48.623633],
                        [4.841961, 48.649667],
                        [4.911268, 48.688712],
                        [4.988428, 48.684419],
                        [4.990125, 48.741837],
                        [4.888761, 48.81721],
                        [4.936209, 48.922142],
                        [5.030129, 48.956902],
                        [5.036321, 49.024333],
                        [5.007681, 49.034952],
                        [4.992118, 49.1149],
                        [4.939762, 49.185068],
                        [4.950989, 49.236866],
                        [4.894206, 49.259074],
                        [4.826941, 49.235761],
                        [4.686075, 49.256759],
                        [4.625104, 49.235656],
                        [4.575868, 49.296651],
                        [4.422583, 49.280645],
                        [4.306757, 49.327797],
                        [4.248308, 49.382256],
                        [4.14317, 49.404187],
                        [4.047973, 49.405642],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "51", "NOM_DEPT": "MARNE"},
        },
        47: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-0.313443, 42.849375],
                        [-0.145992, 42.768467],
                        [-0.106109, 42.720824],
                        [-0.010638, 42.684385],
                        [0.17572, 42.736485],
                        [0.259883, 42.715811],
                        [0.292822, 42.674925],
                        [0.359629, 42.723392],
                        [0.429276, 42.69075],
                        [0.47775, 42.69999],
                        [0.455094, 42.728061],
                        [0.4589, 42.828145],
                        [0.477301, 42.878107],
                        [0.575935, 42.870826],
                        [0.627418, 43.000103],
                        [0.563004, 43.017468],
                        [0.53227, 43.093864],
                        [0.441999, 43.131273],
                        [0.551875, 43.209147],
                        [0.551568, 43.236103],
                        [0.61628, 43.289037],
                        [0.606811, 43.310886],
                        [0.498034, 43.326181],
                        [0.277255, 43.385791],
                        [0.182031, 43.371183],
                        [0.137982, 43.432916],
                        [0.112124, 43.51737],
                        [0.056081, 43.518807],
                        [-0.001925, 43.56554],
                        [-0.015781, 43.604657],
                        [-0.096783, 43.582406],
                        [-0.040132, 43.512605],
                        [-0.069031, 43.437349],
                        [0.009598, 43.42211],
                        [-0.046122, 43.300856],
                        [-0.017008, 43.270453],
                        [-0.117701, 43.180327],
                        [-0.146132, 43.128236],
                        [-0.190984, 43.1112],
                        [-0.223952, 43.033688],
                        [-0.291552, 42.987768],
                        [-0.281591, 42.933563],
                        [-0.327082, 42.915782],
                        [-0.313443, 42.849375],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "65", "NOM_DEPT": "HAUTES-PYRENEES"},
        },
        48: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.075141, 44.577325],
                        [1.013167, 44.536127],
                        [1.009025, 44.480041],
                        [1.064084, 44.378513],
                        [1.107939, 44.327403],
                        [1.281379, 44.235786],
                        [1.380368, 44.224858],
                        [1.520539, 44.26327],
                        [1.569138, 44.298394],
                        [1.651621, 44.286806],
                        [1.699503, 44.313814],
                        [1.882083, 44.340065],
                        [1.8396, 44.4759],
                        [1.931468, 44.506394],
                        [2.057369, 44.582906],
                        [2.153817, 44.571901],
                        [2.207475, 44.615532],
                        [2.169418, 44.638066],
                        [2.153492, 44.753108],
                        [2.171636, 44.790024],
                        [2.094212, 44.872011],
                        [2.062914, 44.976506],
                        [1.908156, 44.978427],
                        [1.823915, 44.927682],
                        [1.750625, 44.954959],
                        [1.650984, 45.025016],
                        [1.535725, 45.04628],
                        [1.448262, 45.019313],
                        [1.413299, 44.999386],
                        [1.44192, 44.877579],
                        [1.361404, 44.840795],
                        [1.364103, 44.811568],
                        [1.287782, 44.714781],
                        [1.22455, 44.684266],
                        [1.146672, 44.670346],
                        [1.153794, 44.639406],
                        [1.075141, 44.577325],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "46", "NOM_DEPT": "LOT"},
        },
        49: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [6.636396, 43.788951],
                        [6.697323, 43.873655],
                        [6.745556, 43.872108],
                        [6.830709, 43.918363],
                        [6.88461, 43.889121],
                        [6.913089, 43.927965],
                        [6.851892, 43.954794],
                        [6.836004, 43.990602],
                        [6.745714, 44.043235],
                        [6.75528, 44.078607],
                        [6.686536, 44.169254],
                        [6.723994, 44.249843],
                        [6.796091, 44.316106],
                        [6.88743, 44.361048],
                        [6.881957, 44.477253],
                        [6.854013, 44.52913],
                        [6.933507, 44.575952],
                        [6.948335, 44.654816],
                        [6.914488, 44.659499],
                        [6.839802, 44.608589],
                        [6.772207, 44.588909],
                        [6.684305, 44.5413],
                        [6.632376, 44.447129],
                        [6.562445, 44.445493],
                        [6.413885, 44.46929],
                        [6.362, 44.522073],
                        [6.233718, 44.463831],
                        [6.262482, 44.41225],
                        [6.228222, 44.3817],
                        [6.155615, 44.46196],
                        [6.071139, 44.450536],
                        [5.95367, 44.395059],
                        [5.912323, 44.271532],
                        [5.823912, 44.278902],
                        [5.881794, 44.210999],
                        [5.755494, 44.210208],
                        [5.676037, 44.191433],
                        [5.639594, 44.167586],
                        [5.576187, 44.188042],
                        [5.543986, 44.136391],
                        [5.498788, 44.115719],
                        [5.502637, 44.063439],
                        [5.543657, 44.028708],
                        [5.51209, 43.946002],
                        [5.607127, 43.913773],
                        [5.57819, 43.829921],
                        [5.654445, 43.825111],
                        [5.757333, 43.729409],
                        [5.781343, 43.755657],
                        [5.901207, 43.732585],
                        [6.036132, 43.694163],
                        [6.182886, 43.762176],
                        [6.21671, 43.799512],
                        [6.356961, 43.736368],
                        [6.413483, 43.76036],
                        [6.414428, 43.791594],
                        [6.524762, 43.806366],
                        [6.636396, 43.788951],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "04", "NOM_DEPT": "ALPES-DE-HAUTE-PROVENCE"},
        },
        50: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.614431, 47.694214],
                        [0.580518, 47.712328],
                        [0.71263, 47.790036],
                        [0.774579, 47.839687],
                        [0.759875, 47.898227],
                        [0.845801, 47.941401],
                        [0.797485, 48.037554],
                        [0.841217, 48.103062],
                        [0.882491, 48.161763],
                        [0.797656, 48.194452],
                        [0.737827, 48.189072],
                        [0.683224, 48.248586],
                        [0.535973, 48.249847],
                        [0.487572, 48.3078],
                        [0.382605, 48.333827],
                        [0.363959, 48.451633],
                        [0.29586, 48.480174],
                        [0.116245, 48.435554],
                        [0.062488, 48.382217],
                        [-0.002559, 48.397314],
                        [-0.054531, 48.382003],
                        [-0.137978, 48.361356],
                        [-0.163096, 48.255542],
                        [-0.146837, 48.205009],
                        [-0.249921, 48.157107],
                        [-0.217174, 48.10696],
                        [-0.230942, 48.058985],
                        [-0.341665, 48.043096],
                        [-0.282633, 47.958192],
                        [-0.38484, 47.930845],
                        [-0.370673, 47.880025],
                        [-0.447859, 47.832216],
                        [-0.388201, 47.805319],
                        [-0.381703, 47.760563],
                        [-0.334077, 47.721166],
                        [-0.23306, 47.707562],
                        [-0.193157, 47.647917],
                        [-0.135037, 47.63252],
                        [-0.071831, 47.658007],
                        [-0.004508, 47.647688],
                        [0.051659, 47.606515],
                        [0.151604, 47.581535],
                        [0.230002, 47.608398],
                        [0.378961, 47.569104],
                        [0.456631, 47.638826],
                        [0.542892, 47.656207],
                        [0.614431, 47.694214],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "72", "NOM_DEPT": "SARTHE"},
        },
        51: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [-3.235445, 47.323818],
                            [-3.086556, 47.283074],
                            [-3.093118, 47.315135],
                            [-3.155861, 47.361084],
                            [-3.248775, 47.379576],
                            [-3.235445, 47.323818],
                        ]
                    ],
                    [
                        [
                            [-3.523004, 47.849147],
                            [-3.529927, 47.782464],
                            [-3.452761, 47.695342],
                            [-3.344218, 47.708363],
                            [-3.208128, 47.663421],
                            [-3.209753, 47.64069],
                            [-3.123259, 47.569508],
                            [-2.975178, 47.576072],
                            [-2.851151, 47.619022],
                            [-2.778574, 47.619159],
                            [-2.701951, 47.589919],
                            [-2.730539, 47.542489],
                            [-2.813616, 47.552973],
                            [-2.871566, 47.532184],
                            [-2.800208, 47.487275],
                            [-2.664337, 47.518637],
                            [-2.53713, 47.525679],
                            [-2.441224, 47.49624],
                            [-2.458489, 47.448122],
                            [-2.312868, 47.464469],
                            [-2.107334, 47.531057],
                            [-2.097036, 47.63136],
                            [-2.131472, 47.72224],
                            [-2.089712, 47.738561],
                            [-2.049526, 47.816917],
                            [-2.116299, 47.880956],
                            [-2.079089, 47.919522],
                            [-2.136865, 47.979117],
                            [-2.239594, 47.999462],
                            [-2.279595, 48.026361],
                            [-2.233245, 48.075628],
                            [-2.287278, 48.133746],
                            [-2.371365, 48.122103],
                            [-2.408905, 48.168611],
                            [-2.494819, 48.157845],
                            [-2.574786, 48.07041],
                            [-2.63119, 48.035479],
                            [-2.670051, 48.047884],
                            [-2.652301, 48.119325],
                            [-2.781951, 48.12058],
                            [-3.03354, 48.199361],
                            [-3.116374, 48.206364],
                            [-3.155254, 48.158491],
                            [-3.272244, 48.140015],
                            [-3.336755, 48.171125],
                            [-3.564839, 48.185747],
                            [-3.695839, 48.152212],
                            [-3.695021, 48.093495],
                            [-3.640232, 47.985243],
                            [-3.555276, 47.993098],
                            [-3.484812, 47.96689],
                            [-3.392625, 47.954451],
                            [-3.403443, 47.870115],
                            [-3.523004, 47.849147],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "56", "NOM_DEPT": "MORBIHAN"},
        },
        52: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.814819, 48.670168],
                        [0.850642, 48.582627],
                        [0.966551, 48.522745],
                        [0.942241, 48.399001],
                        [0.883371, 48.356673],
                        [0.785432, 48.340427],
                        [0.762193, 48.306877],
                        [0.830483, 48.210713],
                        [0.797656, 48.194452],
                        [0.882491, 48.161763],
                        [0.841217, 48.103062],
                        [0.99733, 48.127494],
                        [1.008548, 48.083127],
                        [1.112233, 48.080729],
                        [1.121234, 48.039116],
                        [1.209643, 47.968501],
                        [1.308628, 47.953854],
                        [1.520124, 47.982278],
                        [1.512976, 48.028722],
                        [1.594116, 48.0307],
                        [1.624593, 48.067223],
                        [1.744834, 48.066144],
                        [1.865671, 48.083857],
                        [1.965479, 48.255466],
                        [1.994085, 48.286586],
                        [1.976578, 48.399384],
                        [1.930556, 48.404125],
                        [1.922149, 48.4576],
                        [1.801446, 48.466088],
                        [1.76533, 48.569371],
                        [1.709253, 48.578024],
                        [1.602498, 48.663769],
                        [1.579546, 48.701812],
                        [1.591203, 48.81487],
                        [1.55725, 48.891577],
                        [1.501524, 48.941054],
                        [1.46835, 48.892217],
                        [1.362181, 48.834179],
                        [1.376964, 48.791769],
                        [1.319548, 48.760965],
                        [1.184731, 48.77263],
                        [1.031657, 48.730583],
                        [0.876707, 48.715492],
                        [0.814819, 48.670168],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "28", "NOM_DEPT": "EURE-ET-LOIR"},
        },
        53: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [9.402268, 41.858698],
                        [9.329201, 41.836815],
                        [9.227497, 41.855589],
                        [9.221084, 42.027597],
                        [9.160818, 42.026017],
                        [9.119729, 42.107774],
                        [9.072187, 42.130214],
                        [9.045659, 42.206923],
                        [8.904767, 42.253859],
                        [8.819561, 42.317558],
                        [8.640802, 42.373436],
                        [8.573411, 42.381406],
                        [8.689106, 42.263524],
                        [8.616716, 42.25546],
                        [8.570335, 42.2303],
                        [8.590171, 42.163888],
                        [8.660505, 42.103587],
                        [8.710257, 42.095824],
                        [8.741332, 42.040909],
                        [8.65642, 42.009346],
                        [8.668873, 41.982431],
                        [8.597695, 41.953243],
                        [8.641453, 41.909889],
                        [8.72143, 41.909258],
                        [8.754903, 41.932569],
                        [8.803137, 41.891384],
                        [8.771294, 41.81124],
                        [8.684518, 41.747002],
                        [8.717235, 41.722771],
                        [8.914509, 41.689727],
                        [8.877266, 41.652451],
                        [8.793074, 41.629553],
                        [8.788528, 41.557734],
                        [8.841681, 41.546549],
                        [8.938398, 41.489667],
                        [9.082198, 41.441978],
                        [9.095532, 41.412432],
                        [9.219682, 41.368214],
                        [9.228899, 41.425303],
                        [9.265877, 41.465995],
                        [9.287551, 41.530226],
                        [9.3409, 41.559245],
                        [9.327204, 41.61636],
                        [9.387497, 41.657362],
                        [9.407323, 41.767639],
                        [9.402268, 41.858698],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "2A", "NOM_DEPT": "CORSE-DU-SUD"},
        },
        54: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.47091, 49.497205],
                        [5.46178, 49.452691],
                        [5.529099, 49.407375],
                        [5.634566, 49.437436],
                        [5.688148, 49.415106],
                        [5.731786, 49.311343],
                        [5.719044, 49.215987],
                        [5.765544, 49.198089],
                        [5.744468, 49.156596],
                        [5.763361, 49.10788],
                        [5.818638, 49.086174],
                        [5.823067, 49.023107],
                        [5.800245, 48.946746],
                        [5.747162, 48.915258],
                        [5.780972, 48.826749],
                        [5.714036, 48.744533],
                        [5.757709, 48.695698],
                        [5.761767, 48.60939],
                        [5.71609, 48.561424],
                        [5.776212, 48.540359],
                        [5.765155, 48.496493],
                        [5.85607, 48.506844],
                        [5.961559, 48.349891],
                        [6.116724, 48.354038],
                        [6.178419, 48.397599],
                        [6.566974, 48.419032],
                        [6.584971, 48.460509],
                        [6.699498, 48.413088],
                        [6.815167, 48.398846],
                        [6.890811, 48.418094],
                        [6.982986, 48.47906],
                        [7.123165, 48.513592],
                        [7.07936, 48.536418],
                        [6.982882, 48.611863],
                        [6.844054, 48.625975],
                        [6.754673, 48.669387],
                        [6.692284, 48.67284],
                        [6.658407, 48.708047],
                        [6.598966, 48.715691],
                        [6.554149, 48.754093],
                        [6.35503, 48.781659],
                        [6.338947, 48.834058],
                        [6.271978, 48.933136],
                        [6.132207, 48.934721],
                        [6.116899, 48.967833],
                        [6.043435, 48.977478],
                        [6.044997, 49.010419],
                        [5.9354, 49.071852],
                        [5.931603, 49.109104],
                        [6.02615, 49.165119],
                        [5.987627, 49.209617],
                        [6.029385, 49.230472],
                        [5.928531, 49.375507],
                        [5.94262, 49.452896],
                        [5.893401, 49.49691],
                        [5.79393, 49.55124],
                        [5.715279, 49.53934],
                        [5.659768, 49.552871],
                        [5.47091, 49.497205],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "54", "NOM_DEPT": "MEURTHE-ET-MOSELLE"},
        },
        55: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.412815, 48.950626],
                        [0.333773, 48.942884],
                        [0.27564, 48.964745],
                        [0.156475, 48.924788],
                        [0.127608, 48.952219],
                        [0.056398, 48.902464],
                        [-0.058807, 48.853587],
                        [-0.146343, 48.834449],
                        [-0.305921, 48.858307],
                        [-0.346245, 48.821999],
                        [-0.411519, 48.87014],
                        [-0.463753, 48.871366],
                        [-0.714679, 48.799868],
                        [-0.840935, 48.75222],
                        [-0.798956, 48.710189],
                        [-0.752614, 48.617619],
                        [-0.774172, 48.562678],
                        [-0.860363, 48.501458],
                        [-0.757281, 48.436551],
                        [-0.653994, 48.444282],
                        [-0.551718, 48.473117],
                        [-0.505065, 48.505796],
                        [-0.430754, 48.51182],
                        [-0.367623, 48.492944],
                        [-0.278228, 48.506989],
                        [-0.206938, 48.562945],
                        [-0.169383, 48.53697],
                        [-0.148713, 48.458068],
                        [-0.051896, 48.45326],
                        [-0.054531, 48.382003],
                        [-0.002559, 48.397314],
                        [0.062488, 48.382217],
                        [0.116245, 48.435554],
                        [0.29586, 48.480174],
                        [0.363959, 48.451633],
                        [0.382605, 48.333827],
                        [0.487572, 48.3078],
                        [0.535973, 48.249847],
                        [0.683224, 48.248586],
                        [0.737827, 48.189072],
                        [0.797656, 48.194452],
                        [0.830483, 48.210713],
                        [0.762193, 48.306877],
                        [0.785432, 48.340427],
                        [0.883371, 48.356673],
                        [0.942241, 48.399001],
                        [0.966551, 48.522745],
                        [0.850642, 48.582627],
                        [0.814819, 48.670168],
                        [0.730589, 48.705208],
                        [0.774959, 48.737527],
                        [0.733506, 48.783364],
                        [0.610294, 48.831314],
                        [0.552503, 48.875538],
                        [0.457358, 48.879762],
                        [0.386189, 48.910415],
                        [0.412815, 48.950626],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "61", "NOM_DEPT": "ORNE"},
        },
        56: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.310561, 46.446766],
                        [5.215064, 46.468359],
                        [5.201145, 46.50821],
                        [5.052374, 46.484873],
                        [4.940023, 46.517198],
                        [4.891818, 46.439914],
                        [4.888208, 46.402982],
                        [4.810995, 46.259922],
                        [4.780213, 46.176677],
                        [4.797433, 46.140701],
                        [4.750325, 46.09415],
                        [4.73953, 46.047209],
                        [4.754631, 45.973622],
                        [4.729097, 45.949092],
                        [4.864502, 45.904617],
                        [4.923799, 45.803999],
                        [5.101067, 45.813378],
                        [5.191533, 45.771688],
                        [5.266895, 45.789369],
                        [5.309169, 45.854933],
                        [5.353827, 45.883273],
                        [5.434945, 45.831094],
                        [5.422641, 45.807124],
                        [5.545542, 45.713593],
                        [5.623748, 45.613268],
                        [5.689187, 45.648502],
                        [5.704119, 45.710926],
                        [5.776161, 45.729222],
                        [5.786856, 45.822956],
                        [5.831226, 45.93846],
                        [5.809643, 45.9898],
                        [5.807622, 46.063935],
                        [5.832301, 46.105996],
                        [5.956063, 46.132089],
                        [6.033128, 46.237996],
                        [6.124247, 46.251012],
                        [6.102638, 46.285064],
                        [6.169742, 46.367937],
                        [6.064008, 46.416227],
                        [5.986841, 46.364873],
                        [5.908938, 46.283952],
                        [5.849846, 46.262064],
                        [5.725183, 46.260729],
                        [5.714718, 46.308769],
                        [5.649339, 46.339491],
                        [5.542038, 46.270202],
                        [5.473055, 46.265064],
                        [5.437795, 46.315113],
                        [5.373462, 46.352236],
                        [5.377045, 46.381359],
                        [5.307691, 46.416817],
                        [5.310561, 46.446766],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "01", "NOM_DEPT": "AIN"},
        },
        57: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.858306, 42.825719],
                        [0.927332, 42.78926],
                        [1.075108, 42.785351],
                        [1.161848, 42.711046],
                        [1.230212, 42.727586],
                        [1.325026, 42.723904],
                        [1.3896, 42.685083],
                        [1.435054, 42.606076],
                        [1.549248, 42.655776],
                        [1.60147, 42.628039],
                        [1.687359, 42.623904],
                        [1.786125, 42.573623],
                        [1.874485, 42.581406],
                        [1.97176, 42.61692],
                        [2.000515, 42.661565],
                        [2.166054, 42.663918],
                        [2.175874, 42.682795],
                        [2.057204, 42.756223],
                        [1.955396, 42.736701],
                        [1.90818, 42.767667],
                        [1.880474, 42.852669],
                        [1.986921, 42.871012],
                        [1.9851, 43.026272],
                        [1.941133, 43.052715],
                        [1.949476, 43.119494],
                        [1.824772, 43.145814],
                        [1.710056, 43.189698],
                        [1.723844, 43.224524],
                        [1.68842, 43.273554],
                        [1.637204, 43.255115],
                        [1.54752, 43.275674],
                        [1.463711, 43.210601],
                        [1.425361, 43.256572],
                        [1.343652, 43.315606],
                        [1.29331, 43.285337],
                        [1.374373, 43.213746],
                        [1.314608, 43.189995],
                        [1.227481, 43.183893],
                        [1.208734, 43.117951],
                        [1.124082, 43.156907],
                        [1.058913, 43.141826],
                        [1.038836, 43.100553],
                        [0.985169, 43.067056],
                        [1.007046, 43.007591],
                        [0.979101, 42.974431],
                        [0.874911, 42.957776],
                        [0.832413, 42.919988],
                        [0.858306, 42.825719],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "09", "NOM_DEPT": "ARIEGE"},
        },
        58: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.253152, 45.444219],
                        [1.259604, 45.398349],
                        [1.322797, 45.382659],
                        [1.227119, 45.27198],
                        [1.277496, 45.242082],
                        [1.296518, 45.140189],
                        [1.386442, 45.102881],
                        [1.448262, 45.019313],
                        [1.535725, 45.04628],
                        [1.650984, 45.025016],
                        [1.750625, 44.954959],
                        [1.823915, 44.927682],
                        [1.908156, 44.978427],
                        [2.062914, 44.976506],
                        [2.132979, 44.985521],
                        [2.095159, 45.05603],
                        [2.171756, 45.081496],
                        [2.213697, 45.160193],
                        [2.195361, 45.220852],
                        [2.271414, 45.290152],
                        [2.350479, 45.327558],
                        [2.378246, 45.414306],
                        [2.441861, 45.384258],
                        [2.487468, 45.418838],
                        [2.508409, 45.478499],
                        [2.516332, 45.553427],
                        [2.46535, 45.600823],
                        [2.514297, 45.639532],
                        [2.528365, 45.681924],
                        [2.492126, 45.73767],
                        [2.435856, 45.699275],
                        [2.349183, 45.709479],
                        [2.337755, 45.680605],
                        [2.193958, 45.699047],
                        [2.174353, 45.732216],
                        [2.113545, 45.724775],
                        [2.017609, 45.75549],
                        [1.898731, 45.698278],
                        [1.871348, 45.664658],
                        [1.783868, 45.680363],
                        [1.637663, 45.580352],
                        [1.557196, 45.549366],
                        [1.48037, 45.565943],
                        [1.412059, 45.528081],
                        [1.350078, 45.466888],
                        [1.287057, 45.489938],
                        [1.253152, 45.444219],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "19", "NOM_DEPT": "CORREZE"},
        },
        59: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [6.84618, 47.822945],
                        [6.863476, 47.785161],
                        [7.015961, 47.743233],
                        [7.046315, 47.671502],
                        [7.004983, 47.619383],
                        [7.08627, 47.592562],
                        [7.130346, 47.503027],
                        [7.173077, 47.447183],
                        [7.246297, 47.422202],
                        [7.301734, 47.437815],
                        [7.403411, 47.435524],
                        [7.506754, 47.495634],
                        [7.503408, 47.54198],
                        [7.584706, 47.577264],
                        [7.592798, 47.601777],
                        [7.522346, 47.662321],
                        [7.513752, 47.702818],
                        [7.548078, 47.739587],
                        [7.53126, 47.786758],
                        [7.556705, 47.879941],
                        [7.62209, 47.972273],
                        [7.571623, 48.03038],
                        [7.577313, 48.120369],
                        [7.519369, 48.126112],
                        [7.470561, 48.161015],
                        [7.476943, 48.203537],
                        [7.348563, 48.247195],
                        [7.275184, 48.305235],
                        [7.198282, 48.310468],
                        [7.133556, 48.245941],
                        [7.058913, 48.137266],
                        [7.001884, 48.022399],
                        [6.943356, 47.997958],
                        [6.900213, 47.891191],
                        [6.920034, 47.850288],
                        [6.84618, 47.822945],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "68", "NOM_DEPT": "HAUT-RHIN"},
        },
        60: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.326666, 47.186225],
                        [1.276908, 47.254707],
                        [1.223537, 47.294081],
                        [1.162065, 47.272196],
                        [1.108127, 47.298398],
                        [1.122835, 47.354017],
                        [1.107483, 47.411325],
                        [1.132364, 47.446467],
                        [1.045291, 47.531488],
                        [1.076336, 47.563222],
                        [1.033353, 47.607012],
                        [0.919011, 47.632609],
                        [0.859504, 47.669207],
                        [0.735311, 47.695402],
                        [0.614431, 47.694214],
                        [0.542892, 47.656207],
                        [0.456631, 47.638826],
                        [0.378961, 47.569104],
                        [0.230002, 47.608398],
                        [0.201503, 47.544328],
                        [0.220109, 47.501953],
                        [0.18528, 47.424733],
                        [0.078975, 47.282825],
                        [0.053828, 47.16373],
                        [0.076371, 47.123932],
                        [0.136131, 47.121581],
                        [0.174221, 47.071275],
                        [0.298231, 47.053919],
                        [0.300736, 46.973828],
                        [0.43871, 46.929582],
                        [0.506141, 46.959247],
                        [0.598348, 46.956764],
                        [0.566949, 47.00227],
                        [0.692569, 46.974307],
                        [0.704324, 46.903293],
                        [0.790328, 46.852391],
                        [0.811902, 46.794508],
                        [0.867469, 46.748219],
                        [0.988813, 46.761541],
                        [1.049878, 46.98064],
                        [1.077615, 47.015842],
                        [1.161422, 47.039623],
                        [1.273057, 47.037834],
                        [1.311673, 47.096975],
                        [1.365361, 47.122051],
                        [1.326666, 47.186225],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "37", "NOM_DEPT": "INDRE-ET-LOIRE"},
        },
        61: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.067712, 51.006505],
                        [2.097601, 50.998427],
                        [2.183905, 50.883452],
                        [2.21343, 50.810549],
                        [2.340891, 50.740906],
                        [2.407792, 50.672766],
                        [2.495949, 50.631245],
                        [2.630516, 50.617952],
                        [2.713851, 50.631292],
                        [2.769041, 50.663678],
                        [2.840449, 50.656566],
                        [2.805166, 50.603271],
                        [2.825982, 50.525388],
                        [2.898952, 50.501558],
                        [2.96471, 50.512778],
                        [3.020793, 50.481769],
                        [3.037672, 50.44164],
                        [2.993078, 50.379847],
                        [3.173376, 50.241108],
                        [3.156132, 50.183715],
                        [3.095757, 50.124202],
                        [3.090254, 50.053741],
                        [3.172707, 50.011995],
                        [3.230541, 50.03131],
                        [3.280174, 50.015183],
                        [3.352982, 50.035859],
                        [3.49136, 50.018856],
                        [3.544846, 50.053794],
                        [3.61364, 50.025419],
                        [3.715185, 50.069275],
                        [3.74638, 50.053604],
                        [3.923501, 50.026431],
                        [3.980376, 49.995376],
                        [4.087129, 49.969188],
                        [4.140895, 49.97876],
                        [4.162224, 50.048985],
                        [4.227999, 50.066372],
                        [4.199887, 50.131078],
                        [4.126927, 50.135011],
                        [4.16012, 50.202536],
                        [4.22185, 50.256953],
                        [4.136656, 50.2743],
                        [4.037614, 50.342949],
                        [3.967899, 50.350366],
                        [3.8898, 50.32998],
                        [3.852756, 50.351593],
                        [3.747404, 50.350929],
                        [3.694427, 50.315828],
                        [3.658271, 50.371341],
                        [3.664218, 50.453175],
                        [3.61301, 50.492469],
                        [3.473964, 50.533562],
                        [3.373892, 50.491825],
                        [3.286517, 50.527576],
                        [3.248509, 50.638041],
                        [3.258371, 50.70065],
                        [3.191219, 50.724406],
                        [3.151998, 50.782343],
                        [3.061377, 50.780501],
                        [2.938073, 50.744341],
                        [2.89838, 50.694236],
                        [2.813275, 50.716948],
                        [2.717481, 50.813608],
                        [2.634983, 50.812756],
                        [2.599595, 50.853334],
                        [2.632687, 50.946005],
                        [2.575982, 51.013753],
                        [2.543035, 51.088543],
                        [2.424754, 51.055626],
                        [2.34784, 51.059832],
                        [2.1097, 51.003824],
                        [2.067712, 51.006505],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "59", "NOM_DEPT": "NORD"},
        },
        62: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [7.130346, 47.503027],
                        [7.08627, 47.592562],
                        [7.004983, 47.619383],
                        [7.046315, 47.671502],
                        [7.015961, 47.743233],
                        [6.863476, 47.785161],
                        [6.84618, 47.822945],
                        [6.823539, 47.813054],
                        [6.757638, 47.747878],
                        [6.780405, 47.625261],
                        [6.806992, 47.562802],
                        [6.90567, 47.547362],
                        [6.90761, 47.494546],
                        [6.940537, 47.433374],
                        [6.998963, 47.452299],
                        [6.983119, 47.493303],
                        [7.079277, 47.488864],
                        [7.130346, 47.503027],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "90", "NOM_DEPT": "TERRITOIRE DE BELFORT"},
        },
        63: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-1.245882, 47.776718],
                        [-1.352864, 47.797693],
                        [-1.390428, 47.828281],
                        [-1.593407, 47.77605],
                        [-1.65482, 47.712593],
                        [-1.772416, 47.698453],
                        [-1.864013, 47.706985],
                        [-1.969054, 47.688369],
                        [-2.097036, 47.63136],
                        [-2.107334, 47.531057],
                        [-2.312868, 47.464469],
                        [-2.458489, 47.448122],
                        [-2.534103, 47.382965],
                        [-2.513805, 47.298372],
                        [-2.44754, 47.261756],
                        [-2.398381, 47.281446],
                        [-2.301643, 47.236404],
                        [-2.187365, 47.280619],
                        [-2.158371, 47.209053],
                        [-2.167064, 47.16618],
                        [-2.226823, 47.13094],
                        [-2.053473, 47.094122],
                        [-1.980414, 47.028906],
                        [-1.943228, 46.994711],
                        [-1.830982, 46.932034],
                        [-1.751062, 46.929596],
                        [-1.689761, 46.890493],
                        [-1.548511, 46.86008],
                        [-1.500767, 46.883891],
                        [-1.553564, 46.981505],
                        [-1.552322, 47.018349],
                        [-1.482131, 47.037862],
                        [-1.456132, 46.926273],
                        [-1.372986, 46.952184],
                        [-1.378612, 47.030854],
                        [-1.294635, 47.039483],
                        [-1.271207, 47.083893],
                        [-1.14857, 47.029545],
                        [-1.115463, 47.062565],
                        [-1.231146, 47.109955],
                        [-1.235248, 47.138782],
                        [-1.163216, 47.177784],
                        [-1.197722, 47.250581],
                        [-1.254175, 47.249856],
                        [-1.305109, 47.30317],
                        [-1.299877, 47.337624],
                        [-1.16761, 47.365887],
                        [-1.017874, 47.365062],
                        [-0.946443, 47.386467],
                        [-0.967483, 47.4928],
                        [-1.157233, 47.510083],
                        [-1.172416, 47.573008],
                        [-1.04591, 47.563352],
                        [-1.006864, 47.589053],
                        [-1.138202, 47.619457],
                        [-1.17493, 47.694565],
                        [-1.254577, 47.733642],
                        [-1.245882, 47.776718],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "44", "NOM_DEPT": "LOIRE-ATLANTIQUE"},
        },
        64: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.976538, 47.569429],
                        [3.025638, 47.558753],
                        [3.101997, 47.587956],
                        [3.122047, 47.541049],
                        [3.204649, 47.522966],
                        [3.235477, 47.489179],
                        [3.307051, 47.49472],
                        [3.346315, 47.472438],
                        [3.397288, 47.508867],
                        [3.487879, 47.493923],
                        [3.513505, 47.527668],
                        [3.580617, 47.497863],
                        [3.580113, 47.464901],
                        [3.678991, 47.445534],
                        [3.714782, 47.406835],
                        [3.785634, 47.390542],
                        [3.970678, 47.378314],
                        [3.973085, 47.332713],
                        [4.106086, 47.339256],
                        [4.06606, 47.407251],
                        [4.119427, 47.443553],
                        [4.1155, 47.515009],
                        [4.175128, 47.553259],
                        [4.212381, 47.627966],
                        [4.268423, 47.68141],
                        [4.258164, 47.727403],
                        [4.332472, 47.756511],
                        [4.324394, 47.847157],
                        [4.261001, 47.843851],
                        [4.293424, 47.925676],
                        [4.199158, 47.969941],
                        [4.111786, 47.926996],
                        [3.902087, 47.93917],
                        [3.850029, 47.983792],
                        [3.804968, 48.10255],
                        [3.740291, 48.169708],
                        [3.66787, 48.139212],
                        [3.621604, 48.22574],
                        [3.616804, 48.27134],
                        [3.498153, 48.369097],
                        [3.414792, 48.390273],
                        [3.365159, 48.372281],
                        [3.167738, 48.371861],
                        [3.049519, 48.36012],
                        [3.043627, 48.272022],
                        [3.005156, 48.20767],
                        [2.936314, 48.163392],
                        [3.029465, 48.133207],
                        [3.050471, 48.072334],
                        [3.088318, 48.053936],
                        [3.12845, 47.970973],
                        [3.050104, 47.911447],
                        [3.010293, 47.904717],
                        [3.023798, 47.786555],
                        [2.935058, 47.763246],
                        [2.856666, 47.760926],
                        [2.858518, 47.711993],
                        [2.92311, 47.68056],
                        [2.937999, 47.598885],
                        [2.976538, 47.569429],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "89", "NOM_DEPT": "YONNE"},
        },
        65: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [-2.006895, 48.566113],
                            [-2.048688, 48.636976],
                            [-2.123708, 48.60441],
                            [-2.075984, 48.567679],
                            [-2.006895, 48.566113],
                        ]
                    ],
                    [
                        [
                            [-1.070165, 48.508494],
                            [-1.206556, 48.542206],
                            [-1.272248, 48.533925],
                            [-1.377246, 48.458285],
                            [-1.489947, 48.489375],
                            [-1.518915, 48.566594],
                            [-1.571087, 48.626446],
                            [-1.764152, 48.60356],
                            [-1.845073, 48.616368],
                            [-1.871656, 48.647411],
                            [-1.856132, 48.704855],
                            [-1.969828, 48.686323],
                            [-2.02896, 48.646915],
                            [-1.948037, 48.538808],
                            [-1.91249, 48.518841],
                            [-1.954833, 48.31711],
                            [-2.014101, 48.279532],
                            [-2.053293, 48.298328],
                            [-2.110119, 48.252903],
                            [-2.186961, 48.246379],
                            [-2.224737, 48.170597],
                            [-2.287278, 48.133746],
                            [-2.233245, 48.075628],
                            [-2.279595, 48.026361],
                            [-2.239594, 47.999462],
                            [-2.136865, 47.979117],
                            [-2.079089, 47.919522],
                            [-2.116299, 47.880956],
                            [-2.049526, 47.816917],
                            [-2.089712, 47.738561],
                            [-2.131472, 47.72224],
                            [-2.097036, 47.63136],
                            [-1.969054, 47.688369],
                            [-1.864013, 47.706985],
                            [-1.772416, 47.698453],
                            [-1.65482, 47.712593],
                            [-1.593407, 47.77605],
                            [-1.390428, 47.828281],
                            [-1.352864, 47.797693],
                            [-1.245882, 47.776718],
                            [-1.238252, 47.809991],
                            [-1.189184, 47.867978],
                            [-1.153994, 47.965821],
                            [-1.102671, 47.989063],
                            [-1.021261, 47.99494],
                            [-1.023283, 48.068911],
                            [-1.049606, 48.089805],
                            [-1.100061, 48.25928],
                            [-1.04502, 48.327728],
                            [-1.082794, 48.433058],
                            [-1.070165, 48.508494],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "35", "NOM_DEPT": "ILLE-ET-VILAINE"},
        },
        66: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-1.524867, 43.529701],
                        [-1.47662, 43.539184],
                        [-1.417774, 43.497767],
                        [-1.291182, 43.498205],
                        [-1.17082, 43.54561],
                        [-1.109248, 43.51413],
                        [-0.993394, 43.505388],
                        [-0.896691, 43.550489],
                        [-0.781781, 43.564167],
                        [-0.715391, 43.541114],
                        [-0.670807, 43.566717],
                        [-0.557174, 43.542797],
                        [-0.448292, 43.596089],
                        [-0.406042, 43.568226],
                        [-0.30369, 43.560277],
                        [-0.242837, 43.584976],
                        [-0.232582, 43.714087],
                        [-0.194143, 43.737017],
                        [-0.190992, 43.875183],
                        [-0.233939, 43.891068],
                        [-0.179109, 43.93792],
                        [-0.073598, 43.945047],
                        [0.032557, 43.900188],
                        [0.076647, 43.916471],
                        [0.076046, 43.983143],
                        [0.062698, 44.000842],
                        [0.100821, 44.08677],
                        [0.135108, 44.124221],
                        [0.034594, 44.130652],
                        [-0.004232, 44.149996],
                        [-0.129155, 44.15241],
                        [-0.140688, 44.226405],
                        [-0.194113, 44.26904],
                        [-0.223447, 44.205898],
                        [-0.272119, 44.193809],
                        [-0.389617, 44.209485],
                        [-0.383387, 44.286311],
                        [-0.43184, 44.322577],
                        [-0.517635, 44.339111],
                        [-0.528103, 44.364654],
                        [-0.627648, 44.398146],
                        [-0.628777, 44.443192],
                        [-0.730703, 44.446375],
                        [-0.845274, 44.418975],
                        [-0.91917, 44.443344],
                        [-1.007453, 44.437652],
                        [-0.980697, 44.482879],
                        [-1.085166, 44.532195],
                        [-1.106491, 44.502773],
                        [-1.25389, 44.467604],
                        [-1.312324, 44.144802],
                        [-1.374987, 43.913789],
                        [-1.436504, 43.710565],
                        [-1.448204, 43.642278],
                        [-1.524867, 43.529701],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "40", "NOM_DEPT": "LANDES"},
        },
        67: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-3.659144, 48.65921],
                        [-3.660936, 48.69407],
                        [-3.83238, 48.711938],
                        [-3.864418, 48.670333],
                        [-3.94946, 48.65286],
                        [-3.975749, 48.699033],
                        [-4.186936, 48.686461],
                        [-4.272768, 48.649582],
                        [-4.351408, 48.676118],
                        [-4.462763, 48.627102],
                        [-4.561476, 48.623804],
                        [-4.630605, 48.577692],
                        [-4.730582, 48.556349],
                        [-4.775473, 48.491005],
                        [-4.793344, 48.416233],
                        [-4.76091, 48.372749],
                        [-4.608724, 48.337887],
                        [-4.424948, 48.397597],
                        [-4.441761, 48.353615],
                        [-4.302158, 48.343777],
                        [-4.30803, 48.297168],
                        [-4.3845, 48.275156],
                        [-4.423777, 48.291668],
                        [-4.566614, 48.286344],
                        [-4.564024, 48.232231],
                        [-4.448362, 48.23563],
                        [-4.301125, 48.191447],
                        [-4.271734, 48.133056],
                        [-4.306989, 48.089183],
                        [-4.3744, 48.11016],
                        [-4.488601, 48.086471],
                        [-4.668222, 48.0702],
                        [-4.72303, 48.033596],
                        [-4.453571, 47.981774],
                        [-4.362572, 47.889263],
                        [-4.362419, 47.795744],
                        [-4.19231, 47.79738],
                        [-4.163559, 47.849185],
                        [-4.077726, 47.866527],
                        [-4.041589, 47.845999],
                        [-3.911501, 47.87028],
                        [-3.902476, 47.83594],
                        [-3.8006, 47.787632],
                        [-3.732544, 47.802927],
                        [-3.68084, 47.77679],
                        [-3.532309, 47.768279],
                        [-3.523004, 47.849147],
                        [-3.403443, 47.870115],
                        [-3.392625, 47.954451],
                        [-3.484812, 47.96689],
                        [-3.555276, 47.993098],
                        [-3.640232, 47.985243],
                        [-3.695021, 48.093495],
                        [-3.695839, 48.152212],
                        [-3.564839, 48.185747],
                        [-3.518441, 48.282273],
                        [-3.556787, 48.33552],
                        [-3.554584, 48.377767],
                        [-3.590415, 48.428923],
                        [-3.604061, 48.496439],
                        [-3.55386, 48.540921],
                        [-3.649378, 48.610153],
                        [-3.659144, 48.65921],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "29", "NOM_DEPT": "FINISTERE"},
        },
        68: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [6.802517, 45.778372],
                        [6.818079, 45.834977],
                        [6.939605, 45.846732],
                        [6.99172, 45.8682],
                        [7.043894, 45.922085],
                        [7.018246, 45.984186],
                        [6.951512, 46.049956],
                        [6.891454, 46.084492],
                        [6.898381, 46.122562],
                        [6.814732, 46.129696],
                        [6.803661, 46.204345],
                        [6.86451, 46.282991],
                        [6.782637, 46.336884],
                        [6.795665, 46.393093],
                        [6.722869, 46.407554],
                        [6.545175, 46.394727],
                        [6.390036, 46.340166],
                        [6.326998, 46.371126],
                        [6.279912, 46.351094],
                        [6.237798, 46.277334],
                        [6.295656, 46.226059],
                        [6.232072, 46.20547],
                        [6.175072, 46.15815],
                        [5.956063, 46.132089],
                        [5.832301, 46.105996],
                        [5.807622, 46.063935],
                        [5.809643, 45.9898],
                        [5.831226, 45.93846],
                        [5.862101, 45.932402],
                        [5.873427, 45.838096],
                        [5.91321, 45.804141],
                        [6.042939, 45.739096],
                        [6.166234, 45.755716],
                        [6.189714, 45.704162],
                        [6.23968, 45.685405],
                        [6.330635, 45.695531],
                        [6.383852, 45.778055],
                        [6.423672, 45.802442],
                        [6.47056, 45.884692],
                        [6.509087, 45.908633],
                        [6.552238, 45.82688],
                        [6.601733, 45.79542],
                        [6.661192, 45.798905],
                        [6.711939, 45.72292],
                        [6.802517, 45.778372],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "74", "NOM_DEPT": "HAUTE-SAVOIE"},
        },
        69: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.704364, 49.232202],
                        [1.742137, 49.180155],
                        [1.795469, 49.185259],
                        [1.885239, 49.162638],
                        [1.996823, 49.17645],
                        [2.080888, 49.209776],
                        [2.252488, 49.152882],
                        [2.310929, 49.186407],
                        [2.346257, 49.161816],
                        [2.440903, 49.145803],
                        [2.590524, 49.079655],
                        [2.633273, 49.108376],
                        [2.735013, 49.06045],
                        [3.008516, 49.09151],
                        [3.071884, 49.117554],
                        [3.139658, 49.152577],
                        [3.064088, 49.192739],
                        [3.026888, 49.275532],
                        [2.97439, 49.302339],
                        [3.095387, 49.377119],
                        [3.093783, 49.433747],
                        [3.160583, 49.45159],
                        [3.095778, 49.513403],
                        [3.13148, 49.543378],
                        [3.097776, 49.656683],
                        [3.118403, 49.705969],
                        [2.915713, 49.702672],
                        [2.793612, 49.655954],
                        [2.799495, 49.620586],
                        [2.689142, 49.625602],
                        [2.670723, 49.581412],
                        [2.571493, 49.597081],
                        [2.504749, 49.639467],
                        [2.373146, 49.656266],
                        [2.247169, 49.701641],
                        [2.12141, 49.688074],
                        [1.93321, 49.71963],
                        [1.893864, 49.698988],
                        [1.783837, 49.758308],
                        [1.689576, 49.694786],
                        [1.725205, 49.672634],
                        [1.704582, 49.605399],
                        [1.745133, 49.531738],
                        [1.719233, 49.508223],
                        [1.766345, 49.46615],
                        [1.713938, 49.409225],
                        [1.759412, 49.36815],
                        [1.775629, 49.299694],
                        [1.710479, 49.264464],
                        [1.704364, 49.232202],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "60", "NOM_DEPT": "OISE"},
        },
        70: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.608796, 49.077894],
                        [1.673689, 49.078151],
                        [1.723457, 49.044977],
                        [1.82395, 49.076361],
                        [1.937802, 49.021776],
                        [2.024773, 48.998756],
                        [2.084915, 49.014679],
                        [2.205858, 48.949741],
                        [2.200591, 48.908679],
                        [2.290974, 48.950967],
                        [2.366444, 48.974177],
                        [2.45949, 48.955046],
                        [2.553061, 49.009817],
                        [2.590524, 49.079655],
                        [2.440903, 49.145803],
                        [2.346257, 49.161816],
                        [2.310929, 49.186407],
                        [2.252488, 49.152882],
                        [2.080888, 49.209776],
                        [1.996823, 49.17645],
                        [1.885239, 49.162638],
                        [1.795469, 49.185259],
                        [1.742137, 49.180155],
                        [1.704364, 49.232202],
                        [1.675737, 49.211867],
                        [1.655777, 49.130162],
                        [1.608796, 49.077894],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "95", "NOM_DEPT": "VAL-D'OISE"},
        },
        71: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [4.106086, 47.339256],
                        [3.973085, 47.332713],
                        [3.970678, 47.378314],
                        [3.785634, 47.390542],
                        [3.714782, 47.406835],
                        [3.678991, 47.445534],
                        [3.580113, 47.464901],
                        [3.580617, 47.497863],
                        [3.513505, 47.527668],
                        [3.487879, 47.493923],
                        [3.397288, 47.508867],
                        [3.346315, 47.472438],
                        [3.307051, 47.49472],
                        [3.235477, 47.489179],
                        [3.204649, 47.522966],
                        [3.122047, 47.541049],
                        [3.101997, 47.587956],
                        [3.025638, 47.558753],
                        [2.976538, 47.569429],
                        [2.914297, 47.56597],
                        [2.874625, 47.520423],
                        [2.928902, 47.444567],
                        [2.873491, 47.348396],
                        [2.983404, 47.259763],
                        [2.981685, 47.221997],
                        [3.028085, 47.129068],
                        [3.023215, 47.062617],
                        [3.075738, 47.019145],
                        [3.07933, 46.955119],
                        [3.050294, 46.91063],
                        [3.068095, 46.877677],
                        [3.032068, 46.794911],
                        [3.049065, 46.758079],
                        [3.21555, 46.682892],
                        [3.269792, 46.716741],
                        [3.346709, 46.684416],
                        [3.434133, 46.711906],
                        [3.487153, 46.658253],
                        [3.550392, 46.715865],
                        [3.629424, 46.749459],
                        [3.73619, 46.752471],
                        [3.79733, 46.701503],
                        [3.923394, 46.738873],
                        [3.991959, 46.776751],
                        [4.06271, 46.789365],
                        [4.056234, 46.843272],
                        [4.093851, 46.874734],
                        [4.037222, 46.918156],
                        [4.039402, 46.98511],
                        [4.072015, 47.054495],
                        [4.038726, 47.08001],
                        [4.061427, 47.121042],
                        [4.115967, 47.123338],
                        [4.181888, 47.150505],
                        [4.209834, 47.155412],
                        [4.230655, 47.198951],
                        [4.178052, 47.250288],
                        [4.13548, 47.237396],
                        [4.106086, 47.339256],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "58", "NOM_DEPT": "NIEVRE"},
        },
        72: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.255236, 46.979888],
                        [5.31005, 47.018021],
                        [5.322186, 47.072982],
                        [5.386012, 47.081977],
                        [5.439973, 47.144397],
                        [5.476629, 47.216028],
                        [5.488283, 47.289347],
                        [5.518539, 47.304187],
                        [5.451398, 47.384063],
                        [5.399202, 47.499014],
                        [5.447064, 47.496254],
                        [5.496859, 47.544145],
                        [5.477547, 47.608722],
                        [5.425863, 47.632114],
                        [5.374079, 47.604542],
                        [5.239232, 47.61613],
                        [5.173597, 47.652569],
                        [5.108878, 47.649685],
                        [4.979107, 47.687763],
                        [4.94961, 47.765003],
                        [4.982401, 47.800347],
                        [4.954094, 47.866768],
                        [4.852043, 47.956239],
                        [4.786513, 47.964202],
                        [4.789084, 48.007829],
                        [4.704238, 48.020232],
                        [4.582679, 48.029464],
                        [4.559969, 47.971423],
                        [4.448998, 47.957155],
                        [4.309004, 47.961173],
                        [4.293424, 47.925676],
                        [4.261001, 47.843851],
                        [4.324394, 47.847157],
                        [4.332472, 47.756511],
                        [4.258164, 47.727403],
                        [4.268423, 47.68141],
                        [4.212381, 47.627966],
                        [4.175128, 47.553259],
                        [4.1155, 47.515009],
                        [4.119427, 47.443553],
                        [4.06606, 47.407251],
                        [4.106086, 47.339256],
                        [4.13548, 47.237396],
                        [4.178052, 47.250288],
                        [4.230655, 47.198951],
                        [4.209834, 47.155412],
                        [4.2596, 47.114326],
                        [4.405487, 47.081643],
                        [4.406283, 47.05],
                        [4.493691, 47.028372],
                        [4.62323, 46.94082],
                        [4.72813, 46.919375],
                        [5.049304, 46.981587],
                        [5.106281, 46.955765],
                        [5.255236, 46.979888],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "21", "NOM_DEPT": "COTE-D'OR"},
        },
        73: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.226559, 48.776102],
                        [2.111889, 48.73956],
                        [2.082221, 48.685852],
                        [2.020006, 48.642089],
                        [2.017574, 48.557597],
                        [1.967426, 48.533071],
                        [1.922149, 48.4576],
                        [1.930556, 48.404125],
                        [1.976578, 48.399384],
                        [1.994085, 48.286586],
                        [2.18135, 48.313745],
                        [2.369811, 48.308672],
                        [2.402664, 48.320719],
                        [2.429832, 48.362016],
                        [2.533732, 48.411251],
                        [2.50475, 48.439446],
                        [2.499525, 48.525239],
                        [2.543777, 48.60385],
                        [2.533616, 48.657331],
                        [2.57166, 48.692014],
                        [2.503537, 48.735211],
                        [2.370707, 48.720176],
                        [2.320718, 48.748756],
                        [2.226559, 48.776102],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "91", "NOM_DEPT": "ESSONNE"},
        },
        74: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [0.197354, 46.09555],
                        [0.214922, 46.138846],
                        [0.155111, 46.157168],
                        [0.112837, 46.210933],
                        [0.128837, 46.267232],
                        [0.177369, 46.328113],
                        [0.137598, 46.349395],
                        [0.078218, 46.304934],
                        [0.037602, 46.325529],
                        [0.03422, 46.373497],
                        [-0.017093, 46.411322],
                        [-0.031351, 46.524981],
                        [0.02599, 46.594744],
                        [-0.040426, 46.663717],
                        [0.000704, 46.716233],
                        [-0.020316, 46.812654],
                        [-0.009032, 46.907477],
                        [-0.087696, 47.023133],
                        [-0.102121, 47.064797],
                        [-0.18484, 47.108337],
                        [-0.241538, 47.105725],
                        [-0.40078, 47.070771],
                        [-0.49534, 47.082385],
                        [-0.559532, 47.061887],
                        [-0.565468, 47.019426],
                        [-0.619977, 46.993322],
                        [-0.713058, 46.986072],
                        [-0.773877, 47.004252],
                        [-0.89196, 46.975818],
                        [-0.829144, 46.933365],
                        [-0.781647, 46.842829],
                        [-0.700856, 46.808627],
                        [-0.727312, 46.767632],
                        [-0.656189, 46.700775],
                        [-0.644064, 46.638028],
                        [-0.614114, 46.62039],
                        [-0.602129, 46.533281],
                        [-0.612426, 46.458735],
                        [-0.640645, 46.416229],
                        [-0.5378, 46.386465],
                        [-0.55765, 46.363449],
                        [-0.750476, 46.304259],
                        [-0.751462, 46.24507],
                        [-0.690715, 46.219203],
                        [-0.619957, 46.137753],
                        [-0.546997, 46.14423],
                        [-0.506083, 46.106705],
                        [-0.400508, 46.084718],
                        [-0.281734, 46.079754],
                        [-0.102937, 45.96966],
                        [-0.041431, 45.99348],
                        [-0.031995, 46.055922],
                        [0.019273, 46.052848],
                        [0.072972, 46.093896],
                        [0.197354, 46.09555],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "79", "NOM_DEPT": "DEUX-SEVRES"},
        },
        75: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [-2.287278, 48.133746],
                        [-2.224737, 48.170597],
                        [-2.186961, 48.246379],
                        [-2.110119, 48.252903],
                        [-2.053293, 48.298328],
                        [-2.014101, 48.279532],
                        [-1.954833, 48.31711],
                        [-1.91249, 48.518841],
                        [-1.948037, 48.538808],
                        [-2.006895, 48.566113],
                        [-2.075984, 48.567679],
                        [-2.123708, 48.60441],
                        [-2.164261, 48.578893],
                        [-2.223948, 48.595387],
                        [-2.312865, 48.680923],
                        [-2.473428, 48.622517],
                        [-2.631268, 48.53813],
                        [-2.681559, 48.531133],
                        [-2.819599, 48.593528],
                        [-2.826935, 48.650569],
                        [-2.947904, 48.727215],
                        [-2.943653, 48.758338],
                        [-3.029397, 48.775914],
                        [-3.113976, 48.866738],
                        [-3.231757, 48.867416],
                        [-3.430725, 48.797223],
                        [-3.5132, 48.834999],
                        [-3.585008, 48.7755],
                        [-3.581249, 48.670018],
                        [-3.659144, 48.65921],
                        [-3.649378, 48.610153],
                        [-3.55386, 48.540921],
                        [-3.604061, 48.496439],
                        [-3.590415, 48.428923],
                        [-3.554584, 48.377767],
                        [-3.556787, 48.33552],
                        [-3.518441, 48.282273],
                        [-3.564839, 48.185747],
                        [-3.336755, 48.171125],
                        [-3.272244, 48.140015],
                        [-3.155254, 48.158491],
                        [-3.116374, 48.206364],
                        [-3.03354, 48.199361],
                        [-2.781951, 48.12058],
                        [-2.652301, 48.119325],
                        [-2.670051, 48.047884],
                        [-2.63119, 48.035479],
                        [-2.574786, 48.07041],
                        [-2.494819, 48.157845],
                        [-2.408905, 48.168611],
                        [-2.371365, 48.122103],
                        [-2.287278, 48.133746],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "22", "NOM_DEPT": "COTES-D'ARMOR"},
        },
        76: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [3.032068, 46.794911],
                        [2.959915, 46.803877],
                        [2.827616, 46.735288],
                        [2.774488, 46.718907],
                        [2.704975, 46.739387],
                        [2.596648, 46.63722],
                        [2.614955, 46.55328],
                        [2.536652, 46.5197],
                        [2.482929, 46.532697],
                        [2.352004, 46.512211],
                        [2.285758, 46.453519],
                        [2.281048, 46.420405],
                        [2.323024, 46.329279],
                        [2.391861, 46.329982],
                        [2.478941, 46.281148],
                        [2.516311, 46.23944],
                        [2.565379, 46.143032],
                        [2.640691, 46.118478],
                        [2.733052, 46.223324],
                        [2.810275, 46.196213],
                        [2.855725, 46.255486],
                        [2.937146, 46.242917],
                        [2.909593, 46.203494],
                        [2.971757, 46.12178],
                        [3.166532, 46.065678],
                        [3.371596, 46.055061],
                        [3.41903, 46.074292],
                        [3.463503, 46.017937],
                        [3.58847, 46.024138],
                        [3.694018, 45.930732],
                        [3.708884, 45.973785],
                        [3.788909, 45.973859],
                        [3.825443, 45.995968],
                        [3.806764, 46.045623],
                        [3.821869, 46.087984],
                        [3.789762, 46.154851],
                        [3.804887, 46.254857],
                        [3.899533, 46.275905],
                        [3.986626, 46.319194],
                        [3.977215, 46.399225],
                        [3.998042, 46.465468],
                        [3.957938, 46.489756],
                        [3.890471, 46.481251],
                        [3.834006, 46.531132],
                        [3.801756, 46.5199],
                        [3.743287, 46.56757],
                        [3.696952, 46.660582],
                        [3.637901, 46.707209],
                        [3.629424, 46.749459],
                        [3.550392, 46.715865],
                        [3.487153, 46.658253],
                        [3.434133, 46.711906],
                        [3.346709, 46.684416],
                        [3.269792, 46.716741],
                        [3.21555, 46.682892],
                        [3.049065, 46.758079],
                        [3.032068, 46.794911],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "03", "NOM_DEPT": "ALLIER"},
        },
        77: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [-1.342125, 46.200128],
                            [-1.4221, 46.204881],
                            [-1.514373, 46.257714],
                            [-1.535322, 46.204395],
                            [-1.461598, 46.202119],
                            [-1.354959, 46.155888],
                            [-1.342125, 46.200128],
                        ]
                    ],
                    [
                        [
                            [-1.2155, 45.90668],
                            [-1.247923, 45.990416],
                            [-1.312762, 45.992977],
                            [-1.365934, 46.027266],
                            [-1.383914, 45.951445],
                            [-1.266151, 45.878167],
                            [-1.236423, 45.804537],
                            [-1.195619, 45.829697],
                            [-1.188433, 45.886748],
                            [-1.2155, 45.90668],
                        ]
                    ],
                    [
                        [
                            [0.004331, 45.191633],
                            [-0.044168, 45.247891],
                            [-0.115385, 45.248073],
                            [-0.108786, 45.288952],
                            [-0.226702, 45.321433],
                            [-0.280896, 45.359871],
                            [-0.249759, 45.408742],
                            [-0.267424, 45.455678],
                            [-0.246156, 45.491641],
                            [-0.296715, 45.564494],
                            [-0.37592, 45.608919],
                            [-0.408929, 45.65618],
                            [-0.415839, 45.741669],
                            [-0.273119, 45.806559],
                            [-0.221745, 45.775746],
                            [-0.153095, 45.795737],
                            [-0.1154, 45.870664],
                            [-0.131664, 45.911021],
                            [-0.102937, 45.96966],
                            [-0.281734, 46.079754],
                            [-0.400508, 46.084718],
                            [-0.506083, 46.106705],
                            [-0.546997, 46.14423],
                            [-0.619957, 46.137753],
                            [-0.690715, 46.219203],
                            [-0.751462, 46.24507],
                            [-0.750476, 46.304259],
                            [-0.839878, 46.340369],
                            [-0.934889, 46.312856],
                            [-1.013807, 46.355625],
                            [-1.129404, 46.310277],
                            [-1.111164, 46.261344],
                            [-1.198998, 46.213245],
                            [-1.223875, 46.165945],
                            [-1.126411, 46.124263],
                            [-1.052687, 46.011181],
                            [-1.098949, 45.990508],
                            [-1.06432, 45.949909],
                            [-1.137161, 45.819899],
                            [-1.242574, 45.781572],
                            [-1.237228, 45.705896],
                            [-1.115849, 45.646981],
                            [-1.009631, 45.611434],
                            [-1.025742, 45.574693],
                            [-0.841057, 45.435083],
                            [-0.774018, 45.369209],
                            [-0.752682, 45.32177],
                            [-0.594481, 45.321143],
                            [-0.559507, 45.297708],
                            [-0.429195, 45.279474],
                            [-0.394072, 45.16478],
                            [-0.342338, 45.167558],
                            [-0.255087, 45.114085],
                            [-0.152953, 45.088807],
                            [-0.087703, 45.121389],
                            [-0.0402, 45.102384],
                            [0.004331, 45.191633],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "17", "NOM_DEPT": "CHARENTE-MARITIME"},
        },
        78: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [3.361343, 44.971412],
                        [3.347199, 45.014234],
                        [3.29725, 45.036078],
                        [3.325785, 45.095136],
                        [3.288033, 45.120424],
                        [3.222465, 45.271971],
                        [3.117998, 45.284187],
                        [3.103498, 45.354373],
                        [3.01671, 45.287121],
                        [2.948625, 45.309126],
                        [2.921556, 45.365775],
                        [2.852379, 45.392341],
                        [2.714857, 45.381558],
                        [2.65143, 45.442655],
                        [2.508409, 45.478499],
                        [2.487468, 45.418838],
                        [2.441861, 45.384258],
                        [2.378246, 45.414306],
                        [2.350479, 45.327558],
                        [2.271414, 45.290152],
                        [2.195361, 45.220852],
                        [2.213697, 45.160193],
                        [2.171756, 45.081496],
                        [2.095159, 45.05603],
                        [2.132979, 44.985521],
                        [2.062914, 44.976506],
                        [2.094212, 44.872011],
                        [2.171636, 44.790024],
                        [2.153492, 44.753108],
                        [2.169418, 44.638066],
                        [2.207475, 44.615532],
                        [2.208414, 44.643844],
                        [2.326786, 44.669692],
                        [2.435003, 44.638878],
                        [2.556124, 44.721285],
                        [2.562709, 44.775753],
                        [2.599358, 44.792809],
                        [2.602681, 44.843168],
                        [2.706435, 44.907226],
                        [2.738254, 44.941222],
                        [2.801955, 44.873629],
                        [2.849658, 44.871489],
                        [2.879572, 44.803011],
                        [2.934522, 44.779198],
                        [2.923264, 44.728639],
                        [2.981677, 44.644677],
                        [3.061526, 44.817176],
                        [3.099477, 44.833588],
                        [3.105498, 44.886775],
                        [3.182312, 44.863735],
                        [3.249693, 44.916238],
                        [3.361343, 44.971412],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "15", "NOM_DEPT": "CANTAL"},
        },
        79: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.565787, 43.42296],
                        [2.539962, 43.346222],
                        [2.601603, 43.298707],
                        [2.772248, 43.257786],
                        [2.832762, 43.322413],
                        [3.004349, 43.320131],
                        [3.004741, 43.288538],
                        [3.147208, 43.247005],
                        [3.201027, 43.249167],
                        [3.240561, 43.212809],
                        [3.343863, 43.270396],
                        [3.430332, 43.29021],
                        [3.510954, 43.273333],
                        [3.602619, 43.355427],
                        [3.662159, 43.392279],
                        [3.796664, 43.441036],
                        [3.907134, 43.516844],
                        [4.011185, 43.552447],
                        [4.101042, 43.554371],
                        [4.150216, 43.585562],
                        [4.194441, 43.654304],
                        [4.144781, 43.733887],
                        [4.002046, 43.811464],
                        [3.917385, 43.885593],
                        [3.830797, 43.866424],
                        [3.824905, 43.919298],
                        [3.787325, 43.96687],
                        [3.72699, 43.969016],
                        [3.623589, 43.916979],
                        [3.575448, 43.865522],
                        [3.530701, 43.855625],
                        [3.424448, 43.911598],
                        [3.358359, 43.913833],
                        [3.275075, 43.898352],
                        [3.203112, 43.813873],
                        [3.059856, 43.831647],
                        [3.060741, 43.693077],
                        [2.98535, 43.708516],
                        [2.935463, 43.694668],
                        [2.915982, 43.660021],
                        [2.754524, 43.614139],
                        [2.711169, 43.645597],
                        [2.643264, 43.650146],
                        [2.615607, 43.566633],
                        [2.658651, 43.525794],
                        [2.65954, 43.480164],
                        [2.606081, 43.431094],
                        [2.565787, 43.42296],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "34", "NOM_DEPT": "HERAULT"},
        },
        80: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.80147, 44.706779],
                        [5.759044, 44.69607],
                        [5.627085, 44.752464],
                        [5.464159, 44.792427],
                        [5.483647, 44.922291],
                        [5.483609, 45.022786],
                        [5.449789, 45.070784],
                        [5.388383, 45.036139],
                        [5.179385, 45.08331],
                        [5.188574, 45.171269],
                        [5.176541, 45.248402],
                        [5.121426, 45.248336],
                        [5.054319, 45.319055],
                        [4.989191, 45.344047],
                        [4.880238, 45.297454],
                        [4.800494, 45.298361],
                        [4.812474, 45.164482],
                        [4.837673, 45.004792],
                        [4.886589, 44.936652],
                        [4.822513, 44.817088],
                        [4.766216, 44.778627],
                        [4.77906, 44.654699],
                        [4.710266, 44.581549],
                        [4.69364, 44.542231],
                        [4.698652, 44.452309],
                        [4.667367, 44.430664],
                        [4.650615, 44.329806],
                        [4.762251, 44.325382],
                        [4.802877, 44.296596],
                        [4.814084, 44.232315],
                        [5.060565, 44.30814],
                        [5.149727, 44.282084],
                        [5.154904, 44.230945],
                        [5.384523, 44.201047],
                        [5.383241, 44.155285],
                        [5.435756, 44.152249],
                        [5.498788, 44.115719],
                        [5.543986, 44.136391],
                        [5.576187, 44.188042],
                        [5.639594, 44.167586],
                        [5.676037, 44.191433],
                        [5.686555, 44.266918],
                        [5.646781, 44.267091],
                        [5.631598, 44.328303],
                        [5.493072, 44.337178],
                        [5.418531, 44.424947],
                        [5.513341, 44.491131],
                        [5.603639, 44.465545],
                        [5.630799, 44.531598],
                        [5.597249, 44.543274],
                        [5.649631, 44.617881],
                        [5.79062, 44.65329],
                        [5.80147, 44.706779],
                    ],
                    [
                        [4.89291, 44.364818],
                        [4.918515, 44.407785],
                        [4.970436, 44.43137],
                        [5.015759, 44.392766],
                        [5.013377, 44.32614],
                        [4.978583, 44.297463],
                        [4.88953, 44.304153],
                        [4.89291, 44.364818],
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "26", "NOM_DEPT": "DROME"},
        },
        81: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.786125, 42.573623],
                        [1.749882, 42.563585],
                        [1.729888, 42.495326],
                        [1.834623, 42.481786],
                        [1.958284, 42.424049],
                        [1.985907, 42.362048],
                        [2.083598, 42.3627],
                        [2.156342, 42.423427],
                        [2.2578, 42.438358],
                        [2.435482, 42.388877],
                        [2.482963, 42.339647],
                        [2.540034, 42.333752],
                        [2.577825, 42.357933],
                        [2.671765, 42.341178],
                        [2.675046, 42.404968],
                        [2.7532, 42.425357],
                        [2.799242, 42.418569],
                        [2.841411, 42.458523],
                        [3.040762, 42.473141],
                        [3.085437, 42.42551],
                        [3.17322, 42.434877],
                        [3.133585, 42.512941],
                        [3.049606, 42.55014],
                        [3.035422, 42.678248],
                        [3.043499, 42.83815],
                        [2.917115, 42.88486],
                        [2.865274, 42.918341],
                        [2.789054, 42.895989],
                        [2.74, 42.837574],
                        [2.697578, 42.830431],
                        [2.509012, 42.849832],
                        [2.452475, 42.836933],
                        [2.327116, 42.837443],
                        [2.357535, 42.734122],
                        [2.322006, 42.707792],
                        [2.166054, 42.663918],
                        [2.000515, 42.661565],
                        [1.97176, 42.61692],
                        [1.874485, 42.581406],
                        [1.786125, 42.573623],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "66", "NOM_DEPT": "PYRENEES-ORIENTALES"},
        },
        82: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [6.260566, 45.126848],
                        [6.362923, 45.104494],
                        [6.393915, 45.061819],
                        [6.486235, 45.056073],
                        [6.481254, 45.094136],
                        [6.629987, 45.109327],
                        [6.680067, 45.140125],
                        [6.767935, 45.159744],
                        [6.849859, 45.127161],
                        [6.968757, 45.208061],
                        [7.13759, 45.255695],
                        [7.110695, 45.326512],
                        [7.184275, 45.407481],
                        [7.113516, 45.434195],
                        [7.099789, 45.469439],
                        [7.000332, 45.504417],
                        [7.000691, 45.639902],
                        [6.934609, 45.647092],
                        [6.829115, 45.702833],
                        [6.802517, 45.778372],
                        [6.711939, 45.72292],
                        [6.661192, 45.798905],
                        [6.601733, 45.79542],
                        [6.552238, 45.82688],
                        [6.509087, 45.908633],
                        [6.47056, 45.884692],
                        [6.423672, 45.802442],
                        [6.383852, 45.778055],
                        [6.330635, 45.695531],
                        [6.23968, 45.685405],
                        [6.189714, 45.704162],
                        [6.166234, 45.755716],
                        [6.042939, 45.739096],
                        [5.91321, 45.804141],
                        [5.873427, 45.838096],
                        [5.862101, 45.932402],
                        [5.831226, 45.93846],
                        [5.786856, 45.822956],
                        [5.776161, 45.729222],
                        [5.704119, 45.710926],
                        [5.689187, 45.648502],
                        [5.623748, 45.613268],
                        [5.736372, 45.47254],
                        [5.782081, 45.440655],
                        [5.879738, 45.406797],
                        [5.96617, 45.492309],
                        [6.049754, 45.43792],
                        [6.121272, 45.438898],
                        [6.177451, 45.393161],
                        [6.18445, 45.317949],
                        [6.131945, 45.288287],
                        [6.125696, 45.24427],
                        [6.189208, 45.163732],
                        [6.260566, 45.126848],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "73", "NOM_DEPT": "SAVOIE"},
        },
        83: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.80147, 44.706779],
                        [5.79062, 44.65329],
                        [5.649631, 44.617881],
                        [5.597249, 44.543274],
                        [5.630799, 44.531598],
                        [5.603639, 44.465545],
                        [5.513341, 44.491131],
                        [5.418531, 44.424947],
                        [5.493072, 44.337178],
                        [5.631598, 44.328303],
                        [5.646781, 44.267091],
                        [5.686555, 44.266918],
                        [5.676037, 44.191433],
                        [5.755494, 44.210208],
                        [5.881794, 44.210999],
                        [5.823912, 44.278902],
                        [5.912323, 44.271532],
                        [5.95367, 44.395059],
                        [6.071139, 44.450536],
                        [6.155615, 44.46196],
                        [6.228222, 44.3817],
                        [6.262482, 44.41225],
                        [6.233718, 44.463831],
                        [6.362, 44.522073],
                        [6.413885, 44.46929],
                        [6.562445, 44.445493],
                        [6.632376, 44.447129],
                        [6.684305, 44.5413],
                        [6.772207, 44.588909],
                        [6.839802, 44.608589],
                        [6.914488, 44.659499],
                        [6.948335, 44.654816],
                        [6.987055, 44.690141],
                        [7.077109, 44.680918],
                        [6.999571, 44.789445],
                        [7.006774, 44.839316],
                        [6.933687, 44.862026],
                        [6.859863, 44.852901],
                        [6.749746, 44.907361],
                        [6.763456, 44.97122],
                        [6.740807, 45.016729],
                        [6.673884, 45.019618],
                        [6.629987, 45.109327],
                        [6.481254, 45.094136],
                        [6.486235, 45.056073],
                        [6.393915, 45.061819],
                        [6.362923, 45.104494],
                        [6.260566, 45.126848],
                        [6.229388, 45.10875],
                        [6.203927, 45.012469],
                        [6.318198, 45.003857],
                        [6.35884, 44.941284],
                        [6.355361, 44.854779],
                        [6.302847, 44.87326],
                        [6.250544, 44.852655],
                        [6.136224, 44.864073],
                        [6.056343, 44.815908],
                        [6.030211, 44.838096],
                        [5.949519, 44.80453],
                        [5.915233, 44.754706],
                        [5.850399, 44.750745],
                        [5.80147, 44.706779],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "05", "NOM_DEPT": "HAUTES-ALPES"},
        },
        84: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [4.89291, 44.364818],
                            [4.88953, 44.304153],
                            [4.978583, 44.297463],
                            [5.013377, 44.32614],
                            [5.015759, 44.392766],
                            [4.970436, 44.43137],
                            [4.918515, 44.407785],
                            [4.89291, 44.364818],
                        ]
                    ],
                    [
                        [
                            [4.739061, 43.924059],
                            [4.853094, 43.911382],
                            [4.966309, 43.871647],
                            [5.029533, 43.827793],
                            [5.05149, 43.787882],
                            [5.187972, 43.735103],
                            [5.22999, 43.747673],
                            [5.318503, 43.735021],
                            [5.439246, 43.681104],
                            [5.531453, 43.659011],
                            [5.606944, 43.658686],
                            [5.753638, 43.724623],
                            [5.757333, 43.729409],
                            [5.654445, 43.825111],
                            [5.57819, 43.829921],
                            [5.607127, 43.913773],
                            [5.51209, 43.946002],
                            [5.543657, 44.028708],
                            [5.502637, 44.063439],
                            [5.498788, 44.115719],
                            [5.435756, 44.152249],
                            [5.383241, 44.155285],
                            [5.384523, 44.201047],
                            [5.154904, 44.230945],
                            [5.149727, 44.282084],
                            [5.060565, 44.30814],
                            [4.814084, 44.232315],
                            [4.802877, 44.296596],
                            [4.762251, 44.325382],
                            [4.650615, 44.329806],
                            [4.649224, 44.27036],
                            [4.722075, 44.187422],
                            [4.707458, 44.103672],
                            [4.787978, 44.065054],
                            [4.842094, 43.986475],
                            [4.739061, 43.924059],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "84", "NOM_DEPT": "VAUCLUSE"},
        },
        85: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.167786, 46.424067],
                        [2.151672, 46.45796],
                        [2.204397, 46.4844],
                        [2.1587, 46.557346],
                        [2.185629, 46.602862],
                        [2.140724, 46.695554],
                        [2.065751, 46.742495],
                        [2.115361, 46.774359],
                        [2.04881, 46.829448],
                        [2.126204, 46.879865],
                        [2.070699, 46.933996],
                        [2.093384, 47.015736],
                        [2.051488, 47.040016],
                        [2.048375, 47.106016],
                        [1.966414, 47.125418],
                        [1.882722, 47.10195],
                        [1.774581, 47.130847],
                        [1.842109, 47.178029],
                        [1.839079, 47.219308],
                        [1.705831, 47.265878],
                        [1.592428, 47.276677],
                        [1.448462, 47.237968],
                        [1.326666, 47.186225],
                        [1.365361, 47.122051],
                        [1.311673, 47.096975],
                        [1.273057, 47.037834],
                        [1.161422, 47.039623],
                        [1.077615, 47.015842],
                        [1.049878, 46.98064],
                        [0.988813, 46.761541],
                        [0.867469, 46.748219],
                        [0.924756, 46.692793],
                        [0.894302, 46.625737],
                        [0.942024, 46.580792],
                        [1.014764, 46.567764],
                        [1.145935, 46.506402],
                        [1.151605, 46.449236],
                        [1.21269, 46.432222],
                        [1.17728, 46.383952],
                        [1.303057, 46.370995],
                        [1.356023, 46.400123],
                        [1.415191, 46.347218],
                        [1.522307, 46.426525],
                        [1.644846, 46.386816],
                        [1.727711, 46.388959],
                        [1.8195, 46.430038],
                        [1.993082, 46.430917],
                        [2.088942, 46.408903],
                        [2.167786, 46.424067],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "36", "NOM_DEPT": "INDRE"},
        },
        86: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [9.402268, 41.858698],
                        [9.412574, 41.952475],
                        [9.549983, 42.104164],
                        [9.558834, 42.285263],
                        [9.53267, 42.379967],
                        [9.543397, 42.42849],
                        [9.533193, 42.545944],
                        [9.449196, 42.662236],
                        [9.446381, 42.686122],
                        [9.492379, 42.805103],
                        [9.473063, 42.874132],
                        [9.463554, 42.986403],
                        [9.421761, 43.011723],
                        [9.34087, 42.994461],
                        [9.353823, 42.916239],
                        [9.31102, 42.83468],
                        [9.34256, 42.794801],
                        [9.344475, 42.737812],
                        [9.293322, 42.674316],
                        [9.254452, 42.718512],
                        [9.166883, 42.736561],
                        [9.085758, 42.714607],
                        [9.02069, 42.644271],
                        [8.886524, 42.628971],
                        [8.808933, 42.599056],
                        [8.804095, 42.56986],
                        [8.666505, 42.515224],
                        [8.655224, 42.415736],
                        [8.608422, 42.416825],
                        [8.573411, 42.381406],
                        [8.640802, 42.373436],
                        [8.819561, 42.317558],
                        [8.904767, 42.253859],
                        [9.045659, 42.206923],
                        [9.072187, 42.130214],
                        [9.119729, 42.107774],
                        [9.160818, 42.026017],
                        [9.221084, 42.027597],
                        [9.227497, 41.855589],
                        [9.329201, 41.836815],
                        [9.402268, 41.858698],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "2B", "NOM_DEPT": "HAUTE-CORSE"},
        },
        87: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1.253152, 45.444219],
                        [1.287057, 45.489938],
                        [1.350078, 45.466888],
                        [1.412059, 45.528081],
                        [1.48037, 45.565943],
                        [1.557196, 45.549366],
                        [1.637663, 45.580352],
                        [1.783868, 45.680363],
                        [1.871348, 45.664658],
                        [1.898731, 45.698278],
                        [1.87514, 45.73278],
                        [1.880899, 45.797715],
                        [1.772749, 45.842828],
                        [1.676637, 45.835114],
                        [1.602398, 45.857465],
                        [1.60872, 45.933412],
                        [1.5325, 45.952804],
                        [1.549176, 46.03541],
                        [1.452795, 46.179755],
                        [1.3749, 46.215451],
                        [1.44377, 46.305894],
                        [1.415191, 46.347218],
                        [1.356023, 46.400123],
                        [1.303057, 46.370995],
                        [1.17728, 46.383952],
                        [1.129758, 46.360466],
                        [1.026995, 46.343034],
                        [1.005887, 46.280974],
                        [0.907272, 46.285257],
                        [0.796326, 46.210963],
                        [0.823434, 46.128582],
                        [0.81791, 46.047878],
                        [0.925625, 46.010454],
                        [0.942592, 45.957436],
                        [0.862906, 45.919755],
                        [0.782232, 45.821082],
                        [0.71644, 45.805618],
                        [0.714888, 45.76312],
                        [0.629742, 45.71457],
                        [0.775843, 45.66757],
                        [0.75153, 45.618324],
                        [0.8115, 45.575871],
                        [0.934552, 45.611582],
                        [1.035849, 45.600209],
                        [1.119784, 45.487783],
                        [1.253152, 45.444219],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "87", "NOM_DEPT": "HAUTE-VIENNE"},
        },
        88: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [-2.301813, 46.989743],
                            [-2.26438, 46.960878],
                            [-2.218334, 47.007819],
                            [-2.287231, 47.024621],
                            [-2.301813, 46.989743],
                        ]
                    ],
                    [
                        [
                            [-1.980414, 47.028906],
                            [-2.027355, 47.009918],
                            [-2.062741, 46.948067],
                            [-2.153827, 46.89015],
                            [-2.144508, 46.826396],
                            [-1.942881, 46.692705],
                            [-1.856018, 46.608578],
                            [-1.81235, 46.493418],
                            [-1.777142, 46.492758],
                            [-1.627061, 46.414222],
                            [-1.502145, 46.39735],
                            [-1.465942, 46.342359],
                            [-1.366743, 46.348613],
                            [-1.207394, 46.266572],
                            [-1.201088, 46.316347],
                            [-1.129404, 46.310277],
                            [-1.013807, 46.355625],
                            [-0.934889, 46.312856],
                            [-0.839878, 46.340369],
                            [-0.750476, 46.304259],
                            [-0.55765, 46.363449],
                            [-0.5378, 46.386465],
                            [-0.640645, 46.416229],
                            [-0.612426, 46.458735],
                            [-0.602129, 46.533281],
                            [-0.614114, 46.62039],
                            [-0.644064, 46.638028],
                            [-0.656189, 46.700775],
                            [-0.727312, 46.767632],
                            [-0.700856, 46.808627],
                            [-0.781647, 46.842829],
                            [-0.829144, 46.933365],
                            [-0.89196, 46.975818],
                            [-0.93346, 47.008908],
                            [-1.055403, 47.005685],
                            [-1.14857, 47.029545],
                            [-1.271207, 47.083893],
                            [-1.294635, 47.039483],
                            [-1.378612, 47.030854],
                            [-1.372986, 46.952184],
                            [-1.456132, 46.926273],
                            [-1.482131, 47.037862],
                            [-1.552322, 47.018349],
                            [-1.553564, 46.981505],
                            [-1.500767, 46.883891],
                            [-1.548511, 46.86008],
                            [-1.689761, 46.890493],
                            [-1.751062, 46.929596],
                            [-1.830982, 46.932034],
                            [-1.943228, 46.994711],
                            [-1.980414, 47.028906],
                        ]
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "85", "NOM_DEPT": "VENDEE"},
        },
        89: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [5.671875, 43.179269],
                        [5.69488, 43.143588],
                        [5.81273, 43.109365],
                        [5.804565, 43.078285],
                        [5.85745, 43.046619],
                        [5.941246, 43.10766],
                        [6.03144, 43.077473],
                        [6.124046, 43.079308],
                        [6.183994, 43.108535],
                        [6.265297, 43.121045],
                        [6.368261, 43.089913],
                        [6.387573, 43.144898],
                        [6.493498, 43.150223],
                        [6.559636, 43.18863],
                        [6.635531, 43.17251],
                        [6.659332, 43.195927],
                        [6.677312, 43.278792],
                        [6.665953, 43.318216],
                        [6.739811, 43.412881],
                        [6.859478, 43.418164],
                        [6.933726, 43.480068],
                        [6.88423, 43.502536],
                        [6.908013, 43.599079],
                        [6.798741, 43.62818],
                        [6.760801, 43.666488],
                        [6.753536, 43.738167],
                        [6.636396, 43.788951],
                        [6.524762, 43.806366],
                        [6.414428, 43.791594],
                        [6.413483, 43.76036],
                        [6.356961, 43.736368],
                        [6.21671, 43.799512],
                        [6.182886, 43.762176],
                        [6.036132, 43.694163],
                        [5.901207, 43.732585],
                        [5.781343, 43.755657],
                        [5.757333, 43.729409],
                        [5.753638, 43.724623],
                        [5.813244, 43.688964],
                        [5.799061, 43.660518],
                        [5.700215, 43.641716],
                        [5.682145, 43.613732],
                        [5.72461, 43.550898],
                        [5.698803, 43.48217],
                        [5.751847, 43.434295],
                        [5.682787, 43.399157],
                        [5.760929, 43.267338],
                        [5.683909, 43.236058],
                        [5.671875, 43.179269],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "83", "NOM_DEPT": "VAR"},
        },
        90: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.59228, 48.807437],
                        [2.495647, 48.86085],
                        [2.41634, 48.849238],
                        [2.331895, 48.817013],
                        [2.320718, 48.748756],
                        [2.370707, 48.720176],
                        [2.503537, 48.735211],
                        [2.57166, 48.692014],
                        [2.613648, 48.761027],
                        [2.59228, 48.807437],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "94", "NOM_DEPT": "VAL-DE-MARNE"},
        },
        91: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.331895, 48.817013],
                        [2.255143, 48.834808],
                        [2.231736, 48.869069],
                        [2.319884, 48.900459],
                        [2.290974, 48.950967],
                        [2.200591, 48.908679],
                        [2.152869, 48.87334],
                        [2.151578, 48.81702],
                        [2.226559, 48.776102],
                        [2.320718, 48.748756],
                        [2.331895, 48.817013],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "92", "NOM_DEPT": "HAUTS-DE-SEINE"},
        },
        92: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.981677, 44.644677],
                        [3.083594, 44.559014],
                        [3.068543, 44.50349],
                        [3.135736, 44.45487],
                        [3.119711, 44.383378],
                        [3.154252, 44.30837],
                        [3.125229, 44.284464],
                        [3.229848, 44.226255],
                        [3.3578, 44.19791],
                        [3.373648, 44.170756],
                        [3.43973, 44.129098],
                        [3.633491, 44.122695],
                        [3.637769, 44.175488],
                        [3.678641, 44.182759],
                        [3.796995, 44.127389],
                        [3.862105, 44.130074],
                        [3.952604, 44.170794],
                        [3.951317, 44.247795],
                        [3.922859, 44.305218],
                        [3.952331, 44.32839],
                        [3.885918, 44.387999],
                        [3.944362, 44.399568],
                        [3.998163, 44.459798],
                        [3.945149, 44.573791],
                        [3.905172, 44.592708],
                        [3.862527, 44.743863],
                        [3.740651, 44.838697],
                        [3.666365, 44.828778],
                        [3.659522, 44.869939],
                        [3.594336, 44.87543],
                        [3.589349, 44.832194],
                        [3.475774, 44.815372],
                        [3.417971, 44.900768],
                        [3.412835, 44.944843],
                        [3.361343, 44.971412],
                        [3.249693, 44.916238],
                        [3.182312, 44.863735],
                        [3.105498, 44.886775],
                        [3.099477, 44.833588],
                        [3.061526, 44.817176],
                        [2.981677, 44.644677],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "48", "NOM_DEPT": "LOZERE"},
        },
        93: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [4.230283, 43.460185],
                        [4.55492, 43.446215],
                        [4.588099, 43.422707],
                        [4.5628, 43.372137],
                        [4.661783, 43.346412],
                        [4.759589, 43.349941],
                        [4.855049, 43.332617],
                        [4.86685, 43.404682],
                        [4.967706, 43.426105],
                        [5.041039, 43.327287],
                        [5.240587, 43.331714],
                        [5.31103, 43.360876],
                        [5.362055, 43.321957],
                        [5.345688, 43.282363],
                        [5.363644, 43.207125],
                        [5.536932, 43.214494],
                        [5.60089, 43.162546],
                        [5.671875, 43.179269],
                        [5.683909, 43.236058],
                        [5.760929, 43.267338],
                        [5.682787, 43.399157],
                        [5.751847, 43.434295],
                        [5.698803, 43.48217],
                        [5.72461, 43.550898],
                        [5.682145, 43.613732],
                        [5.700215, 43.641716],
                        [5.799061, 43.660518],
                        [5.813244, 43.688964],
                        [5.753638, 43.724623],
                        [5.606944, 43.658686],
                        [5.531453, 43.659011],
                        [5.439246, 43.681104],
                        [5.318503, 43.735021],
                        [5.22999, 43.747673],
                        [5.187972, 43.735103],
                        [5.05149, 43.787882],
                        [5.029533, 43.827793],
                        [4.966309, 43.871647],
                        [4.853094, 43.911382],
                        [4.739061, 43.924059],
                        [4.64191, 43.867478],
                        [4.654821, 43.806409],
                        [4.593032, 43.687462],
                        [4.487237, 43.699238],
                        [4.427028, 43.620678],
                        [4.40935, 43.561128],
                        [4.238106, 43.497627],
                        [4.230283, 43.460185],
                    ],
                    [
                        [5.096382, 43.401408],
                        [5.05957, 43.403977],
                        [5.051881, 43.463557],
                        [5.006007, 43.469662],
                        [5.015465, 43.529723],
                        [5.108666, 43.525495],
                        [5.157538, 43.409584],
                        [5.096382, 43.401408],
                    ],
                ],
            },
            "attributes": {"CODE_DEPT": "13", "NOM_DEPT": "BOUCHES-DU-RHONE"},
        },
        94: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.331895, 48.817013],
                        [2.41634, 48.849238],
                        [2.385151, 48.902008],
                        [2.319884, 48.900459],
                        [2.231736, 48.869069],
                        [2.255143, 48.834808],
                        [2.331895, 48.817013],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "75", "NOM_DEPT": "PARIS"},
        },
        95: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [2.59228, 48.807437],
                        [2.562622, 48.888884],
                        [2.602598, 48.929357],
                        [2.553061, 49.009817],
                        [2.45949, 48.955046],
                        [2.366444, 48.974177],
                        [2.290974, 48.950967],
                        [2.319884, 48.900459],
                        [2.385151, 48.902008],
                        [2.41634, 48.849238],
                        [2.495647, 48.86085],
                        [2.59228, 48.807437],
                    ]
                ],
            },
            "attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"},
        },
    },
}

geolayer_fr_dept_geometry_only = {
    "metadata": metadata_fr_dept_geometry_only,
    "features": {
        0: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [505760.0, 6248691.0],
                        [509767.0, 6249274.0],
                        [514960.0, 6255730.0],
                        [523428.0, 6259977.0],
                        [531230.0, 6258583.0],
                        [536034.0, 6253601.0],
                        [539594.0, 6265818.0],
                        [554723.0, 6278961.0],
                        [550482.0, 6283435.0],
                        [545681.0, 6284750.0],
                        [535303.0, 6300840.0],
                        [531445.0, 6300603.0],
                        [531142.0, 6309545.0],
                        [528381.0, 6316132.0],
                        [520187.0, 6318466.0],
                        [528536.0, 6329188.0],
                        [521740.0, 6328834.0],
                        [519117.0, 6332164.0],
                        [512956.0, 6327891.0],
                        [507637.0, 6333951.0],
                        [502833.0, 6331375.0],
                        [496470.0, 6331745.0],
                        [495008.0, 6328849.0],
                        [483787.0, 6325253.0],
                        [474692.0, 6327970.0],
                        [465465.0, 6324803.0],
                        [465239.0, 6317398.0],
                        [461632.0, 6315722.0],
                        [453303.0, 6321029.0],
                        [444807.0, 6320573.0],
                        [440195.0, 6315550.0],
                        [443572.0, 6313646.0],
                        [442698.0, 6298315.0],
                        [439499.0, 6295895.0],
                        [438084.0, 6281592.0],
                        [443497.0, 6282643.0],
                        [449863.0, 6280833.0],
                        [456497.0, 6283051.0],
                        [457450.0, 6278664.0],
                        [461941.0, 6273297.0],
                        [466465.0, 6272970.0],
                        [468215.0, 6263513.0],
                        [471536.0, 6256527.0],
                        [479309.0, 6257879.0],
                        [496988.0, 6250664.0],
                        [505760.0, 6248691.0],
                    ]
                ],
                "bbox": (438084.0, 6248691.0, 554723.0, 6333951.0),
            }
        },
        1: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [547193.0, 6388334.0],
                        [539761.0, 6395885.0],
                        [530971.0, 6390971.0],
                        [526858.0, 6394383.0],
                        [527849.0, 6401566.0],
                        [514373.0, 6400391.0],
                        [512334.0, 6403639.0],
                        [495031.0, 6397493.0],
                        [491196.0, 6399384.0],
                        [489091.0, 6407815.0],
                        [486169.0, 6410676.0],
                        [474628.0, 6407547.0],
                        [472909.0, 6402270.0],
                        [476701.0, 6399758.0],
                        [474218.0, 6394851.0],
                        [464993.0, 6388179.0],
                        [460343.0, 6383021.0],
                        [460366.0, 6373402.0],
                        [462536.0, 6370133.0],
                        [454032.0, 6364649.0],
                        [457916.0, 6359953.0],
                        [455164.0, 6354504.0],
                        [449164.0, 6352477.0],
                        [449759.0, 6344226.0],
                        [459734.0, 6343570.0],
                        [462757.0, 6341305.0],
                        [470769.0, 6340294.0],
                        [467874.0, 6336236.0],
                        [464468.0, 6326808.0],
                        [465465.0, 6324803.0],
                        [474692.0, 6327970.0],
                        [483787.0, 6325253.0],
                        [495008.0, 6328849.0],
                        [496470.0, 6331745.0],
                        [502833.0, 6331375.0],
                        [507637.0, 6333951.0],
                        [512956.0, 6327891.0],
                        [519117.0, 6332164.0],
                        [520115.0, 6336256.0],
                        [529462.0, 6338671.0],
                        [533815.0, 6350996.0],
                        [536387.0, 6355171.0],
                        [530427.0, 6360537.0],
                        [531660.0, 6365290.0],
                        [544593.0, 6364542.0],
                        [545774.0, 6366277.0],
                        [541673.0, 6377661.0],
                        [542159.0, 6383881.0],
                        [547193.0, 6388334.0],
                    ]
                ],
                "bbox": (449164.0, 6324803.0, 547193.0, 6410676.0),
            }
        },
        2: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [841110.0, 6468164.0],
                        [847361.0, 6468209.0],
                        [855768.0, 6473591.0],
                        [860939.0, 6470947.0],
                        [866406.0, 6463235.0],
                        [870728.0, 6463360.0],
                        [871909.0, 6454823.0],
                        [871457.0, 6445038.0],
                        [888053.0, 6440277.0],
                        [892767.0, 6444271.0],
                        [895595.0, 6439026.0],
                        [895949.0, 6427870.0],
                        [894862.0, 6413405.0],
                        [907889.0, 6409384.0],
                        [918546.0, 6403480.0],
                        [921863.0, 6404787.0],
                        [925560.0, 6409806.0],
                        [930672.0, 6410433.0],
                        [933177.0, 6416064.0],
                        [939410.0, 6420031.0],
                        [941569.0, 6417648.0],
                        [947667.0, 6423241.0],
                        [956742.0, 6422339.0],
                        [960775.0, 6424797.0],
                        [965006.0, 6422921.0],
                        [964872.0, 6432532.0],
                        [961377.0, 6439340.0],
                        [952342.0, 6439924.0],
                        [953909.0, 6450690.0],
                        [956276.0, 6452799.0],
                        [950505.0, 6456663.0],
                        [945165.0, 6465401.0],
                        [945461.0, 6470305.0],
                        [949441.0, 6473761.0],
                        [948557.0, 6482085.0],
                        [943964.0, 6486985.0],
                        [938381.0, 6486658.0],
                        [931624.0, 6492445.0],
                        [925224.0, 6482705.0],
                        [917457.0, 6486189.0],
                        [913763.0, 6489603.0],
                        [904449.0, 6504924.0],
                        [897998.0, 6515860.0],
                        [888123.0, 6525941.0],
                        [888996.0, 6528631.0],
                        [882529.0, 6534232.0],
                        [879159.0, 6530984.0],
                        [876089.0, 6523611.0],
                        [870291.0, 6521483.0],
                        [863140.0, 6525920.0],
                        [862850.0, 6517700.0],
                        [865784.0, 6514252.0],
                        [858527.0, 6506228.0],
                        [848198.0, 6502534.0],
                        [841056.0, 6498593.0],
                        [845846.0, 6493277.0],
                        [837308.0, 6485557.0],
                        [837457.0, 6475559.0],
                        [841110.0, 6468164.0],
                    ]
                ],
                "bbox": (837308.0, 6403480.0, 965006.0, 6534232.0),
            }
        },
        3: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [634422.0, 7101577.0],
                        [623701.0, 7099214.0],
                        [610465.0, 7094261.0],
                        [605814.0, 7089013.0],
                        [599885.0, 7086576.0],
                        [601399.0, 7078135.0],
                        [598139.0, 7067917.0],
                        [599563.0, 7049801.0],
                        [597332.0, 7035063.0],
                        [603193.0, 7029103.0],
                        [605232.0, 7026713.0],
                        [612989.0, 7030025.0],
                        [622831.0, 7024302.0],
                        [624801.0, 7021563.0],
                        [634147.0, 7017146.0],
                        [635372.0, 7012312.0],
                        [648121.0, 7014552.0],
                        [654991.0, 7012592.0],
                        [660837.0, 7014835.0],
                        [663948.0, 7010834.0],
                        [656343.0, 7006536.0],
                        [658067.0, 7000416.0],
                        [662547.0, 7004433.0],
                        [667892.0, 7004913.0],
                        [669642.0, 7001764.0],
                        [689814.0, 6997681.0],
                        [691147.0, 6993758.0],
                        [706470.0, 6995042.0],
                        [706855.0, 7002888.0],
                        [711164.0, 7009522.0],
                        [712383.0, 7015916.0],
                        [699507.0, 7031355.0],
                        [702680.0, 7038239.0],
                        [701478.0, 7042709.0],
                        [697493.0, 7046164.0],
                        [692820.0, 7044918.0],
                        [687641.0, 7047582.0],
                        [686184.0, 7056263.0],
                        [688698.0, 7062196.0],
                        [683642.0, 7063001.0],
                        [679720.0, 7059405.0],
                        [673807.0, 7057943.0],
                        [664277.0, 7059477.0],
                        [658064.0, 7064147.0],
                        [653390.0, 7071778.0],
                        [644454.0, 7079622.0],
                        [642453.0, 7087769.0],
                        [636514.0, 7100652.0],
                        [634422.0, 7101577.0],
                    ]
                ],
                "bbox": (597332.0, 6993758.0, 712383.0, 7101577.0),
            }
        },
        4: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [776081.0, 6923412.0],
                        [782994.0, 6923346.0],
                        [790665.0, 6921022.0],
                        [795010.0, 6915033.0],
                        [803525.0, 6909934.0],
                        [814643.0, 6911926.0],
                        [818364.0, 6905215.0],
                        [822754.0, 6907655.0],
                        [833062.0, 6905548.0],
                        [837898.0, 6908256.0],
                        [842092.0, 6905887.0],
                        [849280.0, 6910207.0],
                        [847303.0, 6917040.0],
                        [853548.0, 6926776.0],
                        [849442.0, 6935263.0],
                        [853210.0, 6945817.0],
                        [856532.0, 6942619.0],
                        [867310.0, 6942452.0],
                        [873032.0, 6949057.0],
                        [869864.0, 6950495.0],
                        [863792.0, 6957578.0],
                        [856370.0, 6957018.0],
                        [850915.0, 6964755.0],
                        [848735.0, 6964497.0],
                        [834935.0, 6970707.0],
                        [833403.0, 6975569.0],
                        [835414.0, 6979112.0],
                        [832902.0, 6984653.0],
                        [828614.0, 6985882.0],
                        [833821.0, 7001508.0],
                        [834466.0, 7007583.0],
                        [830491.0, 7008459.0],
                        [826108.0, 7005649.0],
                        [820627.0, 6997569.0],
                        [821199.0, 6989850.0],
                        [814347.0, 6988595.0],
                        [808498.0, 6984157.0],
                        [803958.0, 6983050.0],
                        [795770.0, 6985807.0],
                        [788558.0, 6985051.0],
                        [789845.0, 6973793.0],
                        [787172.0, 6965431.0],
                        [790134.0, 6962730.0],
                        [781387.0, 6953785.0],
                        [779463.0, 6948255.0],
                        [774574.0, 6946610.0],
                        [777906.0, 6941851.0],
                        [775403.0, 6934852.0],
                        [776081.0, 6923412.0],
                    ]
                ],
                "bbox": (774574.0, 6905215.0, 873032.0, 7008459.0),
            }
        },
        5: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [730707.0, 6810078.0],
                        [736893.0, 6807760.0],
                        [745765.0, 6796957.0],
                        [746161.0, 6791892.0],
                        [749678.0, 6782304.0],
                        [755033.0, 6785741.0],
                        [759917.0, 6778325.0],
                        [763413.0, 6765164.0],
                        [767353.0, 6760249.0],
                        [783028.0, 6759096.0],
                        [789480.0, 6763963.0],
                        [796594.0, 6759156.0],
                        [797692.0, 6763119.0],
                        [808147.0, 6762855.0],
                        [816397.0, 6764598.0],
                        [817962.0, 6771080.0],
                        [827043.0, 6770243.0],
                        [825768.0, 6776095.0],
                        [828770.0, 6781171.0],
                        [835407.0, 6779651.0],
                        [837598.0, 6783989.0],
                        [837935.0, 6797546.0],
                        [834073.0, 6806764.0],
                        [827022.0, 6811887.0],
                        [822210.0, 6820200.0],
                        [823302.0, 6827043.0],
                        [819107.0, 6829393.0],
                        [814106.0, 6826118.0],
                        [803526.0, 6829924.0],
                        [796995.0, 6835851.0],
                        [797551.0, 6845278.0],
                        [785824.0, 6845891.0],
                        [779497.0, 6845091.0],
                        [773768.0, 6840880.0],
                        [769985.0, 6834113.0],
                        [760761.0, 6824301.0],
                        [753955.0, 6826609.0],
                        [746802.0, 6826973.0],
                        [740952.0, 6835710.0],
                        [737148.0, 6833964.0],
                        [731262.0, 6826009.0],
                        [728998.0, 6813854.0],
                        [730707.0, 6810078.0],
                    ]
                ],
                "bbox": (728998.0, 6759096.0, 837935.0, 6845891.0),
            }
        },
        6: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1009696.0, 6370071.0],
                        [1002665.0, 6364730.0],
                        [997268.0, 6357103.0],
                        [994698.0, 6348019.0],
                        [1000668.0, 6338218.0],
                        [1000089.0, 6334256.0],
                        [1007601.0, 6328762.0],
                        [1009068.0, 6324850.0],
                        [1014122.0, 6322114.0],
                        [1012050.0, 6317690.0],
                        [1007566.0, 6320724.0],
                        [1000978.0, 6315262.0],
                        [997097.0, 6315251.0],
                        [992638.0, 6305621.0],
                        [1002326.0, 6300425.0],
                        [1003290.0, 6292496.0],
                        [1006552.0, 6288390.0],
                        [1015523.0, 6285590.0],
                        [1014132.0, 6274778.0],
                        [1018256.0, 6272482.0],
                        [1020971.0, 6279894.0],
                        [1026533.0, 6279746.0],
                        [1033109.0, 6287175.0],
                        [1036126.0, 6293135.0],
                        [1041921.0, 6296903.0],
                        [1048217.0, 6297561.0],
                        [1064350.0, 6309506.0],
                        [1061225.0, 6317546.0],
                        [1066133.0, 6321494.0],
                        [1066468.0, 6326676.0],
                        [1072800.0, 6330433.0],
                        [1073742.0, 6336784.0],
                        [1077560.0, 6342698.0],
                        [1073403.0, 6350462.0],
                        [1060282.0, 6348576.0],
                        [1054180.0, 6344806.0],
                        [1042408.0, 6347558.0],
                        [1034654.0, 6353189.0],
                        [1025044.0, 6356596.0],
                        [1020000.0, 6356725.0],
                        [1018585.0, 6361599.0],
                        [1009696.0, 6370071.0],
                    ]
                ],
                "bbox": (992638.0, 6272482.0, 1077560.0, 6370071.0),
            }
        },
        7: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [753779.0, 6537018.0],
                        [758503.0, 6532097.0],
                        [754369.0, 6520637.0],
                        [760734.0, 6514163.0],
                        [764154.0, 6503988.0],
                        [770440.0, 6500348.0],
                        [774454.0, 6495613.0],
                        [776221.0, 6483674.0],
                        [770335.0, 6479388.0],
                        [770263.0, 6473476.0],
                        [776677.0, 6475557.0],
                        [780259.0, 6472021.0],
                        [792166.0, 6477709.0],
                        [802398.0, 6475469.0],
                        [807029.0, 6471772.0],
                        [806856.0, 6463705.0],
                        [811227.0, 6465007.0],
                        [816370.0, 6460772.0],
                        [825694.0, 6462649.0],
                        [826509.0, 6469123.0],
                        [831517.0, 6473257.0],
                        [837457.0, 6475559.0],
                        [837308.0, 6485557.0],
                        [834511.0, 6489782.0],
                        [829797.0, 6488843.0],
                        [825934.0, 6498617.0],
                        [818524.0, 6498224.0],
                        [809870.0, 6504594.0],
                        [806255.0, 6511913.0],
                        [808147.0, 6518212.0],
                        [807296.0, 6530310.0],
                        [802643.0, 6534285.0],
                        [800220.0, 6540120.0],
                        [801039.0, 6547667.0],
                        [798995.0, 6551156.0],
                        [802035.0, 6559678.0],
                        [810991.0, 6564128.0],
                        [806993.0, 6569822.0],
                        [798969.0, 6562707.0],
                        [797273.0, 6565101.0],
                        [787355.0, 6564848.0],
                        [785138.0, 6567101.0],
                        [776287.0, 6563809.0],
                        [774989.0, 6567447.0],
                        [768620.0, 6568680.0],
                        [769267.0, 6575508.0],
                        [762003.0, 6573092.0],
                        [760949.0, 6561975.0],
                        [763504.0, 6554575.0],
                        [762385.0, 6549859.0],
                        [763887.0, 6544360.0],
                        [761084.0, 6541876.0],
                        [754888.0, 6541809.0],
                        [753779.0, 6537018.0],
                    ]
                ],
                "bbox": (753779.0, 6460772.0, 837457.0, 6575508.0),
            }
        },
        8: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [505760.0, 6248691.0],
                        [506455.0, 6246240.0],
                        [501020.0, 6240519.0],
                        [500952.0, 6237523.0],
                        [491741.0, 6229153.0],
                        [498958.0, 6224762.0],
                        [501199.0, 6216194.0],
                        [506394.0, 6214104.0],
                        [501753.0, 6199863.0],
                        [493715.0, 6200925.0],
                        [492032.0, 6195420.0],
                        [491362.0, 6184305.0],
                        [493119.0, 6181125.0],
                        [509918.0, 6181609.0],
                        [507071.0, 6189939.0],
                        [508439.0, 6196068.0],
                        [512551.0, 6198492.0],
                        [524704.0, 6194181.0],
                        [522873.0, 6204718.0],
                        [526458.0, 6208824.0],
                        [535012.0, 6210452.0],
                        [537386.0, 6214080.0],
                        [535770.0, 6220735.0],
                        [540236.0, 6224348.0],
                        [541984.0, 6228895.0],
                        [547328.0, 6230443.0],
                        [554118.0, 6225953.0],
                        [555809.0, 6233248.0],
                        [562910.0, 6233771.0],
                        [567825.0, 6236309.0],
                        [561407.0, 6244405.0],
                        [565565.0, 6247682.0],
                        [572065.0, 6240985.0],
                        [575081.0, 6235814.0],
                        [582028.0, 6242918.0],
                        [589272.0, 6240503.0],
                        [593467.0, 6242482.0],
                        [598408.0, 6250205.0],
                        [603733.0, 6249863.0],
                        [603060.0, 6255463.0],
                        [607574.0, 6261192.0],
                        [611672.0, 6256714.0],
                        [621363.0, 6260238.0],
                        [620519.0, 6263967.0],
                        [609628.0, 6269734.0],
                        [605052.0, 6276459.0],
                        [594074.0, 6282175.0],
                        [597601.0, 6285124.0],
                        [595737.0, 6291653.0],
                        [592076.0, 6294561.0],
                        [590928.0, 6301074.0],
                        [586632.0, 6302842.0],
                        [583878.0, 6308763.0],
                        [583992.0, 6314318.0],
                        [575242.0, 6309509.0],
                        [567948.0, 6310839.0],
                        [568130.0, 6303820.0],
                        [556606.0, 6298479.0],
                        [550735.0, 6304341.0],
                        [535303.0, 6300840.0],
                        [545681.0, 6284750.0],
                        [550482.0, 6283435.0],
                        [554723.0, 6278961.0],
                        [539594.0, 6265818.0],
                        [536034.0, 6253601.0],
                        [531230.0, 6258583.0],
                        [523428.0, 6259977.0],
                        [514960.0, 6255730.0],
                        [509767.0, 6249274.0],
                        [505760.0, 6248691.0],
                    ]
                ],
                "bbox": (491362.0, 6181125.0, 621363.0, 6314318.0),
            }
        },
        9: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [806993.0, 6569822.0],
                        [808209.0, 6578315.0],
                        [815826.0, 6575242.0],
                        [824653.0, 6575157.0],
                        [830305.0, 6579430.0],
                        [833486.0, 6565745.0],
                        [837322.0, 6565642.0],
                        [839484.0, 6574938.0],
                        [845050.0, 6590960.0],
                        [845229.0, 6595067.0],
                        [848718.0, 6603737.0],
                        [857422.0, 6600366.0],
                        [868758.0, 6603264.0],
                        [869949.0, 6598870.0],
                        [877344.0, 6596683.0],
                        [885325.0, 6599852.0],
                        [880824.0, 6605207.0],
                        [886706.0, 6618161.0],
                        [882575.0, 6628163.0],
                        [880659.0, 6638936.0],
                        [887343.0, 6642371.0],
                        [876345.0, 6647462.0],
                        [872158.0, 6650880.0],
                        [871408.0, 6655745.0],
                        [860161.0, 6652754.0],
                        [855755.0, 6655507.0],
                        [831500.0, 6648015.0],
                        [823470.0, 6650227.0],
                        [813434.0, 6659755.0],
                        [806754.0, 6662035.0],
                        [806631.0, 6665548.0],
                        [795506.0, 6668991.0],
                        [791663.0, 6673495.0],
                        [789554.0, 6672918.0],
                        [784602.0, 6669828.0],
                        [780471.0, 6669516.0],
                        [778810.0, 6664936.0],
                        [781374.0, 6662136.0],
                        [779000.0, 6654397.0],
                        [778932.0, 6646959.0],
                        [783308.0, 6642195.0],
                        [780490.0, 6638662.0],
                        [781064.0, 6632682.0],
                        [775685.0, 6631211.0],
                        [770503.0, 6626941.0],
                        [760920.0, 6622686.0],
                        [756196.0, 6628301.0],
                        [748049.0, 6627896.0],
                        [748734.0, 6623209.0],
                        [753291.0, 6618069.0],
                        [756931.0, 6607772.0],
                        [761463.0, 6602522.0],
                        [763922.0, 6603795.0],
                        [768312.0, 6598303.0],
                        [773476.0, 6599308.0],
                        [776586.0, 6596649.0],
                        [775079.0, 6589273.0],
                        [775913.0, 6580395.0],
                        [769267.0, 6575508.0],
                        [768620.0, 6568680.0],
                        [774989.0, 6567447.0],
                        [776287.0, 6563809.0],
                        [785138.0, 6567101.0],
                        [787355.0, 6564848.0],
                        [797273.0, 6565101.0],
                        [798969.0, 6562707.0],
                        [806993.0, 6569822.0],
                    ]
                ],
                "bbox": (748049.0, 6562707.0, 887343.0, 6673495.0),
            }
        },
        10: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [399495.0, 6830885.0],
                        [398130.0, 6822559.0],
                        [400321.0, 6810723.0],
                        [395852.0, 6803336.0],
                        [398626.0, 6784333.0],
                        [400465.0, 6781914.0],
                        [400197.0, 6773697.0],
                        [394099.0, 6773357.0],
                        [390140.0, 6770978.0],
                        [386941.0, 6760260.0],
                        [382932.0, 6754022.0],
                        [389872.0, 6749698.0],
                        [393110.0, 6750366.0],
                        [402067.0, 6747685.0],
                        [404251.0, 6751414.0],
                        [412442.0, 6746090.0],
                        [419671.0, 6744167.0],
                        [429458.0, 6743442.0],
                        [440863.0, 6746201.0],
                        [446732.0, 6745443.0],
                        [446459.0, 6750432.0],
                        [442128.0, 6753611.0],
                        [448124.0, 6758669.0],
                        [447308.0, 6764356.0],
                        [455060.0, 6767070.0],
                        [451057.0, 6776681.0],
                        [459373.0, 6778102.0],
                        [460615.0, 6783387.0],
                        [458409.0, 6789055.0],
                        [466280.0, 6794064.0],
                        [465298.0, 6799724.0],
                        [467628.0, 6811401.0],
                        [473893.0, 6813452.0],
                        [474394.0, 6821359.0],
                        [467262.0, 6822174.0],
                        [466087.0, 6830999.0],
                        [463434.0, 6833996.0],
                        [457920.0, 6827997.0],
                        [451256.0, 6826715.0],
                        [446687.0, 6829012.0],
                        [441174.0, 6828584.0],
                        [437568.0, 6825109.0],
                        [429868.0, 6822252.0],
                        [422197.0, 6821752.0],
                        [414934.0, 6829326.0],
                        [407934.0, 6831360.0],
                        [404267.0, 6828490.0],
                        [399495.0, 6830885.0],
                    ]
                ],
                "bbox": (382932.0, 6743442.0, 474394.0, 6833996.0),
            }
        },
        11: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [459784.0, 6545825.0],
                        [457303.0, 6539406.0],
                        [458386.0, 6534878.0],
                        [455132.0, 6526680.0],
                        [449713.0, 6524677.0],
                        [445866.0, 6528260.0],
                        [434480.0, 6521530.0],
                        [434607.0, 6512022.0],
                        [436951.0, 6506668.0],
                        [442913.0, 6501478.0],
                        [446521.0, 6493231.0],
                        [444696.0, 6489309.0],
                        [445861.0, 6484044.0],
                        [443202.0, 6478722.0],
                        [447267.0, 6474282.0],
                        [456356.0, 6470307.0],
                        [455660.0, 6465791.0],
                        [461242.0, 6465553.0],
                        [464807.0, 6459164.0],
                        [468806.0, 6462928.0],
                        [474561.0, 6460744.0],
                        [485798.0, 6470195.0],
                        [484697.0, 6477489.0],
                        [489646.0, 6488189.0],
                        [493466.0, 6488572.0],
                        [504657.0, 6496986.0],
                        [505177.0, 6505055.0],
                        [513233.0, 6510903.0],
                        [515635.0, 6515544.0],
                        [522412.0, 6520738.0],
                        [522669.0, 6525452.0],
                        [527825.0, 6527023.0],
                        [534383.0, 6537804.0],
                        [540666.0, 6541823.0],
                        [539507.0, 6547743.0],
                        [531290.0, 6552122.0],
                        [531964.0, 6561069.0],
                        [526089.0, 6562344.0],
                        [521367.0, 6557890.0],
                        [509938.0, 6556936.0],
                        [507509.0, 6562167.0],
                        [499249.0, 6554736.0],
                        [489751.0, 6554866.0],
                        [483517.0, 6558927.0],
                        [473907.0, 6559092.0],
                        [469589.0, 6554692.0],
                        [465641.0, 6555184.0],
                        [464645.0, 6548283.0],
                        [459784.0, 6545825.0],
                    ]
                ],
                "bbox": (434480.0, 6459164.0, 540666.0, 6562344.0),
            }
        },
        12: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [417723.0, 6857101.0],
                        [408651.0, 6861319.0],
                        [399642.0, 6861271.0],
                        [396867.0, 6868913.0],
                        [401493.0, 6871059.0],
                        [411444.0, 6881401.0],
                        [417375.0, 6892264.0],
                        [416434.0, 6899162.0],
                        [413253.0, 6901117.0],
                        [415797.0, 6907383.0],
                        [406933.0, 6907874.0],
                        [400663.0, 6914651.0],
                        [399047.0, 6920143.0],
                        [400759.0, 6925144.0],
                        [397607.0, 6926545.0],
                        [396597.0, 6932989.0],
                        [388320.0, 6946238.0],
                        [388687.0, 6950091.0],
                        [394381.0, 6955463.0],
                        [390587.0, 6963240.0],
                        [381046.0, 6965005.0],
                        [372051.0, 6959988.0],
                        [362230.0, 6961356.0],
                        [343652.0, 6969661.0],
                        [343012.0, 6963991.0],
                        [349037.0, 6960923.0],
                        [349892.0, 6952123.0],
                        [346450.0, 6948841.0],
                        [350114.0, 6938864.0],
                        [350193.0, 6931900.0],
                        [357636.0, 6924163.0],
                        [364780.0, 6906370.0],
                        [363427.0, 6896430.0],
                        [366480.0, 6887586.0],
                        [365701.0, 6878731.0],
                        [362959.0, 6869214.0],
                        [363872.0, 6859932.0],
                        [368562.0, 6852485.0],
                        [376547.0, 6847928.0],
                        [372261.0, 6845150.0],
                        [363309.0, 6845999.0],
                        [366767.0, 6839135.0],
                        [368413.0, 6830443.0],
                        [376536.0, 6826525.0],
                        [384742.0, 6834496.0],
                        [389634.0, 6835155.0],
                        [399495.0, 6830885.0],
                        [404267.0, 6828490.0],
                        [407934.0, 6831360.0],
                        [414934.0, 6829326.0],
                        [421619.0, 6835816.0],
                        [423498.0, 6841841.0],
                        [420581.0, 6852284.0],
                        [417723.0, 6857101.0],
                    ]
                ],
                "bbox": (343012.0, 6826525.0, 423498.0, 6969661.0),
            }
        },
        13: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [590236.0, 6872273.0],
                        [594217.0, 6866696.0],
                        [596554.0, 6858123.0],
                        [595472.0, 6845570.0],
                        [597086.0, 6841311.0],
                        [604791.0, 6831646.0],
                        [608912.0, 6830618.0],
                        [611402.0, 6819097.0],
                        [620311.0, 6818025.0],
                        [623768.0, 6826369.0],
                        [627504.0, 6829048.0],
                        [627800.0, 6838438.0],
                        [632440.0, 6843248.0],
                        [634691.0, 6849194.0],
                        [643163.0, 6853168.0],
                        [637702.0, 6857774.0],
                        [637864.0, 6864035.0],
                        [641404.0, 6867928.0],
                        [641836.0, 6872490.0],
                        [633062.0, 6879807.0],
                        [628641.0, 6878089.0],
                        [622312.0, 6880731.0],
                        [614076.0, 6886919.0],
                        [606678.0, 6883543.0],
                        [603102.0, 6887292.0],
                        [598361.0, 6887345.0],
                        [591984.0, 6886421.0],
                        [587216.0, 6881812.0],
                        [590236.0, 6872273.0],
                    ]
                ],
                "bbox": (587216.0, 6818025.0, 643163.0, 6887345.0),
            }
        },
        14: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [986155.0, 6724947.0],
                        [984341.0, 6721925.0],
                        [977033.0, 6724531.0],
                        [974258.0, 6721322.0],
                        [969354.0, 6721610.0],
                        [967469.0, 6716290.0],
                        [955890.0, 6718838.0],
                        [950918.0, 6717032.0],
                        [945847.0, 6708437.0],
                        [932449.0, 6699390.0],
                        [925719.0, 6696195.0],
                        [922029.0, 6697905.0],
                        [904021.0, 6688452.0],
                        [905832.0, 6683506.0],
                        [912920.0, 6678099.0],
                        [913407.0, 6674258.0],
                        [909981.0, 6669146.0],
                        [913780.0, 6661601.0],
                        [925599.0, 6657600.0],
                        [925393.0, 6653995.0],
                        [928880.0, 6645788.0],
                        [940225.0, 6640408.0],
                        [944367.0, 6635241.0],
                        [942748.0, 6631718.0],
                        [934547.0, 6625608.0],
                        [937312.0, 6621303.0],
                        [933274.0, 6616467.0],
                        [940343.0, 6611180.0],
                        [938167.0, 6613167.0],
                        [950995.0, 6626461.0],
                        [962319.0, 6634781.0],
                        [961533.0, 6640379.0],
                        [963711.0, 6649123.0],
                        [961099.0, 6653277.0],
                        [967437.0, 6658254.0],
                        [976505.0, 6662212.0],
                        [981857.0, 6667617.0],
                        [983508.0, 6674248.0],
                        [992174.0, 6680929.0],
                        [993793.0, 6685149.0],
                        [999048.0, 6690006.0],
                        [1001635.0, 6695987.0],
                        [1006570.0, 6701646.0],
                        [1002944.0, 6704539.0],
                        [995578.0, 6702427.0],
                        [996902.0, 6711079.0],
                        [994087.0, 6717743.0],
                        [993651.0, 6723596.0],
                        [986155.0, 6724947.0],
                    ]
                ],
                "bbox": (904021.0, 6611180.0, 1006570.0, 6724947.0),
            }
        },
        15: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [904250.0, 6825381.0],
                        [904895.0, 6830283.0],
                        [900379.0, 6832469.0],
                        [903561.0, 6837915.0],
                        [902927.0, 6847494.0],
                        [899528.0, 6852809.0],
                        [904125.0, 6862116.0],
                        [901302.0, 6871865.0],
                        [905066.0, 6875501.0],
                        [906433.0, 6884047.0],
                        [905859.0, 6891045.0],
                        [901739.0, 6893315.0],
                        [900172.0, 6898682.0],
                        [901547.0, 6903348.0],
                        [898091.0, 6905220.0],
                        [898652.0, 6915853.0],
                        [895087.0, 6927281.0],
                        [891117.0, 6929633.0],
                        [883576.0, 6926040.0],
                        [878534.0, 6930925.0],
                        [879041.0, 6935896.0],
                        [875512.0, 6946935.0],
                        [873032.0, 6949057.0],
                        [867310.0, 6942452.0],
                        [856532.0, 6942619.0],
                        [853210.0, 6945817.0],
                        [849442.0, 6935263.0],
                        [853548.0, 6926776.0],
                        [847303.0, 6917040.0],
                        [849280.0, 6910207.0],
                        [842092.0, 6905887.0],
                        [841416.0, 6900107.0],
                        [845429.0, 6892400.0],
                        [846791.0, 6883540.0],
                        [848915.0, 6882413.0],
                        [848655.0, 6874905.0],
                        [841874.0, 6870868.0],
                        [838677.0, 6859119.0],
                        [846329.0, 6850924.0],
                        [846365.0, 6844539.0],
                        [847795.0, 6838972.0],
                        [852692.0, 6834838.0],
                        [856191.0, 6834907.0],
                        [863008.0, 6828766.0],
                        [873603.0, 6822775.0],
                        [882722.0, 6816263.0],
                        [893443.0, 6818701.0],
                        [904250.0, 6825381.0],
                    ]
                ],
                "bbox": (838677.0, 6816263.0, 906433.0, 6949057.0),
            }
        },
        16: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [486169.0, 6410676.0],
                        [482141.0, 6421330.0],
                        [476390.0, 6418176.0],
                        [469504.0, 6418931.0],
                        [461839.0, 6422164.0],
                        [466012.0, 6428425.0],
                        [464018.0, 6432038.0],
                        [469719.0, 6445475.0],
                        [467756.0, 6450339.0],
                        [460931.0, 6449393.0],
                        [457280.0, 6451647.0],
                        [452009.0, 6448234.0],
                        [444096.0, 6451365.0],
                        [437492.0, 6457585.0],
                        [433418.0, 6457450.0],
                        [431214.0, 6470295.0],
                        [421098.0, 6472770.0],
                        [418478.0, 6475494.0],
                        [406100.0, 6476140.0],
                        [404682.0, 6481482.0],
                        [399796.0, 6489042.0],
                        [386164.0, 6505245.0],
                        [380995.0, 6504145.0],
                        [375328.0, 6494206.0],
                        [373905.0, 6475097.0],
                        [366594.0, 6427323.0],
                        [365668.0, 6410104.0],
                        [370987.0, 6417061.0],
                        [380337.0, 6407555.0],
                        [382533.0, 6402380.0],
                        [376517.0, 6401861.0],
                        [367865.0, 6404553.0],
                        [364521.0, 6395279.0],
                        [361697.0, 6391399.0],
                        [361774.0, 6383396.0],
                        [373686.0, 6386677.0],
                        [375548.0, 6389853.0],
                        [383562.0, 6383958.0],
                        [381182.0, 6379048.0],
                        [388231.0, 6379327.0],
                        [393973.0, 6376334.0],
                        [403228.0, 6378937.0],
                        [411314.0, 6378206.0],
                        [411174.0, 6373203.0],
                        [418928.0, 6369127.0],
                        [419635.0, 6366255.0],
                        [426389.0, 6364119.0],
                        [430077.0, 6359927.0],
                        [429214.0, 6351421.0],
                        [438523.0, 6349285.0],
                        [442465.0, 6350467.0],
                        [445091.0, 6357381.0],
                        [449164.0, 6352477.0],
                        [455164.0, 6354504.0],
                        [457916.0, 6359953.0],
                        [454032.0, 6364649.0],
                        [462536.0, 6370133.0],
                        [460366.0, 6373402.0],
                        [460343.0, 6383021.0],
                        [464993.0, 6388179.0],
                        [474218.0, 6394851.0],
                        [476701.0, 6399758.0],
                        [472909.0, 6402270.0],
                        [474628.0, 6407547.0],
                        [486169.0, 6410676.0],
                    ]
                ],
                "bbox": (361697.0, 6349285.0, 486169.0, 6505245.0),
            }
        },
        17: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [503908.0, 6928958.0],
                        [498291.0, 6928808.0],
                        [490213.0, 6925480.0],
                        [480923.0, 6917694.0],
                        [474554.0, 6915313.0],
                        [465316.0, 6913926.0],
                        [451821.0, 6920480.0],
                        [444571.0, 6921849.0],
                        [429556.0, 6922759.0],
                        [420281.0, 6924935.0],
                        [414059.0, 6928862.0],
                        [403953.0, 6928646.0],
                        [400759.0, 6925144.0],
                        [399047.0, 6920143.0],
                        [400663.0, 6914651.0],
                        [406933.0, 6907874.0],
                        [415797.0, 6907383.0],
                        [413253.0, 6901117.0],
                        [416434.0, 6899162.0],
                        [417375.0, 6892264.0],
                        [411444.0, 6881401.0],
                        [401493.0, 6871059.0],
                        [396867.0, 6868913.0],
                        [399642.0, 6861271.0],
                        [408651.0, 6861319.0],
                        [417723.0, 6857101.0],
                        [427244.0, 6861949.0],
                        [446005.0, 6869054.0],
                        [449827.0, 6868751.0],
                        [454384.0, 6863198.0],
                        [457511.0, 6867107.0],
                        [469104.0, 6863978.0],
                        [475607.0, 6865852.0],
                        [484257.0, 6870962.0],
                        [489675.0, 6876299.0],
                        [491678.0, 6873174.0],
                        [500558.0, 6877307.0],
                        [504730.0, 6874732.0],
                        [510545.0, 6875400.0],
                        [512505.0, 6881741.0],
                        [508338.0, 6886469.0],
                        [512079.0, 6895331.0],
                        [509950.0, 6897618.0],
                        [509502.0, 6910309.0],
                        [505278.0, 6914121.0],
                        [503908.0, 6928958.0],
                    ]
                ],
                "bbox": (396867.0, 6857101.0, 512505.0, 6928958.0),
            }
        },
        18: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [915394.0, 6762341.0],
                        [919858.0, 6768473.0],
                        [924039.0, 6766004.0],
                        [929025.0, 6772821.0],
                        [935284.0, 6772098.0],
                        [936416.0, 6766072.0],
                        [941726.0, 6764118.0],
                        [951150.0, 6767749.0],
                        [956126.0, 6765947.0],
                        [959909.0, 6759629.0],
                        [964569.0, 6761737.0],
                        [968808.0, 6766577.0],
                        [972278.0, 6762245.0],
                        [982963.0, 6756697.0],
                        [986052.0, 6752778.0],
                        [987691.0, 6753958.0],
                        [993060.0, 6757264.0],
                        [991355.0, 6761730.0],
                        [993983.0, 6773739.0],
                        [998205.0, 6776671.0],
                        [1001795.0, 6789636.0],
                        [1006708.0, 6801985.0],
                        [1011125.0, 6809400.0],
                        [1005338.0, 6811635.0],
                        [1003109.0, 6819572.0],
                        [1004385.0, 6831654.0],
                        [994239.0, 6827289.0],
                        [987769.0, 6820181.0],
                        [982282.0, 6817771.0],
                        [973656.0, 6818945.0],
                        [964951.0, 6823820.0],
                        [963830.0, 6819154.0],
                        [935203.0, 6815546.0],
                        [930831.0, 6810526.0],
                        [919362.0, 6809623.0],
                        [910921.0, 6826770.0],
                        [904250.0, 6825381.0],
                        [893443.0, 6818701.0],
                        [882722.0, 6816263.0],
                        [878315.0, 6811920.0],
                        [883843.0, 6809100.0],
                        [896020.0, 6796835.0],
                        [901295.0, 6794520.0],
                        [899609.0, 6786135.0],
                        [895837.0, 6779219.0],
                        [900794.0, 6778635.0],
                        [906998.0, 6773750.0],
                        [908017.0, 6765028.0],
                        [912655.0, 6766332.0],
                        [915394.0, 6762341.0],
                    ]
                ],
                "bbox": (878315.0, 6752778.0, 1011125.0, 6831654.0),
            }
        },
        19: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [642856.0, 6724786.0],
                        [634456.0, 6720842.0],
                        [639501.0, 6716775.0],
                        [642622.0, 6708275.0],
                        [632231.0, 6698879.0],
                        [634922.0, 6687596.0],
                        [624165.0, 6685496.0],
                        [619951.0, 6688294.0],
                        [617060.0, 6680060.0],
                        [612147.0, 6680536.0],
                        [612309.0, 6675948.0],
                        [607114.0, 6670785.0],
                        [615265.0, 6667454.0],
                        [621646.0, 6669974.0],
                        [627833.0, 6667741.0],
                        [627981.0, 6660408.0],
                        [631131.0, 6657674.0],
                        [629301.0, 6648616.0],
                        [633457.0, 6642556.0],
                        [627496.0, 6637025.0],
                        [632500.0, 6630848.0],
                        [628673.0, 6627353.0],
                        [634340.0, 6622075.0],
                        [637665.0, 6611745.0],
                        [635550.0, 6606712.0],
                        [638969.0, 6598575.0],
                        [634893.0, 6595681.0],
                        [636090.0, 6591904.0],
                        [644784.0, 6591412.0],
                        [645179.0, 6595086.0],
                        [650317.0, 6601560.0],
                        [660370.0, 6603761.0],
                        [664479.0, 6602292.0],
                        [670500.0, 6605989.0],
                        [669145.0, 6615318.0],
                        [677474.0, 6626628.0],
                        [682775.0, 6624336.0],
                        [686837.0, 6626145.0],
                        [696943.0, 6633749.0],
                        [702446.0, 6632753.0],
                        [705186.0, 6641947.0],
                        [703828.0, 6645606.0],
                        [706033.0, 6650549.0],
                        [705753.0, 6657660.0],
                        [701762.0, 6662486.0],
                        [702129.0, 6669867.0],
                        [698614.0, 6680189.0],
                        [698745.0, 6684384.0],
                        [690449.0, 6694237.0],
                        [694642.0, 6704915.0],
                        [690565.0, 6713347.0],
                        [685430.0, 6710473.0],
                        [682544.0, 6713710.0],
                        [678869.0, 6710238.0],
                        [674282.0, 6709782.0],
                        [669909.0, 6717111.0],
                        [661757.0, 6718781.0],
                        [657729.0, 6723417.0],
                        [652875.0, 6720759.0],
                        [646396.0, 6725640.0],
                        [642856.0, 6724786.0],
                    ]
                ],
                "bbox": (607114.0, 6591412.0, 706033.0, 6725640.0),
            }
        },
        20: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [779411.0, 6373918.0],
                        [785084.0, 6367917.0],
                        [783861.0, 6358147.0],
                        [791158.0, 6357807.0],
                        [800494.0, 6352553.0],
                        [802764.0, 6358131.0],
                        [806518.0, 6360956.0],
                        [819866.0, 6361270.0],
                        [824346.0, 6357163.0],
                        [831641.0, 6353746.0],
                        [831614.0, 6360351.0],
                        [832713.0, 6371581.0],
                        [835151.0, 6374038.0],
                        [834538.0, 6384016.0],
                        [835764.0, 6388411.0],
                        [841041.0, 6396655.0],
                        [839715.0, 6410394.0],
                        [844069.0, 6414766.0],
                        [848816.0, 6428161.0],
                        [844782.0, 6435636.0],
                        [842390.0, 6453321.0],
                        [841110.0, 6468164.0],
                        [837457.0, 6475559.0],
                        [831517.0, 6473257.0],
                        [826509.0, 6469123.0],
                        [825694.0, 6462649.0],
                        [816370.0, 6460772.0],
                        [813436.0, 6450097.0],
                        [808187.0, 6450395.0],
                        [808165.0, 6446004.0],
                        [801638.0, 6433950.0],
                        [796332.0, 6429870.0],
                        [791307.0, 6420019.0],
                        [782106.0, 6419872.0],
                        [781273.0, 6415520.0],
                        [774103.0, 6411136.0],
                        [768276.0, 6405343.0],
                        [771844.0, 6388592.0],
                        [775042.0, 6386528.0],
                        [779411.0, 6373918.0],
                    ]
                ],
                "bbox": (768276.0, 6352553.0, 848816.0, 6475559.0),
            }
        },
        21: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [776081.0, 6923412.0],
                        [775403.0, 6934852.0],
                        [777906.0, 6941851.0],
                        [774574.0, 6946610.0],
                        [779463.0, 6948255.0],
                        [781387.0, 6953785.0],
                        [790134.0, 6962730.0],
                        [787172.0, 6965431.0],
                        [789845.0, 6973793.0],
                        [788558.0, 6985051.0],
                        [781905.0, 6987282.0],
                        [778060.0, 6986162.0],
                        [770359.0, 6988977.0],
                        [766237.0, 6992385.0],
                        [753505.0, 6995276.0],
                        [751253.0, 6997000.0],
                        [744014.0, 6992056.0],
                        [739058.0, 6995179.0],
                        [735248.0, 6991264.0],
                        [725313.0, 6993104.0],
                        [720100.0, 6990781.0],
                        [716534.0, 6992565.0],
                        [712391.0, 6990404.0],
                        [713833.0, 6986563.0],
                        [708480.0, 6979518.0],
                        [705667.0, 6969289.0],
                        [708546.0, 6956332.0],
                        [707064.0, 6950845.0],
                        [709520.0, 6938240.0],
                        [706939.0, 6934901.0],
                        [711648.0, 6928031.0],
                        [706805.0, 6926038.0],
                        [706929.0, 6919738.0],
                        [698137.0, 6911415.0],
                        [701957.0, 6908433.0],
                        [704672.0, 6899225.0],
                        [710189.0, 6894765.0],
                        [705248.0, 6890863.0],
                        [712067.0, 6888882.0],
                        [712559.0, 6879371.0],
                        [722321.0, 6872132.0],
                        [724211.0, 6867685.0],
                        [729581.0, 6862815.0],
                        [735603.0, 6861428.0],
                        [738742.0, 6868146.0],
                        [744067.0, 6871735.0],
                        [747254.0, 6882494.0],
                        [743801.0, 6891376.0],
                        [745398.0, 6894771.0],
                        [751361.0, 6898188.0],
                        [747051.0, 6913033.0],
                        [761575.0, 6918670.0],
                        [767112.0, 6923360.0],
                        [775242.0, 6918312.0],
                        [776081.0, 6923412.0],
                    ]
                ],
                "bbox": (698137.0, 6861428.0, 790134.0, 6997000.0),
            }
        },
        22: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [334283.0, 6280551.0],
                        [327832.0, 6270658.0],
                        [324268.0, 6267623.0],
                        [314107.0, 6264613.0],
                        [316186.0, 6255555.0],
                        [321493.0, 6257288.0],
                        [325696.0, 6250142.0],
                        [329513.0, 6253905.0],
                        [334359.0, 6254169.0],
                        [344050.0, 6249226.0],
                        [343580.0, 6242296.0],
                        [340751.0, 6235590.0],
                        [335750.0, 6230517.0],
                        [338499.0, 6226346.0],
                        [344947.0, 6224142.0],
                        [346289.0, 6231519.0],
                        [352412.0, 6225527.0],
                        [355170.0, 6226484.0],
                        [373097.0, 6218255.0],
                        [377794.0, 6214129.0],
                        [388910.0, 6213290.0],
                        [393755.0, 6214784.0],
                        [395170.0, 6206882.0],
                        [409841.0, 6194695.0],
                        [412796.0, 6198151.0],
                        [418372.0, 6194685.0],
                        [422245.0, 6194862.0],
                        [428954.0, 6200122.0],
                        [428150.0, 6207547.0],
                        [431947.0, 6209367.0],
                        [431385.0, 6215423.0],
                        [437107.0, 6220297.0],
                        [440142.0, 6228799.0],
                        [443868.0, 6230545.0],
                        [446410.0, 6236240.0],
                        [454979.0, 6245934.0],
                        [452746.0, 6249402.0],
                        [457777.0, 6262698.0],
                        [451477.0, 6264635.0],
                        [454138.0, 6272903.0],
                        [449863.0, 6280833.0],
                        [443497.0, 6282643.0],
                        [438084.0, 6281592.0],
                        [433057.0, 6279053.0],
                        [424830.0, 6280287.0],
                        [421554.0, 6283529.0],
                        [412501.0, 6278002.0],
                        [403447.0, 6281078.0],
                        [399714.0, 6278404.0],
                        [394475.0, 6281218.0],
                        [385124.0, 6280151.0],
                        [377063.0, 6275535.0],
                        [367753.0, 6276986.0],
                        [362964.0, 6280741.0],
                        [352961.0, 6276001.0],
                        [342731.0, 6276517.0],
                        [338238.0, 6281381.0],
                        [334283.0, 6280551.0],
                    ]
                ],
                "bbox": (314107.0, 6194685.0, 457777.0, 6283529.0),
            }
        },
        23: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [642856.0, 6724786.0],
                        [640167.0, 6731164.0],
                        [620646.0, 6731114.0],
                        [613256.0, 6732409.0],
                        [609792.0, 6727136.0],
                        [605429.0, 6729771.0],
                        [602374.0, 6738361.0],
                        [591237.0, 6742041.0],
                        [590280.0, 6747700.0],
                        [594464.0, 6753836.0],
                        [589886.0, 6759775.0],
                        [589601.0, 6765689.0],
                        [573758.0, 6762848.0],
                        [566408.0, 6764638.0],
                        [559999.0, 6772636.0],
                        [559439.0, 6777275.0],
                        [551727.0, 6777731.0],
                        [551017.0, 6782681.0],
                        [539332.0, 6780273.0],
                        [535875.0, 6773086.0],
                        [539183.0, 6762306.0],
                        [532634.0, 6757689.0],
                        [533549.0, 6751156.0],
                        [528757.0, 6745774.0],
                        [518605.0, 6737439.0],
                        [521086.0, 6735350.0],
                        [530153.0, 6735215.0],
                        [539386.0, 6732046.0],
                        [543743.0, 6727862.0],
                        [552256.0, 6724799.0],
                        [555366.0, 6719856.0],
                        [552945.0, 6716389.0],
                        [559271.0, 6706788.0],
                        [557303.0, 6702930.0],
                        [558309.0, 6696538.0],
                        [557051.0, 6690388.0],
                        [561058.0, 6687382.0],
                        [565759.0, 6689706.0],
                        [569696.0, 6685244.0],
                        [573297.0, 6677558.0],
                        [582631.0, 6683116.0],
                        [593597.0, 6687211.0],
                        [602149.0, 6685865.0],
                        [612147.0, 6680536.0],
                        [617060.0, 6680060.0],
                        [619951.0, 6688294.0],
                        [624165.0, 6685496.0],
                        [634922.0, 6687596.0],
                        [632231.0, 6698879.0],
                        [642622.0, 6708275.0],
                        [639501.0, 6716775.0],
                        [634456.0, 6720842.0],
                        [642856.0, 6724786.0],
                    ]
                ],
                "bbox": (518605.0, 6677558.0, 642856.0, 6782681.0),
            }
        },
        24: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1001023.0, 6834020.0],
                        [1007603.0, 6833382.0],
                        [1013753.0, 6840510.0],
                        [1015426.0, 6846104.0],
                        [1012123.0, 6851875.0],
                        [1016765.0, 6860562.0],
                        [1004387.0, 6868517.0],
                        [1002983.0, 6863593.0],
                        [997609.0, 6864713.0],
                        [996607.0, 6871102.0],
                        [990508.0, 6874464.0],
                        [991999.0, 6880708.0],
                        [996400.0, 6888804.0],
                        [1000174.0, 6890502.0],
                        [1005257.0, 6886565.0],
                        [1014136.0, 6883372.0],
                        [1016790.0, 6880171.0],
                        [1025429.0, 6883147.0],
                        [1032318.0, 6879884.0],
                        [1035096.0, 6882767.0],
                        [1038624.0, 6893752.0],
                        [1031356.0, 6897552.0],
                        [1023578.0, 6906994.0],
                        [1018182.0, 6905695.0],
                        [1013674.0, 6899390.0],
                        [1009903.0, 6900358.0],
                        [996736.0, 6898172.0],
                        [992282.0, 6906134.0],
                        [986611.0, 6909639.0],
                        [979390.0, 6908077.0],
                        [979652.0, 6901424.0],
                        [972590.0, 6902443.0],
                        [968604.0, 6909024.0],
                        [966935.0, 6915200.0],
                        [959086.0, 6922273.0],
                        [960438.0, 6926520.0],
                        [957718.0, 6930675.0],
                        [948608.0, 6936180.0],
                        [945901.0, 6934734.0],
                        [938917.0, 6936180.0],
                        [935871.0, 6939385.0],
                        [928691.0, 6938466.0],
                        [926408.0, 6934964.0],
                        [916749.0, 6932316.0],
                        [915342.0, 6936492.0],
                        [909643.0, 6936903.0],
                        [913390.0, 6932141.0],
                        [912688.0, 6923499.0],
                        [920628.0, 6907653.0],
                        [917676.0, 6905219.0],
                        [920671.0, 6900380.0],
                        [914011.0, 6893894.0],
                        [914442.0, 6889764.0],
                        [922708.0, 6883240.0],
                        [922735.0, 6879575.0],
                        [928151.0, 6878713.0],
                        [929417.0, 6875078.0],
                        [939656.0, 6875317.0],
                        [945024.0, 6864515.0],
                        [946451.0, 6858744.0],
                        [961206.0, 6856322.0],
                        [964692.0, 6852206.0],
                        [969100.0, 6851558.0],
                        [971773.0, 6847764.0],
                        [976380.0, 6847597.0],
                        [983189.0, 6843093.0],
                        [993487.0, 6842033.0],
                        [1001023.0, 6834020.0],
                    ]
                ],
                "bbox": (909643.0, 6833382.0, 1038624.0, 6939385.0),
            }
        },
        25: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [483517.0, 6558927.0],
                        [489751.0, 6554866.0],
                        [499249.0, 6554736.0],
                        [507509.0, 6562167.0],
                        [509938.0, 6556936.0],
                        [521367.0, 6557890.0],
                        [526089.0, 6562344.0],
                        [531964.0, 6561069.0],
                        [530127.0, 6570272.0],
                        [538896.0, 6578287.0],
                        [546474.0, 6577615.0],
                        [548271.0, 6584464.0],
                        [556218.0, 6586207.0],
                        [559931.0, 6588729.0],
                        [562773.0, 6594026.0],
                        [558128.0, 6596023.0],
                        [557842.0, 6602380.0],
                        [547958.0, 6609437.0],
                        [542426.0, 6611026.0],
                        [538906.0, 6616112.0],
                        [541431.0, 6623495.0],
                        [537221.0, 6629765.0],
                        [533123.0, 6635020.0],
                        [531658.0, 6641492.0],
                        [525272.0, 6647330.0],
                        [524608.0, 6655240.0],
                        [515158.0, 6658631.0],
                        [517389.0, 6653506.0],
                        [510389.0, 6653999.0],
                        [505157.0, 6650870.0],
                        [494833.0, 6656131.0],
                        [494947.0, 6665028.0],
                        [485608.0, 6667284.0],
                        [482922.0, 6672972.0],
                        [478404.0, 6673399.0],
                        [476861.0, 6677880.0],
                        [471947.0, 6677374.0],
                        [469141.0, 6670338.0],
                        [464624.0, 6667352.0],
                        [465537.0, 6662685.0],
                        [471018.0, 6649618.0],
                        [469757.0, 6639127.0],
                        [470952.0, 6628365.0],
                        [467588.0, 6622657.0],
                        [472374.0, 6614809.0],
                        [467690.0, 6607234.0],
                        [468300.0, 6594579.0],
                        [472081.0, 6590232.0],
                        [472141.0, 6584899.0],
                        [475179.0, 6582497.0],
                        [479925.0, 6587264.0],
                        [482897.0, 6584792.0],
                        [478920.0, 6578170.0],
                        [477460.0, 6571967.0],
                        [480502.0, 6565882.0],
                        [485043.0, 6563684.0],
                        [483517.0, 6558927.0],
                    ]
                ],
                "bbox": (464624.0, 6554736.0, 562773.0, 6677880.0),
            }
        },
        26: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [515635.0, 6515544.0],
                        [513233.0, 6510903.0],
                        [505177.0, 6505055.0],
                        [504657.0, 6496986.0],
                        [493466.0, 6488572.0],
                        [489646.0, 6488189.0],
                        [484697.0, 6477489.0],
                        [485798.0, 6470195.0],
                        [474561.0, 6460744.0],
                        [468806.0, 6462928.0],
                        [464807.0, 6459164.0],
                        [460931.0, 6449393.0],
                        [467756.0, 6450339.0],
                        [469719.0, 6445475.0],
                        [464018.0, 6432038.0],
                        [466012.0, 6428425.0],
                        [461839.0, 6422164.0],
                        [469504.0, 6418931.0],
                        [476390.0, 6418176.0],
                        [482141.0, 6421330.0],
                        [486169.0, 6410676.0],
                        [489091.0, 6407815.0],
                        [491196.0, 6399384.0],
                        [495031.0, 6397493.0],
                        [512334.0, 6403639.0],
                        [514373.0, 6400391.0],
                        [527849.0, 6401566.0],
                        [526858.0, 6394383.0],
                        [530971.0, 6390971.0],
                        [539761.0, 6395885.0],
                        [547193.0, 6388334.0],
                        [553597.0, 6395079.0],
                        [553113.0, 6398528.0],
                        [559319.0, 6399932.0],
                        [564402.0, 6403210.0],
                        [570668.0, 6413830.0],
                        [570522.0, 6417080.0],
                        [576964.0, 6421036.0],
                        [574976.0, 6434607.0],
                        [577774.0, 6436765.0],
                        [573095.0, 6446142.0],
                        [566113.0, 6450433.0],
                        [564865.0, 6461779.0],
                        [560988.0, 6465186.0],
                        [568750.0, 6477311.0],
                        [563844.0, 6479160.0],
                        [563452.0, 6484264.0],
                        [553144.0, 6489340.0],
                        [546900.0, 6501981.0],
                        [539039.0, 6503445.0],
                        [529342.0, 6499739.0],
                        [524801.0, 6504583.0],
                        [526849.0, 6509996.0],
                        [515635.0, 6515544.0],
                    ]
                ],
                "bbox": (460931.0, 6388334.0, 577774.0, 6515544.0),
            }
        },
        27: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [877344.0, 6596683.0],
                        [877221.0, 6593352.0],
                        [882664.0, 6589574.0],
                        [882486.0, 6586333.0],
                        [887558.0, 6582363.0],
                        [890444.0, 6576892.0],
                        [895736.0, 6577631.0],
                        [903737.0, 6585593.0],
                        [908880.0, 6582354.0],
                        [909869.0, 6577050.0],
                        [919460.0, 6577537.0],
                        [923919.0, 6580132.0],
                        [929573.0, 6589336.0],
                        [935280.0, 6595262.0],
                        [935835.0, 6600587.0],
                        [941800.0, 6609883.0],
                        [940343.0, 6611180.0],
                        [933274.0, 6616467.0],
                        [937312.0, 6621303.0],
                        [934547.0, 6625608.0],
                        [942748.0, 6631718.0],
                        [944367.0, 6635241.0],
                        [940225.0, 6640408.0],
                        [928880.0, 6645788.0],
                        [925393.0, 6653995.0],
                        [925599.0, 6657600.0],
                        [913780.0, 6661601.0],
                        [909981.0, 6669146.0],
                        [913407.0, 6674258.0],
                        [912920.0, 6678099.0],
                        [905832.0, 6683506.0],
                        [904021.0, 6688452.0],
                        [896736.0, 6687711.0],
                        [890265.0, 6692353.0],
                        [888032.0, 6690633.0],
                        [887407.0, 6682465.0],
                        [884880.0, 6674426.0],
                        [881002.0, 6667371.0],
                        [876191.0, 6666228.0],
                        [875449.0, 6660099.0],
                        [871408.0, 6655745.0],
                        [872158.0, 6650880.0],
                        [876345.0, 6647462.0],
                        [887343.0, 6642371.0],
                        [880659.0, 6638936.0],
                        [882575.0, 6628163.0],
                        [886706.0, 6618161.0],
                        [880824.0, 6605207.0],
                        [885325.0, 6599852.0],
                        [877344.0, 6596683.0],
                    ]
                ],
                "bbox": (871408.0, 6576892.0, 944367.0, 6692353.0),
            }
        },
        28: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [610874.0, 6360746.0],
                        [596271.0, 6358053.0],
                        [592401.0, 6355117.0],
                        [585843.0, 6356520.0],
                        [581893.0, 6352690.0],
                        [570617.0, 6348643.0],
                        [562737.0, 6350024.0],
                        [549131.0, 6360516.0],
                        [545774.0, 6366277.0],
                        [544593.0, 6364542.0],
                        [531660.0, 6365290.0],
                        [530427.0, 6360537.0],
                        [536387.0, 6355171.0],
                        [533815.0, 6350996.0],
                        [529462.0, 6338671.0],
                        [520115.0, 6336256.0],
                        [519117.0, 6332164.0],
                        [521740.0, 6328834.0],
                        [528536.0, 6329188.0],
                        [520187.0, 6318466.0],
                        [528381.0, 6316132.0],
                        [531142.0, 6309545.0],
                        [531445.0, 6300603.0],
                        [535303.0, 6300840.0],
                        [550735.0, 6304341.0],
                        [556606.0, 6298479.0],
                        [568130.0, 6303820.0],
                        [567948.0, 6310839.0],
                        [575242.0, 6309509.0],
                        [583992.0, 6314318.0],
                        [583816.0, 6319290.0],
                        [589156.0, 6320414.0],
                        [595091.0, 6325907.0],
                        [592665.0, 6336179.0],
                        [599594.0, 6336049.0],
                        [602120.0, 6333848.0],
                        [607335.0, 6338978.0],
                        [613603.0, 6341028.0],
                        [619220.0, 6339455.0],
                        [618185.0, 6342854.0],
                        [612268.0, 6345645.0],
                        [617826.0, 6353582.0],
                        [612319.0, 6353954.0],
                        [610874.0, 6360746.0],
                    ]
                ],
                "bbox": (519117.0, 6298479.0, 619220.0, 6366277.0),
            }
        },
        29: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [404251.0, 6660135.0],
                        [413368.0, 6662854.0],
                        [417889.0, 6660618.0],
                        [424993.0, 6661094.0],
                        [429262.0, 6663802.0],
                        [429925.0, 6668493.0],
                        [434893.0, 6670550.0],
                        [442005.0, 6668948.0],
                        [454238.0, 6672319.0],
                        [458546.0, 6672434.0],
                        [464624.0, 6667352.0],
                        [469141.0, 6670338.0],
                        [471947.0, 6677374.0],
                        [476861.0, 6677880.0],
                        [479254.0, 6691029.0],
                        [487846.0, 6706491.0],
                        [490772.0, 6714971.0],
                        [489539.0, 6719725.0],
                        [491931.0, 6726763.0],
                        [485937.0, 6723990.0],
                        [478533.0, 6727039.0],
                        [474490.0, 6731769.0],
                        [469484.0, 6733109.0],
                        [464631.0, 6730466.0],
                        [460339.0, 6732350.0],
                        [457617.0, 6739093.0],
                        [450112.0, 6740918.0],
                        [446732.0, 6745443.0],
                        [440863.0, 6746201.0],
                        [429458.0, 6743442.0],
                        [419671.0, 6744167.0],
                        [412442.0, 6746090.0],
                        [404251.0, 6751414.0],
                        [402067.0, 6747685.0],
                        [393110.0, 6750366.0],
                        [389872.0, 6749698.0],
                        [382932.0, 6754022.0],
                        [382163.0, 6750361.0],
                        [381255.0, 6745617.0],
                        [386987.0, 6740963.0],
                        [389301.0, 6732485.0],
                        [398982.0, 6728603.0],
                        [395905.0, 6725901.0],
                        [386462.0, 6727467.0],
                        [387234.0, 6720426.0],
                        [401401.0, 6717774.0],
                        [402393.0, 6705897.0],
                        [396890.0, 6703794.0],
                        [385609.0, 6704471.0],
                        [375470.0, 6701871.0],
                        [374867.0, 6698071.0],
                        [378391.0, 6691949.0],
                        [382659.0, 6691801.0],
                        [384839.0, 6683588.0],
                        [379159.0, 6679552.0],
                        [379298.0, 6676338.0],
                        [387784.0, 6670618.0],
                        [385082.0, 6667087.0],
                        [392012.0, 6664073.0],
                        [401283.0, 6663962.0],
                        [404251.0, 6660135.0],
                    ]
                ],
                "bbox": (374867.0, 6660135.0, 491931.0, 6754022.0),
            }
        },
        30: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [863140.0, 6525920.0],
                        [849404.0, 6524528.0],
                        [844536.0, 6535588.0],
                        [833933.0, 6540287.0],
                        [835850.0, 6543054.0],
                        [834501.0, 6551198.0],
                        [835220.0, 6556428.0],
                        [838741.0, 6561678.0],
                        [837322.0, 6565642.0],
                        [833486.0, 6565745.0],
                        [830305.0, 6579430.0],
                        [824653.0, 6575157.0],
                        [815826.0, 6575242.0],
                        [808209.0, 6578315.0],
                        [806993.0, 6569822.0],
                        [810991.0, 6564128.0],
                        [802035.0, 6559678.0],
                        [798995.0, 6551156.0],
                        [801039.0, 6547667.0],
                        [800220.0, 6540120.0],
                        [802643.0, 6534285.0],
                        [807296.0, 6530310.0],
                        [808147.0, 6518212.0],
                        [806255.0, 6511913.0],
                        [809870.0, 6504594.0],
                        [818524.0, 6498224.0],
                        [825934.0, 6498617.0],
                        [829797.0, 6488843.0],
                        [834511.0, 6489782.0],
                        [837308.0, 6485557.0],
                        [845846.0, 6493277.0],
                        [841056.0, 6498593.0],
                        [848198.0, 6502534.0],
                        [858527.0, 6506228.0],
                        [865784.0, 6514252.0],
                        [862850.0, 6517700.0],
                        [863140.0, 6525920.0],
                    ]
                ],
                "bbox": (798995.0, 6485557.0, 865784.0, 6579430.0),
            }
        },
        31: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [606642.0, 6924066.0],
                        [602657.0, 6922993.0],
                        [596650.0, 6927678.0],
                        [584841.0, 6929723.0],
                        [579971.0, 6928884.0],
                        [574422.0, 6917678.0],
                        [566281.0, 6917384.0],
                        [564288.0, 6913853.0],
                        [558013.0, 6912674.0],
                        [555352.0, 6907664.0],
                        [548914.0, 6917432.0],
                        [548813.0, 6922655.0],
                        [537794.0, 6926754.0],
                        [530512.0, 6925008.0],
                        [524567.0, 6928708.0],
                        [520591.0, 6933755.0],
                        [506978.0, 6930086.0],
                        [503908.0, 6928958.0],
                        [505278.0, 6914121.0],
                        [509502.0, 6910309.0],
                        [509950.0, 6897618.0],
                        [512079.0, 6895331.0],
                        [508338.0, 6886469.0],
                        [512505.0, 6881741.0],
                        [510545.0, 6875400.0],
                        [508448.0, 6870995.0],
                        [513552.0, 6867418.0],
                        [520512.0, 6866728.0],
                        [524600.0, 6861683.0],
                        [533488.0, 6856087.0],
                        [536389.0, 6850906.0],
                        [533024.0, 6847407.0],
                        [539112.0, 6843338.0],
                        [543803.0, 6848251.0],
                        [555241.0, 6849633.0],
                        [566604.0, 6854037.0],
                        [576482.0, 6852521.0],
                        [580772.0, 6855857.0],
                        [579784.0, 6860594.0],
                        [587701.0, 6866890.0],
                        [590236.0, 6872273.0],
                        [587216.0, 6881812.0],
                        [591984.0, 6886421.0],
                        [598361.0, 6887345.0],
                        [601892.0, 6893098.0],
                        [603501.0, 6902160.0],
                        [605624.0, 6904387.0],
                        [606128.0, 6907968.0],
                        [610931.0, 6911811.0],
                        [609871.0, 6919444.0],
                        [606642.0, 6924066.0],
                    ]
                ],
                "bbox": (503908.0, 6843338.0, 610931.0, 6933755.0),
            }
        },
        32: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [619220.0, 6339455.0],
                        [628552.0, 6344336.0],
                        [632260.0, 6344664.0],
                        [651092.0, 6332910.0],
                        [652742.0, 6328715.0],
                        [656723.0, 6328192.0],
                        [661724.0, 6320369.0],
                        [659810.0, 6316970.0],
                        [664259.0, 6313698.0],
                        [664946.0, 6304799.0],
                        [674324.0, 6293934.0],
                        [679276.0, 6292258.0],
                        [684993.0, 6295873.0],
                        [693643.0, 6293013.0],
                        [694796.0, 6288406.0],
                        [698819.0, 6289943.0],
                        [704898.0, 6288229.0],
                        [704815.0, 6303628.0],
                        [716344.0, 6301672.0],
                        [722102.0, 6311077.0],
                        [728786.0, 6312824.0],
                        [736140.0, 6324746.0],
                        [726344.0, 6331169.0],
                        [726879.0, 6340020.0],
                        [729879.0, 6341376.0],
                        [728598.0, 6344387.0],
                        [718362.0, 6347498.0],
                        [709994.0, 6353946.0],
                        [712305.0, 6356606.0],
                        [709537.0, 6364934.0],
                        [710800.0, 6372878.0],
                        [705449.0, 6378272.0],
                        [706639.0, 6384441.0],
                        [698547.0, 6393953.0],
                        [693924.0, 6403282.0],
                        [694820.0, 6408897.0],
                        [690477.0, 6411547.0],
                        [688126.0, 6419157.0],
                        [684359.0, 6419403.0],
                        [679353.0, 6426925.0],
                        [676829.0, 6423158.0],
                        [668604.0, 6416079.0],
                        [668313.0, 6410487.0],
                        [665404.0, 6408608.0],
                        [664849.0, 6402561.0],
                        [655192.0, 6393469.0],
                        [646639.0, 6396959.0],
                        [637228.0, 6394175.0],
                        [637122.0, 6391031.0],
                        [632813.0, 6386229.0],
                        [625170.0, 6387538.0],
                        [615061.0, 6379167.0],
                        [607709.0, 6375883.0],
                        [610874.0, 6360746.0],
                        [612319.0, 6353954.0],
                        [617826.0, 6353582.0],
                        [612268.0, 6345645.0],
                        [618185.0, 6342854.0],
                        [619220.0, 6339455.0],
                    ]
                ],
                "bbox": (607709.0, 6288229.0, 736140.0, 6426925.0),
            }
        },
        33: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [636090.0, 6591904.0],
                        [630016.0, 6590287.0],
                        [622684.0, 6592821.0],
                        [609355.0, 6592908.0],
                        [602234.0, 6588456.0],
                        [595863.0, 6588324.0],
                        [586530.0, 6592902.0],
                        [578129.0, 6584256.0],
                        [580236.0, 6579624.0],
                        [574730.0, 6569689.0],
                        [580656.0, 6565605.0],
                        [587795.0, 6549437.0],
                        [586335.0, 6540289.0],
                        [592200.0, 6538029.0],
                        [591561.0, 6529605.0],
                        [597279.0, 6527024.0],
                        [604752.0, 6527760.0],
                        [613074.0, 6522626.0],
                        [612524.0, 6515422.0],
                        [614305.0, 6511565.0],
                        [623634.0, 6517796.0],
                        [631053.0, 6514297.0],
                        [635791.0, 6515072.0],
                        [637278.0, 6511373.0],
                        [648450.0, 6509221.0],
                        [649366.0, 6512420.0],
                        [656101.0, 6511235.0],
                        [660507.0, 6515469.0],
                        [656022.0, 6519074.0],
                        [652489.0, 6525488.0],
                        [656753.0, 6529414.0],
                        [660605.0, 6529501.0],
                        [668605.0, 6543382.0],
                        [665172.0, 6557241.0],
                        [666451.0, 6560450.0],
                        [662729.0, 6571178.0],
                        [659880.0, 6575828.0],
                        [653217.0, 6581299.0],
                        [647921.0, 6581264.0],
                        [644784.0, 6591412.0],
                        [636090.0, 6591904.0],
                    ]
                ],
                "bbox": (574730.0, 6509221.0, 668605.0, 6592908.0),
            }
        },
        34: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [695265.0, 6784783.0],
                        [685053.0, 6785343.0],
                        [678166.0, 6780535.0],
                        [665644.0, 6782354.0],
                        [663338.0, 6793247.0],
                        [657236.0, 6795707.0],
                        [655721.0, 6802434.0],
                        [653275.0, 6801114.0],
                        [639308.0, 6801806.0],
                        [625387.0, 6798948.0],
                        [623220.0, 6795517.0],
                        [615539.0, 6776549.0],
                        [606511.0, 6774717.0],
                        [597558.0, 6774986.0],
                        [595216.0, 6770968.0],
                        [589165.0, 6770859.0],
                        [589601.0, 6765689.0],
                        [589886.0, 6759775.0],
                        [594464.0, 6753836.0],
                        [590280.0, 6747700.0],
                        [591237.0, 6742041.0],
                        [602374.0, 6738361.0],
                        [605429.0, 6729771.0],
                        [609792.0, 6727136.0],
                        [613256.0, 6732409.0],
                        [620646.0, 6731114.0],
                        [640167.0, 6731164.0],
                        [642856.0, 6724786.0],
                        [646396.0, 6725640.0],
                        [652875.0, 6720759.0],
                        [657729.0, 6723417.0],
                        [661757.0, 6718781.0],
                        [669909.0, 6717111.0],
                        [674282.0, 6709782.0],
                        [678869.0, 6710238.0],
                        [682544.0, 6713710.0],
                        [685430.0, 6710473.0],
                        [690565.0, 6713347.0],
                        [693556.0, 6718403.0],
                        [698236.0, 6718784.0],
                        [695341.0, 6722058.0],
                        [694231.0, 6731133.0],
                        [689391.0, 6734632.0],
                        [689262.0, 6740069.0],
                        [695135.0, 6740319.0],
                        [701782.0, 6742907.0],
                        [700769.0, 6756036.0],
                        [703743.0, 6756785.0],
                        [709585.0, 6763406.0],
                        [706580.0, 6772621.0],
                        [703759.0, 6774663.0],
                        [702192.0, 6781427.0],
                        [695265.0, 6784783.0],
                    ]
                ],
                "bbox": (589165.0, 6709782.0, 709585.0, 6802434.0),
            }
        },
        35: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [986052.0, 6752778.0],
                        [982963.0, 6756697.0],
                        [972278.0, 6762245.0],
                        [968808.0, 6766577.0],
                        [964569.0, 6761737.0],
                        [959909.0, 6759629.0],
                        [956126.0, 6765947.0],
                        [951150.0, 6767749.0],
                        [941726.0, 6764118.0],
                        [936416.0, 6766072.0],
                        [935284.0, 6772098.0],
                        [929025.0, 6772821.0],
                        [924039.0, 6766004.0],
                        [919858.0, 6768473.0],
                        [915394.0, 6762341.0],
                        [910900.0, 6755744.0],
                        [906433.0, 6754603.0],
                        [901288.0, 6749897.0],
                        [900414.0, 6745482.0],
                        [902985.0, 6741752.0],
                        [901778.0, 6735043.0],
                        [894824.0, 6733348.0],
                        [886220.0, 6734507.0],
                        [880542.0, 6733086.0],
                        [878352.0, 6725366.0],
                        [882147.0, 6728546.0],
                        [886108.0, 6726069.0],
                        [887785.0, 6718944.0],
                        [884206.0, 6713509.0],
                        [880595.0, 6713705.0],
                        [884919.0, 6701062.0],
                        [890265.0, 6692353.0],
                        [896736.0, 6687711.0],
                        [904021.0, 6688452.0],
                        [922029.0, 6697905.0],
                        [925719.0, 6696195.0],
                        [932449.0, 6699390.0],
                        [945847.0, 6708437.0],
                        [950918.0, 6717032.0],
                        [955890.0, 6718838.0],
                        [967469.0, 6716290.0],
                        [969354.0, 6721610.0],
                        [974258.0, 6721322.0],
                        [977033.0, 6724531.0],
                        [984341.0, 6721925.0],
                        [986155.0, 6724947.0],
                        [983826.0, 6731782.0],
                        [981470.0, 6745308.0],
                        [986052.0, 6752778.0],
                    ]
                ],
                "bbox": (878352.0, 6687711.0, 986155.0, 6772821.0),
            }
        },
        36: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [753779.0, 6537018.0],
                        [745523.0, 6547324.0],
                        [735860.0, 6546571.0],
                        [732386.0, 6552810.0],
                        [728730.0, 6550656.0],
                        [712873.0, 6551781.0],
                        [697819.0, 6557998.0],
                        [693029.0, 6567076.0],
                        [695157.0, 6571452.0],
                        [688886.0, 6572856.0],
                        [685369.0, 6566281.0],
                        [679424.0, 6569309.0],
                        [672252.0, 6557694.0],
                        [666451.0, 6560450.0],
                        [665172.0, 6557241.0],
                        [668605.0, 6543382.0],
                        [660605.0, 6529501.0],
                        [656753.0, 6529414.0],
                        [652489.0, 6525488.0],
                        [656022.0, 6519074.0],
                        [660507.0, 6515469.0],
                        [663288.0, 6509261.0],
                        [662164.0, 6504560.0],
                        [658322.0, 6500286.0],
                        [662264.0, 6494997.0],
                        [661594.0, 6486680.0],
                        [672750.0, 6482640.0],
                        [677684.0, 6475835.0],
                        [688449.0, 6477003.0],
                        [693859.0, 6474045.0],
                        [695974.0, 6467752.0],
                        [701310.0, 6465307.0],
                        [708104.0, 6472781.0],
                        [713160.0, 6472555.0],
                        [722742.0, 6478087.0],
                        [735734.0, 6477978.0],
                        [739202.0, 6481030.0],
                        [749018.0, 6471190.0],
                        [752222.0, 6475420.0],
                        [760473.0, 6472496.0],
                        [763248.0, 6477235.0],
                        [770263.0, 6473476.0],
                        [770335.0, 6479388.0],
                        [776221.0, 6483674.0],
                        [774454.0, 6495613.0],
                        [770440.0, 6500348.0],
                        [764154.0, 6503988.0],
                        [760734.0, 6514163.0],
                        [754369.0, 6520637.0],
                        [758503.0, 6532097.0],
                        [753779.0, 6537018.0],
                    ]
                ],
                "bbox": (652489.0, 6465307.0, 776221.0, 6572856.0),
            }
        },
        37: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [583992.0, 6314318.0],
                        [583878.0, 6308763.0],
                        [586632.0, 6302842.0],
                        [590928.0, 6301074.0],
                        [592076.0, 6294561.0],
                        [595737.0, 6291653.0],
                        [597601.0, 6285124.0],
                        [594074.0, 6282175.0],
                        [605052.0, 6276459.0],
                        [609628.0, 6269734.0],
                        [620519.0, 6263967.0],
                        [621363.0, 6260238.0],
                        [624846.0, 6255615.0],
                        [637154.0, 6259493.0],
                        [640013.0, 6262596.0],
                        [651680.0, 6257911.0],
                        [654081.0, 6259728.0],
                        [664821.0, 6258302.0],
                        [668090.0, 6259189.0],
                        [672444.0, 6264623.0],
                        [672394.0, 6269695.0],
                        [668935.0, 6274250.0],
                        [671212.0, 6283521.0],
                        [676690.0, 6282993.0],
                        [680178.0, 6279485.0],
                        [693221.0, 6284557.0],
                        [694796.0, 6288406.0],
                        [693643.0, 6293013.0],
                        [684993.0, 6295873.0],
                        [679276.0, 6292258.0],
                        [674324.0, 6293934.0],
                        [664946.0, 6304799.0],
                        [664259.0, 6313698.0],
                        [659810.0, 6316970.0],
                        [661724.0, 6320369.0],
                        [656723.0, 6328192.0],
                        [652742.0, 6328715.0],
                        [651092.0, 6332910.0],
                        [632260.0, 6344664.0],
                        [628552.0, 6344336.0],
                        [619220.0, 6339455.0],
                        [613603.0, 6341028.0],
                        [607335.0, 6338978.0],
                        [602120.0, 6333848.0],
                        [599594.0, 6336049.0],
                        [592665.0, 6336179.0],
                        [595091.0, 6325907.0],
                        [589156.0, 6320414.0],
                        [583816.0, 6319290.0],
                        [583992.0, 6314318.0],
                    ]
                ],
                "bbox": (583816.0, 6255615.0, 694796.0, 6344664.0),
            }
        },
        38: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [612314.0, 6962826.0],
                        [608347.0, 6970745.0],
                        [605014.0, 6980736.0],
                        [589321.0, 6994349.0],
                        [583880.0, 6997485.0],
                        [570354.0, 6986979.0],
                        [561015.0, 6982476.0],
                        [553619.0, 6982021.0],
                        [539569.0, 6977082.0],
                        [525341.0, 6975010.0],
                        [506777.0, 6963564.0],
                        [498821.0, 6960824.0],
                        [494437.0, 6953650.0],
                        [487453.0, 6938754.0],
                        [491281.0, 6933115.0],
                        [506978.0, 6930086.0],
                        [520591.0, 6933755.0],
                        [524567.0, 6928708.0],
                        [530512.0, 6925008.0],
                        [537794.0, 6926754.0],
                        [548813.0, 6922655.0],
                        [548914.0, 6917432.0],
                        [555352.0, 6907664.0],
                        [558013.0, 6912674.0],
                        [564288.0, 6913853.0],
                        [566281.0, 6917384.0],
                        [574422.0, 6917678.0],
                        [579971.0, 6928884.0],
                        [584841.0, 6929723.0],
                        [596650.0, 6927678.0],
                        [602657.0, 6922993.0],
                        [606642.0, 6924066.0],
                        [610545.0, 6930338.0],
                        [607205.0, 6935073.0],
                        [609123.0, 6937659.0],
                        [606321.0, 6945902.0],
                        [607933.0, 6953359.0],
                        [605401.0, 6955866.0],
                        [612314.0, 6962826.0],
                    ]
                ],
                "bbox": (487453.0, 6907664.0, 612314.0, 6997485.0),
            }
        },
        39: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [823302.0, 6827043.0],
                        [822210.0, 6820200.0],
                        [827022.0, 6811887.0],
                        [834073.0, 6806764.0],
                        [837935.0, 6797546.0],
                        [837598.0, 6783989.0],
                        [835407.0, 6779651.0],
                        [828770.0, 6781171.0],
                        [825768.0, 6776095.0],
                        [827043.0, 6770243.0],
                        [833398.0, 6769005.0],
                        [833316.0, 6764154.0],
                        [838226.0, 6763382.0],
                        [846087.0, 6753627.0],
                        [848388.0, 6746302.0],
                        [846031.0, 6742315.0],
                        [848455.0, 6733791.0],
                        [858300.0, 6729814.0],
                        [863148.0, 6730266.0],
                        [868188.0, 6726357.0],
                        [878352.0, 6725366.0],
                        [880542.0, 6733086.0],
                        [886220.0, 6734507.0],
                        [894824.0, 6733348.0],
                        [901778.0, 6735043.0],
                        [902985.0, 6741752.0],
                        [900414.0, 6745482.0],
                        [901288.0, 6749897.0],
                        [906433.0, 6754603.0],
                        [910900.0, 6755744.0],
                        [915394.0, 6762341.0],
                        [912655.0, 6766332.0],
                        [908017.0, 6765028.0],
                        [906998.0, 6773750.0],
                        [900794.0, 6778635.0],
                        [895837.0, 6779219.0],
                        [899609.0, 6786135.0],
                        [901295.0, 6794520.0],
                        [896020.0, 6796835.0],
                        [883843.0, 6809100.0],
                        [878315.0, 6811920.0],
                        [882722.0, 6816263.0],
                        [873603.0, 6822775.0],
                        [863008.0, 6828766.0],
                        [856191.0, 6834907.0],
                        [852692.0, 6834838.0],
                        [847795.0, 6838972.0],
                        [846365.0, 6844539.0],
                        [840675.0, 6844876.0],
                        [835676.0, 6840415.0],
                        [836281.0, 6837534.0],
                        [830469.0, 6833515.0],
                        [832829.0, 6827018.0],
                        [823302.0, 6827043.0],
                    ]
                ],
                "bbox": (822210.0, 6725366.0, 915394.0, 6844876.0),
            }
        },
        40: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [831641.0, 6353746.0],
                        [824346.0, 6357163.0],
                        [819866.0, 6361270.0],
                        [806518.0, 6360956.0],
                        [802764.0, 6358131.0],
                        [800494.0, 6352553.0],
                        [791158.0, 6357807.0],
                        [783861.0, 6358147.0],
                        [785084.0, 6367917.0],
                        [779411.0, 6373918.0],
                        [775211.0, 6367175.0],
                        [770571.0, 6365836.0],
                        [775941.0, 6359276.0],
                        [773621.0, 6356674.0],
                        [775968.0, 6350322.0],
                        [776174.0, 6341769.0],
                        [768987.0, 6337162.0],
                        [763780.0, 6336809.0],
                        [754256.0, 6342872.0],
                        [750995.0, 6342037.0],
                        [750700.0, 6336169.0],
                        [735189.0, 6336775.0],
                        [729879.0, 6341376.0],
                        [726879.0, 6340020.0],
                        [726344.0, 6331169.0],
                        [736140.0, 6324746.0],
                        [728786.0, 6312824.0],
                        [734096.0, 6312602.0],
                        [742673.0, 6306434.0],
                        [746263.0, 6307559.0],
                        [750088.0, 6313306.0],
                        [758340.0, 6319159.0],
                        [763184.0, 6318967.0],
                        [766255.0, 6313712.0],
                        [766790.0, 6307842.0],
                        [773726.0, 6310049.0],
                        [780634.0, 6301895.0],
                        [792244.0, 6293431.0],
                        [796379.0, 6284647.0],
                        [792922.0, 6276955.0],
                        [788998.0, 6273432.0],
                        [792112.0, 6270978.0],
                        [792074.0, 6265425.0],
                        [799607.0, 6263119.0],
                        [800175.0, 6267290.0],
                        [813903.0, 6274579.0],
                        [815212.0, 6281222.0],
                        [819908.0, 6290041.0],
                        [828463.0, 6288899.0],
                        [833168.0, 6302217.0],
                        [831988.0, 6308980.0],
                        [839658.0, 6315433.0],
                        [847769.0, 6322554.0],
                        [843231.0, 6331183.0],
                        [836689.0, 6335330.0],
                        [837656.0, 6344658.0],
                        [831641.0, 6353746.0],
                    ]
                ],
                "bbox": (726344.0, 6263119.0, 847769.0, 6373918.0),
            }
        },
        41: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1011125.0, 6809400.0],
                        [1016850.0, 6809125.0],
                        [1022638.0, 6802981.0],
                        [1032428.0, 6798669.0],
                        [1032222.0, 6793924.0],
                        [1036067.0, 6790258.0],
                        [1040408.0, 6789869.0],
                        [1046450.0, 6801750.0],
                        [1048508.0, 6811325.0],
                        [1051141.0, 6812923.0],
                        [1050303.0, 6822049.0],
                        [1052109.0, 6831679.0],
                        [1054677.0, 6834498.0],
                        [1054069.0, 6843233.0],
                        [1056359.0, 6848835.0],
                        [1064869.0, 6858273.0],
                        [1065247.0, 6862338.0],
                        [1074008.0, 6868775.0],
                        [1077114.0, 6879387.0],
                        [1081448.0, 6887616.0],
                        [1072364.0, 6888601.0],
                        [1060439.0, 6895482.0],
                        [1055798.0, 6892558.0],
                        [1050607.0, 6895578.0],
                        [1045763.0, 6893084.0],
                        [1038624.0, 6893752.0],
                        [1035096.0, 6882767.0],
                        [1032318.0, 6879884.0],
                        [1025429.0, 6883147.0],
                        [1016790.0, 6880171.0],
                        [1014136.0, 6883372.0],
                        [1005257.0, 6886565.0],
                        [1000174.0, 6890502.0],
                        [996400.0, 6888804.0],
                        [991999.0, 6880708.0],
                        [990508.0, 6874464.0],
                        [996607.0, 6871102.0],
                        [997609.0, 6864713.0],
                        [1002983.0, 6863593.0],
                        [1004387.0, 6868517.0],
                        [1016765.0, 6860562.0],
                        [1012123.0, 6851875.0],
                        [1015426.0, 6846104.0],
                        [1013753.0, 6840510.0],
                        [1007603.0, 6833382.0],
                        [1001023.0, 6834020.0],
                        [1004385.0, 6831654.0],
                        [1003109.0, 6819572.0],
                        [1005338.0, 6811635.0],
                        [1011125.0, 6809400.0],
                    ]
                ],
                "bbox": (990508.0, 6789869.0, 1081448.0, 6895578.0),
            }
        },
        42: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [719561.0, 6234874.0],
                        [716336.0, 6238907.0],
                        [711963.0, 6238657.0],
                        [700385.0, 6243263.0],
                        [700353.0, 6246775.0],
                        [686427.0, 6247043.0],
                        [681495.0, 6239871.0],
                        [667653.0, 6244475.0],
                        [662679.0, 6249784.0],
                        [664821.0, 6258302.0],
                        [654081.0, 6259728.0],
                        [651680.0, 6257911.0],
                        [640013.0, 6262596.0],
                        [637154.0, 6259493.0],
                        [624846.0, 6255615.0],
                        [621363.0, 6260238.0],
                        [611672.0, 6256714.0],
                        [607574.0, 6261192.0],
                        [603060.0, 6255463.0],
                        [603733.0, 6249863.0],
                        [598408.0, 6250205.0],
                        [593467.0, 6242482.0],
                        [596256.0, 6236985.0],
                        [595072.0, 6233132.0],
                        [604330.0, 6228108.0],
                        [614442.0, 6225039.0],
                        [613663.0, 6217624.0],
                        [617210.0, 6214637.0],
                        [617137.0, 6197372.0],
                        [608402.0, 6195450.0],
                        [610538.0, 6185966.0],
                        [614361.0, 6182470.0],
                        [622733.0, 6184536.0],
                        [632373.0, 6176261.0],
                        [631545.0, 6174170.0],
                        [644388.0, 6178927.0],
                        [647326.0, 6181831.0],
                        [644930.0, 6193342.0],
                        [655189.0, 6193206.0],
                        [659825.0, 6194610.0],
                        [675246.0, 6192375.0],
                        [678721.0, 6193157.0],
                        [682753.0, 6199641.0],
                        [688989.0, 6202113.0],
                        [693222.0, 6198384.0],
                        [703560.0, 6193187.0],
                        [704952.0, 6201963.0],
                        [703499.0, 6206754.0],
                        [709550.0, 6222514.0],
                        [719561.0, 6234874.0],
                    ]
                ],
                "bbox": (593467.0, 6174170.0, 719561.0, 6262596.0),
            }
        },
        43: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [695265.0, 6784783.0],
                        [700383.0, 6789702.0],
                        [703237.0, 6796855.0],
                        [703668.0, 6806647.0],
                        [712422.0, 6807964.0],
                        [727042.0, 6808060.0],
                        [730707.0, 6810078.0],
                        [728998.0, 6813854.0],
                        [731262.0, 6826009.0],
                        [737148.0, 6833964.0],
                        [740952.0, 6835710.0],
                        [733915.0, 6839303.0],
                        [735102.0, 6844463.0],
                        [732040.0, 6850473.0],
                        [735603.0, 6861428.0],
                        [729581.0, 6862815.0],
                        [724211.0, 6867685.0],
                        [722321.0, 6872132.0],
                        [712559.0, 6879371.0],
                        [712067.0, 6888882.0],
                        [705248.0, 6890863.0],
                        [700622.0, 6887964.0],
                        [680633.0, 6884542.0],
                        [673222.0, 6889902.0],
                        [670084.0, 6886723.0],
                        [667303.0, 6878971.0],
                        [670882.0, 6870004.0],
                        [667928.0, 6865519.0],
                        [670056.0, 6856451.0],
                        [671600.0, 6851283.0],
                        [668472.0, 6843626.0],
                        [665649.0, 6839786.0],
                        [666363.0, 6833836.0],
                        [663045.0, 6825117.0],
                        [663371.0, 6815578.0],
                        [665496.0, 6812431.0],
                        [657768.0, 6807009.0],
                        [655721.0, 6802434.0],
                        [657236.0, 6795707.0],
                        [663338.0, 6793247.0],
                        [665644.0, 6782354.0],
                        [678166.0, 6780535.0],
                        [685053.0, 6785343.0],
                        [695265.0, 6784783.0],
                    ]
                ],
                "bbox": (655721.0, 6780535.0, 740952.0, 6890863.0),
            }
        },
        44: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [706470.0, 6995042.0],
                        [691147.0, 6993758.0],
                        [689814.0, 6997681.0],
                        [669642.0, 7001764.0],
                        [667892.0, 7004913.0],
                        [662547.0, 7004433.0],
                        [658067.0, 7000416.0],
                        [656343.0, 7006536.0],
                        [663948.0, 7010834.0],
                        [660837.0, 7014835.0],
                        [654991.0, 7012592.0],
                        [648121.0, 7014552.0],
                        [635372.0, 7012312.0],
                        [634147.0, 7017146.0],
                        [624801.0, 7021563.0],
                        [622831.0, 7024302.0],
                        [612989.0, 7030025.0],
                        [605232.0, 7026713.0],
                        [603193.0, 7029103.0],
                        [596733.0, 7029014.0],
                        [595668.0, 7021497.0],
                        [599348.0, 7018454.0],
                        [591189.0, 7008466.0],
                        [589294.0, 7002423.0],
                        [583880.0, 6997485.0],
                        [589321.0, 6994349.0],
                        [605014.0, 6980736.0],
                        [608347.0, 6970745.0],
                        [612314.0, 6962826.0],
                        [620154.0, 6956108.0],
                        [623025.0, 6958366.0],
                        [636565.0, 6954687.0],
                        [645659.0, 6956103.0],
                        [654712.0, 6950974.0],
                        [664208.0, 6949037.0],
                        [669006.0, 6944292.0],
                        [676176.0, 6942514.0],
                        [677528.0, 6947426.0],
                        [685504.0, 6946842.0],
                        [685089.0, 6950779.0],
                        [693916.0, 6955962.0],
                        [708546.0, 6956332.0],
                        [705667.0, 6969289.0],
                        [708480.0, 6979518.0],
                        [713833.0, 6986563.0],
                        [712391.0, 6990404.0],
                        [706470.0, 6995042.0],
                    ]
                ],
                "bbox": (583880.0, 6942514.0, 713833.0, 7030025.0),
            }
        },
        45: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [708104.0, 6472781.0],
                        [709251.0, 6464988.0],
                        [717445.0, 6463649.0],
                        [722648.0, 6446835.0],
                        [725628.0, 6444038.0],
                        [723408.0, 6437470.0],
                        [727352.0, 6435060.0],
                        [728488.0, 6430309.0],
                        [732563.0, 6427378.0],
                        [732994.0, 6422485.0],
                        [737614.0, 6413026.0],
                        [746579.0, 6414955.0],
                        [746937.0, 6419760.0],
                        [752090.0, 6419191.0],
                        [752669.0, 6414624.0],
                        [758530.0, 6415778.0],
                        [768276.0, 6405343.0],
                        [774103.0, 6411136.0],
                        [781273.0, 6415520.0],
                        [782106.0, 6419872.0],
                        [791307.0, 6420019.0],
                        [796332.0, 6429870.0],
                        [801638.0, 6433950.0],
                        [808165.0, 6446004.0],
                        [808187.0, 6450395.0],
                        [813436.0, 6450097.0],
                        [816370.0, 6460772.0],
                        [811227.0, 6465007.0],
                        [806856.0, 6463705.0],
                        [807029.0, 6471772.0],
                        [802398.0, 6475469.0],
                        [792166.0, 6477709.0],
                        [780259.0, 6472021.0],
                        [776677.0, 6475557.0],
                        [770263.0, 6473476.0],
                        [763248.0, 6477235.0],
                        [760473.0, 6472496.0],
                        [752222.0, 6475420.0],
                        [749018.0, 6471190.0],
                        [739202.0, 6481030.0],
                        [735734.0, 6477978.0],
                        [722742.0, 6478087.0],
                        [713160.0, 6472555.0],
                        [708104.0, 6472781.0],
                    ]
                ],
                "bbox": (708104.0, 6405343.0, 816370.0, 6481030.0),
            }
        },
        46: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [776081.0, 6923412.0],
                        [775242.0, 6918312.0],
                        [767112.0, 6923360.0],
                        [761575.0, 6918670.0],
                        [747051.0, 6913033.0],
                        [751361.0, 6898188.0],
                        [745398.0, 6894771.0],
                        [743801.0, 6891376.0],
                        [747254.0, 6882494.0],
                        [744067.0, 6871735.0],
                        [738742.0, 6868146.0],
                        [735603.0, 6861428.0],
                        [732040.0, 6850473.0],
                        [735102.0, 6844463.0],
                        [733915.0, 6839303.0],
                        [740952.0, 6835710.0],
                        [746802.0, 6826973.0],
                        [753955.0, 6826609.0],
                        [760761.0, 6824301.0],
                        [769985.0, 6834113.0],
                        [773768.0, 6840880.0],
                        [779497.0, 6845091.0],
                        [785824.0, 6845891.0],
                        [797551.0, 6845278.0],
                        [796995.0, 6835851.0],
                        [803526.0, 6829924.0],
                        [814106.0, 6826118.0],
                        [819107.0, 6829393.0],
                        [823302.0, 6827043.0],
                        [832829.0, 6827018.0],
                        [830469.0, 6833515.0],
                        [836281.0, 6837534.0],
                        [835676.0, 6840415.0],
                        [840675.0, 6844876.0],
                        [846365.0, 6844539.0],
                        [846329.0, 6850924.0],
                        [838677.0, 6859119.0],
                        [841874.0, 6870868.0],
                        [848655.0, 6874905.0],
                        [848915.0, 6882413.0],
                        [846791.0, 6883540.0],
                        [845429.0, 6892400.0],
                        [841416.0, 6900107.0],
                        [842092.0, 6905887.0],
                        [837898.0, 6908256.0],
                        [833062.0, 6905548.0],
                        [822754.0, 6907655.0],
                        [818364.0, 6905215.0],
                        [814643.0, 6911926.0],
                        [803525.0, 6909934.0],
                        [795010.0, 6915033.0],
                        [790665.0, 6921022.0],
                        [782994.0, 6923346.0],
                        [776081.0, 6923412.0],
                    ]
                ],
                "bbox": (732040.0, 6824301.0, 848915.0, 6923412.0),
            }
        },
        47: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [428954.0, 6200122.0],
                        [442286.0, 6190571.0],
                        [445343.0, 6185147.0],
                        [453012.0, 6180794.0],
                        [468501.0, 6186020.0],
                        [475317.0, 6183479.0],
                        [477861.0, 6178841.0],
                        [483521.0, 6184043.0],
                        [489111.0, 6180226.0],
                        [493119.0, 6181125.0],
                        [491362.0, 6184305.0],
                        [492032.0, 6195420.0],
                        [493715.0, 6200925.0],
                        [501753.0, 6199863.0],
                        [506394.0, 6214104.0],
                        [501199.0, 6216194.0],
                        [498958.0, 6224762.0],
                        [491741.0, 6229153.0],
                        [500952.0, 6237523.0],
                        [501020.0, 6240519.0],
                        [506455.0, 6246240.0],
                        [505760.0, 6248691.0],
                        [496988.0, 6250664.0],
                        [479309.0, 6257879.0],
                        [471536.0, 6256527.0],
                        [468215.0, 6263513.0],
                        [466465.0, 6272970.0],
                        [461941.0, 6273297.0],
                        [457450.0, 6278664.0],
                        [456497.0, 6283051.0],
                        [449863.0, 6280833.0],
                        [454138.0, 6272903.0],
                        [451477.0, 6264635.0],
                        [457777.0, 6262698.0],
                        [452746.0, 6249402.0],
                        [454979.0, 6245934.0],
                        [446410.0, 6236240.0],
                        [443868.0, 6230545.0],
                        [440142.0, 6228799.0],
                        [437107.0, 6220297.0],
                        [431385.0, 6215423.0],
                        [431947.0, 6209367.0],
                        [428150.0, 6207547.0],
                        [428954.0, 6200122.0],
                    ]
                ],
                "bbox": (428150.0, 6178841.0, 506455.0, 6283051.0),
            }
        },
        48: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [547193.0, 6388334.0],
                        [542159.0, 6383881.0],
                        [541673.0, 6377661.0],
                        [545774.0, 6366277.0],
                        [549131.0, 6360516.0],
                        [562737.0, 6350024.0],
                        [570617.0, 6348643.0],
                        [581893.0, 6352690.0],
                        [585843.0, 6356520.0],
                        [592401.0, 6355117.0],
                        [596271.0, 6358053.0],
                        [610874.0, 6360746.0],
                        [607709.0, 6375883.0],
                        [615061.0, 6379167.0],
                        [625170.0, 6387538.0],
                        [632813.0, 6386229.0],
                        [637122.0, 6391031.0],
                        [634129.0, 6393565.0],
                        [633003.0, 6406356.0],
                        [634482.0, 6410441.0],
                        [628463.0, 6419614.0],
                        [626129.0, 6431248.0],
                        [613933.0, 6431618.0],
                        [607209.0, 6426078.0],
                        [601475.0, 6429196.0],
                        [593751.0, 6437105.0],
                        [584718.0, 6439628.0],
                        [577774.0, 6436765.0],
                        [574976.0, 6434607.0],
                        [576964.0, 6421036.0],
                        [570522.0, 6417080.0],
                        [570668.0, 6413830.0],
                        [564402.0, 6403210.0],
                        [559319.0, 6399932.0],
                        [553113.0, 6398528.0],
                        [553597.0, 6395079.0],
                        [547193.0, 6388334.0],
                    ]
                ],
                "bbox": (541673.0, 6348643.0, 637122.0, 6439628.0),
            }
        },
        49: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [992638.0, 6305621.0],
                        [997097.0, 6315251.0],
                        [1000978.0, 6315262.0],
                        [1007566.0, 6320724.0],
                        [1012050.0, 6317690.0],
                        [1014122.0, 6322114.0],
                        [1009068.0, 6324850.0],
                        [1007601.0, 6328762.0],
                        [1000089.0, 6334256.0],
                        [1000668.0, 6338218.0],
                        [994698.0, 6348019.0],
                        [997268.0, 6357103.0],
                        [1002665.0, 6364730.0],
                        [1009696.0, 6370071.0],
                        [1008626.0, 6382943.0],
                        [1006125.0, 6388590.0],
                        [1012175.0, 6394096.0],
                        [1012913.0, 6402904.0],
                        [1010207.0, 6403290.0],
                        [1004568.0, 6397351.0],
                        [999315.0, 6394909.0],
                        [992592.0, 6389297.0],
                        [988952.0, 6378656.0],
                        [983401.0, 6378221.0],
                        [971476.0, 6380340.0],
                        [967103.0, 6386021.0],
                        [957182.0, 6379131.0],
                        [959705.0, 6373500.0],
                        [957118.0, 6369997.0],
                        [950982.0, 6378672.0],
                        [944316.0, 6377139.0],
                        [935206.0, 6370624.0],
                        [932421.0, 6356788.0],
                        [925339.0, 6357350.0],
                        [930231.0, 6349978.0],
                        [920148.0, 6349530.0],
                        [913873.0, 6347227.0],
                        [911050.0, 6344481.0],
                        [905908.0, 6346585.0],
                        [903520.0, 6340766.0],
                        [899978.0, 6338355.0],
                        [900470.0, 6332559.0],
                        [903879.0, 6328807.0],
                        [901642.0, 6319541.0],
                        [909386.0, 6316209.0],
                        [907367.0, 6306820.0],
                        [913516.0, 6306489.0],
                        [922160.0, 6296144.0],
                        [923991.0, 6299127.0],
                        [933734.0, 6296912.0],
                        [944763.0, 6293054.0],
                        [956283.0, 6301072.0],
                        [958836.0, 6305328.0],
                        [970413.0, 6298787.0],
                        [974848.0, 6301646.0],
                        [974774.0, 6305117.0],
                        [983574.0, 6307147.0],
                        [992638.0, 6305621.0],
                    ]
                ],
                "bbox": (899978.0, 6293054.0, 1014122.0, 6403290.0),
            }
        },
        50: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [521086.0, 6735350.0],
                        [518605.0, 6737439.0],
                        [528757.0, 6745774.0],
                        [533549.0, 6751156.0],
                        [532634.0, 6757689.0],
                        [539183.0, 6762306.0],
                        [535875.0, 6773086.0],
                        [539332.0, 6780273.0],
                        [542578.0, 6786711.0],
                        [536374.0, 6790515.0],
                        [531913.0, 6790043.0],
                        [528051.0, 6796772.0],
                        [517130.0, 6797243.0],
                        [513744.0, 6803794.0],
                        [506061.0, 6806938.0],
                        [505117.0, 6820071.0],
                        [500193.0, 6823412.0],
                        [486746.0, 6818925.0],
                        [482552.0, 6813147.0],
                        [477803.0, 6815005.0],
                        [473893.0, 6813452.0],
                        [467628.0, 6811401.0],
                        [465298.0, 6799724.0],
                        [466280.0, 6794064.0],
                        [458409.0, 6789055.0],
                        [460615.0, 6783387.0],
                        [459373.0, 6778102.0],
                        [451057.0, 6776681.0],
                        [455060.0, 6767070.0],
                        [447308.0, 6764356.0],
                        [448124.0, 6758669.0],
                        [442128.0, 6753611.0],
                        [446459.0, 6750432.0],
                        [446732.0, 6745443.0],
                        [450112.0, 6740918.0],
                        [457617.0, 6739093.0],
                        [460339.0, 6732350.0],
                        [464631.0, 6730466.0],
                        [469484.0, 6733109.0],
                        [474490.0, 6731769.0],
                        [478533.0, 6727039.0],
                        [485937.0, 6723990.0],
                        [491931.0, 6726763.0],
                        [502971.0, 6722018.0],
                        [509057.0, 6729569.0],
                        [515591.0, 6731294.0],
                        [521086.0, 6735350.0],
                    ]
                ],
                "bbox": (442128.0, 6722018.0, 542578.0, 6823412.0),
            }
        },
        51: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [229520.0, 6710085.0],
                            [240383.0, 6704696.0],
                            [240163.0, 6708285.0],
                            [235835.0, 6713741.0],
                            [229006.0, 6716339.0],
                            [229520.0, 6710085.0],
                        ]
                    ],
                    [
                        [
                            [212687.0, 6770001.0],
                            [211559.0, 6762660.0],
                            [216528.0, 6752538.0],
                            [224759.0, 6753321.0],
                            [234540.0, 6747533.0],
                            [234220.0, 6745025.0],
                            [240082.0, 6736634.0],
                            [251238.0, 6736509.0],
                            [260889.0, 6740570.0],
                            [266327.0, 6740184.0],
                            [271833.0, 6736526.0],
                            [269308.0, 6731426.0],
                            [263161.0, 6733044.0],
                            [258643.0, 6731063.0],
                            [263631.0, 6725691.0],
                            [274085.0, 6728424.0],
                            [283689.0, 6728526.0],
                            [290663.0, 6724762.0],
                            [288997.0, 6719519.0],
                            [300067.0, 6720583.0],
                            [315995.0, 6726944.0],
                            [317487.0, 6738014.0],
                            [315562.0, 6748257.0],
                            [318803.0, 6749864.0],
                            [322365.0, 6758359.0],
                            [317839.0, 6765781.0],
                            [320890.0, 6769878.0],
                            [317014.0, 6776765.0],
                            [309516.0, 6779524.0],
                            [306739.0, 6782705.0],
                            [310549.0, 6787938.0],
                            [306966.0, 6794650.0],
                            [300637.0, 6793781.0],
                            [298204.0, 6799128.0],
                            [291749.0, 6798375.0],
                            [285132.0, 6789099.0],
                            [280665.0, 6785525.0],
                            [277875.0, 6787107.0],
                            [279762.0, 6794931.0],
                            [270150.0, 6795768.0],
                            [252150.0, 6805897.0],
                            [246074.0, 6807146.0],
                            [242780.0, 6802066.0],
                            [233945.0, 6800703.0],
                            [229439.0, 6804532.0],
                            [212675.0, 6807535.0],
                            [202658.0, 6804638.0],
                            [202166.0, 6798131.0],
                            [205220.0, 6785800.0],
                            [211608.0, 6786141.0],
                            [216607.0, 6782805.0],
                            [223352.0, 6780867.0],
                            [221788.0, 6771592.0],
                            [212687.0, 6770001.0],
                        ]
                    ],
                ],
                "bbox": (202166.0, 6704696.0, 322365.0, 6807535.0),
            }
        },
        52: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [539112.0, 6843338.0],
                        [541484.0, 6833537.0],
                        [549859.0, 6826656.0],
                        [547706.0, 6812952.0],
                        [543224.0, 6808364.0],
                        [535921.0, 6806758.0],
                        [534094.0, 6803079.0],
                        [538862.0, 6792254.0],
                        [536374.0, 6790515.0],
                        [542578.0, 6786711.0],
                        [539332.0, 6780273.0],
                        [551017.0, 6782681.0],
                        [551727.0, 6777731.0],
                        [559439.0, 6777275.0],
                        [559999.0, 6772636.0],
                        [566408.0, 6764638.0],
                        [573758.0, 6762848.0],
                        [589601.0, 6765689.0],
                        [589165.0, 6770859.0],
                        [595216.0, 6770968.0],
                        [597558.0, 6774986.0],
                        [606511.0, 6774717.0],
                        [615539.0, 6776549.0],
                        [623220.0, 6795517.0],
                        [625387.0, 6798948.0],
                        [624251.0, 6811501.0],
                        [620852.0, 6812073.0],
                        [620311.0, 6818025.0],
                        [611402.0, 6819097.0],
                        [608912.0, 6830618.0],
                        [604791.0, 6831646.0],
                        [597086.0, 6841311.0],
                        [595472.0, 6845570.0],
                        [596554.0, 6858123.0],
                        [594217.0, 6866696.0],
                        [590236.0, 6872273.0],
                        [587701.0, 6866890.0],
                        [579784.0, 6860594.0],
                        [580772.0, 6855857.0],
                        [576482.0, 6852521.0],
                        [566604.0, 6854037.0],
                        [555241.0, 6849633.0],
                        [543803.0, 6848251.0],
                        [539112.0, 6843338.0],
                    ]
                ],
                "bbox": (534094.0, 6762848.0, 625387.0, 6872273.0),
            }
        },
        53: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1232225.0, 6105798.0],
                        [1226359.0, 6102880.0],
                        [1217754.0, 6104291.0],
                        [1215715.0, 6123336.0],
                        [1210743.0, 6122769.0],
                        [1206639.0, 6131576.0],
                        [1202519.0, 6133762.0],
                        [1199675.0, 6142105.0],
                        [1187662.0, 6146432.0],
                        [1180116.0, 6152978.0],
                        [1164950.0, 6158109.0],
                        [1159342.0, 6158599.0],
                        [1169805.0, 6146197.0],
                        [1163901.0, 6144874.0],
                        [1160274.0, 6141810.0],
                        [1162433.0, 6134554.0],
                        [1168722.0, 6128275.0],
                        [1172897.0, 6127710.0],
                        [1175910.0, 6121801.0],
                        [1169135.0, 6117789.0],
                        [1170381.0, 6114875.0],
                        [1164715.0, 6111213.0],
                        [1168686.0, 6106658.0],
                        [1175324.0, 6107066.0],
                        [1177911.0, 6109856.0],
                        [1182246.0, 6105577.0],
                        [1180256.0, 6096485.0],
                        [1173562.0, 6088828.0],
                        [1176478.0, 6086334.0],
                        [1193164.0, 6083876.0],
                        [1190373.0, 6079505.0],
                        [1183548.0, 6076443.0],
                        [1183755.0, 6068439.0],
                        [1188281.0, 6067524.0],
                        [1196826.0, 6061810.0],
                        [1209242.0, 6057430.0],
                        [1210610.0, 6054235.0],
                        [1221376.0, 6050136.0],
                        [1221646.0, 6056536.0],
                        [1224377.0, 6061299.0],
                        [1225618.0, 6068574.0],
                        [1229809.0, 6072152.0],
                        [1228158.0, 6078400.0],
                        [1232811.0, 6083356.0],
                        [1233466.0, 6095728.0],
                        [1232225.0, 6105798.0],
                    ]
                ],
                "bbox": (1159342.0, 6050136.0, 1233466.0, 6158599.0),
            }
        },
        54: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [879041.0, 6935896.0],
                        [878534.0, 6930925.0],
                        [883576.0, 6926040.0],
                        [891117.0, 6929633.0],
                        [895087.0, 6927281.0],
                        [898652.0, 6915853.0],
                        [898091.0, 6905220.0],
                        [901547.0, 6903348.0],
                        [900172.0, 6898682.0],
                        [901739.0, 6893315.0],
                        [905859.0, 6891045.0],
                        [906433.0, 6884047.0],
                        [905066.0, 6875501.0],
                        [901302.0, 6871865.0],
                        [904125.0, 6862116.0],
                        [899528.0, 6852809.0],
                        [902927.0, 6847494.0],
                        [903561.0, 6837915.0],
                        [900379.0, 6832469.0],
                        [904895.0, 6830283.0],
                        [904250.0, 6825381.0],
                        [910921.0, 6826770.0],
                        [919362.0, 6809623.0],
                        [930831.0, 6810526.0],
                        [935203.0, 6815546.0],
                        [963830.0, 6819154.0],
                        [964951.0, 6823820.0],
                        [973656.0, 6818945.0],
                        [982282.0, 6817771.0],
                        [987769.0, 6820181.0],
                        [994239.0, 6827289.0],
                        [1004385.0, 6831654.0],
                        [1001023.0, 6834020.0],
                        [993487.0, 6842033.0],
                        [983189.0, 6843093.0],
                        [976380.0, 6847597.0],
                        [971773.0, 6847764.0],
                        [969100.0, 6851558.0],
                        [964692.0, 6852206.0],
                        [961206.0, 6856322.0],
                        [946451.0, 6858744.0],
                        [945024.0, 6864515.0],
                        [939656.0, 6875317.0],
                        [929417.0, 6875078.0],
                        [928151.0, 6878713.0],
                        [922735.0, 6879575.0],
                        [922708.0, 6883240.0],
                        [914442.0, 6889764.0],
                        [914011.0, 6893894.0],
                        [920671.0, 6900380.0],
                        [917676.0, 6905219.0],
                        [920628.0, 6907653.0],
                        [912688.0, 6923499.0],
                        [913390.0, 6932141.0],
                        [909643.0, 6936903.0],
                        [902225.0, 6942685.0],
                        [896580.0, 6941163.0],
                        [892512.0, 6942531.0],
                        [879041.0, 6935896.0],
                    ]
                ],
                "bbox": (878534.0, 6809623.0, 1004385.0, 6942685.0),
            }
        },
        55: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [510545.0, 6875400.0],
                        [504730.0, 6874732.0],
                        [500558.0, 6877307.0],
                        [491678.0, 6873174.0],
                        [489675.0, 6876299.0],
                        [484257.0, 6870962.0],
                        [475607.0, 6865852.0],
                        [469104.0, 6863978.0],
                        [457511.0, 6867107.0],
                        [454384.0, 6863198.0],
                        [449827.0, 6868751.0],
                        [446005.0, 6869054.0],
                        [427244.0, 6861949.0],
                        [417723.0, 6857101.0],
                        [420581.0, 6852284.0],
                        [423498.0, 6841841.0],
                        [421619.0, 6835816.0],
                        [414934.0, 6829326.0],
                        [422197.0, 6821752.0],
                        [429868.0, 6822252.0],
                        [437568.0, 6825109.0],
                        [441174.0, 6828584.0],
                        [446687.0, 6829012.0],
                        [451256.0, 6826715.0],
                        [457920.0, 6827997.0],
                        [463434.0, 6833996.0],
                        [466087.0, 6830999.0],
                        [467262.0, 6822174.0],
                        [474394.0, 6821359.0],
                        [473893.0, 6813452.0],
                        [477803.0, 6815005.0],
                        [482552.0, 6813147.0],
                        [486746.0, 6818925.0],
                        [500193.0, 6823412.0],
                        [505117.0, 6820071.0],
                        [506061.0, 6806938.0],
                        [513744.0, 6803794.0],
                        [517130.0, 6797243.0],
                        [528051.0, 6796772.0],
                        [531913.0, 6790043.0],
                        [536374.0, 6790515.0],
                        [538862.0, 6792254.0],
                        [534094.0, 6803079.0],
                        [535921.0, 6806758.0],
                        [543224.0, 6808364.0],
                        [547706.0, 6812952.0],
                        [549859.0, 6826656.0],
                        [541484.0, 6833537.0],
                        [539112.0, 6843338.0],
                        [533024.0, 6847407.0],
                        [536389.0, 6850906.0],
                        [533488.0, 6856087.0],
                        [524600.0, 6861683.0],
                        [520512.0, 6866728.0],
                        [513552.0, 6867418.0],
                        [508448.0, 6870995.0],
                        [510545.0, 6875400.0],
                    ]
                ],
                "bbox": (414934.0, 6790043.0, 549859.0, 6877307.0),
            }
        },
        56: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [877344.0, 6596683.0],
                        [869949.0, 6598870.0],
                        [868758.0, 6603264.0],
                        [857422.0, 6600366.0],
                        [848718.0, 6603737.0],
                        [845229.0, 6595067.0],
                        [845050.0, 6590960.0],
                        [839484.0, 6574938.0],
                        [837322.0, 6565642.0],
                        [838741.0, 6561678.0],
                        [835220.0, 6556428.0],
                        [834501.0, 6551198.0],
                        [835850.0, 6543054.0],
                        [833933.0, 6540287.0],
                        [844536.0, 6535588.0],
                        [849404.0, 6524528.0],
                        [863140.0, 6525920.0],
                        [870291.0, 6521483.0],
                        [876089.0, 6523611.0],
                        [879159.0, 6530984.0],
                        [882529.0, 6534232.0],
                        [888996.0, 6528631.0],
                        [888123.0, 6525941.0],
                        [897998.0, 6515860.0],
                        [904449.0, 6504924.0],
                        [909413.0, 6509006.0],
                        [910338.0, 6515974.0],
                        [915868.0, 6518199.0],
                        [916332.0, 6528631.0],
                        [919315.0, 6541572.0],
                        [917441.0, 6547210.0],
                        [916992.0, 6555432.0],
                        [918731.0, 6560168.0],
                        [928176.0, 6563414.0],
                        [933670.0, 6575392.0],
                        [940629.0, 6577110.0],
                        [938817.0, 6580823.0],
                        [943610.0, 6590224.0],
                        [935280.0, 6595262.0],
                        [929573.0, 6589336.0],
                        [923919.0, 6580132.0],
                        [919460.0, 6577537.0],
                        [909869.0, 6577050.0],
                        [908880.0, 6582354.0],
                        [903737.0, 6585593.0],
                        [895736.0, 6577631.0],
                        [890444.0, 6576892.0],
                        [887558.0, 6582363.0],
                        [882486.0, 6586333.0],
                        [882664.0, 6589574.0],
                        [877221.0, 6593352.0],
                        [877344.0, 6596683.0],
                    ]
                ],
                "bbox": (833933.0, 6504924.0, 943610.0, 6603737.0),
            }
        },
        57: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [524704.0, 6194181.0],
                        [530246.0, 6189977.0],
                        [542336.0, 6189236.0],
                        [549247.0, 6180805.0],
                        [554894.0, 6182516.0],
                        [562658.0, 6181937.0],
                        [567864.0, 6177510.0],
                        [571419.0, 6168649.0],
                        [580902.0, 6173997.0],
                        [585134.0, 6170835.0],
                        [592180.0, 6170254.0],
                        [600206.0, 6164532.0],
                        [607482.0, 6165290.0],
                        [615529.0, 6169131.0],
                        [617954.0, 6174066.0],
                        [631545.0, 6174170.0],
                        [632373.0, 6176261.0],
                        [622733.0, 6184536.0],
                        [614361.0, 6182470.0],
                        [610538.0, 6185966.0],
                        [608402.0, 6195450.0],
                        [617137.0, 6197372.0],
                        [617210.0, 6214637.0],
                        [613663.0, 6217624.0],
                        [614442.0, 6225039.0],
                        [604330.0, 6228108.0],
                        [595072.0, 6233132.0],
                        [596256.0, 6236985.0],
                        [593467.0, 6242482.0],
                        [589272.0, 6240503.0],
                        [582028.0, 6242918.0],
                        [575081.0, 6235814.0],
                        [572065.0, 6240985.0],
                        [565565.0, 6247682.0],
                        [561407.0, 6244405.0],
                        [567825.0, 6236309.0],
                        [562910.0, 6233771.0],
                        [555809.0, 6233248.0],
                        [554118.0, 6225953.0],
                        [547328.0, 6230443.0],
                        [541984.0, 6228895.0],
                        [540236.0, 6224348.0],
                        [535770.0, 6220735.0],
                        [537386.0, 6214080.0],
                        [535012.0, 6210452.0],
                        [526458.0, 6208824.0],
                        [522873.0, 6204718.0],
                        [524704.0, 6194181.0],
                    ]
                ],
                "bbox": (522873.0, 6164532.0, 632373.0, 6247682.0),
            }
        },
        58: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [563452.0, 6484264.0],
                        [563844.0, 6479160.0],
                        [568750.0, 6477311.0],
                        [560988.0, 6465186.0],
                        [564865.0, 6461779.0],
                        [566113.0, 6450433.0],
                        [573095.0, 6446142.0],
                        [577774.0, 6436765.0],
                        [584718.0, 6439628.0],
                        [593751.0, 6437105.0],
                        [601475.0, 6429196.0],
                        [607209.0, 6426078.0],
                        [613933.0, 6431618.0],
                        [626129.0, 6431248.0],
                        [631663.0, 6432186.0],
                        [628772.0, 6440050.0],
                        [634831.0, 6442812.0],
                        [638218.0, 6451518.0],
                        [636846.0, 6458269.0],
                        [642886.0, 6465907.0],
                        [649118.0, 6470007.0],
                        [651369.0, 6479623.0],
                        [656321.0, 6476249.0],
                        [659915.0, 6480065.0],
                        [661594.0, 6486680.0],
                        [662264.0, 6494997.0],
                        [658322.0, 6500286.0],
                        [662164.0, 6504560.0],
                        [663288.0, 6509261.0],
                        [660507.0, 6515469.0],
                        [656101.0, 6511235.0],
                        [649366.0, 6512420.0],
                        [648450.0, 6509221.0],
                        [637278.0, 6511373.0],
                        [635791.0, 6515072.0],
                        [631053.0, 6514297.0],
                        [623634.0, 6517796.0],
                        [614305.0, 6511565.0],
                        [612121.0, 6507862.0],
                        [605337.0, 6509707.0],
                        [593766.0, 6498788.0],
                        [587429.0, 6495459.0],
                        [581471.0, 6497412.0],
                        [576059.0, 6493313.0],
                        [571080.0, 6486618.0],
                        [566212.0, 6489282.0],
                        [563452.0, 6484264.0],
                    ]
                ],
                "bbox": (560988.0, 6426078.0, 663288.0, 6517796.0),
            }
        },
        59: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [987691.0, 6753958.0],
                        [989189.0, 6749828.0],
                        [1000830.0, 6745745.0],
                        [1003510.0, 6737902.0],
                        [1000706.0, 6731961.0],
                        [1006958.0, 6729298.0],
                        [1010786.0, 6719537.0],
                        [1014326.0, 6713511.0],
                        [1019985.0, 6711034.0],
                        [1024064.0, 6712992.0],
                        [1031730.0, 6713160.0],
                        [1039126.0, 6720266.0],
                        [1038581.0, 6725392.0],
                        [1044459.0, 6729657.0],
                        [1044908.0, 6732411.0],
                        [1039238.0, 6738821.0],
                        [1038337.0, 6743276.0],
                        [1040672.0, 6747502.0],
                        [1039113.0, 6752662.0],
                        [1040418.0, 6763108.0],
                        [1044697.0, 6773634.0],
                        [1040564.0, 6779861.0],
                        [1040408.0, 6789869.0],
                        [1036067.0, 6790258.0],
                        [1032222.0, 6793924.0],
                        [1032428.0, 6798669.0],
                        [1022638.0, 6802981.0],
                        [1016850.0, 6809125.0],
                        [1011125.0, 6809400.0],
                        [1006708.0, 6801985.0],
                        [1001795.0, 6789636.0],
                        [998205.0, 6776671.0],
                        [993983.0, 6773739.0],
                        [991355.0, 6761730.0],
                        [993060.0, 6757264.0],
                        [987691.0, 6753958.0],
                    ]
                ],
                "bbox": (987691.0, 6711034.0, 1044908.0, 6809400.0),
            }
        },
        60: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [573297.0, 6677558.0],
                        [569696.0, 6685244.0],
                        [565759.0, 6689706.0],
                        [561058.0, 6687382.0],
                        [557051.0, 6690388.0],
                        [558309.0, 6696538.0],
                        [557303.0, 6702930.0],
                        [559271.0, 6706788.0],
                        [552945.0, 6716389.0],
                        [555366.0, 6719856.0],
                        [552256.0, 6724799.0],
                        [543743.0, 6727862.0],
                        [539386.0, 6732046.0],
                        [530153.0, 6735215.0],
                        [521086.0, 6735350.0],
                        [515591.0, 6731294.0],
                        [509057.0, 6729569.0],
                        [502971.0, 6722018.0],
                        [491931.0, 6726763.0],
                        [489539.0, 6719725.0],
                        [490772.0, 6714971.0],
                        [487846.0, 6706491.0],
                        [479254.0, 6691029.0],
                        [476861.0, 6677880.0],
                        [478404.0, 6673399.0],
                        [482922.0, 6672972.0],
                        [485608.0, 6667284.0],
                        [494947.0, 6665028.0],
                        [494833.0, 6656131.0],
                        [505157.0, 6650870.0],
                        [510389.0, 6653999.0],
                        [517389.0, 6653506.0],
                        [515158.0, 6658631.0],
                        [524608.0, 6655240.0],
                        [525272.0, 6647330.0],
                        [531658.0, 6641492.0],
                        [533123.0, 6635020.0],
                        [537221.0, 6629765.0],
                        [546519.0, 6631001.0],
                        [551779.0, 6655211.0],
                        [553982.0, 6659068.0],
                        [560408.0, 6661557.0],
                        [568878.0, 6661167.0],
                        [571950.0, 6667671.0],
                        [576079.0, 6670370.0],
                        [573297.0, 6677558.0],
                    ]
                ],
                "bbox": (476861.0, 6629765.0, 576079.0, 6735350.0),
            }
        },
        61: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [634422.0, 7101577.0],
                        [636514.0, 7100652.0],
                        [642453.0, 7087769.0],
                        [644454.0, 7079622.0],
                        [653390.0, 7071778.0],
                        [658064.0, 7064147.0],
                        [664277.0, 7059477.0],
                        [673807.0, 7057943.0],
                        [679720.0, 7059405.0],
                        [683642.0, 7063001.0],
                        [688698.0, 7062196.0],
                        [686184.0, 7056263.0],
                        [687641.0, 7047582.0],
                        [692820.0, 7044918.0],
                        [697493.0, 7046164.0],
                        [701478.0, 7042709.0],
                        [702680.0, 7038239.0],
                        [699507.0, 7031355.0],
                        [712383.0, 7015916.0],
                        [711164.0, 7009522.0],
                        [706855.0, 7002888.0],
                        [706470.0, 6995042.0],
                        [712391.0, 6990404.0],
                        [716534.0, 6992565.0],
                        [720100.0, 6990781.0],
                        [725313.0, 6993104.0],
                        [735248.0, 6991264.0],
                        [739058.0, 6995179.0],
                        [744014.0, 6992056.0],
                        [751253.0, 6997000.0],
                        [753505.0, 6995276.0],
                        [766237.0, 6992385.0],
                        [770359.0, 6988977.0],
                        [778060.0, 6986162.0],
                        [781905.0, 6987282.0],
                        [783321.0, 6995122.0],
                        [788006.0, 6997129.0],
                        [785882.0, 7004302.0],
                        [780654.0, 7004663.0],
                        [782919.0, 7012216.0],
                        [787237.0, 7018342.0],
                        [781127.0, 7020183.0],
                        [773958.0, 7027731.0],
                        [768979.0, 7028494.0],
                        [763439.0, 7026158.0],
                        [760772.0, 7028536.0],
                        [753265.0, 7028386.0],
                        [749524.0, 7024442.0],
                        [746894.0, 7030603.0],
                        [747241.0, 7039722.0],
                        [743565.0, 7044070.0],
                        [733656.0, 7048580.0],
                        [726572.0, 7043892.0],
                        [720348.0, 7047849.0],
                        [717610.0, 7060148.0],
                        [718286.0, 7067127.0],
                        [713527.0, 7069761.0],
                        [710740.0, 7076212.0],
                        [704337.0, 7075998.0],
                        [695621.0, 7071968.0],
                        [692807.0, 7066387.0],
                        [686789.0, 7068929.0],
                        [680050.0, 7079722.0],
                        [674224.0, 7079651.0],
                        [671748.0, 7084186.0],
                        [674131.0, 7094505.0],
                        [670178.0, 7102078.0],
                        [667909.0, 7110430.0],
                        [659576.0, 7106814.0],
                        [654175.0, 7107325.0],
                        [637372.0, 7101244.0],
                        [634422.0, 7101577.0],
                    ]
                ],
                "bbox": (634422.0, 6986162.0, 788006.0, 7110430.0),
            }
        },
        62: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1010786.0, 6719537.0],
                        [1006958.0, 6729298.0],
                        [1000706.0, 6731961.0],
                        [1003510.0, 6737902.0],
                        [1000830.0, 6745745.0],
                        [989189.0, 6749828.0],
                        [987691.0, 6753958.0],
                        [986052.0, 6752778.0],
                        [981470.0, 6745308.0],
                        [983826.0, 6731782.0],
                        [986155.0, 6724947.0],
                        [993651.0, 6723596.0],
                        [994087.0, 6717743.0],
                        [996902.0, 6711079.0],
                        [1001194.0, 6713400.0],
                        [999772.0, 6717889.0],
                        [1007028.0, 6717766.0],
                        [1010786.0, 6719537.0],
                    ]
                ],
                "bbox": (981470.0, 6711079.0, 1010786.0, 6753958.0),
            }
        },
        63: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [382163.0, 6750361.0],
                        [374291.0, 6753124.0],
                        [371672.0, 6756673.0],
                        [356172.0, 6751743.0],
                        [351165.0, 6744974.0],
                        [342268.0, 6743932.0],
                        [335469.0, 6745297.0],
                        [327477.0, 6743723.0],
                        [317487.0, 6738014.0],
                        [315995.0, 6726944.0],
                        [300067.0, 6720583.0],
                        [288997.0, 6719519.0],
                        [282806.0, 6712695.0],
                        [283678.0, 6703214.0],
                        [288393.0, 6698809.0],
                        [292251.0, 6700736.0],
                        [299211.0, 6695249.0],
                        [308160.0, 6699576.0],
                        [309828.0, 6691500.0],
                        [308860.0, 6686791.0],
                        [304084.0, 6683183.0],
                        [316935.0, 6678247.0],
                        [322009.0, 6670666.0],
                        [324590.0, 6666698.0],
                        [332678.0, 6659222.0],
                        [338731.0, 6658583.0],
                        [343129.0, 6653969.0],
                        [353671.0, 6649968.0],
                        [357453.0, 6652400.0],
                        [354064.0, 6663454.0],
                        [354394.0, 6667534.0],
                        [359840.0, 6669393.0],
                        [361112.0, 6656907.0],
                        [367588.0, 6659427.0],
                        [367645.0, 6668175.0],
                        [374065.0, 6668782.0],
                        [376108.0, 6673611.0],
                        [385082.0, 6667087.0],
                        [387784.0, 6670618.0],
                        [379298.0, 6676338.0],
                        [379159.0, 6679552.0],
                        [384839.0, 6683588.0],
                        [382659.0, 6691801.0],
                        [378391.0, 6691949.0],
                        [374867.0, 6698071.0],
                        [375470.0, 6701871.0],
                        [385609.0, 6704471.0],
                        [396890.0, 6703794.0],
                        [402393.0, 6705897.0],
                        [401401.0, 6717774.0],
                        [387234.0, 6720426.0],
                        [386462.0, 6727467.0],
                        [395905.0, 6725901.0],
                        [398982.0, 6728603.0],
                        [389301.0, 6732485.0],
                        [386987.0, 6740963.0],
                        [381255.0, 6745617.0],
                        [382163.0, 6750361.0],
                    ]
                ],
                "bbox": (282806.0, 6649968.0, 402393.0, 6756673.0),
            }
        },
        64: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [698236.0, 6718784.0],
                        [701928.0, 6717598.0],
                        [707666.0, 6720847.0],
                        [709181.0, 6715638.0],
                        [715400.0, 6713642.0],
                        [717731.0, 6709895.0],
                        [723118.0, 6710529.0],
                        [726085.0, 6708066.0],
                        [729904.0, 6712131.0],
                        [736733.0, 6710509.0],
                        [738638.0, 6714270.0],
                        [743712.0, 6710994.0],
                        [743701.0, 6707332.0],
                        [751168.0, 6705240.0],
                        [753904.0, 6700965.0],
                        [759265.0, 6699206.0],
                        [773240.0, 6698003.0],
                        [773484.0, 6692940.0],
                        [783517.0, 6693799.0],
                        [780393.0, 6701310.0],
                        [784360.0, 6705398.0],
                        [783952.0, 6713331.0],
                        [788376.0, 6717645.0],
                        [791050.0, 6725986.0],
                        [795163.0, 6731989.0],
                        [794312.0, 6737086.0],
                        [799827.0, 6740411.0],
                        [799053.0, 6750471.0],
                        [794318.0, 6750026.0],
                        [796594.0, 6759156.0],
                        [789480.0, 6763963.0],
                        [783028.0, 6759096.0],
                        [767353.0, 6760249.0],
                        [763413.0, 6765164.0],
                        [759917.0, 6778325.0],
                        [755033.0, 6785741.0],
                        [749678.0, 6782304.0],
                        [746161.0, 6791892.0],
                        [745765.0, 6796957.0],
                        [736893.0, 6807760.0],
                        [730707.0, 6810078.0],
                        [727042.0, 6808060.0],
                        [712422.0, 6807964.0],
                        [703668.0, 6806647.0],
                        [703237.0, 6796855.0],
                        [700383.0, 6789702.0],
                        [695265.0, 6784783.0],
                        [702192.0, 6781427.0],
                        [703759.0, 6774663.0],
                        [706580.0, 6772621.0],
                        [709585.0, 6763406.0],
                        [703743.0, 6756785.0],
                        [700769.0, 6756036.0],
                        [701782.0, 6742907.0],
                        [695135.0, 6740319.0],
                        [689262.0, 6740069.0],
                        [689391.0, 6734632.0],
                        [694231.0, 6731133.0],
                        [695341.0, 6722058.0],
                        [698236.0, 6718784.0],
                    ]
                ],
                "bbox": (689262.0, 6692940.0, 799827.0, 6810078.0),
            }
        },
        65: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [330825.0, 6841252.0],
                            [328251.0, 6849310.0],
                            [322500.0, 6846053.0],
                            [325749.0, 6841751.0],
                            [330825.0, 6841252.0],
                        ]
                    ],
                    [
                        [
                            [399495.0, 6830885.0],
                            [389634.0, 6835155.0],
                            [384742.0, 6834496.0],
                            [376536.0, 6826525.0],
                            [368413.0, 6830443.0],
                            [366767.0, 6839135.0],
                            [363309.0, 6845999.0],
                            [348952.0, 6844300.0],
                            [343084.0, 6846084.0],
                            [341341.0, 6849649.0],
                            [342875.0, 6855953.0],
                            [334395.0, 6854417.0],
                            [329772.0, 6850320.0],
                            [334969.0, 6837949.0],
                            [337450.0, 6835570.0],
                            [332923.0, 6813386.0],
                            [328273.0, 6809495.0],
                            [325505.0, 6811765.0],
                            [320973.0, 6806998.0],
                            [315234.0, 6806646.0],
                            [311879.0, 6798427.0],
                            [306966.0, 6794650.0],
                            [310549.0, 6787938.0],
                            [306739.0, 6782705.0],
                            [309516.0, 6779524.0],
                            [317014.0, 6776765.0],
                            [320890.0, 6769878.0],
                            [317839.0, 6765781.0],
                            [322365.0, 6758359.0],
                            [318803.0, 6749864.0],
                            [315562.0, 6748257.0],
                            [317487.0, 6738014.0],
                            [327477.0, 6743723.0],
                            [335469.0, 6745297.0],
                            [342268.0, 6743932.0],
                            [351165.0, 6744974.0],
                            [356172.0, 6751743.0],
                            [371672.0, 6756673.0],
                            [374291.0, 6753124.0],
                            [382163.0, 6750361.0],
                            [382932.0, 6754022.0],
                            [386941.0, 6760260.0],
                            [390140.0, 6770978.0],
                            [394099.0, 6773357.0],
                            [400197.0, 6773697.0],
                            [400465.0, 6781914.0],
                            [398626.0, 6784333.0],
                            [395852.0, 6803336.0],
                            [400321.0, 6810723.0],
                            [398130.0, 6822559.0],
                            [399495.0, 6830885.0],
                        ]
                    ],
                ],
                "bbox": (306739.0, 6738014.0, 400465.0, 6855953.0),
            }
        },
        66: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [334283.0, 6280551.0],
                        [338238.0, 6281381.0],
                        [342731.0, 6276517.0],
                        [352961.0, 6276001.0],
                        [362964.0, 6280741.0],
                        [367753.0, 6276986.0],
                        [377063.0, 6275535.0],
                        [385124.0, 6280151.0],
                        [394475.0, 6281218.0],
                        [399714.0, 6278404.0],
                        [403447.0, 6281078.0],
                        [412501.0, 6278002.0],
                        [421554.0, 6283529.0],
                        [424830.0, 6280287.0],
                        [433057.0, 6279053.0],
                        [438084.0, 6281592.0],
                        [439499.0, 6295895.0],
                        [442698.0, 6298315.0],
                        [443572.0, 6313646.0],
                        [440195.0, 6315550.0],
                        [444807.0, 6320573.0],
                        [453303.0, 6321029.0],
                        [461632.0, 6315722.0],
                        [465239.0, 6317398.0],
                        [465465.0, 6324803.0],
                        [464468.0, 6326808.0],
                        [467874.0, 6336236.0],
                        [470769.0, 6340294.0],
                        [462757.0, 6341305.0],
                        [459734.0, 6343570.0],
                        [449759.0, 6344226.0],
                        [449164.0, 6352477.0],
                        [445091.0, 6357381.0],
                        [442465.0, 6350467.0],
                        [438523.0, 6349285.0],
                        [429214.0, 6351421.0],
                        [430077.0, 6359927.0],
                        [426389.0, 6364119.0],
                        [419635.0, 6366255.0],
                        [418928.0, 6369127.0],
                        [411174.0, 6373203.0],
                        [411314.0, 6378206.0],
                        [403228.0, 6378937.0],
                        [393973.0, 6376334.0],
                        [388231.0, 6379327.0],
                        [381182.0, 6379048.0],
                        [383562.0, 6383958.0],
                        [375548.0, 6389853.0],
                        [373686.0, 6386677.0],
                        [361774.0, 6383396.0],
                        [355175.0, 6347840.0],
                        [348748.0, 6322487.0],
                        [342546.0, 6300215.0],
                        [341177.0, 6292691.0],
                        [334283.0, 6280551.0],
                    ]
                ],
                "bbox": (334283.0, 6275535.0, 470769.0, 6389853.0),
            }
        },
        67: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [210124.0, 6860562.0],
                        [210319.0, 6864435.0],
                        [197918.0, 6867491.0],
                        [195168.0, 6863087.0],
                        [188759.0, 6861699.0],
                        [187283.0, 6866983.0],
                        [171676.0, 6866983.0],
                        [165007.0, 6863478.0],
                        [159513.0, 6866951.0],
                        [150836.0, 6862294.0],
                        [143559.0, 6862620.0],
                        [137993.0, 6858007.0],
                        [130421.0, 6856362.0],
                        [126410.0, 6849458.0],
                        [124277.0, 6841317.0],
                        [126191.0, 6836271.0],
                        [137035.0, 6831319.0],
                        [151215.0, 6836632.0],
                        [149516.0, 6831882.0],
                        [159712.0, 6829829.0],
                        [158800.0, 6824711.0],
                        [152925.0, 6822802.0],
                        [150196.0, 6824902.0],
                        [139593.0, 6825317.0],
                        [139209.0, 6819312.0],
                        [147794.0, 6818873.0],
                        [158225.0, 6812964.0],
                        [159803.0, 6806301.0],
                        [156741.0, 6801688.0],
                        [151961.0, 6804475.0],
                        [143250.0, 6802653.0],
                        [129762.0, 6802135.0],
                        [125302.0, 6798484.0],
                        [144750.0, 6790824.0],
                        [150552.0, 6779953.0],
                        [149596.0, 6769606.0],
                        [162294.0, 6768615.0],
                        [164959.0, 6774152.0],
                        [171525.0, 6775493.0],
                        [174013.0, 6772980.0],
                        [183941.0, 6774809.0],
                        [184280.0, 6770949.0],
                        [191411.0, 6764941.0],
                        [196633.0, 6766198.0],
                        [200244.0, 6762976.0],
                        [211251.0, 6761104.0],
                        [212687.0, 6770001.0],
                        [221788.0, 6771592.0],
                        [223352.0, 6780867.0],
                        [216607.0, 6782805.0],
                        [211608.0, 6786141.0],
                        [205220.0, 6785800.0],
                        [202166.0, 6798131.0],
                        [202658.0, 6804638.0],
                        [212675.0, 6807535.0],
                        [216996.0, 6817941.0],
                        [214652.0, 6824074.0],
                        [215204.0, 6828740.0],
                        [213034.0, 6834627.0],
                        [212655.0, 6842190.0],
                        [216761.0, 6846809.0],
                        [210382.0, 6855067.0],
                        [210124.0, 6860562.0],
                    ]
                ],
                "bbox": (124277.0, 6761104.0, 223352.0, 6867491.0),
            }
        },
        68: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [995359.0, 6526975.0],
                        [996263.0, 6533312.0],
                        [1005620.0, 6535079.0],
                        [1009539.0, 6537663.0],
                        [1013275.0, 6543845.0],
                        [1010939.0, 6550631.0],
                        [1005414.0, 6557665.0],
                        [1000587.0, 6561265.0],
                        [1000913.0, 6565514.0],
                        [994423.0, 6565990.0],
                        [993170.0, 6574229.0],
                        [997429.0, 6583180.0],
                        [990846.0, 6588853.0],
                        [991547.0, 6595136.0],
                        [985884.0, 6596474.0],
                        [972312.0, 6594423.0],
                        [960663.0, 6587846.0],
                        [955674.0, 6591075.0],
                        [952150.0, 6588701.0],
                        [949250.0, 6580383.0],
                        [953939.0, 6574878.0],
                        [949136.0, 6572391.0],
                        [944956.0, 6566962.0],
                        [928176.0, 6563414.0],
                        [918731.0, 6560168.0],
                        [916992.0, 6555432.0],
                        [917441.0, 6547210.0],
                        [919315.0, 6541572.0],
                        [921730.0, 6540986.0],
                        [922988.0, 6530552.0],
                        [926213.0, 6526897.0],
                        [936560.0, 6520059.0],
                        [946066.0, 6522280.0],
                        [948121.0, 6516633.0],
                        [952091.0, 6514710.0],
                        [959117.0, 6516128.0],
                        [962862.0, 6525460.0],
                        [965836.0, 6528299.0],
                        [969073.0, 6537583.0],
                        [971940.0, 6540371.0],
                        [975690.0, 6531451.0],
                        [979688.0, 6528135.0],
                        [984284.0, 6528734.0],
                        [988618.0, 6520489.0],
                        [995359.0, 6526975.0],
                    ]
                ],
                "bbox": (916992.0, 6514710.0, 1013275.0, 6596474.0),
            }
        },
        69: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [605624.0, 6904387.0],
                        [608283.0, 6898554.0],
                        [612180.0, 6899061.0],
                        [618689.0, 6896449.0],
                        [626847.0, 6897876.0],
                        [633020.0, 6901508.0],
                        [645465.0, 6895048.0],
                        [649761.0, 6898738.0],
                        [652314.0, 6895981.0],
                        [659205.0, 6894147.0],
                        [670084.0, 6886723.0],
                        [673222.0, 6889902.0],
                        [680633.0, 6884542.0],
                        [700622.0, 6887964.0],
                        [705248.0, 6890863.0],
                        [710189.0, 6894765.0],
                        [704672.0, 6899225.0],
                        [701957.0, 6908433.0],
                        [698137.0, 6911415.0],
                        [706929.0, 6919738.0],
                        [706805.0, 6926038.0],
                        [711648.0, 6928031.0],
                        [706939.0, 6934901.0],
                        [709520.0, 6938240.0],
                        [707064.0, 6950845.0],
                        [708546.0, 6956332.0],
                        [693916.0, 6955962.0],
                        [685089.0, 6950779.0],
                        [685504.0, 6946842.0],
                        [677528.0, 6947426.0],
                        [676176.0, 6942514.0],
                        [669006.0, 6944292.0],
                        [664208.0, 6949037.0],
                        [654712.0, 6950974.0],
                        [645659.0, 6956103.0],
                        [636565.0, 6954687.0],
                        [623025.0, 6958366.0],
                        [620154.0, 6956108.0],
                        [612314.0, 6962826.0],
                        [605401.0, 6955866.0],
                        [607933.0, 6953359.0],
                        [606321.0, 6945902.0],
                        [609123.0, 6937659.0],
                        [607205.0, 6935073.0],
                        [610545.0, 6930338.0],
                        [606642.0, 6924066.0],
                        [609871.0, 6919444.0],
                        [610931.0, 6911811.0],
                        [606128.0, 6907968.0],
                        [605624.0, 6904387.0],
                    ]
                ],
                "bbox": (605401.0, 6884542.0, 711648.0, 6962826.0),
            }
        },
        70: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [598361.0, 6887345.0],
                        [603102.0, 6887292.0],
                        [606678.0, 6883543.0],
                        [614076.0, 6886919.0],
                        [622312.0, 6880731.0],
                        [628641.0, 6878089.0],
                        [633062.0, 6879807.0],
                        [641836.0, 6872490.0],
                        [641404.0, 6867928.0],
                        [648071.0, 6872567.0],
                        [653619.0, 6875101.0],
                        [660416.0, 6872923.0],
                        [667303.0, 6878971.0],
                        [670084.0, 6886723.0],
                        [659205.0, 6894147.0],
                        [652314.0, 6895981.0],
                        [649761.0, 6898738.0],
                        [645465.0, 6895048.0],
                        [633020.0, 6901508.0],
                        [626847.0, 6897876.0],
                        [618689.0, 6896449.0],
                        [612180.0, 6899061.0],
                        [608283.0, 6898554.0],
                        [605624.0, 6904387.0],
                        [603501.0, 6902160.0],
                        [601892.0, 6893098.0],
                        [598361.0, 6887345.0],
                    ]
                ],
                "bbox": (598361.0, 6867928.0, 670084.0, 6904387.0),
            }
        },
        71: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [783517.0, 6693799.0],
                        [773484.0, 6692940.0],
                        [773240.0, 6698003.0],
                        [759265.0, 6699206.0],
                        [753904.0, 6700965.0],
                        [751168.0, 6705240.0],
                        [743701.0, 6707332.0],
                        [743712.0, 6710994.0],
                        [738638.0, 6714270.0],
                        [736733.0, 6710509.0],
                        [729904.0, 6712131.0],
                        [726085.0, 6708066.0],
                        [723118.0, 6710529.0],
                        [717731.0, 6709895.0],
                        [715400.0, 6713642.0],
                        [709181.0, 6715638.0],
                        [707666.0, 6720847.0],
                        [701928.0, 6717598.0],
                        [698236.0, 6718784.0],
                        [693556.0, 6718403.0],
                        [690565.0, 6713347.0],
                        [694642.0, 6704915.0],
                        [690449.0, 6694237.0],
                        [698745.0, 6684384.0],
                        [698614.0, 6680189.0],
                        [702129.0, 6669867.0],
                        [701762.0, 6662486.0],
                        [705753.0, 6657660.0],
                        [706033.0, 6650549.0],
                        [703828.0, 6645606.0],
                        [705186.0, 6641947.0],
                        [702446.0, 6632753.0],
                        [703745.0, 6628663.0],
                        [716475.0, 6620334.0],
                        [720608.0, 6624106.0],
                        [726499.0, 6620539.0],
                        [733164.0, 6623625.0],
                        [737251.0, 6617690.0],
                        [742042.0, 6624120.0],
                        [748049.0, 6627896.0],
                        [756196.0, 6628301.0],
                        [760920.0, 6622686.0],
                        [770503.0, 6626941.0],
                        [775685.0, 6631211.0],
                        [781064.0, 6632682.0],
                        [780490.0, 6638662.0],
                        [783308.0, 6642195.0],
                        [778932.0, 6646959.0],
                        [779000.0, 6654397.0],
                        [781374.0, 6662136.0],
                        [778810.0, 6664936.0],
                        [780471.0, 6669516.0],
                        [784602.0, 6669828.0],
                        [789554.0, 6672918.0],
                        [791663.0, 6673495.0],
                        [793165.0, 6678355.0],
                        [789098.0, 6683996.0],
                        [785899.0, 6682517.0],
                        [783517.0, 6693799.0],
                    ]
                ],
                "bbox": (690449.0, 6617690.0, 793165.0, 6720847.0),
            }
        },
        72: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [871408.0, 6655745.0],
                        [875449.0, 6660099.0],
                        [876191.0, 6666228.0],
                        [881002.0, 6667371.0],
                        [884880.0, 6674426.0],
                        [887407.0, 6682465.0],
                        [888032.0, 6690633.0],
                        [890265.0, 6692353.0],
                        [884919.0, 6701062.0],
                        [880595.0, 6713705.0],
                        [884206.0, 6713509.0],
                        [887785.0, 6718944.0],
                        [886108.0, 6726069.0],
                        [882147.0, 6728546.0],
                        [878352.0, 6725366.0],
                        [868188.0, 6726357.0],
                        [863148.0, 6730266.0],
                        [858300.0, 6729814.0],
                        [848455.0, 6733791.0],
                        [846031.0, 6742315.0],
                        [848388.0, 6746302.0],
                        [846087.0, 6753627.0],
                        [838226.0, 6763382.0],
                        [833316.0, 6764154.0],
                        [833398.0, 6769005.0],
                        [827043.0, 6770243.0],
                        [817962.0, 6771080.0],
                        [816397.0, 6764598.0],
                        [808147.0, 6762855.0],
                        [797692.0, 6763119.0],
                        [796594.0, 6759156.0],
                        [794318.0, 6750026.0],
                        [799053.0, 6750471.0],
                        [799827.0, 6740411.0],
                        [794312.0, 6737086.0],
                        [795163.0, 6731989.0],
                        [791050.0, 6725986.0],
                        [788376.0, 6717645.0],
                        [783952.0, 6713331.0],
                        [784360.0, 6705398.0],
                        [780393.0, 6701310.0],
                        [783517.0, 6693799.0],
                        [785899.0, 6682517.0],
                        [789098.0, 6683996.0],
                        [793165.0, 6678355.0],
                        [791663.0, 6673495.0],
                        [795506.0, 6668991.0],
                        [806631.0, 6665548.0],
                        [806754.0, 6662035.0],
                        [813434.0, 6659755.0],
                        [823470.0, 6650227.0],
                        [831500.0, 6648015.0],
                        [855755.0, 6655507.0],
                        [860161.0, 6652754.0],
                        [871408.0, 6655745.0],
                    ]
                ],
                "bbox": (780393.0, 6648015.0, 890265.0, 6771080.0),
            }
        },
        73: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [643163.0, 6853168.0],
                        [634691.0, 6849194.0],
                        [632440.0, 6843248.0],
                        [627800.0, 6838438.0],
                        [627504.0, 6829048.0],
                        [623768.0, 6826369.0],
                        [620311.0, 6818025.0],
                        [620852.0, 6812073.0],
                        [624251.0, 6811501.0],
                        [625387.0, 6798948.0],
                        [639308.0, 6801806.0],
                        [653275.0, 6801114.0],
                        [655721.0, 6802434.0],
                        [657768.0, 6807009.0],
                        [665496.0, 6812431.0],
                        [663371.0, 6815578.0],
                        [663045.0, 6825117.0],
                        [666363.0, 6833836.0],
                        [665649.0, 6839786.0],
                        [668472.0, 6843626.0],
                        [663488.0, 6848458.0],
                        [653706.0, 6846856.0],
                        [650056.0, 6850064.0],
                        [643163.0, 6853168.0],
                    ]
                ],
                "bbox": (620311.0, 6798948.0, 668472.0, 6853168.0),
            }
        },
        74: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [483517.0, 6558927.0],
                        [485043.0, 6563684.0],
                        [480502.0, 6565882.0],
                        [477460.0, 6571967.0],
                        [478920.0, 6578170.0],
                        [482897.0, 6584792.0],
                        [479925.0, 6587264.0],
                        [475179.0, 6582497.0],
                        [472141.0, 6584899.0],
                        [472081.0, 6590232.0],
                        [468300.0, 6594579.0],
                        [467690.0, 6607234.0],
                        [472374.0, 6614809.0],
                        [467588.0, 6622657.0],
                        [470952.0, 6628365.0],
                        [469757.0, 6639127.0],
                        [471018.0, 6649618.0],
                        [465537.0, 6662685.0],
                        [464624.0, 6667352.0],
                        [458546.0, 6672434.0],
                        [454238.0, 6672319.0],
                        [442005.0, 6668948.0],
                        [434893.0, 6670550.0],
                        [429925.0, 6668493.0],
                        [429262.0, 6663802.0],
                        [424993.0, 6661094.0],
                        [417889.0, 6660618.0],
                        [413368.0, 6662854.0],
                        [404251.0, 6660135.0],
                        [408792.0, 6655192.0],
                        [411920.0, 6644974.0],
                        [417892.0, 6640888.0],
                        [415662.0, 6636435.0],
                        [420740.0, 6628764.0],
                        [421344.0, 6621760.0],
                        [423543.0, 6619698.0],
                        [424018.0, 6609992.0],
                        [422851.0, 6601758.0],
                        [420470.0, 6597142.0],
                        [428213.0, 6593481.0],
                        [426574.0, 6590996.0],
                        [411453.0, 6585116.0],
                        [411065.0, 6578554.0],
                        [415606.0, 6575464.0],
                        [420640.0, 6566176.0],
                        [426299.0, 6566639.0],
                        [429269.0, 6562335.0],
                        [437311.0, 6559539.0],
                        [446458.0, 6558600.0],
                        [459784.0, 6545825.0],
                        [464645.0, 6548283.0],
                        [465641.0, 6555184.0],
                        [469589.0, 6554692.0],
                        [473907.0, 6559092.0],
                        [483517.0, 6558927.0],
                    ]
                ],
                "bbox": (404251.0, 6545825.0, 485043.0, 6672434.0),
            }
        },
        75: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [306966.0, 6794650.0],
                        [311879.0, 6798427.0],
                        [315234.0, 6806646.0],
                        [320973.0, 6806998.0],
                        [325505.0, 6811765.0],
                        [328273.0, 6809495.0],
                        [332923.0, 6813386.0],
                        [337450.0, 6835570.0],
                        [334969.0, 6837949.0],
                        [330825.0, 6841252.0],
                        [325749.0, 6841751.0],
                        [322500.0, 6846053.0],
                        [319331.0, 6843417.0],
                        [315059.0, 6845536.0],
                        [309156.0, 6855461.0],
                        [296913.0, 6849790.0],
                        [284640.0, 6841250.0],
                        [280881.0, 6840740.0],
                        [271227.0, 6848399.0],
                        [271155.0, 6854763.0],
                        [262910.0, 6863924.0],
                        [263482.0, 6867351.0],
                        [257346.0, 6869777.0],
                        [251930.0, 6880323.0],
                        [243322.0, 6881073.0],
                        [228138.0, 6874463.0],
                        [222446.0, 6879145.0],
                        [216642.0, 6872989.0],
                        [215941.0, 6861279.0],
                        [210124.0, 6860562.0],
                        [210382.0, 6855067.0],
                        [216761.0, 6846809.0],
                        [212655.0, 6842190.0],
                        [213034.0, 6834627.0],
                        [215204.0, 6828740.0],
                        [214652.0, 6824074.0],
                        [216996.0, 6817941.0],
                        [212675.0, 6807535.0],
                        [229439.0, 6804532.0],
                        [233945.0, 6800703.0],
                        [242780.0, 6802066.0],
                        [246074.0, 6807146.0],
                        [252150.0, 6805897.0],
                        [270150.0, 6795768.0],
                        [279762.0, 6794931.0],
                        [277875.0, 6787107.0],
                        [280665.0, 6785525.0],
                        [285132.0, 6789099.0],
                        [291749.0, 6798375.0],
                        [298204.0, 6799128.0],
                        [300637.0, 6793781.0],
                        [306966.0, 6794650.0],
                    ]
                ],
                "bbox": (210124.0, 6785525.0, 337450.0, 6881073.0),
            }
        },
        76: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [702446.0, 6632753.0],
                        [696943.0, 6633749.0],
                        [686837.0, 6626145.0],
                        [682775.0, 6624336.0],
                        [677474.0, 6626628.0],
                        [669145.0, 6615318.0],
                        [670500.0, 6605989.0],
                        [664479.0, 6602292.0],
                        [660370.0, 6603761.0],
                        [650317.0, 6601560.0],
                        [645179.0, 6595086.0],
                        [644784.0, 6591412.0],
                        [647921.0, 6581264.0],
                        [653217.0, 6581299.0],
                        [659880.0, 6575828.0],
                        [662729.0, 6571178.0],
                        [666451.0, 6560450.0],
                        [672252.0, 6557694.0],
                        [679424.0, 6569309.0],
                        [685369.0, 6566281.0],
                        [688886.0, 6572856.0],
                        [695157.0, 6571452.0],
                        [693029.0, 6567076.0],
                        [697819.0, 6557998.0],
                        [712873.0, 6551781.0],
                        [728730.0, 6550656.0],
                        [732386.0, 6552810.0],
                        [735860.0, 6546571.0],
                        [745523.0, 6547324.0],
                        [753779.0, 6537018.0],
                        [754888.0, 6541809.0],
                        [761084.0, 6541876.0],
                        [763887.0, 6544360.0],
                        [762385.0, 6549859.0],
                        [763504.0, 6554575.0],
                        [760949.0, 6561975.0],
                        [762003.0, 6573092.0],
                        [769267.0, 6575508.0],
                        [775913.0, 6580395.0],
                        [775079.0, 6589273.0],
                        [776586.0, 6596649.0],
                        [773476.0, 6599308.0],
                        [768312.0, 6598303.0],
                        [763922.0, 6603795.0],
                        [761463.0, 6602522.0],
                        [756931.0, 6607772.0],
                        [753291.0, 6618069.0],
                        [748734.0, 6623209.0],
                        [748049.0, 6627896.0],
                        [742042.0, 6624120.0],
                        [737251.0, 6617690.0],
                        [733164.0, 6623625.0],
                        [726499.0, 6620539.0],
                        [720608.0, 6624106.0],
                        [716475.0, 6620334.0],
                        [703745.0, 6628663.0],
                        [702446.0, 6632753.0],
                    ]
                ],
                "bbox": (644784.0, 6537018.0, 776586.0, 6633749.0),
            }
        },
        77: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [365341.0, 6575902.0],
                            [359213.0, 6576771.0],
                            [352445.0, 6583031.0],
                            [350494.0, 6577212.0],
                            [356155.0, 6576636.0],
                            [364082.0, 6571051.0],
                            [365341.0, 6575902.0],
                        ]
                    ],
                    [
                        [
                            [373352.0, 6542832.0],
                            [371342.0, 6552252.0],
                            [366346.0, 6552808.0],
                            [362447.0, 6556836.0],
                            [360591.0, 6548506.0],
                            [369260.0, 6539881.0],
                            [371124.0, 6531592.0],
                            [374437.0, 6534213.0],
                            [375330.0, 6540510.0],
                            [373352.0, 6542832.0],
                        ]
                    ],
                    [
                        [
                            [464807.0, 6459164.0],
                            [461242.0, 6465553.0],
                            [455660.0, 6465791.0],
                            [456356.0, 6470307.0],
                            [447267.0, 6474282.0],
                            [443202.0, 6478722.0],
                            [445861.0, 6484044.0],
                            [444696.0, 6489309.0],
                            [446521.0, 6493231.0],
                            [442913.0, 6501478.0],
                            [436951.0, 6506668.0],
                            [434607.0, 6512022.0],
                            [434480.0, 6521530.0],
                            [445866.0, 6528260.0],
                            [449713.0, 6524677.0],
                            [455132.0, 6526680.0],
                            [458386.0, 6534878.0],
                            [457303.0, 6539406.0],
                            [459784.0, 6545825.0],
                            [446458.0, 6558600.0],
                            [437311.0, 6559539.0],
                            [429269.0, 6562335.0],
                            [426299.0, 6566639.0],
                            [420640.0, 6566176.0],
                            [415606.0, 6575464.0],
                            [411065.0, 6578554.0],
                            [411453.0, 6585116.0],
                            [404775.0, 6589452.0],
                            [397324.0, 6586760.0],
                            [391500.0, 6591809.0],
                            [382360.0, 6587238.0],
                            [383479.0, 6581738.0],
                            [376439.0, 6576760.0],
                            [374243.0, 6571617.0],
                            [381511.0, 6566597.0],
                            [386552.0, 6553761.0],
                            [382858.0, 6551653.0],
                            [385303.0, 6547012.0],
                            [378912.0, 6532887.0],
                            [370510.0, 6529071.0],
                            [370474.0, 6520657.0],
                            [379564.0, 6513624.0],
                            [387626.0, 6509256.0],
                            [386164.0, 6505245.0],
                            [399796.0, 6489042.0],
                            [404682.0, 6481482.0],
                            [406100.0, 6476140.0],
                            [418478.0, 6475494.0],
                            [421098.0, 6472770.0],
                            [431214.0, 6470295.0],
                            [433418.0, 6457450.0],
                            [437492.0, 6457585.0],
                            [444096.0, 6451365.0],
                            [452009.0, 6448234.0],
                            [457280.0, 6451647.0],
                            [460931.0, 6449393.0],
                            [464807.0, 6459164.0],
                        ]
                    ],
                ],
                "bbox": (350494.0, 6448234.0, 464807.0, 6591809.0),
            }
        },
        78: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [728488.0, 6430309.0],
                        [727352.0, 6435060.0],
                        [723408.0, 6437470.0],
                        [725628.0, 6444038.0],
                        [722648.0, 6446835.0],
                        [717445.0, 6463649.0],
                        [709251.0, 6464988.0],
                        [708104.0, 6472781.0],
                        [701310.0, 6465307.0],
                        [695974.0, 6467752.0],
                        [693859.0, 6474045.0],
                        [688449.0, 6477003.0],
                        [677684.0, 6475835.0],
                        [672750.0, 6482640.0],
                        [661594.0, 6486680.0],
                        [659915.0, 6480065.0],
                        [656321.0, 6476249.0],
                        [651369.0, 6479623.0],
                        [649118.0, 6470007.0],
                        [642886.0, 6465907.0],
                        [636846.0, 6458269.0],
                        [638218.0, 6451518.0],
                        [634831.0, 6442812.0],
                        [628772.0, 6440050.0],
                        [631663.0, 6432186.0],
                        [626129.0, 6431248.0],
                        [628463.0, 6419614.0],
                        [634482.0, 6410441.0],
                        [633003.0, 6406356.0],
                        [634129.0, 6393565.0],
                        [637122.0, 6391031.0],
                        [637228.0, 6394175.0],
                        [646639.0, 6396959.0],
                        [655192.0, 6393469.0],
                        [664849.0, 6402561.0],
                        [665404.0, 6408608.0],
                        [668313.0, 6410487.0],
                        [668604.0, 6416079.0],
                        [676829.0, 6423158.0],
                        [679353.0, 6426925.0],
                        [684359.0, 6419403.0],
                        [688126.0, 6419157.0],
                        [690477.0, 6411547.0],
                        [694820.0, 6408897.0],
                        [693924.0, 6403282.0],
                        [698547.0, 6393953.0],
                        [704864.0, 6413115.0],
                        [707862.0, 6414941.0],
                        [708330.0, 6420849.0],
                        [714401.0, 6418301.0],
                        [719705.0, 6424147.0],
                        [728488.0, 6430309.0],
                    ]
                ],
                "bbox": (626129.0, 6391031.0, 728488.0, 6486680.0),
            }
        },
        79: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [664821.0, 6258302.0],
                        [662679.0, 6249784.0],
                        [667653.0, 6244475.0],
                        [681495.0, 6239871.0],
                        [686427.0, 6247043.0],
                        [700353.0, 6246775.0],
                        [700385.0, 6243263.0],
                        [711963.0, 6238657.0],
                        [716336.0, 6238907.0],
                        [719561.0, 6234874.0],
                        [727933.0, 6241307.0],
                        [734945.0, 6243544.0],
                        [741504.0, 6241707.0],
                        [748880.0, 6250885.0],
                        [753675.0, 6255020.0],
                        [764523.0, 6260540.0],
                        [773373.0, 6269062.0],
                        [781738.0, 6273121.0],
                        [788998.0, 6273432.0],
                        [792922.0, 6276955.0],
                        [796379.0, 6284647.0],
                        [792244.0, 6293431.0],
                        [780634.0, 6301895.0],
                        [773726.0, 6310049.0],
                        [766790.0, 6307842.0],
                        [766255.0, 6313712.0],
                        [763184.0, 6318967.0],
                        [758340.0, 6319159.0],
                        [750088.0, 6313306.0],
                        [746263.0, 6307559.0],
                        [742673.0, 6306434.0],
                        [734096.0, 6312602.0],
                        [728786.0, 6312824.0],
                        [722102.0, 6311077.0],
                        [716344.0, 6301672.0],
                        [704815.0, 6303628.0],
                        [704898.0, 6288229.0],
                        [698819.0, 6289943.0],
                        [694796.0, 6288406.0],
                        [693221.0, 6284557.0],
                        [680178.0, 6279485.0],
                        [676690.0, 6282993.0],
                        [671212.0, 6283521.0],
                        [668935.0, 6274250.0],
                        [672394.0, 6269695.0],
                        [672444.0, 6264623.0],
                        [668090.0, 6259189.0],
                        [664821.0, 6258302.0],
                    ]
                ],
                "bbox": (662679.0, 6234874.0, 796379.0, 6319159.0),
            }
        },
        80: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [921863.0, 6404787.0],
                        [918546.0, 6403480.0],
                        [907889.0, 6409384.0],
                        [894862.0, 6413405.0],
                        [895949.0, 6427870.0],
                        [895595.0, 6439026.0],
                        [892767.0, 6444271.0],
                        [888053.0, 6440277.0],
                        [871457.0, 6445038.0],
                        [871909.0, 6454823.0],
                        [870728.0, 6463360.0],
                        [866406.0, 6463235.0],
                        [860939.0, 6470947.0],
                        [855768.0, 6473591.0],
                        [847361.0, 6468209.0],
                        [841110.0, 6468164.0],
                        [842390.0, 6453321.0],
                        [844782.0, 6435636.0],
                        [848816.0, 6428161.0],
                        [844069.0, 6414766.0],
                        [839715.0, 6410394.0],
                        [841041.0, 6396655.0],
                        [835764.0, 6388411.0],
                        [834538.0, 6384016.0],
                        [835151.0, 6374038.0],
                        [832713.0, 6371581.0],
                        [831614.0, 6360351.0],
                        [840525.0, 6360052.0],
                        [843837.0, 6356928.0],
                        [844895.0, 6349809.0],
                        [864358.0, 6358713.0],
                        [871547.0, 6356009.0],
                        [872115.0, 6350341.0],
                        [890550.0, 6347548.0],
                        [890601.0, 6342463.0],
                        [894810.0, 6342254.0],
                        [899978.0, 6338355.0],
                        [903520.0, 6340766.0],
                        [905908.0, 6346585.0],
                        [911050.0, 6344481.0],
                        [913873.0, 6347227.0],
                        [914428.0, 6355637.0],
                        [911254.0, 6355549.0],
                        [909816.0, 6362305.0],
                        [898744.0, 6362932.0],
                        [892505.0, 6372493.0],
                        [899815.0, 6380077.0],
                        [907085.0, 6377469.0],
                        [909000.0, 6384874.0],
                        [906293.0, 6386082.0],
                        [910174.0, 6394503.0],
                        [921214.0, 6398819.0],
                        [921863.0, 6404787.0],
                    ],
                    [
                        [850837.0, 6364673.0],
                        [852761.0, 6369494.0],
                        [856829.0, 6372215.0],
                        [860545.0, 6368019.0],
                        [860544.0, 6360615.0],
                        [857850.0, 6357360.0],
                        [850729.0, 6357929.0],
                        [850837.0, 6364673.0],
                    ],
                ],
                "bbox": (831614.0, 6338355.0, 921863.0, 6473591.0),
            }
        },
        81: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [600206.0, 6164532.0],
                        [597209.0, 6163462.0],
                        [595443.0, 6155896.0],
                        [604042.0, 6154257.0],
                        [614139.0, 6147692.0],
                        [616327.0, 6140765.0],
                        [624388.0, 6140739.0],
                        [630462.0, 6147428.0],
                        [638840.0, 6149005.0],
                        [653442.0, 6143379.0],
                        [657322.0, 6137875.0],
                        [662029.0, 6137190.0],
                        [665163.0, 6139863.0],
                        [672907.0, 6137962.0],
                        [673207.0, 6145058.0],
                        [679658.0, 6147303.0],
                        [683451.0, 6146537.0],
                        [686936.0, 6150974.0],
                        [703357.0, 6152588.0],
                        [707042.0, 6147292.0],
                        [714275.0, 6148346.0],
                        [710994.0, 6157024.0],
                        [704080.0, 6161154.0],
                        [702907.0, 6175403.0],
                        [703560.0, 6193187.0],
                        [693222.0, 6198384.0],
                        [688989.0, 6202113.0],
                        [682753.0, 6199641.0],
                        [678721.0, 6193157.0],
                        [675246.0, 6192375.0],
                        [659825.0, 6194610.0],
                        [655189.0, 6193206.0],
                        [644930.0, 6193342.0],
                        [647326.0, 6181831.0],
                        [644388.0, 6178927.0],
                        [631545.0, 6174170.0],
                        [617954.0, 6174066.0],
                        [615529.0, 6169131.0],
                        [607482.0, 6165290.0],
                        [600206.0, 6164532.0],
                    ]
                ],
                "bbox": (595443.0, 6137190.0, 714275.0, 6202113.0),
            }
        },
        82: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [956276.0, 6452799.0],
                        [964422.0, 6450656.0],
                        [967061.0, 6446025.0],
                        [974349.0, 6445704.0],
                        [973771.0, 6449910.0],
                        [985382.0, 6452122.0],
                        [989157.0, 6455721.0],
                        [995952.0, 6458223.0],
                        [1002558.0, 6454919.0],
                        [1011443.0, 6464355.0],
                        [1024403.0, 6470318.0],
                        [1021887.0, 6478062.0],
                        [1027167.0, 6487344.0],
                        [1021485.0, 6490016.0],
                        [1020210.0, 6493869.0],
                        [1012252.0, 6497350.0],
                        [1011518.0, 6512378.0],
                        [1006337.0, 6512917.0],
                        [997830.0, 6518696.0],
                        [995359.0, 6526975.0],
                        [988618.0, 6520489.0],
                        [984284.0, 6528734.0],
                        [979688.0, 6528135.0],
                        [975690.0, 6531451.0],
                        [971940.0, 6540371.0],
                        [969073.0, 6537583.0],
                        [965836.0, 6528299.0],
                        [962862.0, 6525460.0],
                        [959117.0, 6516128.0],
                        [952091.0, 6514710.0],
                        [948121.0, 6516633.0],
                        [946066.0, 6522280.0],
                        [936560.0, 6520059.0],
                        [926213.0, 6526897.0],
                        [922988.0, 6530552.0],
                        [921730.0, 6540986.0],
                        [919315.0, 6541572.0],
                        [916332.0, 6528631.0],
                        [915868.0, 6518199.0],
                        [910338.0, 6515974.0],
                        [909413.0, 6509006.0],
                        [904449.0, 6504924.0],
                        [913763.0, 6489603.0],
                        [917457.0, 6486189.0],
                        [925224.0, 6482705.0],
                        [931624.0, 6492445.0],
                        [938381.0, 6486658.0],
                        [943964.0, 6486985.0],
                        [948557.0, 6482085.0],
                        [949441.0, 6473761.0],
                        [945461.0, 6470305.0],
                        [945165.0, 6465401.0],
                        [950505.0, 6456663.0],
                        [956276.0, 6452799.0],
                    ]
                ],
                "bbox": (904449.0, 6445704.0, 1027167.0, 6541572.0),
            }
        },
        83: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [921863.0, 6404787.0],
                        [921214.0, 6398819.0],
                        [910174.0, 6394503.0],
                        [906293.0, 6386082.0],
                        [909000.0, 6384874.0],
                        [907085.0, 6377469.0],
                        [899815.0, 6380077.0],
                        [892505.0, 6372493.0],
                        [898744.0, 6362932.0],
                        [909816.0, 6362305.0],
                        [911254.0, 6355549.0],
                        [914428.0, 6355637.0],
                        [913873.0, 6347227.0],
                        [920148.0, 6349530.0],
                        [930231.0, 6349978.0],
                        [925339.0, 6357350.0],
                        [932421.0, 6356788.0],
                        [935206.0, 6370624.0],
                        [944316.0, 6377139.0],
                        [950982.0, 6378672.0],
                        [957118.0, 6369997.0],
                        [959705.0, 6373500.0],
                        [957182.0, 6379131.0],
                        [967103.0, 6386021.0],
                        [971476.0, 6380340.0],
                        [983401.0, 6378221.0],
                        [988952.0, 6378656.0],
                        [992592.0, 6389297.0],
                        [999315.0, 6394909.0],
                        [1004568.0, 6397351.0],
                        [1010207.0, 6403290.0],
                        [1012913.0, 6402904.0],
                        [1015781.0, 6406977.0],
                        [1022960.0, 6406318.0],
                        [1016213.0, 6418043.0],
                        [1016501.0, 6423604.0],
                        [1010607.0, 6425833.0],
                        [1004832.0, 6424533.0],
                        [995855.0, 6430156.0],
                        [996598.0, 6437292.0],
                        [994575.0, 6442256.0],
                        [989294.0, 6442329.0],
                        [985382.0, 6452122.0],
                        [973771.0, 6449910.0],
                        [974349.0, 6445704.0],
                        [967061.0, 6446025.0],
                        [964422.0, 6450656.0],
                        [956276.0, 6452799.0],
                        [953909.0, 6450690.0],
                        [952342.0, 6439924.0],
                        [961377.0, 6439340.0],
                        [964872.0, 6432532.0],
                        [965006.0, 6422921.0],
                        [960775.0, 6424797.0],
                        [956742.0, 6422339.0],
                        [947667.0, 6423241.0],
                        [941569.0, 6417648.0],
                        [939410.0, 6420031.0],
                        [933177.0, 6416064.0],
                        [930672.0, 6410433.0],
                        [925560.0, 6409806.0],
                        [921863.0, 6404787.0],
                    ]
                ],
                "bbox": (892505.0, 6347227.0, 1022960.0, 6452799.0),
            }
        },
        84: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [850837.0, 6364673.0],
                            [850729.0, 6357929.0],
                            [857850.0, 6357360.0],
                            [860544.0, 6360615.0],
                            [860545.0, 6368019.0],
                            [856829.0, 6372215.0],
                            [852761.0, 6369494.0],
                            [850837.0, 6364673.0],
                        ]
                    ],
                    [
                        [
                            [839658.0, 6315433.0],
                            [848847.0, 6314233.0],
                            [858049.0, 6310039.0],
                            [863255.0, 6305296.0],
                            [865136.0, 6300908.0],
                            [876282.0, 6295340.0],
                            [879627.0, 6296831.0],
                            [886796.0, 6295631.0],
                            [896706.0, 6289935.0],
                            [904218.0, 6287715.0],
                            [910307.0, 6287877.0],
                            [921881.0, 6295602.0],
                            [922160.0, 6296144.0],
                            [913516.0, 6306489.0],
                            [907367.0, 6306820.0],
                            [909386.0, 6316209.0],
                            [901642.0, 6319541.0],
                            [903879.0, 6328807.0],
                            [900470.0, 6332559.0],
                            [899978.0, 6338355.0],
                            [894810.0, 6342254.0],
                            [890601.0, 6342463.0],
                            [890550.0, 6347548.0],
                            [872115.0, 6350341.0],
                            [871547.0, 6356009.0],
                            [864358.0, 6358713.0],
                            [844895.0, 6349809.0],
                            [843837.0, 6356928.0],
                            [840525.0, 6360052.0],
                            [831614.0, 6360351.0],
                            [831641.0, 6353746.0],
                            [837656.0, 6344658.0],
                            [836689.0, 6335330.0],
                            [843231.0, 6331183.0],
                            [847769.0, 6322554.0],
                            [839658.0, 6315433.0],
                        ]
                    ],
                ],
                "bbox": (831614.0, 6287715.0, 922160.0, 6372215.0),
            }
        },
        85: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [636090.0, 6591904.0],
                        [634893.0, 6595681.0],
                        [638969.0, 6598575.0],
                        [635550.0, 6606712.0],
                        [637665.0, 6611745.0],
                        [634340.0, 6622075.0],
                        [628673.0, 6627353.0],
                        [632500.0, 6630848.0],
                        [627496.0, 6637025.0],
                        [633457.0, 6642556.0],
                        [629301.0, 6648616.0],
                        [631131.0, 6657674.0],
                        [627981.0, 6660408.0],
                        [627833.0, 6667741.0],
                        [621646.0, 6669974.0],
                        [615265.0, 6667454.0],
                        [607114.0, 6670785.0],
                        [612309.0, 6675948.0],
                        [612147.0, 6680536.0],
                        [602149.0, 6685865.0],
                        [593597.0, 6687211.0],
                        [582631.0, 6683116.0],
                        [573297.0, 6677558.0],
                        [576079.0, 6670370.0],
                        [571950.0, 6667671.0],
                        [568878.0, 6661167.0],
                        [560408.0, 6661557.0],
                        [553982.0, 6659068.0],
                        [551779.0, 6655211.0],
                        [546519.0, 6631001.0],
                        [537221.0, 6629765.0],
                        [541431.0, 6623495.0],
                        [538906.0, 6616112.0],
                        [542426.0, 6611026.0],
                        [547958.0, 6609437.0],
                        [557842.0, 6602380.0],
                        [558128.0, 6596023.0],
                        [562773.0, 6594026.0],
                        [559931.0, 6588729.0],
                        [569564.0, 6587075.0],
                        [573702.0, 6590223.0],
                        [578129.0, 6584256.0],
                        [586530.0, 6592902.0],
                        [595863.0, 6588324.0],
                        [602234.0, 6588456.0],
                        [609355.0, 6592908.0],
                        [622684.0, 6592821.0],
                        [630016.0, 6590287.0],
                        [636090.0, 6591904.0],
                    ]
                ],
                "bbox": (537221.0, 6584256.0, 638969.0, 6687211.0),
            }
        },
        86: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1232225.0, 6105798.0],
                        [1232233.0, 6116272.0],
                        [1242213.0, 6134033.0],
                        [1241272.0, 6154177.0],
                        [1238247.0, 6164499.0],
                        [1238682.0, 6169952.0],
                        [1236764.0, 6182904.0],
                        [1228823.0, 6195229.0],
                        [1228376.0, 6197858.0],
                        [1231051.0, 6211355.0],
                        [1228846.0, 6218876.0],
                        [1227050.0, 6231255.0],
                        [1223421.0, 6233783.0],
                        [1216996.0, 6231337.0],
                        [1218749.0, 6222752.0],
                        [1215986.0, 6213431.0],
                        [1218915.0, 6209217.0],
                        [1219580.0, 6202912.0],
                        [1215962.0, 6195537.0],
                        [1212393.0, 6200184.0],
                        [1205077.0, 6201621.0],
                        [1198634.0, 6198671.0],
                        [1193909.0, 6190462.0],
                        [1183050.0, 6187935.0],
                        [1176939.0, 6184145.0],
                        [1176781.0, 6180877.0],
                        [1165934.0, 6173994.0],
                        [1165800.0, 6162888.0],
                        [1161943.0, 6162734.0],
                        [1159342.0, 6158599.0],
                        [1164950.0, 6158109.0],
                        [1180116.0, 6152978.0],
                        [1187662.0, 6146432.0],
                        [1199675.0, 6142105.0],
                        [1202519.0, 6133762.0],
                        [1206639.0, 6131576.0],
                        [1210743.0, 6122769.0],
                        [1215715.0, 6123336.0],
                        [1217754.0, 6104291.0],
                        [1226359.0, 6102880.0],
                        [1232225.0, 6105798.0],
                    ]
                ],
                "bbox": (1159342.0, 6102880.0, 1242213.0, 6233783.0),
            }
        },
        87: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [563452.0, 6484264.0],
                        [566212.0, 6489282.0],
                        [571080.0, 6486618.0],
                        [576059.0, 6493313.0],
                        [581471.0, 6497412.0],
                        [587429.0, 6495459.0],
                        [593766.0, 6498788.0],
                        [605337.0, 6509707.0],
                        [612121.0, 6507862.0],
                        [614305.0, 6511565.0],
                        [612524.0, 6515422.0],
                        [613074.0, 6522626.0],
                        [604752.0, 6527760.0],
                        [597279.0, 6527024.0],
                        [591561.0, 6529605.0],
                        [592200.0, 6538029.0],
                        [586335.0, 6540289.0],
                        [587795.0, 6549437.0],
                        [580656.0, 6565605.0],
                        [574730.0, 6569689.0],
                        [580236.0, 6579624.0],
                        [578129.0, 6584256.0],
                        [573702.0, 6590223.0],
                        [569564.0, 6587075.0],
                        [559931.0, 6588729.0],
                        [556218.0, 6586207.0],
                        [548271.0, 6584464.0],
                        [546474.0, 6577615.0],
                        [538896.0, 6578287.0],
                        [530127.0, 6570272.0],
                        [531964.0, 6561069.0],
                        [531290.0, 6552122.0],
                        [539507.0, 6547743.0],
                        [540666.0, 6541823.0],
                        [534383.0, 6537804.0],
                        [527825.0, 6527023.0],
                        [522669.0, 6525452.0],
                        [522412.0, 6520738.0],
                        [515635.0, 6515544.0],
                        [526849.0, 6509996.0],
                        [524801.0, 6504583.0],
                        [529342.0, 6499739.0],
                        [539039.0, 6503445.0],
                        [546900.0, 6501981.0],
                        [553144.0, 6489340.0],
                        [563452.0, 6484264.0],
                    ]
                ],
                "bbox": (515635.0, 6484264.0, 614305.0, 6590223.0),
            }
        },
        88: {
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [297360.0, 6667914.0],
                            [299985.0, 6664525.0],
                            [303823.0, 6669495.0],
                            [298725.0, 6671705.0],
                            [297360.0, 6667914.0],
                        ]
                    ],
                    [
                        [
                            [322009.0, 6670666.0],
                            [318317.0, 6668787.0],
                            [315194.0, 6662103.0],
                            [307861.0, 6656132.0],
                            [308108.0, 6649020.0],
                            [322518.0, 6633220.0],
                            [328569.0, 6623483.0],
                            [331126.0, 6610513.0],
                            [333817.0, 6610276.0],
                            [344797.0, 6600884.0],
                            [354269.0, 6598459.0],
                            [356701.0, 6592204.0],
                            [364357.0, 6592471.0],
                            [376108.0, 6582708.0],
                            [376887.0, 6588202.0],
                            [382360.0, 6587238.0],
                            [391500.0, 6591809.0],
                            [397324.0, 6586760.0],
                            [404775.0, 6589452.0],
                            [411453.0, 6585116.0],
                            [426574.0, 6590996.0],
                            [428213.0, 6593481.0],
                            [420470.0, 6597142.0],
                            [422851.0, 6601758.0],
                            [424018.0, 6609992.0],
                            [423543.0, 6619698.0],
                            [421344.0, 6621760.0],
                            [420740.0, 6628764.0],
                            [415662.0, 6636435.0],
                            [417892.0, 6640888.0],
                            [411920.0, 6644974.0],
                            [408792.0, 6655192.0],
                            [404251.0, 6660135.0],
                            [401283.0, 6663962.0],
                            [392012.0, 6664073.0],
                            [385082.0, 6667087.0],
                            [376108.0, 6673611.0],
                            [374065.0, 6668782.0],
                            [367645.0, 6668175.0],
                            [367588.0, 6659427.0],
                            [361112.0, 6656907.0],
                            [359840.0, 6669393.0],
                            [354394.0, 6667534.0],
                            [354064.0, 6663454.0],
                            [357453.0, 6652400.0],
                            [353671.0, 6649968.0],
                            [343129.0, 6653969.0],
                            [338731.0, 6658583.0],
                            [332678.0, 6659222.0],
                            [324590.0, 6666698.0],
                            [322009.0, 6670666.0],
                        ]
                    ],
                ],
                "bbox": (297360.0, 6582708.0, 428213.0, 6673611.0),
            }
        },
        89: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [917346.0, 6234793.0],
                        [919352.0, 6230892.0],
                        [929076.0, 6227424.0],
                        [928534.0, 6223947.0],
                        [932969.0, 6220583.0],
                        [939545.0, 6227616.0],
                        [947016.0, 6224540.0],
                        [954550.0, 6225038.0],
                        [959301.0, 6228480.0],
                        [965861.0, 6230140.0],
                        [974387.0, 6227034.0],
                        [975697.0, 6233209.0],
                        [984286.0, 6234176.0],
                        [989472.0, 6238682.0],
                        [995722.0, 6237173.0],
                        [997536.0, 6239863.0],
                        [998568.0, 6249133.0],
                        [997443.0, 6253468.0],
                        [1002933.0, 6264260.0],
                        [1012590.0, 6265313.0],
                        [1018256.0, 6272482.0],
                        [1014132.0, 6274778.0],
                        [1015523.0, 6285590.0],
                        [1006552.0, 6288390.0],
                        [1003290.0, 6292496.0],
                        [1002326.0, 6300425.0],
                        [992638.0, 6305621.0],
                        [983574.0, 6307147.0],
                        [974774.0, 6305117.0],
                        [974848.0, 6301646.0],
                        [970413.0, 6298787.0],
                        [958836.0, 6305328.0],
                        [956283.0, 6301072.0],
                        [944763.0, 6293054.0],
                        [933734.0, 6296912.0],
                        [923991.0, 6299127.0],
                        [922160.0, 6296144.0],
                        [921881.0, 6295602.0],
                        [926823.0, 6291811.0],
                        [925792.0, 6288611.0],
                        [917893.0, 6286245.0],
                        [916541.0, 6283087.0],
                        [920209.0, 6276225.0],
                        [918385.0, 6268519.0],
                        [922861.0, 6263349.0],
                        [917403.0, 6259253.0],
                        [924245.0, 6244827.0],
                        [918110.0, 6241136.0],
                        [917346.0, 6234793.0],
                    ]
                ],
                "bbox": (916541.0, 6220583.0, 1018256.0, 6307147.0),
            }
        },
        90: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [670056.0, 6856451.0],
                        [662997.0, 6862431.0],
                        [657169.0, 6861180.0],
                        [650942.0, 6857646.0],
                        [650056.0, 6850064.0],
                        [653706.0, 6846856.0],
                        [663488.0, 6848458.0],
                        [668472.0, 6843626.0],
                        [671600.0, 6851283.0],
                        [670056.0, 6856451.0],
                    ]
                ],
                "bbox": (650056.0, 6843626.0, 671600.0, 6862431.0),
            }
        },
        91: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [650942.0, 6857646.0],
                        [645325.0, 6859675.0],
                        [643644.0, 6863501.0],
                        [650140.0, 6866932.0],
                        [648071.0, 6872567.0],
                        [641404.0, 6867928.0],
                        [637864.0, 6864035.0],
                        [637702.0, 6857774.0],
                        [643163.0, 6853168.0],
                        [650056.0, 6850064.0],
                        [650942.0, 6857646.0],
                    ]
                ],
                "bbox": (637702.0, 6850064.0, 650942.0, 6872567.0),
            }
        },
        92: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [698547.0, 6393953.0],
                        [706639.0, 6384441.0],
                        [705449.0, 6378272.0],
                        [710800.0, 6372878.0],
                        [709537.0, 6364934.0],
                        [712305.0, 6356606.0],
                        [709994.0, 6353946.0],
                        [718362.0, 6347498.0],
                        [728598.0, 6344387.0],
                        [729879.0, 6341376.0],
                        [735189.0, 6336775.0],
                        [750700.0, 6336169.0],
                        [750995.0, 6342037.0],
                        [754256.0, 6342872.0],
                        [763780.0, 6336809.0],
                        [768987.0, 6337162.0],
                        [776174.0, 6341769.0],
                        [775968.0, 6350322.0],
                        [773621.0, 6356674.0],
                        [775941.0, 6359276.0],
                        [770571.0, 6365836.0],
                        [775211.0, 6367175.0],
                        [779411.0, 6373918.0],
                        [775042.0, 6386528.0],
                        [771844.0, 6388592.0],
                        [768276.0, 6405343.0],
                        [758530.0, 6415778.0],
                        [752669.0, 6414624.0],
                        [752090.0, 6419191.0],
                        [746937.0, 6419760.0],
                        [746579.0, 6414955.0],
                        [737614.0, 6413026.0],
                        [732994.0, 6422485.0],
                        [732563.0, 6427378.0],
                        [728488.0, 6430309.0],
                        [719705.0, 6424147.0],
                        [714401.0, 6418301.0],
                        [708330.0, 6420849.0],
                        [707862.0, 6414941.0],
                        [704864.0, 6413115.0],
                        [698547.0, 6393953.0],
                    ]
                ],
                "bbox": (698547.0, 6336169.0, 779411.0, 6430309.0),
            }
        },
        93: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [799607.0, 6263119.0],
                        [825918.0, 6262030.0],
                        [828657.0, 6259471.0],
                        [826719.0, 6253810.0],
                        [834804.0, 6251115.0],
                        [842728.0, 6251679.0],
                        [850515.0, 6249931.0],
                        [851283.0, 6257962.0],
                        [859395.0, 6260541.0],
                        [865618.0, 6249711.0],
                        [881792.0, 6250642.0],
                        [887411.0, 6254047.0],
                        [891677.0, 6249845.0],
                        [890480.0, 6245406.0],
                        [892188.0, 6237089.0],
                        [906247.0, 6238345.0],
                        [911635.0, 6232742.0],
                        [917346.0, 6234793.0],
                        [918110.0, 6241136.0],
                        [924245.0, 6244827.0],
                        [917403.0, 6259253.0],
                        [922861.0, 6263349.0],
                        [918385.0, 6268519.0],
                        [920209.0, 6276225.0],
                        [916541.0, 6283087.0],
                        [917893.0, 6286245.0],
                        [925792.0, 6288611.0],
                        [926823.0, 6291811.0],
                        [921881.0, 6295602.0],
                        [910307.0, 6287877.0],
                        [904218.0, 6287715.0],
                        [896706.0, 6289935.0],
                        [886796.0, 6295631.0],
                        [879627.0, 6296831.0],
                        [876282.0, 6295340.0],
                        [865136.0, 6300908.0],
                        [863255.0, 6305296.0],
                        [858049.0, 6310039.0],
                        [848847.0, 6314233.0],
                        [839658.0, 6315433.0],
                        [831988.0, 6308980.0],
                        [833168.0, 6302217.0],
                        [828463.0, 6288899.0],
                        [819908.0, 6290041.0],
                        [815212.0, 6281222.0],
                        [813903.0, 6274579.0],
                        [800175.0, 6267290.0],
                        [799607.0, 6263119.0],
                    ],
                    [
                        [869889.0, 6258065.0],
                        [866899.0, 6258272.0],
                        [866104.0, 6264876.0],
                        [862374.0, 6265459.0],
                        [862969.0, 6272152.0],
                        [870516.0, 6271879.0],
                        [874819.0, 6259107.0],
                        [869889.0, 6258065.0],
                    ],
                ],
                "bbox": (799607.0, 6232742.0, 926823.0, 6315433.0),
            }
        },
        94: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [650942.0, 6857646.0],
                        [657169.0, 6861180.0],
                        [654926.0, 6867065.0],
                        [650140.0, 6866932.0],
                        [643644.0, 6863501.0],
                        [645325.0, 6859675.0],
                        [650942.0, 6857646.0],
                    ]
                ],
                "bbox": (643644.0, 6857646.0, 657169.0, 6867065.0),
            }
        },
        95: {
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [670056.0, 6856451.0],
                        [667928.0, 6865519.0],
                        [670882.0, 6870004.0],
                        [667303.0, 6878971.0],
                        [660416.0, 6872923.0],
                        [653619.0, 6875101.0],
                        [648071.0, 6872567.0],
                        [650140.0, 6866932.0],
                        [654926.0, 6867065.0],
                        [657169.0, 6861180.0],
                        [662997.0, 6862431.0],
                        [670056.0, 6856451.0],
                    ]
                ],
                "bbox": (648071.0, 6856451.0, 670882.0, 6878971.0),
            }
        },
    },
}

geolayer_fr_dept_data_only = {
    "metadata": metadata_fr_dept_data_only,
    "features": {
        0: {"attributes": {"CODE_DEPT": "32", "NOM_DEPT": "GERS"}},
        1: {"attributes": {"CODE_DEPT": "47", "NOM_DEPT": "LOT-ET-GARONNE"}},
        2: {"attributes": {"CODE_DEPT": "38", "NOM_DEPT": "ISERE"}},
        3: {"attributes": {"CODE_DEPT": "62", "NOM_DEPT": "PAS-DE-CALAIS"}},
        4: {"attributes": {"CODE_DEPT": "08", "NOM_DEPT": "ARDENNES"}},
        5: {"attributes": {"CODE_DEPT": "10", "NOM_DEPT": "AUBE"}},
        6: {"attributes": {"CODE_DEPT": "06", "NOM_DEPT": "ALPES-MARITIMES"}},
        7: {"attributes": {"CODE_DEPT": "42", "NOM_DEPT": "LOIRE"}},
        8: {"attributes": {"CODE_DEPT": "31", "NOM_DEPT": "HAUTE-GARONNE"}},
        9: {"attributes": {"CODE_DEPT": "71", "NOM_DEPT": "SAONE-ET-LOIRE"}},
        10: feature_dpt_data_only_a,
        11: {"attributes": {"CODE_DEPT": "16", "NOM_DEPT": "CHARENTE"}},
        12: {"attributes": {"CODE_DEPT": "50", "NOM_DEPT": "MANCHE"}},
        13: {"attributes": {"CODE_DEPT": "78", "NOM_DEPT": "YVELINES"}},
        14: {"attributes": {"CODE_DEPT": "25", "NOM_DEPT": "DOUBS"}},
        15: {"attributes": {"CODE_DEPT": "55", "NOM_DEPT": "MEUSE"}},
        16: {"attributes": {"CODE_DEPT": "33", "NOM_DEPT": "GIRONDE"}},
        17: {"attributes": {"CODE_DEPT": "14", "NOM_DEPT": "CALVADOS"}},
        18: {"attributes": {"CODE_DEPT": "88", "NOM_DEPT": "VOSGES"}},
        19: {"attributes": {"CODE_DEPT": "18", "NOM_DEPT": "CHER"}},
        20: {"attributes": {"CODE_DEPT": "07", "NOM_DEPT": "ARDECHE"}},
        21: feature_dpt_data_only_b,
        22: {"attributes": {"CODE_DEPT": "64", "NOM_DEPT": "PYRENEES-ATLANTIQUES"}},
        23: {"attributes": {"CODE_DEPT": "41", "NOM_DEPT": "LOIR-ET-CHER"}},
        24: {"attributes": {"CODE_DEPT": "57", "NOM_DEPT": "MOSELLE"}},
        25: {"attributes": {"CODE_DEPT": "86", "NOM_DEPT": "VIENNE"}},
        26: {"attributes": {"CODE_DEPT": "24", "NOM_DEPT": "DORDOGNE"}},
        27: {"attributes": {"CODE_DEPT": "39", "NOM_DEPT": "JURA"}},
        28: {"attributes": {"CODE_DEPT": "82", "NOM_DEPT": "TARN-ET-GARONNE"}},
        29: {"attributes": {"CODE_DEPT": "49", "NOM_DEPT": "MAINE-ET-LOIRE"}},
        30: {"attributes": {"CODE_DEPT": "69", "NOM_DEPT": "RHONE"}},
        31: {"attributes": {"CODE_DEPT": "27", "NOM_DEPT": "EURE"}},
        32: {"attributes": {"CODE_DEPT": "12", "NOM_DEPT": "AVEYRON"}},
        33: {"attributes": {"CODE_DEPT": "23", "NOM_DEPT": "CREUSE"}},
        34: {"attributes": {"CODE_DEPT": "45", "NOM_DEPT": "LOIRET"}},
        35: {"attributes": {"CODE_DEPT": "70", "NOM_DEPT": "HAUTE-SAONE"}},
        36: {"attributes": {"CODE_DEPT": "63", "NOM_DEPT": "PUY-DE-DOME"}},
        37: {"attributes": {"CODE_DEPT": "81", "NOM_DEPT": "TARN"}},
        38: {"attributes": {"CODE_DEPT": "76", "NOM_DEPT": "SEINE-MARITIME"}},
        39: {"attributes": {"CODE_DEPT": "52", "NOM_DEPT": "HAUTE-MARNE"}},
        40: {"attributes": {"CODE_DEPT": "30", "NOM_DEPT": "GARD"}},
        41: {"attributes": {"CODE_DEPT": "67", "NOM_DEPT": "BAS-RHIN"}},
        42: {"attributes": {"CODE_DEPT": "11", "NOM_DEPT": "AUDE"}},
        43: {"attributes": {"CODE_DEPT": "77", "NOM_DEPT": "SEINE-ET-MARNE"}},
        44: {"attributes": {"CODE_DEPT": "80", "NOM_DEPT": "SOMME"}},
        45: {"attributes": {"CODE_DEPT": "43", "NOM_DEPT": "HAUTE-LOIRE"}},
        46: {"attributes": {"CODE_DEPT": "51", "NOM_DEPT": "MARNE"}},
        47: {"attributes": {"CODE_DEPT": "65", "NOM_DEPT": "HAUTES-PYRENEES"}},
        48: {"attributes": {"CODE_DEPT": "46", "NOM_DEPT": "LOT"}},
        49: {"attributes": {"CODE_DEPT": "04", "NOM_DEPT": "ALPES-DE-HAUTE-PROVENCE"}},
        50: {"attributes": {"CODE_DEPT": "72", "NOM_DEPT": "SARTHE"}},
        51: feature_dpt_data_only_d,
        52: {"attributes": {"CODE_DEPT": "28", "NOM_DEPT": "EURE-ET-LOIR"}},
        53: {"attributes": {"CODE_DEPT": "2A", "NOM_DEPT": "CORSE-DU-SUD"}},
        54: {"attributes": {"CODE_DEPT": "54", "NOM_DEPT": "MEURTHE-ET-MOSELLE"}},
        55: {"attributes": {"CODE_DEPT": "61", "NOM_DEPT": "ORNE"}},
        56: {"attributes": {"CODE_DEPT": "01", "NOM_DEPT": "AIN"}},
        57: {"attributes": {"CODE_DEPT": "09", "NOM_DEPT": "ARIEGE"}},
        58: {"attributes": {"CODE_DEPT": "19", "NOM_DEPT": "CORREZE"}},
        59: {"attributes": {"CODE_DEPT": "68", "NOM_DEPT": "HAUT-RHIN"}},
        60: {"attributes": {"CODE_DEPT": "37", "NOM_DEPT": "INDRE-ET-LOIRE"}},
        61: {"attributes": {"CODE_DEPT": "59", "NOM_DEPT": "NORD"}},
        62: {"attributes": {"CODE_DEPT": "90", "NOM_DEPT": "TERRITOIRE DE BELFORT"}},
        63: {"attributes": {"CODE_DEPT": "44", "NOM_DEPT": "LOIRE-ATLANTIQUE"}},
        64: {"attributes": {"CODE_DEPT": "89", "NOM_DEPT": "YONNE"}},
        65: {"attributes": {"CODE_DEPT": "35", "NOM_DEPT": "ILLE-ET-VILAINE"}},
        66: {"attributes": {"CODE_DEPT": "40", "NOM_DEPT": "LANDES"}},
        67: {"attributes": {"CODE_DEPT": "29", "NOM_DEPT": "FINISTERE"}},
        68: {"attributes": {"CODE_DEPT": "74", "NOM_DEPT": "HAUTE-SAVOIE"}},
        69: {"attributes": {"CODE_DEPT": "60", "NOM_DEPT": "OISE"}},
        70: feature_dpt_data_only_c,
        71: {"attributes": {"CODE_DEPT": "58", "NOM_DEPT": "NIEVRE"}},
        72: {"attributes": {"CODE_DEPT": "21", "NOM_DEPT": "COTE-D'OR"}},
        73: {"attributes": {"CODE_DEPT": "91", "NOM_DEPT": "ESSONNE"}},
        74: {"attributes": {"CODE_DEPT": "79", "NOM_DEPT": "DEUX-SEVRES"}},
        75: {"attributes": {"CODE_DEPT": "22", "NOM_DEPT": "COTES-D'ARMOR"}},
        76: {"attributes": {"CODE_DEPT": "03", "NOM_DEPT": "ALLIER"}},
        77: {"attributes": {"CODE_DEPT": "17", "NOM_DEPT": "CHARENTE-MARITIME"}},
        78: {"attributes": {"CODE_DEPT": "15", "NOM_DEPT": "CANTAL"}},
        79: {"attributes": {"CODE_DEPT": "34", "NOM_DEPT": "HERAULT"}},
        80: {"attributes": {"CODE_DEPT": "26", "NOM_DEPT": "DROME"}},
        81: {"attributes": {"CODE_DEPT": "66", "NOM_DEPT": "PYRENEES-ORIENTALES"}},
        82: {"attributes": {"CODE_DEPT": "73", "NOM_DEPT": "SAVOIE"}},
        83: {"attributes": {"CODE_DEPT": "05", "NOM_DEPT": "HAUTES-ALPES"}},
        84: {"attributes": {"CODE_DEPT": "84", "NOM_DEPT": "VAUCLUSE"}},
        85: {"attributes": {"CODE_DEPT": "36", "NOM_DEPT": "INDRE"}},
        86: {"attributes": {"CODE_DEPT": "2B", "NOM_DEPT": "HAUTE-CORSE"}},
        87: {"attributes": {"CODE_DEPT": "87", "NOM_DEPT": "HAUTE-VIENNE"}},
        88: {"attributes": {"CODE_DEPT": "85", "NOM_DEPT": "VENDEE"}},
        89: {"attributes": {"CODE_DEPT": "83", "NOM_DEPT": "VAR"}},
        90: {"attributes": {"CODE_DEPT": "94", "NOM_DEPT": "VAL-DE-MARNE"}},
        91: {"attributes": {"CODE_DEPT": "92", "NOM_DEPT": "HAUTS-DE-SEINE"}},
        92: {"attributes": {"CODE_DEPT": "48", "NOM_DEPT": "LOZERE"}},
        93: {"attributes": {"CODE_DEPT": "13", "NOM_DEPT": "BOUCHES-DU-RHONE"}},
        94: {"attributes": {"CODE_DEPT": "75", "NOM_DEPT": "PARIS"}},
        95: {"attributes": {"CODE_DEPT": "93", "NOM_DEPT": "SEINE-SAINT-DENIS"}},
    },
}

geolayer_fr_dept_population = {
    "metadata": metadata_fr_dept_population,
    "features": {
        0: {
            "attributes": {
                "CODE_DEPT": "32",
                "INSEE_REG": "76",
                "POPULATION": 191091,
                "AREA": 6304.33,
                "DENSITY": 30.31,
            }
        },
        1: {
            "attributes": {
                "CODE_DEPT": "47",
                "INSEE_REG": "75",
                "POPULATION": 332842,
                "AREA": 5382.87,
                "DENSITY": 61.83,
            }
        },
        2: {
            "attributes": {
                "CODE_DEPT": "38",
                "INSEE_REG": "84",
                "POPULATION": 1258722,
                "AREA": 7868.79,
                "DENSITY": 159.96,
            }
        },
        3: {
            "attributes": {
                "CODE_DEPT": "62",
                "INSEE_REG": "32",
                "POPULATION": 1468018,
                "AREA": 6714.14,
                "DENSITY": 218.65,
            }
        },
        4: {
            "attributes": {
                "CODE_DEPT": "08",
                "INSEE_REG": "44",
                "POPULATION": 273579,
                "AREA": 5253.13,
                "DENSITY": 52.08,
            }
        },
        5: {
            "attributes": {
                "CODE_DEPT": "10",
                "INSEE_REG": "44",
                "POPULATION": 310020,
                "AREA": 6021.83,
                "DENSITY": 51.48,
            }
        },
        6: {
            "attributes": {
                "CODE_DEPT": "42",
                "INSEE_REG": "84",
                "POPULATION": 762941,
                "AREA": 4795.85,
                "DENSITY": 159.08,
            }
        },
        7: {
            "attributes": {
                "CODE_DEPT": "06",
                "INSEE_REG": "93",
                "POPULATION": 1083310,
                "AREA": 4291.62,
                "DENSITY": 252.42,
            }
        },
        8: {
            "attributes": {
                "CODE_DEPT": "31",
                "INSEE_REG": "76",
                "POPULATION": 1362672,
                "AREA": 6364.82,
                "DENSITY": 214.09,
            }
        },
        9: {
            "attributes": {
                "CODE_DEPT": "71",
                "INSEE_REG": "27",
                "POPULATION": 553595,
                "AREA": 8598.33,
                "DENSITY": 64.38,
            }
        },
        10: feature_dpt_population_a,
        11: {
            "attributes": {
                "CODE_DEPT": "78",
                "INSEE_REG": "11",
                "POPULATION": 1438266,
                "AREA": 2305.64,
                "DENSITY": 623.8,
            }
        },
        12: {
            "attributes": {
                "CODE_DEPT": "50",
                "INSEE_REG": "28",
                "POPULATION": 496883,
                "AREA": 6015.07,
                "DENSITY": 82.61,
            }
        },
        13: {
            "attributes": {
                "CODE_DEPT": "16",
                "INSEE_REG": "75",
                "POPULATION": 352335,
                "AREA": 5963.54,
                "DENSITY": 59.08,
            }
        },
        14: {
            "attributes": {
                "CODE_DEPT": "25",
                "INSEE_REG": "27",
                "POPULATION": 539067,
                "AREA": 5248.31,
                "DENSITY": 102.71,
            }
        },
        15: {
            "attributes": {
                "CODE_DEPT": "55",
                "INSEE_REG": "44",
                "POPULATION": 187187,
                "AREA": 6233.18,
                "DENSITY": 30.03,
            }
        },
        16: {
            "attributes": {
                "CODE_DEPT": "33",
                "INSEE_REG": "75",
                "POPULATION": 1583384,
                "AREA": 10068.74,
                "DENSITY": 157.26,
            }
        },
        17: {
            "attributes": {
                "CODE_DEPT": "14",
                "INSEE_REG": "28",
                "POPULATION": 694002,
                "AREA": 5588.48,
                "DENSITY": 124.18,
            }
        },
        18: {
            "attributes": {
                "CODE_DEPT": "88",
                "INSEE_REG": "44",
                "POPULATION": 367673,
                "AREA": 5891.56,
                "DENSITY": 62.41,
            }
        },
        19: {
            "attributes": {
                "CODE_DEPT": "18",
                "INSEE_REG": "24",
                "POPULATION": 304256,
                "AREA": 7292.67,
                "DENSITY": 41.72,
            }
        },
        20: {
            "attributes": {
                "CODE_DEPT": "07",
                "INSEE_REG": "84",
                "POPULATION": 325712,
                "AREA": 5562.05,
                "DENSITY": 58.56,
            }
        },
        21: feature_dpt_population_b,
        22: {
            "attributes": {
                "CODE_DEPT": "64",
                "INSEE_REG": "75",
                "POPULATION": 677309,
                "AREA": 7691.6,
                "DENSITY": 88.06,
            }
        },
        23: {
            "attributes": {
                "CODE_DEPT": "41",
                "INSEE_REG": "24",
                "POPULATION": 331915,
                "AREA": 6412.3,
                "DENSITY": 51.76,
            }
        },
        24: {
            "attributes": {
                "CODE_DEPT": "57",
                "INSEE_REG": "44",
                "POPULATION": 1043522,
                "AREA": 6252.63,
                "DENSITY": 166.89,
            }
        },
        25: {
            "attributes": {
                "CODE_DEPT": "86",
                "INSEE_REG": "75",
                "POPULATION": 436876,
                "AREA": 7025.24,
                "DENSITY": 62.19,
            }
        },
        26: {
            "attributes": {
                "CODE_DEPT": "24",
                "INSEE_REG": "75",
                "POPULATION": 413606,
                "AREA": 9209.9,
                "DENSITY": 44.91,
            }
        },
        27: {
            "attributes": {
                "CODE_DEPT": "39",
                "INSEE_REG": "27",
                "POPULATION": 260188,
                "AREA": 5040.63,
                "DENSITY": 51.62,
            }
        },
        28: {
            "attributes": {
                "CODE_DEPT": "82",
                "INSEE_REG": "76",
                "POPULATION": 258349,
                "AREA": 3731.0,
                "DENSITY": 69.24,
            }
        },
        29: {
            "attributes": {
                "CODE_DEPT": "49",
                "INSEE_REG": "52",
                "POPULATION": 813493,
                "AREA": 7161.34,
                "DENSITY": 113.6,
            }
        },
        30: {
            "attributes": {
                "CODE_DEPT": "69",
                "INSEE_REG": "84",
                "POPULATION": 1843319,
                "AREA": 3253.11,
                "DENSITY": 566.63,
            }
        },
        31: {
            "attributes": {
                "CODE_DEPT": "12",
                "INSEE_REG": "76",
                "POPULATION": 279206,
                "AREA": 8770.69,
                "DENSITY": 31.83,
            }
        },
        32: {
            "attributes": {
                "CODE_DEPT": "23",
                "INSEE_REG": "75",
                "POPULATION": 118638,
                "AREA": 5589.16,
                "DENSITY": 21.23,
            }
        },
        33: {
            "attributes": {
                "CODE_DEPT": "45",
                "INSEE_REG": "24",
                "POPULATION": 678008,
                "AREA": 6804.01,
                "DENSITY": 99.65,
            }
        },
        34: {
            "attributes": {
                "CODE_DEPT": "70",
                "INSEE_REG": "27",
                "POPULATION": 236659,
                "AREA": 5382.37,
                "DENSITY": 43.97,
            }
        },
        35: {
            "attributes": {
                "CODE_DEPT": "63",
                "INSEE_REG": "84",
                "POPULATION": 653742,
                "AREA": 8003.1,
                "DENSITY": 81.69,
            }
        },
        36: {
            "attributes": {
                "CODE_DEPT": "81",
                "INSEE_REG": "76",
                "POPULATION": 387890,
                "AREA": 5785.79,
                "DENSITY": 67.04,
            }
        },
        37: {
            "attributes": {
                "CODE_DEPT": "27",
                "INSEE_REG": "28",
                "POPULATION": 601843,
                "AREA": 6035.85,
                "DENSITY": 99.71,
            }
        },
        38: {
            "attributes": {
                "CODE_DEPT": "76",
                "INSEE_REG": "28",
                "POPULATION": 1254378,
                "AREA": 6318.26,
                "DENSITY": 198.53,
            }
        },
        39: {
            "attributes": {
                "CODE_DEPT": "52",
                "INSEE_REG": "44",
                "POPULATION": 175640,
                "AREA": 6249.91,
                "DENSITY": 28.1,
            }
        },
        40: {
            "attributes": {
                "CODE_DEPT": "30",
                "INSEE_REG": "76",
                "POPULATION": 744178,
                "AREA": 5874.71,
                "DENSITY": 126.67,
            }
        },
        41: {
            "attributes": {
                "CODE_DEPT": "67",
                "INSEE_REG": "44",
                "POPULATION": 1125559,
                "AREA": 4796.37,
                "DENSITY": 234.67,
            }
        },
        42: {
            "attributes": {
                "CODE_DEPT": "11",
                "INSEE_REG": "76",
                "POPULATION": 370260,
                "AREA": 6351.35,
                "DENSITY": 58.3,
            }
        },
        43: {
            "attributes": {
                "CODE_DEPT": "77",
                "INSEE_REG": "11",
                "POPULATION": 1403997,
                "AREA": 5924.64,
                "DENSITY": 236.98,
            }
        },
        44: {
            "attributes": {
                "CODE_DEPT": "43",
                "INSEE_REG": "84",
                "POPULATION": 227283,
                "AREA": 4996.58,
                "DENSITY": 45.49,
            }
        },
        45: {
            "attributes": {
                "CODE_DEPT": "51",
                "INSEE_REG": "44",
                "POPULATION": 568895,
                "AREA": 8195.78,
                "DENSITY": 69.41,
            }
        },
        46: {
            "attributes": {
                "CODE_DEPT": "80",
                "INSEE_REG": "32",
                "POPULATION": 572443,
                "AREA": 6206.58,
                "DENSITY": 92.23,
            }
        },
        47: {
            "attributes": {
                "CODE_DEPT": "46",
                "INSEE_REG": "76",
                "POPULATION": 173828,
                "AREA": 5221.64,
                "DENSITY": 33.29,
            }
        },
        48: {
            "attributes": {
                "CODE_DEPT": "65",
                "INSEE_REG": "76",
                "POPULATION": 228530,
                "AREA": 4527.89,
                "DENSITY": 50.47,
            }
        },
        49: {
            "attributes": {
                "CODE_DEPT": "04",
                "INSEE_REG": "93",
                "POPULATION": 163915,
                "AREA": 6993.79,
                "DENSITY": 23.44,
            }
        },
        50: {
            "attributes": {
                "CODE_DEPT": "72",
                "INSEE_REG": "52",
                "POPULATION": 566506,
                "AREA": 6236.75,
                "DENSITY": 90.83,
            }
        },
        51: feature_dpt_population_d,
        52: {
            "attributes": {
                "CODE_DEPT": "2A",
                "INSEE_REG": "94",
                "POPULATION": 157249,
                "AREA": 4028.53,
                "DENSITY": 39.03,
            }
        },
        53: {
            "attributes": {
                "CODE_DEPT": "28",
                "INSEE_REG": "24",
                "POPULATION": 433233,
                "AREA": 5927.23,
                "DENSITY": 73.09,
            }
        },
        54: {
            "attributes": {
                "CODE_DEPT": "54",
                "INSEE_REG": "44",
                "POPULATION": 733481,
                "AREA": 5283.29,
                "DENSITY": 138.83,
            }
        },
        55: {
            "attributes": {
                "CODE_DEPT": "01",
                "INSEE_REG": "84",
                "POPULATION": 643350,
                "AREA": 5773.77,
                "DENSITY": 111.43,
            }
        },
        56: {
            "attributes": {
                "CODE_DEPT": "19",
                "INSEE_REG": "75",
                "POPULATION": 241464,
                "AREA": 5888.93,
                "DENSITY": 41.0,
            }
        },
        57: {
            "attributes": {
                "CODE_DEPT": "09",
                "INSEE_REG": "76",
                "POPULATION": 153153,
                "AREA": 4921.75,
                "DENSITY": 31.12,
            }
        },
        58: {
            "attributes": {
                "CODE_DEPT": "68",
                "INSEE_REG": "44",
                "POPULATION": 764030,
                "AREA": 3526.37,
                "DENSITY": 216.66,
            }
        },
        59: {
            "attributes": {
                "CODE_DEPT": "59",
                "INSEE_REG": "32",
                "POPULATION": 2604361,
                "AREA": 5774.99,
                "DENSITY": 450.97,
            }
        },
        60: {
            "attributes": {
                "CODE_DEPT": "90",
                "INSEE_REG": "27",
                "POPULATION": 142622,
                "AREA": 609.64,
                "DENSITY": 233.94,
            }
        },
        61: {
            "attributes": {
                "CODE_DEPT": "44",
                "INSEE_REG": "52",
                "POPULATION": 1394909,
                "AREA": 6992.78,
                "DENSITY": 199.48,
            }
        },
        62: {
            "attributes": {
                "CODE_DEPT": "89",
                "INSEE_REG": "27",
                "POPULATION": 338291,
                "AREA": 7450.97,
                "DENSITY": 45.4,
            }
        },
        63: {
            "attributes": {
                "CODE_DEPT": "35",
                "INSEE_REG": "53",
                "POPULATION": 1060199,
                "AREA": 6830.2,
                "DENSITY": 155.22,
            }
        },
        64: {
            "attributes": {
                "CODE_DEPT": "40",
                "INSEE_REG": "75",
                "POPULATION": 407444,
                "AREA": 9353.03,
                "DENSITY": 43.56,
            }
        },
        65: {
            "attributes": {
                "CODE_DEPT": "29",
                "INSEE_REG": "53",
                "POPULATION": 909028,
                "AREA": 6756.76,
                "DENSITY": 134.54,
            }
        },
        66: {
            "attributes": {
                "CODE_DEPT": "74",
                "INSEE_REG": "84",
                "POPULATION": 807360,
                "AREA": 4596.53,
                "DENSITY": 175.65,
            }
        },
        67: {
            "attributes": {
                "CODE_DEPT": "60",
                "INSEE_REG": "32",
                "POPULATION": 824503,
                "AREA": 5893.6,
                "DENSITY": 139.9,
            }
        },
        68: feature_dpt_population_c,
        69: {
            "attributes": {
                "CODE_DEPT": "58",
                "INSEE_REG": "27",
                "POPULATION": 207182,
                "AREA": 6862.87,
                "DENSITY": 30.19,
            }
        },
        70: {
            "attributes": {
                "CODE_DEPT": "61",
                "INSEE_REG": "28",
                "POPULATION": 283372,
                "AREA": 6142.73,
                "DENSITY": 46.13,
            }
        },
        71: {
            "attributes": {
                "CODE_DEPT": "91",
                "INSEE_REG": "11",
                "POPULATION": 1296130,
                "AREA": 1818.35,
                "DENSITY": 712.81,
            }
        },
        72: {
            "attributes": {
                "CODE_DEPT": "21",
                "INSEE_REG": "27",
                "POPULATION": 532871,
                "AREA": 8787.51,
                "DENSITY": 60.64,
            }
        },
        73: {
            "attributes": {
                "CODE_DEPT": "22",
                "INSEE_REG": "53",
                "POPULATION": 598814,
                "AREA": 6963.26,
                "DENSITY": 86.0,
            }
        },
        74: {
            "attributes": {
                "CODE_DEPT": "03",
                "INSEE_REG": "84",
                "POPULATION": 337988,
                "AREA": 7365.26,
                "DENSITY": 45.89,
            }
        },
        75: {
            "attributes": {
                "CODE_DEPT": "17",
                "INSEE_REG": "75",
                "POPULATION": 644303,
                "AREA": 6913.03,
                "DENSITY": 93.2,
            }
        },
        76: {
            "attributes": {
                "CODE_DEPT": "15",
                "INSEE_REG": "84",
                "POPULATION": 145143,
                "AREA": 5767.47,
                "DENSITY": 25.17,
            }
        },
        77: {
            "attributes": {
                "CODE_DEPT": "34",
                "INSEE_REG": "76",
                "POPULATION": 1144892,
                "AREA": 6231.05,
                "DENSITY": 183.74,
            }
        },
        78: {
            "attributes": {
                "CODE_DEPT": "26",
                "INSEE_REG": "84",
                "POPULATION": 511553,
                "AREA": 6553.53,
                "DENSITY": 78.06,
            }
        },
        79: {
            "attributes": {
                "CODE_DEPT": "66",
                "INSEE_REG": "76",
                "POPULATION": 474452,
                "AREA": 4147.76,
                "DENSITY": 114.39,
            }
        },
        80: {
            "attributes": {
                "CODE_DEPT": "73",
                "INSEE_REG": "84",
                "POPULATION": 431174,
                "AREA": 6260.4,
                "DENSITY": 68.87,
            }
        },
        81: {
            "attributes": {
                "CODE_DEPT": "37",
                "INSEE_REG": "24",
                "POPULATION": 606511,
                "AREA": 6147.6,
                "DENSITY": 98.66,
            }
        },
        82: {
            "attributes": {
                "CODE_DEPT": "05",
                "INSEE_REG": "93",
                "POPULATION": 141284,
                "AREA": 5685.31,
                "DENSITY": 24.85,
            }
        },
        83: {
            "attributes": {
                "CODE_DEPT": "79",
                "INSEE_REG": "75",
                "POPULATION": 374351,
                "AREA": 6029.06,
                "DENSITY": 62.09,
            }
        },
        84: {
            "attributes": {
                "CODE_DEPT": "84",
                "INSEE_REG": "93",
                "POPULATION": 559479,
                "AREA": 3577.19,
                "DENSITY": 156.4,
            }
        },
        85: {
            "attributes": {
                "CODE_DEPT": "36",
                "INSEE_REG": "24",
                "POPULATION": 222232,
                "AREA": 6887.38,
                "DENSITY": 32.27,
            }
        },
        86: {
            "attributes": {
                "CODE_DEPT": "2B",
                "INSEE_REG": "94",
                "POPULATION": 177689,
                "AREA": 4719.71,
                "DENSITY": 37.65,
            }
        },
        87: {
            "attributes": {
                "CODE_DEPT": "87",
                "INSEE_REG": "75",
                "POPULATION": 374426,
                "AREA": 5549.31,
                "DENSITY": 67.47,
            }
        },
        88: {
            "attributes": {
                "CODE_DEPT": "85",
                "INSEE_REG": "52",
                "POPULATION": 675247,
                "AREA": 6758.23,
                "DENSITY": 99.91,
            }
        },
        89: {
            "attributes": {
                "CODE_DEPT": "83",
                "INSEE_REG": "93",
                "POPULATION": 1058740,
                "AREA": 6002.84,
                "DENSITY": 176.37,
            }
        },
        90: {
            "attributes": {
                "CODE_DEPT": "94",
                "INSEE_REG": "11",
                "POPULATION": 1387926,
                "AREA": 244.7,
                "DENSITY": 5671.95,
            }
        },
        91: {
            "attributes": {
                "CODE_DEPT": "92",
                "INSEE_REG": "11",
                "POPULATION": 1609306,
                "AREA": 175.63,
                "DENSITY": 9163.05,
            }
        },
        92: {
            "attributes": {
                "CODE_DEPT": "48",
                "INSEE_REG": "76",
                "POPULATION": 76601,
                "AREA": 5172.02,
                "DENSITY": 14.81,
            }
        },
        93: {
            "attributes": {
                "CODE_DEPT": "13",
                "INSEE_REG": "93",
                "POPULATION": 2024162,
                "AREA": 5082.57,
                "DENSITY": 398.26,
            }
        },
        94: {
            "attributes": {
                "CODE_DEPT": "93",
                "INSEE_REG": "11",
                "POPULATION": 1623111,
                "AREA": 236.96,
                "DENSITY": 6849.73,
            }
        },
        95: {
            "attributes": {
                "CODE_DEPT": "75",
                "INSEE_REG": "11",
                "POPULATION": 2187526,
                "AREA": 105.44,
                "DENSITY": 20746.64,
            }
        },
    },
}

geolayer_fr_dept_population_geometry = {
    "metadata": metadata_fr_dept_population_geometry,
    "features": {
        0: {
            "attributes": {
                "CODE_DEPT": "32",
                "NOM_DEPT": "GERS",
                "POPULATION": 191091,
                "DENSITY": 30.31,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [505760.0, 6248691.0],
                        [509767.0, 6249274.0],
                        [514960.0, 6255730.0],
                        [523428.0, 6259977.0],
                        [531230.0, 6258583.0],
                        [536034.0, 6253601.0],
                        [539594.0, 6265818.0],
                        [554723.0, 6278961.0],
                        [550482.0, 6283435.0],
                        [545681.0, 6284750.0],
                        [535303.0, 6300840.0],
                        [531445.0, 6300603.0],
                        [531142.0, 6309545.0],
                        [528381.0, 6316132.0],
                        [520187.0, 6318466.0],
                        [528536.0, 6329188.0],
                        [521740.0, 6328834.0],
                        [519117.0, 6332164.0],
                        [512956.0, 6327891.0],
                        [507637.0, 6333951.0],
                        [502833.0, 6331375.0],
                        [496470.0, 6331745.0],
                        [495008.0, 6328849.0],
                        [483787.0, 6325253.0],
                        [474692.0, 6327970.0],
                        [465465.0, 6324803.0],
                        [465239.0, 6317398.0],
                        [461632.0, 6315722.0],
                        [453303.0, 6321029.0],
                        [444807.0, 6320573.0],
                        [440195.0, 6315550.0],
                        [443572.0, 6313646.0],
                        [442698.0, 6298315.0],
                        [439499.0, 6295895.0],
                        [438084.0, 6281592.0],
                        [443497.0, 6282643.0],
                        [449863.0, 6280833.0],
                        [456497.0, 6283051.0],
                        [457450.0, 6278664.0],
                        [461941.0, 6273297.0],
                        [466465.0, 6272970.0],
                        [468215.0, 6263513.0],
                        [471536.0, 6256527.0],
                        [479309.0, 6257879.0],
                        [496988.0, 6250664.0],
                        [505760.0, 6248691.0],
                    ]
                ],
            },
        },
        1: {
            "attributes": {
                "CODE_DEPT": "47",
                "NOM_DEPT": "LOT-ET-GARONNE",
                "POPULATION": 332842,
                "DENSITY": 61.83,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [547193.0, 6388334.0],
                        [539761.0, 6395885.0],
                        [530971.0, 6390971.0],
                        [526858.0, 6394383.0],
                        [527849.0, 6401566.0],
                        [514373.0, 6400391.0],
                        [512334.0, 6403639.0],
                        [495031.0, 6397493.0],
                        [491196.0, 6399384.0],
                        [489091.0, 6407815.0],
                        [486169.0, 6410676.0],
                        [474628.0, 6407547.0],
                        [472909.0, 6402270.0],
                        [476701.0, 6399758.0],
                        [474218.0, 6394851.0],
                        [464993.0, 6388179.0],
                        [460343.0, 6383021.0],
                        [460366.0, 6373402.0],
                        [462536.0, 6370133.0],
                        [454032.0, 6364649.0],
                        [457916.0, 6359953.0],
                        [455164.0, 6354504.0],
                        [449164.0, 6352477.0],
                        [449759.0, 6344226.0],
                        [459734.0, 6343570.0],
                        [462757.0, 6341305.0],
                        [470769.0, 6340294.0],
                        [467874.0, 6336236.0],
                        [464468.0, 6326808.0],
                        [465465.0, 6324803.0],
                        [474692.0, 6327970.0],
                        [483787.0, 6325253.0],
                        [495008.0, 6328849.0],
                        [496470.0, 6331745.0],
                        [502833.0, 6331375.0],
                        [507637.0, 6333951.0],
                        [512956.0, 6327891.0],
                        [519117.0, 6332164.0],
                        [520115.0, 6336256.0],
                        [529462.0, 6338671.0],
                        [533815.0, 6350996.0],
                        [536387.0, 6355171.0],
                        [530427.0, 6360537.0],
                        [531660.0, 6365290.0],
                        [544593.0, 6364542.0],
                        [545774.0, 6366277.0],
                        [541673.0, 6377661.0],
                        [542159.0, 6383881.0],
                        [547193.0, 6388334.0],
                    ]
                ],
            },
        },
        2: {
            "attributes": {
                "CODE_DEPT": "38",
                "NOM_DEPT": "ISERE",
                "POPULATION": 1258722,
                "DENSITY": 159.96,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [841110.0, 6468164.0],
                        [847361.0, 6468209.0],
                        [855768.0, 6473591.0],
                        [860939.0, 6470947.0],
                        [866406.0, 6463235.0],
                        [870728.0, 6463360.0],
                        [871909.0, 6454823.0],
                        [871457.0, 6445038.0],
                        [888053.0, 6440277.0],
                        [892767.0, 6444271.0],
                        [895595.0, 6439026.0],
                        [895949.0, 6427870.0],
                        [894862.0, 6413405.0],
                        [907889.0, 6409384.0],
                        [918546.0, 6403480.0],
                        [921863.0, 6404787.0],
                        [925560.0, 6409806.0],
                        [930672.0, 6410433.0],
                        [933177.0, 6416064.0],
                        [939410.0, 6420031.0],
                        [941569.0, 6417648.0],
                        [947667.0, 6423241.0],
                        [956742.0, 6422339.0],
                        [960775.0, 6424797.0],
                        [965006.0, 6422921.0],
                        [964872.0, 6432532.0],
                        [961377.0, 6439340.0],
                        [952342.0, 6439924.0],
                        [953909.0, 6450690.0],
                        [956276.0, 6452799.0],
                        [950505.0, 6456663.0],
                        [945165.0, 6465401.0],
                        [945461.0, 6470305.0],
                        [949441.0, 6473761.0],
                        [948557.0, 6482085.0],
                        [943964.0, 6486985.0],
                        [938381.0, 6486658.0],
                        [931624.0, 6492445.0],
                        [925224.0, 6482705.0],
                        [917457.0, 6486189.0],
                        [913763.0, 6489603.0],
                        [904449.0, 6504924.0],
                        [897998.0, 6515860.0],
                        [888123.0, 6525941.0],
                        [888996.0, 6528631.0],
                        [882529.0, 6534232.0],
                        [879159.0, 6530984.0],
                        [876089.0, 6523611.0],
                        [870291.0, 6521483.0],
                        [863140.0, 6525920.0],
                        [862850.0, 6517700.0],
                        [865784.0, 6514252.0],
                        [858527.0, 6506228.0],
                        [848198.0, 6502534.0],
                        [841056.0, 6498593.0],
                        [845846.0, 6493277.0],
                        [837308.0, 6485557.0],
                        [837457.0, 6475559.0],
                        [841110.0, 6468164.0],
                    ]
                ],
            },
        },
        3: {
            "attributes": {
                "CODE_DEPT": "62",
                "NOM_DEPT": "PAS-DE-CALAIS",
                "POPULATION": 1468018,
                "DENSITY": 218.65,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [634422.0, 7101577.0],
                        [623701.0, 7099214.0],
                        [610465.0, 7094261.0],
                        [605814.0, 7089013.0],
                        [599885.0, 7086576.0],
                        [601399.0, 7078135.0],
                        [598139.0, 7067917.0],
                        [599563.0, 7049801.0],
                        [597332.0, 7035063.0],
                        [603193.0, 7029103.0],
                        [605232.0, 7026713.0],
                        [612989.0, 7030025.0],
                        [622831.0, 7024302.0],
                        [624801.0, 7021563.0],
                        [634147.0, 7017146.0],
                        [635372.0, 7012312.0],
                        [648121.0, 7014552.0],
                        [654991.0, 7012592.0],
                        [660837.0, 7014835.0],
                        [663948.0, 7010834.0],
                        [656343.0, 7006536.0],
                        [658067.0, 7000416.0],
                        [662547.0, 7004433.0],
                        [667892.0, 7004913.0],
                        [669642.0, 7001764.0],
                        [689814.0, 6997681.0],
                        [691147.0, 6993758.0],
                        [706470.0, 6995042.0],
                        [706855.0, 7002888.0],
                        [711164.0, 7009522.0],
                        [712383.0, 7015916.0],
                        [699507.0, 7031355.0],
                        [702680.0, 7038239.0],
                        [701478.0, 7042709.0],
                        [697493.0, 7046164.0],
                        [692820.0, 7044918.0],
                        [687641.0, 7047582.0],
                        [686184.0, 7056263.0],
                        [688698.0, 7062196.0],
                        [683642.0, 7063001.0],
                        [679720.0, 7059405.0],
                        [673807.0, 7057943.0],
                        [664277.0, 7059477.0],
                        [658064.0, 7064147.0],
                        [653390.0, 7071778.0],
                        [644454.0, 7079622.0],
                        [642453.0, 7087769.0],
                        [636514.0, 7100652.0],
                        [634422.0, 7101577.0],
                    ]
                ],
            },
        },
        4: {
            "attributes": {
                "CODE_DEPT": "08",
                "NOM_DEPT": "ARDENNES",
                "POPULATION": 273579,
                "DENSITY": 52.08,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [776081.0, 6923412.0],
                        [782994.0, 6923346.0],
                        [790665.0, 6921022.0],
                        [795010.0, 6915033.0],
                        [803525.0, 6909934.0],
                        [814643.0, 6911926.0],
                        [818364.0, 6905215.0],
                        [822754.0, 6907655.0],
                        [833062.0, 6905548.0],
                        [837898.0, 6908256.0],
                        [842092.0, 6905887.0],
                        [849280.0, 6910207.0],
                        [847303.0, 6917040.0],
                        [853548.0, 6926776.0],
                        [849442.0, 6935263.0],
                        [853210.0, 6945817.0],
                        [856532.0, 6942619.0],
                        [867310.0, 6942452.0],
                        [873032.0, 6949057.0],
                        [869864.0, 6950495.0],
                        [863792.0, 6957578.0],
                        [856370.0, 6957018.0],
                        [850915.0, 6964755.0],
                        [848735.0, 6964497.0],
                        [834935.0, 6970707.0],
                        [833403.0, 6975569.0],
                        [835414.0, 6979112.0],
                        [832902.0, 6984653.0],
                        [828614.0, 6985882.0],
                        [833821.0, 7001508.0],
                        [834466.0, 7007583.0],
                        [830491.0, 7008459.0],
                        [826108.0, 7005649.0],
                        [820627.0, 6997569.0],
                        [821199.0, 6989850.0],
                        [814347.0, 6988595.0],
                        [808498.0, 6984157.0],
                        [803958.0, 6983050.0],
                        [795770.0, 6985807.0],
                        [788558.0, 6985051.0],
                        [789845.0, 6973793.0],
                        [787172.0, 6965431.0],
                        [790134.0, 6962730.0],
                        [781387.0, 6953785.0],
                        [779463.0, 6948255.0],
                        [774574.0, 6946610.0],
                        [777906.0, 6941851.0],
                        [775403.0, 6934852.0],
                        [776081.0, 6923412.0],
                    ]
                ],
            },
        },
        5: {
            "attributes": {
                "CODE_DEPT": "10",
                "NOM_DEPT": "AUBE",
                "POPULATION": 310020,
                "DENSITY": 51.48,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [730707.0, 6810078.0],
                        [736893.0, 6807760.0],
                        [745765.0, 6796957.0],
                        [746161.0, 6791892.0],
                        [749678.0, 6782304.0],
                        [755033.0, 6785741.0],
                        [759917.0, 6778325.0],
                        [763413.0, 6765164.0],
                        [767353.0, 6760249.0],
                        [783028.0, 6759096.0],
                        [789480.0, 6763963.0],
                        [796594.0, 6759156.0],
                        [797692.0, 6763119.0],
                        [808147.0, 6762855.0],
                        [816397.0, 6764598.0],
                        [817962.0, 6771080.0],
                        [827043.0, 6770243.0],
                        [825768.0, 6776095.0],
                        [828770.0, 6781171.0],
                        [835407.0, 6779651.0],
                        [837598.0, 6783989.0],
                        [837935.0, 6797546.0],
                        [834073.0, 6806764.0],
                        [827022.0, 6811887.0],
                        [822210.0, 6820200.0],
                        [823302.0, 6827043.0],
                        [819107.0, 6829393.0],
                        [814106.0, 6826118.0],
                        [803526.0, 6829924.0],
                        [796995.0, 6835851.0],
                        [797551.0, 6845278.0],
                        [785824.0, 6845891.0],
                        [779497.0, 6845091.0],
                        [773768.0, 6840880.0],
                        [769985.0, 6834113.0],
                        [760761.0, 6824301.0],
                        [753955.0, 6826609.0],
                        [746802.0, 6826973.0],
                        [740952.0, 6835710.0],
                        [737148.0, 6833964.0],
                        [731262.0, 6826009.0],
                        [728998.0, 6813854.0],
                        [730707.0, 6810078.0],
                    ]
                ],
            },
        },
        6: {
            "attributes": {
                "CODE_DEPT": "06",
                "NOM_DEPT": "ALPES-MARITIMES",
                "POPULATION": 1083310,
                "DENSITY": 252.42,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1009696.0, 6370071.0],
                        [1002665.0, 6364730.0],
                        [997268.0, 6357103.0],
                        [994698.0, 6348019.0],
                        [1000668.0, 6338218.0],
                        [1000089.0, 6334256.0],
                        [1007601.0, 6328762.0],
                        [1009068.0, 6324850.0],
                        [1014122.0, 6322114.0],
                        [1012050.0, 6317690.0],
                        [1007566.0, 6320724.0],
                        [1000978.0, 6315262.0],
                        [997097.0, 6315251.0],
                        [992638.0, 6305621.0],
                        [1002326.0, 6300425.0],
                        [1003290.0, 6292496.0],
                        [1006552.0, 6288390.0],
                        [1015523.0, 6285590.0],
                        [1014132.0, 6274778.0],
                        [1018256.0, 6272482.0],
                        [1020971.0, 6279894.0],
                        [1026533.0, 6279746.0],
                        [1033109.0, 6287175.0],
                        [1036126.0, 6293135.0],
                        [1041921.0, 6296903.0],
                        [1048217.0, 6297561.0],
                        [1064350.0, 6309506.0],
                        [1061225.0, 6317546.0],
                        [1066133.0, 6321494.0],
                        [1066468.0, 6326676.0],
                        [1072800.0, 6330433.0],
                        [1073742.0, 6336784.0],
                        [1077560.0, 6342698.0],
                        [1073403.0, 6350462.0],
                        [1060282.0, 6348576.0],
                        [1054180.0, 6344806.0],
                        [1042408.0, 6347558.0],
                        [1034654.0, 6353189.0],
                        [1025044.0, 6356596.0],
                        [1020000.0, 6356725.0],
                        [1018585.0, 6361599.0],
                        [1009696.0, 6370071.0],
                    ]
                ],
            },
        },
        7: {
            "attributes": {
                "CODE_DEPT": "42",
                "NOM_DEPT": "LOIRE",
                "POPULATION": 762941,
                "DENSITY": 159.08,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [753779.0, 6537018.0],
                        [758503.0, 6532097.0],
                        [754369.0, 6520637.0],
                        [760734.0, 6514163.0],
                        [764154.0, 6503988.0],
                        [770440.0, 6500348.0],
                        [774454.0, 6495613.0],
                        [776221.0, 6483674.0],
                        [770335.0, 6479388.0],
                        [770263.0, 6473476.0],
                        [776677.0, 6475557.0],
                        [780259.0, 6472021.0],
                        [792166.0, 6477709.0],
                        [802398.0, 6475469.0],
                        [807029.0, 6471772.0],
                        [806856.0, 6463705.0],
                        [811227.0, 6465007.0],
                        [816370.0, 6460772.0],
                        [825694.0, 6462649.0],
                        [826509.0, 6469123.0],
                        [831517.0, 6473257.0],
                        [837457.0, 6475559.0],
                        [837308.0, 6485557.0],
                        [834511.0, 6489782.0],
                        [829797.0, 6488843.0],
                        [825934.0, 6498617.0],
                        [818524.0, 6498224.0],
                        [809870.0, 6504594.0],
                        [806255.0, 6511913.0],
                        [808147.0, 6518212.0],
                        [807296.0, 6530310.0],
                        [802643.0, 6534285.0],
                        [800220.0, 6540120.0],
                        [801039.0, 6547667.0],
                        [798995.0, 6551156.0],
                        [802035.0, 6559678.0],
                        [810991.0, 6564128.0],
                        [806993.0, 6569822.0],
                        [798969.0, 6562707.0],
                        [797273.0, 6565101.0],
                        [787355.0, 6564848.0],
                        [785138.0, 6567101.0],
                        [776287.0, 6563809.0],
                        [774989.0, 6567447.0],
                        [768620.0, 6568680.0],
                        [769267.0, 6575508.0],
                        [762003.0, 6573092.0],
                        [760949.0, 6561975.0],
                        [763504.0, 6554575.0],
                        [762385.0, 6549859.0],
                        [763887.0, 6544360.0],
                        [761084.0, 6541876.0],
                        [754888.0, 6541809.0],
                        [753779.0, 6537018.0],
                    ]
                ],
            },
        },
        8: {
            "attributes": {
                "CODE_DEPT": "31",
                "NOM_DEPT": "HAUTE-GARONNE",
                "POPULATION": 1362672,
                "DENSITY": 214.09,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [505760.0, 6248691.0],
                        [506455.0, 6246240.0],
                        [501020.0, 6240519.0],
                        [500952.0, 6237523.0],
                        [491741.0, 6229153.0],
                        [498958.0, 6224762.0],
                        [501199.0, 6216194.0],
                        [506394.0, 6214104.0],
                        [501753.0, 6199863.0],
                        [493715.0, 6200925.0],
                        [492032.0, 6195420.0],
                        [491362.0, 6184305.0],
                        [493119.0, 6181125.0],
                        [509918.0, 6181609.0],
                        [507071.0, 6189939.0],
                        [508439.0, 6196068.0],
                        [512551.0, 6198492.0],
                        [524704.0, 6194181.0],
                        [522873.0, 6204718.0],
                        [526458.0, 6208824.0],
                        [535012.0, 6210452.0],
                        [537386.0, 6214080.0],
                        [535770.0, 6220735.0],
                        [540236.0, 6224348.0],
                        [541984.0, 6228895.0],
                        [547328.0, 6230443.0],
                        [554118.0, 6225953.0],
                        [555809.0, 6233248.0],
                        [562910.0, 6233771.0],
                        [567825.0, 6236309.0],
                        [561407.0, 6244405.0],
                        [565565.0, 6247682.0],
                        [572065.0, 6240985.0],
                        [575081.0, 6235814.0],
                        [582028.0, 6242918.0],
                        [589272.0, 6240503.0],
                        [593467.0, 6242482.0],
                        [598408.0, 6250205.0],
                        [603733.0, 6249863.0],
                        [603060.0, 6255463.0],
                        [607574.0, 6261192.0],
                        [611672.0, 6256714.0],
                        [621363.0, 6260238.0],
                        [620519.0, 6263967.0],
                        [609628.0, 6269734.0],
                        [605052.0, 6276459.0],
                        [594074.0, 6282175.0],
                        [597601.0, 6285124.0],
                        [595737.0, 6291653.0],
                        [592076.0, 6294561.0],
                        [590928.0, 6301074.0],
                        [586632.0, 6302842.0],
                        [583878.0, 6308763.0],
                        [583992.0, 6314318.0],
                        [575242.0, 6309509.0],
                        [567948.0, 6310839.0],
                        [568130.0, 6303820.0],
                        [556606.0, 6298479.0],
                        [550735.0, 6304341.0],
                        [535303.0, 6300840.0],
                        [545681.0, 6284750.0],
                        [550482.0, 6283435.0],
                        [554723.0, 6278961.0],
                        [539594.0, 6265818.0],
                        [536034.0, 6253601.0],
                        [531230.0, 6258583.0],
                        [523428.0, 6259977.0],
                        [514960.0, 6255730.0],
                        [509767.0, 6249274.0],
                        [505760.0, 6248691.0],
                    ]
                ],
            },
        },
        9: {
            "attributes": {
                "CODE_DEPT": "71",
                "NOM_DEPT": "SAONE-ET-LOIRE",
                "POPULATION": 553595,
                "DENSITY": 64.38,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [806993.0, 6569822.0],
                        [808209.0, 6578315.0],
                        [815826.0, 6575242.0],
                        [824653.0, 6575157.0],
                        [830305.0, 6579430.0],
                        [833486.0, 6565745.0],
                        [837322.0, 6565642.0],
                        [839484.0, 6574938.0],
                        [845050.0, 6590960.0],
                        [845229.0, 6595067.0],
                        [848718.0, 6603737.0],
                        [857422.0, 6600366.0],
                        [868758.0, 6603264.0],
                        [869949.0, 6598870.0],
                        [877344.0, 6596683.0],
                        [885325.0, 6599852.0],
                        [880824.0, 6605207.0],
                        [886706.0, 6618161.0],
                        [882575.0, 6628163.0],
                        [880659.0, 6638936.0],
                        [887343.0, 6642371.0],
                        [876345.0, 6647462.0],
                        [872158.0, 6650880.0],
                        [871408.0, 6655745.0],
                        [860161.0, 6652754.0],
                        [855755.0, 6655507.0],
                        [831500.0, 6648015.0],
                        [823470.0, 6650227.0],
                        [813434.0, 6659755.0],
                        [806754.0, 6662035.0],
                        [806631.0, 6665548.0],
                        [795506.0, 6668991.0],
                        [791663.0, 6673495.0],
                        [789554.0, 6672918.0],
                        [784602.0, 6669828.0],
                        [780471.0, 6669516.0],
                        [778810.0, 6664936.0],
                        [781374.0, 6662136.0],
                        [779000.0, 6654397.0],
                        [778932.0, 6646959.0],
                        [783308.0, 6642195.0],
                        [780490.0, 6638662.0],
                        [781064.0, 6632682.0],
                        [775685.0, 6631211.0],
                        [770503.0, 6626941.0],
                        [760920.0, 6622686.0],
                        [756196.0, 6628301.0],
                        [748049.0, 6627896.0],
                        [748734.0, 6623209.0],
                        [753291.0, 6618069.0],
                        [756931.0, 6607772.0],
                        [761463.0, 6602522.0],
                        [763922.0, 6603795.0],
                        [768312.0, 6598303.0],
                        [773476.0, 6599308.0],
                        [776586.0, 6596649.0],
                        [775079.0, 6589273.0],
                        [775913.0, 6580395.0],
                        [769267.0, 6575508.0],
                        [768620.0, 6568680.0],
                        [774989.0, 6567447.0],
                        [776287.0, 6563809.0],
                        [785138.0, 6567101.0],
                        [787355.0, 6564848.0],
                        [797273.0, 6565101.0],
                        [798969.0, 6562707.0],
                        [806993.0, 6569822.0],
                    ]
                ],
            },
        },
        10: feature_dpt_population_geometry_a,
        11: {
            "attributes": {
                "CODE_DEPT": "16",
                "NOM_DEPT": "CHARENTE",
                "POPULATION": 352335,
                "DENSITY": 59.08,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [459784.0, 6545825.0],
                        [457303.0, 6539406.0],
                        [458386.0, 6534878.0],
                        [455132.0, 6526680.0],
                        [449713.0, 6524677.0],
                        [445866.0, 6528260.0],
                        [434480.0, 6521530.0],
                        [434607.0, 6512022.0],
                        [436951.0, 6506668.0],
                        [442913.0, 6501478.0],
                        [446521.0, 6493231.0],
                        [444696.0, 6489309.0],
                        [445861.0, 6484044.0],
                        [443202.0, 6478722.0],
                        [447267.0, 6474282.0],
                        [456356.0, 6470307.0],
                        [455660.0, 6465791.0],
                        [461242.0, 6465553.0],
                        [464807.0, 6459164.0],
                        [468806.0, 6462928.0],
                        [474561.0, 6460744.0],
                        [485798.0, 6470195.0],
                        [484697.0, 6477489.0],
                        [489646.0, 6488189.0],
                        [493466.0, 6488572.0],
                        [504657.0, 6496986.0],
                        [505177.0, 6505055.0],
                        [513233.0, 6510903.0],
                        [515635.0, 6515544.0],
                        [522412.0, 6520738.0],
                        [522669.0, 6525452.0],
                        [527825.0, 6527023.0],
                        [534383.0, 6537804.0],
                        [540666.0, 6541823.0],
                        [539507.0, 6547743.0],
                        [531290.0, 6552122.0],
                        [531964.0, 6561069.0],
                        [526089.0, 6562344.0],
                        [521367.0, 6557890.0],
                        [509938.0, 6556936.0],
                        [507509.0, 6562167.0],
                        [499249.0, 6554736.0],
                        [489751.0, 6554866.0],
                        [483517.0, 6558927.0],
                        [473907.0, 6559092.0],
                        [469589.0, 6554692.0],
                        [465641.0, 6555184.0],
                        [464645.0, 6548283.0],
                        [459784.0, 6545825.0],
                    ]
                ],
            },
        },
        12: {
            "attributes": {
                "CODE_DEPT": "50",
                "NOM_DEPT": "MANCHE",
                "POPULATION": 496883,
                "DENSITY": 82.61,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [417723.0, 6857101.0],
                        [408651.0, 6861319.0],
                        [399642.0, 6861271.0],
                        [396867.0, 6868913.0],
                        [401493.0, 6871059.0],
                        [411444.0, 6881401.0],
                        [417375.0, 6892264.0],
                        [416434.0, 6899162.0],
                        [413253.0, 6901117.0],
                        [415797.0, 6907383.0],
                        [406933.0, 6907874.0],
                        [400663.0, 6914651.0],
                        [399047.0, 6920143.0],
                        [400759.0, 6925144.0],
                        [397607.0, 6926545.0],
                        [396597.0, 6932989.0],
                        [388320.0, 6946238.0],
                        [388687.0, 6950091.0],
                        [394381.0, 6955463.0],
                        [390587.0, 6963240.0],
                        [381046.0, 6965005.0],
                        [372051.0, 6959988.0],
                        [362230.0, 6961356.0],
                        [343652.0, 6969661.0],
                        [343012.0, 6963991.0],
                        [349037.0, 6960923.0],
                        [349892.0, 6952123.0],
                        [346450.0, 6948841.0],
                        [350114.0, 6938864.0],
                        [350193.0, 6931900.0],
                        [357636.0, 6924163.0],
                        [364780.0, 6906370.0],
                        [363427.0, 6896430.0],
                        [366480.0, 6887586.0],
                        [365701.0, 6878731.0],
                        [362959.0, 6869214.0],
                        [363872.0, 6859932.0],
                        [368562.0, 6852485.0],
                        [376547.0, 6847928.0],
                        [372261.0, 6845150.0],
                        [363309.0, 6845999.0],
                        [366767.0, 6839135.0],
                        [368413.0, 6830443.0],
                        [376536.0, 6826525.0],
                        [384742.0, 6834496.0],
                        [389634.0, 6835155.0],
                        [399495.0, 6830885.0],
                        [404267.0, 6828490.0],
                        [407934.0, 6831360.0],
                        [414934.0, 6829326.0],
                        [421619.0, 6835816.0],
                        [423498.0, 6841841.0],
                        [420581.0, 6852284.0],
                        [417723.0, 6857101.0],
                    ]
                ],
            },
        },
        13: {
            "attributes": {
                "CODE_DEPT": "78",
                "NOM_DEPT": "YVELINES",
                "POPULATION": 1438266,
                "DENSITY": 623.8,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [590236.0, 6872273.0],
                        [594217.0, 6866696.0],
                        [596554.0, 6858123.0],
                        [595472.0, 6845570.0],
                        [597086.0, 6841311.0],
                        [604791.0, 6831646.0],
                        [608912.0, 6830618.0],
                        [611402.0, 6819097.0],
                        [620311.0, 6818025.0],
                        [623768.0, 6826369.0],
                        [627504.0, 6829048.0],
                        [627800.0, 6838438.0],
                        [632440.0, 6843248.0],
                        [634691.0, 6849194.0],
                        [643163.0, 6853168.0],
                        [637702.0, 6857774.0],
                        [637864.0, 6864035.0],
                        [641404.0, 6867928.0],
                        [641836.0, 6872490.0],
                        [633062.0, 6879807.0],
                        [628641.0, 6878089.0],
                        [622312.0, 6880731.0],
                        [614076.0, 6886919.0],
                        [606678.0, 6883543.0],
                        [603102.0, 6887292.0],
                        [598361.0, 6887345.0],
                        [591984.0, 6886421.0],
                        [587216.0, 6881812.0],
                        [590236.0, 6872273.0],
                    ]
                ],
            },
        },
        14: {
            "attributes": {
                "CODE_DEPT": "25",
                "NOM_DEPT": "DOUBS",
                "POPULATION": 539067,
                "DENSITY": 102.71,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [986155.0, 6724947.0],
                        [984341.0, 6721925.0],
                        [977033.0, 6724531.0],
                        [974258.0, 6721322.0],
                        [969354.0, 6721610.0],
                        [967469.0, 6716290.0],
                        [955890.0, 6718838.0],
                        [950918.0, 6717032.0],
                        [945847.0, 6708437.0],
                        [932449.0, 6699390.0],
                        [925719.0, 6696195.0],
                        [922029.0, 6697905.0],
                        [904021.0, 6688452.0],
                        [905832.0, 6683506.0],
                        [912920.0, 6678099.0],
                        [913407.0, 6674258.0],
                        [909981.0, 6669146.0],
                        [913780.0, 6661601.0],
                        [925599.0, 6657600.0],
                        [925393.0, 6653995.0],
                        [928880.0, 6645788.0],
                        [940225.0, 6640408.0],
                        [944367.0, 6635241.0],
                        [942748.0, 6631718.0],
                        [934547.0, 6625608.0],
                        [937312.0, 6621303.0],
                        [933274.0, 6616467.0],
                        [940343.0, 6611180.0],
                        [938167.0, 6613167.0],
                        [950995.0, 6626461.0],
                        [962319.0, 6634781.0],
                        [961533.0, 6640379.0],
                        [963711.0, 6649123.0],
                        [961099.0, 6653277.0],
                        [967437.0, 6658254.0],
                        [976505.0, 6662212.0],
                        [981857.0, 6667617.0],
                        [983508.0, 6674248.0],
                        [992174.0, 6680929.0],
                        [993793.0, 6685149.0],
                        [999048.0, 6690006.0],
                        [1001635.0, 6695987.0],
                        [1006570.0, 6701646.0],
                        [1002944.0, 6704539.0],
                        [995578.0, 6702427.0],
                        [996902.0, 6711079.0],
                        [994087.0, 6717743.0],
                        [993651.0, 6723596.0],
                        [986155.0, 6724947.0],
                    ]
                ],
            },
        },
        15: {
            "attributes": {
                "CODE_DEPT": "55",
                "NOM_DEPT": "MEUSE",
                "POPULATION": 187187,
                "DENSITY": 30.03,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [904250.0, 6825381.0],
                        [904895.0, 6830283.0],
                        [900379.0, 6832469.0],
                        [903561.0, 6837915.0],
                        [902927.0, 6847494.0],
                        [899528.0, 6852809.0],
                        [904125.0, 6862116.0],
                        [901302.0, 6871865.0],
                        [905066.0, 6875501.0],
                        [906433.0, 6884047.0],
                        [905859.0, 6891045.0],
                        [901739.0, 6893315.0],
                        [900172.0, 6898682.0],
                        [901547.0, 6903348.0],
                        [898091.0, 6905220.0],
                        [898652.0, 6915853.0],
                        [895087.0, 6927281.0],
                        [891117.0, 6929633.0],
                        [883576.0, 6926040.0],
                        [878534.0, 6930925.0],
                        [879041.0, 6935896.0],
                        [875512.0, 6946935.0],
                        [873032.0, 6949057.0],
                        [867310.0, 6942452.0],
                        [856532.0, 6942619.0],
                        [853210.0, 6945817.0],
                        [849442.0, 6935263.0],
                        [853548.0, 6926776.0],
                        [847303.0, 6917040.0],
                        [849280.0, 6910207.0],
                        [842092.0, 6905887.0],
                        [841416.0, 6900107.0],
                        [845429.0, 6892400.0],
                        [846791.0, 6883540.0],
                        [848915.0, 6882413.0],
                        [848655.0, 6874905.0],
                        [841874.0, 6870868.0],
                        [838677.0, 6859119.0],
                        [846329.0, 6850924.0],
                        [846365.0, 6844539.0],
                        [847795.0, 6838972.0],
                        [852692.0, 6834838.0],
                        [856191.0, 6834907.0],
                        [863008.0, 6828766.0],
                        [873603.0, 6822775.0],
                        [882722.0, 6816263.0],
                        [893443.0, 6818701.0],
                        [904250.0, 6825381.0],
                    ]
                ],
            },
        },
        16: {
            "attributes": {
                "CODE_DEPT": "33",
                "NOM_DEPT": "GIRONDE",
                "POPULATION": 1583384,
                "DENSITY": 157.26,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [486169.0, 6410676.0],
                        [482141.0, 6421330.0],
                        [476390.0, 6418176.0],
                        [469504.0, 6418931.0],
                        [461839.0, 6422164.0],
                        [466012.0, 6428425.0],
                        [464018.0, 6432038.0],
                        [469719.0, 6445475.0],
                        [467756.0, 6450339.0],
                        [460931.0, 6449393.0],
                        [457280.0, 6451647.0],
                        [452009.0, 6448234.0],
                        [444096.0, 6451365.0],
                        [437492.0, 6457585.0],
                        [433418.0, 6457450.0],
                        [431214.0, 6470295.0],
                        [421098.0, 6472770.0],
                        [418478.0, 6475494.0],
                        [406100.0, 6476140.0],
                        [404682.0, 6481482.0],
                        [399796.0, 6489042.0],
                        [386164.0, 6505245.0],
                        [380995.0, 6504145.0],
                        [375328.0, 6494206.0],
                        [373905.0, 6475097.0],
                        [366594.0, 6427323.0],
                        [365668.0, 6410104.0],
                        [370987.0, 6417061.0],
                        [380337.0, 6407555.0],
                        [382533.0, 6402380.0],
                        [376517.0, 6401861.0],
                        [367865.0, 6404553.0],
                        [364521.0, 6395279.0],
                        [361697.0, 6391399.0],
                        [361774.0, 6383396.0],
                        [373686.0, 6386677.0],
                        [375548.0, 6389853.0],
                        [383562.0, 6383958.0],
                        [381182.0, 6379048.0],
                        [388231.0, 6379327.0],
                        [393973.0, 6376334.0],
                        [403228.0, 6378937.0],
                        [411314.0, 6378206.0],
                        [411174.0, 6373203.0],
                        [418928.0, 6369127.0],
                        [419635.0, 6366255.0],
                        [426389.0, 6364119.0],
                        [430077.0, 6359927.0],
                        [429214.0, 6351421.0],
                        [438523.0, 6349285.0],
                        [442465.0, 6350467.0],
                        [445091.0, 6357381.0],
                        [449164.0, 6352477.0],
                        [455164.0, 6354504.0],
                        [457916.0, 6359953.0],
                        [454032.0, 6364649.0],
                        [462536.0, 6370133.0],
                        [460366.0, 6373402.0],
                        [460343.0, 6383021.0],
                        [464993.0, 6388179.0],
                        [474218.0, 6394851.0],
                        [476701.0, 6399758.0],
                        [472909.0, 6402270.0],
                        [474628.0, 6407547.0],
                        [486169.0, 6410676.0],
                    ]
                ],
            },
        },
        17: {
            "attributes": {
                "CODE_DEPT": "14",
                "NOM_DEPT": "CALVADOS",
                "POPULATION": 694002,
                "DENSITY": 124.18,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [503908.0, 6928958.0],
                        [498291.0, 6928808.0],
                        [490213.0, 6925480.0],
                        [480923.0, 6917694.0],
                        [474554.0, 6915313.0],
                        [465316.0, 6913926.0],
                        [451821.0, 6920480.0],
                        [444571.0, 6921849.0],
                        [429556.0, 6922759.0],
                        [420281.0, 6924935.0],
                        [414059.0, 6928862.0],
                        [403953.0, 6928646.0],
                        [400759.0, 6925144.0],
                        [399047.0, 6920143.0],
                        [400663.0, 6914651.0],
                        [406933.0, 6907874.0],
                        [415797.0, 6907383.0],
                        [413253.0, 6901117.0],
                        [416434.0, 6899162.0],
                        [417375.0, 6892264.0],
                        [411444.0, 6881401.0],
                        [401493.0, 6871059.0],
                        [396867.0, 6868913.0],
                        [399642.0, 6861271.0],
                        [408651.0, 6861319.0],
                        [417723.0, 6857101.0],
                        [427244.0, 6861949.0],
                        [446005.0, 6869054.0],
                        [449827.0, 6868751.0],
                        [454384.0, 6863198.0],
                        [457511.0, 6867107.0],
                        [469104.0, 6863978.0],
                        [475607.0, 6865852.0],
                        [484257.0, 6870962.0],
                        [489675.0, 6876299.0],
                        [491678.0, 6873174.0],
                        [500558.0, 6877307.0],
                        [504730.0, 6874732.0],
                        [510545.0, 6875400.0],
                        [512505.0, 6881741.0],
                        [508338.0, 6886469.0],
                        [512079.0, 6895331.0],
                        [509950.0, 6897618.0],
                        [509502.0, 6910309.0],
                        [505278.0, 6914121.0],
                        [503908.0, 6928958.0],
                    ]
                ],
            },
        },
        18: {
            "attributes": {
                "CODE_DEPT": "88",
                "NOM_DEPT": "VOSGES",
                "POPULATION": 367673,
                "DENSITY": 62.41,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [915394.0, 6762341.0],
                        [919858.0, 6768473.0],
                        [924039.0, 6766004.0],
                        [929025.0, 6772821.0],
                        [935284.0, 6772098.0],
                        [936416.0, 6766072.0],
                        [941726.0, 6764118.0],
                        [951150.0, 6767749.0],
                        [956126.0, 6765947.0],
                        [959909.0, 6759629.0],
                        [964569.0, 6761737.0],
                        [968808.0, 6766577.0],
                        [972278.0, 6762245.0],
                        [982963.0, 6756697.0],
                        [986052.0, 6752778.0],
                        [987691.0, 6753958.0],
                        [993060.0, 6757264.0],
                        [991355.0, 6761730.0],
                        [993983.0, 6773739.0],
                        [998205.0, 6776671.0],
                        [1001795.0, 6789636.0],
                        [1006708.0, 6801985.0],
                        [1011125.0, 6809400.0],
                        [1005338.0, 6811635.0],
                        [1003109.0, 6819572.0],
                        [1004385.0, 6831654.0],
                        [994239.0, 6827289.0],
                        [987769.0, 6820181.0],
                        [982282.0, 6817771.0],
                        [973656.0, 6818945.0],
                        [964951.0, 6823820.0],
                        [963830.0, 6819154.0],
                        [935203.0, 6815546.0],
                        [930831.0, 6810526.0],
                        [919362.0, 6809623.0],
                        [910921.0, 6826770.0],
                        [904250.0, 6825381.0],
                        [893443.0, 6818701.0],
                        [882722.0, 6816263.0],
                        [878315.0, 6811920.0],
                        [883843.0, 6809100.0],
                        [896020.0, 6796835.0],
                        [901295.0, 6794520.0],
                        [899609.0, 6786135.0],
                        [895837.0, 6779219.0],
                        [900794.0, 6778635.0],
                        [906998.0, 6773750.0],
                        [908017.0, 6765028.0],
                        [912655.0, 6766332.0],
                        [915394.0, 6762341.0],
                    ]
                ],
            },
        },
        19: {
            "attributes": {
                "CODE_DEPT": "18",
                "NOM_DEPT": "CHER",
                "POPULATION": 304256,
                "DENSITY": 41.72,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [642856.0, 6724786.0],
                        [634456.0, 6720842.0],
                        [639501.0, 6716775.0],
                        [642622.0, 6708275.0],
                        [632231.0, 6698879.0],
                        [634922.0, 6687596.0],
                        [624165.0, 6685496.0],
                        [619951.0, 6688294.0],
                        [617060.0, 6680060.0],
                        [612147.0, 6680536.0],
                        [612309.0, 6675948.0],
                        [607114.0, 6670785.0],
                        [615265.0, 6667454.0],
                        [621646.0, 6669974.0],
                        [627833.0, 6667741.0],
                        [627981.0, 6660408.0],
                        [631131.0, 6657674.0],
                        [629301.0, 6648616.0],
                        [633457.0, 6642556.0],
                        [627496.0, 6637025.0],
                        [632500.0, 6630848.0],
                        [628673.0, 6627353.0],
                        [634340.0, 6622075.0],
                        [637665.0, 6611745.0],
                        [635550.0, 6606712.0],
                        [638969.0, 6598575.0],
                        [634893.0, 6595681.0],
                        [636090.0, 6591904.0],
                        [644784.0, 6591412.0],
                        [645179.0, 6595086.0],
                        [650317.0, 6601560.0],
                        [660370.0, 6603761.0],
                        [664479.0, 6602292.0],
                        [670500.0, 6605989.0],
                        [669145.0, 6615318.0],
                        [677474.0, 6626628.0],
                        [682775.0, 6624336.0],
                        [686837.0, 6626145.0],
                        [696943.0, 6633749.0],
                        [702446.0, 6632753.0],
                        [705186.0, 6641947.0],
                        [703828.0, 6645606.0],
                        [706033.0, 6650549.0],
                        [705753.0, 6657660.0],
                        [701762.0, 6662486.0],
                        [702129.0, 6669867.0],
                        [698614.0, 6680189.0],
                        [698745.0, 6684384.0],
                        [690449.0, 6694237.0],
                        [694642.0, 6704915.0],
                        [690565.0, 6713347.0],
                        [685430.0, 6710473.0],
                        [682544.0, 6713710.0],
                        [678869.0, 6710238.0],
                        [674282.0, 6709782.0],
                        [669909.0, 6717111.0],
                        [661757.0, 6718781.0],
                        [657729.0, 6723417.0],
                        [652875.0, 6720759.0],
                        [646396.0, 6725640.0],
                        [642856.0, 6724786.0],
                    ]
                ],
            },
        },
        20: {
            "attributes": {
                "CODE_DEPT": "07",
                "NOM_DEPT": "ARDECHE",
                "POPULATION": 325712,
                "DENSITY": 58.56,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [779411.0, 6373918.0],
                        [785084.0, 6367917.0],
                        [783861.0, 6358147.0],
                        [791158.0, 6357807.0],
                        [800494.0, 6352553.0],
                        [802764.0, 6358131.0],
                        [806518.0, 6360956.0],
                        [819866.0, 6361270.0],
                        [824346.0, 6357163.0],
                        [831641.0, 6353746.0],
                        [831614.0, 6360351.0],
                        [832713.0, 6371581.0],
                        [835151.0, 6374038.0],
                        [834538.0, 6384016.0],
                        [835764.0, 6388411.0],
                        [841041.0, 6396655.0],
                        [839715.0, 6410394.0],
                        [844069.0, 6414766.0],
                        [848816.0, 6428161.0],
                        [844782.0, 6435636.0],
                        [842390.0, 6453321.0],
                        [841110.0, 6468164.0],
                        [837457.0, 6475559.0],
                        [831517.0, 6473257.0],
                        [826509.0, 6469123.0],
                        [825694.0, 6462649.0],
                        [816370.0, 6460772.0],
                        [813436.0, 6450097.0],
                        [808187.0, 6450395.0],
                        [808165.0, 6446004.0],
                        [801638.0, 6433950.0],
                        [796332.0, 6429870.0],
                        [791307.0, 6420019.0],
                        [782106.0, 6419872.0],
                        [781273.0, 6415520.0],
                        [774103.0, 6411136.0],
                        [768276.0, 6405343.0],
                        [771844.0, 6388592.0],
                        [775042.0, 6386528.0],
                        [779411.0, 6373918.0],
                    ]
                ],
            },
        },
        21: feature_dpt_population_geometry_b,
        22: {
            "attributes": {
                "CODE_DEPT": "64",
                "NOM_DEPT": "PYRENEES-ATLANTIQUES",
                "POPULATION": 677309,
                "DENSITY": 88.06,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [334283.0, 6280551.0],
                        [327832.0, 6270658.0],
                        [324268.0, 6267623.0],
                        [314107.0, 6264613.0],
                        [316186.0, 6255555.0],
                        [321493.0, 6257288.0],
                        [325696.0, 6250142.0],
                        [329513.0, 6253905.0],
                        [334359.0, 6254169.0],
                        [344050.0, 6249226.0],
                        [343580.0, 6242296.0],
                        [340751.0, 6235590.0],
                        [335750.0, 6230517.0],
                        [338499.0, 6226346.0],
                        [344947.0, 6224142.0],
                        [346289.0, 6231519.0],
                        [352412.0, 6225527.0],
                        [355170.0, 6226484.0],
                        [373097.0, 6218255.0],
                        [377794.0, 6214129.0],
                        [388910.0, 6213290.0],
                        [393755.0, 6214784.0],
                        [395170.0, 6206882.0],
                        [409841.0, 6194695.0],
                        [412796.0, 6198151.0],
                        [418372.0, 6194685.0],
                        [422245.0, 6194862.0],
                        [428954.0, 6200122.0],
                        [428150.0, 6207547.0],
                        [431947.0, 6209367.0],
                        [431385.0, 6215423.0],
                        [437107.0, 6220297.0],
                        [440142.0, 6228799.0],
                        [443868.0, 6230545.0],
                        [446410.0, 6236240.0],
                        [454979.0, 6245934.0],
                        [452746.0, 6249402.0],
                        [457777.0, 6262698.0],
                        [451477.0, 6264635.0],
                        [454138.0, 6272903.0],
                        [449863.0, 6280833.0],
                        [443497.0, 6282643.0],
                        [438084.0, 6281592.0],
                        [433057.0, 6279053.0],
                        [424830.0, 6280287.0],
                        [421554.0, 6283529.0],
                        [412501.0, 6278002.0],
                        [403447.0, 6281078.0],
                        [399714.0, 6278404.0],
                        [394475.0, 6281218.0],
                        [385124.0, 6280151.0],
                        [377063.0, 6275535.0],
                        [367753.0, 6276986.0],
                        [362964.0, 6280741.0],
                        [352961.0, 6276001.0],
                        [342731.0, 6276517.0],
                        [338238.0, 6281381.0],
                        [334283.0, 6280551.0],
                    ]
                ],
            },
        },
        23: {
            "attributes": {
                "CODE_DEPT": "41",
                "NOM_DEPT": "LOIR-ET-CHER",
                "POPULATION": 331915,
                "DENSITY": 51.76,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [642856.0, 6724786.0],
                        [640167.0, 6731164.0],
                        [620646.0, 6731114.0],
                        [613256.0, 6732409.0],
                        [609792.0, 6727136.0],
                        [605429.0, 6729771.0],
                        [602374.0, 6738361.0],
                        [591237.0, 6742041.0],
                        [590280.0, 6747700.0],
                        [594464.0, 6753836.0],
                        [589886.0, 6759775.0],
                        [589601.0, 6765689.0],
                        [573758.0, 6762848.0],
                        [566408.0, 6764638.0],
                        [559999.0, 6772636.0],
                        [559439.0, 6777275.0],
                        [551727.0, 6777731.0],
                        [551017.0, 6782681.0],
                        [539332.0, 6780273.0],
                        [535875.0, 6773086.0],
                        [539183.0, 6762306.0],
                        [532634.0, 6757689.0],
                        [533549.0, 6751156.0],
                        [528757.0, 6745774.0],
                        [518605.0, 6737439.0],
                        [521086.0, 6735350.0],
                        [530153.0, 6735215.0],
                        [539386.0, 6732046.0],
                        [543743.0, 6727862.0],
                        [552256.0, 6724799.0],
                        [555366.0, 6719856.0],
                        [552945.0, 6716389.0],
                        [559271.0, 6706788.0],
                        [557303.0, 6702930.0],
                        [558309.0, 6696538.0],
                        [557051.0, 6690388.0],
                        [561058.0, 6687382.0],
                        [565759.0, 6689706.0],
                        [569696.0, 6685244.0],
                        [573297.0, 6677558.0],
                        [582631.0, 6683116.0],
                        [593597.0, 6687211.0],
                        [602149.0, 6685865.0],
                        [612147.0, 6680536.0],
                        [617060.0, 6680060.0],
                        [619951.0, 6688294.0],
                        [624165.0, 6685496.0],
                        [634922.0, 6687596.0],
                        [632231.0, 6698879.0],
                        [642622.0, 6708275.0],
                        [639501.0, 6716775.0],
                        [634456.0, 6720842.0],
                        [642856.0, 6724786.0],
                    ]
                ],
            },
        },
        24: {
            "attributes": {
                "CODE_DEPT": "57",
                "NOM_DEPT": "MOSELLE",
                "POPULATION": 1043522,
                "DENSITY": 166.89,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1001023.0, 6834020.0],
                        [1007603.0, 6833382.0],
                        [1013753.0, 6840510.0],
                        [1015426.0, 6846104.0],
                        [1012123.0, 6851875.0],
                        [1016765.0, 6860562.0],
                        [1004387.0, 6868517.0],
                        [1002983.0, 6863593.0],
                        [997609.0, 6864713.0],
                        [996607.0, 6871102.0],
                        [990508.0, 6874464.0],
                        [991999.0, 6880708.0],
                        [996400.0, 6888804.0],
                        [1000174.0, 6890502.0],
                        [1005257.0, 6886565.0],
                        [1014136.0, 6883372.0],
                        [1016790.0, 6880171.0],
                        [1025429.0, 6883147.0],
                        [1032318.0, 6879884.0],
                        [1035096.0, 6882767.0],
                        [1038624.0, 6893752.0],
                        [1031356.0, 6897552.0],
                        [1023578.0, 6906994.0],
                        [1018182.0, 6905695.0],
                        [1013674.0, 6899390.0],
                        [1009903.0, 6900358.0],
                        [996736.0, 6898172.0],
                        [992282.0, 6906134.0],
                        [986611.0, 6909639.0],
                        [979390.0, 6908077.0],
                        [979652.0, 6901424.0],
                        [972590.0, 6902443.0],
                        [968604.0, 6909024.0],
                        [966935.0, 6915200.0],
                        [959086.0, 6922273.0],
                        [960438.0, 6926520.0],
                        [957718.0, 6930675.0],
                        [948608.0, 6936180.0],
                        [945901.0, 6934734.0],
                        [938917.0, 6936180.0],
                        [935871.0, 6939385.0],
                        [928691.0, 6938466.0],
                        [926408.0, 6934964.0],
                        [916749.0, 6932316.0],
                        [915342.0, 6936492.0],
                        [909643.0, 6936903.0],
                        [913390.0, 6932141.0],
                        [912688.0, 6923499.0],
                        [920628.0, 6907653.0],
                        [917676.0, 6905219.0],
                        [920671.0, 6900380.0],
                        [914011.0, 6893894.0],
                        [914442.0, 6889764.0],
                        [922708.0, 6883240.0],
                        [922735.0, 6879575.0],
                        [928151.0, 6878713.0],
                        [929417.0, 6875078.0],
                        [939656.0, 6875317.0],
                        [945024.0, 6864515.0],
                        [946451.0, 6858744.0],
                        [961206.0, 6856322.0],
                        [964692.0, 6852206.0],
                        [969100.0, 6851558.0],
                        [971773.0, 6847764.0],
                        [976380.0, 6847597.0],
                        [983189.0, 6843093.0],
                        [993487.0, 6842033.0],
                        [1001023.0, 6834020.0],
                    ]
                ],
            },
        },
        25: {
            "attributes": {
                "CODE_DEPT": "86",
                "NOM_DEPT": "VIENNE",
                "POPULATION": 436876,
                "DENSITY": 62.19,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [483517.0, 6558927.0],
                        [489751.0, 6554866.0],
                        [499249.0, 6554736.0],
                        [507509.0, 6562167.0],
                        [509938.0, 6556936.0],
                        [521367.0, 6557890.0],
                        [526089.0, 6562344.0],
                        [531964.0, 6561069.0],
                        [530127.0, 6570272.0],
                        [538896.0, 6578287.0],
                        [546474.0, 6577615.0],
                        [548271.0, 6584464.0],
                        [556218.0, 6586207.0],
                        [559931.0, 6588729.0],
                        [562773.0, 6594026.0],
                        [558128.0, 6596023.0],
                        [557842.0, 6602380.0],
                        [547958.0, 6609437.0],
                        [542426.0, 6611026.0],
                        [538906.0, 6616112.0],
                        [541431.0, 6623495.0],
                        [537221.0, 6629765.0],
                        [533123.0, 6635020.0],
                        [531658.0, 6641492.0],
                        [525272.0, 6647330.0],
                        [524608.0, 6655240.0],
                        [515158.0, 6658631.0],
                        [517389.0, 6653506.0],
                        [510389.0, 6653999.0],
                        [505157.0, 6650870.0],
                        [494833.0, 6656131.0],
                        [494947.0, 6665028.0],
                        [485608.0, 6667284.0],
                        [482922.0, 6672972.0],
                        [478404.0, 6673399.0],
                        [476861.0, 6677880.0],
                        [471947.0, 6677374.0],
                        [469141.0, 6670338.0],
                        [464624.0, 6667352.0],
                        [465537.0, 6662685.0],
                        [471018.0, 6649618.0],
                        [469757.0, 6639127.0],
                        [470952.0, 6628365.0],
                        [467588.0, 6622657.0],
                        [472374.0, 6614809.0],
                        [467690.0, 6607234.0],
                        [468300.0, 6594579.0],
                        [472081.0, 6590232.0],
                        [472141.0, 6584899.0],
                        [475179.0, 6582497.0],
                        [479925.0, 6587264.0],
                        [482897.0, 6584792.0],
                        [478920.0, 6578170.0],
                        [477460.0, 6571967.0],
                        [480502.0, 6565882.0],
                        [485043.0, 6563684.0],
                        [483517.0, 6558927.0],
                    ]
                ],
            },
        },
        26: {
            "attributes": {
                "CODE_DEPT": "24",
                "NOM_DEPT": "DORDOGNE",
                "POPULATION": 413606,
                "DENSITY": 44.91,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [515635.0, 6515544.0],
                        [513233.0, 6510903.0],
                        [505177.0, 6505055.0],
                        [504657.0, 6496986.0],
                        [493466.0, 6488572.0],
                        [489646.0, 6488189.0],
                        [484697.0, 6477489.0],
                        [485798.0, 6470195.0],
                        [474561.0, 6460744.0],
                        [468806.0, 6462928.0],
                        [464807.0, 6459164.0],
                        [460931.0, 6449393.0],
                        [467756.0, 6450339.0],
                        [469719.0, 6445475.0],
                        [464018.0, 6432038.0],
                        [466012.0, 6428425.0],
                        [461839.0, 6422164.0],
                        [469504.0, 6418931.0],
                        [476390.0, 6418176.0],
                        [482141.0, 6421330.0],
                        [486169.0, 6410676.0],
                        [489091.0, 6407815.0],
                        [491196.0, 6399384.0],
                        [495031.0, 6397493.0],
                        [512334.0, 6403639.0],
                        [514373.0, 6400391.0],
                        [527849.0, 6401566.0],
                        [526858.0, 6394383.0],
                        [530971.0, 6390971.0],
                        [539761.0, 6395885.0],
                        [547193.0, 6388334.0],
                        [553597.0, 6395079.0],
                        [553113.0, 6398528.0],
                        [559319.0, 6399932.0],
                        [564402.0, 6403210.0],
                        [570668.0, 6413830.0],
                        [570522.0, 6417080.0],
                        [576964.0, 6421036.0],
                        [574976.0, 6434607.0],
                        [577774.0, 6436765.0],
                        [573095.0, 6446142.0],
                        [566113.0, 6450433.0],
                        [564865.0, 6461779.0],
                        [560988.0, 6465186.0],
                        [568750.0, 6477311.0],
                        [563844.0, 6479160.0],
                        [563452.0, 6484264.0],
                        [553144.0, 6489340.0],
                        [546900.0, 6501981.0],
                        [539039.0, 6503445.0],
                        [529342.0, 6499739.0],
                        [524801.0, 6504583.0],
                        [526849.0, 6509996.0],
                        [515635.0, 6515544.0],
                    ]
                ],
            },
        },
        27: {
            "attributes": {
                "CODE_DEPT": "39",
                "NOM_DEPT": "JURA",
                "POPULATION": 260188,
                "DENSITY": 51.62,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [877344.0, 6596683.0],
                        [877221.0, 6593352.0],
                        [882664.0, 6589574.0],
                        [882486.0, 6586333.0],
                        [887558.0, 6582363.0],
                        [890444.0, 6576892.0],
                        [895736.0, 6577631.0],
                        [903737.0, 6585593.0],
                        [908880.0, 6582354.0],
                        [909869.0, 6577050.0],
                        [919460.0, 6577537.0],
                        [923919.0, 6580132.0],
                        [929573.0, 6589336.0],
                        [935280.0, 6595262.0],
                        [935835.0, 6600587.0],
                        [941800.0, 6609883.0],
                        [940343.0, 6611180.0],
                        [933274.0, 6616467.0],
                        [937312.0, 6621303.0],
                        [934547.0, 6625608.0],
                        [942748.0, 6631718.0],
                        [944367.0, 6635241.0],
                        [940225.0, 6640408.0],
                        [928880.0, 6645788.0],
                        [925393.0, 6653995.0],
                        [925599.0, 6657600.0],
                        [913780.0, 6661601.0],
                        [909981.0, 6669146.0],
                        [913407.0, 6674258.0],
                        [912920.0, 6678099.0],
                        [905832.0, 6683506.0],
                        [904021.0, 6688452.0],
                        [896736.0, 6687711.0],
                        [890265.0, 6692353.0],
                        [888032.0, 6690633.0],
                        [887407.0, 6682465.0],
                        [884880.0, 6674426.0],
                        [881002.0, 6667371.0],
                        [876191.0, 6666228.0],
                        [875449.0, 6660099.0],
                        [871408.0, 6655745.0],
                        [872158.0, 6650880.0],
                        [876345.0, 6647462.0],
                        [887343.0, 6642371.0],
                        [880659.0, 6638936.0],
                        [882575.0, 6628163.0],
                        [886706.0, 6618161.0],
                        [880824.0, 6605207.0],
                        [885325.0, 6599852.0],
                        [877344.0, 6596683.0],
                    ]
                ],
            },
        },
        28: {
            "attributes": {
                "CODE_DEPT": "82",
                "NOM_DEPT": "TARN-ET-GARONNE",
                "POPULATION": 258349,
                "DENSITY": 69.24,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [610874.0, 6360746.0],
                        [596271.0, 6358053.0],
                        [592401.0, 6355117.0],
                        [585843.0, 6356520.0],
                        [581893.0, 6352690.0],
                        [570617.0, 6348643.0],
                        [562737.0, 6350024.0],
                        [549131.0, 6360516.0],
                        [545774.0, 6366277.0],
                        [544593.0, 6364542.0],
                        [531660.0, 6365290.0],
                        [530427.0, 6360537.0],
                        [536387.0, 6355171.0],
                        [533815.0, 6350996.0],
                        [529462.0, 6338671.0],
                        [520115.0, 6336256.0],
                        [519117.0, 6332164.0],
                        [521740.0, 6328834.0],
                        [528536.0, 6329188.0],
                        [520187.0, 6318466.0],
                        [528381.0, 6316132.0],
                        [531142.0, 6309545.0],
                        [531445.0, 6300603.0],
                        [535303.0, 6300840.0],
                        [550735.0, 6304341.0],
                        [556606.0, 6298479.0],
                        [568130.0, 6303820.0],
                        [567948.0, 6310839.0],
                        [575242.0, 6309509.0],
                        [583992.0, 6314318.0],
                        [583816.0, 6319290.0],
                        [589156.0, 6320414.0],
                        [595091.0, 6325907.0],
                        [592665.0, 6336179.0],
                        [599594.0, 6336049.0],
                        [602120.0, 6333848.0],
                        [607335.0, 6338978.0],
                        [613603.0, 6341028.0],
                        [619220.0, 6339455.0],
                        [618185.0, 6342854.0],
                        [612268.0, 6345645.0],
                        [617826.0, 6353582.0],
                        [612319.0, 6353954.0],
                        [610874.0, 6360746.0],
                    ]
                ],
            },
        },
        29: {
            "attributes": {
                "CODE_DEPT": "49",
                "NOM_DEPT": "MAINE-ET-LOIRE",
                "POPULATION": 813493,
                "DENSITY": 113.6,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [404251.0, 6660135.0],
                        [413368.0, 6662854.0],
                        [417889.0, 6660618.0],
                        [424993.0, 6661094.0],
                        [429262.0, 6663802.0],
                        [429925.0, 6668493.0],
                        [434893.0, 6670550.0],
                        [442005.0, 6668948.0],
                        [454238.0, 6672319.0],
                        [458546.0, 6672434.0],
                        [464624.0, 6667352.0],
                        [469141.0, 6670338.0],
                        [471947.0, 6677374.0],
                        [476861.0, 6677880.0],
                        [479254.0, 6691029.0],
                        [487846.0, 6706491.0],
                        [490772.0, 6714971.0],
                        [489539.0, 6719725.0],
                        [491931.0, 6726763.0],
                        [485937.0, 6723990.0],
                        [478533.0, 6727039.0],
                        [474490.0, 6731769.0],
                        [469484.0, 6733109.0],
                        [464631.0, 6730466.0],
                        [460339.0, 6732350.0],
                        [457617.0, 6739093.0],
                        [450112.0, 6740918.0],
                        [446732.0, 6745443.0],
                        [440863.0, 6746201.0],
                        [429458.0, 6743442.0],
                        [419671.0, 6744167.0],
                        [412442.0, 6746090.0],
                        [404251.0, 6751414.0],
                        [402067.0, 6747685.0],
                        [393110.0, 6750366.0],
                        [389872.0, 6749698.0],
                        [382932.0, 6754022.0],
                        [382163.0, 6750361.0],
                        [381255.0, 6745617.0],
                        [386987.0, 6740963.0],
                        [389301.0, 6732485.0],
                        [398982.0, 6728603.0],
                        [395905.0, 6725901.0],
                        [386462.0, 6727467.0],
                        [387234.0, 6720426.0],
                        [401401.0, 6717774.0],
                        [402393.0, 6705897.0],
                        [396890.0, 6703794.0],
                        [385609.0, 6704471.0],
                        [375470.0, 6701871.0],
                        [374867.0, 6698071.0],
                        [378391.0, 6691949.0],
                        [382659.0, 6691801.0],
                        [384839.0, 6683588.0],
                        [379159.0, 6679552.0],
                        [379298.0, 6676338.0],
                        [387784.0, 6670618.0],
                        [385082.0, 6667087.0],
                        [392012.0, 6664073.0],
                        [401283.0, 6663962.0],
                        [404251.0, 6660135.0],
                    ]
                ],
            },
        },
        30: {
            "attributes": {
                "CODE_DEPT": "69",
                "NOM_DEPT": "RHONE",
                "POPULATION": 1843319,
                "DENSITY": 566.63,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [863140.0, 6525920.0],
                        [849404.0, 6524528.0],
                        [844536.0, 6535588.0],
                        [833933.0, 6540287.0],
                        [835850.0, 6543054.0],
                        [834501.0, 6551198.0],
                        [835220.0, 6556428.0],
                        [838741.0, 6561678.0],
                        [837322.0, 6565642.0],
                        [833486.0, 6565745.0],
                        [830305.0, 6579430.0],
                        [824653.0, 6575157.0],
                        [815826.0, 6575242.0],
                        [808209.0, 6578315.0],
                        [806993.0, 6569822.0],
                        [810991.0, 6564128.0],
                        [802035.0, 6559678.0],
                        [798995.0, 6551156.0],
                        [801039.0, 6547667.0],
                        [800220.0, 6540120.0],
                        [802643.0, 6534285.0],
                        [807296.0, 6530310.0],
                        [808147.0, 6518212.0],
                        [806255.0, 6511913.0],
                        [809870.0, 6504594.0],
                        [818524.0, 6498224.0],
                        [825934.0, 6498617.0],
                        [829797.0, 6488843.0],
                        [834511.0, 6489782.0],
                        [837308.0, 6485557.0],
                        [845846.0, 6493277.0],
                        [841056.0, 6498593.0],
                        [848198.0, 6502534.0],
                        [858527.0, 6506228.0],
                        [865784.0, 6514252.0],
                        [862850.0, 6517700.0],
                        [863140.0, 6525920.0],
                    ]
                ],
            },
        },
        31: {
            "attributes": {
                "CODE_DEPT": "27",
                "NOM_DEPT": "EURE",
                "POPULATION": 601843,
                "DENSITY": 99.71,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [606642.0, 6924066.0],
                        [602657.0, 6922993.0],
                        [596650.0, 6927678.0],
                        [584841.0, 6929723.0],
                        [579971.0, 6928884.0],
                        [574422.0, 6917678.0],
                        [566281.0, 6917384.0],
                        [564288.0, 6913853.0],
                        [558013.0, 6912674.0],
                        [555352.0, 6907664.0],
                        [548914.0, 6917432.0],
                        [548813.0, 6922655.0],
                        [537794.0, 6926754.0],
                        [530512.0, 6925008.0],
                        [524567.0, 6928708.0],
                        [520591.0, 6933755.0],
                        [506978.0, 6930086.0],
                        [503908.0, 6928958.0],
                        [505278.0, 6914121.0],
                        [509502.0, 6910309.0],
                        [509950.0, 6897618.0],
                        [512079.0, 6895331.0],
                        [508338.0, 6886469.0],
                        [512505.0, 6881741.0],
                        [510545.0, 6875400.0],
                        [508448.0, 6870995.0],
                        [513552.0, 6867418.0],
                        [520512.0, 6866728.0],
                        [524600.0, 6861683.0],
                        [533488.0, 6856087.0],
                        [536389.0, 6850906.0],
                        [533024.0, 6847407.0],
                        [539112.0, 6843338.0],
                        [543803.0, 6848251.0],
                        [555241.0, 6849633.0],
                        [566604.0, 6854037.0],
                        [576482.0, 6852521.0],
                        [580772.0, 6855857.0],
                        [579784.0, 6860594.0],
                        [587701.0, 6866890.0],
                        [590236.0, 6872273.0],
                        [587216.0, 6881812.0],
                        [591984.0, 6886421.0],
                        [598361.0, 6887345.0],
                        [601892.0, 6893098.0],
                        [603501.0, 6902160.0],
                        [605624.0, 6904387.0],
                        [606128.0, 6907968.0],
                        [610931.0, 6911811.0],
                        [609871.0, 6919444.0],
                        [606642.0, 6924066.0],
                    ]
                ],
            },
        },
        32: {
            "attributes": {
                "CODE_DEPT": "12",
                "NOM_DEPT": "AVEYRON",
                "POPULATION": 279206,
                "DENSITY": 31.83,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [619220.0, 6339455.0],
                        [628552.0, 6344336.0],
                        [632260.0, 6344664.0],
                        [651092.0, 6332910.0],
                        [652742.0, 6328715.0],
                        [656723.0, 6328192.0],
                        [661724.0, 6320369.0],
                        [659810.0, 6316970.0],
                        [664259.0, 6313698.0],
                        [664946.0, 6304799.0],
                        [674324.0, 6293934.0],
                        [679276.0, 6292258.0],
                        [684993.0, 6295873.0],
                        [693643.0, 6293013.0],
                        [694796.0, 6288406.0],
                        [698819.0, 6289943.0],
                        [704898.0, 6288229.0],
                        [704815.0, 6303628.0],
                        [716344.0, 6301672.0],
                        [722102.0, 6311077.0],
                        [728786.0, 6312824.0],
                        [736140.0, 6324746.0],
                        [726344.0, 6331169.0],
                        [726879.0, 6340020.0],
                        [729879.0, 6341376.0],
                        [728598.0, 6344387.0],
                        [718362.0, 6347498.0],
                        [709994.0, 6353946.0],
                        [712305.0, 6356606.0],
                        [709537.0, 6364934.0],
                        [710800.0, 6372878.0],
                        [705449.0, 6378272.0],
                        [706639.0, 6384441.0],
                        [698547.0, 6393953.0],
                        [693924.0, 6403282.0],
                        [694820.0, 6408897.0],
                        [690477.0, 6411547.0],
                        [688126.0, 6419157.0],
                        [684359.0, 6419403.0],
                        [679353.0, 6426925.0],
                        [676829.0, 6423158.0],
                        [668604.0, 6416079.0],
                        [668313.0, 6410487.0],
                        [665404.0, 6408608.0],
                        [664849.0, 6402561.0],
                        [655192.0, 6393469.0],
                        [646639.0, 6396959.0],
                        [637228.0, 6394175.0],
                        [637122.0, 6391031.0],
                        [632813.0, 6386229.0],
                        [625170.0, 6387538.0],
                        [615061.0, 6379167.0],
                        [607709.0, 6375883.0],
                        [610874.0, 6360746.0],
                        [612319.0, 6353954.0],
                        [617826.0, 6353582.0],
                        [612268.0, 6345645.0],
                        [618185.0, 6342854.0],
                        [619220.0, 6339455.0],
                    ]
                ],
            },
        },
        33: {
            "attributes": {
                "CODE_DEPT": "23",
                "NOM_DEPT": "CREUSE",
                "POPULATION": 118638,
                "DENSITY": 21.23,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [636090.0, 6591904.0],
                        [630016.0, 6590287.0],
                        [622684.0, 6592821.0],
                        [609355.0, 6592908.0],
                        [602234.0, 6588456.0],
                        [595863.0, 6588324.0],
                        [586530.0, 6592902.0],
                        [578129.0, 6584256.0],
                        [580236.0, 6579624.0],
                        [574730.0, 6569689.0],
                        [580656.0, 6565605.0],
                        [587795.0, 6549437.0],
                        [586335.0, 6540289.0],
                        [592200.0, 6538029.0],
                        [591561.0, 6529605.0],
                        [597279.0, 6527024.0],
                        [604752.0, 6527760.0],
                        [613074.0, 6522626.0],
                        [612524.0, 6515422.0],
                        [614305.0, 6511565.0],
                        [623634.0, 6517796.0],
                        [631053.0, 6514297.0],
                        [635791.0, 6515072.0],
                        [637278.0, 6511373.0],
                        [648450.0, 6509221.0],
                        [649366.0, 6512420.0],
                        [656101.0, 6511235.0],
                        [660507.0, 6515469.0],
                        [656022.0, 6519074.0],
                        [652489.0, 6525488.0],
                        [656753.0, 6529414.0],
                        [660605.0, 6529501.0],
                        [668605.0, 6543382.0],
                        [665172.0, 6557241.0],
                        [666451.0, 6560450.0],
                        [662729.0, 6571178.0],
                        [659880.0, 6575828.0],
                        [653217.0, 6581299.0],
                        [647921.0, 6581264.0],
                        [644784.0, 6591412.0],
                        [636090.0, 6591904.0],
                    ]
                ],
            },
        },
        34: {
            "attributes": {
                "CODE_DEPT": "45",
                "NOM_DEPT": "LOIRET",
                "POPULATION": 678008,
                "DENSITY": 99.65,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [695265.0, 6784783.0],
                        [685053.0, 6785343.0],
                        [678166.0, 6780535.0],
                        [665644.0, 6782354.0],
                        [663338.0, 6793247.0],
                        [657236.0, 6795707.0],
                        [655721.0, 6802434.0],
                        [653275.0, 6801114.0],
                        [639308.0, 6801806.0],
                        [625387.0, 6798948.0],
                        [623220.0, 6795517.0],
                        [615539.0, 6776549.0],
                        [606511.0, 6774717.0],
                        [597558.0, 6774986.0],
                        [595216.0, 6770968.0],
                        [589165.0, 6770859.0],
                        [589601.0, 6765689.0],
                        [589886.0, 6759775.0],
                        [594464.0, 6753836.0],
                        [590280.0, 6747700.0],
                        [591237.0, 6742041.0],
                        [602374.0, 6738361.0],
                        [605429.0, 6729771.0],
                        [609792.0, 6727136.0],
                        [613256.0, 6732409.0],
                        [620646.0, 6731114.0],
                        [640167.0, 6731164.0],
                        [642856.0, 6724786.0],
                        [646396.0, 6725640.0],
                        [652875.0, 6720759.0],
                        [657729.0, 6723417.0],
                        [661757.0, 6718781.0],
                        [669909.0, 6717111.0],
                        [674282.0, 6709782.0],
                        [678869.0, 6710238.0],
                        [682544.0, 6713710.0],
                        [685430.0, 6710473.0],
                        [690565.0, 6713347.0],
                        [693556.0, 6718403.0],
                        [698236.0, 6718784.0],
                        [695341.0, 6722058.0],
                        [694231.0, 6731133.0],
                        [689391.0, 6734632.0],
                        [689262.0, 6740069.0],
                        [695135.0, 6740319.0],
                        [701782.0, 6742907.0],
                        [700769.0, 6756036.0],
                        [703743.0, 6756785.0],
                        [709585.0, 6763406.0],
                        [706580.0, 6772621.0],
                        [703759.0, 6774663.0],
                        [702192.0, 6781427.0],
                        [695265.0, 6784783.0],
                    ]
                ],
            },
        },
        35: {
            "attributes": {
                "CODE_DEPT": "70",
                "NOM_DEPT": "HAUTE-SAONE",
                "POPULATION": 236659,
                "DENSITY": 43.97,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [986052.0, 6752778.0],
                        [982963.0, 6756697.0],
                        [972278.0, 6762245.0],
                        [968808.0, 6766577.0],
                        [964569.0, 6761737.0],
                        [959909.0, 6759629.0],
                        [956126.0, 6765947.0],
                        [951150.0, 6767749.0],
                        [941726.0, 6764118.0],
                        [936416.0, 6766072.0],
                        [935284.0, 6772098.0],
                        [929025.0, 6772821.0],
                        [924039.0, 6766004.0],
                        [919858.0, 6768473.0],
                        [915394.0, 6762341.0],
                        [910900.0, 6755744.0],
                        [906433.0, 6754603.0],
                        [901288.0, 6749897.0],
                        [900414.0, 6745482.0],
                        [902985.0, 6741752.0],
                        [901778.0, 6735043.0],
                        [894824.0, 6733348.0],
                        [886220.0, 6734507.0],
                        [880542.0, 6733086.0],
                        [878352.0, 6725366.0],
                        [882147.0, 6728546.0],
                        [886108.0, 6726069.0],
                        [887785.0, 6718944.0],
                        [884206.0, 6713509.0],
                        [880595.0, 6713705.0],
                        [884919.0, 6701062.0],
                        [890265.0, 6692353.0],
                        [896736.0, 6687711.0],
                        [904021.0, 6688452.0],
                        [922029.0, 6697905.0],
                        [925719.0, 6696195.0],
                        [932449.0, 6699390.0],
                        [945847.0, 6708437.0],
                        [950918.0, 6717032.0],
                        [955890.0, 6718838.0],
                        [967469.0, 6716290.0],
                        [969354.0, 6721610.0],
                        [974258.0, 6721322.0],
                        [977033.0, 6724531.0],
                        [984341.0, 6721925.0],
                        [986155.0, 6724947.0],
                        [983826.0, 6731782.0],
                        [981470.0, 6745308.0],
                        [986052.0, 6752778.0],
                    ]
                ],
            },
        },
        36: {
            "attributes": {
                "CODE_DEPT": "63",
                "NOM_DEPT": "PUY-DE-DOME",
                "POPULATION": 653742,
                "DENSITY": 81.69,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [753779.0, 6537018.0],
                        [745523.0, 6547324.0],
                        [735860.0, 6546571.0],
                        [732386.0, 6552810.0],
                        [728730.0, 6550656.0],
                        [712873.0, 6551781.0],
                        [697819.0, 6557998.0],
                        [693029.0, 6567076.0],
                        [695157.0, 6571452.0],
                        [688886.0, 6572856.0],
                        [685369.0, 6566281.0],
                        [679424.0, 6569309.0],
                        [672252.0, 6557694.0],
                        [666451.0, 6560450.0],
                        [665172.0, 6557241.0],
                        [668605.0, 6543382.0],
                        [660605.0, 6529501.0],
                        [656753.0, 6529414.0],
                        [652489.0, 6525488.0],
                        [656022.0, 6519074.0],
                        [660507.0, 6515469.0],
                        [663288.0, 6509261.0],
                        [662164.0, 6504560.0],
                        [658322.0, 6500286.0],
                        [662264.0, 6494997.0],
                        [661594.0, 6486680.0],
                        [672750.0, 6482640.0],
                        [677684.0, 6475835.0],
                        [688449.0, 6477003.0],
                        [693859.0, 6474045.0],
                        [695974.0, 6467752.0],
                        [701310.0, 6465307.0],
                        [708104.0, 6472781.0],
                        [713160.0, 6472555.0],
                        [722742.0, 6478087.0],
                        [735734.0, 6477978.0],
                        [739202.0, 6481030.0],
                        [749018.0, 6471190.0],
                        [752222.0, 6475420.0],
                        [760473.0, 6472496.0],
                        [763248.0, 6477235.0],
                        [770263.0, 6473476.0],
                        [770335.0, 6479388.0],
                        [776221.0, 6483674.0],
                        [774454.0, 6495613.0],
                        [770440.0, 6500348.0],
                        [764154.0, 6503988.0],
                        [760734.0, 6514163.0],
                        [754369.0, 6520637.0],
                        [758503.0, 6532097.0],
                        [753779.0, 6537018.0],
                    ]
                ],
            },
        },
        37: {
            "attributes": {
                "CODE_DEPT": "81",
                "NOM_DEPT": "TARN",
                "POPULATION": 387890,
                "DENSITY": 67.04,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [583992.0, 6314318.0],
                        [583878.0, 6308763.0],
                        [586632.0, 6302842.0],
                        [590928.0, 6301074.0],
                        [592076.0, 6294561.0],
                        [595737.0, 6291653.0],
                        [597601.0, 6285124.0],
                        [594074.0, 6282175.0],
                        [605052.0, 6276459.0],
                        [609628.0, 6269734.0],
                        [620519.0, 6263967.0],
                        [621363.0, 6260238.0],
                        [624846.0, 6255615.0],
                        [637154.0, 6259493.0],
                        [640013.0, 6262596.0],
                        [651680.0, 6257911.0],
                        [654081.0, 6259728.0],
                        [664821.0, 6258302.0],
                        [668090.0, 6259189.0],
                        [672444.0, 6264623.0],
                        [672394.0, 6269695.0],
                        [668935.0, 6274250.0],
                        [671212.0, 6283521.0],
                        [676690.0, 6282993.0],
                        [680178.0, 6279485.0],
                        [693221.0, 6284557.0],
                        [694796.0, 6288406.0],
                        [693643.0, 6293013.0],
                        [684993.0, 6295873.0],
                        [679276.0, 6292258.0],
                        [674324.0, 6293934.0],
                        [664946.0, 6304799.0],
                        [664259.0, 6313698.0],
                        [659810.0, 6316970.0],
                        [661724.0, 6320369.0],
                        [656723.0, 6328192.0],
                        [652742.0, 6328715.0],
                        [651092.0, 6332910.0],
                        [632260.0, 6344664.0],
                        [628552.0, 6344336.0],
                        [619220.0, 6339455.0],
                        [613603.0, 6341028.0],
                        [607335.0, 6338978.0],
                        [602120.0, 6333848.0],
                        [599594.0, 6336049.0],
                        [592665.0, 6336179.0],
                        [595091.0, 6325907.0],
                        [589156.0, 6320414.0],
                        [583816.0, 6319290.0],
                        [583992.0, 6314318.0],
                    ]
                ],
            },
        },
        38: {
            "attributes": {
                "CODE_DEPT": "76",
                "NOM_DEPT": "SEINE-MARITIME",
                "POPULATION": 1254378,
                "DENSITY": 198.53,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [612314.0, 6962826.0],
                        [608347.0, 6970745.0],
                        [605014.0, 6980736.0],
                        [589321.0, 6994349.0],
                        [583880.0, 6997485.0],
                        [570354.0, 6986979.0],
                        [561015.0, 6982476.0],
                        [553619.0, 6982021.0],
                        [539569.0, 6977082.0],
                        [525341.0, 6975010.0],
                        [506777.0, 6963564.0],
                        [498821.0, 6960824.0],
                        [494437.0, 6953650.0],
                        [487453.0, 6938754.0],
                        [491281.0, 6933115.0],
                        [506978.0, 6930086.0],
                        [520591.0, 6933755.0],
                        [524567.0, 6928708.0],
                        [530512.0, 6925008.0],
                        [537794.0, 6926754.0],
                        [548813.0, 6922655.0],
                        [548914.0, 6917432.0],
                        [555352.0, 6907664.0],
                        [558013.0, 6912674.0],
                        [564288.0, 6913853.0],
                        [566281.0, 6917384.0],
                        [574422.0, 6917678.0],
                        [579971.0, 6928884.0],
                        [584841.0, 6929723.0],
                        [596650.0, 6927678.0],
                        [602657.0, 6922993.0],
                        [606642.0, 6924066.0],
                        [610545.0, 6930338.0],
                        [607205.0, 6935073.0],
                        [609123.0, 6937659.0],
                        [606321.0, 6945902.0],
                        [607933.0, 6953359.0],
                        [605401.0, 6955866.0],
                        [612314.0, 6962826.0],
                    ]
                ],
            },
        },
        39: {
            "attributes": {
                "CODE_DEPT": "52",
                "NOM_DEPT": "HAUTE-MARNE",
                "POPULATION": 175640,
                "DENSITY": 28.1,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [823302.0, 6827043.0],
                        [822210.0, 6820200.0],
                        [827022.0, 6811887.0],
                        [834073.0, 6806764.0],
                        [837935.0, 6797546.0],
                        [837598.0, 6783989.0],
                        [835407.0, 6779651.0],
                        [828770.0, 6781171.0],
                        [825768.0, 6776095.0],
                        [827043.0, 6770243.0],
                        [833398.0, 6769005.0],
                        [833316.0, 6764154.0],
                        [838226.0, 6763382.0],
                        [846087.0, 6753627.0],
                        [848388.0, 6746302.0],
                        [846031.0, 6742315.0],
                        [848455.0, 6733791.0],
                        [858300.0, 6729814.0],
                        [863148.0, 6730266.0],
                        [868188.0, 6726357.0],
                        [878352.0, 6725366.0],
                        [880542.0, 6733086.0],
                        [886220.0, 6734507.0],
                        [894824.0, 6733348.0],
                        [901778.0, 6735043.0],
                        [902985.0, 6741752.0],
                        [900414.0, 6745482.0],
                        [901288.0, 6749897.0],
                        [906433.0, 6754603.0],
                        [910900.0, 6755744.0],
                        [915394.0, 6762341.0],
                        [912655.0, 6766332.0],
                        [908017.0, 6765028.0],
                        [906998.0, 6773750.0],
                        [900794.0, 6778635.0],
                        [895837.0, 6779219.0],
                        [899609.0, 6786135.0],
                        [901295.0, 6794520.0],
                        [896020.0, 6796835.0],
                        [883843.0, 6809100.0],
                        [878315.0, 6811920.0],
                        [882722.0, 6816263.0],
                        [873603.0, 6822775.0],
                        [863008.0, 6828766.0],
                        [856191.0, 6834907.0],
                        [852692.0, 6834838.0],
                        [847795.0, 6838972.0],
                        [846365.0, 6844539.0],
                        [840675.0, 6844876.0],
                        [835676.0, 6840415.0],
                        [836281.0, 6837534.0],
                        [830469.0, 6833515.0],
                        [832829.0, 6827018.0],
                        [823302.0, 6827043.0],
                    ]
                ],
            },
        },
        40: {
            "attributes": {
                "CODE_DEPT": "30",
                "NOM_DEPT": "GARD",
                "POPULATION": 744178,
                "DENSITY": 126.67,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [831641.0, 6353746.0],
                        [824346.0, 6357163.0],
                        [819866.0, 6361270.0],
                        [806518.0, 6360956.0],
                        [802764.0, 6358131.0],
                        [800494.0, 6352553.0],
                        [791158.0, 6357807.0],
                        [783861.0, 6358147.0],
                        [785084.0, 6367917.0],
                        [779411.0, 6373918.0],
                        [775211.0, 6367175.0],
                        [770571.0, 6365836.0],
                        [775941.0, 6359276.0],
                        [773621.0, 6356674.0],
                        [775968.0, 6350322.0],
                        [776174.0, 6341769.0],
                        [768987.0, 6337162.0],
                        [763780.0, 6336809.0],
                        [754256.0, 6342872.0],
                        [750995.0, 6342037.0],
                        [750700.0, 6336169.0],
                        [735189.0, 6336775.0],
                        [729879.0, 6341376.0],
                        [726879.0, 6340020.0],
                        [726344.0, 6331169.0],
                        [736140.0, 6324746.0],
                        [728786.0, 6312824.0],
                        [734096.0, 6312602.0],
                        [742673.0, 6306434.0],
                        [746263.0, 6307559.0],
                        [750088.0, 6313306.0],
                        [758340.0, 6319159.0],
                        [763184.0, 6318967.0],
                        [766255.0, 6313712.0],
                        [766790.0, 6307842.0],
                        [773726.0, 6310049.0],
                        [780634.0, 6301895.0],
                        [792244.0, 6293431.0],
                        [796379.0, 6284647.0],
                        [792922.0, 6276955.0],
                        [788998.0, 6273432.0],
                        [792112.0, 6270978.0],
                        [792074.0, 6265425.0],
                        [799607.0, 6263119.0],
                        [800175.0, 6267290.0],
                        [813903.0, 6274579.0],
                        [815212.0, 6281222.0],
                        [819908.0, 6290041.0],
                        [828463.0, 6288899.0],
                        [833168.0, 6302217.0],
                        [831988.0, 6308980.0],
                        [839658.0, 6315433.0],
                        [847769.0, 6322554.0],
                        [843231.0, 6331183.0],
                        [836689.0, 6335330.0],
                        [837656.0, 6344658.0],
                        [831641.0, 6353746.0],
                    ]
                ],
            },
        },
        41: {
            "attributes": {
                "CODE_DEPT": "67",
                "NOM_DEPT": "BAS-RHIN",
                "POPULATION": 1125559,
                "DENSITY": 234.67,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1011125.0, 6809400.0],
                        [1016850.0, 6809125.0],
                        [1022638.0, 6802981.0],
                        [1032428.0, 6798669.0],
                        [1032222.0, 6793924.0],
                        [1036067.0, 6790258.0],
                        [1040408.0, 6789869.0],
                        [1046450.0, 6801750.0],
                        [1048508.0, 6811325.0],
                        [1051141.0, 6812923.0],
                        [1050303.0, 6822049.0],
                        [1052109.0, 6831679.0],
                        [1054677.0, 6834498.0],
                        [1054069.0, 6843233.0],
                        [1056359.0, 6848835.0],
                        [1064869.0, 6858273.0],
                        [1065247.0, 6862338.0],
                        [1074008.0, 6868775.0],
                        [1077114.0, 6879387.0],
                        [1081448.0, 6887616.0],
                        [1072364.0, 6888601.0],
                        [1060439.0, 6895482.0],
                        [1055798.0, 6892558.0],
                        [1050607.0, 6895578.0],
                        [1045763.0, 6893084.0],
                        [1038624.0, 6893752.0],
                        [1035096.0, 6882767.0],
                        [1032318.0, 6879884.0],
                        [1025429.0, 6883147.0],
                        [1016790.0, 6880171.0],
                        [1014136.0, 6883372.0],
                        [1005257.0, 6886565.0],
                        [1000174.0, 6890502.0],
                        [996400.0, 6888804.0],
                        [991999.0, 6880708.0],
                        [990508.0, 6874464.0],
                        [996607.0, 6871102.0],
                        [997609.0, 6864713.0],
                        [1002983.0, 6863593.0],
                        [1004387.0, 6868517.0],
                        [1016765.0, 6860562.0],
                        [1012123.0, 6851875.0],
                        [1015426.0, 6846104.0],
                        [1013753.0, 6840510.0],
                        [1007603.0, 6833382.0],
                        [1001023.0, 6834020.0],
                        [1004385.0, 6831654.0],
                        [1003109.0, 6819572.0],
                        [1005338.0, 6811635.0],
                        [1011125.0, 6809400.0],
                    ]
                ],
            },
        },
        42: {
            "attributes": {
                "CODE_DEPT": "11",
                "NOM_DEPT": "AUDE",
                "POPULATION": 370260,
                "DENSITY": 58.3,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [719561.0, 6234874.0],
                        [716336.0, 6238907.0],
                        [711963.0, 6238657.0],
                        [700385.0, 6243263.0],
                        [700353.0, 6246775.0],
                        [686427.0, 6247043.0],
                        [681495.0, 6239871.0],
                        [667653.0, 6244475.0],
                        [662679.0, 6249784.0],
                        [664821.0, 6258302.0],
                        [654081.0, 6259728.0],
                        [651680.0, 6257911.0],
                        [640013.0, 6262596.0],
                        [637154.0, 6259493.0],
                        [624846.0, 6255615.0],
                        [621363.0, 6260238.0],
                        [611672.0, 6256714.0],
                        [607574.0, 6261192.0],
                        [603060.0, 6255463.0],
                        [603733.0, 6249863.0],
                        [598408.0, 6250205.0],
                        [593467.0, 6242482.0],
                        [596256.0, 6236985.0],
                        [595072.0, 6233132.0],
                        [604330.0, 6228108.0],
                        [614442.0, 6225039.0],
                        [613663.0, 6217624.0],
                        [617210.0, 6214637.0],
                        [617137.0, 6197372.0],
                        [608402.0, 6195450.0],
                        [610538.0, 6185966.0],
                        [614361.0, 6182470.0],
                        [622733.0, 6184536.0],
                        [632373.0, 6176261.0],
                        [631545.0, 6174170.0],
                        [644388.0, 6178927.0],
                        [647326.0, 6181831.0],
                        [644930.0, 6193342.0],
                        [655189.0, 6193206.0],
                        [659825.0, 6194610.0],
                        [675246.0, 6192375.0],
                        [678721.0, 6193157.0],
                        [682753.0, 6199641.0],
                        [688989.0, 6202113.0],
                        [693222.0, 6198384.0],
                        [703560.0, 6193187.0],
                        [704952.0, 6201963.0],
                        [703499.0, 6206754.0],
                        [709550.0, 6222514.0],
                        [719561.0, 6234874.0],
                    ]
                ],
            },
        },
        43: {
            "attributes": {
                "CODE_DEPT": "77",
                "NOM_DEPT": "SEINE-ET-MARNE",
                "POPULATION": 1403997,
                "DENSITY": 236.98,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [695265.0, 6784783.0],
                        [700383.0, 6789702.0],
                        [703237.0, 6796855.0],
                        [703668.0, 6806647.0],
                        [712422.0, 6807964.0],
                        [727042.0, 6808060.0],
                        [730707.0, 6810078.0],
                        [728998.0, 6813854.0],
                        [731262.0, 6826009.0],
                        [737148.0, 6833964.0],
                        [740952.0, 6835710.0],
                        [733915.0, 6839303.0],
                        [735102.0, 6844463.0],
                        [732040.0, 6850473.0],
                        [735603.0, 6861428.0],
                        [729581.0, 6862815.0],
                        [724211.0, 6867685.0],
                        [722321.0, 6872132.0],
                        [712559.0, 6879371.0],
                        [712067.0, 6888882.0],
                        [705248.0, 6890863.0],
                        [700622.0, 6887964.0],
                        [680633.0, 6884542.0],
                        [673222.0, 6889902.0],
                        [670084.0, 6886723.0],
                        [667303.0, 6878971.0],
                        [670882.0, 6870004.0],
                        [667928.0, 6865519.0],
                        [670056.0, 6856451.0],
                        [671600.0, 6851283.0],
                        [668472.0, 6843626.0],
                        [665649.0, 6839786.0],
                        [666363.0, 6833836.0],
                        [663045.0, 6825117.0],
                        [663371.0, 6815578.0],
                        [665496.0, 6812431.0],
                        [657768.0, 6807009.0],
                        [655721.0, 6802434.0],
                        [657236.0, 6795707.0],
                        [663338.0, 6793247.0],
                        [665644.0, 6782354.0],
                        [678166.0, 6780535.0],
                        [685053.0, 6785343.0],
                        [695265.0, 6784783.0],
                    ]
                ],
            },
        },
        44: {
            "attributes": {
                "CODE_DEPT": "80",
                "NOM_DEPT": "SOMME",
                "POPULATION": 572443,
                "DENSITY": 92.23,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [706470.0, 6995042.0],
                        [691147.0, 6993758.0],
                        [689814.0, 6997681.0],
                        [669642.0, 7001764.0],
                        [667892.0, 7004913.0],
                        [662547.0, 7004433.0],
                        [658067.0, 7000416.0],
                        [656343.0, 7006536.0],
                        [663948.0, 7010834.0],
                        [660837.0, 7014835.0],
                        [654991.0, 7012592.0],
                        [648121.0, 7014552.0],
                        [635372.0, 7012312.0],
                        [634147.0, 7017146.0],
                        [624801.0, 7021563.0],
                        [622831.0, 7024302.0],
                        [612989.0, 7030025.0],
                        [605232.0, 7026713.0],
                        [603193.0, 7029103.0],
                        [596733.0, 7029014.0],
                        [595668.0, 7021497.0],
                        [599348.0, 7018454.0],
                        [591189.0, 7008466.0],
                        [589294.0, 7002423.0],
                        [583880.0, 6997485.0],
                        [589321.0, 6994349.0],
                        [605014.0, 6980736.0],
                        [608347.0, 6970745.0],
                        [612314.0, 6962826.0],
                        [620154.0, 6956108.0],
                        [623025.0, 6958366.0],
                        [636565.0, 6954687.0],
                        [645659.0, 6956103.0],
                        [654712.0, 6950974.0],
                        [664208.0, 6949037.0],
                        [669006.0, 6944292.0],
                        [676176.0, 6942514.0],
                        [677528.0, 6947426.0],
                        [685504.0, 6946842.0],
                        [685089.0, 6950779.0],
                        [693916.0, 6955962.0],
                        [708546.0, 6956332.0],
                        [705667.0, 6969289.0],
                        [708480.0, 6979518.0],
                        [713833.0, 6986563.0],
                        [712391.0, 6990404.0],
                        [706470.0, 6995042.0],
                    ]
                ],
            },
        },
        45: {
            "attributes": {
                "CODE_DEPT": "43",
                "NOM_DEPT": "HAUTE-LOIRE",
                "POPULATION": 227283,
                "DENSITY": 45.49,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [708104.0, 6472781.0],
                        [709251.0, 6464988.0],
                        [717445.0, 6463649.0],
                        [722648.0, 6446835.0],
                        [725628.0, 6444038.0],
                        [723408.0, 6437470.0],
                        [727352.0, 6435060.0],
                        [728488.0, 6430309.0],
                        [732563.0, 6427378.0],
                        [732994.0, 6422485.0],
                        [737614.0, 6413026.0],
                        [746579.0, 6414955.0],
                        [746937.0, 6419760.0],
                        [752090.0, 6419191.0],
                        [752669.0, 6414624.0],
                        [758530.0, 6415778.0],
                        [768276.0, 6405343.0],
                        [774103.0, 6411136.0],
                        [781273.0, 6415520.0],
                        [782106.0, 6419872.0],
                        [791307.0, 6420019.0],
                        [796332.0, 6429870.0],
                        [801638.0, 6433950.0],
                        [808165.0, 6446004.0],
                        [808187.0, 6450395.0],
                        [813436.0, 6450097.0],
                        [816370.0, 6460772.0],
                        [811227.0, 6465007.0],
                        [806856.0, 6463705.0],
                        [807029.0, 6471772.0],
                        [802398.0, 6475469.0],
                        [792166.0, 6477709.0],
                        [780259.0, 6472021.0],
                        [776677.0, 6475557.0],
                        [770263.0, 6473476.0],
                        [763248.0, 6477235.0],
                        [760473.0, 6472496.0],
                        [752222.0, 6475420.0],
                        [749018.0, 6471190.0],
                        [739202.0, 6481030.0],
                        [735734.0, 6477978.0],
                        [722742.0, 6478087.0],
                        [713160.0, 6472555.0],
                        [708104.0, 6472781.0],
                    ]
                ],
            },
        },
        46: {
            "attributes": {
                "CODE_DEPT": "51",
                "NOM_DEPT": "MARNE",
                "POPULATION": 568895,
                "DENSITY": 69.41,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [776081.0, 6923412.0],
                        [775242.0, 6918312.0],
                        [767112.0, 6923360.0],
                        [761575.0, 6918670.0],
                        [747051.0, 6913033.0],
                        [751361.0, 6898188.0],
                        [745398.0, 6894771.0],
                        [743801.0, 6891376.0],
                        [747254.0, 6882494.0],
                        [744067.0, 6871735.0],
                        [738742.0, 6868146.0],
                        [735603.0, 6861428.0],
                        [732040.0, 6850473.0],
                        [735102.0, 6844463.0],
                        [733915.0, 6839303.0],
                        [740952.0, 6835710.0],
                        [746802.0, 6826973.0],
                        [753955.0, 6826609.0],
                        [760761.0, 6824301.0],
                        [769985.0, 6834113.0],
                        [773768.0, 6840880.0],
                        [779497.0, 6845091.0],
                        [785824.0, 6845891.0],
                        [797551.0, 6845278.0],
                        [796995.0, 6835851.0],
                        [803526.0, 6829924.0],
                        [814106.0, 6826118.0],
                        [819107.0, 6829393.0],
                        [823302.0, 6827043.0],
                        [832829.0, 6827018.0],
                        [830469.0, 6833515.0],
                        [836281.0, 6837534.0],
                        [835676.0, 6840415.0],
                        [840675.0, 6844876.0],
                        [846365.0, 6844539.0],
                        [846329.0, 6850924.0],
                        [838677.0, 6859119.0],
                        [841874.0, 6870868.0],
                        [848655.0, 6874905.0],
                        [848915.0, 6882413.0],
                        [846791.0, 6883540.0],
                        [845429.0, 6892400.0],
                        [841416.0, 6900107.0],
                        [842092.0, 6905887.0],
                        [837898.0, 6908256.0],
                        [833062.0, 6905548.0],
                        [822754.0, 6907655.0],
                        [818364.0, 6905215.0],
                        [814643.0, 6911926.0],
                        [803525.0, 6909934.0],
                        [795010.0, 6915033.0],
                        [790665.0, 6921022.0],
                        [782994.0, 6923346.0],
                        [776081.0, 6923412.0],
                    ]
                ],
            },
        },
        47: {
            "attributes": {
                "CODE_DEPT": "65",
                "NOM_DEPT": "HAUTES-PYRENEES",
                "POPULATION": 228530,
                "DENSITY": 50.47,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [428954.0, 6200122.0],
                        [442286.0, 6190571.0],
                        [445343.0, 6185147.0],
                        [453012.0, 6180794.0],
                        [468501.0, 6186020.0],
                        [475317.0, 6183479.0],
                        [477861.0, 6178841.0],
                        [483521.0, 6184043.0],
                        [489111.0, 6180226.0],
                        [493119.0, 6181125.0],
                        [491362.0, 6184305.0],
                        [492032.0, 6195420.0],
                        [493715.0, 6200925.0],
                        [501753.0, 6199863.0],
                        [506394.0, 6214104.0],
                        [501199.0, 6216194.0],
                        [498958.0, 6224762.0],
                        [491741.0, 6229153.0],
                        [500952.0, 6237523.0],
                        [501020.0, 6240519.0],
                        [506455.0, 6246240.0],
                        [505760.0, 6248691.0],
                        [496988.0, 6250664.0],
                        [479309.0, 6257879.0],
                        [471536.0, 6256527.0],
                        [468215.0, 6263513.0],
                        [466465.0, 6272970.0],
                        [461941.0, 6273297.0],
                        [457450.0, 6278664.0],
                        [456497.0, 6283051.0],
                        [449863.0, 6280833.0],
                        [454138.0, 6272903.0],
                        [451477.0, 6264635.0],
                        [457777.0, 6262698.0],
                        [452746.0, 6249402.0],
                        [454979.0, 6245934.0],
                        [446410.0, 6236240.0],
                        [443868.0, 6230545.0],
                        [440142.0, 6228799.0],
                        [437107.0, 6220297.0],
                        [431385.0, 6215423.0],
                        [431947.0, 6209367.0],
                        [428150.0, 6207547.0],
                        [428954.0, 6200122.0],
                    ]
                ],
            },
        },
        48: {
            "attributes": {
                "CODE_DEPT": "46",
                "NOM_DEPT": "LOT",
                "POPULATION": 173828,
                "DENSITY": 33.29,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [547193.0, 6388334.0],
                        [542159.0, 6383881.0],
                        [541673.0, 6377661.0],
                        [545774.0, 6366277.0],
                        [549131.0, 6360516.0],
                        [562737.0, 6350024.0],
                        [570617.0, 6348643.0],
                        [581893.0, 6352690.0],
                        [585843.0, 6356520.0],
                        [592401.0, 6355117.0],
                        [596271.0, 6358053.0],
                        [610874.0, 6360746.0],
                        [607709.0, 6375883.0],
                        [615061.0, 6379167.0],
                        [625170.0, 6387538.0],
                        [632813.0, 6386229.0],
                        [637122.0, 6391031.0],
                        [634129.0, 6393565.0],
                        [633003.0, 6406356.0],
                        [634482.0, 6410441.0],
                        [628463.0, 6419614.0],
                        [626129.0, 6431248.0],
                        [613933.0, 6431618.0],
                        [607209.0, 6426078.0],
                        [601475.0, 6429196.0],
                        [593751.0, 6437105.0],
                        [584718.0, 6439628.0],
                        [577774.0, 6436765.0],
                        [574976.0, 6434607.0],
                        [576964.0, 6421036.0],
                        [570522.0, 6417080.0],
                        [570668.0, 6413830.0],
                        [564402.0, 6403210.0],
                        [559319.0, 6399932.0],
                        [553113.0, 6398528.0],
                        [553597.0, 6395079.0],
                        [547193.0, 6388334.0],
                    ]
                ],
            },
        },
        49: {
            "attributes": {
                "CODE_DEPT": "04",
                "NOM_DEPT": "ALPES-DE-HAUTE-PROVENCE",
                "POPULATION": 163915,
                "DENSITY": 23.44,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [992638.0, 6305621.0],
                        [997097.0, 6315251.0],
                        [1000978.0, 6315262.0],
                        [1007566.0, 6320724.0],
                        [1012050.0, 6317690.0],
                        [1014122.0, 6322114.0],
                        [1009068.0, 6324850.0],
                        [1007601.0, 6328762.0],
                        [1000089.0, 6334256.0],
                        [1000668.0, 6338218.0],
                        [994698.0, 6348019.0],
                        [997268.0, 6357103.0],
                        [1002665.0, 6364730.0],
                        [1009696.0, 6370071.0],
                        [1008626.0, 6382943.0],
                        [1006125.0, 6388590.0],
                        [1012175.0, 6394096.0],
                        [1012913.0, 6402904.0],
                        [1010207.0, 6403290.0],
                        [1004568.0, 6397351.0],
                        [999315.0, 6394909.0],
                        [992592.0, 6389297.0],
                        [988952.0, 6378656.0],
                        [983401.0, 6378221.0],
                        [971476.0, 6380340.0],
                        [967103.0, 6386021.0],
                        [957182.0, 6379131.0],
                        [959705.0, 6373500.0],
                        [957118.0, 6369997.0],
                        [950982.0, 6378672.0],
                        [944316.0, 6377139.0],
                        [935206.0, 6370624.0],
                        [932421.0, 6356788.0],
                        [925339.0, 6357350.0],
                        [930231.0, 6349978.0],
                        [920148.0, 6349530.0],
                        [913873.0, 6347227.0],
                        [911050.0, 6344481.0],
                        [905908.0, 6346585.0],
                        [903520.0, 6340766.0],
                        [899978.0, 6338355.0],
                        [900470.0, 6332559.0],
                        [903879.0, 6328807.0],
                        [901642.0, 6319541.0],
                        [909386.0, 6316209.0],
                        [907367.0, 6306820.0],
                        [913516.0, 6306489.0],
                        [922160.0, 6296144.0],
                        [923991.0, 6299127.0],
                        [933734.0, 6296912.0],
                        [944763.0, 6293054.0],
                        [956283.0, 6301072.0],
                        [958836.0, 6305328.0],
                        [970413.0, 6298787.0],
                        [974848.0, 6301646.0],
                        [974774.0, 6305117.0],
                        [983574.0, 6307147.0],
                        [992638.0, 6305621.0],
                    ]
                ],
            },
        },
        50: {
            "attributes": {
                "CODE_DEPT": "72",
                "NOM_DEPT": "SARTHE",
                "POPULATION": 566506,
                "DENSITY": 90.83,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [521086.0, 6735350.0],
                        [518605.0, 6737439.0],
                        [528757.0, 6745774.0],
                        [533549.0, 6751156.0],
                        [532634.0, 6757689.0],
                        [539183.0, 6762306.0],
                        [535875.0, 6773086.0],
                        [539332.0, 6780273.0],
                        [542578.0, 6786711.0],
                        [536374.0, 6790515.0],
                        [531913.0, 6790043.0],
                        [528051.0, 6796772.0],
                        [517130.0, 6797243.0],
                        [513744.0, 6803794.0],
                        [506061.0, 6806938.0],
                        [505117.0, 6820071.0],
                        [500193.0, 6823412.0],
                        [486746.0, 6818925.0],
                        [482552.0, 6813147.0],
                        [477803.0, 6815005.0],
                        [473893.0, 6813452.0],
                        [467628.0, 6811401.0],
                        [465298.0, 6799724.0],
                        [466280.0, 6794064.0],
                        [458409.0, 6789055.0],
                        [460615.0, 6783387.0],
                        [459373.0, 6778102.0],
                        [451057.0, 6776681.0],
                        [455060.0, 6767070.0],
                        [447308.0, 6764356.0],
                        [448124.0, 6758669.0],
                        [442128.0, 6753611.0],
                        [446459.0, 6750432.0],
                        [446732.0, 6745443.0],
                        [450112.0, 6740918.0],
                        [457617.0, 6739093.0],
                        [460339.0, 6732350.0],
                        [464631.0, 6730466.0],
                        [469484.0, 6733109.0],
                        [474490.0, 6731769.0],
                        [478533.0, 6727039.0],
                        [485937.0, 6723990.0],
                        [491931.0, 6726763.0],
                        [502971.0, 6722018.0],
                        [509057.0, 6729569.0],
                        [515591.0, 6731294.0],
                        [521086.0, 6735350.0],
                    ]
                ],
            },
        },
        51: feature_dpt_population_geometry_d,
        52: {
            "attributes": {
                "CODE_DEPT": "28",
                "NOM_DEPT": "EURE-ET-LOIR",
                "POPULATION": 433233,
                "DENSITY": 73.09,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [539112.0, 6843338.0],
                        [541484.0, 6833537.0],
                        [549859.0, 6826656.0],
                        [547706.0, 6812952.0],
                        [543224.0, 6808364.0],
                        [535921.0, 6806758.0],
                        [534094.0, 6803079.0],
                        [538862.0, 6792254.0],
                        [536374.0, 6790515.0],
                        [542578.0, 6786711.0],
                        [539332.0, 6780273.0],
                        [551017.0, 6782681.0],
                        [551727.0, 6777731.0],
                        [559439.0, 6777275.0],
                        [559999.0, 6772636.0],
                        [566408.0, 6764638.0],
                        [573758.0, 6762848.0],
                        [589601.0, 6765689.0],
                        [589165.0, 6770859.0],
                        [595216.0, 6770968.0],
                        [597558.0, 6774986.0],
                        [606511.0, 6774717.0],
                        [615539.0, 6776549.0],
                        [623220.0, 6795517.0],
                        [625387.0, 6798948.0],
                        [624251.0, 6811501.0],
                        [620852.0, 6812073.0],
                        [620311.0, 6818025.0],
                        [611402.0, 6819097.0],
                        [608912.0, 6830618.0],
                        [604791.0, 6831646.0],
                        [597086.0, 6841311.0],
                        [595472.0, 6845570.0],
                        [596554.0, 6858123.0],
                        [594217.0, 6866696.0],
                        [590236.0, 6872273.0],
                        [587701.0, 6866890.0],
                        [579784.0, 6860594.0],
                        [580772.0, 6855857.0],
                        [576482.0, 6852521.0],
                        [566604.0, 6854037.0],
                        [555241.0, 6849633.0],
                        [543803.0, 6848251.0],
                        [539112.0, 6843338.0],
                    ]
                ],
            },
        },
        53: {
            "attributes": {
                "CODE_DEPT": "2A",
                "NOM_DEPT": "CORSE-DU-SUD",
                "POPULATION": 157249,
                "DENSITY": 39.03,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1232225.0, 6105798.0],
                        [1226359.0, 6102880.0],
                        [1217754.0, 6104291.0],
                        [1215715.0, 6123336.0],
                        [1210743.0, 6122769.0],
                        [1206639.0, 6131576.0],
                        [1202519.0, 6133762.0],
                        [1199675.0, 6142105.0],
                        [1187662.0, 6146432.0],
                        [1180116.0, 6152978.0],
                        [1164950.0, 6158109.0],
                        [1159342.0, 6158599.0],
                        [1169805.0, 6146197.0],
                        [1163901.0, 6144874.0],
                        [1160274.0, 6141810.0],
                        [1162433.0, 6134554.0],
                        [1168722.0, 6128275.0],
                        [1172897.0, 6127710.0],
                        [1175910.0, 6121801.0],
                        [1169135.0, 6117789.0],
                        [1170381.0, 6114875.0],
                        [1164715.0, 6111213.0],
                        [1168686.0, 6106658.0],
                        [1175324.0, 6107066.0],
                        [1177911.0, 6109856.0],
                        [1182246.0, 6105577.0],
                        [1180256.0, 6096485.0],
                        [1173562.0, 6088828.0],
                        [1176478.0, 6086334.0],
                        [1193164.0, 6083876.0],
                        [1190373.0, 6079505.0],
                        [1183548.0, 6076443.0],
                        [1183755.0, 6068439.0],
                        [1188281.0, 6067524.0],
                        [1196826.0, 6061810.0],
                        [1209242.0, 6057430.0],
                        [1210610.0, 6054235.0],
                        [1221376.0, 6050136.0],
                        [1221646.0, 6056536.0],
                        [1224377.0, 6061299.0],
                        [1225618.0, 6068574.0],
                        [1229809.0, 6072152.0],
                        [1228158.0, 6078400.0],
                        [1232811.0, 6083356.0],
                        [1233466.0, 6095728.0],
                        [1232225.0, 6105798.0],
                    ]
                ],
            },
        },
        54: {
            "attributes": {
                "CODE_DEPT": "54",
                "NOM_DEPT": "MEURTHE-ET-MOSELLE",
                "POPULATION": 733481,
                "DENSITY": 138.83,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [879041.0, 6935896.0],
                        [878534.0, 6930925.0],
                        [883576.0, 6926040.0],
                        [891117.0, 6929633.0],
                        [895087.0, 6927281.0],
                        [898652.0, 6915853.0],
                        [898091.0, 6905220.0],
                        [901547.0, 6903348.0],
                        [900172.0, 6898682.0],
                        [901739.0, 6893315.0],
                        [905859.0, 6891045.0],
                        [906433.0, 6884047.0],
                        [905066.0, 6875501.0],
                        [901302.0, 6871865.0],
                        [904125.0, 6862116.0],
                        [899528.0, 6852809.0],
                        [902927.0, 6847494.0],
                        [903561.0, 6837915.0],
                        [900379.0, 6832469.0],
                        [904895.0, 6830283.0],
                        [904250.0, 6825381.0],
                        [910921.0, 6826770.0],
                        [919362.0, 6809623.0],
                        [930831.0, 6810526.0],
                        [935203.0, 6815546.0],
                        [963830.0, 6819154.0],
                        [964951.0, 6823820.0],
                        [973656.0, 6818945.0],
                        [982282.0, 6817771.0],
                        [987769.0, 6820181.0],
                        [994239.0, 6827289.0],
                        [1004385.0, 6831654.0],
                        [1001023.0, 6834020.0],
                        [993487.0, 6842033.0],
                        [983189.0, 6843093.0],
                        [976380.0, 6847597.0],
                        [971773.0, 6847764.0],
                        [969100.0, 6851558.0],
                        [964692.0, 6852206.0],
                        [961206.0, 6856322.0],
                        [946451.0, 6858744.0],
                        [945024.0, 6864515.0],
                        [939656.0, 6875317.0],
                        [929417.0, 6875078.0],
                        [928151.0, 6878713.0],
                        [922735.0, 6879575.0],
                        [922708.0, 6883240.0],
                        [914442.0, 6889764.0],
                        [914011.0, 6893894.0],
                        [920671.0, 6900380.0],
                        [917676.0, 6905219.0],
                        [920628.0, 6907653.0],
                        [912688.0, 6923499.0],
                        [913390.0, 6932141.0],
                        [909643.0, 6936903.0],
                        [902225.0, 6942685.0],
                        [896580.0, 6941163.0],
                        [892512.0, 6942531.0],
                        [879041.0, 6935896.0],
                    ]
                ],
            },
        },
        55: {
            "attributes": {
                "CODE_DEPT": "61",
                "NOM_DEPT": "ORNE",
                "POPULATION": 283372,
                "DENSITY": 46.13,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [510545.0, 6875400.0],
                        [504730.0, 6874732.0],
                        [500558.0, 6877307.0],
                        [491678.0, 6873174.0],
                        [489675.0, 6876299.0],
                        [484257.0, 6870962.0],
                        [475607.0, 6865852.0],
                        [469104.0, 6863978.0],
                        [457511.0, 6867107.0],
                        [454384.0, 6863198.0],
                        [449827.0, 6868751.0],
                        [446005.0, 6869054.0],
                        [427244.0, 6861949.0],
                        [417723.0, 6857101.0],
                        [420581.0, 6852284.0],
                        [423498.0, 6841841.0],
                        [421619.0, 6835816.0],
                        [414934.0, 6829326.0],
                        [422197.0, 6821752.0],
                        [429868.0, 6822252.0],
                        [437568.0, 6825109.0],
                        [441174.0, 6828584.0],
                        [446687.0, 6829012.0],
                        [451256.0, 6826715.0],
                        [457920.0, 6827997.0],
                        [463434.0, 6833996.0],
                        [466087.0, 6830999.0],
                        [467262.0, 6822174.0],
                        [474394.0, 6821359.0],
                        [473893.0, 6813452.0],
                        [477803.0, 6815005.0],
                        [482552.0, 6813147.0],
                        [486746.0, 6818925.0],
                        [500193.0, 6823412.0],
                        [505117.0, 6820071.0],
                        [506061.0, 6806938.0],
                        [513744.0, 6803794.0],
                        [517130.0, 6797243.0],
                        [528051.0, 6796772.0],
                        [531913.0, 6790043.0],
                        [536374.0, 6790515.0],
                        [538862.0, 6792254.0],
                        [534094.0, 6803079.0],
                        [535921.0, 6806758.0],
                        [543224.0, 6808364.0],
                        [547706.0, 6812952.0],
                        [549859.0, 6826656.0],
                        [541484.0, 6833537.0],
                        [539112.0, 6843338.0],
                        [533024.0, 6847407.0],
                        [536389.0, 6850906.0],
                        [533488.0, 6856087.0],
                        [524600.0, 6861683.0],
                        [520512.0, 6866728.0],
                        [513552.0, 6867418.0],
                        [508448.0, 6870995.0],
                        [510545.0, 6875400.0],
                    ]
                ],
            },
        },
        56: {
            "attributes": {
                "CODE_DEPT": "01",
                "NOM_DEPT": "AIN",
                "POPULATION": 643350,
                "DENSITY": 111.43,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [877344.0, 6596683.0],
                        [869949.0, 6598870.0],
                        [868758.0, 6603264.0],
                        [857422.0, 6600366.0],
                        [848718.0, 6603737.0],
                        [845229.0, 6595067.0],
                        [845050.0, 6590960.0],
                        [839484.0, 6574938.0],
                        [837322.0, 6565642.0],
                        [838741.0, 6561678.0],
                        [835220.0, 6556428.0],
                        [834501.0, 6551198.0],
                        [835850.0, 6543054.0],
                        [833933.0, 6540287.0],
                        [844536.0, 6535588.0],
                        [849404.0, 6524528.0],
                        [863140.0, 6525920.0],
                        [870291.0, 6521483.0],
                        [876089.0, 6523611.0],
                        [879159.0, 6530984.0],
                        [882529.0, 6534232.0],
                        [888996.0, 6528631.0],
                        [888123.0, 6525941.0],
                        [897998.0, 6515860.0],
                        [904449.0, 6504924.0],
                        [909413.0, 6509006.0],
                        [910338.0, 6515974.0],
                        [915868.0, 6518199.0],
                        [916332.0, 6528631.0],
                        [919315.0, 6541572.0],
                        [917441.0, 6547210.0],
                        [916992.0, 6555432.0],
                        [918731.0, 6560168.0],
                        [928176.0, 6563414.0],
                        [933670.0, 6575392.0],
                        [940629.0, 6577110.0],
                        [938817.0, 6580823.0],
                        [943610.0, 6590224.0],
                        [935280.0, 6595262.0],
                        [929573.0, 6589336.0],
                        [923919.0, 6580132.0],
                        [919460.0, 6577537.0],
                        [909869.0, 6577050.0],
                        [908880.0, 6582354.0],
                        [903737.0, 6585593.0],
                        [895736.0, 6577631.0],
                        [890444.0, 6576892.0],
                        [887558.0, 6582363.0],
                        [882486.0, 6586333.0],
                        [882664.0, 6589574.0],
                        [877221.0, 6593352.0],
                        [877344.0, 6596683.0],
                    ]
                ],
            },
        },
        57: {
            "attributes": {
                "CODE_DEPT": "09",
                "NOM_DEPT": "ARIEGE",
                "POPULATION": 153153,
                "DENSITY": 31.12,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [524704.0, 6194181.0],
                        [530246.0, 6189977.0],
                        [542336.0, 6189236.0],
                        [549247.0, 6180805.0],
                        [554894.0, 6182516.0],
                        [562658.0, 6181937.0],
                        [567864.0, 6177510.0],
                        [571419.0, 6168649.0],
                        [580902.0, 6173997.0],
                        [585134.0, 6170835.0],
                        [592180.0, 6170254.0],
                        [600206.0, 6164532.0],
                        [607482.0, 6165290.0],
                        [615529.0, 6169131.0],
                        [617954.0, 6174066.0],
                        [631545.0, 6174170.0],
                        [632373.0, 6176261.0],
                        [622733.0, 6184536.0],
                        [614361.0, 6182470.0],
                        [610538.0, 6185966.0],
                        [608402.0, 6195450.0],
                        [617137.0, 6197372.0],
                        [617210.0, 6214637.0],
                        [613663.0, 6217624.0],
                        [614442.0, 6225039.0],
                        [604330.0, 6228108.0],
                        [595072.0, 6233132.0],
                        [596256.0, 6236985.0],
                        [593467.0, 6242482.0],
                        [589272.0, 6240503.0],
                        [582028.0, 6242918.0],
                        [575081.0, 6235814.0],
                        [572065.0, 6240985.0],
                        [565565.0, 6247682.0],
                        [561407.0, 6244405.0],
                        [567825.0, 6236309.0],
                        [562910.0, 6233771.0],
                        [555809.0, 6233248.0],
                        [554118.0, 6225953.0],
                        [547328.0, 6230443.0],
                        [541984.0, 6228895.0],
                        [540236.0, 6224348.0],
                        [535770.0, 6220735.0],
                        [537386.0, 6214080.0],
                        [535012.0, 6210452.0],
                        [526458.0, 6208824.0],
                        [522873.0, 6204718.0],
                        [524704.0, 6194181.0],
                    ]
                ],
            },
        },
        58: {
            "attributes": {
                "CODE_DEPT": "19",
                "NOM_DEPT": "CORREZE",
                "POPULATION": 241464,
                "DENSITY": 41.0,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [563452.0, 6484264.0],
                        [563844.0, 6479160.0],
                        [568750.0, 6477311.0],
                        [560988.0, 6465186.0],
                        [564865.0, 6461779.0],
                        [566113.0, 6450433.0],
                        [573095.0, 6446142.0],
                        [577774.0, 6436765.0],
                        [584718.0, 6439628.0],
                        [593751.0, 6437105.0],
                        [601475.0, 6429196.0],
                        [607209.0, 6426078.0],
                        [613933.0, 6431618.0],
                        [626129.0, 6431248.0],
                        [631663.0, 6432186.0],
                        [628772.0, 6440050.0],
                        [634831.0, 6442812.0],
                        [638218.0, 6451518.0],
                        [636846.0, 6458269.0],
                        [642886.0, 6465907.0],
                        [649118.0, 6470007.0],
                        [651369.0, 6479623.0],
                        [656321.0, 6476249.0],
                        [659915.0, 6480065.0],
                        [661594.0, 6486680.0],
                        [662264.0, 6494997.0],
                        [658322.0, 6500286.0],
                        [662164.0, 6504560.0],
                        [663288.0, 6509261.0],
                        [660507.0, 6515469.0],
                        [656101.0, 6511235.0],
                        [649366.0, 6512420.0],
                        [648450.0, 6509221.0],
                        [637278.0, 6511373.0],
                        [635791.0, 6515072.0],
                        [631053.0, 6514297.0],
                        [623634.0, 6517796.0],
                        [614305.0, 6511565.0],
                        [612121.0, 6507862.0],
                        [605337.0, 6509707.0],
                        [593766.0, 6498788.0],
                        [587429.0, 6495459.0],
                        [581471.0, 6497412.0],
                        [576059.0, 6493313.0],
                        [571080.0, 6486618.0],
                        [566212.0, 6489282.0],
                        [563452.0, 6484264.0],
                    ]
                ],
            },
        },
        59: {
            "attributes": {
                "CODE_DEPT": "68",
                "NOM_DEPT": "HAUT-RHIN",
                "POPULATION": 764030,
                "DENSITY": 216.66,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [987691.0, 6753958.0],
                        [989189.0, 6749828.0],
                        [1000830.0, 6745745.0],
                        [1003510.0, 6737902.0],
                        [1000706.0, 6731961.0],
                        [1006958.0, 6729298.0],
                        [1010786.0, 6719537.0],
                        [1014326.0, 6713511.0],
                        [1019985.0, 6711034.0],
                        [1024064.0, 6712992.0],
                        [1031730.0, 6713160.0],
                        [1039126.0, 6720266.0],
                        [1038581.0, 6725392.0],
                        [1044459.0, 6729657.0],
                        [1044908.0, 6732411.0],
                        [1039238.0, 6738821.0],
                        [1038337.0, 6743276.0],
                        [1040672.0, 6747502.0],
                        [1039113.0, 6752662.0],
                        [1040418.0, 6763108.0],
                        [1044697.0, 6773634.0],
                        [1040564.0, 6779861.0],
                        [1040408.0, 6789869.0],
                        [1036067.0, 6790258.0],
                        [1032222.0, 6793924.0],
                        [1032428.0, 6798669.0],
                        [1022638.0, 6802981.0],
                        [1016850.0, 6809125.0],
                        [1011125.0, 6809400.0],
                        [1006708.0, 6801985.0],
                        [1001795.0, 6789636.0],
                        [998205.0, 6776671.0],
                        [993983.0, 6773739.0],
                        [991355.0, 6761730.0],
                        [993060.0, 6757264.0],
                        [987691.0, 6753958.0],
                    ]
                ],
            },
        },
        60: {
            "attributes": {
                "CODE_DEPT": "37",
                "NOM_DEPT": "INDRE-ET-LOIRE",
                "POPULATION": 606511,
                "DENSITY": 98.66,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [573297.0, 6677558.0],
                        [569696.0, 6685244.0],
                        [565759.0, 6689706.0],
                        [561058.0, 6687382.0],
                        [557051.0, 6690388.0],
                        [558309.0, 6696538.0],
                        [557303.0, 6702930.0],
                        [559271.0, 6706788.0],
                        [552945.0, 6716389.0],
                        [555366.0, 6719856.0],
                        [552256.0, 6724799.0],
                        [543743.0, 6727862.0],
                        [539386.0, 6732046.0],
                        [530153.0, 6735215.0],
                        [521086.0, 6735350.0],
                        [515591.0, 6731294.0],
                        [509057.0, 6729569.0],
                        [502971.0, 6722018.0],
                        [491931.0, 6726763.0],
                        [489539.0, 6719725.0],
                        [490772.0, 6714971.0],
                        [487846.0, 6706491.0],
                        [479254.0, 6691029.0],
                        [476861.0, 6677880.0],
                        [478404.0, 6673399.0],
                        [482922.0, 6672972.0],
                        [485608.0, 6667284.0],
                        [494947.0, 6665028.0],
                        [494833.0, 6656131.0],
                        [505157.0, 6650870.0],
                        [510389.0, 6653999.0],
                        [517389.0, 6653506.0],
                        [515158.0, 6658631.0],
                        [524608.0, 6655240.0],
                        [525272.0, 6647330.0],
                        [531658.0, 6641492.0],
                        [533123.0, 6635020.0],
                        [537221.0, 6629765.0],
                        [546519.0, 6631001.0],
                        [551779.0, 6655211.0],
                        [553982.0, 6659068.0],
                        [560408.0, 6661557.0],
                        [568878.0, 6661167.0],
                        [571950.0, 6667671.0],
                        [576079.0, 6670370.0],
                        [573297.0, 6677558.0],
                    ]
                ],
            },
        },
        61: {
            "attributes": {
                "CODE_DEPT": "59",
                "NOM_DEPT": "NORD",
                "POPULATION": 2604361,
                "DENSITY": 450.97,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [634422.0, 7101577.0],
                        [636514.0, 7100652.0],
                        [642453.0, 7087769.0],
                        [644454.0, 7079622.0],
                        [653390.0, 7071778.0],
                        [658064.0, 7064147.0],
                        [664277.0, 7059477.0],
                        [673807.0, 7057943.0],
                        [679720.0, 7059405.0],
                        [683642.0, 7063001.0],
                        [688698.0, 7062196.0],
                        [686184.0, 7056263.0],
                        [687641.0, 7047582.0],
                        [692820.0, 7044918.0],
                        [697493.0, 7046164.0],
                        [701478.0, 7042709.0],
                        [702680.0, 7038239.0],
                        [699507.0, 7031355.0],
                        [712383.0, 7015916.0],
                        [711164.0, 7009522.0],
                        [706855.0, 7002888.0],
                        [706470.0, 6995042.0],
                        [712391.0, 6990404.0],
                        [716534.0, 6992565.0],
                        [720100.0, 6990781.0],
                        [725313.0, 6993104.0],
                        [735248.0, 6991264.0],
                        [739058.0, 6995179.0],
                        [744014.0, 6992056.0],
                        [751253.0, 6997000.0],
                        [753505.0, 6995276.0],
                        [766237.0, 6992385.0],
                        [770359.0, 6988977.0],
                        [778060.0, 6986162.0],
                        [781905.0, 6987282.0],
                        [783321.0, 6995122.0],
                        [788006.0, 6997129.0],
                        [785882.0, 7004302.0],
                        [780654.0, 7004663.0],
                        [782919.0, 7012216.0],
                        [787237.0, 7018342.0],
                        [781127.0, 7020183.0],
                        [773958.0, 7027731.0],
                        [768979.0, 7028494.0],
                        [763439.0, 7026158.0],
                        [760772.0, 7028536.0],
                        [753265.0, 7028386.0],
                        [749524.0, 7024442.0],
                        [746894.0, 7030603.0],
                        [747241.0, 7039722.0],
                        [743565.0, 7044070.0],
                        [733656.0, 7048580.0],
                        [726572.0, 7043892.0],
                        [720348.0, 7047849.0],
                        [717610.0, 7060148.0],
                        [718286.0, 7067127.0],
                        [713527.0, 7069761.0],
                        [710740.0, 7076212.0],
                        [704337.0, 7075998.0],
                        [695621.0, 7071968.0],
                        [692807.0, 7066387.0],
                        [686789.0, 7068929.0],
                        [680050.0, 7079722.0],
                        [674224.0, 7079651.0],
                        [671748.0, 7084186.0],
                        [674131.0, 7094505.0],
                        [670178.0, 7102078.0],
                        [667909.0, 7110430.0],
                        [659576.0, 7106814.0],
                        [654175.0, 7107325.0],
                        [637372.0, 7101244.0],
                        [634422.0, 7101577.0],
                    ]
                ],
            },
        },
        62: {
            "attributes": {
                "CODE_DEPT": "90",
                "NOM_DEPT": "TERRITOIRE DE BELFORT",
                "POPULATION": 142622,
                "DENSITY": 233.94,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [1010786.0, 6719537.0],
                        [1006958.0, 6729298.0],
                        [1000706.0, 6731961.0],
                        [1003510.0, 6737902.0],
                        [1000830.0, 6745745.0],
                        [989189.0, 6749828.0],
                        [987691.0, 6753958.0],
                        [986052.0, 6752778.0],
                        [981470.0, 6745308.0],
                        [983826.0, 6731782.0],
                        [986155.0, 6724947.0],
                        [993651.0, 6723596.0],
                        [994087.0, 6717743.0],
                        [996902.0, 6711079.0],
                        [1001194.0, 6713400.0],
                        [999772.0, 6717889.0],
                        [1007028.0, 6717766.0],
                        [1010786.0, 6719537.0],
                    ]
                ],
            },
        },
        63: {
            "attributes": {
                "CODE_DEPT": "44",
                "NOM_DEPT": "LOIRE-ATLANTIQUE",
                "POPULATION": 1394909,
                "DENSITY": 199.48,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [382163.0, 6750361.0],
                        [374291.0, 6753124.0],
                        [371672.0, 6756673.0],
                        [356172.0, 6751743.0],
                        [351165.0, 6744974.0],
                        [342268.0, 6743932.0],
                        [335469.0, 6745297.0],
                        [327477.0, 6743723.0],
                        [317487.0, 6738014.0],
                        [315995.0, 6726944.0],
                        [300067.0, 6720583.0],
                        [288997.0, 6719519.0],
                        [282806.0, 6712695.0],
                        [283678.0, 6703214.0],
                        [288393.0, 6698809.0],
                        [292251.0, 6700736.0],
                        [299211.0, 6695249.0],
                        [308160.0, 6699576.0],
                        [309828.0, 6691500.0],
                        [308860.0, 6686791.0],
                        [304084.0, 6683183.0],
                        [316935.0, 6678247.0],
                        [322009.0, 6670666.0],
                        [324590.0, 6666698.0],
                        [332678.0, 6659222.0],
                        [338731.0, 6658583.0],
                        [343129.0, 6653969.0],
                        [353671.0, 6649968.0],
                        [357453.0, 6652400.0],
                        [354064.0, 6663454.0],
                        [354394.0, 6667534.0],
                        [359840.0, 6669393.0],
                        [361112.0, 6656907.0],
                        [367588.0, 6659427.0],
                        [367645.0, 6668175.0],
                        [374065.0, 6668782.0],
                        [376108.0, 6673611.0],
                        [385082.0, 6667087.0],
                        [387784.0, 6670618.0],
                        [379298.0, 6676338.0],
                        [379159.0, 6679552.0],
                        [384839.0, 6683588.0],
                        [382659.0, 6691801.0],
                        [378391.0, 6691949.0],
                        [374867.0, 6698071.0],
                        [375470.0, 6701871.0],
                        [385609.0, 6704471.0],
                        [396890.0, 6703794.0],
                        [402393.0, 6705897.0],
                        [401401.0, 6717774.0],
                        [387234.0, 6720426.0],
                        [386462.0, 6727467.0],
                        [395905.0, 6725901.0],
                        [398982.0, 6728603.0],
                        [389301.0, 6732485.0],
                        [386987.0, 6740963.0],
                        [381255.0, 6745617.0],
                        [382163.0, 6750361.0],
                    ]
                ],
            },
        },
        64: {
            "attributes": {
                "CODE_DEPT": "89",
                "NOM_DEPT": "YONNE",
                "POPULATION": 338291,
                "DENSITY": 45.4,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [698236.0, 6718784.0],
                        [701928.0, 6717598.0],
                        [707666.0, 6720847.0],
                        [709181.0, 6715638.0],
                        [715400.0, 6713642.0],
                        [717731.0, 6709895.0],
                        [723118.0, 6710529.0],
                        [726085.0, 6708066.0],
                        [729904.0, 6712131.0],
                        [736733.0, 6710509.0],
                        [738638.0, 6714270.0],
                        [743712.0, 6710994.0],
                        [743701.0, 6707332.0],
                        [751168.0, 6705240.0],
                        [753904.0, 6700965.0],
                        [759265.0, 6699206.0],
                        [773240.0, 6698003.0],
                        [773484.0, 6692940.0],
                        [783517.0, 6693799.0],
                        [780393.0, 6701310.0],
                        [784360.0, 6705398.0],
                        [783952.0, 6713331.0],
                        [788376.0, 6717645.0],
                        [791050.0, 6725986.0],
                        [795163.0, 6731989.0],
                        [794312.0, 6737086.0],
                        [799827.0, 6740411.0],
                        [799053.0, 6750471.0],
                        [794318.0, 6750026.0],
                        [796594.0, 6759156.0],
                        [789480.0, 6763963.0],
                        [783028.0, 6759096.0],
                        [767353.0, 6760249.0],
                        [763413.0, 6765164.0],
                        [759917.0, 6778325.0],
                        [755033.0, 6785741.0],
                        [749678.0, 6782304.0],
                        [746161.0, 6791892.0],
                        [745765.0, 6796957.0],
                        [736893.0, 6807760.0],
                        [730707.0, 6810078.0],
                        [727042.0, 6808060.0],
                        [712422.0, 6807964.0],
                        [703668.0, 6806647.0],
                        [703237.0, 6796855.0],
                        [700383.0, 6789702.0],
                        [695265.0, 6784783.0],
                        [702192.0, 6781427.0],
                        [703759.0, 6774663.0],
                        [706580.0, 6772621.0],
                        [709585.0, 6763406.0],
                        [703743.0, 6756785.0],
                        [700769.0, 6756036.0],
                        [701782.0, 6742907.0],
                        [695135.0, 6740319.0],
                        [689262.0, 6740069.0],
                        [689391.0, 6734632.0],
                        [694231.0, 6731133.0],
                        [695341.0, 6722058.0],
                        [698236.0, 6718784.0],
                    ]
                ],
            },
        },
        65: {
            "attributes": {
                "CODE_DEPT": "35",
                "NOM_DEPT": "ILLE-ET-VILAINE",
                "POPULATION": 1060199,
                "DENSITY": 155.22,
            },
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [330825.0, 6841252.0],
                            [328251.0, 6849310.0],
                            [322500.0, 6846053.0],
                            [325749.0, 6841751.0],
                            [330825.0, 6841252.0],
                        ]
                    ],
                    [
                        [
                            [399495.0, 6830885.0],
                            [389634.0, 6835155.0],
                            [384742.0, 6834496.0],
                            [376536.0, 6826525.0],
                            [368413.0, 6830443.0],
                            [366767.0, 6839135.0],
                            [363309.0, 6845999.0],
                            [348952.0, 6844300.0],
                            [343084.0, 6846084.0],
                            [341341.0, 6849649.0],
                            [342875.0, 6855953.0],
                            [334395.0, 6854417.0],
                            [329772.0, 6850320.0],
                            [334969.0, 6837949.0],
                            [337450.0, 6835570.0],
                            [332923.0, 6813386.0],
                            [328273.0, 6809495.0],
                            [325505.0, 6811765.0],
                            [320973.0, 6806998.0],
                            [315234.0, 6806646.0],
                            [311879.0, 6798427.0],
                            [306966.0, 6794650.0],
                            [310549.0, 6787938.0],
                            [306739.0, 6782705.0],
                            [309516.0, 6779524.0],
                            [317014.0, 6776765.0],
                            [320890.0, 6769878.0],
                            [317839.0, 6765781.0],
                            [322365.0, 6758359.0],
                            [318803.0, 6749864.0],
                            [315562.0, 6748257.0],
                            [317487.0, 6738014.0],
                            [327477.0, 6743723.0],
                            [335469.0, 6745297.0],
                            [342268.0, 6743932.0],
                            [351165.0, 6744974.0],
                            [356172.0, 6751743.0],
                            [371672.0, 6756673.0],
                            [374291.0, 6753124.0],
                            [382163.0, 6750361.0],
                            [382932.0, 6754022.0],
                            [386941.0, 6760260.0],
                            [390140.0, 6770978.0],
                            [394099.0, 6773357.0],
                            [400197.0, 6773697.0],
                            [400465.0, 6781914.0],
                            [398626.0, 6784333.0],
                            [395852.0, 6803336.0],
                            [400321.0, 6810723.0],
                            [398130.0, 6822559.0],
                            [399495.0, 6830885.0],
                        ]
                    ],
                ],
            },
        },
        66: {
            "attributes": {
                "CODE_DEPT": "40",
                "NOM_DEPT": "LANDES",
                "POPULATION": 407444,
                "DENSITY": 43.56,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [334283.0, 6280551.0],
                        [338238.0, 6281381.0],
                        [342731.0, 6276517.0],
                        [352961.0, 6276001.0],
                        [362964.0, 6280741.0],
                        [367753.0, 6276986.0],
                        [377063.0, 6275535.0],
                        [385124.0, 6280151.0],
                        [394475.0, 6281218.0],
                        [399714.0, 6278404.0],
                        [403447.0, 6281078.0],
                        [412501.0, 6278002.0],
                        [421554.0, 6283529.0],
                        [424830.0, 6280287.0],
                        [433057.0, 6279053.0],
                        [438084.0, 6281592.0],
                        [439499.0, 6295895.0],
                        [442698.0, 6298315.0],
                        [443572.0, 6313646.0],
                        [440195.0, 6315550.0],
                        [444807.0, 6320573.0],
                        [453303.0, 6321029.0],
                        [461632.0, 6315722.0],
                        [465239.0, 6317398.0],
                        [465465.0, 6324803.0],
                        [464468.0, 6326808.0],
                        [467874.0, 6336236.0],
                        [470769.0, 6340294.0],
                        [462757.0, 6341305.0],
                        [459734.0, 6343570.0],
                        [449759.0, 6344226.0],
                        [449164.0, 6352477.0],
                        [445091.0, 6357381.0],
                        [442465.0, 6350467.0],
                        [438523.0, 6349285.0],
                        [429214.0, 6351421.0],
                        [430077.0, 6359927.0],
                        [426389.0, 6364119.0],
                        [419635.0, 6366255.0],
                        [418928.0, 6369127.0],
                        [411174.0, 6373203.0],
                        [411314.0, 6378206.0],
                        [403228.0, 6378937.0],
                        [393973.0, 6376334.0],
                        [388231.0, 6379327.0],
                        [381182.0, 6379048.0],
                        [383562.0, 6383958.0],
                        [375548.0, 6389853.0],
                        [373686.0, 6386677.0],
                        [361774.0, 6383396.0],
                        [355175.0, 6347840.0],
                        [348748.0, 6322487.0],
                        [342546.0, 6300215.0],
                        [341177.0, 6292691.0],
                        [334283.0, 6280551.0],
                    ]
                ],
            },
        },
        67: {
            "attributes": {
                "CODE_DEPT": "29",
                "NOM_DEPT": "FINISTERE",
                "POPULATION": 909028,
                "DENSITY": 134.54,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [210124.0, 6860562.0],
                        [210319.0, 6864435.0],
                        [197918.0, 6867491.0],
                        [195168.0, 6863087.0],
                        [188759.0, 6861699.0],
                        [187283.0, 6866983.0],
                        [171676.0, 6866983.0],
                        [165007.0, 6863478.0],
                        [159513.0, 6866951.0],
                        [150836.0, 6862294.0],
                        [143559.0, 6862620.0],
                        [137993.0, 6858007.0],
                        [130421.0, 6856362.0],
                        [126410.0, 6849458.0],
                        [124277.0, 6841317.0],
                        [126191.0, 6836271.0],
                        [137035.0, 6831319.0],
                        [151215.0, 6836632.0],
                        [149516.0, 6831882.0],
                        [159712.0, 6829829.0],
                        [158800.0, 6824711.0],
                        [152925.0, 6822802.0],
                        [150196.0, 6824902.0],
                        [139593.0, 6825317.0],
                        [139209.0, 6819312.0],
                        [147794.0, 6818873.0],
                        [158225.0, 6812964.0],
                        [159803.0, 6806301.0],
                        [156741.0, 6801688.0],
                        [151961.0, 6804475.0],
                        [143250.0, 6802653.0],
                        [129762.0, 6802135.0],
                        [125302.0, 6798484.0],
                        [144750.0, 6790824.0],
                        [150552.0, 6779953.0],
                        [149596.0, 6769606.0],
                        [162294.0, 6768615.0],
                        [164959.0, 6774152.0],
                        [171525.0, 6775493.0],
                        [174013.0, 6772980.0],
                        [183941.0, 6774809.0],
                        [184280.0, 6770949.0],
                        [191411.0, 6764941.0],
                        [196633.0, 6766198.0],
                        [200244.0, 6762976.0],
                        [211251.0, 6761104.0],
                        [212687.0, 6770001.0],
                        [221788.0, 6771592.0],
                        [223352.0, 6780867.0],
                        [216607.0, 6782805.0],
                        [211608.0, 6786141.0],
                        [205220.0, 6785800.0],
                        [202166.0, 6798131.0],
                        [202658.0, 6804638.0],
                        [212675.0, 6807535.0],
                        [216996.0, 6817941.0],
                        [214652.0, 6824074.0],
                        [215204.0, 6828740.0],
                        [213034.0, 6834627.0],
                        [212655.0, 6842190.0],
                        [216761.0, 6846809.0],
                        [210382.0, 6855067.0],
                        [210124.0, 6860562.0],
                    ]
                ],
            },
        },
        68: {
            "attributes": {
                "CODE_DEPT": "74",
                "NOM_DEPT": "HAUTE-SAVOIE",
                "POPULATION": 807360,
                "DENSITY": 175.65,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [995359.0, 6526975.0],
                        [996263.0, 6533312.0],
                        [1005620.0, 6535079.0],
                        [1009539.0, 6537663.0],
                        [1013275.0, 6543845.0],
                        [1010939.0, 6550631.0],
                        [1005414.0, 6557665.0],
                        [1000587.0, 6561265.0],
                        [1000913.0, 6565514.0],
                        [994423.0, 6565990.0],
                        [993170.0, 6574229.0],
                        [997429.0, 6583180.0],
                        [990846.0, 6588853.0],
                        [991547.0, 6595136.0],
                        [985884.0, 6596474.0],
                        [972312.0, 6594423.0],
                        [960663.0, 6587846.0],
                        [955674.0, 6591075.0],
                        [952150.0, 6588701.0],
                        [949250.0, 6580383.0],
                        [953939.0, 6574878.0],
                        [949136.0, 6572391.0],
                        [944956.0, 6566962.0],
                        [928176.0, 6563414.0],
                        [918731.0, 6560168.0],
                        [916992.0, 6555432.0],
                        [917441.0, 6547210.0],
                        [919315.0, 6541572.0],
                        [921730.0, 6540986.0],
                        [922988.0, 6530552.0],
                        [926213.0, 6526897.0],
                        [936560.0, 6520059.0],
                        [946066.0, 6522280.0],
                        [948121.0, 6516633.0],
                        [952091.0, 6514710.0],
                        [959117.0, 6516128.0],
                        [962862.0, 6525460.0],
                        [965836.0, 6528299.0],
                        [969073.0, 6537583.0],
                        [971940.0, 6540371.0],
                        [975690.0, 6531451.0],
                        [979688.0, 6528135.0],
                        [984284.0, 6528734.0],
                        [988618.0, 6520489.0],
                        [995359.0, 6526975.0],
                    ]
                ],
            },
        },
        69: {
            "attributes": {
                "CODE_DEPT": "60",
                "NOM_DEPT": "OISE",
                "POPULATION": 824503,
                "DENSITY": 139.9,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [605624.0, 6904387.0],
                        [608283.0, 6898554.0],
                        [612180.0, 6899061.0],
                        [618689.0, 6896449.0],
                        [626847.0, 6897876.0],
                        [633020.0, 6901508.0],
                        [645465.0, 6895048.0],
                        [649761.0, 6898738.0],
                        [652314.0, 6895981.0],
                        [659205.0, 6894147.0],
                        [670084.0, 6886723.0],
                        [673222.0, 6889902.0],
                        [680633.0, 6884542.0],
                        [700622.0, 6887964.0],
                        [705248.0, 6890863.0],
                        [710189.0, 6894765.0],
                        [704672.0, 6899225.0],
                        [701957.0, 6908433.0],
                        [698137.0, 6911415.0],
                        [706929.0, 6919738.0],
                        [706805.0, 6926038.0],
                        [711648.0, 6928031.0],
                        [706939.0, 6934901.0],
                        [709520.0, 6938240.0],
                        [707064.0, 6950845.0],
                        [708546.0, 6956332.0],
                        [693916.0, 6955962.0],
                        [685089.0, 6950779.0],
                        [685504.0, 6946842.0],
                        [677528.0, 6947426.0],
                        [676176.0, 6942514.0],
                        [669006.0, 6944292.0],
                        [664208.0, 6949037.0],
                        [654712.0, 6950974.0],
                        [645659.0, 6956103.0],
                        [636565.0, 6954687.0],
                        [623025.0, 6958366.0],
                        [620154.0, 6956108.0],
                        [612314.0, 6962826.0],
                        [605401.0, 6955866.0],
                        [607933.0, 6953359.0],
                        [606321.0, 6945902.0],
                        [609123.0, 6937659.0],
                        [607205.0, 6935073.0],
                        [610545.0, 6930338.0],
                        [606642.0, 6924066.0],
                        [609871.0, 6919444.0],
                        [610931.0, 6911811.0],
                        [606128.0, 6907968.0],
                        [605624.0, 6904387.0],
                    ]
                ],
            },
        },
        70: feature_dpt_population_geometry_c,
        71: {
            "attributes": {
                "CODE_DEPT": "58",
                "NOM_DEPT": "NIEVRE",
                "POPULATION": 207182,
                "DENSITY": 30.19,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [783517.0, 6693799.0],
                        [773484.0, 6692940.0],
                        [773240.0, 6698003.0],
                        [759265.0, 6699206.0],
                        [753904.0, 6700965.0],
                        [751168.0, 6705240.0],
                        [743701.0, 6707332.0],
                        [743712.0, 6710994.0],
                        [738638.0, 6714270.0],
                        [736733.0, 6710509.0],
                        [729904.0, 6712131.0],
                        [726085.0, 6708066.0],
                        [723118.0, 6710529.0],
                        [717731.0, 6709895.0],
                        [715400.0, 6713642.0],
                        [709181.0, 6715638.0],
                        [707666.0, 6720847.0],
                        [701928.0, 6717598.0],
                        [698236.0, 6718784.0],
                        [693556.0, 6718403.0],
                        [690565.0, 6713347.0],
                        [694642.0, 6704915.0],
                        [690449.0, 6694237.0],
                        [698745.0, 6684384.0],
                        [698614.0, 6680189.0],
                        [702129.0, 6669867.0],
                        [701762.0, 6662486.0],
                        [705753.0, 6657660.0],
                        [706033.0, 6650549.0],
                        [703828.0, 6645606.0],
                        [705186.0, 6641947.0],
                        [702446.0, 6632753.0],
                        [703745.0, 6628663.0],
                        [716475.0, 6620334.0],
                        [720608.0, 6624106.0],
                        [726499.0, 6620539.0],
                        [733164.0, 6623625.0],
                        [737251.0, 6617690.0],
                        [742042.0, 6624120.0],
                        [748049.0, 6627896.0],
                        [756196.0, 6628301.0],
                        [760920.0, 6622686.0],
                        [770503.0, 6626941.0],
                        [775685.0, 6631211.0],
                        [781064.0, 6632682.0],
                        [780490.0, 6638662.0],
                        [783308.0, 6642195.0],
                        [778932.0, 6646959.0],
                        [779000.0, 6654397.0],
                        [781374.0, 6662136.0],
                        [778810.0, 6664936.0],
                        [780471.0, 6669516.0],
                        [784602.0, 6669828.0],
                        [789554.0, 6672918.0],
                        [791663.0, 6673495.0],
                        [793165.0, 6678355.0],
                        [789098.0, 6683996.0],
                        [785899.0, 6682517.0],
                        [783517.0, 6693799.0],
                    ]
                ],
            },
        },
        72: {
            "attributes": {
                "CODE_DEPT": "21",
                "NOM_DEPT": "COTE-D'OR",
                "POPULATION": 532871,
                "DENSITY": 60.64,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [871408.0, 6655745.0],
                        [875449.0, 6660099.0],
                        [876191.0, 6666228.0],
                        [881002.0, 6667371.0],
                        [884880.0, 6674426.0],
                        [887407.0, 6682465.0],
                        [888032.0, 6690633.0],
                        [890265.0, 6692353.0],
                        [884919.0, 6701062.0],
                        [880595.0, 6713705.0],
                        [884206.0, 6713509.0],
                        [887785.0, 6718944.0],
                        [886108.0, 6726069.0],
                        [882147.0, 6728546.0],
                        [878352.0, 6725366.0],
                        [868188.0, 6726357.0],
                        [863148.0, 6730266.0],
                        [858300.0, 6729814.0],
                        [848455.0, 6733791.0],
                        [846031.0, 6742315.0],
                        [848388.0, 6746302.0],
                        [846087.0, 6753627.0],
                        [838226.0, 6763382.0],
                        [833316.0, 6764154.0],
                        [833398.0, 6769005.0],
                        [827043.0, 6770243.0],
                        [817962.0, 6771080.0],
                        [816397.0, 6764598.0],
                        [808147.0, 6762855.0],
                        [797692.0, 6763119.0],
                        [796594.0, 6759156.0],
                        [794318.0, 6750026.0],
                        [799053.0, 6750471.0],
                        [799827.0, 6740411.0],
                        [794312.0, 6737086.0],
                        [795163.0, 6731989.0],
                        [791050.0, 6725986.0],
                        [788376.0, 6717645.0],
                        [783952.0, 6713331.0],
                        [784360.0, 6705398.0],
                        [780393.0, 6701310.0],
                        [783517.0, 6693799.0],
                        [785899.0, 6682517.0],
                        [789098.0, 6683996.0],
                        [793165.0, 6678355.0],
                        [791663.0, 6673495.0],
                        [795506.0, 6668991.0],
                        [806631.0, 6665548.0],
                        [806754.0, 6662035.0],
                        [813434.0, 6659755.0],
                        [823470.0, 6650227.0],
                        [831500.0, 6648015.0],
                        [855755.0, 6655507.0],
                        [860161.0, 6652754.0],
                        [871408.0, 6655745.0],
                    ]
                ],
            },
        },
        73: {
            "attributes": {
                "CODE_DEPT": "91",
                "NOM_DEPT": "ESSONNE",
                "POPULATION": 1296130,
                "DENSITY": 712.81,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [643163.0, 6853168.0],
                        [634691.0, 6849194.0],
                        [632440.0, 6843248.0],
                        [627800.0, 6838438.0],
                        [627504.0, 6829048.0],
                        [623768.0, 6826369.0],
                        [620311.0, 6818025.0],
                        [620852.0, 6812073.0],
                        [624251.0, 6811501.0],
                        [625387.0, 6798948.0],
                        [639308.0, 6801806.0],
                        [653275.0, 6801114.0],
                        [655721.0, 6802434.0],
                        [657768.0, 6807009.0],
                        [665496.0, 6812431.0],
                        [663371.0, 6815578.0],
                        [663045.0, 6825117.0],
                        [666363.0, 6833836.0],
                        [665649.0, 6839786.0],
                        [668472.0, 6843626.0],
                        [663488.0, 6848458.0],
                        [653706.0, 6846856.0],
                        [650056.0, 6850064.0],
                        [643163.0, 6853168.0],
                    ]
                ],
            },
        },
        74: {
            "attributes": {
                "CODE_DEPT": "79",
                "NOM_DEPT": "DEUX-SEVRES",
                "POPULATION": 374351,
                "DENSITY": 62.09,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [483517.0, 6558927.0],
                        [485043.0, 6563684.0],
                        [480502.0, 6565882.0],
                        [477460.0, 6571967.0],
                        [478920.0, 6578170.0],
                        [482897.0, 6584792.0],
                        [479925.0, 6587264.0],
                        [475179.0, 6582497.0],
                        [472141.0, 6584899.0],
                        [472081.0, 6590232.0],
                        [468300.0, 6594579.0],
                        [467690.0, 6607234.0],
                        [472374.0, 6614809.0],
                        [467588.0, 6622657.0],
                        [470952.0, 6628365.0],
                        [469757.0, 6639127.0],
                        [471018.0, 6649618.0],
                        [465537.0, 6662685.0],
                        [464624.0, 6667352.0],
                        [458546.0, 6672434.0],
                        [454238.0, 6672319.0],
                        [442005.0, 6668948.0],
                        [434893.0, 6670550.0],
                        [429925.0, 6668493.0],
                        [429262.0, 6663802.0],
                        [424993.0, 6661094.0],
                        [417889.0, 6660618.0],
                        [413368.0, 6662854.0],
                        [404251.0, 6660135.0],
                        [408792.0, 6655192.0],
                        [411920.0, 6644974.0],
                        [417892.0, 6640888.0],
                        [415662.0, 6636435.0],
                        [420740.0, 6628764.0],
                        [421344.0, 6621760.0],
                        [423543.0, 6619698.0],
                        [424018.0, 6609992.0],
                        [422851.0, 6601758.0],
                        [420470.0, 6597142.0],
                        [428213.0, 6593481.0],
                        [426574.0, 6590996.0],
                        [411453.0, 6585116.0],
                        [411065.0, 6578554.0],
                        [415606.0, 6575464.0],
                        [420640.0, 6566176.0],
                        [426299.0, 6566639.0],
                        [429269.0, 6562335.0],
                        [437311.0, 6559539.0],
                        [446458.0, 6558600.0],
                        [459784.0, 6545825.0],
                        [464645.0, 6548283.0],
                        [465641.0, 6555184.0],
                        [469589.0, 6554692.0],
                        [473907.0, 6559092.0],
                        [483517.0, 6558927.0],
                    ]
                ],
            },
        },
        75: {
            "attributes": {
                "CODE_DEPT": "22",
                "NOM_DEPT": "COTES-D'ARMOR",
                "POPULATION": 598814,
                "DENSITY": 86.0,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [306966.0, 6794650.0],
                        [311879.0, 6798427.0],
                        [315234.0, 6806646.0],
                        [320973.0, 6806998.0],
                        [325505.0, 6811765.0],
                        [328273.0, 6809495.0],
                        [332923.0, 6813386.0],
                        [337450.0, 6835570.0],
                        [334969.0, 6837949.0],
                        [330825.0, 6841252.0],
                        [325749.0, 6841751.0],
                        [322500.0, 6846053.0],
                        [319331.0, 6843417.0],
                        [315059.0, 6845536.0],
                        [309156.0, 6855461.0],
                        [296913.0, 6849790.0],
                        [284640.0, 6841250.0],
                        [280881.0, 6840740.0],
                        [271227.0, 6848399.0],
                        [271155.0, 6854763.0],
                        [262910.0, 6863924.0],
                        [263482.0, 6867351.0],
                        [257346.0, 6869777.0],
                        [251930.0, 6880323.0],
                        [243322.0, 6881073.0],
                        [228138.0, 6874463.0],
                        [222446.0, 6879145.0],
                        [216642.0, 6872989.0],
                        [215941.0, 6861279.0],
                        [210124.0, 6860562.0],
                        [210382.0, 6855067.0],
                        [216761.0, 6846809.0],
                        [212655.0, 6842190.0],
                        [213034.0, 6834627.0],
                        [215204.0, 6828740.0],
                        [214652.0, 6824074.0],
                        [216996.0, 6817941.0],
                        [212675.0, 6807535.0],
                        [229439.0, 6804532.0],
                        [233945.0, 6800703.0],
                        [242780.0, 6802066.0],
                        [246074.0, 6807146.0],
                        [252150.0, 6805897.0],
                        [270150.0, 6795768.0],
                        [279762.0, 6794931.0],
                        [277875.0, 6787107.0],
                        [280665.0, 6785525.0],
                        [285132.0, 6789099.0],
                        [291749.0, 6798375.0],
                        [298204.0, 6799128.0],
                        [300637.0, 6793781.0],
                        [306966.0, 6794650.0],
                    ]
                ],
            },
        },
        76: {
            "attributes": {
                "CODE_DEPT": "03",
                "NOM_DEPT": "ALLIER",
                "POPULATION": 337988,
                "DENSITY": 45.89,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [702446.0, 6632753.0],
                        [696943.0, 6633749.0],
                        [686837.0, 6626145.0],
                        [682775.0, 6624336.0],
                        [677474.0, 6626628.0],
                        [669145.0, 6615318.0],
                        [670500.0, 6605989.0],
                        [664479.0, 6602292.0],
                        [660370.0, 6603761.0],
                        [650317.0, 6601560.0],
                        [645179.0, 6595086.0],
                        [644784.0, 6591412.0],
                        [647921.0, 6581264.0],
                        [653217.0, 6581299.0],
                        [659880.0, 6575828.0],
                        [662729.0, 6571178.0],
                        [666451.0, 6560450.0],
                        [672252.0, 6557694.0],
                        [679424.0, 6569309.0],
                        [685369.0, 6566281.0],
                        [688886.0, 6572856.0],
                        [695157.0, 6571452.0],
                        [693029.0, 6567076.0],
                        [697819.0, 6557998.0],
                        [712873.0, 6551781.0],
                        [728730.0, 6550656.0],
                        [732386.0, 6552810.0],
                        [735860.0, 6546571.0],
                        [745523.0, 6547324.0],
                        [753779.0, 6537018.0],
                        [754888.0, 6541809.0],
                        [761084.0, 6541876.0],
                        [763887.0, 6544360.0],
                        [762385.0, 6549859.0],
                        [763504.0, 6554575.0],
                        [760949.0, 6561975.0],
                        [762003.0, 6573092.0],
                        [769267.0, 6575508.0],
                        [775913.0, 6580395.0],
                        [775079.0, 6589273.0],
                        [776586.0, 6596649.0],
                        [773476.0, 6599308.0],
                        [768312.0, 6598303.0],
                        [763922.0, 6603795.0],
                        [761463.0, 6602522.0],
                        [756931.0, 6607772.0],
                        [753291.0, 6618069.0],
                        [748734.0, 6623209.0],
                        [748049.0, 6627896.0],
                        [742042.0, 6624120.0],
                        [737251.0, 6617690.0],
                        [733164.0, 6623625.0],
                        [726499.0, 6620539.0],
                        [720608.0, 6624106.0],
                        [716475.0, 6620334.0],
                        [703745.0, 6628663.0],
                        [702446.0, 6632753.0],
                    ]
                ],
            },
        },
        77: {
            "attributes": {
                "CODE_DEPT": "17",
                "NOM_DEPT": "CHARENTE-MARITIME",
                "POPULATION": 644303,
                "DENSITY": 93.2,
            },
            "geometry": {
                "type": "MultiPolygon",
                "coordinates": [
                    [
                        [
                            [365341.0, 6575902.0],
                            [359213.0, 6576771.0],
                            [352445.0, 6583031.0],
                            [350494.0, 6577212.0],
                            [356155.0, 6576636.0],
                            [364082.0, 6571051.0],
                            [365341.0, 6575902.0],
                        ]
                    ],
                    [
                        [
                            [373352.0, 6542832.0],
                            [371342.0, 6552252.0],
                            [366346.0, 6552808.0],
                            [362447.0, 6556836.0],
                            [360591.0, 6548506.0],
                            [369260.0, 6539881.0],
                            [371124.0, 6531592.0],
                            [374437.0, 6534213.0],
                            [375330.0, 6540510.0],
                            [373352.0, 6542832.0],
                        ]
                    ],
                    [
                        [
                            [464807.0, 6459164.0],
                            [461242.0, 6465553.0],
                            [455660.0, 6465791.0],
                            [456356.0, 6470307.0],
                            [447267.0, 6474282.0],
                            [443202.0, 6478722.0],
                            [445861.0, 6484044.0],
                            [444696.0, 6489309.0],
                            [446521.0, 6493231.0],
                            [442913.0, 6501478.0],
                            [436951.0, 6506668.0],
                            [434607.0, 6512022.0],
                            [434480.0, 6521530.0],
                            [445866.0, 6528260.0],
                            [449713.0, 6524677.0],
                            [455132.0, 6526680.0],
                            [458386.0, 6534878.0],
                            [457303.0, 6539406.0],
                            [459784.0, 6545825.0],
                            [446458.0, 6558600.0],
                            [437311.0, 6559539.0],
                            [429269.0, 6562335.0],
                            [426299.0, 6566639.0],
                            [420640.0, 6566176.0],
                            [415606.0, 6575464.0],
                            [411065.0, 6578554.0],
                            [411453.0, 6585116.0],
                            [404775.0, 6589452.0],
                            [397324.0, 6586760.0],
                            [391500.0, 6591809.0],
                            [382360.0, 6587238.0],
                            [383479.0, 6581738.0],
                            [376439.0, 6576760.0],
                            [374243.0, 6571617.0],
                            [381511.0, 6566597.0],
                            [386552.0, 6553761.0],
                            [382858.0, 6551653.0],
                            [385303.0, 6547012.0],
                            [378912.0, 6532887.0],
                            [370510.0, 6529071.0],
                            [370474.0, 6520657.0],
                            [379564.0, 6513624.0],
                            [387626.0, 6509256.0],
                            [386164.0, 6505245.0],
                            [399796.0, 6489042.0],
                            [404682.0, 6481482.0],
                            [406100.0, 6476140.0],
                            [418478.0, 6475494.0],
                            [421098.0, 6472770.0],
                            [431214.0, 6470295.0],
                            [433418.0, 6457450.0],
                            [437492.0, 6457585.0],
                            [444096.0, 6451365.0],
                            [452009.0, 6448234.0],
                            [457280.0, 6451647.0],
                            [460931.0, 6449393.0],
                            [464807.0, 6459164.0],
                        ]
                    ],
                ],
            },
        },
        78: {
            "attributes": {
                "CODE_DEPT": "15",
                "NOM_DEPT": "CANTAL",
                "POPULATION": 145143,
                "DENSITY": 25.17,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [728488.0, 6430309.0],
                        [727352.0, 6435060.0],
                        [723408.0, 6437470.0],
                        [725628.0, 6444038.0],
                        [722648.0, 6446835.0],
                        [717445.0, 6463649.0],
                        [709251.0, 6464988.0],
                        [708104.0, 6472781.0],
                        [701310.0, 6465307.0],
                        [695974.0, 6467752.0],
                        [693859.0, 6474045.0],
                        [688449.0, 6477003.0],
                        [677684.0, 6475835.0],
                        [672750.0, 6482640.0],
                        [661594.0, 6486680.0],
                        [659915.0, 6480065.0],
                        [656321.0, 6476249.0],
                        [651369.0, 6479623.0],
                        [649118.0, 6470007.0],
                        [642886.0, 6465907.0],
                        [636846.0, 6458269.0],
                        [638218.0, 6451518.0],
                        [634831.0, 6442812.0],
                        [628772.0, 6440050.0],
                        [631663.0, 6432186.0],
                        [626129.0, 6431248.0],
                        [628463.0, 6419614.0],
                        [634482.0, 6410441.0],
                        [633003.0, 6406356.0],
                        [634129.0, 6393565.0],
                        [637122.0, 6391031.0],
                        [637228.0, 6394175.0],
                        [646639.0, 6396959.0],
                        [655192.0, 6393469.0],
                        [664849.0, 6402561.0],
                        [665404.0, 6408608.0],
                        [668313.0, 6410487.0],
                        [668604.0, 6416079.0],
                        [676829.0, 6423158.0],
                        [679353.0, 6426925.0],
                        [684359.0, 6419403.0],
                        [688126.0, 6419157.0],
                        [690477.0, 6411547.0],
                        [694820.0, 6408897.0],
                        [693924.0, 6403282.0],
                        [698547.0, 6393953.0],
                        [704864.0, 6413115.0],
                        [707862.0, 6414941.0],
                        [708330.0, 6420849.0],
                        [714401.0, 6418301.0],
                        [719705.0, 6424147.0],
                        [728488.0, 6430309.0],
                    ]
                ],
            },
        },
        79: {
            "attributes": {
                "CODE_DEPT": "34",
                "NOM_DEPT": "HERAULT",
                "POPULATION": 1144892,
                "DENSITY": 183.74,
            },
            "geometry": {
                "type": "Polygon",
                "coordinates": [
                    [
                        [664821.0, 6258302.0],
                        [662679.0, 6249784.0],
                        [667653.0, 6244475.0],
                        [681495.0, 6239871.0],
                        [686427.0, 6247043.0],
                        [700353.0, 6246775.0],
                        [700385.0, 6243263.0],
                        [711963.0, 6238657.0],
                        [716336.0, 6238907.0],
                        [719561.0, 6234874.0],
                        [727933.0, 6241307.0],
                        [734945.0, 6243544.0],
                        [741504.0, 6241707.0],
                        [748880.0, 6250885.0],
                        [753675.0, 6255020.0],
                        [764523.0, 6260540.0],
                        [773373.0, 6269062.0],
                        [781738.0, 6273121.0],
                        [788998.0, 6273432.0],
                        [792922.0, 6276955.0],
                        [796379.0, 6284647.0],
                        [792244.0, 6293431.0],
                        [780634.0, 6301895.0],
                        [773726.0, 6310049.0],
                        [766790.0, 6307842.0],
                        [766255.0, 6313712.0],
                        [763184.0, 6318967.0],
                        [758340.0, 6319159.0],
                        [750088.0, 6313306.0],
                        [746263.0, 6307559.0],
                        [742673.0, 6306434.0],
                        [734096.0, 6312602.0],
                        [728786.0, 6312824.0],
                        [722102.0, 6311077.0],
                        [716344.0, 6301672.0],
                        [704815.0, 6303628.0],
                        [704898.0, 6288229.0],
                        [698819.0, 6289943.0],
                        [694796.0, 6288406.0],
                        [693221.0, 6284557.0],
                        [680178.0, 6279485.0],
                        [676690.0, 6282993.0],
                        [671212.0, 6283521.0],
                        [668935.0, 6274250.0],
                        [672394.0, 6269695.0],
                        [672444.0, 6264623.0],
                        [668090.0, 6259189.0],
                        [664821.0, 6258302.0],
                    ]
                ],
            },
        },
        80: {
      