# Copyright (C) 2021 Intel Corporation
# SPDX-License-Identifier: GPL-3.0-or-later


"""
CVE checker for libnss

References:
http://www.cvedetails.com/vulnerability-list/vendor_id-452/product_id-4052/Mozilla-Network-Security-Services.html

RSS feed: http://www.cvedetails.com/vulnerability-feed.php?vendor_id=452&product_id=4052&version_id=&orderby=3&cvssscoremin=0
"""
from cve_bin_tool.checkers import Checker


class LibnssChecker(Checker):
    CONTAINS_PATTERNS = [
        r"Client authentication failed: private key in key database does not match public key in certificate database.",
        r"The next protocol negotiation extension was enabled, but the callback was cleared prior to being needed.",
        r"# SSL/TLS secrets log file, generated by NSS",
        r"Header: NSS ",
        r"Version: NSS ",
    ]
    FILENAME_PATTERNS = [r"libnss.so.", r"libssl3.so"]
    VERSION_PATTERNS = [
        r"\$Header: NSS ([01234]+\.[0-9]+) ",
        r"\$Header: NSS ([01234]+\.[0-9]+\.[0-9]+) ",
        r"\$Header: NSS ([01234]+\.[0-9]+\.[0-9]+)\.[0-9]+ ",
        r"Version: NSS ([01234]+\.[0-9]+) Basic",
        r"Version: NSS ([01234]+\.[0-9]+\.[0-9]+) Basic",
        r"Version: NSS ([01234]+\.[0-9]+\.[0-9]+)\.[0-9]+ Basic",
        r"Version: NSS (\d+(?:\.\d+)+)",
        r"\@\(#\)NSS ([01234]+\.[0-9]+) Basic",
        r"\@\(#\)NSS ([01234]+\.[0-9]+\.[0-9]+) Basic",
        r"\@\(#\)NSS ([01234]+\.[0-9]+\.[0-9]+)\.[0-9]+ Basic",
    ]
    VENDOR_PRODUCT = [("mozilla", "network_security_services")]
