/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.JaiI18N;
import javax.media.jai.operator.ScalePropertyGenerator;

public class ScaleDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Scale"}, {"LocalName", "Scale"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("ScaleDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/ScaleDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("ScaleDescriptor1")}, {"arg1Desc", JaiI18N.getString("ScaleDescriptor2")}, {"arg2Desc", JaiI18N.getString("ScaleDescriptor3")}, {"arg3Desc", JaiI18N.getString("ScaleDescriptor4")}, {"arg4Desc", JaiI18N.getString("ScaleDescriptor5")}};
    private static final Class[] paramClasses = new Class[]{Float.class, Float.class, Float.class, Float.class, Interpolation.class};
    private static final String[] paramNames = new String[]{"xScale", "yScale", "xTrans", "yTrans", "interpolation"};
    private static final Object[] paramDefaults = new Object[]{new Float(1.0f), new Float(1.0f), new Float(0.0f), new Float(0.0f), Interpolation.getInstance(0)};

    public ScaleDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    public boolean isRenderableSupported() {
        return true;
    }

    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] propertyGeneratorArray = new PropertyGenerator[]{new ScalePropertyGenerator()};
        return propertyGeneratorArray;
    }

    protected boolean validateParameters(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateParameters(parameterBlock, stringBuffer)) {
            return false;
        }
        float f = parameterBlock.getFloatParameter(0);
        float f2 = parameterBlock.getFloatParameter(1);
        if (f <= 0.0f || f2 <= 0.0f) {
            stringBuffer.append(this.getName() + " " + JaiI18N.getString("ScaleDescriptor6"));
            return false;
        }
        return true;
    }

    public Number getParamMinValue(int n) {
        if (n == 0 || n == 1) {
            return new Float(0.0f);
        }
        if (n == 2 || n == 3) {
            return new Float(-3.4028235E38f);
        }
        if (n == 4) {
            return null;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static RenderedOp create(RenderedImage renderedImage, Float f, Float f2, Float f3, Float f4, Interpolation interpolation, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Scale", "rendered");
        parameterBlockJAI.setSource("source0", renderedImage);
        parameterBlockJAI.setParameter("xScale", f);
        parameterBlockJAI.setParameter("yScale", f2);
        parameterBlockJAI.setParameter("xTrans", f3);
        parameterBlockJAI.setParameter("yTrans", f4);
        parameterBlockJAI.setParameter("interpolation", interpolation);
        return JAI.create("Scale", parameterBlockJAI, renderingHints);
    }

    public static RenderableOp createRenderable(RenderableImage renderableImage, Float f, Float f2, Float f3, Float f4, Interpolation interpolation, RenderingHints renderingHints) {
        ParameterBlockJAI parameterBlockJAI = new ParameterBlockJAI("Scale", "renderable");
        parameterBlockJAI.setSource("source0", renderableImage);
        parameterBlockJAI.setParameter("xScale", f);
        parameterBlockJAI.setParameter("yScale", f2);
        parameterBlockJAI.setParameter("xTrans", f3);
        parameterBlockJAI.setParameter("yTrans", f4);
        parameterBlockJAI.setParameter("interpolation", interpolation);
        return JAI.createRenderable("Scale", parameterBlockJAI, renderingHints);
    }
}

