/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import com.sun.media.jai.util.PropertyGeneratorImpl;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.WarpOpImage;

class FilteredSubsamplePropertyGenerator
extends PropertyGeneratorImpl {
    public FilteredSubsamplePropertyGenerator() {
        super(new String[]{"FilteredSubsample"}, new Class[]{Boolean.TYPE}, new Class[]{RenderedOp.class, RenderableOp.class});
    }

    public Object getProperty(String string, Object object) {
        this.validate(string, object);
        if (object instanceof RenderedOp && string.equalsIgnoreCase("roi")) {
            RenderedOp renderedOp = (RenderedOp)object;
            ParameterBlock parameterBlock = renderedOp.getParameterBlock();
            RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
            Object object2 = renderedImage.getProperty("ROI");
            if (object2 == null || object2.equals(Image.UndefinedProperty) || !(object2 instanceof ROI)) {
                return null;
            }
            ROI rOI = (ROI)object2;
            Rectangle rectangle = null;
            PlanarImage planarImage = renderedOp.getRendering();
            if (planarImage instanceof WarpOpImage && !((OpImage)planarImage).hasExtender(0)) {
                WarpOpImage warpOpImage = (WarpOpImage)planarImage;
                rectangle = new Rectangle(renderedImage.getMinX() + warpOpImage.getLeftPadding(), renderedImage.getMinY() + warpOpImage.getTopPadding(), renderedImage.getWidth() - warpOpImage.getWidth() + 1, renderedImage.getHeight() - warpOpImage.getHeight() + 1);
            } else {
                rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            }
            if (!rectangle.contains(rOI.getBounds())) {
                rOI = rOI.intersect(new ROIShape(rectangle));
            }
            float f = 1.0f / (float)parameterBlock.getIntParameter(1);
            float f2 = 1.0f / (float)parameterBlock.getIntParameter(2);
            AffineTransform affineTransform = new AffineTransform((double)f, 0.0, 0.0, (double)f2, 0.0, 0.0);
            ROI rOI2 = rOI.transform(affineTransform);
            Rectangle rectangle2 = renderedOp.getBounds();
            if (!rectangle2.contains(rOI2.getBounds())) {
                rOI2 = rOI2.intersect(new ROIShape(rectangle2));
            }
            return rOI2;
        }
        return null;
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[]{"roi"};
        return stringArray;
    }
}

