/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.media.jai.JaiI18N;
import javax.media.jai.WarpPolynomial;

public final class WarpAffine
extends WarpPolynomial {
    private float c1;
    private float c2;
    private float c3;
    private float c4;
    private float c5;
    private float c6;
    private float invc1;
    private float invc2;
    private float invc3;
    private float invc4;
    private float invc5;
    private float invc6;
    private AffineTransform transform;
    private AffineTransform invTransform;

    private static final float[] xCoeffsHelper(AffineTransform affineTransform) {
        float[] fArray = new float[]{(float)affineTransform.getTranslateX(), (float)affineTransform.getScaleX(), (float)affineTransform.getShearX()};
        return fArray;
    }

    private static final float[] yCoeffsHelper(AffineTransform affineTransform) {
        float[] fArray = new float[]{(float)affineTransform.getTranslateY(), (float)affineTransform.getShearY(), (float)affineTransform.getScaleY()};
        return fArray;
    }

    public WarpAffine(float[] fArray, float[] fArray2, float f, float f2, float f3, float f4) {
        super(fArray, fArray2, f, f2, f3, f4);
        if (fArray.length != 3 || fArray2.length != 3) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpAffine0"));
        }
        this.c1 = fArray[0];
        this.c2 = fArray[1];
        this.c3 = fArray[2];
        this.c4 = fArray2[0];
        this.c5 = fArray2[1];
        this.c6 = fArray2[2];
        this.transform = this.getTransform();
        try {
            this.invTransform = this.transform.createInverse();
            this.invc1 = (float)this.invTransform.getTranslateX();
            this.invc2 = (float)this.invTransform.getScaleX();
            this.invc3 = (float)this.invTransform.getShearX();
            this.invc4 = (float)this.invTransform.getTranslateY();
            this.invc5 = (float)this.invTransform.getShearY();
            this.invc6 = (float)this.invTransform.getScaleY();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.invTransform = null;
        }
    }

    public WarpAffine(float[] fArray, float[] fArray2) {
        this(fArray, fArray2, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public WarpAffine(AffineTransform affineTransform, float f, float f2, float f3, float f4) {
        this(WarpAffine.xCoeffsHelper(affineTransform), WarpAffine.yCoeffsHelper(affineTransform), f, f2, f3, f4);
    }

    public WarpAffine(AffineTransform affineTransform) {
        this(affineTransform, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.c2, this.c5, this.c3, this.c6, this.c1, this.c4);
    }

    public float[] warpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        if (fArray == null) {
            fArray = new float[(n3 + n5 - 1) / n5 * ((n4 + n6 - 1) / n6) * 2];
        }
        float f = (float)n5 * this.preScaleX;
        float f2 = this.c2 * f * this.postScaleX;
        float f3 = this.c5 * f * this.postScaleY;
        float f4 = ((float)n + 0.5f) * this.preScaleX;
        n3 += n;
        n4 += n2;
        int n7 = 0;
        for (int i = n2; i < n4; i += n6) {
            float f5 = ((float)i + 0.5f) * this.preScaleY;
            float f6 = (this.c1 + this.c2 * f4 + this.c3 * f5) * this.postScaleX - 0.5f;
            float f7 = (this.c4 + this.c5 * f4 + this.c6 * f5) * this.postScaleY - 0.5f;
            for (int j = n; j < n3; j += n5) {
                fArray[n7++] = f6;
                fArray[n7++] = f7;
                f6 += f2;
                f7 += f3;
            }
        }
        return fArray;
    }

    public Rectangle mapDestRect(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        float[] fArray = this.mapDestPoint(n, n3);
        float f = fArray[0];
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[1];
        fArray = this.mapDestPoint(n2, n3);
        f = Math.min(f, fArray[0]);
        f2 = Math.max(f2, fArray[0]);
        f3 = Math.min(f3, fArray[1]);
        f4 = Math.max(f4, fArray[1]);
        fArray = this.mapDestPoint(n, n4);
        f = Math.min(f, fArray[0]);
        f2 = Math.max(f2, fArray[0]);
        f3 = Math.min(f3, fArray[1]);
        f4 = Math.max(f4, fArray[1]);
        fArray = this.mapDestPoint(n2, n4);
        f = Math.min(f, fArray[0]);
        f2 = Math.max(f2, fArray[0]);
        f3 = Math.min(f3, fArray[1]);
        f4 = Math.max(f4, fArray[1]);
        int n5 = (int)Math.floor(f);
        int n6 = (int)Math.floor(f3);
        int n7 = (int)Math.ceil(f2 - (float)n5);
        int n8 = (int)Math.ceil(f4 - (float)n6);
        return new Rectangle(n5, n6, n7, n8);
    }

    public Rectangle mapSourceRect(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.invTransform == null) {
            return null;
        }
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        float[] fArray = this.mapSrcPoint(n, n3);
        float f = fArray[0];
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[1];
        fArray = this.mapSrcPoint(n2, n3);
        f = Math.min(f, fArray[0]);
        f2 = Math.max(f2, fArray[0]);
        f3 = Math.min(f3, fArray[1]);
        f4 = Math.max(f4, fArray[1]);
        fArray = this.mapSrcPoint(n, n4);
        f = Math.min(f, fArray[0]);
        f2 = Math.max(f2, fArray[0]);
        f3 = Math.min(f3, fArray[1]);
        f4 = Math.max(f4, fArray[1]);
        fArray = this.mapSrcPoint(n2, n4);
        f = Math.min(f, fArray[0]);
        f2 = Math.max(f2, fArray[0]);
        f3 = Math.min(f3, fArray[1]);
        f4 = Math.max(f4, fArray[1]);
        int n5 = (int)Math.floor(f);
        int n6 = (int)Math.floor(f3);
        int n7 = (int)Math.ceil(f2 - (float)n5);
        int n8 = (int)Math.ceil(f4 - (float)n6);
        return new Rectangle(n5, n6, n7, n8);
    }

    private float[] mapDestPoint(int n, int n2) {
        float f = ((float)n + 0.5f) * this.preScaleX;
        float f2 = ((float)n2 + 0.5f) * this.preScaleY;
        float[] fArray = new float[]{(this.c1 + this.c2 * f + this.c3 * f2) * this.postScaleX - 0.5f, (this.c4 + this.c5 * f + this.c6 * f2) * this.postScaleY - 0.5f};
        return fArray;
    }

    private float[] mapSrcPoint(int n, int n2) {
        float f = ((float)n + 0.5f) * this.preScaleX;
        float f2 = ((float)n2 + 0.5f) * this.preScaleY;
        float[] fArray = new float[]{(this.invc1 + this.invc2 * f + this.invc3 * f2) * this.postScaleX - 0.5f, (this.invc4 + this.invc5 * f + this.invc6 * f2) * this.postScaleY - 0.5f};
        return fArray;
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        double d = (point2D.getX() + 0.5) * (double)this.preScaleX;
        double d2 = (point2D.getY() + 0.5) * (double)this.preScaleY;
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(((double)this.c1 + (double)this.c2 * d + (double)this.c3 * d2) * (double)this.postScaleX - 0.5, ((double)this.c4 + (double)this.c5 * d + (double)this.c6 * d2) * (double)this.postScaleY - 0.5);
        return point2D2;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.invTransform == null) {
            return null;
        }
        double d = (point2D.getX() + 0.5) / (double)this.postScaleX;
        double d2 = (point2D.getY() + 0.5) / (double)this.postScaleY;
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.setLocation(((double)this.invc1 + (double)this.invc2 * d + (double)this.invc3 * d2) / (double)this.preScaleX - 0.5, ((double)this.invc4 + (double)this.invc5 * d + (double)this.invc6 * d2) / (double)this.preScaleY - 0.5);
        return point2D2;
    }
}

