/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.CaselessStringArrayTable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.JaiI18N;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.util.Range;

public class ParameterListDescriptorImpl
implements ParameterListDescriptor,
Serializable {
    private int numParams;
    private String[] paramNames;
    private Class[] paramClasses;
    private Object[] paramDefaults;
    private Object[] validParamValues;
    private CaselessStringArrayTable paramIndices;
    private Object descriptor;
    private boolean validParamsInitialized = false;

    public static Set getEnumeratedValues(Object object, Class clazz) {
        if (object == null || clazz == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!EnumeratedParameter.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("ParameterListDescriptorImpl10", new Object[]{clazz.getName()}));
        }
        Field[] fieldArray = object.getClass().getDeclaredFields();
        if (fieldArray == null) {
            return null;
        }
        int n = fieldArray.length;
        HashSet<Object> hashSet = null;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            int n2 = field.getModifiers();
            if (!Modifier.isPublic(n2) || !Modifier.isStatic(n2) || !Modifier.isFinal(n2)) continue;
            Object object2 = null;
            try {
                object2 = field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!clazz.isInstance(object2)) continue;
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
            }
            if (hashSet.contains(object2)) {
                throw new UnsupportedOperationException(JaiI18N.getString("ParameterListDescriptorImpl0"));
            }
            hashSet.add(object2);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValidParamValue(int n) {
        if (this.validParamsInitialized) {
            return this.validParamValues[n];
        }
        ParameterListDescriptorImpl parameterListDescriptorImpl = this;
        synchronized (parameterListDescriptorImpl) {
            if (this.validParamValues == null) {
                this.validParamValues = new Object[this.numParams];
            }
            Class clazz = EnumeratedParameter.class;
            for (int i = 0; i < this.numParams; ++i) {
                if (this.validParamValues[i] != null || !clazz.isAssignableFrom(this.paramClasses[i])) continue;
                this.validParamValues[i] = ParameterListDescriptorImpl.getEnumeratedValues(this.descriptor, this.paramClasses[i]);
            }
        }
        this.validParamsInitialized = true;
        return this.validParamValues[n];
    }

    public ParameterListDescriptorImpl() {
        this.numParams = 0;
        this.paramNames = null;
        this.paramClasses = null;
        this.paramDefaults = null;
        this.paramIndices = new CaselessStringArrayTable();
        this.validParamValues = null;
    }

    public ParameterListDescriptorImpl(Object object, String[] stringArray, Class[] classArray, Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2 = n = stringArray == null ? 0 : stringArray.length;
        if (objectArray != null && objectArray.length != n) {
            throw new IllegalArgumentException("paramDefaults" + JaiI18N.getString("ParameterListDescriptorImpl1"));
        }
        if (objectArray2 != null && objectArray2.length != n) {
            throw new IllegalArgumentException("validParamValues" + JaiI18N.getString("ParameterListDescriptorImpl2"));
        }
        this.descriptor = object;
        if (n == 0) {
            if (classArray != null && classArray.length != 0) {
                throw new IllegalArgumentException("paramClasses" + JaiI18N.getString("ParameterListDescriptorImpl3"));
            }
            this.numParams = 0;
            this.paramNames = null;
            this.paramClasses = null;
            this.paramDefaults = null;
            this.paramIndices = new CaselessStringArrayTable();
            this.validParamValues = null;
        } else {
            int n3;
            if (classArray == null || classArray.length != n) {
                throw new IllegalArgumentException("paramClasses" + JaiI18N.getString("ParameterListDescriptorImpl3"));
            }
            this.numParams = n;
            this.paramNames = stringArray;
            this.paramClasses = classArray;
            this.validParamValues = objectArray2;
            if (objectArray == null) {
                this.paramDefaults = new Object[n];
                for (n3 = 0; n3 < n; ++n3) {
                    this.paramDefaults[n3] = ParameterListDescriptor.NO_PARAMETER_DEFAULT;
                }
            } else {
                this.paramDefaults = objectArray;
                for (n3 = 0; n3 < n; ++n3) {
                    if (objectArray[n3] == null || objectArray[n3] == ParameterListDescriptor.NO_PARAMETER_DEFAULT || classArray[n3].isInstance(objectArray[n3])) continue;
                    throw new IllegalArgumentException(JaiI18N.formatMsg("ParameterListDescriptorImpl4", new Object[]{objectArray[n3].getClass().getName(), classArray[n3].getName(), stringArray[n3]}));
                }
            }
            if (objectArray2 != null) {
                Class clazz = EnumeratedParameter.class;
                for (int i = 0; i < n; ++i) {
                    if (objectArray2[i] == null) continue;
                    if (clazz.isAssignableFrom(classArray[i])) {
                        if (objectArray2[i] instanceof Set) continue;
                        throw new IllegalArgumentException(JaiI18N.formatMsg("ParameterListDescriptorImpl5", new Object[]{stringArray[i]}));
                    }
                    if (objectArray2[i] instanceof Range) {
                        Range range = (Range)objectArray2[i];
                        if (classArray[i].isAssignableFrom(range.getElementClass())) continue;
                        throw new IllegalArgumentException(JaiI18N.formatMsg("ParameterListDescriptorImpl6", new Object[]{range.getElementClass().getName(), classArray[i].getName(), stringArray[i]}));
                    }
                    if (classArray[i].isInstance(objectArray2[i])) continue;
                    throw new IllegalArgumentException(JaiI18N.formatMsg("ParameterListDescriptorImpl7", new Object[]{objectArray2[i].getClass().getName(), classArray[i].getName(), stringArray[i]}));
                }
            }
            this.paramIndices = new CaselessStringArrayTable(stringArray);
        }
    }

    public int getNumParameters() {
        return this.numParams;
    }

    public Class[] getParamClasses() {
        return this.paramClasses;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public Object[] getParamDefaults() {
        return this.paramDefaults;
    }

    public Object getParamDefaultValue(String string) {
        return this.paramDefaults[this.paramIndices.indexOf(string)];
    }

    public Range getParamValueRange(String string) {
        Object object = this.getValidParamValue(this.paramIndices.indexOf(string));
        if (object == null || object instanceof Range) {
            return (Range)object;
        }
        return null;
    }

    public String[] getEnumeratedParameterNames() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.numParams; ++i) {
            if (!(class$javax$media$jai$EnumeratedParameter == null ? ParameterListDescriptorImpl.class$("javax.media.jai.EnumeratedParameter") : class$javax$media$jai$EnumeratedParameter).isAssignableFrom(this.paramClasses[i])) continue;
            vector.add(this.paramNames[i]);
        }
        if (vector.size() <= 0) {
            return null;
        }
        return vector.toArray(new String[0]);
    }

    public EnumeratedParameter[] getEnumeratedParameterValues(String string) {
        int n;
        if (!EnumeratedParameter.class.isAssignableFrom(this.paramClasses[n = this.paramIndices.indexOf(string)])) {
            throw new IllegalArgumentException(string + ":" + JaiI18N.getString("ParameterListDescriptorImpl8"));
        }
        Set set = (Set)this.getValidParamValue(n);
        if (set == null) {
            return null;
        }
        return set.toArray(new EnumeratedParameter[0]);
    }

    public boolean isParameterValueValid(String string, Object object) {
        int n = this.paramIndices.indexOf(string);
        if (object == null && this.paramDefaults[n] == null) {
            return true;
        }
        if (object != null && !this.paramClasses[n].isInstance(object)) {
            throw new IllegalArgumentException(JaiI18N.formatMsg("ParameterListDescriptorImpl9", new Object[]{object.getClass().getName(), this.paramClasses[n].getName(), string}));
        }
        Object object2 = this.getValidParamValue(n);
        if (object2 == null) {
            return true;
        }
        if (object2 instanceof Range) {
            return ((Range)object2).contains((Comparable)object);
        }
        if (object2 instanceof Set) {
            return ((Set)object2).contains(object);
        }
        return object == object2;
    }
}

