/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.DataBuffer;
import javax.media.jai.JaiI18N;

public class DataBufferFloat
extends DataBuffer {
    protected float[][] bankdata;
    protected float[] data;

    public DataBufferFloat(int n) {
        super(4, n);
        this.data = new float[n];
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(int n, int n2) {
        super(4, n, n2);
        this.bankdata = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            this.bankdata[i] = new float[n];
        }
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[] fArray, int n) {
        super(4, n);
        if (fArray.length < n) {
            throw new RuntimeException(JaiI18N.getString("DataBuffer0"));
        }
        this.data = fArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[] fArray, int n, int n2) {
        super(4, n, 1, n2);
        if (fArray.length < n) {
            throw new RuntimeException(JaiI18N.getString("DataBuffer1"));
        }
        this.data = fArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[][] fArray, int n) {
        super(4, n, fArray.length);
        this.bankdata = fArray;
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[][] fArray, int n, int[] nArray) {
        super(4, n, fArray.length, nArray);
        this.bankdata = fArray;
        this.data = this.bankdata[0];
    }

    public float[] getData() {
        return this.data;
    }

    public float[] getData(int n) {
        return this.bankdata[n];
    }

    public float[][] getBankData() {
        return this.bankdata;
    }

    public int getElem(int n) {
        return Math.round(this.data[n + this.offset]);
    }

    public int getElem(int n, int n2) {
        return Math.round(this.bankdata[n][n2 + this.offsets[n]]);
    }

    public void setElem(int n, int n2) {
        this.data[n + this.offset] = n2;
    }

    public void setElem(int n, int n2, int n3) {
        this.bankdata[n][n2 + this.offsets[n]] = n3;
    }

    public float getElemFloat(int n) {
        return this.data[n + this.offset];
    }

    public float getElemFloat(int n, int n2) {
        return this.bankdata[n][n2 + this.offsets[n]];
    }

    public void setElemFloat(int n, float f) {
        this.data[n + this.offset] = f;
    }

    public void setElemFloat(int n, int n2, float f) {
        this.bankdata[n][n2 + this.offsets[n]] = f;
    }

    public double getElemDouble(int n) {
        return this.data[n + this.offset];
    }

    public double getElemDouble(int n, int n2) {
        return this.bankdata[n][n2 + this.offsets[n]];
    }

    public void setElemDouble(int n, double d) {
        this.data[n + this.offset] = (float)d;
    }

    public void setElemDouble(int n, int n2, double d) {
        this.bankdata[n][n2 + this.offsets[n]] = (float)d;
    }
}

