/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;

public abstract class CRIFImpl
implements ContextualRenderedImageFactory {
    protected String operationName = null;

    public CRIFImpl() {
        this.operationName = null;
    }

    public CRIFImpl(String string) {
        this.operationName = string;
    }

    public abstract RenderedImage create(ParameterBlock var1, RenderingHints var2);

    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        RenderingHints renderingHints = renderContext.getRenderingHints();
        if (this.operationName != null) {
            Object object;
            PlanarImage planarImage;
            OperationRegistry operationRegistry;
            OperationRegistry operationRegistry2 = operationRegistry = renderingHints == null ? null : (OperationRegistry)renderingHints.get(JAI.KEY_OPERATION_REGISTRY);
            if (operationRegistry == null) {
                planarImage = JAI.create(this.operationName, parameterBlock, renderingHints);
            } else {
                OperationDescriptor operationDescriptor = (OperationDescriptor)operationRegistry.getDescriptor(OperationDescriptor.class, this.operationName);
                if (operationDescriptor == null) {
                    throw new IllegalArgumentException(this.operationName + ": " + JaiI18N.getString("JAI0"));
                }
                if (!operationDescriptor.isModeSupported("rendered")) {
                    throw new IllegalArgumentException(this.operationName + ": " + JaiI18N.getString("JAI1"));
                }
                if (!RenderedImage.class.isAssignableFrom(operationDescriptor.getDestClass("rendered"))) {
                    throw new IllegalArgumentException(this.operationName + ": " + JaiI18N.getString("JAI2"));
                }
                object = new StringBuffer();
                if (!operationDescriptor.validateArguments("rendered", parameterBlock = (ParameterBlock)parameterBlock.clone(), (StringBuffer)object)) {
                    throw new IllegalArgumentException(((StringBuffer)object).toString());
                }
                planarImage = new RenderedOp(operationRegistry, this.operationName, parameterBlock, renderingHints);
            }
            if (planarImage != null) {
                if (planarImage instanceof RenderedOp) {
                    try {
                        planarImage = planarImage.getRendering();
                    }
                    catch (Exception exception) {
                        object = ImageUtil.getImagingListener(renderingHints);
                        String string = JaiI18N.getString("CRIFImpl0") + this.operationName;
                        object.errorOccurred(string, exception, this, false);
                    }
                }
                return planarImage;
            }
        }
        return this.create(parameterBlock, renderingHints);
    }

    public RenderContext mapRenderContext(int n, RenderContext renderContext, ParameterBlock parameterBlock, RenderableImage renderableImage) {
        return renderContext;
    }

    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        Rectangle2D.Float float_;
        int n = parameterBlock.getNumSources();
        if (n == 0) {
            return null;
        }
        RenderableImage renderableImage = parameterBlock.getRenderableSource(0);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        for (int i = 1; i < n && !(float_2 = (Rectangle2D.Float)float_2.createIntersection(float_ = new Rectangle2D.Float((renderableImage = parameterBlock.getRenderableSource(i)).getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight()))).isEmpty(); ++i) {
        }
        return float_2;
    }

    public Object getProperty(ParameterBlock parameterBlock, String string) {
        return Image.UndefinedProperty;
    }

    public String[] getPropertyNames() {
        return null;
    }

    public boolean isDynamic() {
        return false;
    }
}

