/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import java.awt.RenderingHints;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.JAI;

public class RenderingHintsProxy
implements Serializable {
    private transient RenderingHints hints;
    private static final Class[] KEY_CLASSES = new Class[]{RenderingHints.class, JAI.class};
    private static final Object[] SUPPRESSED_KEYS = new Object[]{JAI.KEY_OPERATION_REGISTRY, JAI.KEY_TILE_CACHE, JAI.KEY_RETRY_INTERVAL, JAI.KEY_NUM_RETRIES, JAI.KEY_NEGOTIATION_PREFERENCES};
    private static SoftReference suppressedKeyReference = null;
    private static SoftReference hintTableReference = null;

    public RenderingHintsProxy(RenderingHints renderingHints) {
        this.hints = renderingHints;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    private static synchronized Vector getSuppressedKeys() {
        Vector<Object> vector = null;
        if (SUPPRESSED_KEYS != null) {
            Vector<Object> vector2 = vector = suppressedKeyReference != null ? (Vector<Object>)suppressedKeyReference.get() : null;
            if (vector == null) {
                int n = SUPPRESSED_KEYS.length;
                vector = new Vector<Object>(n);
                for (int i = 0; i < n; ++i) {
                    vector.add(SUPPRESSED_KEYS[i]);
                }
                suppressedKeyReference = new SoftReference(vector);
            }
        }
        return vector;
    }

    private static synchronized Hashtable getHintTable() {
        Hashtable<Object, HintElement> hashtable;
        Hashtable<Object, HintElement> hashtable2 = hashtable = hintTableReference != null ? (Hashtable<Object, HintElement>)hintTableReference.get() : null;
        if (hashtable == null) {
            hashtable = new Hashtable<Object, HintElement>();
            for (int i = 0; i < KEY_CLASSES.length; ++i) {
                Class clazz = KEY_CLASSES[i];
                Field[] fieldArray = clazz.getFields();
                for (int j = 0; j < fieldArray.length; ++j) {
                    Field field = fieldArray[j];
                    int n = field.getModifiers();
                    if (!Modifier.isPublic(n) || !Modifier.isStatic(n)) continue;
                    try {
                        Object object = field.get(null);
                        hashtable.put(object, new HintElement(clazz, field));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            hintTableReference = new SoftReference(hashtable);
        }
        return hashtable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Set<Object> set;
        Hashtable<HintElement, HintElement> hashtable = new Hashtable<HintElement, HintElement>();
        if (this.hints != null && !this.hints.isEmpty() && !(set = this.hints.keySet()).isEmpty()) {
            Iterator<Object> iterator = set.iterator();
            Hashtable hashtable2 = RenderingHintsProxy.getHintTable();
            Vector vector = RenderingHintsProxy.getSuppressedKeys();
            while (iterator.hasNext()) {
                HintElement hintElement;
                Object object = iterator.next();
                if (vector != null && vector.indexOf(object) != -1 || (hintElement = (HintElement)hashtable2.get(object)) == null) continue;
                Object object2 = this.hints.get(object);
                HintElement hintElement2 = null;
                try {
                    hintElement2 = new HintElement(object2);
                }
                catch (NotSerializableException notSerializableException) {
                    hintElement2 = (HintElement)hashtable2.get(object2);
                }
                if (hintElement2 == null) continue;
                hashtable.put(hintElement, hintElement2);
            }
        }
        objectOutputStream.writeObject(hashtable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Hashtable hashtable = (Hashtable)objectInputStream.readObject();
        this.hints = new RenderingHints(null);
        if (hashtable.isEmpty()) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            HintElement hintElement = (HintElement)enumeration.nextElement();
            Object object = hintElement.getObject();
            HintElement hintElement2 = (HintElement)hashtable.get(hintElement);
            Object object2 = hintElement2.getObject();
            this.hints.put(object, object2);
        }
    }

    private static class HintElement
    implements Serializable {
        private static final int TYPE_OBJECT = 1;
        private static final int TYPE_FIELD = 2;
        private int type;
        private Object obj;
        private String className;
        private String fieldName;

        public HintElement(Object object) throws NotSerializableException {
            if (!(object instanceof Serializable)) {
                throw new NotSerializableException();
            }
            this.type = 1;
            this.obj = object;
        }

        public HintElement(Class clazz, Field field) {
            this.type = 2;
            this.className = clazz.getName();
            this.fieldName = field.getName();
        }

        public Object getObject() {
            Object object = null;
            if (this.type == 1) {
                object = this.obj;
            } else if (this.type == 2) {
                try {
                    Class<?> clazz = Class.forName(this.className);
                    Field field = clazz.getField(this.fieldName);
                    object = field.get(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return object;
        }
    }
}

