/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.RMIServerProxy;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.remote.RemoteRenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;

public final class JAIRMIUtil {
    public static Vector replaceIdWithSources(Vector vector, Hashtable hashtable, String string, RenderingHints renderingHints) {
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object e = vector.elementAt(i);
            if (e instanceof String) {
                boolean bl;
                object = (String)e;
                int n = ((String)object).indexOf("::");
                boolean bl2 = bl = n != -1;
                if (bl) {
                    vector2.add(new RMIServerProxy((String)object, string, renderingHints));
                    continue;
                }
                vector2.add(hashtable.get(Long.valueOf((String)object)));
                continue;
            }
            object = PlanarImage.wrapRenderedImage((RenderedImage)e);
            vector2.add(object);
        }
        return vector2;
    }

    public static Vector replaceSourcesWithId(Vector vector, String string) {
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            RenderedImage renderedImage;
            Object e = vector.elementAt(i);
            if (e instanceof RMIServerProxy) {
                renderedImage = (RMIServerProxy)e;
                if (((PlanarImageServerProxy)renderedImage).getServerName().equalsIgnoreCase(string)) {
                    vector2.add(((RMIServerProxy)renderedImage).getRMIID().toString());
                    continue;
                }
                object = new String(((PlanarImageServerProxy)renderedImage).getServerName() + "::" + ((RMIServerProxy)renderedImage).getRMIID());
                vector2.add(object);
                continue;
            }
            if (e instanceof RemoteRenderedOp) {
                RenderedImage renderedImage2;
                renderedImage = (RemoteRenderedOp)e;
                object = ((RenderedOp)renderedImage).getRendering();
                if (object instanceof RMIServerProxy) {
                    renderedImage2 = (RMIServerProxy)object;
                    if (((PlanarImageServerProxy)renderedImage2).getServerName().equalsIgnoreCase(string)) {
                        vector2.add(((RMIServerProxy)renderedImage2).getRMIID().toString());
                        continue;
                    }
                    String string2 = new String(((PlanarImageServerProxy)renderedImage2).getServerName() + "::" + ((RMIServerProxy)renderedImage2).getRMIID());
                    vector2.add(string2);
                    continue;
                }
                renderedImage2 = (RenderedImage)object;
                vector2.add(new SerializableRenderedImage(renderedImage2));
                continue;
            }
            if (e instanceof RenderedOp) {
                renderedImage = (RenderedOp)e;
                vector2.add(new SerializableRenderedImage(((RenderedOp)renderedImage).getRendering()));
                continue;
            }
            if (e instanceof Serializable) {
                vector2.add(e);
                continue;
            }
            if (!(e instanceof RenderedImage)) continue;
            renderedImage = (RenderedImage)e;
            vector2.add(new SerializableRenderedImage(renderedImage));
        }
        return vector2;
    }

    public static Object replaceImage(RenderedImage renderedImage, String string) {
        if (renderedImage instanceof RMIServerProxy) {
            RMIServerProxy rMIServerProxy = (RMIServerProxy)renderedImage;
            if (rMIServerProxy.getServerName().equalsIgnoreCase(string)) {
                return "::" + rMIServerProxy.getRMIID();
            }
            return rMIServerProxy.getServerName() + "::" + rMIServerProxy.getRMIID() + ";;" + rMIServerProxy.getOperationName();
        }
        if (renderedImage instanceof RenderedOp) {
            PlanarImage planarImage = ((RenderedOp)renderedImage).getRendering();
            return JAIRMIUtil.replaceImage(planarImage, string);
        }
        if (renderedImage instanceof RenderedImage) {
            if (renderedImage instanceof Serializable) {
                return renderedImage;
            }
            return new SerializableRenderedImage(renderedImage);
        }
        return renderedImage;
    }

    public static void checkClientParameters(ParameterBlock parameterBlock, String string) {
        if (parameterBlock == null) {
            return;
        }
        int n = parameterBlock.getNumParameters();
        Vector<Object> vector = parameterBlock.getParameters();
        for (int i = 0; i < n; ++i) {
            Object object = vector.elementAt(i);
            if (object == null || !(object instanceof RenderedImage)) continue;
            parameterBlock.set(JAIRMIUtil.replaceImage((RenderedImage)object, string), i);
        }
    }

    public static void checkClientParameters(Vector vector, String string) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e == null || !(e instanceof RenderedImage)) continue;
            vector.set(i, JAIRMIUtil.replaceImage((RenderedImage)e, string));
        }
    }

    public static Object replaceStringWithImage(String string, Hashtable hashtable) {
        int n = string.indexOf("::");
        int n2 = string.indexOf(";;");
        if (n == -1) {
            return string;
        }
        if (n2 == -1) {
            Long l = Long.valueOf(string.substring(n + 2));
            return hashtable.get(l);
        }
        Long l = Long.valueOf(string.substring(n + 2, n2));
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2 + 2);
        return new RMIServerProxy(string2 + "::" + l, string3, null);
    }

    public static void checkServerParameters(ParameterBlock parameterBlock, Hashtable hashtable) {
        if (parameterBlock == null) {
            return;
        }
        int n = parameterBlock.getNumParameters();
        Vector<Object> vector = parameterBlock.getParameters();
        for (int i = 0; i < n; ++i) {
            Object object = vector.elementAt(i);
            if (object == null || !(object instanceof String)) continue;
            parameterBlock.set(JAIRMIUtil.replaceStringWithImage((String)object, hashtable), i);
        }
    }

    public static void checkServerParameters(Vector vector, Hashtable hashtable) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object e = vector.elementAt(i);
            if (e == null || !(e instanceof String)) continue;
            vector.set(i, JAIRMIUtil.replaceStringWithImage((String)e, hashtable));
        }
    }
}

