/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.Rational;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.ScaleOpImage;

final class ScaleBilinearOpImage
extends ScaleOpImage {
    private int subsampleBits;
    int one;
    int shift2;
    int round2;
    Rational half = new Rational(1L, 2L);
    long invScaleYInt;
    long invScaleYFrac;
    long invScaleXInt;
    long invScaleXFrac;

    public ScaleBilinearOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, float f, float f2, float f3, float f4, Interpolation interpolation) {
        super(renderedImage, imageLayout, map, true, borderExtender, interpolation, f, f2, f3, f4);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n];
        int[] nArray3 = null;
        int[] nArray4 = null;
        float[] fArray = null;
        float[] fArray2 = null;
        switch (rasterAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                nArray4 = new int[n2];
                nArray3 = new int[n];
                this.preComputePositionsInt(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: 
            case 5: {
                fArray2 = new float[n2];
                fArray = new float[n];
                this.preComputePositionsFloat(rectangle, rectangle2.x, rectangle2.y, n3, n4, nArray2, nArray, fArray, fArray2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, nArray3, nArray4);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, rasterAccessor2, nArray2, nArray, fArray, fArray2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void preComputePositionsInt(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n5;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        long l = n9;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n10 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n8;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n11 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = (n11 - n) * n3;
            nArray3[n5] = (int)((float)l8 / (float)l9 * (float)this.one);
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l8 += l10) < l9) continue;
            ++n11;
            l8 -= l9;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            nArray2[n5] = (n10 - n2) * n4;
            nArray4[n5] = (int)((float)l3 / (float)l4 * (float)this.one);
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l3 += l5) < l4) continue;
            ++n10;
            l3 -= l4;
        }
    }

    private void preComputePositionsFloat(Rectangle rectangle, int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n5;
        int n6 = rectangle.width;
        int n7 = rectangle.height;
        int n8 = rectangle.x;
        int n9 = rectangle.y;
        long l = n9;
        long l2 = 1L;
        l = l * this.transYRationalDenom - this.transYRationalNum * l2;
        l = 2L * l + (l2 *= this.transYRationalDenom);
        l2 *= 2L;
        l *= this.invScaleYRationalNum;
        l = 2L * l - (l2 *= this.invScaleYRationalDenom);
        int n10 = Rational.floor(l, l2 *= 2L);
        long l3 = l % l2;
        if (n10 < 0) {
            l3 = l2 + l3;
        }
        long l4 = l2 * this.invScaleYRationalDenom;
        l3 *= this.invScaleYRationalDenom;
        long l5 = this.invScaleYFrac * l2;
        long l6 = n8;
        long l7 = 1L;
        l6 = l6 * this.transXRationalDenom - this.transXRationalNum * l7;
        l6 = 2L * l6 + (l7 *= this.transXRationalDenom);
        l7 *= 2L;
        l6 *= this.invScaleXRationalNum;
        l6 = 2L * l6 - (l7 *= this.invScaleXRationalDenom);
        int n11 = Rational.floor(l6, l7 *= 2L);
        long l8 = l6 % l7;
        if (n11 < 0) {
            l8 = l7 + l8;
        }
        long l9 = l7 * this.invScaleXRationalDenom;
        l8 *= this.invScaleXRationalDenom;
        long l10 = this.invScaleXFrac * l7;
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = (n11 - n) * n3;
            fArray[n5] = (float)l8 / (float)l9;
            n11 = (int)((long)n11 + this.invScaleXInt);
            if ((l8 += l10) < l9) continue;
            ++n11;
            l8 -= l9;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            nArray2[n5] = (n10 - n2) * n4;
            fArray2[n5] = (float)l3 / (float)l4;
            n10 = (int)((long)n10 + this.invScaleYInt);
            if ((l3 += l5) < l4) continue;
            ++n10;
            l3 -= l4;
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n6; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n9 = nArray5[i];
            int n10 = nArray6[i];
            for (int j = 0; j < n5; ++j) {
                int n11 = n9;
                int n12 = nArray4[j];
                int n13 = nArray2[j] + n10;
                int n14 = n13 + n2;
                for (int k = 0; k < n4; ++k) {
                    int n15 = nArray3[k];
                    int n16 = nArray[k];
                    int n17 = n16 + n;
                    int n18 = byArray4[n16 + n13] & 0xFF;
                    int n19 = byArray4[n17 + n13] & 0xFF;
                    int n20 = byArray4[n16 + n14] & 0xFF;
                    int n21 = byArray4[n17 + n14] & 0xFF;
                    int n22 = (n19 - n18) * n15 + (n18 << this.subsampleBits);
                    int n23 = (n21 - n20) * n15 + (n20 << this.subsampleBits);
                    int n24 = (n23 - n22) * n12 + (n22 << this.subsampleBits) + this.round2 >> this.shift2;
                    byArray3[n11] = (byte)(n24 & 0xFF);
                    n11 += n7;
                }
                n9 += n8;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n6; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n9 = nArray5[i];
            int n10 = nArray6[i];
            for (int j = 0; j < n5; ++j) {
                int n11 = n9;
                int n12 = nArray4[j];
                int n13 = nArray2[j] + n10;
                int n14 = n13 + n2;
                for (int k = 0; k < n4; ++k) {
                    int n15 = nArray3[k];
                    int n16 = nArray[k];
                    int n17 = n16 + n;
                    short s = sArray4[n16 + n13];
                    short s2 = sArray4[n17 + n13];
                    short s3 = sArray4[n16 + n14];
                    short s4 = sArray4[n17 + n14];
                    int n18 = (s2 - s) * n15 + (s << this.subsampleBits);
                    int n19 = (s4 - s3) * n15 + (s3 << this.subsampleBits);
                    int n20 = (n19 - n18) * n12 + (n18 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n11] = (short)n20;
                    n11 += n7;
                }
                n9 += n8;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray5 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray6 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n6; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n9 = nArray5[i];
            int n10 = nArray6[i];
            for (int j = 0; j < n5; ++j) {
                int n11 = n9;
                int n12 = nArray4[j];
                int n13 = nArray2[j] + n10;
                int n14 = n13 + n2;
                for (int k = 0; k < n4; ++k) {
                    int n15 = nArray3[k];
                    int n16 = nArray[k];
                    int n17 = n16 + n;
                    int n18 = sArray4[n16 + n13] & 0xFFFF;
                    int n19 = sArray4[n17 + n13] & 0xFFFF;
                    int n20 = sArray4[n16 + n14] & 0xFFFF;
                    int n21 = sArray4[n17 + n14] & 0xFFFF;
                    int n22 = (n19 - n18) * n15 + (n18 << this.subsampleBits);
                    int n23 = (n21 - n20) * n15 + (n20 << this.subsampleBits);
                    int n24 = (n23 - n22) * n12 + (n22 << this.subsampleBits) + this.round2 >> this.shift2;
                    sArray3[n11] = (short)(n24 & 0xFFFF);
                    n11 += n7;
                }
                n9 += n8;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        int[][] nArray5 = rasterAccessor2.getIntDataArrays();
        int[] nArray6 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        int[][] nArray7 = rasterAccessor.getIntDataArrays();
        int[] nArray8 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        int n9 = 29 - this.subsampleBits;
        for (int i = 0; i < n6; ++i) {
            int[] nArray9 = nArray5[i];
            int[] nArray10 = nArray7[i];
            int n10 = nArray6[i];
            int n11 = nArray8[i];
            for (int j = 0; j < n5; ++j) {
                int n12 = n10;
                int n13 = nArray4[j];
                int n14 = nArray2[j] + n11;
                int n15 = n14 + n2;
                for (int k = 0; k < n4; ++k) {
                    long l;
                    long l2;
                    int n16 = nArray3[k];
                    int n17 = nArray[k];
                    int n18 = n17 + n;
                    int n19 = nArray10[n17 + n14];
                    int n20 = nArray10[n18 + n14];
                    int n21 = nArray10[n17 + n15];
                    int n22 = nArray10[n18 + n15];
                    if ((n19 | n21) >>> n9 == 0) {
                        if ((n20 | n22) >>> n9 == 0) {
                            l2 = (n20 - n19) * n16 + (n19 << this.subsampleBits);
                            l = (n22 - n21) * n16 + (n21 << this.subsampleBits);
                        } else {
                            l2 = ((long)n20 - (long)n19) * (long)n16 + (long)(n19 << this.subsampleBits);
                            l = ((long)n22 - (long)n21) * (long)n16 + (long)(n21 << this.subsampleBits);
                        }
                    } else {
                        l2 = ((long)n20 - (long)n19) * (long)n16 + ((long)n19 << this.subsampleBits);
                        l = ((long)n22 - (long)n21) * (long)n16 + ((long)n21 << this.subsampleBits);
                    }
                    nArray9[n12] = (int)((l - l2) * (long)n13 + (l2 << this.subsampleBits) + (long)this.round2 >> this.shift2);
                    n12 += n7;
                }
                n10 += n8;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        float[][] fArray3 = rasterAccessor2.getFloatDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        float[][] fArray4 = rasterAccessor.getFloatDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n6; ++i) {
            float[] fArray5 = fArray3[i];
            float[] fArray6 = fArray4[i];
            int n9 = nArray3[i];
            int n10 = nArray4[i];
            for (int j = 0; j < n5; ++j) {
                int n11 = n9;
                float f = fArray2[j];
                int n12 = nArray2[j] + n10;
                int n13 = n12 + n2;
                for (int k = 0; k < n4; ++k) {
                    float f2 = fArray[k];
                    int n14 = nArray[k];
                    int n15 = n14 + n;
                    float f3 = fArray6[n14 + n12];
                    float f4 = fArray6[n15 + n12];
                    float f5 = fArray6[n14 + n13];
                    float f6 = fArray6[n15 + n13];
                    float f7 = (f4 - f3) * f2 + f3;
                    float f8 = (f6 - f5) * f2 + f5;
                    fArray5[n11] = (f8 - f7) * f + f7;
                    n11 += n7;
                }
                n9 += n8;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, RasterAccessor rasterAccessor2, int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        int n = rasterAccessor.getPixelStride();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = (rasterAccessor.getWidth() - 1) * n;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        int n6 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        boolean bl = false;
        for (int i = 0; i < n6; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n9 = nArray3[i];
            int n10 = nArray4[i];
            for (int j = 0; j < n5; ++j) {
                int n11 = n9;
                double d = fArray2[j];
                int n12 = nArray2[j] + n10;
                int n13 = n12 + n2;
                for (int k = 0; k < n4; ++k) {
                    double d2 = fArray[k];
                    int n14 = nArray[k];
                    int n15 = n14 + n;
                    double d3 = dArray4[n14 + n12];
                    double d4 = dArray4[n15 + n12];
                    double d5 = dArray4[n14 + n13];
                    double d6 = dArray4[n15 + n13];
                    double d7 = (d4 - d3) * d2 + d3;
                    double d8 = (d6 - d5) * d2 + d5;
                    dArray3[n11] = (d8 - d7) * d + d7;
                    n11 += n7;
                }
                n9 += n8;
            }
        }
    }
}

