/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class OverlayOpImage
extends PointOpImage {
    private static ImageLayout layoutHelper(ImageLayout imageLayout, Vector vector, Map map) {
        if (imageLayout != null) {
            imageLayout = (ImageLayout)imageLayout.clone();
            imageLayout.unsetImageBounds();
        }
        return imageLayout;
    }

    public OverlayOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, OverlayOpImage.layoutHelper(imageLayout, OverlayOpImage.vectorize(renderedImage, renderedImage2), map), map, true);
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (this.sampleModel.getTransferType() != sampleModel.getTransferType() || this.sampleModel.getNumBands() != sampleModel.getNumBands()) {
            this.sampleModel = sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        this.minX = renderedImage.getMinX();
        this.minY = renderedImage.getMinY();
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
    }

    public Raster computeTile(int n, int n2) {
        WritableRaster writableRaster = this.createTile(n, n2);
        Rectangle rectangle = writableRaster.getBounds().intersection(this.getBounds());
        PlanarImage planarImage = this.getSource(0);
        PlanarImage planarImage2 = this.getSource(1);
        Rectangle rectangle2 = planarImage.getBounds();
        Rectangle rectangle3 = planarImage2.getBounds();
        Raster[] rasterArray = new Raster[1];
        if (rectangle3.contains(rectangle)) {
            rasterArray[0] = planarImage2.getData(rectangle);
            this.computeRect(rasterArray, writableRaster, rectangle);
            if (planarImage2.overlapsMultipleTiles(rectangle)) {
                this.recycleTile(rasterArray[0]);
            }
            return writableRaster;
        }
        if (rectangle2.contains(rectangle) && !rectangle3.intersects(rectangle)) {
            rasterArray[0] = planarImage.getData(rectangle);
            this.computeRect(rasterArray, writableRaster, rectangle);
            if (planarImage.overlapsMultipleTiles(rectangle)) {
                this.recycleTile(rasterArray[0]);
            }
            return writableRaster;
        }
        Rectangle rectangle4 = rectangle.intersection(rectangle2);
        rasterArray[0] = planarImage.getData(rectangle4);
        this.computeRect(rasterArray, writableRaster, rectangle4);
        if (planarImage.overlapsMultipleTiles(rectangle4)) {
            this.recycleTile(rasterArray[0]);
        }
        if (rectangle3.intersects(rectangle)) {
            Rectangle rectangle5 = rectangle.intersection(rectangle3);
            rasterArray[0] = planarImage2.getData(rectangle5);
            this.computeRect(rasterArray, writableRaster, rectangle5);
            if (planarImage2.overlapsMultipleTiles(rectangle5)) {
                this.recycleTile(rasterArray[0]);
            }
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: 
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2);
            }
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        for (int i = 0; i < n3; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    byArray3[n10] = byArray4[n11];
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    sArray3[n10] = sArray4[n11];
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        for (int i = 0; i < n3; ++i) {
            int[] nArray5 = nArray2[i];
            int[] nArray6 = nArray4[i];
            int n8 = nArray[i];
            int n9 = nArray3[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    nArray5[n10] = nArray6[n11];
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        for (int i = 0; i < n3; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    fArray3[n10] = fArray4[n11];
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n4;
                n9 += n6;
                for (int k = 0; k < n; ++k) {
                    dArray3[n10] = dArray4[n11];
                    n10 += n5;
                    n11 += n7;
                }
            }
        }
    }
}

