/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

public class MosaicOpImage
extends OpImage {
    private static final int WEIGHT_TYPE_ALPHA = 1;
    private static final int WEIGHT_TYPE_ROI = 2;
    private static final int WEIGHT_TYPE_THRESHOLD = 3;
    protected MosaicType mosaicType;
    protected PlanarImage[] sourceAlpha;
    protected ROI[] sourceROI;
    protected double[][] sourceThreshold;
    protected double[] backgroundValues;
    protected int numBands = this.sampleModel.getNumBands();
    protected int[] background;
    protected int[][] threshold;
    protected boolean isAlphaBitmask = false;
    private BorderExtender sourceExtender;
    private BorderExtender zeroExtender;
    private PlanarImage[] roiImage;

    private static final ImageLayout getLayout(Vector vector, ImageLayout imageLayout) {
        Object object;
        int n;
        RenderedImage renderedImage = null;
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        int n2 = vector.size();
        if (n2 > 0) {
            renderedImage = (RenderedImage)vector.get(0);
            sampleModel = renderedImage.getSampleModel();
            colorModel = renderedImage.getColorModel();
        } else if (imageLayout != null && imageLayout.isValid(268)) {
            sampleModel = imageLayout.getSampleModel(null);
            if (sampleModel == null) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage7"));
            }
        } else {
            throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage8"));
        }
        int n3 = sampleModel.getDataType();
        int n4 = sampleModel.getNumBands();
        int n5 = sampleModel.getSampleSize(0);
        for (n = 1; n < n4; ++n) {
            if (sampleModel.getSampleSize(n) == n5) continue;
            throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage1"));
        }
        if (n2 < 1) {
            return (ImageLayout)imageLayout.clone();
        }
        for (n = 1; n < n2; ++n) {
            object = (RenderedImage)vector.get(n);
            SampleModel sampleModel2 = object.getSampleModel();
            if (sampleModel2.getDataType() != n3) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage2"));
            }
            if (sampleModel2.getNumBands() != n4) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage3"));
            }
            for (int i = 0; i < n4; ++i) {
                if (sampleModel2.getSampleSize(i) == n5) continue;
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage1"));
            }
        }
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        object = new Rectangle();
        if (imageLayout2.isValid(15)) {
            ((Rectangle)object).setBounds(imageLayout2.getMinX(null), imageLayout2.getMinY(null), imageLayout2.getWidth(null), imageLayout2.getHeight(null));
        } else if (n2 > 0) {
            ((Rectangle)object).setBounds(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            for (int i = 1; i < n2; ++i) {
                RenderedImage renderedImage2 = (RenderedImage)vector.get(i);
                Rectangle rectangle = new Rectangle(renderedImage2.getMinX(), renderedImage2.getMinY(), renderedImage2.getWidth(), renderedImage2.getHeight());
                object = ((Rectangle)object).union(rectangle);
            }
        }
        imageLayout2.setMinX(((Rectangle)object).x);
        imageLayout2.setMinY(((Rectangle)object).y);
        imageLayout2.setWidth(((Rectangle)object).width);
        imageLayout2.setHeight(((Rectangle)object).height);
        if (imageLayout2.isValid(256)) {
            SampleModel sampleModel3 = imageLayout2.getSampleModel(null);
            boolean bl = sampleModel3.getNumBands() != n4 || sampleModel3.getDataType() != n3;
            for (int i = 0; !bl && i < n4; ++i) {
                if (sampleModel3.getSampleSize(i) == n5) continue;
                bl = true;
            }
            if (bl) {
                imageLayout2.unsetValid(256);
            }
        }
        return imageLayout2;
    }

    public MosaicOpImage(Vector vector, ImageLayout imageLayout, Map map, MosaicType mosaicType, PlanarImage[] planarImageArray, ROI[] rOIArray, double[][] object, double[] dArray) {
        super(vector, MosaicOpImage.getLayout(vector, imageLayout), map, true);
        double d;
        int n;
        int n2 = this.getNumSources();
        this.mosaicType = mosaicType;
        this.sourceAlpha = null;
        if (planarImageArray != null) {
            for (n = 0; n < planarImageArray.length; ++n) {
                if (planarImageArray[n] == null) continue;
                SampleModel sampleModel = planarImageArray[n].getSampleModel();
                if (sampleModel.getNumBands() != 1) {
                    throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
                }
                if (sampleModel.getDataType() != this.sampleModel.getDataType()) {
                    throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
                }
                if (sampleModel.getSampleSize(0) == this.sampleModel.getSampleSize(0)) continue;
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
            }
            this.sourceAlpha = new PlanarImage[n2];
            System.arraycopy(planarImageArray, 0, this.sourceAlpha, 0, Math.min(planarImageArray.length, n2));
        }
        this.sourceROI = null;
        if (rOIArray != null) {
            this.sourceROI = new ROI[n2];
            System.arraycopy(rOIArray, 0, this.sourceROI, 0, Math.min(rOIArray.length, n2));
        }
        boolean bl = this.isAlphaBitmask = mosaicType != MosaicDescriptor.MOSAIC_TYPE_BLEND || planarImageArray == null || planarImageArray.length < n2;
        if (!this.isAlphaBitmask) {
            for (n = 0; n < n2; ++n) {
                if (planarImageArray[n] != null) continue;
                this.isAlphaBitmask = true;
                break;
            }
        }
        this.sourceThreshold = new double[n2][this.numBands];
        if (object == null) {
            object = new double[][]{{1.0}};
        }
        for (n = 0; n < n2; ++n) {
            if (n < ((double[][])object).length && object[n] != null) {
                if (object[n].length < this.numBands) {
                    Arrays.fill(this.sourceThreshold[n], object[n][0]);
                    continue;
                }
                System.arraycopy(object[n], 0, this.sourceThreshold[n], 0, this.numBands);
                continue;
            }
            this.sourceThreshold[n] = this.sourceThreshold[0];
        }
        this.threshold = new int[n2][this.numBands];
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < this.numBands; ++i) {
                this.threshold[n][i] = (int)this.sourceThreshold[n][i];
            }
        }
        this.backgroundValues = new double[this.numBands];
        if (dArray == null) {
            dArray = new double[]{0.0};
        }
        if (dArray.length < this.numBands) {
            Arrays.fill(this.backgroundValues, dArray[0]);
        } else {
            System.arraycopy(dArray, 0, this.backgroundValues, 0, this.numBands);
        }
        this.background = new int[this.backgroundValues.length];
        n = this.sampleModel.getDataType();
        block18: for (int i = 0; i < this.background.length; ++i) {
            switch (n) {
                case 0: {
                    this.background[i] = ImageUtil.clampRoundByte(this.backgroundValues[i]);
                    continue block18;
                }
                case 1: {
                    this.background[i] = ImageUtil.clampRoundUShort(this.backgroundValues[i]);
                    continue block18;
                }
                case 2: {
                    this.background[i] = ImageUtil.clampRoundShort(this.backgroundValues[i]);
                    continue block18;
                }
                case 3: {
                    this.background[i] = ImageUtil.clampRoundInt(this.backgroundValues[i]);
                    continue block18;
                }
            }
        }
        switch (n) {
            case 0: {
                d = 0.0;
                break;
            }
            case 1: {
                d = 0.0;
                break;
            }
            case 2: {
                d = -32768.0;
                break;
            }
            case 3: {
                d = -2.147483648E9;
                break;
            }
            case 4: {
                d = -3.4028234663852886E38;
                break;
            }
            default: {
                d = -1.7976931348623157E308;
            }
        }
        BorderExtender borderExtender = this.sourceExtender = d == 0.0 ? BorderExtender.createInstance(0) : new BorderExtenderConstant(new double[]{d});
        if (planarImageArray != null || rOIArray != null) {
            this.zeroExtender = BorderExtender.createInstance(0);
        }
        if (rOIArray != null) {
            this.roiImage = new PlanarImage[n2];
            for (int i = 0; i < rOIArray.length; ++i) {
                if (rOIArray[i] == null) continue;
                this.roiImage[i] = rOIArray[i].getAsImage();
            }
        }
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return rectangle.intersection(this.getSourceImage(n).getBounds());
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return rectangle.intersection(this.getBounds());
    }

    public Raster computeTile(int n, int n2) {
        Object object;
        Object object2;
        int n3;
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(n), this.tileYToY(n2)));
        Rectangle rectangle = this.getTileRect(n, n2);
        int n4 = this.getNumSources();
        Raster[] rasterArray = new Raster[n4];
        Raster[] rasterArray2 = this.sourceAlpha != null ? new Raster[n4] : null;
        Raster[] rasterArray3 = this.sourceROI != null ? new Raster[n4] : null;
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = this.getSourceImage(n3);
            object = this.mapDestRect(rectangle, n3);
            Raster raster = rasterArray[n3] = object != null && ((Rectangle)object).isEmpty() ? null : ((PlanarImage)object2).getExtendedData(rectangle, this.sourceExtender);
            if (rasterArray[n3] == null) continue;
            if (this.sourceAlpha != null && this.sourceAlpha[n3] != null) {
                rasterArray2[n3] = this.sourceAlpha[n3].getExtendedData(rectangle, this.zeroExtender);
            }
            if (this.sourceROI == null || this.sourceROI[n3] == null) continue;
            rasterArray3[n3] = this.roiImage[n3].getExtendedData(rectangle, this.zeroExtender);
        }
        this.computeRect(rasterArray, writableRaster, rectangle, rasterArray2, rasterArray3);
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = rasterArray[n3];
            if (object2 == null || !((PlanarImage)(object = this.getSourceImage(n3))).overlapsMultipleTiles(((Raster)object2).getBounds())) continue;
            this.recycleTile((Raster)object2);
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.computeRect(rasterArray, writableRaster, rectangle, null, null);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle, Raster[] rasterArray2, Raster[] rasterArray3) {
        RasterAccessor[] rasterAccessorArray;
        int n;
        int n2;
        int n3 = rasterArray.length;
        ArrayList<Raster> arrayList = new ArrayList<Raster>(n3);
        for (n2 = 0; n2 < n3; ++n2) {
            if (rasterArray[n2] == null) continue;
            arrayList.add(rasterArray[n2]);
        }
        n2 = arrayList.size();
        if (n2 == 0) {
            ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            return;
        }
        SampleModel[] sampleModelArray = new SampleModel[n2];
        for (n = 0; n < n2; ++n) {
            sampleModelArray[n] = ((Raster)arrayList.get(n)).getSampleModel();
        }
        n = RasterAccessor.findCompatibleTag(sampleModelArray, writableRaster.getSampleModel());
        RasterAccessor[] rasterAccessorArray2 = new RasterAccessor[n3];
        for (int i = 0; i < n3; ++i) {
            if (rasterArray[i] == null) continue;
            rasterAccessorArray = new RasterFormatTag(rasterArray[i].getSampleModel(), n);
            rasterAccessorArray2[i] = new RasterAccessor(rasterArray[i], rectangle, (RasterFormatTag)rasterAccessorArray, null);
        }
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, new RasterFormatTag(writableRaster.getSampleModel(), n), null);
        rasterAccessorArray = new RasterAccessor[n3];
        if (rasterArray2 != null) {
            for (int i = 0; i < n3; ++i) {
                if (rasterArray2[i] == null) continue;
                SampleModel sampleModel = rasterArray2[i].getSampleModel();
                int n4 = RasterAccessor.findCompatibleTag(null, sampleModel);
                RasterFormatTag rasterFormatTag = new RasterFormatTag(sampleModel, n4);
                rasterAccessorArray[i] = new RasterAccessor(rasterArray2[i], rectangle, rasterFormatTag, this.sourceAlpha[i].getColorModel());
            }
        }
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessorArray2, rasterAccessor, rasterAccessorArray, rasterArray3);
            }
        }
        rasterAccessor.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n;
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        byte[][][] byArrayArray = new byte[n2][][];
        for (n = 0; n < n2; ++n) {
            if (rasterAccessorArray[n] == null) continue;
            nArray[n] = rasterAccessorArray[n].getScanlineStride();
            nArray2[n] = rasterAccessorArray[n].getPixelStride();
            nArrayArray[n] = rasterAccessorArray[n].getBandOffsets();
            byArrayArray[n] = rasterAccessorArray[n].getByteDataArrays();
        }
        n = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (rasterAccessorArray2[i] == null) continue;
            bl = true;
            break;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        Object object = null;
        Object object2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            object = new int[n2][];
            object2 = new byte[n2][][];
            for (int i = 0; i < n2; ++i) {
                if (rasterAccessorArray2[i] == null) continue;
                nArray4[i] = rasterAccessorArray2[i].getScanlineStride();
                nArray5[i] = rasterAccessorArray2[i].getPixelStride();
                object[i] = rasterAccessorArray2[i].getBandOffsets();
                object2[i] = rasterAccessorArray2[i].getByteDataArrays();
            }
        }
        int[] nArray6 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray6[i] = 3;
            if (rasterAccessorArray2[i] != null) {
                nArray6[i] = 1;
                continue;
            }
            if (this.sourceROI == null || this.sourceROI[i] == null) continue;
            nArray6[i] = 2;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        byte[][] byArrayArray2 = new byte[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        Object object3 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            object3 = new byte[n2][];
        }
        for (int i = 0; i < n8; ++i) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            for (int j = 0; j < n2; ++j) {
                if (rasterAccessorArray[j] != null) {
                    byArrayArray2[j] = byArrayArray[j][i];
                    nArray7[j] = nArrayArray[j][i];
                }
                if (nArray6[j] != 1) continue;
                object3[j] = object2[j][0];
                nArray9[j] = object[j][0];
            }
            byte[] byArray2 = byArray[i];
            int n16 = nArray3[i];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (n15 = n3; n15 < n7; ++n15) {
                    for (n14 = 0; n14 < n2; ++n14) {
                        if (rasterAccessorArray[n14] != null) {
                            nArray8[n14] = nArray7[n14];
                            int n17 = n14;
                            nArray7[n17] = nArray7[n17] + nArray[n14];
                        }
                        if (rasterAccessorArray2[n14] == null) continue;
                        nArray10[n14] = nArray9[n14];
                        int n18 = n14;
                        nArray9[n18] = nArray9[n18] + nArray4[n14];
                    }
                    n14 = n16;
                    n16 += n9;
                    for (n13 = n; n13 < n6; ++n13) {
                        boolean bl2 = false;
                        for (int j = 0; j < n2; ++j) {
                            if (rasterAccessorArray[j] == null) continue;
                            n12 = byArrayArray2[j][nArray8[j]];
                            int n19 = j;
                            nArray8[n19] = nArray8[n19] + nArray2[j];
                            switch (nArray6[j]) {
                                case 1: {
                                    bl2 = object3[j][nArray10[j]] != 0;
                                    int n20 = j;
                                    nArray10[n20] = nArray10[n20] + nArray5[j];
                                    break;
                                }
                                case 2: {
                                    bl2 = rasterArray[j].getSample(n13, n15, 0) > 0;
                                    break;
                                }
                                default: {
                                    boolean bl3 = bl2 = (double)(n12 & 0xFF) >= this.sourceThreshold[j][i];
                                }
                            }
                            if (!bl2) continue;
                            byArray2[n14] = n12;
                            for (n11 = j + 1; n11 < n2; ++n11) {
                                if (rasterAccessorArray[n11] != null) {
                                    int n21 = n11;
                                    nArray8[n21] = nArray8[n21] + nArray2[n11];
                                }
                                if (rasterAccessorArray2[n11] == null) continue;
                                int n22 = n11;
                                nArray10[n22] = nArray10[n22] + nArray5[n11];
                            }
                            break;
                        }
                        if (!bl2) {
                            byArray2[n14] = (byte)this.background[i];
                        }
                        n14 += n10;
                    }
                }
                continue;
            }
            for (n15 = n3; n15 < n7; ++n15) {
                for (n14 = 0; n14 < n2; ++n14) {
                    if (rasterAccessorArray[n14] != null) {
                        nArray8[n14] = nArray7[n14];
                        int n23 = n14;
                        nArray7[n23] = nArray7[n23] + nArray[n14];
                    }
                    if (nArray6[n14] != 1) continue;
                    nArray10[n14] = nArray9[n14];
                    int n24 = n14;
                    nArray9[n24] = nArray9[n24] + nArray4[n14];
                }
                n14 = n16;
                n16 += n9;
                for (n13 = n; n13 < n6; ++n13) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    for (n12 = 0; n12 < n2; ++n12) {
                        if (rasterAccessorArray[n12] == null) continue;
                        n11 = byArrayArray2[n12][nArray8[n12]];
                        int n25 = n12;
                        nArray8[n25] = nArray8[n25] + nArray2[n12];
                        float f3 = 0.0f;
                        switch (nArray6[n12]) {
                            case 1: {
                                f3 = object3[n12][nArray10[n12]] & 0xFF;
                                f3 = f3 > 0.0f && this.isAlphaBitmask ? 1.0f : (f3 /= 255.0f);
                                int n26 = n12;
                                nArray10[n26] = nArray10[n26] + nArray5[n12];
                                break;
                            }
                            case 2: {
                                f3 = rasterArray[n12].getSample(n13, n15, 0) > 0 ? 1.0f : 0.0f;
                                break;
                            }
                            default: {
                                f3 = (double)(n11 & 0xFF) >= this.sourceThreshold[n12][i] ? 1.0f : 0.0f;
                            }
                        }
                        f += f3 * (float)(n11 & 0xFF);
                        f2 += f3;
                    }
                    byArray2[n14] = (double)f2 == 0.0 ? (byte)this.background[i] : ImageUtil.clampRoundByte(f / f2);
                    n14 += n10;
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n;
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        short[][][] sArrayArray = new short[n2][][];
        for (n = 0; n < n2; ++n) {
            if (rasterAccessorArray[n] == null) continue;
            nArray[n] = rasterAccessorArray[n].getScanlineStride();
            nArray2[n] = rasterAccessorArray[n].getPixelStride();
            nArrayArray[n] = rasterAccessorArray[n].getBandOffsets();
            sArrayArray[n] = rasterAccessorArray[n].getShortDataArrays();
        }
        n = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (rasterAccessorArray2[i] == null) continue;
            bl = true;
            break;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        Object object = null;
        Object object2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            object = new int[n2][];
            object2 = new short[n2][][];
            for (int i = 0; i < n2; ++i) {
                if (rasterAccessorArray2[i] == null) continue;
                nArray4[i] = rasterAccessorArray2[i].getScanlineStride();
                nArray5[i] = rasterAccessorArray2[i].getPixelStride();
                object[i] = rasterAccessorArray2[i].getBandOffsets();
                object2[i] = rasterAccessorArray2[i].getShortDataArrays();
            }
        }
        int[] nArray6 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray6[i] = 3;
            if (rasterAccessorArray2[i] != null) {
                nArray6[i] = 1;
                continue;
            }
            if (this.sourceROI == null || this.sourceROI[i] == null) continue;
            nArray6[i] = 2;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        short[][] sArrayArray2 = new short[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        Object object3 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            object3 = new short[n2][];
        }
        for (int i = 0; i < n8; ++i) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            for (int j = 0; j < n2; ++j) {
                if (rasterAccessorArray[j] != null) {
                    sArrayArray2[j] = sArrayArray[j][i];
                    nArray7[j] = nArrayArray[j][i];
                }
                if (nArray6[j] != 1) continue;
                object3[j] = object2[j][0];
                nArray9[j] = object[j][0];
            }
            short[] sArray2 = sArray[i];
            int n16 = nArray3[i];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (n15 = n3; n15 < n7; ++n15) {
                    for (n14 = 0; n14 < n2; ++n14) {
                        if (rasterAccessorArray[n14] != null) {
                            nArray8[n14] = nArray7[n14];
                            int n17 = n14;
                            nArray7[n17] = nArray7[n17] + nArray[n14];
                        }
                        if (rasterAccessorArray2[n14] == null) continue;
                        nArray10[n14] = nArray9[n14];
                        int n18 = n14;
                        nArray9[n18] = nArray9[n18] + nArray4[n14];
                    }
                    n14 = n16;
                    n16 += n9;
                    for (n13 = n; n13 < n6; ++n13) {
                        boolean bl2 = false;
                        for (int j = 0; j < n2; ++j) {
                            if (rasterAccessorArray[j] == null) continue;
                            n12 = sArrayArray2[j][nArray8[j]];
                            int n19 = j;
                            nArray8[n19] = nArray8[n19] + nArray2[j];
                            switch (nArray6[j]) {
                                case 1: {
                                    bl2 = object3[j][nArray10[j]] != 0;
                                    int n20 = j;
                                    nArray10[n20] = nArray10[n20] + nArray5[j];
                                    break;
                                }
                                case 2: {
                                    bl2 = rasterArray[j].getSample(n13, n15, 0) > 0;
                                    break;
                                }
                                default: {
                                    boolean bl3 = bl2 = (double)(n12 & 0xFFFF) >= this.sourceThreshold[j][i];
                                }
                            }
                            if (!bl2) continue;
                            sArray2[n14] = n12;
                            for (n11 = j + 1; n11 < n2; ++n11) {
                                if (rasterAccessorArray[n11] != null) {
                                    int n21 = n11;
                                    nArray8[n21] = nArray8[n21] + nArray2[n11];
                                }
                                if (rasterAccessorArray2[n11] == null) continue;
                                int n22 = n11;
                                nArray10[n22] = nArray10[n22] + nArray5[n11];
                            }
                            break;
                        }
                        if (!bl2) {
                            sArray2[n14] = (short)this.background[i];
                        }
                        n14 += n10;
                    }
                }
                continue;
            }
            for (n15 = n3; n15 < n7; ++n15) {
                for (n14 = 0; n14 < n2; ++n14) {
                    if (rasterAccessorArray[n14] != null) {
                        nArray8[n14] = nArray7[n14];
                        int n23 = n14;
                        nArray7[n23] = nArray7[n23] + nArray[n14];
                    }
                    if (nArray6[n14] != 1) continue;
                    nArray10[n14] = nArray9[n14];
                    int n24 = n14;
                    nArray9[n24] = nArray9[n24] + nArray4[n14];
                }
                n14 = n16;
                n16 += n9;
                for (n13 = n; n13 < n6; ++n13) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    for (n12 = 0; n12 < n2; ++n12) {
                        if (rasterAccessorArray[n12] == null) continue;
                        n11 = sArrayArray2[n12][nArray8[n12]];
                        int n25 = n12;
                        nArray8[n25] = nArray8[n25] + nArray2[n12];
                        float f3 = 0.0f;
                        switch (nArray6[n12]) {
                            case 1: {
                                f3 = object3[n12][nArray10[n12]] & 0xFFFF;
                                f3 = f3 > 0.0f && this.isAlphaBitmask ? 1.0f : (f3 /= 65535.0f);
                                int n26 = n12;
                                nArray10[n26] = nArray10[n26] + nArray5[n12];
                                break;
                            }
                            case 2: {
                                f3 = rasterArray[n12].getSample(n13, n15, 0) > 0 ? 1.0f : 0.0f;
                                break;
                            }
                            default: {
                                f3 = (double)(n11 & 0xFFFF) >= this.sourceThreshold[n12][i] ? 1.0f : 0.0f;
                            }
                        }
                        f += f3 * (float)(n11 & 0xFFFF);
                        f2 += f3;
                    }
                    sArray2[n14] = (double)f2 == 0.0 ? (short)this.background[i] : ImageUtil.clampRoundUShort(f / f2);
                    n14 += n10;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n;
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        short[][][] sArrayArray = new short[n2][][];
        for (n = 0; n < n2; ++n) {
            if (rasterAccessorArray[n] == null) continue;
            nArray[n] = rasterAccessorArray[n].getScanlineStride();
            nArray2[n] = rasterAccessorArray[n].getPixelStride();
            nArrayArray[n] = rasterAccessorArray[n].getBandOffsets();
            sArrayArray[n] = rasterAccessorArray[n].getShortDataArrays();
        }
        n = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (rasterAccessorArray2[i] == null) continue;
            bl = true;
            break;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        Object object = null;
        Object object2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            object = new int[n2][];
            object2 = new short[n2][][];
            for (int i = 0; i < n2; ++i) {
                if (rasterAccessorArray2[i] == null) continue;
                nArray4[i] = rasterAccessorArray2[i].getScanlineStride();
                nArray5[i] = rasterAccessorArray2[i].getPixelStride();
                object[i] = rasterAccessorArray2[i].getBandOffsets();
                object2[i] = rasterAccessorArray2[i].getShortDataArrays();
            }
        }
        int[] nArray6 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray6[i] = 3;
            if (rasterAccessorArray2[i] != null) {
                nArray6[i] = 1;
                continue;
            }
            if (this.sourceROI == null || this.sourceROI[i] == null) continue;
            nArray6[i] = 2;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        short[][] sArrayArray2 = new short[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        Object object3 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            object3 = new short[n2][];
        }
        for (int i = 0; i < n8; ++i) {
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            for (int j = 0; j < n2; ++j) {
                if (rasterAccessorArray[j] != null) {
                    sArrayArray2[j] = sArrayArray[j][i];
                    nArray7[j] = nArrayArray[j][i];
                }
                if (nArray6[j] != 1) continue;
                object3[j] = object2[j][0];
                nArray9[j] = object[j][0];
            }
            short[] sArray2 = sArray[i];
            int n16 = nArray3[i];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (n15 = n3; n15 < n7; ++n15) {
                    for (n14 = 0; n14 < n2; ++n14) {
                        if (rasterAccessorArray[n14] != null) {
                            nArray8[n14] = nArray7[n14];
                            int n17 = n14;
                            nArray7[n17] = nArray7[n17] + nArray[n14];
                        }
                        if (rasterAccessorArray2[n14] == null) continue;
                        nArray10[n14] = nArray9[n14];
                        int n18 = n14;
                        nArray9[n18] = nArray9[n18] + nArray4[n14];
                    }
                    n14 = n16;
                    n16 += n9;
                    for (n13 = n; n13 < n6; ++n13) {
                        boolean bl2 = false;
                        for (int j = 0; j < n2; ++j) {
                            if (rasterAccessorArray[j] == null) continue;
                            n12 = sArrayArray2[j][nArray8[j]];
                            int n19 = j;
                            nArray8[n19] = nArray8[n19] + nArray2[j];
                            switch (nArray6[j]) {
                                case 1: {
                                    bl2 = object3[j][nArray10[j]] != 0;
                                    int n20 = j;
                                    nArray10[n20] = nArray10[n20] + nArray5[j];
                                    break;
                                }
                                case 2: {
                                    bl2 = rasterArray[j].getSample(n13, n15, 0) > 0;
                                    break;
                                }
                                default: {
                                    boolean bl3 = bl2 = (double)n12 >= this.sourceThreshold[j][i];
                                }
                            }
                            if (!bl2) continue;
                            sArray2[n14] = n12;
                            for (n11 = j + 1; n11 < n2; ++n11) {
                                if (rasterAccessorArray[n11] != null) {
                                    int n21 = n11;
                                    nArray8[n21] = nArray8[n21] + nArray2[n11];
                                }
                                if (rasterAccessorArray2[n11] == null) continue;
                                int n22 = n11;
                                nArray10[n22] = nArray10[n22] + nArray5[n11];
                            }
                            break;
                        }
                        if (!bl2) {
                            sArray2[n14] = (short)this.background[i];
                        }
                        n14 += n10;
                    }
                }
                continue;
            }
            for (n15 = n3; n15 < n7; ++n15) {
                for (n14 = 0; n14 < n2; ++n14) {
                    if (rasterAccessorArray[n14] != null) {
                        nArray8[n14] = nArray7[n14];
                        int n23 = n14;
                        nArray7[n23] = nArray7[n23] + nArray[n14];
                    }
                    if (nArray6[n14] != 1) continue;
                    nArray10[n14] = nArray9[n14];
                    int n24 = n14;
                    nArray9[n24] = nArray9[n24] + nArray4[n14];
                }
                n14 = n16;
                n16 += n9;
                for (n13 = n; n13 < n6; ++n13) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    for (n12 = 0; n12 < n2; ++n12) {
                        if (rasterAccessorArray[n12] == null) continue;
                        n11 = sArrayArray2[n12][nArray8[n12]];
                        int n25 = n12;
                        nArray8[n25] = nArray8[n25] + nArray2[n12];
                        float f3 = 0.0f;
                        switch (nArray6[n12]) {
                            case 1: {
                                f3 = object3[n12][nArray10[n12]];
                                f3 = f3 > 0.0f && this.isAlphaBitmask ? 1.0f : (f3 /= 32767.0f);
                                int n26 = n12;
                                nArray10[n26] = nArray10[n26] + nArray5[n12];
                                break;
                            }
                            case 2: {
                                f3 = rasterArray[n12].getSample(n13, n15, 0) > 0 ? 1.0f : 0.0f;
                                break;
                            }
                            default: {
                                f3 = (double)n11 >= this.sourceThreshold[n12][i] ? 1.0f : 0.0f;
                            }
                        }
                        f += f3 * (float)n11;
                        f2 += f3;
                    }
                    sArray2[n14] = (double)f2 == 0.0 ? (short)this.background[i] : ImageUtil.clampRoundShort(f / f2);
                    n14 += n10;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n;
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        int[][][] nArrayArray2 = new int[n2][][];
        for (n = 0; n < n2; ++n) {
            if (rasterAccessorArray[n] == null) continue;
            nArray[n] = rasterAccessorArray[n].getScanlineStride();
            nArray2[n] = rasterAccessorArray[n].getPixelStride();
            nArrayArray[n] = rasterAccessorArray[n].getBandOffsets();
            nArrayArray2[n] = rasterAccessorArray[n].getIntDataArrays();
        }
        n = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (rasterAccessorArray2[i] == null) continue;
            bl = true;
            break;
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        Object object = null;
        Object object2 = null;
        if (bl) {
            nArray5 = new int[n2];
            nArray6 = new int[n2];
            object = new int[n2][];
            object2 = new int[n2][][];
            for (int i = 0; i < n2; ++i) {
                if (rasterAccessorArray2[i] == null) continue;
                nArray5[i] = rasterAccessorArray2[i].getScanlineStride();
                nArray6[i] = rasterAccessorArray2[i].getPixelStride();
                object[i] = rasterAccessorArray2[i].getBandOffsets();
                object2[i] = rasterAccessorArray2[i].getIntDataArrays();
            }
        }
        int[] nArray7 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray7[i] = 3;
            if (rasterAccessorArray2[i] != null) {
                nArray7[i] = 1;
                continue;
            }
            if (this.sourceROI == null || this.sourceROI[i] == null) continue;
            nArray7[i] = 2;
        }
        int[] nArray8 = new int[n2];
        int[] nArray9 = new int[n2];
        int[][] nArrayArray3 = new int[n2][];
        int[] nArray10 = null;
        int[] nArray11 = null;
        Object object3 = null;
        if (bl) {
            nArray10 = new int[n2];
            nArray11 = new int[n2];
            object3 = new int[n2][];
        }
        for (int i = 0; i < n8; ++i) {
            int n11;
            int n12;
            int n13;
            for (int j = 0; j < n2; ++j) {
                if (rasterAccessorArray[j] != null) {
                    nArrayArray3[j] = nArrayArray2[j][i];
                    nArray8[j] = nArrayArray[j][i];
                }
                if (nArray7[j] != 1) continue;
                object3[j] = object2[j][0];
                nArray10[j] = object[j][0];
            }
            int[] nArray12 = nArray4[i];
            int n14 = nArray3[i];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (n13 = n3; n13 < n7; ++n13) {
                    for (n12 = 0; n12 < n2; ++n12) {
                        if (rasterAccessorArray[n12] != null) {
                            nArray9[n12] = nArray8[n12];
                            int n15 = n12;
                            nArray8[n15] = nArray8[n15] + nArray[n12];
                        }
                        if (rasterAccessorArray2[n12] == null) continue;
                        nArray11[n12] = nArray10[n12];
                        int n16 = n12;
                        nArray10[n16] = nArray10[n16] + nArray5[n12];
                    }
                    n12 = n14;
                    n14 += n9;
                    for (n11 = n; n11 < n6; ++n11) {
                        boolean bl2 = false;
                        for (int j = 0; j < n2; ++j) {
                            if (rasterAccessorArray[j] == null) continue;
                            int n17 = nArrayArray3[j][nArray9[j]];
                            int n18 = j;
                            nArray9[n18] = nArray9[n18] + nArray2[j];
                            switch (nArray7[j]) {
                                case 1: {
                                    bl2 = object3[j][nArray11[j]] != 0;
                                    int n19 = j;
                                    nArray11[n19] = nArray11[n19] + nArray6[j];
                                    break;
                                }
                                case 2: {
                                    bl2 = rasterArray[j].getSample(n11, n13, 0) > 0;
                                    break;
                                }
                                default: {
                                    boolean bl3 = bl2 = (double)n17 >= this.sourceThreshold[j][i];
                                }
                            }
                            if (!bl2) continue;
                            nArray12[n12] = n17;
                            for (int k = j + 1; k < n2; ++k) {
                                if (rasterAccessorArray[k] != null) {
                                    int n20 = k;
                                    nArray9[n20] = nArray9[n20] + nArray2[k];
                                }
                                if (rasterAccessorArray2[k] == null) continue;
                                int n21 = k;
                                nArray11[n21] = nArray11[n21] + nArray6[k];
                            }
                            break;
                        }
                        if (!bl2) {
                            nArray12[n12] = this.background[i];
                        }
                        n12 += n10;
                    }
                }
                continue;
            }
            for (n13 = n3; n13 < n7; ++n13) {
                for (n12 = 0; n12 < n2; ++n12) {
                    if (rasterAccessorArray[n12] != null) {
                        nArray9[n12] = nArray8[n12];
                        int n22 = n12;
                        nArray8[n22] = nArray8[n22] + nArray[n12];
                    }
                    if (nArray7[n12] != 1) continue;
                    nArray11[n12] = nArray10[n12];
                    int n23 = n12;
                    nArray10[n23] = nArray10[n23] + nArray5[n12];
                }
                n12 = n14;
                n14 += n9;
                for (n11 = n; n11 < n6; ++n11) {
                    double d = 0.0;
                    double d2 = 0.0;
                    for (int j = 0; j < n2; ++j) {
                        if (rasterAccessorArray[j] == null) continue;
                        int n24 = nArrayArray3[j][nArray9[j]];
                        int n25 = j;
                        nArray9[n25] = nArray9[n25] + nArray2[j];
                        double d3 = 0.0;
                        switch (nArray7[j]) {
                            case 1: {
                                d3 = object3[j][nArray11[j]];
                                d3 = d3 > 0.0 && this.isAlphaBitmask ? 1.0 : (d3 /= 2.147483647E9);
                                int n26 = j;
                                nArray11[n26] = nArray11[n26] + nArray6[j];
                                break;
                            }
                            case 2: {
                                d3 = rasterArray[j].getSample(n11, n13, 0) > 0 ? 1.0 : 0.0;
                                break;
                            }
                            default: {
                                d3 = (double)n24 >= this.sourceThreshold[j][i] ? 1.0 : 0.0;
                            }
                        }
                        d += d3 * (double)n24;
                        d2 += d3;
                    }
                    nArray12[n12] = d2 == 0.0 ? this.background[i] : ImageUtil.clampRoundInt(d / d2);
                    n12 += n10;
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n;
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        float[][][] fArrayArray = new float[n2][][];
        for (n = 0; n < n2; ++n) {
            if (rasterAccessorArray[n] == null) continue;
            nArray[n] = rasterAccessorArray[n].getScanlineStride();
            nArray2[n] = rasterAccessorArray[n].getPixelStride();
            nArrayArray[n] = rasterAccessorArray[n].getBandOffsets();
            fArrayArray[n] = rasterAccessorArray[n].getFloatDataArrays();
        }
        n = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (rasterAccessorArray2[i] == null) continue;
            bl = true;
            break;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        Object object = null;
        Object object2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            object = new int[n2][];
            object2 = new float[n2][][];
            for (int i = 0; i < n2; ++i) {
                if (rasterAccessorArray2[i] == null) continue;
                nArray4[i] = rasterAccessorArray2[i].getScanlineStride();
                nArray5[i] = rasterAccessorArray2[i].getPixelStride();
                object[i] = rasterAccessorArray2[i].getBandOffsets();
                object2[i] = rasterAccessorArray2[i].getFloatDataArrays();
            }
        }
        int[] nArray6 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray6[i] = 3;
            if (rasterAccessorArray2[i] != null) {
                nArray6[i] = 1;
                continue;
            }
            if (this.sourceROI == null || this.sourceROI[i] == null) continue;
            nArray6[i] = 2;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        float[][] fArrayArray2 = new float[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        Object object3 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            object3 = new float[n2][];
        }
        for (int i = 0; i < n8; ++i) {
            int n11;
            int n12;
            int n13;
            for (int j = 0; j < n2; ++j) {
                if (rasterAccessorArray[j] != null) {
                    fArrayArray2[j] = fArrayArray[j][i];
                    nArray7[j] = nArrayArray[j][i];
                }
                if (nArray6[j] != 1) continue;
                object3[j] = object2[j][0];
                nArray9[j] = object[j][0];
            }
            float[] fArray2 = fArray[i];
            int n14 = nArray3[i];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (n13 = n3; n13 < n7; ++n13) {
                    for (n12 = 0; n12 < n2; ++n12) {
                        if (rasterAccessorArray[n12] != null) {
                            nArray8[n12] = nArray7[n12];
                            int n15 = n12;
                            nArray7[n15] = nArray7[n15] + nArray[n12];
                        }
                        if (rasterAccessorArray2[n12] == null) continue;
                        nArray10[n12] = nArray9[n12];
                        int n16 = n12;
                        nArray9[n16] = nArray9[n16] + nArray4[n12];
                    }
                    n12 = n14;
                    n14 += n9;
                    for (n11 = n; n11 < n6; ++n11) {
                        boolean bl2 = false;
                        for (int j = 0; j < n2; ++j) {
                            if (rasterAccessorArray[j] == null) continue;
                            float f = fArrayArray2[j][nArray8[j]];
                            int n17 = j;
                            nArray8[n17] = nArray8[n17] + nArray2[j];
                            switch (nArray6[j]) {
                                case 1: {
                                    bl2 = object3[j][nArray10[j]] != 0.0f;
                                    int n18 = j;
                                    nArray10[n18] = nArray10[n18] + nArray5[j];
                                    break;
                                }
                                case 2: {
                                    bl2 = rasterArray[j].getSample(n11, n13, 0) > 0;
                                    break;
                                }
                                default: {
                                    boolean bl3 = bl2 = (double)f >= this.sourceThreshold[j][i];
                                }
                            }
                            if (!bl2) continue;
                            fArray2[n12] = f;
                            for (int k = j + 1; k < n2; ++k) {
                                if (rasterAccessorArray[k] != null) {
                                    int n19 = k;
                                    nArray8[n19] = nArray8[n19] + nArray2[k];
                                }
                                if (rasterAccessorArray2[k] == null) continue;
                                int n20 = k;
                                nArray10[n20] = nArray10[n20] + nArray5[k];
                            }
                            break;
                        }
                        if (!bl2) {
                            fArray2[n12] = (float)this.backgroundValues[i];
                        }
                        n12 += n10;
                    }
                }
                continue;
            }
            for (n13 = n3; n13 < n7; ++n13) {
                for (n12 = 0; n12 < n2; ++n12) {
                    if (rasterAccessorArray[n12] != null) {
                        nArray8[n12] = nArray7[n12];
                        int n21 = n12;
                        nArray7[n21] = nArray7[n21] + nArray[n12];
                    }
                    if (nArray6[n12] != 1) continue;
                    nArray10[n12] = nArray9[n12];
                    int n22 = n12;
                    nArray9[n22] = nArray9[n22] + nArray4[n12];
                }
                n12 = n14;
                n14 += n9;
                for (n11 = n; n11 < n6; ++n11) {
                    float f = 0.0f;
                    float f2 = 0.0f;
                    for (int j = 0; j < n2; ++j) {
                        if (rasterAccessorArray[j] == null) continue;
                        float f3 = fArrayArray2[j][nArray8[j]];
                        int n23 = j;
                        nArray8[n23] = nArray8[n23] + nArray2[j];
                        float f4 = 0.0f;
                        switch (nArray6[j]) {
                            case 1: {
                                f4 = object3[j][nArray10[j]];
                                if (f4 > 0.0f && this.isAlphaBitmask) {
                                    f4 = 1.0f;
                                }
                                int n24 = j;
                                nArray10[n24] = nArray10[n24] + nArray5[j];
                                break;
                            }
                            case 2: {
                                f4 = rasterArray[j].getSample(n11, n13, 0) > 0 ? 1.0f : 0.0f;
                                break;
                            }
                            default: {
                                f4 = (double)f3 >= this.sourceThreshold[j][i] ? 1.0f : 0.0f;
                            }
                        }
                        f += f4 * f3;
                        f2 += f4;
                    }
                    fArray2[n12] = (double)f2 == 0.0 ? (float)this.backgroundValues[i] : f / f2;
                    n12 += n10;
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n;
        int n2 = rasterAccessorArray.length;
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[][] nArrayArray = new int[n2][];
        double[][][] dArrayArray = new double[n2][][];
        for (n = 0; n < n2; ++n) {
            if (rasterAccessorArray[n] == null) continue;
            nArray[n] = rasterAccessorArray[n].getScanlineStride();
            nArray2[n] = rasterAccessorArray[n].getPixelStride();
            nArrayArray[n] = rasterAccessorArray[n].getBandOffsets();
            dArrayArray[n] = rasterAccessorArray[n].getDoubleDataArrays();
        }
        n = rasterAccessor.getX();
        int n3 = rasterAccessor.getY();
        int n4 = rasterAccessor.getWidth();
        int n5 = rasterAccessor.getHeight();
        int n6 = n + n4;
        int n7 = n3 + n5;
        int n8 = rasterAccessor.getNumBands();
        int n9 = rasterAccessor.getScanlineStride();
        int n10 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        boolean bl = false;
        for (int i = 0; i < n2; ++i) {
            if (rasterAccessorArray2[i] == null) continue;
            bl = true;
            break;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        Object object = null;
        Object object2 = null;
        if (bl) {
            nArray4 = new int[n2];
            nArray5 = new int[n2];
            object = new int[n2][];
            object2 = new double[n2][][];
            for (int i = 0; i < n2; ++i) {
                if (rasterAccessorArray2[i] == null) continue;
                nArray4[i] = rasterAccessorArray2[i].getScanlineStride();
                nArray5[i] = rasterAccessorArray2[i].getPixelStride();
                object[i] = rasterAccessorArray2[i].getBandOffsets();
                object2[i] = rasterAccessorArray2[i].getDoubleDataArrays();
            }
        }
        int[] nArray6 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray6[i] = 3;
            if (rasterAccessorArray2[i] != null) {
                nArray6[i] = 1;
                continue;
            }
            if (this.sourceROI == null || this.sourceROI[i] == null) continue;
            nArray6[i] = 2;
        }
        int[] nArray7 = new int[n2];
        int[] nArray8 = new int[n2];
        double[][] dArrayArray2 = new double[n2][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        Object object3 = null;
        if (bl) {
            nArray9 = new int[n2];
            nArray10 = new int[n2];
            object3 = new double[n2][];
        }
        for (int i = 0; i < n8; ++i) {
            int n11;
            double d;
            int n12;
            int n13;
            int n14;
            for (int j = 0; j < n2; ++j) {
                if (rasterAccessorArray[j] != null) {
                    dArrayArray2[j] = dArrayArray[j][i];
                    nArray7[j] = nArrayArray[j][i];
                }
                if (nArray6[j] != 1) continue;
                object3[j] = object2[j][0];
                nArray9[j] = object[j][0];
            }
            double[] dArray2 = dArray[i];
            int n15 = nArray3[i];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                for (n14 = n3; n14 < n7; ++n14) {
                    for (n13 = 0; n13 < n2; ++n13) {
                        if (rasterAccessorArray[n13] != null) {
                            nArray8[n13] = nArray7[n13];
                            int n16 = n13;
                            nArray7[n16] = nArray7[n16] + nArray[n13];
                        }
                        if (rasterAccessorArray2[n13] == null) continue;
                        nArray10[n13] = nArray9[n13];
                        int n17 = n13;
                        nArray9[n17] = nArray9[n17] + nArray4[n13];
                    }
                    n13 = n15;
                    n15 += n9;
                    for (n12 = n; n12 < n6; ++n12) {
                        boolean bl2 = false;
                        for (int j = 0; j < n2; ++j) {
                            if (rasterAccessorArray[j] == null) continue;
                            d = dArrayArray2[j][nArray8[j]];
                            int n18 = j;
                            nArray8[n18] = nArray8[n18] + nArray2[j];
                            switch (nArray6[j]) {
                                case 1: {
                                    bl2 = object3[j][nArray10[j]] != 0.0;
                                    int n19 = j;
                                    nArray10[n19] = nArray10[n19] + nArray5[j];
                                    break;
                                }
                                case 2: {
                                    bl2 = rasterArray[j].getSample(n12, n14, 0) > 0;
                                    break;
                                }
                                default: {
                                    boolean bl3 = bl2 = d >= this.sourceThreshold[j][i];
                                }
                            }
                            if (!bl2) continue;
                            dArray2[n13] = d;
                            for (n11 = j + 1; n11 < n2; ++n11) {
                                if (rasterAccessorArray[n11] != null) {
                                    int n20 = n11;
                                    nArray8[n20] = nArray8[n20] + nArray2[n11];
                                }
                                if (rasterAccessorArray2[n11] == null) continue;
                                int n21 = n11;
                                nArray10[n21] = nArray10[n21] + nArray5[n11];
                            }
                            break;
                        }
                        if (!bl2) {
                            dArray2[n13] = this.backgroundValues[i];
                        }
                        n13 += n10;
                    }
                }
                continue;
            }
            for (n14 = n3; n14 < n7; ++n14) {
                for (n13 = 0; n13 < n2; ++n13) {
                    if (rasterAccessorArray[n13] != null) {
                        nArray8[n13] = nArray7[n13];
                        int n22 = n13;
                        nArray7[n22] = nArray7[n22] + nArray[n13];
                    }
                    if (nArray6[n13] != 1) continue;
                    nArray10[n13] = nArray9[n13];
                    int n23 = n13;
                    nArray9[n23] = nArray9[n23] + nArray4[n13];
                }
                n13 = n15;
                n15 += n9;
                for (n12 = n; n12 < n6; ++n12) {
                    double d2 = 0.0;
                    d = 0.0;
                    for (n11 = 0; n11 < n2; ++n11) {
                        if (rasterAccessorArray[n11] == null) continue;
                        double d3 = dArrayArray2[n11][nArray8[n11]];
                        int n24 = n11;
                        nArray8[n24] = nArray8[n24] + nArray2[n11];
                        double d4 = 0.0;
                        switch (nArray6[n11]) {
                            case 1: {
                                d4 = object3[n11][nArray10[n11]];
                                if (d4 > 0.0 && this.isAlphaBitmask) {
                                    d4 = 1.0;
                                }
                                int n25 = n11;
                                nArray10[n25] = nArray10[n25] + nArray5[n11];
                                break;
                            }
                            case 2: {
                                d4 = rasterArray[n11].getSample(n12, n14, 0) > 0 ? 1.0 : 0.0;
                                break;
                            }
                            default: {
                                d4 = d3 >= this.sourceThreshold[n11][i] ? 1.0 : 0.0;
                            }
                        }
                        d2 += d4 * d3;
                        d += d4;
                    }
                    dArray2[n13] = d == 0.0 ? this.backgroundValues[i] : d2 / d;
                    n13 += n10;
                }
            }
        }
    }
}

