/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class ConvolveOpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    private int kx;
    private int ky;

    public ConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n10 = nArray2[i];
            int n11 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n12 = n10;
                int n13 = n11;
                for (int k = 0; k < n; ++k) {
                    int n14;
                    float f = 0.5f;
                    int n15 = 0;
                    int n16 = n12;
                    for (n14 = 0; n14 < n5; ++n14) {
                        int n17 = n16;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            f += (float)(byArray4[n17] & 0xFF) * fArray[n15 + i2];
                            n17 += n8;
                        }
                        n15 += n4;
                        n16 += n9;
                    }
                    n14 = (int)f;
                    if (n14 < 0) {
                        n14 = 0;
                    } else if (n14 > 255) {
                        n14 = 255;
                    }
                    byArray3[n13] = (byte)n14;
                    n12 += n8;
                    n13 += n6;
                }
                n10 += n9;
                n11 += n7;
            }
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n10 = nArray2[i];
            int n11 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n12 = n10;
                int n13 = n11;
                for (int k = 0; k < n; ++k) {
                    int n14;
                    float f = 0.5f;
                    int n15 = 0;
                    int n16 = n12;
                    for (n14 = 0; n14 < n5; ++n14) {
                        int n17 = n16;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            f += (float)sArray4[n17] * fArray[n15 + i2];
                            n17 += n8;
                        }
                        n15 += n4;
                        n16 += n9;
                    }
                    n14 = (int)f;
                    if (n14 < Short.MIN_VALUE) {
                        n14 = Short.MIN_VALUE;
                    } else if (n14 > Short.MAX_VALUE) {
                        n14 = Short.MAX_VALUE;
                    }
                    sArray3[n13] = (short)n14;
                    n12 += n8;
                    n13 += n6;
                }
                n10 += n9;
                n11 += n7;
            }
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n10 = nArray2[i];
            int n11 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n12 = n10;
                int n13 = n11;
                for (int k = 0; k < n; ++k) {
                    int n14;
                    float f = 0.5f;
                    int n15 = 0;
                    int n16 = n12;
                    for (n14 = 0; n14 < n5; ++n14) {
                        int n17 = n16;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            f += (float)(sArray4[n17] & 0xFFFF) * fArray[n15 + i2];
                            n17 += n8;
                        }
                        n15 += n4;
                        n16 += n9;
                    }
                    n14 = (int)f;
                    if (n14 < 0) {
                        n14 = 0;
                    } else if (n14 > 65535) {
                        n14 = 65535;
                    }
                    sArray3[n13] = (short)n14;
                    n12 += n8;
                    n13 += n6;
                }
                n10 += n9;
                n11 += n7;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            int[] nArray5 = nArray[i];
            int[] nArray6 = nArray3[i];
            int n10 = nArray4[i];
            int n11 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n12 = n10;
                int n13 = n11;
                for (int k = 0; k < n; ++k) {
                    float f = 0.5f;
                    int n14 = 0;
                    int n15 = n12;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n16 = n15;
                        for (int i3 = 0; i3 < n4; ++i3) {
                            f += (float)nArray6[n16] * fArray[n14 + i3];
                            n16 += n8;
                        }
                        n14 += n4;
                        n15 += n9;
                    }
                    nArray5[n13] = (int)f;
                    n12 += n8;
                    n13 += n6;
                }
                n10 += n9;
                n11 += n7;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        float[][] fArray3 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            float[] fArray4 = fArray2[i];
            float[] fArray5 = fArray3[i];
            int n10 = nArray2[i];
            int n11 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n12 = n10;
                int n13 = n11;
                for (int k = 0; k < n; ++k) {
                    float f = 0.0f;
                    int n14 = 0;
                    int n15 = n12;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n16 = n15;
                        for (int i3 = 0; i3 < n4; ++i3) {
                            f += fArray5[n16] * fArray[n14 + i3];
                            n16 += n8;
                        }
                        n14 += n4;
                        n15 += n9;
                    }
                    fArray4[n13] = f;
                    n12 += n8;
                    n13 += n6;
                }
                n10 += n9;
                n11 += n7;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[] fArray = this.kernel.getKernelData();
        int n4 = this.kernel.getWidth();
        int n5 = this.kernel.getHeight();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n6 = rasterAccessor2.getPixelStride();
        int n7 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = rasterAccessor.getPixelStride();
        int n9 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n10 = nArray2[i];
            int n11 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                int n12 = n10;
                int n13 = n11;
                for (int k = 0; k < n; ++k) {
                    double d = 0.5;
                    int n14 = 0;
                    int n15 = n12;
                    for (int i2 = 0; i2 < n5; ++i2) {
                        int n16 = n15;
                        for (int i3 = 0; i3 < n4; ++i3) {
                            d += dArray4[n16] * (double)fArray[n14 + i3];
                            n16 += n8;
                        }
                        n14 += n4;
                        n15 += n9;
                    }
                    dArray3[n13] = d;
                    n12 += n8;
                    n13 += n6;
                }
                n10 += n9;
                n11 += n7;
            }
        }
    }
}

