/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class ConjugateOpImage
extends PointOpImage {
    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        int n = sampleModel.getTransferType();
        boolean bl = false;
        if (n == 0) {
            n = 2;
            bl = true;
        } else if (n == 1) {
            n = 3;
            bl = true;
        }
        if (bl) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, n, sampleModel.getWidth(), sampleModel.getHeight(), sampleModel.getNumBands());
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public ConjugateOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, ConjugateOpImage.layoutHelper(imageLayout, renderedImage), map, true);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ConjugateOpImage0"));
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            int n8;
            int n9;
            int n10;
            int n11;
            boolean bl = i % 2 == 0;
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            if (bl) {
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = n12;
                    n9 = n13;
                    for (n8 = 0; n8 < n; ++n8) {
                        sArray3[n9] = sArray4[n10];
                        n10 += n6;
                        n9 += n4;
                    }
                    n12 += n7;
                    n13 += n5;
                }
                continue;
            }
            for (n11 = 0; n11 < n2; ++n11) {
                n10 = n12;
                n9 = n13;
                for (n8 = 0; n8 < n; ++n8) {
                    sArray3[n9] = ImageUtil.clampShort(-sArray4[n10]);
                    n10 += n6;
                    n9 += n4;
                }
                n12 += n7;
                n13 += n5;
            }
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            int n8;
            int n9;
            int n10;
            int n11;
            boolean bl = i % 2 == 0;
            int[] nArray5 = nArray[i];
            int[] nArray6 = nArray3[i];
            int n12 = nArray4[i];
            int n13 = nArray2[i];
            if (bl) {
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = n12;
                    n9 = n13;
                    for (n8 = 0; n8 < n; ++n8) {
                        nArray5[n9] = nArray6[n10];
                        n10 += n6;
                        n9 += n4;
                    }
                    n12 += n7;
                    n13 += n5;
                }
                continue;
            }
            for (n11 = 0; n11 < n2; ++n11) {
                n10 = n12;
                n9 = n13;
                for (n8 = 0; n8 < n; ++n8) {
                    nArray5[n9] = -nArray6[n10];
                    n10 += n6;
                    n9 += n4;
                }
                n12 += n7;
                n13 += n5;
            }
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            int n8;
            int n9;
            int n10;
            int n11;
            boolean bl = i % 2 == 0;
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            if (bl) {
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = n12;
                    n9 = n13;
                    for (n8 = 0; n8 < n; ++n8) {
                        fArray3[n9] = fArray4[n10];
                        n10 += n6;
                        n9 += n4;
                    }
                    n12 += n7;
                    n13 += n5;
                }
                continue;
            }
            for (n11 = 0; n11 < n2; ++n11) {
                n10 = n12;
                n9 = n13;
                for (n8 = 0; n8 < n; ++n8) {
                    fArray3[n9] = -fArray4[n10];
                    n10 += n6;
                    n9 += n4;
                }
                n12 += n7;
                n13 += n5;
            }
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        for (int i = 0; i < n3; ++i) {
            int n8;
            int n9;
            int n10;
            int n11;
            boolean bl = i % 2 == 0;
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            int n12 = nArray2[i];
            int n13 = nArray[i];
            if (bl) {
                for (n11 = 0; n11 < n2; ++n11) {
                    n10 = n12;
                    n9 = n13;
                    for (n8 = 0; n8 < n; ++n8) {
                        dArray3[n9] = dArray4[n10];
                        n10 += n6;
                        n9 += n4;
                    }
                    n12 += n7;
                    n13 += n5;
                }
                continue;
            }
            for (n11 = 0; n11 < n2; ++n11) {
                n10 = n12;
                n9 = n13;
                for (n8 = 0; n8 < n; ++n8) {
                    dArray3[n9] = -dArray4[n10];
                    n10 += n6;
                    n9 += n4;
                }
                n12 += n7;
                n13 += n5;
            }
        }
    }
}

