/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineOpImage;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class AffineBicubic2OpImage
extends AffineOpImage {
    private int subsampleBits;
    private int shiftvalue;

    public AffineBicubic2OpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, map, imageLayout, affineTransform, interpolation, dArray);
        this.subsampleBits = interpolation.getSubsampleBitsH();
        this.shiftvalue = 1 << this.subsampleBits;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = raster.getBounds();
        int n = rectangle2.x;
        int n2 = rectangle2.y;
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rectangle, n, n2, rasterAccessor2);
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        byte[] byArray3 = new byte[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            byArray3[n3] = (byte)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            int n19 = n17 + n18 - n8 - n7;
            int n20 = n19 + n7;
            int n21 = n20 + n7;
            int n22 = n21 + n7;
            int n23 = n19 + n8;
            int n24 = n23 + n7;
            int n25 = n24 + n7;
            int n26 = n25 + n7;
            int n27 = n23 + n8;
            int n28 = n27 + n7;
            int n29 = n28 + n7;
            int n30 = n29 + n7;
            int n31 = n27 + n8;
            int n32 = n31 + n7;
            int n33 = n32 + n7;
            int n34 = n33 + n7;
            for (int i = n10; i < n12; ++i) {
                int n35;
                if ((float)n15 >= f + 1.0f && (float)n15 < f3 - 2.0f && (float)n16 >= f2 + 1.0f && (float)n16 < f4 - 2.0f) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        byte[] byArray4 = byArray2[n35];
                        int n36 = nArray2[n35];
                        int n37 = byArray4[n19 + n36] & 0xFF;
                        int n38 = byArray4[n20 + n36] & 0xFF;
                        int n39 = byArray4[n21 + n36] & 0xFF;
                        int n40 = byArray4[n22 + n36] & 0xFF;
                        int n41 = byArray4[n23 + n36] & 0xFF;
                        int n42 = byArray4[n24 + n36] & 0xFF;
                        int n43 = byArray4[n25 + n36] & 0xFF;
                        int n44 = byArray4[n26 + n36] & 0xFF;
                        int n45 = byArray4[n27 + n36] & 0xFF;
                        int n46 = byArray4[n28 + n36] & 0xFF;
                        int n47 = byArray4[n29 + n36] & 0xFF;
                        int n48 = byArray4[n30 + n36] & 0xFF;
                        int n49 = byArray4[n31 + n36] & 0xFF;
                        int n50 = byArray4[n32 + n36] & 0xFF;
                        int n51 = byArray4[n33 + n36] & 0xFF;
                        int n52 = byArray4[n34 + n36] & 0xFF;
                        int n53 = (int)(f7 * (float)this.shiftvalue);
                        int n54 = (int)(f8 * (float)this.shiftvalue);
                        float f9 = this.interp.interpolate(n37, n38, n39, n40, n41, n42, n43, n44, n45, n46, n47, n48, n49, n50, n51, n52, n53, n54);
                        int n55 = f9 < 0.5f ? 0 : (f9 > 254.5f ? 255 : (int)(f9 + 0.5f));
                        byArray[n35][n14 + nArray[n35]] = (byte)(n55 & 0xFF);
                    }
                } else if (this.setBackground) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        byArray[n35][n14 + nArray[n35]] = byArray3[n35];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    if ((f7 = (float)((double)f7 + this.fracdx)) == 1.0f) {
                        f7 = 0.999999f;
                    }
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    if ((f8 = (float)((double)f8 + this.fracdy)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n19 = n17 + n18 - n8 - n7;
                n20 = n19 + n7;
                n21 = n20 + n7;
                n22 = n21 + n7;
                n23 = n19 + n8;
                n24 = n23 + n7;
                n25 = n24 + n7;
                n26 = n25 + n7;
                n27 = n23 + n8;
                n28 = n27 + n7;
                n29 = n28 + n7;
                n30 = n29 + n7;
                n31 = n27 + n8;
                n32 = n31 + n7;
                n33 = n32 + n7;
                n34 = n33 + n7;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void intLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        int[] nArray5 = new int[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            nArray5[n3] = (int)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            int n19 = n17 + n18 - n8 - n7;
            int n20 = n19 + n7;
            int n21 = n20 + n7;
            int n22 = n21 + n7;
            int n23 = n19 + n8;
            int n24 = n23 + n7;
            int n25 = n24 + n7;
            int n26 = n25 + n7;
            int n27 = n23 + n8;
            int n28 = n27 + n7;
            int n29 = n28 + n7;
            int n30 = n29 + n7;
            int n31 = n27 + n8;
            int n32 = n31 + n7;
            int n33 = n32 + n7;
            int n34 = n33 + n7;
            for (int i = n10; i < n12; ++i) {
                int n35;
                if ((float)n15 >= f + 1.0f && (float)n15 < f3 - 2.0f && (float)n16 >= f2 + 1.0f && (float)n16 < f4 - 2.0f) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        int[] nArray6 = nArray3[n35];
                        int n36 = nArray4[n35];
                        int n37 = nArray6[n19 + n36];
                        int n38 = nArray6[n20 + n36];
                        int n39 = nArray6[n21 + n36];
                        int n40 = nArray6[n22 + n36];
                        int n41 = nArray6[n23 + n36];
                        int n42 = nArray6[n24 + n36];
                        int n43 = nArray6[n25 + n36];
                        int n44 = nArray6[n26 + n36];
                        int n45 = nArray6[n27 + n36];
                        int n46 = nArray6[n28 + n36];
                        int n47 = nArray6[n29 + n36];
                        int n48 = nArray6[n30 + n36];
                        int n49 = nArray6[n31 + n36];
                        int n50 = nArray6[n32 + n36];
                        int n51 = nArray6[n33 + n36];
                        int n52 = nArray6[n34 + n36];
                        int n53 = (int)(f7 * (float)this.shiftvalue);
                        int n54 = (int)(f8 * (float)this.shiftvalue);
                        float f9 = this.interp.interpolate(n37, n38, n39, n40, n41, n42, n43, n44, n45, n46, n47, n48, n49, n50, n51, n52, n53, n54);
                        int n55 = f9 < -2.1474836E9f ? Integer.MIN_VALUE : (f9 > 2.1474836E9f ? Integer.MAX_VALUE : ((double)f9 > 0.0 ? (int)(f9 + 0.5f) : (int)(f9 - 0.5f)));
                        nArray[n35][n14 + nArray2[n35]] = n55;
                    }
                } else if (this.setBackground) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        nArray[n35][n14 + nArray2[n35]] = nArray5[n35];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    if ((f7 = (float)((double)f7 + this.fracdx)) == 1.0f) {
                        f7 = 0.999999f;
                    }
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    if ((f8 = (float)((double)f8 + this.fracdy)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n19 = n17 + n18 - n8 - n7;
                n20 = n19 + n7;
                n21 = n20 + n7;
                n22 = n21 + n7;
                n23 = n19 + n8;
                n24 = n23 + n7;
                n25 = n24 + n7;
                n26 = n25 + n7;
                n27 = n23 + n8;
                n28 = n27 + n7;
                n29 = n28 + n7;
                n30 = n29 + n7;
                n31 = n27 + n8;
                n32 = n31 + n7;
                n33 = n32 + n7;
                n34 = n33 + n7;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void shortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            sArray3[n3] = (short)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            int n19 = n17 + n18 - n8 - n7;
            int n20 = n19 + n7;
            int n21 = n20 + n7;
            int n22 = n21 + n7;
            int n23 = n19 + n8;
            int n24 = n23 + n7;
            int n25 = n24 + n7;
            int n26 = n25 + n7;
            int n27 = n23 + n8;
            int n28 = n27 + n7;
            int n29 = n28 + n7;
            int n30 = n29 + n7;
            int n31 = n27 + n8;
            int n32 = n31 + n7;
            int n33 = n32 + n7;
            int n34 = n33 + n7;
            for (int i = n10; i < n12; ++i) {
                int n35;
                if ((float)n15 >= f + 1.0f && (float)n15 < f3 - 2.0f && (float)n16 >= f2 + 1.0f && (float)n16 < f4 - 2.0f) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        short[] sArray4 = sArray2[n35];
                        int n36 = nArray2[n35];
                        short s = sArray4[n19 + n36];
                        short s2 = sArray4[n20 + n36];
                        short s3 = sArray4[n21 + n36];
                        short s4 = sArray4[n22 + n36];
                        short s5 = sArray4[n23 + n36];
                        short s6 = sArray4[n24 + n36];
                        short s7 = sArray4[n25 + n36];
                        short s8 = sArray4[n26 + n36];
                        short s9 = sArray4[n27 + n36];
                        short s10 = sArray4[n28 + n36];
                        short s11 = sArray4[n29 + n36];
                        short s12 = sArray4[n30 + n36];
                        short s13 = sArray4[n31 + n36];
                        short s14 = sArray4[n32 + n36];
                        short s15 = sArray4[n33 + n36];
                        short s16 = sArray4[n34 + n36];
                        int n37 = (int)(f7 * (float)this.shiftvalue);
                        int n38 = (int)(f8 * (float)this.shiftvalue);
                        float f9 = this.interp.interpolate(s, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, n37, n38);
                        int n39 = f9 < -32768.0f ? Short.MIN_VALUE : (f9 > 32767.0f ? Short.MAX_VALUE : ((double)f9 > 0.0 ? (int)((short)(f9 + 0.5f)) : (int)((short)(f9 - 0.5f))));
                        sArray[n35][n14 + nArray[n35]] = n39;
                    }
                } else if (this.setBackground) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        sArray[n35][n14 + nArray[n35]] = sArray3[n35];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    if ((f7 = (float)((double)f7 + this.fracdx)) == 1.0f) {
                        f7 = 0.999999f;
                    }
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    if ((f8 = (float)((double)f8 + this.fracdy)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n19 = n17 + n18 - n8 - n7;
                n20 = n19 + n7;
                n21 = n20 + n7;
                n22 = n21 + n7;
                n23 = n19 + n8;
                n24 = n23 + n7;
                n25 = n24 + n7;
                n26 = n25 + n7;
                n27 = n23 + n8;
                n28 = n27 + n7;
                n29 = n28 + n7;
                n30 = n29 + n7;
                n31 = n27 + n8;
                n32 = n31 + n7;
                n33 = n32 + n7;
                n34 = n33 + n7;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void ushortLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        short[] sArray3 = new short[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            sArray3[n3] = (short)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            int n19 = n17 + n18 - n8 - n7;
            int n20 = n19 + n7;
            int n21 = n20 + n7;
            int n22 = n21 + n7;
            int n23 = n19 + n8;
            int n24 = n23 + n7;
            int n25 = n24 + n7;
            int n26 = n25 + n7;
            int n27 = n23 + n8;
            int n28 = n27 + n7;
            int n29 = n28 + n7;
            int n30 = n29 + n7;
            int n31 = n27 + n8;
            int n32 = n31 + n7;
            int n33 = n32 + n7;
            int n34 = n33 + n7;
            for (int i = n10; i < n12; ++i) {
                int n35;
                if ((float)n15 >= f + 1.0f && (float)n15 < f3 - 2.0f && (float)n16 >= f2 + 1.0f && (float)n16 < f4 - 2.0f) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        short[] sArray4 = sArray2[n35];
                        int n36 = nArray2[n35];
                        int n37 = sArray4[n19 + n36] & 0xFFFF;
                        int n38 = sArray4[n20 + n36] & 0xFFFF;
                        int n39 = sArray4[n21 + n36] & 0xFFFF;
                        int n40 = sArray4[n22 + n36] & 0xFFFF;
                        int n41 = sArray4[n23 + n36] & 0xFFFF;
                        int n42 = sArray4[n24 + n36] & 0xFFFF;
                        int n43 = sArray4[n25 + n36] & 0xFFFF;
                        int n44 = sArray4[n26 + n36] & 0xFFFF;
                        int n45 = sArray4[n27 + n36] & 0xFFFF;
                        int n46 = sArray4[n28 + n36] & 0xFFFF;
                        int n47 = sArray4[n29 + n36] & 0xFFFF;
                        int n48 = sArray4[n30 + n36] & 0xFFFF;
                        int n49 = sArray4[n31 + n36] & 0xFFFF;
                        int n50 = sArray4[n32 + n36] & 0xFFFF;
                        int n51 = sArray4[n33 + n36] & 0xFFFF;
                        int n52 = sArray4[n34 + n36] & 0xFFFF;
                        int n53 = (int)(f7 * (float)this.shiftvalue);
                        int n54 = (int)(f8 * (float)this.shiftvalue);
                        float f9 = this.interp.interpolate(n37, n38, n39, n40, n41, n42, n43, n44, n45, n46, n47, n48, n49, n50, n51, n52, n53, n54);
                        int n55 = (double)f9 < 0.0 ? 0 : (f9 > 65535.0f ? 65535 : (int)(f9 + 0.5f));
                        sArray[n35][n14 + nArray[n35]] = (short)(n55 & 0xFFFF);
                    }
                } else if (this.setBackground) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        sArray[n35][n14 + nArray[n35]] = sArray3[n35];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    if ((f7 = (float)((double)f7 + this.fracdx)) == 1.0f) {
                        f7 = 0.999999f;
                    }
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    if ((f8 = (float)((double)f8 + this.fracdy)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n19 = n17 + n18 - n8 - n7;
                n20 = n19 + n7;
                n21 = n20 + n7;
                n22 = n21 + n7;
                n23 = n19 + n8;
                n24 = n23 + n7;
                n25 = n24 + n7;
                n26 = n25 + n7;
                n27 = n23 + n8;
                n28 = n27 + n7;
                n29 = n28 + n7;
                n30 = n29 + n7;
                n31 = n27 + n8;
                n32 = n31 + n7;
                n33 = n32 + n7;
                n34 = n33 + n7;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void floatLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        int n3;
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n4 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getNumBands();
        int n10 = rectangle.x;
        int n11 = rectangle.y;
        int n12 = rectangle.x + rectangle.width;
        int n13 = rectangle.y + rectangle.height;
        float[] fArray3 = new float[n9];
        for (n3 = 0; n3 < n9; ++n3) {
            fArray3[n3] = (float)this.backgroundValues[n3];
        }
        for (n3 = n11; n3 < n13; ++n3) {
            int n14 = n4;
            ((Point2D)float_).setLocation((double)n10 + 0.5, (double)n3 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f5 = (float)((Point2D)float_2).getX();
            float f6 = (float)((Point2D)float_2).getY();
            f5 = (float)((double)f5 - 0.5);
            f6 = (float)((double)f6 - 0.5);
            int n15 = (int)Math.floor(f5);
            int n16 = (int)Math.floor(f6);
            float f7 = f5 - (float)n15;
            float f8 = f6 - (float)n16;
            int n17 = (n15 - n) * n7;
            int n18 = (n16 - n2) * n8;
            int n19 = n17 + n18 - n8 - n7;
            int n20 = n19 + n7;
            int n21 = n20 + n7;
            int n22 = n21 + n7;
            int n23 = n19 + n8;
            int n24 = n23 + n7;
            int n25 = n24 + n7;
            int n26 = n25 + n7;
            int n27 = n23 + n8;
            int n28 = n27 + n7;
            int n29 = n28 + n7;
            int n30 = n29 + n7;
            int n31 = n27 + n8;
            int n32 = n31 + n7;
            int n33 = n32 + n7;
            int n34 = n33 + n7;
            for (int i = n10; i < n12; ++i) {
                int n35;
                if ((float)n15 >= f + 1.0f && (float)n15 < f3 - 2.0f && (float)n16 >= f2 + 1.0f && (float)n16 < f4 - 2.0f) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        float f9;
                        float[] fArray4 = fArray2[n35];
                        int n36 = nArray2[n35];
                        float f10 = fArray4[n19 + n36];
                        float f11 = fArray4[n20 + n36];
                        float f12 = fArray4[n21 + n36];
                        float f13 = fArray4[n22 + n36];
                        float f14 = fArray4[n23 + n36];
                        float f15 = fArray4[n24 + n36];
                        float f16 = fArray4[n25 + n36];
                        float f17 = fArray4[n26 + n36];
                        float f18 = fArray4[n27 + n36];
                        float f19 = fArray4[n28 + n36];
                        float f20 = fArray4[n29 + n36];
                        float f21 = fArray4[n30 + n36];
                        float f22 = fArray4[n31 + n36];
                        float f23 = fArray4[n32 + n36];
                        float f24 = fArray4[n33 + n36];
                        float f25 = fArray4[n34 + n36];
                        fArray[n35][n14 + nArray[n35]] = f9 = this.interp.interpolate(f10, f11, f12, f13, f14, f15, f16, f17, f18, f19, f20, f21, f22, f23, f24, f25, f7, f8);
                    }
                } else if (this.setBackground) {
                    for (n35 = 0; n35 < n9; ++n35) {
                        fArray[n35][n14 + nArray[n35]] = fArray3[n35];
                    }
                }
                if ((double)f7 < this.fracdx1) {
                    n15 += this.incx;
                    if ((f7 = (float)((double)f7 + this.fracdx)) == 1.0f) {
                        f7 = 0.999999f;
                    }
                } else {
                    n15 += this.incx1;
                    f7 = (float)((double)f7 - this.fracdx1);
                }
                if ((double)f8 < this.fracdy1) {
                    n16 += this.incy;
                    if ((f8 = (float)((double)f8 + this.fracdy)) == 1.0f) {
                        f8 = 0.999999f;
                    }
                } else {
                    n16 += this.incy1;
                    f8 = (float)((double)f8 - this.fracdy1);
                }
                n17 = (n15 - n) * n7;
                n18 = (n16 - n2) * n8;
                n19 = n17 + n18 - n8 - n7;
                n20 = n19 + n7;
                n21 = n20 + n7;
                n22 = n21 + n7;
                n23 = n19 + n8;
                n24 = n23 + n7;
                n25 = n24 + n7;
                n26 = n25 + n7;
                n27 = n23 + n8;
                n28 = n27 + n7;
                n29 = n28 + n7;
                n30 = n29 + n7;
                n31 = n27 + n8;
                n32 = n31 + n7;
                n33 = n32 + n7;
                n34 = n33 + n7;
                n14 += n5;
            }
            n4 += n6;
        }
    }

    private void doubleLoop(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2, RasterAccessor rasterAccessor2) {
        float f = rasterAccessor.getX();
        float f2 = rasterAccessor.getY();
        float f3 = f + (float)rasterAccessor.getWidth();
        float f4 = f2 + (float)rasterAccessor.getHeight();
        int n3 = 0;
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        int n8 = rasterAccessor2.getNumBands();
        int n9 = rectangle.x;
        int n10 = rectangle.y;
        int n11 = rectangle.x + rectangle.width;
        int n12 = rectangle.y + rectangle.height;
        for (int i = n10; i < n12; ++i) {
            int n13 = n3;
            ((Point2D)float_).setLocation((double)n9 + 0.5, (double)i + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            double d = ((Point2D)float_2).getX();
            double d2 = ((Point2D)float_2).getY();
            int n14 = (int)Math.floor(d -= 0.5);
            int n15 = (int)Math.floor(d2 -= 0.5);
            double d3 = d - (double)n14;
            double d4 = d2 - (double)n15;
            int n16 = (n14 - n) * n6;
            int n17 = (n15 - n2) * n7;
            int n18 = n16 + n17 - n7 - n6;
            int n19 = n18 + n6;
            int n20 = n19 + n6;
            int n21 = n20 + n6;
            int n22 = n18 + n7;
            int n23 = n22 + n6;
            int n24 = n23 + n6;
            int n25 = n24 + n6;
            int n26 = n22 + n7;
            int n27 = n26 + n6;
            int n28 = n27 + n6;
            int n29 = n28 + n6;
            int n30 = n26 + n7;
            int n31 = n30 + n6;
            int n32 = n31 + n6;
            int n33 = n32 + n6;
            for (int j = n9; j < n11; ++j) {
                int n34;
                if ((float)n14 >= f + 1.0f && (float)n14 < f3 - 2.0f && (float)n15 >= f2 + 1.0f && (float)n15 < f4 - 2.0f) {
                    for (n34 = 0; n34 < n8; ++n34) {
                        double d5;
                        double[] dArray3 = dArray2[n34];
                        int n35 = nArray2[n34];
                        double d6 = dArray3[n18 + n35];
                        double d7 = dArray3[n19 + n35];
                        double d8 = dArray3[n20 + n35];
                        double d9 = dArray3[n21 + n35];
                        double d10 = dArray3[n22 + n35];
                        double d11 = dArray3[n23 + n35];
                        double d12 = dArray3[n24 + n35];
                        double d13 = dArray3[n25 + n35];
                        double d14 = dArray3[n26 + n35];
                        double d15 = dArray3[n27 + n35];
                        double d16 = dArray3[n28 + n35];
                        double d17 = dArray3[n29 + n35];
                        double d18 = dArray3[n30 + n35];
                        double d19 = dArray3[n31 + n35];
                        double d20 = dArray3[n32 + n35];
                        double d21 = dArray3[n33 + n35];
                        dArray[n34][n13 + nArray[n34]] = d5 = this.interp.interpolate(d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17, d18, d19, d20, d21, (float)d3, (float)d4);
                    }
                } else if (this.setBackground) {
                    for (n34 = 0; n34 < n8; ++n34) {
                        dArray[n34][n13 + nArray[n34]] = this.backgroundValues[n34];
                    }
                }
                if (d3 < this.fracdx1) {
                    n14 += this.incx;
                    if ((d3 += this.fracdx) == 1.0) {
                        d3 = 0.999999;
                    }
                } else {
                    n14 += this.incx1;
                    d3 -= this.fracdx1;
                }
                if (d4 < this.fracdy1) {
                    n15 += this.incy;
                    if ((d4 += this.fracdy) == 1.0) {
                        d4 = 0.999999;
                    }
                } else {
                    n15 += this.incy1;
                    d4 -= this.fracdy1;
                }
                n16 = (n14 - n) * n6;
                n17 = (n15 - n2) * n7;
                n18 = n16 + n17 - n7 - n6;
                n19 = n18 + n6;
                n20 = n19 + n6;
                n21 = n20 + n6;
                n22 = n18 + n7;
                n23 = n22 + n6;
                n24 = n23 + n6;
                n25 = n24 + n6;
                n26 = n22 + n7;
                n27 = n26 + n6;
                n28 = n27 + n6;
                n29 = n28 + n6;
                n30 = n26 + n7;
                n31 = n30 + n6;
                n32 = n31 + n6;
                n33 = n32 + n6;
                n13 += n4;
            }
            n3 += n5;
        }
    }
}

