/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Iterator;
import java.util.TreeMap;
import javax.media.jai.Histogram;
import javax.media.jai.StatisticsOpImage;

final class MlibHistogramOpImage
extends StatisticsOpImage {
    private int[] numBins;
    private double[] lowValueFP;
    private double[] highValueFP;
    private int[] lowValue;
    private int[] highValue;
    private int numBands = this.sampleModel.getNumBands();
    private int[] bandIndexMap;
    private boolean reorderBands = false;

    public MlibHistogramOpImage(RenderedImage renderedImage, int n, int n2, int[] nArray, double[] dArray, double[] dArray2) {
        super(renderedImage, null, renderedImage.getMinX(), renderedImage.getMinY(), n, n2);
        int n3;
        this.numBins = new int[this.numBands];
        this.lowValueFP = new double[this.numBands];
        this.highValueFP = new double[this.numBands];
        for (n3 = 0; n3 < this.numBands; ++n3) {
            this.numBins[n3] = nArray.length == 1 ? nArray[0] : nArray[n3];
            this.lowValueFP[n3] = dArray.length == 1 ? dArray[0] : dArray[n3];
            this.highValueFP[n3] = dArray2.length == 1 ? dArray2[0] : dArray2[n3];
        }
        this.lowValue = new int[this.lowValueFP.length];
        for (n3 = 0; n3 < this.lowValueFP.length; ++n3) {
            this.lowValue[n3] = (int)Math.ceil(this.lowValueFP[n3]);
        }
        this.highValue = new int[this.highValueFP.length];
        for (n3 = 0; n3 < this.highValueFP.length; ++n3) {
            this.highValue[n3] = (int)Math.ceil(this.highValueFP[n3]);
        }
        if (this.numBands > 1) {
            int n4;
            int n5;
            int n6;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
            int[] nArray2 = componentSampleModel.getBankIndices();
            boolean bl = false;
            for (n6 = 1; n6 < this.numBands; ++n6) {
                if (nArray2[n6] == nArray2[n6 - 1]) continue;
                bl = true;
                break;
            }
            if (bl) {
                for (n6 = 0; n6 < this.numBands; ++n6) {
                    treeMap.put(new Integer(nArray2[n6]), new Integer(n6));
                }
                this.bandIndexMap = new int[this.numBands];
                Iterator iterator = treeMap.keySet().iterator();
                n5 = 0;
                while (iterator.hasNext()) {
                    n4 = (Integer)treeMap.get(iterator.next());
                    if (n4 != n5) {
                        this.reorderBands = true;
                    }
                    this.bandIndexMap[n5++] = n4;
                }
            }
            if (!this.reorderBands) {
                treeMap.clear();
                if (this.bandIndexMap == null) {
                    this.bandIndexMap = new int[this.numBands];
                }
                int[] nArray3 = componentSampleModel.getBandOffsets();
                for (n5 = 0; n5 < this.numBands; ++n5) {
                    treeMap.put(new Integer(nArray3[n5]), new Integer(n5));
                }
                Iterator iterator = treeMap.keySet().iterator();
                n4 = 0;
                while (iterator.hasNext()) {
                    int n7 = (Integer)treeMap.get(iterator.next());
                    if (n7 != n4) {
                        this.reorderBands = true;
                    }
                    this.bandIndexMap[n4++] = n7;
                }
            }
        }
    }

    protected String[] getStatisticsNames() {
        String[] stringArray = new String[]{"histogram"};
        return stringArray;
    }

    protected Object createStatistics(String string) {
        if (string.equalsIgnoreCase("histogram")) {
            return new Histogram(this.numBins, this.lowValueFP, this.highValueFP);
        }
        return Image.UndefinedProperty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accumulateStatistics(String string, Raster raster, Object object) {
        int n;
        Object object2;
        Histogram histogram = (Histogram)object;
        int n2 = histogram.getNumBands();
        int[][] nArray = histogram.getBins();
        Rectangle rectangle = raster.getBounds();
        if (!this.reorderBands && rectangle.equals(this.getBounds())) {
            object2 = nArray;
        } else {
            object2 = new int[n2][];
            for (n = 0; n < n2; ++n) {
                object2[n] = new int[histogram.getNumBins(n)];
            }
        }
        n = MediaLibAccessor.findCompatibleTag(null, raster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        int n3 = (this.xPeriod - (rectangle.x - this.xStart) % this.xPeriod) % this.xPeriod;
        int n4 = (this.yPeriod - (rectangle.y - this.yStart) % this.yPeriod) % this.yPeriod;
        if (object2 == nArray) {
            Histogram histogram2 = histogram;
            synchronized (histogram2) {
                com.sun.medialib.mlib.Image.Histogram2((int[][])object2, (mediaLibImage)mediaLibImageArray[0], (int[])this.lowValue, (int[])this.highValue, (int)n3, (int)n4, (int)this.xPeriod, (int)this.yPeriod);
            }
        }
        com.sun.medialib.mlib.Image.Histogram2((int[][])object2, (mediaLibImage)mediaLibImageArray[0], (int[])this.lowValue, (int[])this.highValue, (int)n3, (int)n4, (int)this.xPeriod, (int)this.yPeriod);
        Histogram histogram3 = histogram;
        synchronized (histogram3) {
            for (int i = 0; i < n2; ++i) {
                int n5 = object2[i].length;
                int[] nArray2 = this.reorderBands ? nArray[this.bandIndexMap[i]] : nArray[i];
                int[] nArray3 = object2[i];
                for (int j = 0; j < n5; ++j) {
                    int n6 = j;
                    nArray2[n6] = nArray2[n6] + nArray3[j];
                }
            }
        }
    }
}

