/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;

final class MlibConvolve3x3Or5x5OpImage
extends AreaOpImage {
    protected KernelJAI kernel;
    private int kw;
    private int kh;
    float[] kData;
    double[] doublekData;
    int[] intkData;
    int shift = -1;

    public MlibConvolve3x3Or5x5OpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kData = kernelJAI.getKernelData();
        int n = this.kw * this.kh;
        this.intkData = new int[n];
        this.doublekData = new double[n];
        for (int i = 0; i < n; ++i) {
            this.doublekData[i] = this.kData[i];
        }
    }

    private synchronized void setShift(int n) {
        if (this.shift == -1) {
            int n2 = MediaLibAccessor.getMediaLibDataType(n);
            this.shift = Image.ConvKernelConvert((int[])this.intkData, (double[])this.doublekData, (int)this.kw, (int)this.kh, (int)n2);
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n, true);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n, true);
        int n2 = this.getSampleModel().getNumBands();
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        block4: for (int i = 0; i < mediaLibImageArray2.length; ++i) {
            switch (mediaLibAccessor2.getDataType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (this.shift == -1) {
                        this.setShift(n);
                    }
                    if (this.kw == 3) {
                        Image.Conv3x3((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (int[])this.intkData, (int)this.shift, (int)((1 << n2) - 1), (int)0);
                        continue block4;
                    }
                    Image.Conv5x5((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (int[])this.intkData, (int)this.shift, (int)((1 << n2) - 1), (int)0);
                    continue block4;
                }
                case 4: 
                case 5: {
                    if (this.kw == 3) {
                        Image.Conv3x3_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.doublekData, (int)((1 << n2) - 1), (int)0);
                        continue block4;
                    }
                    Image.Conv5x5_Fp((mediaLibImage)mediaLibImageArray2[i], (mediaLibImage)mediaLibImageArray[i], (double[])this.doublekData, (int)((1 << n2) - 1), (int)0);
                    continue block4;
                }
                default: {
                    String string = this.getClass().getName();
                    throw new RuntimeException(JaiI18N.getString("Generic2"));
                }
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

