/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils.concurrent;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = -8799170460903375842L;
    private AtomicLongArray larray;

    public AtomicDoubleArray(int length) {
        this.larray = new AtomicLongArray(length);
        long ZERO = Double.doubleToRawLongBits(0.0);
        for (int i = 0; i < length; ++i) {
            this.larray.set(i, ZERO);
        }
    }

    public AtomicDoubleArray(double[] array) {
        this(array.length);
        for (int i = 0; i < array.length; ++i) {
            this.set(i, array[i]);
        }
    }

    public double getAndIncrement(int i) {
        return this.getAndAdd(i, 1.0);
    }

    public double getAndDecrement(int i) {
        return this.getAndAdd(i, -1.0);
    }

    public double getAndAdd(int i, double delta) {
        double newVal;
        double orig;
        while (!this.compareAndSet(i, orig = this.get(i), newVal = orig + delta)) {
        }
        return orig;
    }

    public double addAndGet(int i, double delta) {
        double newVal;
        double orig;
        while (!this.compareAndSet(i, orig = this.get(i), newVal = orig + delta)) {
        }
        return newVal;
    }

    public double getAndSet(int i, double newValue) {
        long oldL = this.larray.getAndSet(i, Double.doubleToRawLongBits(newValue));
        return Double.longBitsToDouble(oldL);
    }

    public void set(int i, double newValue) {
        this.larray.set(i, Double.doubleToRawLongBits(newValue));
    }

    public void lazySet(int i, double newValue) {
        this.larray.lazySet(i, Double.doubleToRawLongBits(newValue));
    }

    public boolean compareAndSet(int i, double expected, double update) {
        long expectedL = Double.doubleToRawLongBits(expected);
        long updateL = Double.doubleToRawLongBits(update);
        return this.larray.compareAndSet(i, expectedL, updateL);
    }

    public boolean weakCompareAndSet(int i, double expected, double update) {
        long expectedL = Double.doubleToRawLongBits(expected);
        long updateL = Double.doubleToRawLongBits(update);
        return this.larray.weakCompareAndSet(i, expectedL, updateL);
    }

    public double get(int i) {
        return Double.longBitsToDouble(this.larray.get(i));
    }

    public int length() {
        return this.larray.length();
    }
}

