/*
 * Decompiled with CFR 0.152.
 */
package jsat.utils;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class LongList
extends AbstractList<Long>
implements Serializable {
    private static final long serialVersionUID = 3060216677615816178L;
    private long[] array;
    private int end;

    private LongList(long[] array, int end) {
        this.array = array;
        this.end = end;
    }

    public LongList() {
        this(10);
    }

    @Override
    public void clear() {
        this.end = 0;
    }

    public LongList(int capacity) {
        this.array = new long[capacity];
        this.end = 0;
    }

    public LongList(Collection<Long> c) {
        this(c.size());
        this.addAll(c);
    }

    @Override
    public long set(int index, long element) {
        this.boundsCheck(index);
        long prev = this.array[index];
        this.array[index] = element;
        return prev;
    }

    @Override
    public Long set(int index, Long element) {
        return this.set(index, (long)element);
    }

    @Override
    public void add(int index, long element) {
        this.boundsCheck(index);
        this.enlargeIfNeeded(1);
        System.arraycopy(this.array, index, this.array, index + 1, this.end - index);
        this.array[index] = element;
    }

    @Override
    public void add(int index, Long element) {
        this.add(index, (long)element);
    }

    @Override
    public boolean add(long e) {
        this.enlargeIfNeeded(1);
        this.array[this.end++] = e;
        return true;
    }

    @Override
    public boolean add(Long e) {
        if (e == null) {
            return false;
        }
        return this.add((long)e);
    }

    public long getL(int index) {
        this.boundsCheck(index);
        return this.array[index];
    }

    @Override
    public Long get(int index) {
        return this.getL(index);
    }

    private void boundsCheck(int index) throws IndexOutOfBoundsException {
        if (index >= this.end) {
            throw new IndexOutOfBoundsException("List of of size " + this.size() + ", index requested was " + index);
        }
    }

    @Override
    public int size() {
        return this.end;
    }

    @Override
    public Long remove(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Can not remove invalid index " + index);
        }
        long removed = this.array[index];
        for (int i = index; i < this.end - 1; ++i) {
            this.array[i] = this.array[i + 1];
        }
        --this.end;
        return removed;
    }

    private void enlargeIfNeeded(int i) {
        while (this.end + i > this.array.length) {
            this.array = Arrays.copyOf(this.array, Math.max(this.array.length * 2, 8));
        }
    }

    public static List<Long> view(long[] array, int length) {
        return new LongList(array, length);
    }
}

