/*
 * Decompiled with CFR 0.152.
 */
package jsat.text.wordweighting;

import java.util.List;
import jsat.linear.IndexValue;
import jsat.linear.Vec;
import jsat.text.wordweighting.WordWeighting;

public class OkapiBM25
extends WordWeighting {
    private static final long serialVersionUID = 6456657674702490465L;
    private double k1;
    private double b;
    private double N;
    private double docAvg;
    private int[] df;

    public OkapiBM25() {
        this(1.5, 0.75);
    }

    public OkapiBM25(double k1, double b) {
        if (Double.isNaN(k1) || Double.isInfinite(k1) || k1 < 0.0) {
            throw new IllegalArgumentException("coefficient k1 must be a non negative constant, not " + k1);
        }
        this.k1 = k1;
        if (Double.isNaN(b) || b < 0.0 || b > 1.0) {
            throw new IllegalArgumentException("coefficient b must be in the range [0,1], not " + b);
        }
        this.b = b;
    }

    @Override
    public void setWeight(List<? extends Vec> allDocuments, List<Integer> df) {
        this.df = new int[df.size()];
        this.docAvg = 0.0;
        for (Vec vec : allDocuments) {
            for (IndexValue iv : vec) {
                this.docAvg += iv.getValue();
                int n = iv.getIndex();
                this.df[n] = this.df[n] + 1;
            }
        }
        this.N = allDocuments.size();
        this.docAvg /= this.N;
    }

    @Override
    public void applyTo(Vec vec) {
        double sum = vec.sum();
        for (IndexValue iv : vec) {
            double value = iv.getValue();
            int index = iv.getIndex();
            double idf = Math.log((this.N - (double)this.df[index] + 0.5) / ((double)this.df[index] + 0.5));
            double result = idf * (value * (this.k1 + 1.0)) / (value + this.k1 * (1.0 - this.b + this.b * sum / this.docAvg));
            vec.set(index, result);
        }
    }

    @Override
    public double indexFunc(double value, int index) {
        if (index < 0 || value == 0.0) {
            return 0.0;
        }
        return 0.0;
    }
}

