/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.rootfinding;

import jsat.linear.Vec;
import jsat.math.Function;
import jsat.math.rootfinding.RootFinder;

public class Bisection
implements RootFinder {
    private static final long serialVersionUID = -8107160048637997385L;

    public static double root(double a, double b, Function f, double ... args) {
        return Bisection.root(1.0E-15, 1000, a, b, 0, f, args);
    }

    public static double root(double eps, double a, double b, Function f, double ... args) {
        return Bisection.root(eps, 1000, a, b, 0, f, args);
    }

    public static double root(double eps, double a, double b, int pos, Function f, double ... args) {
        return Bisection.root(eps, 1000, a, b, pos, f, args);
    }

    public static double root(double eps, int maxIterations, double a, double b, int pos, Function f, double ... args) {
        if (b <= a) {
            throw new ArithmeticException("a musbt be < b for Bisection to work");
        }
        if (args == null || args.length == 0) {
            pos = 0;
            args = new double[1];
        }
        args[pos] = b;
        double fb = f.f(args);
        args[pos] = a;
        double fa = f.f(args);
        if (fa * fb >= 0.0) {
            throw new ArithmeticException("The given interval does not appear to bracket the root");
        }
        while (b - a > 2.0 * eps && maxIterations-- > 0) {
            args[pos] = (a + b) * 0.5;
            double ftmp = f.f(args);
            if (fa * ftmp < 0.0) {
                b = args[pos];
                fb = ftmp;
                continue;
            }
            if (!(fb * ftmp < 0.0)) break;
            a = args[pos];
            fa = ftmp;
        }
        return (a + b) * 0.5;
    }

    @Override
    public double root(double eps, int maxIterations, double[] initialGuesses, Function f, int pos, double ... args) {
        return Bisection.root(eps, maxIterations, initialGuesses[0], initialGuesses[1], pos, f, args);
    }

    @Override
    public double root(double eps, int maxIterations, double[] initialGuesses, Function f, int pos, Vec args) {
        return Bisection.root(eps, maxIterations, initialGuesses[0], initialGuesses[1], pos, f, args.arrayCopy());
    }

    @Override
    public int guessesNeeded() {
        return 2;
    }
}

