/*
 * Decompiled with CFR 0.152.
 */
package jsat.math.decayrates;

import java.util.List;
import jsat.math.decayrates.DecayRate;
import jsat.parameters.Parameter;
import jsat.parameters.Parameterized;

public class LinearDecay
implements DecayRate,
Parameterized {
    private static final long serialVersionUID = 4934146018742844875L;
    private double min;
    private double maxTime;

    public LinearDecay() {
        this(1.0E-4, 100000.0);
    }

    public LinearDecay(double min, double maxTime) {
        this.setMinRate(min);
        this.setMaxTime(maxTime);
    }

    public void setMinRate(double min) {
        if (min <= 0.0 || Double.isNaN(min) || Double.isInfinite(min)) {
            throw new RuntimeException("minRate should be positive, not " + min);
        }
        this.min = min;
    }

    public double getMinRate() {
        return this.min;
    }

    public void setMaxTime(double maxTime) {
        if (maxTime <= 0.0 || Double.isInfinite(maxTime) || Double.isNaN(maxTime)) {
            throw new RuntimeException("maxTime should be positive, not " + maxTime);
        }
        this.maxTime = maxTime;
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    @Override
    public double rate(double time, double maxTime, double initial) {
        if (time < 0.0) {
            throw new ArithmeticException("Negative time value given");
        }
        return (initial - this.min) * (1.0 - Math.min(time, maxTime) / maxTime) + this.min;
    }

    @Override
    public double rate(double time, double initial) {
        return this.rate(time, this.maxTime, initial);
    }

    @Override
    public DecayRate clone() {
        return new LinearDecay(this.min, this.maxTime);
    }

    public String toString() {
        return "Linear Decay";
    }

    @Override
    public List<Parameter> getParameters() {
        return Parameter.getParamsFromMethods(this);
    }

    @Override
    public Parameter getParameter(String paramName) {
        return Parameter.toParameterMap(this.getParameters()).get(paramName);
    }
}

