/*
 * Decompiled with CFR 0.152.
 */
package jsat.lossfunctions;

import jsat.classifiers.CategoricalResults;
import jsat.lossfunctions.LossC;

public class LogisticLoss
implements LossC {
    private static final long serialVersionUID = -3929171604513497068L;

    public static double loss(double pred, double y) {
        double x = -y * pred;
        if (x >= 30.0) {
            return x;
        }
        if (x <= -30.0) {
            return 0.0;
        }
        return Math.log(1.0 + Math.exp(x));
    }

    public static double deriv(double pred, double y) {
        double x = y * pred;
        if (x >= 30.0) {
            return 0.0;
        }
        if (x <= -30.0) {
            return y;
        }
        return -y / (1.0 + Math.exp(y * pred));
    }

    public static double deriv2(double pred, double y) {
        double x = y * pred;
        if (x >= 30.0) {
            return 0.0;
        }
        if (x <= -30.0) {
            return 0.0;
        }
        double p = 1.0 / (1.0 + Math.exp(y * pred));
        return p * (1.0 - p);
    }

    public static CategoricalResults classify(double score) {
        CategoricalResults cr = new CategoricalResults(2);
        double p = score > 30.0 ? 1.0 : (score < -30.0 ? 0.0 : 1.0 / (1.0 + Math.exp(-score)));
        cr.setProb(0, 1.0 - p);
        cr.setProb(1, p);
        return cr;
    }

    @Override
    public double getLoss(double pred, double y) {
        return LogisticLoss.loss(pred, y);
    }

    @Override
    public double getDeriv(double pred, double y) {
        return LogisticLoss.deriv(pred, y);
    }

    @Override
    public double getDeriv2(double pred, double y) {
        return LogisticLoss.deriv2(pred, y);
    }

    @Override
    public double getDeriv2Max() {
        return 0.25;
    }

    @Override
    public LogisticLoss clone() {
        return this;
    }

    @Override
    public CategoricalResults getClassification(double score) {
        return LogisticLoss.classify(score);
    }
}

