/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection.lsh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import jsat.linear.DenseMatrix;
import jsat.linear.DenseVector;
import jsat.linear.Matrix;
import jsat.linear.RandomMatrix;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.VecPairedComparable;
import jsat.linear.distancemetrics.CosineDistance;
import jsat.linear.distancemetrics.CosineDistanceNormalized;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.utils.BoundedSortedList;
import jsat.utils.random.XOR96;

public class RandomProjectionLSH<V extends Vec>
implements VectorCollection<V> {
    private static final long serialVersionUID = -2042964665052386855L;
    private static final int NO_POOL = -1;
    private Matrix randProjMatrix;
    private int[] projections;
    private int slotsPerEntry;
    private List<V> vecs;
    private ThreadLocal<Vec> tempVecs;

    public RandomProjectionLSH(List<V> vecs, int ints, boolean inMemory) {
        this.randProjMatrix = new NormalMatrix(ints * 32, ((Vec)vecs.get(0)).length(), -1);
        if (inMemory) {
            DenseMatrix dense = new DenseMatrix(this.randProjMatrix.rows(), this.randProjMatrix.cols());
            dense.mutableAdd(this.randProjMatrix);
            this.randProjMatrix = dense;
        }
        this.setUpVecs(vecs);
    }

    public RandomProjectionLSH(List<V> vecs, int ints, int poolSize) {
        this.randProjMatrix = new NormalMatrix(ints * 32, ((Vec)vecs.get(0)).length(), poolSize);
        this.setUpVecs(vecs);
    }

    protected RandomProjectionLSH(RandomProjectionLSH<V> toCopy) {
        this.randProjMatrix = toCopy.randProjMatrix.clone();
        this.projections = Arrays.copyOf(toCopy.projections, toCopy.projections.length);
        this.slotsPerEntry = toCopy.slotsPerEntry;
        this.vecs = new ArrayList<V>(toCopy.vecs);
        this.tempVecs = new ThreadLocal<Vec>(){

            @Override
            protected Vec initialValue() {
                return new DenseVector(RandomProjectionLSH.this.randProjMatrix.rows());
            }
        };
    }

    private void setUpVecs(List<V> vecs) {
        this.vecs = vecs;
        this.tempVecs = new ThreadLocal<Vec>(){

            @Override
            protected Vec initialValue() {
                return new DenseVector(RandomProjectionLSH.this.randProjMatrix.rows());
            }
        };
        this.slotsPerEntry = this.randProjMatrix.rows() / 32;
        this.projections = new int[this.slotsPerEntry * vecs.size()];
        Vec projected = this.tempVecs.get();
        for (int slot = 0; slot < vecs.size(); ++slot) {
            projected.zeroOut();
            this.projectVector((Vec)vecs.get(slot), slot * this.slotsPerEntry, this.projections, projected);
        }
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, double range) {
        ArrayList<VecPaired<Vec, Double>> toRet = new ArrayList<VecPaired<Vec, Double>>();
        int minHammingDist = (int)this.cosineToHamming(CosineDistance.distanceToCosine(range));
        int[] queryProj = new int[this.slotsPerEntry];
        Vec tmpSapce = this.tempVecs.get();
        tmpSapce.zeroOut();
        this.projectVector(query, 0, queryProj, tmpSapce);
        for (int slot = 0; slot < this.vecs.size(); ++slot) {
            int hamming = 0;
            int pos = 0;
            while (pos < this.slotsPerEntry) {
                hamming += Integer.bitCount(this.projections[slot * this.slotsPerEntry + pos] ^ queryProj[pos++]);
            }
            if (hamming > minHammingDist) continue;
            toRet.add(new VecPaired<Vec, Double>((Vec)this.vecs.get(slot), CosineDistance.cosineToDistance(this.hammingToCosine(hamming))));
        }
        return toRet;
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, int neighbors) {
        BoundedSortedList<VecPairedComparable<Vec, Double>> toRet = new BoundedSortedList<VecPairedComparable<Vec, Double>>(neighbors);
        int[] queryProj = new int[this.slotsPerEntry];
        Vec tmpSapce = this.tempVecs.get();
        tmpSapce.zeroOut();
        this.projectVector(query, 0, queryProj, tmpSapce);
        for (int slot = 0; slot < this.vecs.size(); ++slot) {
            int hamming = 0;
            int pos = 0;
            while (pos < this.slotsPerEntry) {
                hamming += Integer.bitCount(this.projections[slot * this.slotsPerEntry + pos] ^ queryProj[pos++]);
            }
            if (toRet.size() >= neighbors && !((double)hamming < (Double)((VecPairedComparable)toRet.last()).getPair())) continue;
            toRet.add(new VecPairedComparable<Vec, Double>((Vec)this.vecs.get(slot), Double.valueOf(hamming)));
        }
        for (int i = 0; i < toRet.size(); ++i) {
            ((VecPairedComparable)toRet.get(i)).setPair(CosineDistance.cosineToDistance(this.hammingToCosine((Double)((VecPairedComparable)toRet.get(i)).getPair())));
        }
        return toRet;
    }

    public int getSignatureBitLength() {
        return this.randProjMatrix.rows() * 32;
    }

    private void projectVector(Vec vec, int slot, int[] projLocation, Vec projected) {
        this.randProjMatrix.multiply(vec, 1.0, projected);
        int bitsLeft = 32;
        int curVal = 0;
        for (int pos = 0; pos < this.slotsPerEntry; ++pos) {
            while (bitsLeft > 0) {
                curVal <<= 1;
                if (projected.get(pos * 32 + (32 - bitsLeft)) >= 0.0) {
                    curVal |= 1;
                }
                --bitsLeft;
            }
            projLocation[slot + pos] = curVal;
            curVal = 0;
            bitsLeft = 32;
        }
    }

    @Override
    public int size() {
        return this.vecs.size();
    }

    @Override
    public VectorCollection<V> clone() {
        return new RandomProjectionLSH<V>(this);
    }

    private double hammingToCosine(double ham) {
        return Math.cos(ham * Math.PI / (double)this.randProjMatrix.rows());
    }

    private double cosineToHamming(double cos) {
        return (double)this.randProjMatrix.rows() * Math.acos(cos) / Math.PI;
    }

    public static class RandomProjectionLSHFactory<V extends Vec>
    implements VectorCollectionFactory<V> {
        private static final long serialVersionUID = 1805047681811290699L;
        private int intsToUse;
        private boolean inMemory;
        private int poolSize = -1;

        public RandomProjectionLSHFactory(int intsToUse, boolean inMemory) {
            this.intsToUse = intsToUse;
            this.inMemory = inMemory;
        }

        public RandomProjectionLSHFactory(int intsToUse, int poolSize) {
            this.intsToUse = intsToUse;
            this.poolSize = poolSize;
        }

        protected RandomProjectionLSHFactory(RandomProjectionLSHFactory<V> toCopy) {
            this.inMemory = toCopy.inMemory;
            this.intsToUse = toCopy.intsToUse;
            this.poolSize = toCopy.poolSize;
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric) {
            if (!(distanceMetric instanceof CosineDistance) && !(distanceMetric instanceof CosineDistanceNormalized)) {
                throw new IllegalArgumentException("RandomProjectionLSH is only compatible with the Cosine Distance metric");
            }
            if (this.poolSize > 0) {
                return new RandomProjectionLSH<V>(source, this.intsToUse, this.poolSize);
            }
            return new RandomProjectionLSH<V>(source, this.intsToUse, this.inMemory);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric, ExecutorService threadpool) {
            return this.getVectorCollection(source, distanceMetric);
        }

        @Override
        public VectorCollectionFactory<V> clone() {
            return new RandomProjectionLSHFactory<V>(this);
        }
    }

    private static final class NormalMatrix
    extends RandomMatrix {
        private static final long serialVersionUID = -5274754647385324984L;
        private final double[] pool;
        private final long seedMult;

        public NormalMatrix(int rows, int cols, int poolSize) {
            super(rows, cols);
            if (poolSize > 0) {
                this.pool = new double[poolSize];
                XOR96 rand = new XOR96();
                for (int i = 0; i < this.pool.length; ++i) {
                    this.pool[i] = rand.nextGaussian();
                }
            } else {
                this.pool = null;
            }
            this.seedMult = new Random().nextLong();
        }

        public NormalMatrix(NormalMatrix toCopy) {
            super(toCopy);
            this.pool = (double[])(toCopy.pool == null ? null : Arrays.copyOf(toCopy.pool, toCopy.pool.length));
            this.seedMult = toCopy.seedMult;
        }

        @Override
        public double get(int i, int j) {
            if (this.pool == null) {
                return super.get(i, j);
            }
            long index = (long)((i + 1) * (j + this.cols())) * this.seedMult & Integer.MAX_VALUE;
            return this.pool[(int)index % this.pool.length];
        }

        @Override
        protected double getVal(Random rand) {
            if (this.pool == null) {
                return rand.nextGaussian();
            }
            return this.pool[rand.nextInt(this.pool.length)];
        }

        @Override
        public Matrix clone() {
            return new NormalMatrix(this);
        }
    }
}

