/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.math.OnLineStatistics;
import jsat.utils.ListUtils;
import jsat.utils.SystemInfo;

public class VectorCollectionUtils {
    public static <V0 extends Vec, V1 extends Vec> List<List<? extends VecPaired<V0, Double>>> allNearestNeighbors(VectorCollection<V0> collection, List<V1> search, int k) {
        ArrayList<List<VecPaired<V0, Double>>> results = new ArrayList<List<VecPaired<V0, Double>>>(search.size());
        for (Vec v : search) {
            results.add(collection.search(v, k));
        }
        return results;
    }

    public static <V0 extends Vec, V1 extends Vec> List<List<? extends VecPaired<V0, Double>>> allNearestNeighbors(VectorCollection<V0> collection, V1[] search, int k) {
        return VectorCollectionUtils.allNearestNeighbors(collection, Arrays.asList(search), k);
    }

    public static <V0 extends Vec, V1 extends Vec> List<List<? extends VecPaired<V0, Double>>> allNearestNeighbors(final VectorCollection<V0> collection, List<V1> search, final int k, ExecutorService threadpool) throws InterruptedException, ExecutionException {
        ArrayList<List<VecPaired<V0, Double>>> results = new ArrayList<List<VecPaired<V0, Double>>>(search.size());
        ArrayList subResults = new ArrayList(SystemInfo.LogicalCores);
        for (final List<V1> subSearch : ListUtils.splitList(search, SystemInfo.LogicalCores)) {
            subResults.add(threadpool.submit(new Callable<List<List<? extends VecPaired<V0, Double>>>>(){

                @Override
                public List<List<? extends VecPaired<V0, Double>>> call() throws Exception {
                    ArrayList subResult = new ArrayList(subSearch.size());
                    for (Vec v : subSearch) {
                        subResult.add(collection.search(v, k));
                    }
                    return subResult;
                }
            }));
        }
        for (List<Object> subResult : ListUtils.collectFutures(subResults)) {
            results.addAll(subResult);
        }
        return results;
    }

    public static <V0 extends Vec, V1 extends Vec> List<List<? extends VecPaired<V0, Double>>> allNearestNeighbors(VectorCollection<V0> collection, V1[] search, int k, ExecutorService threadpool) throws InterruptedException, ExecutionException {
        return VectorCollectionUtils.allNearestNeighbors(collection, Arrays.asList(search), k, threadpool);
    }

    public static <V0 extends Vec, V1 extends Vec> OnLineStatistics getKthNeighborStats(VectorCollection<V0> collection, List<V1> search, int k) {
        OnLineStatistics stats = new OnLineStatistics();
        for (Vec v : search) {
            stats.add(collection.search(v, k).get(k - 1).getPair());
        }
        return stats;
    }

    public static <V0 extends Vec, V1 extends Vec> OnLineStatistics getKthNeighborStats(VectorCollection<V0> collection, V1[] search, int k) {
        return VectorCollectionUtils.getKthNeighborStats(collection, Arrays.asList(search), k);
    }

    public static <V0 extends Vec, V1 extends Vec> OnLineStatistics getKthNeighborStats(final VectorCollection<V0> collection, List<V1> search, final int k, ExecutorService threadpool) throws InterruptedException, ExecutionException {
        ArrayList futureStats = new ArrayList(SystemInfo.LogicalCores);
        for (final List<V1> subSearch : ListUtils.splitList(search, SystemInfo.LogicalCores)) {
            futureStats.add(threadpool.submit(new Callable<OnLineStatistics>(){

                @Override
                public OnLineStatistics call() throws Exception {
                    OnLineStatistics stats = new OnLineStatistics();
                    for (Vec v : subSearch) {
                        stats.add(collection.search(v, k).get(k - 1).getPair());
                    }
                    return stats;
                }
            }));
        }
        OnLineStatistics stats = new OnLineStatistics();
        for (OnLineStatistics subResult : ListUtils.collectFutures(futureStats)) {
            stats = OnLineStatistics.add(stats, subResult);
        }
        return stats;
    }

    public static <V0 extends Vec, V1 extends Vec> OnLineStatistics getKthNeighborStats(VectorCollection<V0> collection, V1[] search, int k, ExecutorService threadpool) throws InterruptedException, ExecutionException {
        return VectorCollectionUtils.getKthNeighborStats(collection, Arrays.asList(search), k, threadpool);
    }
}

