/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.VecPairedComparable;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.FakeExecutor;
import jsat.utils.IntList;
import jsat.utils.ListUtils;
import jsat.utils.ProbailityMatch;

public class RandomBallCoverOneShot<V extends Vec>
implements VectorCollection<V> {
    private static final long serialVersionUID = -2562499883847452797L;
    private DistanceMetric dm;
    private List<List<Integer>> ownedVecs;
    private List<Integer> R;
    private List<V> allVecs;
    private List<Double> distCache;
    private int s;
    double[] repRadius;

    public RandomBallCoverOneShot(List<V> vecs, DistanceMetric dm, int s, ExecutorService execServ) {
        this.dm = dm;
        this.s = s;
        this.allVecs = new ArrayList<V>(vecs);
        this.distCache = execServ instanceof FakeExecutor ? dm.getAccelerationCache(this.allVecs) : dm.getAccelerationCache(vecs, execServ);
        IntList allIndices = new IntList(this.allVecs.size());
        ListUtils.addRange(allIndices, 0, this.allVecs.size(), 1);
        try {
            this.setUp(allIndices, execServ);
        }
        catch (InterruptedException ex) {
            try {
                this.setUp(allIndices, new FakeExecutor());
            }
            catch (InterruptedException ex1) {
                // empty catch block
            }
        }
    }

    public RandomBallCoverOneShot(List<V> vecs, DistanceMetric dm, ExecutorService execServ) {
        this(vecs, dm, (int)Math.sqrt(vecs.size()), execServ);
    }

    public RandomBallCoverOneShot(List<V> vecs, DistanceMetric dm, int s) {
        this(vecs, dm, s, new FakeExecutor());
    }

    public RandomBallCoverOneShot(List<V> vecs, DistanceMetric dm) {
        this(vecs, dm, (int)Math.sqrt(vecs.size()));
    }

    private RandomBallCoverOneShot(RandomBallCoverOneShot<V> other) {
        this.dm = other.dm.clone();
        this.ownedVecs = new ArrayList<List<Integer>>(other.ownedVecs.size());
        for (int i = 0; i < other.ownedVecs.size(); ++i) {
            this.ownedVecs.add(new IntList((Collection<Integer>)other.ownedVecs.get(i)));
        }
        this.R = new IntList(other.R);
        this.repRadius = Arrays.copyOf(other.repRadius, other.repRadius.length);
        this.s = other.s;
        if (other.distCache != null) {
            this.distCache = new DoubleList(other.distCache);
        }
        if (other.allVecs != null) {
            this.allVecs = new ArrayList<V>(other.allVecs);
        }
    }

    private void setUp(List<Integer> allIndices, ExecutorService execServ) throws InterruptedException {
        int repCount = (int)Math.max(1.0, Math.sqrt(allIndices.size()));
        Collections.shuffle(allIndices);
        this.R = allIndices.subList(0, repCount);
        this.repRadius = new double[this.R.size()];
        final List<Integer> allRemainingVecs = allIndices.subList(repCount, allIndices.size());
        this.ownedVecs = new ArrayList<List<Integer>>(repCount);
        for (int i = 0; i < repCount; ++i) {
            this.ownedVecs.add(new IntList(this.s));
        }
        final CountDownLatch latch = new CountDownLatch(this.R.size());
        for (int i = 0; i < this.R.size(); ++i) {
            final int Ri = this.R.get(i);
            final List<Integer> ROwned = this.ownedVecs.get(i);
            execServ.submit(new Runnable(){

                @Override
                public void run() {
                    BoundedSortedList<ProbailityMatch<VecPaired<Vec, Integer>>> nearest = new BoundedSortedList<ProbailityMatch<VecPaired<Vec, Integer>>>(RandomBallCoverOneShot.this.s, RandomBallCoverOneShot.this.s);
                    Iterator i$ = allRemainingVecs.iterator();
                    while (i$.hasNext()) {
                        int n = (Integer)i$.next();
                        nearest.add(new ProbailityMatch<VecPaired<Vec, Integer>>(RandomBallCoverOneShot.this.dm.dist(n, Ri, (List<? extends Vec>)RandomBallCoverOneShot.this.allVecs, (List<Double>)RandomBallCoverOneShot.this.distCache), new VecPaired<Vec, Integer>((Vec)RandomBallCoverOneShot.this.allVecs.get(n), n)));
                    }
                    for (ProbailityMatch probailityMatch : nearest) {
                        ROwned.add(((VecPaired)probailityMatch.getMatch()).getPair());
                    }
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, double range) {
        double tmp;
        ArrayList<VecPairedComparable<Vec, Double>> knn = new ArrayList<VecPairedComparable<Vec, Double>>();
        List<Double> qi = this.dm.getQueryInfo(query);
        double bestDist = Double.POSITIVE_INFINITY;
        int bestRep = 0;
        for (int i = 0; i < this.R.size(); ++i) {
            double d;
            tmp = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
            if (!(d < bestDist)) continue;
            bestRep = i;
            bestDist = tmp;
        }
        if (bestDist <= range) {
            knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(this.R.get(bestRep)), bestDist));
        }
        for (int v : this.ownedVecs.get(bestRep)) {
            double d;
            tmp = this.dm.dist(v, query, qi, this.allVecs, this.distCache);
            if (!(d <= range)) continue;
            knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(v), tmp));
        }
        Collections.sort(knn);
        return knn;
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, int neighbors) {
        BoundedSortedList<VecPairedComparable<Vec, Double>> knn = new BoundedSortedList<VecPairedComparable<Vec, Double>>(neighbors);
        List<Double> qi = this.dm.getQueryInfo(query);
        double bestDist = Double.POSITIVE_INFINITY;
        int bestRep = 0;
        for (int i = 0; i < this.R.size(); ++i) {
            double d;
            double tmp = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
            if (!(d < bestDist)) continue;
            bestRep = i;
            bestDist = tmp;
        }
        knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(this.R.get(bestRep)), bestDist));
        for (int v : this.ownedVecs.get(bestRep)) {
            knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(v), this.dm.dist(v, query, qi, this.allVecs, this.distCache)));
        }
        return knn;
    }

    @Override
    public int size() {
        return this.R.size() * this.s;
    }

    @Override
    public RandomBallCoverOneShot<V> clone() {
        return new RandomBallCoverOneShot<V>(this);
    }

    public static class RandomBallCoverOneShotFactory<V extends Vec>
    implements VectorCollectionFactory<V> {
        private static final long serialVersionUID = 7658115337969827371L;

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric) {
            return new RandomBallCoverOneShot<V>(source, distanceMetric);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric, ExecutorService threadpool) {
            return new RandomBallCoverOneShot<V>(source, distanceMetric, threadpool);
        }

        @Override
        public VectorCollectionFactory<V> clone() {
            return new RandomBallCoverOneShotFactory<V>();
        }
    }
}

