/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.VecPairedComparable;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.utils.BoundedSortedList;
import jsat.utils.DoubleList;
import jsat.utils.FakeExecutor;
import jsat.utils.IntList;
import jsat.utils.ListUtils;
import jsat.utils.SystemInfo;

public class RandomBallCover<V extends Vec>
implements VectorCollection<V> {
    private static final long serialVersionUID = 2437771973228849200L;
    private DistanceMetric dm;
    private List<List<Integer>> ownedVecs;
    private List<DoubleList> ownedRDists;
    private List<Integer> R;
    private int size;
    private List<V> allVecs;
    private List<Double> distCache;
    double[] repRadius;

    public RandomBallCover(List<V> vecs, DistanceMetric dm, ExecutorService execServ) {
        this.dm = dm;
        this.size = vecs.size();
        this.allVecs = new ArrayList<V>(vecs);
        this.distCache = execServ instanceof FakeExecutor ? dm.getAccelerationCache(this.allVecs) : dm.getAccelerationCache(this.allVecs, execServ);
        IntList allIndices = new IntList(vecs.size());
        ListUtils.addRange(allIndices, 0, this.size, 1);
        try {
            this.setUp(allIndices, execServ);
        }
        catch (InterruptedException ex) {
            try {
                this.setUp(allIndices, new FakeExecutor());
            }
            catch (InterruptedException ex1) {
                // empty catch block
            }
        }
    }

    public RandomBallCover(List<V> vecs, DistanceMetric dm) {
        this(vecs, dm, new FakeExecutor());
    }

    private RandomBallCover(RandomBallCover<V> other) {
        this.dm = other.dm.clone();
        this.size = other.size;
        this.allVecs = new ArrayList<V>(other.allVecs);
        this.distCache = new DoubleList(other.distCache);
        this.ownedVecs = new ArrayList<List<Integer>>(other.ownedVecs.size());
        this.ownedRDists = new ArrayList<DoubleList>(other.ownedRDists.size());
        for (int i = 0; i < other.ownedRDists.size(); ++i) {
            this.ownedRDists.add(new DoubleList(other.ownedRDists.get(i)));
            this.ownedVecs.add(new IntList((Collection<Integer>)other.ownedVecs.get(i)));
        }
        this.R = new IntList(other.R);
        this.repRadius = Arrays.copyOf(other.repRadius, other.repRadius.length);
    }

    private void setUp(List<Integer> vecIndices, ExecutorService execServ) throws InterruptedException {
        int repCount = (int)Math.max(1.0, Math.sqrt(vecIndices.size()));
        Collections.shuffle(vecIndices);
        this.R = vecIndices.subList(0, repCount);
        this.repRadius = new double[this.R.size()];
        this.ownedRDists = new ArrayList<DoubleList>(this.repRadius.length);
        vecIndices = vecIndices.subList(repCount, vecIndices.size());
        this.ownedVecs = new ArrayList<List<Integer>>(repCount);
        for (int i = 0; i < repCount; ++i) {
            this.ownedVecs.add(new IntList(repCount));
            this.ownedRDists.add(new DoubleList(repCount));
        }
        final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
        for (final List<Integer> subSet : ListUtils.splitList(vecIndices, SystemInfo.LogicalCores)) {
            execServ.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Iterator i$ = subSet.iterator();
                    while (i$.hasNext()) {
                        int v = (Integer)i$.next();
                        int bestRep = 0;
                        double bestDist = RandomBallCover.this.dm.dist(v, (Integer)RandomBallCover.this.R.get(0), (List<? extends Vec>)RandomBallCover.this.allVecs, (List<Double>)RandomBallCover.this.distCache);
                        for (int potentialRep = 1; potentialRep < RandomBallCover.this.R.size(); ++potentialRep) {
                            double d;
                            double tmp = RandomBallCover.this.dm.dist(v, (Integer)RandomBallCover.this.R.get(potentialRep), (List<? extends Vec>)RandomBallCover.this.allVecs, (List<Double>)RandomBallCover.this.distCache);
                            if (!(d < bestDist)) continue;
                            bestDist = tmp;
                            bestRep = potentialRep;
                        }
                        List list = (List)RandomBallCover.this.ownedVecs.get(bestRep);
                        synchronized (list) {
                            ((List)RandomBallCover.this.ownedVecs.get(bestRep)).add(v);
                            ((DoubleList)RandomBallCover.this.ownedRDists.get(bestRep)).add(bestDist);
                            RandomBallCover.this.repRadius[bestRep] = Math.max(RandomBallCover.this.repRadius[bestRep], bestDist);
                        }
                    }
                    latch.countDown();
                }
            });
        }
        latch.await();
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, double range) {
        int i;
        ArrayList<VecPairedComparable<Vec, Double>> knn = new ArrayList<VecPairedComparable<Vec, Double>>();
        List<Double> qi = this.dm.getQueryInfo(query);
        double[] queryRDists = new double[this.R.size()];
        for (i = 0; i < this.R.size(); ++i) {
            double d;
            queryRDists[i] = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
            if (!(d <= range)) continue;
            knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(this.R.get(i)), queryRDists[i]));
        }
        for (i = 0; i < this.R.size(); ++i) {
            if (queryRDists[i] > range + this.repRadius[i]) continue;
            for (int j = 0; j < this.ownedVecs.get(i).size(); ++j) {
                double d;
                double rDist = this.ownedRDists.get(i).getD(j);
                if (queryRDists[i] > range + rDist) continue;
                Vec v = (Vec)this.allVecs.get(this.ownedVecs.get(i).get(j));
                double dist = this.dm.dist(this.ownedVecs.get(i).get(j), query, qi, this.allVecs, this.distCache);
                if (!(d <= range)) continue;
                knn.add(new VecPairedComparable<Vec, Double>(v, dist));
            }
        }
        Collections.sort(knn);
        return knn;
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, int neighbors) {
        BoundedSortedList<VecPairedComparable<Vec, Double>> knn = new BoundedSortedList<VecPairedComparable<Vec, Double>>(neighbors);
        List<Double> qi = this.dm.getQueryInfo(query);
        double[] queryRDists = new double[this.R.size()];
        int bestRep = 0;
        for (int i = 0; i < this.R.size(); ++i) {
            double d;
            queryRDists[i] = this.dm.dist(this.R.get(i), query, qi, this.allVecs, this.distCache);
            if (!(d < queryRDists[i])) continue;
            bestRep = i;
        }
        knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(this.R.get(bestRep)), queryRDists[bestRep]));
        for (int v : this.ownedVecs.get(bestRep)) {
            knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(v), this.dm.dist(v, query, qi, this.allVecs, this.distCache)));
        }
        for (int i = 0; i < this.R.size(); ++i) {
            if (i == bestRep || queryRDists[i] > (Double)((VecPairedComparable)knn.last()).getPair() + this.repRadius[i] || queryRDists[i] > 3.0 * queryRDists[bestRep]) continue;
            knn.add(new VecPairedComparable<Vec, Double>((Vec)this.allVecs.get(this.R.get(i)), queryRDists[i]));
            for (int j = 0; j < this.ownedVecs.get(i).size(); ++j) {
                double rDist = this.ownedRDists.get(i).getD(j);
                if (queryRDists[i] > (Double)((VecPairedComparable)knn.last()).getPair() + rDist) continue;
                int indx = this.ownedVecs.get(i).get(j);
                Vec v = (Vec)this.allVecs.get(indx);
                knn.add(new VecPairedComparable<Vec, Double>(v, this.dm.dist(indx, query, qi, this.allVecs, this.distCache)));
            }
        }
        return knn;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public RandomBallCover<V> clone() {
        return new RandomBallCover<V>(this);
    }

    public static class RandomBallCoverFactory<V extends Vec>
    implements VectorCollectionFactory<V> {
        private static final long serialVersionUID = 2707446304590604519L;

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric) {
            return new RandomBallCover<V>(source, distanceMetric);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric, ExecutorService threadpool) {
            return new RandomBallCover<V>(source, distanceMetric, threadpool);
        }

        @Override
        public VectorCollectionFactory<V> clone() {
            return new RandomBallCoverFactory<V>();
        }
    }
}

