/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsat.linear.Vec;
import jsat.linear.VecPaired;
import jsat.linear.VecPairedComparable;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;
import jsat.utils.BoundedSortedList;
import jsat.utils.FakeExecutor;
import jsat.utils.ProbailityMatch;
import jsat.utils.SystemInfo;

public class EuclideanCollection<V extends Vec>
implements VectorCollection<V> {
    private static final long serialVersionUID = 3544832051605265927L;
    private List<V> source;
    private double[] dotCache;

    public EuclideanCollection(List<V> source) {
        this(source, new FakeExecutor());
    }

    public EuclideanCollection(EuclideanCollection toCopy) {
        this.source = new ArrayList<V>(toCopy.source);
        this.dotCache = Arrays.copyOf(toCopy.dotCache, toCopy.dotCache.length);
    }

    public EuclideanCollection(final List<V> source, ExecutorService threadpool) {
        this.source = source;
        this.dotCache = new double[source.size()];
        final CountDownLatch latch = new CountDownLatch(SystemInfo.LogicalCores);
        int start = 0;
        for (int id = 0; id < SystemInfo.LogicalCores; ++id) {
            int E;
            final int S = start;
            start = E = id == SystemInfo.LogicalCores - 1 ? this.dotCache.length : start + this.dotCache.length / SystemInfo.LogicalCores;
            threadpool.submit(new Runnable(){

                @Override
                public void run() {
                    for (int i = S; i < E; ++i) {
                        Vec c = (Vec)source.get(i);
                        ((EuclideanCollection)EuclideanCollection.this).dotCache[i] = c.dot(c);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Logger.getLogger(EuclideanCollection.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, double range) {
        ArrayList<VecPairedComparable<Vec, Double>> list = new ArrayList<VecPairedComparable<Vec, Double>>();
        double xx = query.dot(query);
        double cmpRange = range * range - xx;
        for (int i = 0; i < this.dotCache.length; ++i) {
            double v = this.dotCache[i] - 2.0 * query.dot((Vec)this.source.get(i));
            if (!(v <= cmpRange)) continue;
            list.add(new VecPairedComparable<Vec, Double>((Vec)this.source.get(i), Math.sqrt(xx + v)));
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public List<? extends VecPaired<V, Double>> search(Vec query, int neighbors) {
        BoundedSortedList<ProbailityMatch<V>> boundedList = new BoundedSortedList<ProbailityMatch<V>>(neighbors, neighbors);
        for (int i = 0; i < this.dotCache.length; ++i) {
            double v = this.dotCache[i] - 2.0 * query.dot((Vec)this.source.get(i));
            if (boundedList.size() >= neighbors && !(v < ((ProbailityMatch)boundedList.get(neighbors - 1)).getProbability())) continue;
            boundedList.add(new ProbailityMatch<V>(v, this.source.get(i)));
        }
        double xx = query.dot(query);
        ArrayList<VecPaired<Vec, Double>> list = new ArrayList<VecPaired<Vec, Double>>(boundedList.size());
        for (ProbailityMatch probailityMatch : boundedList) {
            list.add(new VecPaired<Vec, Double>((Vec)probailityMatch.getMatch(), Math.sqrt(xx + probailityMatch.getProbability())));
        }
        return list;
    }

    @Override
    public int size() {
        return this.dotCache.length;
    }

    @Override
    public EuclideanCollection<V> clone() {
        return new EuclideanCollection<V>(this);
    }

    public static class EuclideanCollectionFactory<V extends Vec>
    implements VectorCollectionFactory<V> {
        private static final long serialVersionUID = 4838578403165658320L;

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric) {
            if (!(distanceMetric instanceof EuclideanDistance)) {
                throw new IllegalArgumentException("EuclideanCollection only supports Euclidean Distanse");
            }
            return new EuclideanCollection<V>(source);
        }

        @Override
        public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric, ExecutorService threadpool) {
            if (!(distanceMetric instanceof EuclideanDistance)) {
                throw new IllegalArgumentException("EuclideanCollection only supports Euclidean Distanse");
            }
            return new EuclideanCollection<V>(source, threadpool);
        }

        @Override
        public EuclideanCollectionFactory<V> clone() {
            return new EuclideanCollectionFactory<V>();
        }
    }
}

