/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear.vectorcollection;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import jsat.linear.Vec;
import jsat.linear.distancemetrics.ChebyshevDistance;
import jsat.linear.distancemetrics.DistanceMetric;
import jsat.linear.distancemetrics.EuclideanDistance;
import jsat.linear.distancemetrics.ManhattanDistance;
import jsat.linear.distancemetrics.MinkowskiDistance;
import jsat.linear.vectorcollection.KDTree;
import jsat.linear.vectorcollection.VPTree;
import jsat.linear.vectorcollection.VectorArray;
import jsat.linear.vectorcollection.VectorCollection;
import jsat.linear.vectorcollection.VectorCollectionFactory;

public class DefaultVectorCollectionFactory<V extends Vec>
implements VectorCollectionFactory<V> {
    private static final long serialVersionUID = -7442543159507721642L;
    private static final int VEC_ARRAY_CUT_OFF = 20;
    private static final int KD_TREE_CUT_OFF = 14;
    private static final int KD_TREE_PIVOT = 5;
    private static final int BRUTE_FORCE_DIM = 1000;

    @Override
    public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric) {
        if (source.size() < 20) {
            return new VectorArray<V>(distanceMetric, source);
        }
        int dimension = ((Vec)source.get(0)).length();
        if (dimension >= 1000) {
            return new VectorArray<V>(distanceMetric, source);
        }
        if (dimension < 14 && (distanceMetric instanceof EuclideanDistance || distanceMetric instanceof ChebyshevDistance || distanceMetric instanceof ManhattanDistance || distanceMetric instanceof MinkowskiDistance)) {
            KDTree.PivotSelection pivotSelect = dimension <= 5 ? KDTree.PivotSelection.Variance : KDTree.PivotSelection.Incremental;
            KDTree<V> kd = new KDTree<V>(source, distanceMetric, pivotSelect);
            return kd;
        }
        return new VPTree<V>(source, distanceMetric, VPTree.VPSelection.Random, new Random(), 50, 50);
    }

    @Override
    public VectorCollection<V> getVectorCollection(List<V> source, DistanceMetric distanceMetric, ExecutorService threadpool) {
        if (source.size() < 20) {
            return new VectorArray<V>(distanceMetric, source);
        }
        int dimension = ((Vec)source.get(0)).length();
        if (dimension >= 1000) {
            return new VectorArray<V>(distanceMetric, source);
        }
        if (dimension < 14 && (distanceMetric instanceof EuclideanDistance || distanceMetric instanceof ChebyshevDistance || distanceMetric instanceof ManhattanDistance || distanceMetric instanceof MinkowskiDistance)) {
            KDTree.PivotSelection pivotSelect = dimension <= 5 ? KDTree.PivotSelection.Variance : KDTree.PivotSelection.Incremental;
            KDTree<V> kd = new KDTree<V>(source, distanceMetric, pivotSelect, threadpool);
            return kd;
        }
        return new VPTree<V>(source, distanceMetric, VPTree.VPSelection.Random, new Random(), 50, 50, threadpool);
    }

    @Override
    public VectorCollectionFactory<V> clone() {
        return new DefaultVectorCollectionFactory<V>();
    }
}

