/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Iterator;
import jsat.linear.IndexValue;
import jsat.linear.Vec;

public class VecWithNorm
extends Vec {
    private static final long serialVersionUID = 3888178071694466561L;
    private final Vec base;
    private double normSqrd;

    public VecWithNorm(Vec base, double norm) {
        this.base = base;
        this.normSqrd = norm * norm;
    }

    public VecWithNorm(Vec base) {
        this(base, base.pNorm(2.0));
    }

    public Vec getBase() {
        return this.base;
    }

    @Override
    public double pNorm(double p) {
        if (p == 2.0) {
            return Math.sqrt(this.normSqrd);
        }
        return this.base.pNorm(p);
    }

    @Override
    public int length() {
        return this.base.length();
    }

    @Override
    public double get(int index) {
        return this.base.get(index);
    }

    @Override
    public void set(int index, double val) {
        double old = this.base.get(index);
        this.normSqrd += -(old * old) + val * val;
        this.base.set(index, val);
    }

    @Override
    public boolean isSparse() {
        return this.base.isSparse();
    }

    @Override
    public VecWithNorm clone() {
        return new VecWithNorm(this.base.clone(), Math.sqrt(this.normSqrd));
    }

    @Override
    public void mutableAdd(double c) {
        for (int i = 0; i < this.base.length(); ++i) {
            double old = this.base.get(i);
            double toAdd = c;
            this.normSqrd += toAdd * (toAdd + 2.0 * old);
        }
        this.base.mutableAdd(c);
    }

    @Override
    public void mutableAdd(double c, Vec b) {
        for (IndexValue iv : b) {
            double old = this.base.get(iv.getIndex());
            double toAdd = c * iv.getValue();
            this.normSqrd += toAdd * (toAdd + 2.0 * old);
        }
        this.base.mutableAdd(c, b);
    }

    @Override
    public void mutablePairwiseMultiply(Vec b) {
        this.base.mutablePairwiseMultiply(b);
        this.normSqrd = Math.pow(this.base.pNorm(2.0), 2.0);
    }

    @Override
    public void mutableMultiply(double c) {
        this.normSqrd *= c * c;
        this.base.mutableMultiply(c);
    }

    @Override
    public void mutablePairwiseDivide(Vec b) {
        this.base.mutablePairwiseDivide(b);
        this.normSqrd = Math.pow(this.base.pNorm(2.0), 2.0);
    }

    @Override
    public void mutableDivide(double c) {
        this.normSqrd /= c * c;
    }

    @Override
    public void zeroOut() {
        this.normSqrd = 0.0;
        this.base.zeroOut();
    }

    @Override
    public int nnz() {
        return this.base.nnz();
    }

    @Override
    public Iterator<IndexValue> getNonZeroIterator() {
        return this.base.getNonZeroIterator();
    }

    @Override
    public Iterator<IndexValue> getNonZeroIterator(int start) {
        return this.base.getNonZeroIterator(start);
    }
}

