/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import jsat.linear.DenseVector;
import jsat.linear.IndexValue;
import jsat.linear.Matrix;
import jsat.linear.SparseVector;
import jsat.math.Function;
import jsat.math.IndexFunction;

public abstract class Vec
implements Cloneable,
Iterable<IndexValue>,
Serializable {
    private static final long serialVersionUID = 9035784536820782955L;

    public abstract int length();

    public boolean canBeMutated() {
        return true;
    }

    private Vec getThisSide(Vec other) {
        if (this.canBeMutated()) {
            return this.clone();
        }
        if (other == null) {
            if (this.isSparse()) {
                return new SparseVector(this);
            }
            return new DenseVector(this);
        }
        if (this.isSparse() && other.isSparse()) {
            return new SparseVector(this);
        }
        return new DenseVector(this);
    }

    public int nnz() {
        int nnz = 0;
        for (IndexValue i : this) {
            ++nnz;
        }
        return nnz;
    }

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    public void increment(int index, double val) {
        this.set(index, val + this.get(index));
    }

    public Vec add(double c) {
        Vec toRet = this.getThisSide(null);
        toRet.mutableAdd(c);
        return toRet;
    }

    public Vec add(Vec b) {
        Vec toRet = this.getThisSide(b);
        toRet.mutableAdd(b);
        return toRet;
    }

    public Vec subtract(double c) {
        return this.add(-c);
    }

    public Vec subtract(Vec b) {
        Vec toRet = this.getThisSide(b);
        toRet.mutableSubtract(b);
        return toRet;
    }

    public Vec pairwiseMultiply(Vec b) {
        Vec toRet = this.getThisSide(b);
        toRet.mutablePairwiseMultiply(b);
        return toRet;
    }

    public Vec multiply(double c) {
        Vec toRet = this.getThisSide(null);
        toRet.mutableMultiply(c);
        return toRet;
    }

    public Vec multiply(Matrix A) {
        DenseVector b = new DenseVector(A.cols());
        this.multiply(A, b);
        return b;
    }

    public void multiply(Matrix A, Vec b) {
        this.multiply(1.0, A, b);
    }

    public void multiply(double c, Matrix A, Vec b) {
        if (this.length() != A.rows()) {
            throw new ArithmeticException("Vector x Matrix dimensions do not agree [1," + this.length() + "] x [" + A.rows() + ", " + A.cols() + "]");
        }
        if (b.length() != A.cols()) {
            throw new ArithmeticException("Destination vector is not the right size");
        }
        if (!this.isSparse()) {
            for (int i = 0; i < this.length(); ++i) {
                double this_i = c * this.get(i);
                for (int j = 0; j < A.cols(); ++j) {
                    b.increment(j, this_i * A.get(i, j));
                }
            }
        } else {
            for (IndexValue iv : this) {
                int i = iv.getIndex();
                double this_i = c * iv.getValue();
                for (int j = 0; j < A.cols(); ++j) {
                    b.increment(j, this_i * A.get(i, j));
                }
            }
        }
    }

    public Vec pairwiseDivide(Vec b) {
        Vec toRet = this.getThisSide(b);
        toRet.mutablePairwiseDivide(b);
        return toRet;
    }

    public Vec divide(double c) {
        Vec toRet = this.getThisSide(null);
        toRet.mutableDivide(c);
        return toRet;
    }

    public void mutableAdd(double c) {
        for (int i = 0; i < this.length(); ++i) {
            this.increment(i, c);
        }
    }

    public void mutableAdd(double c, Vec b) {
        if (this.length() != b.length()) {
            throw new ArithmeticException("Vectors must have the same length, not " + this.length() + " and " + b.length());
        }
        if (b.isSparse()) {
            for (IndexValue iv : b) {
                this.increment(iv.getIndex(), c * iv.getValue());
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                this.increment(i, c * b.get(i));
            }
        }
    }

    public void mutableAdd(Vec b) {
        this.mutableAdd(1.0, b);
    }

    public void mutableSubtract(double c) {
        this.mutableAdd(-c);
    }

    public void mutableSubtract(double c, Vec b) {
        this.mutableAdd(-c, b);
    }

    public void mutableSubtract(Vec b) {
        this.mutableAdd(-1.0, b);
    }

    public void mutablePairwiseMultiply(Vec b) {
        if (this.length() != b.length()) {
            throw new ArithmeticException("Vector lengths do not agree " + this.length() + " vs " + b.length());
        }
        for (int i = 0; i < this.length(); ++i) {
            this.set(i, this.get(i) * b.get(i));
        }
    }

    public void mutableMultiply(double c) {
        for (int i = 0; i < this.length(); ++i) {
            this.set(i, this.get(i) * c);
        }
    }

    public void mutablePairwiseDivide(Vec b) {
        if (this.length() != b.length()) {
            throw new ArithmeticException("Vector lengths do not agree " + this.length() + " vs " + b.length());
        }
        for (int i = 0; i < this.length(); ++i) {
            this.set(i, this.get(i) / b.get(i));
        }
    }

    public void mutableDivide(double c) {
        for (int i = 0; i < this.length(); ++i) {
            this.set(i, this.get(i) / c);
        }
    }

    public Vec sortedCopy() {
        double[] arrayCopy = this.arrayCopy();
        Arrays.sort(arrayCopy);
        return new DenseVector(arrayCopy);
    }

    public double min() {
        if (this.isSparse() && this.nnz() < this.length()) {
            double min = 0.0;
            for (IndexValue iv : this) {
                min = Math.min(min, iv.getValue());
            }
            return min;
        }
        double min = this.get(0);
        for (int i = 1; i < this.length(); ++i) {
            min = Math.min(min, this.get(i));
        }
        return min;
    }

    public double max() {
        if (this.isSparse() && this.nnz() < this.length()) {
            double max = 0.0;
            for (IndexValue iv : this) {
                max = Math.max(max, iv.getValue());
            }
            return max;
        }
        double max = this.get(0);
        for (int i = 1; i < this.length(); ++i) {
            max = Math.max(max, this.get(i));
        }
        return max;
    }

    public double sum() {
        double sum = 0.0;
        double c = 0.0;
        for (IndexValue iv : this) {
            double d = iv.getValue();
            double y = d - c;
            double t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        return sum;
    }

    public double mean() {
        return this.sum() / (double)this.length();
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public double variance() {
        double mu = this.mean();
        double variance = 0.0;
        double N = this.length();
        int used = 0;
        for (IndexValue x : this) {
            ++used;
            variance += Math.pow(x.getValue() - mu, 2.0) / N;
        }
        return variance += (double)(this.length() - used) * Math.pow(0.0 - mu, 2.0) / N;
    }

    public double median() {
        Vec copy = this.sortedCopy();
        if (copy.length() % 2 != 0) {
            return copy.get(copy.length() / 2);
        }
        return copy.get(copy.length() / 2) / 2.0 + copy.get(copy.length() / 2 + 1) / 2.0;
    }

    public double skewness() {
        double mean = this.mean();
        double tmp = 0.0;
        int length = this.length();
        int used = 0;
        for (IndexValue iv : this) {
            tmp += Math.pow(iv.getValue() - mean, 3.0);
            ++used;
        }
        double s1 = (tmp += Math.pow(-mean, 3.0) * (double)(length - used)) / (Math.pow(this.standardDeviation(), 3.0) * (double)(length - 1));
        if (length >= 3) {
            return Math.sqrt(length * (length - 1)) / (double)(length - 2) * s1;
        }
        return s1;
    }

    public double kurtosis() {
        double mean = this.mean();
        double tmp = 0.0;
        int length = this.length();
        int used = 0;
        for (IndexValue iv : this) {
            tmp += Math.pow(iv.getValue() - mean, 4.0);
            ++used;
        }
        return (tmp += Math.pow(-mean, 4.0) * (double)(length - used)) / (Math.pow(this.standardDeviation(), 4.0) * (double)(length - 1)) - 3.0;
    }

    public abstract boolean isSparse();

    public void copyTo(Vec destination) {
        if (this.length() != destination.length()) {
            throw new ArithmeticException("Source and destination must be the same size");
        }
        if (this.isSparse()) {
            destination.zeroOut();
            for (IndexValue iv : this) {
                destination.set(iv.getIndex(), iv.getValue());
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                destination.set(i, this.get(i));
            }
        }
    }

    public void copyToRow(Matrix A, int row) {
        if (this.length() != A.cols()) {
            throw new ArithmeticException("Destination matrix does not have the same number of columns as this has rows");
        }
        for (int i = 0; i < this.length(); ++i) {
            A.set(row, i, this.get(i));
        }
    }

    public void copyToCol(Matrix A, int col) {
        if (this.length() != A.rows()) {
            throw new ArithmeticException("Destination matrix does not have the same number of rows as this has rows");
        }
        for (int i = 0; i < this.length(); ++i) {
            A.set(i, col, this.get(i));
        }
    }

    public abstract Vec clone();

    public Vec normalized() {
        Vec toRet = this.getThisSide(null);
        toRet.normalize();
        return toRet;
    }

    public void normalize() {
        this.mutableDivide(Math.max(this.pNorm(2.0), 1.0E-10));
    }

    public void applyFunction(Function f) {
        for (int i = 0; i < this.length(); ++i) {
            this.set(i, f.f(this.get(i)));
        }
    }

    public void applyIndexFunction(IndexFunction f) {
        for (int i = 0; i < this.length(); ++i) {
            this.set(i, f.indexFunc(this.get(i), i));
        }
    }

    public double pNormDist(double p, Vec y) {
        Iterator<IndexValue> thisIter = this.iterator();
        Iterator<IndexValue> otherIter = y.iterator();
        if (!thisIter.hasNext()) {
            if (!otherIter.hasNext()) {
                return 0.0;
            }
            return y.pNorm(p);
        }
        if (!otherIter.hasNext()) {
            return this.pNorm(p);
        }
        double result = 0.0;
        IndexValue av = thisIter.next();
        IndexValue bv = otherIter.next();
        do {
            boolean nextA = false;
            boolean nextB = false;
            if (av.getIndex() == bv.getIndex()) {
                result += Math.pow(Math.abs(av.getValue() - bv.getValue()), p);
                nextB = true;
                nextA = true;
            } else if (av.getIndex() < bv.getIndex()) {
                result += Math.pow(Math.abs(av.getValue()), p);
                nextA = true;
            } else if (av.getIndex() > bv.getIndex()) {
                result += Math.pow(Math.abs(bv.getValue()), p);
                nextB = true;
            }
            if (nextA) {
                IndexValue indexValue = av = thisIter.hasNext() ? thisIter.next() : null;
            }
            if (!nextB) continue;
            IndexValue indexValue = bv = otherIter.hasNext() ? otherIter.next() : null;
        } while (av != null && bv != null);
        while (av != null) {
            result += Math.pow(Math.abs(av.getValue()), p);
            av = thisIter.hasNext() ? thisIter.next() : null;
        }
        while (bv != null) {
            result += Math.pow(Math.abs(bv.getValue()), p);
            bv = otherIter.hasNext() ? otherIter.next() : null;
        }
        return Math.pow(result, 1.0 / p);
    }

    public double pNorm(double p) {
        if (p <= 0.0) {
            throw new IllegalArgumentException("norm must be a positive value, not " + p);
        }
        double result = 0.0;
        if (p == 1.0) {
            for (IndexValue iv : this) {
                result += Math.abs(iv.getValue());
            }
        } else if (p == 2.0) {
            for (IndexValue iv : this) {
                result += iv.getValue() * iv.getValue();
            }
            result = Math.sqrt(result);
        } else if (Double.isInfinite(p)) {
            for (IndexValue iv : this) {
                result = Math.max(result, Math.abs(iv.getValue()));
            }
        } else {
            for (IndexValue iv : this) {
                result += Math.pow(Math.abs(iv.getValue()), p);
            }
            result = Math.pow(result, 1.0 / p);
        }
        return result;
    }

    public double dot(Vec v) {
        double dot = 0.0;
        if (!this.isSparse() && v.isSparse()) {
            for (IndexValue iv : v) {
                dot += this.get(iv.getIndex()) * iv.getValue();
            }
        } else if (this.isSparse() && !v.isSparse()) {
            for (IndexValue iv : this) {
                dot += iv.getValue() * v.get(iv.getIndex());
            }
        } else if (this.isSparse() && v.isSparse()) {
            Iterator<IndexValue> aIter = this.getNonZeroIterator();
            Iterator<IndexValue> bIter = v.getNonZeroIterator();
            if (this.nnz() == 0 || v.nnz() == 0) {
                return 0.0;
            }
            IndexValue aCur = aIter.next();
            IndexValue bCur = bIter.next();
            while (aCur != null && bCur != null) {
                if (aCur.getIndex() == bCur.getIndex()) {
                    dot += aCur.getValue() * bCur.getValue();
                    aCur = aIter.hasNext() ? aIter.next() : null;
                    if (bIter.hasNext()) {
                        bCur = bIter.next();
                        continue;
                    }
                    bCur = null;
                    continue;
                }
                if (aCur.getIndex() < bCur.getIndex()) {
                    if (aIter.hasNext()) {
                        aCur = aIter.next();
                        continue;
                    }
                    aCur = null;
                    continue;
                }
                if (bIter.hasNext()) {
                    bCur = bIter.next();
                    continue;
                }
                bCur = null;
            }
        } else {
            for (int i = 0; i < this.length(); ++i) {
                dot += this.get(i) * v.get(i);
            }
        }
        return dot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        sb.append(this.get(0));
        for (int i = 1; i < this.length(); ++i) {
            sb.append(",").append(this.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return this.equals(obj, 0.0);
    }

    public boolean equals(Object obj, double range) {
        if (!(obj instanceof Vec)) {
            return false;
        }
        Vec other = (Vec)obj;
        range = Math.abs(range);
        Iterator<IndexValue> thisIter = this.iterator();
        Iterator<IndexValue> otherIter = other.iterator();
        if (!thisIter.hasNext()) {
            return !otherIter.hasNext();
        }
        if (!otherIter.hasNext()) {
            return false;
        }
        IndexValue av = thisIter.next();
        IndexValue bv = otherIter.next();
        do {
            boolean nextA = false;
            boolean nextB = false;
            if (av.getIndex() == bv.getIndex()) {
                if (Math.abs(av.getValue() - bv.getValue()) > range) {
                    return false;
                }
                nextB = true;
                nextA = true;
            } else if (av.getIndex() < bv.getIndex()) {
                if (Math.abs(av.getValue()) > range) {
                    return false;
                }
                nextA = true;
            } else if (av.getIndex() > bv.getIndex()) {
                if (Math.abs(bv.getValue()) > range) {
                    return false;
                }
                nextB = true;
            }
            if (nextA) {
                IndexValue indexValue = av = thisIter.hasNext() ? thisIter.next() : null;
            }
            if (!nextB) continue;
            IndexValue indexValue = bv = otherIter.hasNext() ? otherIter.next() : null;
        } while (av != null && bv != null);
        while (av != null) {
            if (Math.abs(av.getValue()) > range) {
                return false;
            }
            av = thisIter.hasNext() ? thisIter.next() : null;
        }
        while (bv != null) {
            if (Math.abs(bv.getValue()) > range) {
                return false;
            }
            bv = otherIter.hasNext() ? otherIter.next() : null;
        }
        return true;
    }

    public double[] arrayCopy() {
        double[] array = new double[this.length()];
        for (IndexValue iv : this) {
            array[iv.getIndex()] = iv.getValue();
        }
        return array;
    }

    @Override
    public Iterator<IndexValue> iterator() {
        return this.getNonZeroIterator(0);
    }

    public Iterator<IndexValue> getNonZeroIterator() {
        return this.getNonZeroIterator(0);
    }

    public Iterator<IndexValue> getNonZeroIterator(int start) {
        int i;
        final Vec magic = this;
        for (i = start; i < magic.length() && magic.get(i) == 0.0; ++i) {
        }
        final int fnz = magic.length() == 0 || magic.length() <= i || magic.get(i) == 0.0 ? -1 : i;
        Iterator<IndexValue> itor = new Iterator<IndexValue>(){
            int curIndex = 0;
            int nextNonZero = fnz;
            IndexValue indexValue = new IndexValue(-1, Double.NaN);

            @Override
            public boolean hasNext() {
                return this.nextNonZero >= 0;
            }

            @Override
            public IndexValue next() {
                if (this.nextNonZero == -1) {
                    return null;
                }
                this.indexValue.setIndex(this.nextNonZero);
                this.indexValue.setValue(Vec.this.get(this.nextNonZero));
                this.nextNonZero = -1;
                for (int i = this.nextNonZero + 1; i < magic.length(); ++i) {
                    if (Vec.this.get(i) == 0.0) continue;
                    this.nextNonZero = i;
                    break;
                }
                return this.indexValue;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        return itor;
    }

    public void zeroOut() {
        for (int i = 0; i < this.length(); ++i) {
            this.set(i, 0.0);
        }
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.length(); ++i) {
            double val = this.get(i);
            if (val == 0.0) continue;
            long bits = Double.doubleToLongBits(val);
            result = 31 * result + (int)(bits ^ bits >>> 32);
            result = 31 * result + i;
        }
        return 31 * result + this.length();
    }

    public static Vec random(int length) {
        return Vec.random(length, new Random());
    }

    public static Vec random(int length, Random rand) {
        DenseVector v = new DenseVector(length);
        for (int i = 0; i < length; ++i) {
            ((Vec)v).set(i, rand.nextDouble());
        }
        return v;
    }

    public static Vec zeros(int length) {
        return new DenseVector(length);
    }
}

