/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Iterator;
import jsat.linear.IndexValue;
import jsat.linear.Vec;

public class ShiftedVec
extends Vec {
    private static final long serialVersionUID = -8318033099234181766L;
    private Vec base;
    private double shift;

    public ShiftedVec(Vec base, double shift) {
        this.base = base;
        this.shift = shift;
    }

    public Vec getBase() {
        return this.base;
    }

    public void setShift(double shift) {
        this.shift = shift;
    }

    public double getShift() {
        return this.shift;
    }

    public void embedShift() {
        this.base.mutableAdd(this.shift);
        this.shift = 0.0;
    }

    @Override
    public int length() {
        return this.base.length();
    }

    @Override
    public double get(int index) {
        return this.base.get(index) + this.shift;
    }

    @Override
    public void set(int index, double val) {
        this.base.set(index, val - this.shift);
    }

    @Override
    public void increment(int index, double val) {
        this.base.increment(index, val);
    }

    @Override
    public void mutableAdd(Vec b) {
        if (b instanceof ShiftedVec) {
            ShiftedVec other = (ShiftedVec)b;
            this.base.mutableAdd(other.base);
            this.shift += other.shift;
        } else {
            this.base.mutableAdd(b);
        }
    }

    @Override
    public void mutableAdd(double c) {
        this.shift += c;
    }

    @Override
    public void mutableAdd(double c, Vec b) {
        if (b instanceof ShiftedVec) {
            ShiftedVec other = (ShiftedVec)b;
            this.base.mutableAdd(c, other.base);
            this.shift += other.shift * c;
        } else {
            this.base.mutableAdd(c, b);
        }
    }

    @Override
    public void mutableDivide(double c) {
        this.base.mutableDivide(c);
        this.shift /= c;
        if (Double.isNaN(this.shift)) {
            this.shift = 0.0;
        }
    }

    @Override
    public void mutableMultiply(double c) {
        this.base.mutableMultiply(c);
        this.shift *= c;
    }

    @Override
    public void mutablePairwiseDivide(Vec b) {
        this.base.mutableAdd(this.shift);
        this.shift = 0.0;
        this.base.mutablePairwiseDivide(b);
    }

    @Override
    public void mutablePairwiseMultiply(Vec b) {
        this.base.mutableAdd(this.shift);
        this.shift = 0.0;
        this.base.mutablePairwiseMultiply(b);
    }

    @Override
    public double dot(Vec v) {
        if (v instanceof ShiftedVec) {
            ShiftedVec other = (ShiftedVec)v;
            return this.base.dot(other.base) + other.base.sum() * this.shift + this.base.sum() * other.shift + (double)this.length() * this.shift * other.shift;
        }
        return this.base.dot(v) + v.sum() * this.shift;
    }

    @Override
    public void zeroOut() {
        this.base.zeroOut();
        this.shift = 0.0;
    }

    @Override
    public double pNorm(double p) {
        if (!this.isSparse()) {
            return super.pNorm(p);
        }
        double baseZeroContribs = Math.pow(Math.abs(this.shift), p) * (double)(this.length() - this.base.nnz());
        double baseNonZeroContribs = 0.0;
        for (IndexValue iv : this.base) {
            baseNonZeroContribs += Math.pow(Math.abs(iv.getValue() + this.shift), p);
        }
        return Math.pow(baseNonZeroContribs + baseZeroContribs, 1.0 / p);
    }

    @Override
    public double mean() {
        return this.base.mean() + this.shift;
    }

    @Override
    public double variance() {
        return this.base.variance();
    }

    @Override
    public double standardDeviation() {
        return this.base.standardDeviation();
    }

    @Override
    public double kurtosis() {
        return this.base.kurtosis();
    }

    @Override
    public double max() {
        return this.base.max() + this.shift;
    }

    @Override
    public double min() {
        return this.base.min() + this.shift;
    }

    @Override
    public double median() {
        return this.base.median() + this.shift;
    }

    @Override
    public Iterator<IndexValue> getNonZeroIterator(final int start) {
        if (!this.isSparse()) {
            return super.getNonZeroIterator(start);
        }
        final Iterator<IndexValue> baseIter = this.base.getNonZeroIterator(start);
        if (this.shift == 0.0) {
            return baseIter;
        }
        final int lastIndx = this.length() - 1;
        return new Iterator<IndexValue>(){
            IndexValue nextBaseVal;
            IndexValue nextVal;
            IndexValue toRet = null;
            {
                for (int effectiveStart = start; effectiveStart <= lastIndx; ++effectiveStart) {
                    IndexValue indexValue = this.nextBaseVal = baseIter.hasNext() ? (IndexValue)baseIter.next() : null;
                    if (this.nextBaseVal != null && this.nextBaseVal.getIndex() == effectiveStart) {
                        if (this.nextBaseVal.getValue() + ShiftedVec.this.shift == 0.0) continue;
                        this.nextVal = new IndexValue(effectiveStart, this.nextBaseVal.getValue() + ShiftedVec.this.shift);
                        this.nextBaseVal = baseIter.hasNext() ? (IndexValue)baseIter.next() : null;
                    } else {
                        this.nextVal = new IndexValue(effectiveStart, ShiftedVec.this.shift);
                    }
                    this.toRet = new IndexValue(effectiveStart, ShiftedVec.this.shift);
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextVal != null;
            }

            @Override
            public IndexValue next() {
                this.toRet.setIndex(this.nextVal.getIndex());
                this.toRet.setValue(this.nextVal.getValue());
                do {
                    this.nextVal.setIndex(this.nextVal.getIndex() + 1);
                    if (this.nextVal.getIndex() == lastIndx + 1) {
                        this.nextVal = null;
                        continue;
                    }
                    if (this.nextBaseVal != null && this.nextBaseVal.getIndex() == this.nextVal.getIndex()) {
                        this.nextVal.setValue(this.nextBaseVal.getValue() + ShiftedVec.this.shift);
                        this.nextBaseVal = baseIter.hasNext() ? (IndexValue)baseIter.next() : null;
                        continue;
                    }
                    this.nextVal.setValue(ShiftedVec.this.shift);
                } while (this.nextVal != null && this.nextVal.getValue() == 0.0);
                return this.toRet;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    @Override
    public boolean isSparse() {
        return this.base.isSparse();
    }

    @Override
    public ShiftedVec clone() {
        return new ShiftedVec(this.base.clone(), this.shift);
    }
}

