/*
 * Decompiled with CFR 0.152.
 */
package jsat.linear;

import java.util.Random;
import jsat.linear.DenseMatrix;
import jsat.linear.GenericMatrix;
import jsat.linear.Matrix;

public abstract class RandomMatrix
extends GenericMatrix {
    private static final long serialVersionUID = 3514801206898749257L;
    private int rows;
    private int cols;
    private long seedMult;
    private ThreadLocal<Random> localRand = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random(1L);
        }
    };

    public RandomMatrix(int rows, int cols) {
        this(rows, cols, new Random().nextLong());
    }

    public RandomMatrix(int rows, int cols, long seedMult) {
        if (rows <= 0) {
            throw new IllegalArgumentException("rows must be positive, not " + rows);
        }
        if (cols <= 0) {
            throw new IllegalArgumentException("cols must be positive, not " + cols);
        }
        this.rows = rows;
        this.cols = cols;
        this.seedMult = seedMult;
    }

    public RandomMatrix(RandomMatrix toCopy) {
        this(toCopy.rows, toCopy.cols, toCopy.seedMult);
    }

    @Override
    protected Matrix getMatrixOfSameType(int rows, int cols) {
        return new DenseMatrix(rows, cols);
    }

    protected abstract double getVal(Random var1);

    @Override
    public double get(int i, int j) {
        long seed = (long)((i + 1) * (j + this.cols)) * this.seedMult;
        Random rand = this.localRand.get();
        rand.setSeed(seed);
        return this.getVal(rand);
    }

    @Override
    public void set(int i, int j, double value) {
        throw new UnsupportedOperationException("Random Matrix can not be altered");
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public boolean isSparce() {
        return false;
    }

    @Override
    public boolean canBeMutated() {
        return false;
    }

    @Override
    public void changeSize(int newRows, int newCols) {
        throw new UnsupportedOperationException("Random Matrix can not be altered");
    }
}

